/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp417_ = FALSE;
	ValaMethod* _tmp418_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp586_;
	ValaCCodeExpression* _tmp587_;
	gboolean _tmp588_ = FALSE;
	ValaMethod* _tmp589_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp617_ = FALSE;
	ValaMethod* _tmp618_;
	gboolean _tmp775_ = FALSE;
	ValaMethod* _tmp776_;
	ValaMethod* _tmp830_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1024_;
	ValaIterator* _tmp1025_;
	ValaIterator* _tmp1446_;
	gboolean _tmp1456_ = FALSE;
	gboolean _tmp1457_ = FALSE;
	ValaMethod* _tmp1458_;
	gboolean _tmp1579_ = FALSE;
	ValaDelegate* _tmp1580_;
	gboolean _tmp1676_ = FALSE;
	ValaMethod* _tmp1677_;
	gboolean _tmp1693_;
	gboolean _tmp1694_;
	gboolean _tmp1737_ = FALSE;
	ValaDelegate* _tmp1738_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1756_;
	ValaDataType* _tmp1757_;
	gboolean _tmp1758_ = FALSE;
	ValaDataType* _tmp1759_;
	ValaCCodeFunctionCall* _tmp1787_;
	ValaCCodeFunctionCall* _tmp1788_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1801_;
	ValaCCodeFunctionCall* _tmp1802_;
	ValaCCodeFunctionCall* _tmp1817_;
	gboolean _tmp1832_;
	gboolean _tmp1833_;
	gboolean _tmp1857_;
	gboolean _tmp1858_;
	gboolean _tmp1893_ = FALSE;
	gboolean _tmp1894_ = FALSE;
	ValaMethod* _tmp1895_;
	gboolean _tmp1933_ = FALSE;
	gboolean _tmp1934_ = FALSE;
	gboolean _tmp1935_ = FALSE;
	gboolean _tmp1936_ = FALSE;
	gboolean _tmp1937_ = FALSE;
	ValaMethod* _tmp1938_;
	gboolean _tmp1955_ = FALSE;
	gboolean _tmp1956_ = FALSE;
	ValaMethod* _tmp1957_;
	ValaMethod* _tmp1976_;
	gboolean _tmp2086_ = FALSE;
	ValaCodeNode* _tmp2087_;
	ValaCodeNode* _tmp2088_;
	ValaList* _tmp2188_;
	ValaIterator* _tmp2189_;
	gboolean _tmp2343_ = FALSE;
	gboolean _tmp2344_ = FALSE;
	ValaMethod* _tmp2345_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp367_ = FALSE;
		ValaMemberAccess* _tmp368_;
		const gchar* _tmp369_;
		const gchar* _tmp370_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* pub_inst = NULL;
				ValaTargetValue* _tmp281_;
				ValaCCodeExpression* _tmp282_;
				ValaCCodeExpression* _tmp283_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaMethod* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaCCodeFunctionCall* _tmp352_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				_tmp281_ = instance_value;
				_tmp282_ = vala_get_cvalue_ (_tmp281_);
				_tmp283_ = _vala_ccode_node_ref0 (_tmp282_);
				pub_inst = _tmp283_;
				vcast = NULL;
				_tmp284_ = m;
				_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
				_tmp286_ = _tmp285_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp287_;
					ValaSymbol* _tmp288_;
					ValaSymbol* _tmp289_;
					ValaClass* _tmp290_;
					gboolean _tmp291_;
					gboolean _tmp292_;
					_tmp287_ = m;
					_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
					_tmp289_ = _tmp288_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass);
					_tmp290_ = base_class;
					_tmp291_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (_tmp292_) {
						ValaCCodeIdentifier* _tmp293_;
						ValaCCodeIdentifier* _tmp294_;
						ValaCCodeFunctionCall* _tmp295_;
						ValaCCodeFunctionCall* _tmp296_;
						ValaCCodeExpression* _tmp297_;
						ValaCCodeFunctionCall* _tmp298_;
						ValaClass* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaCCodeIdentifier* _tmp302_;
						ValaCCodeIdentifier* _tmp303_;
						ValaCCodeFunctionCall* _tmp304_;
						ValaClass* _tmp305_;
						gchar* _tmp306_;
						gchar* _tmp307_;
						ValaCCodeIdentifier* _tmp308_;
						ValaCCodeIdentifier* _tmp309_;
						_tmp293_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_CLASS");
						_tmp294_ = _tmp293_;
						_tmp295_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp294_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp295_;
						_vala_ccode_node_unref0 (_tmp294_);
						_tmp296_ = vcast;
						_tmp297_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp296_, _tmp297_);
						_tmp298_ = vcast;
						_tmp299_ = base_class;
						_tmp300_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_ccode_identifier_new (_tmp301_);
						_tmp303_ = _tmp302_;
						vala_ccode_function_call_add_argument (_tmp298_, (ValaCCodeExpression*) _tmp303_);
						_vala_ccode_node_unref0 (_tmp303_);
						_g_free0 (_tmp301_);
						_tmp304_ = vcast;
						_tmp305_ = base_class;
						_tmp306_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp305_);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_ccode_identifier_new (_tmp307_);
						_tmp309_ = _tmp308_;
						vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp309_);
						_vala_ccode_node_unref0 (_tmp309_);
						_g_free0 (_tmp307_);
					} else {
						ValaClass* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaCCodeIdentifier* _tmp313_;
						ValaCCodeIdentifier* _tmp314_;
						ValaCCodeFunctionCall* _tmp315_;
						ValaCCodeFunctionCall* _tmp316_;
						ValaCCodeExpression* _tmp317_;
						_tmp310_ = base_class;
						_tmp311_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_ccode_identifier_new (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp315_;
						_vala_ccode_node_unref0 (_tmp314_);
						_g_free0 (_tmp312_);
						_tmp316_ = vcast;
						_tmp317_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp316_, _tmp317_);
					}
				} else {
					ValaMethod* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp318_ = m;
					_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
					_tmp320_ = _tmp319_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp321_;
						ValaSymbol* _tmp322_;
						ValaSymbol* _tmp323_;
						ValaInterface* _tmp324_;
						gboolean _tmp325_;
						gboolean _tmp326_;
						_tmp321_ = m;
						_tmp322_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp324_ = base_iface;
						_tmp325_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp324_);
						_tmp326_ = _tmp325_;
						if (_tmp326_) {
							ValaCCodeIdentifier* _tmp327_;
							ValaCCodeIdentifier* _tmp328_;
							ValaCCodeFunctionCall* _tmp329_;
							ValaCCodeFunctionCall* _tmp330_;
							ValaCCodeExpression* _tmp331_;
							ValaCCodeFunctionCall* _tmp332_;
							ValaInterface* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							ValaCCodeIdentifier* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeFunctionCall* _tmp338_;
							ValaInterface* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							ValaCCodeIdentifier* _tmp343_;
							_tmp327_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_INTERFACE");
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp328_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp329_;
							_vala_ccode_node_unref0 (_tmp328_);
							_tmp330_ = vcast;
							_tmp331_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp330_, _tmp331_);
							_tmp332_ = vcast;
							_tmp333_ = base_iface;
							_tmp334_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = vala_ccode_identifier_new (_tmp335_);
							_tmp337_ = _tmp336_;
							vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp337_);
							_vala_ccode_node_unref0 (_tmp337_);
							_g_free0 (_tmp335_);
							_tmp338_ = vcast;
							_tmp339_ = base_iface;
							_tmp340_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_ccode_identifier_new (_tmp341_);
							_tmp343_ = _tmp342_;
							vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp343_);
							_vala_ccode_node_unref0 (_tmp343_);
							_g_free0 (_tmp341_);
						} else {
							ValaInterface* _tmp344_;
							gchar* _tmp345_;
							gchar* _tmp346_;
							ValaCCodeIdentifier* _tmp347_;
							ValaCCodeIdentifier* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							ValaCCodeExpression* _tmp351_;
							_tmp344_ = base_iface;
							_tmp345_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_identifier_new (_tmp346_);
							_tmp348_ = _tmp347_;
							_tmp349_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp349_;
							_vala_ccode_node_unref0 (_tmp348_);
							_g_free0 (_tmp346_);
							_tmp350_ = vcast;
							_tmp351_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp350_, _tmp351_);
						}
					}
				}
				_tmp352_ = vcast;
				if (_tmp352_ != NULL) {
					ValaCCodeFunctionCall* _tmp353_;
					ValaCCodeFunctionCall* _tmp354_;
					ValaMethod* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					ValaCCodeMemberAccess* _tmp358_;
					ValaCCodeMemberAccess* _tmp359_;
					ValaCCodeFunctionCall* _tmp360_;
					ValaCCodeFunctionCall* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					ValaCCodeMemberAccess* _tmp365_;
					ValaCCodeMemberAccess* _tmp366_;
					_tmp353_ = async_call;
					_tmp354_ = vcast;
					_tmp355_ = m;
					_tmp356_ = vala_get_ccode_vfunc_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp354_, _tmp357_);
					_tmp359_ = _tmp358_;
					vala_ccode_function_call_set_call (_tmp353_, (ValaCCodeExpression*) _tmp359_);
					_vala_ccode_node_unref0 (_tmp359_);
					_g_free0 (_tmp357_);
					_tmp360_ = finish_call;
					_tmp361_ = vcast;
					_tmp362_ = m;
					_tmp363_ = vala_get_ccode_finish_vfunc_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp361_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_ccode_function_call_set_call (_tmp360_, (ValaCCodeExpression*) _tmp366_);
					_vala_ccode_node_unref0 (_tmp366_);
					_g_free0 (_tmp364_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_ccode_node_unref0 (pub_inst);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_member_name (_tmp368_);
		_tmp370_ = _tmp369_;
		if (g_strcmp0 (_tmp370_, "begin") == 0) {
			ValaMemberAccess* _tmp371_;
			ValaExpression* _tmp372_;
			ValaExpression* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp371_ = ma;
			_tmp372_ = vala_member_access_get_inner (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
			_tmp375_ = _tmp374_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp367_ = _tmp375_ == _tmp378_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCCodeFunctionCall* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			_tmp379_ = async_call;
			_tmp380_ = _vala_ccode_node_ref0 (_tmp379_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_async_begin_parameters (_tmp381_);
			_vala_iterable_unref0 (params);
			params = _tmp382_;
		} else {
			gboolean _tmp383_ = FALSE;
			ValaMemberAccess* _tmp384_;
			const gchar* _tmp385_;
			const gchar* _tmp386_;
			_tmp384_ = ma;
			_tmp385_ = vala_member_access_get_member_name (_tmp384_);
			_tmp386_ = _tmp385_;
			if (g_strcmp0 (_tmp386_, "end") == 0) {
				ValaMemberAccess* _tmp387_;
				ValaExpression* _tmp388_;
				ValaExpression* _tmp389_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				ValaMemberAccess* _tmp392_;
				ValaSymbol* _tmp393_;
				ValaSymbol* _tmp394_;
				_tmp387_ = ma;
				_tmp388_ = vala_member_access_get_inner (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_expression_get_symbol_reference (_tmp389_);
				_tmp391_ = _tmp390_;
				_tmp392_ = ma;
				_tmp393_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp383_ = _tmp391_ == _tmp394_;
			} else {
				_tmp383_ = FALSE;
			}
			if (_tmp383_) {
				ValaCCodeFunctionCall* _tmp395_;
				ValaCCodeFunctionCall* _tmp396_;
				ValaMethod* _tmp397_;
				ValaList* _tmp398_;
				_tmp395_ = finish_call;
				_tmp396_ = _vala_ccode_node_ref0 (_tmp395_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp396_;
				_tmp397_ = m;
				_tmp398_ = vala_method_get_async_end_parameters (_tmp397_);
				_vala_iterable_unref0 (params);
				params = _tmp398_;
			} else {
				gboolean _tmp399_;
				gboolean _tmp400_;
				_tmp399_ = vala_method_call_get_is_yield_expression (expr);
				_tmp400_ = _tmp399_;
				if (!_tmp400_) {
					ValaCCodeFunctionCall* _tmp401_;
					ValaCCodeFunctionCall* _tmp402_;
					ValaMethod* _tmp403_;
					ValaList* _tmp404_;
					_tmp401_ = async_call;
					_tmp402_ = _vala_ccode_node_ref0 (_tmp401_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp402_;
					_tmp403_ = m;
					_tmp404_ = vala_method_get_async_begin_parameters (_tmp403_);
					_vala_iterable_unref0 (params);
					params = _tmp404_;
				} else {
					ValaCCodeFunctionCall* _tmp405_;
					ValaCCodeFunctionCall* _tmp406_;
					GHashFunc _tmp407_;
					GEqualFunc _tmp408_;
					GEqualFunc _tmp409_;
					ValaHashMap* _tmp410_;
					ValaHashMap* _tmp411_;
					ValaMethod* _tmp412_;
					ValaCCodeIdentifier* _tmp413_;
					ValaCCodeIdentifier* _tmp414_;
					ValaCCodeMemberAccess* _tmp415_;
					ValaCCodeMemberAccess* _tmp416_;
					_tmp405_ = finish_call;
					_tmp406_ = _vala_ccode_node_ref0 (_tmp405_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp406_;
					_tmp407_ = g_direct_hash;
					_tmp408_ = g_direct_equal;
					_tmp409_ = g_direct_equal;
					_tmp410_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp407_, _tmp408_, _tmp409_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp410_;
					_tmp411_ = out_arg_map;
					_tmp412_ = m;
					_tmp413_ = vala_ccode_identifier_new ("_data_");
					_tmp414_ = _tmp413_;
					_tmp415_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp414_, "_res_");
					_tmp416_ = _tmp415_;
					vala_map_set ((ValaMap*) _tmp411_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp412_), FALSE)), (ValaCCodeExpression*) _tmp416_);
					_vala_ccode_node_unref0 (_tmp416_);
					_vala_ccode_node_unref0 (_tmp414_);
				}
			}
		}
	}
	_tmp418_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp418_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp419_;
		ValaSymbol* _tmp420_;
		ValaSymbol* _tmp421_;
		_tmp419_ = m;
		_tmp420_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp419_);
		_tmp421_ = _tmp420_;
		_tmp417_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp421_, VALA_TYPE_CLASS);
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaCodeContext* _tmp422_;
		ValaCodeContext* _tmp423_;
		ValaProfile _tmp424_;
		ValaProfile _tmp425_;
		ValaClass* _tmp437_;
		ValaClass* _tmp438_;
		gboolean _tmp439_;
		gboolean _tmp440_;
		_tmp422_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp423_ = _tmp422_;
		_tmp424_ = vala_code_context_get_profile (_tmp423_);
		_tmp425_ = _tmp424_;
		if (_tmp425_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp426_;
			ValaSymbol* _tmp427_;
			ValaSymbol* _tmp428_;
			gboolean _tmp429_;
			gboolean _tmp430_;
			_tmp426_ = m;
			_tmp427_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_CLASS, ValaClass));
			_tmp430_ = _tmp429_;
			if (!_tmp430_) {
				ValaCCodeFunctionCall* _tmp431_;
				ValaCCodeExpression* _tmp432_;
				ValaCCodeExpression* _tmp433_;
				_tmp431_ = ccall;
				_tmp432_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp433_ = _tmp432_;
				vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
				_vala_ccode_node_unref0 (_tmp433_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp434_;
			ValaCCodeExpression* _tmp435_;
			ValaCCodeExpression* _tmp436_;
			_tmp434_ = ccall;
			_tmp435_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp436_ = _tmp435_;
			vala_ccode_function_call_add_argument (_tmp434_, _tmp436_);
			_vala_ccode_node_unref0 (_tmp436_);
		}
		_tmp437_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_class_get_is_compact (_tmp438_);
		_tmp440_ = _tmp439_;
		if (!_tmp440_) {
			ValaClass* _tmp441_;
			ValaClass* _tmp442_;
			ValaMethod* _tmp443_;
			ValaSymbol* _tmp444_;
			ValaSymbol* _tmp445_;
			_tmp441_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp442_ = _tmp441_;
			_tmp443_ = m;
			_tmp444_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp443_);
			_tmp445_ = _tmp444_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp445_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp446_;
					ValaClass* _tmp447_;
					ValaList* _tmp448_;
					ValaList* _tmp449_;
					gint _base_type_size = 0;
					ValaList* _tmp450_;
					gint _tmp451_;
					gint _tmp452_;
					gint _base_type_index = 0;
					_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp447_ = _tmp446_;
					_tmp448_ = vala_class_get_base_types (_tmp447_);
					_tmp449_ = _vala_iterable_ref0 (_tmp448_);
					_base_type_list = _tmp449_;
					_tmp450_ = _base_type_list;
					_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
					_tmp452_ = _tmp451_;
					_base_type_size = _tmp452_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp453_;
						gint _tmp454_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp455_;
						gpointer _tmp456_;
						ValaDataType* _tmp457_;
						ValaTypeSymbol* _tmp458_;
						ValaTypeSymbol* _tmp459_;
						_base_type_index = _base_type_index + 1;
						_tmp453_ = _base_type_index;
						_tmp454_ = _base_type_size;
						if (!(_tmp453_ < _tmp454_)) {
							break;
						}
						_tmp455_ = _base_type_list;
						_tmp456_ = vala_list_get (_tmp455_, _base_type_index);
						base_type = (ValaDataType*) _tmp456_;
						_tmp457_ = base_type;
						_tmp458_ = vala_data_type_get_type_symbol (_tmp457_);
						_tmp459_ = _tmp458_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp460_;
							gchar* _tmp461_;
							gchar* _tmp462_;
							gboolean _tmp463_;
							ValaHashMap* _tmp469_;
							ValaDataType* _tmp470_;
							ValaList* _tmp471_;
							ValaList* _tmp472_;
							type_parameters = NULL;
							_tmp460_ = m;
							_tmp461_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp460_);
							_tmp462_ = _tmp461_;
							_tmp463_ = g_strcmp0 (_tmp462_, "g_object_new") == 0;
							_g_free0 (_tmp462_);
							if (_tmp463_) {
								ValaDataType* _tmp464_;
								ValaTypeSymbol* _tmp465_;
								ValaTypeSymbol* _tmp466_;
								ValaList* _tmp467_;
								ValaList* _tmp468_;
								_tmp464_ = base_type;
								_tmp465_ = vala_data_type_get_type_symbol (_tmp464_);
								_tmp466_ = _tmp465_;
								_tmp467_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_CLASS, ValaClass));
								_tmp468_ = _vala_iterable_ref0 (_tmp467_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp468_;
							}
							_tmp469_ = in_arg_map;
							_tmp470_ = base_type;
							_tmp471_ = vala_data_type_get_type_arguments (_tmp470_);
							_tmp472_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp469_, _tmp471_, (ValaCodeNode*) expr, TRUE, _tmp472_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp473_;
				ValaSymbol* _tmp474_;
				ValaSymbol* _tmp475_;
				ValaClass* _tmp476_;
				type_param_index = 0;
				_tmp473_ = m;
				_tmp474_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp475_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp476_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp477_;
					ValaList* _tmp478_;
					ValaList* _tmp479_;
					gint _type_param_size = 0;
					ValaList* _tmp480_;
					gint _tmp481_;
					gint _tmp482_;
					gint _type_param_index = 0;
					_tmp477_ = cl;
					_tmp478_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp477_);
					_tmp479_ = _vala_iterable_ref0 (_tmp478_);
					_type_param_list = _tmp479_;
					_tmp480_ = _type_param_list;
					_tmp481_ = vala_collection_get_size ((ValaCollection*) _tmp480_);
					_tmp482_ = _tmp481_;
					_type_param_size = _tmp482_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp483_;
						gint _tmp484_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp485_;
						gpointer _tmp486_;
						ValaHashMap* _tmp487_;
						ValaTypeParameter* _tmp488_;
						const gchar* _tmp489_;
						const gchar* _tmp490_;
						gchar* _tmp491_;
						gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						ValaCCodeIdentifier* _tmp495_;
						ValaCCodeIdentifier* _tmp496_;
						ValaHashMap* _tmp497_;
						ValaTypeParameter* _tmp498_;
						const gchar* _tmp499_;
						const gchar* _tmp500_;
						gchar* _tmp501_;
						gchar* _tmp502_;
						gchar* _tmp503_;
						gchar* _tmp504_;
						ValaCCodeIdentifier* _tmp505_;
						ValaCCodeIdentifier* _tmp506_;
						ValaHashMap* _tmp507_;
						ValaTypeParameter* _tmp508_;
						const gchar* _tmp509_;
						const gchar* _tmp510_;
						gchar* _tmp511_;
						gchar* _tmp512_;
						gchar* _tmp513_;
						gchar* _tmp514_;
						ValaCCodeIdentifier* _tmp515_;
						ValaCCodeIdentifier* _tmp516_;
						gint _tmp517_;
						_type_param_index = _type_param_index + 1;
						_tmp483_ = _type_param_index;
						_tmp484_ = _type_param_size;
						if (!(_tmp483_ < _tmp484_)) {
							break;
						}
						_tmp485_ = _type_param_list;
						_tmp486_ = vala_list_get (_tmp485_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp486_;
						_tmp487_ = in_arg_map;
						_tmp488_ = type_param;
						_tmp489_ = vala_symbol_get_name ((ValaSymbol*) _tmp488_);
						_tmp490_ = _tmp489_;
						_tmp491_ = g_ascii_strdown (_tmp490_, (gssize) -1);
						_tmp492_ = _tmp491_;
						_tmp493_ = g_strdup_printf ("%s_type", _tmp492_);
						_tmp494_ = _tmp493_;
						_tmp495_ = vala_ccode_identifier_new (_tmp494_);
						_tmp496_ = _tmp495_;
						vala_map_set ((ValaMap*) _tmp487_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp496_);
						_vala_ccode_node_unref0 (_tmp496_);
						_g_free0 (_tmp494_);
						_g_free0 (_tmp492_);
						_tmp497_ = in_arg_map;
						_tmp498_ = type_param;
						_tmp499_ = vala_symbol_get_name ((ValaSymbol*) _tmp498_);
						_tmp500_ = _tmp499_;
						_tmp501_ = g_ascii_strdown (_tmp500_, (gssize) -1);
						_tmp502_ = _tmp501_;
						_tmp503_ = g_strdup_printf ("%s_dup_func", _tmp502_);
						_tmp504_ = _tmp503_;
						_tmp505_ = vala_ccode_identifier_new (_tmp504_);
						_tmp506_ = _tmp505_;
						vala_map_set ((ValaMap*) _tmp497_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp506_);
						_vala_ccode_node_unref0 (_tmp506_);
						_g_free0 (_tmp504_);
						_g_free0 (_tmp502_);
						_tmp507_ = in_arg_map;
						_tmp508_ = type_param;
						_tmp509_ = vala_symbol_get_name ((ValaSymbol*) _tmp508_);
						_tmp510_ = _tmp509_;
						_tmp511_ = g_ascii_strdown (_tmp510_, (gssize) -1);
						_tmp512_ = _tmp511_;
						_tmp513_ = g_strdup_printf ("%s_destroy_func", _tmp512_);
						_tmp514_ = _tmp513_;
						_tmp515_ = vala_ccode_identifier_new (_tmp514_);
						_tmp516_ = _tmp515_;
						vala_map_set ((ValaMap*) _tmp507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp516_);
						_vala_ccode_node_unref0 (_tmp516_);
						_g_free0 (_tmp514_);
						_g_free0 (_tmp512_);
						_tmp517_ = type_param_index;
						type_param_index = _tmp517_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp518_;
			ValaClass* _tmp519_;
			ValaClass* _tmp520_;
			ValaClass* _tmp521_;
			ValaClass* _tmp522_;
			_tmp518_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp519_ = _tmp518_;
			_tmp520_ = vala_class_get_base_class (_tmp519_);
			_tmp521_ = _tmp520_;
			_tmp522_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp521_ == _tmp522_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp523_;
				ValaClass* _tmp524_;
				gchar* _tmp525_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp526_;
				ValaCCodeDeclaration* _tmp527_;
				ValaCCodeDeclaration* _tmp528_;
				const gchar* _tmp529_;
				const gchar* _tmp530_;
				const gchar* _tmp531_;
				const gchar* _tmp532_;
				gchar* _tmp533_;
				gchar* _tmp534_;
				ValaCCodeConstant* _tmp535_;
				ValaCCodeConstant* _tmp536_;
				ValaCCodeVariableDeclarator* _tmp537_;
				ValaCCodeVariableDeclarator* _tmp538_;
				ValaCCodeFunction* _tmp539_;
				ValaCCodeFunction* _tmp540_;
				ValaCCodeDeclaration* _tmp541_;
				ValaCCodeFunctionCall* _tmp542_;
				ValaCCodeIdentifier* _tmp543_;
				ValaCCodeIdentifier* _tmp544_;
				ValaCCodeUnaryExpression* _tmp545_;
				ValaCCodeUnaryExpression* _tmp546_;
				ValaCCodeCastExpression* _tmp547_;
				ValaCCodeCastExpression* _tmp548_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp549_;
				ValaCCodeIdentifier* _tmp550_;
				ValaCCodeFunctionCall* _tmp551_;
				ValaCCodeFunctionCall* _tmp552_;
				ValaCCodeFunctionCall* _tmp553_;
				ValaClass* _tmp554_;
				ValaClass* _tmp555_;
				gchar* _tmp556_;
				gchar* _tmp557_;
				ValaCCodeIdentifier* _tmp558_;
				ValaCCodeIdentifier* _tmp559_;
				ValaCCodeFunctionCall* _tmp560_;
				ValaCCodeFunctionCall* _tmp561_;
				_tmp523_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp524_ = _tmp523_;
				_tmp525_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp524_, NULL);
				class_prefix = _tmp525_;
				_tmp526_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp526_;
				_tmp527_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp527_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp528_ = funcs;
				_tmp529_ = class_prefix;
				_tmp530_ = class_prefix;
				_tmp531_ = class_prefix;
				_tmp532_ = class_prefix;
				_tmp533_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp529_, _tmp530_, _tmp531_, _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_ccode_constant_new (_tmp534_);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp536_, NULL);
				_tmp538_ = _tmp537_;
				vala_ccode_declaration_add_declarator (_tmp528_, (ValaCCodeDeclarator*) _tmp538_);
				_vala_ccode_node_unref0 (_tmp538_);
				_vala_ccode_node_unref0 (_tmp536_);
				_g_free0 (_tmp534_);
				_tmp539_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp540_ = _tmp539_;
				_tmp541_ = funcs;
				vala_ccode_function_add_statement (_tmp540_, (ValaCCodeNode*) _tmp541_);
				_tmp542_ = ccall;
				_tmp543_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp546_, "GSourceFuncs *");
				_tmp548_ = _tmp547_;
				vala_ccode_function_call_add_argument (_tmp542_, (ValaCCodeExpression*) _tmp548_);
				_vala_ccode_node_unref0 (_tmp548_);
				_vala_ccode_node_unref0 (_tmp546_);
				_vala_ccode_node_unref0 (_tmp544_);
				_tmp549_ = vala_ccode_identifier_new ("sizeof");
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp550_);
				_tmp552_ = _tmp551_;
				_vala_ccode_node_unref0 (_tmp550_);
				csizeof = _tmp552_;
				_tmp553_ = csizeof;
				_tmp554_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_get_ccode_name ((ValaCodeNode*) _tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_ccode_identifier_new (_tmp557_);
				_tmp559_ = _tmp558_;
				vala_ccode_function_call_add_argument (_tmp553_, (ValaCCodeExpression*) _tmp559_);
				_vala_ccode_node_unref0 (_tmp559_);
				_g_free0 (_tmp557_);
				_tmp560_ = ccall;
				_tmp561_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp560_, (ValaCCodeExpression*) _tmp561_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp562_ = FALSE;
		ValaMethod* _tmp563_;
		_tmp563_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp563_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp564_;
			ValaSymbol* _tmp565_;
			ValaSymbol* _tmp566_;
			_tmp564_ = m;
			_tmp565_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp564_);
			_tmp566_ = _tmp565_;
			_tmp562_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp566_, VALA_TYPE_STRUCT);
		} else {
			_tmp562_ = FALSE;
		}
		if (_tmp562_) {
			ValaCCodeFunctionCall* _tmp567_;
			ValaCCodeExpression* _tmp568_;
			ValaCCodeExpression* _tmp569_;
			_tmp567_ = ccall;
			_tmp568_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp569_ = _tmp568_;
			vala_ccode_function_call_add_argument (_tmp567_, _tmp569_);
			_vala_ccode_node_unref0 (_tmp569_);
		} else {
			gboolean _tmp570_ = FALSE;
			gboolean _tmp571_ = FALSE;
			gboolean _tmp572_ = FALSE;
			gboolean _tmp573_ = FALSE;
			ValaMethod* _tmp574_;
			_tmp574_ = m;
			if (_tmp574_ != NULL) {
				ValaMethod* _tmp575_;
				_tmp575_ = m;
				_tmp573_ = vala_method_has_type_parameters (_tmp575_);
			} else {
				_tmp573_ = FALSE;
			}
			if (_tmp573_) {
				ValaMethod* _tmp576_;
				_tmp576_ = m;
				_tmp572_ = !vala_get_ccode_has_generic_type_parameter (_tmp576_);
			} else {
				_tmp572_ = FALSE;
			}
			if (_tmp572_) {
				ValaMethod* _tmp577_;
				_tmp577_ = m;
				_tmp571_ = !vala_get_ccode_simple_generics (_tmp577_);
			} else {
				_tmp571_ = FALSE;
			}
			if (_tmp571_) {
				gboolean _tmp578_ = FALSE;
				ValaCCodeFunctionCall* _tmp579_;
				ValaCCodeFunctionCall* _tmp580_;
				_tmp579_ = ccall;
				_tmp580_ = finish_call;
				if (_tmp579_ != _tmp580_) {
					_tmp578_ = TRUE;
				} else {
					gboolean _tmp581_;
					gboolean _tmp582_;
					_tmp581_ = vala_method_call_get_is_yield_expression (expr);
					_tmp582_ = _tmp581_;
					_tmp578_ = _tmp582_;
				}
				_tmp570_ = _tmp578_;
			} else {
				_tmp570_ = FALSE;
			}
			if (_tmp570_) {
				ValaHashMap* _tmp583_;
				ValaMemberAccess* _tmp584_;
				ValaList* _tmp585_;
				_tmp583_ = in_arg_map;
				_tmp584_ = ma;
				_tmp585_ = vala_member_access_get_type_arguments (_tmp584_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp583_, _tmp585_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp586_ = ccall;
	_tmp587_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp586_);
	ccall_expr = _tmp587_;
	_tmp589_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp589_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp590_;
		ValaCodeContext* _tmp591_;
		ValaProfile _tmp592_;
		ValaProfile _tmp593_;
		_tmp590_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp591_ = _tmp590_;
		_tmp592_ = vala_code_context_get_profile (_tmp591_);
		_tmp593_ = _tmp592_;
		_tmp588_ = _tmp593_ != VALA_PROFILE_POSIX;
	} else {
		_tmp588_ = FALSE;
	}
	if (_tmp588_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp594_;
		ValaExpression* _tmp595_;
		ValaExpression* _tmp596_;
		ValaDataType* _tmp597_;
		ValaDataType* _tmp598_;
		ValaArrayType* _tmp599_;
		ValaHashMap* _tmp600_;
		ValaArrayType* _tmp601_;
		ValaDataType* _tmp602_;
		ValaDataType* _tmp603_;
		gchar* _tmp604_;
		gchar* _tmp605_;
		ValaCCodeIdentifier* _tmp606_;
		ValaCCodeIdentifier* _tmp607_;
		_tmp594_ = ma;
		_tmp595_ = vala_member_access_get_inner (_tmp594_);
		_tmp596_ = _tmp595_;
		_tmp597_ = vala_expression_get_value_type (_tmp596_);
		_tmp598_ = _tmp597_;
		_tmp599_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp598_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp599_;
		_tmp600_ = in_arg_map;
		_tmp601_ = array_type;
		_tmp602_ = vala_array_type_get_element_type (_tmp601_);
		_tmp603_ = _tmp602_;
		_tmp604_ = vala_get_ccode_name ((ValaCodeNode*) _tmp603_);
		_tmp605_ = _tmp604_;
		_tmp606_ = vala_ccode_identifier_new (_tmp605_);
		_tmp607_ = _tmp606_;
		vala_map_set ((ValaMap*) _tmp600_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp607_);
		_vala_ccode_node_unref0 (_tmp607_);
		_g_free0 (_tmp605_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp608_;
		_tmp608_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp608_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp609_;
			_tmp609_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp609_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp610_;
				ValaExpression* _tmp611_;
				ValaExpression* _tmp612_;
				ValaTargetValue* _tmp613_;
				ValaTargetValue* _tmp614_;
				ValaTargetValue* _tmp615_;
				ValaTargetValue* _tmp616_;
				_tmp610_ = ma;
				_tmp611_ = vala_member_access_get_inner (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_expression_get_target_value (_tmp612_);
				_tmp614_ = _tmp613_;
				_tmp615_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp614_, (ValaCodeNode*) expr);
				_tmp616_ = _tmp615_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp616_);
				_vala_target_value_unref0 (_tmp616_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp618_ = m;
	if (_tmp618_ != NULL) {
		ValaMethod* _tmp619_;
		gboolean _tmp620_;
		gboolean _tmp621_;
		_tmp619_ = m;
		_tmp620_ = vala_method_get_is_async_callback (_tmp619_);
		_tmp621_ = _tmp620_;
		_tmp617_ = _tmp621_;
	} else {
		_tmp617_ = FALSE;
	}
	if (_tmp617_) {
		ValaMethod* _tmp622_;
		ValaMethod* _tmp623_;
		gboolean _tmp624_;
		gboolean _tmp625_;
		ValaHashMap* _tmp639_;
		ValaMethod* _tmp640_;
		ValaCCodeExpression* _tmp641_;
		ValaHashMap* _tmp642_;
		ValaMethod* _tmp643_;
		ValaCCodeExpression* _tmp644_;
		_tmp622_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp623_ = _tmp622_;
		_tmp624_ = vala_method_get_closure (_tmp623_);
		_tmp625_ = _tmp624_;
		if (_tmp625_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp626_;
			ValaSymbol* _tmp627_;
			ValaSymbol* _tmp628_;
			ValaBlock* _tmp629_;
			ValaBlock* _tmp630_;
			ValaBlock* _tmp631_;
			ValaBlock* _tmp632_;
			gchar* _tmp633_;
			gchar* _tmp634_;
			ValaCCodeExpression* _tmp635_;
			ValaCCodeExpression* _tmp636_;
			ValaCCodeMemberAccess* _tmp637_;
			_tmp626_ = m;
			_tmp627_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp626_);
			_tmp628_ = _tmp627_;
			_tmp629_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp628_, VALA_TYPE_METHOD, ValaMethod));
			_tmp630_ = _tmp629_;
			_tmp631_ = _vala_code_node_ref0 (_tmp630_);
			block = _tmp631_;
			_tmp632_ = block;
			_tmp633_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp632_));
			_tmp634_ = _tmp633_;
			_tmp635_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp634_);
			_tmp636_ = _tmp635_;
			_tmp637_ = vala_ccode_member_access_new_pointer (_tmp636_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp637_;
			_vala_ccode_node_unref0 (_tmp636_);
			_g_free0 (_tmp634_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp638_;
			_tmp638_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp638_;
		}
		_tmp639_ = in_arg_map;
		_tmp640_ = m;
		_tmp641_ = instance;
		vala_map_set ((ValaMap*) _tmp639_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp640_), FALSE)), _tmp641_);
		_tmp642_ = out_arg_map;
		_tmp643_ = m;
		_tmp644_ = instance;
		vala_map_set ((ValaMap*) _tmp642_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp643_), FALSE)), _tmp644_);
	} else {
		gboolean _tmp645_ = FALSE;
		gboolean _tmp646_ = FALSE;
		ValaMethod* _tmp647_;
		_tmp647_ = m;
		if (_tmp647_ != NULL) {
			ValaMethod* _tmp648_;
			ValaMemberBinding _tmp649_;
			ValaMemberBinding _tmp650_;
			_tmp648_ = m;
			_tmp649_ = vala_method_get_binding (_tmp648_);
			_tmp650_ = _tmp649_;
			_tmp646_ = _tmp650_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp646_ = FALSE;
		}
		if (_tmp646_) {
			ValaMethod* _tmp651_;
			_tmp651_ = m;
			_tmp645_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp651_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp645_ = FALSE;
		}
		if (_tmp645_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp652_;
			ValaExpression* _tmp653_;
			ValaExpression* _tmp654_;
			ValaTargetValue* _tmp655_;
			ValaTargetValue* _tmp656_;
			ValaTargetValue* _tmp657_;
			gboolean _tmp658_ = FALSE;
			gboolean _tmp659_ = FALSE;
			ValaMemberAccess* _tmp660_;
			const gchar* _tmp661_;
			const gchar* _tmp662_;
			ValaTargetValue* _tmp684_;
			ValaCCodeExpression* _tmp685_;
			ValaCCodeExpression* _tmp686_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp687_;
			ValaSymbol* _tmp688_;
			ValaSymbol* _tmp689_;
			ValaStruct* _tmp690_;
			gboolean _tmp691_ = FALSE;
			ValaStruct* _tmp692_;
			ValaMethod* _tmp700_;
			gboolean _tmp701_;
			gboolean _tmp702_;
			_tmp652_ = ma;
			_tmp653_ = vala_member_access_get_inner (_tmp652_);
			_tmp654_ = _tmp653_;
			_tmp655_ = vala_expression_get_target_value (_tmp654_);
			_tmp656_ = _tmp655_;
			_tmp657_ = _vala_target_value_ref0 (_tmp656_);
			instance_value = _tmp657_;
			_tmp660_ = ma;
			_tmp661_ = vala_member_access_get_member_name (_tmp660_);
			_tmp662_ = _tmp661_;
			if (g_strcmp0 (_tmp662_, "begin") == 0) {
				_tmp659_ = TRUE;
			} else {
				ValaMemberAccess* _tmp663_;
				const gchar* _tmp664_;
				const gchar* _tmp665_;
				_tmp663_ = ma;
				_tmp664_ = vala_member_access_get_member_name (_tmp663_);
				_tmp665_ = _tmp664_;
				_tmp659_ = g_strcmp0 (_tmp665_, "end") == 0;
			}
			if (_tmp659_) {
				ValaMemberAccess* _tmp666_;
				ValaExpression* _tmp667_;
				ValaExpression* _tmp668_;
				ValaSymbol* _tmp669_;
				ValaSymbol* _tmp670_;
				ValaMemberAccess* _tmp671_;
				ValaSymbol* _tmp672_;
				ValaSymbol* _tmp673_;
				_tmp666_ = ma;
				_tmp667_ = vala_member_access_get_inner (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_expression_get_symbol_reference (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp671_ = ma;
				_tmp672_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp671_);
				_tmp673_ = _tmp672_;
				_tmp658_ = _tmp670_ == _tmp673_;
			} else {
				_tmp658_ = FALSE;
			}
			if (_tmp658_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp674_;
				ValaExpression* _tmp675_;
				ValaExpression* _tmp676_;
				ValaMemberAccess* _tmp677_;
				ValaMemberAccess* _tmp678_;
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaTargetValue* _tmp681_;
				ValaTargetValue* _tmp682_;
				ValaTargetValue* _tmp683_;
				_tmp674_ = ma;
				_tmp675_ = vala_member_access_get_inner (_tmp674_);
				_tmp676_ = _tmp675_;
				_tmp677_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp676_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp677_;
				_tmp678_ = inner_ma;
				_tmp679_ = vala_member_access_get_inner (_tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_target_value (_tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = _vala_target_value_ref0 (_tmp682_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp683_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp684_ = instance_value;
			_tmp685_ = vala_get_cvalue_ (_tmp684_);
			_tmp686_ = _vala_ccode_node_ref0 (_tmp685_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp686_;
			_tmp687_ = m;
			_tmp688_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp687_);
			_tmp689_ = _tmp688_;
			_tmp690_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp689_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp689_) : NULL);
			st = _tmp690_;
			_tmp692_ = st;
			if (_tmp692_ != NULL) {
				ValaStruct* _tmp693_;
				_tmp693_ = st;
				_tmp691_ = !vala_struct_is_simple_type (_tmp693_);
			} else {
				_tmp691_ = FALSE;
			}
			if (_tmp691_) {
				ValaTargetValue* _tmp694_;
				ValaTargetValue* _tmp697_;
				ValaCCodeExpression* _tmp698_;
				ValaCCodeUnaryExpression* _tmp699_;
				_tmp694_ = instance_value;
				if (!vala_get_lvalue (_tmp694_)) {
					ValaTargetValue* _tmp695_;
					ValaTargetValue* _tmp696_;
					_tmp695_ = instance_value;
					_tmp696_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp695_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp696_;
				}
				_tmp697_ = instance_value;
				_tmp698_ = vala_get_cvalue_ (_tmp697_);
				_tmp699_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp698_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp699_;
			}
			_tmp700_ = m;
			_tmp701_ = vala_method_get_coroutine (_tmp700_);
			_tmp702_ = _tmp701_;
			if (!_tmp702_) {
				ValaHashMap* _tmp703_;
				ValaMethod* _tmp704_;
				ValaCCodeExpression* _tmp705_;
				_tmp703_ = in_arg_map;
				_tmp704_ = m;
				_tmp705_ = instance;
				vala_map_set ((ValaMap*) _tmp703_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp704_), FALSE)), _tmp705_);
			} else {
				gboolean _tmp706_;
				gboolean _tmp707_;
				_tmp706_ = vala_method_call_get_is_yield_expression (expr);
				_tmp707_ = _tmp706_;
				if (_tmp707_) {
					ValaHashMap* _tmp708_;
					ValaMethod* _tmp709_;
					ValaCCodeExpression* _tmp710_;
					ValaMethod* _tmp711_;
					_tmp708_ = in_arg_map;
					_tmp709_ = m;
					_tmp710_ = instance;
					vala_map_set ((ValaMap*) _tmp708_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp709_), FALSE)), _tmp710_);
					_tmp711_ = m;
					if (vala_get_ccode_finish_instance (_tmp711_)) {
						ValaHashMap* _tmp712_;
						ValaMethod* _tmp713_;
						ValaCCodeExpression* _tmp714_;
						_tmp712_ = out_arg_map;
						_tmp713_ = m;
						_tmp714_ = instance;
						vala_map_set ((ValaMap*) _tmp712_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp713_), FALSE)), _tmp714_);
					}
				} else {
					gboolean _tmp715_ = FALSE;
					ValaMemberAccess* _tmp716_;
					const gchar* _tmp717_;
					const gchar* _tmp718_;
					_tmp716_ = ma;
					_tmp717_ = vala_member_access_get_member_name (_tmp716_);
					_tmp718_ = _tmp717_;
					if (g_strcmp0 (_tmp718_, "end") != 0) {
						_tmp715_ = TRUE;
					} else {
						ValaMethod* _tmp719_;
						_tmp719_ = m;
						_tmp715_ = vala_get_ccode_finish_instance (_tmp719_);
					}
					if (_tmp715_) {
						ValaHashMap* _tmp720_;
						ValaMethod* _tmp721_;
						ValaCCodeExpression* _tmp722_;
						ValaHashMap* _tmp723_;
						ValaMethod* _tmp724_;
						ValaCCodeExpression* _tmp725_;
						_tmp720_ = out_arg_map;
						_tmp721_ = m;
						_tmp722_ = instance;
						vala_map_set ((ValaMap*) _tmp720_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp721_), FALSE)), _tmp722_);
						_tmp723_ = in_arg_map;
						_tmp724_ = m;
						_tmp725_ = instance;
						vala_map_set ((ValaMap*) _tmp723_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp724_), FALSE)), _tmp725_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp726_ = FALSE;
			ValaMethod* _tmp727_;
			_tmp727_ = m;
			if (_tmp727_ != NULL) {
				ValaMethod* _tmp728_;
				ValaMemberBinding _tmp729_;
				ValaMemberBinding _tmp730_;
				_tmp728_ = m;
				_tmp729_ = vala_method_get_binding (_tmp728_);
				_tmp730_ = _tmp729_;
				_tmp726_ = _tmp730_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp726_ = FALSE;
			}
			if (_tmp726_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp731_;
				ValaSymbol* _tmp732_;
				ValaSymbol* _tmp733_;
				ValaClass* _tmp734_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp735_;
				gchar* _tmp736_;
				gchar* _tmp737_;
				ValaCCodeIdentifier* _tmp738_;
				ValaCCodeIdentifier* _tmp739_;
				ValaCCodeFunctionCall* _tmp740_;
				ValaCCodeFunctionCall* _tmp741_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp742_;
				ValaExpression* _tmp743_;
				ValaExpression* _tmp744_;
				ValaCCodeFunctionCall* _tmp767_;
				ValaCCodeExpression* _tmp768_;
				ValaHashMap* _tmp769_;
				ValaMethod* _tmp770_;
				ValaCCodeFunctionCall* _tmp771_;
				ValaHashMap* _tmp772_;
				ValaMethod* _tmp773_;
				ValaCCodeFunctionCall* _tmp774_;
				_tmp731_ = m;
				_tmp732_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp731_);
				_tmp733_ = _tmp732_;
				_tmp734_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp733_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp734_;
				_tmp735_ = cl;
				_tmp736_ = vala_get_ccode_class_type_function (_tmp735_);
				_tmp737_ = _tmp736_;
				_tmp738_ = vala_ccode_identifier_new (_tmp737_);
				_tmp739_ = _tmp738_;
				_tmp740_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp739_);
				_tmp741_ = _tmp740_;
				_vala_ccode_node_unref0 (_tmp739_);
				_g_free0 (_tmp737_);
				cast = _tmp741_;
				_tmp742_ = ma;
				_tmp743_ = vala_member_access_get_inner (_tmp742_);
				_tmp744_ = _tmp743_;
				if (_tmp744_ == NULL) {
					ValaDataType* _tmp745_;
					_tmp745_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp745_ == NULL) {
						ValaCCodeIdentifier* _tmp746_;
						_tmp746_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp746_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp747_;
						ValaCCodeIdentifier* _tmp748_;
						ValaCCodeFunctionCall* _tmp749_;
						ValaCCodeFunctionCall* _tmp750_;
						ValaCCodeFunctionCall* _tmp751_;
						ValaCCodeExpression* _tmp752_;
						ValaCCodeExpression* _tmp753_;
						ValaCCodeFunctionCall* _tmp754_;
						ValaCCodeExpression* _tmp755_;
						_tmp747_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp748_ = _tmp747_;
						_tmp749_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp748_);
						_tmp750_ = _tmp749_;
						_vala_ccode_node_unref0 (_tmp748_);
						k = _tmp750_;
						_tmp751_ = k;
						_tmp752_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp753_ = _tmp752_;
						vala_ccode_function_call_add_argument (_tmp751_, _tmp753_);
						_vala_ccode_node_unref0 (_tmp753_);
						_tmp754_ = k;
						_tmp755_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp754_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp755_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp756_;
					ValaCCodeIdentifier* _tmp757_;
					ValaCCodeFunctionCall* _tmp758_;
					ValaCCodeFunctionCall* _tmp759_;
					ValaCCodeFunctionCall* _tmp760_;
					ValaMemberAccess* _tmp761_;
					ValaExpression* _tmp762_;
					ValaExpression* _tmp763_;
					ValaCCodeExpression* _tmp764_;
					ValaCCodeFunctionCall* _tmp765_;
					ValaCCodeExpression* _tmp766_;
					_tmp756_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp757_ = _tmp756_;
					_tmp758_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp757_);
					_tmp759_ = _tmp758_;
					_vala_ccode_node_unref0 (_tmp757_);
					k = _tmp759_;
					_tmp760_ = k;
					_tmp761_ = ma;
					_tmp762_ = vala_member_access_get_inner (_tmp761_);
					_tmp763_ = _tmp762_;
					_tmp764_ = vala_get_cvalue (_tmp763_);
					vala_ccode_function_call_add_argument (_tmp760_, _tmp764_);
					_tmp765_ = k;
					_tmp766_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp765_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp766_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp767_ = cast;
				_tmp768_ = klass;
				vala_ccode_function_call_add_argument (_tmp767_, _tmp768_);
				_tmp769_ = in_arg_map;
				_tmp770_ = m;
				_tmp771_ = cast;
				vala_map_set ((ValaMap*) _tmp769_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp770_), FALSE)), (ValaCCodeExpression*) _tmp771_);
				_tmp772_ = out_arg_map;
				_tmp773_ = m;
				_tmp774_ = cast;
				vala_map_set ((ValaMap*) _tmp772_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp773_), FALSE)), (ValaCCodeExpression*) _tmp774_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp776_ = m;
	if (_tmp776_ != NULL) {
		ValaMethod* _tmp777_;
		_tmp777_ = m;
		_tmp775_ = vala_get_ccode_has_generic_type_parameter (_tmp777_);
	} else {
		_tmp775_ = FALSE;
	}
	if (_tmp775_) {
		ValaMethod* _tmp778_;
		_tmp778_ = m;
		if (vala_method_has_type_parameters (_tmp778_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp779_;
				ValaList* _tmp780_;
				ValaList* _tmp781_;
				gint _type_arg_size = 0;
				ValaList* _tmp782_;
				gint _tmp783_;
				gint _tmp784_;
				gint _type_arg_index = 0;
				_tmp779_ = ma;
				_tmp780_ = vala_member_access_get_type_arguments (_tmp779_);
				_tmp781_ = _vala_iterable_ref0 (_tmp780_);
				_type_arg_list = _tmp781_;
				_tmp782_ = _type_arg_list;
				_tmp783_ = vala_collection_get_size ((ValaCollection*) _tmp782_);
				_tmp784_ = _tmp783_;
				_type_arg_size = _tmp784_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp785_;
					gint _tmp786_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp787_;
					gpointer _tmp788_;
					gboolean _tmp789_ = FALSE;
					gboolean _tmp790_ = FALSE;
					gboolean _tmp791_ = FALSE;
					ValaMethod* _tmp792_;
					ValaHashMap* _tmp800_;
					ValaMethod* _tmp801_;
					ValaDataType* _tmp802_;
					gchar* _tmp803_;
					gchar* _tmp804_;
					ValaCCodeIdentifier* _tmp805_;
					ValaCCodeIdentifier* _tmp806_;
					gint _tmp807_;
					_type_arg_index = _type_arg_index + 1;
					_tmp785_ = _type_arg_index;
					_tmp786_ = _type_arg_size;
					if (!(_tmp785_ < _tmp786_)) {
						break;
					}
					_tmp787_ = _type_arg_list;
					_tmp788_ = vala_list_get (_tmp787_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp788_;
					_tmp792_ = m;
					if (vala_get_ccode_simple_generics (_tmp792_)) {
						ValaDataType* _tmp793_;
						_tmp793_ = type_arg;
						_tmp791_ = vala_data_type_is_real_struct_type (_tmp793_);
					} else {
						_tmp791_ = FALSE;
					}
					if (_tmp791_) {
						ValaDataType* _tmp794_;
						gboolean _tmp795_;
						gboolean _tmp796_;
						_tmp794_ = type_arg;
						_tmp795_ = vala_data_type_get_nullable (_tmp794_);
						_tmp796_ = _tmp795_;
						_tmp790_ = !_tmp796_;
					} else {
						_tmp790_ = FALSE;
					}
					if (_tmp790_) {
						ValaDataType* _tmp797_;
						_tmp797_ = type_arg;
						_tmp789_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp797_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp789_ = FALSE;
					}
					if (_tmp789_) {
						ValaDataType* _tmp798_;
						ValaPointerType* _tmp799_;
						_tmp798_ = type_arg;
						_tmp799_ = vala_pointer_type_new (_tmp798_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp799_;
					}
					_tmp800_ = in_arg_map;
					_tmp801_ = m;
					_tmp802_ = type_arg;
					_tmp803_ = vala_get_ccode_name ((ValaCodeNode*) _tmp802_);
					_tmp804_ = _tmp803_;
					_tmp805_ = vala_ccode_identifier_new (_tmp804_);
					_tmp806_ = _tmp805_;
					vala_map_set ((ValaMap*) _tmp800_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp801_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp806_);
					_vala_ccode_node_unref0 (_tmp806_);
					_g_free0 (_tmp804_);
					_tmp807_ = type_param_index;
					type_param_index = _tmp807_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp808_;
				ValaExpression* _tmp809_;
				ValaExpression* _tmp810_;
				ValaDataType* _tmp811_;
				ValaDataType* _tmp812_;
				ValaList* _tmp813_;
				ValaList* _tmp814_;
				gint _type_arg_size = 0;
				ValaList* _tmp815_;
				gint _tmp816_;
				gint _tmp817_;
				gint _type_arg_index = 0;
				_tmp808_ = ma;
				_tmp809_ = vala_member_access_get_inner (_tmp808_);
				_tmp810_ = _tmp809_;
				_tmp811_ = vala_expression_get_value_type (_tmp810_);
				_tmp812_ = _tmp811_;
				_tmp813_ = vala_data_type_get_type_arguments (_tmp812_);
				_tmp814_ = _vala_iterable_ref0 (_tmp813_);
				_type_arg_list = _tmp814_;
				_tmp815_ = _type_arg_list;
				_tmp816_ = vala_collection_get_size ((ValaCollection*) _tmp815_);
				_tmp817_ = _tmp816_;
				_type_arg_size = _tmp817_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp818_;
					gint _tmp819_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp820_;
					gpointer _tmp821_;
					ValaHashMap* _tmp822_;
					ValaMethod* _tmp823_;
					ValaDataType* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeIdentifier* _tmp827_;
					ValaCCodeIdentifier* _tmp828_;
					gint _tmp829_;
					_type_arg_index = _type_arg_index + 1;
					_tmp818_ = _type_arg_index;
					_tmp819_ = _type_arg_size;
					if (!(_tmp818_ < _tmp819_)) {
						break;
					}
					_tmp820_ = _type_arg_list;
					_tmp821_ = vala_list_get (_tmp820_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp821_;
					_tmp822_ = in_arg_map;
					_tmp823_ = m;
					_tmp824_ = type_arg;
					_tmp825_ = vala_get_ccode_name ((ValaCodeNode*) _tmp824_);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_identifier_new (_tmp826_);
					_tmp828_ = _tmp827_;
					vala_map_set ((ValaMap*) _tmp822_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp823_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp828_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_tmp829_ = type_param_index;
					type_param_index = _tmp829_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp830_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp830_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp831_;
		ValaExpression* _tmp832_;
		ValaExpression* _tmp833_;
		ValaDataType* _tmp834_;
		ValaDataType* _tmp835_;
		ValaArrayType* _tmp836_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp837_;
		ValaCCodeIdentifier* _tmp838_;
		ValaCCodeFunctionCall* _tmp839_;
		ValaCCodeFunctionCall* _tmp840_;
		ValaCCodeFunctionCall* _tmp841_;
		ValaArrayType* _tmp842_;
		ValaDataType* _tmp843_;
		ValaDataType* _tmp844_;
		gchar* _tmp845_;
		gchar* _tmp846_;
		ValaCCodeIdentifier* _tmp847_;
		ValaCCodeIdentifier* _tmp848_;
		ValaHashMap* _tmp849_;
		ValaCCodeFunctionCall* _tmp850_;
		_tmp831_ = ma;
		_tmp832_ = vala_member_access_get_inner (_tmp831_);
		_tmp833_ = _tmp832_;
		_tmp834_ = vala_expression_get_value_type (_tmp833_);
		_tmp835_ = _tmp834_;
		_tmp836_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp835_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp836_;
		_tmp837_ = vala_ccode_identifier_new ("sizeof");
		_tmp838_ = _tmp837_;
		_tmp839_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp838_);
		_tmp840_ = _tmp839_;
		_vala_ccode_node_unref0 (_tmp838_);
		csizeof = _tmp840_;
		_tmp841_ = csizeof;
		_tmp842_ = array_type;
		_tmp843_ = vala_array_type_get_element_type (_tmp842_);
		_tmp844_ = _tmp843_;
		_tmp845_ = vala_get_ccode_name ((ValaCodeNode*) _tmp844_);
		_tmp846_ = _tmp845_;
		_tmp847_ = vala_ccode_identifier_new (_tmp846_);
		_tmp848_ = _tmp847_;
		vala_ccode_function_call_add_argument (_tmp841_, (ValaCCodeExpression*) _tmp848_);
		_vala_ccode_node_unref0 (_tmp848_);
		_g_free0 (_tmp846_);
		_tmp849_ = in_arg_map;
		_tmp850_ = csizeof;
		vala_map_set ((ValaMap*) _tmp849_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp850_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp851_;
		_tmp851_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp851_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp852_;
			ValaMethod* _tmp853_;
			ValaMethod* _tmp854_;
			gint param_nr = 0;
			ValaMethod* _tmp920_;
			ValaCCodeBaseModuleEmitContext* _tmp921_;
			_tmp852_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp853_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp852_, (ValaSymbol*) _tmp853_);
			_tmp854_ = m;
			vala_method_clear_parameters (_tmp854_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp855_;
				ValaList* _tmp856_;
				gint _arg_size = 0;
				ValaList* _tmp857_;
				gint _tmp858_;
				gint _tmp859_;
				gint _arg_index = 0;
				_tmp855_ = vala_method_call_get_argument_list (expr);
				_tmp856_ = _vala_iterable_ref0 (_tmp855_);
				_arg_list = _tmp856_;
				_tmp857_ = _arg_list;
				_tmp858_ = vala_collection_get_size ((ValaCollection*) _tmp857_);
				_tmp859_ = _tmp858_;
				_arg_size = _tmp859_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp860_;
					gint _tmp861_;
					ValaExpression* arg = NULL;
					ValaList* _tmp862_;
					gpointer _tmp863_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp864_;
					ValaUnaryExpression* _tmp865_;
					gboolean _tmp866_ = FALSE;
					ValaUnaryExpression* _tmp867_;
					gint _tmp908_;
					_arg_index = _arg_index + 1;
					_tmp860_ = _arg_index;
					_tmp861_ = _arg_size;
					if (!(_tmp860_ < _tmp861_)) {
						break;
					}
					_tmp862_ = _arg_list;
					_tmp863_ = vala_list_get (_tmp862_, _arg_index);
					arg = (ValaExpression*) _tmp863_;
					_tmp864_ = arg;
					_tmp865_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp864_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp864_) : NULL);
					unary = _tmp865_;
					_tmp867_ = unary;
					if (_tmp867_ != NULL) {
						ValaUnaryExpression* _tmp868_;
						ValaUnaryOperator _tmp869_;
						ValaUnaryOperator _tmp870_;
						_tmp868_ = unary;
						_tmp869_ = vala_unary_expression_get_operator (_tmp868_);
						_tmp870_ = _tmp869_;
						_tmp866_ = _tmp870_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp866_ = FALSE;
					}
					if (_tmp866_) {
						ValaParameter* param = NULL;
						gchar* _tmp871_;
						gchar* _tmp872_;
						ValaUnaryExpression* _tmp873_;
						ValaExpression* _tmp874_;
						ValaExpression* _tmp875_;
						ValaDataType* _tmp876_;
						ValaDataType* _tmp877_;
						ValaParameter* _tmp878_;
						ValaParameter* _tmp879_;
						ValaParameter* _tmp880_;
						ValaMethod* _tmp881_;
						ValaParameter* _tmp882_;
						_tmp871_ = g_strdup_printf ("param%d", param_nr);
						_tmp872_ = _tmp871_;
						_tmp873_ = unary;
						_tmp874_ = vala_unary_expression_get_inner (_tmp873_);
						_tmp875_ = _tmp874_;
						_tmp876_ = vala_expression_get_value_type (_tmp875_);
						_tmp877_ = _tmp876_;
						_tmp878_ = vala_parameter_new (_tmp872_, _tmp877_, NULL);
						_tmp879_ = _tmp878_;
						_g_free0 (_tmp872_);
						param = _tmp879_;
						_tmp880_ = param;
						vala_parameter_set_direction (_tmp880_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp881_ = m;
						_tmp882_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp881_, _tmp882_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp883_ = FALSE;
						ValaUnaryExpression* _tmp884_;
						_tmp884_ = unary;
						if (_tmp884_ != NULL) {
							ValaUnaryExpression* _tmp885_;
							ValaUnaryOperator _tmp886_;
							ValaUnaryOperator _tmp887_;
							_tmp885_ = unary;
							_tmp886_ = vala_unary_expression_get_operator (_tmp885_);
							_tmp887_ = _tmp886_;
							_tmp883_ = _tmp887_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp883_ = FALSE;
						}
						if (_tmp883_) {
							ValaParameter* param = NULL;
							gchar* _tmp888_;
							gchar* _tmp889_;
							ValaUnaryExpression* _tmp890_;
							ValaExpression* _tmp891_;
							ValaExpression* _tmp892_;
							ValaDataType* _tmp893_;
							ValaDataType* _tmp894_;
							ValaParameter* _tmp895_;
							ValaParameter* _tmp896_;
							ValaParameter* _tmp897_;
							ValaMethod* _tmp898_;
							ValaParameter* _tmp899_;
							_tmp888_ = g_strdup_printf ("param%d", param_nr);
							_tmp889_ = _tmp888_;
							_tmp890_ = unary;
							_tmp891_ = vala_unary_expression_get_inner (_tmp890_);
							_tmp892_ = _tmp891_;
							_tmp893_ = vala_expression_get_value_type (_tmp892_);
							_tmp894_ = _tmp893_;
							_tmp895_ = vala_parameter_new (_tmp889_, _tmp894_, NULL);
							_tmp896_ = _tmp895_;
							_g_free0 (_tmp889_);
							param = _tmp896_;
							_tmp897_ = param;
							vala_parameter_set_direction (_tmp897_, VALA_PARAMETER_DIRECTION_REF);
							_tmp898_ = m;
							_tmp899_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp898_, _tmp899_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp900_;
							gchar* _tmp901_;
							gchar* _tmp902_;
							ValaExpression* _tmp903_;
							ValaDataType* _tmp904_;
							ValaDataType* _tmp905_;
							ValaParameter* _tmp906_;
							ValaParameter* _tmp907_;
							_tmp900_ = m;
							_tmp901_ = g_strdup_printf ("param%d", param_nr);
							_tmp902_ = _tmp901_;
							_tmp903_ = arg;
							_tmp904_ = vala_expression_get_value_type (_tmp903_);
							_tmp905_ = _tmp904_;
							_tmp906_ = vala_parameter_new (_tmp902_, _tmp905_, NULL);
							_tmp907_ = _tmp906_;
							vala_callable_add_parameter ((ValaCallable*) _tmp900_, _tmp907_);
							_vala_code_node_unref0 (_tmp907_);
							_g_free0 (_tmp902_);
						}
					}
					_tmp908_ = param_nr;
					param_nr = _tmp908_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp909_;
				ValaList* _tmp910_;
				ValaList* _tmp911_;
				gint _param_size = 0;
				ValaList* _tmp912_;
				gint _tmp913_;
				gint _tmp914_;
				gint _param_index = 0;
				_tmp909_ = m;
				_tmp910_ = vala_callable_get_parameters ((ValaCallable*) _tmp909_);
				_tmp911_ = _vala_iterable_ref0 (_tmp910_);
				_param_list = _tmp911_;
				_tmp912_ = _param_list;
				_tmp913_ = vala_collection_get_size ((ValaCollection*) _tmp912_);
				_tmp914_ = _tmp913_;
				_param_size = _tmp914_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp915_;
					gint _tmp916_;
					ValaParameter* param = NULL;
					ValaList* _tmp917_;
					gpointer _tmp918_;
					ValaParameter* _tmp919_;
					_param_index = _param_index + 1;
					_tmp915_ = _param_index;
					_tmp916_ = _param_size;
					if (!(_tmp915_ < _tmp916_)) {
						break;
					}
					_tmp917_ = _param_list;
					_tmp918_ = vala_list_get (_tmp917_, _param_index);
					param = (ValaParameter*) _tmp918_;
					_tmp919_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp919_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp920_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp920_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp921_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp921_);
		} else {
			gboolean _tmp922_ = FALSE;
			gboolean _tmp923_ = FALSE;
			ValaMethod* _tmp924_;
			_tmp924_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp924_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp925_;
				ValaCodeContext* _tmp926_;
				ValaProfile _tmp927_;
				ValaProfile _tmp928_;
				_tmp925_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp926_ = _tmp925_;
				_tmp927_ = vala_code_context_get_profile (_tmp926_);
				_tmp928_ = _tmp927_;
				_tmp923_ = _tmp928_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp923_ = FALSE;
			}
			if (_tmp923_) {
				ValaMethod* _tmp929_;
				ValaSymbol* _tmp930_;
				ValaSymbol* _tmp931_;
				_tmp929_ = m;
				_tmp930_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp929_);
				_tmp931_ = _tmp930_;
				_tmp922_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp931_, VALA_TYPE_CLASS);
			} else {
				_tmp922_ = FALSE;
			}
			if (_tmp922_) {
				ValaCCodeFunction* _tmp932_;
				ValaCCodeFunction* _tmp933_;
				ValaCCodeExpression* _tmp934_;
				ValaCCodeExpression* _tmp935_;
				ValaCCodeFunctionCall* _tmp936_;
				ValaClass* _tmp937_;
				ValaClass* _tmp938_;
				gchar* _tmp939_;
				gchar* _tmp940_;
				gchar* _tmp941_;
				gchar* _tmp942_;
				ValaCCodeCastExpression* _tmp943_;
				ValaCCodeCastExpression* _tmp944_;
				ValaMethod* _tmp945_;
				ValaMethod* _tmp946_;
				ValaBlock* _tmp947_;
				ValaBlock* _tmp948_;
				gboolean _tmp949_;
				gboolean _tmp950_;
				gboolean _tmp977_ = FALSE;
				ValaClass* _tmp978_;
				ValaClass* _tmp979_;
				gboolean _tmp980_;
				gboolean _tmp981_;
				_tmp932_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp933_ = _tmp932_;
				_tmp934_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp935_ = _tmp934_;
				_tmp936_ = ccall;
				_tmp937_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_get_ccode_name ((ValaCodeNode*) _tmp938_);
				_tmp940_ = _tmp939_;
				_tmp941_ = g_strconcat (_tmp940_, "*", NULL);
				_tmp942_ = _tmp941_;
				_tmp943_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp936_, _tmp942_);
				_tmp944_ = _tmp943_;
				vala_ccode_function_add_assignment (_tmp933_, _tmp935_, (ValaCCodeExpression*) _tmp944_);
				_vala_ccode_node_unref0 (_tmp944_);
				_g_free0 (_tmp942_);
				_g_free0 (_tmp940_);
				_vala_ccode_node_unref0 (_tmp935_);
				_tmp945_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp946_);
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_block_get_captured (_tmp948_);
				_tmp950_ = _tmp949_;
				if (_tmp950_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp951_;
					ValaClass* _tmp952_;
					ValaObjectType* _tmp953_;
					ValaObjectType* _tmp954_;
					ValaSourceReference* _tmp955_;
					ValaSourceReference* _tmp956_;
					ValaCCodeExpression* _tmp957_;
					ValaCCodeExpression* _tmp958_;
					ValaCCodeFunctionCall* _tmp959_;
					ValaCCodeFunctionCall* _tmp960_;
					ValaCCodeFunctionCall* _tmp961_;
					ValaCCodeExpression* _tmp962_;
					ValaCCodeExpression* _tmp963_;
					ValaCCodeFunction* _tmp964_;
					ValaCCodeFunction* _tmp965_;
					ValaMethod* _tmp966_;
					ValaMethod* _tmp967_;
					ValaBlock* _tmp968_;
					ValaBlock* _tmp969_;
					gchar* _tmp970_;
					gchar* _tmp971_;
					ValaCCodeExpression* _tmp972_;
					ValaCCodeExpression* _tmp973_;
					ValaCCodeMemberAccess* _tmp974_;
					ValaCCodeMemberAccess* _tmp975_;
					ValaCCodeFunctionCall* _tmp976_;
					_tmp951_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp952_ = _tmp951_;
					_tmp953_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp952_);
					_tmp954_ = _tmp953_;
					_tmp955_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp956_ = _tmp955_;
					_tmp957_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp954_, _tmp956_, FALSE);
					_tmp958_ = _tmp957_;
					_tmp959_ = vala_ccode_function_call_new (_tmp958_);
					_tmp960_ = _tmp959_;
					_vala_ccode_node_unref0 (_tmp958_);
					_vala_code_node_unref0 (_tmp954_);
					ref_call = _tmp960_;
					_tmp961_ = ref_call;
					_tmp962_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp963_ = _tmp962_;
					vala_ccode_function_call_add_argument (_tmp961_, _tmp963_);
					_vala_ccode_node_unref0 (_tmp963_);
					_tmp964_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp965_ = _tmp964_;
					_tmp966_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp967_ = _tmp966_;
					_tmp968_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp967_);
					_tmp969_ = _tmp968_;
					_tmp970_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp969_));
					_tmp971_ = _tmp970_;
					_tmp972_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp971_);
					_tmp973_ = _tmp972_;
					_tmp974_ = vala_ccode_member_access_new_pointer (_tmp973_, "self");
					_tmp975_ = _tmp974_;
					_tmp976_ = ref_call;
					vala_ccode_function_add_assignment (_tmp965_, (ValaCCodeExpression*) _tmp975_, (ValaCCodeExpression*) _tmp976_);
					_vala_ccode_node_unref0 (_tmp975_);
					_vala_ccode_node_unref0 (_tmp973_);
					_g_free0 (_tmp971_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp978_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp979_ = _tmp978_;
				_tmp980_ = vala_class_get_is_compact (_tmp979_);
				_tmp981_ = _tmp980_;
				if (!_tmp981_) {
					ValaClass* _tmp982_;
					ValaClass* _tmp983_;
					_tmp982_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp983_ = _tmp982_;
					_tmp977_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp983_);
				} else {
					_tmp977_ = FALSE;
				}
				if (_tmp977_) {
					gchar** suffices = NULL;
					gchar* _tmp984_;
					gchar* _tmp985_;
					gchar* _tmp986_;
					gchar** _tmp987_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp984_ = g_strdup ("type");
					_tmp985_ = g_strdup ("dup_func");
					_tmp986_ = g_strdup ("destroy_func");
					_tmp987_ = g_new0 (gchar*, 3 + 1);
					_tmp987_[0] = _tmp984_;
					_tmp987_[1] = _tmp985_;
					_tmp987_[2] = _tmp986_;
					suffices = _tmp987_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp988_;
						ValaClass* _tmp989_;
						ValaList* _tmp990_;
						ValaList* _tmp991_;
						gint _type_param_size = 0;
						ValaList* _tmp992_;
						gint _tmp993_;
						gint _tmp994_;
						gint _type_param_index = 0;
						_tmp988_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp989_ = _tmp988_;
						_tmp990_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp989_);
						_tmp991_ = _vala_iterable_ref0 (_tmp990_);
						_type_param_list = _tmp991_;
						_tmp992_ = _type_param_list;
						_tmp993_ = vala_collection_get_size ((ValaCollection*) _tmp992_);
						_tmp994_ = _tmp993_;
						_type_param_size = _tmp994_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp995_;
							gint _tmp996_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp997_;
							gpointer _tmp998_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp999_;
							ValaCCodeIdentifier* _tmp1000_;
							ValaCCodeMemberAccess* _tmp1001_;
							ValaCCodeMemberAccess* _tmp1002_;
							gchar** _tmp1003_;
							gint _tmp1003__length1;
							_type_param_index = _type_param_index + 1;
							_tmp995_ = _type_param_index;
							_tmp996_ = _type_param_size;
							if (!(_tmp995_ < _tmp996_)) {
								break;
							}
							_tmp997_ = _type_param_list;
							_tmp998_ = vala_list_get (_tmp997_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp998_;
							_tmp999_ = vala_ccode_identifier_new ("self");
							_tmp1000_ = _tmp999_;
							_tmp1001_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1000_, "priv");
							_tmp1002_ = _tmp1001_;
							_vala_ccode_node_unref0 (_tmp1000_);
							priv_access = _tmp1002_;
							_tmp1003_ = suffices;
							_tmp1003__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp1003_;
								suffix_collection_length1 = _tmp1003__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp1004_;
									gchar* suffix = NULL;
									_tmp1004_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp1004_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp1005_;
										const gchar* _tmp1006_;
										const gchar* _tmp1007_;
										gchar* _tmp1008_;
										gchar* _tmp1009_;
										const gchar* _tmp1010_;
										gchar* _tmp1011_;
										gchar* _tmp1012_;
										ValaCCodeIdentifier* _tmp1013_;
										ValaCCodeIdentifier* _tmp1014_;
										ValaCCodeFunction* _tmp1015_;
										ValaCCodeFunction* _tmp1016_;
										ValaCCodeMemberAccess* _tmp1017_;
										ValaCCodeIdentifier* _tmp1018_;
										const gchar* _tmp1019_;
										const gchar* _tmp1020_;
										ValaCCodeMemberAccess* _tmp1021_;
										ValaCCodeMemberAccess* _tmp1022_;
										ValaCCodeIdentifier* _tmp1023_;
										_tmp1005_ = type_param;
										_tmp1006_ = vala_symbol_get_name ((ValaSymbol*) _tmp1005_);
										_tmp1007_ = _tmp1006_;
										_tmp1008_ = g_ascii_strdown (_tmp1007_, (gssize) -1);
										_tmp1009_ = _tmp1008_;
										_tmp1010_ = suffix;
										_tmp1011_ = g_strdup_printf ("%s_%s", _tmp1009_, _tmp1010_);
										_tmp1012_ = _tmp1011_;
										_tmp1013_ = vala_ccode_identifier_new (_tmp1012_);
										_tmp1014_ = _tmp1013_;
										_g_free0 (_tmp1012_);
										_g_free0 (_tmp1009_);
										param_name = _tmp1014_;
										_tmp1015_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp1016_ = _tmp1015_;
										_tmp1017_ = priv_access;
										_tmp1018_ = param_name;
										_tmp1019_ = vala_ccode_identifier_get_name (_tmp1018_);
										_tmp1020_ = _tmp1019_;
										_tmp1021_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1017_, _tmp1020_);
										_tmp1022_ = _tmp1021_;
										_tmp1023_ = param_name;
										vala_ccode_function_add_assignment (_tmp1016_, (ValaCCodeExpression*) _tmp1022_, (ValaCCodeExpression*) _tmp1023_);
										_vala_ccode_node_unref0 (_tmp1022_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1024_ = params;
	_tmp1025_ = vala_iterable_iterator ((ValaIterable*) _tmp1024_);
	params_it = _tmp1025_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1026_;
		ValaList* _tmp1027_;
		gint _arg_size = 0;
		ValaList* _tmp1028_;
		gint _tmp1029_;
		gint _tmp1030_;
		gint _arg_index = 0;
		_tmp1026_ = vala_method_call_get_argument_list (expr);
		_tmp1027_ = _vala_iterable_ref0 (_tmp1026_);
		_arg_list = _tmp1027_;
		_tmp1028_ = _arg_list;
		_tmp1029_ = vala_collection_get_size ((ValaCollection*) _tmp1028_);
		_tmp1030_ = _tmp1029_;
		_arg_size = _tmp1030_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1031_;
			gint _tmp1032_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1033_;
			gpointer _tmp1034_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1035_;
			ValaCCodeExpression* _tmp1036_;
			ValaCCodeExpression* _tmp1037_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1038_;
			ValaHashMap* _tmp1039_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1040_;
			gboolean _tmp1050_ = FALSE;
			ValaParameter* _tmp1051_;
			gdouble _tmp1395_ = 0.0;
			gboolean _tmp1396_ = FALSE;
			ValaParameter* _tmp1397_;
			ValaHashMap* _tmp1399_;
			ValaCCodeExpression* _tmp1400_;
			gboolean _tmp1401_ = FALSE;
			ValaMethod* _tmp1402_;
			gboolean _tmp1427_ = FALSE;
			ValaExpression* _tmp1428_;
			gint _tmp1445_;
			_arg_index = _arg_index + 1;
			_tmp1031_ = _arg_index;
			_tmp1032_ = _arg_size;
			if (!(_tmp1031_ < _tmp1032_)) {
				break;
			}
			_tmp1033_ = _arg_list;
			_tmp1034_ = vala_list_get (_tmp1033_, _arg_index);
			arg = (ValaExpression*) _tmp1034_;
			_tmp1035_ = arg;
			_tmp1036_ = vala_get_cvalue (_tmp1035_);
			_tmp1037_ = _vala_ccode_node_ref0 (_tmp1036_);
			cexpr = _tmp1037_;
			_tmp1038_ = in_arg_map;
			_tmp1039_ = _vala_map_ref0 (_tmp1038_);
			carg_map = _tmp1039_;
			param = NULL;
			_tmp1040_ = params_it;
			if (vala_iterator_next (_tmp1040_)) {
				ValaIterator* _tmp1041_;
				gpointer _tmp1042_;
				gboolean _tmp1043_ = FALSE;
				ValaParameter* _tmp1044_;
				gboolean _tmp1045_;
				gboolean _tmp1046_;
				_tmp1041_ = params_it;
				_tmp1042_ = vala_iterator_get (_tmp1041_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1042_;
				_tmp1044_ = param;
				_tmp1045_ = vala_parameter_get_params_array (_tmp1044_);
				_tmp1046_ = _tmp1045_;
				if (_tmp1046_) {
					_tmp1043_ = TRUE;
				} else {
					ValaParameter* _tmp1047_;
					gboolean _tmp1048_;
					gboolean _tmp1049_;
					_tmp1047_ = param;
					_tmp1048_ = vala_parameter_get_ellipsis (_tmp1047_);
					_tmp1049_ = _tmp1048_;
					_tmp1043_ = _tmp1049_;
				}
				ellipsis = _tmp1043_;
			}
			_tmp1051_ = param;
			if (_tmp1051_ != NULL) {
				_tmp1050_ = !ellipsis;
			} else {
				_tmp1050_ = FALSE;
			}
			if (_tmp1050_) {
				ValaParameter* _tmp1052_;
				ValaParameterDirection _tmp1053_;
				ValaParameterDirection _tmp1054_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1057_;
				ValaUnaryExpression* _tmp1058_;
				gboolean _tmp1059_ = FALSE;
				ValaUnaryExpression* _tmp1060_;
				ValaParameter* _tmp1325_;
				gchar* _tmp1326_;
				gchar* _tmp1327_;
				gboolean _tmp1328_;
				_tmp1052_ = param;
				_tmp1053_ = vala_parameter_get_direction (_tmp1052_);
				_tmp1054_ = _tmp1053_;
				if (_tmp1054_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1055_;
					ValaHashMap* _tmp1056_;
					_tmp1055_ = out_arg_map;
					_tmp1056_ = _vala_map_ref0 (_tmp1055_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1056_;
				}
				_tmp1057_ = arg;
				_tmp1058_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1057_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1057_) : NULL);
				unary = _tmp1058_;
				_tmp1060_ = unary;
				if (_tmp1060_ == NULL) {
					_tmp1059_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1061_;
					ValaUnaryOperator _tmp1062_;
					ValaUnaryOperator _tmp1063_;
					_tmp1061_ = unary;
					_tmp1062_ = vala_unary_expression_get_operator (_tmp1061_);
					_tmp1063_ = _tmp1062_;
					_tmp1059_ = _tmp1063_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1059_) {
					gboolean _tmp1064_ = FALSE;
					gboolean _tmp1065_ = FALSE;
					ValaParameter* _tmp1066_;
					ValaParameter* _tmp1208_;
					ValaExpression* _tmp1209_;
					ValaCCodeExpression* _tmp1210_;
					ValaCCodeExpression* _tmp1211_;
					_tmp1066_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1066_)) {
						ValaParameter* _tmp1067_;
						ValaDataType* _tmp1068_;
						ValaDataType* _tmp1069_;
						_tmp1067_ = param;
						_tmp1068_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1067_);
						_tmp1069_ = _tmp1068_;
						_tmp1065_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1069_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1065_ = FALSE;
					}
					if (_tmp1065_) {
						ValaParameter* _tmp1070_;
						ValaDataType* _tmp1071_;
						ValaDataType* _tmp1072_;
						gboolean _tmp1073_;
						gboolean _tmp1074_;
						_tmp1070_ = param;
						_tmp1071_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1070_);
						_tmp1072_ = _tmp1071_;
						_tmp1073_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1072_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1074_ = _tmp1073_;
						_tmp1064_ = !_tmp1074_;
					} else {
						_tmp1064_ = FALSE;
					}
					if (_tmp1064_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						ValaArrayType* _tmp1078_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1079_;
						gchar* _tmp1080_;
						gboolean _tmp1081_ = FALSE;
						ValaUnaryExpression* _tmp1082_;
						_tmp1075_ = param;
						_tmp1076_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1078_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1077_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1078_;
						_tmp1079_ = param;
						_tmp1080_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1079_);
						length_ctype = _tmp1080_;
						_tmp1082_ = unary;
						if (_tmp1082_ != NULL) {
							ValaUnaryExpression* _tmp1083_;
							ValaUnaryOperator _tmp1084_;
							ValaUnaryOperator _tmp1085_;
							_tmp1083_ = unary;
							_tmp1084_ = vala_unary_expression_get_operator (_tmp1083_);
							_tmp1085_ = _tmp1084_;
							_tmp1081_ = _tmp1085_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1081_ = FALSE;
						}
						if (_tmp1081_) {
							const gchar* _tmp1086_;
							gchar* _tmp1087_;
							_tmp1086_ = length_ctype;
							_tmp1087_ = g_strdup_printf ("%s*", _tmp1086_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1087_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1088_ = FALSE;
								_tmp1088_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1090_;
									gint _tmp1091_;
									gint _tmp1092_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1093_;
									ValaCCodeExpression* _tmp1094_;
									ValaCCodeExpression* _tmp1095_;
									const gchar* _tmp1096_;
									ValaCCodeCastExpression* _tmp1097_;
									ValaCCodeCastExpression* _tmp1098_;
									ValaHashMap* _tmp1099_;
									ValaParameter* _tmp1100_;
									ValaCCodeCastExpression* _tmp1101_;
									if (!_tmp1088_) {
										gint _tmp1089_;
										_tmp1089_ = dim;
										dim = _tmp1089_ + 1;
									}
									_tmp1088_ = FALSE;
									_tmp1090_ = array_type;
									_tmp1091_ = vala_array_type_get_rank (_tmp1090_);
									_tmp1092_ = _tmp1091_;
									if (!(dim <= _tmp1092_)) {
										break;
									}
									_tmp1093_ = arg;
									_tmp1094_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1093_, dim);
									_tmp1095_ = _tmp1094_;
									_tmp1096_ = length_ctype;
									_tmp1097_ = vala_ccode_cast_expression_new (_tmp1095_, _tmp1096_);
									_tmp1098_ = _tmp1097_;
									_vala_ccode_node_unref0 (_tmp1095_);
									array_length_expr = _tmp1098_;
									_tmp1099_ = carg_map;
									_tmp1100_ = param;
									_tmp1101_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1099_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1100_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1101_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1102_ = FALSE;
						ValaParameter* _tmp1103_;
						_tmp1103_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1103_)) {
							ValaParameter* _tmp1104_;
							ValaDataType* _tmp1105_;
							ValaDataType* _tmp1106_;
							_tmp1104_ = param;
							_tmp1105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1104_);
							_tmp1106_ = _tmp1105_;
							_tmp1102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1106_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1102_ = FALSE;
						}
						if (_tmp1102_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1107_;
							ValaDataType* _tmp1108_;
							ValaDataType* _tmp1109_;
							ValaDelegateType* _tmp1110_;
							ValaDelegateType* _tmp1111_;
							ValaDelegate* _tmp1112_;
							ValaDelegate* _tmp1113_;
							gboolean _tmp1114_;
							gboolean _tmp1115_;
							_tmp1107_ = param;
							_tmp1108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1107_);
							_tmp1109_ = _tmp1108_;
							_tmp1110_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1110_;
							_tmp1111_ = deleg_type;
							_tmp1112_ = vala_delegate_type_get_delegate_symbol (_tmp1111_);
							_tmp1113_ = _tmp1112_;
							_tmp1114_ = vala_delegate_get_has_target (_tmp1113_);
							_tmp1115_ = _tmp1114_;
							if (_tmp1115_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1116_;
								ValaCCodeExpression* _tmp1117_ = NULL;
								ValaCCodeExpression* _tmp1118_;
								ValaCCodeExpression* _tmp1119_;
								ValaParameter* _tmp1120_;
								gchar* _tmp1121_;
								gchar* _tmp1122_;
								gboolean _tmp1123_;
								_tmp1116_ = arg;
								_tmp1118_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1116_, &_tmp1117_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1117_;
								delegate_target = _tmp1118_;
								_tmp1119_ = delegate_target;
								_vala_assert (_tmp1119_ != NULL, "delegate_target != null");
								_tmp1120_ = param;
								_tmp1121_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1120_);
								_tmp1122_ = _tmp1121_;
								_tmp1123_ = g_strcmp0 (_tmp1122_, "GClosure*") == 0;
								_g_free0 (_tmp1122_);
								if (_tmp1123_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1124_;
									ValaCCodeIdentifier* _tmp1125_;
									ValaCCodeFunctionCall* _tmp1126_;
									ValaCCodeFunctionCall* _tmp1127_;
									ValaCCodeFunctionCall* _tmp1128_;
									ValaCCodeExpression* _tmp1129_;
									ValaCCodeCastExpression* _tmp1130_;
									ValaCCodeCastExpression* _tmp1131_;
									ValaCCodeFunctionCall* _tmp1132_;
									ValaCCodeExpression* _tmp1133_;
									ValaCCodeFunctionCall* _tmp1134_;
									ValaCCodeExpression* _tmp1135_;
									ValaCCodeCastExpression* _tmp1136_;
									ValaCCodeCastExpression* _tmp1137_;
									ValaCCodeExpression* _tmp1138_;
									ValaCCodeConstant* _tmp1139_;
									ValaCCodeConstant* _tmp1140_;
									ValaCCodeBinaryExpression* _tmp1141_;
									ValaCCodeBinaryExpression* _tmp1142_;
									ValaCCodeConstant* _tmp1143_;
									ValaCCodeConstant* _tmp1144_;
									ValaCCodeFunctionCall* _tmp1145_;
									ValaCCodeConditionalExpression* _tmp1146_;
									_tmp1124_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1125_ = _tmp1124_;
									_tmp1126_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1125_);
									_tmp1127_ = _tmp1126_;
									_vala_ccode_node_unref0 (_tmp1125_);
									closure_new = _tmp1127_;
									_tmp1128_ = closure_new;
									_tmp1129_ = cexpr;
									_tmp1130_ = vala_ccode_cast_expression_new (_tmp1129_, "GCallback");
									_tmp1131_ = _tmp1130_;
									vala_ccode_function_call_add_argument (_tmp1128_, (ValaCCodeExpression*) _tmp1131_);
									_vala_ccode_node_unref0 (_tmp1131_);
									_tmp1132_ = closure_new;
									_tmp1133_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1132_, _tmp1133_);
									_tmp1134_ = closure_new;
									_tmp1135_ = delegate_target_destroy_notify;
									_tmp1136_ = vala_ccode_cast_expression_new (_tmp1135_, "GClosureNotify");
									_tmp1137_ = _tmp1136_;
									vala_ccode_function_call_add_argument (_tmp1134_, (ValaCCodeExpression*) _tmp1137_);
									_vala_ccode_node_unref0 (_tmp1137_);
									_tmp1138_ = cexpr;
									_tmp1139_ = vala_ccode_constant_new ("NULL");
									_tmp1140_ = _tmp1139_;
									_tmp1141_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1138_, (ValaCCodeExpression*) _tmp1140_);
									_tmp1142_ = _tmp1141_;
									_tmp1143_ = vala_ccode_constant_new ("NULL");
									_tmp1144_ = _tmp1143_;
									_tmp1145_ = closure_new;
									_tmp1146_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1142_, (ValaCCodeExpression*) _tmp1144_, (ValaCCodeExpression*) _tmp1145_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1146_;
									_vala_ccode_node_unref0 (_tmp1144_);
									_vala_ccode_node_unref0 (_tmp1142_);
									_vala_ccode_node_unref0 (_tmp1140_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1147_;
									ValaParameter* _tmp1148_;
									gpointer _tmp1149_;
									gboolean _tmp1150_ = FALSE;
									ValaCCodeExpression* _tmp1151_;
									_tmp1147_ = carg_map;
									_tmp1148_ = param;
									_tmp1149_ = vala_map_get ((ValaMap*) _tmp1147_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1148_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1149_;
									_tmp1151_ = node;
									if (_tmp1151_ == NULL) {
										_tmp1150_ = TRUE;
									} else {
										gboolean _tmp1152_ = FALSE;
										ValaCCodeExpression* _tmp1153_;
										_tmp1153_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1153_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1154_;
											const gchar* _tmp1155_;
											const gchar* _tmp1156_;
											_tmp1154_ = node;
											_tmp1155_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1154_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1156_ = _tmp1155_;
											_tmp1152_ = g_strcmp0 (_tmp1156_, "NULL") == 0;
										} else {
											_tmp1152_ = FALSE;
										}
										_tmp1150_ = _tmp1152_;
									}
									if (_tmp1150_) {
										ValaHashMap* _tmp1157_;
										ValaParameter* _tmp1158_;
										ValaCCodeExpression* _tmp1159_;
										ValaDelegateType* _tmp1160_;
										_tmp1157_ = carg_map;
										_tmp1158_ = param;
										_tmp1159_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1157_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1158_), FALSE)), _tmp1159_);
										_tmp1160_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1160_)) {
											ValaCCodeExpression* _tmp1161_;
											ValaHashMap* _tmp1162_;
											ValaParameter* _tmp1163_;
											ValaCCodeExpression* _tmp1164_;
											_tmp1161_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1161_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1162_ = carg_map;
											_tmp1163_ = param;
											_tmp1164_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1162_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1163_), FALSE)), _tmp1164_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1165_;
							ValaDataType* _tmp1166_;
							ValaDataType* _tmp1167_;
							_tmp1165_ = param;
							_tmp1166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1165_);
							_tmp1167_ = _tmp1166_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1167_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1168_;
								ValaParameter* _tmp1169_;
								ValaExpression* _tmp1170_;
								ValaCCodeExpression* _tmp1171_ = NULL;
								ValaCCodeExpression* _tmp1172_;
								ValaCCodeExpression* _tmp1173_;
								_tmp1168_ = carg_map;
								_tmp1169_ = param;
								_tmp1170_ = arg;
								_tmp1172_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1170_, &_tmp1171_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1171_;
								_tmp1173_ = _tmp1172_;
								vala_map_set ((ValaMap*) _tmp1168_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1169_), FALSE)), _tmp1173_);
								_vala_ccode_node_unref0 (_tmp1173_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1174_;
								ValaDataType* _tmp1175_;
								ValaDataType* _tmp1176_;
								_tmp1174_ = param;
								_tmp1175_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1174_);
								_tmp1176_ = _tmp1175_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1176_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1177_ = FALSE;
									ValaMethod* _tmp1178_;
									_tmp1178_ = m;
									if (_tmp1178_ != NULL) {
										ValaMethod* _tmp1179_;
										_tmp1179_ = m;
										_tmp1177_ = vala_get_ccode_simple_generics (_tmp1179_);
									} else {
										_tmp1177_ = FALSE;
									}
									if (_tmp1177_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1180_;
										ValaDataType* _tmp1181_;
										ValaDataType* _tmp1182_;
										ValaGenericType* _tmp1183_;
										gint type_param_index = 0;
										ValaMethod* _tmp1184_;
										ValaGenericType* _tmp1185_;
										ValaTypeParameter* _tmp1186_;
										ValaTypeParameter* _tmp1187_;
										const gchar* _tmp1188_;
										const gchar* _tmp1189_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1190_;
										ValaList* _tmp1191_;
										gpointer _tmp1192_;
										ValaParameter* _tmp1193_;
										ValaDataType* _tmp1194_;
										ValaDataType* _tmp1195_;
										gboolean _tmp1196_;
										gboolean _tmp1197_;
										_tmp1180_ = param;
										_tmp1181_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1180_);
										_tmp1182_ = _tmp1181_;
										_tmp1183_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1182_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1183_;
										_tmp1184_ = m;
										_tmp1185_ = generic_type;
										_tmp1186_ = vala_generic_type_get_type_parameter (_tmp1185_);
										_tmp1187_ = _tmp1186_;
										_tmp1188_ = vala_symbol_get_name ((ValaSymbol*) _tmp1187_);
										_tmp1189_ = _tmp1188_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1184_, _tmp1189_);
										_tmp1190_ = ma;
										_tmp1191_ = vala_member_access_get_type_arguments (_tmp1190_);
										_tmp1192_ = vala_list_get (_tmp1191_, type_param_index);
										type_arg = (ValaDataType*) _tmp1192_;
										_tmp1193_ = param;
										_tmp1194_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1193_);
										_tmp1195_ = _tmp1194_;
										_tmp1196_ = vala_data_type_get_value_owned (_tmp1195_);
										_tmp1197_ = _tmp1196_;
										if (_tmp1197_) {
											ValaDataType* _tmp1198_;
											_tmp1198_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1198_)) {
												ValaHashMap* _tmp1199_;
												ValaParameter* _tmp1200_;
												ValaDataType* _tmp1201_;
												ValaCCodeExpression* _tmp1202_;
												ValaCCodeExpression* _tmp1203_;
												_tmp1199_ = carg_map;
												_tmp1200_ = param;
												_tmp1201_ = type_arg;
												_tmp1202_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1201_, FALSE);
												_tmp1203_ = _tmp1202_;
												vala_map_set ((ValaMap*) _tmp1199_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1200_), FALSE)), _tmp1203_);
												_vala_ccode_node_unref0 (_tmp1203_);
											} else {
												ValaHashMap* _tmp1204_;
												ValaParameter* _tmp1205_;
												ValaCCodeConstant* _tmp1206_;
												ValaCCodeConstant* _tmp1207_;
												_tmp1204_ = carg_map;
												_tmp1205_ = param;
												_tmp1206_ = vala_ccode_constant_new ("NULL");
												_tmp1207_ = _tmp1206_;
												vala_map_set ((ValaMap*) _tmp1204_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1205_), FALSE)), (ValaCCodeExpression*) _tmp1207_);
												_vala_ccode_node_unref0 (_tmp1207_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1208_ = param;
					_tmp1209_ = arg;
					_tmp1210_ = cexpr;
					_tmp1211_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1208_, _tmp1209_, _tmp1210_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1211_;
				} else {
					ValaExpression* _tmp1212_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1213_;
					ValaDataType* _tmp1214_;
					ValaDataType* _tmp1215_;
					ValaParameter* _tmp1216_;
					ValaDataType* _tmp1217_;
					ValaDataType* _tmp1218_;
					gboolean _tmp1219_;
					gboolean _tmp1220_;
					ValaLocalVariable* _tmp1221_;
					ValaLocalVariable* _tmp1222_;
					ValaExpression* _tmp1223_;
					ValaLocalVariable* _tmp1224_;
					const gchar* _tmp1225_;
					const gchar* _tmp1226_;
					ValaCCodeExpression* _tmp1227_;
					ValaCCodeExpression* _tmp1228_;
					ValaExpression* _tmp1229_;
					ValaTargetValue* _tmp1230_;
					ValaTargetValue* _tmp1231_;
					ValaExpression* _tmp1232_;
					ValaDataType* _tmp1233_;
					ValaDataType* _tmp1234_;
					ValaExpression* _tmp1235_;
					ValaCCodeExpression* _tmp1236_;
					ValaCCodeUnaryExpression* _tmp1237_;
					gboolean _tmp1238_ = FALSE;
					gboolean _tmp1239_ = FALSE;
					ValaParameter* _tmp1240_;
					_tmp1212_ = arg;
					vala_expression_set_target_value (_tmp1212_, NULL);
					_tmp1213_ = param;
					_tmp1214_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1213_);
					_tmp1215_ = _tmp1214_;
					_tmp1216_ = param;
					_tmp1217_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1216_);
					_tmp1218_ = _tmp1217_;
					_tmp1219_ = vala_data_type_get_value_owned (_tmp1218_);
					_tmp1220_ = _tmp1219_;
					_tmp1221_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1215_, _tmp1220_, NULL, TRUE);
					temp_var = _tmp1221_;
					_tmp1222_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1222_, FALSE);
					_tmp1223_ = arg;
					_tmp1224_ = temp_var;
					_tmp1225_ = vala_symbol_get_name ((ValaSymbol*) _tmp1224_);
					_tmp1226_ = _tmp1225_;
					_tmp1227_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1226_);
					_tmp1228_ = _tmp1227_;
					vala_set_cvalue (_tmp1223_, _tmp1228_);
					_vala_ccode_node_unref0 (_tmp1228_);
					_tmp1229_ = arg;
					_tmp1230_ = vala_expression_get_target_value (_tmp1229_);
					_tmp1231_ = _tmp1230_;
					_tmp1232_ = arg;
					_tmp1233_ = vala_expression_get_target_type (_tmp1232_);
					_tmp1234_ = _tmp1233_;
					vala_target_value_set_value_type (_tmp1231_, _tmp1234_);
					_tmp1235_ = arg;
					_tmp1236_ = vala_get_cvalue (_tmp1235_);
					_tmp1237_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1236_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1237_;
					_tmp1240_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1240_)) {
						ValaParameter* _tmp1241_;
						ValaDataType* _tmp1242_;
						ValaDataType* _tmp1243_;
						_tmp1241_ = param;
						_tmp1242_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1241_);
						_tmp1243_ = _tmp1242_;
						_tmp1239_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1243_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1239_ = FALSE;
					}
					if (_tmp1239_) {
						ValaParameter* _tmp1244_;
						ValaDataType* _tmp1245_;
						ValaDataType* _tmp1246_;
						gboolean _tmp1247_;
						gboolean _tmp1248_;
						_tmp1244_ = param;
						_tmp1245_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1244_);
						_tmp1246_ = _tmp1245_;
						_tmp1247_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1246_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1248_ = _tmp1247_;
						_tmp1238_ = !_tmp1248_;
					} else {
						_tmp1238_ = FALSE;
					}
					if (_tmp1238_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1249_;
						ValaDataType* _tmp1250_;
						ValaDataType* _tmp1251_;
						ValaArrayType* _tmp1252_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1253_;
						gchar* _tmp1254_;
						_tmp1249_ = param;
						_tmp1250_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1249_);
						_tmp1251_ = _tmp1250_;
						_tmp1252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1251_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1252_;
						_tmp1253_ = param;
						_tmp1254_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1253_);
						length_ctype = _tmp1254_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1255_ = FALSE;
								_tmp1255_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1257_;
									gint _tmp1258_;
									gint _tmp1259_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1260_;
									ValaCType* _tmp1261_;
									ValaCType* _tmp1262_;
									ValaLocalVariable* _tmp1263_;
									ValaLocalVariable* _tmp1264_;
									ValaLocalVariable* _tmp1265_;
									ValaExpression* _tmp1266_;
									ValaLocalVariable* _tmp1267_;
									const gchar* _tmp1268_;
									const gchar* _tmp1269_;
									ValaCCodeExpression* _tmp1270_;
									ValaCCodeExpression* _tmp1271_;
									ValaHashMap* _tmp1272_;
									ValaParameter* _tmp1273_;
									ValaExpression* _tmp1274_;
									ValaList* _tmp1275_;
									gpointer _tmp1276_;
									ValaCCodeExpression* _tmp1277_;
									ValaCCodeUnaryExpression* _tmp1278_;
									ValaCCodeUnaryExpression* _tmp1279_;
									if (!_tmp1255_) {
										gint _tmp1256_;
										_tmp1256_ = dim;
										dim = _tmp1256_ + 1;
									}
									_tmp1255_ = FALSE;
									_tmp1257_ = array_type;
									_tmp1258_ = vala_array_type_get_rank (_tmp1257_);
									_tmp1259_ = _tmp1258_;
									if (!(dim <= _tmp1259_)) {
										break;
									}
									_tmp1260_ = length_ctype;
									_tmp1261_ = vala_ctype_new (_tmp1260_, "0");
									_tmp1262_ = _tmp1261_;
									_tmp1263_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1262_, TRUE, NULL, TRUE);
									_tmp1264_ = _tmp1263_;
									_vala_code_node_unref0 (_tmp1262_);
									temp_array_length = _tmp1264_;
									_tmp1265_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1265_, FALSE);
									_tmp1266_ = arg;
									_tmp1267_ = temp_array_length;
									_tmp1268_ = vala_symbol_get_name ((ValaSymbol*) _tmp1267_);
									_tmp1269_ = _tmp1268_;
									_tmp1270_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1269_);
									_tmp1271_ = _tmp1270_;
									vala_append_array_length (_tmp1266_, _tmp1271_);
									_vala_ccode_node_unref0 (_tmp1271_);
									_tmp1272_ = carg_map;
									_tmp1273_ = param;
									_tmp1274_ = arg;
									_tmp1275_ = vala_get_array_lengths (_tmp1274_);
									_tmp1276_ = vala_list_get (_tmp1275_, dim - 1);
									_tmp1277_ = (ValaCCodeExpression*) _tmp1276_;
									_tmp1278_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1277_);
									_tmp1279_ = _tmp1278_;
									vala_map_set ((ValaMap*) _tmp1272_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1273_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1279_);
									_vala_ccode_node_unref0 (_tmp1279_);
									_vala_ccode_node_unref0 (_tmp1277_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1280_ = FALSE;
						ValaParameter* _tmp1281_;
						_tmp1281_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1281_)) {
							ValaParameter* _tmp1282_;
							ValaDataType* _tmp1283_;
							ValaDataType* _tmp1284_;
							_tmp1282_ = param;
							_tmp1283_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1282_);
							_tmp1284_ = _tmp1283_;
							_tmp1280_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1284_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1280_ = FALSE;
						}
						if (_tmp1280_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1285_;
							ValaDataType* _tmp1286_;
							ValaDataType* _tmp1287_;
							ValaDelegateType* _tmp1288_;
							ValaDelegateType* _tmp1289_;
							ValaDelegate* _tmp1290_;
							ValaDelegate* _tmp1291_;
							gboolean _tmp1292_;
							gboolean _tmp1293_;
							_tmp1285_ = param;
							_tmp1286_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1285_);
							_tmp1287_ = _tmp1286_;
							_tmp1288_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1287_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1288_;
							_tmp1289_ = deleg_type;
							_tmp1290_ = vala_delegate_type_get_delegate_symbol (_tmp1289_);
							_tmp1291_ = _tmp1290_;
							_tmp1292_ = vala_delegate_get_has_target (_tmp1291_);
							_tmp1293_ = _tmp1292_;
							if (_tmp1293_) {
								ValaDataType* _tmp1294_;
								ValaLocalVariable* _tmp1295_;
								ValaLocalVariable* _tmp1296_;
								ValaExpression* _tmp1297_;
								ValaLocalVariable* _tmp1298_;
								const gchar* _tmp1299_;
								const gchar* _tmp1300_;
								ValaCCodeExpression* _tmp1301_;
								ValaCCodeExpression* _tmp1302_;
								ValaHashMap* _tmp1303_;
								ValaParameter* _tmp1304_;
								ValaExpression* _tmp1305_;
								ValaCCodeExpression* _tmp1306_;
								ValaCCodeUnaryExpression* _tmp1307_;
								ValaCCodeUnaryExpression* _tmp1308_;
								ValaDelegateType* _tmp1309_;
								_tmp1294_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1295_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1294_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1295_;
								_tmp1296_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1296_, FALSE);
								_tmp1297_ = arg;
								_tmp1298_ = temp_var;
								_tmp1299_ = vala_symbol_get_name ((ValaSymbol*) _tmp1298_);
								_tmp1300_ = _tmp1299_;
								_tmp1301_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1300_);
								_tmp1302_ = _tmp1301_;
								vala_set_delegate_target (_tmp1297_, _tmp1302_);
								_vala_ccode_node_unref0 (_tmp1302_);
								_tmp1303_ = carg_map;
								_tmp1304_ = param;
								_tmp1305_ = arg;
								_tmp1306_ = vala_get_delegate_target (_tmp1305_);
								_tmp1307_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1306_);
								_tmp1308_ = _tmp1307_;
								vala_map_set ((ValaMap*) _tmp1303_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1304_), FALSE)), (ValaCCodeExpression*) _tmp1308_);
								_vala_ccode_node_unref0 (_tmp1308_);
								_tmp1309_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1309_)) {
									ValaDelegateType* _tmp1310_;
									ValaLocalVariable* _tmp1311_;
									ValaLocalVariable* _tmp1312_;
									ValaExpression* _tmp1313_;
									ValaLocalVariable* _tmp1314_;
									const gchar* _tmp1315_;
									const gchar* _tmp1316_;
									ValaCCodeExpression* _tmp1317_;
									ValaCCodeExpression* _tmp1318_;
									ValaHashMap* _tmp1319_;
									ValaParameter* _tmp1320_;
									ValaExpression* _tmp1321_;
									ValaCCodeExpression* _tmp1322_;
									ValaCCodeUnaryExpression* _tmp1323_;
									ValaCCodeUnaryExpression* _tmp1324_;
									_tmp1310_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1311_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1310_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1311_;
									_tmp1312_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1312_, FALSE);
									_tmp1313_ = arg;
									_tmp1314_ = temp_var;
									_tmp1315_ = vala_symbol_get_name ((ValaSymbol*) _tmp1314_);
									_tmp1316_ = _tmp1315_;
									_tmp1317_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1316_);
									_tmp1318_ = _tmp1317_;
									vala_set_delegate_target_destroy_notify (_tmp1313_, _tmp1318_);
									_vala_ccode_node_unref0 (_tmp1318_);
									_tmp1319_ = carg_map;
									_tmp1320_ = param;
									_tmp1321_ = arg;
									_tmp1322_ = vala_get_delegate_target_destroy_notify (_tmp1321_);
									_tmp1323_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1322_);
									_tmp1324_ = _tmp1323_;
									vala_map_set ((ValaMap*) _tmp1319_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1320_), FALSE)), (ValaCCodeExpression*) _tmp1324_);
									_vala_ccode_node_unref0 (_tmp1324_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1325_ = param;
				_tmp1326_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1325_);
				_tmp1327_ = _tmp1326_;
				_tmp1328_ = _tmp1327_ != NULL;
				_g_free0 (_tmp1327_);
				if (_tmp1328_) {
					ValaCCodeExpression* _tmp1329_;
					ValaParameter* _tmp1330_;
					gchar* _tmp1331_;
					gchar* _tmp1332_;
					ValaCCodeCastExpression* _tmp1333_;
					_tmp1329_ = cexpr;
					_tmp1330_ = param;
					_tmp1331_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1330_);
					_tmp1332_ = _tmp1331_;
					_tmp1333_ = vala_ccode_cast_expression_new (_tmp1329_, _tmp1332_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1333_;
					_g_free0 (_tmp1332_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1334_;
				ValaUnaryExpression* _tmp1335_;
				gboolean _tmp1336_ = FALSE;
				gboolean _tmp1337_ = FALSE;
				_tmp1334_ = arg;
				_tmp1335_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1334_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1334_) : NULL);
				unary = _tmp1335_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1338_;
					_tmp1338_ = unary;
					_tmp1337_ = _tmp1338_ != NULL;
				} else {
					_tmp1337_ = FALSE;
				}
				if (_tmp1337_) {
					ValaUnaryExpression* _tmp1339_;
					ValaUnaryOperator _tmp1340_;
					ValaUnaryOperator _tmp1341_;
					_tmp1339_ = unary;
					_tmp1340_ = vala_unary_expression_get_operator (_tmp1339_);
					_tmp1341_ = _tmp1340_;
					_tmp1336_ = _tmp1341_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1336_ = FALSE;
				}
				if (_tmp1336_) {
					ValaHashMap* _tmp1342_;
					ValaHashMap* _tmp1343_;
					ValaExpression* _tmp1344_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1345_;
					ValaDataType* _tmp1346_;
					ValaDataType* _tmp1347_;
					ValaExpression* _tmp1348_;
					ValaDataType* _tmp1349_;
					ValaDataType* _tmp1350_;
					gboolean _tmp1351_;
					gboolean _tmp1352_;
					ValaLocalVariable* _tmp1353_;
					ValaLocalVariable* _tmp1354_;
					ValaExpression* _tmp1355_;
					ValaLocalVariable* _tmp1356_;
					const gchar* _tmp1357_;
					const gchar* _tmp1358_;
					ValaCCodeExpression* _tmp1359_;
					ValaCCodeExpression* _tmp1360_;
					ValaExpression* _tmp1361_;
					ValaTargetValue* _tmp1362_;
					ValaTargetValue* _tmp1363_;
					ValaExpression* _tmp1364_;
					ValaDataType* _tmp1365_;
					ValaDataType* _tmp1366_;
					gboolean _tmp1367_ = FALSE;
					ValaExpression* _tmp1368_;
					ValaDataType* _tmp1369_;
					ValaDataType* _tmp1370_;
					ValaExpression* _tmp1389_;
					ValaCCodeExpression* _tmp1390_;
					ValaCCodeUnaryExpression* _tmp1391_;
					_tmp1342_ = out_arg_map;
					_tmp1343_ = _vala_map_ref0 (_tmp1342_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1343_;
					_tmp1344_ = arg;
					vala_expression_set_target_value (_tmp1344_, NULL);
					_tmp1345_ = arg;
					_tmp1346_ = vala_expression_get_value_type (_tmp1345_);
					_tmp1347_ = _tmp1346_;
					_tmp1348_ = arg;
					_tmp1349_ = vala_expression_get_value_type (_tmp1348_);
					_tmp1350_ = _tmp1349_;
					_tmp1351_ = vala_data_type_get_value_owned (_tmp1350_);
					_tmp1352_ = _tmp1351_;
					_tmp1353_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1347_, _tmp1352_, NULL, TRUE);
					temp_var = _tmp1353_;
					_tmp1354_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1354_, FALSE);
					_tmp1355_ = arg;
					_tmp1356_ = temp_var;
					_tmp1357_ = vala_symbol_get_name ((ValaSymbol*) _tmp1356_);
					_tmp1358_ = _tmp1357_;
					_tmp1359_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1358_);
					_tmp1360_ = _tmp1359_;
					vala_set_cvalue (_tmp1355_, _tmp1360_);
					_vala_ccode_node_unref0 (_tmp1360_);
					_tmp1361_ = arg;
					_tmp1362_ = vala_expression_get_target_value (_tmp1361_);
					_tmp1363_ = _tmp1362_;
					_tmp1364_ = arg;
					_tmp1365_ = vala_expression_get_value_type (_tmp1364_);
					_tmp1366_ = _tmp1365_;
					vala_target_value_set_value_type (_tmp1363_, _tmp1366_);
					_tmp1368_ = arg;
					_tmp1369_ = vala_expression_get_value_type (_tmp1368_);
					_tmp1370_ = _tmp1369_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1370_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1371_;
						ValaDataType* _tmp1372_;
						ValaDataType* _tmp1373_;
						ValaDelegate* _tmp1374_;
						ValaDelegate* _tmp1375_;
						gboolean _tmp1376_;
						gboolean _tmp1377_;
						_tmp1371_ = arg;
						_tmp1372_ = vala_expression_get_value_type (_tmp1371_);
						_tmp1373_ = _tmp1372_;
						_tmp1374_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1373_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1375_ = _tmp1374_;
						_tmp1376_ = vala_delegate_get_has_target (_tmp1375_);
						_tmp1377_ = _tmp1376_;
						_tmp1367_ = _tmp1377_;
					} else {
						_tmp1367_ = FALSE;
					}
					if (_tmp1367_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1378_;
						ValaTargetValue* _tmp1379_;
						ValaTargetValue* _tmp1380_;
						ValaGLibValue* _tmp1381_;
						ValaCCodeExpression* _tmp1382_;
						ValaGLibValue* _tmp1385_;
						ValaCCodeExpression* _tmp1386_;
						_tmp1378_ = arg;
						_tmp1379_ = vala_expression_get_target_value (_tmp1378_);
						_tmp1380_ = _tmp1379_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1380_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1381_ = arg_value;
						_tmp1382_ = _tmp1381_->delegate_target_cvalue;
						if (_tmp1382_ == NULL) {
							ValaGLibValue* _tmp1383_;
							ValaCCodeConstant* _tmp1384_;
							_tmp1383_ = arg_value;
							_tmp1384_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1383_->delegate_target_cvalue);
							_tmp1383_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1384_;
						}
						_tmp1385_ = arg_value;
						_tmp1386_ = _tmp1385_->delegate_target_destroy_notify_cvalue;
						if (_tmp1386_ == NULL) {
							ValaGLibValue* _tmp1387_;
							ValaCCodeConstant* _tmp1388_;
							_tmp1387_ = arg_value;
							_tmp1388_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1387_->delegate_target_destroy_notify_cvalue);
							_tmp1387_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1388_;
						}
					}
					_tmp1389_ = arg;
					_tmp1390_ = vala_get_cvalue (_tmp1389_);
					_tmp1391_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1390_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1391_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1392_;
					ValaCCodeExpression* _tmp1393_;
					ValaCCodeExpression* _tmp1394_;
					_tmp1392_ = arg;
					_tmp1393_ = cexpr;
					_tmp1394_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1392_, _tmp1393_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1394_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1397_ = param;
			if (_tmp1397_ != NULL) {
				_tmp1396_ = !ellipsis;
			} else {
				_tmp1396_ = FALSE;
			}
			if (_tmp1396_) {
				ValaParameter* _tmp1398_;
				_tmp1398_ = param;
				_tmp1395_ = vala_get_ccode_pos (_tmp1398_);
			} else {
				_tmp1395_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1395_, ellipsis);
			_tmp1399_ = carg_map;
			_tmp1400_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1399_, (gpointer) ((gintptr) arg_pos), _tmp1400_);
			_tmp1402_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1402_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1403_;
				ValaCodeContext* _tmp1404_;
				ValaProfile _tmp1405_;
				ValaProfile _tmp1406_;
				_tmp1403_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1404_ = _tmp1403_;
				_tmp1405_ = vala_code_context_get_profile (_tmp1404_);
				_tmp1406_ = _tmp1405_;
				_tmp1401_ = _tmp1406_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1401_ = FALSE;
			}
			if (_tmp1401_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1407_;
				ValaExpression* _tmp1408_;
				ValaExpression* _tmp1409_;
				ValaDataType* _tmp1410_;
				ValaDataType* _tmp1411_;
				ValaDataType* _tmp1412_;
				ValaDataType* _tmp1413_;
				gchar* _tmp1414_;
				gchar* _tmp1415_;
				gchar* _tmp1416_;
				gchar* _tmp1417_;
				ValaCCodeIdentifier* _tmp1418_;
				ValaCCodeIdentifier* _tmp1419_;
				ValaHashMap* _tmp1420_;
				ValaCCodeIdentifier* _tmp1421_;
				ValaCCodeExpression* _tmp1422_;
				ValaCCodeBinaryExpression* _tmp1423_;
				ValaCCodeBinaryExpression* _tmp1424_;
				_tmp1407_ = ma;
				_tmp1408_ = vala_member_access_get_inner (_tmp1407_);
				_tmp1409_ = _tmp1408_;
				_tmp1410_ = vala_expression_get_value_type (_tmp1409_);
				_tmp1411_ = _tmp1410_;
				_tmp1412_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1411_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1413_ = _tmp1412_;
				_tmp1414_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1413_);
				_tmp1415_ = _tmp1414_;
				_tmp1416_ = g_strdup_printf ("sizeof (%s)", _tmp1415_);
				_tmp1417_ = _tmp1416_;
				_tmp1418_ = vala_ccode_identifier_new (_tmp1417_);
				_tmp1419_ = _tmp1418_;
				_g_free0 (_tmp1417_);
				_g_free0 (_tmp1415_);
				csizeof = _tmp1419_;
				_tmp1420_ = carg_map;
				_tmp1421_ = csizeof;
				_tmp1422_ = cexpr;
				_tmp1423_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1421_, _tmp1422_);
				_tmp1424_ = _tmp1423_;
				vala_map_set ((ValaMap*) _tmp1420_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1424_);
				_vala_ccode_node_unref0 (_tmp1424_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1425_;
				ValaCCodeExpression* _tmp1426_;
				_tmp1425_ = carg_map;
				_tmp1426_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1425_, (gpointer) ((gintptr) arg_pos), _tmp1426_);
			}
			_tmp1428_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1428_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1427_ = ellipsis;
			} else {
				_tmp1427_ = FALSE;
			}
			if (_tmp1427_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1429_;
				ValaNamedArgument* _tmp1430_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1431_;
				const gchar* _tmp1432_;
				const gchar* _tmp1433_;
				gchar** _tmp1434_;
				gchar** _tmp1435_;
				gchar** _tmp1436_;
				gint _tmp1436__length1;
				gchar* _tmp1437_;
				gchar* _tmp1438_;
				ValaHashMap* _tmp1439_;
				const gchar* _tmp1440_;
				gchar* _tmp1441_;
				gchar* _tmp1442_;
				ValaCCodeConstant* _tmp1443_;
				ValaCCodeConstant* _tmp1444_;
				_tmp1429_ = arg;
				_tmp1430_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1429_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1430_;
				_tmp1431_ = named_arg;
				_tmp1432_ = vala_named_argument_get_name (_tmp1431_);
				_tmp1433_ = _tmp1432_;
				_tmp1435_ = _tmp1434_ = g_strsplit (_tmp1433_, "_", 0);
				_tmp1436_ = _tmp1435_;
				_tmp1436__length1 = _vala_array_length (_tmp1434_);
				_tmp1437_ = _vala_g_strjoinv ("-", _tmp1436_, (gint) _vala_array_length (_tmp1434_));
				_tmp1438_ = _tmp1437_;
				_tmp1436_ = (_vala_array_free (_tmp1436_, _tmp1436__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1438_;
				_tmp1439_ = carg_map;
				_tmp1440_ = name;
				_tmp1441_ = g_strdup_printf ("\"%s\"", _tmp1440_);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_ccode_constant_new (_tmp1442_);
				_tmp1444_ = _tmp1443_;
				vala_map_set ((ValaMap*) _tmp1439_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1444_);
				_vala_ccode_node_unref0 (_tmp1444_);
				_g_free0 (_tmp1442_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1445_ = i;
			i = _tmp1445_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1446_ = params_it;
	if (vala_iterator_next (_tmp1446_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1447_;
		gpointer _tmp1448_;
		gboolean _tmp1449_ = FALSE;
		ValaParameter* _tmp1450_;
		gboolean _tmp1451_;
		gboolean _tmp1452_;
		_tmp1447_ = params_it;
		_tmp1448_ = vala_iterator_get (_tmp1447_);
		param = (ValaParameter*) _tmp1448_;
		_tmp1450_ = param;
		_tmp1451_ = vala_parameter_get_params_array (_tmp1450_);
		_tmp1452_ = _tmp1451_;
		if (_tmp1452_) {
			_tmp1449_ = TRUE;
		} else {
			ValaParameter* _tmp1453_;
			gboolean _tmp1454_;
			gboolean _tmp1455_;
			_tmp1453_ = param;
			_tmp1454_ = vala_parameter_get_ellipsis (_tmp1453_);
			_tmp1455_ = _tmp1454_;
			_tmp1449_ = _tmp1455_;
		}
		_vala_assert (_tmp1449_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1458_ = m;
	if (_tmp1458_ != NULL) {
		ValaMethod* _tmp1459_;
		ValaDataType* _tmp1460_;
		ValaDataType* _tmp1461_;
		_tmp1459_ = m;
		_tmp1460_ = vala_callable_get_return_type ((ValaCallable*) _tmp1459_);
		_tmp1461_ = _tmp1460_;
		_tmp1457_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1461_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1457_ = FALSE;
	}
	if (_tmp1457_) {
		ValaCCodeFunctionCall* _tmp1462_;
		ValaCCodeFunctionCall* _tmp1463_;
		_tmp1462_ = async_call;
		_tmp1463_ = ccall;
		_tmp1456_ = _tmp1462_ != _tmp1463_;
	} else {
		_tmp1456_ = FALSE;
	}
	if (_tmp1456_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1464_;
		ValaDataType* _tmp1465_;
		ValaDataType* _tmp1466_;
		ValaArrayType* _tmp1467_;
		_tmp1464_ = m;
		_tmp1465_ = vala_callable_get_return_type ((ValaCallable*) _tmp1464_);
		_tmp1466_ = _tmp1465_;
		_tmp1467_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1466_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1467_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1468_ = FALSE;
				_tmp1468_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1470_;
					gint _tmp1471_;
					gint _tmp1472_;
					ValaMethod* _tmp1473_;
					if (!_tmp1468_) {
						gint _tmp1469_;
						_tmp1469_ = dim;
						dim = _tmp1469_ + 1;
					}
					_tmp1468_ = FALSE;
					_tmp1470_ = array_type;
					_tmp1471_ = vala_array_type_get_rank (_tmp1470_);
					_tmp1472_ = _tmp1471_;
					if (!(dim <= _tmp1472_)) {
						break;
					}
					_tmp1473_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1473_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1474_;
						ValaDataType* _tmp1475_;
						ValaLocalVariable* _tmp1476_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1477_;
						const gchar* _tmp1478_;
						const gchar* _tmp1479_;
						ValaCCodeExpression* _tmp1480_;
						ValaLocalVariable* _tmp1481_;
						ValaCCodeExpression* _tmp1482_;
						ValaCCodeExpression* _tmp1483_;
						ValaCCodeAssignment* _tmp1484_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1485_;
						ValaCCodeIdentifier* _tmp1486_;
						ValaCCodeFunctionCall* _tmp1487_;
						ValaCCodeFunctionCall* _tmp1488_;
						ValaCCodeFunctionCall* _tmp1489_;
						ValaCCodeExpression* _tmp1490_;
						ValaCCodeFunctionCall* _tmp1491_;
						_tmp1474_ = itype;
						_tmp1475_ = vala_data_type_get_return_type (_tmp1474_);
						_tmp1476_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1475_, TRUE, NULL, FALSE);
						temp_var = _tmp1476_;
						_tmp1477_ = temp_var;
						_tmp1478_ = vala_symbol_get_name ((ValaSymbol*) _tmp1477_);
						_tmp1479_ = _tmp1478_;
						_tmp1480_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1479_);
						temp_ref = _tmp1480_;
						_tmp1481_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1481_, FALSE);
						_tmp1482_ = temp_ref;
						_tmp1483_ = ccall_expr;
						_tmp1484_ = vala_ccode_assignment_new (_tmp1482_, _tmp1483_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1484_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1485_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1486_ = _tmp1485_;
						_tmp1487_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1486_);
						_tmp1488_ = _tmp1487_;
						_vala_ccode_node_unref0 (_tmp1486_);
						len_call = _tmp1488_;
						_tmp1489_ = len_call;
						_tmp1490_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1489_, _tmp1490_);
						_tmp1491_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1491_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1492_;
						_tmp1492_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1492_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1493_;
							gchar* _tmp1494_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1495_;
							ValaCType* _tmp1496_;
							ValaCType* _tmp1497_;
							ValaLocalVariable* _tmp1498_;
							ValaLocalVariable* _tmp1499_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1500_;
							const gchar* _tmp1501_;
							const gchar* _tmp1502_;
							ValaCCodeExpression* _tmp1503_;
							ValaLocalVariable* _tmp1504_;
							ValaHashMap* _tmp1505_;
							ValaMethod* _tmp1506_;
							ValaCCodeExpression* _tmp1507_;
							ValaCCodeUnaryExpression* _tmp1508_;
							ValaCCodeUnaryExpression* _tmp1509_;
							ValaCCodeExpression* _tmp1510_;
							_tmp1493_ = m;
							_tmp1494_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1493_);
							length_ctype = _tmp1494_;
							_tmp1495_ = length_ctype;
							_tmp1496_ = vala_ctype_new (_tmp1495_, "0");
							_tmp1497_ = _tmp1496_;
							_tmp1498_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1497_, TRUE, NULL, TRUE);
							_tmp1499_ = _tmp1498_;
							_vala_code_node_unref0 (_tmp1497_);
							temp_var = _tmp1499_;
							_tmp1500_ = temp_var;
							_tmp1501_ = vala_symbol_get_name ((ValaSymbol*) _tmp1500_);
							_tmp1502_ = _tmp1501_;
							_tmp1503_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1502_);
							temp_ref = _tmp1503_;
							_tmp1504_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1504_, FALSE);
							_tmp1505_ = out_arg_map;
							_tmp1506_ = m;
							_tmp1507_ = temp_ref;
							_tmp1508_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1507_);
							_tmp1509_ = _tmp1508_;
							vala_map_set ((ValaMap*) _tmp1505_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1506_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1509_);
							_vala_ccode_node_unref0 (_tmp1509_);
							_tmp1510_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1510_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1511_;
							gchar* _tmp1512_;
							gchar* _tmp1513_;
							gboolean _tmp1514_;
							_tmp1511_ = m;
							_tmp1512_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1511_);
							_tmp1513_ = _tmp1512_;
							_tmp1514_ = _tmp1513_ != NULL;
							_g_free0 (_tmp1513_);
							if (_tmp1514_) {
								ValaMethod* _tmp1515_;
								gchar* _tmp1516_;
								gchar* _tmp1517_;
								ValaCCodeConstant* _tmp1518_;
								ValaCCodeConstant* _tmp1519_;
								_tmp1515_ = m;
								_tmp1516_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1515_);
								_tmp1517_ = _tmp1516_;
								_tmp1518_ = vala_ccode_constant_new (_tmp1517_);
								_tmp1519_ = _tmp1518_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1519_);
								_vala_ccode_node_unref0 (_tmp1519_);
								_g_free0 (_tmp1517_);
							} else {
								ValaCCodeConstant* _tmp1520_;
								ValaCCodeConstant* _tmp1521_;
								_tmp1520_ = vala_ccode_constant_new ("-1");
								_tmp1521_ = _tmp1520_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1521_);
								_vala_ccode_node_unref0 (_tmp1521_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1522_ = FALSE;
		gboolean _tmp1523_ = FALSE;
		ValaMethod* _tmp1524_;
		_tmp1524_ = m;
		if (_tmp1524_ != NULL) {
			ValaMethod* _tmp1525_;
			ValaDataType* _tmp1526_;
			ValaDataType* _tmp1527_;
			_tmp1525_ = m;
			_tmp1526_ = vala_callable_get_return_type ((ValaCallable*) _tmp1525_);
			_tmp1527_ = _tmp1526_;
			_tmp1523_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1527_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1523_ = FALSE;
		}
		if (_tmp1523_) {
			ValaCCodeFunctionCall* _tmp1528_;
			ValaCCodeFunctionCall* _tmp1529_;
			_tmp1528_ = async_call;
			_tmp1529_ = ccall;
			_tmp1522_ = _tmp1528_ != _tmp1529_;
		} else {
			_tmp1522_ = FALSE;
		}
		if (_tmp1522_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1530_;
			ValaDataType* _tmp1531_;
			ValaDataType* _tmp1532_;
			ValaDelegateType* _tmp1533_;
			gboolean _tmp1534_ = FALSE;
			ValaMethod* _tmp1535_;
			_tmp1530_ = m;
			_tmp1531_ = vala_callable_get_return_type ((ValaCallable*) _tmp1530_);
			_tmp1532_ = _tmp1531_;
			_tmp1533_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1532_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1533_;
			_tmp1535_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1535_)) {
				ValaDelegateType* _tmp1536_;
				ValaDelegate* _tmp1537_;
				ValaDelegate* _tmp1538_;
				gboolean _tmp1539_;
				gboolean _tmp1540_;
				_tmp1536_ = deleg_type;
				_tmp1537_ = vala_delegate_type_get_delegate_symbol (_tmp1536_);
				_tmp1538_ = _tmp1537_;
				_tmp1539_ = vala_delegate_get_has_target (_tmp1538_);
				_tmp1540_ = _tmp1539_;
				_tmp1534_ = _tmp1540_;
			} else {
				_tmp1534_ = FALSE;
			}
			if (_tmp1534_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1541_;
				ValaLocalVariable* _tmp1542_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1543_;
				const gchar* _tmp1544_;
				const gchar* _tmp1545_;
				ValaCCodeExpression* _tmp1546_;
				ValaLocalVariable* _tmp1547_;
				ValaHashMap* _tmp1548_;
				ValaMethod* _tmp1549_;
				ValaCCodeExpression* _tmp1550_;
				ValaCCodeUnaryExpression* _tmp1551_;
				ValaCCodeUnaryExpression* _tmp1552_;
				ValaCCodeExpression* _tmp1553_;
				ValaDelegateType* _tmp1554_;
				_tmp1541_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1542_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1541_, TRUE, NULL, TRUE);
				temp_var = _tmp1542_;
				_tmp1543_ = temp_var;
				_tmp1544_ = vala_symbol_get_name ((ValaSymbol*) _tmp1543_);
				_tmp1545_ = _tmp1544_;
				_tmp1546_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1545_);
				temp_ref = _tmp1546_;
				_tmp1547_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1547_, FALSE);
				_tmp1548_ = out_arg_map;
				_tmp1549_ = m;
				_tmp1550_ = temp_ref;
				_tmp1551_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1550_);
				_tmp1552_ = _tmp1551_;
				vala_map_set ((ValaMap*) _tmp1548_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1549_), FALSE)), (ValaCCodeExpression*) _tmp1552_);
				_vala_ccode_node_unref0 (_tmp1552_);
				_tmp1553_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1553_);
				_tmp1554_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1554_)) {
					ValaDelegateType* _tmp1555_;
					ValaLocalVariable* _tmp1556_;
					ValaLocalVariable* _tmp1557_;
					const gchar* _tmp1558_;
					const gchar* _tmp1559_;
					ValaCCodeExpression* _tmp1560_;
					ValaLocalVariable* _tmp1561_;
					ValaHashMap* _tmp1562_;
					ValaMethod* _tmp1563_;
					ValaCCodeExpression* _tmp1564_;
					ValaCCodeUnaryExpression* _tmp1565_;
					ValaCCodeUnaryExpression* _tmp1566_;
					ValaCCodeExpression* _tmp1567_;
					_tmp1555_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1556_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1555_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1556_;
					_tmp1557_ = temp_var;
					_tmp1558_ = vala_symbol_get_name ((ValaSymbol*) _tmp1557_);
					_tmp1559_ = _tmp1558_;
					_tmp1560_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1559_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1560_;
					_tmp1561_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1561_, FALSE);
					_tmp1562_ = out_arg_map;
					_tmp1563_ = m;
					_tmp1564_ = temp_ref;
					_tmp1565_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1564_);
					_tmp1566_ = _tmp1565_;
					vala_map_set ((ValaMap*) _tmp1562_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1563_), FALSE)), (ValaCCodeExpression*) _tmp1566_);
					_vala_ccode_node_unref0 (_tmp1566_);
					_tmp1567_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1567_);
				} else {
					ValaCCodeConstant* _tmp1568_;
					ValaCCodeConstant* _tmp1569_;
					_tmp1568_ = vala_ccode_constant_new ("NULL");
					_tmp1569_ = _tmp1568_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1569_);
					_vala_ccode_node_unref0 (_tmp1569_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1570_;
				ValaCCodeConstant* _tmp1571_;
				ValaDelegateType* _tmp1572_;
				ValaDelegate* _tmp1573_;
				ValaDelegate* _tmp1574_;
				gboolean _tmp1575_;
				gboolean _tmp1576_;
				_tmp1570_ = vala_ccode_constant_new ("NULL");
				_tmp1571_ = _tmp1570_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1571_);
				_vala_ccode_node_unref0 (_tmp1571_);
				_tmp1572_ = deleg_type;
				_tmp1573_ = vala_delegate_type_get_delegate_symbol (_tmp1572_);
				_tmp1574_ = _tmp1573_;
				_tmp1575_ = vala_delegate_get_has_target (_tmp1574_);
				_tmp1576_ = _tmp1575_;
				if (_tmp1576_) {
					ValaCCodeConstant* _tmp1577_;
					ValaCCodeConstant* _tmp1578_;
					_tmp1577_ = vala_ccode_constant_new ("NULL");
					_tmp1578_ = _tmp1577_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1578_);
					_vala_ccode_node_unref0 (_tmp1578_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1580_ = deleg;
	if (_tmp1580_ != NULL) {
		ValaDelegate* _tmp1581_;
		ValaDataType* _tmp1582_;
		ValaDataType* _tmp1583_;
		_tmp1581_ = deleg;
		_tmp1582_ = vala_callable_get_return_type ((ValaCallable*) _tmp1581_);
		_tmp1583_ = _tmp1582_;
		_tmp1579_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1583_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1579_ = FALSE;
	}
	if (_tmp1579_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1584_;
		ValaDataType* _tmp1585_;
		ValaDataType* _tmp1586_;
		ValaArrayType* _tmp1587_;
		_tmp1584_ = deleg;
		_tmp1585_ = vala_callable_get_return_type ((ValaCallable*) _tmp1584_);
		_tmp1586_ = _tmp1585_;
		_tmp1587_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1586_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1587_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1588_ = FALSE;
				_tmp1588_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1590_;
					gint _tmp1591_;
					gint _tmp1592_;
					ValaDelegate* _tmp1593_;
					if (!_tmp1588_) {
						gint _tmp1589_;
						_tmp1589_ = dim;
						dim = _tmp1589_ + 1;
					}
					_tmp1588_ = FALSE;
					_tmp1590_ = array_type;
					_tmp1591_ = vala_array_type_get_rank (_tmp1590_);
					_tmp1592_ = _tmp1591_;
					if (!(dim <= _tmp1592_)) {
						break;
					}
					_tmp1593_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1593_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1594_;
						ValaDataType* _tmp1595_;
						ValaLocalVariable* _tmp1596_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1597_;
						const gchar* _tmp1598_;
						const gchar* _tmp1599_;
						ValaCCodeExpression* _tmp1600_;
						ValaLocalVariable* _tmp1601_;
						ValaCCodeExpression* _tmp1602_;
						ValaCCodeExpression* _tmp1603_;
						ValaCCodeAssignment* _tmp1604_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1605_;
						ValaCCodeIdentifier* _tmp1606_;
						ValaCCodeFunctionCall* _tmp1607_;
						ValaCCodeFunctionCall* _tmp1608_;
						ValaCCodeFunctionCall* _tmp1609_;
						ValaCCodeExpression* _tmp1610_;
						ValaCCodeFunctionCall* _tmp1611_;
						_tmp1594_ = itype;
						_tmp1595_ = vala_data_type_get_return_type (_tmp1594_);
						_tmp1596_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1595_, TRUE, NULL, FALSE);
						temp_var = _tmp1596_;
						_tmp1597_ = temp_var;
						_tmp1598_ = vala_symbol_get_name ((ValaSymbol*) _tmp1597_);
						_tmp1599_ = _tmp1598_;
						_tmp1600_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1599_);
						temp_ref = _tmp1600_;
						_tmp1601_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1601_, FALSE);
						_tmp1602_ = temp_ref;
						_tmp1603_ = ccall_expr;
						_tmp1604_ = vala_ccode_assignment_new (_tmp1602_, _tmp1603_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1604_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1605_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1606_ = _tmp1605_;
						_tmp1607_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1606_);
						_tmp1608_ = _tmp1607_;
						_vala_ccode_node_unref0 (_tmp1606_);
						len_call = _tmp1608_;
						_tmp1609_ = len_call;
						_tmp1610_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1609_, _tmp1610_);
						_tmp1611_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1611_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1612_;
						_tmp1612_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1612_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1613_;
							gchar* _tmp1614_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1615_;
							ValaCType* _tmp1616_;
							ValaCType* _tmp1617_;
							ValaLocalVariable* _tmp1618_;
							ValaLocalVariable* _tmp1619_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1620_;
							const gchar* _tmp1621_;
							const gchar* _tmp1622_;
							ValaCCodeExpression* _tmp1623_;
							ValaLocalVariable* _tmp1624_;
							ValaHashMap* _tmp1625_;
							ValaDelegate* _tmp1626_;
							ValaCCodeExpression* _tmp1627_;
							ValaCCodeUnaryExpression* _tmp1628_;
							ValaCCodeUnaryExpression* _tmp1629_;
							ValaCCodeExpression* _tmp1630_;
							_tmp1613_ = deleg;
							_tmp1614_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1613_);
							length_ctype = _tmp1614_;
							_tmp1615_ = length_ctype;
							_tmp1616_ = vala_ctype_new (_tmp1615_, "0");
							_tmp1617_ = _tmp1616_;
							_tmp1618_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1617_, TRUE, NULL, TRUE);
							_tmp1619_ = _tmp1618_;
							_vala_code_node_unref0 (_tmp1617_);
							temp_var = _tmp1619_;
							_tmp1620_ = temp_var;
							_tmp1621_ = vala_symbol_get_name ((ValaSymbol*) _tmp1620_);
							_tmp1622_ = _tmp1621_;
							_tmp1623_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1622_);
							temp_ref = _tmp1623_;
							_tmp1624_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1624_, FALSE);
							_tmp1625_ = out_arg_map;
							_tmp1626_ = deleg;
							_tmp1627_ = temp_ref;
							_tmp1628_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1627_);
							_tmp1629_ = _tmp1628_;
							vala_map_set ((ValaMap*) _tmp1625_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1626_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1629_);
							_vala_ccode_node_unref0 (_tmp1629_);
							_tmp1630_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1630_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1631_;
							ValaCCodeConstant* _tmp1632_;
							_tmp1631_ = vala_ccode_constant_new ("-1");
							_tmp1632_ = _tmp1631_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1632_);
							_vala_ccode_node_unref0 (_tmp1632_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1633_ = FALSE;
		gboolean _tmp1634_ = FALSE;
		ValaDelegate* _tmp1635_;
		_tmp1635_ = deleg;
		if (_tmp1635_ != NULL) {
			ValaDelegate* _tmp1636_;
			ValaDataType* _tmp1637_;
			ValaDataType* _tmp1638_;
			_tmp1636_ = deleg;
			_tmp1637_ = vala_callable_get_return_type ((ValaCallable*) _tmp1636_);
			_tmp1638_ = _tmp1637_;
			_tmp1634_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1638_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1634_ = FALSE;
		}
		if (_tmp1634_) {
			ValaDelegate* _tmp1639_;
			_tmp1639_ = deleg;
			_tmp1633_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1639_);
		} else {
			_tmp1633_ = FALSE;
		}
		if (_tmp1633_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1640_;
			ValaDataType* _tmp1641_;
			ValaDataType* _tmp1642_;
			ValaDelegateType* _tmp1643_;
			ValaDelegateType* _tmp1644_;
			ValaDelegate* _tmp1645_;
			ValaDelegate* _tmp1646_;
			gboolean _tmp1647_;
			gboolean _tmp1648_;
			_tmp1640_ = deleg;
			_tmp1641_ = vala_callable_get_return_type ((ValaCallable*) _tmp1640_);
			_tmp1642_ = _tmp1641_;
			_tmp1643_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1642_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1643_;
			_tmp1644_ = deleg_type;
			_tmp1645_ = vala_delegate_type_get_delegate_symbol (_tmp1644_);
			_tmp1646_ = _tmp1645_;
			_tmp1647_ = vala_delegate_get_has_target (_tmp1646_);
			_tmp1648_ = _tmp1647_;
			if (_tmp1648_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1649_;
				ValaLocalVariable* _tmp1650_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1651_;
				const gchar* _tmp1652_;
				const gchar* _tmp1653_;
				ValaCCodeExpression* _tmp1654_;
				ValaLocalVariable* _tmp1655_;
				ValaHashMap* _tmp1656_;
				ValaDelegate* _tmp1657_;
				ValaCCodeExpression* _tmp1658_;
				ValaCCodeUnaryExpression* _tmp1659_;
				ValaCCodeUnaryExpression* _tmp1660_;
				ValaCCodeExpression* _tmp1661_;
				ValaDelegateType* _tmp1662_;
				_tmp1649_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1650_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1649_, TRUE, NULL, TRUE);
				temp_var = _tmp1650_;
				_tmp1651_ = temp_var;
				_tmp1652_ = vala_symbol_get_name ((ValaSymbol*) _tmp1651_);
				_tmp1653_ = _tmp1652_;
				_tmp1654_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1653_);
				temp_ref = _tmp1654_;
				_tmp1655_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1655_, FALSE);
				_tmp1656_ = out_arg_map;
				_tmp1657_ = deleg;
				_tmp1658_ = temp_ref;
				_tmp1659_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1658_);
				_tmp1660_ = _tmp1659_;
				vala_map_set ((ValaMap*) _tmp1656_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1657_), FALSE)), (ValaCCodeExpression*) _tmp1660_);
				_vala_ccode_node_unref0 (_tmp1660_);
				_tmp1661_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1661_);
				_tmp1662_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1662_)) {
					ValaDelegateType* _tmp1663_;
					ValaLocalVariable* _tmp1664_;
					ValaLocalVariable* _tmp1665_;
					const gchar* _tmp1666_;
					const gchar* _tmp1667_;
					ValaCCodeExpression* _tmp1668_;
					ValaLocalVariable* _tmp1669_;
					ValaHashMap* _tmp1670_;
					ValaDelegate* _tmp1671_;
					ValaCCodeExpression* _tmp1672_;
					ValaCCodeUnaryExpression* _tmp1673_;
					ValaCCodeUnaryExpression* _tmp1674_;
					ValaCCodeExpression* _tmp1675_;
					_tmp1663_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1664_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1663_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1664_;
					_tmp1665_ = temp_var;
					_tmp1666_ = vala_symbol_get_name ((ValaSymbol*) _tmp1665_);
					_tmp1667_ = _tmp1666_;
					_tmp1668_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1667_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1668_;
					_tmp1669_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1669_, FALSE);
					_tmp1670_ = out_arg_map;
					_tmp1671_ = deleg;
					_tmp1672_ = temp_ref;
					_tmp1673_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1672_);
					_tmp1674_ = _tmp1673_;
					vala_map_set ((ValaMap*) _tmp1670_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1671_), FALSE)), (ValaCCodeExpression*) _tmp1674_);
					_vala_ccode_node_unref0 (_tmp1674_);
					_tmp1675_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1675_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1677_ = m;
	if (_tmp1677_ != NULL) {
		ValaMethod* _tmp1678_;
		gboolean _tmp1679_;
		gboolean _tmp1680_;
		_tmp1678_ = m;
		_tmp1679_ = vala_method_get_coroutine (_tmp1678_);
		_tmp1680_ = _tmp1679_;
		_tmp1676_ = _tmp1680_;
	} else {
		_tmp1676_ = FALSE;
	}
	if (_tmp1676_) {
		gboolean _tmp1681_;
		gboolean _tmp1682_;
		_tmp1681_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1682_ = _tmp1681_;
		if (_tmp1682_) {
			ValaHashMap* _tmp1683_;
			ValaMethod* _tmp1684_;
			ValaMethod* _tmp1685_;
			gchar* _tmp1686_;
			gchar* _tmp1687_;
			ValaCCodeIdentifier* _tmp1688_;
			ValaCCodeIdentifier* _tmp1689_;
			ValaHashMap* _tmp1690_;
			ValaCCodeIdentifier* _tmp1691_;
			ValaCCodeIdentifier* _tmp1692_;
			_tmp1683_ = in_arg_map;
			_tmp1684_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1685_ = _tmp1684_;
			_tmp1686_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1685_);
			_tmp1687_ = _tmp1686_;
			_tmp1688_ = vala_ccode_identifier_new (_tmp1687_);
			_tmp1689_ = _tmp1688_;
			vala_map_set ((ValaMap*) _tmp1683_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1689_);
			_vala_ccode_node_unref0 (_tmp1689_);
			_g_free0 (_tmp1687_);
			_tmp1690_ = in_arg_map;
			_tmp1691_ = vala_ccode_identifier_new ("_data_");
			_tmp1692_ = _tmp1691_;
			vala_map_set ((ValaMap*) _tmp1690_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1692_);
			_vala_ccode_node_unref0 (_tmp1692_);
		}
	}
	_tmp1693_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1694_ = _tmp1693_;
	if (_tmp1694_) {
		ValaCallable* _tmp1695_ = NULL;
		ValaMethod* _tmp1696_;
		ValaHashMap* _tmp1698_;
		ValaCCodeExpression* _tmp1699_;
		ValaCCodeExpression* _tmp1700_;
		ValaCCodeUnaryExpression* _tmp1701_;
		ValaCCodeUnaryExpression* _tmp1702_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1696_ = m;
		_tmp1695_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1696_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1695_ == NULL) {
			ValaDelegate* _tmp1697_;
			_tmp1697_ = deleg;
			_tmp1695_ = (ValaCallable*) _tmp1697_;
		}
		_tmp1698_ = out_arg_map;
		_tmp1699_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1700_ = _tmp1699_;
		_tmp1701_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1700_);
		_tmp1702_ = _tmp1701_;
		vala_map_set ((ValaMap*) _tmp1698_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1695_), FALSE)), (ValaCCodeExpression*) _tmp1702_);
		_vala_ccode_node_unref0 (_tmp1702_);
		_vala_ccode_node_unref0 (_tmp1700_);
	} else {
		gboolean _tmp1703_ = FALSE;
		gboolean _tmp1704_ = FALSE;
		ValaMethod* _tmp1705_;
		_tmp1705_ = m;
		if (_tmp1705_ != NULL) {
			ValaMethod* _tmp1706_;
			_tmp1706_ = m;
			_tmp1704_ = vala_method_has_error_type_parameter (_tmp1706_);
		} else {
			_tmp1704_ = FALSE;
		}
		if (_tmp1704_) {
			ValaCCodeFunctionCall* _tmp1707_;
			ValaCCodeFunctionCall* _tmp1708_;
			_tmp1707_ = async_call;
			_tmp1708_ = ccall;
			_tmp1703_ = _tmp1707_ != _tmp1708_;
		} else {
			_tmp1703_ = FALSE;
		}
		if (_tmp1703_) {
			ValaHashMap* _tmp1709_;
			ValaMethod* _tmp1710_;
			ValaCCodeConstant* _tmp1711_;
			ValaCCodeConstant* _tmp1712_;
			_tmp1709_ = out_arg_map;
			_tmp1710_ = m;
			_tmp1711_ = vala_ccode_constant_new ("NULL");
			_tmp1712_ = _tmp1711_;
			vala_map_set ((ValaMap*) _tmp1709_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1710_), FALSE)), (ValaCCodeExpression*) _tmp1712_);
			_vala_ccode_node_unref0 (_tmp1712_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1713_;
		_tmp1713_ = m;
		if (_tmp1713_ == NULL) {
			ValaHashMap* _tmp1714_;
			ValaCCodeConstant* _tmp1715_;
			ValaCCodeConstant* _tmp1716_;
			_tmp1714_ = in_arg_map;
			_tmp1715_ = vala_ccode_constant_new ("NULL");
			_tmp1716_ = _tmp1715_;
			vala_map_set ((ValaMap*) _tmp1714_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1716_);
			_vala_ccode_node_unref0 (_tmp1716_);
		} else {
			gboolean _tmp1717_ = FALSE;
			gboolean _tmp1718_ = FALSE;
			gboolean _tmp1719_ = FALSE;
			ValaMethod* _tmp1720_;
			gboolean _tmp1721_;
			gboolean _tmp1722_;
			_tmp1720_ = m;
			_tmp1721_ = vala_method_get_printf_format (_tmp1720_);
			_tmp1722_ = _tmp1721_;
			if (!_tmp1722_) {
				ValaMethod* _tmp1723_;
				gboolean _tmp1724_;
				gboolean _tmp1725_;
				_tmp1723_ = m;
				_tmp1724_ = vala_method_get_scanf_format (_tmp1723_);
				_tmp1725_ = _tmp1724_;
				_tmp1719_ = !_tmp1725_;
			} else {
				_tmp1719_ = FALSE;
			}
			if (_tmp1719_) {
				ValaMethod* _tmp1726_;
				gchar* _tmp1727_;
				gchar* _tmp1728_;
				_tmp1726_ = m;
				_tmp1727_ = vala_get_ccode_sentinel (_tmp1726_);
				_tmp1728_ = _tmp1727_;
				_tmp1718_ = g_strcmp0 (_tmp1728_, "") != 0;
				_g_free0 (_tmp1728_);
			} else {
				_tmp1718_ = FALSE;
			}
			if (_tmp1718_) {
				gboolean _tmp1729_;
				gboolean _tmp1730_;
				_tmp1729_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1730_ = _tmp1729_;
				_tmp1717_ = !_tmp1730_;
			} else {
				_tmp1717_ = FALSE;
			}
			if (_tmp1717_) {
				ValaHashMap* _tmp1731_;
				ValaMethod* _tmp1732_;
				gchar* _tmp1733_;
				gchar* _tmp1734_;
				ValaCCodeConstant* _tmp1735_;
				ValaCCodeConstant* _tmp1736_;
				_tmp1731_ = in_arg_map;
				_tmp1732_ = m;
				_tmp1733_ = vala_get_ccode_sentinel (_tmp1732_);
				_tmp1734_ = _tmp1733_;
				_tmp1735_ = vala_ccode_constant_new (_tmp1734_);
				_tmp1736_ = _tmp1735_;
				vala_map_set ((ValaMap*) _tmp1731_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1736_);
				_vala_ccode_node_unref0 (_tmp1736_);
				_g_free0 (_tmp1734_);
			}
		}
	}
	_tmp1738_ = deleg;
	if (_tmp1738_ != NULL) {
		ValaDelegate* _tmp1739_;
		gboolean _tmp1740_;
		gboolean _tmp1741_;
		_tmp1739_ = deleg;
		_tmp1740_ = vala_delegate_get_has_target (_tmp1739_);
		_tmp1741_ = _tmp1740_;
		_tmp1737_ = _tmp1741_;
	} else {
		_tmp1737_ = FALSE;
	}
	if (_tmp1737_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1742_;
		ValaDelegate* _tmp1743_;
		ValaExpression* _tmp1744_;
		ValaExpression* _tmp1745_;
		ValaCCodeExpression* _tmp1746_ = NULL;
		ValaCCodeExpression* _tmp1747_;
		ValaCCodeExpression* _tmp1748_;
		ValaHashMap* _tmp1749_;
		ValaDelegate* _tmp1750_;
		ValaExpression* _tmp1751_;
		ValaExpression* _tmp1752_;
		ValaCCodeExpression* _tmp1753_ = NULL;
		ValaCCodeExpression* _tmp1754_;
		ValaCCodeExpression* _tmp1755_;
		_tmp1742_ = in_arg_map;
		_tmp1743_ = deleg;
		_tmp1744_ = vala_method_call_get_call (expr);
		_tmp1745_ = _tmp1744_;
		_tmp1747_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1745_, &_tmp1746_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1746_;
		_tmp1748_ = _tmp1747_;
		vala_map_set ((ValaMap*) _tmp1742_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1743_), FALSE)), _tmp1748_);
		_vala_ccode_node_unref0 (_tmp1748_);
		_tmp1749_ = out_arg_map;
		_tmp1750_ = deleg;
		_tmp1751_ = vala_method_call_get_call (expr);
		_tmp1752_ = _tmp1751_;
		_tmp1754_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1752_, &_tmp1753_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1753_;
		_tmp1755_ = _tmp1754_;
		vala_map_set ((ValaMap*) _tmp1749_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1750_), FALSE)), _tmp1755_);
		_vala_ccode_node_unref0 (_tmp1755_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1756_ = itype;
	_tmp1757_ = vala_data_type_get_return_type (_tmp1756_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1757_);
	_tmp1759_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1759_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1760_;
		ValaDataType* _tmp1761_;
		_tmp1760_ = itype;
		_tmp1761_ = vala_data_type_get_return_type (_tmp1760_);
		_tmp1758_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1761_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1758_ = FALSE;
	}
	if (_tmp1758_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1762_;
		ValaSignal* _tmp1763_;
		ValaSignal* _tmp1764_;
		ValaSignal* _tmp1765_;
		gboolean _tmp1766_ = FALSE;
		gboolean _tmp1767_ = FALSE;
		ValaMemberAccess* _tmp1768_;
		_tmp1762_ = itype;
		_tmp1763_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1762_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1764_ = _tmp1763_;
		_tmp1765_ = _vala_code_node_ref0 (_tmp1764_);
		sig = _tmp1765_;
		_tmp1768_ = ma;
		if (_tmp1768_ != NULL) {
			ValaMemberAccess* _tmp1769_;
			ValaExpression* _tmp1770_;
			ValaExpression* _tmp1771_;
			_tmp1769_ = ma;
			_tmp1770_ = vala_member_access_get_inner (_tmp1769_);
			_tmp1771_ = _tmp1770_;
			_tmp1767_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1771_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1767_ = FALSE;
		}
		if (_tmp1767_) {
			ValaSignal* _tmp1772_;
			gboolean _tmp1773_;
			gboolean _tmp1774_;
			_tmp1772_ = sig;
			_tmp1773_ = vala_signal_get_is_virtual (_tmp1772_);
			_tmp1774_ = _tmp1773_;
			_tmp1766_ = _tmp1774_;
		} else {
			_tmp1766_ = FALSE;
		}
		if (_tmp1766_) {
		} else {
			gboolean _tmp1775_ = FALSE;
			ValaSignal* _tmp1776_;
			_tmp1776_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1776_)) {
				_tmp1775_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1777_;
				ValaSourceReference* _tmp1778_;
				ValaSourceReference* _tmp1779_;
				ValaSourceFile* _tmp1780_;
				ValaSourceFile* _tmp1781_;
				ValaSignal* _tmp1782_;
				ValaSourceReference* _tmp1783_;
				ValaSourceReference* _tmp1784_;
				ValaSourceFile* _tmp1785_;
				ValaSourceFile* _tmp1786_;
				_tmp1777_ = ma;
				_tmp1778_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1777_);
				_tmp1779_ = _tmp1778_;
				_tmp1780_ = vala_source_reference_get_file (_tmp1779_);
				_tmp1781_ = _tmp1780_;
				_tmp1782_ = sig;
				_tmp1783_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1782_);
				_tmp1784_ = _tmp1783_;
				_tmp1785_ = vala_source_reference_get_file (_tmp1784_);
				_tmp1786_ = _tmp1785_;
				_tmp1775_ = _tmp1781_ == _tmp1786_;
			}
			if (_tmp1775_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1787_ = async_call;
	_tmp1788_ = ccall;
	if (_tmp1787_ == _tmp1788_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1789_;
		ValaDataType* _tmp1790_;
		ValaLocalVariable* _tmp1791_;
		ValaLocalVariable* _tmp1792_;
		const gchar* _tmp1793_;
		const gchar* _tmp1794_;
		ValaCCodeExpression* _tmp1795_;
		ValaLocalVariable* _tmp1796_;
		ValaHashMap* _tmp1797_;
		ValaCCodeExpression* _tmp1798_;
		ValaCCodeUnaryExpression* _tmp1799_;
		ValaCCodeUnaryExpression* _tmp1800_;
		_tmp1789_ = itype;
		_tmp1790_ = vala_data_type_get_return_type (_tmp1789_);
		_tmp1791_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1790_, TRUE, NULL, TRUE);
		out_param_var = _tmp1791_;
		_tmp1792_ = out_param_var;
		_tmp1793_ = vala_symbol_get_name ((ValaSymbol*) _tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1794_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1795_;
		_tmp1796_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1796_, FALSE);
		_tmp1797_ = out_arg_map;
		_tmp1798_ = out_param_ref;
		_tmp1799_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1798_);
		_tmp1800_ = _tmp1799_;
		vala_map_set ((ValaMap*) _tmp1797_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1800_);
		_vala_ccode_node_unref0 (_tmp1800_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1801_ = async_call;
	_tmp1802_ = ccall;
	if (_tmp1801_ != _tmp1802_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1813_;
			ValaHashMap* _tmp1814_;
			gpointer _tmp1815_;
			ValaCCodeExpression* _tmp1816_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1803_;
				ValaSet* _tmp1804_;
				ValaSet* _tmp1805_;
				ValaIterator* _tmp1806_;
				ValaIterator* _tmp1807_;
				_tmp1803_ = out_arg_map;
				_tmp1804_ = vala_map_get_keys ((ValaMap*) _tmp1803_);
				_tmp1805_ = _tmp1804_;
				_tmp1806_ = vala_iterable_iterator ((ValaIterable*) _tmp1805_);
				_tmp1807_ = _tmp1806_;
				_vala_iterable_unref0 (_tmp1805_);
				_pos_it = _tmp1807_;
				while (TRUE) {
					ValaIterator* _tmp1808_;
					gint pos = 0;
					ValaIterator* _tmp1809_;
					gpointer _tmp1810_;
					gboolean _tmp1811_ = FALSE;
					_tmp1808_ = _pos_it;
					if (!vala_iterator_next (_tmp1808_)) {
						break;
					}
					_tmp1809_ = _pos_it;
					_tmp1810_ = vala_iterator_get (_tmp1809_);
					pos = (gint) ((gintptr) _tmp1810_);
					if (pos > last_pos) {
						gboolean _tmp1812_ = FALSE;
						if (min_pos == -1) {
							_tmp1812_ = TRUE;
						} else {
							_tmp1812_ = pos < min_pos;
						}
						_tmp1811_ = _tmp1812_;
					} else {
						_tmp1811_ = FALSE;
					}
					if (_tmp1811_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1813_ = ccall;
			_tmp1814_ = out_arg_map;
			_tmp1815_ = vala_map_get ((ValaMap*) _tmp1814_, (gpointer) ((gintptr) min_pos));
			_tmp1816_ = (ValaCCodeExpression*) _tmp1815_;
			vala_ccode_function_call_add_argument (_tmp1813_, _tmp1816_);
			_vala_ccode_node_unref0 (_tmp1816_);
			last_pos = min_pos;
		}
	}
	_tmp1817_ = async_call;
	if (_tmp1817_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1828_;
			ValaHashMap* _tmp1829_;
			gpointer _tmp1830_;
			ValaCCodeExpression* _tmp1831_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1818_;
				ValaSet* _tmp1819_;
				ValaSet* _tmp1820_;
				ValaIterator* _tmp1821_;
				ValaIterator* _tmp1822_;
				_tmp1818_ = in_arg_map;
				_tmp1819_ = vala_map_get_keys ((ValaMap*) _tmp1818_);
				_tmp1820_ = _tmp1819_;
				_tmp1821_ = vala_iterable_iterator ((ValaIterable*) _tmp1820_);
				_tmp1822_ = _tmp1821_;
				_vala_iterable_unref0 (_tmp1820_);
				_pos_it = _tmp1822_;
				while (TRUE) {
					ValaIterator* _tmp1823_;
					gint pos = 0;
					ValaIterator* _tmp1824_;
					gpointer _tmp1825_;
					gboolean _tmp1826_ = FALSE;
					_tmp1823_ = _pos_it;
					if (!vala_iterator_next (_tmp1823_)) {
						break;
					}
					_tmp1824_ = _pos_it;
					_tmp1825_ = vala_iterator_get (_tmp1824_);
					pos = (gint) ((gintptr) _tmp1825_);
					if (pos > last_pos) {
						gboolean _tmp1827_ = FALSE;
						if (min_pos == -1) {
							_tmp1827_ = TRUE;
						} else {
							_tmp1827_ = pos < min_pos;
						}
						_tmp1826_ = _tmp1827_;
					} else {
						_tmp1826_ = FALSE;
					}
					if (_tmp1826_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1828_ = async_call;
			_tmp1829_ = in_arg_map;
			_tmp1830_ = vala_map_get ((ValaMap*) _tmp1829_, (gpointer) ((gintptr) min_pos));
			_tmp1831_ = (ValaCCodeExpression*) _tmp1830_;
			vala_ccode_function_call_add_argument (_tmp1828_, _tmp1831_);
			_vala_ccode_node_unref0 (_tmp1831_);
			last_pos = min_pos;
		}
	}
	_tmp1832_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1833_ = _tmp1832_;
	if (_tmp1833_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1834_;
		gint _tmp1835_;
		ValaCCodeFunction* _tmp1836_;
		ValaCCodeFunction* _tmp1837_;
		ValaCCodeIdentifier* _tmp1838_;
		ValaCCodeIdentifier* _tmp1839_;
		ValaCCodeMemberAccess* _tmp1840_;
		ValaCCodeMemberAccess* _tmp1841_;
		gchar* _tmp1842_;
		gchar* _tmp1843_;
		ValaCCodeConstant* _tmp1844_;
		ValaCCodeConstant* _tmp1845_;
		ValaCCodeFunction* _tmp1846_;
		ValaCCodeFunction* _tmp1847_;
		ValaCCodeFunctionCall* _tmp1848_;
		ValaCCodeFunction* _tmp1849_;
		ValaCCodeFunction* _tmp1850_;
		ValaCCodeConstant* _tmp1851_;
		ValaCCodeConstant* _tmp1852_;
		ValaCCodeFunction* _tmp1853_;
		ValaCCodeFunction* _tmp1854_;
		gchar* _tmp1855_;
		gchar* _tmp1856_;
		_tmp1834_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1835_ = _tmp1834_->next_coroutine_state;
		_tmp1834_->next_coroutine_state = _tmp1835_ + 1;
		state = _tmp1835_;
		_tmp1836_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1837_ = _tmp1836_;
		_tmp1838_ = vala_ccode_identifier_new ("_data_");
		_tmp1839_ = _tmp1838_;
		_tmp1840_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1839_, "_state_");
		_tmp1841_ = _tmp1840_;
		_tmp1842_ = g_strdup_printf ("%i", state);
		_tmp1843_ = _tmp1842_;
		_tmp1844_ = vala_ccode_constant_new (_tmp1843_);
		_tmp1845_ = _tmp1844_;
		vala_ccode_function_add_assignment (_tmp1837_, (ValaCCodeExpression*) _tmp1841_, (ValaCCodeExpression*) _tmp1845_);
		_vala_ccode_node_unref0 (_tmp1845_);
		_g_free0 (_tmp1843_);
		_vala_ccode_node_unref0 (_tmp1841_);
		_vala_ccode_node_unref0 (_tmp1839_);
		_tmp1846_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = async_call;
		vala_ccode_function_add_expression (_tmp1847_, (ValaCCodeExpression*) _tmp1848_);
		_tmp1849_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1850_ = _tmp1849_;
		_tmp1851_ = vala_ccode_constant_new ("FALSE");
		_tmp1852_ = _tmp1851_;
		vala_ccode_function_add_return (_tmp1850_, (ValaCCodeExpression*) _tmp1852_);
		_vala_ccode_node_unref0 (_tmp1852_);
		_tmp1853_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = g_strdup_printf ("_state_%d", state);
		_tmp1856_ = _tmp1855_;
		vala_ccode_function_add_label (_tmp1854_, _tmp1856_);
		_g_free0 (_tmp1856_);
	}
	_tmp1857_ = vala_method_call_get_is_assert (expr);
	_tmp1858_ = _tmp1857_;
	if (_tmp1858_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1859_;
		ValaSourceReference* _tmp1860_;
		ValaSourceLocation _tmp1861_ = {0};
		ValaSourceLocation _tmp1862_;
		gchar* _tmp1863_;
		ValaSourceReference* _tmp1864_;
		ValaSourceReference* _tmp1865_;
		ValaSourceLocation _tmp1866_ = {0};
		ValaSourceLocation _tmp1867_;
		gchar* _tmp1868_;
		ValaSourceReference* _tmp1869_;
		ValaSourceReference* _tmp1870_;
		ValaSourceLocation _tmp1871_ = {0};
		ValaSourceLocation _tmp1872_;
		gchar* _tmp1873_;
		gchar* _tmp1874_;
		ValaCCodeFunctionCall* _tmp1875_;
		ValaCCodeIdentifier* _tmp1876_;
		ValaCCodeIdentifier* _tmp1877_;
		ValaCCodeFunctionCall* _tmp1878_;
		const gchar* _tmp1879_;
		gchar* _tmp1880_;
		gchar* _tmp1881_;
		gchar* _tmp1882_;
		gchar* _tmp1883_;
		gchar* _tmp1884_;
		gchar* _tmp1885_;
		ValaCCodeConstant* _tmp1886_;
		ValaCCodeConstant* _tmp1887_;
		_tmp1859_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1860_ = _tmp1859_;
		vala_source_reference_get_begin (_tmp1860_, &_tmp1861_);
		_tmp1862_ = _tmp1861_;
		_tmp1863_ = _tmp1862_.pos;
		_tmp1864_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1865_ = _tmp1864_;
		vala_source_reference_get_end (_tmp1865_, &_tmp1866_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = _tmp1867_.pos;
		_tmp1869_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1870_ = _tmp1869_;
		vala_source_reference_get_begin (_tmp1870_, &_tmp1871_);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = _tmp1872_.pos;
		_tmp1874_ = string_substring ((const gchar*) _tmp1863_, (glong) 0, (glong) ((gint) (_tmp1868_ - _tmp1873_)));
		message = _tmp1874_;
		_tmp1875_ = ccall;
		_tmp1876_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1877_ = _tmp1876_;
		vala_ccode_function_call_set_call (_tmp1875_, (ValaCCodeExpression*) _tmp1877_);
		_vala_ccode_node_unref0 (_tmp1877_);
		_tmp1878_ = ccall;
		_tmp1879_ = message;
		_tmp1880_ = string_replace (_tmp1879_, "\n", " ");
		_tmp1881_ = _tmp1880_;
		_tmp1882_ = g_strescape (_tmp1881_, "");
		_tmp1883_ = _tmp1882_;
		_tmp1884_ = g_strdup_printf ("\"%s\"", _tmp1883_);
		_tmp1885_ = _tmp1884_;
		_tmp1886_ = vala_ccode_constant_new (_tmp1885_);
		_tmp1887_ = _tmp1886_;
		vala_ccode_function_call_add_argument (_tmp1878_, (ValaCCodeExpression*) _tmp1887_);
		_vala_ccode_node_unref0 (_tmp1887_);
		_g_free0 (_tmp1885_);
		_g_free0 (_tmp1883_);
		_g_free0 (_tmp1881_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1888_;
		ValaCCodeFunction* _tmp1889_;
		ValaCCodeExpression* _tmp1890_;
		ValaCCodeExpression* _tmp1891_;
		ValaCCodeExpression* _tmp1892_;
		_tmp1888_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1889_ = _tmp1888_;
		_tmp1890_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1889_, _tmp1890_);
		_tmp1891_ = out_param_ref;
		_tmp1892_ = _vala_ccode_node_ref0 (_tmp1891_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1892_;
	}
	_tmp1895_ = m;
	if (_tmp1895_ != NULL) {
		ValaMethod* _tmp1896_;
		ValaMemberBinding _tmp1897_;
		ValaMemberBinding _tmp1898_;
		_tmp1896_ = m;
		_tmp1897_ = vala_method_get_binding (_tmp1896_);
		_tmp1898_ = _tmp1897_;
		_tmp1894_ = _tmp1898_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1894_ = FALSE;
	}
	if (_tmp1894_) {
		ValaMethod* _tmp1899_;
		gboolean _tmp1900_;
		gboolean _tmp1901_;
		_tmp1899_ = m;
		_tmp1900_ = vala_method_get_returns_modified_pointer (_tmp1899_);
		_tmp1901_ = _tmp1900_;
		_tmp1893_ = _tmp1901_;
	} else {
		_tmp1893_ = FALSE;
	}
	if (_tmp1893_) {
		gboolean _tmp1902_ = FALSE;
		gboolean _tmp1903_ = FALSE;
		ValaMemberAccess* _tmp1904_;
		_tmp1904_ = ma;
		if (_tmp1904_ != NULL) {
			ValaMemberAccess* _tmp1905_;
			ValaExpression* _tmp1906_;
			ValaExpression* _tmp1907_;
			ValaSymbol* _tmp1908_;
			ValaSymbol* _tmp1909_;
			_tmp1905_ = ma;
			_tmp1906_ = vala_member_access_get_inner (_tmp1905_);
			_tmp1907_ = _tmp1906_;
			_tmp1908_ = vala_expression_get_symbol_reference (_tmp1907_);
			_tmp1909_ = _tmp1908_;
			_tmp1903_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1909_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1903_ = FALSE;
		}
		if (_tmp1903_) {
			ValaMemberAccess* _tmp1910_;
			ValaExpression* _tmp1911_;
			ValaExpression* _tmp1912_;
			_tmp1910_ = ma;
			_tmp1911_ = vala_member_access_get_inner (_tmp1910_);
			_tmp1912_ = _tmp1911_;
			_tmp1902_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1912_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1902_ = FALSE;
		}
		if (_tmp1902_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1913_;
			ValaExpression* _tmp1914_;
			ValaExpression* _tmp1915_;
			ValaSymbol* _tmp1916_;
			ValaSymbol* _tmp1917_;
			ValaProperty* _tmp1918_;
			ValaProperty* _tmp1919_;
			ValaMemberAccess* _tmp1920_;
			ValaExpression* _tmp1921_;
			ValaExpression* _tmp1922_;
			ValaExpression* _tmp1923_;
			ValaExpression* _tmp1924_;
			ValaDataType* _tmp1925_;
			ValaDataType* _tmp1926_;
			ValaCCodeExpression* _tmp1927_;
			ValaGLibValue* _tmp1928_;
			ValaGLibValue* _tmp1929_;
			_tmp1913_ = ma;
			_tmp1914_ = vala_member_access_get_inner (_tmp1913_);
			_tmp1915_ = _tmp1914_;
			_tmp1916_ = vala_expression_get_symbol_reference (_tmp1915_);
			_tmp1917_ = _tmp1916_;
			_tmp1918_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1917_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1918_;
			_tmp1919_ = prop;
			_tmp1920_ = ma;
			_tmp1921_ = vala_member_access_get_inner (_tmp1920_);
			_tmp1922_ = _tmp1921_;
			_tmp1923_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1922_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1924_ = _tmp1923_;
			_tmp1925_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1926_ = _tmp1925_;
			_tmp1927_ = ccall_expr;
			_tmp1928_ = vala_glib_value_new (_tmp1926_, _tmp1927_, FALSE);
			_tmp1929_ = _tmp1928_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1919_, _tmp1924_, (ValaTargetValue*) _tmp1929_);
			_vala_target_value_unref0 (_tmp1929_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1930_;
			ValaCCodeExpression* _tmp1931_;
			ValaCCodeAssignment* _tmp1932_;
			_tmp1930_ = instance;
			_tmp1931_ = ccall_expr;
			_tmp1932_ = vala_ccode_assignment_new (_tmp1930_, _tmp1931_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1932_;
		}
	}
	_tmp1938_ = m;
	if (_tmp1938_ != NULL) {
		ValaMethod* _tmp1939_;
		_tmp1939_ = m;
		_tmp1937_ = vala_get_ccode_simple_generics (_tmp1939_);
	} else {
		_tmp1937_ = FALSE;
	}
	if (_tmp1937_) {
		ValaMethod* _tmp1940_;
		ValaDataType* _tmp1941_;
		ValaDataType* _tmp1942_;
		_tmp1940_ = m;
		_tmp1941_ = vala_callable_get_return_type ((ValaCallable*) _tmp1940_);
		_tmp1942_ = _tmp1941_;
		_tmp1936_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1942_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1936_ = FALSE;
	}
	if (_tmp1936_) {
		ValaDataType* _tmp1943_;
		ValaDataType* _tmp1944_;
		_tmp1943_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1944_ = _tmp1943_;
		_tmp1935_ = vala_data_type_is_real_struct_type (_tmp1944_);
	} else {
		_tmp1935_ = FALSE;
	}
	if (_tmp1935_) {
		ValaDataType* _tmp1945_;
		ValaDataType* _tmp1946_;
		gboolean _tmp1947_;
		gboolean _tmp1948_;
		_tmp1945_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1946_ = _tmp1945_;
		_tmp1947_ = vala_data_type_get_nullable (_tmp1946_);
		_tmp1948_ = _tmp1947_;
		_tmp1934_ = !_tmp1948_;
	} else {
		_tmp1934_ = FALSE;
	}
	if (_tmp1934_) {
		ValaDataType* _tmp1949_;
		ValaDataType* _tmp1950_;
		_tmp1949_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1950_ = _tmp1949_;
		_tmp1933_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1950_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1933_ = FALSE;
	}
	if (_tmp1933_) {
		ValaCCodeExpression* _tmp1951_;
		ValaCCodeParenthesizedExpression* _tmp1952_;
		ValaCCodeParenthesizedExpression* _tmp1953_;
		ValaCCodeUnaryExpression* _tmp1954_;
		_tmp1951_ = ccall_expr;
		_tmp1952_ = vala_ccode_parenthesized_expression_new (_tmp1951_);
		_tmp1953_ = _tmp1952_;
		_tmp1954_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1953_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1954_;
		_vala_ccode_node_unref0 (_tmp1953_);
	}
	_tmp1957_ = m;
	if (_tmp1957_ != NULL) {
		ValaMethod* _tmp1958_;
		gchar* _tmp1959_;
		gchar* _tmp1960_;
		_tmp1958_ = m;
		_tmp1959_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1958_);
		_tmp1960_ = _tmp1959_;
		_tmp1956_ = _tmp1960_ != NULL;
		_g_free0 (_tmp1960_);
	} else {
		_tmp1956_ = FALSE;
	}
	if (_tmp1956_) {
		ValaMethod* _tmp1961_;
		gchar* _tmp1962_;
		gchar* _tmp1963_;
		ValaMethod* _tmp1964_;
		ValaDataType* _tmp1965_;
		ValaDataType* _tmp1966_;
		gchar* _tmp1967_;
		gchar* _tmp1968_;
		_tmp1961_ = m;
		_tmp1962_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1961_);
		_tmp1963_ = _tmp1962_;
		_tmp1964_ = m;
		_tmp1965_ = vala_callable_get_return_type ((ValaCallable*) _tmp1964_);
		_tmp1966_ = _tmp1965_;
		_tmp1967_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1966_);
		_tmp1968_ = _tmp1967_;
		_tmp1955_ = g_strcmp0 (_tmp1963_, _tmp1968_) != 0;
		_g_free0 (_tmp1968_);
		_g_free0 (_tmp1963_);
	} else {
		_tmp1955_ = FALSE;
	}
	if (_tmp1955_) {
		ValaCCodeExpression* _tmp1969_;
		ValaMethod* _tmp1970_;
		ValaDataType* _tmp1971_;
		ValaDataType* _tmp1972_;
		gchar* _tmp1973_;
		gchar* _tmp1974_;
		ValaCCodeCastExpression* _tmp1975_;
		_tmp1969_ = ccall_expr;
		_tmp1970_ = m;
		_tmp1971_ = vala_callable_get_return_type ((ValaCallable*) _tmp1970_);
		_tmp1972_ = _tmp1971_;
		_tmp1973_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1972_);
		_tmp1974_ = _tmp1973_;
		_tmp1975_ = vala_ccode_cast_expression_new (_tmp1969_, _tmp1974_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1975_;
		_g_free0 (_tmp1974_);
	}
	_tmp1976_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1976_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1977_;
		ValaIterator* _tmp1978_;
		ValaIterator* _tmp1979_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1980_;
		gpointer _tmp1981_;
		ValaExpression* _tmp1982_;
		ValaCCodeExpression* _tmp1983_;
		ValaCCodeExpression* _tmp1984_;
		ValaCCodeExpression* _tmp1985_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1986_;
		ValaLocalVariable* _tmp1987_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1988_;
		const gchar* _tmp1989_;
		const gchar* _tmp1990_;
		ValaCCodeExpression* _tmp1991_;
		ValaLocalVariable* _tmp1992_;
		ValaCCodeFile* _tmp1993_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1994_;
		ValaExpression* _tmp1995_;
		ValaExpression* _tmp1996_;
		ValaCCodeExpression* _tmp1997_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1998_;
		ValaExpression* _tmp1999_;
		ValaExpression* _tmp2000_;
		ValaCCodeExpression* _tmp2001_;
		ValaCCodeExpression* _tmp2002_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp2003_;
		ValaExpression* _tmp2004_;
		ValaExpression* _tmp2005_;
		ValaDataType* _tmp2006_;
		ValaDataType* _tmp2007_;
		ValaArrayType* _tmp2008_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp2009_;
		ValaDataType* _tmp2010_;
		ValaDataType* _tmp2011_;
		gchar* _tmp2012_;
		gchar* _tmp2013_;
		gchar* _tmp2014_;
		gchar* _tmp2015_;
		ValaCCodeIdentifier* _tmp2016_;
		ValaCCodeIdentifier* _tmp2017_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2018_;
		ValaCCodeExpression* _tmp2019_;
		ValaCCodeBinaryExpression* _tmp2020_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2021_;
		ValaCCodeExpression* _tmp2022_;
		ValaCCodeBinaryExpression* _tmp2023_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2024_;
		ValaCCodeIdentifier* _tmp2025_;
		ValaCCodeFunctionCall* _tmp2026_;
		ValaCCodeFunctionCall* _tmp2027_;
		ValaCCodeFunctionCall* _tmp2028_;
		ValaCCodeExpression* _tmp2029_;
		ValaCCodeExpression* _tmp2030_;
		ValaCCodeBinaryExpression* _tmp2031_;
		ValaCCodeBinaryExpression* _tmp2032_;
		ValaCCodeFunctionCall* _tmp2033_;
		ValaCCodeConstant* _tmp2034_;
		ValaCCodeConstant* _tmp2035_;
		ValaCCodeFunctionCall* _tmp2036_;
		ValaCCodeIdentifier* _tmp2037_;
		ValaCCodeBinaryExpression* _tmp2038_;
		ValaCCodeBinaryExpression* _tmp2039_;
		ValaCCodeBinaryExpression* _tmp2040_;
		ValaCCodeFunction* _tmp2041_;
		ValaCCodeFunction* _tmp2042_;
		ValaCCodeExpression* _tmp2043_;
		ValaCCodeExpression* _tmp2044_;
		ValaCCodeFunction* _tmp2045_;
		ValaCCodeFunction* _tmp2046_;
		ValaCCodeExpression* _tmp2047_;
		ValaCCodeFunction* _tmp2048_;
		ValaCCodeFunction* _tmp2049_;
		ValaCCodeBinaryExpression* _tmp2050_;
		ValaCCodeFunctionCall* _tmp2051_;
		ValaCCodeConstant* _tmp2052_;
		ValaCCodeConstant* _tmp2053_;
		ValaCCodeConditionalExpression* _tmp2054_;
		ValaCCodeConditionalExpression* _tmp2055_;
		ValaCCodeFunction* _tmp2056_;
		ValaCCodeFunction* _tmp2057_;
		ValaMemberAccess* _tmp2058_;
		ValaExpression* _tmp2059_;
		ValaExpression* _tmp2060_;
		ValaCCodeExpression* _tmp2061_;
		ValaCCodeExpression* _tmp2062_;
		ValaCCodeExpression* _tmp2063_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2064_;
		ValaExpression* _tmp2065_;
		ValaExpression* _tmp2066_;
		ValaSymbol* _tmp2067_;
		ValaSymbol* _tmp2068_;
		ValaSymbol* _tmp2069_;
		gboolean _tmp2070_ = FALSE;
		gboolean _tmp2071_ = FALSE;
		ValaSymbol* _tmp2072_;
		_tmp1977_ = vala_method_call_get_argument_list (expr);
		_tmp1978_ = vala_iterable_iterator ((ValaIterable*) _tmp1977_);
		arg_it = _tmp1978_;
		_tmp1979_ = arg_it;
		vala_iterator_next (_tmp1979_);
		_tmp1980_ = arg_it;
		_tmp1981_ = vala_iterator_get (_tmp1980_);
		_tmp1982_ = (ValaExpression*) _tmp1981_;
		_tmp1983_ = vala_get_cvalue (_tmp1982_);
		_tmp1984_ = _vala_ccode_node_ref0 (_tmp1983_);
		_tmp1985_ = _tmp1984_;
		_vala_code_node_unref0 (_tmp1982_);
		new_size = _tmp1985_;
		_tmp1986_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1987_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1986_, TRUE, NULL, FALSE);
		temp_decl = _tmp1987_;
		_tmp1988_ = temp_decl;
		_tmp1989_ = vala_symbol_get_name ((ValaSymbol*) _tmp1988_);
		_tmp1990_ = _tmp1989_;
		_tmp1991_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1990_);
		temp_ref = _tmp1991_;
		_tmp1992_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1992_, FALSE);
		_tmp1993_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1993_, "string.h", FALSE);
		_tmp1994_ = ma;
		_tmp1995_ = vala_member_access_get_inner (_tmp1994_);
		_tmp1996_ = _tmp1995_;
		_tmp1997_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1996_, 1);
		clen = _tmp1997_;
		_tmp1998_ = ma;
		_tmp1999_ = vala_member_access_get_inner (_tmp1998_);
		_tmp2000_ = _tmp1999_;
		_tmp2001_ = vala_get_cvalue (_tmp2000_);
		_tmp2002_ = _vala_ccode_node_ref0 (_tmp2001_);
		celems = _tmp2002_;
		_tmp2003_ = ma;
		_tmp2004_ = vala_member_access_get_inner (_tmp2003_);
		_tmp2005_ = _tmp2004_;
		_tmp2006_ = vala_expression_get_value_type (_tmp2005_);
		_tmp2007_ = _tmp2006_;
		_tmp2008_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2007_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2008_;
		_tmp2009_ = array_type;
		_tmp2010_ = vala_array_type_get_element_type (_tmp2009_);
		_tmp2011_ = _tmp2010_;
		_tmp2012_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2011_);
		_tmp2013_ = _tmp2012_;
		_tmp2014_ = g_strdup_printf ("sizeof (%s)", _tmp2013_);
		_tmp2015_ = _tmp2014_;
		_tmp2016_ = vala_ccode_identifier_new (_tmp2015_);
		_tmp2017_ = _tmp2016_;
		_g_free0 (_tmp2015_);
		_g_free0 (_tmp2013_);
		csizeof = _tmp2017_;
		_tmp2018_ = temp_ref;
		_tmp2019_ = clen;
		_tmp2020_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2018_, _tmp2019_);
		cdelta = _tmp2020_;
		_tmp2021_ = temp_ref;
		_tmp2022_ = clen;
		_tmp2023_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2021_, _tmp2022_);
		ccheck = _tmp2023_;
		_tmp2024_ = vala_ccode_identifier_new ("memset");
		_tmp2025_ = _tmp2024_;
		_tmp2026_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2025_);
		_tmp2027_ = _tmp2026_;
		_vala_ccode_node_unref0 (_tmp2025_);
		czero = _tmp2027_;
		_tmp2028_ = czero;
		_tmp2029_ = celems;
		_tmp2030_ = clen;
		_tmp2031_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2029_, _tmp2030_);
		_tmp2032_ = _tmp2031_;
		vala_ccode_function_call_add_argument (_tmp2028_, (ValaCCodeExpression*) _tmp2032_);
		_vala_ccode_node_unref0 (_tmp2032_);
		_tmp2033_ = czero;
		_tmp2034_ = vala_ccode_constant_new ("0");
		_tmp2035_ = _tmp2034_;
		vala_ccode_function_call_add_argument (_tmp2033_, (ValaCCodeExpression*) _tmp2035_);
		_vala_ccode_node_unref0 (_tmp2035_);
		_tmp2036_ = czero;
		_tmp2037_ = csizeof;
		_tmp2038_ = cdelta;
		_tmp2039_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2037_, (ValaCCodeExpression*) _tmp2038_);
		_tmp2040_ = _tmp2039_;
		vala_ccode_function_call_add_argument (_tmp2036_, (ValaCCodeExpression*) _tmp2040_);
		_vala_ccode_node_unref0 (_tmp2040_);
		_tmp2041_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2042_ = _tmp2041_;
		_tmp2043_ = temp_ref;
		_tmp2044_ = new_size;
		vala_ccode_function_add_assignment (_tmp2042_, _tmp2043_, _tmp2044_);
		_tmp2045_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2046_ = _tmp2045_;
		_tmp2047_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2046_, _tmp2047_);
		_tmp2048_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2049_ = _tmp2048_;
		_tmp2050_ = ccheck;
		_tmp2051_ = czero;
		_tmp2052_ = vala_ccode_constant_new ("NULL");
		_tmp2053_ = _tmp2052_;
		_tmp2054_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2050_, (ValaCCodeExpression*) _tmp2051_, (ValaCCodeExpression*) _tmp2053_);
		_tmp2055_ = _tmp2054_;
		vala_ccode_function_add_expression (_tmp2049_, (ValaCCodeExpression*) _tmp2055_);
		_vala_ccode_node_unref0 (_tmp2055_);
		_vala_ccode_node_unref0 (_tmp2053_);
		_tmp2056_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2057_ = _tmp2056_;
		_tmp2058_ = ma;
		_tmp2059_ = vala_member_access_get_inner (_tmp2058_);
		_tmp2060_ = _tmp2059_;
		_tmp2061_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2060_, 1);
		_tmp2062_ = _tmp2061_;
		_tmp2063_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2057_, _tmp2062_, _tmp2063_);
		_vala_ccode_node_unref0 (_tmp2062_);
		_tmp2064_ = ma;
		_tmp2065_ = vala_member_access_get_inner (_tmp2064_);
		_tmp2066_ = _tmp2065_;
		_tmp2067_ = vala_expression_get_symbol_reference (_tmp2066_);
		_tmp2068_ = _tmp2067_;
		_tmp2069_ = _vala_code_node_ref0 (_tmp2068_);
		array_var = _tmp2069_;
		_tmp2072_ = array_var;
		if (_tmp2072_ != NULL) {
			ValaSymbol* _tmp2073_;
			_tmp2073_ = array_var;
			_tmp2071_ = vala_symbol_is_internal_symbol (_tmp2073_);
		} else {
			_tmp2071_ = FALSE;
		}
		if (_tmp2071_) {
			gboolean _tmp2074_ = FALSE;
			ValaSymbol* _tmp2075_;
			_tmp2075_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2075_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2074_ = TRUE;
			} else {
				ValaSymbol* _tmp2076_;
				_tmp2076_ = array_var;
				_tmp2074_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2076_, VALA_TYPE_FIELD);
			}
			_tmp2070_ = _tmp2074_;
		} else {
			_tmp2070_ = FALSE;
		}
		if (_tmp2070_) {
			ValaCCodeFunction* _tmp2077_;
			ValaCCodeFunction* _tmp2078_;
			ValaMemberAccess* _tmp2079_;
			ValaExpression* _tmp2080_;
			ValaExpression* _tmp2081_;
			ValaTargetValue* _tmp2082_;
			ValaTargetValue* _tmp2083_;
			ValaCCodeExpression* _tmp2084_;
			ValaCCodeExpression* _tmp2085_;
			_tmp2077_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2078_ = _tmp2077_;
			_tmp2079_ = ma;
			_tmp2080_ = vala_member_access_get_inner (_tmp2079_);
			_tmp2081_ = _tmp2080_;
			_tmp2082_ = vala_expression_get_target_value (_tmp2081_);
			_tmp2083_ = _tmp2082_;
			_tmp2084_ = vala_get_array_size_cvalue (_tmp2083_);
			_tmp2085_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2078_, _tmp2084_, _tmp2085_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2087_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2088_ = _tmp2087_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2088_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2089_;
		ValaDataType* _tmp2090_;
		_tmp2089_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2090_ = _tmp2089_;
		_tmp2086_ = !vala_data_type_is_disposable (_tmp2090_);
	} else {
		_tmp2086_ = FALSE;
	}
	if (_tmp2086_) {
		gboolean _tmp2091_ = FALSE;
		ValaCCodeExpression* _tmp2092_;
		_tmp2092_ = ccall_expr;
		if (_tmp2092_ != NULL) {
			_tmp2091_ = !return_result_via_out_param;
		} else {
			_tmp2091_ = FALSE;
		}
		if (_tmp2091_) {
			ValaCCodeFunction* _tmp2093_;
			ValaCCodeFunction* _tmp2094_;
			ValaCCodeExpression* _tmp2095_;
			_tmp2093_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2094_ = _tmp2093_;
			_tmp2095_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2094_, _tmp2095_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2096_;
		ValaDataType* _tmp2097_;
		ValaDataType* _tmp2098_;
		gboolean _tmp2099_ = FALSE;
		ValaDataType* _tmp2100_;
		ValaDataType* _tmp2101_;
		gboolean _tmp2154_ = FALSE;
		ValaMethod* _tmp2155_;
		_tmp2096_ = itype;
		_tmp2097_ = vala_data_type_get_return_type (_tmp2096_);
		_tmp2098_ = _vala_code_node_ref0 (_tmp2097_);
		result_type = _tmp2098_;
		_tmp2100_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2101_ = _tmp2100_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2101_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2102_;
			ValaDataType* _tmp2103_;
			_tmp2102_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2103_ = _tmp2102_;
			_tmp2099_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2103_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2099_ = FALSE;
		}
		if (_tmp2099_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2104_;
			ValaDataType* _tmp2105_;
			ValaTypeParameter* _tmp2106_;
			ValaTypeParameter* _tmp2107_;
			ValaTypeParameter* _tmp2108_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2109_;
			ValaSymbol* _tmp2110_;
			ValaSymbol* _tmp2111_;
			ValaSymbol* _tmp2112_;
			ValaSymbol* _tmp2113_;
			ValaStruct* _tmp2114_;
			gboolean _tmp2115_ = FALSE;
			ValaTypeParameter* _tmp2116_;
			ValaSymbol* _tmp2117_;
			ValaSymbol* _tmp2118_;
			ValaTypeSymbol* _tmp2119_;
			gboolean _tmp2128_ = FALSE;
			gboolean _tmp2129_ = FALSE;
			ValaStruct* _tmp2130_;
			_tmp2104_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2105_ = _tmp2104_;
			_tmp2106_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2105_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2107_ = _tmp2106_;
			_tmp2108_ = _vala_code_node_ref0 (_tmp2107_);
			type_parameter = _tmp2108_;
			_tmp2109_ = type_parameter;
			_tmp2110_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2109_);
			_tmp2111_ = _tmp2110_;
			_tmp2112_ = vala_symbol_get_parent_symbol (_tmp2111_);
			_tmp2113_ = _tmp2112_;
			_tmp2114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2113_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2113_) : NULL);
			st = _tmp2114_;
			_tmp2116_ = type_parameter;
			_tmp2117_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2116_);
			_tmp2118_ = _tmp2117_;
			_tmp2119_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2118_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2119_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2115_ = TRUE;
			} else {
				gboolean _tmp2120_ = FALSE;
				ValaStruct* _tmp2121_;
				_tmp2121_ = st;
				if (_tmp2121_ != NULL) {
					ValaStruct* _tmp2122_;
					gchar* _tmp2123_;
					gchar* _tmp2124_;
					_tmp2122_ = st;
					_tmp2123_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2122_);
					_tmp2124_ = _tmp2123_;
					_tmp2120_ = g_strcmp0 (_tmp2124_, "va_list") == 0;
					_g_free0 (_tmp2124_);
				} else {
					_tmp2120_ = FALSE;
				}
				_tmp2115_ = _tmp2120_;
			}
			if (_tmp2115_) {
				ValaDataType* _tmp2125_;
				ValaDataType* _tmp2126_;
				ValaDataType* _tmp2127_;
				_tmp2125_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2126_ = _tmp2125_;
				_tmp2127_ = _vala_code_node_ref0 (_tmp2126_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2127_;
			}
			_tmp2130_ = st;
			if (_tmp2130_ != NULL) {
				ValaStruct* _tmp2131_;
				gchar* _tmp2132_;
				gchar* _tmp2133_;
				_tmp2131_ = st;
				_tmp2132_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2131_);
				_tmp2133_ = _tmp2132_;
				_tmp2129_ = g_strcmp0 (_tmp2133_, "va_list") == 0;
				_g_free0 (_tmp2133_);
			} else {
				_tmp2129_ = FALSE;
			}
			if (_tmp2129_) {
				ValaMemberAccess* _tmp2134_;
				const gchar* _tmp2135_;
				const gchar* _tmp2136_;
				_tmp2134_ = ma;
				_tmp2135_ = vala_member_access_get_member_name (_tmp2134_);
				_tmp2136_ = _tmp2135_;
				_tmp2128_ = g_strcmp0 (_tmp2136_, "arg") == 0;
			} else {
				_tmp2128_ = FALSE;
			}
			if (_tmp2128_) {
				gboolean _tmp2137_ = FALSE;
				ValaDataType* _tmp2138_;
				_tmp2138_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2138_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2139_;
					ValaDelegate* _tmp2140_;
					ValaDelegate* _tmp2141_;
					gboolean _tmp2142_;
					gboolean _tmp2143_;
					_tmp2139_ = result_type;
					_tmp2140_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2139_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2141_ = _tmp2140_;
					_tmp2142_ = vala_delegate_get_has_target (_tmp2141_);
					_tmp2143_ = _tmp2142_;
					_tmp2137_ = _tmp2143_;
				} else {
					_tmp2137_ = FALSE;
				}
				if (_tmp2137_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2144_;
					ValaTargetValue* _tmp2145_;
					ValaGLibValue* _tmp2146_;
					ValaCCodeExpression* _tmp2147_;
					ValaGLibValue* _tmp2150_;
					ValaCCodeExpression* _tmp2151_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2144_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2145_ = _tmp2144_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2145_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2146_ = arg_value;
					_tmp2147_ = _tmp2146_->delegate_target_cvalue;
					if (_tmp2147_ == NULL) {
						ValaGLibValue* _tmp2148_;
						ValaCCodeConstant* _tmp2149_;
						_tmp2148_ = arg_value;
						_tmp2149_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2148_->delegate_target_cvalue);
						_tmp2148_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2149_;
					}
					_tmp2150_ = arg_value;
					_tmp2151_ = _tmp2150_->delegate_target_destroy_notify_cvalue;
					if (_tmp2151_ == NULL) {
						ValaGLibValue* _tmp2152_;
						ValaCCodeConstant* _tmp2153_;
						_tmp2152_ = arg_value;
						_tmp2153_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2152_->delegate_target_destroy_notify_cvalue);
						_tmp2152_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2153_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2155_ = m;
		if (_tmp2155_ != NULL) {
			ValaMethod* _tmp2156_;
			_tmp2156_ = m;
			_tmp2154_ = vala_method_get_format_arg_index (_tmp2156_) >= 0;
		} else {
			_tmp2154_ = FALSE;
		}
		if (_tmp2154_) {
			ValaCCodeExpression* _tmp2157_;
			_tmp2157_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2157_);
		} else {
			gboolean _tmp2158_ = FALSE;
			ValaMethod* _tmp2159_;
			_tmp2159_ = m;
			if (_tmp2159_ != NULL) {
				ValaMethod* _tmp2160_;
				_tmp2160_ = m;
				_tmp2158_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2160_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2158_ = FALSE;
			}
			if (_tmp2158_) {
				ValaCCodeExpression* _tmp2161_;
				_tmp2161_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2161_);
			} else {
				gboolean _tmp2162_ = FALSE;
				gboolean _tmp2163_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2163_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2163_ = FALSE;
				}
				if (_tmp2163_) {
					gboolean _tmp2164_ = FALSE;
					ValaDataType* _tmp2165_;
					_tmp2165_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2165_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2166_;
						_tmp2166_ = result_type;
						_tmp2164_ = !vala_data_type_is_disposable (_tmp2166_);
					} else {
						_tmp2164_ = FALSE;
					}
					_tmp2162_ = _tmp2164_;
				} else {
					_tmp2162_ = FALSE;
				}
				if (_tmp2162_) {
					ValaCCodeExpression* _tmp2167_;
					_tmp2167_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2167_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2168_;
						ValaDataType* _tmp2169_;
						gboolean _tmp2170_;
						gboolean _tmp2171_;
						ValaLocalVariable* _tmp2172_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2173_;
						const gchar* _tmp2174_;
						const gchar* _tmp2175_;
						ValaCCodeExpression* _tmp2176_;
						ValaLocalVariable* _tmp2177_;
						ValaCCodeFunction* _tmp2178_;
						ValaCCodeFunction* _tmp2179_;
						ValaCCodeExpression* _tmp2180_;
						ValaCCodeExpression* _tmp2181_;
						ValaCCodeExpression* _tmp2182_;
						ValaTargetValue* _tmp2183_;
						ValaTargetValue* _tmp2184_;
						_tmp2168_ = result_type;
						_tmp2169_ = result_type;
						_tmp2170_ = vala_data_type_get_value_owned (_tmp2169_);
						_tmp2171_ = _tmp2170_;
						_tmp2172_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2168_, _tmp2171_, NULL, FALSE);
						temp_var = _tmp2172_;
						_tmp2173_ = temp_var;
						_tmp2174_ = vala_symbol_get_name ((ValaSymbol*) _tmp2173_);
						_tmp2175_ = _tmp2174_;
						_tmp2176_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2175_);
						temp_ref = _tmp2176_;
						_tmp2177_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2177_, FALSE);
						_tmp2178_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2179_ = _tmp2178_;
						_tmp2180_ = temp_ref;
						_tmp2181_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2179_, _tmp2180_, _tmp2181_);
						_tmp2182_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2182_);
						_tmp2183_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2184_ = _tmp2183_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2184_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2185_;
						ValaTargetValue* _tmp2186_;
						ValaTargetValue* _tmp2187_;
						_tmp2185_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2185_);
						_tmp2186_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2187_ = _tmp2186_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2187_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2188_ = params;
	_tmp2189_ = vala_iterable_iterator ((ValaIterable*) _tmp2188_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2189_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2190_;
		ValaList* _tmp2191_;
		gint _arg_size = 0;
		ValaList* _tmp2192_;
		gint _tmp2193_;
		gint _tmp2194_;
		gint _arg_index = 0;
		_tmp2190_ = vala_method_call_get_argument_list (expr);
		_tmp2191_ = _vala_iterable_ref0 (_tmp2190_);
		_arg_list = _tmp2191_;
		_tmp2192_ = _arg_list;
		_tmp2193_ = vala_collection_get_size ((ValaCollection*) _tmp2192_);
		_tmp2194_ = _tmp2193_;
		_arg_size = _tmp2194_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2195_;
			gint _tmp2196_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2197_;
			gpointer _tmp2198_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2199_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2202_;
			ValaUnaryExpression* _tmp2203_;
			gboolean _tmp2204_ = FALSE;
			ValaUnaryExpression* _tmp2205_;
			gboolean _tmp2263_ = FALSE;
			ValaUnaryExpression* _tmp2264_;
			ValaUnaryExpression* _tmp2268_;
			ValaExpression* _tmp2269_;
			ValaExpression* _tmp2270_;
			ValaDataType* _tmp2271_;
			ValaDataType* _tmp2272_;
			gboolean _tmp2282_ = FALSE;
			ValaMemberAccess* _tmp2283_;
			ValaSymbol* _tmp2284_;
			ValaSymbol* _tmp2285_;
			ValaUnaryExpression* _tmp2301_;
			ValaExpression* _tmp2302_;
			ValaExpression* _tmp2303_;
			ValaTargetValue* _tmp2304_;
			ValaTargetValue* _tmp2305_;
			ValaUnaryExpression* _tmp2306_;
			ValaTargetValue* _tmp2307_;
			ValaTargetValue* _tmp2308_;
			ValaUnaryExpression* _tmp2309_;
			ValaExpression* _tmp2310_;
			ValaExpression* _tmp2311_;
			ValaDataType* _tmp2312_;
			ValaDataType* _tmp2313_;
			ValaExpression* _tmp2314_;
			ValaTargetValue* _tmp2315_;
			ValaTargetValue* _tmp2316_;
			ValaSourceReference* _tmp2317_;
			ValaSourceReference* _tmp2318_;
			gboolean _tmp2319_ = FALSE;
			ValaParameter* _tmp2320_;
			_arg_index = _arg_index + 1;
			_tmp2195_ = _arg_index;
			_tmp2196_ = _arg_size;
			if (!(_tmp2195_ < _tmp2196_)) {
				break;
			}
			_tmp2197_ = _arg_list;
			_tmp2198_ = vala_list_get (_tmp2197_, _arg_index);
			arg = (ValaExpression*) _tmp2198_;
			param = NULL;
			_tmp2199_ = params_it;
			if (vala_iterator_next (_tmp2199_)) {
				ValaIterator* _tmp2200_;
				gpointer _tmp2201_;
				_tmp2200_ = params_it;
				_tmp2201_ = vala_iterator_get (_tmp2200_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2201_;
			}
			_tmp2202_ = arg;
			_tmp2203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2202_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2202_) : NULL);
			unary = _tmp2203_;
			_tmp2205_ = unary;
			if (_tmp2205_ != NULL) {
				ValaUnaryExpression* _tmp2206_;
				ValaUnaryOperator _tmp2207_;
				ValaUnaryOperator _tmp2208_;
				_tmp2206_ = unary;
				_tmp2207_ = vala_unary_expression_get_operator (_tmp2206_);
				_tmp2208_ = _tmp2207_;
				_tmp2204_ = _tmp2208_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2204_ = FALSE;
			}
			if (_tmp2204_) {
				gboolean _tmp2209_ = FALSE;
				gboolean _tmp2210_ = FALSE;
				gboolean _tmp2211_ = FALSE;
				gboolean _tmp2212_ = FALSE;
				ValaParameter* _tmp2213_;
				_tmp2213_ = param;
				if (_tmp2213_ != NULL) {
					ValaParameter* _tmp2214_;
					_tmp2214_ = param;
					_tmp2212_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2214_);
				} else {
					_tmp2212_ = FALSE;
				}
				if (_tmp2212_) {
					ValaParameter* _tmp2215_;
					ValaDataType* _tmp2216_;
					ValaDataType* _tmp2217_;
					_tmp2215_ = param;
					_tmp2216_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2215_);
					_tmp2217_ = _tmp2216_;
					_tmp2211_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2217_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2211_ = FALSE;
				}
				if (_tmp2211_) {
					ValaParameter* _tmp2218_;
					ValaDataType* _tmp2219_;
					ValaDataType* _tmp2220_;
					gboolean _tmp2221_;
					gboolean _tmp2222_;
					_tmp2218_ = param;
					_tmp2219_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2218_);
					_tmp2220_ = _tmp2219_;
					_tmp2221_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2220_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2222_ = _tmp2221_;
					_tmp2210_ = !_tmp2222_;
				} else {
					_tmp2210_ = FALSE;
				}
				if (_tmp2210_) {
					ValaParameter* _tmp2223_;
					ValaDataType* _tmp2224_;
					ValaDataType* _tmp2225_;
					gint _tmp2226_;
					gint _tmp2227_;
					_tmp2223_ = param;
					_tmp2224_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2223_);
					_tmp2225_ = _tmp2224_;
					_tmp2226_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2225_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2227_ = _tmp2226_;
					_tmp2209_ = _tmp2227_ == 1;
				} else {
					_tmp2209_ = FALSE;
				}
				if (_tmp2209_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2228_;
					ValaExpression* _tmp2229_;
					ValaExpression* _tmp2230_;
					ValaSymbol* _tmp2231_;
					ValaSymbol* _tmp2232_;
					gboolean _tmp2233_ = FALSE;
					gboolean _tmp2234_ = FALSE;
					gboolean _tmp2235_ = FALSE;
					gboolean _tmp2236_ = FALSE;
					ValaVariable* _tmp2237_;
					_tmp2228_ = unary;
					_tmp2229_ = vala_unary_expression_get_inner (_tmp2228_);
					_tmp2230_ = _tmp2229_;
					_tmp2231_ = vala_expression_get_symbol_reference (_tmp2230_);
					_tmp2232_ = _tmp2231_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2232_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2232_) : NULL;
					_tmp2237_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2237_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2236_ = TRUE;
					} else {
						ValaVariable* _tmp2238_;
						_tmp2238_ = array_var;
						_tmp2236_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2238_, VALA_TYPE_FIELD);
					}
					if (_tmp2236_) {
						ValaVariable* _tmp2239_;
						_tmp2239_ = array_var;
						_tmp2235_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2239_);
					} else {
						_tmp2235_ = FALSE;
					}
					if (_tmp2235_) {
						ValaVariable* _tmp2240_;
						ValaDataType* _tmp2241_;
						ValaDataType* _tmp2242_;
						_tmp2240_ = array_var;
						_tmp2241_ = vala_variable_get_variable_type (_tmp2240_);
						_tmp2242_ = _tmp2241_;
						_tmp2234_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2242_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2234_ = FALSE;
					}
					if (_tmp2234_) {
						ValaVariable* _tmp2243_;
						ValaDataType* _tmp2244_;
						ValaDataType* _tmp2245_;
						gboolean _tmp2246_;
						gboolean _tmp2247_;
						_tmp2243_ = array_var;
						_tmp2244_ = vala_variable_get_variable_type (_tmp2243_);
						_tmp2245_ = _tmp2244_;
						_tmp2246_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2245_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2247_ = _tmp2246_;
						_tmp2233_ = !_tmp2247_;
					} else {
						_tmp2233_ = FALSE;
					}
					if (_tmp2233_) {
						ValaCCodeFunction* _tmp2248_;
						ValaCCodeFunction* _tmp2249_;
						ValaUnaryExpression* _tmp2250_;
						ValaExpression* _tmp2251_;
						ValaExpression* _tmp2252_;
						ValaTargetValue* _tmp2253_;
						ValaTargetValue* _tmp2254_;
						ValaCCodeExpression* _tmp2255_;
						ValaUnaryExpression* _tmp2256_;
						ValaExpression* _tmp2257_;
						ValaExpression* _tmp2258_;
						ValaTargetValue* _tmp2259_;
						ValaTargetValue* _tmp2260_;
						ValaCCodeExpression* _tmp2261_;
						ValaCCodeExpression* _tmp2262_;
						_tmp2248_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2249_ = _tmp2248_;
						_tmp2250_ = unary;
						_tmp2251_ = vala_unary_expression_get_inner (_tmp2250_);
						_tmp2252_ = _tmp2251_;
						_tmp2253_ = vala_expression_get_target_value (_tmp2252_);
						_tmp2254_ = _tmp2253_;
						_tmp2255_ = vala_get_array_size_cvalue (_tmp2254_);
						_tmp2256_ = unary;
						_tmp2257_ = vala_unary_expression_get_inner (_tmp2256_);
						_tmp2258_ = _tmp2257_;
						_tmp2259_ = vala_expression_get_target_value (_tmp2258_);
						_tmp2260_ = _tmp2259_;
						_tmp2261_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2260_, 1);
						_tmp2262_ = _tmp2261_;
						vala_ccode_function_add_assignment (_tmp2249_, _tmp2255_, _tmp2262_);
						_vala_ccode_node_unref0 (_tmp2262_);
					}
				}
			}
			_tmp2264_ = unary;
			if (_tmp2264_ == NULL) {
				_tmp2263_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2265_;
				ValaUnaryOperator _tmp2266_;
				ValaUnaryOperator _tmp2267_;
				_tmp2265_ = unary;
				_tmp2266_ = vala_unary_expression_get_operator (_tmp2265_);
				_tmp2267_ = _tmp2266_;
				_tmp2263_ = _tmp2267_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2263_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2268_ = unary;
			_tmp2269_ = vala_unary_expression_get_inner (_tmp2268_);
			_tmp2270_ = _tmp2269_;
			_tmp2271_ = vala_expression_get_value_type (_tmp2270_);
			_tmp2272_ = _tmp2271_;
			if (vala_ccode_base_module_requires_destroy (_tmp2272_)) {
				ValaCCodeFunction* _tmp2273_;
				ValaCCodeFunction* _tmp2274_;
				ValaUnaryExpression* _tmp2275_;
				ValaExpression* _tmp2276_;
				ValaExpression* _tmp2277_;
				ValaTargetValue* _tmp2278_;
				ValaTargetValue* _tmp2279_;
				ValaCCodeExpression* _tmp2280_;
				ValaCCodeExpression* _tmp2281_;
				_tmp2273_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2274_ = _tmp2273_;
				_tmp2275_ = unary;
				_tmp2276_ = vala_unary_expression_get_inner (_tmp2275_);
				_tmp2277_ = _tmp2276_;
				_tmp2278_ = vala_expression_get_target_value (_tmp2277_);
				_tmp2279_ = _tmp2278_;
				_tmp2280_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2279_, FALSE);
				_tmp2281_ = _tmp2280_;
				vala_ccode_function_add_expression (_tmp2274_, _tmp2281_);
				_vala_ccode_node_unref0 (_tmp2281_);
			}
			_tmp2283_ = ma;
			_tmp2284_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2283_);
			_tmp2285_ = _tmp2284_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2285_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2286_;
				ValaTargetValue* _tmp2287_;
				ValaTargetValue* _tmp2288_;
				ValaDataType* _tmp2289_;
				ValaDataType* _tmp2290_;
				_tmp2286_ = unary;
				_tmp2287_ = vala_expression_get_target_value ((ValaExpression*) _tmp2286_);
				_tmp2288_ = _tmp2287_;
				_tmp2289_ = vala_target_value_get_value_type (_tmp2288_);
				_tmp2290_ = _tmp2289_;
				_tmp2282_ = _tmp2290_ == NULL;
			} else {
				_tmp2282_ = FALSE;
			}
			if (_tmp2282_) {
				ValaUnaryExpression* _tmp2291_;
				ValaTargetValue* _tmp2292_;
				ValaTargetValue* _tmp2293_;
				ValaUnaryExpression* _tmp2294_;
				ValaExpression* _tmp2295_;
				ValaExpression* _tmp2296_;
				ValaDataType* _tmp2297_;
				ValaDataType* _tmp2298_;
				ValaDataType* _tmp2299_;
				ValaDataType* _tmp2300_;
				_tmp2291_ = unary;
				_tmp2292_ = vala_expression_get_target_value ((ValaExpression*) _tmp2291_);
				_tmp2293_ = _tmp2292_;
				_tmp2294_ = unary;
				_tmp2295_ = vala_unary_expression_get_inner (_tmp2294_);
				_tmp2296_ = _tmp2295_;
				_tmp2297_ = vala_expression_get_value_type (_tmp2296_);
				_tmp2298_ = _tmp2297_;
				_tmp2299_ = vala_data_type_copy (_tmp2298_);
				_tmp2300_ = _tmp2299_;
				vala_target_value_set_value_type (_tmp2293_, _tmp2300_);
				_vala_code_node_unref0 (_tmp2300_);
			}
			_tmp2301_ = unary;
			_tmp2302_ = vala_unary_expression_get_inner (_tmp2301_);
			_tmp2303_ = _tmp2302_;
			_tmp2304_ = vala_expression_get_target_value (_tmp2303_);
			_tmp2305_ = _tmp2304_;
			_tmp2306_ = unary;
			_tmp2307_ = vala_expression_get_target_value ((ValaExpression*) _tmp2306_);
			_tmp2308_ = _tmp2307_;
			_tmp2309_ = unary;
			_tmp2310_ = vala_unary_expression_get_inner (_tmp2309_);
			_tmp2311_ = _tmp2310_;
			_tmp2312_ = vala_expression_get_value_type (_tmp2311_);
			_tmp2313_ = _tmp2312_;
			_tmp2314_ = arg;
			_tmp2315_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2308_, _tmp2313_, (ValaCodeNode*) _tmp2314_);
			_tmp2316_ = _tmp2315_;
			_tmp2317_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2318_ = _tmp2317_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2305_, _tmp2316_, _tmp2318_);
			_vala_target_value_unref0 (_tmp2316_);
			_tmp2320_ = param;
			if (_tmp2320_ != NULL) {
				ValaParameter* _tmp2321_;
				_tmp2321_ = param;
				_tmp2319_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2321_);
			} else {
				_tmp2319_ = FALSE;
			}
			if (_tmp2319_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2322_;
				ValaCCodeIdentifier* _tmp2323_;
				ValaCCodeFunctionCall* _tmp2324_;
				ValaCCodeFunctionCall* _tmp2325_;
				ValaCCodeFunctionCall* _tmp2326_;
				ValaUnaryExpression* _tmp2327_;
				ValaExpression* _tmp2328_;
				ValaExpression* _tmp2329_;
				ValaTargetValue* _tmp2330_;
				ValaTargetValue* _tmp2331_;
				ValaCCodeExpression* _tmp2332_;
				ValaCCodeFunction* _tmp2333_;
				ValaCCodeFunction* _tmp2334_;
				ValaUnaryExpression* _tmp2335_;
				ValaExpression* _tmp2336_;
				ValaExpression* _tmp2337_;
				ValaTargetValue* _tmp2338_;
				ValaTargetValue* _tmp2339_;
				ValaCCodeExpression* _tmp2340_;
				ValaCCodeExpression* _tmp2341_;
				ValaCCodeFunctionCall* _tmp2342_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2322_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2323_ = _tmp2322_;
				_tmp2324_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2323_);
				_tmp2325_ = _tmp2324_;
				_vala_ccode_node_unref0 (_tmp2323_);
				len_call = _tmp2325_;
				_tmp2326_ = len_call;
				_tmp2327_ = unary;
				_tmp2328_ = vala_unary_expression_get_inner (_tmp2327_);
				_tmp2329_ = _tmp2328_;
				_tmp2330_ = vala_expression_get_target_value (_tmp2329_);
				_tmp2331_ = _tmp2330_;
				_tmp2332_ = vala_get_cvalue_ (_tmp2331_);
				vala_ccode_function_call_add_argument (_tmp2326_, _tmp2332_);
				_tmp2333_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2334_ = _tmp2333_;
				_tmp2335_ = unary;
				_tmp2336_ = vala_unary_expression_get_inner (_tmp2335_);
				_tmp2337_ = _tmp2336_;
				_tmp2338_ = vala_expression_get_target_value (_tmp2337_);
				_tmp2339_ = _tmp2338_;
				_tmp2340_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2339_, 1);
				_tmp2341_ = _tmp2340_;
				_tmp2342_ = len_call;
				vala_ccode_function_add_assignment (_tmp2334_, _tmp2341_, (ValaCCodeExpression*) _tmp2342_);
				_vala_ccode_node_unref0 (_tmp2341_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2345_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2345_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2346_;
		ValaSymbol* _tmp2347_;
		ValaSymbol* _tmp2348_;
		_tmp2346_ = m;
		_tmp2347_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2346_);
		_tmp2348_ = _tmp2347_;
		_tmp2344_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2348_, VALA_TYPE_CLASS);
	} else {
		_tmp2344_ = FALSE;
	}
	if (_tmp2344_) {
		gboolean _tmp2349_ = FALSE;
		gboolean _tmp2350_ = FALSE;
		ValaClass* _tmp2351_;
		ValaClass* _tmp2352_;
		gboolean _tmp2353_;
		gboolean _tmp2354_;
		_tmp2351_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2352_ = _tmp2351_;
		_tmp2353_ = vala_class_get_is_compact (_tmp2352_);
		_tmp2354_ = _tmp2353_;
		if (_tmp2354_) {
			ValaClass* _tmp2355_;
			ValaClass* _tmp2356_;
			ValaClass* _tmp2357_;
			ValaClass* _tmp2358_;
			_tmp2355_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2356_ = _tmp2355_;
			_tmp2357_ = vala_class_get_base_class (_tmp2356_);
			_tmp2358_ = _tmp2357_;
			_tmp2350_ = _tmp2358_ != NULL;
		} else {
			_tmp2350_ = FALSE;
		}
		if (_tmp2350_) {
			_tmp2349_ = TRUE;
		} else {
			ValaClass* _tmp2359_;
			ValaClass* _tmp2360_;
			ValaClass* _tmp2361_;
			ValaClass* _tmp2362_;
			ValaClass* _tmp2363_;
			_tmp2359_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2360_ = _tmp2359_;
			_tmp2361_ = vala_class_get_base_class (_tmp2360_);
			_tmp2362_ = _tmp2361_;
			_tmp2363_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2349_ = _tmp2362_ == _tmp2363_;
		}
		_tmp2343_ = _tmp2349_;
	} else {
		_tmp2343_ = FALSE;
	}
	if (_tmp2343_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2364_;
		ValaClass* _tmp2365_;
		gchar* _tmp2366_;
		gchar* _tmp2367_;
		gchar* _tmp2368_;
		gchar* _tmp2369_;
		ValaCCodeIdentifier* _tmp2370_;
		ValaCCodeIdentifier* _tmp2371_;
		ValaCCodeFunctionCall* _tmp2372_;
		ValaCCodeFunctionCall* _tmp2373_;
		ValaCCodeFunctionCall* _tmp2374_;
		ValaCCodeExpression* _tmp2375_;
		ValaCCodeExpression* _tmp2376_;
		ValaClass* _tmp2377_;
		ValaClass* _tmp2378_;
		gboolean _tmp2379_;
		gboolean _tmp2380_;
		ValaCCodeFunction* _tmp2384_;
		ValaCCodeFunction* _tmp2385_;
		ValaCCodeFunctionCall* _tmp2386_;
		_tmp2364_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2365_ = _tmp2364_;
		_tmp2366_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2365_, NULL);
		_tmp2367_ = _tmp2366_;
		_tmp2368_ = g_strdup_printf ("%s_instance_init", _tmp2367_);
		_tmp2369_ = _tmp2368_;
		_tmp2370_ = vala_ccode_identifier_new (_tmp2369_);
		_tmp2371_ = _tmp2370_;
		_tmp2372_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2371_);
		_tmp2373_ = _tmp2372_;
		_vala_ccode_node_unref0 (_tmp2371_);
		_g_free0 (_tmp2369_);
		_g_free0 (_tmp2367_);
		cinitcall = _tmp2373_;
		_tmp2374_ = cinitcall;
		_tmp2375_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2376_ = _tmp2375_;
		vala_ccode_function_call_add_argument (_tmp2374_, _tmp2376_);
		_vala_ccode_node_unref0 (_tmp2376_);
		_tmp2377_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2378_ = _tmp2377_;
		_tmp2379_ = vala_class_get_is_compact (_tmp2378_);
		_tmp2380_ = _tmp2379_;
		if (!_tmp2380_) {
			ValaCCodeFunctionCall* _tmp2381_;
			ValaCCodeConstant* _tmp2382_;
			ValaCCodeConstant* _tmp2383_;
			_tmp2381_ = cinitcall;
			_tmp2382_ = vala_ccode_constant_new ("NULL");
			_tmp2383_ = _tmp2382_;
			vala_ccode_function_call_add_argument (_tmp2381_, (ValaCCodeExpression*) _tmp2383_);
			_vala_ccode_node_unref0 (_tmp2383_);
		}
		_tmp2384_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2385_ = _tmp2384_;
		_tmp2386_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2385_, (ValaCCodeExpression*) _tmp2386_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaEnumValue* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaEnumValue* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			_enum_value_index = _enum_value_index + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = vala_list_get (_tmp27_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp28_;
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = enum_value;
			_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_identifier_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_function_add_case (_tmp30_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = enum_value;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("\"", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\"", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_constant_new (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	vala_ccode_function_close (_tmp48_);
	_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("NULL");
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_return (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function_declaration (_tmp53_, _tmp54_);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = function;
	vala_ccode_file_add_function (_tmp55_, _tmp56_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaUnaryExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp9_) : NULL;
			_tmp11_ = unary;
			if (_tmp11_ != NULL) {
				gboolean _tmp12_ = FALSE;
				ValaUnaryExpression* _tmp13_;
				ValaUnaryOperator _tmp14_;
				ValaUnaryOperator _tmp15_;
				_tmp13_ = unary;
				_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp12_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp16_;
					ValaUnaryOperator _tmp17_;
					ValaUnaryOperator _tmp18_;
					_tmp16_ = unary;
					_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp10_ = _tmp12_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

