/*
 * Copyright (C) 2018 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/

#include "chinesedate.h"
#include <QDebug>
#include <QDate>
#include <QDateTime>
unsigned int chineseDays[201]={0x04bd8,0x04ae0,0x0a570,0x054d5,0x0d260,0x0d950,0x16554,0x056a0,0x09ad0,0x055d2,//1900-1909
            0x04ae0,0x0a5b6,0x0a4d0,0x0d250,0x1d255,0x0b540,0x0d6a0,0x0ada2,0x095b0,0x14977,//1910-1919
            0x04970,0x0a4b0,0x0b4b5,0x06a50,0x06d40,0x1ab54,0x02b60,0x09570,0x052f2,0x04970,//1920-1929
            0x06566,0x0d4a0,0x0ea50,0x16a95,0x05ad0,0x02b60,0x186e3,0x092e0,0x1c8d7,0x0c950,//1930-1939
            0x0d4a0,0x1d8a6,0x0b550,0x056a0,0x1a5b4,0x025d0,0x092d0,0x0d2b2,0x0a950,0x0b557,//1940-1949
            0x06ca0,0x0b550,0x15355,0x04da0,0x0a5b0,0x14573,0x052b0,0x0a9a8,0x0e950,0x06aa0,//1950-1959
            0x0aea6,0x0ab50,0x04b60,0x0aae4,0x0a570,0x05260,0x0f263,0x0d950,0x05b57,0x056a0,//1960-1969
            0x096d0,0x04dd5,0x04ad0,0x0a4d0,0x0d4d4,0x0d250,0x0d558,0x0b540,0x0b6a0,0x195a6,//1970-1979
            0x095b0,0x049b0,0x0a974,0x0a4b0,0x0b27a,0x06a50,0x06d40,0x0af46,0x0ab60,0x09570,//1980-1989
            0x04af5,0x04970,0x064b0,0x074a3,0x0ea50,0x06b58,0x05ac0,0x0ab60,0x096d5,0x092e0,//1990-1999
            0x0c960,0x0d954,0x0d4a0,0x0da50,0x07552,0x056a0,0x0abb7,0x025d0,0x092d0,0x0cab5,//2000-2009
            0x0a950,0x0b4a0,0x0baa4,0x0ad50,0x055d9,0x04ba0,0x0a5b0,0x15176,0x052b0,0x0a930,//2010-2019
            0x07954,0x06aa0,0x0ad50,0x05b52,0x04b60,0x0a6e6,0x0a4e0,0x0d260,0x0ea65,0x0d530,//2020-2029
            0x05aa0,0x076a3,0x096d0,0x04afb,0x04ad0,0x0a4d0,0x1d0b6,0x0d250,0x0d520,0x0dd45,//2030-2039
            0x0b5a0,0x056d0,0x055b2,0x049b0,0x0a577,0x0a4b0,0x0aa50,0x1b255,0x06d20,0x0ada0,//2040-2049
            /**Add By JJonline@JJonline.Cn**/
            0x14b63,0x09370,0x049f8,0x04970,0x064b0,0x168a6,0x0ea50, 0x06b20,0x1a6c4,0x0aae0,//2050-2059
            0x092e0,0x0d2e3,0x0c960,0x0d557,0x0d4a0,0x0da50,0x05d55,0x056a0,0x0a6d0,0x055d4,//2060-2069
            0x052d0,0x0a9b8,0x0a950,0x0b4a0,0x0b6a6,0x0ad50,0x055a0,0x0aba4,0x0a5b0,0x052b0,//2070-2079
            0x0b273,0x06930,0x07337,0x06aa0,0x0ad50,0x14b55,0x04b60,0x0a570,0x054e4,0x0d160,//2080-2089
            0x0e968,0x0d520,0x0daa0,0x16aa6,0x056d0,0x04ae0,0x0a9d4,0x0a2d0,0x0d150,0x0f252,//2090-2099
            0x0d520};

int Month[12] = {31,28,31,30,31,30,31,31,30,31,30,31};
ChineseDate::ChineseDate()
{
    ChineseMonth<<""<<"正"<<"二"<<"三"<<"四"<<"五"<<"六"<<"七"<<"八"<<"九"<<"十"<<"冬"<<"腊";
    ChineseDay<<""<<"一"<<"二"<<"三"<<"四"<<"五"<<"六"<<"七"<<"八"<<"九";
    ChineseDays<<"初"<<"十"<<"廿"<<"三十";

}

int ChineseDate::getYearDays(int year)
{
    int sum = 12 * 29;
    for (unsigned int i = 0x8000; i > 0x8; i = i >> 1) {
        sum += chineseDays[year - 1900] & i ? 1 : 0;
    }
    sum += getLeapMonthDays(year);
    return sum;
}

bool ChineseDate::isLeapMonth(int year)
{
    return chineseDays[year - 1900] & 0xf ? true : false;
}

int ChineseDate::getLeapMonthDays(int year)
{
    if(isLeapMonth(year))
        return chineseDays[year-1900]& 0x10000 ? 30 : 29;
    return 0;
}

int ChineseDate::getLeapMonth(int year)
{
    if(isLeapMonth(year))
        return chineseDays[year-1900] & 0xf;
    return 0;
}

int ChineseDate::getYearMonthDays(int year,int month)
{
    return chineseDays[year-1900] & (0x10000 >> month) ? 30 : 29;
}

QString ChineseDate::getChineseDays(int month, int day, bool isleap)
{
    QString res = "";
    if(isleap)
        res = res + "闰";

    res = res + ChineseMonth.at(month) + "月";
    if(day == 10)
        res = res + "初十";
    else if(day == 20)
        res = res + "二十";
    else if(day == 30)
        res = res + "三十";
    else
        res = res + ChineseDays.at(day/10) + ChineseDay.at(day%10);
    return res;
}

QString ChineseDate::getDateLunar()
{
    int leapyear,leapmonth,leapday;
    QDateTime currentTime = QDateTime::currentDateTime();
    QDate oldTile(1900, 1, 31);
    //获取当前日期到1900年1月31日的天数
    int offset = oldTile.daysTo(currentTime.date());

    //获取农历年
    int i,yearlength;
    for (i = 1900; i < 2101 && offset > 0; i++) {
        yearlength = getYearDays(i);
        offset -= yearlength;
    }
    if (offset < 0) {
        offset += yearlength;
        i--;
    }
    leapyear = i;

    //获取农历月
    bool isLeap = false;
    int temp;
    int  leapMonth = getLeapMonth(leapyear);
    for (i = 1; i < 13 && offset >= 0; i++) {
        temp = getYearMonthDays(leapyear,i);
        offset -= temp;
        isLeap = false;
        if (i == leapMonth) {
            if (offset < 0) {
                i--;
                isLeap = true;
            } else {
                temp = getLeapMonthDays(leapyear);
                offset -= temp;
            }
        }
    }
    if (offset < 0) {
        if (i == leapMonth && isLeap) {
            offset += temp;
            isLeap = false;
        } else if (i == (leapMonth + 1)) {
            offset += temp;
            isLeap = true;
            i--;
        } else {
            offset += temp;
            i--;
        }
    }
    leapmonth = i;
    leapday = offset + 1;
    
    return getChineseDays(leapmonth,leapday,isLeap);
}
