/* female.c -- Female voice data
 *
 * Copyright (C) 1990, 1991 Speech Research Laboratory, Minsk
 * Copyright (C) 2005 Igor Poretsky <poretsky@mlbox.ru>
 * Copyright (C) 2021 Boris Lobanov <lobbormef@gmail.com>
 * Copyright (C) 2021 Alexander Ivanov <ivalex01@gmail.com>
 *
 * SPDX-License-Identifier: MIT
 */

#include <stdint.h>

#include "voice.h"


const voice_t female =
  {
    5000, /* Pitch factor */

    /* Sound offsets */
    {
      0, 51, 102,
      153, 204, 255,
      306, 357, 408,
      459, 510, 561,
      612, 663, 714,
      765, 816, 867,
      918, 969, 1020,
      1071, 1122, 1173,
      1224, 1275, 1326,
      1377, 1428, 1479,
      1530, 1581, 1632,
      1683, 1734, 1785,
      1836, 1887, 1938,
      1989, 2040, 2091,
      2142, 2193, 2244,
      2295, 2346, 2397,
      2448, 2499, 2550,
      2601, 2652, 2703,
      2754, 2805, 2856,
      2907, 2958, 3009,
      3060, 3111, 3162,
      3213, 3264, 3315,
      3366, 3417, 3468,
      3519, 3570, 3621,
      3672, 3723, 3774,
      3825, 3876, 3927,
      3978, 4029, 4080,
      4131, 4182, 4233,
      4284, 4335, 4386,
      4437, 4488, 4539,
      4590, 4641, 4692,
      4743, 4794, 4845,
      4896, 4947, 4998,
      5049, 5100, 5151,
      5202, 5253, 5304,
      5355, 5406, 5457,
      5508, 5559, 5610,
      5661, 5712, 5763,
      5814, 5865, 5916,
      5967, 5968, 6019,
      6070, 6121, 6172,
      6223, 6274, 6791,
      7098, 7734, 7785,
      7836, 8465, 8856,
      8857, 8858, 8909,
      8960, 9011, 9061,
      9112, 9163, 9294,
      9437, 9602, 9724,
      10015, 10279, 10496,
      10739, 11191, 11460,
      11983, 12564, 12679,
      12813, 13006, 13149,
      13284, 13460, 13646,
      13855, 14252, 14497,
      14739, 15324, 15375,
      15426, 15477, 15528,
      15579, 15630, 15631,
      15632, 15633, 15634,
      15635, 15636, 15637,
      15638, 15639, 15640,
      15641, 15642, 15643,
      15644, 15645, 15646,
      15647, 15648, 15649,
      15650, 15651, 15652,
      15653, 15654, 15655,
      15656, 15657, 15658,
      15659, 15660, 15661
    },

    /* Sound lengths */
    {
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      51, 51, 51,
      200, 51, 51,
      51, 51, 51,
      51, 517, 307,
      636, 51, 51,
      629, 391, 200,
      200, 51, 51,
      51, 50, 51,
      51, 131, 143,
      165, 122, 291,
      264, 217, 243,
      452, 269, 523,
      581, 115, 134,
      193, 143, 135,
      176, 186, 209,
      397, 245, 242,
      585, 51, 51,
      51, 51, 51,
      51, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200
    },

    /* Samples */
    {
      0, 42, 74, 94, 100,
      90, 65, 28, -11, -47,
      -74, -87, -82, -66, -45,
      -24, -7, 0, -4, -17,
      -35, -55, -71, -76, -71,
      -59, -39, -17, 4, 19,
      28, 26, 14, -4, -25,
      -44, -53, -47, -43, -40,
      -36, -33, -29, -26, -22,
      -19, -15, -12, -8, -5,
      -1, 0, -1, 21, 42,
      62, 76, 72, 47, 9,
      -34, -80, -110, -113, -97,
      -71, -37, -1, 25, 40,
      46, 39, 24, 13, 7,
      5, 7, 11, 11, 2,
      -11, -28, -48, -62, -67,
      -65, -58, -48, -39, -34,
      -29, -21, -16, -11, -10,
      -8, -7, -6, -4, -3,
      -2, 0, 0, 34, 81,
      99, 81, 39, -21, -89,
      -125, -103, -61, -21, 24,
      54, 55, 36, 19, 7,
      3, 13, 25, 20, -6,
      -35, -55, -67, -55, -20,
      12, 28, 30, 22, -2,
      -26, -35, -38, -38, -33,
      -27, -30, -35, -29, -20,
      -18, -15, -13, -10, -8,
      -5, -3, 0, 0, 1,
      16, 42, 86, 112, 84,
      39, 17, 6, -4, -9,
      -29, -71, -92, -72, -46,
      -39, -36, -32, -28, -5,
      38, 61, 45, 19, 6,
      -1, 4, 15, 1, -36,
      -59, -59, -56, -55, -59,
      -73, -80, -59, -26, -8,
      -4, -4, -6, -6, -5,
      -4, -3, -2, 0, 0,
      44, 64, 62, 63, 71,
      73, 78, 80, 64, 35,
      22, 19, 7, -10, -26,
      -47, -66, -73, -81, -95,
      -100, -99, -98, -89, -67,
      -50, -42, -34, -32, -36,
      -35, -25, -20, -24, -28,
      -36, -45, -45, -39, -42,
      -52, -55, -52, -47, -34,
      -28, -21, -14, -8, 0,
      0, 41, 73, 48, 11,
      22, 64, 76, 50, 23,
      17, 28, 43, 43, 13,
      -32, -50, -33, -23, -51,
      -91, -100, -79, -57, -48,
      -50, -57, -55, -36, -11,
      -6, -21, -28, -13, 8,
      11, 1, -9, -12, -10,
      -10, -9, -8, -7, -6,
      -5, -4, -3, -2, -2,
      -1, 0, 12, 35, 57,
      86, 112, 112, 90, 63,
      38, 12, -10, -24, -42,
      -67, -88, -93, -88, -81,
      -68, -52, -42, -37, -28,
      -11, 6, 20, 32, 38,
      34, 19, 3, -13, -34,
      -54, -68, -77, -87, -93,
      -88, -77, -64, -50, -37,
      -27, -20, -17, -13, -9,
      -5, -1, 0, 12, 47,
      100, 125, 86, 47, 40,
      30, -3, -45, -75, -83,
      -53, -11, 4, -7, -6,
      26, 50, 47, 11, -46,
      -63, -34, -25, -50, -60,
      -43, -29, -25, -31, -44,
      -45, -23, -3, -3, -7,
      -4, -10, -30, -43, -36,
      -19, -16, -14, -11, -9,
      -6, -4, -1, 0, 44,
      22, 0, 77, 112, 63,
      61, 99, 92, 65, 51,
      45, 42, 6, -43, -40,
      -31, -70, -101, -97, -93,
      -101, -108, -93, -60, -48,
      -50, -24, 2, -7, -20,
      -7, 6, -6, -26, -24,
      -13, -31, -56, -57, -55,
      -64, -61, -52, -44, -35,
      -26, -18, -9, -1, 0,
      35, 6, 16, 83, 75,
      39, 75, 102, 74, 61,
      75, 74, 48, 14, 10,
      15, -21, -56, -49, -44,
      -67, -103, -101, -66, -82,
      -113, -68, -34, -67, -65,
      -20, -23, -55, -49, -27,
      -33, -54, -48, -29, -42,
      -66, -61, -45, -47, -39,
      -32, -24, -16, -9, -1,
      0, 9, 13, 10, 7,
      11, 21, 26, 29, 36,
      43, 46, 47, 46, 41,
      27, 12, -3, -18, -30,
      -31, -26, -21, -17, -15,
      -16, -17, -16, -22, -38,
      -50, -50, -45, -36, -24,
      -13, -10, -13, -14, -15,
      -22, -25, -23, -26, -28,
      -26, -25, -13, -9, -5,
      0, 0, 7, 17, 28,
      39, 47, 50, 44, 33,
      18, 4, -9, -20, -26,
      -28, -27, -20, -12, -9,
      -8, -9, -12, -16, -19,
      -23, -23, -18, -9, 0,
      7, 11, 10, 2, -10,
      -24, -35, -42, -43, -41,
      -36, -28, -19, -12, -9,
      -7, -6, -5, -4, -3,
      -2, -1, 0, 1, 10,
      23, 34, 41, 39, 25,
      2, -22, -40, -50, -47,
      -31, -13, 1, 9, 13,
      9, 3, 1, 5, 12,
      22, 31, 34, 24, 8,
      -10, -26, -37, -38, -28,
      -19, -11, -6, -7, -13,
      -17, -15, -10, -9, -8,
      -7, -6, -6, -5, -4,
      -3, -2, 0, 0, 11,
      34, 47, 50, 44, 28,
      8, -4, -7, -9, -9,
      -10, -17, -30, -38, -37,
      -29, -17, -2, 9, 9,
      3, -2, -4, 0, 10,
      19, 18, 8, -8, -26,
      -40, -42, -36, -26, -20,
      -17, -20, -23, -20, -12,
      -2, 9, 7, 6, 5,
      4, 2, 1, 0, 0,
      -1, 8, 22, 36, 46,
      50, 44, 31, 16, 3,
      -6, -10, -10, -9, -13,
      -20, -29, -39, -46, -47,
      -43, -37, -28, -19, -14,
      -12, -10, -9, -7, -4,
      -1, -2, -7, -15, -24,
      -31, -34, -33, -31, -29,
      -29, -29, -31, -32, -29,
      -20, -15, -10, -5, 0,
      0, -1, 14, 31, 46,
      57, 62, 59, 48, 31,
      12, -7, -24, -35, -37,
      -35, -30, -26, -23, -24,
      -28, -34, -42, -48, -47,
      -41, -31, -21, -13, -6,
      -1, 1, 0, -3, -7,
      -12, -16, -19, -19, -16,
      -8, -4, -4, -4, -3,
      -3, -2, -2, -1, -1,
      0, 0, 4, 17, 32,
      53, 70, 75, 68, 53,
      27, -6, -35, -56, -70,
      -73, -63, -48, -32, -17,
      -5, -1, -2, -3, -6,
      -7, -4, 1, 7, 12,
      16, 15, 10, 2, -9,
      -24, -38, -50, -57, -60,
      -54, -45, -35, -25, -16,
      -8, -3, -3, -2, -2,
      -1, 0, 0, 12, 20,
      26, 40, 53, 69, 91,
      93, 65, 27, -10, -46,
      -57, -40, -15, 7, 27,
      29, 11, -11, -31, -53,
      -63, -60, -59, -64, -65,
      -64, -64, -51, -34, -31,
      -30, -28, -29, -26, -25,
      -23, -21, -20, -18, -16,
      -14, -13, -11, -9, -7,
      -6, -4, 0, 0, 16,
      27, 50, 75, 81, 78,
      70, 47, 20, 7, 1,
      -13, -29, -39, -52, -58,
      -44, -28, -26, -29, -30,
      -31, -25, -8, 6, 7,
      3, 3, -2, -10, -16,
      -27, -41, -48, -46, -42,
      -37, -31, -29, -32, -30,
      -20, -10, -9, -8, -6,
      -5, -4, -2, 0, 0,
      8, 24, 19, 15, 28,
      43, 42, 41, 38, 29,
      25, 31, 29, 9, -4,
      -5, -8, -20, -30, -42,
      -55, -58, -54, -56, -63,
      -62, -53, -43, -35, -31,
      -34, -35, -27, -18, -15,
      -17, -20, -20, -17, -13,
      -13, -17, -22, -21, -13,
      -11, -8, -6, -3, 0,
      0, 6, 5, -6, -19,
      -20, -10, 7, 17, 9,
      6, 18, 33, 34, 28,
      21, 15, 18, 21, 18,
      6, -7, -13, -16, -21,
      -21, -23, -35, -44, -36,
      -27, -30, -42, -50, -36,
      -15, -8, -3, -3, -3,
      -2, -2, -2, -2, -2,
      -2, -2, -1, -1, -1,
      -1, 0, 17, 43, 50,
      45, 45, 43, 41, 45,
      46, 36, 19, 10, 4,
      -7, -21, -29, -35, -39,
      -37, -34, -36, -38, -35,
      -29, -28, -19, -1, 17,
      24, 18, 6, -11, -21,
      -16, -10, -15, -27, -38,
      -44, -43, -39, -37, -36,
      -37, -31, -25, -19, -13,
      -7, -1, 0, 2, 33,
      50, 28, 2, 5, 18,
      17, 1, -20, -34, -24,
      -3, -4, -25, -30, -12,
      7, 14, 12, 4, 4,
      18, 28, 15, -10, -18,
      -10, -5, -11, -21, -28,
      -25, -13, -12, -26, -32,
      -18, -16, -15, -14, -12,
      -11, -9, -8, -6, -5,
      -4, -2, -1, 0, 4,
      10, 22, 44, 49, 37,
      36, 41, 34, 23, 12,
      -6, -18, -14, -17, -36,
      -44, -38, -33, -29, -23,
      -19, -12, 5, 19, 20,
      16, 19, 25, 26, 18,
      5, -5, -8, -12, -26,
      -44, -50, -44, -36, -36,
      -37, -30, -15, -12, -10,
      -8, -5, -3, 0, 0,
      14, 31, 32, 27, 37,
      50, 46, 34, 28, 24,
      19, 13, 0, -19, -26,
      -25, -34, -49, -48, -37,
      -34, -33, -26, -19, -11,
      2, 11, 11, 14, 23,
      24, 17, 12, 7, -7,
      -18, -21, -26, -35, -41,
      -41, -42, -40, -35, -34,
      -32, -24, -16, -8, -1,
      0, 4, 39, 47, 47,
      53, 54, 45, 45, 49,
      32, 21, 26, 30, 22,
      13, 8, -15, -34, -36,
      -40, -54, -63, -61, -61,
      -56, -39, -30, -33, -31,
      -23, -18, -17, -12, -13,
      -22, -20, -12, -9, -12,
      -11, -10, -9, -8, -7,
      -6, -5, -4, -3, -2,
      -1, 0, 2, 7, 10,
      13, 24, 51, 75, 72,
      58, 52, 45, 34, 27,
      13, -12, -27, -27, -31,
      -41, -45, -47, -49, -40,
      -22, -12, -6, 3, 13,
      21, 29, 36, 35, 27,
      22, 18, 11, 4, -6,
      -22, -37, -46, -50, -51,
      -48, -44, -42, -36, -25,
      -14, 0, 0, 3, 20,
      38, 52, 73, 93, 90,
      66, 39, 13, -9, -21,
      -32, -42, -35, -15, -2,
      -1, -11, -27, -37, -41,
      -46, -51, -55, -64, -77,
      -81, -70, -54, -44, -35,
      -23, -14, -9, -9, -8,
      -8, -8, -7, -7, -6,
      -6, -6, -5, -5, -4,
      -4, -3, -3, 0, 3,
      11, 15, 33, 67, 81,
      63, 49, 52, 51, 40,
      19, -10, -29, -28, -31,
      -50, -62, -56, -38, -21,
      -18, -29, -35, -18, 2,
      2, -6, -5, 3, 12,
      7, -14, -36, -42, -39,
      -44, -51, -54, -50, -40,
      -32, -30, -26, -22, -18,
      -14, -9, -5, -1, 0,
      16, 29, 28, 24, 36,
      50, 49, 36, 30, 30,
      31, 25, 8, -13, -20,
      -15, -16, -29, -44, -49,
      -48, -49, -57, -63, -60,
      -49, -40, -39, -41, -40,
      -32, -26, -26, -30, -30,
      -24, -17, -16, -19, -23,
      -21, -17, -14, -15, -12,
      -10, -8, -6, -4, -1,
      0, 4, 5, 3, 2,
      3, 7, 12, 18, 25,
      32, 38, 40, 38, 32,
      23, 12, 1, -9, -17,
      -21, -21, -18, -15, -14,
      -16, -22, -32, -42, -49,
      -50, -45, -33, -21, -10,
      0, 7, 6, 1, -5,
      -8, -11, -15, -19, -20,
      -17, -13, -10, -7, -4,
      0, 0, 1, 12, 24,
      33, 42, 48, 50, 47,
      41, 32, 21, 8, -3,
      -13, -21, -28, -32, -35,
      -37, -37, -36, -33, -30,
      -26, -19, -12, -3, 7,
      18, 27, 31, 30, 24,
      12, -5, -22, -36, -45,
      -49, -47, -41, -32, -25,
      -19, -14, -11, -8, -6,
      -3, 0, 0, 1, 5,
      11, 16, 18, 16, 16,
      26, 44, 50, 38, 16,
      -6, -21, -26, -23, -19,
      -22, -29, -31, -26, -16,
      -2, 11, 18, 20, 19,
      18, 19, 18, 11, 0,
      -12, -21, -25, -26, -22,
      -20, -22, -25, -29, -29,
      -21, -18, -15, -12, -9,
      -6, -3, -1, 0, -1,
      18, 39, 45, 36, 34,
      43, 45, 34, 21, 5,
      -8, -11, -10, -25, -46,
      -50, -39, -27, -23, -22,
      -20, -16, -4, 13, 20,
      15, 14, 21, 23, 14,
      2, -10, -22, -28, -29,
      -33, -41, -44, -38, -30,
      -25, -21, -15, -13, -10,
      -8, -6, -3, -1, 0,
      3, 17, 26, 25, 27,
      39, 48, 45, 38, 33,
      27, 21, 19, 10, -11,
      -27, -28, -28, -34, -37,
      -35, -42, -50, -42, -26,
      -24, -25, -15, -7, -5,
      1, 8, -3, -20, -18,
      -9, -14, -24, -27, -28,
      -31, -29, -23, -28, -33,
      -24, -18, -12, -7, -1,
      0, 4, 21, 38, 51,
      58, 62, 62, 58, 49,
      35, 20, 4, -11, -22,
      -30, -32, -33, -32, -32,
      -35, -39, -44, -47, -46,
      -42, -35, -27, -19, -10,
      -3, 2, 5, 4, -1,
      -7, -14, -19, -24, -26,
      -25, -23, -18, -16, -14,
      -12, -10, -8, -5, -3,
      -1, 0, 7, 31, 52,
      67, 70, 58, 36, 8,
      -21, -44, -57, -59, -56,
      -50, -47, -47, -50, -54,
      -55, -51, -39, -21, 1,
      21, 36, 43, 46, 53,
      60, 65, 71, 75, 70,
      58, 41, 19, -5, -26,
      -38, -43, -41, -36, -29,
      -26, -27, -29, -31, -31,
      -26, 0, 0, 18, 43,
      70, 93, 93, 62, 26,
      3, -7, -9, -9, -14,
      -23, -23, -13, -1, 3,
      -3, -20, -38, -45, -41,
      -35, -31, -33, -42, -52,
      -54, -51, -45, -37, -28,
      -22, -19, -15, -14, -13,
      -13, -12, -11, -10, -9,
      -8, -7, -6, -5, -4,
      -3, -2, -1, 0, 20,
      30, 21, 27, 41, 46,
      57, 68, 51, 25, 27,
      34, 14, -14, -31, -42,
      -47, -36, -38, -67, -82,
      -68, -54, -46, -33, -29,
      -34, -20, 5, 5, -13,
      -17, -12, -14, -14, -11,
      -24, -43, -42, -33, -34,
      -36, -31, -27, -23, -19,
      -14, -10, -6, -2, 0,
      8, 9, 9, 22, 35,
      38, 42, 44, 33, 23,
      28, 30, 12, -6, -13,
      -21, -33, -39, -40, -52,
      -63, -58, -49, -49, -48,
      -41, -39, -39, -30, -22,
      -27, -32, -31, -34, -44,
      -49, -46, -47, -50, -51,
      -54, -59, -58, -50, -44,
      -39, -30, -20, -11, -1,
      0, 9, 24, 38, 48,
      50, 42, 31, 21, 9,
      0, -2, -1, 0, 3,
      2, -2, -9, -17, -27,
      -34, -34, -30, -22, -13,
      -4, 2, 5, 3, -3,
      -9, -14, -15, -11, -4,
      0, 0, -3, -5, -9,
      -14, -18, -18, -16, -14,
      -11, -9, -7, -5, -3,
      -1, 0, 16, 31, 44,
      50, 44, 31, 17, 5,
      -4, -5, -1, 4, 6,
      3, -8, -23, -36, -42,
      -41, -31, -18, -5, 4,
      10, 11, 7, 4, 1,
      -2, -2, -1, -1, -3,
      -6, -11, -17, -22, -26,
      -29, -27, -25, -22, -19,
      -17, -14, -11, -9, -6,
      -4, -1, 0, 23, 45,
      50, 41, 20, -6, -20,
      -17, -13, -11, -12, -19,
      -25, -20, -5, 10, 21,
      24, 17, 4, -4, -6,
      -5, -4, -4, -9, -16,
      -18, -17, -12, -6, -4,
      -8, -10, -9, -7, -1,
      2, -1, -9, -15, -19,
      -17, -15, -13, -10, -8,
      -5, -3, -1, 0, 2,
      10, 24, 42, 50, 48,
      42, 30, 16, 10, 6,
      -6, -16, -25, -34, -37,
      -31, -26, -22, -16, -13,
      -13, -9, -3, 0, 3,
      5, 1, -2, -3, -6,
      -13, -20, -28, -37, -41,
      -40, -36, -32, -29, -28,
      -26, -20, -14, -8, -5,
      -6, -4, -2, -1, 0,
      8, 8, 9, 23, 41,
      50, 49, 42, 30, 22,
      24, 24, 12, -4, -16,
      -26, -28, -25, -29, -38,
      -42, -39, -32, -21, -13,
      -14, -16, -10, -3, 3,
      9, 8, 0, -5, -6,
      -10, -17, -23, -32, -37,
      -33, -30, -31, -29, -26,
      -27, -24, -16, -13, 0,
      0, 8, 25, 39, 49,
      54, 50, 38, 24, 9,
      -3, -13, -16, -13, -9,
      -4, -3, -8, -19, -33,
      -49, -60, -63, -59, -49,
      -35, -22, -11, -5, -4,
      -7, -13, -18, -21, -20,
      -15, -14, -14, -13, -12,
      -11, -10, -9, -8, -7,
      -6, -5, -4, -3, -2,
      -1, 0, 5, 29, 51,
      67, 75, 68, 48, 24,
      4, -13, -22, -21, -16,
      -13, -14, -21, -32, -39,
      -42, -37, -26, -12, -1,
      5, 7, 5, 0, -4,
      -6, -7, -7, -9, -12,
      -16, -21, -24, -27, -27,
      -26, -23, -21, -18, -16,
      -14, -12, -9, -7, -5,
      -3, -1, 0, 17, 62,
      91, 93, 69, 23, -26,
      -57, -65, -59, -41, -23,
      -12, -4, 8, 11, 12,
      16, 14, 1, -14, -29,
      -43, -44, -33, -22, -13,
      -11, -18, -24, -25, -23,
      -21, -13, -8, -10, -12,
      -16, -27, -33, -31, -27,
      -23, -20, -17, -14, -11,
      -7, -4, -1, 0, 2,
      16, 29, 52, 75, 81,
      72, 57, 32, 4, -9,
      -15, -25, -33, -41, -54,
      -60, -54, -40, -24, -10,
      -4, -7, -12, -13, -9,
      -1, 7, 9, 3, -6,
      -19, -30, -37, -41, -46,
      -48, -46, -46, -44, -40,
      -38, -36, -29, -21, -17,
      -13, -9, -5, -1, 0,
      24, 45, 58, 62, 55,
      48, 49, 48, 36, 24,
      12, -5, -17, -21, -30,
      -42, -46, -45, -47, -44,
      -37, -35, -34, -25, -16,
      -11, -5, 2, 3, 4,
      7, 4, -5, -13, -21,
      -31, -34, -34, -38, -39,
      -39, -40, -41, -38, -34,
      -29, -22, -15, -8, -1,
      0, 2, 7, -3, 8,
      20, 9, 3, 20, 28,
      13, 8, 17, 21, 13,
      8, 7, 3, 15, 16,
      -17, -36, -20, -7, -29,
      -50, -35, -18, -18, -22,
      -30, -41, -33, -12, -23,
      -37, -16, -4, -16, -24,
      -10, 3, -3, -7, -2,
      -7, -1, 14, -2, -17,
      0, 0, 22, 26, 13,
      17, 39, 50, 39, 26,
      25, 32, 37, 30, 11,
      -1, 5, 11, -7, -33,
      -31, -10, -13, -38, -48,
      -30, -13, -16, -24, -22,
      -9, 5, 4, -13, -26,
      -19, -7, -14, -32, -33,
      -17, -13, -27, -36, -30,
      -21, -20, -24, -18, -12,
      -6, -1, 0, 10, 30,
      32, 24, 32, 49, 50,
      37, 29, 26, 19, 12,
      2, -16, -27, -23, -23,
      -36, -40, -30, -23, -25,
      -23, -14, -3, 8, 14,
      13, 15, 23, 25, 12,
      -2, -9, -12, -18, -29,
      -40, -42, -37, -34, -39,
      -40, -32, -21, -13, -10,
      -7, -4, -1, 0, 23,
      23, 10, 25, 46, 40,
      28, 35, 44, 41, 32,
      21, 17, 16, 0, -19,
      -20, -18, -35, -50, -44,
      -37, -44, -49, -41, -28,
      -22, -24, -21, -7, -1,
      -10, -14, -7, 0, -7,
      -17, -14, -10, -19, -29,
      -30, -29, -28, -23, -19,
      -14, -10, -5, -1, 0,
      4, 14, 4, 15, 40,
      37, 24, 36, 50, 39,
      32, 39, 36, 22, 15,
      5, -5, -10, -18, -27,
      -35, -41, -46, -47, -48,
      -46, -42, -38, -35, -28,
      -22, -23, -23, -21, -22,
      -23, -20, -20, -22, -23,
      -22, -29, -34, -35, -38,
      -33, -7, -5, -3, -1,
      0, 20, 37, 38, 29,
      19, 12, 13, 25, 39,
      44, 37, 23, 6, -6,
      -7, 1, 9, 6, -8,
      -29, -51, -63, -56, -38,
      -19, -9, -9, -18, -28,
      -28, -16, -2, 4, 1,
      -9, -21, -29, -27, -18,
      -11, -7, -6, -5, -5,
      -4, -3, -3, -2, -1,
      -1, 0, 12, 33, 63,
      75, 53, 40, 53, 66,
      57, 37, 21, 5, -2,
      0, -7, -33, -57, -59,
      -51, -52, -58, -60, -55,
      -43, -27, -10, 0, 5,
      15, 25, 30, 24, 14,
      3, -11, -25, -36, -43,
      -46, -47, -48, -50, -50,
      -46, -42, -39, -38, -37,
      -33, 0, 0, 10, 33,
      61, 85, 81, 78, 93,
      88, 55, 34, 26, 11,
      -7, -27, -42, -40, -46,
      -72, -80, -65, -63, -67,
      -58, -51, -46, -33, -31,
      -38, -29, -19, -27, -35,
      -30, -26, -25, -25, -24,
      -22, -20, -19, -17, -15,
      -14, -12, -10, -9, -7,
      -5, -3, -2, 0, 35,
      12, 5, 57, 69, 32,
      38, 69, 58, 37, 40,
      33, 18, 7, -12, -20,
      -15, -30, -61, -62, -50,
      -68, -82, -63, -46, -47,
      -42, -29, -24, -22, -24,
      -27, -16, -5, -19, -29,
      -15, -13, -36, -42, -31,
      -27, -7, -6, -5, -4,
      -3, -3, -2, -1, 0,
      2, 20, 12, 5, 34,
      46, 20, 23, 54, 45,
      20, 33, 43, 18, 1,
      9, 8, -8, -22, -25,
      -24, -38, -58, -52, -36,
      -51, -63, -40, -27, -46,
      -45, -23, -23, -37, -29,
      -15, -18, -22, -18, -17,
      -17, -19, -22, -19, -5,
      -4, -3, -2, -2, -1,
      0, 25, 38, 11, 2,
      37, 50, 25, 17, 27,
      32, 32, 22, 1, 6,
      31, 16, -22, -22, 1,
      -10, -43, -48, -32, -24,
      -33, -47, -38, -19, -25,
      -41, -31, -9, -7, -16,
      -16, -6, 8, 7, -10,
      -10, 4, 5, -14, -12,
      -10, -8, -6, -5, -3,
      -1, 0, 10, 31, 17,
      1, 25, 50, 33, 15,
      25, 35, 28, 20, 10,
      -2, 0, 5, -15, -34,
      -21, -13, -35, -47, -32,
      -24, -28, -26, -20, -16,
      -6, -2, -12, -13, 1,
      2, -14, -19, -6, -1,
      -14, -24, -20, -14, -15,
      -24, -33, -29, -16, -11,
      -6, -1, 0, 18, 29,
      16, 23, 50, 50, 33,
      32, 34, 29, 25, 10,
      -10, -11, -9, -28, -45,
      -43, -34, -32, -37, -41,
      -28, -7, -3, -8, 2,
      20, 24, 19, 16, 16,
      13, 0, -18, -20, -17,
      -30, -45, -44, -37, -34,
      -36, -38, -31, -25, -19,
      -13, -7, 0, 0, 8,
      16, -2, 20, 50, 30,
      22, 47, 46, 32, 33,
      29, 25, 20, -5, -15,
      -7, -24, -43, -30, -28,
      -49, -47, -34, -33, -29,
      -23, -17, -5, 0, -3,
      5, 7, -5, -8, -3,
      -10, -18, -19, -23, -27,
      -28, -33, -36, -31, -25,
      -19, -13, -7, -1, 0,
      6, 15, -1, 10, 40,
      31, 15, 31, 40, 31,
      27, 25, 31, 31, 8,
      3, 18, -2, -29, -17,
      -18, -42, -42, -39, -50,
      -47, -46, -50, -37, -30,
      -39, -31, -24, -34, -31,
      -22, -26, -24, -16, -19,
      -17, -13, -18, -17, -9,
      -14, -11, -7, -4, -1,
      0, 2, 6, 20, 39,
      30, 20, 40, 51, 34,
      31, 45, 39, 28, 31,
      29, 16, 14, 11, -12,
      -25, -20, -38, -63, -56,
      -47, -59, -59, -46, -46,
      -52, -46, -43, -41, -27,
      -19, -23, -18, -6, -6,
      -13, -11, -10, -9, -8,
      -7, -6, -5, -3, -2,
      -1, 0, 18, 46, 43,
      40, 64, 75, 62, 58,
      54, 43, 41, 34, 9,
      -7, -7, -19, -41, -52,
      -55, -54, -48, -52, -59,
      -47, -28, -23, -23, -13,
      -1, 8, 15, 12, 8,
      11, 8, -6, -14, -13,
      -14, -21, -29, -33, -28,
      -21, -23, -28, -24, -14,
      -7, 0, 0, -3, 26,
      46, 43, 47, 69, 71,
      55, 49, 43, 35, 27,
      10, -6, -8, -17, -49,
      -77, -76, -71, -85, -94,
      -84, -68, -57, -52, -49,
      -37, -23, -22, -28, -25,
      -20, -18, -22, -26, -24,
      -14, -13, -12, -11, -10,
      -9, -8, -7, -6, -5,
      -4, -3, -2, 0, 8,
      25, 6, 17, 54, 56,
      39, 47, 59, 56, 45,
      34, 31, 30, 10, -13,
      -17, -25, -44, -61, -74,
      -77, -74, -81, -82, -62,
      -49, -52, -47, -37, -35,
      -32, -26, -22, -17, -16,
      -17, -14, -15, -25, -26,
      -23, -29, -33, -28, -23,
      -17, -12, -7, -1, 0,
      7, 21, 14, 14, 34,
      34, 22, 28, 37, 33,
      27, 27, 30, 23, 7,
      1, 9, 1, -21, -24,
      -19, -37, -56, -51, -46,
      -59, -63, -49, -42, -53,
      -55, -42, -36, -44, -40,
      -22, -17, -23, -19, -8,
      -9, -16, -15, -13, -11,
      -9, -7, -5, -3, -1,
      0, 14, 32, 20, 1,
      17, 48, 44, 12, 7,
      38, 50, 20, -1, 19,
      34, 12, -8, 3, 16,
      -1, -21, -18, -12, -22,
      -32, -28, -25, -31, -34,
      -28, -26, -30, -30, -25,
      -22, -22, -19, -15, -12,
      -7, -6, -9, -8, -7,
      -6, -5, -4, -3, -2,
      -1, 0, 5, 23, 19,
      6, 15, 41, 50, 31,
      17, 28, 42, 34, 13,
      2, 4, 3, -7, -20,
      -30, -32, -28, -26, -29,
      -34, -33, -21, -11, -12,
      -15, -8, 4, 8, 2,
      -2, -1, -2, -7, -11,
      -12, -15, -18, -20, -20,
      -21, -23, -23, -18, -12,
      -6, -1, 0, 30, 50,
      17, -13, 5, 25, -1,
      -38, -43, -29, -25, -34,
      -44, -41, -24, -6, -5,
      -10, 2, 28, 36, 15,
      -4, -2, 1, -12, -34,
      -44, -38, -30, -33, -39,
      -40, -37, -34, -27, -19,
      -21, -19, -18, -16, -14,
      -13, -11, -9, -8, -6,
      -4, -2, -1, 0, 10,
      -1, -2, 31, 36, 18,
      31, 50, 40, 26, 33,
      39, 23, 4, 8, 7,
      -17, -30, -21, -24, -39,
      -42, -34, -32, -40, -36,
      -21, -19, -23, -12, -1,
      -4, -6, -3, -4, -11,
      -13, -12, -15, -19, -22,
      -24, -24, -28, -32, -33,
      -25, -17, -9, -1, 0,
      1, 2, 20, 31, 26,
      29, 44, 48, 39, 40,
      46, 38, 23, 18, 20,
      7, -9, -12, -15, -32,
      -42, -36, -38, -50, -49,
      -37, -37, -44, -37, -25,
      -26, -30, -20, -15, -22,
      -26, -22, -21, -28, -32,
      -28, -25, -33, -34, -30,
      -32, -33, -22, -12, -1,
      0, 8, 35, 48, 42,
      39, 44, 44, 42, 49,
      57, 53, 36, 25, 21,
      20, 19, 13, -3, -23,
      -37, -45, -52, -58, -60,
      -59, -61, -63, -60, -53,
      -49, -50, -48, -44, -35,
      -24, -15, -12, -12, -12,
      -11, -12, -13, -12, -10,
      -9, -7, -6, -4, -3,
      -1, 0, 30, 49, 37,
      33, 59, 75, 60, 46,
      46, 41, 28, 25, 19,
      -3, -26, -31, -27, -31,
      -38, -46, -56, -54, -40,
      -39, -44, -36, -22, -19,
      -18, -5, 3, -1, -5,
      1, -2, -14, -18, -13,
      -14, -22, -25, -26, -31,
      -31, -26, -24, -26, -24,
      -18, 0, 0, 3, 43,
      43, 35, 73, 93, 64,
      53, 66, 52, 28, 20,
      17, -1, -23, -31, -31,
      -51, -74, -65, -51, -64,
      -67, -45, -32, -32, -26,
      -19, -16, -12, -10, -12,
      -11, -14, -20, -21, -23,
      -30, -30, -27, -25, -22,
      -20, -17, -15, -12, -10,
      -7, -5, -2, 0, 25,
      -6, 6, 61, 54, 32,
      57, 75, 60, 42, 45,
      53, 28, -1, 2, 5,
      -15, -39, -43, -36, -55,
      -82, -65, -48, -67, -71,
      -42, -30, -41, -38, -19,
      -18, -35, -30, -9, -14,
      -35, -29, -20, -35, -46,
      -37, -33, -43, -36, -29,
      -22, -15, -8, -2, 0,
      7, -2, 9, 29, 28,
      28, 41, 52, 48, 43,
      52, 55, 38, 31, 31,
      19, 2, -4, -3, -14,
      -32, -35, -34, -48, -59,
      -51, -49, -59, -62, -53,
      -51, -58, -54, -46, -53,
      -63, -58, -49, -55, -60,
      -46, -32, -38, -43, -38,
      -32, -33, -19, 0, 0,
      0, 25, 31, 11, 2,
      26, 50, 41, 19, 15,
      26, 30, 24, 12, -3,
      -15, -10, 5, 0, -29,
      -47, -33, -17, -22, -34,
      -35, -25, -15, -8, -9,
      -20, -28, -15, 3, 3,
      -11, -15, -6, 1, -2,
      -12, -20, -18, -16, -14,
      -12, -10, -7, -5, -3,
      -1, 0, 2, 36, 39,
      16, 10, 27, 43, 44,
      34, 21, 11, 14, 28,
      25, -2, -27, -28, -17,
      -18, -31, -42, -50, -47,
      -31, -18, -21, -30, -26,
      -10, -1, -1, -5, -5,
      -2, 4, 7, 3, -10,
      -18, -19, -17, -15, -14,
      -12, -10, -8, -6, -4,
      -2, 0, 0, 25, 36,
      23, 26, 47, 50, 37,
      27, 19, 13, 13, 3,
      -21, -33, -27, -23, -28,
      -38, -39, -26, -12, -11,
      -13, -2, 13, 19, 19,
      13, 11, 15, 12, -6,
      -22, -20, -18, -27, -35,
      -38, -35, -28, -27, -32,
      -28, -24, -20, -16, -12,
      -8, -4, -1, 0, 3,
      24, 24, 15, 36, 50,
      35, 31, 40, 34, 20,
      14, 8, 0, -9, -24,
      -29, -29, -39, -45, -41,
      -38, -34, -26, -23, -25,
      -15, -2, -4, -5, 5,
      8, 4, 2, -1, -8,
      -14, -20, -27, -29, -30,
      -37, -38, -33, -33, -33,
      -27, -21, -11, -1, 0,
      9, 1, 12, 41, 39,
      26, 39, 50, 40, 29,
      29, 28, 17, 0, -7,
      -8, -22, -38, -38, -37,
      -43, -47, -42, -36, -33,
      -29, -24, -13, -7, -8,
      0, 9, 6, 2, 4,
      0, -10, -13, -14, -25,
      -32, -30, -30, -38, -39,
      -35, -32, -21, -11, -1,
      0, 27, 62, 49, 23,
      23, 29, 29, 39, 46,
      23, -10, -8, 13, 11,
      -9, -21, -32, -45, -44,
      -26, -24, -46, -57, -41,
      -26, -22, -16, -16, -28,
      -32, -13, 6, 2, -10,
      -13, -13, -12, -11, -10,
      -9, -9, -8, -7, -6,
      -5, -5, -4, -3, -2,
      -1, 0, 26, 71, 60,
      34, 52, 75, 64, 44,
      24, -3, -16, -2, -9,
      -50, -68, -54, -45, -46,
      -47, -46, -41, -19, 5,
      3, -1, 12, 23, 20,
      7, -6, -20, -21, -13,
      -24, -46, -44, -34, -39,
      -49, -46, -41, -37, -32,
      -28, -23, -19, -14, -10,
      -5, -1, 0, 11, 47,
      93, 73, 42, 78, 92,
      41, 6, 0, -17, -34,
      -44, -59, -53, -29, -20,
      -30, -33, -11, 9, -5,
      -27, -19, -1, 0, -11,
      -25, -28, -24, -37, -68,
      -78, -52, -33, -47, -51,
      -26, -6, -13, -28, -27,
      -24, -21, -17, -14, -11,
      -8, -4, -1, 0, 30,
      49, 20, 32, 81, 66,
      34, 46, 49, 29, 16,
      1, -14, -15, -29, -56,
      -57, -40, -47, -63, -54,
      -38, -30, -34, -31, -13,
      -1, -6, -7, 4, 7,
      -2, -10, -17, -23, -21,
      -29, -48, -43, -30, -42,
      -50, -36, -26, -26, -23,
      -17, -12, -6, -1, 0,
      7, 19, -5, 21, 62,
      39, 22, 51, 59, 33,
      23, 35, 27, 1, -10,
      -13, -22, -36, -43, -39,
      -43, -53, -59, -49, -37,
      -51, -52, -26, -22, -34,
      -24, -6, -9, -22, -20,
      -19, -27, -27, -30, -40,
      -39, -38, -46, -47, -36,
      -34, -40, -27, -14, -1,
      0, 16, 27, 35, 37,
      33, 24, 10, -4, -18,
      -28, -33, -31, -25, -17,
      -9, -3, 0, -2, -7,
      -13, -21, -27, -29, -27,
      -22, -15, -7, 1, 7,
      10, 9, 5, -2, -10,
      -17, -20, -18, -17, -15,
      -14, -13, -11, -10, -9,
      -7, -6, -5, -3, -2,
      -1, 0, -1, 9, 17,
      26, 32, 30, 19, 4,
      -14, -33, -46, -47, -41,
      -30, -16, -1, 10, 16,
      19, 16, 10, 5, 3,
      2, 3, 5, 4, 0,
      -5, -12, -20, -26, -28,
      -27, -25, -20, -17, -15,
      -12, -9, -7, -5, -4,
      -4, -3, -3, -2, -2,
      -1, 0, 0, 17, 40,
      49, 40, 20, -11, -45,
      -63, -52, -31, -11, 12,
      27, 27, 18, 9, 3,
      1, 6, 12, 10, -3,
      -18, -28, -34, -28, -10,
      6, 14, 15, 11, -1,
      -13, -18, -19, -19, -17,
      -14, -15, -18, -15, -10,
      -9, -8, -7, -5, -4,
      -3, -2, 0, 0, 0,
      8, 21, 43, 56, 42,
      19, 8, 3, -2, -5,
      -15, -36, -46, -36, -23,
      -20, -18, -16, -14, -3,
      19, 30, 22, 9, 3,
      -1, 2, 7, 1, -18,
      -30, -30, -28, -28, -30,
      -37, -40, -30, -13, -4,
      -2, -2, -3, -3, -3,
      -2, -2, -1, 0, 0,
      11, 2, 5, 27, 25,
      13, 25, 34, 24, 20,
      25, 25, 16, 4, 3,
      5, -7, -19, -17, -15,
      -23, -35, -34, -22, -28,
      -38, -23, -12, -23, -22,
      -7, -8, -19, -17, -9,
      -11, -18, -16, -10, -14,
      -22, -21, -15, -16, -13,
      -11, -8, -6, -3, -1,
      0, 32, 55, 70, 75,
      67, 49, 21, -8, -35,
      -56, -65, -62, -49, -34,
      -18, -5, 0, -3, -13,
      -26, -42, -53, -57, -54,
      -44, -30, -13, 3, 14,
      21, 19, 11, -3, -19,
      -33, -40, -35, -33, -30,
      -27, -25, -22, -19, -17,
      -14, -11, -9, -6, -4,
      -1, 0, 19, 42, 67,
      77, 66, 41, 6, -33,
      -69, -82, -73, -54, -27,
      4, 27, 40, 46, 41,
      23, 6, -7, -20, -24,
      -18, -9, -2, 6, 12,
      6, -2, -12, -25, -39,
      -45, -44, -39, -28, -12,
      2, 11, 17, 17, 9,
      -3, -13, -11, -8, -6,
      -3, 0, 0, 25, 61,
      74, 60, 29, -16, -67,
      -94, -77, -46, -16, 18,
      40, 41, 27, 14, 5,
      2, 10, 19, 15, -5,
      -27, -42, -50, -41, -15,
      9, 21, 23, 16, -2,
      -19, -27, -28, -28, -25,
      -20, -23, -26, -22, -15,
      -14, -12, -10, -8, -6,
      -4, -2, 0, 0, 44,
      93, 83, 37, 25, 37,
      29, 1, -26, -54, -63,
      -36, -14, -30, -42, -11,
      23, 20, 1, -4, -4,
      -2, 2, -12, -36, -35,
      -13, -11, -32, -53, -61,
      -51, -22, -6, -23, -34,
      -15, 6, 7, 0, -8,
      -10, -9, -8, -7, -6,
      -5, -4, -2, 0, 0,
      5, 32, 32, 17, 28,
      54, 50, 34, 37, 38,
      26, 26, 23, 1, -5,
      6, -10, -44, -53, -47,
      -57, -69, -68, -69, -67,
      -50, -41, -52, -50, -32,
      -26, -28, -21, -14, -16,
      -11, -4, -12, -19, -13,
      -11, -17, -16, -12, -10,
      -8, -6, -4, -2, 0,
      0, 11, 35, 55, 68,
      68, 52, 30, 14, 7,
      9, 17, 25, 24, 11,
      -9, -28, -45, -56, -57,
      -54, -53, -54, -53, -52,
      -47, -37, -26, -17, -14,
      -13, -14, -17, -17, -14,
      -11, -11, -14, -13, -12,
      -11, -10, -9, -8, -7,
      -6, -5, -4, -3, -2,
      -1, 0, 5, 18, 24,
      21, 15, 11, 22, 51,
      76, 81, 69, 44, 7,
      -25, -38, -33, -24, -18,
      -16, -24, -40, -48, -37,
      -13, 7, 19, 21, 11,
      -5, -12, -4, 11, 21,
      22, 9, -19, -49, -65,
      -63, -51, -38, -26, -23,
      -26, -29, -25, -13, -9,
      -5, -1, 0, 5, 22,
      47, 90, 106, 64, 17,
      3, -6, -25, -39, -48,
      -39, 5, 44, 36, 13,
      14, 19, 7, -20, -54,
      -67, -51, -43, -51, -47,
      -27, -14, -14, -22, -34,
      -36, -23, -13, -18, -32,
      -41, -32, -29, -26, -23,
      -20, -18, -15, -12, -9,
      -6, -4, -1, 0, 18,
      39, 11, 40, 93, 72,
      50, 74, 76, 51, 37,
      22, 13, 3, -30, -42,
      -41, -71, -88, -79, -88,
      -92, -70, -59, -48, -20,
      -9, -13, -3, 3, 0,
      1, -4, -13, -12, -16,
      -34, -41, -44, -56, -56,
      -41, -36, -31, -26, -21,
      -16, -11, -6, 0, 0,
      21, 2, 14, 55, 47,
      28, 53, 65, 45, 41,
      49, 46, 28, 8, 9,
      9, -20, -36, -19, -34,
      -69, -59, -44, -65, -68,
      -46, -42, -47, -41, -30,
      -28, -37, -36, -22, -25,
      -34, -21, -14, -28, -31,
      -23, -23, -28, -24, -20,
      -16, -12, -8, -4, 0,
      0, 1, 9, 20, 28,
      31, 29, 22, 10, -1,
      -8, -12, -11, -6, -5,
      -9, -15, -21, -25, -24,
      -16, -6, 4, 12, 15,
      11, 5, 0, -2, -1,
      2, 4, 1, -4, -11,
      -21, -29, -32, -30, -24,
      -18, -13, -9, -8, -8,
      -7, -5, -4, -3, -2,
      -1, 0, 20, 31, 24,
      18, 21, 26, 30, 26,
      9, -3, 1, 3, -5,
      -17, -28, -29, -19, -16,
      -23, -26, -17, -7, 1,
      4, 1, 3, 12, 17,
      14, 7, 3, 3, 4,
      -5, -20, -28, -25, -22,
      -23, -29, -32, -25, -14,
      -9, -12, -9, -7, -5,
      -3, 0, 0, 2, 7,
      11, 20, 36, 42, 28,
      12, 12, 18, 13, -1,
      -13, -19, -17, -12, -9,
      -13, -18, -13, 0, 8,
      3, -4, -2, 3, 3,
      1, -1, -5, -10, -13,
      -18, -26, -30, -24, -16,
      -16, -20, -19, -12, -7,
      -6, -5, -4, -4, -3,
      -2, -1, -1, 0, 4,
      12, 22, 31, 29, 20,
      14, 17, 21, 16, 2,
      -10, -13, -12, -13, -18,
      -21, -22, -22, -18, -12,
      -8, -7, -8, -8, -4,
      3, 6, 3, -3, -10,
      -17, -21, -20, -17, -17,
      -24, -31, -26, -14, -5,
      -3, -3, -3, -2, -2,
      -2, -1, -1, -1, 0,
      12, 22, 14, 14, 28,
      38, 35, 29, 29, 32,
      32, 28, 18, 4, 0,
      -3, -16, -29, -33, -32,
      -38, -47, -50, -50, -47,
      -41, -38, -37, -34, -26,
      -21, -23, -21, -16, -18,
      -26, -28, -21, -18, -25,
      -30, -28, -26, -27, -28,
      -27, -27, -25, -19, 0,
      0, 2, 7, 5, 6,
      19, 23, 11, 15, 31,
      25, 10, 19, 25, 8,
      -1, 7, 5, -10, -15,
      -12, -17, -27, -29, -27,
      -26, -31, -30, -23, -22,
      -23, -17, -8, -10, -9,
      -1, 0, -3, 1, -1,
      -5, -4, -4, -10, -11,
      -9, -17, -23, -19, -22,
      0, 0, 1, 10, 7,
      8, 14, 18, 19, 15,
      15, 22, 20, 9, 10,
      16, 6, -2, -1, -3,
      -7, -13, -20, -19, -18,
      -30, -32, -22, -24, -31,
      -24, -19, -23, -23, -19,
      -17, -15, -16, -19, -14,
      -11, -18, -19, -12, -13,
      -12, -10, -8, -6, -5,
      -3, -1, 0, 6, 10,
      1, 12, 24, 11, 9,
      22, 18, 8, 14, 16,
      7, 5, 5, 3, -1,
      -10, -12, -8, -18, -29,
      -18, -16, -32, -28, -15,
      -21, -26, -16, -14, -22,
      -20, -14, -16, -18, -13,
      -12, -10, -12, -14, -11,
      -8, -11, -10, -8, -6,
      -4, -2, 0, 0, 1,
      10, 19, 26, 31, 30,
      23, 13, 2, -9, -18,
      -19, -17, -14, -11, -8,
      -9, -13, -16, -16, -14,
      -9, -1, 5, 9, 11,
      10, 6, 1, -2, -5,
      -7, -10, -12, -17, -23,
      -26, -26, -26, -23, -16,
      -10, -5, 0, 4, 3,
      1, 0, 0, 0, 0,
      5, 19, 27, 27, 27,
      27, 21, 20, 25, 19,
      9, 3, -5, -11, -13,
      -16, -20, -21, -24, -30,
      -29, -27, -27, -24, -19,
      -16, -11, -3, -2, -8,
      -9, -13, -19, -20, -16,
      -15, -21, -25, -28, -28,
      -21, -19, -25, -32, -28,
      -22, -17, -12, -6, -1,
      0, 6, 17, 23, 30,
      38, 43, 43, 36, 25,
      15, 11, 9, 2, -9,
      -18, -20, -18, -17, -16,
      -18, -21, -23, -23, -22,
      -18, -9, 2, 8, 7,
      2, -3, -8, -15, -20,
      -19, -13, -11, -13, -19,
      -28, -31, -21, -19, -16,
      -14, -11, -9, -6, -3,
      -1, 0, 10, 6, 2,
      4, 9, 18, 24, 26,
      24, 16, 4, -6, -6,
      -2, 0, -5, -12, -17,
      -20, -19, -12, -6, -9,
      -18, -25, -23, -14, -5,
      -3, -4, -5, -10, -19,
      -23, -24, -22, -12, -5,
      -11, -25, -32, -21, 0,
      7, -9, -20, -15, -10,
      -6, -1, 0, 0, 8,
      19, 27, 30, 31, 29,
      26, 20, 11, 1, -4,
      -8, -12, -16, -16, -14,
      -13, -14, -17, -20, -22,
      -24, -25, -27, -29, -28,
      -26, -20, -12, -9, -12,
      -15, -18, -21, -23, -26,
      -29, -30, -28, -24, -20,
      -17, -13, -11, -9, -7,
      -6, -4, -2, -1, 0,
      7, 23, 26, 23, 26,
      26, 25, 31, 31, 19,
      10, 6, 3, 1, 3,
      -3, -17, -14, -8, -12,
      -12, -9, -15, -25, -25,
      -18, -13, -13, -15, -22,
      -27, -25, -10, -8, -15,
      -17, -24, -19, -8, -13,
      -17, -21, -30, -26, -22,
      -17, -13, -9, -5, -1,
      0, 0, 17, 27, 23,
      16, 9, 4, 5, 7,
      6, 5, 6, -3, -18,
      -20, -10, -4, -6, -12,
      -22, -33, -34, -27, -18,
      -6, 5, 2, -10, -18,
      -21, -21, -16, -7, -1,
      -2, -8, -16, -18, -15,
      -11, -10, -10, -9, -8,
      -7, -5, -4, -3, -2,
      -1, 0, 1, 3, 7,
      14, 18, 17, 16, 14,
      15, 14, 10, 7, 5,
      1, 0, 2, -1, -12,
      -21, -27, -30, -32, -30,
      -25, -21, -22, -23, -23,
      -24, -23, -18, -12, -7,
      -4, -6, -9, -5, -2,
      -11, -16, -10, -9, -8,
      -7, -6, -5, -4, -3,
      -2, -1, 0, 8, 19,
      21, 26, 33, 34, 30,
      26, 26, 24, 15, 8,
      4, -7, -17, -25, -34,
      -41, -43, -44, -42, -37,
      -38, -39, -31, -28, -30,
      -22, -12, -12, -10, -8,
      -11, -14, -18, -24, -25,
      -24, -32, -38, -35, -37,
      -44, -43, -38, -35, -21,
      -7, -7, 0, 0, 0,
      2, 3, 5, 6, 6,
      5, 4, 3, 1, -3,
      -5, -6, -7, -8, -7,
      -6, -5, -5, -5, -6,
      -8, -8, -8, -9, -10,
      -8, -5, -5, -3, -1,
      -3, -6, -6, -6, -7,
      -7, -6, -6, -7, -7,
      -5, -4, -2, -2, -2,
      -1, -1, -1, -1, 0,
      3, -4, 3, 0, -2,
      2, -4, -2, 2, -2,
      0, -7, -8, -10, -6,
      -6, -8, -4, -15, -16,
      -10, -14, -15, -12, -17,
      -9, -13, -8, -11, -16,
      -9, -19, -9, -11, -13,
      -5, -10, -9, -11, -10,
      -4, -2, -7, -3, -5,
      -3, 0, -3, 0, -5,
      0, -1, -2, 1, -3,
      -3, -4, -6, -5, -4,
      -7, -9, -8, -9, -5,
      -4, -10, -11, -11, -16,
      -11, -13, -11, -10, -14,
      -11, -14, -10, -14, -12,
      -13, -16, -8, -6, -5,
      -5, -7, -4, -6, -7,
      -2, -4, -4, -4, -4,
      -3, -3, 0, -7, -3,
      2, -4, -1, -4, -2,
      -5, -3, -4, -3, -5,
      -9, -7, -9, -4, -6,
      -16, -11, -13, -9, -6,
      -9, -10, -7, -5, -5,
      -9, -11, -13, -7, -1,
      -12, -3, -12, -8, -7,
      -9, -10, -14, -13, -13,
      -5, -7, -6, -10, -9,
      -6, -3, -6, -2, 1,
      -7, -2, -7, -5, -5,
      -5, -5, -5, -5, -4,
      -4, -5, -5, -6, -5,
      -4, -4, -2, -6, -5,
      -11, -6, -9, -13, -11,
      -10, -13, -10, -10, -15,
      -13, -13, -12, -10, -9,
      -14, -13, -11, -13, -7,
      -8, -8, -7, -6, -4,
      -4, -1, -5, -4, -1,
      2, 0, -3, -1, -2,
      -5, 1, -1, -7, -2,
      -7, -10, -5, -5, -7,
      -6, -6, -11, -10, -10,
      -10, -10, -15, -13, -13,
      -10, -6, -8, -12, -11,
      -10, -9, -10, -7, -11,
      -9, -6, -7, -7, -7,
      -5, -4, -7, -6, -4,
      -3, -3, -9, -12, -6,
      -4, -6, -6, -11, -10,
      -5, 0, -2, -7, -9,
      -9, -4, -3, -8, -10,
      -13, -9, -3, -7, -11,
      -11, -8, -7, -3, -11,
      -12, -11, -10, -9, -6,
      -5, -10, -6, -12, -12,
      0, -11, -16, -10, -11,
      -6, -7, -11, -9, -6,
      -6, -5, -5, -4, -5,
      -10, -6, -8, -8, -5,
      -6, -5, -3, -3, -7,
      -5, -5, -2, 0, -6,
      -7, -10, -10, -4, -5,
      -8, -2, -12, -8, -4,
      -8, -11, -10, -15, -10,
      -12, -10, -11, -11, -10,
      -9, -10, -14, -11, -14,
      -15, -10, -10, -9, -6,
      -11, -11, -8, -7, -6,
      -4, -6, -5, -4, -6,
      -5, -6, -7, -1, -2,
      -1, 0, -5, -7, -6,
      -9, -4, -4, -7, -14,
      -14, -10, -11, -11, -10,
      -9, -7, -11, -16, -13,
      -15, -16, -13, -9, -9,
      -9, -8, -10, -9, -10,
      -8, -4, -4, -10, -14,
      -10, -7, -7, -6, -4,
      -3, -5, -5, -8, -9,
      -5, -8, -6, -2, -5,
      -5, -5, -11, -11, -5,
      -6, -9, -7, -6, -7,
      -9, -9, -11, -12, -7,
      -5, -4, -3, -6, -12,
      -10, -9, -9, -11, -7,
      -4, -8, -11, -11, -11,
      -8, -13, -13, -13, -14,
      -13, -12, -13, -13, -7,
      -7, -14, -16, -11, -7,
      -7, -7, -8, -7, -3,
      -1, -4, -8, -8, -7,
      -2, -1, 0, -2, -4,
      -5, -7, -6, -7, -11,
      -9, -9, -10, -10, -14,
      -13, -11, -5, -8, -15,
      -15, -14, -13, -16, -19,
      -14, -11, -10, -11, -14,
      -15, -15, -9, -9, -10,
      -10, -6, -5, -5, -7,
      -9, -3, 2, 1, -3,
      -4, -2, -4, -3, -2,
      0, 0, -1, -3, -8,
      -12, -11, -3, 7, 15,
      33, 56, 62, 44, 20,
      6, 4, -3, -20, -32,
      -29, -21, -14, -7, 0,
      1, 0, 3, 11, 18,
      11, -5, -15, -13, -6,
      -4, -10, -17, -23, -23,
      -21, -18, -19, -20, -19,
      -12, -4, 0, -2, -6,
      -7, -3, 4, 11, 19,
      34, 49, 48, 29, 10,
      3, 3, -3, -14, -22,
      -23, -18, -13, -8, -3,
      -2, -4, -4, 4, 12,
      9, -3, -12, -11, -5,
      -3, -8, -16, -18, -15,
      -11, -12, -15, -14, -10,
      -4, 1, 4, 3, 0,
      0, -1, 1, 7, 11,
      9, 7, 12, 16, 12,
      0, -6, -3, 2, 2,
      -2, -4, -2, -1, -2,
      -2, 0, 0, -6, -10,
      -7, -3, -3, -5, -6,
      -6, -3, 1, 0, -4,
      -6, -5, -4, -5, -9,
      -9, -5, 0, -2, -9,
      -11, -8, -3, 1, 0,
      -4, -5, 0, 4, 1,
      -5, -7, -3, 0, 1,
      0, 0, 4, 6, 3,
      -1, -1, 0, -2, -5,
      -3, 0, 0, -3, -6,
      -4, 0, 1, -1, -3,
      -5, -8, -6, -2, -3,
      -7, -8, -3, 0, -2,
      -8, -8, -2, 1, -4,
      -8, -3, 3, -1, -8,
      -9, -4, 0, -2, -4,
      0, 4, 5, 3, 3,
      3, 1, -2, -1, 2,
      1, -2, -3, 0, 2,
      1, 0, 2, 0, -7,
      -9, -4, -1, -5, -7,
      -3, -2, -6, -8, -4,
      -3, -8, -6, 7, 12,
      -9, -34, -28, 4, 19,
      -7, -33, -18, 18, 26,
      3, -15, -7, 9, 12,
      5, 1, 0, 0, -2,
      1, 8, 8, -1, -5,
      2, 14, 14, 0, -12,
      -10, -1, 0, -11, -17,
      -11, -7, -12, -10, -3,
      -6, -12, -8, -1, -1,
      -6, -5, -3, -7, -12,
      -10, -7, -10, -14, -10,
      -1, 2, 1, 4, 6,
      7, 12, 22, 28, 21,
      12, 9, 10, 10, 7,
      1, -7, 0, 0, 4,
      2, -2, -4, -4, -4,
      -3, -1, -1, -4, -8,
      -10, -8, -5, -3, -2,
      -3, -8, -10, -6, -3,
      -5, -9, -5, 2, 0,
      -6, -6, -5, -3, -1,
      0, -1, -1, -1, 0,
      5, 7, 1, -4, -1,
      4, 3, 1, 3, 5,
      3, -4, -10, -6, 1,
      2, 0, -3, -6, -9,
      -9, -7, -2, 0, -2,
      -7, -9, -6, -3, -3,
      -5, -4, -3, -1, 0,
      -6, -10, -9, -5, 1,
      6, 6, -1, -8, -8,
      -7, 1, 12, 15, 5,
      -8, -13, -8, 1, 10,
      13, 5, -8, -13, -8,
      -1, 2, 1, -1, -1,
      -5, -11, -10, -4, 1,
      4, -1, -8, -12, -13,
      -6, 5, 7, 0, -8,
      -15, -11, 0, 6, 4,
      -1, -6, -8, -9, -4,
      7, 11, 4, -3, -7,
      -10, -5, 5, 10, 9,
      6, -2, -10, -8, -2,
      1, 3, 6, 4, -4,
      -11, -11, -9, -3, 4,
      6, 0, -7, -12, -13,
      -8, -1, 4, 6, 2,
      -7, -13, -13, -8, 3,
      13, 5, -9, -13, -8,
      -2, 4, 9, 3, -8,
      -10, -5, 0, 9, 12,
      4, -6, -9, -8, -3,
      6, 9, 3, -1, -5,
      -11, -10, -4, 0, 5,
      7, -3, -11, -9, -6,
      -8, -7, 1, 8, 2,
      -9, -15, -12, -3, 4,
      3, -2, -6, -4, -3,
      -4, -4, -1, 4, 6,
      -2, -7, -4, -2, -2,
      2, 8, 2, -10, -9,
      -2, 1, 3, 4, 2,
      -7, -12, -5, 2, 3,
      1, -3, -2, -1, -5,
      -10, -11, 0, 9, 3,
      -8, -11, -7, -6, -7,
      -3, 6, 7, -2, -8,
      -12, -11, -1, 4, -2,
      -3, 3, 2, -4, -6,
      -6, -5, -1, 1, 4,
      7, 4, -5, -10, -9,
      -5, 0, 8, 11, 3,
      -9, -13, -12, -9, 2,
      13, 10, -2, -7, -12,
      -16, -8, 1, 1, 4,
      6, -5, -15, -8, -2,
      -7, -3, 4, 1, -4,
      -3, -6, -7, -1, 0,
      -3, 0, 4, 1, -8,
      -7, 0, 0, 1, 2,
      2, 1, -5, -7, -3,
      0, 3, 3, -2, -4,
      -4, -9, -5, 3, 2,
      1, -3, -10, -5, -1,
      -5, -4, 0, 0, -3,
      -5, -5, -6, -5, 0,
      -4, -7, 1, 2, -5,
      -8, -3, 0, -3, -6,
      -3, 4, 6, 1, -5,
      -11, -13, -1, 10, 11,
      4, -8, -12, -8, -2,
      1, 1, 0, 2, 1,
      -3, -4, -10, -15, -3,
      4, -1, 4, 8, -3,
      -13, -16, -14, -3, 9,
      13, 8, -8, -16, -13,
      -6, 0, 7, 7, -1,
      -1, -8, -19, -7, 8,
      6, 4, 4, -8, -13,
      -5, -1, 1, 2, 2,
      -1, -3, -2, -5, -6,
      -1, -2, 1, 3, 2,
      -1, -12, -15, 1, 10,
      4, -1, -6, -11, -11,
      -3, 5, 6, 4, -1,
      -6, -11, -10, 1, 3,
      -6, -3, 5, 2, -5,
      -10, -10, -7, 1, 7,
      2, -4, -4, -6, -6,
      -2, 0, 0, -1, 2,
      3, -6, -8, -4, -3,
      1, 5, 0, -5, -6,
      -5, -4, -3, -7, 2,
      9, 0, -8, -11, -9,
      -7, 0, 8, 4, -2,
      -9, -16, -7, 4, 1,
      -4, 0, -2, -9, -6,
      1, -5, -4, 8, 9,
      -6, -13, -8, -4, -3,
      4, 14, 9, -8, -18,
      -10, -2, 2, 8, 8,
      -2, -9, -11, -7, 1,
      0, -5, 1, 4, -3,
      -5, -7, -7, 1, 3,
      -7, -7, 3, -1, -9,
      -3, 2, -2, -1, -3,
      -1, -2, -9, -6, 1,
      2, 2, -1, -9, -10,
      0, 2, -2, 1, -1,
      -7, -6, -2, -1, -2,
      -2, -2, 0, 3, -2,
      -10, -10, -4, -1, 4,
      8, -2, -9, -7, -10,
      -8, 2, 6, 1, -1,
      -1, -5, -8, -10, -5,
      0, 3, 7, 4, -6,
      -17, -11, -3, -4, 4,
      10, -1, -6, -5, -10,
      -10, -4, 0, 7, 8,
      1, -7, -15, -10, 4,
      5, 2, 4, -2, -9,
      -5, -1, -2, 0, 0,
      26, 0, -29, 1, 32,
      8, -20, 6, 31, 4,
      -21, -3, 13, -1, -20,
      -17, -8, -12, -19, -27,
      -31, -25, -24, -33, -36,
      -38, -38, -40, -44, -40,
      -34, -38, -42, -33, -33,
      -50, -48, -27, -27, -46,
      -42, -11, -6, -40, -50,
      -19, -5, -26, -33, 0,
      0, 1, 1, -2, -1,
      1, -1, -2, -1, -2,
      -4, -4, -3, -5, -6,
      -4, -3, -4, -4, -4,
      -3, -5, -5, -5, -5,
      -5, -7, -6, -5, -7,
      -8, -7, -6, -8, -10,
      -7, -6, -9, -8, -6,
      -6, -6, -6, -5, -4,
      -6, -5, -4, -3, -3,
      0, 0, 5, 3, 0,
      3, 3, -3, -4, -2,
      -3, -5, -4, -6, -7,
      -5, -10, -15, -14, -12,
      -12, -14, -14, -13, -11,
      -7, -12, -14, -10, -10,
      -13, -16, -14, -14, -15,
      -16, -19, -17, -14, -16,
      -16, -15, -13, -10, -6,
      -5, -9, -8, -6, -7,
      -6, -2, -2, 0, -2,
      -5, -6, -3, -2, -3,
      -1, 0, -4, -7, -6,
      -4, -4, -3, -4, -8,
      -5, -4, -11, -10, -5,
      -8, -13, -12, -10, -11,
      -11, -14, -11, -13, -14,
      -15, -15, -11, -13, -12,
      -13, -17, -15, -11, -11,
      -11, -13, -10, -10, -8,
      -6, -10, -9, -4, -7,
      -7, -2, -4, -6, -4,
      -6, -4, -3, -5, -4,
      -6, -6, -4, -4, -2,
      -2, -5, -5, -5, -6,
      -6, -4, -5, -3, -3,
      -8, -9, -8, -11, -13,
      -11, -11, -11, -12, -14,
      -14, -13, -12, -16, -14,
      -14, -14, -11, -13, -14,
      -14, -11, -12, -14, -12,
      -7, -9, -11, -10, -9,
      -9, -8, -7, -8, -8,
      -8, -11, -9, -7, -4,
      -5, -6, -5, -7, -4,
      -4, -9, -7, -4, -6,
      -3, -3, -6, -3, -4,
      -6, -9, -8, -4, -7,
      -10, -10, -10, -7, -9,
      -10, -9, -6, -7, -9,
      -9, -10, -13, -10, -9,
      -10, -10, -10, -11, -9,
      -10, -12, -10, -10, -13,
      -11, -10, -12, -11, -12,
      -12, -8, -6, -7, -9,
      -7, -4, -6, -6, -3,
      -5, -6, -7, -9, -9,
      -6, -7, -8, -7, -5,
      -7, -10, -9, -8, -7,
      -9, -9, -7, -6, -6,
      -7, -7, -8, -7, -5,
      -6, -9, -10, -9, -9,
      -11, -11, -13, -17, -15,
      -12, -12, -10, -11, -12,
      -13, -13, -15, -11, -8,
      -9, -7, -8, -11, -10,
      -8, -7, -7, -10, -10,
      -12, -11, -9, -7, -7,
      -6, -5, -7, -6, -2,
      -1, -3, -3, -5, -6,
      -5, -6, -8, -7, -7,
      -5, -7, -8, -10, -13,
      -12, -9, -7, -6, -7,
      -7, -9, -11, -7, -7,
      -9, -9, -9, -7, -7,
      -12, -16, -16, -13, -10,
      -11, -12, -14, -17, -13,
      -11, -12, -10, -6, -9,
      -12, -12, -11, -8, -8,
      -8, -8, -6, -5, -7,
      -6, -7, -7, -5, -4,
      -8, -6, -5, -6, -8,
      -7, -5, -5, -7, -8,
      -9, -6, -5, -9, -11,
      -12, -10, -7, -9, -12,
      -11, -10, -8, -8, -12,
      -12, -10, -9, -10, -12,
      -10, -9, -12, -15, -10,
      -12, -14, -11, -10, -11,
      -9, -9, -7, -9, -8,
      -7, -10, -8, -5, -7,
      -8, -7, -6, -4, -7,
      -10, -9, -3, -2, -8,
      -9, -5, -6, -10, -8,
      -4, -5, -5, -10, -10,
      -4, -3, -5, -8, -9,
      -7, -8, -11, -11, -10,
      -7, -10, -17, -16, -13,
      -12, -11, -13, -15, -13,
      -10, -12, -12, -9, -11,
      -12, -11, -11, -9, -9,
      -12, -14, -12, -8, -9,
      -11, -9, -6, -5, -7,
      -7, -7, -7, -8, -7,
      -7, -7, -7, -9, -7,
      -7, -4, -4, -7, -8,
      -5, -6, -12, -11, -7,
      -11, -11, -9, -13, -10,
      -9, -14, -11, -5, -6,
      -12, -16, -12, -10, -10,
      -12, -14, -9, -6, -12,
      -16, -9, -3, -5, -12,
      -13, -7, -3, -7, -14,
      -13, -3, -5, -9, -7,
      -5, -2, -5, -11, -9,
      -5, -2, -7, -11, -10,
      -9, -9, -11, -13, -11,
      -8, -7, -10, -10, -6,
      -8, -10, -11, -13, -11,
      -7, -10, -15, -12, -10,
      -10, -11, -13, -12, -10,
      -11, -10, -13, -11, -8,
      -8, -10, -12, -10, -6,
      -7, -10, -12, -5, -2,
      -9, -13, -11, -7, -8,
      -11, -12, -13, -9, -6,
      -11, -11, -5, -4, -9,
      -10, -9, -5, -5, -11,
      -15, -12, -2, -1, -12,
      -15, -9, -6, -7, -10,
      -10, -7, -9, -14, -14,
      -10, -5, -7, -13, -12,
      -6, -6, -10, -12, -10,
      -7, -8, -10, -11, -7,
      -5, -8, -11, -10, -6,
      -8, -10, -9, -11, 0,
      0, 3, -4, -8, -18,
      -29, -34, -36, -41, -46,
      -43, -39, -36, -31, -24,
      -16, -8, -1, 5, 15,
      29, 43, 47, 41, 46,
      56, 42, 24, 25, 19,
      1, -7, -12, -25, -34,
      -37, -41, -40, -35, -35,
      -31, -21, -18, -16, -5,
      3, 4, 8, 13, 13,
      8, 4, -1, -8, -17,
      -24, -27, -32, -38, -39,
      -37, -37, -35, -28, -23,
      -17, -9, -1, 5, 15,
      34, 42, 33, 36, 52,
      45, 27, 26, 27, 13,
      0, -4, -10, -21, -30,
      -33, -30, -33, -41, -37,
      -25, -26, -31, -18, -4,
      -7, -5, 4, 7, 4,
      2, 0, -2, -8, -14,
      -16, -18, -24, -27, -23,
      -23, -25, -21, -16, -13,
      -8, -2, 2, 7, 14,
      20, 23, 20, 21, 26,
      19, 11, 10, 8, 2,
      -3, -7, -12, -16, -18,
      -22, -21, -19, -23, -23,
      -17, -14, -15, -12, -8,
      -7, -5, -3, -4, -5,
      -5, -7, -10, -10, -11,
      -11, -9, -11, -13, -13,
      -13, -12, -11, -11, -8,
      -4, -3, -3, -4, -4,
      -3, -3, -3, -3, -4,
      -3, -3, -5, -7, -6,
      -5, -6, -6, -5, -5,
      -6, -5, -5, -5, -4,
      -4, -4, -5, -6, -6,
      -7, -8, -8, -7, -8,
      -11, -12, -12, -12, -12,
      -13, -13, -12, -11, -12,
      -11, -10, -9, -9, -7,
      -7, -6, -5, -5, -5,
      -5, -4, -4, -4, -3,
      -3, -4, -4, -4, -4,
      -4, -4, -3, -3, -4,
      -4, -4, -4, -4, -5,
      -4, -3, -5, -6, -6,
      -5, -5, -6, -6, -6,
      -7, -8, -7, -7, -7,
      -7, -7, -7, -6, -7,
      -9, -6, -6, -9, -8,
      -6, -7, -6, -6, -7,
      -6, -6, -6, -7, -6,
      -6, -5, 1, 11, 8,
      -9, -14, -11, -24, -30,
      -18, -10, -11, -10, -7,
      -1, 3, -1, -4, 5,
      7, 1, 0, 1, 1,
      -3, -3, -4, -4, -2,
      -7, -7, -3, -7, -12,
      -7, -5, -11, -11, -5,
      -3, 6, 4, -9, -1,
      -8, -19, -24, -23, -13,
      -11, -13, -16, -8, -8,
      -10, 2, 4, -4, -2,
      2, -1, -2, -3, -6,
      -2, 0, -3, -5, -3,
      0, 0, -4, -2, 0,
      0, -2, -5, -1, -1,
      -1, -1, -4, -1, -3,
      -7, -9, -8, -7, -10,
      -10, -11, -10, -11, -13,
      -11, -10, -11, -11, -7,
      -8, -10, -11, -11, -6,
      -8, -7, -9, -7, -3,
      -11, -7, -3, -4, -5,
      0, 0, 0, 0, 5,
      16, 25, 33, 37, 35,
      31, 28, 25, 23, 23,
      22, 19, 13, 5, -5,
      -16, -25, -32, -36, -37,
      -33, -27, -21, -13, -7,
      -4, -1, 0, -1, -3,
      -2, 0, 1, 2, -1,
      -7, -13, -17, -19, -19,
      -16, -11, -9, -8, -7,
      -5, -4, -3, -1, 0,
      11, 27, 31, 18, 10,
      16, 25, 30, 38, 47,
      45, 33, 23, 17, 14,
      15, 14, 5, -6, -19,
      -32, -42, -45, -44, -43,
      -43, -46, -50, -50, -48,
      -44, -39, -33, -28, -25,
      -22, -16, -11, -9, -7,
      -7, -7, -5, -5, -4,
      -4, -3, -2, -2, -1,
      0, 6, 14, 15, 16,
      26, 34, 37, 38, 38,
      39, 38, 35, 27, 18,
      9, 2, -4, -9, -16,
      -23, -31, -36, -39, -43,
      -48, -50, -49, -47, -43,
      -37, -34, -31, -28, -24,
      -23, -23, -22, -21, -19,
      -17, -16, -15, -15, -14,
      -11, -9, -7, -5, -3,
      -1, 0, 4, 19, 20,
      8, 3, 14, 22, 21,
      14, 6, 13, 27, 18,
      0, 3, 17, 15, -3,
      -12, -7, -6, -14, -25,
      -33, -26, -18, -28, -38,
      -31, -21, -19, -21, -24,
      -21, -11, -8, -15, -17,
      -10, -5, -5, -4, -6,
      -1, 3, -10, -9, -1,
      -1, 0, 6, 11, 15,
      16, 16, 21, 29, 33,
      33, 33, 35, 36, 33,
      30, 29, 29, 27, 23,
      17, 11, 7, 0, -9,
      -16, -21, -26, -35, -42,
      -45, -47, -49, -50, -50,
      -48, -45, -41, -37, -32,
      -26, -20, -16, -13, -9,
      -8, -6, -5, -4, -3,
      -2, -1, 0, -2, 3,
      12, 17, 17, 19, 27,
      34, 34, 31, 32, 32,
      25, 16, 10, 7, 3,
      -4, -9, -14, -22, -31,
      -36, -41, -47, -50, -50,
      -49, -50, -50, -44, -37,
      -32, -30, -27, -26, -25,
      -21, -15, -11, -11, -11,
      -9, -8, -7, -6, -5,
      -3, -2, -1, 0, -3,
      8, 23, 8, -22, -16,
      15, 13, -18, -26, -11,
      -6, -9, -9, -10, -10,
      -9, -6, 0, 2, 1,
      1, -3, -11, -12, -3,
      5, 2, -4, -7, -5,
      -2, 0, -1, -3, -7,
      -9, -9, -9, -9, -8,
      -7, -8, -8, -9, -9,
      -8, -7, -5, -3, -1,
      -2, -5, -5, -4, -2,
      -1, -1, -1, -2, -3,
      -3, -2, -2, -3, -3,
      -2, -4, -4, -4, -5,
      -6, -7, -7, -8, -8,
      -8, -8, -9, -10, -11,
      -11, -10, -9, -8, -7,
      -6, -4, -4, -3, -1,
      1, 1, 0, 0, -1,
      -2, -1, -1, -2, -2,
      -2, -3, -4, -6, -6,
      -5, -5, -5, -6, -5,
      -5, -5, -5, -6, -8,
      -9, -10, -10, -11, -11,
      -11, -11, -10, -9, -8,
      -8, -7, -7, 0, 0,
      -2, 3, 12, 7, -9,
      -15, -16, -18, -15, -11,
      -8, -6, -5, -7, -6,
      0, 8, 11, 12, 19,
      9, -19, -30, -25, -19,
      -12, -6, -4, -3, -3,
      -6, -8, -7, -5, -2,
      0, -1, -5, -5, -1,
      1, 0, -1, -2, -2,
      0, 1, -2, -5, -5,
      -3, -1, -2, -3, -5,
      -4, -2, -2, -4, -6,
      -6, -5, -5, -6, -8,
      -8, -7, -6, -6, -7,
      -7, -7, -6, -5, -7,
      -7, -7, -6, -7, -7,
      -3, 6, 5, -9, -14,
      -10, -12, -13, -10, -7,
      -2, 0, 0, 1, 4,
      5, 5, 4, 4, 2,
      1, 2, 3, 0, -1,
      -3, -4, -4, -4, -7,
      -10, -9, -9, -10, -9,
      -11, -13, -10, -7, -10,
      -16, -15, -6, -3, -6,
      -8, -10, -8, -4, -6,
      -9, -6, -1, 0, -2,
      -5, -7, -4, -1, -1,
      -3, 0, 0, -4, 2,
      9, -4, -26, -27, -8,
      9, 12, 1, -14, -20,
      -8, 9, 13, 9, 7,
      -2, -20, -26, -15, 3,
      11, 6, -10, -19, -11,
      3, 8, 0, -11, -14,
      -7, 3, 5, -3, -7,
      -1, 2, 0, -4, -10,
      -16, -15, -11, -10, -8,
      -2, 2, 0, -5, -9,
      -7, -1, 4, 5, 4,
      2, -7, -14, -16, -13,
      -2, 10, 4, -12, -20,
      -13, -1, 5, 1, -9,
      -12, -6, 3, 5, -1,
      -8, -8, -4, 2, 0,
      -6, -9, -8, -5, -1,
      -1, -5, -8, -7, -2,
      -1, -4, -8, -10, -8,
      -2, 0, -3, -8, -10,
      -8, -3, -2, -4, -6,
      -4, -2, -2, -3, -4,
      -4, -3, -3, -3, -3,
      -5, -6, -5, -2, -2,
      -3, -4, -4, -4, -3,
      -1, -1, -4, -6, -7,
      -4, -2, -4, -8, -8,
      -7, -6, -7, -8, -10,
      -9, -8, -6, -5, -6,
      -7, -7, -7, -6, -4,
      -4, -7, -8, -6, -6,
      -7, -6, -4, -4, -3,
      -1, 0, 0, 1, 9,
      21, 10, -11, -3, 5,
      -14, -25, -14, -2, -4,
      -12, -14, -8, 0, 0,
      -7, -8, 3, 1, -6,
      -12, 4, 7, -7, -10,
      2, 5, -5, -6, -1,
      -1, -2, -3, -4, 0,
      3, 0, -5, 0, 6,
      0, -5, 1, 6, 0,
      -6, -1, 1, -3, -5,
      -4, -3, -3, -5, -7,
      -6, -4, -6, -9, -7,
      -4, -7, -10, -7, -4,
      -7, -9, -7, -7, -7,
      -7, -7, -5, -3, -4,
      -4, 2, 5, 1, 2,
      7, 8, 6, 5, 8,
      9, 7, 5, 5, 6,
      4, -2, -4, -3, -5,
      -10, -11, -8, -10, -12,
      -11, -9, -9, -9, -8,
      -9, -8, -7, -9, -8,
      -6, -7, -7, -4, -5,
      -7, -7, -6, 0, 0,
      -4, -2, 0, 3, 5,
      -12, -25, -9, -2, -4,
      9, 11, -20, -25, -1,
      -2, -9, -5, -7, -5,
      -4, -7, -5, -2, -5,
      -5, -1, -2, -4, -1,
      -2, -4, 0, -1, -5,
      -3, 0, -4, -4, -1,
      -3, -4, -2, -3, -4,
      0, -1, -5, -5, -3,
      -4, -4, -3, -3, -3,
      -2, -3, -7, -4, -3,
      -5, -4, -3, -4, -5,
      -4, -2, 6, -1, -11,
      -12, -13, -10, -8, -5,
      -1, 2, -1, -5, -4,
      -6, -6, -6, -6, -6,
      -5, -4, -5, -3, -3,
      -3, -2, -2, -2, -1,
      -2, -3, -3, -2, -1,
      -3, -4, -2, -2, -3,
      -1, -3, -4, -3, -4,
      -5, -4, -3, -6, -6,
      -5, -8, -8, -5, -7,
      -7, -4, -8, -13, -7,
      -5, -8, -6, -4, -6,
      -4, -2, -7, -5, 1,
      -5, -5, 1, -3, -4,
      1, 1, -3, -2, 0,
      -2, 0, 3, 0, -3,
      0, -2, -4, 0, 0,
      -4, -4, -2, -5, -4,
      -3, -4, -6, -4, -4,
      -9, -8, -7, -10, -6,
      -6, -8, -9, -11, -11,
      -8, -7, -8, -5, -6,
      -8, -2, -1, -5, -1,
      -1, -4, -1, 1, -1,
      0, -1, -5, -1, 3,
      1, 0, 2, 4, 1,
      5, 3, 0, 4, 3,
      -2, -1, 1, -8, -9,
      -4, -8, -12, -10, -11,
      -18, -13, -11, -19, -15,
      -10, -12, -11, -7, -10,
      -10, -6, -7, -5, 1,
      0, -4, -2, 1, 0,
      0, 4, -2, 0, 7,
      1, 1, 8, 5, 2,
      8, 7, 3, 7, 10,
      4, 7, 10, 3, -1,
      -3, -5, -11, -13, -15,
      -19, -15, -18, -23, -23,
      -20, -16, -20, -17, -14,
      -7, -12, -12, -3, -3,
      -2, -3, -1, -6, -1,
      4, -7, 1, 8, 3,
      9, 12, 6, 3, 0,
      0, 5, 0, -18, -8,
      6, -9, -8, 7, -3,
      -9, 1, 2, -4, -2,
      1, -1, -4, -2, -1,
      -1, -3, -4, -3, -3,
      -3, -3, -3, -2, -3,
      -3, 2, -1, -12, -8,
      -3, -4, 3, -3, -23,
      -9, 5, -13, -15, -1,
      -5, -14, -7, -1, -7,
      -10, -4, -3, -9, -6,
      -2, -7, -9, -4, -2,
      -3, -3, -3, -3, -1,
      -2, -5, -3, 0, -3,
      -3, 1, 0, -3, -2,
      -1, -1, 3, 9, 5,
      -7, -5, 1, -4, -8,
      -5, -7, -12, -11, -4,
      -4, -10, -7, 2, -8,
      -19, -1, 1, -16, -8,
      -1, -7, -10, -7, -3,
      -5, -9, -6, -3, -4,
      -4, -5, -3, -1, -4,
      -2, 8, 2, -16, -4,
      10, -5, -10, 4, 6,
      -7, -7, 2, 2, -2,
      0, 1, -3, -4, 0,
      -2, -6, -3, -2, -7,
      -8, -5, -4, -7, -8,
      -7, -7, -10, -12, -8,
      -5, -11, -9, -3, -4,
      -9, -8, -4, -5, -9,
      -7, -5, -6, -9, -8,
      -4, 4, 1, -6, -4,
      -3, -4, -3, -2, -1,
      -1, -2, 0, 4, 3,
      0, 1, 3, 0, -2,
      -1, 1, -2, -11, -8,
      -3, -8, -12, -9, -7,
      -12, -15, -11, -10, -16,
      -19, -12, -12, -14, -7,
      -5, -9, -10, -4, -6,
      -13, -3, 4, -6, -7,
      8, 11, -1, -4, 8,
      14, 3, -3, 8, 14,
      4, -2, 8, 12, 3,
      -2, 5, 7, -3, -6,
      -2, -1, -10, -16, -10,
      -6, -13, -20, -14, -9,
      -16, -20, -17, -10, -11,
      -19, -16, -7, -8, -19,
      -15, -4, -8, -13, -7,
      -4, -9, -2, 0, 0,
      -5, -5, -4, -2, -2,
      -2, 0, 5, -4, -16,
      -8, -2, -6, -6, -3,
      -3, 4, 13, 5, -14,
      -21, -14, -6, 2, 3,
      -9, -16, -13, -7, -5,
      -6, -4, -3, -1, 0,
      0, 0, 0, -1, -4,
      -4, -4, -2, -2, -4,
      -6, -7, -8, -7, -8,
      -11, -13, -12, -11, -10,
      -9, -8, -8, -7, -5,
      -6, -6, -5, -4, -3,
      -3, -3, -2, -2, -3,
      -5, -5, -4, -3, -3,
      -4, -6, -6, -6, -6,
      -7, -5, -6, -8, -9,
      -7, -4, -1, -2, -3,
      -1, 0, -2, -7, -9,
      -6, -2, -4, -7, -9,
      -9, -10, -10, -9, -7,
      -6, -5, -5, -5, -6,
      -6, -6, -7, -5, -3,
      -3, -4, -7, -7, -5,
      -5, -4, -4, -4, -5,
      -6, -6, -4, -2, -2,
      -3, -5, -4, -1, 0,
      -1, -4, -6, -5, -4,
      -5, -6, -7, -7, -6,
      -6, -4, -1, -2, -3,
      -4, -5, -5, -5, -6,
      -5, -3, -3, -5, -7,
      -8, -6, -5, -4, -4,
      -5, -7, -8, -8, -5,
      -4, -5, -4, -2, -2,
      -2, -4, -5, -4, -3,
      -4, -5, -6, -7, -6,
      -5, -5, -6, -6, -4,
      -3, -3, -3, -3, -3,
      -2, -3, -5, -6, -5,
      -4, -4, -4, -4, -4,
      -4, -4, -3, -4, -4,
      -5, -6, -6, -5, -6,
      0, -3, -3, -2, 3,
      5, -7, -17, -14, -8,
      -6, -6, -6, -4, -3,
      -5, -6, -7, -7, -6,
      -5, -4, -4, 9, 21,
      -5, -22, -7, -1, -5,
      -4, -5, -5, -5, -8,
      -10, -7, -4, -5, -3,
      -3, -7, -8, -2, 0,
      -3, -4, -5, -5, -3,
      -2, -5, -5, -4, -4,
      -3, -2, -4, -6, -3,
      -2, -4, -6, -6, -5,
      -4, -4, -5, -5, -4,
      -5, -5, -4, -2, -1,
      -2, 0, 1, 1, -7,
      -21, -21, -13, -9, -9,
      -6, 1, 5, -1, -7,
      -9, -9, -4, -2, -5,
      -5, -3, -2, -1, -3,
      -5, -5, -4, -3, -3,
      -6, -7, -6, -5, -2,
      1, -3, -8, -6, -2,
      -4, -9, -13, -11, -2,
      0, -5, -7, -7, -3,
      3, 7, 1, -6, -2,
      3, -1, -12, -17, -12,
      -3, -4, -13, -15, -6,
      0, -1, -7, -9, -3,
      5, 4, -5, -9, -4,
      0, -1, -6, -10, -7,
      -2, -2, -7, -10, -7,
      -2, -1, -5, -8, -6,
      -2, -1, -4, -6, -4,
      0, 1, -3, -6, -5,
      -2, -3, -7, -9, -7,
      -4, -5, -8, -8, -5,
      -3, -4, -6, -6, -4,
      -2, -2, -4, -5, -3,
      -2, -1, -3, -5, -5,
      -3, -3, -5, -6, -5,
      -4, -5, -6, -7, -7,
      -6, -6, -6, -6, -6,
      -5, -6, -6, -6, -5,
      -5, -6, -8, -8, -7,
      -7, -7, -8, -7, -5,
      -3, -2, -2, -1, 2,
      3, 4, 4, 4, 5,
      5, 3, 1, 0, 0,
      -4, -5, -6, -6, -7,
      -4, 2, 1, -5, -11,
      -14, -10, -1, 3, -1,
      -9, -12, -9, -3, 2,
      0, -6, -9, -8, -3,
      0, -1, -6, -9, -8,
      -4, -1, -1, -5, -8,
      -7, -3, -1, -1, -4,
      -7, -6, -4, -2, -4,
      -6, -7, -7, -5, -2,
      -2, -4, -7, -8, -5,
      -2, 3, 7, 3, -7,
      -18, -21, -10, 9, 18,
      6, -14, -26, -16, 7,
      17, 6, -15, -26, -19,
      -3, 8, 6, -5, -13,
      -12, -3, 3, 1, -6,
      -11, -10, -3, 2, -1,
      -5, -9, -7, -2, 1,
      -1, -6, -9, -7, -3,
      -1, -2, -6, -8, -6,
      -3, -2, -3, -5, -7,
      -6, -3, 0, -2, -6,
      -7, -5, -2, 0, -3,
      -7, -7, 2, 10, 3,
      -11, -19, -18, -8, 0,
      -2, -11, -14, -10, -2,
      5, 4, -2, -7, -5,
      0, 4, 2, -4, -10,
      -11, -7, -4, -5, -9,
      -11, -9, -5, -1, -1,
      -5, -7, -4, -1, 0,
      0, -2, -5, -6, -4,
      -2, -3, -6, -10, -10,
      -6, -3, -4, -9, -9,
      -6, -1, 0, -3, -6,
      -7, -4, -1, -2, -5,
      -7, -6, -5, -5, -6,
      -9, -10, -5, -1, -1,
      -5, -9, -7, -2, 2,
      1, -7, -10, -6, -2,
      0, -3, -10, -11, -6,
      -1, -1, -4, -6, -8,
      -6, -2, 1, -1, -7,
      -9, -6, -2, 0, -1,
      -7, -11, -7, -2, -1,
      -5, -8, -8, -4, 0,
      -2, -6, -9, -5, -1,
      0, -1, -7, -9, -6,
      -1, -3, -7, -8, -6,
      -7, -7, -4, -2, -3,
      -5, -6, -4, 0, 0,
      -6, -9, -6, -3, -1,
      -2, -6, -8, -8, -6,
      -3, -2, -4, -8, -10,
      -6, -1, 0, -4, -10,
      -8, -3, 0, -2, -7,
      -8, -6, -4, -5, -7,
      -8, -5, -4, -3, -3,
      -3, -5, -4, -3, -4,
      -5, -6, -6, -6, -5,
      -5, -6, -5, -3, -3,
      -4, -5, -7, -5, -4,
      -4, -4, -5, -6, -5,
      -3, -4, -5, -7, -6,
      -5, -4, -3, -4, -5,
      -5, -4, -3, -3, -4,
      -5, -5, -4, -5, -5,
      -7, -7, -6, -4, -6,
      -7, -5, -3, -3, -4,
      -4, -4, -3, -2, -4,
      -5, -5, -4, -3, -3,
      -3, -6, -6, -4, -3,
      -5, -5, -4, -4, -5,
      -5, -5, -5, -5, -5,
      -6, -7, -5, -5, -8,
      -8, -5, -4, -4, -3,
      -4, -5, -5, -4, -3,
      -4, -4, -4, -5, -6,
      -5, -3, -3, -3, -3,
      -4, -4, -3, -2, -3,
      -4, -5, -5, -4, -4,
      -5, -6, -5, -5, -5,
      -6, -7, -7, -5, -4,
      -6, -7, -8, -7, -6,
      -6, -7, -9, -8, -6,
      -4, -4, -7, -8, -7,
      -4, -2, -3, -4, -3,
      1, 3, 2, 0, -1,
      1, 2, 2, 0, -2,
      0, 0, -4, -4, -5,
      -5, -5, -4, -2, 4,
      1, -8, -4, 0, -4,
      -8, -8, -6, -5, -5,
      -6, -7, -6, -5, -4,
      -4, -4, -4, -6, -6,
      -3, -3, -4, -4, -3,
      -4, -6, -5, -4, -4,
      -3, -3, -5, -5, -3,
      -4, -6, -6, -4, -4,
      -5, -5, -5, -5, -6,
      -6, -5, -1, 7, -1,
      -10, 1, 11, -6, -21,
      -5, 4, -9, -17, -11,
      -4, -5, -8, -10, -7,
      0, -3, -10, -4, 3,
      -3, -8, 0, 4, -4,
      -5, 1, 1, -4, -3,
      0, -3, -4, -3, -6,
      -7, -5, -6, -6, -4,
      -3, -6, -6, -4, -5,
      -8, -8, -4, -2, -9,
      -12, -6, -2, -6, -9,
      -8, -3, -1, -8, -10,
      -3, -1, -8, -9, -3,
      1, -7, -12, -2, 6,
      -7, -16, 2, 7, -9,
      -8, 5, 0, -11, -8,
      0, -1, -7, -7, 0,
      2, -6, -8, 0, 5,
      -5, -14, 0, 6, -12,
      -13, 5, 0, -14, -5,
      4, -3, -9, -5, 0,
      -1, -7, -6, 1, -2,
      -10, -6, 1, -4, -10,
      -4, -2, -6, -6, -3,
      -5, -7, -2, -3, -5,
      -2, -4, -5, 0, -2,
      -8, 0, 0, -11, -4,
      3, -8, -8, 2, -5,
      -10, -1, -2, -10, -4,
      0, -6, -7, -4, -4,
      -4, -5, -6, -6, -3,
      -5, -8, -5, -3, -6,
      -8, -3, -3, -9, -8,
      -1, -4, -10, -5, 0,
      -5, -6, 0, 0, -4,
      -4, 0, 0, -4, -4,
      -1, 0, -4, -3, -2,
      -3, -4, -6, -6, -3,
      -6, -10, -6, -3, -10,
      -12, -7, -8, -12, -10,
      -7, -10, -11, -8, -9,
      -11, -8, -7, -5, 0,
      0, -7, -9, -9, -7,
      -7, -7, -6, -9, -7,
      -4, -10, -16, -10, -3,
      -7, -9, -13, -12, -4,
      -8, -16, -12, -4, -10,
      -15, -10, -5, -5, -7,
      -10, -9, -5, -7, -12,
      -8, -4, -9, -9, -4,
      -9, -8, -5, -10, -12,
      -4, -2, -5, -9, -6,
      5, 1, -13, -16, -16,
      -19, -19, -16, -12, -7,
      -10, -10, -7, -7, -6,
      -7, -7, -4, 0, -4,
      -8, -5, -5, -6, -8,
      -9, -8, -4, -7, -10,
      -9, -6, -9, -13, -12,
      -10, -6, -7, -11, -12,
      -6, -7, -16, -12, -3,
      -8, -14, -11, -7, -5,
      -7, -12, -8, -3, -7,
      -9, -4, -8, -15, -11,
      -10, -12, -12, -9, -11,
      -14, -10, -9, -9, -8,
      -8, -6, -4, -9, -11,
      -6, -4, -6, -7, -9,
      -13, -10, -10, -10, -8,
      -5, -5, -8, -6, -7,
      -10, -10, -9, -8, -4,
      -5, -8, -9, -7, -8,
      -10, -12, -9, -9, -9,
      -10, -13, -13, -10, -9,
      -10, -4, -5, -13, -10,
      -1, -1, -10, -12, -11,
      -7, -6, -7, -5, -7,
      -14, -12, -4, -4, -12,
      -9, -4, -11, -15, -9,
      -7, -11, -10, -9, -8,
      -7, -14, -16, -4, -2,
      -12, -14, -7, -10, -16,
      -13, -5, -4, -11, -14,
      -7, 2, -4, -15, -10,
      1, -4, -11, -8, -9,
      -10, -11, -12, -7, -2,
      -7, -15, -11, -7, -11,
      -12, -9, -9, -5, -5,
      -12, -10, -5, -11, -15,
      -2, 2, -8, -10, -12,
      -14, -7, -5, -8, -4,
      -3, -9, -7, -7, -15,
      -11, -3, -13, -16, -2,
      -4, -16, -8, 0, -7,
      -10, -10, -12, -7, -8,
      -18, -8, 3, -5, -12,
      -4, -4, -15, -14, -6,
      -5, -2, -8, -12, -2,
      0, -14, -12, 3, -4,
      -14, -8, -9, -16, -13,
      -11, -9, -4, -7, -13,
      -12, -10, -10, -13, -10,
      -7, -7, -9, -9, -10,
      -12, -9, -8, -10, -5,
      -4, -7, -8, -9, -8,
      -10, -14, -15, -7, -3,
      -9, -8, -6, -10, -17,
      -12, -3, -3, -8, -12,
      -9, -8, -10, -12, -7,
      -2, -9, -12, -11, -12,
      -11, -6, -6, -11, -10,
      -11, -9, -5, -6, -8,
      -7, -9, -13, -6, -1,
      -8, -12, -5, -4, -12,
      -7, 0, -4, -12, -14,
      -11, -6, -7, -13, -12,
      -5, -11, -16, -9, -3,
      -9, -13, -6, -5, -8,
      -10, -10, -5, 0, -10,
      -12, -3, -9, -18, -12,
      -5, -10, -14, -10, -7,
      -6, -12, -15, -6, -3,
      -12, -12, -1, -4, -14,
      -11, -3, -6, -12, -9,
      -7, -8, -11, -14, -8,
      -3, -9, -12, -6, -7,
      -17, -14, -3, -2, -10,
      -12, -7, -5, -8, -12,
      -10, -4, -5, -12, -12,
      -7, -10, -15, -12, -7,
      -9, -13, -11, -5, -7,
      -11, -7, -4, -6, -9,
      -7, -6, -9, -10, -6,
      -1, -6, -11, -7, -4,
      -11, -14, -8, -4, -10,
      -15, -9, -3, -8, -14,
      -10, -3, -3, -11, -9,
      -2, -7, -14, -13, -8,
      -10, -14, -14, -6, -3,
      -9, -12, -6, -6, -13,
      -16, -11, -8, -11, -12,
      -10, -7, -7, -11, -12,
      -10, -8, -10, -9, -6,
      -6, -6, -5, -6, -8,
      -6, -5, -4, -2, -2,
      -7, -6, -4, -9, -10,
      -5, -7, 0, 0, -4,
      -4, -5, -9, -12, -13,
      -11, -10, -10, -12, -11,
      -8, -7, -5, -3, -3,
      -9, -10, 14, 25, 0,
      -7, -12, -18, -19, -21,
      -16, -12, -12, -5, -10,
      -10, -4, -5, -6, -5,
      -7, -4, -8, -11, -6,
      -6, -7, -5, -6, -6,
      -5, -7, -7, -7, -9,
      -10, -9, -9, -8, -8,
      -8, -7, -8, -7, -6,
      -7, -7, -8, -7, -7,
      -10, -9, -6, -7, -6,
      -6, -7, -5, -8, -8,
      -5, -5, -8, -8, -9,
      -9, -9, -10, -7, -8,
      -8, -7, -9, -11, -11,
      -10, -7, -6, -10, -10,
      -9, -12, -10, -8, 0,
      4, -5, -7, -5, -11,
      -17, -17, -13, -8, -6,
      -3, -6, -11, -8, -8,
      -8, -1, -7, -13, -7,
      -8, -9, -6, -9, -9,
      -8, -9, -7, -7, -9,
      -8, -9, -10, -6, -6,
      -6, -8, -10, -3, -7,
      -12, -2, -4, -7, -5,
      -8, -7, -7, -13, -10,
      -7, -5, -5, -11, -11,
      -7, -10, -10, -6, -6,
      -8, -6, -7, -10, -11,
      -6, -10, -8, -4, -8,
      -6, -6, -10, -6, -5,
      -9, -5, -7, -8, -6,
      -9, -12, -9, -12, -8,
      -7, -11, -5, -7, -11,
      -7, -8, -7, -5, -10,
      -9, -9, -12, -6, -8,
      -8, -6, -8, -5, -5,
      -7, -7, -8, -6, -8,
      -8, -5, -9, -8, -3,
      -8, -6, -6, -8, -6,
      -11, -10, -6, -11, -7,
      -6, -12, -5, -7, -10,
      -6, -10, -10, -6, -9,
      -2, -4, -11, -7, -12,
      -10, -5, -8, -7, -5,
      -6, -8, -11, -12, -7,
      -6, -8, -6, -9, -9,
      -5, -9, -6, -4, -7,
      -8, -9, -9, -9, -8,
      -8, -10, -10, -7, -4,
      -9, -6, -5, -8, -4,
      -5, -10, -10, -9, -8,
      -5, -11, -8, -6, -11,
      -6, -5, -11, -9, -5,
      -8, -10, -8, -9, -9,
      -8, -9, -8, -10, -9,
      -4, -11, -6, -4, -10,
      -5, -5, -10, -6, -9,
      -8, -6, -12, -9, -5,
      -8, -7, -7, -7, -8,
      -8, -8, -12, -7, -4,
      -11, -7, -5, -12, -5,
      -7, -10, -4, -10, -8,
      -6, -8, -7, -8, -6,
      -1, -9, -7, -3, -13,
      -6, -3, -11, -7, -10,
      -14, -7, -11, -12, -5,
      -9, -10, -8, -6, -5,
      -8, -5, -4, -9, -7,
      -2, -8, -4, -4, -9,
      -5, -9, -6, -8, -12,
      -8, -10, -6, -6, -13,
      -8, -5, -15, -12, -6,
      -11, -7, -9, -9, -9,
      -13, -6, -7, -13, -7,
      -6, -10, -8, -8, -7,
      -6, -10, -6, -7, -12,
      -4, -9, -10, 0, -10,
      -11, -4, -10, -12, -8,
      -11, -6, -6, -10, -2,
      -10, -11, -2, -7, -10,
      -7, -7, -9, -8, -11,
      -8, -9, -8, -5, -8,
      -6, -7, -9, -9, -7,
      -8, -8, -5, -7, -9,
      -8, -10, -10, -7, -5,
      -8, -2, -4, -8, -9,
      -12, -9, -8, -8, -6,
      -2, -5, -7, -4, -7,
      -6, -6, -5, -7, -9,
      -7, -11, -11, -5, -6,
      -10, -5, -7, -6, -4,
      -10, -9, -4, -7, -10,
      -6, -8, -11, -10, -10,
      -10, -10, -9, -8, -4,
      -9, -11, -7, -11, -13,
      -8, -7, -8, -4, -5,
      -7, -5, -9, -8, -3,
      -8, -8, -6, -10, -8,
      -10, -12, -8, -10, -11,
      -5, -8, -10, -6, -9,
      -8, -3, -10, -8, -5,
      -12, -9, -7, -10, -6,
      -5, -9, -6, -6, -10,
      -9, -7, -10, -11, -9,
      -9, -9, -9, -7, -7,
      -8, -7, -7, -7, -5,
      -6, -8, -6, -5, -6,
      -6, -5, -7, -6, -5,
      -6, -6, -7, -8, -7,
      -8, -7, -6, -8, -8,
      -7, -9, -8, 0, 0,
      6, 26, 17, -23, -31,
      -17, -15, -10, -4, -7,
      -8, -3, 11, 18, 2,
      -19, -24, -19, -12, -4,
      1, 3, 2, -2, -5,
      -6, -4, 0, 5, 15,
      13, -1, -8, -9, -12,
      -11, -7, -4, -4, -5,
      -6, -6, -7, -6, -6,
      -5, -1, 0, -3, -4,
      -3, -2, -3, -5, -9,
      -12, -13, -14, -15, -14,
      -13, -11, -8, -6, -4,
      -3, -2, 0, 1, 2,
      3, 4, 5, 7, 7,
      7, 6, 4, 2, 0,
      -2, -4, -5, -6, -7,
      -7, -8, -9, -10, -10,
      -9, -8, -8, -8, -9,
      -10, -10, -10, -11, -13,
      -14, -14, -14, -13, -12,
      -10, -10, -11, -13, -14,
      -14, -13, -8, 0, 0,
      0, 3, 9, 6, -22,
      -35, -21, -8, -4, -4,
      -3, 1, 1, -7, -1,
      19, 29, 23, 0, -23,
      -32, -27, -16, -8, -4,
      1, 2, -2, -5, -4,
      -3, -3, -1, -1, -3,
      -5, -4, -3, -4, -6,
      -5, -4, -3, -3, -4,
      -7, -6, -5, -5, -3,
      -3, -4, -5, -4, -3,
      -3, -4, -6, -5, -4,
      -6, -8, -8, -7, -6,
      -5, -3, -2, 5, 13,
      5, -13, -17, -14, -14,
      -13, -11, -9, -1, 4,
      -1, -5, -3, -1, 0,
      0, -3, -9, -11, -6,
      -4, -5, -5, -5, -5,
      -4, -4, -6, -7, -4,
      -3, -4, -4, -4, -6,
      -5, -2, -2, -6, -8,
      -6, -5, -4, -4, -5,
      -6, -1, 6, 8, -1,
      -6, -4, -5, -7, -12,
      -17, -14, -7, -6, -9,
      -8, -3, 0, 0, -1,
      3, 2, -9, -17, -18,
      -11, 0, 7, 7, -1,
      -11, -15, -13, -6, 3,
      7, 3, -4, -11, -13,
      -10, -4, 3, 5, 1,
      -6, -10, -10, -2, 8,
      9, 0, -13, -22, -19,
      -8, 6, 12, 7, -4,
      -13, -17, -11, 0, 8,
      9, 1, -9, -15, -14,
      -7, 2, 6, 4, -3,
      -11, -14, -12, -4, 2,
      4, 0, -7, -11, -11,
      -5, 0, 2, -1, -7,
      -11, -11, -5, 1, 3,
      1, -3, -7, -8, -6,
      -2, 0, 0, -2, -6,
      -7, -5, 1, 8, 12,
      9, -4, -20, -32, -31,
      -17, 4, 21, 27, 19,
      -7, -33, -35, -12, 12,
      21, 8, -20, -38, -33,
      -8, 17, 25, 17, -2,
      -19, -21, -8, 7, 13,
      6, -5, -15, -17, -7,
      3, 6, 1, -9, -15,
      -13, -4, 7, 11, 4,
      -7, -14, -14, -7, 0,
      4, 2, -5, -11, -11,
      -8, -2, 3, 3, -1,
      -6, -8, -7, -5, -4,
      -3, -3, -5, -5, -5,
      -4, -4, -4, -4, -5,
      -6, -5, -4, -4, -4,
      -4, -4, -4, -3, -3,
      -4, -5, -6, -6, -5,
      -4, -4, -4, -5, -6,
      -5, -4, -2, -2, -3,
      0, 0, -1, 0, 10,
      20, 5, -18, -17, -5,
      0, 0, 0, -1, -1,
      6, 24, 26, -4, -32,
      -30, -12, 0, -1, -6,
      -6, -5, -4, -4, -4,
      -4, -3, -2, -3, -3,
      -2, -1, -1, -1, -2,
      -2, -2, -2, -2, -4,
      -4, -4, -3, -1, -1,
      -2, -1, -1, -1, -1,
      -1, -1, 0, -1, -1,
      0, 1, 0, 0, -1,
      0, 0, 0, -1, -2,
      -2, -3, -4, -2, -4,
      -4, -3, -6, -6, -4,
      -3, -5, -7, -6, -5,
      -5, -5, -6, -3, -1,
      -4, -6, -4, -3, -3,
      -4, -4, -2, -1, -1,
      -3, -4, -1, 0, -1,
      -2, -1, 0, 0, 0,
      1, 1, 0, 1, 2,
      2, 0, -2, -3, -2,
      -2, -2, -3, -3, -4,
      -6, -5, -5, -6, -5,
      -5, -7, -6, -7, -7,
      -6, -3, -3, -6, -6,
      -5, -5, -5, 0, 0,
      -1, 1, 6, -1, -20,
      -3, 18, -16, -4, 22,
      -18, 11, 31, -25, -12,
      2, -5, 8, -6, -2,
      3, -3, 7, 0, -3,
      2, -1, 4, 1, 0,
      1, -4, 0, 1, 1,
      2, -2, 0, 0, -1,
      1, -1, -1, -2, -3,
      0, -1, -1, -1, -1,
      -1, 2, 6, 8, 6,
      -2, -3, 2, -3, -11,
      -13, -16, -13, -7, -7,
      -7, -5, 1, 5, 5,
      4, 2, 2, 2, 3,
      2, -1, -2, -1, -1,
      -2, -2, -1, -3, -4,
      -2, -1, -4, -4, -2,
      -2, -1, 3, 2, -3,
      -4, -4, -4, -4, -5,
      -4, -4, -5, -7, -7,
      -6, -3, -2, -2, -2,
      -2, -1, 0, 0, 0,
      0, -1, -1, 0, -1,
      -2, -3, -3, -3, -3,
      -3, -4, -4, -4, -4,
      -3, -1, 0, 0, 0,
      1, 1, 1, 1, 4,
      6, 5, 2, -3, -9,
      -14, -17, -17, -14, -10,
      -4, 1, 5, 7, 7,
      5, 1, -3, -7, -11,
      -14, -14, -13, -10, -6,
      -2, 1, 3, 4, 3,
      1, -2, -4, -6, -7,
      -7, -6, -4, -2, 0,
      1, 2, 3, 2, 1,
      -1, -2, -4, -4, -5,
      -4, -3, -1, 0, 0,
      1, 1, 0, 0, -1,
      -2, -3, -3, -3, -3,
      0, 3, 4, 0, -7,
      -16, -23, -25, -24, -18,
      -6, 11, 20, 20, 15,
      6, -4, -11, -17, -20,
      -19, -14, -7, -1, 7,
      14, 17, 18, 18, 12,
      2, -9, -19, -26, -28,
      -23, -16, -5, 7, 21,
      29, 31, 26, 15, -1,
      -14, -24, -29, -28, -20,
      -10, 0, 10, 18, 20,
      19, 14, 4, -4, -7,
      -7, -6, -6, -6, -7,
      -8, -8, -8, -8, -6,
      -3, 0, 2, 3, 2,
      0, -1, -2, -5, -6,
      -7, -7, -5, -2, 1,
      2, 3, 3, 2, 1,
      0, 0, -2, -2, -2,
      -2, -2, -1, 1, 1,
      2, 2, 3, 2, 0,
      0, -3, 0, 6, 3,
      -5, -5, -4, 0, 16,
      13, -22, -32, -10, 0,
      -3, -3, -2, -2, -2,
      -1, -2, -3, -3, -3,
      -3, -4, -5, -5, -3,
      -1, -2, -4, -4, -3,
      -1, -1, -3, -5, -5,
      -6, -5, -4, -3, -1,
      4, 5, -4, -8, -4,
      -2, -1, 1, 1, -1,
      -5, -2, 14, 21, -5,
      -30, -25, -9, -1, 0,
      -1, -1, -2, -6, -12,
      -10, -2, 0, -1, 1,
      -1, -5, -8, -4, 1,
      1, -5, -11, -14, -12,
      -9, -7, -4, 1, 7,
      7, 2, -2, -3, -6,
      -7, -4, -1, 1, -2,
      -7, -10, -9, -8, -5,
      -2, -4, -5, -5, -4,
      -4, -3, -2, -2, -2,
      -1, -2, -1, -1, -3,
      -3, -3, -4, -3, -2,
      -4, -4, -5, -5, -2,
      0, 2, 0, -5, -5,
      -4, -3, -1, 0, 0,
      -1, -2, -5, -4, -3,
      -2, -4, -4, -3, -2,
      -4, -7, -7, -1, -1,
      -6, -8, -8, -7, -7,
      -7, -7, -6, -6, -6,
      -5, -5, -7, -6, -4,
      -5, -7, -7, -4, 0,
      1, 3, 3, 2, 0,
      -1, -2, -1, 1, 0,
      0, 0, -1, -2, -10,
      -11, -3, -2, -7, -5,
      -3, -6, -3, 9, 2,
      -12, 0, 3, -12, -7,
      0, -8, -7, -2, 1,
      5, 9, -4, -24, -15,
      2, 13, 22, -10, -38,
      -13, 4, -6, -9, -7,
      -2, 4, 4, -3, -13,
      -8, 5, 7, 3, 0,
      -5, -7, 1, 4, -2,
      -4, -5, -5, -4, 1,
      10, 14, -3, -26, -16,
      6, 4, -12, -19, -8,
      9, 10, 2, 2, 1,
      -9, -12, -5, -18, -38,
      -29, -9, 0, 2, -3,
      -8, 0, 13, 14, 5,
      -4, -12, -6, 6, 5,
      -9, -15, -7, 4, 6,
      0, -5, -3, -2, -2,
      -2, -7, -15, -16, -9,
      -2, -2, -8, -10, -4,
      5, 8, 1, -6, -5,
      1, 3, -2, -10, -11,
      -6, 0, 0, -5, -10,
      -7, 1, 6, 1, -8,
      -8, 1, 4, -1, -9,
      -10, -2, 4, 3, -3,
      -8, -7, -2, 0, -4,
      -9, -10, -4, 1, -1,
      -7, -8, -4, 1, 2,
      -1, -5, -7, -4, -1,
      -3, -8, -10, -6, -2,
      -2, -6, -9, -7, -2,
      -1, -5, -9, -9, -5,
      -3, -3, -6, -7, -5,
      -2, -2, -6, -9, -8,
      -4, -3, -4, -7, -7,
      -3, 0, 1, 0, 0,
      0, 4, 5, 3, 1,
      1, 0, 1, 2, 0,
      0, 1, -1, -6, -10,
      -10, -7, -2, 3, 4,
      3, 0, -4, -8, -8,
      -6, -2, 1, 3, 3,
      0, -4, -6, -6, -5,
      -2, 2, 7, 5, -1,
      -9, -16, -16, -10, 1,
      15, 25, 20, 0, -24,
      -38, -32, -11, 15, 33,
      35, 22, -2, -24, -30,
      -18, 3, 21, 31, 26,
      9, -10, -22, -21, -8,
      8, 21, 23, 15, 1,
      -11, -15, -9, 2, 13,
      17, 14, 5, -6, -12,
      -11, -4, 5, 12, 12,
      5, -3, -9, -11, -7,
      1, 7, 9, 6, 0,
      -6, -10, -8, -3, 2,
      6, 6, 2, -3, -7,
      -8, -5, -1, 4, 4,
      2, -3, -7, -8, -5,
      -2, 1, 2, -1, -4,
      -7, -7, -5, 0, 2,
      1, -2, -5, -8, -8,
      -5, -2, 0, 0, -1,
      -4, -7, -7, -5, -3,
      -2, -1, -3, -5, -6,
      -4, -2, -1, -1, -3,
      -5, -6, -5, -3, -1,
      -2, -3, -4, -5, -6,
      -6, -4, -1, 0, -2,
      -5, -8, -9, -7, -4,
      -1, 0, -1, -4, -6,
      -7, -6, -3, -1, -1,
      -4, -6, -8, -8, -6,
      -3, 0, 0, -4, -7,
      -8, -6, -3, 0, 0,
      -2, -5, -8, -9, -7,
      -3, -1, 0, -1, -5,
      -7, -8, -7, -4, -1,
      -1, -2, -4, -6, -7,
      -6, -4, -1, -1, -2,
      -5, -5, -5, -5, -5,
      -4, -3, -3, -3, -3,
      -4, -4, -4, -4, -4,
      -4, -5, -5, -4, -3,
      -2, -3, -4, -6, -6,
      -4, -1, 1, 0, -2,
      -5, -7, -7, -5, -2,
      -1, -1, -3, -7, -9,
      -8, -4, 1, 2, 1,
      -3, -7, -9, -8, -5,
      0, 2, 0, -3, -6,
      -8, -7, -4, -1, 0,
      -1, -3, -6, -6, -4,
      -2, -1, -1, -4, -6,
      -6, -5, -3, -1, -2,
      -3, -5, -5, -5, -3,
      -2, -1, -1, -3, -5,
      -5, -4, -2, -1, -2,
      -5, -7, -6, -4, -2,
      -1, -2, -3, -4, -4,
      -3, -1, 0, -1, -2,
      -4, -6, -6, -5, -4,
      -3, -3, -4, -5, -5,
      -4, -2, -1, -1, -2,
      -3, -4, -4, -3, -3,
      -3, -3, -4, -4, -4,
      -3, -3, -2, -2, -2,
      -2, -1, -1, -2, -3,
      -3, -2, -1, -2, -2,
      -3, -3, -4, -4, -4,
      -3, -3, -3, -3, -4,
      -5, -4, -4, -3, -3,
      -4, -5, -6, -7, -6,
      -6, -5, -4, -3, -2,
      -1, -1, -1, 0, 0,
      1, 1, 2, 1, 1,
      0, -2, -4, -2, -5,
      -4, 6, 7, 4, 0,
      0, 6, 3, -7, -10,
      -14, -17, -11, -8, -14,
      -16, -9, -4, -7, -8,
      -6, -4, -1, 1, -1,
      -1, 2, 1, -3, -5,
      -4, -1, -3, -7, -10,
      -7, -1, -1, 0, -5,
      -13, -9, 1, 3, 4,
      0, -5, -1, -4, -15,
      -17, -8, 2, -1, -12,
      -12, -6, -4, -3, -6,
      -12, -14, -8, 3, 7,
      0, -9, -10, 1, 11,
      9, -2, -10, -11, -10,
      -7, -11, -17, -7, 5,
      2, -6, -11, -6, 6,
      6, -10, -22, -14, 4,
      12, 9, 0, -7, -3,
      0, -7, -12, -6, -4,
      -9, -7, -2, -4, -2,
      5, 6, 3, -5, -13,
      -13, -9, -11, -14, -9,
      0, 5, 6, 6, 3,
      -1, 0, -3, -16, -22,
      -12, 0, 2, -3, -7,
      -2, 3, 0, -3, -7,
      -10, -11, -8, -1, 5,
      8, 5, -2, -10, -11,
      -6, -3, -7, -9, -6,
      -4, 1, 3, -5, -10,
      -7, -7, -9, -9, -7,
      -2, -1, -5, -5, -3,
      -5, -8, -4, 1, -1,
      -5, -5, -3, -6, -4,
      3, 1, -7, -11, -11,
      -10, -6, -1, 4, 4,
      -2, -6, -8, -9, -8,
      -7, -5, -5, -6, -4,
      -3, -8, -9, -5, -2,
      0, -2, -8, -8, -4,
      -3, -6, -7, -7, -5,
      -3, -4, -2, 3, 2,
      -6, -8, -5, -6, -10,
      -8, -3, 0, -3, -4,
      -3, -3, -1, 2, 0,
      -6, -10, -8, -2, 1,
      -4, -8, -10, -8, -5,
      -4, 0, 0, -4, -4,
      -4, -4, -3, -4, -3,
      -1, 7, 22, 10, -30,
      -20, -1, -13, -14, -15,
      -9, -2, -1, -1, -4,
      -5, -4, -1, 0, 0,
      -1, -3, -5, -4, -2,
      -2, -1, -4, -4, -3,
      -5, -5, -5, -4, -5,
      -6, -6, -6, -4, -5,
      -5, -4, 0, 6, -2,
      -5, 4, -9, -14, -2,
      -3, -1, -10, -21, -12,
      -3, -5, -7, -5, -4,
      1, 7, 4, -1, -4,
      1, 3, -10, -15, -16,
      -17, -13, -9, -7, -5,
      -3, -3, -2, 0, 0,
      -2, -3, -2, 4, 5,
      -1, -4, 0, 2, 4,
      0, -3, -3, -6, -1,
      6, -2, -17, -15, -6,
      -5, -13, -18, -15, -10,
      -4, -4, -6, -8, -7,
      -3, 0, 0, 0, 1,
      2, 0, -3, -1, 0,
      -2, -6, -7, -8, -8,
      -8, -9, -8, -8, -9,
      -9, -7, -4, -1, 0,
      -1, -3, -4, -1, 2,
      1, -3, -6, -8, -5,
      -1, -1, -5, -7, -4,
      -2, -2, -4, -6, -7,
      -7, -4, -2, -3, -6,
      -6, -4, -2, -2, -3,
      -4, -5, -6, -6, -5,
      -4, -4, -5, -6, -7,
      -5, -4, -3, -4, -7,
      -8, -6, -2, 0, -1,
      -2, -3, -3, -4, -4,
      -2, -2, -3, -5, -7,
      -7, -6, -4, -5, -7,
      -8, -8, -7, -5, -4,
      -5, -8, -9, -7, -4,
      -3, -4, -6, -6, -5,
      -3, -2, -1, -1, -2,
      -3, -3, -3, -1, 0,
      0, -2, -4, -4, -3,
      -2, -2, -2, 0, -4,
      0, 0, -3, -5, -10,
      -13, -14, -14, -13, -12,
      -8, -5, -2, 1, 2,
      2, -1, -3, -6, -8,
      -7, -3, -5, -9, -11,
      -13, -14, -12, -10, -6,
      -4, 0, 1, 2, 7,
      10, 5, -2, -9, -14,
      -18, -20, -21, -22, -15,
      -2, 8, 14, 18, 16,
      6, -8, -20, -30, -32,
      -27, -19, -12, -5, -1,
      1, 0, -1, -2, -3,
      -2, 0, 0, 0, -1,
      0, -1, -1, -2, -3,
      -5, -7, -9, -11, -13,
      -13, -11, -10, -8, -6,
      -4, -3, -2, -1, 0,
      0, -1, -2, -4, -6,
      -7, -8, -8, -7, -6,
      -5, -4, -4, -2, -3,
      -4, -4, -5, -7, -9,
      -10, -9, -9, -8, -7,
      -6, -5, -5, -4, -5,
      -7, -8, -9, -10, -9,
      -6, -3, 0, 1, 1,
      0, -3, -6, -10, -14,
      -15, -13, -10, -5, -1,
      2, 4, 4, 2, -1,
      -4, -9, -16, -22, -25,
      -23, -16, -7, 1, 7,
      9, 5, 1, -3, -7,
      -11, -15, -18, -16, -12,
      -6, -2, 0, 0, -1,
      -4, -7, -9, -10, -8,
      -6, -3, -1, -1, -1,
      -2, -4, -5, -7, -9,
      -10, -10, -8, -6, -5,
      -7, -7, -6, -3, -1,
      -1, -2, -3, -5, -5,
      -7, -10, -12, -12, -8,
      -5, -4, -3, -1, -1,
      -2, -4, -6, -8, -10,
      -10, -10, -8, -7, -6,
      -4, -1, 0, -3, -7,
      -10, -13, -11, -6, -2,
      -3, -6, -10, -10, -6,
      -5, -5, -6, -7, -6,
      -5, -5, -5, -5, -6,
      -7, -6, -3, -1, -4,
      -6, -3, -3, -5, -7,
      -7, -8, -11, -10, -8,
      -3, -1, -3, -8, -10,
      -11, -11, -9, -8, -7,
      -5, -5, -7, -11, -11,
      -8, -2, 2, 1, -2,
      -7, -10, -10, -9, -7,
      -6, -6, -5, -5, -4,
      -1, -2, -3, -2, -1,
      -3, -3, -2, -7, -11,
      -8, -4, -4, -7, -10,
      -13, -13, -12, -6, 4,
      9, 7, -1, -11, -17,
      -18, -14, -8, -2, 1,
      3, 1, -4, -11, -12,
      -11, -9, -10, -11, -11,
      -10, -6, 0, 4, 3,
      -1, -9, -12, -9, -5,
      -2, -3, -7, -8, -7,
      -4, -2, -5, -8, -11,
      -14, -11, -3, 2, 2,
      -1, -6, -10, -11, -14,
      -20, -21, -12, -3, 3,
      6, 7, 6, 3, -3,
      -8, -8, -5, -3, 0,
      2, 2, -1, -5, -8,
      -13, -16, -18, -16, -14,
      -11, -7, -1, 4, 4,
      2, 1, -3, -6, -6,
      -7, -7, -7, -7, -5,
      -3, -3, -1, 0, -4,
      -8, -12, -14, -15, -15,
      -13, -8, -3, 0, 3,
      3, -1, -7, -13, -17,
      -18, -13, -4, -1, -2,
      1, 6, 8, 4, -1,
      -6, -11, -16, -19, -15,
      -10, -7, -3, -2, -3,
      -3, -3, -4, -5, -7,
      -9, -12, -13, -11, -8,
      -3, 1, 0, -2, -4,
      -6, -8, -10, -11, -13,
      -13, -10, -6, -1, 2,
      5, 4, -3, -10, -14,
      -13, -9, -4, 0, 2,
      2, -1, -4, -6, -9,
      -11, -12, -10, -9, -9,
      -9, -8, -6, -5, -6,
      -7, -5, -1, 0, -1,
      -3, -3, -2, 0, 1,
      0, -1, -2, -4, -6,
      -7, -9, -11, -12, -12,
      -10, -8, -5, -4, -5,
      -9, -13, -14, -13, -11,
      -9, -4, 0, 0, 0,
      0, -1, -4, -7, -9,
      -8, -6, -4, -5, -8,
      -8, -6, -7, -7, -7,
      -9, -11, -11, -10, -8,
      -5, -3, -1, 1, 3,
      1, -3, -6, -6, -5,
      -4, -6, -8, -7, -7,
      -9, -11, -11, -10, -10,
      -10, -10, -10, -10, -9,
      -7, -4, -2, 0, -1,
      -5, -6, -4, -1, 0,
      2, 1, -1, 0, 0,
      1, 2, 4, 5, 6,
      7, 7, 7, 7, 6,
      6, 7, 7, 6, 5,
      3, 1, -2, -5, -7,
      -8, -10, -10, -11, -12,
      -12, -13, -14, -15, -16,
      -16, -16, -15, -14, -14,
      -14, -15, -14, -14, -13,
      -12, -11, -10, -9, -7,
      -6, -5, -4, -3, 0,
      0, -1, 2, 4, 6,
      8, 8, 9, 9, 8,
      8, 8, 8, 7, 6,
      4, 1, -1, -3, -3,
      -4, -6, -7, -8, -8,
      -9, -11, -12, -14, -15,
      -16, -16, -16, -16, -15,
      -14, -13, -12, -11, -10,
      -9, -8, -6, -5, -4,
      -3, -3, -2, -2, -1,
      0, 0, 0, 2, 4,
      6, 7, 8, 9, 9,
      9, 9, 8, 8, 7,
      5, 3, 2, 1, -1,
      -3, -6, -8, -10, -11,
      -11, -11, -12, -13, -14,
      -14, -15, -16, -16, -16,
      -16, -15, -14, -14, -14,
      -13, -13, -12, -11, -10,
      -10, -9, -8, -7, -7,
      -5, 0, 0, 0, 1,
      1, 1, 3, 5, 5,
      5, 6, 8, 8, 8,
      8, 7, 6, 5, 4,
      2, -1, -1, -1, -3,
      -5, -6, -7, -8, -10,
      -11, -11, -10, -11, -14,
      -16, -16, -15, -14, -15,
      -16, -15, -15, -16, -16,
      -14, -12, -11, -9, -9,
      -7, -5, 0, 0, 0,
      2, 4, 6, 7, 7,
      7, 8, 9, 9, 8,
      7, 8, 10, 11, 10,
      9, 7, 4, 2, 1,
      0, -1, -2, -5, -7,
      -7, -7, -6, -7, -10,
      -10, -10, -11, -12, -15,
      -16, -16, -16, -16, -14,
      -13, -11, -10, -9, -7,
      -6, -4, -4, 0, 0,
      0, 3, 6, 8, 8,
      6, 5, 4, 2, 2,
      2, 0, -2, -2, -3,
      -3, -3, -3, -6, -10,
      -8, -5, -7, -10, -13,
      -14, -14, -12, -11, -12,
      -16, -16, -12, -9, -9,
      -10, -10, -10, -8, -5,
      -4, -3, -4, -4, -5,
      -4, -2, -1, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0
    }
  };
