#include <stdlib.h>
#include <stdio.h>
#include "graphite.h"
#include "statistics.h"
#include "poller.h"
#include "control_ng.h"
#include "call_interfaces.h"
#include "ssllib.h"

int _log_facility_rtcp;
int _log_facility_cdr;
int _log_facility_dtmf;
struct rtpengine_config rtpe_config = {
	.dtls_rsa_key_size = 2048,
};
struct rtpengine_config initial_rtpe_config;
struct poller *rtpe_poller;
struct poller_map *rtpe_poller_map;
GString *dtmf_logs;
struct control_ng *rtpe_control_ng[2];

static void __assert_g_string_eq(GString *a, const char *b, unsigned int line) {
	if (strcmp(a->str, b) == 0) {
		g_string_free(a, TRUE);
		return;
	}
	printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX test failed at line %u\n", line);
	printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX received >>>>> <%s>\n", a->str);
	printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX doesn't match expected <<<<< <%s>\n", b);

	const char *A = a->str;
	while (*A == *b) {
		A++;
		b++;
	}

	printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX difference in received at: ... <%s>\n", A);
	printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX difference in expected at: ... <%s>\n", b);

	abort();
}
#define assert_g_string_eq(a, b) __assert_g_string_eq(a, b, __LINE__)

static void __assert_metrics_eq(GQueue *q, const char *b, unsigned int line) {
	GString *a = g_string_new("");
	for (GList *l = q->head; l; l = l->next) {
		struct stats_metric *m = l->data;
#define APP_S(x) if (m->x) do { g_string_append(a, m->x); g_string_append_c(a, '\n'); } while (0)
		APP_S(descr);
		APP_S(label);
		APP_S(value_long);
		APP_S(value_short);
		APP_S(prom_label);
	}
	__assert_g_string_eq(a, b, line);
	statistics_free_metrics(&q);
}
#define assert_metrics_eq(a, b) __assert_metrics_eq(a, b, __LINE__)

int main(void) {
	rtpe_common_config_ptr = &rtpe_config.common;

	rtpe_ssl_init();
	rtpe_poller = poller_new();
	call_init();
	statistics_init();
	call_interfaces_init();
	control_ng_init();
	dtls_init();

	// fake current time
	rtpe_now = (struct timeval) {150,0};
	rtpe_started = (struct timeval) {80,0};

	// test cmd_time_min/max/avg

	GString *graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 150\n"
			"ping_time_max 0.000000 150\n"
			"ping_time_avg 0.000000 150\n"
			"pings_ps_min 0 150\n"
			"pings_ps_max 0 150\n"
			"pings_ps_avg 0 150\n"
			"ping_count 0 150\n"
			"offer_time_min 0.000000 150\n"
			"offer_time_max 0.000000 150\n"
			"offer_time_avg 0.000000 150\n"
			"offers_ps_min 0 150\n"
			"offers_ps_max 0 150\n"
			"offers_ps_avg 0 150\n"
			"offer_count 0 150\n"
			"answer_time_min 0.000000 150\n"
			"answer_time_max 0.000000 150\n"
			"answer_time_avg 0.000000 150\n"
			"answers_ps_min 0 150\n"
			"answers_ps_max 0 150\n"
			"answers_ps_avg 0 150\n"
			"answer_count 0 150\n"
			"delete_time_min 0.000000 150\n"
			"delete_time_max 0.000000 150\n"
			"delete_time_avg 0.000000 150\n"
			"deletes_ps_min 0 150\n"
			"deletes_ps_max 0 150\n"
			"deletes_ps_avg 0 150\n"
			"delete_count 0 150\n"
			"query_time_min 0.000000 150\n"
			"query_time_max 0.000000 150\n"
			"query_time_avg 0.000000 150\n"
			"querys_ps_min 0 150\n"
			"querys_ps_max 0 150\n"
			"querys_ps_avg 0 150\n"
			"query_count 0 150\n"
			"list_time_min 0.000000 150\n"
			"list_time_max 0.000000 150\n"
			"list_time_avg 0.000000 150\n"
			"lists_ps_min 0 150\n"
			"lists_ps_max 0 150\n"
			"lists_ps_avg 0 150\n"
			"list_count 0 150\n"
			"start recording_time_min 0.000000 150\n"
			"start recording_time_max 0.000000 150\n"
			"start recording_time_avg 0.000000 150\n"
			"start recordings_ps_min 0 150\n"
			"start recordings_ps_max 0 150\n"
			"start recordings_ps_avg 0 150\n"
			"start recording_count 0 150\n"
			"stop recording_time_min 0.000000 150\n"
			"stop recording_time_max 0.000000 150\n"
			"stop recording_time_avg 0.000000 150\n"
			"stop recordings_ps_min 0 150\n"
			"stop recordings_ps_max 0 150\n"
			"stop recordings_ps_avg 0 150\n"
			"stop recording_count 0 150\n"
			"start forwarding_time_min 0.000000 150\n"
			"start forwarding_time_max 0.000000 150\n"
			"start forwarding_time_avg 0.000000 150\n"
			"start forwardings_ps_min 0 150\n"
			"start forwardings_ps_max 0 150\n"
			"start forwardings_ps_avg 0 150\n"
			"start forwarding_count 0 150\n"
			"stop forwarding_time_min 0.000000 150\n"
			"stop forwarding_time_max 0.000000 150\n"
			"stop forwarding_time_avg 0.000000 150\n"
			"stop forwardings_ps_min 0 150\n"
			"stop forwardings_ps_max 0 150\n"
			"stop forwardings_ps_avg 0 150\n"
			"stop forwarding_count 0 150\n"
			"block DTMF_time_min 0.000000 150\n"
			"block DTMF_time_max 0.000000 150\n"
			"block DTMF_time_avg 0.000000 150\n"
			"block DTMFs_ps_min 0 150\n"
			"block DTMFs_ps_max 0 150\n"
			"block DTMFs_ps_avg 0 150\n"
			"block DTMF_count 0 150\n"
			"unblock DTMF_time_min 0.000000 150\n"
			"unblock DTMF_time_max 0.000000 150\n"
			"unblock DTMF_time_avg 0.000000 150\n"
			"unblock DTMFs_ps_min 0 150\n"
			"unblock DTMFs_ps_max 0 150\n"
			"unblock DTMFs_ps_avg 0 150\n"
			"unblock DTMF_count 0 150\n"
			"block media_time_min 0.000000 150\n"
			"block media_time_max 0.000000 150\n"
			"block media_time_avg 0.000000 150\n"
			"block medias_ps_min 0 150\n"
			"block medias_ps_max 0 150\n"
			"block medias_ps_avg 0 150\n"
			"block media_count 0 150\n"
			"unblock media_time_min 0.000000 150\n"
			"unblock media_time_max 0.000000 150\n"
			"unblock media_time_avg 0.000000 150\n"
			"unblock medias_ps_min 0 150\n"
			"unblock medias_ps_max 0 150\n"
			"unblock medias_ps_avg 0 150\n"
			"unblock media_count 0 150\n"
			"play media_time_min 0.000000 150\n"
			"play media_time_max 0.000000 150\n"
			"play media_time_avg 0.000000 150\n"
			"play medias_ps_min 0 150\n"
			"play medias_ps_max 0 150\n"
			"play medias_ps_avg 0 150\n"
			"play media_count 0 150\n"
			"stop media_time_min 0.000000 150\n"
			"stop media_time_max 0.000000 150\n"
			"stop media_time_avg 0.000000 150\n"
			"stop medias_ps_min 0 150\n"
			"stop medias_ps_max 0 150\n"
			"stop medias_ps_avg 0 150\n"
			"stop media_count 0 150\n"
			"play DTMF_time_min 0.000000 150\n"
			"play DTMF_time_max 0.000000 150\n"
			"play DTMF_time_avg 0.000000 150\n"
			"play DTMFs_ps_min 0 150\n"
			"play DTMFs_ps_max 0 150\n"
			"play DTMFs_ps_avg 0 150\n"
			"play DTMF_count 0 150\n"
			"statistics_time_min 0.000000 150\n"
			"statistics_time_max 0.000000 150\n"
			"statistics_time_avg 0.000000 150\n"
			"statisticss_ps_min 0 150\n"
			"statisticss_ps_max 0 150\n"
			"statisticss_ps_avg 0 150\n"
			"statistics_count 0 150\n"
			"silence media_time_min 0.000000 150\n"
			"silence media_time_max 0.000000 150\n"
			"silence media_time_avg 0.000000 150\n"
			"silence medias_ps_min 0 150\n"
			"silence medias_ps_max 0 150\n"
			"silence medias_ps_avg 0 150\n"
			"silence media_count 0 150\n"
			"unsilence media_time_min 0.000000 150\n"
			"unsilence media_time_max 0.000000 150\n"
			"unsilence media_time_avg 0.000000 150\n"
			"unsilence medias_ps_min 0 150\n"
			"unsilence medias_ps_max 0 150\n"
			"unsilence medias_ps_avg 0 150\n"
			"unsilence media_count 0 150\n"
			"publish_time_min 0.000000 150\n"
			"publish_time_max 0.000000 150\n"
			"publish_time_avg 0.000000 150\n"
			"publishs_ps_min 0 150\n"
			"publishs_ps_max 0 150\n"
			"publishs_ps_avg 0 150\n"
			"publish_count 0 150\n"
			"subscribe request_time_min 0.000000 150\n"
			"subscribe request_time_max 0.000000 150\n"
			"subscribe request_time_avg 0.000000 150\n"
			"subscribe requests_ps_min 0 150\n"
			"subscribe requests_ps_max 0 150\n"
			"subscribe requests_ps_avg 0 150\n"
			"subscribe request_count 0 150\n"
			"subscribe answer_time_min 0.000000 150\n"
			"subscribe answer_time_max 0.000000 150\n"
			"subscribe answer_time_avg 0.000000 150\n"
			"subscribe answers_ps_min 0 150\n"
			"subscribe answers_ps_max 0 150\n"
			"subscribe answers_ps_avg 0 150\n"
			"subscribe answer_count 0 150\n"
			"unsubscribe_time_min 0.000000 150\n"
			"unsubscribe_time_max 0.000000 150\n"
			"unsubscribe_time_avg 0.000000 150\n"
			"unsubscribes_ps_min 0 150\n"
			"unsubscribes_ps_max 0 150\n"
			"unsubscribes_ps_avg 0 150\n"
			"unsubscribe_count 0 150\n"
			"call_dur 0.000000 150\n"
			"average_call_dur 0.000000 150\n"
			"forced_term_sess 0 150\n"
			"managed_sess 0 150\n"
			"managed_sess_min 0 150\n"
			"managed_sess_max 0 150\n"
			"current_sessions_total 0 150\n"
			"current_sessions_own 0 150\n"
			"current_sessions_foreign 0 150\n"
			"current_transcoded_media 0 150\n"
			"current_sessions_ipv4 0 150\n"
			"current_sessions_ipv6 0 150\n"
			"current_sessions_mixed 0 150\n"
			"nopacket_relayed_sess 0 150\n"
			"oneway_stream_sess 0 150\n"
			"regular_term_sess 0 150\n"
			"relayed_errors_user 0 150\n"
			"relayed_packets_user 0 150\n"
			"relayed_bytes_user 0 150\n"
			"relayed_errors_kernel 0 150\n"
			"relayed_packets_kernel 0 150\n"
			"relayed_bytes_kernel 0 150\n"
			"relayed_errors 0 150\n"
			"relayed_packets 0 150\n"
			"relayed_bytes 0 150\n"
			"silent_timeout_sess 0 150\n"
			"final_timeout_sess 0 150\n"
			"offer_timeout_sess 0 150\n"
			"timeout_sess 0 150\n"
			"reject_sess 0 150\n");

	GQueue *stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"0\n"
			"0\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"0\n"
			"0\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"70 seconds\n"
			"70\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"0\n"
			"0\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"0.000000 seconds squared\n"
			"0.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"0\n"
			"0\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"0\n"
			"0\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minofferdelay\n"
			"0.000000\n"
			"maxofferdelay\n"
			"0.000000\n"
			"avgofferdelay\n"
			"0.000000\n"
			"Min/Max/Avg answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minanswerdelay\n"
			"0.000000\n"
			"maxanswerdelay\n"
			"0.000000\n"
			"avganswerdelay\n"
			"0.000000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"0/0/0 per sec\n"
			"minofferrequestrate\n"
			"0\n"
			"maxofferrequestrate\n"
			"0\n"
			"avgofferrequestrate\n"
			"0\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");

	RTPE_STATS_INC(ng_commands[NGC_OFFER]);
	RTPE_GAUGE_SET(ng_command_times[NGC_OFFER], 2500000LL);

	RTPE_STATS_INC(ng_commands[NGC_OFFER]);
	RTPE_GAUGE_SET(ng_command_times[NGC_OFFER], 3200000LL);

	graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 150\n"
			"ping_time_max 0.000000 150\n"
			"ping_time_avg 0.000000 150\n"
			"pings_ps_min 0 150\n"
			"pings_ps_max 0 150\n"
			"pings_ps_avg 0 150\n"
			"ping_count 0 150\n"
			"offer_time_min 2.500000 150\n"
			"offer_time_max 3.200000 150\n"
			"offer_time_avg 2.850000 150\n"
			"offers_ps_min 0 150\n"
			"offers_ps_max 0 150\n"
			"offers_ps_avg 0 150\n"
			"offer_count 2 150\n"
			"answer_time_min 0.000000 150\n"
			"answer_time_max 0.000000 150\n"
			"answer_time_avg 0.000000 150\n"
			"answers_ps_min 0 150\n"
			"answers_ps_max 0 150\n"
			"answers_ps_avg 0 150\n"
			"answer_count 0 150\n"
			"delete_time_min 0.000000 150\n"
			"delete_time_max 0.000000 150\n"
			"delete_time_avg 0.000000 150\n"
			"deletes_ps_min 0 150\n"
			"deletes_ps_max 0 150\n"
			"deletes_ps_avg 0 150\n"
			"delete_count 0 150\n"
			"query_time_min 0.000000 150\n"
			"query_time_max 0.000000 150\n"
			"query_time_avg 0.000000 150\n"
			"querys_ps_min 0 150\n"
			"querys_ps_max 0 150\n"
			"querys_ps_avg 0 150\n"
			"query_count 0 150\n"
			"list_time_min 0.000000 150\n"
			"list_time_max 0.000000 150\n"
			"list_time_avg 0.000000 150\n"
			"lists_ps_min 0 150\n"
			"lists_ps_max 0 150\n"
			"lists_ps_avg 0 150\n"
			"list_count 0 150\n"
			"start recording_time_min 0.000000 150\n"
			"start recording_time_max 0.000000 150\n"
			"start recording_time_avg 0.000000 150\n"
			"start recordings_ps_min 0 150\n"
			"start recordings_ps_max 0 150\n"
			"start recordings_ps_avg 0 150\n"
			"start recording_count 0 150\n"
			"stop recording_time_min 0.000000 150\n"
			"stop recording_time_max 0.000000 150\n"
			"stop recording_time_avg 0.000000 150\n"
			"stop recordings_ps_min 0 150\n"
			"stop recordings_ps_max 0 150\n"
			"stop recordings_ps_avg 0 150\n"
			"stop recording_count 0 150\n"
			"start forwarding_time_min 0.000000 150\n"
			"start forwarding_time_max 0.000000 150\n"
			"start forwarding_time_avg 0.000000 150\n"
			"start forwardings_ps_min 0 150\n"
			"start forwardings_ps_max 0 150\n"
			"start forwardings_ps_avg 0 150\n"
			"start forwarding_count 0 150\n"
			"stop forwarding_time_min 0.000000 150\n"
			"stop forwarding_time_max 0.000000 150\n"
			"stop forwarding_time_avg 0.000000 150\n"
			"stop forwardings_ps_min 0 150\n"
			"stop forwardings_ps_max 0 150\n"
			"stop forwardings_ps_avg 0 150\n"
			"stop forwarding_count 0 150\n"
			"block DTMF_time_min 0.000000 150\n"
			"block DTMF_time_max 0.000000 150\n"
			"block DTMF_time_avg 0.000000 150\n"
			"block DTMFs_ps_min 0 150\n"
			"block DTMFs_ps_max 0 150\n"
			"block DTMFs_ps_avg 0 150\n"
			"block DTMF_count 0 150\n"
			"unblock DTMF_time_min 0.000000 150\n"
			"unblock DTMF_time_max 0.000000 150\n"
			"unblock DTMF_time_avg 0.000000 150\n"
			"unblock DTMFs_ps_min 0 150\n"
			"unblock DTMFs_ps_max 0 150\n"
			"unblock DTMFs_ps_avg 0 150\n"
			"unblock DTMF_count 0 150\n"
			"block media_time_min 0.000000 150\n"
			"block media_time_max 0.000000 150\n"
			"block media_time_avg 0.000000 150\n"
			"block medias_ps_min 0 150\n"
			"block medias_ps_max 0 150\n"
			"block medias_ps_avg 0 150\n"
			"block media_count 0 150\n"
			"unblock media_time_min 0.000000 150\n"
			"unblock media_time_max 0.000000 150\n"
			"unblock media_time_avg 0.000000 150\n"
			"unblock medias_ps_min 0 150\n"
			"unblock medias_ps_max 0 150\n"
			"unblock medias_ps_avg 0 150\n"
			"unblock media_count 0 150\n"
			"play media_time_min 0.000000 150\n"
			"play media_time_max 0.000000 150\n"
			"play media_time_avg 0.000000 150\n"
			"play medias_ps_min 0 150\n"
			"play medias_ps_max 0 150\n"
			"play medias_ps_avg 0 150\n"
			"play media_count 0 150\n"
			"stop media_time_min 0.000000 150\n"
			"stop media_time_max 0.000000 150\n"
			"stop media_time_avg 0.000000 150\n"
			"stop medias_ps_min 0 150\n"
			"stop medias_ps_max 0 150\n"
			"stop medias_ps_avg 0 150\n"
			"stop media_count 0 150\n"
			"play DTMF_time_min 0.000000 150\n"
			"play DTMF_time_max 0.000000 150\n"
			"play DTMF_time_avg 0.000000 150\n"
			"play DTMFs_ps_min 0 150\n"
			"play DTMFs_ps_max 0 150\n"
			"play DTMFs_ps_avg 0 150\n"
			"play DTMF_count 0 150\n"
			"statistics_time_min 0.000000 150\n"
			"statistics_time_max 0.000000 150\n"
			"statistics_time_avg 0.000000 150\n"
			"statisticss_ps_min 0 150\n"
			"statisticss_ps_max 0 150\n"
			"statisticss_ps_avg 0 150\n"
			"statistics_count 0 150\n"
			"silence media_time_min 0.000000 150\n"
			"silence media_time_max 0.000000 150\n"
			"silence media_time_avg 0.000000 150\n"
			"silence medias_ps_min 0 150\n"
			"silence medias_ps_max 0 150\n"
			"silence medias_ps_avg 0 150\n"
			"silence media_count 0 150\n"
			"unsilence media_time_min 0.000000 150\n"
			"unsilence media_time_max 0.000000 150\n"
			"unsilence media_time_avg 0.000000 150\n"
			"unsilence medias_ps_min 0 150\n"
			"unsilence medias_ps_max 0 150\n"
			"unsilence medias_ps_avg 0 150\n"
			"unsilence media_count 0 150\n"
			"publish_time_min 0.000000 150\n"
			"publish_time_max 0.000000 150\n"
			"publish_time_avg 0.000000 150\n"
			"publishs_ps_min 0 150\n"
			"publishs_ps_max 0 150\n"
			"publishs_ps_avg 0 150\n"
			"publish_count 0 150\n"
			"subscribe request_time_min 0.000000 150\n"
			"subscribe request_time_max 0.000000 150\n"
			"subscribe request_time_avg 0.000000 150\n"
			"subscribe requests_ps_min 0 150\n"
			"subscribe requests_ps_max 0 150\n"
			"subscribe requests_ps_avg 0 150\n"
			"subscribe request_count 0 150\n"
			"subscribe answer_time_min 0.000000 150\n"
			"subscribe answer_time_max 0.000000 150\n"
			"subscribe answer_time_avg 0.000000 150\n"
			"subscribe answers_ps_min 0 150\n"
			"subscribe answers_ps_max 0 150\n"
			"subscribe answers_ps_avg 0 150\n"
			"subscribe answer_count 0 150\n"
			"unsubscribe_time_min 0.000000 150\n"
			"unsubscribe_time_max 0.000000 150\n"
			"unsubscribe_time_avg 0.000000 150\n"
			"unsubscribes_ps_min 0 150\n"
			"unsubscribes_ps_max 0 150\n"
			"unsubscribes_ps_avg 0 150\n"
			"unsubscribe_count 0 150\n"
			"call_dur 0.000000 150\n"
			"average_call_dur 0.000000 150\n"
			"forced_term_sess 0 150\n"
			"managed_sess 0 150\n"
			"managed_sess_min 0 150\n"
			"managed_sess_max 0 150\n"
			"current_sessions_total 0 150\n"
			"current_sessions_own 0 150\n"
			"current_sessions_foreign 0 150\n"
			"current_transcoded_media 0 150\n"
			"current_sessions_ipv4 0 150\n"
			"current_sessions_ipv6 0 150\n"
			"current_sessions_mixed 0 150\n"
			"nopacket_relayed_sess 0 150\n"
			"oneway_stream_sess 0 150\n"
			"regular_term_sess 0 150\n"
			"relayed_errors_user 0 150\n"
			"relayed_packets_user 0 150\n"
			"relayed_bytes_user 0 150\n"
			"relayed_errors_kernel 0 150\n"
			"relayed_packets_kernel 0 150\n"
			"relayed_bytes_kernel 0 150\n"
			"relayed_errors 0 150\n"
			"relayed_packets 0 150\n"
			"relayed_bytes 0 150\n"
			"silent_timeout_sess 0 150\n"
			"final_timeout_sess 0 150\n"
			"offer_timeout_sess 0 150\n"
			"timeout_sess 0 150\n"
			"reject_sess 0 150\n");

	stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"0\n"
			"0\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"0\n"
			"0\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"70 seconds\n"
			"70\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"0\n"
			"0\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"0.000000 seconds squared\n"
			"0.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"0\n"
			"0\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"0\n"
			"0\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"2.500000/3.200000/2.850000 sec\n"
			"minofferdelay\n"
			"2.500000\n"
			"maxofferdelay\n"
			"3.200000\n"
			"avgofferdelay\n"
			"2.850000\n"
			"Min/Max/Avg answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minanswerdelay\n"
			"0.000000\n"
			"maxanswerdelay\n"
			"0.000000\n"
			"avganswerdelay\n"
			"0.000000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"0/0/0 per sec\n"
			"minofferrequestrate\n"
			"0\n"
			"maxofferrequestrate\n"
			"0\n"
			"avgofferrequestrate\n"
			"0\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");

	RTPE_STATS_INC(ng_commands[NGC_ANSWER]);
	RTPE_GAUGE_SET(ng_command_times[NGC_ANSWER], 3200000LL);

	graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 150\n"
			"ping_time_max 0.000000 150\n"
			"ping_time_avg 0.000000 150\n"
			"pings_ps_min 0 150\n"
			"pings_ps_max 0 150\n"
			"pings_ps_avg 0 150\n"
			"ping_count 0 150\n"
			"offer_time_min 0.000000 150\n"
			"offer_time_max 0.000000 150\n"
			"offer_time_avg 0.000000 150\n"
			"offers_ps_min 0 150\n"
			"offers_ps_max 0 150\n"
			"offers_ps_avg 0 150\n"
			"offer_count 2 150\n"
			"answer_time_min 3.200000 150\n"
			"answer_time_max 3.200000 150\n"
			"answer_time_avg 3.200000 150\n"
			"answers_ps_min 0 150\n"
			"answers_ps_max 0 150\n"
			"answers_ps_avg 0 150\n"
			"answer_count 1 150\n"
			"delete_time_min 0.000000 150\n"
			"delete_time_max 0.000000 150\n"
			"delete_time_avg 0.000000 150\n"
			"deletes_ps_min 0 150\n"
			"deletes_ps_max 0 150\n"
			"deletes_ps_avg 0 150\n"
			"delete_count 0 150\n"
			"query_time_min 0.000000 150\n"
			"query_time_max 0.000000 150\n"
			"query_time_avg 0.000000 150\n"
			"querys_ps_min 0 150\n"
			"querys_ps_max 0 150\n"
			"querys_ps_avg 0 150\n"
			"query_count 0 150\n"
			"list_time_min 0.000000 150\n"
			"list_time_max 0.000000 150\n"
			"list_time_avg 0.000000 150\n"
			"lists_ps_min 0 150\n"
			"lists_ps_max 0 150\n"
			"lists_ps_avg 0 150\n"
			"list_count 0 150\n"
			"start recording_time_min 0.000000 150\n"
			"start recording_time_max 0.000000 150\n"
			"start recording_time_avg 0.000000 150\n"
			"start recordings_ps_min 0 150\n"
			"start recordings_ps_max 0 150\n"
			"start recordings_ps_avg 0 150\n"
			"start recording_count 0 150\n"
			"stop recording_time_min 0.000000 150\n"
			"stop recording_time_max 0.000000 150\n"
			"stop recording_time_avg 0.000000 150\n"
			"stop recordings_ps_min 0 150\n"
			"stop recordings_ps_max 0 150\n"
			"stop recordings_ps_avg 0 150\n"
			"stop recording_count 0 150\n"
			"start forwarding_time_min 0.000000 150\n"
			"start forwarding_time_max 0.000000 150\n"
			"start forwarding_time_avg 0.000000 150\n"
			"start forwardings_ps_min 0 150\n"
			"start forwardings_ps_max 0 150\n"
			"start forwardings_ps_avg 0 150\n"
			"start forwarding_count 0 150\n"
			"stop forwarding_time_min 0.000000 150\n"
			"stop forwarding_time_max 0.000000 150\n"
			"stop forwarding_time_avg 0.000000 150\n"
			"stop forwardings_ps_min 0 150\n"
			"stop forwardings_ps_max 0 150\n"
			"stop forwardings_ps_avg 0 150\n"
			"stop forwarding_count 0 150\n"
			"block DTMF_time_min 0.000000 150\n"
			"block DTMF_time_max 0.000000 150\n"
			"block DTMF_time_avg 0.000000 150\n"
			"block DTMFs_ps_min 0 150\n"
			"block DTMFs_ps_max 0 150\n"
			"block DTMFs_ps_avg 0 150\n"
			"block DTMF_count 0 150\n"
			"unblock DTMF_time_min 0.000000 150\n"
			"unblock DTMF_time_max 0.000000 150\n"
			"unblock DTMF_time_avg 0.000000 150\n"
			"unblock DTMFs_ps_min 0 150\n"
			"unblock DTMFs_ps_max 0 150\n"
			"unblock DTMFs_ps_avg 0 150\n"
			"unblock DTMF_count 0 150\n"
			"block media_time_min 0.000000 150\n"
			"block media_time_max 0.000000 150\n"
			"block media_time_avg 0.000000 150\n"
			"block medias_ps_min 0 150\n"
			"block medias_ps_max 0 150\n"
			"block medias_ps_avg 0 150\n"
			"block media_count 0 150\n"
			"unblock media_time_min 0.000000 150\n"
			"unblock media_time_max 0.000000 150\n"
			"unblock media_time_avg 0.000000 150\n"
			"unblock medias_ps_min 0 150\n"
			"unblock medias_ps_max 0 150\n"
			"unblock medias_ps_avg 0 150\n"
			"unblock media_count 0 150\n"
			"play media_time_min 0.000000 150\n"
			"play media_time_max 0.000000 150\n"
			"play media_time_avg 0.000000 150\n"
			"play medias_ps_min 0 150\n"
			"play medias_ps_max 0 150\n"
			"play medias_ps_avg 0 150\n"
			"play media_count 0 150\n"
			"stop media_time_min 0.000000 150\n"
			"stop media_time_max 0.000000 150\n"
			"stop media_time_avg 0.000000 150\n"
			"stop medias_ps_min 0 150\n"
			"stop medias_ps_max 0 150\n"
			"stop medias_ps_avg 0 150\n"
			"stop media_count 0 150\n"
			"play DTMF_time_min 0.000000 150\n"
			"play DTMF_time_max 0.000000 150\n"
			"play DTMF_time_avg 0.000000 150\n"
			"play DTMFs_ps_min 0 150\n"
			"play DTMFs_ps_max 0 150\n"
			"play DTMFs_ps_avg 0 150\n"
			"play DTMF_count 0 150\n"
			"statistics_time_min 0.000000 150\n"
			"statistics_time_max 0.000000 150\n"
			"statistics_time_avg 0.000000 150\n"
			"statisticss_ps_min 0 150\n"
			"statisticss_ps_max 0 150\n"
			"statisticss_ps_avg 0 150\n"
			"statistics_count 0 150\n"
			"silence media_time_min 0.000000 150\n"
			"silence media_time_max 0.000000 150\n"
			"silence media_time_avg 0.000000 150\n"
			"silence medias_ps_min 0 150\n"
			"silence medias_ps_max 0 150\n"
			"silence medias_ps_avg 0 150\n"
			"silence media_count 0 150\n"
			"unsilence media_time_min 0.000000 150\n"
			"unsilence media_time_max 0.000000 150\n"
			"unsilence media_time_avg 0.000000 150\n"
			"unsilence medias_ps_min 0 150\n"
			"unsilence medias_ps_max 0 150\n"
			"unsilence medias_ps_avg 0 150\n"
			"unsilence media_count 0 150\n"
			"publish_time_min 0.000000 150\n"
			"publish_time_max 0.000000 150\n"
			"publish_time_avg 0.000000 150\n"
			"publishs_ps_min 0 150\n"
			"publishs_ps_max 0 150\n"
			"publishs_ps_avg 0 150\n"
			"publish_count 0 150\n"
			"subscribe request_time_min 0.000000 150\n"
			"subscribe request_time_max 0.000000 150\n"
			"subscribe request_time_avg 0.000000 150\n"
			"subscribe requests_ps_min 0 150\n"
			"subscribe requests_ps_max 0 150\n"
			"subscribe requests_ps_avg 0 150\n"
			"subscribe request_count 0 150\n"
			"subscribe answer_time_min 0.000000 150\n"
			"subscribe answer_time_max 0.000000 150\n"
			"subscribe answer_time_avg 0.000000 150\n"
			"subscribe answers_ps_min 0 150\n"
			"subscribe answers_ps_max 0 150\n"
			"subscribe answers_ps_avg 0 150\n"
			"subscribe answer_count 0 150\n"
			"unsubscribe_time_min 0.000000 150\n"
			"unsubscribe_time_max 0.000000 150\n"
			"unsubscribe_time_avg 0.000000 150\n"
			"unsubscribes_ps_min 0 150\n"
			"unsubscribes_ps_max 0 150\n"
			"unsubscribes_ps_avg 0 150\n"
			"unsubscribe_count 0 150\n"
			"call_dur 0.000000 150\n"
			"average_call_dur 0.000000 150\n"
			"forced_term_sess 0 150\n"
			"managed_sess 0 150\n"
			"managed_sess_min 0 150\n"
			"managed_sess_max 0 150\n"
			"current_sessions_total 0 150\n"
			"current_sessions_own 0 150\n"
			"current_sessions_foreign 0 150\n"
			"current_transcoded_media 0 150\n"
			"current_sessions_ipv4 0 150\n"
			"current_sessions_ipv6 0 150\n"
			"current_sessions_mixed 0 150\n"
			"nopacket_relayed_sess 0 150\n"
			"oneway_stream_sess 0 150\n"
			"regular_term_sess 0 150\n"
			"relayed_errors_user 0 150\n"
			"relayed_packets_user 0 150\n"
			"relayed_bytes_user 0 150\n"
			"relayed_errors_kernel 0 150\n"
			"relayed_packets_kernel 0 150\n"
			"relayed_bytes_kernel 0 150\n"
			"relayed_errors 0 150\n"
			"relayed_packets 0 150\n"
			"relayed_bytes 0 150\n"
			"silent_timeout_sess 0 150\n"
			"final_timeout_sess 0 150\n"
			"offer_timeout_sess 0 150\n"
			"timeout_sess 0 150\n"
			"reject_sess 0 150\n");

	stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"0\n"
			"0\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"0\n"
			"0\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"70 seconds\n"
			"70\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"0\n"
			"0\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"0.000000 seconds squared\n"
			"0.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"0\n"
			"0\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"0\n"
			"0\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minofferdelay\n"
			"0.000000\n"
			"maxofferdelay\n"
			"0.000000\n"
			"avgofferdelay\n"
			"0.000000\n"
			"Min/Max/Avg answer processing delay\n"
			"3.200000/3.200000/3.200000 sec\n"
			"minanswerdelay\n"
			"3.200000\n"
			"maxanswerdelay\n"
			"3.200000\n"
			"avganswerdelay\n"
			"3.200000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"0/0/0 per sec\n"
			"minofferrequestrate\n"
			"0\n"
			"maxofferrequestrate\n"
			"0\n"
			"avgofferrequestrate\n"
			"0\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");

	// test cmd_ps_min/max/avg

	call_timer(NULL);
	RTPE_STATS_ADD(ng_commands[NGC_OFFER], 100);

	rtpe_now.tv_sec += 2;

	RTPE_STATS_ADD(ng_commands[NGC_OFFER], 20);
	call_timer(NULL);

	// timer run time interval increased
	rtpe_now.tv_sec += 5;

	RTPE_STATS_ADD(ng_commands[NGC_OFFER], 200);
	call_timer(NULL);

	graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 157\n"
			"ping_time_max 0.000000 157\n"
			"ping_time_avg 0.000000 157\n"
			"pings_ps_min 0 157\n"
			"pings_ps_max 0 157\n"
			"pings_ps_avg 0 157\n"
			"ping_count 0 157\n"
			"offer_time_min 0.000000 157\n"
			"offer_time_max 0.000000 157\n"
			"offer_time_avg 0.000000 157\n"
			"offers_ps_min 40 157\n"
			"offers_ps_max 60 157\n"
			"offers_ps_avg 33 157\n"
			"offer_count 322 157\n"
			"answer_time_min 0.000000 157\n"
			"answer_time_max 0.000000 157\n"
			"answer_time_avg 0.000000 157\n"
			"answers_ps_min 0 157\n"
			"answers_ps_max 0 157\n"
			"answers_ps_avg 0 157\n"
			"answer_count 1 157\n"
			"delete_time_min 0.000000 157\n"
			"delete_time_max 0.000000 157\n"
			"delete_time_avg 0.000000 157\n"
			"deletes_ps_min 0 157\n"
			"deletes_ps_max 0 157\n"
			"deletes_ps_avg 0 157\n"
			"delete_count 0 157\n"
			"query_time_min 0.000000 157\n"
			"query_time_max 0.000000 157\n"
			"query_time_avg 0.000000 157\n"
			"querys_ps_min 0 157\n"
			"querys_ps_max 0 157\n"
			"querys_ps_avg 0 157\n"
			"query_count 0 157\n"
			"list_time_min 0.000000 157\n"
			"list_time_max 0.000000 157\n"
			"list_time_avg 0.000000 157\n"
			"lists_ps_min 0 157\n"
			"lists_ps_max 0 157\n"
			"lists_ps_avg 0 157\n"
			"list_count 0 157\n"
			"start recording_time_min 0.000000 157\n"
			"start recording_time_max 0.000000 157\n"
			"start recording_time_avg 0.000000 157\n"
			"start recordings_ps_min 0 157\n"
			"start recordings_ps_max 0 157\n"
			"start recordings_ps_avg 0 157\n"
			"start recording_count 0 157\n"
			"stop recording_time_min 0.000000 157\n"
			"stop recording_time_max 0.000000 157\n"
			"stop recording_time_avg 0.000000 157\n"
			"stop recordings_ps_min 0 157\n"
			"stop recordings_ps_max 0 157\n"
			"stop recordings_ps_avg 0 157\n"
			"stop recording_count 0 157\n"
			"start forwarding_time_min 0.000000 157\n"
			"start forwarding_time_max 0.000000 157\n"
			"start forwarding_time_avg 0.000000 157\n"
			"start forwardings_ps_min 0 157\n"
			"start forwardings_ps_max 0 157\n"
			"start forwardings_ps_avg 0 157\n"
			"start forwarding_count 0 157\n"
			"stop forwarding_time_min 0.000000 157\n"
			"stop forwarding_time_max 0.000000 157\n"
			"stop forwarding_time_avg 0.000000 157\n"
			"stop forwardings_ps_min 0 157\n"
			"stop forwardings_ps_max 0 157\n"
			"stop forwardings_ps_avg 0 157\n"
			"stop forwarding_count 0 157\n"
			"block DTMF_time_min 0.000000 157\n"
			"block DTMF_time_max 0.000000 157\n"
			"block DTMF_time_avg 0.000000 157\n"
			"block DTMFs_ps_min 0 157\n"
			"block DTMFs_ps_max 0 157\n"
			"block DTMFs_ps_avg 0 157\n"
			"block DTMF_count 0 157\n"
			"unblock DTMF_time_min 0.000000 157\n"
			"unblock DTMF_time_max 0.000000 157\n"
			"unblock DTMF_time_avg 0.000000 157\n"
			"unblock DTMFs_ps_min 0 157\n"
			"unblock DTMFs_ps_max 0 157\n"
			"unblock DTMFs_ps_avg 0 157\n"
			"unblock DTMF_count 0 157\n"
			"block media_time_min 0.000000 157\n"
			"block media_time_max 0.000000 157\n"
			"block media_time_avg 0.000000 157\n"
			"block medias_ps_min 0 157\n"
			"block medias_ps_max 0 157\n"
			"block medias_ps_avg 0 157\n"
			"block media_count 0 157\n"
			"unblock media_time_min 0.000000 157\n"
			"unblock media_time_max 0.000000 157\n"
			"unblock media_time_avg 0.000000 157\n"
			"unblock medias_ps_min 0 157\n"
			"unblock medias_ps_max 0 157\n"
			"unblock medias_ps_avg 0 157\n"
			"unblock media_count 0 157\n"
			"play media_time_min 0.000000 157\n"
			"play media_time_max 0.000000 157\n"
			"play media_time_avg 0.000000 157\n"
			"play medias_ps_min 0 157\n"
			"play medias_ps_max 0 157\n"
			"play medias_ps_avg 0 157\n"
			"play media_count 0 157\n"
			"stop media_time_min 0.000000 157\n"
			"stop media_time_max 0.000000 157\n"
			"stop media_time_avg 0.000000 157\n"
			"stop medias_ps_min 0 157\n"
			"stop medias_ps_max 0 157\n"
			"stop medias_ps_avg 0 157\n"
			"stop media_count 0 157\n"
			"play DTMF_time_min 0.000000 157\n"
			"play DTMF_time_max 0.000000 157\n"
			"play DTMF_time_avg 0.000000 157\n"
			"play DTMFs_ps_min 0 157\n"
			"play DTMFs_ps_max 0 157\n"
			"play DTMFs_ps_avg 0 157\n"
			"play DTMF_count 0 157\n"
			"statistics_time_min 0.000000 157\n"
			"statistics_time_max 0.000000 157\n"
			"statistics_time_avg 0.000000 157\n"
			"statisticss_ps_min 0 157\n"
			"statisticss_ps_max 0 157\n"
			"statisticss_ps_avg 0 157\n"
			"statistics_count 0 157\n"
			"silence media_time_min 0.000000 157\n"
			"silence media_time_max 0.000000 157\n"
			"silence media_time_avg 0.000000 157\n"
			"silence medias_ps_min 0 157\n"
			"silence medias_ps_max 0 157\n"
			"silence medias_ps_avg 0 157\n"
			"silence media_count 0 157\n"
			"unsilence media_time_min 0.000000 157\n"
			"unsilence media_time_max 0.000000 157\n"
			"unsilence media_time_avg 0.000000 157\n"
			"unsilence medias_ps_min 0 157\n"
			"unsilence medias_ps_max 0 157\n"
			"unsilence medias_ps_avg 0 157\n"
			"unsilence media_count 0 157\n"
			"publish_time_min 0.000000 157\n"
			"publish_time_max 0.000000 157\n"
			"publish_time_avg 0.000000 157\n"
			"publishs_ps_min 0 157\n"
			"publishs_ps_max 0 157\n"
			"publishs_ps_avg 0 157\n"
			"publish_count 0 157\n"
			"subscribe request_time_min 0.000000 157\n"
			"subscribe request_time_max 0.000000 157\n"
			"subscribe request_time_avg 0.000000 157\n"
			"subscribe requests_ps_min 0 157\n"
			"subscribe requests_ps_max 0 157\n"
			"subscribe requests_ps_avg 0 157\n"
			"subscribe request_count 0 157\n"
			"subscribe answer_time_min 0.000000 157\n"
			"subscribe answer_time_max 0.000000 157\n"
			"subscribe answer_time_avg 0.000000 157\n"
			"subscribe answers_ps_min 0 157\n"
			"subscribe answers_ps_max 0 157\n"
			"subscribe answers_ps_avg 0 157\n"
			"subscribe answer_count 0 157\n"
			"unsubscribe_time_min 0.000000 157\n"
			"unsubscribe_time_max 0.000000 157\n"
			"unsubscribe_time_avg 0.000000 157\n"
			"unsubscribes_ps_min 0 157\n"
			"unsubscribes_ps_max 0 157\n"
			"unsubscribes_ps_avg 0 157\n"
			"unsubscribe_count 0 157\n"
			"call_dur 0.000000 157\n"
			"average_call_dur 0.000000 157\n"
			"forced_term_sess 0 157\n"
			"managed_sess 0 157\n"
			"managed_sess_min 0 157\n"
			"managed_sess_max 0 157\n"
			"current_sessions_total 0 157\n"
			"current_sessions_own 0 157\n"
			"current_sessions_foreign 0 157\n"
			"current_transcoded_media 0 157\n"
			"current_sessions_ipv4 0 157\n"
			"current_sessions_ipv6 0 157\n"
			"current_sessions_mixed 0 157\n"
			"nopacket_relayed_sess 0 157\n"
			"oneway_stream_sess 0 157\n"
			"regular_term_sess 0 157\n"
			"relayed_errors_user 0 157\n"
			"relayed_packets_user 0 157\n"
			"relayed_bytes_user 0 157\n"
			"relayed_errors_kernel 0 157\n"
			"relayed_packets_kernel 0 157\n"
			"relayed_bytes_kernel 0 157\n"
			"relayed_errors 0 157\n"
			"relayed_packets 0 157\n"
			"relayed_bytes 0 157\n"
			"silent_timeout_sess 0 157\n"
			"final_timeout_sess 0 157\n"
			"offer_timeout_sess 0 157\n"
			"timeout_sess 0 157\n"
			"reject_sess 0 157\n");

	stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"0\n"
			"0\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"0\n"
			"0\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"77 seconds\n"
			"77\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"0\n"
			"0\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"0.000000 seconds squared\n"
			"0.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"0\n"
			"0\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"0\n"
			"0\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minofferdelay\n"
			"0.000000\n"
			"maxofferdelay\n"
			"0.000000\n"
			"avgofferdelay\n"
			"0.000000\n"
			"Min/Max/Avg answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minanswerdelay\n"
			"0.000000\n"
			"maxanswerdelay\n"
			"0.000000\n"
			"avganswerdelay\n"
			"0.000000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"40/60/33 per sec\n"
			"minofferrequestrate\n"
			"40\n"
			"maxofferrequestrate\n"
			"60\n"
			"avgofferrequestrate\n"
			"33\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");

	// test average call duration

	const str callid1 = STR_CONST_INIT("test1");
	const str callid2 = STR_CONST_INIT("test2");
	struct call *call1 = call_get_or_create(&callid1, false, true);
	struct call_monologue *ml1 = call_get_or_create_monologue(call1, &callid1);
	struct call *call2 = call_get_or_create(&callid2, false, true);
	struct call_monologue *ml2 = call_get_or_create_monologue(call2, &callid2);
	call1->created = ml1->started = (struct timeval) {157,0};
	call2->created = ml2->started = (struct timeval) {57,0};

	graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 157\n"
			"ping_time_max 0.000000 157\n"
			"ping_time_avg 0.000000 157\n"
			"pings_ps_min 0 157\n"
			"pings_ps_max 0 157\n"
			"pings_ps_avg 0 157\n"
			"ping_count 0 157\n"
			"offer_time_min 0.000000 157\n"
			"offer_time_max 0.000000 157\n"
			"offer_time_avg 0.000000 157\n"
			"offers_ps_min 0 157\n"
			"offers_ps_max 0 157\n"
			"offers_ps_avg 0 157\n"
			"offer_count 322 157\n"
			"answer_time_min 0.000000 157\n"
			"answer_time_max 0.000000 157\n"
			"answer_time_avg 0.000000 157\n"
			"answers_ps_min 0 157\n"
			"answers_ps_max 0 157\n"
			"answers_ps_avg 0 157\n"
			"answer_count 1 157\n"
			"delete_time_min 0.000000 157\n"
			"delete_time_max 0.000000 157\n"
			"delete_time_avg 0.000000 157\n"
			"deletes_ps_min 0 157\n"
			"deletes_ps_max 0 157\n"
			"deletes_ps_avg 0 157\n"
			"delete_count 0 157\n"
			"query_time_min 0.000000 157\n"
			"query_time_max 0.000000 157\n"
			"query_time_avg 0.000000 157\n"
			"querys_ps_min 0 157\n"
			"querys_ps_max 0 157\n"
			"querys_ps_avg 0 157\n"
			"query_count 0 157\n"
			"list_time_min 0.000000 157\n"
			"list_time_max 0.000000 157\n"
			"list_time_avg 0.000000 157\n"
			"lists_ps_min 0 157\n"
			"lists_ps_max 0 157\n"
			"lists_ps_avg 0 157\n"
			"list_count 0 157\n"
			"start recording_time_min 0.000000 157\n"
			"start recording_time_max 0.000000 157\n"
			"start recording_time_avg 0.000000 157\n"
			"start recordings_ps_min 0 157\n"
			"start recordings_ps_max 0 157\n"
			"start recordings_ps_avg 0 157\n"
			"start recording_count 0 157\n"
			"stop recording_time_min 0.000000 157\n"
			"stop recording_time_max 0.000000 157\n"
			"stop recording_time_avg 0.000000 157\n"
			"stop recordings_ps_min 0 157\n"
			"stop recordings_ps_max 0 157\n"
			"stop recordings_ps_avg 0 157\n"
			"stop recording_count 0 157\n"
			"start forwarding_time_min 0.000000 157\n"
			"start forwarding_time_max 0.000000 157\n"
			"start forwarding_time_avg 0.000000 157\n"
			"start forwardings_ps_min 0 157\n"
			"start forwardings_ps_max 0 157\n"
			"start forwardings_ps_avg 0 157\n"
			"start forwarding_count 0 157\n"
			"stop forwarding_time_min 0.000000 157\n"
			"stop forwarding_time_max 0.000000 157\n"
			"stop forwarding_time_avg 0.000000 157\n"
			"stop forwardings_ps_min 0 157\n"
			"stop forwardings_ps_max 0 157\n"
			"stop forwardings_ps_avg 0 157\n"
			"stop forwarding_count 0 157\n"
			"block DTMF_time_min 0.000000 157\n"
			"block DTMF_time_max 0.000000 157\n"
			"block DTMF_time_avg 0.000000 157\n"
			"block DTMFs_ps_min 0 157\n"
			"block DTMFs_ps_max 0 157\n"
			"block DTMFs_ps_avg 0 157\n"
			"block DTMF_count 0 157\n"
			"unblock DTMF_time_min 0.000000 157\n"
			"unblock DTMF_time_max 0.000000 157\n"
			"unblock DTMF_time_avg 0.000000 157\n"
			"unblock DTMFs_ps_min 0 157\n"
			"unblock DTMFs_ps_max 0 157\n"
			"unblock DTMFs_ps_avg 0 157\n"
			"unblock DTMF_count 0 157\n"
			"block media_time_min 0.000000 157\n"
			"block media_time_max 0.000000 157\n"
			"block media_time_avg 0.000000 157\n"
			"block medias_ps_min 0 157\n"
			"block medias_ps_max 0 157\n"
			"block medias_ps_avg 0 157\n"
			"block media_count 0 157\n"
			"unblock media_time_min 0.000000 157\n"
			"unblock media_time_max 0.000000 157\n"
			"unblock media_time_avg 0.000000 157\n"
			"unblock medias_ps_min 0 157\n"
			"unblock medias_ps_max 0 157\n"
			"unblock medias_ps_avg 0 157\n"
			"unblock media_count 0 157\n"
			"play media_time_min 0.000000 157\n"
			"play media_time_max 0.000000 157\n"
			"play media_time_avg 0.000000 157\n"
			"play medias_ps_min 0 157\n"
			"play medias_ps_max 0 157\n"
			"play medias_ps_avg 0 157\n"
			"play media_count 0 157\n"
			"stop media_time_min 0.000000 157\n"
			"stop media_time_max 0.000000 157\n"
			"stop media_time_avg 0.000000 157\n"
			"stop medias_ps_min 0 157\n"
			"stop medias_ps_max 0 157\n"
			"stop medias_ps_avg 0 157\n"
			"stop media_count 0 157\n"
			"play DTMF_time_min 0.000000 157\n"
			"play DTMF_time_max 0.000000 157\n"
			"play DTMF_time_avg 0.000000 157\n"
			"play DTMFs_ps_min 0 157\n"
			"play DTMFs_ps_max 0 157\n"
			"play DTMFs_ps_avg 0 157\n"
			"play DTMF_count 0 157\n"
			"statistics_time_min 0.000000 157\n"
			"statistics_time_max 0.000000 157\n"
			"statistics_time_avg 0.000000 157\n"
			"statisticss_ps_min 0 157\n"
			"statisticss_ps_max 0 157\n"
			"statisticss_ps_avg 0 157\n"
			"statistics_count 0 157\n"
			"silence media_time_min 0.000000 157\n"
			"silence media_time_max 0.000000 157\n"
			"silence media_time_avg 0.000000 157\n"
			"silence medias_ps_min 0 157\n"
			"silence medias_ps_max 0 157\n"
			"silence medias_ps_avg 0 157\n"
			"silence media_count 0 157\n"
			"unsilence media_time_min 0.000000 157\n"
			"unsilence media_time_max 0.000000 157\n"
			"unsilence media_time_avg 0.000000 157\n"
			"unsilence medias_ps_min 0 157\n"
			"unsilence medias_ps_max 0 157\n"
			"unsilence medias_ps_avg 0 157\n"
			"unsilence media_count 0 157\n"
			"publish_time_min 0.000000 157\n"
			"publish_time_max 0.000000 157\n"
			"publish_time_avg 0.000000 157\n"
			"publishs_ps_min 0 157\n"
			"publishs_ps_max 0 157\n"
			"publishs_ps_avg 0 157\n"
			"publish_count 0 157\n"
			"subscribe request_time_min 0.000000 157\n"
			"subscribe request_time_max 0.000000 157\n"
			"subscribe request_time_avg 0.000000 157\n"
			"subscribe requests_ps_min 0 157\n"
			"subscribe requests_ps_max 0 157\n"
			"subscribe requests_ps_avg 0 157\n"
			"subscribe request_count 0 157\n"
			"subscribe answer_time_min 0.000000 157\n"
			"subscribe answer_time_max 0.000000 157\n"
			"subscribe answer_time_avg 0.000000 157\n"
			"subscribe answers_ps_min 0 157\n"
			"subscribe answers_ps_max 0 157\n"
			"subscribe answers_ps_avg 0 157\n"
			"subscribe answer_count 0 157\n"
			"unsubscribe_time_min 0.000000 157\n"
			"unsubscribe_time_max 0.000000 157\n"
			"unsubscribe_time_avg 0.000000 157\n"
			"unsubscribes_ps_min 0 157\n"
			"unsubscribes_ps_max 0 157\n"
			"unsubscribes_ps_avg 0 157\n"
			"unsubscribe_count 0 157\n"
			"call_dur 0.000000 157\n"
			"average_call_dur 0.000000 157\n"
			"forced_term_sess 0 157\n"
			"managed_sess 0 157\n"
			"managed_sess_min 1 157\n"
			"managed_sess_max 2 157\n"
			"current_sessions_total 2 157\n"
			"current_sessions_own 2 157\n"
			"current_sessions_foreign 0 157\n"
			"current_transcoded_media 0 157\n"
			"current_sessions_ipv4 0 157\n"
			"current_sessions_ipv6 0 157\n"
			"current_sessions_mixed 0 157\n"
			"nopacket_relayed_sess 0 157\n"
			"oneway_stream_sess 0 157\n"
			"regular_term_sess 0 157\n"
			"relayed_errors_user 0 157\n"
			"relayed_packets_user 0 157\n"
			"relayed_bytes_user 0 157\n"
			"relayed_errors_kernel 0 157\n"
			"relayed_packets_kernel 0 157\n"
			"relayed_bytes_kernel 0 157\n"
			"relayed_errors 0 157\n"
			"relayed_packets 0 157\n"
			"relayed_bytes 0 157\n"
			"silent_timeout_sess 0 157\n"
			"final_timeout_sess 0 157\n"
			"offer_timeout_sess 0 157\n"
			"timeout_sess 0 157\n"
			"reject_sess 0 157\n");

	stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"2\n"
			"2\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"2\n"
			"2\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"77 seconds\n"
			"77\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"0\n"
			"0\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"0.000000 seconds squared\n"
			"0.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"1\n"
			"1\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"2\n"
			"2\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minofferdelay\n"
			"0.000000\n"
			"maxofferdelay\n"
			"0.000000\n"
			"avgofferdelay\n"
			"0.000000\n"
			"Min/Max/Avg answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minanswerdelay\n"
			"0.000000\n"
			"maxanswerdelay\n"
			"0.000000\n"
			"avganswerdelay\n"
			"0.000000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"0/0/0 per sec\n"
			"minofferrequestrate\n"
			"0\n"
			"maxofferrequestrate\n"
			"0\n"
			"avgofferrequestrate\n"
			"0\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");


	struct timeval graphite_interval_tv = {100,0};
	rtpe_now = (struct timeval) {200,0};

	add_total_calls_duration_in_interval(&graphite_interval_tv);

	graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 200\n"
			"ping_time_max 0.000000 200\n"
			"ping_time_avg 0.000000 200\n"
			"pings_ps_min 0 200\n"
			"pings_ps_max 0 200\n"
			"pings_ps_avg 0 200\n"
			"ping_count 0 200\n"
			"offer_time_min 0.000000 200\n"
			"offer_time_max 0.000000 200\n"
			"offer_time_avg 0.000000 200\n"
			"offers_ps_min 0 200\n"
			"offers_ps_max 0 200\n"
			"offers_ps_avg 0 200\n"
			"offer_count 322 200\n"
			"answer_time_min 0.000000 200\n"
			"answer_time_max 0.000000 200\n"
			"answer_time_avg 0.000000 200\n"
			"answers_ps_min 0 200\n"
			"answers_ps_max 0 200\n"
			"answers_ps_avg 0 200\n"
			"answer_count 1 200\n"
			"delete_time_min 0.000000 200\n"
			"delete_time_max 0.000000 200\n"
			"delete_time_avg 0.000000 200\n"
			"deletes_ps_min 0 200\n"
			"deletes_ps_max 0 200\n"
			"deletes_ps_avg 0 200\n"
			"delete_count 0 200\n"
			"query_time_min 0.000000 200\n"
			"query_time_max 0.000000 200\n"
			"query_time_avg 0.000000 200\n"
			"querys_ps_min 0 200\n"
			"querys_ps_max 0 200\n"
			"querys_ps_avg 0 200\n"
			"query_count 0 200\n"
			"list_time_min 0.000000 200\n"
			"list_time_max 0.000000 200\n"
			"list_time_avg 0.000000 200\n"
			"lists_ps_min 0 200\n"
			"lists_ps_max 0 200\n"
			"lists_ps_avg 0 200\n"
			"list_count 0 200\n"
			"start recording_time_min 0.000000 200\n"
			"start recording_time_max 0.000000 200\n"
			"start recording_time_avg 0.000000 200\n"
			"start recordings_ps_min 0 200\n"
			"start recordings_ps_max 0 200\n"
			"start recordings_ps_avg 0 200\n"
			"start recording_count 0 200\n"
			"stop recording_time_min 0.000000 200\n"
			"stop recording_time_max 0.000000 200\n"
			"stop recording_time_avg 0.000000 200\n"
			"stop recordings_ps_min 0 200\n"
			"stop recordings_ps_max 0 200\n"
			"stop recordings_ps_avg 0 200\n"
			"stop recording_count 0 200\n"
			"start forwarding_time_min 0.000000 200\n"
			"start forwarding_time_max 0.000000 200\n"
			"start forwarding_time_avg 0.000000 200\n"
			"start forwardings_ps_min 0 200\n"
			"start forwardings_ps_max 0 200\n"
			"start forwardings_ps_avg 0 200\n"
			"start forwarding_count 0 200\n"
			"stop forwarding_time_min 0.000000 200\n"
			"stop forwarding_time_max 0.000000 200\n"
			"stop forwarding_time_avg 0.000000 200\n"
			"stop forwardings_ps_min 0 200\n"
			"stop forwardings_ps_max 0 200\n"
			"stop forwardings_ps_avg 0 200\n"
			"stop forwarding_count 0 200\n"
			"block DTMF_time_min 0.000000 200\n"
			"block DTMF_time_max 0.000000 200\n"
			"block DTMF_time_avg 0.000000 200\n"
			"block DTMFs_ps_min 0 200\n"
			"block DTMFs_ps_max 0 200\n"
			"block DTMFs_ps_avg 0 200\n"
			"block DTMF_count 0 200\n"
			"unblock DTMF_time_min 0.000000 200\n"
			"unblock DTMF_time_max 0.000000 200\n"
			"unblock DTMF_time_avg 0.000000 200\n"
			"unblock DTMFs_ps_min 0 200\n"
			"unblock DTMFs_ps_max 0 200\n"
			"unblock DTMFs_ps_avg 0 200\n"
			"unblock DTMF_count 0 200\n"
			"block media_time_min 0.000000 200\n"
			"block media_time_max 0.000000 200\n"
			"block media_time_avg 0.000000 200\n"
			"block medias_ps_min 0 200\n"
			"block medias_ps_max 0 200\n"
			"block medias_ps_avg 0 200\n"
			"block media_count 0 200\n"
			"unblock media_time_min 0.000000 200\n"
			"unblock media_time_max 0.000000 200\n"
			"unblock media_time_avg 0.000000 200\n"
			"unblock medias_ps_min 0 200\n"
			"unblock medias_ps_max 0 200\n"
			"unblock medias_ps_avg 0 200\n"
			"unblock media_count 0 200\n"
			"play media_time_min 0.000000 200\n"
			"play media_time_max 0.000000 200\n"
			"play media_time_avg 0.000000 200\n"
			"play medias_ps_min 0 200\n"
			"play medias_ps_max 0 200\n"
			"play medias_ps_avg 0 200\n"
			"play media_count 0 200\n"
			"stop media_time_min 0.000000 200\n"
			"stop media_time_max 0.000000 200\n"
			"stop media_time_avg 0.000000 200\n"
			"stop medias_ps_min 0 200\n"
			"stop medias_ps_max 0 200\n"
			"stop medias_ps_avg 0 200\n"
			"stop media_count 0 200\n"
			"play DTMF_time_min 0.000000 200\n"
			"play DTMF_time_max 0.000000 200\n"
			"play DTMF_time_avg 0.000000 200\n"
			"play DTMFs_ps_min 0 200\n"
			"play DTMFs_ps_max 0 200\n"
			"play DTMFs_ps_avg 0 200\n"
			"play DTMF_count 0 200\n"
			"statistics_time_min 0.000000 200\n"
			"statistics_time_max 0.000000 200\n"
			"statistics_time_avg 0.000000 200\n"
			"statisticss_ps_min 0 200\n"
			"statisticss_ps_max 0 200\n"
			"statisticss_ps_avg 0 200\n"
			"statistics_count 0 200\n"
			"silence media_time_min 0.000000 200\n"
			"silence media_time_max 0.000000 200\n"
			"silence media_time_avg 0.000000 200\n"
			"silence medias_ps_min 0 200\n"
			"silence medias_ps_max 0 200\n"
			"silence medias_ps_avg 0 200\n"
			"silence media_count 0 200\n"
			"unsilence media_time_min 0.000000 200\n"
			"unsilence media_time_max 0.000000 200\n"
			"unsilence media_time_avg 0.000000 200\n"
			"unsilence medias_ps_min 0 200\n"
			"unsilence medias_ps_max 0 200\n"
			"unsilence medias_ps_avg 0 200\n"
			"unsilence media_count 0 200\n"
			"publish_time_min 0.000000 200\n"
			"publish_time_max 0.000000 200\n"
			"publish_time_avg 0.000000 200\n"
			"publishs_ps_min 0 200\n"
			"publishs_ps_max 0 200\n"
			"publishs_ps_avg 0 200\n"
			"publish_count 0 200\n"
			"subscribe request_time_min 0.000000 200\n"
			"subscribe request_time_max 0.000000 200\n"
			"subscribe request_time_avg 0.000000 200\n"
			"subscribe requests_ps_min 0 200\n"
			"subscribe requests_ps_max 0 200\n"
			"subscribe requests_ps_avg 0 200\n"
			"subscribe request_count 0 200\n"
			"subscribe answer_time_min 0.000000 200\n"
			"subscribe answer_time_max 0.000000 200\n"
			"subscribe answer_time_avg 0.000000 200\n"
			"subscribe answers_ps_min 0 200\n"
			"subscribe answers_ps_max 0 200\n"
			"subscribe answers_ps_avg 0 200\n"
			"subscribe answer_count 0 200\n"
			"unsubscribe_time_min 0.000000 200\n"
			"unsubscribe_time_max 0.000000 200\n"
			"unsubscribe_time_avg 0.000000 200\n"
			"unsubscribes_ps_min 0 200\n"
			"unsubscribes_ps_max 0 200\n"
			"unsubscribes_ps_avg 0 200\n"
			"unsubscribe_count 0 200\n"
			"call_dur 186.000000 200\n"
			"average_call_dur 0.000000 200\n"
			"forced_term_sess 0 200\n"
			"managed_sess 0 200\n"
			"managed_sess_min 2 200\n"
			"managed_sess_max 2 200\n"
			"current_sessions_total 2 200\n"
			"current_sessions_own 2 200\n"
			"current_sessions_foreign 0 200\n"
			"current_transcoded_media 0 200\n"
			"current_sessions_ipv4 0 200\n"
			"current_sessions_ipv6 0 200\n"
			"current_sessions_mixed 0 200\n"
			"nopacket_relayed_sess 0 200\n"
			"oneway_stream_sess 0 200\n"
			"regular_term_sess 0 200\n"
			"relayed_errors_user 0 200\n"
			"relayed_packets_user 0 200\n"
			"relayed_bytes_user 0 200\n"
			"relayed_errors_kernel 0 200\n"
			"relayed_packets_kernel 0 200\n"
			"relayed_bytes_kernel 0 200\n"
			"relayed_errors 0 200\n"
			"relayed_packets 0 200\n"
			"relayed_bytes 0 200\n"
			"silent_timeout_sess 0 200\n"
			"final_timeout_sess 0 200\n"
			"offer_timeout_sess 0 200\n"
			"timeout_sess 0 200\n"
			"reject_sess 0 200\n");

	stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"2\n"
			"2\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"2\n"
			"2\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"120 seconds\n"
			"120\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"0\n"
			"0\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"0.000000 seconds squared\n"
			"0.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"186.000000 seconds\n"
			"186.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"2\n"
			"2\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"2\n"
			"2\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minofferdelay\n"
			"0.000000\n"
			"maxofferdelay\n"
			"0.000000\n"
			"avgofferdelay\n"
			"0.000000\n"
			"Min/Max/Avg answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minanswerdelay\n"
			"0.000000\n"
			"maxanswerdelay\n"
			"0.000000\n"
			"avganswerdelay\n"
			"0.000000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"0/0/0 per sec\n"
			"minofferrequestrate\n"
			"0\n"
			"maxofferrequestrate\n"
			"0\n"
			"avgofferrequestrate\n"
			"0\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");


	call_destroy(call1);
	call_destroy(call2);
	obj_put(call1);
	obj_put(call2);

	// test average call duration

	graph_str = print_graphite_data();
	assert_g_string_eq(graph_str,
			"ping_time_min 0.000000 200\n"
			"ping_time_max 0.000000 200\n"
			"ping_time_avg 0.000000 200\n"
			"pings_ps_min 0 200\n"
			"pings_ps_max 0 200\n"
			"pings_ps_avg 0 200\n"
			"ping_count 0 200\n"
			"offer_time_min 0.000000 200\n"
			"offer_time_max 0.000000 200\n"
			"offer_time_avg 0.000000 200\n"
			"offers_ps_min 0 200\n"
			"offers_ps_max 0 200\n"
			"offers_ps_avg 0 200\n"
			"offer_count 322 200\n"
			"answer_time_min 0.000000 200\n"
			"answer_time_max 0.000000 200\n"
			"answer_time_avg 0.000000 200\n"
			"answers_ps_min 0 200\n"
			"answers_ps_max 0 200\n"
			"answers_ps_avg 0 200\n"
			"answer_count 1 200\n"
			"delete_time_min 0.000000 200\n"
			"delete_time_max 0.000000 200\n"
			"delete_time_avg 0.000000 200\n"
			"deletes_ps_min 0 200\n"
			"deletes_ps_max 0 200\n"
			"deletes_ps_avg 0 200\n"
			"delete_count 0 200\n"
			"query_time_min 0.000000 200\n"
			"query_time_max 0.000000 200\n"
			"query_time_avg 0.000000 200\n"
			"querys_ps_min 0 200\n"
			"querys_ps_max 0 200\n"
			"querys_ps_avg 0 200\n"
			"query_count 0 200\n"
			"list_time_min 0.000000 200\n"
			"list_time_max 0.000000 200\n"
			"list_time_avg 0.000000 200\n"
			"lists_ps_min 0 200\n"
			"lists_ps_max 0 200\n"
			"lists_ps_avg 0 200\n"
			"list_count 0 200\n"
			"start recording_time_min 0.000000 200\n"
			"start recording_time_max 0.000000 200\n"
			"start recording_time_avg 0.000000 200\n"
			"start recordings_ps_min 0 200\n"
			"start recordings_ps_max 0 200\n"
			"start recordings_ps_avg 0 200\n"
			"start recording_count 0 200\n"
			"stop recording_time_min 0.000000 200\n"
			"stop recording_time_max 0.000000 200\n"
			"stop recording_time_avg 0.000000 200\n"
			"stop recordings_ps_min 0 200\n"
			"stop recordings_ps_max 0 200\n"
			"stop recordings_ps_avg 0 200\n"
			"stop recording_count 0 200\n"
			"start forwarding_time_min 0.000000 200\n"
			"start forwarding_time_max 0.000000 200\n"
			"start forwarding_time_avg 0.000000 200\n"
			"start forwardings_ps_min 0 200\n"
			"start forwardings_ps_max 0 200\n"
			"start forwardings_ps_avg 0 200\n"
			"start forwarding_count 0 200\n"
			"stop forwarding_time_min 0.000000 200\n"
			"stop forwarding_time_max 0.000000 200\n"
			"stop forwarding_time_avg 0.000000 200\n"
			"stop forwardings_ps_min 0 200\n"
			"stop forwardings_ps_max 0 200\n"
			"stop forwardings_ps_avg 0 200\n"
			"stop forwarding_count 0 200\n"
			"block DTMF_time_min 0.000000 200\n"
			"block DTMF_time_max 0.000000 200\n"
			"block DTMF_time_avg 0.000000 200\n"
			"block DTMFs_ps_min 0 200\n"
			"block DTMFs_ps_max 0 200\n"
			"block DTMFs_ps_avg 0 200\n"
			"block DTMF_count 0 200\n"
			"unblock DTMF_time_min 0.000000 200\n"
			"unblock DTMF_time_max 0.000000 200\n"
			"unblock DTMF_time_avg 0.000000 200\n"
			"unblock DTMFs_ps_min 0 200\n"
			"unblock DTMFs_ps_max 0 200\n"
			"unblock DTMFs_ps_avg 0 200\n"
			"unblock DTMF_count 0 200\n"
			"block media_time_min 0.000000 200\n"
			"block media_time_max 0.000000 200\n"
			"block media_time_avg 0.000000 200\n"
			"block medias_ps_min 0 200\n"
			"block medias_ps_max 0 200\n"
			"block medias_ps_avg 0 200\n"
			"block media_count 0 200\n"
			"unblock media_time_min 0.000000 200\n"
			"unblock media_time_max 0.000000 200\n"
			"unblock media_time_avg 0.000000 200\n"
			"unblock medias_ps_min 0 200\n"
			"unblock medias_ps_max 0 200\n"
			"unblock medias_ps_avg 0 200\n"
			"unblock media_count 0 200\n"
			"play media_time_min 0.000000 200\n"
			"play media_time_max 0.000000 200\n"
			"play media_time_avg 0.000000 200\n"
			"play medias_ps_min 0 200\n"
			"play medias_ps_max 0 200\n"
			"play medias_ps_avg 0 200\n"
			"play media_count 0 200\n"
			"stop media_time_min 0.000000 200\n"
			"stop media_time_max 0.000000 200\n"
			"stop media_time_avg 0.000000 200\n"
			"stop medias_ps_min 0 200\n"
			"stop medias_ps_max 0 200\n"
			"stop medias_ps_avg 0 200\n"
			"stop media_count 0 200\n"
			"play DTMF_time_min 0.000000 200\n"
			"play DTMF_time_max 0.000000 200\n"
			"play DTMF_time_avg 0.000000 200\n"
			"play DTMFs_ps_min 0 200\n"
			"play DTMFs_ps_max 0 200\n"
			"play DTMFs_ps_avg 0 200\n"
			"play DTMF_count 0 200\n"
			"statistics_time_min 0.000000 200\n"
			"statistics_time_max 0.000000 200\n"
			"statistics_time_avg 0.000000 200\n"
			"statisticss_ps_min 0 200\n"
			"statisticss_ps_max 0 200\n"
			"statisticss_ps_avg 0 200\n"
			"statistics_count 0 200\n"
			"silence media_time_min 0.000000 200\n"
			"silence media_time_max 0.000000 200\n"
			"silence media_time_avg 0.000000 200\n"
			"silence medias_ps_min 0 200\n"
			"silence medias_ps_max 0 200\n"
			"silence medias_ps_avg 0 200\n"
			"silence media_count 0 200\n"
			"unsilence media_time_min 0.000000 200\n"
			"unsilence media_time_max 0.000000 200\n"
			"unsilence media_time_avg 0.000000 200\n"
			"unsilence medias_ps_min 0 200\n"
			"unsilence medias_ps_max 0 200\n"
			"unsilence medias_ps_avg 0 200\n"
			"unsilence media_count 0 200\n"
			"publish_time_min 0.000000 200\n"
			"publish_time_max 0.000000 200\n"
			"publish_time_avg 0.000000 200\n"
			"publishs_ps_min 0 200\n"
			"publishs_ps_max 0 200\n"
			"publishs_ps_avg 0 200\n"
			"publish_count 0 200\n"
			"subscribe request_time_min 0.000000 200\n"
			"subscribe request_time_max 0.000000 200\n"
			"subscribe request_time_avg 0.000000 200\n"
			"subscribe requests_ps_min 0 200\n"
			"subscribe requests_ps_max 0 200\n"
			"subscribe requests_ps_avg 0 200\n"
			"subscribe request_count 0 200\n"
			"subscribe answer_time_min 0.000000 200\n"
			"subscribe answer_time_max 0.000000 200\n"
			"subscribe answer_time_avg 0.000000 200\n"
			"subscribe answers_ps_min 0 200\n"
			"subscribe answers_ps_max 0 200\n"
			"subscribe answers_ps_avg 0 200\n"
			"subscribe answer_count 0 200\n"
			"unsubscribe_time_min 0.000000 200\n"
			"unsubscribe_time_max 0.000000 200\n"
			"unsubscribe_time_avg 0.000000 200\n"
			"unsubscribes_ps_min 0 200\n"
			"unsubscribes_ps_max 0 200\n"
			"unsubscribes_ps_avg 0 200\n"
			"unsubscribe_count 0 200\n"
			"call_dur 0.000000 200\n"
			"average_call_dur 93.000000 200\n"
			"forced_term_sess 0 200\n"
			"managed_sess 2 200\n"
			"managed_sess_min 0 200\n"
			"managed_sess_max 2 200\n"
			"current_sessions_total 0 200\n"
			"current_sessions_own 0 200\n"
			"current_sessions_foreign 0 200\n"
			"current_transcoded_media 0 200\n"
			"current_sessions_ipv4 0 200\n"
			"current_sessions_ipv6 0 200\n"
			"current_sessions_mixed 0 200\n"
			"nopacket_relayed_sess 0 200\n"
			"oneway_stream_sess 0 200\n"
			"regular_term_sess 0 200\n"
			"relayed_errors_user 0 200\n"
			"relayed_packets_user 0 200\n"
			"relayed_bytes_user 0 200\n"
			"relayed_errors_kernel 0 200\n"
			"relayed_packets_kernel 0 200\n"
			"relayed_bytes_kernel 0 200\n"
			"relayed_errors 0 200\n"
			"relayed_packets 0 200\n"
			"relayed_bytes 0 200\n"
			"silent_timeout_sess 0 200\n"
			"final_timeout_sess 0 200\n"
			"offer_timeout_sess 0 200\n"
			"timeout_sess 0 200\n"
			"reject_sess 0 200\n");

	stats = statistics_gather_metrics();
	assert_metrics_eq(stats,
			"\n"
			"{\n"
			"Statistics over currently running sessions:\n"
			"currentstatistics\n"
			"\n"
			"{\n"
			"Owned sessions\n"
			"sessionsown\n"
			"0\n"
			"0\n"
			"type=\"own\"\n"
			"Foreign sessions\n"
			"sessionsforeign\n"
			"0\n"
			"0\n"
			"type=\"foreign\"\n"
			"Total sessions\n"
			"sessionstotal\n"
			"0\n"
			"0\n"
			"Transcoded media\n"
			"transcodedmedia\n"
			"0\n"
			"0\n"
			"Packets per second (userspace)\n"
			"packetrate_user\n"
			"0\n"
			"0\n"
			"Bytes per second (userspace)\n"
			"byterate_user\n"
			"0\n"
			"0\n"
			"Errors per second (userspace)\n"
			"errorrate_user\n"
			"0\n"
			"0\n"
			"Packets per second (kernel)\n"
			"packetrate_kernel\n"
			"0\n"
			"0\n"
			"Bytes per second (kernel)\n"
			"byterate_kernel\n"
			"0\n"
			"0\n"
			"Errors per second (kernel)\n"
			"errorrate_kernel\n"
			"0\n"
			"0\n"
			"Packets per second (total)\n"
			"packetrate\n"
			"0\n"
			"0\n"
			"Bytes per second (total)\n"
			"byterate\n"
			"0\n"
			"0\n"
			"Errors per second (total)\n"
			"errorrate\n"
			"0\n"
			"0\n"
			"Userspace-only media streams\n"
			"media_userspace\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Kernel-only media streams\n"
			"media_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Mixed kernel/userspace media streams\n"
			"media_mixed\n"
			"0\n"
			"0\n"
			"type=\"mixed\"\n"
			"\n"
			"}\n"
			"Total statistics (does not include current running sessions):\n"
			"totalstatistics\n"
			"\n"
			"{\n"
			"Uptime of rtpengine\n"
			"uptime\n"
			"120 seconds\n"
			"120\n"
			"Total managed sessions\n"
			"managedsessions\n"
			"2\n"
			"2\n"
			"Total rejected sessions\n"
			"rejectedsessions\n"
			"0\n"
			"0\n"
			"reason=\"rejected\"\n"
			"Total timed-out sessions via TIMEOUT\n"
			"timeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"timeout\"\n"
			"Total timed-out sessions via SILENT_TIMEOUT\n"
			"silenttimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"silent_timeout\"\n"
			"Total timed-out sessions via FINAL_TIMEOUT\n"
			"finaltimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"final_timeout\"\n"
			"Total timed-out sessions via OFFER_TIMEOUT\n"
			"offertimeoutsessions\n"
			"0\n"
			"0\n"
			"reason=\"offer_timeout\"\n"
			"Total regular terminated sessions\n"
			"regularterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"terminated\"\n"
			"Total forced terminated sessions\n"
			"forcedterminatedsessions\n"
			"0\n"
			"0\n"
			"reason=\"force_terminated\"\n"
			"Total relayed packets (userspace)\n"
			"relayedpackets_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packet errors (userspace)\n"
			"relayedpacketerrors_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed bytes (userspace)\n"
			"relayedbytes_user\n"
			"0\n"
			"0\n"
			"type=\"userspace\"\n"
			"Total relayed packets (kernel)\n"
			"relayedpackets_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packet errors (kernel)\n"
			"relayedpacketerrors_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed bytes (kernel)\n"
			"relayedbytes_kernel\n"
			"0\n"
			"0\n"
			"type=\"kernel\"\n"
			"Total relayed packets\n"
			"relayedpackets\n"
			"0\n"
			"0\n"
			"Total relayed packet errors\n"
			"relayedpacketerrors\n"
			"0\n"
			"0\n"
			"Total relayed bytes\n"
			"relayedbytes\n"
			"0\n"
			"0\n"
			"Total number of streams with no relayed packets\n"
			"zerowaystreams\n"
			"0\n"
			"0\n"
			"Total number of 1-way streams\n"
			"onewaystreams\n"
			"0\n"
			"0\n"
			"Average call duration\n"
			"avgcallduration\n"
			"93.000000 seconds\n"
			"93.000000\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"186.000000 seconds\n"
			"186.000000\n"
			"Total calls duration squared\n"
			"totalcallsduration2\n"
			"22298.000000 seconds squared\n"
			"22298.000000\n"
			"Total calls duration standard deviation\n"
			"totalcallsduration_stddev\n"
			"50.000000 seconds\n"
			"50.000000\n"
			"\n"
			"\n"
			"}\n"
			"Graphite interval statistics (last reported values to graphite):\n"
			"intervalstatistics\n"
			"{\n"
			"Total calls duration\n"
			"totalcallsduration\n"
			"0.000000 seconds\n"
			"0.000000\n"
			"\n"
			"Min managed sessions\n"
			"minmanagedsessions\n"
			"0\n"
			"0\n"
			"Max managed sessions\n"
			"maxmanagedsessions\n"
			"2\n"
			"2\n"
			"Min/Max/Avg ping processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpingdelay\n"
			"0.000000\n"
			"maxpingdelay\n"
			"0.000000\n"
			"avgpingdelay\n"
			"0.000000\n"
			"Min/Max/Avg offer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minofferdelay\n"
			"0.000000\n"
			"maxofferdelay\n"
			"0.000000\n"
			"avgofferdelay\n"
			"0.000000\n"
			"Min/Max/Avg answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minanswerdelay\n"
			"0.000000\n"
			"maxanswerdelay\n"
			"0.000000\n"
			"avganswerdelay\n"
			"0.000000\n"
			"Min/Max/Avg delete processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"mindeletedelay\n"
			"0.000000\n"
			"maxdeletedelay\n"
			"0.000000\n"
			"avgdeletedelay\n"
			"0.000000\n"
			"Min/Max/Avg query processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minquerydelay\n"
			"0.000000\n"
			"maxquerydelay\n"
			"0.000000\n"
			"avgquerydelay\n"
			"0.000000\n"
			"Min/Max/Avg list processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minlistdelay\n"
			"0.000000\n"
			"maxlistdelay\n"
			"0.000000\n"
			"avglistdelay\n"
			"0.000000\n"
			"Min/Max/Avg start recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart recordingdelay\n"
			"0.000000\n"
			"maxstart recordingdelay\n"
			"0.000000\n"
			"avgstart recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop recording processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop recordingdelay\n"
			"0.000000\n"
			"maxstop recordingdelay\n"
			"0.000000\n"
			"avgstop recordingdelay\n"
			"0.000000\n"
			"Min/Max/Avg start forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstart forwardingdelay\n"
			"0.000000\n"
			"maxstart forwardingdelay\n"
			"0.000000\n"
			"avgstart forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg stop forwarding processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop forwardingdelay\n"
			"0.000000\n"
			"maxstop forwardingdelay\n"
			"0.000000\n"
			"avgstop forwardingdelay\n"
			"0.000000\n"
			"Min/Max/Avg block DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock DTMFdelay\n"
			"0.000000\n"
			"maxblock DTMFdelay\n"
			"0.000000\n"
			"avgblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock DTMFdelay\n"
			"0.000000\n"
			"maxunblock DTMFdelay\n"
			"0.000000\n"
			"avgunblock DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg block media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minblock mediadelay\n"
			"0.000000\n"
			"maxblock mediadelay\n"
			"0.000000\n"
			"avgblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unblock media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunblock mediadelay\n"
			"0.000000\n"
			"maxunblock mediadelay\n"
			"0.000000\n"
			"avgunblock mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay mediadelay\n"
			"0.000000\n"
			"maxplay mediadelay\n"
			"0.000000\n"
			"avgplay mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg stop media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstop mediadelay\n"
			"0.000000\n"
			"maxstop mediadelay\n"
			"0.000000\n"
			"avgstop mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg play DTMF processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minplay DTMFdelay\n"
			"0.000000\n"
			"maxplay DTMFdelay\n"
			"0.000000\n"
			"avgplay DTMFdelay\n"
			"0.000000\n"
			"Min/Max/Avg statistics processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minstatisticsdelay\n"
			"0.000000\n"
			"maxstatisticsdelay\n"
			"0.000000\n"
			"avgstatisticsdelay\n"
			"0.000000\n"
			"Min/Max/Avg silence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsilence mediadelay\n"
			"0.000000\n"
			"maxsilence mediadelay\n"
			"0.000000\n"
			"avgsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg unsilence media processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsilence mediadelay\n"
			"0.000000\n"
			"maxunsilence mediadelay\n"
			"0.000000\n"
			"avgunsilence mediadelay\n"
			"0.000000\n"
			"Min/Max/Avg publish processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minpublishdelay\n"
			"0.000000\n"
			"maxpublishdelay\n"
			"0.000000\n"
			"avgpublishdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe request processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe requestdelay\n"
			"0.000000\n"
			"maxsubscribe requestdelay\n"
			"0.000000\n"
			"avgsubscribe requestdelay\n"
			"0.000000\n"
			"Min/Max/Avg subscribe answer processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minsubscribe answerdelay\n"
			"0.000000\n"
			"maxsubscribe answerdelay\n"
			"0.000000\n"
			"avgsubscribe answerdelay\n"
			"0.000000\n"
			"Min/Max/Avg unsubscribe processing delay\n"
			"0.000000/0.000000/0.000000 sec\n"
			"minunsubscribedelay\n"
			"0.000000\n"
			"maxunsubscribedelay\n"
			"0.000000\n"
			"avgunsubscribedelay\n"
			"0.000000\n"
			"Min/Max/Avg ping requests per second\n"
			"0/0/0 per sec\n"
			"minpingrequestrate\n"
			"0\n"
			"maxpingrequestrate\n"
			"0\n"
			"avgpingrequestrate\n"
			"0\n"
			"Min/Max/Avg offer requests per second\n"
			"0/0/0 per sec\n"
			"minofferrequestrate\n"
			"0\n"
			"maxofferrequestrate\n"
			"0\n"
			"avgofferrequestrate\n"
			"0\n"
			"Min/Max/Avg answer requests per second\n"
			"0/0/0 per sec\n"
			"minanswerrequestrate\n"
			"0\n"
			"maxanswerrequestrate\n"
			"0\n"
			"avganswerrequestrate\n"
			"0\n"
			"Min/Max/Avg delete requests per second\n"
			"0/0/0 per sec\n"
			"mindeleterequestrate\n"
			"0\n"
			"maxdeleterequestrate\n"
			"0\n"
			"avgdeleterequestrate\n"
			"0\n"
			"Min/Max/Avg query requests per second\n"
			"0/0/0 per sec\n"
			"minqueryrequestrate\n"
			"0\n"
			"maxqueryrequestrate\n"
			"0\n"
			"avgqueryrequestrate\n"
			"0\n"
			"Min/Max/Avg list requests per second\n"
			"0/0/0 per sec\n"
			"minlistrequestrate\n"
			"0\n"
			"maxlistrequestrate\n"
			"0\n"
			"avglistrequestrate\n"
			"0\n"
			"Min/Max/Avg start recording requests per second\n"
			"0/0/0 per sec\n"
			"minstart recordingrequestrate\n"
			"0\n"
			"maxstart recordingrequestrate\n"
			"0\n"
			"avgstart recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop recording requests per second\n"
			"0/0/0 per sec\n"
			"minstop recordingrequestrate\n"
			"0\n"
			"maxstop recordingrequestrate\n"
			"0\n"
			"avgstop recordingrequestrate\n"
			"0\n"
			"Min/Max/Avg start forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstart forwardingrequestrate\n"
			"0\n"
			"maxstart forwardingrequestrate\n"
			"0\n"
			"avgstart forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg stop forwarding requests per second\n"
			"0/0/0 per sec\n"
			"minstop forwardingrequestrate\n"
			"0\n"
			"maxstop forwardingrequestrate\n"
			"0\n"
			"avgstop forwardingrequestrate\n"
			"0\n"
			"Min/Max/Avg block DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minblock DTMFrequestrate\n"
			"0\n"
			"maxblock DTMFrequestrate\n"
			"0\n"
			"avgblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg unblock DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minunblock DTMFrequestrate\n"
			"0\n"
			"maxunblock DTMFrequestrate\n"
			"0\n"
			"avgunblock DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg block media requests per second\n"
			"0/0/0 per sec\n"
			"minblock mediarequestrate\n"
			"0\n"
			"maxblock mediarequestrate\n"
			"0\n"
			"avgblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unblock media requests per second\n"
			"0/0/0 per sec\n"
			"minunblock mediarequestrate\n"
			"0\n"
			"maxunblock mediarequestrate\n"
			"0\n"
			"avgunblock mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play media requests per second\n"
			"0/0/0 per sec\n"
			"minplay mediarequestrate\n"
			"0\n"
			"maxplay mediarequestrate\n"
			"0\n"
			"avgplay mediarequestrate\n"
			"0\n"
			"Min/Max/Avg stop media requests per second\n"
			"0/0/0 per sec\n"
			"minstop mediarequestrate\n"
			"0\n"
			"maxstop mediarequestrate\n"
			"0\n"
			"avgstop mediarequestrate\n"
			"0\n"
			"Min/Max/Avg play DTMF requests per second\n"
			"0/0/0 per sec\n"
			"minplay DTMFrequestrate\n"
			"0\n"
			"maxplay DTMFrequestrate\n"
			"0\n"
			"avgplay DTMFrequestrate\n"
			"0\n"
			"Min/Max/Avg statistics requests per second\n"
			"0/0/0 per sec\n"
			"minstatisticsrequestrate\n"
			"0\n"
			"maxstatisticsrequestrate\n"
			"0\n"
			"avgstatisticsrequestrate\n"
			"0\n"
			"Min/Max/Avg silence media requests per second\n"
			"0/0/0 per sec\n"
			"minsilence mediarequestrate\n"
			"0\n"
			"maxsilence mediarequestrate\n"
			"0\n"
			"avgsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg unsilence media requests per second\n"
			"0/0/0 per sec\n"
			"minunsilence mediarequestrate\n"
			"0\n"
			"maxunsilence mediarequestrate\n"
			"0\n"
			"avgunsilence mediarequestrate\n"
			"0\n"
			"Min/Max/Avg publish requests per second\n"
			"0/0/0 per sec\n"
			"minpublishrequestrate\n"
			"0\n"
			"maxpublishrequestrate\n"
			"0\n"
			"avgpublishrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe request requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe requestrequestrate\n"
			"0\n"
			"maxsubscribe requestrequestrate\n"
			"0\n"
			"avgsubscribe requestrequestrate\n"
			"0\n"
			"Min/Max/Avg subscribe answer requests per second\n"
			"0/0/0 per sec\n"
			"minsubscribe answerrequestrate\n"
			"0\n"
			"maxsubscribe answerrequestrate\n"
			"0\n"
			"avgsubscribe answerrequestrate\n"
			"0\n"
			"Min/Max/Avg unsubscribe requests per second\n"
			"0/0/0 per sec\n"
			"minunsubscriberequestrate\n"
			"0\n"
			"maxunsubscriberequestrate\n"
			"0\n"
			"avgunsubscriberequestrate\n"
			"0\n"
			"\n"
			"\n"
			"}\n"
			"MOS statistics:\n"
			"mos\n"
			"\n"
			"{\n"
			"Sum of all MOS values sampled\n"
			"mos_total\n"
			"0.000000\n"
			"0.000000\n"
			"Sum of all MOS square values sampled\n"
			"mos2_total\n"
			"0.000000\n"
			"0.000000\n"
			"Total number of MOS samples\n"
			"mos_samples_total\n"
			"0\n"
			"0\n"
			"Average MOS\n"
			"mos_average\n"
			"0.000000\n"
			"0.000000\n"
			"MOS standard deviation\n"
			"mos_stddev\n"
			"0.000000\n"
			"0.000000\n"
			"\n"
			"\n"
			"}\n"
			"Control statistics:\n"
			"controlstatistics\n"
			"\n"
			"{\n"
			"proxies\n"
			"[\n"
			"                Proxy |       Ping |      Offer |     Answer |     Delete |      Query |       List |   StartRec |    StopRec |   StartFwd |    StopFwd |    BlkDTMF |  UnblkDTMF |   BlkMedia | UnblkMedia |  PlayMedia |  StopMedia |   PlayDTMF |      Stats |   SlnMedia | UnslnMedia |        Pub |     SubReq |     SubAns |      Unsub \n"
			"\n"
			"]\n"
			"totalpingcount\n"
			"0\n"
			"totaloffercount\n"
			"0\n"
			"totalanswercount\n"
			"0\n"
			"totaldeletecount\n"
			"0\n"
			"totalquerycount\n"
			"0\n"
			"totallistcount\n"
			"0\n"
			"totalstartreccount\n"
			"0\n"
			"totalstopreccount\n"
			"0\n"
			"totalstartfwdcount\n"
			"0\n"
			"totalstopfwdcount\n"
			"0\n"
			"totalblkdtmfcount\n"
			"0\n"
			"totalunblkdtmfcount\n"
			"0\n"
			"totalblkmediacount\n"
			"0\n"
			"totalunblkmediacount\n"
			"0\n"
			"totalplaymediacount\n"
			"0\n"
			"totalstopmediacount\n"
			"0\n"
			"totalplaydtmfcount\n"
			"0\n"
			"totalstatscount\n"
			"0\n"
			"totalslnmediacount\n"
			"0\n"
			"totalunslnmediacount\n"
			"0\n"
			"totalpubcount\n"
			"0\n"
			"totalsubreqcount\n"
			"0\n"
			"totalsubanscount\n"
			"0\n"
			"totalunsubcount\n"
			"0\n"
			"\n"
			"}\n"
			"interfaces\n"
			"[\n"
			"]\n"
			"transcoders\n"
			"\n"
			"[\n"
			"\n"
			"]\n"
			"}\n");


	// cleanup

	statistics_free();
	call_free();
	call_interfaces_free();
	control_ng_cleanup();
	dtls_cert_free();

	return 0;
}

int get_local_log_level(unsigned int u) {
	return 7;
}
