% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problems.R
\name{wk_problems}
\alias{wk_problems}
\alias{wk_problems_handler}
\title{Validate well-known binary and well-known text}
\usage{
wk_problems(handleable, ...)

wk_problems_handler()
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}
}
\value{
A character vector of parsing errors. \code{NA} signifies
that there was no parsing error.
}
\description{
The problems handler returns a character vector of parse
errors and can be used to validate input of any type
for which \code{\link[=wk_handle]{wk_handle()}} is defined.
}
\examples{
wk_problems(new_wk_wkt(c("POINT EMTPY", "POINT (20 30)")))
wk_handle(
  new_wk_wkt(c("POINT EMTPY", "POINT (20 30)")),
  wk_problems_handler()
)

}
