% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-bare.R, R/type2.R
\name{vec_ptype2.logical}
\alias{vec_ptype2.logical}
\alias{vec_ptype2.integer}
\alias{vec_ptype2.double}
\alias{vec_ptype2.complex}
\alias{vec_ptype2.character}
\alias{vec_ptype2.raw}
\alias{vec_ptype2.list}
\alias{vec_ptype2}
\title{Find the common type for a pair of vectors}
\usage{
\method{vec_ptype2}{logical}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{integer}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{double}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{complex}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{character}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{raw}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{list}(x, y, ..., x_arg = "", y_arg = "")

vec_ptype2(x, y, ..., x_arg = "", y_arg = "")
}
\arguments{
\item{x, y}{Vector types.}

\item{...}{These dots are for future extensions and must be empty.}

\item{x_arg, y_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}
}
\description{
\code{vec_ptype2()} defines the coercion hierarchy for a set of related
vector types. Along with \code{\link[=vec_cast]{vec_cast()}}, this generic forms the
foundation of type coercions in vctrs.

\code{vec_ptype2()} is relevant when you are implementing vctrs methods
for your class, but it should not usually be called directly. If
you need to find the common type of a set of inputs, call
\code{\link[=vec_ptype_common]{vec_ptype_common()}} instead. This function supports multiple
inputs and \link[=vec_ptype_finalise]{finalises} the common type.
}
\section{Implementing coercion methods}{
\itemize{
\item For an overview of how these generics work and their roles in vctrs,
see \code{\link[=theory-faq-coercion]{?theory-faq-coercion}}.
\item For an example of implementing coercion methods for simple vectors,
see \code{\link[=howto-faq-coercion]{?howto-faq-coercion}}.
\item For an example of implementing coercion methods for data frame
subclasses, see
\code{\link[=howto-faq-coercion-data-frame]{?howto-faq-coercion-data-frame}}.
\item For a tutorial about implementing vctrs classes from scratch, see
\code{vignette("s3-vector")}.
}
}

\section{Dependencies}{

\itemize{
\item \code{\link[=vec_ptype]{vec_ptype()}} is applied to \code{x} and \code{y}
}
}

\seealso{
\code{\link[=stop_incompatible_type]{stop_incompatible_type()}} when you determine from the
attributes that an input can't be cast to the target type.
}
