% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{makeDegenerate5merMut}
\alias{makeDegenerate5merMut}
\title{Make a degenerate 5-mer mutability model based on a 1-mer mutability model}
\usage{
makeDegenerate5merMut(mut1mer, extended = FALSE)
}
\arguments{
\item{mut1mer}{a named vector of length 4 containing (normalized) 
mutability rates. Names should correspond to nucleotides, 
which should include "A", "T", "G", and "C" 
(case-insensitive).}

\item{extended}{whether to return the unextended (\code{extended=FALSE}) or 
extended (\code{extended=TRUE}) 5-mer mutability model. 
Default is \code{FALSE}.}
}
\value{
For \code{extended=FALSE}, a vector of length 1024. The vector returned is 
          normalized. For \code{extended=TRUE}, a vector of length 3125.
}
\description{
\code{makeDegenerate5merMut} populates mutability rates from a 1-mer mutability model
into 5-mers with corresponding central 1-mers.
}
\details{
As a concrete example, consider a 1-mer mutability model in which mutability
          rates of "A", "T", "G", and "C" are, respectively, 0.14, 0.23, 0.31, and 0.32. 
          In the resultant degenerate 5-mer mutability model, all the 5-mers that have 
          an "A" as their central 1-mer would have mutability rate of 0.14/256, where 256 is
          the number of such 5-mers. 
          
          When \code{extended=TRUE}, \code{extendMutabilityMatrix} is called to extend the
          mutability vector of length 1024 into a vector of length 3125.
}
\examples{
# Make a degenerate 5-mer model (length of 1024) based on a 1-mer model
example1merMut <- c(A=0.2, T=0.1, C=0.4, G=0.3)
degenerate5merMut <- makeDegenerate5merMut(mut1mer = example1merMut)

# Look at a few 5-mers
degenerate5merMut[c("AAAAT", "AACAT", "AAGAT", "AATAT")]

# Normalized
sum(degenerate5merMut)

}
\seealso{
See \link{makeAverage1merMut} for making a 1-mer mutability model by 
          taking the average of a 5-mer mutability model. See 
          \link{extendMutabilityMatrix} for extending the mutability vector.
}
