% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_unite}
\alias{df_unite}
\alias{df_unite_factors}
\title{Unite Multiple Columns into One}
\usage{
df_unite(data, col, ..., vars = NULL, sep = "_", remove = TRUE, na.rm = FALSE)

df_unite_factors(
  data,
  col,
  ...,
  vars = NULL,
  sep = "_",
  remove = TRUE,
  na.rm = FALSE
)
}
\arguments{
\item{data}{a data frame}

\item{col}{the name of the new column as a string or a symbol.}

\item{...}{a selection of columns. One or more unquoted expressions (or variable names) separated by
commas.}

\item{vars}{a character vector containing the column names of interest.}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values will be removed prior to uniting
each value.}
}
\description{
Paste together multiple columns into one. Wrapper arround
  \code{\link[tidyr]{unite}()} that supports standard and non standard
  evaluation.
}
\section{Functions}{
\itemize{
\item \code{df_unite()}: Unite multiple columns into one.

\item \code{df_unite_factors()}: Unite factor columns. First, order factors levels then
merge them into one column. The output column is a factor.

}}
\examples{
# Non standard evaluation
head(ToothGrowth) \%>\%
 df_unite(col = "dose_supp", dose, supp)

# Standard evaluation
head(ToothGrowth) \%>\%
 df_unite(col = "dose_supp", vars = c("dose", "supp"))
}
