% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.polyreg.R
\name{mice.impute.polyreg}
\alias{mice.impute.polyreg}
\title{Imputation of unordered data by polytomous regression}
\usage{
mice.impute.polyreg(
  y,
  ry,
  x,
  wy = NULL,
  nnet.maxit = 100,
  nnet.trace = FALSE,
  nnet.MaxNWts = 1500,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{nnet.maxit}{Tuning parameter for \code{nnet()}.}

\item{nnet.trace}{Tuning parameter for \code{nnet()}.}

\item{nnet.MaxNWts}{Tuning parameter for \code{nnet()}.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}
}
\description{
Imputes missing data in a categorical variable using polytomous regression
}
\details{
The function \code{mice.impute.polyreg()} imputes categorical response
variables by the Bayesian polytomous regression model. See J.P.L. Brand
(1999), Chapter 4, Appendix B.

By default, unordered factors with more than two levels are imputed by
\code{mice.impute.polyreg()}.

The method consists of the following steps:
\enumerate{
\item Fit categorical response as a multinomial model
\item Compute predicted categories
\item Add appropriate noise to predictions
}

The algorithm of \code{mice.impute.polyreg} uses the function
\code{multinom()} from the \code{nnet} package.

In order to avoid bias due to perfect prediction, the algorithm augment the
data according to the method of White, Daniel and Royston (2010).
}
\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2011). \code{mice}: Multivariate
Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical
Software}, \bold{45}(3), 1-67. \url{https://www.jstatsoft.org/v45/i03/}

Brand, J.P.L. (1999) \emph{Development, implementation and evaluation of
multiple imputation strategies for the statistical analysis of incomplete
data sets.} Dissertation. Rotterdam: Erasmus University.

White, I.R., Daniel, R. Royston, P. (2010). Avoiding bias due to perfect
prediction in multiple imputation of incomplete categorical variables.
\emph{Computational Statistics and Data Analysis}, 54, 2267-2275.

Venables, W.N. & Ripley, B.D. (2002). \emph{Modern applied statistics with
S-Plus (4th ed)}. Springer, Berlin.
}
\seealso{
\code{\link{mice}}, \code{\link[nnet]{multinom}},
\code{\link[MASS]{polr}}

Other univariate imputation functions: 
\code{\link{mice.impute.cart}()},
\code{\link{mice.impute.lda}()},
\code{\link{mice.impute.logreg.boot}()},
\code{\link{mice.impute.logreg}()},
\code{\link{mice.impute.mean}()},
\code{\link{mice.impute.midastouch}()},
\code{\link{mice.impute.mnar.logreg}()},
\code{\link{mice.impute.norm.boot}()},
\code{\link{mice.impute.norm.nob}()},
\code{\link{mice.impute.norm.predict}()},
\code{\link{mice.impute.norm}()},
\code{\link{mice.impute.pmm}()},
\code{\link{mice.impute.polr}()},
\code{\link{mice.impute.quadratic}()},
\code{\link{mice.impute.rf}()},
\code{\link{mice.impute.ri}()}
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn, 2000-2010
}
\concept{univariate imputation functions}
\keyword{datagen}
