% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/probabilistic.R
\name{period}
\alias{period}
\alias{communicatingClasses}
\alias{transientStates}
\alias{recurrentStates}
\alias{absorbingStates}
\alias{transientClasses}
\alias{recurrentClasses}
\alias{canonicForm}
\title{Various function to perform structural analysis of DTMC}
\usage{
period(object)

communicatingClasses(object)

recurrentClasses(object)

transientClasses(object)

transientStates(object)

recurrentStates(object)

absorbingStates(object)

canonicForm(object)
}
\arguments{
\item{object}{A \code{markovchain} object.}
}
\value{
\describe{
  \item{\code{period}}{returns a integer number corresponding to the periodicity of the Markov 
    chain (if it is irreducible)}
  \item{\code{absorbingStates}}{returns a character vector with the names of the absorbing 
    states in the Markov chain}
  \item{\code{communicatingClasses}}{returns a list in which each slot contains the names of
    the states that are in that communicating class}
  \item{\code{recurrentClasses}}{analogously to \code{communicatingClasses}, but with 
    recurrent classes}
  \item{\code{transientClasses}}{analogously to \code{communicatingClasses}, but with 
    transient classes}
  \item{\code{transientStates}}{returns a character vector with all the transient states
    for the Markov chain}
  \item{\code{recurrentStates}}{returns a character vector with all the recurrent states 
    for the Markov chain}
  \item{\code{canonicForm}}{returns the Markov chain reordered by a permutation of states 
    so that we have blocks submatrices for each of the recurrent classes and a collection 
    of rows in the end for the transient states}
}
}
\description{
These functions return absorbing and transient states of the \code{markovchain} objects.
}
\examples{
statesNames <- c("a", "b", "c")
mc <- new("markovchain", states = statesNames, transitionMatrix =
          matrix(c(0.2, 0.5, 0.3,
                   0,   1,   0,
                   0.1, 0.8, 0.1), nrow = 3, byrow = TRUE,
                 dimnames = list(statesNames, statesNames))
         )

communicatingClasses(mc)
recurrentClasses(mc)
recurrentClasses(mc)
absorbingStates(mc)
transientStates(mc)
recurrentStates(mc)
canonicForm(mc)

# periodicity analysis
A <- matrix(c(0, 1, 0, 0, 0.5, 0, 0.5, 0, 0, 0.5, 0, 0.5, 0, 0, 1, 0), 
            nrow = 4, ncol = 4, byrow = TRUE)
mcA <- new("markovchain", states = c("a", "b", "c", "d"), 
          transitionMatrix = A,
          name = "A")

is.irreducible(mcA) #true
period(mcA) #2

# periodicity analysis
B <- matrix(c(0, 0, 1/2, 1/4, 1/4, 0, 0,
                   0, 0, 1/3, 0, 2/3, 0, 0,
                   0, 0, 0, 0, 0, 1/3, 2/3,
                   0, 0, 0, 0, 0, 1/2, 1/2,
                   0, 0, 0, 0, 0, 3/4, 1/4,
                   1/2, 1/2, 0, 0, 0, 0, 0,
                   1/4, 3/4, 0, 0, 0, 0, 0), byrow = TRUE, ncol = 7)
mcB <- new("markovchain", transitionMatrix = B)
period(mcB)

}
\references{
Feres, Matlab listing for markov chain.
}
\seealso{
\code{\linkS4class{markovchain}}
}
\author{
Giorgio Alfredo Spedicato, Ignacio Cordón
}
