% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_rope.R
\name{interpret_rope}
\alias{interpret_rope}
\title{Interpret Bayesian Posterior Percentage in ROPE.}
\usage{
interpret_rope(rope, rules = "default", ci = 0.9)
}
\arguments{
\item{rope}{Value or vector of percentages in ROPE.}

\item{rules}{A character string (see details) or a custom set of \code{\link[=rules]{rules()}}.}

\item{ci}{The Credible Interval (CI) probability, corresponding to the
proportion of HDI, that was used. Can be \code{1} in the case of "full ROPE".}
}
\description{
Interpretation of
}
\section{Rules}{

\itemize{
\item Default
\itemize{
\item For CI < 1
\itemize{
\item \strong{Rope = 0} - Significant
\item \strong{0 < Rope < 1} - Undecided
\item \strong{Rope = 1} - Negligible
}
\item For CI = 1
\itemize{
\item \strong{Rope < 0.01} - Significant
\item \strong{0.01 < Rope < 0.025} - Probably significant
\item \strong{0.025 < Rope < 0.975} - Undecided
\item \strong{0.975 < Rope < 0.99} - Probably negligible
\item \strong{Rope > 0.99} - Negligible
}
}
}
}

\examples{
interpret_rope(0, ci = 0.9)
interpret_rope(c(0.005, 0.99), ci = 1)
}
\references{
\href{https://easystats.github.io/bayestestR/articles/guidelines.html}{BayestestR's reporting guidelines}
}
\keyword{interpreters}
