% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfcShrink.R
\name{lfcShrink}
\alias{lfcShrink}
\title{Shrink log2 fold changes}
\usage{
lfcShrink(
  dds,
  coef,
  contrast,
  res,
  type = c("apeglm", "ashr", "normal"),
  lfcThreshold = 0,
  svalue = FALSE,
  returnList = FALSE,
  format = c("DataFrame", "GRanges", "GRangesList"),
  apeAdapt = TRUE,
  apeMethod = "nbinomCR",
  parallel = FALSE,
  BPPARAM = bpparam(),
  quiet = FALSE,
  ...
)
}
\arguments{
\item{dds}{a DESeqDataSet object, after running \code{\link{DESeq}}}

\item{coef}{the name or number of the coefficient (LFC) to shrink,
consult \code{resultsNames(dds)} after running \code{DESeq(dds)}.
note: only \code{coef} or \code{contrast} can be specified, not both.
\code{apeglm} requires use of \code{coef}.
For \code{normal}, one of \code{coef} or \code{contrast} must be provided.}

\item{contrast}{see argument description in \code{\link{results}}.
only \code{coef} or \code{contrast} can be specified, not both.}

\item{res}{a DESeqResults object. Results table produced by the
default pipeline, i.e. \code{DESeq} followed by \code{results}.
If not provided, it will be generated internally using \code{coef} or \code{contrast}.
For \code{ashr}, if \code{res} is provided, then \code{coef} and \code{contrast} are ignored.}

\item{type}{\code{"apeglm"} is the adaptive Student's t prior shrinkage estimator from the 'apeglm' package;
\code{"ashr"} is the adaptive shrinkage estimator from the 'ashr' package,
using a fitted mixture of normals prior
- see the Stephens (2016) reference below for citation;
\code{"normal"} is the 2014 DESeq2 shrinkage estimator using a Normal prior;}

\item{lfcThreshold}{a non-negative value which specifies a log2 fold change
threshold (as in \code{\link{results}}). This can be used in conjunction with
\code{normal} and \code{apeglm}, where it will produce new p-values or
s-values testing whether the LFC is greater in absolute value than the threshold.
The s-values returned in combination with \code{apeglm} provide the probability
of FSOS events, "false sign or small", among the tests with equal or smaller s-value
than a given gene's s-value, where "small" is specified by \code{lfcThreshold}.}

\item{svalue}{logical, should p-values and adjusted p-values be replaced
with s-values when using \code{apeglm} or \code{ashr}. s-values provide the probability
of false signs among the tests with equal or smaller s-value than a given given's s-value.
See Stephens (2016) reference on s-values.}

\item{returnList}{logical, should \code{lfcShrink} return a list, where
the first element is the results table, and the second element is the
output of \code{apeglm} or \code{ashr}}

\item{format}{same as defined in \code{\link{results}},
either \code{"DataFrame"}, \code{"GRanges"}, or \code{"GRangesList"}}

\item{apeAdapt}{logical, should \code{apeglm} use the MLE estimates of
LFC to adapt the prior, or use default or specified \code{prior.control}}

\item{apeMethod}{what \code{method} to run \code{apeglm}, which can
differ in terms of speed}

\item{parallel}{if FALSE, no parallelization. if TRUE, parallel
execution using \code{BiocParallel}, see same argument of \code{\link{DESeq}}
parallelization only used with \code{normal} or \code{apeglm}}

\item{BPPARAM}{see same argument of \code{\link{DESeq}}}

\item{quiet}{whether to print messages}

\item{...}{arguments passed to \code{apeglm} and \code{ashr}}
}
\value{
a DESeqResults object with the \code{log2FoldChange} and \code{lfcSE}
columns replaced with shrunken LFC and SE.
For consistency with \code{results} (and similar to the output of \code{bayesglm})
the column name \code{lfcSE} is used here, although what is returned is a posterior SD.
For \code{normal} and for \code{apeglm} the estimate is the posterior mode,
for \code{ashr} it is the posterior mean.
\code{priorInfo(res)} contains information about the shrinkage procedure,
relevant to the various methods specified by \code{type}.
}
\description{
Adds shrunken log2 fold changes (LFC) and SE to a
results table from \code{DESeq} run without LFC shrinkage.
For consistency with \code{results}, the column name \code{lfcSE}
is used here although what is returned is a posterior SD.
Three shrinkage estimators for LFC are available via \code{type}
(see the vignette for more details on the estimators).
The apeglm publication demonstrates that 'apeglm' and 'ashr' outperform
the original 'normal' shrinkage estimator.
}
\details{
See vignette for a comparison of shrinkage estimators on an example dataset.
For all shrinkage methods, details on the prior is included in
\code{priorInfo(res)}, including the \code{fitted_g} mixture for ashr.

\strong{For type="apeglm":}
Specifying \code{apeglm} passes along DESeq2 MLE log2
fold changes and standard errors to the \code{apeglm} function
in the apeglm package, and re-estimates posterior LFCs for
the coefficient specified by \code{coef}.

\strong{For type="ashr":}
Specifying \code{ashr} passes along DESeq2 MLE log2
fold changes and standard errors to the \code{ash} function
in the ashr package, 
with arguments \code{mixcompdist="normal"} and \code{method="shrink"}.

\strong{For type="normal":}
For design as a formula, shrinkage cannot be applied
to coefficients in a model with interaction terms. 
For user-supplied model matrices, shrinkage is only
supported via \code{coef}. \code{coef} will make use
of standard model matrices, while \code{contrast}
will make use of expanded model matrices, and for the
latter, a results object should be provided to
\code{res}. With numeric- or list-style contrasts,
it is possible to use \code{lfcShrink}, but likely easier to use
\code{DESeq} with \code{betaPrior=TRUE} followed by \code{results},
because the numeric or list should reference the coefficients
from the expanded model matrix. These coefficients will be printed
to console if 'contrast' is used.
}
\examples{

set.seed(1)
dds <- makeExampleDESeqDataSet(n=500,betaSD=1)
dds <- DESeq(dds)
res <- results(dds)

# these are the coefficients from the model
# we can specify them using 'coef' by name or number below
resultsNames(dds)

res.ape <- lfcShrink(dds=dds, coef=2, type="apeglm")
res.ash <- lfcShrink(dds=dds, coef=2, type="ashr")
res.norm <- lfcShrink(dds=dds, coef=2, type="normal")

}
\references{
Publications for the following shrinkage estimators:

\code{type="apeglm"}:

Zhu, A., Ibrahim, J.G., Love, M.I. (2018) Heavy-tailed prior distributions for
sequence count data: removing the noise and preserving large differences.
Bioinformatics. \url{https://doi.org/10.1093/bioinformatics/bty895}

\code{type="ashr"}:

Stephens, M. (2016) False discovery rates: a new deal.
Biostatistics, 18:2. \url{https://doi.org/10.1093/biostatistics/kxw041}

\code{type="normal"}:

Love, M.I., Huber, W., Anders, S. (2014) Moderated estimation of fold change and
dispersion for RNA-seq data with DESeq2. Genome Biology, 15:550.
\url{https://doi.org/10.1186/s13059-014-0550-8}

Related work, the \code{bayesglm} function in the \code{arm} package:

Gelman, A., Jakulin, A., Pittau, M.G. and Su, Y.-S. (2009).
A Weakly Informative Default Prior Distribution For Logistic And Other Regression Models.
The Annals of Applied Statistics 2:4.
\url{http://www.stat.columbia.edu/~gelman/research/published/ priors11.pdf}
}
