% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxSilhouette.R
\name{approxSilhouette}
\alias{approxSilhouette}
\title{Approximate silhouette width}
\usage{
approxSilhouette(x, clusters)
}
\arguments{
\item{x}{A numeric matrix-like object containing observations in rows and variables in columns.}

\item{clusters}{Vector of length equal to \code{ncol(x)}, specifying the cluster assigned to each observation.}
}
\value{
A \linkS4class{DataFrame} with one row per observation in \code{x} and the columns:
\itemize{
\item \code{cluster}, the assigned cluster for each observation in \code{x}.
\item \code{other}, the closest cluster other than the one to which the current observation is assigned.
\item \code{width}, a numeric field containing the approximate silhouette width of the current cell.
}
Row names are defined as the row names of \code{x}.
}
\description{
Given a clustering, quickly compute an approximate silhouette width for each observation.
}
\details{
The silhouette width is a general-purpose method for evaluating the separation between clusters 
but requires calculating the average distance between pairs of observations within or between clusters.
This function instead approximates the average distance with the root-mean-squared-distance, which can be computed very efficiently for large datasets.
The approximated averages are then used to compute the silhouette width using the usual definition.

% In case you're wondering, here it is. Let O be the current observation.
% - The squared distance to the centroid is (O - Y)^2 where Y = mean(X) for the vector of observations X.
% - The mean of squares within X is mean[(X - Y)^2].
% - Their sum is:
%   (O - Y)^2 + mean[(X - Y)^2] = O^2 - 2OY + Y^2 + mean(X^2) - 2 mean(X) Y + Y^2
%                               = O^2 - 2OY + mean(X^2)
%                               = O^2 - 2OE(X) + mean(X^2)
%                               = mean[(O - X)^2]
%   After which we can just take the square root.
}
\examples{
m <- matrix(rnorm(10000), ncol=10)
clusters <- clusterRows(m, BLUSPARAM=KmeansParam(5))
out <- approxSilhouette(m, clusters)
boxplot(split(out$width, clusters))

# Mocking up a stronger example:
centers <- matrix(rnorm(30), nrow=3)
clusters <- sample(1:3, 1000, replace=TRUE)

y <- centers[clusters,]
y <- y + rnorm(length(y), sd=0.1)

out2 <- approxSilhouette(y, clusters)
boxplot(split(out2$width, clusters))

}
\seealso{
\code{silhouette} from the \pkg{cluster} package, for the exact calculation.

\code{\link{neighborPurity}}, for another method of evaluating cluster separation.
}
\author{
Aaron Lun
}
