// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

import QtQuick 2.15
import QtQuick.Layouts 1.15
import HelperWidgets 2.0
import StudioTheme 1.0 as StudioTheme

Section {
    caption: qsTr("Buffer Input")
    width: parent.width

    SectionLayout {
        PropertyLabel {
            text: qsTr("Buffer")
            tooltip: qsTr("Sets input buffer for a pass.")
        }

        SecondColumnLayout {
            IdComboBox {
                typeFilter: "QtQuick3D.Buffer"
                backendValue: backendValues.buffer
                implicitWidth: StudioTheme.Values.singleControlColumnWidth
                               + StudioTheme.Values.actionIndicatorWidth
            }

            ExpandingSpacer {}
        }

        PropertyLabel {
            text: qsTr("Parameter")
            tooltip: qsTr("Sets buffer input buffer name in the shader.")
        }

        SecondColumnLayout {
            LineEdit {
                backendValue: backendValues.param
                showTranslateCheckBox: false
                implicitWidth: StudioTheme.Values.singleControlColumnWidth
                               + StudioTheme.Values.actionIndicatorWidth
                width: implicitWidth
            }

            ExpandingSpacer {}
        }
    }
}
