#include "myutils.h"
#include "hmmparams.h"

void HMMParams::GetDefaultHMMParams(bool Nucleo, vector<string> &Lines)
	{
	if (Nucleo)
		GetDefaultHMMParams_Nucleo(Lines);
	else
		GetDefaultHMMParams_Amino(Lines);
	}

void HMMParams::GetDefaultHMMParams_Amino(vector<string> &Lines)
	{
	Lines.clear();
#define ADD_STR(s)	Lines.push_back(s);

ADD_STR("HMM	aa")
ADD_STR("T.START_M	0.6")
ADD_STR("T.START_IS	0.02")
ADD_STR("T.START_IL	0.18")
ADD_STR("T.M_M	0.96")
ADD_STR("T.M_IS	0.012")
ADD_STR("T.M_IL	0.008")
ADD_STR("T.IS_IS	0.35")
ADD_STR("T.IS_M	0.65")
ADD_STR("T.IL_IL	0.90")
ADD_STR("T.IL_M	0.10")

ADD_STR("E.AA	0.023731")
ADD_STR("E.CA	0.0014551")
ADD_STR("E.CC	0.010135")
ADD_STR("E.DA	0.0022355")
ADD_STR("E.DC	0.00036798")
ADD_STR("E.DD	0.019112")
ADD_STR("E.EA	0.0033222")
ADD_STR("E.EC	0.00037956")
ADD_STR("E.ED	0.004968")
ADD_STR("E.EE	0.016766")
ADD_STR("E.FA	0.00165")
ADD_STR("E.FC	0.00052274")
ADD_STR("E.FD	0.00069041")
ADD_STR("E.FE	0.00078814")
ADD_STR("E.FF	0.01661")
ADD_STR("E.GA	0.005979")
ADD_STR("E.GC	0.00071206")
ADD_STR("E.GD	0.0023525")
ADD_STR("E.GE	0.0021486")
ADD_STR("E.GF	0.001152")
ADD_STR("E.GG	0.040629")
ADD_STR("E.HA	0.0011435")
ADD_STR("E.HC	0.00026421")
ADD_STR("E.HD	0.00097077")
ADD_STR("E.HE	0.0013177")
ADD_STR("E.HF	0.00072545")
ADD_STR("E.HG	0.001037")
ADD_STR("E.HH	0.00868")
ADD_STR("E.IA	0.0031885")
ADD_STR("E.IC	0.0009404")
ADD_STR("E.ID	0.0010536")
ADD_STR("E.IE	0.0012421")
ADD_STR("E.IF	0.0027995")
ADD_STR("E.IG	0.0014252")
ADD_STR("E.IH	0.00059716")
ADD_STR("E.II	0.017783")
ADD_STR("E.KA	0.0033169")
ADD_STR("E.KC	0.00046951")
ADD_STR("E.KD	0.0025252")
ADD_STR("E.KE	0.0042842")
ADD_STR("E.KF	0.00087222")
ADD_STR("E.KG	0.0025931")
ADD_STR("E.KH	0.0012138")
ADD_STR("E.KI	0.0015785")
ADD_STR("E.KK	0.016122")
ADD_STR("E.LA	0.0044958")
ADD_STR("E.LC	0.0013849")
ADD_STR("E.LD	0.0016197")
ADD_STR("E.LE	0.0022206")
ADD_STR("E.LF	0.0053337")
ADD_STR("E.LG	0.0021285")
ADD_STR("E.LH	0.0011175")
ADD_STR("E.LI	0.010718")
ADD_STR("E.LK	0.0025963")
ADD_STR("E.LL	0.035839")
ADD_STR("E.MA	0.0014888")
ADD_STR("E.MC	0.00037421")
ADD_STR("E.MD	0.00047808")
ADD_STR("E.ME	0.00076105")
ADD_STR("E.MF	0.0011611")
ADD_STR("E.MG	0.00066504")
ADD_STR("E.MH	0.00042237")
ADD_STR("E.MI	0.002241")
ADD_STR("E.MK	0.0009612")
ADD_STR("E.ML	0.0046194")
ADD_STR("E.MM	0.0040952")
ADD_STR("E.NA	0.0021023")
ADD_STR("E.NC	0.00042479")
ADD_STR("E.ND	0.0035354")
ADD_STR("E.NE	0.0022474")
ADD_STR("E.NF	0.00084658")
ADD_STR("E.NG	0.0028888")
ADD_STR("E.NH	0.001412")
ADD_STR("E.NI	0.0010427")
ADD_STR("E.NK	0.0025731")
ADD_STR("E.NL	0.0016028")
ADD_STR("E.NM	0.00063401")
ADD_STR("E.NN	0.012819")
ADD_STR("E.PA	0.0023062")
ADD_STR("E.PC	0.00034766")
ADD_STR("E.PD	0.0012538")
ADD_STR("E.PE	0.0015155")
ADD_STR("E.PF	0.00060701")
ADD_STR("E.PG	0.001556")
ADD_STR("E.PH	0.00049078")
ADD_STR("E.PI	0.0010377")
ADD_STR("E.PK	0.0015484")
ADD_STR("E.PL	0.0015731")
ADD_STR("E.PM	0.00046718")
ADD_STR("E.PN	0.0010028")
ADD_STR("E.PP	0.018461")
ADD_STR("E.QA	0.002191")
ADD_STR("E.QC	0.00032102")
ADD_STR("E.QD	0.0017678")
ADD_STR("E.QE	0.0034513")
ADD_STR("E.QF	0.00059248")
ADD_STR("E.QG	0.0014243")
ADD_STR("E.QH	0.001139")
ADD_STR("E.QI	0.0010088")
ADD_STR("E.QK	0.0031231")
ADD_STR("E.QL	0.0018055")
ADD_STR("E.QM	0.00075546")
ADD_STR("E.QN	0.0015822")
ADD_STR("E.QP	0.00090111")
ADD_STR("E.QQ	0.007566")
ADD_STR("E.RA	0.002445")
ADD_STR("E.RC	0.00044701")
ADD_STR("E.RD	0.0016166")
ADD_STR("E.RE	0.0026887")
ADD_STR("E.RF	0.00090768")
ADD_STR("E.RG	0.0019486")
ADD_STR("E.RH	0.001321")
ADD_STR("E.RI	0.0013814")
ADD_STR("E.RK	0.0059565")
ADD_STR("E.RL	0.0024681")
ADD_STR("E.RM	0.00076734")
ADD_STR("E.RN	0.0020778")
ADD_STR("E.RP	0.0010627")
ADD_STR("E.RQ	0.0025353")
ADD_STR("E.RR	0.017751")
ADD_STR("E.SA	0.0063175")
ADD_STR("E.SC	0.00094867")
ADD_STR("E.SD	0.0028523")
ADD_STR("E.SE	0.002939")
ADD_STR("E.SF	0.0011904")
ADD_STR("E.SG	0.0038196")
ADD_STR("E.SH	0.0011642")
ADD_STR("E.SI	0.0017357")
ADD_STR("E.SK	0.0031263")
ADD_STR("E.SL	0.0025096")
ADD_STR("E.SM	0.00087787")
ADD_STR("E.SN	0.003014")
ADD_STR("E.SP	0.0018004")
ADD_STR("E.SQ	0.0019115")
ADD_STR("E.SR	0.0022454")
ADD_STR("E.SS	0.013466")
ADD_STR("E.TA	0.0039")
ADD_STR("E.TC	0.00073798")
ADD_STR("E.TD	0.0018049")
ADD_STR("E.TE	0.0021676")
ADD_STR("E.TF	0.0010759")
ADD_STR("E.TG	0.0021484")
ADD_STR("E.TH	0.00077747")
ADD_STR("E.TI	0.0024897")
ADD_STR("E.TK	0.0025086")
ADD_STR("E.TL	0.0030227")
ADD_STR("E.TM	0.00093371")
ADD_STR("E.TN	0.0022014")
ADD_STR("E.TP	0.0014798")
ADD_STR("E.TQ	0.0015453")
ADD_STR("E.TR	0.0018605")
ADD_STR("E.TS	0.0048729")
ADD_STR("E.TT	0.012994")
ADD_STR("E.VA	0.0053324")
ADD_STR("E.VC	0.0011915")
ADD_STR("E.VD	0.0012792")
ADD_STR("E.VE	0.001787")
ADD_STR("E.VF	0.0025616")
ADD_STR("E.VG	0.0019458")
ADD_STR("E.VH	0.00071553")
ADD_STR("E.VI	0.01118")
ADD_STR("E.VK	0.002109")
ADD_STR("E.VL	0.0091446")
ADD_STR("E.VM	0.0019746")
ADD_STR("E.VN	0.0013661")
ADD_STR("E.VP	0.0013578")
ADD_STR("E.VQ	0.0013284")
ADD_STR("E.VR	0.0016936")
ADD_STR("E.VS	0.002416")
ADD_STR("E.VT	0.0034345")
ADD_STR("E.VV	0.020752")
ADD_STR("E.WA	0.00039119")
ADD_STR("E.WC	0.00010666")
ADD_STR("E.WD	0.00016015")
ADD_STR("E.WE	0.00023815")
ADD_STR("E.WF	0.00085751")
ADD_STR("E.WG	0.00038786")
ADD_STR("E.WH	0.00019097")
ADD_STR("E.WI	0.00039549")
ADD_STR("E.WK	0.00028448")
ADD_STR("E.WL	0.00076736")
ADD_STR("E.WM	0.00016253")
ADD_STR("E.WN	0.00021006")
ADD_STR("E.WP	0.00015674")
ADD_STR("E.WQ	0.00020592")
ADD_STR("E.WR	0.00029139")
ADD_STR("E.WS	0.00026525")
ADD_STR("E.WT	0.00024961")
ADD_STR("E.WV	0.00038538")
ADD_STR("E.WW	0.0056363")
ADD_STR("E.YA	0.0013184")
ADD_STR("E.YC	0.00036626")
ADD_STR("E.YD	0.00066005")
ADD_STR("E.YE	0.00092548")
ADD_STR("E.YF	0.0036874")
ADD_STR("E.YG	0.00089301")
ADD_STR("E.YH	0.0013104")
ADD_STR("E.YI	0.0012786")
ADD_STR("E.YK	0.0010082")
ADD_STR("E.YL	0.0021971")
ADD_STR("E.YM	0.00054105")
ADD_STR("E.YN	0.0007496")
ADD_STR("E.YP	0.00047608")
ADD_STR("E.YQ	0.00070192")
ADD_STR("E.YR	0.0009943")
ADD_STR("E.YS	0.0010265")
ADD_STR("E.YT	0.00094759")
ADD_STR("E.YV	0.00148")
ADD_STR("E.YW	0.00069226")
ADD_STR("E.YY	0.0099931")

#undef ADD_STR
	}

void HMMParams::GetDefaultHMMParams_Nucleo(vector<string> &Lines)
	{
	Lines.clear();
#define ADD_STR(s)	Lines.push_back(s);

ADD_STR("HMM	nt")
ADD_STR("T.START_M	0.6")
ADD_STR("T.START_IS	0.02")
ADD_STR("T.START_IL	0.18")
ADD_STR("T.M_M	0.96")
ADD_STR("T.M_IS	0.012")
ADD_STR("T.M_IL	0.008")
ADD_STR("T.IS_IS	0.35")
ADD_STR("T.IS_M	0.65")
ADD_STR("T.IL_IL	0.90")
ADD_STR("T.IL_M	0.10")

#define Diag	"0.12"
#define Other	"0.044"

ADD_STR("E.AA	" Diag)

ADD_STR("E.CA	" Other)
ADD_STR("E.CC	" Diag)

ADD_STR("E.GA	" Other)
ADD_STR("E.GC	" Other)
ADD_STR("E.GG	" Diag)

ADD_STR("E.TA	" Other)
ADD_STR("E.TC	" Other)
ADD_STR("E.TG	" Other)
ADD_STR("E.TT	" Diag)

#undef ADD_STR
	}
