// UTILITY.H : many utility functions and classes...

// Copyright (C) 1998 Tommi Hassinen, Geoff Hutchison.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef UTILITY_H
#define UTILITY_H

#include "libghemicaldefine.h"

class superimpose;

/*################################################################################################*/

#include "atom.h"
#include "bond.h"

#include "model.h"

#include "conjgrad.h"

/*################################################################################################*/

/// This class can be used to superimpose coordinate sets.

class superimpose : public conjugate_gradient
{
	protected:
	
	model * mdl;
	
	i32s index[2];
	i32s counter;
	
	f64 value;
	f64 rot[3]; f64 drot[3];
	f64 loc[3]; f64 dloc[3];
	
	public:
	
	superimpose(model *, i32s, i32s);
	~superimpose(void);
	
	f64 GetRMS(void);
	void Compare(const f64 *, const f64 *, bool, f64 * = NULL);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
	
	void Transform(void);
};

/*################################################################################################*/

/**	An utility class (template) to release memory when program closes.
	
	If you have, say a table that you have to create when program starts, 
	and to destroy it when program closes. For example
	
		int * table = new int[100];
	
	The memory will be automatically released if you attach an "cleaner" for it:
	
		int * table = new int[100];
		singleton_cleaner<int> table_cleaner(table);
*/

template<class TYPE1> class singleton_cleaner
{
	private:
	
	TYPE1 * instance;
	
	public:
	
	singleton_cleaner(TYPE1 * p1 = NULL) { instance = p1; }
	~singleton_cleaner(void) { if (instance) delete instance; }
	
	bool SetInstance(TYPE1 * p1) { if (instance) return false; instance = p1; return true; }
};

/*################################################################################################*/

void DefineSecondaryStructure(model *);

f64 HBondEnergy(model *, i32s *, i32s *);
bool TorsionCheck(model *, i32s, i32s *, fGL);

/*################################################################################################*/

#endif	// UTILITY_H

// eof
