/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <QObject>
#include <QList>
#include "core/mpvtypes.h"
#include "global/globalsignal.h"

class PlayList : public QObject
{
    Q_OBJECT
public:
    explicit PlayList(QObject *parent = nullptr);
    void addListFile(QString filePath, QString fileName, int duration);
    void setList(QVector<QPair<QString, QPair<QString, int> > > path_name_vec);
    void setCurrentIndex(int index);

private slots:
    void addDirectory(QString dir);
    void playNext();

signals:

private:
    int m_PlayIndex;                // 当前播放索引
    QString m_playFile;             // 当前播放文件
    PLAYORDER m_play_order;         // 播放顺序
    // <绝对路径，<文件名，秒数>>
//    QVector<QPair<QString, QPair<QString, int> > > m_path_name_vec;
    QStringList m_fileList;         // 该列表排序需要和界面列表中排序一致
    // <绝对路径，<文件名，秒数>>
    QMap<QString, QPair<QString, int> > m_path_name_map;

    void initGlobalSig();
};

#endif // PLAYLIST_H
