; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
;
; RUN: igc_opt --igc-scalarize --opaque-pointers -S < %s | FileCheck %s
; REQUIRES: llvm-14-plus
; ------------------------------------------------
; ScalarizeFunction
; ------------------------------------------------
; The pass should remove redundant vector operations
; ------------------------------------------------

define i32 @basic(i32 %src) {
; CHECK-LABEL: define i32 @basic(
; CHECK-SAME: i32 [[SRC:%.*]]) {
; CHECK-NEXT:    ret i32 [[SRC]]
;
  %vector = insertelement <2 x i32> undef, i32 %src, i32 0
  %result = extractelement <2 x i32> %vector, i32 0
  ret i32 %result
}

define float @should_work_with_different_value_type(float %src) {
; CHECK-LABEL: define float @should_work_with_different_value_type(
; CHECK-SAME: float [[SRC:%.*]]) {
; CHECK-NEXT:    ret float [[SRC]]
;
  %vector = insertelement <2 x float> undef, float %src, i32 0
  %result = extractelement <2 x float> %vector, i32 0
  ret float %result
}

define i32 @should_return_undef(i32 %src) {
; CHECK-LABEL: define i32 @should_return_undef(
; CHECK-SAME: i32 [[SRC:%.*]]) {
; CHECK-NEXT:    ret i32 undef
;
  %vector = insertelement <2 x i32> undef, i32 %src, i32 0
  %result = extractelement <2 x i32> %vector, i32 1
  ret i32 %result
}


define i32 @should_work_with_larger_vector_size() {
; CHECK-LABEL: define i32 @should_work_with_larger_vector_size() {
; CHECK-NEXT:    [[RESULT:%.*]] = add i32 0, 8
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %1 = insertelement <16 x i32> undef, i32 0, i32 0
  %2 = insertelement <16 x i32> %1, i32 1, i32 1
  %3 = insertelement <16 x i32> %2, i32 2, i32 2
  %4 = insertelement <16 x i32> %3, i32 3, i32 3
  %5 = insertelement <16 x i32> %4, i32 4, i32 4
  %6 = insertelement <16 x i32> %5, i32 5, i32 5
  %7 = insertelement <16 x i32> %6, i32 6, i32 6
  %8 = insertelement <16 x i32> %7, i32 7, i32 7
  %9 = insertelement <16 x i32> %8, i32 8, i32 8
  %10 = insertelement <16 x i32> %9, i32 9, i32 9
  %11 = insertelement <16 x i32> %10, i32 10, i32 10
  %12 = insertelement <16 x i32> %11, i32 11, i32 11
  %13 = insertelement <16 x i32> %12, i32 12, i32 12
  %14 = insertelement <16 x i32> %13, i32 13, i32 13
  %15 = insertelement <16 x i32> %14, i32 14, i32 14
  %vector = insertelement <16 x i32> %15, i32 15, i32 15
  %first = extractelement <16 x i32> %vector, i32 0
  %second = extractelement <16 x i32> %vector, i32 8
  %result = add i32 %first, %second
  ret i32 %result
}

define i32 @should_work_with_shuffle_instruction() {
; CHECK-LABEL: define i32 @should_work_with_shuffle_instruction() {
; CHECK-NEXT:    [[RETURN:%.*]] = add i32 1, 7
; CHECK-NEXT:    ret i32 [[RETURN]]
;
  %1 = insertelement <4 x i32> undef, i32 0, i32 0
  %2 = insertelement <4 x i32> %1, i32 1, i32 1
  %3 = insertelement <4 x i32> %2, i32 2, i32 2
  %first_vector = insertelement <4 x i32> %3, i32 3, i32 3

  %4 = insertelement <4 x i32> undef, i32 4, i32 0
  %5 = insertelement <4 x i32> %4, i32 5, i32 1
  %6 = insertelement <4 x i32> %5, i32 6, i32 2
  %second_vector = insertelement <4 x i32> %6, i32 7, i32 3

  %result = shufflevector <4 x i32> %first_vector, <4 x i32> %second_vector, <4 x i32> <i32 1, i32 3, i32 5, i32 7>

  %first = extractelement <4 x i32> %result, i32 0
  %second = extractelement <4 x i32> %result, i32 3
  %return = add i32 %first, %second
  ret i32 %return
}


define i32 @should_not_scalarize_with_index_as_variable(i32 %data, i32 %index) {
; CHECK-LABEL: define i32 @should_not_scalarize_with_index_as_variable(
; CHECK-SAME: i32 [[DATA:%.*]], i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[VECTOR:%.*]] = insertelement <2 x i32> undef, i32 [[DATA]], i32 [[INDEX]]
; CHECK-NEXT:    [[RESULT:%.*]] = extractelement <2 x i32> [[VECTOR]], i32 [[INDEX]]
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %vector = insertelement <2 x i32> undef, i32 %data, i32 %index
  %result = extractelement <2 x i32> %vector, i32 %index
  ret i32 %result
}

define i32 @should_work_with_shuffle_undef() {
; CHECK-LABEL: define i32 @should_work_with_shuffle_undef() {
; CHECK-NEXT:    [[RETURN:%.*]] = add i32 undef, undef
; CHECK-NEXT:    ret i32 [[RETURN]]
;
  %result = shufflevector <4 x i32> undef, <4 x i32> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>

  %first = extractelement <4 x i32> %result, i32 0
  %second = extractelement <4 x i32> %result, i32 3
  %return = add i32 %first, %second
  ret i32 %return
}

define i32 @should_work_with_shuffle_undef_2() {
; CHECK-LABEL: define i32 @should_work_with_shuffle_undef_2() {
; CHECK-NEXT:    [[RETURN:%.*]] = add i32 1, undef
; CHECK-NEXT:    ret i32 [[RETURN]]
;
  %1 = insertelement <4 x i32> undef, i32 0, i32 0
  %2 = insertelement <4 x i32> %1, i32 1, i32 1
  %3 = insertelement <4 x i32> %2, i32 2, i32 2
  %first_vector = insertelement <4 x i32> %3, i32 3, i32 3

  %4 = insertelement <4 x i32> undef, i32 4, i32 0
  %5 = insertelement <4 x i32> %4, i32 5, i32 1
  %6 = insertelement <4 x i32> %5, i32 6, i32 2
  %second_vector = insertelement <4 x i32> %6, i32 7, i32 3

  %result = shufflevector <4 x i32> %first_vector, <4 x i32> %second_vector, <4 x i32> <i32 1, i32 3, i32 5, i32 undef>

  %first = extractelement <4 x i32> %result, i32 0
  %second = extractelement <4 x i32> %result, i32 3
  %return = add i32 %first, %second
  ret i32 %return
}
