//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagecache/armstoragecache/v3"
	"net/http"
	"net/url"
	"regexp"
)

// StorageTargetServer is a fake server for instances of the armstoragecache.StorageTargetClient type.
type StorageTargetServer struct {
	// BeginFlush is the fake for method StorageTargetClient.BeginFlush
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginFlush func(ctx context.Context, resourceGroupName string, cacheName string, storageTargetName string, options *armstoragecache.StorageTargetClientBeginFlushOptions) (resp azfake.PollerResponder[armstoragecache.StorageTargetClientFlushResponse], errResp azfake.ErrorResponder)

	// BeginInvalidate is the fake for method StorageTargetClient.BeginInvalidate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginInvalidate func(ctx context.Context, resourceGroupName string, cacheName string, storageTargetName string, options *armstoragecache.StorageTargetClientBeginInvalidateOptions) (resp azfake.PollerResponder[armstoragecache.StorageTargetClientInvalidateResponse], errResp azfake.ErrorResponder)

	// BeginResume is the fake for method StorageTargetClient.BeginResume
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginResume func(ctx context.Context, resourceGroupName string, cacheName string, storageTargetName string, options *armstoragecache.StorageTargetClientBeginResumeOptions) (resp azfake.PollerResponder[armstoragecache.StorageTargetClientResumeResponse], errResp azfake.ErrorResponder)

	// BeginSuspend is the fake for method StorageTargetClient.BeginSuspend
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginSuspend func(ctx context.Context, resourceGroupName string, cacheName string, storageTargetName string, options *armstoragecache.StorageTargetClientBeginSuspendOptions) (resp azfake.PollerResponder[armstoragecache.StorageTargetClientSuspendResponse], errResp azfake.ErrorResponder)
}

// NewStorageTargetServerTransport creates a new instance of StorageTargetServerTransport with the provided implementation.
// The returned StorageTargetServerTransport instance is connected to an instance of armstoragecache.StorageTargetClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStorageTargetServerTransport(srv *StorageTargetServer) *StorageTargetServerTransport {
	return &StorageTargetServerTransport{
		srv:             srv,
		beginFlush:      newTracker[azfake.PollerResponder[armstoragecache.StorageTargetClientFlushResponse]](),
		beginInvalidate: newTracker[azfake.PollerResponder[armstoragecache.StorageTargetClientInvalidateResponse]](),
		beginResume:     newTracker[azfake.PollerResponder[armstoragecache.StorageTargetClientResumeResponse]](),
		beginSuspend:    newTracker[azfake.PollerResponder[armstoragecache.StorageTargetClientSuspendResponse]](),
	}
}

// StorageTargetServerTransport connects instances of armstoragecache.StorageTargetClient to instances of StorageTargetServer.
// Don't use this type directly, use NewStorageTargetServerTransport instead.
type StorageTargetServerTransport struct {
	srv             *StorageTargetServer
	beginFlush      *tracker[azfake.PollerResponder[armstoragecache.StorageTargetClientFlushResponse]]
	beginInvalidate *tracker[azfake.PollerResponder[armstoragecache.StorageTargetClientInvalidateResponse]]
	beginResume     *tracker[azfake.PollerResponder[armstoragecache.StorageTargetClientResumeResponse]]
	beginSuspend    *tracker[azfake.PollerResponder[armstoragecache.StorageTargetClientSuspendResponse]]
}

// Do implements the policy.Transporter interface for StorageTargetServerTransport.
func (s *StorageTargetServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StorageTargetClient.BeginFlush":
		resp, err = s.dispatchBeginFlush(req)
	case "StorageTargetClient.BeginInvalidate":
		resp, err = s.dispatchBeginInvalidate(req)
	case "StorageTargetClient.BeginResume":
		resp, err = s.dispatchBeginResume(req)
	case "StorageTargetClient.BeginSuspend":
		resp, err = s.dispatchBeginSuspend(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StorageTargetServerTransport) dispatchBeginFlush(req *http.Request) (*http.Response, error) {
	if s.srv.BeginFlush == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFlush not implemented")}
	}
	beginFlush := s.beginFlush.get(req)
	if beginFlush == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageTargets/(?P<storageTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/flush`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		storageTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginFlush(req.Context(), resourceGroupNameParam, cacheNameParam, storageTargetNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFlush = &respr
		s.beginFlush.add(req, beginFlush)
	}

	resp, err := server.PollerResponderNext(beginFlush, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginFlush.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFlush) {
		s.beginFlush.remove(req)
	}

	return resp, nil
}

func (s *StorageTargetServerTransport) dispatchBeginInvalidate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginInvalidate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInvalidate not implemented")}
	}
	beginInvalidate := s.beginInvalidate.get(req)
	if beginInvalidate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageTargets/(?P<storageTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invalidate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		storageTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginInvalidate(req.Context(), resourceGroupNameParam, cacheNameParam, storageTargetNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInvalidate = &respr
		s.beginInvalidate.add(req, beginInvalidate)
	}

	resp, err := server.PollerResponderNext(beginInvalidate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginInvalidate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInvalidate) {
		s.beginInvalidate.remove(req)
	}

	return resp, nil
}

func (s *StorageTargetServerTransport) dispatchBeginResume(req *http.Request) (*http.Response, error) {
	if s.srv.BeginResume == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResume not implemented")}
	}
	beginResume := s.beginResume.get(req)
	if beginResume == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageTargets/(?P<storageTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resume`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		storageTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginResume(req.Context(), resourceGroupNameParam, cacheNameParam, storageTargetNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResume = &respr
		s.beginResume.add(req, beginResume)
	}

	resp, err := server.PollerResponderNext(beginResume, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginResume.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResume) {
		s.beginResume.remove(req)
	}

	return resp, nil
}

func (s *StorageTargetServerTransport) dispatchBeginSuspend(req *http.Request) (*http.Response, error) {
	if s.srv.BeginSuspend == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSuspend not implemented")}
	}
	beginSuspend := s.beginSuspend.get(req)
	if beginSuspend == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/caches/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageTargets/(?P<storageTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suspend`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		storageTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginSuspend(req.Context(), resourceGroupNameParam, cacheNameParam, storageTargetNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSuspend = &respr
		s.beginSuspend.add(req, beginSuspend)
	}

	resp, err := server.PollerResponderNext(beginSuspend, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginSuspend.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSuspend) {
		s.beginSuspend.remove(req)
	}

	return resp, nil
}
