//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatabricks_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databricks/armdatabricks"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceGet.json
func ExampleWorkspacesClient_Get_getAWorkspace() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Get(ctx, "rg", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceManagedDiskEncryptionGet.json
func ExampleWorkspacesClient_Get_getAWorkspaceWithCustomerManagedKeyCmkEncryptionForManagedDisks() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Get(ctx, "rg", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG/providers/Microsoft.Compute/diskEncryptionSets/myDiskEncryptionSet"),
	// 		Encryption: &armdatabricks.WorkspacePropertiesEncryption{
	// 			Entities: &armdatabricks.EncryptionEntitiesDefinition{
	// 				ManagedDisk: &armdatabricks.ManagedDiskEncryption{
	// 					KeySource: to.Ptr(armdatabricks.EncryptionKeySourceMicrosoftKeyvault),
	// 					KeyVaultProperties: &armdatabricks.ManagedDiskEncryptionKeyVaultProperties{
	// 						KeyName: to.Ptr("test-cmk-key"),
	// 						KeyVaultURI: to.Ptr("https://test-vault-name.vault.azure.net/"),
	// 						KeyVersion: to.Ptr("00000000000000000000000000000000"),
	// 					},
	// 					RotationToLatestKeyVersionEnabled: to.Ptr(true),
	// 				},
	// 			},
	// 		},
	// 		ManagedDiskIdentity: &armdatabricks.ManagedIdentityConfiguration{
	// 			Type: to.Ptr("SystemAssigned"),
	// 			PrincipalID: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			TenantID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 		},
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceGetParameters.json
func ExampleWorkspacesClient_Get_getAWorkspaceWithCustomParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Get(ctx, "rg", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		Parameters: &armdatabricks.WorkspaceCustomParameters{
	// 			CustomPrivateSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("PrivateBob"),
	// 			},
	// 			CustomPublicSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("PublicSarah"),
	// 			},
	// 			CustomVirtualNetworkID: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
	// 			},
	// 		},
	// 		PrivateEndpointConnections: []*armdatabricks.PrivateEndpointConnection{
	// 			{
	// 				Name: to.Ptr("myWorkspace.23456789-1111-1111-1111-111111111111"),
	// 				Type: to.Ptr("Microsoft.Databricks/workspaces/privateEndpointConnections"),
	// 				ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace/privateEndpointConnections/myWorkspace.23456789-1111-1111-1111-111111111111"),
	// 				Properties: &armdatabricks.PrivateEndpointConnectionProperties{
	// 					PrivateEndpoint: &armdatabricks.PrivateEndpoint{
	// 						ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/networkResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 					},
	// 					PrivateLinkServiceConnectionState: &armdatabricks.PrivateLinkServiceConnectionState{
	// 						Description: to.Ptr("Auto-Approved"),
	// 						ActionsRequired: to.Ptr("None"),
	// 						Status: to.Ptr(armdatabricks.PrivateLinkServiceConnectionStatusApproved),
	// 					},
	// 					ProvisioningState: to.Ptr(armdatabricks.PrivateEndpointConnectionProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdatabricks.PublicNetworkAccessDisabled),
	// 		RequiredNsgRules: to.Ptr(armdatabricks.RequiredNsgRulesNoAzureDatabricksRules),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceDelete.json
func ExampleWorkspacesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginDelete(ctx, "rg", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/PrepareEncryption.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_createAWorkspaceWhichIsReadyForCustomerManagedKeyCmkEncryption() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Properties: &armdatabricks.WorkspaceProperties{
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
			Parameters: &armdatabricks.WorkspaceCustomParameters{
				PrepareEncryption: &armdatabricks.WorkspaceCustomBooleanParameter{
					Value: to.Ptr(true),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		StorageAccountIdentity: &armdatabricks.ManagedIdentityConfiguration{
	// 			Type: to.Ptr("SystemAssigned"),
	// 			PrincipalID: to.Ptr("55555555-5555-5555-5555-555555555555"),
	// 			TenantID: to.Ptr("66666666-6666-6666-6666-666666666666"),
	// 		},
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceManagedDiskEncryptionCreate.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_createAWorkspaceWithCustomerManagedKeyCmkEncryptionForManagedDisks() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Properties: &armdatabricks.WorkspaceProperties{
			Encryption: &armdatabricks.WorkspacePropertiesEncryption{
				Entities: &armdatabricks.EncryptionEntitiesDefinition{
					ManagedDisk: &armdatabricks.ManagedDiskEncryption{
						KeySource: to.Ptr(armdatabricks.EncryptionKeySourceMicrosoftKeyvault),
						KeyVaultProperties: &armdatabricks.ManagedDiskEncryptionKeyVaultProperties{
							KeyName:     to.Ptr("test-cmk-key"),
							KeyVaultURI: to.Ptr("https://test-vault-name.vault.azure.net/"),
							KeyVersion:  to.Ptr("00000000000000000000000000000000"),
						},
						RotationToLatestKeyVersionEnabled: to.Ptr(true),
					},
				},
			},
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG/providers/Microsoft.Compute/diskEncryptionSets/myDiskEncryptionSet"),
	// 		Encryption: &armdatabricks.WorkspacePropertiesEncryption{
	// 			Entities: &armdatabricks.EncryptionEntitiesDefinition{
	// 				ManagedDisk: &armdatabricks.ManagedDiskEncryption{
	// 					KeySource: to.Ptr(armdatabricks.EncryptionKeySourceMicrosoftKeyvault),
	// 					KeyVaultProperties: &armdatabricks.ManagedDiskEncryptionKeyVaultProperties{
	// 						KeyName: to.Ptr("test-cmk-key"),
	// 						KeyVaultURI: to.Ptr("https://test-vault-name.vault.azure.net/"),
	// 						KeyVersion: to.Ptr("00000000000000000000000000000000"),
	// 					},
	// 					RotationToLatestKeyVersionEnabled: to.Ptr(true),
	// 				},
	// 			},
	// 		},
	// 		ManagedDiskIdentity: &armdatabricks.ManagedIdentityConfiguration{
	// 			Type: to.Ptr("SystemAssigned"),
	// 			PrincipalID: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			TenantID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 		},
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceCreate.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_createOrUpdateWorkspace() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Properties: &armdatabricks.WorkspaceProperties{
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceCreateWithParameters.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_createOrUpdateWorkspaceWithCustomParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Properties: &armdatabricks.WorkspaceProperties{
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
			Parameters: &armdatabricks.WorkspaceCustomParameters{
				CustomPrivateSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
					Value: to.Ptr("myPrivateSubnet"),
				},
				CustomPublicSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
					Value: to.Ptr("myPublicSubnet"),
				},
				CustomVirtualNetworkID: &armdatabricks.WorkspaceCustomStringParameter{
					Value: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		Parameters: &armdatabricks.WorkspaceCustomParameters{
	// 			CustomPrivateSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("myPrivateSubnet"),
	// 			},
	// 			CustomPublicSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("myPublicSubnet"),
	// 			},
	// 			CustomVirtualNetworkID: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/EnableEncryption.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_enableCustomerManagedKeyCmkEncryptionOnAWorkspaceWhichIsPreparedForEncryption() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Properties: &armdatabricks.WorkspaceProperties{
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
			Parameters: &armdatabricks.WorkspaceCustomParameters{
				Encryption: &armdatabricks.WorkspaceEncryptionParameter{
					Value: &armdatabricks.Encryption{
						KeyName:     to.Ptr("myKeyName"),
						KeySource:   to.Ptr(armdatabricks.KeySourceMicrosoftKeyvault),
						KeyVaultURI: to.Ptr("https://myKeyVault.vault.azure.net/"),
						KeyVersion:  to.Ptr("00000000000000000000000000000000"),
					},
				},
				PrepareEncryption: &armdatabricks.WorkspaceCustomBooleanParameter{
					Value: to.Ptr(true),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		Parameters: &armdatabricks.WorkspaceCustomParameters{
	// 			CustomPrivateSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("PrivateBob"),
	// 			},
	// 			CustomPublicSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("PublicSarah"),
	// 			},
	// 			CustomVirtualNetworkID: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
	// 			},
	// 			Encryption: &armdatabricks.WorkspaceEncryptionParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeObject),
	// 				Value: &armdatabricks.Encryption{
	// 					KeyName: to.Ptr("myKeyName"),
	// 					KeySource: to.Ptr(armdatabricks.KeySourceMicrosoftKeyvault),
	// 					KeyVaultURI: to.Ptr("https://myKeyVault.vault.azure.net/"),
	// 					KeyVersion: to.Ptr("00000000000000000000000000000000"),
	// 				},
	// 			},
	// 			PrepareEncryption: &armdatabricks.WorkspaceCustomBooleanParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeBool),
	// 				Value: to.Ptr(true),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		StorageAccountIdentity: &armdatabricks.ManagedIdentityConfiguration{
	// 			Type: to.Ptr("SystemAssigned"),
	// 			PrincipalID: to.Ptr("55555555-5555-5555-5555-555555555555"),
	// 			TenantID: to.Ptr("66666666-6666-6666-6666-666666666666"),
	// 		},
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/DisableEncryption.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_revertCustomerManagedKeyCmkEncryptionToMicrosoftManagedKeysEncryptionOnAWorkspace() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Properties: &armdatabricks.WorkspaceProperties{
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
			Parameters: &armdatabricks.WorkspaceCustomParameters{
				Encryption: &armdatabricks.WorkspaceEncryptionParameter{
					Value: &armdatabricks.Encryption{
						KeySource: to.Ptr(armdatabricks.KeySourceDefault),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		Parameters: &armdatabricks.WorkspaceCustomParameters{
	// 			CustomPrivateSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("PrivateBob"),
	// 			},
	// 			CustomPublicSubnetName: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("PublicSarah"),
	// 			},
	// 			CustomVirtualNetworkID: &armdatabricks.WorkspaceCustomStringParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeString),
	// 				Value: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
	// 			},
	// 			Encryption: &armdatabricks.WorkspaceEncryptionParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeObject),
	// 				Value: &armdatabricks.Encryption{
	// 					KeySource: to.Ptr(armdatabricks.KeySourceDefault),
	// 				},
	// 			},
	// 			PrepareEncryption: &armdatabricks.WorkspaceCustomBooleanParameter{
	// 				Type: to.Ptr(armdatabricks.CustomParameterTypeBool),
	// 				Value: to.Ptr(true),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		StorageAccountIdentity: &armdatabricks.ManagedIdentityConfiguration{
	// 			Type: to.Ptr("SystemAssigned"),
	// 			PrincipalID: to.Ptr("55555555-5555-5555-5555-555555555555"),
	// 			TenantID: to.Ptr("66666666-6666-6666-6666-666666666666"),
	// 		},
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("5555555555555555"),
	// 		WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceManagedDiskEncryptionUpdate.json
func ExampleWorkspacesClient_BeginCreateOrUpdate_updateAWorkspaceWithCustomerManagedKeyCmkEncryptionForManagedDisks() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "rg", "myWorkspace", armdatabricks.Workspace{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"mytag1": to.Ptr("myvalue1"),
		},
		Properties: &armdatabricks.WorkspaceProperties{
			Encryption: &armdatabricks.WorkspacePropertiesEncryption{
				Entities: &armdatabricks.EncryptionEntitiesDefinition{
					ManagedDisk: &armdatabricks.ManagedDiskEncryption{
						KeySource: to.Ptr(armdatabricks.EncryptionKeySourceMicrosoftKeyvault),
						KeyVaultProperties: &armdatabricks.ManagedDiskEncryptionKeyVaultProperties{
							KeyName:     to.Ptr("test-cmk-key"),
							KeyVaultURI: to.Ptr("https://test-vault-name.vault.azure.net/"),
							KeyVersion:  to.Ptr("00000000000000000000000000000000"),
						},
						RotationToLatestKeyVersionEnabled: to.Ptr(true),
					},
				},
			},
			ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Tags: map[string]*string{
	// 		"mytag1": to.Ptr("myvalue1"),
	// 	},
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG/providers/Microsoft.Compute/diskEncryptionSets/myDiskEncryptionSet"),
	// 		Encryption: &armdatabricks.WorkspacePropertiesEncryption{
	// 			Entities: &armdatabricks.EncryptionEntitiesDefinition{
	// 				ManagedDisk: &armdatabricks.ManagedDiskEncryption{
	// 					KeySource: to.Ptr(armdatabricks.EncryptionKeySourceMicrosoftKeyvault),
	// 					KeyVaultProperties: &armdatabricks.ManagedDiskEncryptionKeyVaultProperties{
	// 						KeyName: to.Ptr("test-cmk-key"),
	// 						KeyVaultURI: to.Ptr("https://test-vault-name.vault.azure.net/"),
	// 						KeyVersion: to.Ptr("00000000000000000000000000000000"),
	// 					},
	// 					RotationToLatestKeyVersionEnabled: to.Ptr(true),
	// 				},
	// 			},
	// 		},
	// 		ManagedDiskIdentity: &armdatabricks.ManagedIdentityConfiguration{
	// 			Type: to.Ptr("SystemAssigned"),
	// 			PrincipalID: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			TenantID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 		},
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("6666666666666666"),
	// 		WorkspaceURL: to.Ptr("adb-6666666666666666.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspaceUpdate.json
func ExampleWorkspacesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginUpdate(ctx, "rg", "myWorkspace", armdatabricks.WorkspaceUpdate{
		Tags: map[string]*string{
			"mytag1": to.Ptr("myvalue1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armdatabricks.Workspace{
	// 	Type: to.Ptr("Microsoft.Databricks/workspaces"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace"),
	// 	Location: to.Ptr("East US 2"),
	// 	Tags: map[string]*string{
	// 		"mytag1": to.Ptr("myvalue1"),
	// 	},
	// 	Properties: &armdatabricks.WorkspaceProperties{
	// 		Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
	// 			{
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 		}},
	// 		CreatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
	// 		ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
	// 		ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
	// 		UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
	// 		UpdatedBy: &armdatabricks.CreatedBy{
	// 			ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
	// 			Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
	// 			Puid: to.Ptr("33333333"),
	// 		},
	// 		WorkspaceID: to.Ptr("6666666666666666"),
	// 		WorkspaceURL: to.Ptr("adb-6666666666666666.19.azuredatabricks.net"),
	// 	},
	// 	SKU: &armdatabricks.SKU{
	// 		Name: to.Ptr("premium"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspacesListByResourceGroup.json
func ExampleWorkspacesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListByResourceGroupPager("rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceListResult = armdatabricks.WorkspaceListResult{
		// 	Value: []*armdatabricks.Workspace{
		// 		{
		// 			Name: to.Ptr("myWorkspace1"),
		// 			Type: to.Ptr("Microsoft.Databricks/workspaces"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace1"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armdatabricks.WorkspaceProperties{
		// 				Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
		// 					{
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 				}},
		// 				CreatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
		// 				ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		// 				ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
		// 				UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
		// 				UpdatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				WorkspaceID: to.Ptr("5555555555555555"),
		// 				WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
		// 			},
		// 			SKU: &armdatabricks.SKU{
		// 				Name: to.Ptr("premium"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myWorkspace2"),
		// 			Type: to.Ptr("Microsoft.Databricks/workspaces"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace2"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armdatabricks.WorkspaceProperties{
		// 				Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
		// 					{
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 				}},
		// 				CreatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
		// 				ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		// 				ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
		// 				UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
		// 				UpdatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				WorkspaceID: to.Ptr("6666666666666666"),
		// 				WorkspaceURL: to.Ptr("adb-6666666666666666.19.azuredatabricks.net"),
		// 			},
		// 			SKU: &armdatabricks.SKU{
		// 				Name: to.Ptr("standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e1a87e1a5deb3f986ea1474d233d6680f1e19fc1/specification/databricks/resource-manager/Microsoft.Databricks/stable/2023-02-01/examples/WorkspacesListBySubscription.json
func ExampleWorkspacesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabricks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceListResult = armdatabricks.WorkspaceListResult{
		// 	Value: []*armdatabricks.Workspace{
		// 		{
		// 			Name: to.Ptr("myWorkspace1"),
		// 			Type: to.Ptr("Microsoft.Databricks/workspaces"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace1"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armdatabricks.WorkspaceProperties{
		// 				Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
		// 					{
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 				}},
		// 				CreatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
		// 				ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		// 				ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
		// 				UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
		// 				UpdatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				WorkspaceID: to.Ptr("5555555555555555"),
		// 				WorkspaceURL: to.Ptr("adb-5555555555555555.19.azuredatabricks.net"),
		// 			},
		// 			SKU: &armdatabricks.SKU{
		// 				Name: to.Ptr("premium"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myWorkspace2"),
		// 			Type: to.Ptr("Microsoft.Databricks/workspaces"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Databricks/workspaces/myWorkspace2"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armdatabricks.WorkspaceProperties{
		// 				Authorizations: []*armdatabricks.WorkspaceProviderAuthorization{
		// 					{
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						RoleDefinitionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 				}},
		// 				CreatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-20T00:10:29.285Z"); return t}()),
		// 				ManagedResourceGroupID: to.Ptr("/subscriptions/subid/resourceGroups/myManagedRG"),
		// 				ProvisioningState: to.Ptr(armdatabricks.ProvisioningStateSucceeded),
		// 				UIDefinitionURI: to.Ptr("https://path/to/workspaceCreateUiDefinition.json"),
		// 				UpdatedBy: &armdatabricks.CreatedBy{
		// 					ApplicationID: to.Ptr("44444444-4444-4444-4444-444444444444"),
		// 					Oid: to.Ptr("22222222-2222-2222-2222-222222222222"),
		// 					Puid: to.Ptr("33333333"),
		// 				},
		// 				WorkspaceID: to.Ptr("6666666666666666"),
		// 				WorkspaceURL: to.Ptr("adb-6666666666666666.19.azuredatabricks.net"),
		// 			},
		// 			SKU: &armdatabricks.SKU{
		// 				Name: to.Ptr("standard"),
		// 			},
		// 	}},
		// }
	}
}
