// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes an existing export job. Poll job descriptions after a job starts to
// know the status of the job. When a job succeeds, a URL is provided to download
// the exported assets' data from. Download URLs are valid for five minutes after
// they are generated. You can call the DescribeAssetBundleExportJob API for a new
// download URL as needed. Job descriptions are available for 14 days after the job
// starts.
func (c *Client) DescribeAssetBundleExportJob(ctx context.Context, params *DescribeAssetBundleExportJobInput, optFns ...func(*Options)) (*DescribeAssetBundleExportJobOutput, error) {
	if params == nil {
		params = &DescribeAssetBundleExportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAssetBundleExportJob", params, optFns, c.addOperationDescribeAssetBundleExportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAssetBundleExportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAssetBundleExportJobInput struct {

	// The ID of the job that you want described. The job ID is set when you start a
	// new job with a StartAssetBundleExportJob API call.
	//
	// This member is required.
	AssetBundleExportJobId *string

	// The ID of the Amazon Web Services account the export job is executed in.
	//
	// This member is required.
	AwsAccountId *string

	noSmithyDocumentSerde
}

type DescribeAssetBundleExportJobOutput struct {

	// The Amazon Resource Name (ARN) for the export job.
	Arn *string

	// The ID of the job. The job ID is set when you start a new job with a
	// StartAssetBundleExportJob API call.
	AssetBundleExportJobId *string

	// The ID of the Amazon Web Services account that the export job was executed in.
	AwsAccountId *string

	// The CloudFormation override property configuration for the export job.
	CloudFormationOverridePropertyConfiguration *types.AssetBundleCloudFormationOverridePropertyConfiguration

	// The time that the export job was created.
	CreatedTime *time.Time

	// The URL to download the exported asset bundle data from. This URL is available
	// only after the job has succeeded. This URL is valid for 5 minutes after
	// issuance. Call DescribeAssetBundleExportJob again for a fresh URL if needed.
	// The downloaded asset bundle is a zip file named assetbundle-{jobId}.qs . The
	// file has a .qs extension. This URL can't be used in a StartAssetBundleImportJob
	// API call and should only be used for download purposes.
	DownloadUrl *string

	// An array of error records that describes any failures that occurred during the
	// export job processing. Error records accumulate while the job runs. The complete
	// set of error records is available after the job has completed and failed.
	Errors []types.AssetBundleExportJobError

	// The format of the exported asset bundle. A QUICKSIGHT_JSON formatted file can
	// be used to make a StartAssetBundleImportJob API call. A CLOUDFORMATION_JSON
	// formatted file can be used in the CloudFormation console and with the
	// CloudFormation APIs.
	ExportFormat types.AssetBundleExportFormat

	// The include dependencies flag.
	IncludeAllDependencies bool

	// The include permissions flag.
	IncludePermissions bool

	// The include tags flag.
	IncludeTags bool

	// Indicates the status of a job through its queuing and execution. Poll this
	// DescribeAssetBundleExportApi until JobStatus is either SUCCESSFUL or FAILED .
	JobStatus types.AssetBundleExportJobStatus

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// A list of resource ARNs that exported with the job.
	ResourceArns []string

	// The HTTP status of the response.
	Status int32

	// The validation strategy that is used to export the analysis or dashboard.
	ValidationStrategy *types.AssetBundleExportJobValidationStrategy

	// An array of warning records that describe the analysis or dashboard that is
	// exported. This array includes UI errors that can be skipped during the
	// validation process. This property only appears if StrictModeForAllResources in
	// ValidationStrategy is set to FALSE .
	Warnings []types.AssetBundleExportJobWarning

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAssetBundleExportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeAssetBundleExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeAssetBundleExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAssetBundleExportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeAssetBundleExportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAssetBundleExportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeAssetBundleExportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAssetBundleExportJob",
	}
}
