// Code generated by smithy-go-codegen DO NOT EDIT.

package ssm

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// ServiceSetting is an account-level setting for an Amazon Web Services service.
// This setting defines how a user interacts with or uses a service or a feature of
// a service. For example, if an Amazon Web Services service charges money to the
// account based on feature or service usage, then the Amazon Web Services service
// team might create a default setting of "false". This means the user can't use
// this feature unless they change the setting to "true" and intentionally opt in
// for a paid feature. Services map a SettingId object to a setting value. Amazon
// Web Services services teams define the default value for a SettingId. You can't
// create a new SettingId, but you can overwrite the default value if you have the
// ssm:UpdateServiceSetting permission for the setting. Use the GetServiceSetting
// API operation to view the current value. Or, use the ResetServiceSetting to
// change the value back to the original value defined by the Amazon Web Services
// service team. Update the service setting for the account.
func (c *Client) UpdateServiceSetting(ctx context.Context, params *UpdateServiceSettingInput, optFns ...func(*Options)) (*UpdateServiceSettingOutput, error) {
	if params == nil {
		params = &UpdateServiceSettingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateServiceSetting", params, optFns, c.addOperationUpdateServiceSettingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateServiceSettingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request body of the UpdateServiceSetting API operation.
type UpdateServiceSettingInput struct {

	// The Amazon Resource Name (ARN) of the service setting to reset. For example,
	// arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled.
	// The setting ID can be one of the following.
	//
	// *
	// /ssm/automation/customer-script-log-destination
	//
	// *
	// /ssm/automation/customer-script-log-group-name
	//
	// *
	// /ssm/documents/console/public-sharing-permission
	//
	// *
	// /ssm/managed-instance/activation-tier
	//
	// * /ssm/opsinsights/opscenter
	//
	// *
	// /ssm/parameter-store/default-parameter-tier
	//
	// *
	// /ssm/parameter-store/high-throughput-enabled
	//
	// This member is required.
	SettingId *string

	// The new value to specify for the service setting. The following list specifies
	// the available values for each setting.
	//
	// *
	// /ssm/automation/customer-script-log-destination: CloudWatch
	//
	// *
	// /ssm/automation/customer-script-log-group-name: the name of an Amazon CloudWatch
	// Logs log group
	//
	// * /ssm/documents/console/public-sharing-permission: Enable or
	// Disable
	//
	// * /ssm/managed-instance/activation-tier: standard or advanced
	//
	// *
	// /ssm/opsinsights/opscenter: Enabled or Disabled
	//
	// *
	// /ssm/parameter-store/default-parameter-tier: Standard, Advanced,
	// Intelligent-Tiering
	//
	// * /ssm/parameter-store/high-throughput-enabled: true or
	// false
	//
	// This member is required.
	SettingValue *string

	noSmithyDocumentSerde
}

// The result body of the UpdateServiceSetting API operation.
type UpdateServiceSettingOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateServiceSettingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateServiceSetting{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateServiceSetting{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateServiceSettingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateServiceSetting(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateServiceSetting(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ssm",
		OperationName: "UpdateServiceSetting",
	}
}
