//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation

import "time"

// Account - Definition of the automation account type.
type Account struct {
	// Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// Gets or sets the automation account properties.
	Properties *AccountProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource system metadata.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountClientCreateOrUpdateOptions contains the optional parameters for the AccountClient.CreateOrUpdate method.
type AccountClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccountClientDeleteOptions contains the optional parameters for the AccountClient.Delete method.
type AccountClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountClientGetOptions contains the optional parameters for the AccountClient.Get method.
type AccountClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountClientListByResourceGroupOptions contains the optional parameters for the AccountClient.ListByResourceGroup method.
type AccountClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountClientListOptions contains the optional parameters for the AccountClient.List method.
type AccountClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountClientUpdateOptions contains the optional parameters for the AccountClient.Update method.
type AccountClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccountCreateOrUpdateParameters - The parameters supplied to the create or update automation account operation.
type AccountCreateOrUpdateParameters struct {
	// Sets the identity property for automation account
	Identity *Identity `json:"identity,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets account create or update properties.
	Properties *AccountCreateOrUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountCreateOrUpdateProperties - The parameters supplied to the create or update account properties.
type AccountCreateOrUpdateProperties struct {
	// Indicates whether requests using non-AAD authentication are blocked
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Set the encryption properties for the automation account
	Encryption *EncryptionProperties `json:"encryption,omitempty"`

	// Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
	PublicNetworkAccess *bool `json:"publicNetworkAccess,omitempty"`

	// Gets or sets account SKU.
	SKU *SKU `json:"sku,omitempty"`
}

// AccountListResult - The response model for the list account operation.
type AccountListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets list of accounts.
	Value []*Account `json:"value,omitempty"`
}

// AccountProperties - Definition of the account property.
type AccountProperties struct {
	// URL of automation hybrid service which is used for hybrid worker on-boarding.
	AutomationHybridServiceURL *string `json:"automationHybridServiceUrl,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Indicates whether requests using non-AAD authentication are blocked
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Encryption properties for the automation account
	Encryption *EncryptionProperties `json:"encryption,omitempty"`

	// Gets or sets the last modified by.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// List of Automation operations supported by the Automation resource provider.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
	PublicNetworkAccess *bool `json:"publicNetworkAccess,omitempty"`

	// Gets or sets the SKU of account.
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets status of account.
	State *AutomationAccountState `json:"state,omitempty" azure:"ro"`
}

// AccountUpdateParameters - The parameters supplied to the update automation account operation.
type AccountUpdateParameters struct {
	// Sets the identity property for automation account
	Identity *Identity `json:"identity,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets account update properties.
	Properties *AccountUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountUpdateProperties - The parameters supplied to the update account properties.
type AccountUpdateProperties struct {
	// Indicates whether requests using non-AAD authentication are blocked
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Set the encryption properties for the automation account
	Encryption *EncryptionProperties `json:"encryption,omitempty"`

	// Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
	PublicNetworkAccess *bool `json:"publicNetworkAccess,omitempty"`

	// Gets or sets account SKU.
	SKU *SKU `json:"sku,omitempty"`
}

// Activity - Definition of the activity.
type Activity struct {
	// Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`

	// Gets or sets the properties of the activity.
	Properties *ActivityProperties `json:"properties,omitempty"`

	// READ-ONLY; Gets the name of the activity.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// ActivityClientGetOptions contains the optional parameters for the ActivityClient.Get method.
type ActivityClientGetOptions struct {
	// placeholder for future optional parameters
}

// ActivityClientListByModuleOptions contains the optional parameters for the ActivityClient.ListByModule method.
type ActivityClientListByModuleOptions struct {
	// placeholder for future optional parameters
}

// ActivityListResult - The response model for the list activity operation.
type ActivityListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of activities.
	Value []*Activity `json:"value,omitempty"`
}

// ActivityOutputType - Definition of the activity output type.
type ActivityOutputType struct {
	// Gets or sets the name of the activity output type.
	Name *string `json:"name,omitempty"`

	// Gets or sets the type of the activity output type.
	Type *string `json:"type,omitempty"`
}

// ActivityParameter - Definition of the activity parameter.
type ActivityParameter struct {
	// Gets or sets the description of the activity parameter.
	Description *string `json:"description,omitempty"`

	// Gets or sets a Boolean value that indicates true if the parameter is dynamic.
	IsDynamic *bool `json:"isDynamic,omitempty"`

	// Gets or sets a Boolean value that indicates true if the parameter is required. If the value is false, the parameter is
	// optional.
	IsMandatory *bool `json:"isMandatory,omitempty"`

	// Gets or sets the name of the activity parameter.
	Name *string `json:"name,omitempty"`

	// Gets or sets the position of the activity parameter.
	Position *int64 `json:"position,omitempty"`

	// Gets or sets the type of the activity parameter.
	Type *string `json:"type,omitempty"`

	// Gets or sets the validation set of activity parameter.
	ValidationSet []*ActivityParameterValidationSet `json:"validationSet,omitempty"`

	// Gets or sets a Boolean value that indicates true if the parameter can take values from the incoming pipeline objects. This
	// setting is used if the cmdlet must access the complete input object. false
	// indicates that the parameter cannot take values from the complete input object.
	ValueFromPipeline *bool `json:"valueFromPipeline,omitempty"`

	// Gets or sets a Boolean value that indicates true if the parameter can be filled from a property of the incoming pipeline
	// object that has the same name as this parameter. false indicates that the
	// parameter cannot be filled from the incoming pipeline object property with the same name.
	ValueFromPipelineByPropertyName *bool `json:"valueFromPipelineByPropertyName,omitempty"`

	// Gets or sets a Boolean value that indicates true if the cmdlet parameter accepts all the remaining command-line arguments
	// that are associated with this parameter in the form of an array. false if the
	// cmdlet parameter does not accept all the remaining argument values.
	ValueFromRemainingArguments *bool `json:"valueFromRemainingArguments,omitempty"`
}

// ActivityParameterSet - Definition of the activity parameter set.
type ActivityParameterSet struct {
	// Gets or sets the name of the activity parameter set.
	Name *string `json:"name,omitempty"`

	// Gets or sets the parameters of the activity parameter set.
	Parameters []*ActivityParameter `json:"parameters,omitempty"`
}

// ActivityParameterValidationSet - Definition of the activity parameter validation set.
type ActivityParameterValidationSet struct {
	// Gets or sets the name of the activity parameter validation set member.
	MemberValue *string `json:"memberValue,omitempty"`
}

// ActivityProperties - Properties of the activity.
type ActivityProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the user name of the activity.
	Definition *string `json:"definition,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the output types of the activity.
	OutputTypes []*ActivityOutputType `json:"outputTypes,omitempty"`

	// Gets or sets the parameter sets of the activity.
	ParameterSets []*ActivityParameterSet `json:"parameterSets,omitempty"`
}

// AdvancedSchedule - The properties of the create Advanced Schedule.
type AdvancedSchedule struct {
	// Days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays []*int32 `json:"monthDays,omitempty"`

	// Occurrences of days within a month.
	MonthlyOccurrences []*AdvancedScheduleMonthlyOccurrence `json:"monthlyOccurrences,omitempty"`

	// Days of the week that the job should execute on.
	WeekDays []*string `json:"weekDays,omitempty"`
}

// AdvancedScheduleMonthlyOccurrence - The properties of the create advanced schedule monthly occurrence.
type AdvancedScheduleMonthlyOccurrence struct {
	// Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
	Day *ScheduleDay `json:"day,omitempty"`

	// Occurrence of the week within the month. Must be between 1 and 5
	Occurrence *int32 `json:"occurrence,omitempty"`
}

// AgentRegistration - Definition of the agent registration information type.
type AgentRegistration struct {
	// Gets or sets the dsc meta configuration.
	DscMetaConfiguration *string `json:"dscMetaConfiguration,omitempty"`

	// Gets or sets the dsc server endpoint.
	Endpoint *string `json:"endpoint,omitempty"`

	// Gets or sets the id.
	ID *string `json:"id,omitempty"`

	// Gets or sets the agent registration keys.
	Keys *AgentRegistrationKeys `json:"keys,omitempty"`
}

// AgentRegistrationInformationClientGetOptions contains the optional parameters for the AgentRegistrationInformationClient.Get
// method.
type AgentRegistrationInformationClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentRegistrationInformationClientRegenerateKeyOptions contains the optional parameters for the AgentRegistrationInformationClient.RegenerateKey
// method.
type AgentRegistrationInformationClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// AgentRegistrationKeys - Definition of the agent registration keys.
type AgentRegistrationKeys struct {
	// Gets or sets the primary key.
	Primary *string `json:"primary,omitempty"`

	// Gets or sets the secondary key.
	Secondary *string `json:"secondary,omitempty"`
}

// AgentRegistrationRegenerateKeyParameter - The parameters supplied to the regenerate keys operation.
type AgentRegistrationRegenerateKeyParameter struct {
	// REQUIRED; Gets or sets the agent registration key name - primary or secondary.
	KeyName *AgentRegistrationKeyName `json:"keyName,omitempty"`
}

// AzureQueryProperties - Azure query for the update configuration.
type AzureQueryProperties struct {
	// List of locations to scope the query to.
	Locations []*string `json:"locations,omitempty"`

	// List of Subscription or Resource Group ARM Ids.
	Scope []*string `json:"scope,omitempty"`

	// Tag settings for the VM.
	TagSettings *TagSettingsProperties `json:"tagSettings,omitempty"`
}

// Certificate - Definition of the certificate.
type Certificate struct {
	// Gets or sets the properties of the certificate.
	Properties *CertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateClientCreateOrUpdateOptions contains the optional parameters for the CertificateClient.CreateOrUpdate method.
type CertificateClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientDeleteOptions contains the optional parameters for the CertificateClient.Delete method.
type CertificateClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientGetOptions contains the optional parameters for the CertificateClient.Get method.
type CertificateClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientListByAutomationAccountOptions contains the optional parameters for the CertificateClient.ListByAutomationAccount
// method.
type CertificateClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientUpdateOptions contains the optional parameters for the CertificateClient.Update method.
type CertificateClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CertificateCreateOrUpdateParameters - The parameters supplied to the create or update or replace certificate operation.
type CertificateCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the certificate.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the properties of the certificate.
	Properties *CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
}

// CertificateCreateOrUpdateProperties - The properties of the create certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the base64 encoded value of the certificate.
	Base64Value *string `json:"base64Value,omitempty"`

	// Gets or sets the description of the certificate.
	Description *string `json:"description,omitempty"`

	// Gets or sets the is exportable flag of the certificate.
	IsExportable *bool `json:"isExportable,omitempty"`

	// Gets or sets the thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// CertificateListResult - The response model for the list certificate operation.
type CertificateListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of certificates.
	Value []*Certificate `json:"value,omitempty"`
}

// CertificateProperties - Properties of the certificate.
type CertificateProperties struct {
	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the expiry time of the certificate.
	ExpiryTime *time.Time `json:"expiryTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the is exportable flag of the certificate.
	IsExportable *bool `json:"isExportable,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// CertificateUpdateParameters - The parameters supplied to the update certificate operation.
type CertificateUpdateParameters struct {
	// Gets or sets the name of the certificate.
	Name *string `json:"name,omitempty"`

	// Gets or sets the properties of the certificate.
	Properties *CertificateUpdateProperties `json:"properties,omitempty"`
}

// CertificateUpdateProperties - The properties of the update certificate operation
type CertificateUpdateProperties struct {
	// Gets or sets the description of the certificate.
	Description *string `json:"description,omitempty"`
}

// ClientConvertGraphRunbookContentOptions contains the optional parameters for the Client.ConvertGraphRunbookContent method.
type ClientConvertGraphRunbookContentOptions struct {
	// placeholder for future optional parameters
}

type ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// Connection - Definition of the connection.
type Connection struct {
	// Gets or sets the properties of the connection.
	Properties *ConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectionClientCreateOrUpdateOptions contains the optional parameters for the ConnectionClient.CreateOrUpdate method.
type ConnectionClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectionClientDeleteOptions contains the optional parameters for the ConnectionClient.Delete method.
type ConnectionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectionClientGetOptions contains the optional parameters for the ConnectionClient.Get method.
type ConnectionClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectionClientListByAutomationAccountOptions contains the optional parameters for the ConnectionClient.ListByAutomationAccount
// method.
type ConnectionClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// ConnectionClientUpdateOptions contains the optional parameters for the ConnectionClient.Update method.
type ConnectionClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectionCreateOrUpdateParameters - The parameters supplied to the create or update connection operation.
type ConnectionCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the connection.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the properties of the connection.
	Properties *ConnectionCreateOrUpdateProperties `json:"properties,omitempty"`
}

// ConnectionCreateOrUpdateProperties - The properties of the create connection properties
type ConnectionCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`

	// Gets or sets the description of the connection.
	Description *string `json:"description,omitempty"`

	// Gets or sets the field definition properties of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues,omitempty"`
}

// ConnectionListResult - The response model for the list connection operation.
type ConnectionListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of connection.
	Value []*Connection `json:"value,omitempty"`
}

// ConnectionProperties - Definition of the connection properties.
type ConnectionProperties struct {
	// Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the field definition values of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// ConnectionType - Definition of the connection type.
type ConnectionType struct {
	// Gets or sets the properties of the connection type.
	Properties *ConnectionTypeProperties `json:"properties,omitempty"`

	// READ-ONLY; Gets the id of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the connection type.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectionTypeAssociationProperty - The connection type property associated with the entity.
type ConnectionTypeAssociationProperty struct {
	// Gets or sets the name of the connection type.
	Name *string `json:"name,omitempty"`
}

// ConnectionTypeClientCreateOrUpdateOptions contains the optional parameters for the ConnectionTypeClient.CreateOrUpdate
// method.
type ConnectionTypeClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectionTypeClientDeleteOptions contains the optional parameters for the ConnectionTypeClient.Delete method.
type ConnectionTypeClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectionTypeClientGetOptions contains the optional parameters for the ConnectionTypeClient.Get method.
type ConnectionTypeClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectionTypeClientListByAutomationAccountOptions contains the optional parameters for the ConnectionTypeClient.ListByAutomationAccount
// method.
type ConnectionTypeClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// ConnectionTypeCreateOrUpdateParameters - The parameters supplied to the create or update connection type operation.
type ConnectionTypeCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the connection type.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the value of the connection type.
	Properties *ConnectionTypeCreateOrUpdateProperties `json:"properties,omitempty"`
}

// ConnectionTypeCreateOrUpdateProperties - The properties of the create connection type.
type ConnectionTypeCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition `json:"fieldDefinitions,omitempty"`

	// Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool `json:"isGlobal,omitempty"`
}

// ConnectionTypeListResult - The response model for the list connection type operation.
type ConnectionTypeListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of connection types.
	Value []*ConnectionType `json:"value,omitempty"`
}

// ConnectionTypeProperties - Properties of the connection type.
type ConnectionTypeProperties struct {
	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool `json:"isGlobal,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition `json:"fieldDefinitions,omitempty" azure:"ro"`
}

// ConnectionUpdateParameters - The parameters supplied to the update connection operation.
type ConnectionUpdateParameters struct {
	// Gets or sets the name of the connection.
	Name *string `json:"name,omitempty"`

	// Gets or sets the properties of the connection.
	Properties *ConnectionUpdateProperties `json:"properties,omitempty"`
}

// ConnectionUpdateProperties - The properties of the update connection operation.
type ConnectionUpdateProperties struct {
	// Gets or sets the description of the connection.
	Description *string `json:"description,omitempty"`

	// Gets or sets the field definition values of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues,omitempty"`
}

// ContentHash - Definition of the runbook property type.
type ContentHash struct {
	// REQUIRED; Gets or sets the content hash algorithm used to hash the content.
	Algorithm *string `json:"algorithm,omitempty"`

	// REQUIRED; Gets or sets expected hash value of the content.
	Value *string `json:"value,omitempty"`
}

// ContentLink - Definition of the content link.
type ContentLink struct {
	// Gets or sets the hash.
	ContentHash *ContentHash `json:"contentHash,omitempty"`

	// Gets or sets the uri of the runbook content.
	URI *string `json:"uri,omitempty"`

	// Gets or sets the version of the content.
	Version *string `json:"version,omitempty"`
}

// ContentSource - Definition of the content source.
type ContentSource struct {
	// Gets or sets the hash.
	Hash *ContentHash `json:"hash,omitempty"`

	// Gets or sets the content source type.
	Type *ContentSourceType `json:"type,omitempty"`

	// Gets or sets the value of the content. This is based on the content source type.
	Value *string `json:"value,omitempty"`

	// Gets or sets the version of the content.
	Version *string `json:"version,omitempty"`
}

// Credential - Definition of the credential.
type Credential struct {
	// Gets or sets the properties of the credential.
	Properties *CredentialProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CredentialClientCreateOrUpdateOptions contains the optional parameters for the CredentialClient.CreateOrUpdate method.
type CredentialClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CredentialClientDeleteOptions contains the optional parameters for the CredentialClient.Delete method.
type CredentialClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CredentialClientGetOptions contains the optional parameters for the CredentialClient.Get method.
type CredentialClientGetOptions struct {
	// placeholder for future optional parameters
}

// CredentialClientListByAutomationAccountOptions contains the optional parameters for the CredentialClient.ListByAutomationAccount
// method.
type CredentialClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// CredentialClientUpdateOptions contains the optional parameters for the CredentialClient.Update method.
type CredentialClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CredentialCreateOrUpdateParameters - The parameters supplied to the create or update credential operation.
type CredentialCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the properties of the credential.
	Properties *CredentialCreateOrUpdateProperties `json:"properties,omitempty"`
}

// CredentialCreateOrUpdateProperties - The properties of the create credential operation.
type CredentialCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the password of the credential.
	Password *string `json:"password,omitempty"`

	// REQUIRED; Gets or sets the user name of the credential.
	UserName *string `json:"userName,omitempty"`

	// Gets or sets the description of the credential.
	Description *string `json:"description,omitempty"`
}

// CredentialListResult - The response model for the list credential operation.
type CredentialListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of credentials.
	Value []*Credential `json:"value,omitempty"`
}

// CredentialProperties - Definition of the credential properties
type CredentialProperties struct {
	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the user name of the credential.
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// CredentialUpdateParameters - The parameters supplied to the Update credential operation.
type CredentialUpdateParameters struct {
	// Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`

	// Gets or sets the properties of the variable.
	Properties *CredentialUpdateProperties `json:"properties,omitempty"`
}

// CredentialUpdateProperties - The properties of the Update credential
type CredentialUpdateProperties struct {
	// Gets or sets the description of the credential.
	Description *string `json:"description,omitempty"`

	// Gets or sets the password of the credential.
	Password *string `json:"password,omitempty"`

	// Gets or sets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
}

// DeletedAutomationAccount - Definition of the deleted automation account type.
type DeletedAutomationAccount struct {
	// The resource id.
	ID *string `json:"id,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the automation account properties.
	Properties *DeletedAutomationAccountProperties `json:"properties,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`
}

// DeletedAutomationAccountListResult - The response model for the list deleted automation account.
type DeletedAutomationAccountListResult struct {
	// Gets or sets the list of deleted automation accounts.
	Value []*DeletedAutomationAccount `json:"value,omitempty"`
}

// DeletedAutomationAccountProperties - Definition of the deleted automation account properties.
type DeletedAutomationAccountProperties struct {
	// Gets or sets the Automation Account Id.
	AutomationAccountID *string `json:"automationAccountId,omitempty"`

	// Gets or sets the Automation Account Resource Id.
	AutomationAccountResourceID *string `json:"automationAccountResourceId,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Gets the deletion time.
	DeletionTime *time.Time `json:"deletionTime,omitempty" azure:"ro"`
}

// DeletedAutomationAccountsClientListBySubscriptionOptions contains the optional parameters for the DeletedAutomationAccountsClient.ListBySubscription
// method.
type DeletedAutomationAccountsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DscCompilationJob - Definition of the Dsc Compilation job.
type DscCompilationJob struct {
	// Gets or sets the properties of the Dsc Compilation job.
	Properties *DscCompilationJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DscCompilationJobClientBeginCreateOptions contains the optional parameters for the DscCompilationJobClient.BeginCreate
// method.
type DscCompilationJobClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DscCompilationJobClientGetOptions contains the optional parameters for the DscCompilationJobClient.Get method.
type DscCompilationJobClientGetOptions struct {
	// placeholder for future optional parameters
}

// DscCompilationJobClientGetStreamOptions contains the optional parameters for the DscCompilationJobClient.GetStream method.
type DscCompilationJobClientGetStreamOptions struct {
	// placeholder for future optional parameters
}

// DscCompilationJobClientListByAutomationAccountOptions contains the optional parameters for the DscCompilationJobClient.ListByAutomationAccount
// method.
type DscCompilationJobClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// DscCompilationJobCreateParameters - The parameters supplied to the create compilation job operation.
type DscCompilationJobCreateParameters struct {
	// REQUIRED; Gets or sets the list of compilation job properties.
	Properties *DscCompilationJobCreateProperties `json:"properties,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DscCompilationJobCreateProperties - The parameters supplied to the create compilation job operation.
type DscCompilationJobCreateProperties struct {
	// REQUIRED; Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`

	// If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool `json:"incrementNodeConfigurationBuild,omitempty"`

	// Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters,omitempty"`
}

// DscCompilationJobListResult - The response model for the list job operation.
type DscCompilationJobListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of Dsc Compilation jobs.
	Value []*DscCompilationJob `json:"value,omitempty"`
}

// DscCompilationJobProperties - Definition of Dsc Compilation job properties.
type DscCompilationJobProperties struct {
	// Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`

	// Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// The current provisioning state of the job.
	ProvisioningState *JobProvisioningState `json:"provisioningState,omitempty"`

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the status of the job.
	Status *JobStatus `json:"status,omitempty"`

	// Gets or sets the status details of the job.
	StatusDetails *string `json:"statusDetails,omitempty"`

	// READ-ONLY; Gets the creation time of the job.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time of the job.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the exception of the job.
	Exception *string `json:"exception,omitempty" azure:"ro"`

	// READ-ONLY; Gets the id of the job.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modified time of the job.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last status modified time of the job.
	LastStatusModifiedTime *time.Time `json:"lastStatusModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time of the job.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the compilation job started by.
	StartedBy *string `json:"startedBy,omitempty" azure:"ro"`
}

// DscCompilationJobStreamClientListByJobOptions contains the optional parameters for the DscCompilationJobStreamClient.ListByJob
// method.
type DscCompilationJobStreamClientListByJobOptions struct {
	// placeholder for future optional parameters
}

// DscConfiguration - Definition of the configuration type.
type DscConfiguration struct {
	// Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// Gets or sets the configuration properties.
	Properties *DscConfigurationProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DscConfigurationAssociationProperty - The Dsc configuration property associated with the entity.
type DscConfigurationAssociationProperty struct {
	// Gets or sets the name of the Dsc configuration.
	Name *string `json:"name,omitempty"`
}

// DscConfigurationClientCreateOrUpdateWithJSONOptions contains the optional parameters for the DscConfigurationClient.CreateOrUpdateWithJSON
// method.
type DscConfigurationClientCreateOrUpdateWithJSONOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationClientCreateOrUpdateWithTextOptions contains the optional parameters for the DscConfigurationClient.CreateOrUpdateWithText
// method.
type DscConfigurationClientCreateOrUpdateWithTextOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationClientDeleteOptions contains the optional parameters for the DscConfigurationClient.Delete method.
type DscConfigurationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationClientGetContentOptions contains the optional parameters for the DscConfigurationClient.GetContent method.
type DscConfigurationClientGetContentOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationClientGetOptions contains the optional parameters for the DscConfigurationClient.Get method.
type DscConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationClientListByAutomationAccountOptions contains the optional parameters for the DscConfigurationClient.ListByAutomationAccount
// method.
type DscConfigurationClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
	// Return total rows.
	Inlinecount *string
	// The number of rows to skip.
	Skip *int32
	// The number of rows to take.
	Top *int32
}

// DscConfigurationClientUpdateWithJSONOptions contains the optional parameters for the DscConfigurationClient.UpdateWithJSON
// method.
type DscConfigurationClientUpdateWithJSONOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationClientUpdateWithTextOptions contains the optional parameters for the DscConfigurationClient.UpdateWithText
// method.
type DscConfigurationClientUpdateWithTextOptions struct {
	// placeholder for future optional parameters
}

// DscConfigurationCreateOrUpdateParameters - The parameters supplied to the create or update configuration operation.
type DscConfigurationCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets configuration create or update properties.
	Properties *DscConfigurationCreateOrUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DscConfigurationCreateOrUpdateProperties - The properties to create or update configuration.
type DscConfigurationCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`

	// Gets or sets the description of the configuration.
	Description *string `json:"description,omitempty"`

	// Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`

	// Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`

	// Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter `json:"parameters,omitempty"`
}

// DscConfigurationListResult - The response model for the list configuration operation.
type DscConfigurationListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets the total number of configurations matching filter criteria.
	TotalCount *int32 `json:"totalCount,omitempty"`

	// Gets or sets a list of configurations.
	Value []*DscConfiguration `json:"value,omitempty"`
}

// DscConfigurationParameter - Definition of the configuration parameter type.
type DscConfigurationParameter struct {
	// Gets or sets the default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`

	// Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
	IsMandatory *bool `json:"isMandatory,omitempty"`

	// Get or sets the position of the parameter.
	Position *int32 `json:"position,omitempty"`

	// Gets or sets the type of the parameter.
	Type *string `json:"type,omitempty"`
}

// DscConfigurationProperties - Definition of the configuration property type.
type DscConfigurationProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the job count of the configuration.
	JobCount *int32 `json:"jobCount,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`

	// Gets the number of compiled node configurations.
	NodeConfigurationCount *int32 `json:"nodeConfigurationCount,omitempty"`

	// Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter `json:"parameters,omitempty"`

	// Gets or sets the provisioning state of the configuration.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`

	// Gets or sets the state of the configuration.
	State *DscConfigurationState `json:"state,omitempty"`
}

// DscConfigurationUpdateParameters - The parameters supplied to the create or update configuration operation.
type DscConfigurationUpdateParameters struct {
	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets configuration create or update properties.
	Properties *DscConfigurationCreateOrUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DscMetaConfiguration - Definition of the DSC Meta Configuration.
type DscMetaConfiguration struct {
	// Gets or sets the ActionAfterReboot value of the meta configuration.
	ActionAfterReboot *string `json:"actionAfterReboot,omitempty"`

	// Gets or sets the AllowModuleOverwrite value of the meta configuration.
	AllowModuleOverwrite *bool `json:"allowModuleOverwrite,omitempty"`

	// Gets or sets the CertificateId value of the meta configuration.
	CertificateID *string `json:"certificateId,omitempty"`

	// Gets or sets the ConfigurationMode value of the meta configuration.
	ConfigurationMode *string `json:"configurationMode,omitempty"`

	// Gets or sets the ConfigurationModeFrequencyMins value of the meta configuration.
	ConfigurationModeFrequencyMins *int32 `json:"configurationModeFrequencyMins,omitempty"`

	// Gets or sets the RebootNodeIfNeeded value of the meta configuration.
	RebootNodeIfNeeded *bool `json:"rebootNodeIfNeeded,omitempty"`

	// Gets or sets the RefreshFrequencyMins value of the meta configuration.
	RefreshFrequencyMins *int32 `json:"refreshFrequencyMins,omitempty"`
}

// DscNode - Definition of a DscNode
type DscNode struct {
	// The properties of a DscNode.
	Properties *DscNodeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DscNodeClientDeleteOptions contains the optional parameters for the DscNodeClient.Delete method.
type DscNodeClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DscNodeClientGetOptions contains the optional parameters for the DscNodeClient.Get method.
type DscNodeClientGetOptions struct {
	// placeholder for future optional parameters
}

// DscNodeClientListByAutomationAccountOptions contains the optional parameters for the DscNodeClient.ListByAutomationAccount
// method.
type DscNodeClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
	// Return total rows.
	Inlinecount *string
	// The number of rows to skip.
	Skip *int32
	// The number of rows to take.
	Top *int32
}

// DscNodeClientUpdateOptions contains the optional parameters for the DscNodeClient.Update method.
type DscNodeClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DscNodeConfiguration - Definition of the dsc node configuration.
type DscNodeConfiguration struct {
	// Gets or sets the configuration properties.
	Properties *DscNodeConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DscNodeConfigurationAssociationProperty - The dsc node configuration property associated with the entity.
type DscNodeConfigurationAssociationProperty struct {
	// Gets or sets the name of the dsc node configuration.
	Name *string `json:"name,omitempty"`
}

// DscNodeConfigurationClientBeginCreateOrUpdateOptions contains the optional parameters for the DscNodeConfigurationClient.BeginCreateOrUpdate
// method.
type DscNodeConfigurationClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DscNodeConfigurationClientDeleteOptions contains the optional parameters for the DscNodeConfigurationClient.Delete method.
type DscNodeConfigurationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DscNodeConfigurationClientGetOptions contains the optional parameters for the DscNodeConfigurationClient.Get method.
type DscNodeConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// DscNodeConfigurationClientListByAutomationAccountOptions contains the optional parameters for the DscNodeConfigurationClient.ListByAutomationAccount
// method.
type DscNodeConfigurationClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
	// Return total rows.
	Inlinecount *string
	// The number of rows to skip.
	Skip *int32
	// The number of rows to take.
	Top *int32
}

// DscNodeConfigurationCreateOrUpdateParameters - The parameters supplied to the create or update node configuration operation.
type DscNodeConfigurationCreateOrUpdateParameters struct {
	// Name of the node configuration.
	Name *string `json:"name,omitempty"`

	// Node configuration properties
	Properties *DscNodeConfigurationCreateOrUpdateParametersProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DscNodeConfigurationCreateOrUpdateParametersProperties - The parameter properties supplied to the create or update node
// configuration operation.
type DscNodeConfigurationCreateOrUpdateParametersProperties struct {
	// REQUIRED; Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`

	// REQUIRED; Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`

	// If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool `json:"incrementNodeConfigurationBuild,omitempty"`
}

// DscNodeConfigurationListResult - The response model for the list job operation.
type DscNodeConfigurationListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets the total rows in query.
	TotalCount *int32 `json:"totalCount,omitempty"`

	// Gets or sets a list of Dsc node configurations.
	Value []*DscNodeConfiguration `json:"value,omitempty"`
}

// DscNodeConfigurationProperties - Properties for the DscNodeConfiguration
type DscNodeConfigurationProperties struct {
	// Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`

	// Gets or sets creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool `json:"incrementNodeConfigurationBuild,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Number of nodes with this node configuration assigned
	NodeCount *int64 `json:"nodeCount,omitempty"`

	// Source of node configuration.
	Source *string `json:"source,omitempty"`
}

// DscNodeExtensionHandlerAssociationProperty - The dsc extensionHandler property associated with the node
type DscNodeExtensionHandlerAssociationProperty struct {
	// Gets or sets the name of the extension handler.
	Name *string `json:"name,omitempty"`

	// Gets or sets the version of the extension handler.
	Version *string `json:"version,omitempty"`
}

// DscNodeListResult - The response model for the list dsc nodes operation.
type DscNodeListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets the total number of nodes matching filter criteria.
	TotalCount *int32 `json:"totalCount,omitempty"`

	// Gets or sets a list of dsc nodes.
	Value []*DscNode `json:"value,omitempty"`
}

// DscNodeProperties - The properties of a DscNode
type DscNodeProperties struct {
	// Gets or sets the account id of the node.
	AccountID *string `json:"accountId,omitempty"`

	// Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// Gets or sets the list of extensionHandler properties for a Node.
	ExtensionHandler []*DscNodeExtensionHandlerAssociationProperty `json:"extensionHandler,omitempty"`

	// Gets or sets the ip of the node.
	IP *string `json:"ip,omitempty"`

	// Gets or sets the last seen time of the node.
	LastSeen *time.Time `json:"lastSeen,omitempty"`

	// Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`

	// Gets or sets the node id.
	NodeID *string `json:"nodeId,omitempty"`

	// Gets or sets the registration time of the node.
	RegistrationTime *time.Time `json:"registrationTime,omitempty"`

	// Gets or sets the status of the node.
	Status *string `json:"status,omitempty"`

	// Gets the total number of records matching filter criteria.
	TotalCount *int32 `json:"totalCount,omitempty"`
}

// DscNodeReport - Definition of the dsc node report type.
type DscNodeReport struct {
	// Gets or sets the configurationVersion of the node report.
	ConfigurationVersion *string `json:"configurationVersion,omitempty"`

	// Gets or sets the end time of the node report.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Gets or sets the errors for the node report.
	Errors []*DscReportError `json:"errors,omitempty"`

	// Gets or sets the hostname of the node that sent the report.
	HostName *string `json:"hostName,omitempty"`

	// Gets or sets the id.
	ID *string `json:"id,omitempty"`

	// Gets or sets the IPv4 address of the node that sent the report.
	IPV4Addresses []*string `json:"iPV4Addresses,omitempty"`

	// Gets or sets the IPv6 address of the node that sent the report.
	IPV6Addresses []*string `json:"iPV6Addresses,omitempty"`

	// Gets or sets the lastModifiedTime of the node report.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the metaConfiguration of the node at the time of the report.
	MetaConfiguration *DscMetaConfiguration `json:"metaConfiguration,omitempty"`

	// Gets or sets the number of resource in the node report.
	NumberOfResources *int32 `json:"numberOfResources,omitempty"`

	// Gets or sets the unparsed errors for the node report.
	RawErrors *string `json:"rawErrors,omitempty"`

	// Gets or sets the rebootRequested of the node report.
	RebootRequested *string `json:"rebootRequested,omitempty"`

	// Gets or sets the refreshMode of the node report.
	RefreshMode *string `json:"refreshMode,omitempty"`

	// Gets or sets the reportFormatVersion of the node report.
	ReportFormatVersion *string `json:"reportFormatVersion,omitempty"`

	// Gets or sets the id of the node report.
	ReportID *string `json:"reportId,omitempty"`

	// Gets or sets the resource for the node report.
	Resources []*DscReportResource `json:"resources,omitempty"`

	// Gets or sets the start time of the node report.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or sets the status of the node report.
	Status *string `json:"status,omitempty"`

	// Gets or sets the type of the node report.
	Type *string `json:"type,omitempty"`
}

// DscNodeReportListResult - The response model for the list dsc nodes operation.
type DscNodeReportListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of dsc node reports.
	Value []*DscNodeReport `json:"value,omitempty"`
}

// DscNodeUpdateParameters - The parameters supplied to the update dsc node operation.
type DscNodeUpdateParameters struct {
	// Gets or sets the id of the dsc node.
	NodeID     *string                            `json:"nodeId,omitempty"`
	Properties *DscNodeUpdateParametersProperties `json:"properties,omitempty"`
}

type DscNodeUpdateParametersProperties struct {
	// Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
}

// DscReportError - Definition of the dsc node report error type.
type DscReportError struct {
	// Gets or sets the error code.
	ErrorCode *string `json:"errorCode,omitempty"`

	// Gets or sets the error details.
	ErrorDetails *string `json:"errorDetails,omitempty"`

	// Gets or sets the error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Gets or sets the source of the error.
	ErrorSource *string `json:"errorSource,omitempty"`

	// Gets or sets the locale of the error.
	Locale *string `json:"locale,omitempty"`

	// Gets or sets the resource ID which generated the error.
	ResourceID *string `json:"resourceId,omitempty"`
}

// DscReportResource - Definition of the DSC Report Resource.
type DscReportResource struct {
	// Gets or sets the Resource Navigation values for resources the resource depends on.
	DependsOn []*DscReportResourceNavigation `json:"dependsOn,omitempty"`

	// Gets or sets the duration in seconds for the resource.
	DurationInSeconds *float64 `json:"durationInSeconds,omitempty"`

	// Gets or sets the error of the resource.
	Error *string `json:"error,omitempty"`

	// Gets or sets the module name of the resource.
	ModuleName *string `json:"moduleName,omitempty"`

	// Gets or sets the module version of the resource.
	ModuleVersion *string `json:"moduleVersion,omitempty"`

	// Gets or sets the ID of the resource.
	ResourceID *string `json:"resourceId,omitempty"`

	// Gets or sets the name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`

	// Gets or sets the source info of the resource.
	SourceInfo *string `json:"sourceInfo,omitempty"`

	// Gets or sets the start date of the resource.
	StartDate *time.Time `json:"startDate,omitempty"`

	// Gets or sets the status of the resource.
	Status *string `json:"status,omitempty"`
}

// DscReportResourceNavigation - Navigation for DSC Report Resource.
type DscReportResourceNavigation struct {
	// Gets or sets the ID of the resource to navigate to.
	ResourceID *string `json:"resourceId,omitempty"`
}

// EncryptionProperties - The encryption settings for automation account
type EncryptionProperties struct {
	// User identity used for CMK.
	Identity *EncryptionPropertiesIdentity `json:"identity,omitempty"`

	// Encryption Key Source
	KeySource *EncryptionKeySourceType `json:"keySource,omitempty"`

	// Key vault properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// EncryptionPropertiesIdentity - User identity used for CMK.
type EncryptionPropertiesIdentity struct {
	// The user identity used for CMK. It will be an ARM resource id in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentity interface{} `json:"userAssignedIdentity,omitempty"`
}

// ErrorResponse - Error response of an operation failure
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FieldDefinition - Definition of the connection fields.
type FieldDefinition struct {
	// REQUIRED; Gets or sets the type of the connection field definition.
	Type *string `json:"type,omitempty"`

	// Gets or sets the isEncrypted flag of the connection field definition.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`

	// Gets or sets the isOptional flag of the connection field definition.
	IsOptional *bool `json:"isOptional,omitempty"`
}

// FieldsClientListByTypeOptions contains the optional parameters for the FieldsClient.ListByType method.
type FieldsClientListByTypeOptions struct {
	// placeholder for future optional parameters
}

// GraphicalRunbookContent - Graphical Runbook Content
type GraphicalRunbookContent struct {
	// Graphical Runbook content as JSON
	GraphRunbookJSON *string `json:"graphRunbookJson,omitempty"`

	// Raw graphical Runbook content.
	RawContent *RawGraphicalRunbookContent `json:"rawContent,omitempty"`
}

// HybridRunbookWorker - Definition of hybrid runbook worker.
type HybridRunbookWorker struct {
	// Gets or sets the hybrid worker group properties.
	Properties *HybridRunbookWorkerProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource system metadata.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridRunbookWorkerCreateOrUpdateParameters - The parameters supplied to the create or update hybrid runbook worker operation.
type HybridRunbookWorkerCreateOrUpdateParameters struct {
	// Azure Resource Manager Id for a virtual machine.
	VMResourceID *string `json:"vmResourceId,omitempty"`
}

// HybridRunbookWorkerCreateParameters - The parameters supplied to the create hybrid runbook worker operation.
type HybridRunbookWorkerCreateParameters struct {
	// REQUIRED; Gets or sets hybrid runbook worker group create or update properties.
	Properties *HybridRunbookWorkerCreateOrUpdateParameters `json:"properties,omitempty"`

	// Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
}

// HybridRunbookWorkerGroup - Definition of hybrid runbook worker group.
type HybridRunbookWorkerGroup struct {
	// Gets or sets the hybrid worker group properties.
	Properties *HybridRunbookWorkerGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource system metadata.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridRunbookWorkerGroupClientCreateOptions contains the optional parameters for the HybridRunbookWorkerGroupClient.Create
// method.
type HybridRunbookWorkerGroupClientCreateOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkerGroupClientDeleteOptions contains the optional parameters for the HybridRunbookWorkerGroupClient.Delete
// method.
type HybridRunbookWorkerGroupClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkerGroupClientGetOptions contains the optional parameters for the HybridRunbookWorkerGroupClient.Get method.
type HybridRunbookWorkerGroupClientGetOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkerGroupClientListByAutomationAccountOptions contains the optional parameters for the HybridRunbookWorkerGroupClient.ListByAutomationAccount
// method.
type HybridRunbookWorkerGroupClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// HybridRunbookWorkerGroupClientUpdateOptions contains the optional parameters for the HybridRunbookWorkerGroupClient.Update
// method.
type HybridRunbookWorkerGroupClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkerGroupCreateOrUpdateParameters - The parameters supplied to the create hybrid runbook worker group operation.
type HybridRunbookWorkerGroupCreateOrUpdateParameters struct {
	// Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets hybrid runbook worker group create or update properties.
	Properties *HybridRunbookWorkerGroupCreateOrUpdateProperties `json:"properties,omitempty"`
}

// HybridRunbookWorkerGroupCreateOrUpdateProperties - The hybrid runbook worker group properties.
type HybridRunbookWorkerGroupCreateOrUpdateProperties struct {
	// Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
}

// HybridRunbookWorkerGroupProperties - Definition of hybrid runbook worker group property.
type HybridRunbookWorkerGroupProperties struct {
	// Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`

	// Type of the HybridWorkerGroup.
	GroupType *GroupTypeEnum `json:"groupType,omitempty"`
}

// HybridRunbookWorkerGroupsListResult - The response model for the list hybrid runbook worker groups.
type HybridRunbookWorkerGroupsListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of hybrid runbook worker groups.
	Value []*HybridRunbookWorkerGroup `json:"value,omitempty"`
}

// HybridRunbookWorkerMoveParameters - Parameters supplied to move hybrid worker operation.
type HybridRunbookWorkerMoveParameters struct {
	// Gets or sets the target hybrid runbook worker group.
	HybridRunbookWorkerGroupName *string `json:"hybridRunbookWorkerGroupName,omitempty"`
}

// HybridRunbookWorkerProperties - Definition of hybrid runbook worker property.
type HybridRunbookWorkerProperties struct {
	// Gets or sets the assigned machine IP address.
	IP *string `json:"ip,omitempty"`

	// Last Heartbeat from the Worker
	LastSeenDateTime *time.Time `json:"lastSeenDateTime,omitempty"`

	// Gets or sets the registration time of the worker machine.
	RegisteredDateTime *time.Time `json:"registeredDateTime,omitempty"`

	// Azure Resource Manager Id for a virtual machine.
	VMResourceID *string `json:"vmResourceId,omitempty"`

	// Name of the HybridWorker.
	WorkerName *string `json:"workerName,omitempty"`

	// Type of the HybridWorker.
	WorkerType *WorkerType `json:"workerType,omitempty"`
}

// HybridRunbookWorkersClientCreateOptions contains the optional parameters for the HybridRunbookWorkersClient.Create method.
type HybridRunbookWorkersClientCreateOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkersClientDeleteOptions contains the optional parameters for the HybridRunbookWorkersClient.Delete method.
type HybridRunbookWorkersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkersClientGetOptions contains the optional parameters for the HybridRunbookWorkersClient.Get method.
type HybridRunbookWorkersClientGetOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkersClientListByHybridRunbookWorkerGroupOptions contains the optional parameters for the HybridRunbookWorkersClient.ListByHybridRunbookWorkerGroup
// method.
type HybridRunbookWorkersClientListByHybridRunbookWorkerGroupOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// HybridRunbookWorkersClientMoveOptions contains the optional parameters for the HybridRunbookWorkersClient.Move method.
type HybridRunbookWorkersClientMoveOptions struct {
	// placeholder for future optional parameters
}

// HybridRunbookWorkersListResult - The response model for the list hybrid runbook workers.
type HybridRunbookWorkersListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of hybrid runbook workers.
	Value []*HybridRunbookWorker `json:"value,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// Job - Definition of the job.
type Job struct {
	// The properties of the job.
	Properties *JobProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobClientCreateOptions contains the optional parameters for the JobClient.Create method.
type JobClientCreateOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobClientGetOptions contains the optional parameters for the JobClient.Get method.
type JobClientGetOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobClientGetOutputOptions contains the optional parameters for the JobClient.GetOutput method.
type JobClientGetOutputOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobClientGetRunbookContentOptions contains the optional parameters for the JobClient.GetRunbookContent method.
type JobClientGetRunbookContentOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobClientListByAutomationAccountOptions contains the optional parameters for the JobClient.ListByAutomationAccount method.
type JobClientListByAutomationAccountOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
	// The filter to apply on the operation.
	Filter *string
}

// JobClientResumeOptions contains the optional parameters for the JobClient.Resume method.
type JobClientResumeOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobClientStopOptions contains the optional parameters for the JobClient.Stop method.
type JobClientStopOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobClientSuspendOptions contains the optional parameters for the JobClient.Suspend method.
type JobClientSuspendOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobCollectionItem - Job collection item properties.
type JobCollectionItem struct {
	// REQUIRED; Job properties.
	Properties *JobCollectionItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobCollectionItemProperties - Job collection item properties.
type JobCollectionItemProperties struct {
	// Specifies the runOn group name where the job was executed.
	RunOn *string `json:"runOn,omitempty"`

	// READ-ONLY; The creation time of the job.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the job.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The id of the job.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; The last modified time of the job.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of a resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The runbook association.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the job.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the job.
	Status *JobStatus `json:"status,omitempty" azure:"ro"`
}

// JobCreateParameters - The parameters supplied to the create job operation.
type JobCreateParameters struct {
	// REQUIRED; Gets or sets the list of job properties.
	Properties *JobCreateProperties `json:"properties,omitempty"`
}

type JobCreateProperties struct {
	// Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
}

// JobListResultV2 - The response model for the list job operation.
type JobListResultV2 struct {
	// List of jobs.
	Value []*JobCollectionItem `json:"value,omitempty"`

	// READ-ONLY; The link to the next page.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// JobNavigation - Software update configuration machine run job navigation properties.
type JobNavigation struct {
	// READ-ONLY; Id of the job associated with the software update configuration run
	ID *string `json:"id,omitempty" azure:"ro"`
}

// JobProperties - Definition of job properties.
type JobProperties struct {
	// Gets or sets the creation time of the job.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the end time of the job.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Gets or sets the exception of the job.
	Exception *string `json:"exception,omitempty"`

	// Gets or sets the id of the job.
	JobID *string `json:"jobId,omitempty"`

	// Gets or sets the last modified time of the job.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the last status modified time of the job.
	LastStatusModifiedTime *time.Time `json:"lastStatusModifiedTime,omitempty"`

	// Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// The current provisioning state of the job.
	ProvisioningState *JobProvisioningState `json:"provisioningState,omitempty"`

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`

	// Gets or sets the start time of the job.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or sets the job started by.
	StartedBy *string `json:"startedBy,omitempty"`

	// Gets or sets the status of the job.
	Status *JobStatus `json:"status,omitempty"`

	// Gets or sets the status details of the job.
	StatusDetails *string `json:"statusDetails,omitempty"`
}

// JobSchedule - Definition of the job schedule.
type JobSchedule struct {
	// Gets or sets the properties of the job schedule.
	Properties *JobScheduleProperties `json:"properties,omitempty"`

	// READ-ONLY; Gets the id of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the variable.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobScheduleClientCreateOptions contains the optional parameters for the JobScheduleClient.Create method.
type JobScheduleClientCreateOptions struct {
	// placeholder for future optional parameters
}

// JobScheduleClientDeleteOptions contains the optional parameters for the JobScheduleClient.Delete method.
type JobScheduleClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobScheduleClientGetOptions contains the optional parameters for the JobScheduleClient.Get method.
type JobScheduleClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobScheduleClientListByAutomationAccountOptions contains the optional parameters for the JobScheduleClient.ListByAutomationAccount
// method.
type JobScheduleClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// JobScheduleCreateParameters - The parameters supplied to the create job schedule operation.
type JobScheduleCreateParameters struct {
	// REQUIRED; Gets or sets the list of job schedule properties.
	Properties *JobScheduleCreateProperties `json:"properties,omitempty"`
}

// JobScheduleCreateProperties - The parameters supplied to the create job schedule operation.
type JobScheduleCreateProperties struct {
	// REQUIRED; Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`

	// REQUIRED; Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty `json:"schedule,omitempty"`

	// Gets or sets a list of job properties.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string `json:"runOn,omitempty"`
}

// JobScheduleListResult - The response model for the list job schedule operation.
type JobScheduleListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of job schedules.
	Value []*JobSchedule `json:"value,omitempty"`
}

// JobScheduleProperties - Definition of job schedule parameters.
type JobScheduleProperties struct {
	// Gets or sets the id of job schedule.
	JobScheduleID *string `json:"jobScheduleId,omitempty"`

	// Gets or sets the parameters of the job schedule.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`

	// Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty `json:"schedule,omitempty"`
}

// JobStream - Definition of the job stream.
type JobStream struct {
	// Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`

	// Gets or sets the id of the job stream.
	Properties *JobStreamProperties `json:"properties,omitempty"`
}

// JobStreamClientGetOptions contains the optional parameters for the JobStreamClient.Get method.
type JobStreamClientGetOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// JobStreamClientListByJobOptions contains the optional parameters for the JobStreamClient.ListByJob method.
type JobStreamClientListByJobOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
	// The filter to apply on the operation.
	Filter *string
}

// JobStreamListResult - The response model for the list job stream operation.
type JobStreamListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of job streams.
	Value []*JobStream `json:"value,omitempty"`
}

// JobStreamProperties - Definition of the job stream.
type JobStreamProperties struct {
	// Gets or sets the id of the job stream.
	JobStreamID *string `json:"jobStreamId,omitempty"`

	// Gets or sets the stream text.
	StreamText *string `json:"streamText,omitempty"`

	// Gets or sets the stream type.
	StreamType *JobStreamType `json:"streamType,omitempty"`

	// Gets or sets the summary.
	Summary *string `json:"summary,omitempty"`

	// Gets or sets the creation time of the job.
	Time *time.Time `json:"time,omitempty"`

	// Gets or sets the values of the job stream.
	Value map[string]interface{} `json:"value,omitempty"`
}

// Key - Automation key which is used to register a DSC Node
type Key struct {
	// READ-ONLY; Automation key name.
	KeyName *AutomationKeyName `json:"KeyName,omitempty" azure:"ro"`

	// READ-ONLY; Automation key permissions.
	Permissions *AutomationKeyPermissions `json:"Permissions,omitempty" azure:"ro"`

	// READ-ONLY; Value of the Automation Key used for registration.
	Value *string `json:"Value,omitempty" azure:"ro"`
}

type KeyListResult struct {
	// Lists the automation keys.
	Keys []*Key `json:"keys,omitempty"`
}

// KeyVaultProperties - Settings concerning key vault encryption for a configuration store.
type KeyVaultProperties struct {
	// The name of key used to encrypt data.
	KeyName *string `json:"keyName,omitempty"`

	// The key version of the key used to encrypt data.
	KeyVersion *string `json:"keyVersion,omitempty"`

	// The URI of the key vault key used to encrypt data.
	KeyvaultURI *string `json:"keyvaultUri,omitempty"`
}

// KeysClientListByAutomationAccountOptions contains the optional parameters for the KeysClient.ListByAutomationAccount method.
type KeysClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// LinkedWorkspace - Definition of the linked workspace.
type LinkedWorkspace struct {
	// READ-ONLY; Gets the id of the linked workspace.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// LinkedWorkspaceClientGetOptions contains the optional parameters for the LinkedWorkspaceClient.Get method.
type LinkedWorkspaceClientGetOptions struct {
	// placeholder for future optional parameters
}

// LinuxProperties - Linux specific update configuration.
type LinuxProperties struct {
	// packages excluded from the software update configuration.
	ExcludedPackageNameMasks []*string `json:"excludedPackageNameMasks,omitempty"`

	// Update classifications included in the software update configuration.
	IncludedPackageClassifications *LinuxUpdateClasses `json:"includedPackageClassifications,omitempty"`

	// packages included from the software update configuration.
	IncludedPackageNameMasks []*string `json:"includedPackageNameMasks,omitempty"`

	// Reboot setting for the software update configuration.
	RebootSetting *string `json:"rebootSetting,omitempty"`
}

// Module - Definition of the module type.
type Module struct {
	// Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// Gets or sets the module properties.
	Properties *ModuleProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ModuleClientCreateOrUpdateOptions contains the optional parameters for the ModuleClient.CreateOrUpdate method.
type ModuleClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ModuleClientDeleteOptions contains the optional parameters for the ModuleClient.Delete method.
type ModuleClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ModuleClientGetOptions contains the optional parameters for the ModuleClient.Get method.
type ModuleClientGetOptions struct {
	// placeholder for future optional parameters
}

// ModuleClientListByAutomationAccountOptions contains the optional parameters for the ModuleClient.ListByAutomationAccount
// method.
type ModuleClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// ModuleClientUpdateOptions contains the optional parameters for the ModuleClient.Update method.
type ModuleClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ModuleCreateOrUpdateParameters - The parameters supplied to the create or update module operation.
type ModuleCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the module create properties.
	Properties *ModuleCreateOrUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ModuleCreateOrUpdateProperties - The parameters supplied to the create or update module properties.
type ModuleCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// ModuleErrorInfo - Definition of the module error info type.
type ModuleErrorInfo struct {
	// Gets or sets the error code.
	Code *string `json:"code,omitempty"`

	// Gets or sets the error message.
	Message *string `json:"message,omitempty"`
}

// ModuleListResult - The response model for the list module operation.
type ModuleListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of modules.
	Value []*Module `json:"value,omitempty"`
}

// ModuleProperties - Definition of the module property type.
type ModuleProperties struct {
	// Gets or sets the activity count of the module.
	ActivityCount *int32 `json:"activityCount,omitempty"`

	// Gets or sets the contentLink of the module.
	ContentLink *ContentLink `json:"contentLink,omitempty"`

	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the error info of the module.
	Error *ModuleErrorInfo `json:"error,omitempty"`

	// Gets or sets type of module, if its composite or not.
	IsComposite *bool `json:"isComposite,omitempty"`

	// Gets or sets the isGlobal flag of the module.
	IsGlobal *bool `json:"isGlobal,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the provisioning state of the module.
	ProvisioningState *ModuleProvisioningState `json:"provisioningState,omitempty"`

	// Gets or sets the size in bytes of the module.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`

	// Gets or sets the version of the module.
	Version *string `json:"version,omitempty"`
}

// ModuleUpdateParameters - The parameters supplied to the update module operation.
type ModuleUpdateParameters struct {
	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the module update properties.
	Properties *ModuleUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ModuleUpdateProperties - The parameters supplied to the update properties.
type ModuleUpdateProperties struct {
	// Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// NodeCount - Number of nodes based on the Filter
type NodeCount struct {
	// Gets the name of a count type
	Name       *string              `json:"name,omitempty"`
	Properties *NodeCountProperties `json:"properties,omitempty"`
}

// NodeCountInformationClientGetOptions contains the optional parameters for the NodeCountInformationClient.Get method.
type NodeCountInformationClientGetOptions struct {
	// placeholder for future optional parameters
}

type NodeCountProperties struct {
	// Gets the count for the name
	Count *int32 `json:"count,omitempty"`
}

// NodeCounts - Gets the count of nodes by count type
type NodeCounts struct {
	// Gets the total number of records matching countType criteria.
	TotalCount *int32 `json:"totalCount,omitempty"`

	// Gets an array of counts
	Value []*NodeCount `json:"value,omitempty"`
}

// NodeReportsClientGetContentOptions contains the optional parameters for the NodeReportsClient.GetContent method.
type NodeReportsClientGetContentOptions struct {
	// placeholder for future optional parameters
}

// NodeReportsClientGetOptions contains the optional parameters for the NodeReportsClient.Get method.
type NodeReportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// NodeReportsClientListByNodeOptions contains the optional parameters for the NodeReportsClient.ListByNode method.
type NodeReportsClientListByNodeOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// NonAzureQueryProperties - Non Azure query for the update configuration.
type NonAzureQueryProperties struct {
	// Log Analytics Saved Search name.
	FunctionAlias *string `json:"functionAlias,omitempty"`

	// Workspace Id for Log Analytics in which the saved Search is resided.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// ObjectDataTypesClientListFieldsByModuleAndTypeOptions contains the optional parameters for the ObjectDataTypesClient.ListFieldsByModuleAndType
// method.
type ObjectDataTypesClientListFieldsByModuleAndTypeOptions struct {
	// placeholder for future optional parameters
}

// ObjectDataTypesClientListFieldsByTypeOptions contains the optional parameters for the ObjectDataTypesClient.ListFieldsByType
// method.
type ObjectDataTypesClientListFieldsByTypeOptions struct {
	// placeholder for future optional parameters
}

// Operation - Automation REST API operation
type Operation struct {
	// Provider, Resource and Operation values
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Provider, Resource and Operation values
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Automation
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Runbooks, Jobs etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - The response model for the list of Automation operations
type OperationListResult struct {
	// List of Automation operations supported by the Automation resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Gets the groupIds.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByAutomationAccountOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByAutomationAccount
// method.
type PrivateEndpointConnectionsClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientAutomationOptions contains the optional parameters for the PrivateLinkResourcesClient.Automation
// method.
type PrivateLinkResourcesClientAutomationOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionStateProperty - Connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ProxyResource - ARM proxy resource.
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Python2PackageClientCreateOrUpdateOptions contains the optional parameters for the Python2PackageClient.CreateOrUpdate
// method.
type Python2PackageClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// Python2PackageClientDeleteOptions contains the optional parameters for the Python2PackageClient.Delete method.
type Python2PackageClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// Python2PackageClientGetOptions contains the optional parameters for the Python2PackageClient.Get method.
type Python2PackageClientGetOptions struct {
	// placeholder for future optional parameters
}

// Python2PackageClientListByAutomationAccountOptions contains the optional parameters for the Python2PackageClient.ListByAutomationAccount
// method.
type Python2PackageClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// Python2PackageClientUpdateOptions contains the optional parameters for the Python2PackageClient.Update method.
type Python2PackageClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PythonPackageCreateParameters - The parameters supplied to the create or update module operation.
type PythonPackageCreateParameters struct {
	// REQUIRED; Gets or sets the module create properties.
	Properties *PythonPackageCreateProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PythonPackageCreateProperties - The parameters supplied to the create or update module properties.
type PythonPackageCreateProperties struct {
	// REQUIRED; Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// PythonPackageUpdateParameters - The parameters supplied to the update module operation.
type PythonPackageUpdateParameters struct {
	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// RawGraphicalRunbookContent - Raw Graphical Runbook content
type RawGraphicalRunbookContent struct {
	// Serialized Graphical runbook
	RunbookDefinition *string `json:"runbookDefinition,omitempty"`

	// Runbook Type
	RunbookType *GraphRunbookType `json:"runbookType,omitempty"`

	// Schema version of the serializer.
	SchemaVersion *string `json:"schemaVersion,omitempty"`
}

// Resource - The core properties of ARM resources
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RunAsCredentialAssociationProperty - Definition of RunAs credential to use for hybrid worker.
type RunAsCredentialAssociationProperty struct {
	// Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
}

// Runbook - Definition of the runbook type.
type Runbook struct {
	// Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// Gets or sets the runbook properties.
	Properties *RunbookProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RunbookAssociationProperty - The runbook property associated with the entity.
type RunbookAssociationProperty struct {
	// Gets or sets the name of the runbook.
	Name *string `json:"name,omitempty"`
}

// RunbookClientBeginPublishOptions contains the optional parameters for the RunbookClient.BeginPublish method.
type RunbookClientBeginPublishOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RunbookClientCreateOrUpdateOptions contains the optional parameters for the RunbookClient.CreateOrUpdate method.
type RunbookClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// RunbookClientDeleteOptions contains the optional parameters for the RunbookClient.Delete method.
type RunbookClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RunbookClientGetContentOptions contains the optional parameters for the RunbookClient.GetContent method.
type RunbookClientGetContentOptions struct {
	// placeholder for future optional parameters
}

// RunbookClientGetOptions contains the optional parameters for the RunbookClient.Get method.
type RunbookClientGetOptions struct {
	// placeholder for future optional parameters
}

// RunbookClientListByAutomationAccountOptions contains the optional parameters for the RunbookClient.ListByAutomationAccount
// method.
type RunbookClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// RunbookClientUpdateOptions contains the optional parameters for the RunbookClient.Update method.
type RunbookClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// RunbookCreateOrUpdateDraftParameters - The parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateDraftParameters struct {
	// REQUIRED; Content of the Runbook.
	RunbookContent *string `json:"runbookContent,omitempty"`
}

// RunbookCreateOrUpdateDraftProperties - The parameters supplied to the create or update draft runbook properties.
type RunbookCreateOrUpdateDraftProperties struct {
	// REQUIRED; Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`

	// REQUIRED; Gets or sets the type of the runbook.
	RunbookType *RunbookTypeEnum `json:"runbookType,omitempty"`

	// Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`

	// Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`

	// Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`

	// Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
}

// RunbookCreateOrUpdateParameters - The parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets runbook create or update properties.
	Properties *RunbookCreateOrUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// RunbookCreateOrUpdateProperties - The parameters supplied to the create or update runbook properties.
type RunbookCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the type of the runbook.
	RunbookType *RunbookTypeEnum `json:"runbookType,omitempty"`

	// Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`

	// Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`

	// Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`

	// Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`

	// Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`

	// Gets or sets the published runbook content link.
	PublishContentLink *ContentLink `json:"publishContentLink,omitempty"`
}

type RunbookDraft struct {
	// Gets or sets the creation time of the runbook draft.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the draft runbook content link.
	DraftContentLink *ContentLink `json:"draftContentLink,omitempty"`

	// Gets or sets whether runbook is in edit mode.
	InEdit *bool `json:"inEdit,omitempty"`

	// Gets or sets the last modified time of the runbook draft.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the runbook output types.
	OutputTypes []*string `json:"outputTypes,omitempty"`

	// Gets or sets the runbook draft parameters.
	Parameters map[string]*RunbookParameter `json:"parameters,omitempty"`
}

// RunbookDraftClientBeginReplaceContentOptions contains the optional parameters for the RunbookDraftClient.BeginReplaceContent
// method.
type RunbookDraftClientBeginReplaceContentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RunbookDraftClientGetContentOptions contains the optional parameters for the RunbookDraftClient.GetContent method.
type RunbookDraftClientGetContentOptions struct {
	// placeholder for future optional parameters
}

// RunbookDraftClientGetOptions contains the optional parameters for the RunbookDraftClient.Get method.
type RunbookDraftClientGetOptions struct {
	// placeholder for future optional parameters
}

// RunbookDraftClientUndoEditOptions contains the optional parameters for the RunbookDraftClient.UndoEdit method.
type RunbookDraftClientUndoEditOptions struct {
	// placeholder for future optional parameters
}

// RunbookDraftUndoEditResult - The response model for the undo edit runbook operation.
type RunbookDraftUndoEditResult struct {
	RequestID  *string         `json:"requestId,omitempty"`
	StatusCode *HTTPStatusCode `json:"statusCode,omitempty"`
}

// RunbookListResult - The response model for the list runbook operation.
type RunbookListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of runbooks.
	Value []*Runbook `json:"value,omitempty"`
}

// RunbookParameter - Definition of the runbook parameter type.
type RunbookParameter struct {
	// Gets or sets the default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`

	// Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
	IsMandatory *bool `json:"isMandatory,omitempty"`

	// Get or sets the position of the parameter.
	Position *int32 `json:"position,omitempty"`

	// Gets or sets the type of the parameter.
	Type *string `json:"type,omitempty"`
}

// RunbookProperties - Definition of the runbook property type.
type RunbookProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`

	// Gets or sets the job count of the runbook.
	JobCount *int32 `json:"jobCount,omitempty"`

	// Gets or sets the last modified by.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the option to log activity trace of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`

	// Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`

	// Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`

	// Gets or sets the runbook output types.
	OutputTypes []*string `json:"outputTypes,omitempty"`

	// Gets or sets the runbook parameters.
	Parameters map[string]*RunbookParameter `json:"parameters,omitempty"`

	// Gets or sets the provisioning state of the runbook.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Gets or sets the published runbook content link.
	PublishContentLink *ContentLink `json:"publishContentLink,omitempty"`

	// Gets or sets the type of the runbook.
	RunbookType *RunbookTypeEnum `json:"runbookType,omitempty"`

	// Gets or sets the state of the runbook.
	State *RunbookState `json:"state,omitempty"`
}

// RunbookUpdateParameters - The parameters supplied to the update runbook operation.
type RunbookUpdateParameters struct {
	// Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`

	// Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the runbook update properties.
	Properties *RunbookUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// RunbookUpdateProperties - The parameters supplied to the update runbook properties.
type RunbookUpdateProperties struct {
	// Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`

	// Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`

	// Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`

	// Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
}

// SKU - The account SKU.
type SKU struct {
	// REQUIRED; Gets or sets the SKU name of the account.
	Name *SKUNameEnum `json:"name,omitempty"`

	// Gets or sets the SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// Gets or sets the SKU family.
	Family *string `json:"family,omitempty"`
}

// SUCScheduleProperties - Definition of schedule parameters.
type SUCScheduleProperties struct {
	// Gets or sets the advanced schedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`

	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the end time of the schedule.
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// Gets or sets the expiry time's offset in minutes.
	ExpiryTimeOffsetMinutes *float64 `json:"expiryTimeOffsetMinutes,omitempty"`

	// Gets or sets the frequency of the schedule.
	Frequency *ScheduleFrequency `json:"frequency,omitempty"`

	// Gets or sets the interval of the schedule.
	Interval *int64 `json:"interval,omitempty"`

	// Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the next run time of the schedule.
	NextRun *time.Time `json:"nextRun,omitempty"`

	// Gets or sets the next run time's offset in minutes.
	NextRunOffsetMinutes *float64 `json:"nextRunOffsetMinutes,omitempty"`

	// Gets or sets the start time of the schedule.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`

	// READ-ONLY; Gets the start time's offset in minutes.
	StartTimeOffsetMinutes *float64 `json:"startTimeOffsetMinutes,omitempty" azure:"ro"`
}

// Schedule - Definition of the schedule.
type Schedule struct {
	// Gets or sets the properties of the schedule.
	Properties *ScheduleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScheduleAssociationProperty - The schedule property associated with the entity.
type ScheduleAssociationProperty struct {
	// Gets or sets the name of the Schedule.
	Name *string `json:"name,omitempty"`
}

// ScheduleClientCreateOrUpdateOptions contains the optional parameters for the ScheduleClient.CreateOrUpdate method.
type ScheduleClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScheduleClientDeleteOptions contains the optional parameters for the ScheduleClient.Delete method.
type ScheduleClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ScheduleClientGetOptions contains the optional parameters for the ScheduleClient.Get method.
type ScheduleClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScheduleClientListByAutomationAccountOptions contains the optional parameters for the ScheduleClient.ListByAutomationAccount
// method.
type ScheduleClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// ScheduleClientUpdateOptions contains the optional parameters for the ScheduleClient.Update method.
type ScheduleClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScheduleCreateOrUpdateParameters - The parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the Schedule.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the list of schedule properties.
	Properties *ScheduleCreateOrUpdateProperties `json:"properties,omitempty"`
}

// ScheduleCreateOrUpdateProperties - The parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the frequency of the schedule.
	Frequency *ScheduleFrequency `json:"frequency,omitempty"`

	// REQUIRED; Gets or sets the start time of the schedule.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or sets the AdvancedSchedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`

	// Gets or sets the description of the schedule.
	Description *string `json:"description,omitempty"`

	// Gets or sets the end time of the schedule.
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// Gets or sets the interval of the schedule.
	Interval interface{} `json:"interval,omitempty"`

	// Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`
}

// ScheduleListResult - The response model for the list schedule operation.
type ScheduleListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of schedules.
	Value []*Schedule `json:"value,omitempty"`
}

// ScheduleProperties - Definition of schedule parameters.
type ScheduleProperties struct {
	// Gets or sets the advanced schedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`

	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the end time of the schedule.
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// Gets or sets the expiry time's offset in minutes.
	ExpiryTimeOffsetMinutes *float64 `json:"expiryTimeOffsetMinutes,omitempty"`

	// Gets or sets the frequency of the schedule.
	Frequency *ScheduleFrequency `json:"frequency,omitempty"`

	// Gets or sets the interval of the schedule.
	Interval interface{} `json:"interval,omitempty"`

	// Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the next run time of the schedule.
	NextRun *time.Time `json:"nextRun,omitempty"`

	// Gets or sets the next run time's offset in minutes.
	NextRunOffsetMinutes *float64 `json:"nextRunOffsetMinutes,omitempty"`

	// Gets or sets the start time of the schedule.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`

	// READ-ONLY; Gets the start time's offset in minutes.
	StartTimeOffsetMinutes *float64 `json:"startTimeOffsetMinutes,omitempty" azure:"ro"`
}

// ScheduleUpdateParameters - The parameters supplied to the update schedule operation.
type ScheduleUpdateParameters struct {
	// Gets or sets the name of the Schedule.
	Name *string `json:"name,omitempty"`

	// Gets or sets the list of schedule properties.
	Properties *ScheduleUpdateProperties `json:"properties,omitempty"`
}

// ScheduleUpdateProperties - The parameters supplied to the update schedule operation.
type ScheduleUpdateProperties struct {
	// Gets or sets the description of the schedule.
	Description *string `json:"description,omitempty"`

	// Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// SoftwareUpdateConfiguration - Software update configuration properties.
type SoftwareUpdateConfiguration struct {
	// REQUIRED; Software update configuration properties.
	Properties *SoftwareUpdateConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationCollectionItem - Software update configuration collection item properties.
type SoftwareUpdateConfigurationCollectionItem struct {
	// REQUIRED; Software update configuration properties.
	Properties *SoftwareUpdateConfigurationCollectionItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id of the software update configuration
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the software update configuration.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationCollectionItemProperties - Software update configuration collection item properties.
type SoftwareUpdateConfigurationCollectionItemProperties struct {
	// execution frequency of the schedule associated with the software update configuration
	Frequency *ScheduleFrequency `json:"frequency,omitempty"`

	// ext run time of the update.
	NextRun *time.Time `json:"nextRun,omitempty"`

	// the start time of the update.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Pre and Post Tasks defined
	Tasks *SoftwareUpdateConfigurationTasks `json:"tasks,omitempty"`

	// Update specific properties of the software update configuration.
	UpdateConfiguration *UpdateConfiguration `json:"updateConfiguration,omitempty"`

	// READ-ONLY; Creation time of the software update configuration, which only appears in the response.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Last time software update configuration was modified, which only appears in the response.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state for the software update configuration, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationListResult - result of listing all software update configuration
type SoftwareUpdateConfigurationListResult struct {
	// outer object returned when listing all software update configurations
	Value []*SoftwareUpdateConfigurationCollectionItem `json:"value,omitempty"`
}

// SoftwareUpdateConfigurationMachineRun - Software update configuration machine run model.
type SoftwareUpdateConfigurationMachineRun struct {
	// Software update configuration machine run properties.
	Properties *UpdateConfigurationMachineRunProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id of the software update configuration machine run
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the software update configuration machine run
	Name *string `json:"name,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationMachineRunListResult - result of listing all software update configuration machine runs
type SoftwareUpdateConfigurationMachineRunListResult struct {
	// link to next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// outer object returned when listing all software update configuration machine runs
	Value []*SoftwareUpdateConfigurationMachineRun `json:"value,omitempty"`
}

// SoftwareUpdateConfigurationMachineRunsClientGetByIDOptions contains the optional parameters for the SoftwareUpdateConfigurationMachineRunsClient.GetByID
// method.
type SoftwareUpdateConfigurationMachineRunsClientGetByIDOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// SoftwareUpdateConfigurationMachineRunsClientListOptions contains the optional parameters for the SoftwareUpdateConfigurationMachineRunsClient.List
// method.
type SoftwareUpdateConfigurationMachineRunsClientListOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
	// The filter to apply on the operation. You can use the following filters: 'properties/osType', 'properties/status', 'properties/startTime',
	// and 'properties/softwareUpdateConfiguration/name'
	Filter *string
	// number of entries you skip before returning results
	Skip *string
	// Maximum number of entries returned in the results collection
	Top *string
}

// SoftwareUpdateConfigurationProperties - Software update configuration properties.
type SoftwareUpdateConfigurationProperties struct {
	// REQUIRED; Schedule information for the Software update configuration
	ScheduleInfo *SUCScheduleProperties `json:"scheduleInfo,omitempty"`

	// REQUIRED; update specific properties for the Software update configuration
	UpdateConfiguration *UpdateConfiguration `json:"updateConfiguration,omitempty"`

	// Details of provisioning error
	Error *ErrorResponse `json:"error,omitempty"`

	// Tasks information for the Software update configuration.
	Tasks *SoftwareUpdateConfigurationTasks `json:"tasks,omitempty"`

	// READ-ONLY; CreatedBy property, which only appears in the response.
	CreatedBy *string `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; LastModifiedBy property, which only appears in the response.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state for the software update configuration, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationRun - Software update configuration Run properties.
type SoftwareUpdateConfigurationRun struct {
	// Software update configuration Run properties.
	Properties *SoftwareUpdateConfigurationRunProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id of the software update configuration run
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the software update configuration run.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationRunListResult - result of listing all software update configuration runs
type SoftwareUpdateConfigurationRunListResult struct {
	// link to next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// outer object returned when listing all software update configuration runs
	Value []*SoftwareUpdateConfigurationRun `json:"value,omitempty"`
}

// SoftwareUpdateConfigurationRunProperties - Software update configuration properties.
type SoftwareUpdateConfigurationRunProperties struct {
	// software update configuration triggered this run
	SoftwareUpdateConfiguration *UpdateConfigurationNavigation `json:"softwareUpdateConfiguration,omitempty"`

	// Software update configuration tasks triggered in this run
	Tasks *SoftwareUpdateConfigurationRunTasks `json:"tasks,omitempty"`

	// READ-ONLY; Number of computers in the software update configuration run.
	ComputerCount *int32 `json:"computerCount,omitempty" azure:"ro"`

	// READ-ONLY; Configured duration for the software update configuration run.
	ConfiguredDuration *string `json:"configuredDuration,omitempty" azure:"ro"`

	// READ-ONLY; CreatedBy property, which only appears in the response.
	CreatedBy *string `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; End time of the software update configuration run.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Number of computers with failed status.
	FailedCount *int32 `json:"failedCount,omitempty" azure:"ro"`

	// READ-ONLY; LastModifiedBy property, which only appears in the response.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Operating system target of the software update configuration triggered this run
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the software update configuration run.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Status of the software update configuration run.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// SoftwareUpdateConfigurationRunTaskProperties - Task properties of the software update configuration.
type SoftwareUpdateConfigurationRunTaskProperties struct {
	// The job id of the task.
	JobID *string `json:"jobId,omitempty"`

	// The name of the source of the task.
	Source *string `json:"source,omitempty"`

	// The status of the task.
	Status *string `json:"status,omitempty"`
}

// SoftwareUpdateConfigurationRunTasks - Software update configuration run tasks model.
type SoftwareUpdateConfigurationRunTasks struct {
	// Post task properties.
	PostTask *SoftwareUpdateConfigurationRunTaskProperties `json:"postTask,omitempty"`

	// Pre task properties.
	PreTask *SoftwareUpdateConfigurationRunTaskProperties `json:"preTask,omitempty"`
}

// SoftwareUpdateConfigurationRunsClientGetByIDOptions contains the optional parameters for the SoftwareUpdateConfigurationRunsClient.GetByID
// method.
type SoftwareUpdateConfigurationRunsClientGetByIDOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// SoftwareUpdateConfigurationRunsClientListOptions contains the optional parameters for the SoftwareUpdateConfigurationRunsClient.List
// method.
type SoftwareUpdateConfigurationRunsClientListOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
	// The filter to apply on the operation. You can use the following filters: 'properties/osType', 'properties/status', 'properties/startTime',
	// and 'properties/softwareUpdateConfiguration/name'
	Filter *string
	// Number of entries you skip before returning results
	Skip *string
	// Maximum number of entries returned in the results collection
	Top *string
}

// SoftwareUpdateConfigurationTasks - Task properties of the software update configuration.
type SoftwareUpdateConfigurationTasks struct {
	// Post task properties.
	PostTask *TaskProperties `json:"postTask,omitempty"`

	// Pre task properties.
	PreTask *TaskProperties `json:"preTask,omitempty"`
}

// SoftwareUpdateConfigurationsClientCreateOptions contains the optional parameters for the SoftwareUpdateConfigurationsClient.Create
// method.
type SoftwareUpdateConfigurationsClientCreateOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// SoftwareUpdateConfigurationsClientDeleteOptions contains the optional parameters for the SoftwareUpdateConfigurationsClient.Delete
// method.
type SoftwareUpdateConfigurationsClientDeleteOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// SoftwareUpdateConfigurationsClientGetByNameOptions contains the optional parameters for the SoftwareUpdateConfigurationsClient.GetByName
// method.
type SoftwareUpdateConfigurationsClientGetByNameOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
}

// SoftwareUpdateConfigurationsClientListOptions contains the optional parameters for the SoftwareUpdateConfigurationsClient.List
// method.
type SoftwareUpdateConfigurationsClientListOptions struct {
	// Identifies this specific client request.
	ClientRequestID *string
	// The filter to apply on the operation.
	Filter *string
}

// SourceControl - Definition of the source control.
type SourceControl struct {
	// The properties of the source control.
	Properties *SourceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SourceControlClientCreateOrUpdateOptions contains the optional parameters for the SourceControlClient.CreateOrUpdate method.
type SourceControlClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SourceControlClientDeleteOptions contains the optional parameters for the SourceControlClient.Delete method.
type SourceControlClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SourceControlClientGetOptions contains the optional parameters for the SourceControlClient.Get method.
type SourceControlClientGetOptions struct {
	// placeholder for future optional parameters
}

// SourceControlClientListByAutomationAccountOptions contains the optional parameters for the SourceControlClient.ListByAutomationAccount
// method.
type SourceControlClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// SourceControlClientUpdateOptions contains the optional parameters for the SourceControlClient.Update method.
type SourceControlClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SourceControlCreateOrUpdateParameters - The parameters supplied to the create or update source control operation.
type SourceControlCreateOrUpdateParameters struct {
	// REQUIRED; The properties of the source control.
	Properties *SourceControlCreateOrUpdateProperties `json:"properties,omitempty"`
}

// SourceControlCreateOrUpdateProperties - The properties of the create source control operation.
type SourceControlCreateOrUpdateProperties struct {
	// The auto async of the source control. Default is false.
	AutoSync *bool `json:"autoSync,omitempty"`

	// The repo branch of the source control. Include branch as empty string for VsoTfvc.
	Branch *string `json:"branch,omitempty"`

	// The user description of the source control.
	Description *string `json:"description,omitempty"`

	// The folder path of the source control. Path must be relative.
	FolderPath *string `json:"folderPath,omitempty"`

	// The auto publish of the source control. Default is true.
	PublishRunbook *bool `json:"publishRunbook,omitempty"`

	// The repo url of the source control.
	RepoURL *string `json:"repoUrl,omitempty"`

	// The authorization token for the repo of the source control.
	SecurityToken *SourceControlSecurityTokenProperties `json:"securityToken,omitempty"`

	// The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
	SourceType *SourceType `json:"sourceType,omitempty"`
}

// SourceControlListResult - The response model for the list source controls operation.
type SourceControlListResult struct {
	// The next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of source controls.
	Value []*SourceControl `json:"value,omitempty"`
}

// SourceControlProperties - Definition of the source control properties
type SourceControlProperties struct {
	// The auto sync of the source control. Default is false.
	AutoSync *bool `json:"autoSync,omitempty"`

	// The repo branch of the source control. Include branch as empty string for VsoTfvc.
	Branch *string `json:"branch,omitempty"`

	// The creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// The description.
	Description *string `json:"description,omitempty"`

	// The folder path of the source control.
	FolderPath *string `json:"folderPath,omitempty"`

	// The last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// The auto publish of the source control. Default is true.
	PublishRunbook *bool `json:"publishRunbook,omitempty"`

	// The repo url of the source control.
	RepoURL *string `json:"repoUrl,omitempty"`

	// The source type. Must be one of VsoGit, VsoTfvc, GitHub.
	SourceType *SourceType `json:"sourceType,omitempty"`
}

type SourceControlSecurityTokenProperties struct {
	// The access token.
	AccessToken *string `json:"accessToken,omitempty"`

	// The refresh token.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// The token type. Must be either PersonalAccessToken or Oauth.
	TokenType *TokenType `json:"tokenType,omitempty"`
}

// SourceControlSyncJob - Definition of the source control sync job.
type SourceControlSyncJob struct {
	// The properties of the source control sync job.
	Properties *SourceControlSyncJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SourceControlSyncJobByID - Definition of the source control sync job.
type SourceControlSyncJobByID struct {
	// The id of the job.
	ID *string `json:"id,omitempty"`

	// The properties of the source control sync job.
	Properties *SourceControlSyncJobByIDProperties `json:"properties,omitempty"`
}

// SourceControlSyncJobByIDProperties - Definition of source control sync job properties.
type SourceControlSyncJobByIDProperties struct {
	// The exceptions that occurred while running the sync job.
	Exception *string `json:"exception,omitempty"`

	// The provisioning state of the job.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// The source control sync job id.
	SourceControlSyncJobID *string `json:"sourceControlSyncJobId,omitempty"`

	// The sync type.
	SyncType *SyncType `json:"syncType,omitempty"`

	// READ-ONLY; The creation time of the job.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the job.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the job.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// SourceControlSyncJobClientCreateOptions contains the optional parameters for the SourceControlSyncJobClient.Create method.
type SourceControlSyncJobClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SourceControlSyncJobClientGetOptions contains the optional parameters for the SourceControlSyncJobClient.Get method.
type SourceControlSyncJobClientGetOptions struct {
	// placeholder for future optional parameters
}

// SourceControlSyncJobClientListByAutomationAccountOptions contains the optional parameters for the SourceControlSyncJobClient.ListByAutomationAccount
// method.
type SourceControlSyncJobClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// SourceControlSyncJobCreateParameters - The parameters supplied to the create source control sync job operation.
type SourceControlSyncJobCreateParameters struct {
	// REQUIRED; The properties of the source control sync job.
	Properties *SourceControlSyncJobCreateProperties `json:"properties,omitempty"`
}

// SourceControlSyncJobCreateProperties - Definition of create source control sync job properties.
type SourceControlSyncJobCreateProperties struct {
	// REQUIRED; The commit id of the source control sync job. If not syncing to a commitId, enter an empty string.
	CommitID *string `json:"commitId,omitempty"`
}

// SourceControlSyncJobListResult - The response model for the list source control sync jobs operation.
type SourceControlSyncJobListResult struct {
	// The next link.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of source control sync jobs.
	Value []*SourceControlSyncJob `json:"value,omitempty"`
}

// SourceControlSyncJobProperties - Definition of source control sync job properties.
type SourceControlSyncJobProperties struct {
	// The provisioning state of the job.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// The source control sync job id.
	SourceControlSyncJobID *string `json:"sourceControlSyncJobId,omitempty"`

	// The sync type.
	SyncType *SyncType `json:"syncType,omitempty"`

	// READ-ONLY; The creation time of the job.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the job.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the job.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// SourceControlSyncJobStream - Definition of the source control sync job stream.
type SourceControlSyncJobStream struct {
	// The properties of the source control sync job stream.
	Properties *SourceControlSyncJobStreamProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SourceControlSyncJobStreamByID - Definition of the source control sync job stream by id.
type SourceControlSyncJobStreamByID struct {
	// The properties of the source control sync job stream.
	Properties *SourceControlSyncJobStreamByIDProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SourceControlSyncJobStreamByIDProperties - Definition of source control sync job stream by id properties.
type SourceControlSyncJobStreamByIDProperties struct {
	// The sync job stream id.
	SourceControlSyncJobStreamID *string `json:"sourceControlSyncJobStreamId,omitempty"`

	// The text of the sync job stream.
	StreamText *string `json:"streamText,omitempty"`

	// The type of the sync job stream.
	StreamType *StreamType `json:"streamType,omitempty"`

	// The summary of the sync job stream.
	Summary *string `json:"summary,omitempty"`

	// The values of the job stream.
	Value map[string]interface{} `json:"value,omitempty"`

	// READ-ONLY; The time of the sync job stream.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// SourceControlSyncJobStreamProperties - Definition of source control sync job stream properties.
type SourceControlSyncJobStreamProperties struct {
	// The sync job stream id.
	SourceControlSyncJobStreamID *string `json:"sourceControlSyncJobStreamId,omitempty"`

	// The type of the sync job stream.
	StreamType *StreamType `json:"streamType,omitempty"`

	// The summary of the sync job stream.
	Summary *string `json:"summary,omitempty"`

	// READ-ONLY; The time of the sync job stream.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// SourceControlSyncJobStreamsClientGetOptions contains the optional parameters for the SourceControlSyncJobStreamsClient.Get
// method.
type SourceControlSyncJobStreamsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SourceControlSyncJobStreamsClientListBySyncJobOptions contains the optional parameters for the SourceControlSyncJobStreamsClient.ListBySyncJob
// method.
type SourceControlSyncJobStreamsClientListBySyncJobOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// SourceControlSyncJobStreamsListBySyncJob - The response model for the list source control sync job streams operation.
type SourceControlSyncJobStreamsListBySyncJob struct {
	// The list of source control sync job streams.
	Value []*SourceControlSyncJobStream `json:"value,omitempty"`

	// READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SourceControlUpdateParameters - The parameters supplied to the update source control operation.
type SourceControlUpdateParameters struct {
	// The value of the source control.
	Properties *SourceControlUpdateProperties `json:"properties,omitempty"`
}

// SourceControlUpdateProperties - The properties of the update source control
type SourceControlUpdateProperties struct {
	// The auto sync of the source control. Default is false.
	AutoSync *bool `json:"autoSync,omitempty"`

	// The repo branch of the source control.
	Branch *string `json:"branch,omitempty"`

	// The user description of the source control.
	Description *string `json:"description,omitempty"`

	// The folder path of the source control. Path must be relative.
	FolderPath *string `json:"folderPath,omitempty"`

	// The auto publish of the source control. Default is true.
	PublishRunbook *bool `json:"publishRunbook,omitempty"`

	// The authorization token for the repo of the source control.
	SecurityToken *SourceControlSecurityTokenProperties `json:"securityToken,omitempty"`
}

// Statistics - Definition of the statistic.
type Statistics struct {
	// READ-ONLY; Gets the property value of the statistic.
	CounterProperty *string `json:"counterProperty,omitempty" azure:"ro"`

	// READ-ONLY; Gets the value of the statistic.
	CounterValue *int64 `json:"counterValue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the endTime of the statistic.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the startTime of the statistic.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// StatisticsClientListByAutomationAccountOptions contains the optional parameters for the StatisticsClient.ListByAutomationAccount
// method.
type StatisticsClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// StatisticsListResult - The response model for the list statistics operation.
type StatisticsListResult struct {
	// Gets or sets a list of statistics.
	Value []*Statistics `json:"value,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagSettingsProperties - Tag filter information for the VM.
type TagSettingsProperties struct {
	// Filter VMs by Any or All specified tags.
	FilterOperator *TagOperators `json:"filterOperator,omitempty"`

	// Dictionary of tags with its list of values.
	Tags map[string][]*string `json:"tags,omitempty"`
}

// TargetProperties - Group specific to the update configuration.
type TargetProperties struct {
	// List of Azure queries in the software update configuration.
	AzureQueries []*AzureQueryProperties `json:"azureQueries,omitempty"`

	// List of non Azure queries in the software update configuration.
	NonAzureQueries []*NonAzureQueryProperties `json:"nonAzureQueries,omitempty"`
}

// TaskProperties - Task properties of the software update configuration.
type TaskProperties struct {
	// Gets or sets the parameters of the task.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the name of the runbook.
	Source *string `json:"source,omitempty"`
}

// TestJob - Definition of the test job.
type TestJob struct {
	// Gets or sets the creation time of the test job.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the end time of the test job.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Gets or sets the exception of the test job.
	Exception *string `json:"exception,omitempty"`

	// Gets or sets the last modified time of the test job.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the last status modified time of the test job.
	LastStatusModifiedTime *time.Time `json:"lastStatusModifiedTime,omitempty"`

	// The activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`

	// Gets or sets the parameters of the test job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the start time of the test job.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or sets the status of the test job.
	Status *string `json:"status,omitempty"`

	// Gets or sets the status details of the test job.
	StatusDetails *string `json:"statusDetails,omitempty"`
}

// TestJobClientCreateOptions contains the optional parameters for the TestJobClient.Create method.
type TestJobClientCreateOptions struct {
	// placeholder for future optional parameters
}

// TestJobClientGetOptions contains the optional parameters for the TestJobClient.Get method.
type TestJobClientGetOptions struct {
	// placeholder for future optional parameters
}

// TestJobClientResumeOptions contains the optional parameters for the TestJobClient.Resume method.
type TestJobClientResumeOptions struct {
	// placeholder for future optional parameters
}

// TestJobClientStopOptions contains the optional parameters for the TestJobClient.Stop method.
type TestJobClientStopOptions struct {
	// placeholder for future optional parameters
}

// TestJobClientSuspendOptions contains the optional parameters for the TestJobClient.Suspend method.
type TestJobClientSuspendOptions struct {
	// placeholder for future optional parameters
}

// TestJobCreateParameters - The parameters supplied to the create test job operation.
type TestJobCreateParameters struct {
	// Gets or sets the parameters of the test job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
}

// TestJobStreamsClientGetOptions contains the optional parameters for the TestJobStreamsClient.Get method.
type TestJobStreamsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TestJobStreamsClientListByTestJobOptions contains the optional parameters for the TestJobStreamsClient.ListByTestJob method.
type TestJobStreamsClientListByTestJobOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TypeField - Information about a field of a type.
type TypeField struct {
	// Gets or sets the name of the field.
	Name *string `json:"name,omitempty"`

	// Gets or sets the type of the field.
	Type *string `json:"type,omitempty"`
}

// TypeFieldListResult - The response model for the list fields operation.
type TypeFieldListResult struct {
	// Gets or sets a list of fields.
	Value []*TypeField `json:"value,omitempty"`
}

// UpdateConfiguration - Update specific properties of the software update configuration.
type UpdateConfiguration struct {
	// REQUIRED; operating system of target machines
	OperatingSystem *OperatingSystemType `json:"operatingSystem,omitempty"`

	// List of azure resource Ids for azure virtual machines targeted by the software update configuration.
	AzureVirtualMachines []*string `json:"azureVirtualMachines,omitempty"`

	// Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S
	// as per ISO8601
	Duration *string `json:"duration,omitempty"`

	// Linux specific update configuration.
	Linux *LinuxProperties `json:"linux,omitempty"`

	// List of names of non-azure machines targeted by the software update configuration.
	NonAzureComputerNames []*string `json:"nonAzureComputerNames,omitempty"`

	// Group targets for the software update configuration.
	Targets *TargetProperties `json:"targets,omitempty"`

	// Windows specific update configuration.
	Windows *WindowsProperties `json:"windows,omitempty"`
}

// UpdateConfigurationMachineRunProperties - Software update configuration machine run properties.
type UpdateConfigurationMachineRunProperties struct {
	// Details of provisioning error
	Error *ErrorResponse `json:"error,omitempty"`

	// Job associated with the software update configuration machine run
	Job *JobNavigation `json:"job,omitempty"`

	// software update configuration triggered this run
	SoftwareUpdateConfiguration *UpdateConfigurationNavigation `json:"softwareUpdateConfiguration,omitempty"`

	// READ-ONLY; configured duration for the software update configuration run.
	ConfiguredDuration *string `json:"configuredDuration,omitempty" azure:"ro"`

	// READ-ONLY; correlation id of the software update configuration machine run
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; createdBy property, which only appears in the response.
	CreatedBy *string `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; End time of the software update configuration machine run.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; lastModifiedBy property, which only appears in the response.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Operating system target of the software update configuration triggered this run
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; source computer id of the software update configuration machine run
	SourceComputerID *string `json:"sourceComputerId,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the software update configuration machine run.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Status of the software update configuration machine run.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; name of the updated computer
	TargetComputer *string `json:"targetComputer,omitempty" azure:"ro"`

	// READ-ONLY; type of the updated computer.
	TargetComputerType *string `json:"targetComputerType,omitempty" azure:"ro"`
}

// UpdateConfigurationNavigation - Software update configuration Run Navigation model.
type UpdateConfigurationNavigation struct {
	// READ-ONLY; Name of the software update configuration triggered the software update configuration run
	Name *string `json:"name,omitempty" azure:"ro"`
}

// Usage - Definition of Usage.
type Usage struct {
	// Gets or sets the current usage value.
	CurrentValue *float64 `json:"currentValue,omitempty"`

	// Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`

	// Gets or sets max limit. -1 for unlimited
	Limit *int64 `json:"limit,omitempty"`

	// Gets or sets the usage counter name.
	Name *UsageCounterName `json:"name,omitempty"`

	// Gets or sets the throttle status.
	ThrottleStatus *string `json:"throttleStatus,omitempty"`

	// Gets or sets the usage unit name.
	Unit *string `json:"unit,omitempty"`
}

// UsageCounterName - Definition of usage counter name.
type UsageCounterName struct {
	// Gets or sets the localized usage counter name.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// Gets or sets the usage counter name.
	Value *string `json:"value,omitempty"`
}

// UsageListResult - The response model for the get usage operation.
type UsageListResult struct {
	// Gets or sets usage.
	Value []*Usage `json:"value,omitempty"`
}

// UsagesClientListByAutomationAccountOptions contains the optional parameters for the UsagesClient.ListByAutomationAccount
// method.
type UsagesClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// Variable - Definition of the variable.
type Variable struct {
	// Gets or sets the properties of the variable.
	Properties *VariableProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VariableClientCreateOrUpdateOptions contains the optional parameters for the VariableClient.CreateOrUpdate method.
type VariableClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// VariableClientDeleteOptions contains the optional parameters for the VariableClient.Delete method.
type VariableClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VariableClientGetOptions contains the optional parameters for the VariableClient.Get method.
type VariableClientGetOptions struct {
	// placeholder for future optional parameters
}

// VariableClientListByAutomationAccountOptions contains the optional parameters for the VariableClient.ListByAutomationAccount
// method.
type VariableClientListByAutomationAccountOptions struct {
	// placeholder for future optional parameters
}

// VariableClientUpdateOptions contains the optional parameters for the VariableClient.Update method.
type VariableClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VariableCreateOrUpdateParameters - The parameters supplied to the create or update variable operation.
type VariableCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the variable.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the properties of the variable.
	Properties *VariableCreateOrUpdateProperties `json:"properties,omitempty"`
}

// VariableCreateOrUpdateProperties - The properties of the create variable operation.
type VariableCreateOrUpdateProperties struct {
	// Gets or sets the description of the variable.
	Description *string `json:"description,omitempty"`

	// Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`

	// Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
}

// VariableListResult - The response model for the list variables operation.
type VariableListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of variables.
	Value []*Variable `json:"value,omitempty"`
}

// VariableProperties - Definition of the variable properties
type VariableProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
}

// VariableUpdateParameters - The parameters supplied to the update variable operation.
type VariableUpdateParameters struct {
	// Gets or sets the name of the variable.
	Name *string `json:"name,omitempty"`

	// Gets or sets the value of the variable.
	Properties *VariableUpdateProperties `json:"properties,omitempty"`
}

// VariableUpdateProperties - The properties of the update variable
type VariableUpdateProperties struct {
	// Gets or sets the description of the variable.
	Description *string `json:"description,omitempty"`

	// Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
}

// Watcher - Definition of the watcher type.
type Watcher struct {
	// Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Gets or sets the watcher properties.
	Properties *WatcherProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WatcherClientCreateOrUpdateOptions contains the optional parameters for the WatcherClient.CreateOrUpdate method.
type WatcherClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WatcherClientDeleteOptions contains the optional parameters for the WatcherClient.Delete method.
type WatcherClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WatcherClientGetOptions contains the optional parameters for the WatcherClient.Get method.
type WatcherClientGetOptions struct {
	// placeholder for future optional parameters
}

// WatcherClientListByAutomationAccountOptions contains the optional parameters for the WatcherClient.ListByAutomationAccount
// method.
type WatcherClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// WatcherClientStartOptions contains the optional parameters for the WatcherClient.Start method.
type WatcherClientStartOptions struct {
	// placeholder for future optional parameters
}

// WatcherClientStopOptions contains the optional parameters for the WatcherClient.Stop method.
type WatcherClientStopOptions struct {
	// placeholder for future optional parameters
}

// WatcherClientUpdateOptions contains the optional parameters for the WatcherClient.Update method.
type WatcherClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// WatcherListResult - The response model for the list watcher operation.
type WatcherListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of watchers.
	Value []*Watcher `json:"value,omitempty"`
}

// WatcherProperties - Definition of the watcher properties
type WatcherProperties struct {
	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the frequency at which the watcher is invoked.
	ExecutionFrequencyInSeconds *int64 `json:"executionFrequencyInSeconds,omitempty"`

	// Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
	ScriptName *string `json:"scriptName,omitempty"`

	// Gets or sets the parameters of the script.
	ScriptParameters map[string]*string `json:"scriptParameters,omitempty"`

	// Gets or sets the name of the hybrid worker group the watcher will run on.
	ScriptRunOn *string `json:"scriptRunOn,omitempty"`

	// READ-ONLY; Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Details of the user who last modified the watcher.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the current status of the watcher.
	Status *string `json:"status,omitempty" azure:"ro"`
}

type WatcherUpdateParameters struct {
	// Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`

	// Gets or sets the watcher update properties.
	Properties *WatcherUpdateProperties `json:"properties,omitempty"`
}

// WatcherUpdateProperties - The properties of the update watcher operation.
type WatcherUpdateProperties struct {
	// Gets or sets the frequency at which the watcher is invoked.
	ExecutionFrequencyInSeconds *int64 `json:"executionFrequencyInSeconds,omitempty"`
}

// Webhook - Definition of the webhook type.
type Webhook struct {
	// Gets or sets the webhook properties.
	Properties *WebhookProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebhookClientCreateOrUpdateOptions contains the optional parameters for the WebhookClient.CreateOrUpdate method.
type WebhookClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WebhookClientDeleteOptions contains the optional parameters for the WebhookClient.Delete method.
type WebhookClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WebhookClientGenerateURIOptions contains the optional parameters for the WebhookClient.GenerateURI method.
type WebhookClientGenerateURIOptions struct {
	// placeholder for future optional parameters
}

// WebhookClientGetOptions contains the optional parameters for the WebhookClient.Get method.
type WebhookClientGetOptions struct {
	// placeholder for future optional parameters
}

// WebhookClientListByAutomationAccountOptions contains the optional parameters for the WebhookClient.ListByAutomationAccount
// method.
type WebhookClientListByAutomationAccountOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// WebhookClientUpdateOptions contains the optional parameters for the WebhookClient.Update method.
type WebhookClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// WebhookCreateOrUpdateParameters - The parameters supplied to the create or update webhook operation.
type WebhookCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Gets or sets the properties of the webhook.
	Properties *WebhookCreateOrUpdateProperties `json:"properties,omitempty"`
}

// WebhookCreateOrUpdateProperties - The properties of the create webhook operation.
type WebhookCreateOrUpdateProperties struct {
	// Gets or sets the expiry time.
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`

	// Gets or sets the uri.
	URI *string `json:"uri,omitempty"`
}

// WebhookListResult - The response model for the list webhook operation.
type WebhookListResult struct {
	// Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets a list of webhooks.
	Value []*Webhook `json:"value,omitempty"`
}

// WebhookProperties - Definition of the webhook properties
type WebhookProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// Gets or sets the description.
	Description *string `json:"description,omitempty"`

	// Gets or sets the expiry time.
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// Gets or sets the value of the enabled flag of the webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Gets or sets the last invoked time.
	LastInvokedTime *time.Time `json:"lastInvokedTime,omitempty"`

	// Details of the user who last modified the Webhook
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty"`

	// Gets or sets the parameters of the job that is created when the webhook calls the runbook it is associated with.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`

	// Gets or sets the runbook the webhook is associated with.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`

	// Gets or sets the webhook uri.
	URI *string `json:"uri,omitempty"`
}

// WebhookUpdateParameters - The parameters supplied to the update webhook operation.
type WebhookUpdateParameters struct {
	// Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`

	// Gets or sets the value of the webhook.
	Properties *WebhookUpdateProperties `json:"properties,omitempty"`
}

// WebhookUpdateProperties - The properties of the update webhook.
type WebhookUpdateProperties struct {
	// Gets or sets the description of the webhook.
	Description *string `json:"description,omitempty"`

	// Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters,omitempty"`

	// Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
}

// WindowsProperties - Windows specific update configuration.
type WindowsProperties struct {
	// KB numbers excluded from the software update configuration.
	ExcludedKbNumbers []*string `json:"excludedKbNumbers,omitempty"`

	// KB numbers included from the software update configuration.
	IncludedKbNumbers []*string `json:"includedKbNumbers,omitempty"`

	// Update classification included in the software update configuration. A comma separated string with required values
	IncludedUpdateClassifications *WindowsUpdateClasses `json:"includedUpdateClassifications,omitempty"`

	// Reboot setting for the software update configuration.
	RebootSetting *string `json:"rebootSetting,omitempty"`
}
