// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

package analyticshubpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the listing.
type Listing_State int32

const (
	// Default value. This value is unused.
	Listing_STATE_UNSPECIFIED Listing_State = 0
	// Subscribable state. Users with dataexchange.listings.subscribe permission
	// can subscribe to this listing.
	Listing_ACTIVE Listing_State = 1
)

// Enum value maps for Listing_State.
var (
	Listing_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
	}
	Listing_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
	}
)

func (x Listing_State) Enum() *Listing_State {
	p := new(Listing_State)
	*p = x
	return p
}

func (x Listing_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Listing_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes[0].Descriptor()
}

func (Listing_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes[0]
}

func (x Listing_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Listing_State.Descriptor instead.
func (Listing_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{6, 0}
}

// Listing categories.
type Listing_Category int32

const (
	Listing_CATEGORY_UNSPECIFIED                  Listing_Category = 0
	Listing_CATEGORY_OTHERS                       Listing_Category = 1
	Listing_CATEGORY_ADVERTISING_AND_MARKETING    Listing_Category = 2
	Listing_CATEGORY_COMMERCE                     Listing_Category = 3
	Listing_CATEGORY_CLIMATE_AND_ENVIRONMENT      Listing_Category = 4
	Listing_CATEGORY_DEMOGRAPHICS                 Listing_Category = 5
	Listing_CATEGORY_ECONOMICS                    Listing_Category = 6
	Listing_CATEGORY_EDUCATION                    Listing_Category = 7
	Listing_CATEGORY_ENERGY                       Listing_Category = 8
	Listing_CATEGORY_FINANCIAL                    Listing_Category = 9
	Listing_CATEGORY_GAMING                       Listing_Category = 10
	Listing_CATEGORY_GEOSPATIAL                   Listing_Category = 11
	Listing_CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE  Listing_Category = 12
	Listing_CATEGORY_MEDIA                        Listing_Category = 13
	Listing_CATEGORY_PUBLIC_SECTOR                Listing_Category = 14
	Listing_CATEGORY_RETAIL                       Listing_Category = 15
	Listing_CATEGORY_SPORTS                       Listing_Category = 16
	Listing_CATEGORY_SCIENCE_AND_RESEARCH         Listing_Category = 17
	Listing_CATEGORY_TRANSPORTATION_AND_LOGISTICS Listing_Category = 18
	Listing_CATEGORY_TRAVEL_AND_TOURISM           Listing_Category = 19
)

// Enum value maps for Listing_Category.
var (
	Listing_Category_name = map[int32]string{
		0:  "CATEGORY_UNSPECIFIED",
		1:  "CATEGORY_OTHERS",
		2:  "CATEGORY_ADVERTISING_AND_MARKETING",
		3:  "CATEGORY_COMMERCE",
		4:  "CATEGORY_CLIMATE_AND_ENVIRONMENT",
		5:  "CATEGORY_DEMOGRAPHICS",
		6:  "CATEGORY_ECONOMICS",
		7:  "CATEGORY_EDUCATION",
		8:  "CATEGORY_ENERGY",
		9:  "CATEGORY_FINANCIAL",
		10: "CATEGORY_GAMING",
		11: "CATEGORY_GEOSPATIAL",
		12: "CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE",
		13: "CATEGORY_MEDIA",
		14: "CATEGORY_PUBLIC_SECTOR",
		15: "CATEGORY_RETAIL",
		16: "CATEGORY_SPORTS",
		17: "CATEGORY_SCIENCE_AND_RESEARCH",
		18: "CATEGORY_TRANSPORTATION_AND_LOGISTICS",
		19: "CATEGORY_TRAVEL_AND_TOURISM",
	}
	Listing_Category_value = map[string]int32{
		"CATEGORY_UNSPECIFIED":                  0,
		"CATEGORY_OTHERS":                       1,
		"CATEGORY_ADVERTISING_AND_MARKETING":    2,
		"CATEGORY_COMMERCE":                     3,
		"CATEGORY_CLIMATE_AND_ENVIRONMENT":      4,
		"CATEGORY_DEMOGRAPHICS":                 5,
		"CATEGORY_ECONOMICS":                    6,
		"CATEGORY_EDUCATION":                    7,
		"CATEGORY_ENERGY":                       8,
		"CATEGORY_FINANCIAL":                    9,
		"CATEGORY_GAMING":                       10,
		"CATEGORY_GEOSPATIAL":                   11,
		"CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE":  12,
		"CATEGORY_MEDIA":                        13,
		"CATEGORY_PUBLIC_SECTOR":                14,
		"CATEGORY_RETAIL":                       15,
		"CATEGORY_SPORTS":                       16,
		"CATEGORY_SCIENCE_AND_RESEARCH":         17,
		"CATEGORY_TRANSPORTATION_AND_LOGISTICS": 18,
		"CATEGORY_TRAVEL_AND_TOURISM":           19,
	}
)

func (x Listing_Category) Enum() *Listing_Category {
	p := new(Listing_Category)
	*p = x
	return p
}

func (x Listing_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Listing_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes[1].Descriptor()
}

func (Listing_Category) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes[1]
}

func (x Listing_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Listing_Category.Descriptor instead.
func (Listing_Category) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{6, 1}
}

// State of the subscription.
type Subscription_State int32

const (
	// Default value. This value is unused.
	Subscription_STATE_UNSPECIFIED Subscription_State = 0
	// This subscription is active and the data is accessible.
	Subscription_STATE_ACTIVE Subscription_State = 1
	// The data referenced by this subscription is out of date and should be
	// refreshed. This can happen when a data provider adds or removes datasets.
	Subscription_STATE_STALE Subscription_State = 2
	// This subscription has been cancelled or revoked and the data is no longer
	// accessible.
	Subscription_STATE_INACTIVE Subscription_State = 3
)

// Enum value maps for Subscription_State.
var (
	Subscription_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STATE_ACTIVE",
		2: "STATE_STALE",
		3: "STATE_INACTIVE",
	}
	Subscription_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STATE_ACTIVE":      1,
		"STATE_STALE":       2,
		"STATE_INACTIVE":    3,
	}
)

func (x Subscription_State) Enum() *Subscription_State {
	p := new(Subscription_State)
	*p = x
	return p
}

func (x Subscription_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes[2].Descriptor()
}

func (Subscription_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes[2]
}

func (x Subscription_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_State.Descriptor instead.
func (Subscription_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{7, 0}
}

// A data exchange is a container that lets you share data. Along with the
// descriptive information about the data exchange, it contains listings that
// reference shared datasets.
type DataExchange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the data exchange.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human-readable display name of the data exchange. The display
	// name must contain only Unicode letters, numbers (0-9), underscores (_),
	// dashes (-), spaces ( ), ampersands (&) and must not start or end with
	// spaces. Default value is an empty string. Max length: 63 bytes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of the data exchange. The description must not
	// contain Unicode non-characters as well as C0 and C1 control codes except
	// tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
	// Default value is an empty string.
	// Max length: 2000 bytes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Email or URL of the primary point of contact of the data
	// exchange. Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,4,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
	// Optional. Documentation describing the data exchange.
	Documentation string `protobuf:"bytes,5,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Output only. Number of listings contained in the data exchange.
	ListingCount int32 `protobuf:"varint,6,opt,name=listing_count,json=listingCount,proto3" json:"listing_count,omitempty"`
	// Optional. Base64 encoded image representing the data exchange. Max
	// Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
	// only performs validation on size of the encoded data. Note: For byte
	// fields, the content of the fields are base64-encoded (which increases the
	// size of the data by 33-36%) when using JSON on the wire.
	Icon []byte `protobuf:"bytes,7,opt,name=icon,proto3" json:"icon,omitempty"`
	// Optional. Configurable data sharing environment option for a data exchange.
	SharingEnvironmentConfig *SharingEnvironmentConfig `protobuf:"bytes,8,opt,name=sharing_environment_config,json=sharingEnvironmentConfig,proto3" json:"sharing_environment_config,omitempty"`
}

func (x *DataExchange) Reset() {
	*x = DataExchange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataExchange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataExchange) ProtoMessage() {}

func (x *DataExchange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataExchange.ProtoReflect.Descriptor instead.
func (*DataExchange) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{0}
}

func (x *DataExchange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataExchange) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataExchange) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataExchange) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

func (x *DataExchange) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *DataExchange) GetListingCount() int32 {
	if x != nil {
		return x.ListingCount
	}
	return 0
}

func (x *DataExchange) GetIcon() []byte {
	if x != nil {
		return x.Icon
	}
	return nil
}

func (x *DataExchange) GetSharingEnvironmentConfig() *SharingEnvironmentConfig {
	if x != nil {
		return x.SharingEnvironmentConfig
	}
	return nil
}

// Sharing environment is a behavior model for sharing data within a
// data exchange. This option is configurable for a data exchange.
type SharingEnvironmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Environment:
	//
	//	*SharingEnvironmentConfig_DefaultExchangeConfig_
	//	*SharingEnvironmentConfig_DcrExchangeConfig_
	Environment isSharingEnvironmentConfig_Environment `protobuf_oneof:"environment"`
}

func (x *SharingEnvironmentConfig) Reset() {
	*x = SharingEnvironmentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SharingEnvironmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharingEnvironmentConfig) ProtoMessage() {}

func (x *SharingEnvironmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharingEnvironmentConfig.ProtoReflect.Descriptor instead.
func (*SharingEnvironmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{1}
}

func (m *SharingEnvironmentConfig) GetEnvironment() isSharingEnvironmentConfig_Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (x *SharingEnvironmentConfig) GetDefaultExchangeConfig() *SharingEnvironmentConfig_DefaultExchangeConfig {
	if x, ok := x.GetEnvironment().(*SharingEnvironmentConfig_DefaultExchangeConfig_); ok {
		return x.DefaultExchangeConfig
	}
	return nil
}

func (x *SharingEnvironmentConfig) GetDcrExchangeConfig() *SharingEnvironmentConfig_DcrExchangeConfig {
	if x, ok := x.GetEnvironment().(*SharingEnvironmentConfig_DcrExchangeConfig_); ok {
		return x.DcrExchangeConfig
	}
	return nil
}

type isSharingEnvironmentConfig_Environment interface {
	isSharingEnvironmentConfig_Environment()
}

type SharingEnvironmentConfig_DefaultExchangeConfig_ struct {
	// Default Analytics Hub data exchange, used for secured data sharing.
	DefaultExchangeConfig *SharingEnvironmentConfig_DefaultExchangeConfig `protobuf:"bytes,1,opt,name=default_exchange_config,json=defaultExchangeConfig,proto3,oneof"`
}

type SharingEnvironmentConfig_DcrExchangeConfig_ struct {
	// Data Clean Room (DCR), used for privacy-safe and secured data sharing.
	DcrExchangeConfig *SharingEnvironmentConfig_DcrExchangeConfig `protobuf:"bytes,2,opt,name=dcr_exchange_config,json=dcrExchangeConfig,proto3,oneof"`
}

func (*SharingEnvironmentConfig_DefaultExchangeConfig_) isSharingEnvironmentConfig_Environment() {}

func (*SharingEnvironmentConfig_DcrExchangeConfig_) isSharingEnvironmentConfig_Environment() {}

// Contains details of the data provider.
type DataProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the data provider.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Email or URL of the data provider.
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,2,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
}

func (x *DataProvider) Reset() {
	*x = DataProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProvider) ProtoMessage() {}

func (x *DataProvider) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProvider.ProtoReflect.Descriptor instead.
func (*DataProvider) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{2}
}

func (x *DataProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataProvider) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

// Contains details of the listing publisher.
type Publisher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the listing publisher.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Email or URL of the listing publisher.
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,2,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
}

func (x *Publisher) Reset() {
	*x = Publisher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Publisher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Publisher) ProtoMessage() {}

func (x *Publisher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Publisher.ProtoReflect.Descriptor instead.
func (*Publisher) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{3}
}

func (x *Publisher) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Publisher) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

// Contains the reference that identifies a destination bigquery dataset.
type DestinationDatasetReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique ID for this dataset, without the project name. The ID
	// must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
	// The maximum length is 1,024 characters.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The ID of the project containing this dataset.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DestinationDatasetReference) Reset() {
	*x = DestinationDatasetReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationDatasetReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationDatasetReference) ProtoMessage() {}

func (x *DestinationDatasetReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationDatasetReference.ProtoReflect.Descriptor instead.
func (*DestinationDatasetReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{4}
}

func (x *DestinationDatasetReference) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *DestinationDatasetReference) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Defines the destination bigquery dataset.
type DestinationDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A reference that identifies the destination dataset.
	DatasetReference *DestinationDatasetReference `protobuf:"bytes,1,opt,name=dataset_reference,json=datasetReference,proto3" json:"dataset_reference,omitempty"`
	// Optional. A descriptive name for the dataset.
	FriendlyName *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// Optional. A user-friendly description of the dataset.
	Description *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The labels associated with this dataset. You can use these
	// to organize and group your datasets.
	// You can set this property when inserting or updating a dataset.
	// See https://cloud.google.com/resource-manager/docs/creating-managing-labels
	// for more information.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The geographic location where the dataset should reside. See
	// https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	Location string `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *DestinationDataset) Reset() {
	*x = DestinationDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationDataset) ProtoMessage() {}

func (x *DestinationDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationDataset.ProtoReflect.Descriptor instead.
func (*DestinationDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{5}
}

func (x *DestinationDataset) GetDatasetReference() *DestinationDatasetReference {
	if x != nil {
		return x.DatasetReference
	}
	return nil
}

func (x *DestinationDataset) GetFriendlyName() *wrapperspb.StringValue {
	if x != nil {
		return x.FriendlyName
	}
	return nil
}

func (x *DestinationDataset) GetDescription() *wrapperspb.StringValue {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *DestinationDataset) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DestinationDataset) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// A listing is what gets published into a data exchange that a subscriber can
// subscribe to. It contains a reference to the data source along with
// descriptive information that will help subscribers find and subscribe the
// data.
type Listing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Listing source.
	//
	// Types that are assignable to Source:
	//
	//	*Listing_BigqueryDataset
	Source isListing_Source `protobuf_oneof:"source"`
	// Output only. The resource name of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human-readable display name of the listing. The display name must
	// contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
	// spaces ( ), ampersands (&) and can't start or end with spaces. Default
	// value is an empty string. Max length: 63 bytes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Short description of the listing. The description must not
	// contain Unicode non-characters and C0 and C1 control codes except tabs
	// (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
	// value is an empty string. Max length: 2000 bytes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Email or URL of the primary point of contact of the listing.
	// Max Length: 1000 bytes.
	PrimaryContact string `protobuf:"bytes,4,opt,name=primary_contact,json=primaryContact,proto3" json:"primary_contact,omitempty"`
	// Optional. Documentation describing the listing.
	Documentation string `protobuf:"bytes,5,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Output only. Current state of the listing.
	State Listing_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.bigquery.analyticshub.v1.Listing_State" json:"state,omitempty"`
	// Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
	// Expected image dimensions are 512x512 pixels, however the API only
	// performs validation on size of the encoded data.
	// Note: For byte fields, the contents of the field are base64-encoded (which
	// increases the size of the data by 33-36%) when using JSON on the wire.
	Icon []byte `protobuf:"bytes,8,opt,name=icon,proto3" json:"icon,omitempty"`
	// Optional. Details of the data provider who owns the source data.
	DataProvider *DataProvider `protobuf:"bytes,9,opt,name=data_provider,json=dataProvider,proto3" json:"data_provider,omitempty"`
	// Optional. Categories of the listing. Up to two categories are allowed.
	Categories []Listing_Category `protobuf:"varint,10,rep,packed,name=categories,proto3,enum=google.cloud.bigquery.analyticshub.v1.Listing_Category" json:"categories,omitempty"`
	// Optional. Details of the publisher who owns the listing and who can share
	// the source data.
	Publisher *Publisher `protobuf:"bytes,11,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Optional. Email or URL of the request access of the listing.
	// Subscribers can use this reference to request access.
	// Max Length: 1000 bytes.
	RequestAccess string `protobuf:"bytes,12,opt,name=request_access,json=requestAccess,proto3" json:"request_access,omitempty"`
	// Optional. If set, restricted export configuration will be propagated and
	// enforced on the linked dataset.
	RestrictedExportConfig *Listing_RestrictedExportConfig `protobuf:"bytes,13,opt,name=restricted_export_config,json=restrictedExportConfig,proto3" json:"restricted_export_config,omitempty"`
}

func (x *Listing) Reset() {
	*x = Listing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listing) ProtoMessage() {}

func (x *Listing) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listing.ProtoReflect.Descriptor instead.
func (*Listing) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{6}
}

func (m *Listing) GetSource() isListing_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Listing) GetBigqueryDataset() *Listing_BigQueryDatasetSource {
	if x, ok := x.GetSource().(*Listing_BigqueryDataset); ok {
		return x.BigqueryDataset
	}
	return nil
}

func (x *Listing) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listing) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Listing) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Listing) GetPrimaryContact() string {
	if x != nil {
		return x.PrimaryContact
	}
	return ""
}

func (x *Listing) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *Listing) GetState() Listing_State {
	if x != nil {
		return x.State
	}
	return Listing_STATE_UNSPECIFIED
}

func (x *Listing) GetIcon() []byte {
	if x != nil {
		return x.Icon
	}
	return nil
}

func (x *Listing) GetDataProvider() *DataProvider {
	if x != nil {
		return x.DataProvider
	}
	return nil
}

func (x *Listing) GetCategories() []Listing_Category {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *Listing) GetPublisher() *Publisher {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *Listing) GetRequestAccess() string {
	if x != nil {
		return x.RequestAccess
	}
	return ""
}

func (x *Listing) GetRestrictedExportConfig() *Listing_RestrictedExportConfig {
	if x != nil {
		return x.RestrictedExportConfig
	}
	return nil
}

type isListing_Source interface {
	isListing_Source()
}

type Listing_BigqueryDataset struct {
	// Required. Shared dataset i.e. BigQuery dataset source.
	BigqueryDataset *Listing_BigQueryDatasetSource `protobuf:"bytes,6,opt,name=bigquery_dataset,json=bigqueryDataset,proto3,oneof"`
}

func (*Listing_BigqueryDataset) isListing_Source() {}

// A subscription represents a subscribers' access to a particular set of
// published data. It contains references to associated listings,
// data exchanges, and linked datasets.
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ResourceName:
	//
	//	*Subscription_Listing
	//	*Subscription_DataExchange
	ResourceName isSubscription_ResourceName `protobuf_oneof:"resource_name"`
	// Output only. The resource name of the subscription.
	// e.g. `projects/myproject/locations/US/subscriptions/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when the subscription was created.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. Timestamp when the subscription was last modified.
	LastModifyTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_modify_time,json=lastModifyTime,proto3" json:"last_modify_time,omitempty"`
	// Output only. Organization of the project this subscription belongs to.
	OrganizationId string `protobuf:"bytes,4,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Output only. Display name of the project of this subscription.
	OrganizationDisplayName string `protobuf:"bytes,10,opt,name=organization_display_name,json=organizationDisplayName,proto3" json:"organization_display_name,omitempty"`
	// Output only. Current state of the subscription.
	State Subscription_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.bigquery.analyticshub.v1.Subscription_State" json:"state,omitempty"`
	// Output only. Map of listing resource names to associated linked resource,
	// e.g. projects/123/locations/US/dataExchanges/456/listings/789
	// ->
	// projects/123/datasets/my_dataset
	//
	// For listing-level subscriptions, this is a map of size 1.
	// Only contains values if state == STATE_ACTIVE.
	LinkedDatasetMap map[string]*Subscription_LinkedResource `protobuf:"bytes,8,rep,name=linked_dataset_map,json=linkedDatasetMap,proto3" json:"linked_dataset_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Email of the subscriber.
	SubscriberContact string `protobuf:"bytes,9,opt,name=subscriber_contact,json=subscriberContact,proto3" json:"subscriber_contact,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{7}
}

func (m *Subscription) GetResourceName() isSubscription_ResourceName {
	if m != nil {
		return m.ResourceName
	}
	return nil
}

func (x *Subscription) GetListing() string {
	if x, ok := x.GetResourceName().(*Subscription_Listing); ok {
		return x.Listing
	}
	return ""
}

func (x *Subscription) GetDataExchange() string {
	if x, ok := x.GetResourceName().(*Subscription_DataExchange); ok {
		return x.DataExchange
	}
	return ""
}

func (x *Subscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subscription) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *Subscription) GetLastModifyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifyTime
	}
	return nil
}

func (x *Subscription) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *Subscription) GetOrganizationDisplayName() string {
	if x != nil {
		return x.OrganizationDisplayName
	}
	return ""
}

func (x *Subscription) GetState() Subscription_State {
	if x != nil {
		return x.State
	}
	return Subscription_STATE_UNSPECIFIED
}

func (x *Subscription) GetLinkedDatasetMap() map[string]*Subscription_LinkedResource {
	if x != nil {
		return x.LinkedDatasetMap
	}
	return nil
}

func (x *Subscription) GetSubscriberContact() string {
	if x != nil {
		return x.SubscriberContact
	}
	return ""
}

type isSubscription_ResourceName interface {
	isSubscription_ResourceName()
}

type Subscription_Listing struct {
	// Output only. Resource name of the source Listing.
	// e.g. projects/123/locations/US/dataExchanges/456/listings/789
	Listing string `protobuf:"bytes,5,opt,name=listing,proto3,oneof"`
}

type Subscription_DataExchange struct {
	// Output only. Resource name of the source Data Exchange.
	// e.g. projects/123/locations/US/dataExchanges/456
	DataExchange string `protobuf:"bytes,6,opt,name=data_exchange,json=dataExchange,proto3,oneof"`
}

func (*Subscription_Listing) isSubscription_ResourceName() {}

func (*Subscription_DataExchange) isSubscription_ResourceName() {}

// Message for requesting the list of data exchanges.
type ListDataExchangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the data exchanges.
	// e.g. `projects/myproject/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response page. Leverage
	// the page tokens to iterate through the entire collection.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call, to request the next page of
	// results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataExchangesRequest) Reset() {
	*x = ListDataExchangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataExchangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataExchangesRequest) ProtoMessage() {}

func (x *ListDataExchangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataExchangesRequest.ProtoReflect.Descriptor instead.
func (*ListDataExchangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{8}
}

func (x *ListDataExchangesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataExchangesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataExchangesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to the list of data exchanges.
type ListDataExchangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of data exchanges.
	DataExchanges []*DataExchange `protobuf:"bytes,1,rep,name=data_exchanges,json=dataExchanges,proto3" json:"data_exchanges,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataExchangesResponse) Reset() {
	*x = ListDataExchangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataExchangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataExchangesResponse) ProtoMessage() {}

func (x *ListDataExchangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataExchangesResponse.ProtoReflect.Descriptor instead.
func (*ListDataExchangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{9}
}

func (x *ListDataExchangesResponse) GetDataExchanges() []*DataExchange {
	if x != nil {
		return x.DataExchanges
	}
	return nil
}

func (x *ListDataExchangesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for requesting the list of data exchanges from projects in an
// organization and location.
type ListOrgDataExchangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization resource path of the projects containing
	// DataExchanges. e.g. `organizations/myorg/locations/US`.
	Organization string `protobuf:"bytes,1,opt,name=organization,proto3" json:"organization,omitempty"`
	// The maximum number of results to return in a single response page. Leverage
	// the page tokens to iterate through the entire collection.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call, to request the next page of
	// results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOrgDataExchangesRequest) Reset() {
	*x = ListOrgDataExchangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOrgDataExchangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrgDataExchangesRequest) ProtoMessage() {}

func (x *ListOrgDataExchangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrgDataExchangesRequest.ProtoReflect.Descriptor instead.
func (*ListOrgDataExchangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{10}
}

func (x *ListOrgDataExchangesRequest) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *ListOrgDataExchangesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrgDataExchangesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing data exchanges in an organization and
// location.
type ListOrgDataExchangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of data exchanges.
	DataExchanges []*DataExchange `protobuf:"bytes,1,rep,name=data_exchanges,json=dataExchanges,proto3" json:"data_exchanges,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOrgDataExchangesResponse) Reset() {
	*x = ListOrgDataExchangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOrgDataExchangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrgDataExchangesResponse) ProtoMessage() {}

func (x *ListOrgDataExchangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrgDataExchangesResponse.ProtoReflect.Descriptor instead.
func (*ListOrgDataExchangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{11}
}

func (x *ListOrgDataExchangesResponse) GetDataExchanges() []*DataExchange {
	if x != nil {
		return x.DataExchanges
	}
	return nil
}

func (x *ListOrgDataExchangesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a data exchange.
type GetDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the data exchange.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataExchangeRequest) Reset() {
	*x = GetDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataExchangeRequest) ProtoMessage() {}

func (x *GetDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*GetDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{12}
}

func (x *GetDataExchangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a data exchange.
type CreateDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the data exchange.
	// e.g. `projects/myproject/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the data exchange.
	// Must contain only Unicode letters, numbers (0-9), underscores (_).
	// Should not use characters that require URL-escaping, or characters
	// outside of ASCII, spaces.
	// Max length: 100 bytes.
	DataExchangeId string `protobuf:"bytes,2,opt,name=data_exchange_id,json=dataExchangeId,proto3" json:"data_exchange_id,omitempty"`
	// Required. The data exchange to create.
	DataExchange *DataExchange `protobuf:"bytes,3,opt,name=data_exchange,json=dataExchange,proto3" json:"data_exchange,omitempty"`
}

func (x *CreateDataExchangeRequest) Reset() {
	*x = CreateDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataExchangeRequest) ProtoMessage() {}

func (x *CreateDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*CreateDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{13}
}

func (x *CreateDataExchangeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataExchangeRequest) GetDataExchangeId() string {
	if x != nil {
		return x.DataExchangeId
	}
	return ""
}

func (x *CreateDataExchangeRequest) GetDataExchange() *DataExchange {
	if x != nil {
		return x.DataExchange
	}
	return nil
}

// Message for updating a data exchange.
type UpdateDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask specifies the fields to update in the data exchange
	// resource. The fields specified in the
	// `updateMask` are relative to the resource and are not a full request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The data exchange to update.
	DataExchange *DataExchange `protobuf:"bytes,2,opt,name=data_exchange,json=dataExchange,proto3" json:"data_exchange,omitempty"`
}

func (x *UpdateDataExchangeRequest) Reset() {
	*x = UpdateDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataExchangeRequest) ProtoMessage() {}

func (x *UpdateDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateDataExchangeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDataExchangeRequest) GetDataExchange() *DataExchange {
	if x != nil {
		return x.DataExchange
	}
	return nil
}

// Message for deleting a data exchange.
type DeleteDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full name of the data exchange resource that you want to
	// delete. For example, `projects/myproject/locations/US/dataExchanges/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataExchangeRequest) Reset() {
	*x = DeleteDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataExchangeRequest) ProtoMessage() {}

func (x *DeleteDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteDataExchangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting the list of listings.
type ListListingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response page. Leverage
	// the page tokens to iterate through the entire collection.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call, to request the next page of
	// results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListListingsRequest) Reset() {
	*x = ListListingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListListingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListListingsRequest) ProtoMessage() {}

func (x *ListListingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListListingsRequest.ProtoReflect.Descriptor instead.
func (*ListListingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{16}
}

func (x *ListListingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListListingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListListingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to the list of Listings.
type ListListingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Listing.
	Listings []*Listing `protobuf:"bytes,1,rep,name=listings,proto3" json:"listings,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListListingsResponse) Reset() {
	*x = ListListingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListListingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListListingsResponse) ProtoMessage() {}

func (x *ListListingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListListingsResponse.ProtoReflect.Descriptor instead.
func (*ListListingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{17}
}

func (x *ListListingsResponse) GetListings() []*Listing {
	if x != nil {
		return x.Listings
	}
	return nil
}

func (x *ListListingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a listing.
type GetListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetListingRequest) Reset() {
	*x = GetListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetListingRequest) ProtoMessage() {}

func (x *GetListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetListingRequest.ProtoReflect.Descriptor instead.
func (*GetListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{18}
}

func (x *GetListingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a listing.
type CreateListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the listing.
	// e.g. `projects/myproject/locations/US/dataExchanges/123`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the listing to create.
	// Must contain only Unicode letters, numbers (0-9), underscores (_).
	// Should not use characters that require URL-escaping, or characters
	// outside of ASCII, spaces.
	// Max length: 100 bytes.
	ListingId string `protobuf:"bytes,2,opt,name=listing_id,json=listingId,proto3" json:"listing_id,omitempty"`
	// Required. The listing to create.
	Listing *Listing `protobuf:"bytes,3,opt,name=listing,proto3" json:"listing,omitempty"`
}

func (x *CreateListingRequest) Reset() {
	*x = CreateListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateListingRequest) ProtoMessage() {}

func (x *CreateListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateListingRequest.ProtoReflect.Descriptor instead.
func (*CreateListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{19}
}

func (x *CreateListingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateListingRequest) GetListingId() string {
	if x != nil {
		return x.ListingId
	}
	return ""
}

func (x *CreateListingRequest) GetListing() *Listing {
	if x != nil {
		return x.Listing
	}
	return nil
}

// Message for updating a Listing.
type UpdateListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask specifies the fields to update in the listing
	// resource. The fields specified in the `updateMask` are relative to the
	// resource and are not a full request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The listing to update.
	Listing *Listing `protobuf:"bytes,2,opt,name=listing,proto3" json:"listing,omitempty"`
}

func (x *UpdateListingRequest) Reset() {
	*x = UpdateListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateListingRequest) ProtoMessage() {}

func (x *UpdateListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateListingRequest.ProtoReflect.Descriptor instead.
func (*UpdateListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateListingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateListingRequest) GetListing() *Listing {
	if x != nil {
		return x.Listing
	}
	return nil
}

// Message for deleting a listing.
type DeleteListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the listing to delete.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteListingRequest) Reset() {
	*x = DeleteListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteListingRequest) ProtoMessage() {}

func (x *DeleteListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteListingRequest.ProtoReflect.Descriptor instead.
func (*DeleteListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteListingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for subscribing to a listing.
type SubscribeListingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resulting destination of the listing that you subscribed to.
	//
	// Types that are assignable to Destination:
	//
	//	*SubscribeListingRequest_DestinationDataset
	Destination isSubscribeListingRequest_Destination `protobuf_oneof:"destination"`
	// Required. Resource name of the listing that you want to subscribe to.
	// e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SubscribeListingRequest) Reset() {
	*x = SubscribeListingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeListingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeListingRequest) ProtoMessage() {}

func (x *SubscribeListingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeListingRequest.ProtoReflect.Descriptor instead.
func (*SubscribeListingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{22}
}

func (m *SubscribeListingRequest) GetDestination() isSubscribeListingRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *SubscribeListingRequest) GetDestinationDataset() *DestinationDataset {
	if x, ok := x.GetDestination().(*SubscribeListingRequest_DestinationDataset); ok {
		return x.DestinationDataset
	}
	return nil
}

func (x *SubscribeListingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isSubscribeListingRequest_Destination interface {
	isSubscribeListingRequest_Destination()
}

type SubscribeListingRequest_DestinationDataset struct {
	// BigQuery destination dataset to create for the subscriber.
	DestinationDataset *DestinationDataset `protobuf:"bytes,3,opt,name=destination_dataset,json=destinationDataset,proto3,oneof"`
}

func (*SubscribeListingRequest_DestinationDataset) isSubscribeListingRequest_Destination() {}

// Message for response when you subscribe to a listing.
type SubscribeListingResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subscription object created from this subscribe action.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *SubscribeListingResponse) Reset() {
	*x = SubscribeListingResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeListingResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeListingResponse) ProtoMessage() {}

func (x *SubscribeListingResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeListingResponse.ProtoReflect.Descriptor instead.
func (*SubscribeListingResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{23}
}

func (x *SubscribeListingResponse) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

// Message for subscribing to a Data Exchange.
type SubscribeDataExchangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the Data Exchange.
	// e.g. `projects/publisherproject/locations/US/dataExchanges/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The parent resource path of the Subscription.
	// e.g. `projects/subscriberproject/locations/US`
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Required. Name of the subscription to create.
	// e.g. `subscription1`
	Subscription string `protobuf:"bytes,4,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Email of the subscriber.
	SubscriberContact string `protobuf:"bytes,3,opt,name=subscriber_contact,json=subscriberContact,proto3" json:"subscriber_contact,omitempty"`
}

func (x *SubscribeDataExchangeRequest) Reset() {
	*x = SubscribeDataExchangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeDataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeDataExchangeRequest) ProtoMessage() {}

func (x *SubscribeDataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeDataExchangeRequest.ProtoReflect.Descriptor instead.
func (*SubscribeDataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{24}
}

func (x *SubscribeDataExchangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SubscribeDataExchangeRequest) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *SubscribeDataExchangeRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *SubscribeDataExchangeRequest) GetSubscriberContact() string {
	if x != nil {
		return x.SubscriberContact
	}
	return ""
}

// Message for response when you subscribe to a Data Exchange.
type SubscribeDataExchangeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subscription object created from this subscribe action.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *SubscribeDataExchangeResponse) Reset() {
	*x = SubscribeDataExchangeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeDataExchangeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeDataExchangeResponse) ProtoMessage() {}

func (x *SubscribeDataExchangeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeDataExchangeResponse.ProtoReflect.Descriptor instead.
func (*SubscribeDataExchangeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{25}
}

func (x *SubscribeDataExchangeResponse) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

// Message for refreshing a subscription.
type RefreshSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the Subscription to refresh.
	// e.g. `projects/subscriberproject/locations/US/subscriptions/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RefreshSubscriptionRequest) Reset() {
	*x = RefreshSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshSubscriptionRequest) ProtoMessage() {}

func (x *RefreshSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*RefreshSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{26}
}

func (x *RefreshSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for response when you refresh a subscription.
type RefreshSubscriptionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The refreshed subscription resource.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *RefreshSubscriptionResponse) Reset() {
	*x = RefreshSubscriptionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshSubscriptionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshSubscriptionResponse) ProtoMessage() {}

func (x *RefreshSubscriptionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshSubscriptionResponse.ProtoReflect.Descriptor instead.
func (*RefreshSubscriptionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{27}
}

func (x *RefreshSubscriptionResponse) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

// Message for getting a subscription.
type GetSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the subscription.
	// e.g. projects/123/locations/US/subscriptions/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSubscriptionRequest) Reset() {
	*x = GetSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSubscriptionRequest) ProtoMessage() {}

func (x *GetSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{28}
}

func (x *GetSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for listing subscriptions.
type ListSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource path of the subscription.
	// e.g. projects/myproject/locations/US
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression may be used to filter by Data Exchange or Listing.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of results to return in a single response page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubscriptionsRequest) Reset() {
	*x = ListSubscriptionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscriptionsRequest) ProtoMessage() {}

func (x *ListSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{29}
}

func (x *ListSubscriptionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSubscriptionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSubscriptionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubscriptionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to the listing of subscriptions.
type ListSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of subscriptions.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSubscriptionsResponse) Reset() {
	*x = ListSubscriptionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscriptionsResponse) ProtoMessage() {}

func (x *ListSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{30}
}

func (x *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *ListSubscriptionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for listing subscriptions of a shared resource.
type ListSharedResourceSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the requested target. This resource may be
	// either a Listing or a DataExchange. e.g.
	// projects/123/locations/US/dataExchanges/456 OR e.g.
	// projects/123/locations/US/dataExchanges/456/listings/789
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// If selected, includes deleted subscriptions in the response
	// (up to 63 days after deletion).
	IncludeDeletedSubscriptions bool `protobuf:"varint,2,opt,name=include_deleted_subscriptions,json=includeDeletedSubscriptions,proto3" json:"include_deleted_subscriptions,omitempty"`
	// The maximum number of results to return in a single response page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token, returned by a previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSharedResourceSubscriptionsRequest) Reset() {
	*x = ListSharedResourceSubscriptionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSharedResourceSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSharedResourceSubscriptionsRequest) ProtoMessage() {}

func (x *ListSharedResourceSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSharedResourceSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*ListSharedResourceSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{31}
}

func (x *ListSharedResourceSubscriptionsRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *ListSharedResourceSubscriptionsRequest) GetIncludeDeletedSubscriptions() bool {
	if x != nil {
		return x.IncludeDeletedSubscriptions
	}
	return false
}

func (x *ListSharedResourceSubscriptionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSharedResourceSubscriptionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to the listing of shared resource subscriptions.
type ListSharedResourceSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of subscriptions.
	SharedResourceSubscriptions []*Subscription `protobuf:"bytes,1,rep,name=shared_resource_subscriptions,json=sharedResourceSubscriptions,proto3" json:"shared_resource_subscriptions,omitempty"`
	// Next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSharedResourceSubscriptionsResponse) Reset() {
	*x = ListSharedResourceSubscriptionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSharedResourceSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSharedResourceSubscriptionsResponse) ProtoMessage() {}

func (x *ListSharedResourceSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSharedResourceSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*ListSharedResourceSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{32}
}

func (x *ListSharedResourceSubscriptionsResponse) GetSharedResourceSubscriptions() []*Subscription {
	if x != nil {
		return x.SharedResourceSubscriptions
	}
	return nil
}

func (x *ListSharedResourceSubscriptionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for revoking a subscription.
type RevokeSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the subscription to revoke.
	// e.g. projects/123/locations/US/subscriptions/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RevokeSubscriptionRequest) Reset() {
	*x = RevokeSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevokeSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeSubscriptionRequest) ProtoMessage() {}

func (x *RevokeSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*RevokeSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{33}
}

func (x *RevokeSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for response when you revoke a subscription.
type RevokeSubscriptionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RevokeSubscriptionResponse) Reset() {
	*x = RevokeSubscriptionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevokeSubscriptionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeSubscriptionResponse) ProtoMessage() {}

func (x *RevokeSubscriptionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeSubscriptionResponse.ProtoReflect.Descriptor instead.
func (*RevokeSubscriptionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{34}
}

// Message for deleting a subscription.
type DeleteSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the subscription to delete.
	// e.g. projects/123/locations/US/subscriptions/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSubscriptionRequest) Reset() {
	*x = DeleteSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSubscriptionRequest) ProtoMessage() {}

func (x *DeleteSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the metadata of a long-running operation in Analytics Hub.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{36}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Default Analytics Hub data exchange, used for secured data sharing.
type SharingEnvironmentConfig_DefaultExchangeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SharingEnvironmentConfig_DefaultExchangeConfig) Reset() {
	*x = SharingEnvironmentConfig_DefaultExchangeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SharingEnvironmentConfig_DefaultExchangeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharingEnvironmentConfig_DefaultExchangeConfig) ProtoMessage() {}

func (x *SharingEnvironmentConfig_DefaultExchangeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharingEnvironmentConfig_DefaultExchangeConfig.ProtoReflect.Descriptor instead.
func (*SharingEnvironmentConfig_DefaultExchangeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{1, 0}
}

// Data Clean Room (DCR), used for privacy-safe and secured data sharing.
type SharingEnvironmentConfig_DcrExchangeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. If True, this DCR restricts the contributors to sharing
	// only a single resource in a Listing. And no two resources should have the
	// same IDs. So if a contributor adds a view with a conflicting name, the
	// CreateListing API will reject the request. if False, the data contributor
	// can publish an entire dataset (as before). This is not configurable, and
	// by default, all new DCRs will have the restriction set to True.
	SingleSelectedResourceSharingRestriction *bool `protobuf:"varint,1,opt,name=single_selected_resource_sharing_restriction,json=singleSelectedResourceSharingRestriction,proto3,oneof" json:"single_selected_resource_sharing_restriction,omitempty"`
	// Output only. If True, when subscribing to this DCR, it will create only
	// one linked dataset containing all resources shared within the
	// cleanroom. If False, when subscribing to this DCR, it will
	// create 1 linked dataset per listing. This is not configurable, and by
	// default, all new DCRs will have the restriction set to True.
	SingleLinkedDatasetPerCleanroom *bool `protobuf:"varint,2,opt,name=single_linked_dataset_per_cleanroom,json=singleLinkedDatasetPerCleanroom,proto3,oneof" json:"single_linked_dataset_per_cleanroom,omitempty"`
}

func (x *SharingEnvironmentConfig_DcrExchangeConfig) Reset() {
	*x = SharingEnvironmentConfig_DcrExchangeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SharingEnvironmentConfig_DcrExchangeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharingEnvironmentConfig_DcrExchangeConfig) ProtoMessage() {}

func (x *SharingEnvironmentConfig_DcrExchangeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharingEnvironmentConfig_DcrExchangeConfig.ProtoReflect.Descriptor instead.
func (*SharingEnvironmentConfig_DcrExchangeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{1, 1}
}

func (x *SharingEnvironmentConfig_DcrExchangeConfig) GetSingleSelectedResourceSharingRestriction() bool {
	if x != nil && x.SingleSelectedResourceSharingRestriction != nil {
		return *x.SingleSelectedResourceSharingRestriction
	}
	return false
}

func (x *SharingEnvironmentConfig_DcrExchangeConfig) GetSingleLinkedDatasetPerCleanroom() bool {
	if x != nil && x.SingleLinkedDatasetPerCleanroom != nil {
		return *x.SingleLinkedDatasetPerCleanroom
	}
	return false
}

// A reference to a shared dataset. It is an existing BigQuery dataset with a
// collection of objects such as tables and views that you want to share
// with subscribers.
// When subscriber's subscribe to a listing, Analytics Hub creates a linked
// dataset in
// the subscriber's project. A Linked dataset is an opaque, read-only BigQuery
// dataset that serves as a _symbolic link_ to a shared dataset.
type Listing_BigQueryDatasetSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the dataset source for this listing.
	// e.g. `projects/myproject/datasets/123`
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Optional. Resources in this dataset that are selectively shared.
	// If this field is empty, then the entire dataset (all resources) are
	// shared. This field is only valid for data clean room exchanges.
	SelectedResources []*Listing_BigQueryDatasetSource_SelectedResource `protobuf:"bytes,2,rep,name=selected_resources,json=selectedResources,proto3" json:"selected_resources,omitempty"`
}

func (x *Listing_BigQueryDatasetSource) Reset() {
	*x = Listing_BigQueryDatasetSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listing_BigQueryDatasetSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listing_BigQueryDatasetSource) ProtoMessage() {}

func (x *Listing_BigQueryDatasetSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listing_BigQueryDatasetSource.ProtoReflect.Descriptor instead.
func (*Listing_BigQueryDatasetSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Listing_BigQueryDatasetSource) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *Listing_BigQueryDatasetSource) GetSelectedResources() []*Listing_BigQueryDatasetSource_SelectedResource {
	if x != nil {
		return x.SelectedResources
	}
	return nil
}

// Restricted export config, used to configure restricted export on linked
// dataset.
type Listing_RestrictedExportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If true, enable restricted export.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Output only. If true, restrict direct table access(read
	// api/tabledata.list) on linked table.
	RestrictDirectTableAccess bool `protobuf:"varint,1,opt,name=restrict_direct_table_access,json=restrictDirectTableAccess,proto3" json:"restrict_direct_table_access,omitempty"`
	// Optional. If true, restrict export of query result derived from
	// restricted linked dataset table.
	RestrictQueryResult bool `protobuf:"varint,2,opt,name=restrict_query_result,json=restrictQueryResult,proto3" json:"restrict_query_result,omitempty"`
}

func (x *Listing_RestrictedExportConfig) Reset() {
	*x = Listing_RestrictedExportConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listing_RestrictedExportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listing_RestrictedExportConfig) ProtoMessage() {}

func (x *Listing_RestrictedExportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listing_RestrictedExportConfig.ProtoReflect.Descriptor instead.
func (*Listing_RestrictedExportConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Listing_RestrictedExportConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Listing_RestrictedExportConfig) GetRestrictDirectTableAccess() bool {
	if x != nil {
		return x.RestrictDirectTableAccess
	}
	return false
}

func (x *Listing_RestrictedExportConfig) GetRestrictQueryResult() bool {
	if x != nil {
		return x.RestrictQueryResult
	}
	return false
}

// Resource in this dataset that are selectively shared.
type Listing_BigQueryDatasetSource_SelectedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Resource:
	//
	//	*Listing_BigQueryDatasetSource_SelectedResource_Table
	Resource isListing_BigQueryDatasetSource_SelectedResource_Resource `protobuf_oneof:"resource"`
}

func (x *Listing_BigQueryDatasetSource_SelectedResource) Reset() {
	*x = Listing_BigQueryDatasetSource_SelectedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listing_BigQueryDatasetSource_SelectedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listing_BigQueryDatasetSource_SelectedResource) ProtoMessage() {}

func (x *Listing_BigQueryDatasetSource_SelectedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listing_BigQueryDatasetSource_SelectedResource.ProtoReflect.Descriptor instead.
func (*Listing_BigQueryDatasetSource_SelectedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (m *Listing_BigQueryDatasetSource_SelectedResource) GetResource() isListing_BigQueryDatasetSource_SelectedResource_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (x *Listing_BigQueryDatasetSource_SelectedResource) GetTable() string {
	if x, ok := x.GetResource().(*Listing_BigQueryDatasetSource_SelectedResource_Table); ok {
		return x.Table
	}
	return ""
}

type isListing_BigQueryDatasetSource_SelectedResource_Resource interface {
	isListing_BigQueryDatasetSource_SelectedResource_Resource()
}

type Listing_BigQueryDatasetSource_SelectedResource_Table struct {
	// Optional. Format:
	// For table:
	// `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
	// Example:"projects/test_project/datasets/test_dataset/tables/test_table"
	Table string `protobuf:"bytes,1,opt,name=table,proto3,oneof"`
}

func (*Listing_BigQueryDatasetSource_SelectedResource_Table) isListing_BigQueryDatasetSource_SelectedResource_Resource() {
}

// Reference to a linked resource tracked by this Subscription.
type Subscription_LinkedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Reference:
	//
	//	*Subscription_LinkedResource_LinkedDataset
	Reference isSubscription_LinkedResource_Reference `protobuf_oneof:"reference"`
}

func (x *Subscription_LinkedResource) Reset() {
	*x = Subscription_LinkedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription_LinkedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription_LinkedResource) ProtoMessage() {}

func (x *Subscription_LinkedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription_LinkedResource.ProtoReflect.Descriptor instead.
func (*Subscription_LinkedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP(), []int{7, 0}
}

func (m *Subscription_LinkedResource) GetReference() isSubscription_LinkedResource_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (x *Subscription_LinkedResource) GetLinkedDataset() string {
	if x, ok := x.GetReference().(*Subscription_LinkedResource_LinkedDataset); ok {
		return x.LinkedDataset
	}
	return ""
}

type isSubscription_LinkedResource_Reference interface {
	isSubscription_LinkedResource_Reference()
}

type Subscription_LinkedResource_LinkedDataset struct {
	// Output only. Name of the linked dataset, e.g.
	// projects/subscriberproject/datasets/linked_dataset
	LinkedDataset string `protobuf:"bytes,1,opt,name=linked_dataset,json=linkedDataset,proto3,oneof"`
}

func (*Subscription_LinkedResource_LinkedDataset) isSubscription_LinkedResource_Reference() {}

var File_google_cloud_bigquery_analyticshub_v1_analyticshub_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x04, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c,
	0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x0d,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x12, 0x82, 0x01, 0x0a, 0x1a, 0x73,
	0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a,
	0x74, 0xea, 0x41, 0x71, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x7d, 0x22, 0x8b, 0x05, 0x0a, 0x18, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x8f, 0x01, 0x0a, 0x17, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x15, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x83, 0x01, 0x0a, 0x13, 0x64, 0x63, 0x72, 0x5f, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x44, 0x63, 0x72, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x64, 0x63, 0x72, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x17, 0x0a, 0x15, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0xae, 0x02, 0x0a, 0x11, 0x44, 0x63, 0x72, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a, 0x2c, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x28, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x23, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x1f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x43,
	0x6c, 0x65, 0x61, 0x6e, 0x72, 0x6f, 0x6f, 0x6d, 0x88, 0x01, 0x01, 0x42, 0x2f, 0x0a, 0x2d, 0x5f,
	0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x26, 0x0a, 0x24,
	0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x65, 0x61, 0x6e,
	0x72, 0x6f, 0x6f, 0x6d, 0x42, 0x0d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x55, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x22, 0x52, 0x0a, 0x09, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x22, 0x65,
	0x0a, 0x1b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0xd7, 0x03, 0x0a, 0x12, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x74, 0x0a, 0x11,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x46, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x66, 0x72,
	0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x62, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xe4, 0x10, 0x0a, 0x07, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x76, 0x0a, 0x10, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x00, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x0d, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x12, 0x5d,
	0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x5c, 0x0a,
	0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x09, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x84, 0x01, 0x0a,
	0x18, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x72, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0xc2, 0x02, 0x0a, 0x15, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3e, 0x0a,
	0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x89, 0x01,
	0x0a, 0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x5d, 0x0a, 0x10, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3d, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x01, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0xb6, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x44, 0x0a, 0x1c, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x72,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x2a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x22, 0xb7, 0x04,
	0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59,
	0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x53, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x41, 0x44, 0x56, 0x45, 0x52, 0x54, 0x49, 0x53, 0x49, 0x4e,
	0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f,
	0x4d, 0x4d, 0x45, 0x52, 0x43, 0x45, 0x10, 0x03, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x41, 0x54, 0x45,
	0x47, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4c, 0x49, 0x4d, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x19,
	0x0a, 0x15, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x4d, 0x4f, 0x47,
	0x52, 0x41, 0x50, 0x48, 0x49, 0x43, 0x53, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x45, 0x43, 0x4f, 0x4e, 0x4f, 0x4d, 0x49, 0x43, 0x53, 0x10,
	0x06, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x45, 0x44,
	0x55, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x45, 0x4e, 0x45, 0x52, 0x47, 0x59, 0x10, 0x08, 0x12, 0x16,
	0x0a, 0x12, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x46, 0x49, 0x4e, 0x41, 0x4e,
	0x43, 0x49, 0x41, 0x4c, 0x10, 0x09, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f,
	0x52, 0x59, 0x5f, 0x47, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x43,
	0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x47, 0x45, 0x4f, 0x53, 0x50, 0x41, 0x54, 0x49,
	0x41, 0x4c, 0x10, 0x0b, 0x12, 0x28, 0x0a, 0x24, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59,
	0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x41, 0x52, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f,
	0x4c, 0x49, 0x46, 0x45, 0x5f, 0x53, 0x43, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x0c, 0x12, 0x12,
	0x0a, 0x0e, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x41,
	0x10, 0x0d, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x50,
	0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x53, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x0e, 0x12, 0x13,
	0x0a, 0x0f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x54, 0x41, 0x49,
	0x4c, 0x10, 0x0f, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f,
	0x53, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x10, 0x10, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x41, 0x54, 0x45,
	0x47, 0x4f, 0x52, 0x59, 0x5f, 0x53, 0x43, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x52, 0x45, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x11, 0x12, 0x29, 0x0a, 0x25, 0x43,
	0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52,
	0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4c, 0x4f, 0x47, 0x49, 0x53,
	0x54, 0x49, 0x43, 0x53, 0x10, 0x12, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f,
	0x52, 0x59, 0x5f, 0x54, 0x52, 0x41, 0x56, 0x45, 0x4c, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x54, 0x4f,
	0x55, 0x52, 0x49, 0x53, 0x4d, 0x10, 0x13, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x23, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb0, 0x08, 0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x44, 0x0a,
	0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69,
	0x66, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x19,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x7c, 0x0a, 0x12, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x61,
	0x70, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x11, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x1a, 0x4b, 0x0a, 0x0e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x1a, 0x87, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x58,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x55, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4c, 0x45, 0x10, 0x02, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x03, 0x3a, 0x73, 0xea, 0x41, 0x70, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x18, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9f, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0e, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27,
	0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x44,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf3, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x2d, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x64, 0x12,
	0x5d, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xbc,
	0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5d,
	0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x61, 0x0a,
	0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x9b, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x11, 0x47,
	0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xd3, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x07, 0x6c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0xa7, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x4d, 0x0a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x22, 0x57, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x17, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x48, 0x00,
	0x52, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0x0a, 0x18, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x57, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x02, 0x0a, 0x1c, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x22, 0x78, 0x0a, 0x1d, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x62, 0x0a, 0x1a, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x76, 0x0a, 0x1b, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5e, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x12, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcf, 0x01, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x25, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x42, 0x0a, 0x1d, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x1b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xca, 0x01, 0x0a, 0x27, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x77, 0x0a, 0x1d, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x1b, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x61, 0x0a, 0x19, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65, 0x76,
	0x6f, 0x6b, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x61, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b,
	0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x32, 0xda, 0x2a, 0x0a, 0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x48, 0x75, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0xf4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67,
	0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4f, 0x72, 0x67, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x0c, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e,
	0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0xc7,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x5f, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0xff, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x72, 0xda, 0x41, 0x19, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x12, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a,
	0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x4b,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x0d,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x5e, 0xda, 0x41, 0x0e, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x47, 0x3a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x3c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xe9, 0x01, 0x0a, 0x0d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x6b, 0xda, 0x41, 0x13, 0x6c, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x32, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb1, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xed, 0x01, 0x0a, 0x10, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x58, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a,
	0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x80, 0x02, 0x0a, 0x15, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0xca, 0x41, 0x32, 0x0a, 0x1d,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a,
	0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0xf7, 0x01,
	0x0a, 0x13, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0xca, 0x41, 0x30, 0x0a, 0x1b, 0x52, 0x65,
	0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x12, 0xc7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xf4,
	0x02, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xb1, 0x01, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x9f, 0x01, 0x5a, 0x54, 0x12, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe5, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x12, 0xe4, 0x01,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x02, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0xeb, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe4, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x52, 0x3a,
	0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5a, 0x47, 0x3a, 0x01, 0x2a, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xb7,
	0x02, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xeb, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xe4, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5a, 0x47, 0x3a, 0x01, 0x2a,
	0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x9a, 0x02, 0x0a, 0x12, 0x54, 0x65, 0x73,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xae, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x48, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x78, 0xca, 0x41, 0x1b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xae, 0x03, 0xea, 0x41, 0x48, 0x0a, 0x1f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0xea, 0x41, 0x55,
	0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x7d, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x42, 0x11, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75, 0x62, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68, 0x75, 0x62,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x68, 0x75, 0x62, 0x70, 0x62, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x68,
	0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75, 0x62, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x5c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75,
	0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x3a,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescData = file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDesc
)

func file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescData)
	})
	return file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDescData
}

var file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes = make([]protoimpl.MessageInfo, 45)
var file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_goTypes = []interface{}{
	(Listing_State)(0),                                     // 0: google.cloud.bigquery.analyticshub.v1.Listing.State
	(Listing_Category)(0),                                  // 1: google.cloud.bigquery.analyticshub.v1.Listing.Category
	(Subscription_State)(0),                                // 2: google.cloud.bigquery.analyticshub.v1.Subscription.State
	(*DataExchange)(nil),                                   // 3: google.cloud.bigquery.analyticshub.v1.DataExchange
	(*SharingEnvironmentConfig)(nil),                       // 4: google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
	(*DataProvider)(nil),                                   // 5: google.cloud.bigquery.analyticshub.v1.DataProvider
	(*Publisher)(nil),                                      // 6: google.cloud.bigquery.analyticshub.v1.Publisher
	(*DestinationDatasetReference)(nil),                    // 7: google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
	(*DestinationDataset)(nil),                             // 8: google.cloud.bigquery.analyticshub.v1.DestinationDataset
	(*Listing)(nil),                                        // 9: google.cloud.bigquery.analyticshub.v1.Listing
	(*Subscription)(nil),                                   // 10: google.cloud.bigquery.analyticshub.v1.Subscription
	(*ListDataExchangesRequest)(nil),                       // 11: google.cloud.bigquery.analyticshub.v1.ListDataExchangesRequest
	(*ListDataExchangesResponse)(nil),                      // 12: google.cloud.bigquery.analyticshub.v1.ListDataExchangesResponse
	(*ListOrgDataExchangesRequest)(nil),                    // 13: google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesRequest
	(*ListOrgDataExchangesResponse)(nil),                   // 14: google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesResponse
	(*GetDataExchangeRequest)(nil),                         // 15: google.cloud.bigquery.analyticshub.v1.GetDataExchangeRequest
	(*CreateDataExchangeRequest)(nil),                      // 16: google.cloud.bigquery.analyticshub.v1.CreateDataExchangeRequest
	(*UpdateDataExchangeRequest)(nil),                      // 17: google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest
	(*DeleteDataExchangeRequest)(nil),                      // 18: google.cloud.bigquery.analyticshub.v1.DeleteDataExchangeRequest
	(*ListListingsRequest)(nil),                            // 19: google.cloud.bigquery.analyticshub.v1.ListListingsRequest
	(*ListListingsResponse)(nil),                           // 20: google.cloud.bigquery.analyticshub.v1.ListListingsResponse
	(*GetListingRequest)(nil),                              // 21: google.cloud.bigquery.analyticshub.v1.GetListingRequest
	(*CreateListingRequest)(nil),                           // 22: google.cloud.bigquery.analyticshub.v1.CreateListingRequest
	(*UpdateListingRequest)(nil),                           // 23: google.cloud.bigquery.analyticshub.v1.UpdateListingRequest
	(*DeleteListingRequest)(nil),                           // 24: google.cloud.bigquery.analyticshub.v1.DeleteListingRequest
	(*SubscribeListingRequest)(nil),                        // 25: google.cloud.bigquery.analyticshub.v1.SubscribeListingRequest
	(*SubscribeListingResponse)(nil),                       // 26: google.cloud.bigquery.analyticshub.v1.SubscribeListingResponse
	(*SubscribeDataExchangeRequest)(nil),                   // 27: google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeRequest
	(*SubscribeDataExchangeResponse)(nil),                  // 28: google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeResponse
	(*RefreshSubscriptionRequest)(nil),                     // 29: google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionRequest
	(*RefreshSubscriptionResponse)(nil),                    // 30: google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionResponse
	(*GetSubscriptionRequest)(nil),                         // 31: google.cloud.bigquery.analyticshub.v1.GetSubscriptionRequest
	(*ListSubscriptionsRequest)(nil),                       // 32: google.cloud.bigquery.analyticshub.v1.ListSubscriptionsRequest
	(*ListSubscriptionsResponse)(nil),                      // 33: google.cloud.bigquery.analyticshub.v1.ListSubscriptionsResponse
	(*ListSharedResourceSubscriptionsRequest)(nil),         // 34: google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsRequest
	(*ListSharedResourceSubscriptionsResponse)(nil),        // 35: google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsResponse
	(*RevokeSubscriptionRequest)(nil),                      // 36: google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionRequest
	(*RevokeSubscriptionResponse)(nil),                     // 37: google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionResponse
	(*DeleteSubscriptionRequest)(nil),                      // 38: google.cloud.bigquery.analyticshub.v1.DeleteSubscriptionRequest
	(*OperationMetadata)(nil),                              // 39: google.cloud.bigquery.analyticshub.v1.OperationMetadata
	(*SharingEnvironmentConfig_DefaultExchangeConfig)(nil), // 40: google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.DefaultExchangeConfig
	(*SharingEnvironmentConfig_DcrExchangeConfig)(nil),     // 41: google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.DcrExchangeConfig
	nil,                                    // 42: google.cloud.bigquery.analyticshub.v1.DestinationDataset.LabelsEntry
	(*Listing_BigQueryDatasetSource)(nil),  // 43: google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
	(*Listing_RestrictedExportConfig)(nil), // 44: google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
	(*Listing_BigQueryDatasetSource_SelectedResource)(nil), // 45: google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
	(*Subscription_LinkedResource)(nil),                    // 46: google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
	nil,                                                    // 47: google.cloud.bigquery.analyticshub.v1.Subscription.LinkedDatasetMapEntry
	(*wrapperspb.StringValue)(nil),                         // 48: google.protobuf.StringValue
	(*timestamppb.Timestamp)(nil),                          // 49: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                          // 50: google.protobuf.FieldMask
	(*iampb.GetIamPolicyRequest)(nil),                      // 51: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),                      // 52: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),                // 53: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                                  // 54: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                        // 55: google.longrunning.Operation
	(*iampb.Policy)(nil),                                   // 56: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil),               // 57: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_depIdxs = []int32{
	4,  // 0: google.cloud.bigquery.analyticshub.v1.DataExchange.sharing_environment_config:type_name -> google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
	40, // 1: google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.default_exchange_config:type_name -> google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.DefaultExchangeConfig
	41, // 2: google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.dcr_exchange_config:type_name -> google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.DcrExchangeConfig
	7,  // 3: google.cloud.bigquery.analyticshub.v1.DestinationDataset.dataset_reference:type_name -> google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
	48, // 4: google.cloud.bigquery.analyticshub.v1.DestinationDataset.friendly_name:type_name -> google.protobuf.StringValue
	48, // 5: google.cloud.bigquery.analyticshub.v1.DestinationDataset.description:type_name -> google.protobuf.StringValue
	42, // 6: google.cloud.bigquery.analyticshub.v1.DestinationDataset.labels:type_name -> google.cloud.bigquery.analyticshub.v1.DestinationDataset.LabelsEntry
	43, // 7: google.cloud.bigquery.analyticshub.v1.Listing.bigquery_dataset:type_name -> google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
	0,  // 8: google.cloud.bigquery.analyticshub.v1.Listing.state:type_name -> google.cloud.bigquery.analyticshub.v1.Listing.State
	5,  // 9: google.cloud.bigquery.analyticshub.v1.Listing.data_provider:type_name -> google.cloud.bigquery.analyticshub.v1.DataProvider
	1,  // 10: google.cloud.bigquery.analyticshub.v1.Listing.categories:type_name -> google.cloud.bigquery.analyticshub.v1.Listing.Category
	6,  // 11: google.cloud.bigquery.analyticshub.v1.Listing.publisher:type_name -> google.cloud.bigquery.analyticshub.v1.Publisher
	44, // 12: google.cloud.bigquery.analyticshub.v1.Listing.restricted_export_config:type_name -> google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
	49, // 13: google.cloud.bigquery.analyticshub.v1.Subscription.creation_time:type_name -> google.protobuf.Timestamp
	49, // 14: google.cloud.bigquery.analyticshub.v1.Subscription.last_modify_time:type_name -> google.protobuf.Timestamp
	2,  // 15: google.cloud.bigquery.analyticshub.v1.Subscription.state:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription.State
	47, // 16: google.cloud.bigquery.analyticshub.v1.Subscription.linked_dataset_map:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription.LinkedDatasetMapEntry
	3,  // 17: google.cloud.bigquery.analyticshub.v1.ListDataExchangesResponse.data_exchanges:type_name -> google.cloud.bigquery.analyticshub.v1.DataExchange
	3,  // 18: google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesResponse.data_exchanges:type_name -> google.cloud.bigquery.analyticshub.v1.DataExchange
	3,  // 19: google.cloud.bigquery.analyticshub.v1.CreateDataExchangeRequest.data_exchange:type_name -> google.cloud.bigquery.analyticshub.v1.DataExchange
	50, // 20: google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 21: google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest.data_exchange:type_name -> google.cloud.bigquery.analyticshub.v1.DataExchange
	9,  // 22: google.cloud.bigquery.analyticshub.v1.ListListingsResponse.listings:type_name -> google.cloud.bigquery.analyticshub.v1.Listing
	9,  // 23: google.cloud.bigquery.analyticshub.v1.CreateListingRequest.listing:type_name -> google.cloud.bigquery.analyticshub.v1.Listing
	50, // 24: google.cloud.bigquery.analyticshub.v1.UpdateListingRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 25: google.cloud.bigquery.analyticshub.v1.UpdateListingRequest.listing:type_name -> google.cloud.bigquery.analyticshub.v1.Listing
	8,  // 26: google.cloud.bigquery.analyticshub.v1.SubscribeListingRequest.destination_dataset:type_name -> google.cloud.bigquery.analyticshub.v1.DestinationDataset
	10, // 27: google.cloud.bigquery.analyticshub.v1.SubscribeListingResponse.subscription:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription
	10, // 28: google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeResponse.subscription:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription
	10, // 29: google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionResponse.subscription:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription
	10, // 30: google.cloud.bigquery.analyticshub.v1.ListSubscriptionsResponse.subscriptions:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription
	10, // 31: google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsResponse.shared_resource_subscriptions:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription
	49, // 32: google.cloud.bigquery.analyticshub.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	49, // 33: google.cloud.bigquery.analyticshub.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	45, // 34: google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.selected_resources:type_name -> google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
	46, // 35: google.cloud.bigquery.analyticshub.v1.Subscription.LinkedDatasetMapEntry.value:type_name -> google.cloud.bigquery.analyticshub.v1.Subscription.LinkedResource
	11, // 36: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListDataExchanges:input_type -> google.cloud.bigquery.analyticshub.v1.ListDataExchangesRequest
	13, // 37: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListOrgDataExchanges:input_type -> google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesRequest
	15, // 38: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetDataExchange:input_type -> google.cloud.bigquery.analyticshub.v1.GetDataExchangeRequest
	16, // 39: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.CreateDataExchange:input_type -> google.cloud.bigquery.analyticshub.v1.CreateDataExchangeRequest
	17, // 40: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.UpdateDataExchange:input_type -> google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest
	18, // 41: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.DeleteDataExchange:input_type -> google.cloud.bigquery.analyticshub.v1.DeleteDataExchangeRequest
	19, // 42: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListListings:input_type -> google.cloud.bigquery.analyticshub.v1.ListListingsRequest
	21, // 43: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetListing:input_type -> google.cloud.bigquery.analyticshub.v1.GetListingRequest
	22, // 44: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.CreateListing:input_type -> google.cloud.bigquery.analyticshub.v1.CreateListingRequest
	23, // 45: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.UpdateListing:input_type -> google.cloud.bigquery.analyticshub.v1.UpdateListingRequest
	24, // 46: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.DeleteListing:input_type -> google.cloud.bigquery.analyticshub.v1.DeleteListingRequest
	25, // 47: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.SubscribeListing:input_type -> google.cloud.bigquery.analyticshub.v1.SubscribeListingRequest
	27, // 48: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.SubscribeDataExchange:input_type -> google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeRequest
	29, // 49: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.RefreshSubscription:input_type -> google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionRequest
	31, // 50: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetSubscription:input_type -> google.cloud.bigquery.analyticshub.v1.GetSubscriptionRequest
	32, // 51: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListSubscriptions:input_type -> google.cloud.bigquery.analyticshub.v1.ListSubscriptionsRequest
	34, // 52: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListSharedResourceSubscriptions:input_type -> google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsRequest
	36, // 53: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.RevokeSubscription:input_type -> google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionRequest
	38, // 54: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.DeleteSubscription:input_type -> google.cloud.bigquery.analyticshub.v1.DeleteSubscriptionRequest
	51, // 55: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	52, // 56: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	53, // 57: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	12, // 58: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListDataExchanges:output_type -> google.cloud.bigquery.analyticshub.v1.ListDataExchangesResponse
	14, // 59: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListOrgDataExchanges:output_type -> google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesResponse
	3,  // 60: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetDataExchange:output_type -> google.cloud.bigquery.analyticshub.v1.DataExchange
	3,  // 61: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.CreateDataExchange:output_type -> google.cloud.bigquery.analyticshub.v1.DataExchange
	3,  // 62: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.UpdateDataExchange:output_type -> google.cloud.bigquery.analyticshub.v1.DataExchange
	54, // 63: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.DeleteDataExchange:output_type -> google.protobuf.Empty
	20, // 64: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListListings:output_type -> google.cloud.bigquery.analyticshub.v1.ListListingsResponse
	9,  // 65: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetListing:output_type -> google.cloud.bigquery.analyticshub.v1.Listing
	9,  // 66: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.CreateListing:output_type -> google.cloud.bigquery.analyticshub.v1.Listing
	9,  // 67: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.UpdateListing:output_type -> google.cloud.bigquery.analyticshub.v1.Listing
	54, // 68: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.DeleteListing:output_type -> google.protobuf.Empty
	26, // 69: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.SubscribeListing:output_type -> google.cloud.bigquery.analyticshub.v1.SubscribeListingResponse
	55, // 70: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.SubscribeDataExchange:output_type -> google.longrunning.Operation
	55, // 71: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.RefreshSubscription:output_type -> google.longrunning.Operation
	10, // 72: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetSubscription:output_type -> google.cloud.bigquery.analyticshub.v1.Subscription
	33, // 73: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListSubscriptions:output_type -> google.cloud.bigquery.analyticshub.v1.ListSubscriptionsResponse
	35, // 74: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.ListSharedResourceSubscriptions:output_type -> google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsResponse
	37, // 75: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.RevokeSubscription:output_type -> google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionResponse
	55, // 76: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.DeleteSubscription:output_type -> google.longrunning.Operation
	56, // 77: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.GetIamPolicy:output_type -> google.iam.v1.Policy
	56, // 78: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.SetIamPolicy:output_type -> google.iam.v1.Policy
	57, // 79: google.cloud.bigquery.analyticshub.v1.AnalyticsHubService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	58, // [58:80] is the sub-list for method output_type
	36, // [36:58] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_init() }
func file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_init() {
	if File_google_cloud_bigquery_analyticshub_v1_analyticshub_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataExchange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SharingEnvironmentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Publisher); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationDatasetReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataExchangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataExchangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOrgDataExchangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOrgDataExchangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListListingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListListingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeListingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeListingResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeDataExchangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeDataExchangeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshSubscriptionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubscriptionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubscriptionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSharedResourceSubscriptionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSharedResourceSubscriptionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevokeSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevokeSubscriptionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SharingEnvironmentConfig_DefaultExchangeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SharingEnvironmentConfig_DcrExchangeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listing_BigQueryDatasetSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listing_RestrictedExportConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listing_BigQueryDatasetSource_SelectedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription_LinkedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*SharingEnvironmentConfig_DefaultExchangeConfig_)(nil),
		(*SharingEnvironmentConfig_DcrExchangeConfig_)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Listing_BigqueryDataset)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Subscription_Listing)(nil),
		(*Subscription_DataExchange)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*SubscribeListingRequest_DestinationDataset)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[38].OneofWrappers = []interface{}{}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[42].OneofWrappers = []interface{}{
		(*Listing_BigQueryDatasetSource_SelectedResource_Table)(nil),
	}
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes[43].OneofWrappers = []interface{}{
		(*Subscription_LinkedResource_LinkedDataset)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   45,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_analyticshub_v1_analyticshub_proto = out.File
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_rawDesc = nil
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_goTypes = nil
	file_google_cloud_bigquery_analyticshub_v1_analyticshub_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyticsHubServiceClient is the client API for AnalyticsHubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyticsHubServiceClient interface {
	// Lists all data exchanges in a given project and location.
	ListDataExchanges(ctx context.Context, in *ListDataExchangesRequest, opts ...grpc.CallOption) (*ListDataExchangesResponse, error)
	// Lists all data exchanges from projects in a given organization and
	// location.
	ListOrgDataExchanges(ctx context.Context, in *ListOrgDataExchangesRequest, opts ...grpc.CallOption) (*ListOrgDataExchangesResponse, error)
	// Gets the details of a data exchange.
	GetDataExchange(ctx context.Context, in *GetDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Creates a new data exchange.
	CreateDataExchange(ctx context.Context, in *CreateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Updates an existing data exchange.
	UpdateDataExchange(ctx context.Context, in *UpdateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error)
	// Deletes an existing data exchange.
	DeleteDataExchange(ctx context.Context, in *DeleteDataExchangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all listings in a given project and location.
	ListListings(ctx context.Context, in *ListListingsRequest, opts ...grpc.CallOption) (*ListListingsResponse, error)
	// Gets the details of a listing.
	GetListing(ctx context.Context, in *GetListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Creates a new listing.
	CreateListing(ctx context.Context, in *CreateListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Updates an existing listing.
	UpdateListing(ctx context.Context, in *UpdateListingRequest, opts ...grpc.CallOption) (*Listing, error)
	// Deletes a listing.
	DeleteListing(ctx context.Context, in *DeleteListingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Subscribes to a listing.
	//
	// Currently, with Analytics Hub, you can create listings that
	// reference only BigQuery datasets.
	// Upon subscription to a listing for a BigQuery dataset, Analytics Hub
	// creates a linked dataset in the subscriber's project.
	SubscribeListing(ctx context.Context, in *SubscribeListingRequest, opts ...grpc.CallOption) (*SubscribeListingResponse, error)
	// Creates a Subscription to a Data Exchange. This is a long-running operation
	// as it will create one or more linked datasets.
	SubscribeDataExchange(ctx context.Context, in *SubscribeDataExchangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Refreshes a Subscription to a Data Exchange. A Data Exchange can become
	// stale when a publisher adds or removes data. This is a long-running
	// operation as it may create many linked datasets.
	RefreshSubscription(ctx context.Context, in *RefreshSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of a Subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists all subscriptions in a given project and location.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Lists all subscriptions on a given Data Exchange or Listing.
	ListSharedResourceSubscriptions(ctx context.Context, in *ListSharedResourceSubscriptionsRequest, opts ...grpc.CallOption) (*ListSharedResourceSubscriptionsResponse, error)
	// Revokes a given subscription.
	RevokeSubscription(ctx context.Context, in *RevokeSubscriptionRequest, opts ...grpc.CallOption) (*RevokeSubscriptionResponse, error)
	// Deletes a subscription.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the IAM policy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type analyticsHubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsHubServiceClient(cc grpc.ClientConnInterface) AnalyticsHubServiceClient {
	return &analyticsHubServiceClient{cc}
}

func (c *analyticsHubServiceClient) ListDataExchanges(ctx context.Context, in *ListDataExchangesRequest, opts ...grpc.CallOption) (*ListDataExchangesResponse, error) {
	out := new(ListDataExchangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListDataExchanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListOrgDataExchanges(ctx context.Context, in *ListOrgDataExchangesRequest, opts ...grpc.CallOption) (*ListOrgDataExchangesResponse, error) {
	out := new(ListOrgDataExchangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListOrgDataExchanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetDataExchange(ctx context.Context, in *GetDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateDataExchange(ctx context.Context, in *CreateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateDataExchange(ctx context.Context, in *UpdateDataExchangeRequest, opts ...grpc.CallOption) (*DataExchange, error) {
	out := new(DataExchange)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteDataExchange(ctx context.Context, in *DeleteDataExchangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListListings(ctx context.Context, in *ListListingsRequest, opts ...grpc.CallOption) (*ListListingsResponse, error) {
	out := new(ListListingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListListings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetListing(ctx context.Context, in *GetListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) CreateListing(ctx context.Context, in *CreateListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) UpdateListing(ctx context.Context, in *UpdateListingRequest, opts ...grpc.CallOption) (*Listing, error) {
	out := new(Listing)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteListing(ctx context.Context, in *DeleteListingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SubscribeListing(ctx context.Context, in *SubscribeListingRequest, opts ...grpc.CallOption) (*SubscribeListingResponse, error) {
	out := new(SubscribeListingResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubscribeListing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SubscribeDataExchange(ctx context.Context, in *SubscribeDataExchangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubscribeDataExchange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) RefreshSubscription(ctx context.Context, in *RefreshSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/RefreshSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) ListSharedResourceSubscriptions(ctx context.Context, in *ListSharedResourceSubscriptionsRequest, opts ...grpc.CallOption) (*ListSharedResourceSubscriptionsResponse, error) {
	out := new(ListSharedResourceSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListSharedResourceSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) RevokeSubscription(ctx context.Context, in *RevokeSubscriptionRequest, opts ...grpc.CallOption) (*RevokeSubscriptionResponse, error) {
	out := new(RevokeSubscriptionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/RevokeSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsHubServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsHubServiceServer is the server API for AnalyticsHubService service.
type AnalyticsHubServiceServer interface {
	// Lists all data exchanges in a given project and location.
	ListDataExchanges(context.Context, *ListDataExchangesRequest) (*ListDataExchangesResponse, error)
	// Lists all data exchanges from projects in a given organization and
	// location.
	ListOrgDataExchanges(context.Context, *ListOrgDataExchangesRequest) (*ListOrgDataExchangesResponse, error)
	// Gets the details of a data exchange.
	GetDataExchange(context.Context, *GetDataExchangeRequest) (*DataExchange, error)
	// Creates a new data exchange.
	CreateDataExchange(context.Context, *CreateDataExchangeRequest) (*DataExchange, error)
	// Updates an existing data exchange.
	UpdateDataExchange(context.Context, *UpdateDataExchangeRequest) (*DataExchange, error)
	// Deletes an existing data exchange.
	DeleteDataExchange(context.Context, *DeleteDataExchangeRequest) (*emptypb.Empty, error)
	// Lists all listings in a given project and location.
	ListListings(context.Context, *ListListingsRequest) (*ListListingsResponse, error)
	// Gets the details of a listing.
	GetListing(context.Context, *GetListingRequest) (*Listing, error)
	// Creates a new listing.
	CreateListing(context.Context, *CreateListingRequest) (*Listing, error)
	// Updates an existing listing.
	UpdateListing(context.Context, *UpdateListingRequest) (*Listing, error)
	// Deletes a listing.
	DeleteListing(context.Context, *DeleteListingRequest) (*emptypb.Empty, error)
	// Subscribes to a listing.
	//
	// Currently, with Analytics Hub, you can create listings that
	// reference only BigQuery datasets.
	// Upon subscription to a listing for a BigQuery dataset, Analytics Hub
	// creates a linked dataset in the subscriber's project.
	SubscribeListing(context.Context, *SubscribeListingRequest) (*SubscribeListingResponse, error)
	// Creates a Subscription to a Data Exchange. This is a long-running operation
	// as it will create one or more linked datasets.
	SubscribeDataExchange(context.Context, *SubscribeDataExchangeRequest) (*longrunningpb.Operation, error)
	// Refreshes a Subscription to a Data Exchange. A Data Exchange can become
	// stale when a publisher adds or removes data. This is a long-running
	// operation as it may create many linked datasets.
	RefreshSubscription(context.Context, *RefreshSubscriptionRequest) (*longrunningpb.Operation, error)
	// Gets the details of a Subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Lists all subscriptions in a given project and location.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Lists all subscriptions on a given Data Exchange or Listing.
	ListSharedResourceSubscriptions(context.Context, *ListSharedResourceSubscriptionsRequest) (*ListSharedResourceSubscriptionsResponse, error)
	// Revokes a given subscription.
	RevokeSubscription(context.Context, *RevokeSubscriptionRequest) (*RevokeSubscriptionResponse, error)
	// Deletes a subscription.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*longrunningpb.Operation, error)
	// Gets the IAM policy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedAnalyticsHubServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyticsHubServiceServer struct {
}

func (*UnimplementedAnalyticsHubServiceServer) ListDataExchanges(context.Context, *ListDataExchangesRequest) (*ListDataExchangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataExchanges not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) ListOrgDataExchanges(context.Context, *ListOrgDataExchangesRequest) (*ListOrgDataExchangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrgDataExchanges not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetDataExchange(context.Context, *GetDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) CreateDataExchange(context.Context, *CreateDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) UpdateDataExchange(context.Context, *UpdateDataExchangeRequest) (*DataExchange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) DeleteDataExchange(context.Context, *DeleteDataExchangeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) ListListings(context.Context, *ListListingsRequest) (*ListListingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListListings not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetListing(context.Context, *GetListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) CreateListing(context.Context, *CreateListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) UpdateListing(context.Context, *UpdateListingRequest) (*Listing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) DeleteListing(context.Context, *DeleteListingRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) SubscribeListing(context.Context, *SubscribeListingRequest) (*SubscribeListingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubscribeListing not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) SubscribeDataExchange(context.Context, *SubscribeDataExchangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubscribeDataExchange not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) RefreshSubscription(context.Context, *RefreshSubscriptionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshSubscription not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubscription not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscriptions not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) ListSharedResourceSubscriptions(context.Context, *ListSharedResourceSubscriptionsRequest) (*ListSharedResourceSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSharedResourceSubscriptions not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) RevokeSubscription(context.Context, *RevokeSubscriptionRequest) (*RevokeSubscriptionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeSubscription not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubscription not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedAnalyticsHubServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterAnalyticsHubServiceServer(s *grpc.Server, srv AnalyticsHubServiceServer) {
	s.RegisterService(&_AnalyticsHubService_serviceDesc, srv)
}

func _AnalyticsHubService_ListDataExchanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataExchangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListDataExchanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListDataExchanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListDataExchanges(ctx, req.(*ListDataExchangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListOrgDataExchanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrgDataExchangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListOrgDataExchanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListOrgDataExchanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListOrgDataExchanges(ctx, req.(*ListOrgDataExchangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetDataExchange(ctx, req.(*GetDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateDataExchange(ctx, req.(*CreateDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateDataExchange(ctx, req.(*UpdateDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteDataExchange(ctx, req.(*DeleteDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListListings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListListingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListListings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListListings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListListings(ctx, req.(*ListListingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetListing(ctx, req.(*GetListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_CreateListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).CreateListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/CreateListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).CreateListing(ctx, req.(*CreateListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_UpdateListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).UpdateListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/UpdateListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).UpdateListing(ctx, req.(*UpdateListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteListing(ctx, req.(*DeleteListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SubscribeListing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubscribeListingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SubscribeListing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubscribeListing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SubscribeListing(ctx, req.(*SubscribeListingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SubscribeDataExchange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubscribeDataExchangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SubscribeDataExchange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SubscribeDataExchange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SubscribeDataExchange(ctx, req.(*SubscribeDataExchangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_RefreshSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).RefreshSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/RefreshSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).RefreshSubscription(ctx, req.(*RefreshSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_ListSharedResourceSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSharedResourceSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).ListSharedResourceSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/ListSharedResourceSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).ListSharedResourceSubscriptions(ctx, req.(*ListSharedResourceSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_RevokeSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).RevokeSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/RevokeSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).RevokeSubscription(ctx, req.(*RevokeSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsHubService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsHubServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.analyticshub.v1.AnalyticsHubService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsHubServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnalyticsHubService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
	HandlerType: (*AnalyticsHubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDataExchanges",
			Handler:    _AnalyticsHubService_ListDataExchanges_Handler,
		},
		{
			MethodName: "ListOrgDataExchanges",
			Handler:    _AnalyticsHubService_ListOrgDataExchanges_Handler,
		},
		{
			MethodName: "GetDataExchange",
			Handler:    _AnalyticsHubService_GetDataExchange_Handler,
		},
		{
			MethodName: "CreateDataExchange",
			Handler:    _AnalyticsHubService_CreateDataExchange_Handler,
		},
		{
			MethodName: "UpdateDataExchange",
			Handler:    _AnalyticsHubService_UpdateDataExchange_Handler,
		},
		{
			MethodName: "DeleteDataExchange",
			Handler:    _AnalyticsHubService_DeleteDataExchange_Handler,
		},
		{
			MethodName: "ListListings",
			Handler:    _AnalyticsHubService_ListListings_Handler,
		},
		{
			MethodName: "GetListing",
			Handler:    _AnalyticsHubService_GetListing_Handler,
		},
		{
			MethodName: "CreateListing",
			Handler:    _AnalyticsHubService_CreateListing_Handler,
		},
		{
			MethodName: "UpdateListing",
			Handler:    _AnalyticsHubService_UpdateListing_Handler,
		},
		{
			MethodName: "DeleteListing",
			Handler:    _AnalyticsHubService_DeleteListing_Handler,
		},
		{
			MethodName: "SubscribeListing",
			Handler:    _AnalyticsHubService_SubscribeListing_Handler,
		},
		{
			MethodName: "SubscribeDataExchange",
			Handler:    _AnalyticsHubService_SubscribeDataExchange_Handler,
		},
		{
			MethodName: "RefreshSubscription",
			Handler:    _AnalyticsHubService_RefreshSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _AnalyticsHubService_GetSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _AnalyticsHubService_ListSubscriptions_Handler,
		},
		{
			MethodName: "ListSharedResourceSubscriptions",
			Handler:    _AnalyticsHubService_ListSharedResourceSubscriptions_Handler,
		},
		{
			MethodName: "RevokeSubscription",
			Handler:    _AnalyticsHubService_RevokeSubscription_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _AnalyticsHubService_DeleteSubscription_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _AnalyticsHubService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _AnalyticsHubService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _AnalyticsHubService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/analyticshub/v1/analyticshub.proto",
}
