// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

package lineagepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the run.
type Run_State int32

const (
	// The state is unknown. The true state may be any of the below or a
	// different state that is not supported here explicitly.
	Run_UNKNOWN Run_State = 0
	// The run is still executing.
	Run_STARTED Run_State = 1
	// The run completed.
	Run_COMPLETED Run_State = 2
	// The run failed.
	Run_FAILED Run_State = 3
	// The run aborted.
	Run_ABORTED Run_State = 4
)

// Enum value maps for Run_State.
var (
	Run_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "STARTED",
		2: "COMPLETED",
		3: "FAILED",
		4: "ABORTED",
	}
	Run_State_value = map[string]int32{
		"UNKNOWN":   0,
		"STARTED":   1,
		"COMPLETED": 2,
		"FAILED":    3,
		"ABORTED":   4,
	}
)

func (x Run_State) Enum() *Run_State {
	p := new(Run_State)
	*p = x
	return p
}

func (x Run_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Run_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[0].Descriptor()
}

func (Run_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[0]
}

func (x Run_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Run_State.Descriptor instead.
func (Run_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{1, 0}
}

// An enum with the state of the operation.
type OperationMetadata_State int32

const (
	// Unused.
	OperationMetadata_STATE_UNSPECIFIED OperationMetadata_State = 0
	// The operation has been created but is not yet started.
	OperationMetadata_PENDING OperationMetadata_State = 1
	// The operation is underway.
	OperationMetadata_RUNNING OperationMetadata_State = 2
	// The operation completed successfully.
	OperationMetadata_SUCCEEDED OperationMetadata_State = 3
	// The operation is no longer running and did not succeed.
	OperationMetadata_FAILED OperationMetadata_State = 4
)

// Enum value maps for OperationMetadata_State.
var (
	OperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	OperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
	}
)

func (x OperationMetadata_State) Enum() *OperationMetadata_State {
	p := new(OperationMetadata_State)
	*p = x
	return p
}

func (x OperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[1].Descriptor()
}

func (OperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[1]
}

func (x OperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationMetadata_State.Descriptor instead.
func (OperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{5, 0}
}

// Type of the long running operation.
type OperationMetadata_Type int32

const (
	// Unused.
	OperationMetadata_TYPE_UNSPECIFIED OperationMetadata_Type = 0
	// The resource deletion operation.
	OperationMetadata_DELETE OperationMetadata_Type = 1
	// The resource creation operation.
	OperationMetadata_CREATE OperationMetadata_Type = 2
)

// Enum value maps for OperationMetadata_Type.
var (
	OperationMetadata_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DELETE",
		2: "CREATE",
	}
	OperationMetadata_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"DELETE":           1,
		"CREATE":           2,
	}
)

func (x OperationMetadata_Type) Enum() *OperationMetadata_Type {
	p := new(OperationMetadata_Type)
	*p = x
	return p
}

func (x OperationMetadata_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationMetadata_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[2].Descriptor()
}

func (OperationMetadata_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[2]
}

func (x OperationMetadata_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationMetadata_Type.Descriptor instead.
func (OperationMetadata_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{5, 1}
}

// Type of the source of a process.
type Origin_SourceType int32

const (
	// Source is Unspecified
	Origin_SOURCE_TYPE_UNSPECIFIED Origin_SourceType = 0
	// A custom source
	Origin_CUSTOM Origin_SourceType = 1
	// BigQuery
	Origin_BIGQUERY Origin_SourceType = 2
	// Data Fusion
	Origin_DATA_FUSION Origin_SourceType = 3
	// Composer
	Origin_COMPOSER Origin_SourceType = 4
	// Looker Studio
	Origin_LOOKER_STUDIO Origin_SourceType = 5
	// Dataproc
	Origin_DATAPROC Origin_SourceType = 6
)

// Enum value maps for Origin_SourceType.
var (
	Origin_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNSPECIFIED",
		1: "CUSTOM",
		2: "BIGQUERY",
		3: "DATA_FUSION",
		4: "COMPOSER",
		5: "LOOKER_STUDIO",
		6: "DATAPROC",
	}
	Origin_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNSPECIFIED": 0,
		"CUSTOM":                  1,
		"BIGQUERY":                2,
		"DATA_FUSION":             3,
		"COMPOSER":                4,
		"LOOKER_STUDIO":           5,
		"DATAPROC":                6,
	}
)

func (x Origin_SourceType) Enum() *Origin_SourceType {
	p := new(Origin_SourceType)
	*p = x
	return p
}

func (x Origin_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Origin_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[3].Descriptor()
}

func (Origin_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes[3]
}

func (x Origin_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Origin_SourceType.Descriptor instead.
func (Origin_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{32, 0}
}

// A process is the definition of a data transformation operation.
type Process struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the lineage process. Format:
	// `projects/{project}/locations/{location}/processes/{process}`.
	// Can be specified or auto-assigned.
	// {process} must be not longer than 200 characters and only
	// contain characters in a set: `a-zA-Z0-9_-:.`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human-readable name you can set to display in a user interface.
	// Must be not longer than 200 characters and only contain UTF-8 letters
	// or numbers, spaces or characters like `_-:&.`
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The attributes of the process. Should only be used for the
	// purpose of non-semantic management (classifying, describing or labeling the
	// process).
	//
	// Up to 100 attributes are allowed.
	Attributes map[string]*structpb.Value `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The origin of this process and its runs and lineage events.
	Origin *Origin `protobuf:"bytes,4,opt,name=origin,proto3" json:"origin,omitempty"`
}

func (x *Process) Reset() {
	*x = Process{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Process) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Process) ProtoMessage() {}

func (x *Process) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Process.ProtoReflect.Descriptor instead.
func (*Process) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{0}
}

func (x *Process) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Process) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Process) GetAttributes() map[string]*structpb.Value {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Process) GetOrigin() *Origin {
	if x != nil {
		return x.Origin
	}
	return nil
}

// A lineage run represents an execution of a process that creates
// lineage events.
type Run struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the run. Format:
	// `projects/{project}/locations/{location}/processes/{process}/runs/{run}`.
	// Can be specified or auto-assigned.
	// {run} must be not longer than 200 characters and only
	// contain characters in a set: `a-zA-Z0-9_-:.`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human-readable name you can set to display in a user interface.
	// Must be not longer than 1024 characters and only contain UTF-8 letters
	// or numbers, spaces or characters like `_-:&.`
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The attributes of the run. Should only be used for the purpose of
	// non-semantic management (classifying, describing or labeling the run).
	//
	// Up to 100 attributes are allowed.
	Attributes map[string]*structpb.Value `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The timestamp of the start of the run.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The timestamp of the end of the run.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Required. The state of the run.
	State Run_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.datacatalog.lineage.v1.Run_State" json:"state,omitempty"`
}

func (x *Run) Reset() {
	*x = Run{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Run) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Run) ProtoMessage() {}

func (x *Run) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Run.ProtoReflect.Descriptor instead.
func (*Run) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{1}
}

func (x *Run) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Run) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Run) GetAttributes() map[string]*structpb.Value {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Run) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Run) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Run) GetState() Run_State {
	if x != nil {
		return x.State
	}
	return Run_UNKNOWN
}

// A lineage event represents an operation on assets. Within the operation, the
// data flows from the source to the target defined in the links field.
type LineageEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the lineage event.
	// Format:
	// `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
	// Can be specified or auto-assigned.
	// {lineage_event} must be not longer than 200 characters and only
	// contain characters in a set: `a-zA-Z0-9_-:.`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. List of source-target pairs. Can't contain more than 100 tuples.
	Links []*EventLink `protobuf:"bytes,8,rep,name=links,proto3" json:"links,omitempty"`
	// Required. The beginning of the transformation which resulted in this
	// lineage event. For streaming scenarios, it should be the beginning of the
	// period from which the lineage is being reported.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The end of the transformation which resulted in this lineage
	// event.  For streaming scenarios, it should be the end of the period from
	// which the lineage is being reported.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *LineageEvent) Reset() {
	*x = LineageEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LineageEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LineageEvent) ProtoMessage() {}

func (x *LineageEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LineageEvent.ProtoReflect.Descriptor instead.
func (*LineageEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{2}
}

func (x *LineageEvent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LineageEvent) GetLinks() []*EventLink {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *LineageEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *LineageEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// A lineage between source and target entities.
type EventLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the source entity
	Source *EntityReference `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Required. Reference to the target entity
	Target *EntityReference `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *EventLink) Reset() {
	*x = EventLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventLink) ProtoMessage() {}

func (x *EventLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventLink.ProtoReflect.Descriptor instead.
func (*EventLink) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{3}
}

func (x *EventLink) GetSource() *EntityReference {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *EventLink) GetTarget() *EntityReference {
	if x != nil {
		return x.Target
	}
	return nil
}

// The soft reference to everything you can attach a lineage event to.
type EntityReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. [Fully Qualified Name
	// (FQN)](https://cloud.google.com/data-catalog/docs/fully-qualified-names)
	// of the entity.
	FullyQualifiedName string `protobuf:"bytes,1,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3" json:"fully_qualified_name,omitempty"`
}

func (x *EntityReference) Reset() {
	*x = EntityReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityReference) ProtoMessage() {}

func (x *EntityReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityReference.ProtoReflect.Descriptor instead.
func (*EntityReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{4}
}

func (x *EntityReference) GetFullyQualifiedName() string {
	if x != nil {
		return x.FullyQualifiedName
	}
	return ""
}

// Metadata describing the operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The current operation state.
	State OperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.datacatalog.lineage.v1.OperationMetadata_State" json:"state,omitempty"`
	// Output only. The type of the operation being performed.
	OperationType OperationMetadata_Type `protobuf:"varint,2,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.datacatalog.lineage.v1.OperationMetadata_Type" json:"operation_type,omitempty"`
	// Output only. The [relative name]
	// (https://cloud.google.com//apis/design/resource_names#relative_resource_name)
	// of the resource being operated on.
	Resource string `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// Output only. The UUID of the resource being operated on.
	ResourceUuid string `protobuf:"bytes,4,opt,name=resource_uuid,json=resourceUuid,proto3" json:"resource_uuid,omitempty"`
	// Output only. The timestamp of the operation submission to the server.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp of the operation termination, regardless of its
	// success. This field is unset if the operation is still ongoing.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{5}
}

func (x *OperationMetadata) GetState() OperationMetadata_State {
	if x != nil {
		return x.State
	}
	return OperationMetadata_STATE_UNSPECIFIED
}

func (x *OperationMetadata) GetOperationType() OperationMetadata_Type {
	if x != nil {
		return x.OperationType
	}
	return OperationMetadata_TYPE_UNSPECIFIED
}

func (x *OperationMetadata) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *OperationMetadata) GetResourceUuid() string {
	if x != nil {
		return x.ResourceUuid
	}
	return ""
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Request message for
// [ProcessOpenLineageRunEvent][google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEvent].
type ProcessOpenLineageRunEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and its location that should own the
	// process, run, and lineage event.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. OpenLineage message following OpenLineage format:
	// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json
	OpenLineage *structpb.Struct `protobuf:"bytes,2,opt,name=open_lineage,json=openLineage,proto3" json:"open_lineage,omitempty"`
	// A unique identifier for this request. Restricted to 36 ASCII characters.
	// A random UUID is recommended. This request is idempotent only if a
	// `request_id` is provided.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ProcessOpenLineageRunEventRequest) Reset() {
	*x = ProcessOpenLineageRunEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessOpenLineageRunEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessOpenLineageRunEventRequest) ProtoMessage() {}

func (x *ProcessOpenLineageRunEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessOpenLineageRunEventRequest.ProtoReflect.Descriptor instead.
func (*ProcessOpenLineageRunEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{6}
}

func (x *ProcessOpenLineageRunEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ProcessOpenLineageRunEventRequest) GetOpenLineage() *structpb.Struct {
	if x != nil {
		return x.OpenLineage
	}
	return nil
}

func (x *ProcessOpenLineageRunEventRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for
// [ProcessOpenLineageRunEvent][google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEvent].
type ProcessOpenLineageRunEventResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Created process name.
	// Format: `projects/{project}/locations/{location}/processes/{process}`.
	Process string `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// Created run name.
	// Format:
	// `projects/{project}/locations/{location}/processes/{process}/runs/{run}`.
	Run string `protobuf:"bytes,2,opt,name=run,proto3" json:"run,omitempty"`
	// Created lineage event names.
	// Format:
	// `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
	LineageEvents []string `protobuf:"bytes,3,rep,name=lineage_events,json=lineageEvents,proto3" json:"lineage_events,omitempty"`
}

func (x *ProcessOpenLineageRunEventResponse) Reset() {
	*x = ProcessOpenLineageRunEventResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessOpenLineageRunEventResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessOpenLineageRunEventResponse) ProtoMessage() {}

func (x *ProcessOpenLineageRunEventResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessOpenLineageRunEventResponse.ProtoReflect.Descriptor instead.
func (*ProcessOpenLineageRunEventResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{7}
}

func (x *ProcessOpenLineageRunEventResponse) GetProcess() string {
	if x != nil {
		return x.Process
	}
	return ""
}

func (x *ProcessOpenLineageRunEventResponse) GetRun() string {
	if x != nil {
		return x.Run
	}
	return ""
}

func (x *ProcessOpenLineageRunEventResponse) GetLineageEvents() []string {
	if x != nil {
		return x.LineageEvents
	}
	return nil
}

// Request message for
// [CreateProcess][google.cloud.datacatalog.lineage.v1.CreateProcess].
type CreateProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and its location that should own the
	// process.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The process to create.
	Process *Process `protobuf:"bytes,2,opt,name=process,proto3" json:"process,omitempty"`
	// A unique identifier for this request. Restricted to 36 ASCII characters.
	// A random UUID is recommended. This request is idempotent only if a
	// `request_id` is provided.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateProcessRequest) Reset() {
	*x = CreateProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProcessRequest) ProtoMessage() {}

func (x *CreateProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProcessRequest.ProtoReflect.Descriptor instead.
func (*CreateProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{8}
}

func (x *CreateProcessRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProcessRequest) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *CreateProcessRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [UpdateProcess][google.cloud.datacatalog.lineage.v1.UpdateProcess].
type UpdateProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The lineage process to update.
	//
	// The process's `name` field is used to identify the process to update.
	Process *Process `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// The list of fields to update. Currently not used. The whole message is
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true and the process is not found, the request inserts it.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateProcessRequest) Reset() {
	*x = UpdateProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProcessRequest) ProtoMessage() {}

func (x *UpdateProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProcessRequest.ProtoReflect.Descriptor instead.
func (*UpdateProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateProcessRequest) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *UpdateProcessRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateProcessRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [GetProcess][google.cloud.datacatalog.lineage.v1.GetProcess].
type GetProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the process to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessRequest) Reset() {
	*x = GetProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessRequest) ProtoMessage() {}

func (x *GetProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessRequest.ProtoReflect.Descriptor instead.
func (*GetProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{10}
}

func (x *GetProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ListProcesses][google.cloud.datacatalog.lineage.v1.ListProcesses].
type ListProcessesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and its location that owns this
	// collection of processes.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processes to return. The service may return
	// fewer than this value. If unspecified, at most 50 processes are
	// returned. The maximum value is 100; values greater than 100 are cut to
	// 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token received from a previous `ListProcesses` call. Specify
	// it to get the next page.
	//
	// When paginating, all other parameters specified in this call must
	// match the parameters of the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessesRequest) Reset() {
	*x = ListProcessesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessesRequest) ProtoMessage() {}

func (x *ListProcessesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessesRequest.ProtoReflect.Descriptor instead.
func (*ListProcessesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{11}
}

func (x *ListProcessesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListProcesses][google.cloud.datacatalog.lineage.v1.ListProcesses].
type ListProcessesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The processes from the specified project and location.
	Processes []*Process `protobuf:"bytes,1,rep,name=processes,proto3" json:"processes,omitempty"`
	// The token to specify as `page_token` in the next call to get the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessesResponse) Reset() {
	*x = ListProcessesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessesResponse) ProtoMessage() {}

func (x *ListProcessesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessesResponse.ProtoReflect.Descriptor instead.
func (*ListProcessesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{12}
}

func (x *ListProcessesResponse) GetProcesses() []*Process {
	if x != nil {
		return x.Processes
	}
	return nil
}

func (x *ListProcessesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DeleteProcess][google.cloud.datacatalog.lineage.v1.DeleteProcess].
type DeleteProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the process to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true and the process is not found, the request
	// succeeds but the server doesn't perform any actions.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *DeleteProcessRequest) Reset() {
	*x = DeleteProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessRequest) ProtoMessage() {}

func (x *DeleteProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteProcessRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [CreateRun][google.cloud.datacatalog.lineage.v1.CreateRun].
type CreateRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the process that should own the run.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The run to create.
	Run *Run `protobuf:"bytes,2,opt,name=run,proto3" json:"run,omitempty"`
	// A unique identifier for this request. Restricted to 36 ASCII characters.
	// A random UUID is recommended. This request is idempotent only if a
	// `request_id` is provided.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateRunRequest) Reset() {
	*x = CreateRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRunRequest) ProtoMessage() {}

func (x *CreateRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRunRequest.ProtoReflect.Descriptor instead.
func (*CreateRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{14}
}

func (x *CreateRunRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRunRequest) GetRun() *Run {
	if x != nil {
		return x.Run
	}
	return nil
}

func (x *CreateRunRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [UpdateRun][google.cloud.datacatalog.lineage.v1.UpdateRun].
type UpdateRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The lineage run to update.
	//
	// The run's `name` field is used to identify the run to update.
	//
	// Format:
	// `projects/{project}/locations/{location}/processes/{process}/runs/{run}`.
	Run *Run `protobuf:"bytes,1,opt,name=run,proto3" json:"run,omitempty"`
	// The list of fields to update. Currently not used. The whole message is
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true and the run is not found, the request creates it.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateRunRequest) Reset() {
	*x = UpdateRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRunRequest) ProtoMessage() {}

func (x *UpdateRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRunRequest.ProtoReflect.Descriptor instead.
func (*UpdateRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateRunRequest) GetRun() *Run {
	if x != nil {
		return x.Run
	}
	return nil
}

func (x *UpdateRunRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateRunRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [GetRun][google.cloud.datacatalog.lineage.v1.GetRun].
type GetRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the run to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRunRequest) Reset() {
	*x = GetRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRunRequest) ProtoMessage() {}

func (x *GetRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRunRequest.ProtoReflect.Descriptor instead.
func (*GetRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{16}
}

func (x *GetRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ListRuns][google.cloud.datacatalog.lineage.v1.ListRuns].
type ListRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of process that owns this collection of runs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of runs to return. The service may return
	// fewer than this value. If unspecified, at most 50 runs are
	// returned. The maximum value is 100; values greater than 100 are cut to
	// 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token received from a previous `ListRuns` call. Specify
	// it to get the next page.
	//
	// When paginating, all other parameters specified in this call must
	// match the parameters of the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRunsRequest) Reset() {
	*x = ListRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRunsRequest) ProtoMessage() {}

func (x *ListRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRunsRequest.ProtoReflect.Descriptor instead.
func (*ListRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{17}
}

func (x *ListRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListRuns][google.cloud.datacatalog.lineage.v1.ListRuns].
type ListRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The runs from the specified project and location.
	Runs []*Run `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
	// The token to specify as `page_token` in the next call to get the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRunsResponse) Reset() {
	*x = ListRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRunsResponse) ProtoMessage() {}

func (x *ListRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRunsResponse.ProtoReflect.Descriptor instead.
func (*ListRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{18}
}

func (x *ListRunsResponse) GetRuns() []*Run {
	if x != nil {
		return x.Runs
	}
	return nil
}

func (x *ListRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DeleteRun][google.cloud.datacatalog.lineage.v1.DeleteRun].
type DeleteRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the run to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true and the run is not found, the request
	// succeeds but the server doesn't perform any actions.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *DeleteRunRequest) Reset() {
	*x = DeleteRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRunRequest) ProtoMessage() {}

func (x *DeleteRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRunRequest.ProtoReflect.Descriptor instead.
func (*DeleteRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRunRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [CreateLineageEvent][google.cloud.datacatalog.lineage.v1.CreateLineageEvent].
type CreateLineageEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the run that should own the lineage event.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The lineage event to create.
	LineageEvent *LineageEvent `protobuf:"bytes,2,opt,name=lineage_event,json=lineageEvent,proto3" json:"lineage_event,omitempty"`
	// A unique identifier for this request. Restricted to 36 ASCII characters.
	// A random UUID is recommended. This request is idempotent only if a
	// `request_id` is provided.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateLineageEventRequest) Reset() {
	*x = CreateLineageEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLineageEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLineageEventRequest) ProtoMessage() {}

func (x *CreateLineageEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLineageEventRequest.ProtoReflect.Descriptor instead.
func (*CreateLineageEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{20}
}

func (x *CreateLineageEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLineageEventRequest) GetLineageEvent() *LineageEvent {
	if x != nil {
		return x.LineageEvent
	}
	return nil
}

func (x *CreateLineageEventRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [GetLineageEvent][google.cloud.datacatalog.lineage.v1.GetLineageEvent].
type GetLineageEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the lineage event to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLineageEventRequest) Reset() {
	*x = GetLineageEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLineageEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLineageEventRequest) ProtoMessage() {}

func (x *GetLineageEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLineageEventRequest.ProtoReflect.Descriptor instead.
func (*GetLineageEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{21}
}

func (x *GetLineageEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ListLineageEvents][google.cloud.datacatalog.lineage.v1.ListLineageEvents].
type ListLineageEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the run that owns the collection of lineage events to
	// get.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of lineage events to return.
	//
	// The service may return fewer events than this value.
	// If unspecified, at most 50 events are returned. The maximum value is 100;
	// values greater than 100 are cut to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token received from a previous `ListLineageEvents` call. Specify
	// it to get the next page.
	//
	// When paginating, all other parameters specified in this call must
	// match the parameters of the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLineageEventsRequest) Reset() {
	*x = ListLineageEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLineageEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLineageEventsRequest) ProtoMessage() {}

func (x *ListLineageEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLineageEventsRequest.ProtoReflect.Descriptor instead.
func (*ListLineageEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{22}
}

func (x *ListLineageEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLineageEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLineageEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListLineageEvents][google.cloud.datacatalog.lineage.v1.ListLineageEvents].
type ListLineageEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lineage events from the specified project and location.
	LineageEvents []*LineageEvent `protobuf:"bytes,1,rep,name=lineage_events,json=lineageEvents,proto3" json:"lineage_events,omitempty"`
	// The token to specify as `page_token` in the next call to get the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLineageEventsResponse) Reset() {
	*x = ListLineageEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLineageEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLineageEventsResponse) ProtoMessage() {}

func (x *ListLineageEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLineageEventsResponse.ProtoReflect.Descriptor instead.
func (*ListLineageEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{23}
}

func (x *ListLineageEventsResponse) GetLineageEvents() []*LineageEvent {
	if x != nil {
		return x.LineageEvents
	}
	return nil
}

func (x *ListLineageEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DeleteLineageEvent][google.cloud.datacatalog.lineage.v1.DeleteLineageEvent].
type DeleteLineageEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the lineage event to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true and the lineage event is not found, the request
	// succeeds but the server doesn't perform any actions.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *DeleteLineageEventRequest) Reset() {
	*x = DeleteLineageEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteLineageEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLineageEventRequest) ProtoMessage() {}

func (x *DeleteLineageEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLineageEventRequest.ProtoReflect.Descriptor instead.
func (*DeleteLineageEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteLineageEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteLineageEventRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks].
type SearchLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location you want search in.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The asset for which you want to retrieve links.
	//
	// Types that are assignable to Criteria:
	//
	//	*SearchLinksRequest_Source
	//	*SearchLinksRequest_Target
	Criteria isSearchLinksRequest_Criteria `protobuf_oneof:"criteria"`
	// Optional. The maximum number of links to return in a single page of the
	// response. A page may contain fewer links than this value. If unspecified,
	// at most 10 links are returned.
	//
	// Maximum value is 100; values greater than 100 are reduced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token received from a previous `SearchLinksRequest`
	// call. Use it to get the next page.
	//
	// When requesting subsequent pages of a response, remember that
	// all parameters must match the values you provided
	// in the original request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchLinksRequest) Reset() {
	*x = SearchLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchLinksRequest) ProtoMessage() {}

func (x *SearchLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchLinksRequest.ProtoReflect.Descriptor instead.
func (*SearchLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{25}
}

func (x *SearchLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *SearchLinksRequest) GetCriteria() isSearchLinksRequest_Criteria {
	if m != nil {
		return m.Criteria
	}
	return nil
}

func (x *SearchLinksRequest) GetSource() *EntityReference {
	if x, ok := x.GetCriteria().(*SearchLinksRequest_Source); ok {
		return x.Source
	}
	return nil
}

func (x *SearchLinksRequest) GetTarget() *EntityReference {
	if x, ok := x.GetCriteria().(*SearchLinksRequest_Target); ok {
		return x.Target
	}
	return nil
}

func (x *SearchLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type isSearchLinksRequest_Criteria interface {
	isSearchLinksRequest_Criteria()
}

type SearchLinksRequest_Source struct {
	// Optional. Send asset information in the **source** field to retrieve all
	// links that lead from the specified asset to downstream assets.
	Source *EntityReference `protobuf:"bytes,4,opt,name=source,proto3,oneof"`
}

type SearchLinksRequest_Target struct {
	// Optional. Send asset information in the **target** field to retrieve all
	// links that lead from upstream assets to the specified asset.
	Target *EntityReference `protobuf:"bytes,5,opt,name=target,proto3,oneof"`
}

func (*SearchLinksRequest_Source) isSearchLinksRequest_Criteria() {}

func (*SearchLinksRequest_Target) isSearchLinksRequest_Criteria() {}

// Response message for
// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks].
type SearchLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of links for a given asset. Can be empty if the asset has no
	// relations of requested type (source or target).
	Links []*Link `protobuf:"bytes,1,rep,name=links,proto3" json:"links,omitempty"`
	// The token to specify as `page_token` in the subsequent call to get the next
	// page. Omitted if there are no more pages in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchLinksResponse) Reset() {
	*x = SearchLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchLinksResponse) ProtoMessage() {}

func (x *SearchLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchLinksResponse.ProtoReflect.Descriptor instead.
func (*SearchLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{26}
}

func (x *SearchLinksResponse) GetLinks() []*Link {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *SearchLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Links represent the data flow between **source** (upstream)
// and **target** (downstream) assets in transformation pipelines.
//
// Links are created when LineageEvents record data transformation between
// related assets.
type Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The name of the link. Format:
	// `projects/{project}/locations/{location}/links/{link}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The pointer to the entity that is the **source** of this link.
	Source *EntityReference `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// The pointer to the entity that is the **target** of this link.
	Target *EntityReference `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// The start of the first event establishing this link.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end of the last event establishing this link.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Link) Reset() {
	*x = Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link) ProtoMessage() {}

func (x *Link) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link.ProtoReflect.Descriptor instead.
func (*Link) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{27}
}

func (x *Link) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Link) GetSource() *EntityReference {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Link) GetTarget() *EntityReference {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *Link) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Link) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Request message for
// [BatchSearchLinkProcesses][google.cloud.datacatalog.lineage.v1.Lineage.BatchSearchLinkProcesses].
type BatchSearchLinkProcessesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location where you want to search.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. An array of links to check for their associated LineageProcesses.
	//
	// The maximum number of items in this array is 100.
	// If the request contains more than 100 links, it returns the
	// `INVALID_ARGUMENT` error.
	//
	// Format: `projects/{project}/locations/{location}/links/{link}`.
	Links []string `protobuf:"bytes,2,rep,name=links,proto3" json:"links,omitempty"`
	// The maximum number of processes to return in a single page of the response.
	// A page may contain fewer results than this value.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token received from a previous `BatchSearchLinkProcesses` call.
	// Use it to get the next page.
	//
	// When requesting subsequent pages of a response, remember that
	// all parameters must match the values you provided
	// in the original request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *BatchSearchLinkProcessesRequest) Reset() {
	*x = BatchSearchLinkProcessesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchSearchLinkProcessesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchSearchLinkProcessesRequest) ProtoMessage() {}

func (x *BatchSearchLinkProcessesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchSearchLinkProcessesRequest.ProtoReflect.Descriptor instead.
func (*BatchSearchLinkProcessesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{28}
}

func (x *BatchSearchLinkProcessesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchSearchLinkProcessesRequest) GetLinks() []string {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *BatchSearchLinkProcessesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *BatchSearchLinkProcessesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [BatchSearchLinkProcesses][google.cloud.datacatalog.lineage.v1.Lineage.BatchSearchLinkProcesses].
type BatchSearchLinkProcessesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An array of processes associated with the specified links.
	ProcessLinks []*ProcessLinks `protobuf:"bytes,1,rep,name=process_links,json=processLinks,proto3" json:"process_links,omitempty"`
	// The token to specify as `page_token` in the subsequent call to get the next
	// page. Omitted if there are no more pages in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *BatchSearchLinkProcessesResponse) Reset() {
	*x = BatchSearchLinkProcessesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchSearchLinkProcessesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchSearchLinkProcessesResponse) ProtoMessage() {}

func (x *BatchSearchLinkProcessesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchSearchLinkProcessesResponse.ProtoReflect.Descriptor instead.
func (*BatchSearchLinkProcessesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{29}
}

func (x *BatchSearchLinkProcessesResponse) GetProcessLinks() []*ProcessLinks {
	if x != nil {
		return x.ProcessLinks
	}
	return nil
}

func (x *BatchSearchLinkProcessesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Links associated with a specific process.
type ProcessLinks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The process name in the format of
	// `projects/{project}/locations/{location}/processes/{process}`.
	Process string `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// An array containing link details objects of the links provided in
	// the original request.
	//
	// A single process can result in creating multiple links.
	// If any of the links you provide in the request are created by
	// the same process, they all are included in this array.
	Links []*ProcessLinkInfo `protobuf:"bytes,2,rep,name=links,proto3" json:"links,omitempty"`
}

func (x *ProcessLinks) Reset() {
	*x = ProcessLinks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessLinks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessLinks) ProtoMessage() {}

func (x *ProcessLinks) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessLinks.ProtoReflect.Descriptor instead.
func (*ProcessLinks) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{30}
}

func (x *ProcessLinks) GetProcess() string {
	if x != nil {
		return x.Process
	}
	return ""
}

func (x *ProcessLinks) GetLinks() []*ProcessLinkInfo {
	if x != nil {
		return x.Links
	}
	return nil
}

// Link details.
type ProcessLinkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the link in the format of
	// `projects/{project}/locations/{location}/links/{link}`.
	Link string `protobuf:"bytes,1,opt,name=link,proto3" json:"link,omitempty"`
	// The start of the first event establishing this link-process tuple.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end of the last event establishing this link-process tuple.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ProcessLinkInfo) Reset() {
	*x = ProcessLinkInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessLinkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessLinkInfo) ProtoMessage() {}

func (x *ProcessLinkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessLinkInfo.ProtoReflect.Descriptor instead.
func (*ProcessLinkInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{31}
}

func (x *ProcessLinkInfo) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

func (x *ProcessLinkInfo) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ProcessLinkInfo) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Origin of a process.
type Origin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the source.
	//
	// Use of a source_type other than `CUSTOM` for process creation
	// or updating is highly discouraged, and may be restricted in the future
	// without notice.
	SourceType Origin_SourceType `protobuf:"varint,1,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.datacatalog.lineage.v1.Origin_SourceType" json:"source_type,omitempty"`
	// If the source_type isn't CUSTOM, the value of this field should be a GCP
	// resource name of the system, which reports lineage. The project and
	// location parts of the resource name must match the project and location of
	// the lineage resource being created. Examples:
	//
	//   - `{source_type: COMPOSER, name:
	//     "projects/foo/locations/us/environments/bar"}`
	//   - `{source_type: BIGQUERY, name: "projects/foo/locations/eu"}`
	//   - `{source_type: CUSTOM,   name: "myCustomIntegration"}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Origin) Reset() {
	*x = Origin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Origin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Origin) ProtoMessage() {}

func (x *Origin) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Origin.ProtoReflect.Descriptor instead.
func (*Origin) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP(), []int{32}
}

func (x *Origin) GetSourceType() Origin_SourceType {
	if x != nil {
		return x.SourceType
	}
	return Origin_SOURCE_TYPE_UNSPECIFIED
}

func (x *Origin) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_datacatalog_lineage_v1_lineage_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb4,
	0x03, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x48,
	0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x1a, 0x55, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x64, 0xea, 0x41, 0x61, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x3b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x7d, 0x22, 0xfb, 0x04, 0x0a, 0x03, 0x52, 0x75, 0x6e, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5d,
	0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x1a, 0x55, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x42, 0x4f,
	0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x1e, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x12, 0x46, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x72,
	0x75, 0x6e, 0x7d, 0x22, 0x84, 0x03, 0x0a, 0x0c, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a,
	0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x3a, 0x93, 0x01, 0xea, 0x41, 0x8f, 0x01, 0x0a, 0x27, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x7d, 0x2f, 0x6c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x6c, 0x69, 0x6e, 0x65,
	0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xb1, 0x01, 0x0a, 0x09, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x51, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x48,
	0x0a, 0x0f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x35, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x04, 0x0a, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x57,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x67, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x75,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0x34,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x10, 0x02, 0x22, 0xa0, 0x01, 0x0a, 0x21, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x6e, 0x5f,
	0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6f, 0x70, 0x65,
	0x6e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xf3, 0x01, 0x0a, 0x22, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x52, 0x75,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x35, 0x0a, 0x03, 0x72, 0x75, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x75, 0x6e, 0x52, 0x03, 0x72, 0x75, 0x6e, 0x12, 0x53, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x65,
	0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0d,
	0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xc6, 0x01,
	0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc5, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x53,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8b, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0xb2, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x03,
	0x72, 0x75, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x72, 0x75, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb5, 0x01, 0x0a,
	0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x03, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x72,
	0x75, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x22, 0x4b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x8d, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x78, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x72,
	0x75, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x73, 0x0a, 0x10, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x22, 0xe0, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65,
	0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0d, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x5d, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x85, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0xd4, 0x02, 0x0a,
	0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x22, 0x7e, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xb0, 0x02, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x1a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x1f, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x12, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19,
	0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x20, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x0d, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x0c, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x41, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x4a,
	0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x97, 0x01, 0x0a, 0x0f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6c, 0x69,
	0x6e, 0x6b, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xfb, 0x01, 0x0a, 0x06, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x12,
	0x57, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a,
	0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59,
	0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f,
	0x4e, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x53, 0x45, 0x52, 0x10,
	0x04, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x4f, 0x4f, 0x4b, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x55, 0x44,
	0x49, 0x4f, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x43,
	0x10, 0x06, 0x32, 0xbc, 0x1d, 0x0a, 0x07, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x12, 0x99,
	0x02, 0x0a, 0x1a, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x52, 0x75,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a,
	0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x0c, 0x6f, 0x70,
	0x65, 0x6e, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x52, 0x75, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0xc9, 0x01, 0x0a, 0x0d, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0x4f, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x07,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x22, 0x5c, 0xda, 0x41, 0x13, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a,
	0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x32, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xb0, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xc6, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0xf9, 0x01, 0x0a, 0x0d,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x4e, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbc, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x75, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x22, 0x4e, 0xda, 0x41, 0x0a, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x72, 0x75, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x03, 0x72, 0x75, 0x6e,
	0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0xc5, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x75, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x22, 0x57, 0xda, 0x41, 0x0f, 0x72, 0x75, 0x6e, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a,
	0x03, 0x72, 0x75, 0x6e, 0x32, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xab,
	0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbe, 0x01, 0x0a,
	0x08, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0xf8, 0x01,
	0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x94, 0x01, 0xca, 0x41, 0x4e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfb, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x65,
	0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x22, 0x72, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x55, 0x3a, 0x0d, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x53, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xe9, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x12,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x53, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x2a, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xbc, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xf0,
	0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41,
	0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xf2, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x6c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x70, 0x62,
	0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x4c, 0x69, 0x6e, 0x65,
	0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x5c, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x27, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x4c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescData = file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDesc
)

func file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDescData
}

var file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes = make([]protoimpl.MessageInfo, 35)
var file_google_cloud_datacatalog_lineage_v1_lineage_proto_goTypes = []interface{}{
	(Run_State)(0),                             // 0: google.cloud.datacatalog.lineage.v1.Run.State
	(OperationMetadata_State)(0),               // 1: google.cloud.datacatalog.lineage.v1.OperationMetadata.State
	(OperationMetadata_Type)(0),                // 2: google.cloud.datacatalog.lineage.v1.OperationMetadata.Type
	(Origin_SourceType)(0),                     // 3: google.cloud.datacatalog.lineage.v1.Origin.SourceType
	(*Process)(nil),                            // 4: google.cloud.datacatalog.lineage.v1.Process
	(*Run)(nil),                                // 5: google.cloud.datacatalog.lineage.v1.Run
	(*LineageEvent)(nil),                       // 6: google.cloud.datacatalog.lineage.v1.LineageEvent
	(*EventLink)(nil),                          // 7: google.cloud.datacatalog.lineage.v1.EventLink
	(*EntityReference)(nil),                    // 8: google.cloud.datacatalog.lineage.v1.EntityReference
	(*OperationMetadata)(nil),                  // 9: google.cloud.datacatalog.lineage.v1.OperationMetadata
	(*ProcessOpenLineageRunEventRequest)(nil),  // 10: google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest
	(*ProcessOpenLineageRunEventResponse)(nil), // 11: google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse
	(*CreateProcessRequest)(nil),               // 12: google.cloud.datacatalog.lineage.v1.CreateProcessRequest
	(*UpdateProcessRequest)(nil),               // 13: google.cloud.datacatalog.lineage.v1.UpdateProcessRequest
	(*GetProcessRequest)(nil),                  // 14: google.cloud.datacatalog.lineage.v1.GetProcessRequest
	(*ListProcessesRequest)(nil),               // 15: google.cloud.datacatalog.lineage.v1.ListProcessesRequest
	(*ListProcessesResponse)(nil),              // 16: google.cloud.datacatalog.lineage.v1.ListProcessesResponse
	(*DeleteProcessRequest)(nil),               // 17: google.cloud.datacatalog.lineage.v1.DeleteProcessRequest
	(*CreateRunRequest)(nil),                   // 18: google.cloud.datacatalog.lineage.v1.CreateRunRequest
	(*UpdateRunRequest)(nil),                   // 19: google.cloud.datacatalog.lineage.v1.UpdateRunRequest
	(*GetRunRequest)(nil),                      // 20: google.cloud.datacatalog.lineage.v1.GetRunRequest
	(*ListRunsRequest)(nil),                    // 21: google.cloud.datacatalog.lineage.v1.ListRunsRequest
	(*ListRunsResponse)(nil),                   // 22: google.cloud.datacatalog.lineage.v1.ListRunsResponse
	(*DeleteRunRequest)(nil),                   // 23: google.cloud.datacatalog.lineage.v1.DeleteRunRequest
	(*CreateLineageEventRequest)(nil),          // 24: google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest
	(*GetLineageEventRequest)(nil),             // 25: google.cloud.datacatalog.lineage.v1.GetLineageEventRequest
	(*ListLineageEventsRequest)(nil),           // 26: google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest
	(*ListLineageEventsResponse)(nil),          // 27: google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse
	(*DeleteLineageEventRequest)(nil),          // 28: google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest
	(*SearchLinksRequest)(nil),                 // 29: google.cloud.datacatalog.lineage.v1.SearchLinksRequest
	(*SearchLinksResponse)(nil),                // 30: google.cloud.datacatalog.lineage.v1.SearchLinksResponse
	(*Link)(nil),                               // 31: google.cloud.datacatalog.lineage.v1.Link
	(*BatchSearchLinkProcessesRequest)(nil),    // 32: google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest
	(*BatchSearchLinkProcessesResponse)(nil),   // 33: google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse
	(*ProcessLinks)(nil),                       // 34: google.cloud.datacatalog.lineage.v1.ProcessLinks
	(*ProcessLinkInfo)(nil),                    // 35: google.cloud.datacatalog.lineage.v1.ProcessLinkInfo
	(*Origin)(nil),                             // 36: google.cloud.datacatalog.lineage.v1.Origin
	nil,                                        // 37: google.cloud.datacatalog.lineage.v1.Process.AttributesEntry
	nil,                                        // 38: google.cloud.datacatalog.lineage.v1.Run.AttributesEntry
	(*timestamppb.Timestamp)(nil),              // 39: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                    // 40: google.protobuf.Struct
	(*fieldmaskpb.FieldMask)(nil),              // 41: google.protobuf.FieldMask
	(*structpb.Value)(nil),                     // 42: google.protobuf.Value
	(*longrunningpb.Operation)(nil),            // 43: google.longrunning.Operation
	(*emptypb.Empty)(nil),                      // 44: google.protobuf.Empty
}
var file_google_cloud_datacatalog_lineage_v1_lineage_proto_depIdxs = []int32{
	37, // 0: google.cloud.datacatalog.lineage.v1.Process.attributes:type_name -> google.cloud.datacatalog.lineage.v1.Process.AttributesEntry
	36, // 1: google.cloud.datacatalog.lineage.v1.Process.origin:type_name -> google.cloud.datacatalog.lineage.v1.Origin
	38, // 2: google.cloud.datacatalog.lineage.v1.Run.attributes:type_name -> google.cloud.datacatalog.lineage.v1.Run.AttributesEntry
	39, // 3: google.cloud.datacatalog.lineage.v1.Run.start_time:type_name -> google.protobuf.Timestamp
	39, // 4: google.cloud.datacatalog.lineage.v1.Run.end_time:type_name -> google.protobuf.Timestamp
	0,  // 5: google.cloud.datacatalog.lineage.v1.Run.state:type_name -> google.cloud.datacatalog.lineage.v1.Run.State
	7,  // 6: google.cloud.datacatalog.lineage.v1.LineageEvent.links:type_name -> google.cloud.datacatalog.lineage.v1.EventLink
	39, // 7: google.cloud.datacatalog.lineage.v1.LineageEvent.start_time:type_name -> google.protobuf.Timestamp
	39, // 8: google.cloud.datacatalog.lineage.v1.LineageEvent.end_time:type_name -> google.protobuf.Timestamp
	8,  // 9: google.cloud.datacatalog.lineage.v1.EventLink.source:type_name -> google.cloud.datacatalog.lineage.v1.EntityReference
	8,  // 10: google.cloud.datacatalog.lineage.v1.EventLink.target:type_name -> google.cloud.datacatalog.lineage.v1.EntityReference
	1,  // 11: google.cloud.datacatalog.lineage.v1.OperationMetadata.state:type_name -> google.cloud.datacatalog.lineage.v1.OperationMetadata.State
	2,  // 12: google.cloud.datacatalog.lineage.v1.OperationMetadata.operation_type:type_name -> google.cloud.datacatalog.lineage.v1.OperationMetadata.Type
	39, // 13: google.cloud.datacatalog.lineage.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	39, // 14: google.cloud.datacatalog.lineage.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	40, // 15: google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest.open_lineage:type_name -> google.protobuf.Struct
	4,  // 16: google.cloud.datacatalog.lineage.v1.CreateProcessRequest.process:type_name -> google.cloud.datacatalog.lineage.v1.Process
	4,  // 17: google.cloud.datacatalog.lineage.v1.UpdateProcessRequest.process:type_name -> google.cloud.datacatalog.lineage.v1.Process
	41, // 18: google.cloud.datacatalog.lineage.v1.UpdateProcessRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 19: google.cloud.datacatalog.lineage.v1.ListProcessesResponse.processes:type_name -> google.cloud.datacatalog.lineage.v1.Process
	5,  // 20: google.cloud.datacatalog.lineage.v1.CreateRunRequest.run:type_name -> google.cloud.datacatalog.lineage.v1.Run
	5,  // 21: google.cloud.datacatalog.lineage.v1.UpdateRunRequest.run:type_name -> google.cloud.datacatalog.lineage.v1.Run
	41, // 22: google.cloud.datacatalog.lineage.v1.UpdateRunRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 23: google.cloud.datacatalog.lineage.v1.ListRunsResponse.runs:type_name -> google.cloud.datacatalog.lineage.v1.Run
	6,  // 24: google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest.lineage_event:type_name -> google.cloud.datacatalog.lineage.v1.LineageEvent
	6,  // 25: google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse.lineage_events:type_name -> google.cloud.datacatalog.lineage.v1.LineageEvent
	8,  // 26: google.cloud.datacatalog.lineage.v1.SearchLinksRequest.source:type_name -> google.cloud.datacatalog.lineage.v1.EntityReference
	8,  // 27: google.cloud.datacatalog.lineage.v1.SearchLinksRequest.target:type_name -> google.cloud.datacatalog.lineage.v1.EntityReference
	31, // 28: google.cloud.datacatalog.lineage.v1.SearchLinksResponse.links:type_name -> google.cloud.datacatalog.lineage.v1.Link
	8,  // 29: google.cloud.datacatalog.lineage.v1.Link.source:type_name -> google.cloud.datacatalog.lineage.v1.EntityReference
	8,  // 30: google.cloud.datacatalog.lineage.v1.Link.target:type_name -> google.cloud.datacatalog.lineage.v1.EntityReference
	39, // 31: google.cloud.datacatalog.lineage.v1.Link.start_time:type_name -> google.protobuf.Timestamp
	39, // 32: google.cloud.datacatalog.lineage.v1.Link.end_time:type_name -> google.protobuf.Timestamp
	34, // 33: google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse.process_links:type_name -> google.cloud.datacatalog.lineage.v1.ProcessLinks
	35, // 34: google.cloud.datacatalog.lineage.v1.ProcessLinks.links:type_name -> google.cloud.datacatalog.lineage.v1.ProcessLinkInfo
	39, // 35: google.cloud.datacatalog.lineage.v1.ProcessLinkInfo.start_time:type_name -> google.protobuf.Timestamp
	39, // 36: google.cloud.datacatalog.lineage.v1.ProcessLinkInfo.end_time:type_name -> google.protobuf.Timestamp
	3,  // 37: google.cloud.datacatalog.lineage.v1.Origin.source_type:type_name -> google.cloud.datacatalog.lineage.v1.Origin.SourceType
	42, // 38: google.cloud.datacatalog.lineage.v1.Process.AttributesEntry.value:type_name -> google.protobuf.Value
	42, // 39: google.cloud.datacatalog.lineage.v1.Run.AttributesEntry.value:type_name -> google.protobuf.Value
	10, // 40: google.cloud.datacatalog.lineage.v1.Lineage.ProcessOpenLineageRunEvent:input_type -> google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest
	12, // 41: google.cloud.datacatalog.lineage.v1.Lineage.CreateProcess:input_type -> google.cloud.datacatalog.lineage.v1.CreateProcessRequest
	13, // 42: google.cloud.datacatalog.lineage.v1.Lineage.UpdateProcess:input_type -> google.cloud.datacatalog.lineage.v1.UpdateProcessRequest
	14, // 43: google.cloud.datacatalog.lineage.v1.Lineage.GetProcess:input_type -> google.cloud.datacatalog.lineage.v1.GetProcessRequest
	15, // 44: google.cloud.datacatalog.lineage.v1.Lineage.ListProcesses:input_type -> google.cloud.datacatalog.lineage.v1.ListProcessesRequest
	17, // 45: google.cloud.datacatalog.lineage.v1.Lineage.DeleteProcess:input_type -> google.cloud.datacatalog.lineage.v1.DeleteProcessRequest
	18, // 46: google.cloud.datacatalog.lineage.v1.Lineage.CreateRun:input_type -> google.cloud.datacatalog.lineage.v1.CreateRunRequest
	19, // 47: google.cloud.datacatalog.lineage.v1.Lineage.UpdateRun:input_type -> google.cloud.datacatalog.lineage.v1.UpdateRunRequest
	20, // 48: google.cloud.datacatalog.lineage.v1.Lineage.GetRun:input_type -> google.cloud.datacatalog.lineage.v1.GetRunRequest
	21, // 49: google.cloud.datacatalog.lineage.v1.Lineage.ListRuns:input_type -> google.cloud.datacatalog.lineage.v1.ListRunsRequest
	23, // 50: google.cloud.datacatalog.lineage.v1.Lineage.DeleteRun:input_type -> google.cloud.datacatalog.lineage.v1.DeleteRunRequest
	24, // 51: google.cloud.datacatalog.lineage.v1.Lineage.CreateLineageEvent:input_type -> google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest
	25, // 52: google.cloud.datacatalog.lineage.v1.Lineage.GetLineageEvent:input_type -> google.cloud.datacatalog.lineage.v1.GetLineageEventRequest
	26, // 53: google.cloud.datacatalog.lineage.v1.Lineage.ListLineageEvents:input_type -> google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest
	28, // 54: google.cloud.datacatalog.lineage.v1.Lineage.DeleteLineageEvent:input_type -> google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest
	29, // 55: google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks:input_type -> google.cloud.datacatalog.lineage.v1.SearchLinksRequest
	32, // 56: google.cloud.datacatalog.lineage.v1.Lineage.BatchSearchLinkProcesses:input_type -> google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest
	11, // 57: google.cloud.datacatalog.lineage.v1.Lineage.ProcessOpenLineageRunEvent:output_type -> google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse
	4,  // 58: google.cloud.datacatalog.lineage.v1.Lineage.CreateProcess:output_type -> google.cloud.datacatalog.lineage.v1.Process
	4,  // 59: google.cloud.datacatalog.lineage.v1.Lineage.UpdateProcess:output_type -> google.cloud.datacatalog.lineage.v1.Process
	4,  // 60: google.cloud.datacatalog.lineage.v1.Lineage.GetProcess:output_type -> google.cloud.datacatalog.lineage.v1.Process
	16, // 61: google.cloud.datacatalog.lineage.v1.Lineage.ListProcesses:output_type -> google.cloud.datacatalog.lineage.v1.ListProcessesResponse
	43, // 62: google.cloud.datacatalog.lineage.v1.Lineage.DeleteProcess:output_type -> google.longrunning.Operation
	5,  // 63: google.cloud.datacatalog.lineage.v1.Lineage.CreateRun:output_type -> google.cloud.datacatalog.lineage.v1.Run
	5,  // 64: google.cloud.datacatalog.lineage.v1.Lineage.UpdateRun:output_type -> google.cloud.datacatalog.lineage.v1.Run
	5,  // 65: google.cloud.datacatalog.lineage.v1.Lineage.GetRun:output_type -> google.cloud.datacatalog.lineage.v1.Run
	22, // 66: google.cloud.datacatalog.lineage.v1.Lineage.ListRuns:output_type -> google.cloud.datacatalog.lineage.v1.ListRunsResponse
	43, // 67: google.cloud.datacatalog.lineage.v1.Lineage.DeleteRun:output_type -> google.longrunning.Operation
	6,  // 68: google.cloud.datacatalog.lineage.v1.Lineage.CreateLineageEvent:output_type -> google.cloud.datacatalog.lineage.v1.LineageEvent
	6,  // 69: google.cloud.datacatalog.lineage.v1.Lineage.GetLineageEvent:output_type -> google.cloud.datacatalog.lineage.v1.LineageEvent
	27, // 70: google.cloud.datacatalog.lineage.v1.Lineage.ListLineageEvents:output_type -> google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse
	44, // 71: google.cloud.datacatalog.lineage.v1.Lineage.DeleteLineageEvent:output_type -> google.protobuf.Empty
	30, // 72: google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks:output_type -> google.cloud.datacatalog.lineage.v1.SearchLinksResponse
	33, // 73: google.cloud.datacatalog.lineage.v1.Lineage.BatchSearchLinkProcesses:output_type -> google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse
	57, // [57:74] is the sub-list for method output_type
	40, // [40:57] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_lineage_v1_lineage_proto_init() }
func file_google_cloud_datacatalog_lineage_v1_lineage_proto_init() {
	if File_google_cloud_datacatalog_lineage_v1_lineage_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Process); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Run); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LineageEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessOpenLineageRunEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessOpenLineageRunEventResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLineageEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLineageEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLineageEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLineageEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteLineageEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchSearchLinkProcessesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchSearchLinkProcessesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessLinks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessLinkInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Origin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*SearchLinksRequest_Source)(nil),
		(*SearchLinksRequest_Target)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   35,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_datacatalog_lineage_v1_lineage_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_lineage_v1_lineage_proto_depIdxs,
		EnumInfos:         file_google_cloud_datacatalog_lineage_v1_lineage_proto_enumTypes,
		MessageInfos:      file_google_cloud_datacatalog_lineage_v1_lineage_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_lineage_v1_lineage_proto = out.File
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_rawDesc = nil
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_goTypes = nil
	file_google_cloud_datacatalog_lineage_v1_lineage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LineageClient is the client API for Lineage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LineageClient interface {
	// Creates new lineage events together with their parents: process and run.
	// Updates the process and run if they already exist.
	// Mapped from Open Lineage specification:
	// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
	ProcessOpenLineageRunEvent(ctx context.Context, in *ProcessOpenLineageRunEventRequest, opts ...grpc.CallOption) (*ProcessOpenLineageRunEventResponse, error)
	// Creates a new process.
	CreateProcess(ctx context.Context, in *CreateProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// Updates a process.
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// Gets the details of the specified process.
	GetProcess(ctx context.Context, in *GetProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// List processes in the given project and location. List order is descending
	// by insertion time.
	ListProcesses(ctx context.Context, in *ListProcessesRequest, opts ...grpc.CallOption) (*ListProcessesResponse, error)
	// Deletes the process with the specified name.
	DeleteProcess(ctx context.Context, in *DeleteProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new run.
	CreateRun(ctx context.Context, in *CreateRunRequest, opts ...grpc.CallOption) (*Run, error)
	// Updates a run.
	UpdateRun(ctx context.Context, in *UpdateRunRequest, opts ...grpc.CallOption) (*Run, error)
	// Gets the details of the specified run.
	GetRun(ctx context.Context, in *GetRunRequest, opts ...grpc.CallOption) (*Run, error)
	// Lists runs in the given project and location. List order is descending by
	// `start_time`.
	ListRuns(ctx context.Context, in *ListRunsRequest, opts ...grpc.CallOption) (*ListRunsResponse, error)
	// Deletes the run with the specified name.
	DeleteRun(ctx context.Context, in *DeleteRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new lineage event.
	CreateLineageEvent(ctx context.Context, in *CreateLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error)
	// Gets details of a specified lineage event.
	GetLineageEvent(ctx context.Context, in *GetLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error)
	// Lists lineage events in the given project and location. The list order is
	// not defined.
	ListLineageEvents(ctx context.Context, in *ListLineageEventsRequest, opts ...grpc.CallOption) (*ListLineageEventsResponse, error)
	// Deletes the lineage event with the specified name.
	DeleteLineageEvent(ctx context.Context, in *DeleteLineageEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Retrieve a list of links connected to a specific asset.
	// Links represent the data flow between **source** (upstream)
	// and **target** (downstream) assets in transformation pipelines.
	// Links are stored in the same project as the Lineage Events that create
	// them.
	//
	// You can retrieve links in every project where you have the
	// `datalineage.events.get` permission. The project provided in the URL
	// is used for Billing and Quota.
	SearchLinks(ctx context.Context, in *SearchLinksRequest, opts ...grpc.CallOption) (*SearchLinksResponse, error)
	// Retrieve information about LineageProcesses associated with specific
	// links. LineageProcesses are transformation pipelines that result in data
	// flowing from **source** to **target** assets. Links between assets
	// represent this operation.
	//
	// If you have specific link names, you can use this method to
	// verify which LineageProcesses contribute to creating those links.
	// See the
	// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]
	// method for more information on how to retrieve link name.
	//
	// You can retrieve the LineageProcess information in every project where you
	// have the `datalineage.events.get` permission. The project provided in the
	// URL is used for Billing and Quota.
	BatchSearchLinkProcesses(ctx context.Context, in *BatchSearchLinkProcessesRequest, opts ...grpc.CallOption) (*BatchSearchLinkProcessesResponse, error)
}

type lineageClient struct {
	cc grpc.ClientConnInterface
}

func NewLineageClient(cc grpc.ClientConnInterface) LineageClient {
	return &lineageClient{cc}
}

func (c *lineageClient) ProcessOpenLineageRunEvent(ctx context.Context, in *ProcessOpenLineageRunEventRequest, opts ...grpc.CallOption) (*ProcessOpenLineageRunEventResponse, error) {
	out := new(ProcessOpenLineageRunEventResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/ProcessOpenLineageRunEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) CreateProcess(ctx context.Context, in *CreateProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/CreateProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/UpdateProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) GetProcess(ctx context.Context, in *GetProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/GetProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) ListProcesses(ctx context.Context, in *ListProcessesRequest, opts ...grpc.CallOption) (*ListProcessesResponse, error) {
	out := new(ListProcessesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/ListProcesses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) DeleteProcess(ctx context.Context, in *DeleteProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) CreateRun(ctx context.Context, in *CreateRunRequest, opts ...grpc.CallOption) (*Run, error) {
	out := new(Run)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/CreateRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) UpdateRun(ctx context.Context, in *UpdateRunRequest, opts ...grpc.CallOption) (*Run, error) {
	out := new(Run)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/UpdateRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) GetRun(ctx context.Context, in *GetRunRequest, opts ...grpc.CallOption) (*Run, error) {
	out := new(Run)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/GetRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) ListRuns(ctx context.Context, in *ListRunsRequest, opts ...grpc.CallOption) (*ListRunsResponse, error) {
	out := new(ListRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/ListRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) DeleteRun(ctx context.Context, in *DeleteRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) CreateLineageEvent(ctx context.Context, in *CreateLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error) {
	out := new(LineageEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/CreateLineageEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) GetLineageEvent(ctx context.Context, in *GetLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error) {
	out := new(LineageEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/GetLineageEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) ListLineageEvents(ctx context.Context, in *ListLineageEventsRequest, opts ...grpc.CallOption) (*ListLineageEventsResponse, error) {
	out := new(ListLineageEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/ListLineageEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) DeleteLineageEvent(ctx context.Context, in *DeleteLineageEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteLineageEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) SearchLinks(ctx context.Context, in *SearchLinksRequest, opts ...grpc.CallOption) (*SearchLinksResponse, error) {
	out := new(SearchLinksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/SearchLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) BatchSearchLinkProcesses(ctx context.Context, in *BatchSearchLinkProcessesRequest, opts ...grpc.CallOption) (*BatchSearchLinkProcessesResponse, error) {
	out := new(BatchSearchLinkProcessesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.lineage.v1.Lineage/BatchSearchLinkProcesses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LineageServer is the server API for Lineage service.
type LineageServer interface {
	// Creates new lineage events together with their parents: process and run.
	// Updates the process and run if they already exist.
	// Mapped from Open Lineage specification:
	// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
	ProcessOpenLineageRunEvent(context.Context, *ProcessOpenLineageRunEventRequest) (*ProcessOpenLineageRunEventResponse, error)
	// Creates a new process.
	CreateProcess(context.Context, *CreateProcessRequest) (*Process, error)
	// Updates a process.
	UpdateProcess(context.Context, *UpdateProcessRequest) (*Process, error)
	// Gets the details of the specified process.
	GetProcess(context.Context, *GetProcessRequest) (*Process, error)
	// List processes in the given project and location. List order is descending
	// by insertion time.
	ListProcesses(context.Context, *ListProcessesRequest) (*ListProcessesResponse, error)
	// Deletes the process with the specified name.
	DeleteProcess(context.Context, *DeleteProcessRequest) (*longrunningpb.Operation, error)
	// Creates a new run.
	CreateRun(context.Context, *CreateRunRequest) (*Run, error)
	// Updates a run.
	UpdateRun(context.Context, *UpdateRunRequest) (*Run, error)
	// Gets the details of the specified run.
	GetRun(context.Context, *GetRunRequest) (*Run, error)
	// Lists runs in the given project and location. List order is descending by
	// `start_time`.
	ListRuns(context.Context, *ListRunsRequest) (*ListRunsResponse, error)
	// Deletes the run with the specified name.
	DeleteRun(context.Context, *DeleteRunRequest) (*longrunningpb.Operation, error)
	// Creates a new lineage event.
	CreateLineageEvent(context.Context, *CreateLineageEventRequest) (*LineageEvent, error)
	// Gets details of a specified lineage event.
	GetLineageEvent(context.Context, *GetLineageEventRequest) (*LineageEvent, error)
	// Lists lineage events in the given project and location. The list order is
	// not defined.
	ListLineageEvents(context.Context, *ListLineageEventsRequest) (*ListLineageEventsResponse, error)
	// Deletes the lineage event with the specified name.
	DeleteLineageEvent(context.Context, *DeleteLineageEventRequest) (*emptypb.Empty, error)
	// Retrieve a list of links connected to a specific asset.
	// Links represent the data flow between **source** (upstream)
	// and **target** (downstream) assets in transformation pipelines.
	// Links are stored in the same project as the Lineage Events that create
	// them.
	//
	// You can retrieve links in every project where you have the
	// `datalineage.events.get` permission. The project provided in the URL
	// is used for Billing and Quota.
	SearchLinks(context.Context, *SearchLinksRequest) (*SearchLinksResponse, error)
	// Retrieve information about LineageProcesses associated with specific
	// links. LineageProcesses are transformation pipelines that result in data
	// flowing from **source** to **target** assets. Links between assets
	// represent this operation.
	//
	// If you have specific link names, you can use this method to
	// verify which LineageProcesses contribute to creating those links.
	// See the
	// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]
	// method for more information on how to retrieve link name.
	//
	// You can retrieve the LineageProcess information in every project where you
	// have the `datalineage.events.get` permission. The project provided in the
	// URL is used for Billing and Quota.
	BatchSearchLinkProcesses(context.Context, *BatchSearchLinkProcessesRequest) (*BatchSearchLinkProcessesResponse, error)
}

// UnimplementedLineageServer can be embedded to have forward compatible implementations.
type UnimplementedLineageServer struct {
}

func (*UnimplementedLineageServer) ProcessOpenLineageRunEvent(context.Context, *ProcessOpenLineageRunEventRequest) (*ProcessOpenLineageRunEventResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessOpenLineageRunEvent not implemented")
}
func (*UnimplementedLineageServer) CreateProcess(context.Context, *CreateProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProcess not implemented")
}
func (*UnimplementedLineageServer) UpdateProcess(context.Context, *UpdateProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProcess not implemented")
}
func (*UnimplementedLineageServer) GetProcess(context.Context, *GetProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcess not implemented")
}
func (*UnimplementedLineageServer) ListProcesses(context.Context, *ListProcessesRequest) (*ListProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcesses not implemented")
}
func (*UnimplementedLineageServer) DeleteProcess(context.Context, *DeleteProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcess not implemented")
}
func (*UnimplementedLineageServer) CreateRun(context.Context, *CreateRunRequest) (*Run, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRun not implemented")
}
func (*UnimplementedLineageServer) UpdateRun(context.Context, *UpdateRunRequest) (*Run, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRun not implemented")
}
func (*UnimplementedLineageServer) GetRun(context.Context, *GetRunRequest) (*Run, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRun not implemented")
}
func (*UnimplementedLineageServer) ListRuns(context.Context, *ListRunsRequest) (*ListRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuns not implemented")
}
func (*UnimplementedLineageServer) DeleteRun(context.Context, *DeleteRunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRun not implemented")
}
func (*UnimplementedLineageServer) CreateLineageEvent(context.Context, *CreateLineageEventRequest) (*LineageEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLineageEvent not implemented")
}
func (*UnimplementedLineageServer) GetLineageEvent(context.Context, *GetLineageEventRequest) (*LineageEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLineageEvent not implemented")
}
func (*UnimplementedLineageServer) ListLineageEvents(context.Context, *ListLineageEventsRequest) (*ListLineageEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLineageEvents not implemented")
}
func (*UnimplementedLineageServer) DeleteLineageEvent(context.Context, *DeleteLineageEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLineageEvent not implemented")
}
func (*UnimplementedLineageServer) SearchLinks(context.Context, *SearchLinksRequest) (*SearchLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchLinks not implemented")
}
func (*UnimplementedLineageServer) BatchSearchLinkProcesses(context.Context, *BatchSearchLinkProcessesRequest) (*BatchSearchLinkProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSearchLinkProcesses not implemented")
}

func RegisterLineageServer(s *grpc.Server, srv LineageServer) {
	s.RegisterService(&_Lineage_serviceDesc, srv)
}

func _Lineage_ProcessOpenLineageRunEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessOpenLineageRunEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ProcessOpenLineageRunEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/ProcessOpenLineageRunEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ProcessOpenLineageRunEvent(ctx, req.(*ProcessOpenLineageRunEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_CreateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).CreateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/CreateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).CreateProcess(ctx, req.(*CreateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).UpdateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/UpdateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).UpdateProcess(ctx, req.(*UpdateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_GetProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).GetProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/GetProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).GetProcess(ctx, req.(*GetProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_ListProcesses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ListProcesses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/ListProcesses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ListProcesses(ctx, req.(*ListProcessesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_DeleteProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).DeleteProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).DeleteProcess(ctx, req.(*DeleteProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_CreateRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).CreateRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/CreateRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).CreateRun(ctx, req.(*CreateRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_UpdateRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).UpdateRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/UpdateRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).UpdateRun(ctx, req.(*UpdateRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_GetRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).GetRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/GetRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).GetRun(ctx, req.(*GetRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_ListRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ListRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/ListRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ListRuns(ctx, req.(*ListRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_DeleteRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).DeleteRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).DeleteRun(ctx, req.(*DeleteRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_CreateLineageEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLineageEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).CreateLineageEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/CreateLineageEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).CreateLineageEvent(ctx, req.(*CreateLineageEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_GetLineageEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLineageEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).GetLineageEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/GetLineageEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).GetLineageEvent(ctx, req.(*GetLineageEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_ListLineageEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLineageEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ListLineageEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/ListLineageEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ListLineageEvents(ctx, req.(*ListLineageEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_DeleteLineageEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLineageEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).DeleteLineageEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteLineageEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).DeleteLineageEvent(ctx, req.(*DeleteLineageEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_SearchLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).SearchLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/SearchLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).SearchLinks(ctx, req.(*SearchLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_BatchSearchLinkProcesses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchSearchLinkProcessesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).BatchSearchLinkProcesses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.lineage.v1.Lineage/BatchSearchLinkProcesses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).BatchSearchLinkProcesses(ctx, req.(*BatchSearchLinkProcessesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Lineage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.lineage.v1.Lineage",
	HandlerType: (*LineageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessOpenLineageRunEvent",
			Handler:    _Lineage_ProcessOpenLineageRunEvent_Handler,
		},
		{
			MethodName: "CreateProcess",
			Handler:    _Lineage_CreateProcess_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _Lineage_UpdateProcess_Handler,
		},
		{
			MethodName: "GetProcess",
			Handler:    _Lineage_GetProcess_Handler,
		},
		{
			MethodName: "ListProcesses",
			Handler:    _Lineage_ListProcesses_Handler,
		},
		{
			MethodName: "DeleteProcess",
			Handler:    _Lineage_DeleteProcess_Handler,
		},
		{
			MethodName: "CreateRun",
			Handler:    _Lineage_CreateRun_Handler,
		},
		{
			MethodName: "UpdateRun",
			Handler:    _Lineage_UpdateRun_Handler,
		},
		{
			MethodName: "GetRun",
			Handler:    _Lineage_GetRun_Handler,
		},
		{
			MethodName: "ListRuns",
			Handler:    _Lineage_ListRuns_Handler,
		},
		{
			MethodName: "DeleteRun",
			Handler:    _Lineage_DeleteRun_Handler,
		},
		{
			MethodName: "CreateLineageEvent",
			Handler:    _Lineage_CreateLineageEvent_Handler,
		},
		{
			MethodName: "GetLineageEvent",
			Handler:    _Lineage_GetLineageEvent_Handler,
		},
		{
			MethodName: "ListLineageEvents",
			Handler:    _Lineage_ListLineageEvents_Handler,
		},
		{
			MethodName: "DeleteLineageEvent",
			Handler:    _Lineage_DeleteLineageEvent_Handler,
		},
		{
			MethodName: "SearchLinks",
			Handler:    _Lineage_SearchLinks_Handler,
		},
		{
			MethodName: "BatchSearchLinkProcesses",
			Handler:    _Lineage_BatchSearchLinkProcesses_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/lineage/v1/lineage.proto",
}
