/*******************************************************************************
  author       : Bernd Wichern
  filename     : /zpr/bspk/src/hmm/ghmm/tools/smix_hmm.c
  created      : TIME: 17:23:38     DATE: Tue 18. September 2001
  last-modified: TIME: 13:46:48     DATE: Wed 19. September 2001
  $Id: smix_hmm.c 2267 2009-04-24 15:01:58Z grunau $
*******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ghmm/mes.h>
#include <ghmm/rng.h>
#include <ghmm/smodel.h>
#include <ghmm/sequence.h>
#include <ghmm/smixturehmm.h>
#include <ghmm/matrix.h>

#ifdef GHMM_OBSOLETE

#include <ghmm/obsolete.h>

static int smix_hmm_run(int argc, char* argv[]) {
#define CUR_PROC "smix_hmm_run"

  int k, exitcode = -1, smo_number, sqd_fields;
  ghmm_cseq **sqd = NULL;
  ghmm_cmodel **smo = NULL;
  double **cp = NULL;
  FILE *outfile = NULL;

  /* read sequences and initial models */
  sqd = ghmm_cseq_read(argv[1], &sqd_fields);
  if (!sqd) {GHMM_LOG_QUEUED(LCONVERTED); goto STOP;}
  if (sqd_fields > 1)
    printf("Warning: Seq. File contains multiple Seq. Fields; use only the first one\n");
  smo = ghmm_cmodel_read(argv[2], &smo_number);
  if (!smo) {GHMM_LOG_QUEUED(LCONVERTED); goto STOP;}

  /* open output file */
  if(!(outfile = ighmm_mes_fopen(argv[3], "wt"))) {GHMM_LOG_QUEUED(LCONVERTED); goto STOP;}
  
  /* matrix for component probs., */
  cp = ighmm_cmatrix_alloc(sqd[0]->seq_number, smo_number);
  if (!cp) { GHMM_LOG_QUEUED(LCONVERTED); goto STOP;}

  /* set last arg in ghmm_smixturehmm_init() : 
     1 = strict random partition; cp = 0/1
     2. ghmm_smap_bayes from initial models
     3. cp = 1 for best model, cp = 0 for other models 
     4. open
     5. no start partition == equal cp for each model
  */
  if (ghmm_smixturehmm_init(cp, sqd[0], smo, smo_number, 5) == -1) {
    GHMM_LOG_QUEUED(LCONVERTED); goto STOP;
  }
  /* clustering */
  if (ghmm_smixturehmm_cluster(outfile, cp, sqd[0], smo, smo_number) == -1) {
    GHMM_LOG_QUEUED(LCONVERTED); goto STOP;
  }

  /* print trained models */
  for (k = 0; k < smo_number; k++)
    ghmm_cmodel_print(outfile, smo[k]);  

  if (outfile) fclose(outfile);
  exitcode = 0;
 STOP:
  return exitcode;

# undef CUR_PROC
}
#endif /* GHMM_OBSOLETE */


/*============================================================================*/
int main(int argc, char* argv[]) {
#define CUR_PROC "smix_hmm_main"

#ifdef GHMM_OBSOLETE
  int exitcode = -1;

  if (argc != 4 && argc != 5) {
    printf("Insufficient arguments. Usage: \n");
    printf("mix_hmm [Seq.File] [InitModel File] [Out File] <seed>\n");
    goto STOP;
  }
  ghmm_rng_init();
  if (argc == 5)
      GHMM_RNG_SET(RNG,atoi(argv[4]));
    else {      
      ghmm_rng_timeseed(RNG); 
    }
  
  exitcode = smix_hmm_run(argc, argv);
  /*------------------------------------------------------------------------*/
 STOP:
  ighmm_mes(MES_WIN, "\n(%2.2T): Program finished with exitcode %d.\n", exitcode );
  ighmm_mes_exit();
  return(exitcode);

#else  /* GHMM_OBSOLETE */
  fprintf (stderr, "cluster is obsolete. If you need it rebuild the GHMM with \"GHMM_OBSOLETE\"\n");
  return 0;
#endif /* GHMM_OBSOLETE */

# undef CUR_PROC
} /* main */

   
