c Copyright Notice: FEFF8 is copyright protected software and users
c must obtain a license from the University of Washington Office of
c Technology Transfer for its use; see FEFF8 document for details.

c Main Authors of FEFF8: please contact us concerning any problems.
c A. L. Ankudinov, alex@phys.washington.edu      (206) 543 3904
c B. Ravel,        bruce.ravel@nist.gov          (301) 975-5759
c J. J. Rehr,      jjr@phys.washington.edu       (206) 543 8593

c Citations: Please cite at least one of the following articles if 
c FEFF8 is used in published work: 
c    1) Main FEFF8 reference 
c       A.L. Ankudinov, B. Ravel, J.J. Rehr, and S.D. Conradson, 
c       Phys. Rev. B 58, 7565, (1998).
c    2) Multiple scattering theory
c       J.J. Rehr and R.C. Albers, Phys. Rev. B 41, 8139 (1990).
c///////////////////////////////////////////////////////////////////////
c FEFF PROGRAMS (referred below as a System)
c Copyright (c) 1986-2002, University of Washington.
c 
c END-USER LICENSE 
c 
c A signed End-user License Agreement from the University of Washington
c Office of Technology Transfer is required to use these programs and
c subroutines.
c 
c See the URL: http://leonardo.phys.washington.edu/feff/
c 
c USE RESTRICTIONS:
c 
c 1. The End-user agrees that neither the System, nor any of its
c components shall be used as the basis of a commercial product, and
c that the System shall not be rewritten or otherwise adapted to
c circumvent the need for obtaining additional license rights.
c Components of the System subject to other license agreements are
c excluded from this restriction.
c
c 2. Modification of the System is permitted, e.g., to facilitate
c its performance by the End-user. Use of the System or any of its
c components for any purpose other than that specified in this Agreement
c requires prior approval in writing from the University of Washington.
c
c 3. The license granted hereunder and the licensed System may not be
c assigned, sublicensed, or otherwise transferred by the End-user.  
c
c 4. The End-user shall take reasonable precautions to ensure that
c neither the System nor its components are copied, or transferred out
c side of his/her current academic or government affiliated laboratory
c or disclosed to parties other than the End-user.
c 
c 5. In no event shall the End-user install or provide this System
c on any computer system on which the End-user purchases or sells
c computer-related services.
c 
c 6. Nothing in this agreement shall be construed as conferring rights
c to use in advertising, publicity, or otherwise any trademark or the
c names of the System or the UW.   In published accounts of the use or
c application of FEFF the System should be referred to  by this name,
c with an appropriate literature reference:
c 
c FEFF8: A.L. Ankudinov, B. Ravel, J.J. Rehr, and S.D. Conradson,
c        Phys. Rev. B 58, pp. 7565-7576 (1998).
c
c LIMITATION OF LIABILITY:
c
c 1.   THE UW MAKES NO WARRANTIES , EITHER EXPRESSED OR IMPLIED, AS TO
c THE CONDITION OF THE SYSTEM, ITS MERCHANTABILITY, OR ITS FITNESS FOR
c ANY PARTICULAR PURPOSE.  THE END-USER AGREES TO ACCEPT THE SYSTEM
c 'AS IS' AND IT IS UNDERSTOOD THAT THE UW IS NOT OBLIGATED TO PROVIDE
c MAINTENANCE, IMPROVEMENTS, DEBUGGING OR SUPPORT OF ANY KIND.
c
c 2. THE UW SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL,
c INCIDENTAL OR CONSEQUENTIAL DAMAGES SUFFERED BY THE END-USER OR ANY
c OTHER PARTIES FROM THE USE OF THE SYSTEM.
c
c 3.  The End-user agrees to indemnify the UW for liability resulting
c from the use of the System by End-user. The End-user and the UW each
c agree to hold the other harmless for their own negligence.
c
c TITLE:
c
c 1.  Title patent, copyright and trademark rights to the System are
c retained by the UW. The End-user shall take all reasonable precautions
c to preserve these rights.
c 
c 2.  The UW reserves the right to license or grant any other rights to
c the System to other persons or entities.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c
      program feff
      integer iabs, nabs
      logical ceels !KJ added ceels 5-06

      call rdinp(nabs,ceels)
      call ffmod1
      call ffmod2
      do 900 iabs = 1, nabs
        if (nabs.gt.1) call ffsort (iabs,ceels) !KJ 5-6 added second argument
        call ffmod4
        call ffmod5
        call ffmod6(iabs)
        call ffmod9
 900  continue
      stop
      end
c///////////////////////////////////////////////////////////////////////
c Distribution:  RDINP 1.0
c Copyright (c) [2002] University of Washington
c 
c This software was prepared in part with US Government Funding under
c DOE contract DE-FG03-97ER45623.

c Redistribution and use of this Distribution in source and binary
c formats, with or without modification is permitted, provided the 
c following conditions are met:
c 
c Redistributions must retain the above notices and the following list
c of conditions and disclaimer;
c 
c Modified formats carry the marking
c     "Based on or developed using Distribution: RDINP 1.0
c      RDINP 1.0 Copyright (c) [2002] University of Washington"
c 
c Recipient acknowledges the right of the University of Washington to
c prepare uses of this Distribution and its modifications that may be
c substantially similar or functionally equivalent to
c Recipient-prepared modifications.
c
c Recipient and anyone obtaining access to the Distribution through
c recipient's actions accept all risk associated with possession and
c use of the Distribution.
c
c THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
c WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
c MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
c IN NO EVENT SHALL THE UNIVERSITY OF WASHINGTON OR CONTRIBUTORS TO THE
c DISTRIBUTION BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
c EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
c PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
c REVENUE; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
c LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
c NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
c SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c
c     sub-program exchange point
!     program rdinp 
      subroutine rdinp (nabs,ceels)

c    reads 'feff.inp' file and writes several files in special format
c    ready for the use by other modules: geom.dat, global.dat,
c    mod1.inp, mod2.inp, mod3.inp mod4.inp mod5.inp mod6.inp ldos.inp .
c    The subroutine output 'nabs' is needed for configurational average
c    The rest of output, passed to wrtall via common blocks (allinp.h)

c     coded s. zabinski 1994
c     last modified by a.l.ankudinov march 2001  for new i/o structure

      implicit double precision (a-h, o-z)
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../RDINP/allinp.h
c     Common blocks with all input data
c     the common
cc    atoms.dat
      integer  natt
      integer iphatx(nattx)
      double precision  ratx(3,nattx)
      common /geom/ ratx, iphatx, natt
cc    geom.dat
c       integer  nat
c       integer iatph(0:nphx)
c       integer iphat(natx)
c       double precision  rat(3,natx)
c       common /geom/ ratx, iphatx, natt
cc    global.inp
c       configuration average
      integer iphabs
c     global polarization data
      integer  ipol, ispin, le2
      double precision evec(3), xivec(3), spvec(3), elpty,angks,rclabs
      complex*16 ptz(-1:1, -1:1)
      common /global/ ptz, evec, xivec, spvec, elpty, angks, rclabs, 
     1     ipol, ispin, le2, iphabs
c     c    mod1.inp
      character*80 title(nheadx)
c     integer mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec,
      integer mpot, nph, ntitle, ihole, ipr1, iafolp, iunf,
     1     nmix, nohole, jumprm, inters, nscmt, icoul, lfms1
      integer iz(0:nphx)
      integer lmaxsc(0:nphx)
      real rfms1
      double precision gamach, rgrd, ca1, ecv, totvol
      double precision  xnatph(0:nphx), folp(0:nphx), spinph(0:nphx)
      double precision  xion(0:nphx)
c     for OVERLAP option
      integer novr(0:nphx), iphovr(novrx,0:nphx), nnovr(novrx,0:nphx)
      double precision  rovr(novrx,0:nphx)
      common /mod1/ title, xion, xnatph, spinph, folp, gamach, rgrd,
     1     ca1, ecv, totvol, rovr, rfms1, iz, lmaxsc, mpot, nph, ntitle,
     2     ihole, ipr1, iafolp, nmix,nohole,jumprm, inters,
     3     nscmt, icoul, lfms1, novr, iphovr, nnovr, iunf
c     c    ldos.inp
      integer mldos, lfms2
      double precision emin, emax, eimag, rfms2
      common /mod7/ emin, emax, eimag, rfms2, mldos, lfms2
cc    mod2.inp
c     integer mphase, ipr2, ixc, ixc0, vr0, vi0, ispec, lreal, lfms2
      integer mphase, ipr2, ixc, ixc0, ispec, lreal, l2lp, iPlsmn
      integer lmaxph(0:nphx), iGrid
      character*6  potlbl(0:nphx)
c     double precision rgrd, rfms2, gamach, xkstep, xkmax, vixan
      double precision xkstep, xkmax, vixan, vr0, vi0
      common /mod2/ xkstep, xkmax, vixan, vr0, vi0, 
     &     lmaxph, mphase, ipr2, ixc, ixc0, ispec, lreal, l2lp,
     &     izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis, iPlsmn,
     &     iGrid, potlbl
c     c    mod3.inp
      integer mfms, idwopt, minv
c     integer lmaxph(0:nphx)
c     real rfms2, rprec, rdirec, toler1, toler2
      real rprec, rdirec, toler1, toler2
      double precision   tk, thetad, sig2g
      common /mod3/ tk, thetad, sig2g, rprec, rdirec, toler1,
     1       toler2,  mfms, idwopt, minv
c     c    mod4.inp
      integer  mpath, ms, nncrit, nlegxx, ipr4
c     real critpw, pcritk, pcrith,  rmax, rfms2
      real critpw, pcritk, pcrith,  rmax
      common /mod4/ critpw, pcritk, pcrith,  rmax,
     1       mpath, ms, nncrit, nlegxx, ipr4
c     c    mod5.inp
      integer  mfeff, ipr5, iorder
      logical  wnstar
      double precision critcw
      common /mod5/ critcw, mfeff, ipr5, iorder, wnstar
c     c    mod6.inp
c     integer  mchi, ispec, idwopt, ipr6, mbconv
c     double precision  vrcorr, vicorr, s02, alphat, sig2g
      integer  mchi, ipr6, mbconv, absolu !KJ added absolu 3-06
      double precision  vrcorr, vicorr, s02, alphat, thetae
      common /mod6/ vrcorr, vicorr, s02, alphat, thetae, 
     &     mchi, ipr6, mbconv, absolu   !KJ added absolu 3-06
c     c    so2.inp  
      integer  mso2conv, ipse, ipsk
      double precision wsigk, cen
      character(12) cfname
      common /so2/ wsigk, cen, cfname, mso2conv, ipse, ipsk
      
c     c    eels.inp
c     EELS variables  !KJ 1-06 this section added for ELNES, EXELFS, MAGIC cards
      real*8 ebeam, aconv, acoll, thetax, thetay, emagic
      integer eels, relat, aver, cross, iinput,spcol
      integer nqr,nqf,magic
      integer ipmin,ipmax,ipstep
      common /eelsva/ ebeam,aconv,acoll,thetax,thetay,emagic,magic,
     &     nqr, nqf, aver, cross, relat, iinput, spcol,ipmin, ipmax,
     &     ipstep, eels
c     !KJ end
	
c= ../RDINP/allinp.h}
c={../HEADERS/vers.h
      character*12 vfeff
c                       123456789012  
      parameter (vfeff='Feff 8.50')
c= ../HEADERS/vers.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}

c     Single scattering path to go with Overlap information
      parameter (nssx = 16)
      dimension indss(nssx), iphss(nssx)
      dimension degss(nssx), rss(nssx)

c     Local stuff
      character*150  line
      dimension ltit(nheadx)
      parameter (nwordx = 20)
      character*20 words(nwordx)
      integer iatph(0:nphx)
      integer icnt  !KJ 1-06 this is just a local index that doesn't need to be saved

      parameter (nbr=30)
      logical nogeom
      parameter (big = 1.0e5)
      character*512 slog
      character*12 tmpstr
      logical ceels  !KJ for monolithic version 5-6

      external dist

   10 format (a)
   20 format (bn, i15)
   30 format (bn, f15.0)

      call par_begin
      if (worker) go to 400

c     open the log file, unit 11.  See subroutine wlog.
      open (unit=11, file='log.dat', status='unknown', iostat=ios)
      call chopen (ios, 'log.dat', 'feff')

      tmpstr = vfeff
      call triml (tmpstr)
      call wlog(' ' // tmpstr)

c     initialize all things to be passed
      nabs = 1
      call iniall

c     initialize local staff 
      iatom = 0
      ifolp = 0
      iovrlp = 0
      iphabs = 0
      lxnat = 0
      folpx = 1.15d0
      nogeom = .false.
      rclabs = big
      rmult = 1.0d0
      s02h = 1.0d0
      natt = 0
      nss = 0
      do 90  iss = 1, nssx
         indss(iss) = 0
         iphss(iss) = 0
         degss(iss) = 0
         rss(iss) = 0
  90  continue
      do 95 iph = 0, nphx
  95  iatph(iph) = 0

c     tokens  0 if not a token
c             1 if ATOM (ATOMS)
c             2 if HOLE
c             3 if OVER (OVERLAP)
c             4 if CONT (CONTROL)
c             5 if EXCH (EXCHANGE)
c             6 if ION
c             7 if TITL (TITLE)
c             8 if FOLP
c             9 if RPATH or RMAX
c            10 if DEBY (DEBYE)
c            11 if RMUL (RMULTIPLIER)
c            12 if SS
c            13 if PRIN (PRINT)
c            14 if POTE (POTENTIALS)
c            15 if NLEG
c            16 if CRIT (CRITERIA)
c            17 if NOGEOM
c            18 if IORDER
c            19 if PCRI (PCRITERIA)
c            20 if SIG2
c            21 if XANE (XANES)
c            22 if CORR (CORRECTIONS)
c            23 if AFOL (AFOLP)
c            24 if EXAF (EXAFS)
c            25 if POLA (POLARIZATION)
c            26 if ELLI (ELLIPTICITY) 
c            27 if RGRI (RGRID)
c            28 if RPHA (RPHASES), real phase shifts
c            29 if NSTA (NSTAR), n* for co-linear polarization
c            30 if NOHO (NOHOLE), use no hole for potentials
c            31 if SIG3 third and first cumulants for ss paths
c            32 if JUMP (JUMPRM), remove jumps of potential   
c            33 if MBCO (MBCONV), do convolution with exitation spectrum
c            34 if SPIN do calculation for spin-up(down) photoelectron  
c            35 if EDGE to specify edge by name
c            36 if SCF  do self-consistency loop
c            37 if FMS  use FMS for cluster of the size rfms
c            38 if LDOS print out l-dos for specified energy range
c            39 if INTE how to find interstitial parameters
c            40 if CFAV to do configuration average
c            41 if S02  to specify S_0^2
c            45 if RSIG (RSIGMA), real self-energy 
c            46 if XNCD natural dichroism
c            47 if MULT for quadrupolar etc. transitions
c            48 if UNFR unfreeze f-electrons
c            49 if TDLDA use TDLDA background
c            50 if PMBSE use BSE for background
c            51 if PLASMON       - Added by Josh Kas
c                                - PLASMON
c                                - With this card set, ffmod2 will read exc.dat and
c                                - use a multiple pole self energy
c            52 if S02C (S02CONV) compute S_0^2 from response function
c            53 if SELF print on shell self energy as a function of E.
c            54 if SFSE print off shell self energy and spectral function.
c            55 if RCONV print running convolution with spectral function.
c            56 if ELNE calculate ELNES  !KJ 1-06
c            57 if EXEL calculate EXELFS !KJ 1-06
c            58 if MAGI plot magic angle !KJ 1-06
c            59 if ABSO don't normalize spectrum !KJ 3-06
c            60 if EGRID (Gives user control of grid through grid.inp)
c            -1 if END  (end)
c     mode flag  0 ready to read a keyword card
c                1 reading atom positions
c                2 reading overlap instructions for unique pot
c                3 reading unique potential definitions
c                4 reading EELS input  !KJ

c#mn{
c  replaced read of feff.inp with  call to rdline, which will:
c    1. read from feff.inp if found, otherwise will stop and complain
c       (support for reading from standard input would be easy to add)
c    2. handles line processing tasks like 
c         = ignoring comment lines and blank lines
c         = tab removal
c    3. allows 'include' files in input file
c    4. for initial call, set jinit = -1, line = input_file_name
c
      mode  = 0
      jinit = -1
      line  = 'feff.inp'
  200 continue 
         call rdline(jinit,line)
         if (line .eq. 'read_line_end')    line='END'
         if (line .eq. 'read_line_error')  line='END'
c#mn}

         nwords = nwordx
         call bwords (line, nwords, words)
         itok = itoken (words(1),'feff.inp')

c        process the card using current mode
  210    continue

         if (mode .eq. 0)  then
            if (itok .eq. 1)  then
c              ATOM
c              Following lines are atom postions, one per line
               mode = 1
               iatom  = iatom  +1
            elseif (itok .eq. 2)  then
c              HOLE     1  1.0
c                   holecode s02
               read(words(2),20,err=900)  ihole
               if (nwords.gt.2) read(words(3),30,err=900)  s02h
               mode = 0
            elseif (itok .eq. 3)  then
c              OVERLAP iph
c                  iph  n  r
               read(words(2),20,err=900)  iph
               call phstop(iph,line)
               call warnex(' OVERLAP:')
               mode = 2
               iovrlp = iovrlp +1
            elseif (itok .eq. 4)  then
c              CONTROL  mphase, mpath, mfeff, mchi
c               0 - do not run modules, 1 - run module
               if (nwords.eq.5) then
c                 feff7 input file
                  read(words(2),20,err=900)  mpot
                  mphase = mpot
                  mfms = mpot
                  read(words(3),20,err=900)  mpath
                  read(words(4),20,err=900)  mfeff
                  read(words(5),20,err=900)  mchi
               else
c                 feff8 input file
                  read(words(2),20,err=900)  mpot
                  read(words(3),20,err=900)  mphase
                  read(words(4),20,err=900)  mfms
                  read(words(5),20,err=900)  mpath
                  read(words(6),20,err=900)  mfeff
                  read(words(7),20,err=900)  mchi
               endif
               mode = 0
            elseif (itok .eq. 5)  then
c              EXCHANGE  ixc  vr0  vi0 (ixc0)
c              ixc=0  Hedin-Lunqvist + const real & imag part
c              ixc=1  Dirac-Hara + const real & imag part
c              ixc=2  ground state + const real & imag part
c              ixc=3  Dirac-Hara + HL imag part + const real & imag part
c              ixc=5  partially nonlocal: Dirac-Fock for core + HL for
c                     valence electrons, + const real & imag part
c              ixc=10 same as ixc=0 with broadened plasmon HL selfenergy
c              ixc=13 same as ixc=3 with broadened plasmon HL selfenergy
c              ixc=15 same as ixc=5 with broadened plasmon HL selfenergy
c              vr0 is const imag part of potential
c              vi0 is const imag part of potential
c              Default is HL. (ixc=0, vr0=0, vi0=0, ixc0 = 2)
               vr0=0.0
               vi0=0.0
               read(words(2),20,err=900)  ixc
!              if (nwords.ge.3) (read(words(3),30,err=900)  vr0
                read(words(3),30,err=900)  vr0
!              if (nwords.ge.4) read(words(4),30,err=900)  vi0
                read(words(4),30,err=900)  vi0
               if (nwords .gt. 4) read(words(5),20,err=900)  ixc0
               if (ixc .ge. 3)  call warnex(' EXCHANGE >= 3:')
               mode = 0
            elseif (itok .eq. 6)  then
c              ION  iph xion(iph)
               read(words(2),20,err=900)  iph
               call phstop(iph,line)
               read(words(3),30,err=900)  xion(iph)
               call warnex(' ION:')
               mode = 0
            elseif (itok .eq. 7)  then
c              TITLE title...
               ntitle = ntitle + 1
               if (ntitle .le. nheadx)  then
                  title(ntitle) = line(6:)
                  call triml (title(ntitle))
               else
                  call wlog(' Too many title lines, title ignored')
                  call wlog(' ' // line(1:71))
               endif
               mode = 0
            elseif (itok .eq. 8)  then
c              FOLP iph folp (overlap factor, default 1)
               ifolp = 1
               read(words(2),20,err=900)  iph
               call phstop(iph,line)
               read(words(3),30,err=900)  folp(iph)
               call warnex(' FOLP:')
               mode = 0
            elseif (itok .eq. 9)  then
c              RPATH rmax (max r for ss and pathfinder)
               read(words(2),30,err=900)  rmax
            elseif (itok .eq. 10)  then
c              DEBYE  temp debye-temp ( idwopt )
c                   temps in kelvin
c                   idwopt = 0 use CD model
c                   idwopt = 1 use EM method
c                   idwopt = 2 use RM method
c                   idwopt = -1,-2,... don't calculate DW factors
c                   These add to any sig2 from SIG2 card or files.dat
               read(words(2),30,err=900)  tk
               read(words(3),30,err=900)  thetad
               idwopt=0 
               if (nwords.gt.3) then
                 read(words(4),20,err=900)  idwopt
                 if (idwopt.gt.2) then
                    write(slog,'(a,i5,2x,a)')
     1                 ' Option idwopt=',idwopt,'is not available.'
                    call wlog(slog)
                    write(slog,'(a)')
     1                   '...setting idwopt=2 to use RM.' 
                    call wlog(slog)
                 endif
               endif
               mode = 0
            elseif (itok .eq. 11)  then
c              RMULTIPLIER  rmult
c              Multiples atom coord, rss, overlap and rmax distances by
c              rmult (default 1).  DOES NOT modify sig2g
               read(words(2),30,err=900)  rmult
               mode = 0
            elseif (itok .eq. 12)  then
c              SS index ipot deg rss
               nss = nss + 1
               if (nss .gt. nssx)  then
                  write(slog,'(a,i8)')
     1               ' Too many ss paths requested, max is ', nssx
                  call wlog(slog)
                  call par_stop('RDINP')
               endif
               read(words(2),20,err=900)  indss(nss)
               read(words(3),20,err=900)  iphss(nss)
               read(words(4),30,err=900)  degss(nss)
               read(words(5),30,err=900)  rss(nss)
               mode = 0
            elseif (itok .eq. 13)  then
c              PRINT  ipr1  ipr2  ipr3  ipr4 ipr5 ipr6
c              print flags for various modules
c              ipr1 potph  0 pot.bin only
c                          1 add misc.dat
c                          2 add pot.dat
c                          5 add atom.dat
c                          6 add central atom dirac stuff
c                          7 stop after doing central atom dirac stuff
c              ipr2 xsph   0 phase.bin only
c                          2 add  phase.dat
c                          3 add  emesh.dat
c              ipr3 fmstot  currently is dummy
c              ipr4 pathfinder  0 paths.dat only
c                               1 add crit.dat
c                               2 keep geom.dat
c                               3 add fbeta files
c                               5 special magic code, crit&geom only
c                                 not paths.dat.  Use for path studies
c              ipr5 genfmt 0 files.dat, feff.dats that pass 2/3 of
c                            curved wave importance ratio
c                          1 keep all feff.dats
c              ipr6 ff2chi 0 chi.dat
c                          1 add sig2.dat with debye waller factors
c                          2 add chipnnnn.dat for each path
c                          3 add feffnnnn.dat for each path, and
c                            do not add chipnnnn.dat for each path
c                          4 add both feffnnnn.dat and chipnnnn.dat
c                            for each path
               if (nwords.eq.5) then
c                 feff7 input file
                  read(words(2),20,err=900)  ipr1
                  ipr2 = ipr1
                  ipr3 = ipr1
                  read(words(3),20,err=900)  ipr4
                  read(words(4),20,err=900)  ipr5
                  read(words(5),20,err=900)  ipr6
               else
c                 feff8 input file
                  read(words(2),20,err=900)  ipr1
                  read(words(3),20,err=900)  ipr2
                  read(words(4),20,err=900)  ipr3
                  read(words(5),20,err=900)  ipr4
                  read(words(6),20,err=900)  ipr5
                  read(words(7),20,err=900)  ipr6
               endif
               mode = 0
            elseif (itok .eq. 14)  then
c              POTENTIALS
c              Following lines are unique potential defs, 1 per line
               mode = 3
            elseif (itok .eq. 15)  then
c              NLEG nlegmax (for pathfinder)
               read(words(2),20,err=900)  nlegxx
               mode = 0
            elseif (itok .eq. 16)  then
c              CRIT critcw critpw
               read(words(2),30,err=900)  critcw
               read(words(3),30,err=900)  critpw
               mode = 0
            elseif (itok .eq. 17)  then
c              NOGEOM (do not write geom.dat) (disabled)
               nogeom = .true.
               mode = 0
            elseif (itok .eq. 18)  then
c              IORDER  iorder (used in genfmt, see setlam for meaning)
               read(words(2),20,err=900)  iorder
               call warnex(' IORDER:')
               mode = 0
            elseif (itok .eq. 19)  then
c              PCRIT  pcritk pcrith
c                     (keep and heap criteria for pathfinder)
               read(words(2),30,err=900)  pcritk
               read(words(3),30,err=900)  pcrith
               mode = 0
            elseif (itok .eq. 20)  then
c              SIG2  sig2g   global sig2 used by ff2chi, summed with
c              correlated debye model if DEBYE card used, and with
c              sig2 from files.dat if non-zero.
c              Units are Ang**2
               read(words(2),30,err=900)  sig2g
               mode = 0
            elseif (itok .eq. 21)  then
c              XANES ( xkmax  xkstep vixan)
               slog='XANES is not available in this version of feff8.5'
               call wlog(slog)
               call wlog("Ignoring XANES")
            elseif (itok .eq. 22)  then
c              CORRECTIONS  e0-shift, lambda correction
c              e0 shift is in eV, edge will be edge-e0
c              lambda corr is a const imag energy in eV
c              e0 and lambda corr same as vr0 and vi0 in EXCH card
               read(words(2),30,err=900)  vrcorr
               read(words(3),30,err=900)  vicorr
               mode = 0
            elseif (itok .eq. 23)  then
c              AFOLP use generalized automatic folp
               folpx = 1.15
               if (nwords.ge.2) read(words(2),30,err=900)  folpx
               mode =0
            elseif (itok .eq. 24)  then
c              EXAFS  xkmax for energy grid
               read(words(2),30,err=900)  xkmax
               mode = 0
            elseif (itok .eq. 25)  then
c              POLARIZATION  X Y Z
               ipol = 1
c              run linear polarization code 
               read(words(2),30,err=900)  evec(1)
               read(words(3),30,err=900)  evec(2)
               read(words(4),30,err=900)  evec(3)
               mode = 0
            elseif (itok .eq. 26)  then
c              ELLIPTICITY  E incident direction
               read(words(2),30,err=900)  elpty
               read(words(3),30,err=900)  xivec(1)
               read(words(4),30,err=900)  xivec(2)
               read(words(5),30,err=900)  xivec(3)
               mode = 0
            elseif (itok .eq. 27)  then
c              RGRID  rgrd
c              rgrd will be dpas, default is 0.03 in feff7
               read(words(2),30,err=900)  rgrd
               call warnex(' RGRID:')
               write(slog,'(a,1pe13.5)') ' RGRID, rgrd; ', rgrd
               call wlog(slog)
               i = 1 + int (12.5d0 / rgrd)
               if (mod(i,2) .eq. 0) i = i + 1
               if (i.gt.nrptx) then
                 write(slog,'(a,i6)') 
     1           ' FATAL error in RGRID: increase in dim.h nrptx to', i
                 call wlog(slog)
                 call par_stop(' ')
               endif
               mode = 0
            elseif (itok .eq. 28)  then
c              RPHASES (real phase shifts only)
               call warnex(' RPHASES:')
               call wlog(' Real phase shifts only will be used.  ' //
     1                   'FEFF results will be unreliable.')
               lreal = 2
               mode = 0
            elseif (itok .eq. 29)  then
c              NSTAR, write out n* for colinear polarization
               wnstar = .true.
               mode = 0
            elseif (itok .eq. 30)  then
c              NOHOLE
               if (nohole.lt.0) then
                  nohole = 0
                  if (nwords.ge.2) read(words(2),20,err=900)  nohole
                  call warnex(' NOHOLE:')
               end if
            elseif (itok .eq. 31)  then
c              SIG3 alphat  thetae   first and third cumulants for ss paths
               read(words(2),30,err=900)  alphat
               if (nwords.ge.3) read(words(3),20,err=900)  thetae
               call warnex(' SIG3:')
               write(slog,'(a,1pe13.5)') ' SIG3, alphat ; ', alphat
               call wlog(slog)
               mode = 0
            elseif (itok .eq. 32)  then
c              JUMPRM remove potential jumps at muffin tin radii
               jumprm = 1
            elseif (itok .eq. 33)  then
c              MBCONV do many body convolution with excitation spectrum
               mbconv = 1
            elseif (itok .eq. 34)  then
c              SPIN  specifies spin direction on central atom 
               read(words(2),20,err=900)  ispin 
c              set default spin along z axis
               if (ispin.ne.0) spvec(3) = 1.d0
               if (nwords.gt.2) read(words(3),30,err=900)  spvec(1)
               if (nwords.gt.3) read(words(4),30,err=900)  spvec(2)
               if (nwords.gt.4) read(words(5),30,err=900)  spvec(3)
            elseif (itok .eq. 35)  then
c              EDGE     L3 
c                   holecode
               call setedg (words(2), ihole)
               mode = 0
            elseif (itok .eq. 36)  then
c              SCF    rfms [ lfms nscmt  ca1 nmix  ecv icoul]
c              number of cycles, mode of calculating coulomb potential,
c              convergence accelerator
               nscmt = nbr
               ca1 = 0.2d0
               read(words(2),30,err=900)  rfms1
               if (nwords.gt.2) read(words(3),20,err=900)  lfms1
               if (nwords.gt.3) read(words(4),20,err=900)  nscmt
               if (nwords.gt.4) read(words(5),30,err=900)  ca1
               if (nwords.gt.5) read(words(6),20,err=900)  nmix
               if (nwords.gt.6) read(words(7),30,err=900)  ecv
               if (nwords.gt.7) read(words(8),20,err=900)  icoul
               if (nscmt.le.0 .or. nscmt.gt.nbr) nscmt = nbr
               if (lfms1.gt.0) lfms1 = 1
c              sanity checks for ca1
               if (ca1.lt.0) ca1 =0
               if (ca1.gt.0.5) then
                 call wlog(' Reduce convergence factors in SCF ')
                 call par_stop
     .            (' Cannot run with specified ca1 in SCF card.')
               endif
               if (ecv.ge.0) ecv = -40.0
               if (nmix.le.0) nmix=1
               if (nmix.gt.30) nmix=30
            elseif (itok .eq. 37)  then
c              FMS   rfms2  (lfms2 minv toler1 toler2 rdirec)
c              radius of the cluster to do FMS
               slog="FMS is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring FMS")
            elseif (itok .eq. 38)  then
               slog="LDOS is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring LDOS")
            elseif (itok .eq. 39)  then
c              INTERSTITIAL  inters  totvol
c              inters = 1 local V_int (around central atom)
c              inters = 0 extended V_int (average over all atoms)
c              more obscure options described in manual
               read(words(2),20,err=900)  inters
               if (nwords.ge.3) read(words(3),30,err=900)  totvol
            elseif (itok .eq. 40) then
c              CFAV  iphabs nabs rclabs
               read(words(2),20,err=900)  iphabs
               read(words(3),20,err=900)  nabs
               read(words(4),30,err=900)  rclabs
               if (rclabs.lt.0.5) rclabs=big
               mode = 0
            elseif (itok .eq. 41) then
c              S02  s02
               read(words(2),30,err=900)  s02
               mode = 0
            elseif (itok .eq. 42)  then
               slog="XES is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring XES")
            elseif (itok .eq. 43)  then
               slog="DANES is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring DANES")
c              DANES ( xkmax  xkstep vixan)
            elseif (itok .eq. 44)  then
c              FPRIME  emin emax estep
               slog="FPRIME is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring FPRIME")
            elseif (itok .eq. 45)  then
c              RSIGMA  (real self energy only)
               call warnex(' RSIGMA :')
               call wlog(' Real self energy only will be used.  ' //
     1                   'FEFF results will be unreliable.')
               if (lreal.lt.1) lreal = 1
               mode = 0
            elseif (itok .eq. 46)  then
c              XNCD or XMCD
               slog="XMCD is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring XMCD")
            elseif (itok .eq. 47)  then
c              MULTIPOLES le2 (l2lp)
               read(words(2),20,err=900)  le2
               if (nwords.gt.2) read(words(3),20,err=900)  l2lp
               mode = 0
            elseif (itok .eq. 48)  then
c              UNFREEZEF   
               iunf = 1
               mode = 0
            elseif (itok .eq. 49)  then
c              TDLDA 
               slog="TDLDA is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring TDLDA")
            elseif (itok .eq. 50)  then
c              PMBSE 
               slog="PMBSE is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring PMBSE")
            elseif (itok .eq. 51)  then ! Added by Josh Kas
c              PLASMON
               if(nwords.gt.1) then
                  read(words(2),20,err=900) iPlsmn
               else
                  iPlsmn = 1
               end if
            elseif (itok .eq. 52)  then ! Added by Josh Kas
c              S02CONV
               mso2conv = 1
            elseif (itok .eq. 53)  then ! Added by Josh Kas
c              SELF (print out on shell self energy Sig(k(E),E) )
               ipse = 1
            elseif (itok .eq. 54)  then ! Added by Josh Kas
c              SFSE k0 (print out self energy Sig(k0,E) ) 
               ipsk = 1
               read(words(2),30,err=900)  wsigk
            elseif (itok .eq. 55) then ! Added by Josh Kas
c              RCONV (print running convolution with file cfname at energy cen)
c              RCONV cen cname
               read(words(2),30,err=900) cen
               cfname = words(3)(1:12)
            elseif (itok.eq.56) then  !KJ added this card 1-06
c               ELNES
               slog="ELNES is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring ELNES")
            elseif (itok.eq.57) then  !KJ added this card 1-06
c               EXELFS
               slog="EXELFS is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring EXELFS")
            elseif (itok .eq. 58) then !KJ added this card 1-06
c               MAGIC card
               slog="MAGIC is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring MAGIC")
            elseif (itok .eq. 59) then !KJ added this card 3-06
c               ABSOLUTE card
               slog="ABSOLUTE is not available in this" // 
     &                  "version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring ABSOLUTE")
            elseif ( itok .eq. 60) then
c               EGRID card
               slog="EGRID is not available in this version of FEFF8.5"
               call wlog(slog)
               call wlog("Ignoring EGRID")
            elseif (itok .eq. -1)  then
c              END
               goto 220
            else
               write(slog,'(1x,a)') line(1:70)
               call wlog(slog)
               write(slog,'(1x,a)') words(1)
               call wlog(slog)
               write(slog,'(a,i8)') ' Token ', itok
               call wlog(slog)
               call wlog(' Keyword unrecognized.')
               call wlog(' See FEFF document -- some old features')
               call wlog(' are no longer available.')
               call par_stop('RDINP-2')
            endif
         elseif (mode .eq. 1)  then
            if (itok .ne. 0)  then
c              We're done reading atoms.
c              Change mode and process current card.
               mode = 0
               goto 210
            endif
            natt = natt+1
            if (natt.gt. nattx)  then
               write(slog,'(a,i8)') 'Too many atoms, max is ', nattx
               call wlog(slog)
               call par_stop('RDINP-3')
            endif
            read(words(1),30,err=900)  ratx(1,natt)
            read(words(2),30,err=900)  ratx(2,natt)
            read(words(3),30,err=900)  ratx(3,natt)
            read(words(4),20,err=900)  iphatx(natt)
            if (iatph(iphatx(natt)) .le. 0) iatph(iphatx(natt)) = natt
         elseif (mode .eq. 2)  then
            if (itok .ne. 0)  then
c              We're done reading these overlap instructions.
c              Change mode and process current card.
               mode = 0
               goto 210
            endif
            novr(iph) = novr(iph)+1
            iovr = novr(iph)
            if (iovr .gt. novrx)  then
               write(slog,'(a,i8)') 'Too many overlap shells, max is ',
     1                               novrx
               call wlog(slog)
               call par_stop('RDINP-5')
            endif
            read(words(1),20,err=900) iphovr(iovr,iph)
            read(words(2),20,err=900) nnovr(iovr,iph)
            read(words(3),30,err=900) rovr(iovr,iph)
         elseif (mode .eq. 3)  then
            if (itok .ne. 0)  then
c              We're done reading unique potential definitions
c              Change mode and process current card.
               mode = 0
               goto 210
            endif
            read(words(1),20,err=900)  iph
            if (iph .lt. 0  .or.  iph .gt. nphx)  then
               write(slog,'(a,i8)') 
     1             'Unique potentials must be between 0 and ',
     1             nphx
               call wlog(slog)
               write(slog,'(i8,a)') iph, ' not allowed'
               call wlog(slog)
               write(slog,'(1x,a)') line(1:71)
               call wlog(slog)
               call par_stop('RDINP')
            endif
            read(words(2),20,err=900)  iz(iph)
            if (iz(iph).lt. 6) then
               lmaxsc(iph) = 1
            elseif (iz(iph).lt.55) then
               lmaxsc(iph) = 2
            else
               lmaxsc(iph) = 3
            endif
c           No potential label if user didn't give us one
c           Default set above is potlbl=' '
            if (nwords .ge. 3)  potlbl(iph) = words(3)
            if (nwords .ge. 4)  then
              read(words(4),20,err=900) ltmp
              if (ltmp.ge.1 .and. ltmp.le.lx) lmaxsc(iph) = ltmp
            endif
            lmaxph(iph) = 3
            if (iz(iph).lt.6) lmaxph(iph) = 2
            if (nwords .ge. 5)  then
              read(words(5),20,err=900) ltmp
              if (ltmp.ge.1 .and. ltmp.le.lx) lmaxph(iph) = ltmp
            endif
            if (nwords .ge. 6) then
              read(words(6),30,err=900) xnatph(iph)
              lxnat = 1
            endif
            if (nwords .ge. 7) then
              read(words(7),30,err=900) spinph(iph)
            endif
           elseif (mode.eq.4) then  !KJ 1-06 this mode added to read ELNES card
             if(icnt.eq.5) then
                 read(words(1),30,err=900) ebeam   ! read beam energy in keV
                 ebeam=ebeam * dble(1000)  ! convert to eV
                 read(words(2),20,err=1011) aver ! average over sample to beam orientation?
                 read(words(3),20,err=1011) cross ! calculate cross terms?
                 read(words(4),20,err=1011) relat ! use relativistic q-vector?
		 read(words(5),20,err=1012) iinput ! read xmu.dat or opconsKK.dat or ... ?   !KJ 5/6
                 read(words(6),20,err=1013) spcol !column that has spectrum
		 if (aver.eq.1) icnt=icnt-1 !skip the line for beam orientation
                 goto 1011
 1012		 iinput=1		 
 1013            spcol=4
                 if(iinput.eq.2) spcol=3
 1011          continue ! Josh - Should these 1011 be 900? !KJ No.  Optional input.
              elseif(icnt.eq.4) then
d                 read(words(1),30,err=900) xivec(1)  ! read direction of incoming beam
                 read(words(2),30,err=900) xivec(2)  ! in arbitrary units
                 read(words(3),30,err=900) xivec(3)
                 xinorm=dsqrt(xivec(1)**2+xivec(2)**2+xivec(3)**2)
		 if (xinorm.gt.0.0) then
		    do i=1,3
                       xivec(i)=xivec(i)/xinorm    ! normalize this vector.
		    enddo
		 elseif(.not.(aver.eq.1)) then
		    call wlog('WARNING : beam direction unspecified
     1                  in orientation sensitive EELS calculation.
     2                  Please correct before running EELS module.')
		 endif
             elseif(icnt.eq.3) then
                 read(words(1),30,err=900) acoll  ! collection semiangle in mrad
                 read(words(2),30,err=900) aconv  ! convergence semiangle in mrad
                 acoll=acoll/dble(1000);aconv=aconv/dble(1000) ! convert from mrad to rad
             elseif(icnt.eq.2) then
                 read(words(1),20,err=900) nqr    ! specify q-mesh, radial parameter
                 read(words(2),20,err=900) nqf    ! specify q-mesh, angular parameter
		 if(nqr*nqf.eq.0) then
		    call wlog('WARNING : zero q-mesh points specified
     1               for EELS calculation.  Please correct before
     2               running EELS module.')
                 endif
           elseif(icnt.eq.1) then
                 read(words(1),30,err=900) thetax ! detector position in plane perpendicular to beam ; angle in mrad
                 read(words(2),30,err=900) thetay ! detector position in plane perpendicular to beam ; angle in mrad
                 mode=0  ! finished reading ELNES card
!! initialize evec to be nonzero and perpendicular to xivec
!               if(dabs(xivec(1)-xivec(2)).gt.0.0001.or.
!     1            dabs(xivec(2)-xivec(3)).gt.0.0001) then
!                     evec(1)=xivec(2)*xivec(1)-xivec(3)**2
!                     evec(2)=xivec(3)*xivec(2)-xivec(1)**2
!                     evec(3)=xivec(1)*xivec(3)-xivec(2)**2
!                 else
!                     evec(1)=xivec(2)
!                     evec(2)=dble(0)
!                     evec(3)=-xivec(2)
!                 endif
             endif
             icnt=icnt-1    ! now read the next line
         !KJ end my changes                            
         else
            write(slog,'(a,i8)') 'Mode unrecognized, mode ', mode
            call wlog(slog)
            call par_stop('RDINP-6')
         endif
      goto 200
  220 continue
c done reading input file, 
c#{mn
c call rdline with jinit=0 to clean up all input files
       jinit = 0
       call rdline(jinit,line)
c#mn}

c     Fix up defaults, error check limits, figure out free atoms, etc.



c !KJ added this check 1-06
      if(magic.eq.1.and.(eels.ne.1)) then
          call wlog('To use MAGIC card you must have ELNES card.')
          call wlog('Ignoring MAGIC card.')
          magic=0
        endif
c !KJ

c  !KJ another check for eels 1-06
      if((eels.eq.1).and.(aver.eq.1).and.(cross.eq.1)) then
          call wlog('WARNING : you have asked to calculate an
     1   orientation averaged spectrum, but you have also asked
     2   to calculate cross-terms.  Averaging kills the cross terms.
     3   Hence the program ignores your request and does not
     4   calculate cross terms.')
      endif
c  !KJ

c  !KJ  set up a variable needed for elnes 1-06
        if(eels.eq.1) then
          if(aver.eq.1) then
             ipstep=1
             ipmin=10
             ipmax=10
          else
            ipmin=1
            ipmax=9
            if(cross.eq.1) then
               ipstep=1
            else
               ipstep=4
            endif
          endif
        endif
c  !KJ


c     need smaller rgrid for nonlocal exchange
      if (ixc0.lt.0) ixc0 = 0
      if (mod(ixc,10).ge.5 .and. rgrd.gt.0.03) rgrd=0.03d0 
      if (mod(ixc0,10).ge.5 .and. rgrd.gt.0.03) rgrd=0.03d0 
c     must use linear polarization to use nstar
      if (wnstar)  then
         if (ipol.ne.1)  then
            call wlog(' Must have linear polarization to use NSTAR.')
            call wlog(' NSTAR will be turned off.')
            wnstar = .false.
         endif
      endif

c     Do not use ihole .le. 0
      if (ihole .le. 0)  then
         call wlog(' Use NOHOLE to calculate without core hole.')
         call wlog(' Only ihole greater than zero are allowed.')
         call par_stop('RDINP')
      endif

c     Find out how many unique potentials we have
c     in POTENTIAL card
      nph = 0
      do 300  iph = nphx, 0, -1
         if (iz(iph) .gt. 0)  then
            nph = iph
            goto 301
         endif
  300 continue
  301 continue

c     cannot use OVERLAP and ATOMS cards together
      if (iatom .gt. 0 .and. iovrlp .gt. 0)  then
        call wlog(' Cannot use ATOMS and OVERLAP in the same feff.inp.')
        call par_stop('RDINP')
      endif

c     cannot use OVERLAP and CFAVERAGE   cards together
      if (novr(0) .gt. 0) then
c        OVERLAP is used, cannot do configuration average
         iphabs = 0
         nabs = 1
         rclabs = big
      endif

c     Must have central atom
      if (iz(0) .le. 0)  then
         if (iphabs .gt. 0) then
c           central atom is of the iphabs type
            iz(0) = iz(iphabs)
            potlbl(0) = potlbl(iphabs)
            lmaxsc(0) = lmaxsc(iphabs)
            lmaxph(0) = lmaxph(iphabs)
            xion(0) = xion(iphabs)
         else
            call wlog(' No absorbing atom (unique pot 0) was defined.')
            call par_stop('RDINP')
         endif
      endif

c     No gaps allowed in unique pots.  Make sure we have enough
c     to overlap all unique pots 0 to nph.
      if (iphabs.gt.0 .and. iatph(0).le.0)   iatph(0) = iatph(iphabs)
      do 340  iph = 0, nph
         if (iatph(iph) .le. 0  .and.  novr(iph) .le. 0)  then
c           No model atom, no overlap cards, can't do this unique pot
            write(slog,'(a,i8)') 
     1       ' No atoms or overlap cards for unique pot ', iph
            call wlog(slog)
            call wlog(' Cannot calculate potentials, etc.')
            call par_stop('RDINP-')
         endif
c        by default freeze f-electrons and reset lmaxsc=2
         if (iunf.eq.0 .and. lmaxsc(iph).gt.2) lmaxsc(iph)=2
  340 continue

c     Need number of atoms of each unique pot, count them.  If none,
c     set to one. Do statistics for all atoms in feff.inp.
      do 350  iph = 0, nph
        if (lxnat.eq.0) then 
          xnatph(iph) = 0
          do 346  iat = 1, natt
              if (iphatx(iat) .eq. iph)  xnatph(iph) = xnatph(iph)+1
  346     continue
          if (iph.gt.0 .and. iph.eq.iphabs) xnatph(iph) = xnatph(iph)-1
        else
          if (xnatph(iph).le. 0.01) then
            if (iph.eq.0) then
              xnatph(iph) = 0.01d0
            else
              write (slog,'(a,i4)') ' Inconsistency in POTENTIAL card'//
     1                              ' is detected for unique pot ', iph
              call wlog (slog)
              call wlog (' Results might be meaningless.')
            endif
          endif
        endif
        if (xnatph(iph) .le. 0)  xnatph(iph) = 1
  350 continue
      if (lxnat.ne.0) then
c        normalize statistics to hav one absorber
         do 351 iph = 1, nph
  351    xnatph(iph) = xnatph(iph) /xnatph(0)
         xnatph(0) = 1
      endif
      xnat = 0
      do 352 iph = 0,nph
  352 xnat = xnat + xnatph(iph)

c     Find distance to nearest and most distant atom (use overlap card
c     if no atoms specified.)
      if (natt .lt. 2)  then
         ratmin = rovr(1,0)
         ratmax = rovr(novr(0),0)
      else
         ratmax = 0
         ratmin = 1.0e10
         iatabs = iatph(0)
         icount = 0
         if (iatabs.le.0) iatabs = iatph( iphabs)
         if (iatabs.le.0) call par_stop('RDINP fatal error: iatabs=NaN')

         do 412  iat = 1, natt
           if (iphatx(iat) .eq. iphabs .or. iphatx(iat).eq.0)
     1        icount = icount +1
           if (iat.ne.iatabs) then
c           skip absorbing atom
            tmp = dist (ratx(1,iat), ratx(1,iatabs))
            if (tmp .gt. ratmax)  ratmax = tmp
            if (tmp .lt. ratmin)  ratmin = tmp
           endif
  412    continue
         if (nabs.le.0) nabs = icount
      endif

c     Set total volume
      if (totvol.gt.0) totvol = totvol * ratmin**3 * xnat

c     Set rfms if they are too small
      if (rfms1 .lt. ratmin) rfms1 = -1.e0
      if (rfms2 .lt. ratmin) rfms2 = -1.e0
      if (rfms2 .lt. ratmin .and. ispec.lt.2) ispec = - ispec 
      if (rfms2 .lt. ratmin .and. ispec.eq.3) ispec = - ispec 
c     if ispec.le.0 MS expansion will be used, else - FMS method.
      

c     Set rmax if necessary
      if (rmax.le.0 .and. nss.le.0 .and. ispec.le.0)  then
c        set to min (2+ times ratmin, ratmax) (magic numbers to
c        avoid roundoff, note that rmax is single precision).
         rmax = min (2.2 * ratmin, 1.01 * ratmax)
      endif

c     Set core hole lifetime (central atom quantity) and s02
      iph = 0
      call setgam (iz(iph), ihole, gamach)
      if (s02.eq.1.d0) s02=s02h

c     Convert everything to code units, and use rmult factor
c     rmax is for pathfinder, so leave it in Ang.
      rmax = rmax * rmult
      rfms1 = rfms1 * rmult 
      rfms2 = rfms2 * rmult 
      totvol = totvol * rmult**3
c     Use rmult factor.  Leave distances in Ang.
      do 430  iat = 1, natt
         do 420  i = 1, 3
            ratx(i,iat) = ratx(i,iat) * rmult
  420    continue
  430 continue
      do 460  iph = 0, nph
         do 450  iovr = 1, novr(iph)
            rovr(iovr,iph) = rovr(iovr,iph) * rmult
  450    continue
  460 continue
      do 462  iss = 1, nss
c        rss used only to make paths.dat, so leave it in Angstroms.
         rss(iss) = rss(iss) * rmult
  462 continue

c     Clean up control flags
      if (mpot .ne. 0)  mpot = 1
      if (mphase .ne. 0)  mphase = 1
      if (mfms .ne. 0)  mfms = 1
      if (mpath  .ne. 0)  mpath = 1
      if (mfeff  .ne. 0)  mfeff = 1
      if (mchi   .ne. 0)  mchi = 1
      if (nss    .le. 0)  ms = 1
      if (ifolp  .ne. 0)  iafolp = -1
      if (natt.le.0) then
c       Overalp geometry
        mfms = 0
        mpath = 0
        ms = 0
c       no SCF loop
        nscmt = 0
        do 464 iph = 0, nph
          if (novr(iph).le.0) call par_stop('Bad OVERLAP cards.')
  464   continue
      endif

      if (iafolp .ge. 0) then
         do 485 i = 0, nphx
  485    folp(i) = folpx
      endif

      if (ntitle .le. 0)  then
         ntitle = 1
         title(1) = 'Null title'
      endif
      do 490  i = 1, ntitle
         ltit(i) = istrln (title(i))
  490 continue
      nttl = ntitle

c     write atoms.dat, global.inp, modN.inp and ldos.inp
      call wrtall (nabs)

c     In case of OVERLAP and SS calculateions write 'paths.dat'
c     without invoking the pathfinder. Single scattering paths only.
      if (nss .gt. 0  .and.  mpath .eq. 1)  then
         open (unit=1, file='paths.dat', status='unknown', iostat=ios)
         call chopen (ios, 'paths.dat', 'rdinp')
         do 750  i = 1, ntitle
            write(1,748)  title(i)(1:ltit(i))
  748       format (1x, a)
  750    continue
         write(1,751)
  751    format (' Single scattering paths from ss lines cards',
     1           ' in feff input')
         write(1,706)
  706    format (1x, 71('-'))
         do 760  iss = 1, nss
            if (rmax.le.0  .or.  rss(iss).le.rmax)  then
c              NB, rmax and rss are in angstroms
               write(1,752) indss(iss), 2, degss(iss),
     2              rss(iss)
  752          format ( 2i4, f8.3,
     1             '  index,nleg,degeneracy,r=', f8.4)
               write(1,766)
  766          format (' single scattering')
               write(1,754) rss(iss), zero, zero, iphss(iss),
     1                      potlbl(iphss(iss))
               write(1,753) zero, zero, zero, 0, potlbl(0)
  753          format (3f12.6, i4,  1x, '''', a6, '''', '  x,y,z,ipot')
  754          format (3f12.6, i4,  1x, '''', a6, '''')
            endif
  760    continue
         close (unit=1)
      endif

      do 120  i = 1, ntitle
         call wlog(' ' // title(i)(1:ltit(i)))
  120 continue

c     if user doesn't want geom.dat, don't do it
      if (nogeom)  then
c        don't delete geom.dat when done with it either...
         if (ipr4 .lt. 2)  ipr4 = 2
         if (nabs.gt.1) call 
     1     par_stop('NOGEOM and CFAVERAGE are incompatible')
      else
c       temporarily call ffsort. here
        iabs = 1
c !KJ 1-06 : If the user does EELS and doesn't calculate cross terms for an
c       orientation sensitive calculation, FEFF mustn't change the
c       coordinate system, as this would lead to the appearance of
c       cross terms after all.  Therefore, I added an argument to the
c       calling sequence of ffsort.
c       To be precise, giving '.false.' disables the call of ffsort to mkptz.
c       Giving '.true.' makes ffsort work exactly as it always has.
        if((eels.eq.1)) then
           call ffsort(iabs,.false.)
        else
           call ffsort(iabs,.true.)
        endif   !KJ end my changes
       endif
       
       ceels=(eels.eq.1) !KJ 5-6 for monolithic version

      close(unit=11)
  400 call par_barrier
      call par_end

c     sub-program exchange
!     stop
      return

c     normal end of rdinp

  900 continue
      call wlog(' Error reading input, bad line follows:')
      write(slog,'(1x,a)') line(1:71)
      call wlog(slog)
      call par_stop('RDINP fatal error.')

      end

      subroutine phstop (iph,line)
      implicit double precision (a-h, o-z)
      character*(*) line
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      character*512 slog
      if (iph .lt. 0  .or.  iph .gt. nphx)  then
         write(slog,10) iph, nphx, line
         call wlog(slog)
   10    format (' Unique potential index', i5, ' out of range.', 
     1           ' Must be between 0 and', i5, '.  Input line:', 
     2           1x, a)
         call par_stop('RDINP - PHSTOP')
      endif
      return
      end

      subroutine warnex (string)
      implicit double precision (a-h, o-z)
c     This prints a warning message if the user is using an
c     expert option.
      character*(*) string

      call wlog(string)
      call wlog(' Expert option, please read documentation ' //
     1          'carefully and check your results.')
      return
      end
      subroutine ffsort (iabs,doptz)
c KJ 1-06 : I added second input argument doptz      
      implicit double precision (a-h, o-z)

c     finds iabs-th atom of 'iphabs' type in file atoms.dat and writes
c     a smaller list of all atoms within 'rclabs' of that particular
c     absorber into 'geom.dat' file.
c      first coded by a.l.ankudinov, 1998 for CFAVERAGE card
c      modified by a.l.ankudinov, march 2001 for new i/o structure

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/vers.h
      character*12 vfeff
c                       123456789012  
      parameter (vfeff='Feff 8.50')
c= ../HEADERS/vers.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}

cc    INPUT
cc    atoms.dat
        integer  natt
        integer iphatx(nattx)
        double precision  ratx(3,nattx)
	logical doptz  !KJ 1-06 : call mkptz or not?	
cc    global.dat
c       configuration average
        integer nabs, iphabs
c       global polarization data
        integer  ipol, ispin, le2
        double precision evec(3), xivec(3), spvec(3), elpty,angks,rclabs
        complex*16 ptz(-1:1, -1:1)
cc    OUTPUT: geom.dat
        integer  nat
        integer iatph(0:nphx), iphat(natx), index(natx)
        double precision  rat(3,natx)

c     Local stuff
      parameter (big = 1.0e5)
      character*512 slog

      external dist

c     if (worker) go to 400

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)

cc    read atoms.dat file
      open (file='atoms.dat', unit=3, status='old',iostat=ios)
        read(3, 35) slog, natt
  35    format (a8, i7)
        read  (3, 10) slog
        do 40  iat = 1, natt
          read (3,36) ratx(1,iat), ratx(2,iat), ratx(3,iat), iphatx(iat)
  36      format( 3f13.5, i4)
  40    continue
      close(3)

c     read global.inp
c     CFAVERAGE iphabs nabs rclabs
        open (file='global.dat', unit=3, status='old',iostat=ios)
        call chopen (ios, 'global.inp', 'ffsort')
        read (3, 10) slog
        read (3, 45) nabs, iphabs, rclabs
  45    format ( 2i8, f13.5)
c       global polarization data
        read  (3,10) slog
        read  (3, 50)  ipol, ispin, le2, elpty, angks
  50    format ( 3i5, 2f12.4)
        read  (3, 10) slog
        do 60 i = 1,3
          read  (3,30) evec(i), xivec(i), spvec(i)
  60    continue
        read  (3, 10) slog
        do 70 i = -1, 1
          read (3,30) a1, b1, a2, b2, a3, b3
          ptz(-1,i)= cmplx(a1,b1) 
          ptz(0,i) = cmplx(a2,b2) 
          ptz(1,i) = cmplx(a3,b3) 
  70    continue
      close(3)

c     Find the first absorber (iphabs type) in a long list (iabs.le.0),
c     or find iabs-th atom in the list of type iphabs (iabs.gt.0)
      iatabs = 0
      icount = 0
      ifound = 0
      do 305 iat = 1, natt
         if (iphatx(iat) .eq. 0) iphatx(iat) = iphabs
         if (iphatx(iat) .eq. iphabs) icount = icount +1
         if (ifound.eq.0 .and. icount.gt.0 .and. (icount.eq.iabs .or.
     1                          (iabs.le.0 .and. icount.eq.1))) then
            iatabs = iat
            ifound =1
         endif
  305 continue

c     Make several sanity checks
      if (iatabs.eq.0 .and. natt.gt.1) then
         call wlog(' No absorbing atom (unique pot 0 or iphabs in'//
     1             ' CFAVERAGE  card) was defined.')
         call par_stop('RDINP')
      endif
      if (iphabs.eq.0 .and. icount.gt.1) then
         call wlog(' More than one absorbing atom (potential 0)')
         call wlog(' Only one absorbing atom allowed')
         call par_stop('RDINP')
      endif
      if ((icount.gt.0 .and. icount.lt.nabs) .or. nabs.le.0) then
         nabs = icount
         call wlog(' Averaging over ALL atoms of iphabs type')
      endif

c     Make absorbing atom first in the short list
      if (iatabs .ne. 0) then
         rat(1,1) = 0
         rat(2,1) = 0
         rat(3,1) = 0
         iphat(1) = 0
         index(1) = iatabs
      endif
          
c     make a smaller list of atoms from a big one
      nat = 1
      do 309 iat = 1,natt
         if (iat.ne.iatabs) then
            tmp = dist (ratx(1,iat), ratx(1,iatabs))
            if (tmp.gt.0.1 .and. tmp.le.rclabs) then
               nat = nat + 1
               if (nat.gt.natx) then
                 write (slog, 307) nat, natx
  307            format (' Number of atoms', i6, 'exceeds max allowed',
     1           ' for the pathfinder =', i6)
                 call wlog (' Use or reduce rclabs in CFAVERAGE card')
                 call wlog (' Or increase parameter natx and recompile')
                 call par_stop('RDINP')
               endif
               rat(1,nat) = ratx(1,iat)-ratx(1,iatabs)
               rat(2,nat) = ratx(2,iat)-ratx(2,iatabs)
               rat(3,nat) = ratx(3,iat)-ratx(3,iatabs)
               iphat(nat) = iphatx(iat)
               index(nat) = iat
            endif
         endif
 309  continue
c     sort atoms by distance
      do 315 iat = 1,nat-1
        r2min = rat(1,iat)**2 + rat(2,iat)**2 + rat(3,iat)**2
        imin = iat
        do 310 i = iat+1,nat
          r2 = rat(1,i)**2 + rat(2,i)**2 + rat(3,i)**2
          if (r2.lt.r2min) then
            r2min = r2
            imin = i
          endif
 310    continue
        if (imin.ne.iat) then
c         permute coordinates for atoms iat and imin
          do 311 i = 1,3
            r2 = rat(i,iat)
            rat(i,iat) = rat(i,imin)
            rat(i,imin) = r2
 311      continue
          i = iphat(iat)
          iphat(iat) = iphat(imin)
          iphat(imin) = i
          i = index(iat)
          index(iat) = index(imin)
          index(imin) = i
        endif
 315  enddo

c     rotate xyz frame for the most convinience and make
c     polarization tensor
c     make polarization tensor when z-axis is along k-vector 
      if (doptz)  !KJ I added this if-statement 1-06
     1  call mkptz( ipol, elpty, evec, xivec, ispin, spvec, nat, rat,
     2           angks, le2, ptz)
c     rewrite global.inp for initial iteration to update 'ptz'
      open (file='global.dat', unit=3, status='unknown',iostat=ios)
c       configuration average data
        write (3, 10) ' nabs, iphabs - CFAVERAGE data'
        write (3, 45) nabs, iphabs, rclabs
c       global polarization data
        write (3,10) ' ipol, ispin, le2, elpty, angks'
        write (3, 50)  ipol, ispin, le2, elpty, angks
        write (3, 10) 'evec         xivec        spvec'
        do 360 i = 1,3
          write (3,30) evec(i), xivec(i), spvec(i)
 360    continue
        write (3, 10) ' polarization tensor '
        do 370 i = -1, 1
          write(3,30) dble(ptz(-1,i)), dimag(ptz(-1,i)), dble(ptz(0,i)),
     1                dimag(ptz(0,i)),  dble(ptz(1,i)), dimag(ptz(1,i))
 370    continue
      close(3)
c     Find model atoms for unique pots that have them
c     Use atom closest to absorber for model
      do 316  iph = 1, nphx
 316  iatph(iph) = 0
c     By construction absorbing atom is first in the list
      iatph(0) = 1
      nph = 0
      do 330  iph = 1, nphx
         rabs = big
         do 320  iat = 2, nat
            if (iph .eq. iphat(iat))  then
               tmp = dist (rat(1,iat), rat(1,1))
               if (tmp .lt. rabs)  then
c                 this is the closest so far
                  rabs = tmp
                  iatph(iph) = iat
               endif
            endif
  320    continue
         if (iatph(iph).gt.0) nph = iph
  330 continue
c     if iatph > 0, a model atom has been found.

c     Check if 2 atoms are closer together than 1.75 bohr (~.93 Ang)
      ratmin = 1.0e20
      do 480  iat = 1, nat
         do 470  jat = iat+1, nat
            rtmp = dist(rat(1,iat),rat(1,jat))
            if (rtmp .lt. ratmin)  ratmin = rtmp
            if (rtmp .lt. 1.75 * bohr)  then
               call wlog(' WARNING:  TWO ATOMS VERY CLOSE TOGETHER.' //
     1                   '  CHECK INPUT.')
               iatx = index(iat)
               jatx = index(jat)
               write(slog,'(a,2i8)') ' atoms ', iatx, jatx
               call wlog(slog)
               write(slog,'(i5,1p,3e13.5)') iatx, (ratx(i,iatx),i=1,3)
               call wlog(slog)
               write(slog,'(i5,1p,3e13.5)') jatx, (ratx(i,jatx),i=1,3)
               call wlog(slog)
               call wlog(' Run continues in case you really meant it.')
            endif
  470    continue
  480 continue

c     Write output geom.dat
      open (file='geom.dat', unit=3, status='unknown',iostat=ios)
        write (3,535) nat, nph
  535   format ('nat, nph = ', 2i5)
        write (3,516) (iatph(iph), iph=0,nph)
  516   format(16i5)
        write (3, 10) ' iat     x       y        z       iph  '
        write (3, 526)
  526   format (1x, 71('-'))
        ibounc = 1
        do 540  i = 1, nat
          write(3,536) i, rat(1,i), rat(2,i), rat(3,i), iphat(i), ibounc
  536     format(i4, 3f13.5, 2i4)
  540   continue
      close(3)

c     Atoms for the pathfinder
      if (iatabs .le. 0)  then
         call wlog(' Absorbing atom coords not specified.')
         call wlog(' Cannot find multiple scattering paths.')
         call par_stop('RDINP')
      endif

c 400 call par_barrier

      return
      end
      subroutine iniall
c     initializes all input variables contained in the
c     common blocks of the header file allinp.h 
c     written by Alexei Ankudinov , march 2001.
c     following the suggested by Bruce Ravel subroutine iorini
      implicit double precision (a-h, o-z)

      real szero, sone
      double precision dzero, done
      parameter(szero = 0.e0, dzero = 0.d0)
      parameter(sone = 1.e0,  done = 1.d0)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../RDINP/allinp.h
c     Common blocks with all input data
c     the common
cc    atoms.dat
      integer  natt
      integer iphatx(nattx)
      double precision  ratx(3,nattx)
      common /geom/ ratx, iphatx, natt
cc    geom.dat
c       integer  nat
c       integer iatph(0:nphx)
c       integer iphat(natx)
c       double precision  rat(3,natx)
c       common /geom/ ratx, iphatx, natt
cc    global.inp
c       configuration average
      integer iphabs
c     global polarization data
      integer  ipol, ispin, le2
      double precision evec(3), xivec(3), spvec(3), elpty,angks,rclabs
      complex*16 ptz(-1:1, -1:1)
      common /global/ ptz, evec, xivec, spvec, elpty, angks, rclabs, 
     1     ipol, ispin, le2, iphabs
c     c    mod1.inp
      character*80 title(nheadx)
c     integer mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec,
      integer mpot, nph, ntitle, ihole, ipr1, iafolp, iunf,
     1     nmix, nohole, jumprm, inters, nscmt, icoul, lfms1
      integer iz(0:nphx)
      integer lmaxsc(0:nphx)
      real rfms1
      double precision gamach, rgrd, ca1, ecv, totvol
      double precision  xnatph(0:nphx), folp(0:nphx), spinph(0:nphx)
      double precision  xion(0:nphx)
c     for OVERLAP option
      integer novr(0:nphx), iphovr(novrx,0:nphx), nnovr(novrx,0:nphx)
      double precision  rovr(novrx,0:nphx)
      common /mod1/ title, xion, xnatph, spinph, folp, gamach, rgrd,
     1     ca1, ecv, totvol, rovr, rfms1, iz, lmaxsc, mpot, nph, ntitle,
     2     ihole, ipr1, iafolp, nmix,nohole,jumprm, inters,
     3     nscmt, icoul, lfms1, novr, iphovr, nnovr, iunf
c     c    ldos.inp
      integer mldos, lfms2
      double precision emin, emax, eimag, rfms2
      common /mod7/ emin, emax, eimag, rfms2, mldos, lfms2
cc    mod2.inp
c     integer mphase, ipr2, ixc, ixc0, vr0, vi0, ispec, lreal, lfms2
      integer mphase, ipr2, ixc, ixc0, ispec, lreal, l2lp, iPlsmn
      integer lmaxph(0:nphx), iGrid
      character*6  potlbl(0:nphx)
c     double precision rgrd, rfms2, gamach, xkstep, xkmax, vixan
      double precision xkstep, xkmax, vixan, vr0, vi0
      common /mod2/ xkstep, xkmax, vixan, vr0, vi0, 
     &     lmaxph, mphase, ipr2, ixc, ixc0, ispec, lreal, l2lp,
     &     izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis, iPlsmn,
     &     iGrid, potlbl
c     c    mod3.inp
      integer mfms, idwopt, minv
c     integer lmaxph(0:nphx)
c     real rfms2, rprec, rdirec, toler1, toler2
      real rprec, rdirec, toler1, toler2
      double precision   tk, thetad, sig2g
      common /mod3/ tk, thetad, sig2g, rprec, rdirec, toler1,
     1       toler2,  mfms, idwopt, minv
c     c    mod4.inp
      integer  mpath, ms, nncrit, nlegxx, ipr4
c     real critpw, pcritk, pcrith,  rmax, rfms2
      real critpw, pcritk, pcrith,  rmax
      common /mod4/ critpw, pcritk, pcrith,  rmax,
     1       mpath, ms, nncrit, nlegxx, ipr4
c     c    mod5.inp
      integer  mfeff, ipr5, iorder
      logical  wnstar
      double precision critcw
      common /mod5/ critcw, mfeff, ipr5, iorder, wnstar
c     c    mod6.inp
c     integer  mchi, ispec, idwopt, ipr6, mbconv
c     double precision  vrcorr, vicorr, s02, alphat, sig2g
      integer  mchi, ipr6, mbconv, absolu !KJ added absolu 3-06
      double precision  vrcorr, vicorr, s02, alphat, thetae
      common /mod6/ vrcorr, vicorr, s02, alphat, thetae, 
     &     mchi, ipr6, mbconv, absolu   !KJ added absolu 3-06
c     c    so2.inp  
      integer  mso2conv, ipse, ipsk
      double precision wsigk, cen
      character(12) cfname
      common /so2/ wsigk, cen, cfname, mso2conv, ipse, ipsk
      
c     c    eels.inp
c     EELS variables  !KJ 1-06 this section added for ELNES, EXELFS, MAGIC cards
      real*8 ebeam, aconv, acoll, thetax, thetay, emagic
      integer eels, relat, aver, cross, iinput,spcol
      integer nqr,nqf,magic
      integer ipmin,ipmax,ipstep
      common /eelsva/ ebeam,aconv,acoll,thetax,thetay,emagic,magic,
     &     nqr, nqf, aver, cross, relat, iinput, spcol,ipmin, ipmax,
     &     ipstep, eels
c     !KJ end
	
c= ../RDINP/allinp.h}

c     initialize character string arrays
      do 10 i=1,nheadx
        title(i) = ' '
 10   continue

c  initialize integer scalars
      iGrid = 0 ! Josh Kas
      ntitle = 0
      nat = 0
      natt = 0
      nph = 0

      iafolp = 0
      idwopt = -1
      ihole = 1
      inters = 0
      iorder = 2
      ipr1 = 0
      ipr2 = 0
      ipr3 = 0
      ipr4 = 0
      ipr5 = 0
      ipr6 = 0
      ipse = 0
      ipsk = 0
      ispec = 0
      ixc = 0
      ixc0 = -1
      jumprm = 0
      lfms1 = 0
      lfms2 = 0
      minv = 0
      lreal = 0
      mbconv = 0
      mchi = 1
      mfeff = 1
      mfms = 1
      mpath = 1
      mphase = 1
      mldos = 0
      mpot = 1
      ms = 0
      iPlsmn = 0 ! Josh Kas
      mso2conv = 0 ! Josh Kas
      nlegxx = 10
      nmix = 1
      nohole = -1
      nscmt = 0
      icoul = 0
      iunf = 0
      izstd = 0
      ifxc = 0
      ipmbse = 0
      itdlda = 0
      nonlocal = 0
      ibasis = 0

cc initialize reals
      critpw = 2.5*sone
      pcritk = szero
      pcrith = szero
      rmax = -1 * sone
      rfms1 = -1 * sone
      rfms2 = -1 * sone
      rdirec = -1 * sone
      toler1 = 1.d-3
      toler2 = 1.d-3

cc initialize double precision scalars
      alphat = dzero
      thetae = dzero
      ca1 = dzero
      critcw = 4*done
      eimag = -1*done
      ecv = -40*done 
      emax = dzero
      emin = 1000*done
      rclabs = dzero
      rgrd = 0.05 * done
      s02 = done
      sig2g = dzero
      thetad = dzero
      tk = dzero
      totvol = dzero
      vr0 = dzero
      vi0 = dzero
      vicorr = dzero
      vrcorr = dzero
      xkmax = 20*done
      xkstep = 0.07*done
      vixan = dzero
      wsigk = dzero ! Josh Kas
      cen = dzero ! Josh Kas
      
cc initialize logicals
      wnstar = .false.


c  initialize loops of number of potentials
      do 110 i=0,nphx
        xnatph(i) = dzero
        spinph(i) = dzero
        iz(i) = 0
        xion(i) = dzero
        folp(i) = done
        novr(i) = 0
        lmaxsc(i) = 0
        lmaxph(i) = 0
        potlbl(i) = ' '
 110  continue

c  initialize polarization data
      ipol = 0
      ispin = 0
      le2 = 0
      l2lp = 0
      elpty = dzero
      angks = dzero
      do 130 i=1,3
        evec(i) = dzero
        xivec(i) = dzero
        spvec(i) = dzero
 130  continue
      do 150 i=-1,1
        do 140 j=-1,1
          ptz(j,i) = cmplx(dzero,dzero)
 140    continue
 150  continue

c  initialize atom list data
      do 170 i=1,nattx
 170  iphatx(i) = -1

c  initialize character strings - Josh Kas
      cfname = 'NULL'
      
c  initialize EELS variables !KJ 1-06
      ebeam=dzero
	aconv=dzero
	acoll=dzero
	nqr=0
	nqf=0
	magic=0
	emagic=dzero
	eels=0
	relat=1
	cross=1
	aver=0
      thetax=dzero
	thetay=dzero
	ipmin=1
	ipmax=9
	ipstep=1
	iinput=1  !5/6
       spcol=4
c KJ 

c for ABSOLUTE card  !KJ 3-06
        absolu=0  !KJ 3-06

      return
      end
c  end subroutine iniall
      subroutine mkptz (ipol, elpty, evec, xivec, ispin, spvec,nat,rat,
     1                  angks, le2, ptz)
c     choose new right handed frame of reference with z along spvec,
c      y along (xivec cross spvec); simpler choice if one of them is 0.
c     get all vectors in new frame and
c     makes polarization tensor ptz when z is rotated along k-vector

c     input:
c     ipol = 0  random k-vector orientation in 3d; ptz(i,j)=\delta_{i,j}
c     ipol = 1 for polarizion vector eps and it's  complex conjugate epc
c        ptz(j,i) = 0.5 [(eps(-i))^* eps(-j) + (epc(-i))^* epc(-j)]
c        notice that complex conjugation and taking i-th component
c        are non commuting operations. (eps(-i))^* = (-)^i (epc(i))
c     ipol = 2 ptz(i,j)= i*\delta_{i,j}
c     elpty - ellipticity (optional for ipol=1)
c     xivec - direction of x-ray propagation
c     ispin - type of spin calculations
c        0 - spin independent
c        -1,1 - spin dependent potential
c        2 - calculations with spin-up potential
c       -2 - calculations with spin-down potential
c     spvec - direction of spin vector (along z at the output)
c     nat - number of atoms
c     rat - xyz cordinates of atoms (changed due to the rotations)

c     output:
c     angks - angle between k-vector and spin-vector (0-pi)
c     le2   - 0-only E1, 1-E1+M1, 2-E1+E2, 3-E1+E2+M1 transitions
c     ptz   - polarization tensor

      implicit double precision (a-h, o-z)

c     all input and output through common area /pol/
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
      dimension evec(3), xivec(3), spvec(3), rat(3,nat)
      complex*16 ptz
      dimension ptz(-1:1, -1:1)

c     addittonal local stuff to create polarization tensor ptz(i,j)
      dimension e2(3)
      complex*16  e(3),eps,epc
      dimension eps(-1:1),epc(-1:1)
      character*512 slog

c     make z axis along propagation (XIVEC).
c     le2=0 - only E1 transitions; le2=1 - E1+M1; le2=2 - E1+E2 
      rr = xivec(1)**2 + xivec(2)**2 + xivec(3)**2
      if (rr.eq.0) then
        angks = 0
c       special case when xivec is not specified
        if (ipol.eq.1) then
c         need to know xivec for E2 and M1 transitions
c         leave only E1 contribution
          if (le2.ne.0) call wlog(
     1    '  Can do only E1 transitions. Specify k-vector for M1 or E2')
          le2 = 0
        else
c         for polarization average of circular dichroizm
          if (ispin.ne.0) then
c           spin-dependent case
            do 10 i = 1,3
  10        xivec(i) = spvec(i)
            rr = xivec(1)**2 + xivec(2)**2 + xivec(3)**2
          endif
        endif
      endif
            
              
      if (rr.gt.0) then
         rsp = sqrt(rr)
         rr = xivec(1)**2 + xivec(2)**2
         if ( rr.ne.0 .or. xivec(3).lt.0) then
           if (rr.eq. 0) then
             cst = - 1
             snt = 0
             csf = 1
             snf = 0
           else
c            rotation is defined by angles theta and fi
             rr = sqrt(rr)
             cst = xivec(3) / rsp
             snt = rr / rsp
             csf = xivec(1) / rr
             snf = xivec(2) / rr
           endif
c          rotate all vectors
           do 20 i = 1, nat
 20        call rotate (rat(1,i), cst, snt, csf, snf)
           call rotate (evec, cst, snt, csf, snf)
           call rotate (xivec, cst, snt, csf, snf)
           call rotate (spvec, cst, snt, csf, snf)
         endif
      endif


c     initialize ptz
      do 30 i=-1,1
      do 30 j=-1,1
 30   ptz(j,i) = 0

c     make ptz in the frame when z is along xivec, except ipol=0
      if (ipol .eq. 0) then
         do 40 i=-1,1
 40      ptz(i,i) = 1.d0 /3.d0
      elseif (ipol .eq. 2) then
         ptz( 1, 1) =  1.d0
         ptz(-1,-1) = -1.d0
      elseif (ipol .eq. 1) then
c       Normalize polarization vector
        x = sqrt (evec(1)**2 + evec(2)**2 + evec(3)**2)
        if (x .le. 0.000001) then
         call wlog(' STOP  Polarization vector of almost zero length')
         call wlog(' Correct POLARIZATION card')
         call par_stop('MKPTZ-1')
        endif
        do 50  i = 1, 3
         evec(i) = evec(i) / x
  50    continue
        x = sqrt (xivec(1)**2 + xivec(2)**2 + xivec(3)**2)
        if (x .gt. 0) then
c         run elliptical polarization code
          do 60  i = 1, 3
            xivec(i) = xivec(i) / x
  60      continue
          x = evec(1)*xivec(1)+evec(2)*xivec(2)+evec(3)*xivec(3)
          if (abs(x) .gt. 0.9) then
            call wlog(' polarization')
            write(slog,292)  (evec(i), i=1,3)
            call wlog(slog)
            call wlog(' incidence')
            write(slog,292) (xivec(i), i=1,3)
            call wlog(slog)
            call wlog(' dot product')
            write(slog,292)  x
            call wlog(slog)
  292       format (5x, 1p, 2e13.5)
            call wlog(' STOP polarization almost parallel' //
     1                ' to the incidence')
            call wlog(' Correct ELLIPTICITY and POLARIZATION cards')
            call par_stop('MKPTZ-2')
          endif
          if (x .ne. 0.0) then
c           if xivec not normal to evec then make in normal, keeping the
c           plane based on two vectors
            call wlog(' Changing polarization vector!')
            call wlog(' Incidence is not normal to polarization.')
            call wlog(' Check your input for errors. Run continues.')
            do 70  i = 1,3
              evec(i) = evec(i) - x*xivec(i)
  70        continue
            x = sqrt (evec(1)**2 + evec(2)**2 + evec(3)**2)
            do 80   i = 1, 3
               evec(i) = evec(i) / x
  80        continue
          endif
        else
c         elpty cannot be used with xivec=0
          elpty = 0.0
        endif 
     
        e2(1) = xivec(2)*evec(3)-xivec(3)*evec(2)
        e2(2) = xivec(3)*evec(1)-xivec(1)*evec(3)
        e2(3) = xivec(1)*evec(2)-xivec(2)*evec(1)
        do 90   i = 1,3
          e(i) = (evec(i)+elpty*e2(i)*coni)
  90    continue 
        eps(-1) =  (e(1)-coni*e(2))/sqrt(2.0)
        eps(0)  =   e(3)
        eps(1)  = -(e(1)+coni*e(2))/sqrt(2.0)
        do 100  i = 1,3
          e(i) = (evec(i)-elpty*e2(i)*coni)
  100   continue 
        epc(-1) =  (e(1)-coni*e(2))/sqrt(2.0)
        epc(0)  =   e(3)
        epc(1)  = -(e(1)+coni*e(2))/sqrt(2.0)
        do 110 i = -1,1
        do 110 j = -1,1
c         ptz(j,i) = (-1.0)**i * epc(i)*eps(-j) / (1+elpty**2)
c         above - true polarization tensor for given ellipticity, 
c         below - average over left and right in order to have
c         path reversal simmetry
          ptz(j,i) = ((-1.0)**i)*(epc(i)*eps(-j)+eps(i)*epc(-j))
     1               /(1+elpty**2)/2.0
  110   continue
      endif
c     end of making polarization tensor

      angks = 0


c     second rotate so that z parrallel to spin
c     note that new y-axis is normal to spin AND incidence vector
c     which simplifies further expression for rotation matrix
      rr = spvec(1)**2 + spvec(2)**2 + spvec(3)**2
      if (rr.gt.0) then
         rsp = sqrt(rr)
         rr = spvec(1)**2 + spvec(2)**2
         if ( rr.ne.0 .or. spvec(3).lt.0) then
           if (rr.eq. 0) then
             cst = - 1
             snt = 0
             csf = 1
             snf = 0
             angks = pi
           else
c            rotation is defined by angles theta and fi
             rr = sqrt(rr)
             cst = spvec(3) / rsp
             snt = rr / rsp
             csf = spvec(1) / rr
             snf = spvec(2) / rr
             angks = acos( cst)
           endif
c          rotate all vectors
           do 120 i = 1, nat
 120       call rotate (rat(1,i), cst, snt, csf, snf)
           call rotate (evec, cst, snt, csf, snf)
           call rotate (xivec, cst, snt, csf, snf)
         endif
      endif

      return
      end

      subroutine rotate (vec, cst, snt, csf, snf)
      implicit double precision (a-h, o-z)
c     rotates vector to a new coordinate system
c     Euler angles: alpha=phi, beta=theta, gamma=0
      dimension vec(3), temp (3)

      temp(1) = vec(1)*cst*csf + vec(2)*cst*snf - vec(3)*snt
      temp(2) = -vec(1)*snf + vec(2)*csf
      temp(3) = vec(1)*csf*snt + vec(2)*snt*snf + vec(3)*cst
      do 10 i = 1,3
  10  vec(i) = temp(i)

      return
      end
       subroutine rdline(jinit, line)
c
c  return next "real" command line from input file(s)
c    -  allows use of "include file" or "load file" for reading
c       from other files, and manages the set of include files
c    -  checks for and ignores comment lines and blank lines.
c    -  opens and closes all input files, including initial file.
c
c   jinit  initialization/clean-up flag     [in]
c   line   next command line to parse   [in/out]
c
c notes:
c   1. to initialize, set jinit<0 and line= main_input_file_name.inp
c      if line=' ', routine will stop program.
c   2. returned line will be sent through triml and untab.
c   3. uses routine iscomm to test if line is a comment line.
c   4. special returned values:
c        'read_line_end'  = done reading all inputs
c        'read_line_error'= an error has occurred. the calling routine
c                        should probably stop
c   5. to clean up all open files, call with jinit=0
c
c matt newville march 1999
       implicit none
       integer mwords, ilen, i, jinit, mfil, nfil
       parameter (mwords=2, mfil=10)
       character*(*) line, stat*8
       character*90  files(mfil), errmsg, words(mwords)
       parameter (stat='old')
       integer   iunit(mfil), istrln, nwords, ierr, iexist
       logical   iscomm, open
       external  istrln, iscomm
       save      files, iunit, nfil
c
c jinit=-1: initialize
       if (jinit.eq.-1) then
          jinit  = 1
          do 10 i = 1, mfil
             iunit(i) = 0
             files(i) = ' '
 10       continue
          nfil     = 1
          files(1) = line
          call triml(files(1))
          call openfl(iunit(1), files(1), stat, iexist, ierr)
          if (iexist .lt. 0) go to 2600
          if (ierr   .lt. 0) go to 2800
c
c  jinit=0:  close all opened files (except unit 5!)
       elseif (jinit.eq.0) then
          jinit = 1
          do 25, i = 1, mfil
             if ((iunit(i).gt.0).and.(iunit(i).ne.5)) then 
                inquire(unit = iunit(i), opened=open)
                if (open) then
                   close(iunit(i))
                   iunit(i) = 0
                   files(i) = ' '
                endif 
             endif 
 25       continue 
          return
       end if
c  read next line from current input file
 100   continue
cc       print*, 'rdline 100: nfil , files(nfil), iunit = ',
cc     $      nfil,files(nfil)(:20), iunit(nfil)
       line   = ' '
       read(iunit(nfil),'(a)', err =1000, end = 500) line
c
c  check if command line is 'include filename'.
c  if so, open that file, and put it in the files stack
       call untab(line)
       call triml(line)
       if (iscomm(line)) go to 100
       nwords = mwords
       words(2) = ' '
       call bwords(line, nwords, words)
       call lower(words(1))
       if (((words(1) .eq. 'include').or.(words(1) .eq. 'load'))
     $      .and. (nwords .gt. 1)) then
          nfil = nfil + 1
          if (nfil .gt. mfil) go to 2000
          call getfln(words(2), files(nfil), ierr)
          if (ierr. ne. 0) go to 2400
c  test for recursion:
          do 400 i = 1, nfil - 1
             if (files(nfil) .eq. files(i)) go to 3000
 400      continue
          call openfl(iunit(nfil), files(nfil), stat, iexist, ierr)
          if (iexist .lt. 0) go to 2600
          if (ierr   .lt. 0) go to 2800
          go to 100
       end if
       return
c
c  end-of-file for command line file: drop nfil by 1,
c  return to get another command line
 500   continue
       inquire(unit = iunit(nfil), opened=open)
       if (open .and. (iunit(nfil) .ne. 5)) then
          close(iunit(nfil))
       end if
       iunit(nfil) = 0
       files(nfil) = ' '
       nfil = nfil - 1
       if (nfil.gt.0) go to 100
       line = 'read_line_end'
       return
c   error messages
 1000  continue
       call wlog(' # read error: general error')
       go to 4500
 2000  continue
       call wlog(' # read error: too many nested "include"s')
       write(errmsg, '(1x,a,i3)') ' # current limit is ', mfil
       ilen  = istrln(errmsg)
       call wlog(errmsg(1:ilen))
       go to 4500
 2400  continue
       call wlog(' # read error: cannot determine file name')
       go to 4500
 2600  continue
       call wlog(' # read error: cannot find file')
       go to 4500
 2800  continue
       call wlog(' # read error: cannot open file')
       go to 4500
 3000  continue
       call wlog(' # read error: recursive use of file')
       go to 4500
 4500  continue
       errmsg = ' # >> file name = '//files(nfil)
       ilen   = istrln(errmsg)
       call wlog(errmsg(1:ilen) )
       line = 'read_line_error'
       return
c end subroutine read_line
       end
       subroutine getfln(strin, filnam, ierr)
c  strip off the matched delimeters from string, as if getting
c  a filename from "filename", etc.
       integer idel, iend, istrln, ierr
       character*(*) strin, filnam, tmp*144, ope*8, clo*8
       data ope, clo /'"{(<''[',  '"})>'']'/
c
       ierr  = 0
       tmp   = strin
       call triml(tmp)
       ilen  = istrln(tmp)
       idel  = index(ope,tmp(1:1))
       if (idel.ne.0) then
          iend = index(tmp(2:), clo(idel:idel) )
          if (iend.le.0) then
             ierr = -1
             iend = ilen 
          end if
          filnam = tmp(2:iend)
       else
          iend = index(tmp,' ') - 1
          if (iend.le.0) iend  = istrln(tmp) 
          filnam = tmp(1:iend)
       end if
       return
c end  subroutine getfln
       end
       subroutine openfl(iunit, file, status, iexist, ierr)
c  
c  open a file, 
c   if unit <= 0, the first unused unit number greater than 7 will 
c                be assigned.
c   if status = 'old', the existence of the file is checked.
c   if the file does not exist iexist is set to -1
c   if the file does exist, iexist = iunit.
c   if any errors are encountered, ierr is set to -1.
c
c   note: iunit, iexist, and ierr may be overwritten by this routine
       character*(*)  file, status, stat*10
       integer        iunit, iexist, ierr
       logical        opend, exist
c
c make sure there is a unit number and file name
       ierr   = -3
       iexist =  -1
       if (file .eq. ' ') return
       iexist = 0
       iunit  = nxtunt(iunit)
c
c if status = 'old', check that the file name exists
       ierr = -2
       stat =  status                          
       call lower(stat)
       if (stat.eq.'old') then
          iexist = -1
          inquire(file=file, exist = exist)
          if (.not.exist) return
          iexist = iunit
       end if
c 
c open the file
       ierr = -1
       open(unit=iunit, file=file, status=status, err=100)
       ierr = 0
 100   continue
       return
c end  subroutine openfl
       end
      subroutine setedg (a2, ihole)
      integer i, ihole
      character*2 a2, edglbl, edglbp
      dimension edglbl(0:29), edglbp(0:29)

      data edglbl / 'NO', 'K ', 'L1', 'L2', 'L3',
     3            'M1','M2','M3','M4','M5',
     4            'N1','N2','N3','N4','N5','N6','N7',
     5            'O1','O2','O3','O4','O5','O6','O7',
     6            'P1','P2','P3','P4','P5','R1' /
      data edglbp / '0', '1 ', '2', '3', '4',
     3            '5','6','7','8','9',
     4            '10','11','12','13','14','15','16',
     5            '17','18','19','20','21','22','23',
     6            '24','25','26','27','28','29' /

      ihole  = -1
      do 10 i = 0,29
  10     if (a2 .eq. edglbl(i) .or. a2 .eq. edglbp(i) ) ihole  = i
      if (ihole  .lt. 0) call par_stop('unknown EDGE')

      return
      end
      subroutine wrtall (nabs)
c     writes data stored in common blocks of allinp.h to 
c     all necessary input files for other modules.
c     version 1.0 written by Alexei Ankudinov, March 2001

c     Note: to add input variable one has to add it to the 
c        appropriate common block in allinp.h, properly initialize
c        it in subroutine iniall and modify subroutine wrtall
c        to write it to the appropriate input file.
c        (i.e. one has to make modifications in 3 places)

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
c={../RDINP/allinp.h
c     Common blocks with all input data
c     the common
cc    atoms.dat
      integer  natt
      integer iphatx(nattx)
      double precision  ratx(3,nattx)
      common /geom/ ratx, iphatx, natt
cc    geom.dat
c       integer  nat
c       integer iatph(0:nphx)
c       integer iphat(natx)
c       double precision  rat(3,natx)
c       common /geom/ ratx, iphatx, natt
cc    global.inp
c       configuration average
      integer iphabs
c     global polarization data
      integer  ipol, ispin, le2
      double precision evec(3), xivec(3), spvec(3), elpty,angks,rclabs
      complex*16 ptz(-1:1, -1:1)
      common /global/ ptz, evec, xivec, spvec, elpty, angks, rclabs, 
     1     ipol, ispin, le2, iphabs
c     c    mod1.inp
      character*80 title(nheadx)
c     integer mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec,
      integer mpot, nph, ntitle, ihole, ipr1, iafolp, iunf,
     1     nmix, nohole, jumprm, inters, nscmt, icoul, lfms1
      integer iz(0:nphx)
      integer lmaxsc(0:nphx)
      real rfms1
      double precision gamach, rgrd, ca1, ecv, totvol
      double precision  xnatph(0:nphx), folp(0:nphx), spinph(0:nphx)
      double precision  xion(0:nphx)
c     for OVERLAP option
      integer novr(0:nphx), iphovr(novrx,0:nphx), nnovr(novrx,0:nphx)
      double precision  rovr(novrx,0:nphx)
      common /mod1/ title, xion, xnatph, spinph, folp, gamach, rgrd,
     1     ca1, ecv, totvol, rovr, rfms1, iz, lmaxsc, mpot, nph, ntitle,
     2     ihole, ipr1, iafolp, nmix,nohole,jumprm, inters,
     3     nscmt, icoul, lfms1, novr, iphovr, nnovr, iunf
c     c    ldos.inp
      integer mldos, lfms2
      double precision emin, emax, eimag, rfms2
      common /mod7/ emin, emax, eimag, rfms2, mldos, lfms2
cc    mod2.inp
c     integer mphase, ipr2, ixc, ixc0, vr0, vi0, ispec, lreal, lfms2
      integer mphase, ipr2, ixc, ixc0, ispec, lreal, l2lp, iPlsmn
      integer lmaxph(0:nphx), iGrid
      character*6  potlbl(0:nphx)
c     double precision rgrd, rfms2, gamach, xkstep, xkmax, vixan
      double precision xkstep, xkmax, vixan, vr0, vi0
      common /mod2/ xkstep, xkmax, vixan, vr0, vi0, 
     &     lmaxph, mphase, ipr2, ixc, ixc0, ispec, lreal, l2lp,
     &     izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis, iPlsmn,
     &     iGrid, potlbl
c     c    mod3.inp
      integer mfms, idwopt, minv
c     integer lmaxph(0:nphx)
c     real rfms2, rprec, rdirec, toler1, toler2
      real rprec, rdirec, toler1, toler2
      double precision   tk, thetad, sig2g
      common /mod3/ tk, thetad, sig2g, rprec, rdirec, toler1,
     1       toler2,  mfms, idwopt, minv
c     c    mod4.inp
      integer  mpath, ms, nncrit, nlegxx, ipr4
c     real critpw, pcritk, pcrith,  rmax, rfms2
      real critpw, pcritk, pcrith,  rmax
      common /mod4/ critpw, pcritk, pcrith,  rmax,
     1       mpath, ms, nncrit, nlegxx, ipr4
c     c    mod5.inp
      integer  mfeff, ipr5, iorder
      logical  wnstar
      double precision critcw
      common /mod5/ critcw, mfeff, ipr5, iorder, wnstar
c     c    mod6.inp
c     integer  mchi, ispec, idwopt, ipr6, mbconv
c     double precision  vrcorr, vicorr, s02, alphat, sig2g
      integer  mchi, ipr6, mbconv, absolu !KJ added absolu 3-06
      double precision  vrcorr, vicorr, s02, alphat, thetae
      common /mod6/ vrcorr, vicorr, s02, alphat, thetae, 
     &     mchi, ipr6, mbconv, absolu   !KJ added absolu 3-06
c     c    so2.inp  
      integer  mso2conv, ipse, ipsk
      double precision wsigk, cen
      character(12) cfname
      common /so2/ wsigk, cen, cfname, mso2conv, ipse, ipsk
      
c     c    eels.inp
c     EELS variables  !KJ 1-06 this section added for ELNES, EXELFS, MAGIC cards
      real*8 ebeam, aconv, acoll, thetax, thetay, emagic
      integer eels, relat, aver, cross, iinput,spcol
      integer nqr,nqf,magic
      integer ipmin,ipmax,ipstep
      common /eelsva/ ebeam,aconv,acoll,thetax,thetay,emagic,magic,
     &     nqr, nqf, aver, cross, relat, iinput, spcol,ipmin, ipmax,
     &     ipstep, eels
c     !KJ end
	
c= ../RDINP/allinp.h}

      if (.not. master) return

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)

cc    atoms.dat to be read by ffsort,
cc    that will write smaller geom.dat file
      open (file='atoms.dat', unit=3, status='unknown',iostat=ios)
        write (3, 35) natt
  35    format ('natx =  ', i7)
        write (3, 10) '    x       y        z       iph  '
        do 40  iat = 1, natt
          write(3,36) ratx(1,iat), ratx(2,iat), ratx(3,iat), iphatx(iat)
  36      format( 3f13.5, i4)
  40    continue
      close(3)

cc    global.inp
      open (file='global.dat', unit=3, status='unknown',iostat=ios)
c       configuration average data
        write (3, 10) ' nabs, iphabs - CFAVERAGE data'
        write (3, 45) nabs, iphabs, rclabs
  45    format ( 2i8, f13.5)
c       global polarization data
        write (3,10) ' ipol, ispin, le2, elpty, angks'
        write (3, 50)  ipol, ispin, le2, elpty, angks
  50    format ( 3i5, 2f12.4)
        write (3, 10) 'evec         xivec        spvec'
        do 60 i = 1,3
          write (3,30) evec(i), xivec(i), spvec(i)
  60    continue
        write (3, 10) ' polarization tensor '
        do 70 i = -1, 1
          write(3,30) dble(ptz(-1,i)), dimag(ptz(-1,i)), dble(ptz(0,i)),
     1                dimag(ptz(0,i)),  dble(ptz(1,i)), dimag(ptz(1,i))
  70    continue
      close(3)
        
cc    mod1.inp
      open (file='mod1.inp', unit=3, status='unknown',iostat=ios)
        write(3,10) 'mpot, nph, ntitle, ihole, ipr1, iafolp, ixc,ispec'
        write(3,20) mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec
        write(3,10) 
     1  'nmix, nohole, jumprm, inters, nscmt, icoul, lfms1, iunf'
        write(3,20)  nmix, nohole, jumprm, inters, nscmt, icoul, lfms1,
     1   iunf
        do 110 ititle = 1, ntitle
  110   write(3,10) title(ititle)
        write(3,10) 'gamach, rgrd, ca1, ecv, totvol, rfms1'
        write(3,30)  gamach, rgrd, ca1, ecv, totvol, rfms1
        write(3,10) ' iz, lmaxsc, xnatph, xion, folp'
  120   format ( 2i5, 4f13.5)
        do 130 ip = 0, nph
  130   write(3,120) iz(ip), lmaxsc(ip), xnatph(ip), xion(ip), folp(ip)
c       for OVERLAP option
        write(3,10) 'OVERLAP option: novr(iph)'
        write(3,20) ( novr(iph), iph=0,nph)
        write(3,10) ' iphovr  nnovr rovr '
  140   format ( 2i5, f13.5)
        do 150 iph = 0, nph
        do 150 iovr = 1, novr(iph)
  150   write(3,140) iphovr(iovr, iph), nnovr(iovr,iph), rovr(iovr,iph)
      close(3)
cc    mod2.inp
      open (file='mod2.inp', unit=3, status='unknown',iostat=ios)
c     Josh - added flag for PLASMON card (iPlsmn = 0, 1, or 2)
!     Josh - added flag for user difined grid (EGRID card).
        write(3,10) 'mphase,ipr2,ixc,ixc0,ispec,lreal,lfms2,nph,l2lp,
     &     iplsmn,igrid'
        write(3,20)  mphase,ipr2,ixc,ixc0,ispec,lreal,lfms2,nph,l2lp,
     &        iPlsmn, iGrid
        write(3,10) 'vr0, vi0'
        write(3,30)  vr0, vi0
        write(3,10) ' lmaxph(0:nph)'
        write(3,20)  (lmaxph(iph),iph=0,nph)
        write(3,10) ' potlbl(iph)'
        write(3,170)  (potlbl(iph),iph=0,nph)
  170   format (13a6)
        write(3,10) 'rgrd, rfms2, gamach, xkstep, xkmax, vixan'
        write(3,30)  rgrd, rfms2, gamach, xkstep, xkmax, vixan
        write(3,30)  (spinph(iph),iph=0,nph)
        write(3,20)  izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis
      close(3)
cc    mod3.inp
      open (file='mod3.inp', unit=3, status='unknown',iostat=ios)
        write(3,10) 'mfms, idwopt, minv'
        write(3,20)  mfms, idwopt, minv
        write(3,10) 'rfms2, rdirec, toler1, toler2'
        write(3,30)  rfms2, rdirec, toler1, toler2
        write(3,10) 'tk, thetad, sig2g'
        write(3,30)  tk, thetad, sig2g
        write(3,10) ' lmaxph(0:nph)'
        write(3,20)  (lmaxph(iph),iph=0,nph)
      close(3)
cc    mod4.inp
      open (file='mod4.inp', unit=3, status='unknown',iostat=ios)
        write(3,10) 'mpath, ms, nncrit, nlegxx, ipr4'
        write(3,20)  mpath, ms, nncrit, nlegxx, ipr4
        write(3,10) 'critpw, pcritk, pcrith,  rmax, rfms2'
        write(3,30)  critpw, pcritk, pcrith,  rmax, rfms2
      close(3)
cc    mod5.inp
      open (file='mod5.inp', unit=3, status='unknown',iostat=ios)
        write(3,10) 'mfeff, ipr5, iorder, critcw, wnstar'
        write(3,180)  mfeff, ipr5, iorder, critcw, wnstar
  180   format ( 2i4, i8, f13.5, L5)
      close(3)
cc    mod6.inp
      open (file='mod6.inp', unit=3, status='unknown',iostat=ios)
        write(3,10) 'mchi, ispec, idwopt, ipr6, mbconv, absolu' !KJ added absolu 3-06
        write(3,20)  mchi, ispec, idwopt, ipr6, mbconv, absolu !KJ added absolu 3-06
        write(3,10) 'vrcorr, vicorr, s02, critcw'
        write(3,30)  vrcorr, vicorr, s02, critcw
        write(3,10) 'tk, thetad, alphat, thetae, sig2g'
        write(3,30)  tk, thetad, alphat, thetae, sig2g
      close(3)
cc    so2.inp - Josh Kas
      open (file='s02.inp', unit=3, status='unknown',iostat=ios)
        write(3,10) 'mso2conv, ipse, ipsk'
        write(3,20)  mso2conv, ipse, ipsk
        write(3,10) 'wsigk, cen'
        write(3,30) wsigk, cen
        write(3,10) 'ispec, ipr6'
        write(3,20)  ispec, ipr6
        write(3,10) 'cfname'
        write(3,10) cfname
      close(3)
      return
      end
c     sub-pro exchange point
!     program ffmod1
      subroutine ffmod1

c     calculate  el. density and potential given atomic positions for
c     cluster atoms or other similar information
c     calculation can vary in complexity: self-consistency (on/off),
c     spin dependency (on/off), etc..
c       coded by a.l. ankudinov 2000, for modular code structure
c       modified by a.l. ankudinov 2001, for new i/o structure

c     INPUT files: mod1.inp, geom.dat
c     OUTPUT file: pot.bin

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
      real*8 wall_start, wall_end

c     use feff8.2 manual to get more information about each CARD
cc    mod1.inp
        character*80 title(nheadx)
        integer mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec,
     1     iunf, nmix, nohole, jumprm, inters, nscmt, icoul, lfms1
        integer iz(0:nphx), lmaxsc(0:nphx)
        real rfms1
        double precision gamach, rgrd, ca1, ecv, totvol
        double precision  xnatph(0:nphx), folp(0:nphx),  xion(0:nphx)
c       CONTROL mpot
c       RGRID  rgrd
c       TITLE title
c        ntitle: number of title lines(default:0)
c        title:  title lines(default:none)
c       PRINT   ipr1:   print option (default:0)
c       EXAFS, XANES, DANES, FPRIME, XES
c        ispec: type of spectroscopy (default:0-EXAFS)
c       NOHOLE: turn on/off core-hole potential
c       HOLE  ihole: index of core-hole orbital
c        gamach: core hole lifetime
c       POTENTIALS card
c        nph  - number of different potential types(default:1)
c        iz - nicleus charge for each potential charge(default:none)
c        lmaxsc - max orb momentum to calculate (default:3)
c        xnatph - relative amount of atoms of each type (default:1)
c       ION card
c        xion - total initial charge for each potential type
c               (iz + el.charge) which might be fractional (default:0)
c       EXCHANGE card: ixc=2 for potential calculation
c       JUMPRM: turn on potential jump removal at mt radius (default:0)
c       AFOLP iafolp: turn on/off automatic overlap of muffintin spheres
c       FOLP  folp: manual setting for overlapping muffin-tin spheres
c       INTERSTITIAL inters (default:0)  totvol (default:0)
c       SCF rfms1 lfms1 nscmt ca1 nmix ecv  icoul 
c       OVERLAP geometry ( rarely used for EXAFS calculations only)
        integer novr(0:nphx), iphovr(novrx,0:nphx), nnovr(novrx,0:nphx)
        double precision  rovr(novrx,0:nphx)

cc    geom.dat
        integer  nat, iatph(0:nphx), iphat(natx)
        double precision  rat(3,natx)
c       ATOM card
c         nat: number of atoms in a clsuter
c         rat: x,y,z coordinates of all atoms
c         iphat: which potential type correspond to each atom
c         iatph: index of representative atom for each potential type

      call par_begin

c     Initialize clock
      call seconds(wall_start)
      wall_comm = 0.0

c     open the log file, unit 11.  See subroutine wlog.
      if (master) then
        open (unit=11, file='log1.dat', status='unknown', iostat=ios)
        call chopen (ios, 'log1.dat', 'feff')
      else
        par_type = 2
      endif


c     INPUT: read data in pot.inp  and geom.dat files
c     and transform it to atomic hartree units
      call reapot (mpot, rgrd, ntitle, title, ipr1, ispec,
     1           nohole, ihole, gamach, nph, iz, lmaxsc, xnatph,
     2           xion, iunf, ixc, jumprm, iafolp, folp, inters, totvol,
     3           rfms1, lfms1, nscmt, ca1, nmix, ecv, icoul,
     4           novr, iphovr, nnovr, rovr,
     5           nat, rat, iphat, iatph)

      if (mpot .eq. 1)  then
         call wlog(' Calculating potentials ...')
         call pot (rgrd, nohole,
     $             inters, totvol, ecv, nscmt, nmix, ntitle, title,
     $             nat, nph, ihole, gamach, iafolp,
     $             ixc, iphat, rat, iatph,
     $             xnatph, novr,
     $             iphovr, nnovr, rovr, folp, xion, iunf, iz, ipr1,
     $             ispec, jumprm,
     $             lmaxsc, icoul, ca1, rfms1, lfms1)
      endif

c     OUTPUT: subroutine pot writes main output file pot.bin
c     with information on potentials, necessary for other modules;
c     additional output files can be obtained using PRINT card

      if (master) close (unit=11)

c--   Time at end of run
      call seconds(wall_end)
      if (master .and. parallel_run) then
	write (6,*) 'total time    ', wall_end - wall_start
	write (6,*) 'communicate time', wall_comm
      endif
      call par_end

c     sub-pro exchange point
!     stop
      return
      end
      subroutine afolp ( nph, nat, iphat, rat, iatph, xnatph,
     1                novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1                edens, edenvl,
     2                dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm, 
     2                ixc, rhoint, vint, rs, xf, xmu, xmunew,
     3                rnrmav, qtotel, inters, totvol)

c     find folp(iph) automatically and recalculates
c     interstitial parameters, rmt, vint, etc.
c     written by ala 11.97
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension iphat(natx)
      dimension rat(3,natx)
      dimension iatph(0:nphx)
      dimension xnatph(0:nphx)
      dimension novr(0:nphx)
      dimension iphovr(novrx,0:nphx)
      dimension nnovr(novrx,0:nphx)
      dimension rovr(novrx,0:nphx)
      dimension folp(0:nphx), folpx(0:nphx)
      dimension edens(251,0:nphx), edenvl(251,0:nphx)
      dimension dmag(251,0:nphx+1)
      dimension vclap(251,0:nphx)
      dimension vtot (251,0:nphx), vvalgs (251,0:nphx)
      dimension imt(0:nphx)
      dimension inrm(0:nphx)
      dimension rmt(0:nphx), rmtx(0:nphx)
      dimension rnrm(0:nphx)
      character*512 slog

      do 5 iph=0,nph
         rmtx(iph) = rmt(iph) / folp(iph)
   5  continue

      call wlog(' iph, rnrm(iph)*bohr, rmt(iph)*bohr, folp(iph)')
      if (iafolp.ge.0) then
         do 400  iph = 0, nph
c          old algorithm for automatic overlap
c          folp(iph) = 1 + 0.7*(rnrm(iph)/rmt(iph) - 1)
           folp(iph) = folpx(iph)
           rmt(iph) = folp(iph) * rmtx(iph)

  398      format(i5, 1p, 3e13.5)
           write(slog,398) iph, rnrm(iph)*bohr, rmt(iph)*bohr, folp(iph)
           call wlog(slog)
  400    continue

         idmag = 0
         call istprm (nph, nat, iphat, rat, iatph, xnatph,
     1               novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1               edens, edenvl, idmag,
     2               dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3               ixc, rhoint,vint, rs, xf, xmu, xmunew,
     4               rnrmav, qtotel, inters, totvol)

      endif

      return
      end
      subroutine broydn( iscmt, ca, nph, xnvmu,
     1          ilast, xnatph, rnrm, qnrm, edenvl, rhoval, dq)
c     calculates new density using Broyden algorithm
c     (J.Phys.A, 17,L317(1984))
c     
c      Also handes the charge inside each norman sphere properly.
c     INPUT:
c       ca     - convergence accelerator factor
c       rhoval - new density from integration up to mu
c       edenvl - old valence density
c       qnrm   - the charge inside each norman sphere
c       xnvmu  - valence electron counts in getorb.f
c       also some information from feff.inp file.(nph,etc.)
c     Output:
c       rhoval - new valence density after mixing
c                notice that at input rhoval = density*4*pi*r**2
c       dq     - change of the charge inside each norman sphere
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension ilast(0:nphx),xnatph(0:nphx), xnvmu(0:lx, 0:nphx+1)
      dimension ri05(251)
      dimension rhoval(251,0:nphx+1), edenvl(251,0:nphx)
      dimension dq(0:nphx)
      dimension qnrm(0:nphx), rnrm(0:nphx)

c     work space
      dimension xpc(251)
c     work space for Broyden algorithm
      parameter (nbr=30)
      dimension cmi(nbr,nbr), frho(251,0:nphx,nbr), urho(251,0:nphx,nbr)
      dimension xnorm(nbr), wt(251), rhoold(251,0:nphx)
      save cmi, frho, urho, xnorm, wt, rhoold, ri05

c     make  radial grid with 0.05 step
      dx05=0.05d0
      if(iscmt.eq.1) then
        do 10 i=1,251
           ri05(i) = exp(-8.8+dx05*(i-1))
           wt(i) = ri05(i)**3
  10    continue
      endif

c     record F(\rho_i)
      do 30 iph = 0, nph
      do 30 ir = 1, ilast(iph)
        frho(ir,iph,iscmt)=rhoval(ir,iph)*ri05(ir)-edenvl(ir,iph)*wt(ir)
  30  continue

c     dq here is set to the total number of valence electron for
c     the initial (atomic overlap) density inside corresponding
c     norman sphere, and xnferm is  the total number for the cluster.
      xnferm = 0
      do 330 ip= 0,nph
        dq(ip) = 0
        do 320 il = 0,lx
         dq(ip) = dq(ip) + xnvmu(il, ip)
 320    continue
        xnferm = xnferm + dq(ip)*xnatph(ip)
 330  continue 

      if (iscmt.gt.1) then
c       get normalization factor
        xnorm(iscmt) = 0
        do 510 iph = 0, nph
        do 510 ir = 1,ilast(iph)
          xnorm(iscmt) = xnorm(iscmt) +
     1    (frho(ir,iph,iscmt)-frho(ir,iph,iscmt-1))**2
  510   continue

c       calculate c_m,i
        do 530 j = 2, iscmt
          cmi(iscmt,j) = 0
          do 520 iph = 0, nph
          do 520 ir = 1,ilast(iph)
            cmi(iscmt,j) = cmi(iscmt,j) + frho(ir,iph,iscmt) *
     1      (frho(ir,iph,j)-frho(ir,iph,j-1))
  520     continue
          cmi(iscmt,j) = cmi(iscmt,j)/xnorm(j)
  530   continue

c       calculate U_i - vector of lagrange multipliers
        do 550 iph = 0, nph
        do 550 ir = 1,ilast(iph)
         urho(ir,iph,iscmt)=ca*(frho(ir,iph,iscmt)-frho(ir,iph,iscmt-1))
     1     + (edenvl(ir,iph) - rhoold(ir,iph))*wt(ir)
  550   continue

        do 570 j = 2, iscmt-1
        do 570 iph = 0, nph
        do 570 ir = 1,ilast(iph)
          urho(ir,iph,iscmt)= urho(ir,iph,iscmt) - urho(ir,iph,j) *
     1      (cmi(iscmt,j)-cmi(iscmt-1,j))
  570   continue
      endif

c     construct new density, finally
      do 600 iph = 0, nph
      do 600 ir = 1, ilast(iph)
        rhoold(ir,iph) = edenvl(ir,iph)
        rhoval(ir,iph) = edenvl(ir,iph) + ca*frho(ir,iph,iscmt)/wt(ir)
        do 610 j = 2, iscmt
  610   rhoval(ir,iph)=rhoval(ir,iph)-cmi(iscmt,j)*urho(ir,iph,j)/wt(ir)
  600 continue

c     calculate e charge inside norman sphere
c     dq - extra number of e (charge transfer) 
      x0 = 8.8d0
      dqav=0.0d0
      xnat = 0.d0
      do 700 iph = 0, nph
        jnrm =  (log(rnrm(iph)) + x0) / dx05  +  2
        i0=jnrm+1
        xirf = 2
        do 710 ir = 1, ilast(iph)
           xpc(ir) = rhoval(ir,iph)*ri05(ir)**2
  710   continue
        call somm2 (ri05, xpc, dx05, xirf, rnrm(iph),0,i0)
c       dq is how many new electrons are within norman sphere
        dq(iph) = xirf - qnrm(iph) - dq(iph)
        dqav=dqav+xnatph(iph)*dq(iph)
        xnat = xnat + xnatph(iph)
  700 continue


c     to keep charge neutrality add/subtract part of previous density
      aa = dqav/xnferm
      dqav=dqav/xnat
      do 800 iph = 0, nph
        dq(iph) = dq(iph) - dqav
        qnrm(iph) = qnrm(iph) + dq(iph)
        do 810 ir = 1, ilast(iph)
  810   rhoval(ir,iph) = rhoval(ir,iph) - aa*edenvl(ir,iph)
  800 continue

      return
      end
      subroutine corval ( ecv, xnvmu, eorb, norb, xnval, kappa, rgrd,
     1             nohole, nph, edens, edenvl, vtot, vvalgs,
     1             rmt, rnrm, ixc, rhoint, vint, jumprm,
     2             x0, ri, dx, xion, iunf, iz,
     3             adgc, adpc, dgc, dpc, ihole, lmaxsc)

c     Finds the core-valence separation for the cluster of atoms.
c     written by ala 10 1998

c     Input: necessary atomic data and the muffin-tin potential data
c     Output:
c          xnvmu - number of valence atoms for each channel
c          ecv   - core-valence separation energy
c     Algorithm:
c       definite valence electron - above -20 eV;
c       definite core electrons   - below -70 ev;
c       first find suspicious points in LDOS (central atom only)
c       between -20 and -70, which are written in eldos array
c       After sorting, the lowest valence state is found and
c       all core states above this energy are reassigned to valence.
c       The "ecv" should be between the lowest valence energy and
c       the highest core level. Also it should be far enough 
c       (see variable tol) from both of the above levels and V_int.
c       If fails to find "ecv" for a given core-valence separation,
c       then the highest core level is reassigned to valence and
c       attempt to find "ecv' is repeated.

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}

c     input
      dimension dmagx(nrptx), dmag0(251)
      dimension vtot (251,0:nphx), vvalgs (251,0:nphx)
      dimension xnvmu(0:lx,0:nphx+1), rmt(0:nphx),rnrm(0:nphx)
      dimension ri(nrptx), ri05(251)
      dimension iz(0:nphx), xion(0:nphx),xnval(30,0:nphx)
      dimension norb(0:nphx), kappa(30,0:nphx), iiorb(0:lx,0:nphx)
      dimension eorb(30,0:nphx), eldos(0:lx,0:nphx)
      dimension lmaxsc(0:nphx), ival(0:lx, 0:nphx), ifound(0:lx)
c     input and output
      dimension edens(251,0:nphx), edenvl(251,0:nphx)

c     work space
      dimension dum(nrptx), vtotph(nrptx),vvalph(nrptx)
      dimension dgc(251,30,0:nphx+1), dpc(251,30,0:nphx+1)
      dimension adgc(10,30,0:nphx+1), adpc(10,30,0:nphx+1)
      dimension dgcn(nrptx,30), dpcn(nrptx,30)
      complex*16 xrhoce(0:lx)
      complex*16 xrhole(0:lx)
      complex*16 yrhoce(251)
      complex*16 yrhole(251,0:lx)
      complex*16 ph(lx+1)
c     dimension 32 = (0:lx)*(0:nphx)
      dimension en(32)
      integer ll(32), ip(32), icv(32)
      complex*16 emg, eref, eimag
      dimension xp(0:lx), xpeak(0:lx)
c     stuff from feff.f for rdinp, pathfinder and genfmt
c     Following passed to pathfinder, which is single precision.
      character*512 slog
      logical ok

      write (slog,10) 
  10  format('              Core-valence separation ')
      call wlog(slog)

c     initialize staff
      do 15 i= 1,251
        dmag0(i) = 0.d0
  15  ri05(i) = exp (-8.8+0.05*(i-1))
      do 20 iph = 0, nphx
      do 20 il = 0, lx
         eldos(il, iph) = 0
         iiorb(il, iph) = 0
         ival(il, iph) = 0
  20  continue

      tol = 5.0d0/hart
      if (vint - ecv.lt.tol) ecv = vint - tol
      elow = -70.0d0/hart
      ehigh = -20.0d0/hart
      eimag = coni*1.5/hart
c     make energy step about 0.5 eV
      ne = 1 + nint((ehigh-elow)*2*hart)
      de = (ehigh-elow)/(ne-1)

c     find out problematic energies for core-valence separation
      do 100 iph = 0, nph
      do 100 iorb = 1, norb(iph)
        if (eorb(iorb,iph).lt.ehigh-tol.and.eorb(iorb,iph).gt.elow) then
          lll = -kappa(iorb,iph) - 1
          if (lll.lt.0) lll = kappa(iorb,iph)
c        skip in special case for Hf,Lu,Ta; treat f-electrons as valence
c        or as core according to UNFREEZEF
          if((iz(iph).ge.71.and.iz(iph).le.73) .and. lll.eq.3) goto 100
          if(iunf.eq.0 .and. lll.eq.3) goto 100

          eldos(lll,iph) = eorb(iorb,iph)
          ival(lll,iph) = 1
          if (xnval(iorb,iph).lt. 0.1) ival(lll,iph)=-1
          iiorb(lll,iph) = iorb
        endif
  100 continue

      do 500  iph = 0, nph
         call fixvar (rmt(iph),edens(1,iph),vtot(1,iph),dmag0,
     1                vint, rhoint, dx, rgrd, jumprm,
     2                vjump, ri, vtotph, dum, dmagx)
         if (mod(ixc,10) .ge.5) then
            if (jumprm .gt. 0) jumprm = 2
            call fixvar (rmt(iph), edenvl(1,iph), vvalgs(1,iph),
     1                dmag0, vint, rhoint, dx, rgrd , jumprm,
     2                vjump, ri, vvalph, dum, dmagx)
            if (jumprm .gt. 0) jumprm = 1
         endif
         call fixdsx (iph, dx, rgrd , dgc, dpc, dgcn, dpcn)

         jri = (log(rmt(iph)) + x0) / rgrd + 2
         jri1 = jri+1
         eref = vtotph(jri1)
         do 40 i = 1, jri1
  40     vtotph(i) = vtotph(i) - eref
         if (ixc.ge.5) then
           do 50 i = 1, jri1
  50       vvalph(i) = vvalph(i) - eref
         else
           do 60 i = 1, jri1
  60       vvalph(i) = vtotph(i)
         endif
         itmp = 0
         if (iph.eq.0 .and. nohole.lt.0) itmp = ihole

         xx = dimag(eimag)
         nfound = 0
         do 80 il = 0,lx
           xpeak(il) = (2*il+1.d0)/(6*xx*pi)
           xp(il) = 0
           ifound(il) = 1
           if (ival(il,iph).ne.0) ifound(il) = 0
           nfound = nfound + ifound(il)
  80     continue
         if (nfound .eq. lx+1) goto 500

c        start the search for suspicious maxima in LDOS for iph
         ie = 0
  200    ie=ie + 1
            emg = elow + de*(ie-1) + eimag
            call rholie( ri05, nr05, rgrd, x0, ri, emg,
     2           ixc, rmt(iph), rnrm(iph),
     3           vtotph, vvalph, xnval(1,iph), dgcn, dpcn, eref,
     4           adgc(1,1,iph), adpc(1,1,iph), xrhole,
     5           xrhoce, yrhole, yrhoce, ph,
     6           iz(iph), xion(iph), iunf, itmp,lmaxsc(iph))

c           find the suspicious peaks on ldos and correct the energy
            nfound = 0
            do 400 il = 0, lx
               if (ival(il,iph).ne.0 .and. ifound(il).eq.0) then
c                suspicious ldos; find the first peak in ldos that
c                contains more than 1 electron is not found yet
                 xx = dimag(xrhoce(il))
                 if ((ie.eq.ne .or. xx.lt.xp(il)) .and.
     1                xp(il).gt.xpeak(il)) then
                   ifound(il) = 1
                   eldos(il,iph) = elow + de*(ie-2)
c      print*,iph,' approx count is ',xp(il)*pi*dimag(eimag),' in l=',il
                 else
                   xp(il) = xx
                 endif
               endif
               nfound = nfound + ifound(il)
  400       continue
         if (nfound.lt.lx+1 .and. ie.lt.ne) goto 200

         if (nfound.lt.lx+1) then 
            call wlog ('WARNING: fatal error in subroutine corval. Try')
            call wlog ('  to reduce ca1 in SCF card. If does not help,')
            call wlog ('SEND bug report to AUTHORS')
            call par_stop('CORVAL-1')
         endif
  500 continue

c     arrange suspicious levels in order
      ne = 0
      do 600 iph = 0,nph
      do 600  il = 0, lx
         if (eldos(il,iph) .lt. 0) then
            ne = ne + 1
c           find in which position to put the new energy
            inew = ne
            do 580 ie = 1,ne-1
               if (en(ie).gt.eldos(il,iph) .and. inew.eq.ne) inew = ie
  580       continue
            do 590 ie = ne-1,inew, -1
               en(ie+1) = en(ie)
               icv(ie+1) = icv(ie)
               ll(ie+1) = ll(ie)
               ip(ie+1) = ip(ie)
  590       continue
            en(inew) = eldos(il,iph)
            icv(inew) = ival(il,iph)
            ll(inew) = il
            ip(inew) = iph
         endif
  600 continue

c     goto exit if there is no suspicious points
      if (ne.eq.0) goto 999
 
c     find the highest core and lowest valence energies
      ic = 0
      iv = ne + 1
      do 700 ie = 1,ne
         if (icv(ie).eq.-1) then
            ic = ie
         else
            if (ie.lt.iv) iv = ie
         endif
  700 continue

c     change assignment from core to valence, if core state above lowest
c     valence
      do 720 ie=iv+1,ic
        if (icv(ie).lt.0) then
           iph = ip(ie)
           icv(ie) = 1
           ival(ll(ie),iph) = 1
c          update occupation number
           xnvmu(ll(ie), iph) = xnvmu(ll(ie), iph) + 4*ll(ie)+2
c          update valence density
           iorb = iiorb(ll(ie),iph)

           do 710 ir = 1,251
             edenvl(ir,iph) =  edenvl(ir,iph) + 2*(ll(ie)+1)*
     1       (dgc(ir,iorb,iph)**2 + dpc(ir,iorb,iph)**2)/ri05(ir)**2
             if (ll(ie).ne.0) then
               edenvl(ir,iph) =  edenvl(ir,iph) + 2*ll(ie)*
     1         (dgc(ir,iorb-1,iph)**2+dpc(ir,iorb-1,iph)**2)/ri05(ir)**2
             endif
  710      continue
        endif
  720 continue
      ic = iv - 1

c     check if suggested ecv is between core and valence
      ok = .false.
      if (ic.gt. 0) then
        if (iv.le.ne) then
          if (ecv-en(ic).gt.tol .and. en(iv)-ecv.gt.tol) ok = .true.
        else
          if (ecv-en(ic).gt.tol) ok = .true.
        endif
      else
        if (iv.le.ne) then
          if (en(iv)-ecv.gt.tol) ok = .true.
        endif
      endif
      if (ok) goto 999

  800 ecv = vint - tol
      if (iv.le.ne) ecv = min(ecv,en(iv)-tol)
      if (ic.eq.0) goto 899
      if (ecv-en(ic).gt.tol) goto 899

c     need to reassign the last core state to valence
      ic = ic - 1
      iv = iv - 1
      icv(iv) = 1
      ival(ll(iv),ip(iv)) = 1
      xnvmu(ll(iv),ip(iv)) =  xnvmu(ll(iv),ip(iv)) + 4*ll(iv)+2
c     update valence density
      iph = ip(iv)
      iorb = iiorb(ll(iv),iph)
      do 810 ir = 1,251
        edenvl(ir,iph) =  edenvl(ir,iph)+ 2*(ll(iv)+1)*
     1  (dgc(ir,iorb,iph)**2 + dpc(ir,iorb,iph)**2)/ri05(ir)**2
        if (ll(iv).ne.0) then
          edenvl(ir,iph) =  edenvl(ir,iph)+ 2*ll(iv)*
     1    (dgc(ir,iorb-1,iph)**2+dpc(ir,iorb-1,iph)**2)/ri05(ir)**2
        endif
  810 continue
      go to 800

899   continue
c     update the core valence separation in array xnval
c     need to do that for second call of 'corval' and for ixc=5,6
      do 900  ie = iv, ne
         iph = ip(ie)
         lll = ll(ie)
         iorb = iiorb(lll,iph)
         if (xnval(iorb,iph).lt.0.1) then
            xnval(iorb,iph) = 2*lll+2
            if (lll.gt.0) xnval(iorb-1,iph) = 2*lll
         endif
  900 continue

999   continue
      return
      end
      subroutine coulom( icoul, npot, ilast, rhoval, edenvl, edens,
     2     nat, rat, iatph, iphat, rnrm, dq, iz, vclap)
c     searches for fermi level in comlex energy plain and 
c     Output:
c       rhoval - new valence density
c       vclap  - coulomb potential
c       qnrm   - charge inside each norman sphere
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension ilast(0:nphx)
      dimension ri05(251)
      dimension rhoval(251,0:nphx+1), edenvl(251,0:nphx)
      dimension edens(251,0:nphx), dq(0:nphx), iz(0:nphx)
      dimension rat(3,natx), iatph(0:nphx), iphat(natx), rnrm(0:nphx)
      dimension vclap(251,0:nphx)

c     work space
      dimension  drho(251), dvcl(251)
      external dist

c     make  radial grid with 0.05 step
      dx05=0.05d0
      do 10 i=1,251
         ri05(i) = exp(-8.8+dx05*(i-1))
  10  continue

      do 600 ip=0,npot
        do 550 ir=1, ilast(ip)
           drho(ir)= (rhoval(ir,ip)-edenvl(ir,ip))*ri05(ir)**2
  550   continue
        call potslw(dvcl,drho, ri05,dx05, ilast(ip))

        do 560 ir = ilast(ip)+1, 251
           dvcl(ir) = 0.0d0
  560   continue

        if (icoul.eq. 1) then
c         find the change of coulomb potential at norman radius for
c         each type of iph
          jnrm = (log(rnrm(ip)) + 8.8) / 0.05  +  2
          dvnrm = dq(ip) / rnrm(ip)
          iat0 = iatph(ip)
          do 570 iat=1,nat
             if (iat.ne.iat0) then
               rr = dist( rat(1,iat), rat(1,iat0))
               if (rr.lt.rnrm(ip)) rr=rnrm(ip)
               dvnrm = dvnrm + dq(iphat(iat)) / rr
             endif
  570     continue

c         transfer condition to r(jnrm) instead of r_nrm.
          dr = ri05(jnrm) - rnrm(ip)
c         xx = dr/rnrm(ip)
c         correction using linear expansion of drho
c         neglecting terms xx**4 and higher
          bb = (drho(jnrm)-drho(jnrm-1)) / (ri05(jnrm)-ri05(jnrm-1))
c         dvnrm = dvnrm - xx* (dq(ip)/ri05(jnrm) + xx* (drho(jnrm)*
c    1    (rnrm(ip)/ri05(jnrm)-0.5) + xx*(drho(jnrm)-bb*rnrm(ip))/3 ))
          dvnrm = dvnrm - dr / 2 * ( dq(ip) / rnrm(ip)**2 + 
     1       (dq(ip)+drho(jnrm)*dr-bb/2*dr**2) / ri05(jnrm)**2 )


c         dvcl is calculated correct up to constant shift which is
c         fixed by the condition at R_nrm
          dvnrm = dvnrm - dvcl(jnrm)

        else
c         now this is default (icoul=0)
c         then do normalization based on norman picture
c         i.e. total density is approximated by a sum of densities
c          which are zero outside each norman sphere. use this
c         approximation only for the difference between 2 potentials
c         This is needed for infinite solid where the algorithm for
c         icoul=1 is unstable due to long range Coulomb potential
c         probably better fix will be to use Ewald summation to figure
c         out the Madelung constants (icoul=2 optinon to be done later).

          call frnrm (edens(1,ip), iz(ip), rnrm1)
          do 710 i = 1,251
  710     drho(i) = edens(i,ip) - edenvl (i,ip) +rhoval(i,ip)
          call frnrm (drho, iz(ip), rnrm2)
          rmin = min (rnrm1, rnrm2)
          inrm = (log(rmin) + 8.8) / 0.05  +  1
          r0 = ri05(inrm)

          delv = 0.d0
          if (rnrm2.gt.rnrm1) then
            aa = (drho(inrm+1)-drho(inrm)) / (ri05(inrm+1)-ri05(inrm))
            bb = drho(inrm) - aa * ri05(inrm)
            delv = delv - fab (aa, bb, r0, rnrm1, rnrm2)
          else
            aa = (edens(inrm,ip)-edens(inrm+1,ip))
     1           / (ri05(inrm+1)-ri05(inrm))
            bb = - edens(inrm,ip) - aa * ri05(inrm)
            delv = delv - fab (aa, bb, r0, rnrm2, rnrm1)
          endif
          aa = (drho(inrm+1)-drho(inrm)+edens(inrm,ip)-edens(inrm+1,ip))
     1          / (ri05(inrm+1)-ri05(inrm))
          bb = drho(inrm) - edens(inrm,ip) - aa * ri05(inrm)
          delv = delv - fab (aa, bb, r0, r0, rmin)

          dvnrm = delv - dvcl(inrm)
        endif

        do 580 ir=1,ilast(ip)
           vclap(ir,ip) = vclap(ir,ip) + dvcl(ir) + dvnrm 
  580   continue
        do 590 ir=ilast(ip)+1,251
  590   vclap(ir,ip)=0.0d0
  600 continue

      return
      end

      double precision function fab (aa,bb,r0,r1,r2)
c     it is the \int_r1^r2 dr 4\pi\rho(r) r**2 (1/r0 - 1/r)
c     where 4\pi\rho(r) = aa*r + bb
c     you arrive to this integral as a result of norman picture
c     for normalization of coulomb potential just below the rmin
      implicit double precision (a-h, o-z)

      a2 = (r2**2-r1**2)/2.d0
      a3 = (r2**3-r1**3)/3.d0
      a4 = (r2**4-r1**4)/4.d0
      fab = aa*(a4/r0-a3) + bb*(a3/r0-a2)
      return
      end

      subroutine ff2g (gtr, iph, ie, ilast, xrhoce, xrhole, xrhocp,
     1             ee, ep, yrhole, yrhoce,  yrhocp, rhoval, xnmues,
     2             xnatph, xntot, iflr, iflrp, fl, fr, iunf)
      implicit double precision (a-h, o-z)
c     the main output is l-dos in xrhoce, and valence density 
c     of states at distance r
c     in yrhoce, which at the input are only embedded atom quantities

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      complex*16 xrhoce(0:lx,0:nphx), xrhocp(0:lx,0:nphx)
      complex*16 yrhoce(251), yrhocp(251)
      complex*16 xrhole(0:lx)
      complex*16 yrhole(251,0:lx)
      complex gtr(0:lx)
      complex*16 ee, ep, del, der, fl, fr
      complex*16 cchi(0:lx)
      dimension xnmues(0:lx), rhoval(251)

c     chi from fms is contained in gtr
      do 200  j = 0, lx
         cchi(j) =  dble( real( gtr(j) )) + coni* dble(aimag( gtr(j) ))
  200 continue

      do 730 il = 0,lx
        xrhoce(il, iph)=xrhoce(il, iph)+
     1                       cchi(il)*xrhole(il) 
        if (ie.eq.1) xrhocp(il,iph) = xrhoce(il,iph)
  730 continue

      del = ee-ep
      der = del
c     if iflr=1 add/subtract integral from point to real axis
c     factor 2 below comes from spin degeneracy
      if (iflr.eq.1) der = der - coni * 2 * dimag(ee)
      if (iflrp.eq.1) del = del + coni * 2 * dimag(ep)
      do 750 il = 0, lx
        if (il.le.2 .or. iunf.ne.0) then
         fl = fl + 2 * xrhocp(il,iph) * xnatph
         fr = fr + 2 * xrhoce(il,iph) * xnatph
         xnmues(il) = xnmues(il) + 
     1        dimag( xrhoce(il,iph) * der + xrhocp(il,iph) * del )
         xntot = xntot + xnmues(il) * xnatph
        endif
  750 continue

cc    calculate r-dependent l-dos for later use
      do 840 il = 0,lx
      do 840 ir = 1,ilast
       if (il.le.2 .or. iunf.ne.0) then
        yrhoce(ir) = yrhoce(ir) + cchi(il)*yrhole(ir,il)
        if (ie.eq.1) yrhocp(ir) = yrhoce(ir)
       endif
  840 continue

      do 850 ir = 1, ilast
         rhoval(ir) = rhoval(ir) + dimag(yrhoce(ir)*der+yrhocp(ir)*del)
  850 continue

      return
      end
      subroutine frnrm (rho, iz, rnrm)
      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      dimension rho(nrptx)
         dimension xpc(251), ri(251)
c#mn
       external rr

c     finds norman radius

c     Need overlapped densities.  We'll get them in the form
c     4*pi*density = rho.  Also need z of atom

c     Then integrate out to the point where the integral of
c     4*pi*density*r**2 is equal to iz
      sum= (9*rho(1)*rr(1)**3+28*rho(2)*rr(2)**3+23*rho(3)*rr(3)**3)/480
c     add initial point (r=0) correction (see subroutine somm2)
      dpas = 0.05
      d1 = 3.0
      dd=exp(dpas)-1.0
      db=d1*(d1+1.0)*dd*exp((d1-1.0)*dpas)
      db=rr(1)/db
      dd=rr(1)*(1.0+1.0/(dd*(d1+1.0)))/d1
      sum = sum + dd*rho(1)*rr(1)**2 - db*rho(2)*rr(2)**2

      fl = rho(4) *rr(4)**3
      fr = rho(5) *rr(5)**3
      frr = rho(6) *rr(6)**3
      sum = sum + (25*fl + 12 *fr -frr)/480
      do 10  i = 7, nrptx
         fll = fl
         fl = fr
         fr = frr
         frr = rho(i) * rr(i)**3
         sumsav = sum
         sum = sum + (13*(fr+fl) -fll -frr)/480
         if (sum .ge. iz)  then
            inrm = i-2
            x= (iz-sumsav)/(sum-sumsav)
            goto 20
         endif
   10 continue
      call wlog(' FRNRM Could not integrate enough charge to reach' //
     1          ' required z.')
      call par_stop('FRNRM-1')
   20 continue
      rnrm = rr(inrm)*(1 + x*0.05)
     
c     add next order correction ALA 3/97
        dx05 = 0.05
        x0 = 8.8
        jnrm =  (log(rnrm) + x0) / dx05  +  2
        i0=jnrm+1
        xirf = 2
        do 710 ir = 1, jnrm+2
           ri(ir) = rr(ir)
           xpc(ir) = rho(ir)*ri(ir)**2
  710   continue

        call somm2 (ri, xpc, dx05, xirf, rnrm,0,i0)
c       dq is how many new electrons are within norman sphere
        dn1 = xirf-iz
        x2 = x - dn1/((1-x)*xpc(inrm) + x*xpc(inrm+1))
        if (abs(x2-x).gt.0.0001) then
          xirf = 2
          rnrm = rr(inrm)*(1 + x2*0.05)
          call somm2 (ri, xpc, dx05, xirf, rnrm,0,i0)
          dn2 = xirf-iz
c         Newton-Raphson methof to find zeroes
          x = x2 - dn2 * (x2-x)/(dn2-dn1)
        endif
        rnrm = rr(inrm)*(1 + x*0.05)

      return
      end
      subroutine  grids ( ecv, xmu, negx, neg, emg , step, nflrx)
c     makes a grid in complex e-plane for scmt calculation
c     add complications for complex cases later. ala
c     emg is comlex energy in hartrees
      implicit double precision (a-h, o-z)

      complex*16 emg(negx), eim, eimmin
      dimension step(nflrx)
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}

c     the choice of e_cv should be automated later
c     all l-dos should be zero at ecv
c     fix it by hand if needed below
c     for some complicated materials may need multiple e_cv
c     it may also depend on core-valence separation

c     eimmin = the lowest im energy to search for fermi level
c     may simulate Fermi distr for occ numbers, thus may want
c     to lower eimmin for low temperatures.
      eimmin = coni*0.05/hart
      neg1 = (nflrx+1)/2
      neg3 = nflrx - 1
      neg2mx = negx-neg1-neg3
c     never do calculations on real axis.
      eim = eimmin*neg1**2
      eim = eimmin 
      de = dimag(eim)/4

      do 10 i =1, neg1
c        step linearly increases as one get farther from real axis
         eim = eimmin *i**2
         emg(i) = ecv +eim
  10  continue
      step(nflrx) = dimag(eim)/4

c     set energy step for integration eim above real axis
      de = dimag(emg(neg1))/4
      neg2= nint((xmu-ecv)/de)
      if (neg2.gt.neg2mx) neg2=neg2mx
      if (neg2.lt.neg1) neg2 = neg1
      de = (xmu-ecv) / neg2
      do 20 i = neg1+1,neg1+neg2
  20  emg(i) = emg(i-1) + de

      neg = neg1 + neg2 + neg3
      do 30 i =1, neg3
c        step linearly increases as one get farther from real axis
         eim = eimmin *(i+1)**2 /4.d0
         if (i.le.nflrx) step(i) = dimag(eim)/4
         emg(neg-i+1) = xmu + eim
  30  continue

      return
      end
      subroutine inipot (dgc, dpc, edenvl, vvalgs, xnmues)
c     initialize values of arrays to zero
      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      parameter (zero=0.0d0)

      dimension dgc(251,30,0:nphx+1), dpc(251,30,0:nphx+1)
      dimension edenvl(251,0:nphx), vvalgs (251,0:nphx)
      dimension xnmues(0:lx,0:nphx)

      do 10 iph  = 0,nphx+1
      do 10 iorb = 1,30
      do 10 i = 1,251
   10    dgc(i,iorb,iph) = zero

      do 20 iph  = 0,nphx+1
      do 20 iorb = 1,30
      do 20 i = 1,251
   20    dpc(i,iorb,iph) = zero

      do 30 iph = 0, nphx
      do 30 i = 1, 251
   30    edenvl(i, iph) = zero

      do 40 iph = 0, nphx
      do 40 i = 1, 251
   40    vvalgs(i, iph) = zero

      do 50 iph = 0, nphx
      do 50 ll = 0, lx
   50    xnmues (ll, iph) = zero

      return
      end
      subroutine istval (vtot, rholap, rmt, imt, rws, iws, vint, rhoint,
     1                   ierr)

c     This subroutine calculates interstitial values of v and rho
c     for an overlapped atom.  Inputs are everything except vint and
c     rhoint, which are returned.  vtot includes ground state xc.
c     rhoint is form density*4*pi, same as rholap
c
c     ierr = 0, normal exit
c          =-1, rmt=rws, no calculation possible

      implicit double precision (a-h, o-z)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      parameter (delta = 0.050 000 000 000 000)

      dimension vtot (nrptx)
      dimension rholap (nrptx)

c     Integrations are done in x (r = exp(x), see Louck's grid)
c     Trapezoidal rule, end caps use linear interpolation.
c     imt is grid point immediately below rmt, etc.
c     We will integrate over spherical shell and divide by volume of
c     shell, so leave out factor 4pi, vol = r**3/3, not 4pi*r**3/3,
c     similarly leave out 4pi in integration.

c     If rmt and rws are the same, cannot contribute to interstitial
c     stuff, set error flag
      vol = (rws**3 - rmt**3) / 3
      if (vol .le. 0)  then
         ierr = -1
         return
      endif
      ierr = 0

c     Calculation of vint including exchange correlation
c     Trapezoidal rule from imt+1 to iws
      vint = 0
      do 100  i = imt, iws-1
         fr = rr(i+1)**3 * vtot(i+1)
         fl = rr(i)**3   * vtot(i)
         vint = vint + (fr+fl)*delta/2
  100 continue
c     End cap at rws (rr(iws) to rws)
      xws = log (rws)
      xiws = xx(iws)
      g = xws - xiws
      fr = rr(iws+1)**3 * vtot(iws+1)
      fl = rr(iws)**3   * vtot(iws)
      vint = vint + (g/2) * ( (2-(g/delta))*fl + (g/delta)*fr)
c     End cap at rmt (rmt to rr(imt+1))
      xmt = log (rmt)
      ximt = xx(imt)
      g = xmt - ximt
      fr = rr(imt+1)**3 * vtot(imt+1)
      fl = rr(imt)**3   * vtot(imt)
      vint = vint - (g/2) * ( (2-(g/delta))*fl + (g/delta)*fr)
      vint = vint / vol

c     Calculation of rhoint
c     Trapezoidal rule from imt+1 to iws
      rhoint = 0
      do 200  i = imt, iws-1
         fr = rr(i+1)**3 * rholap(i+1)
         fl = rr(i)**3   * rholap(i)
         rhoint = rhoint + (fr+fl)*delta/2
  200 continue
c     End cap at rws (rr(iws) to rws)
      xws = log (rws)
      xiws = xx(iws)
      g = xws - xiws
      fr = rr(iws+1)**3 * rholap(iws+1)
      fl = rr(iws)**3   * rholap(iws)
      rhoint = rhoint + (g/2) * ( (2-(g/delta))*fl + (g/delta)*fr)
c     End cap at rmt (rmt to rr(imt+1))
      xmt = log (rmt)
      ximt = xx(imt)
      g = xmt - ximt
      fr = rr(imt+1)**3 * rholap(imt+1)
      fl = rr(imt)**3   * rholap(imt)
      rhoint = rhoint - (g/2) * ( (2-(g/delta))*fl + (g/delta)*fr)
      rhoint = rhoint / vol

      return
      end
      subroutine moveh (nat, iphat, iz, rath)
c    Increase length of bonds with hydrogen atoms
c    Move Hydrogens for potentials. Otherwise MT geometry is screwed up.
      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     input is everything; output is modified  atomic coordinates (rath) 
c     nat is number of atoms in cluster
      dimension iphat(natx),  iz(0:nphx)
      dimension rath(3,natx)

      do 970 iat = 1, nat
        if (iz(iphat(iat)) .eq. 1) then
c         find the nearest atom A, units for rat are bohr.
          rah = 100
          ia = 0
          do i = 1,nat
              rattmp = dist(rath(1,iat), rath(1,i) )
              if (rattmp.lt. rah .and. i.ne. iat) then
                 ia = i
                 rah = rattmp
              endif
          enddo
          if (iz(iphat(ia)).eq.1) goto 970

c         set max distance as function of rah ( set by calculations
c         for H2O and GeH4)
          ratmax = rah + 4.d0/rah**2 

c        find shortest AB bond (neither A or B are H)
          rab = 10
          ib = 0
          do i = 1,nat
              rattmp = dist(rath(1,ia), rath(1,i))
              if (i.ne.ia .and. iz(iphat(i)).ne.1 .and.
     1            rab.gt.rattmp) then
                 rab = rattmp
                 ib = i
              endif
          enddo
          if (rab.lt.ratmax) ratmax = 0.95*rab + 0.05*rah
          if (rah .gt. ratmax) goto 970

c         increase rah to ratmax and check that A is still closest to H
          ratmin = rah
  960     do i = 1,3
           rath(i,iat)=rath(i,ia)+ratmax/ratmin*(rath(i,iat)-rath(i,ia))
          enddo
          rbh = 10
          ib = 0
          do i = 1,nat
              rattmp = dist(rath(1,iat), rath(1,i))
              if (i.ne.iat .and. rbh.gt.rattmp) then
                 rbh = rattmp
                 ib = i
              endif
          enddo

          if (ia.ne.ib) then
             rab = dist(rath(1,ia),rath(1,ib))
             rattmp = ratmax*rab**2/(ratmax**2+rab**2-rbh**2)
             ratmin = ratmax
             ratmax = 0.95*rattmp +0.05*rah
             goto 960
          endif
        endif
  970 continue

      return
      end
      subroutine ovrlp (iph, iphat, rat, iatph, novr, iphovr,
     1                nnovr, rovr, iz, nat, rho, dmag,
     2                rhoval, vcoul, edens, edenvl, vclap, rnrm)

c     Overlaps coulomb potentials and electron densities for current
c     unique potential
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension iphat(natx)
      dimension rat(3,natx)
      dimension iatph(0:nphx)
      dimension novr(0:nphx)
      dimension iphovr(novrx,0:nphx)
      dimension nnovr(novrx,0:nphx)
      dimension rovr(novrx,0:nphx)
      dimension iz(0:nphx)
      dimension rho(251,0:nphx+1), dmag(251,0:nphx+1)
      dimension vcoul(251,0:nphx+1), rhoval(251,0:nphx+1)
      dimension edens(251,0:nphx), edenvl(251,0:nphx)
      dimension vclap(251,0:nphx)
      dimension rnrm(0:nphx)
c#mn
       external dist

c     start with free atom values for current atom
      do 100  i = 1, 251
         vclap(i,iph) = vcoul(i,iph)
         edens(i,iph) = rho  (i,iph)
         
cc       investigate effect of central atom spin only
c        if (iph.ge.1) dmag(i,iph) = 0.0

         edenvl(i,iph) = rhoval  (i,iph)
  100 continue

      if (novr(iph) .gt. 0)  then
         do 104  iovr = 1, novr(iph)
            rnn  = rovr(iovr,iph)
            ann  = nnovr(iovr,iph)
            infr = iphovr(iovr,iph)
            call sumax (rnn, ann, vcoul(1,infr), vclap(1,iph))
            call sumax (rnn, ann, rho  (1,infr), edens(1,iph))
            call sumax (rnn, ann, rho  (1,infr), edenvl(1,iph))
  104    continue
      else
c        Do overlapping from geometry with model atom iat
         iat = iatph(iph)

c        overlap with all atoms within r overlap max (rlapx)
c        12 au = 6.35 ang  This number pulled out of a hat...
         rlapx = 12
c        inat is Index of Neighboring ATom
         do 110  inat = 1, nat
c           don't overlap atom with itself
            if (inat .eq. iat)  goto 110

c           if neighbor is too far away, don't overlap it
            rnn = dist (rat(1,inat), rat(1,iat))
            if (rnn .gt. rlapx)  goto 110

            infr = iphat(inat)
            call sumax (rnn, one, vcoul(1,infr), vclap(1,iph))
            call sumax (rnn, one, rho  (1,infr), edens(1,iph))
            call sumax (rnn, one, rho  (1,infr), edenvl(1,iph))
cala        call sumax (rnn, one, rhoval(1,infr), edenvl(1,iph))
  110       continue
      endif

c     set norman radius
      call frnrm (edens(1,iph), iz(iph), rnrm(iph))

c     remember ratio dmag/edens , not dmag itself
      do 200 i = 1,251
        if (edens(i,iph) .gt. 0.d0) then
          dmag(i,iph) = dmag(i,iph) / edens(i,iph)
        else
          dmag(i,iph) = 0.d0
        endif
 200  continue

      return
      end
      subroutine reapot (mpot, rgrd, ntitle, title, ipr1, ispec,
     1           nohole, ihole, gamach, nph, iz, lmaxsc, xnatph,
     2           xion, iunf, ixc, jumprm, iafolp, folp, inters, totvol,
     3           rfms1, lfms1, nscmt, ca1, nmix, ecv, icoul,
     4           novr, iphovr, nnovr, rovr,
     5           nat, rat, iphat, iatph)
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

cc    geom.dat
        integer  nat, iatph(0:nphx), iphat(natx)
        double precision  rat(3,natx)
cc    mod1.inp
        character*80 title(nheadx), head(nheadx)
        integer lhead(nheadx)
        integer mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec,
     1     iunf, nmix, nohole, jumprm, inters, nscmt, icoul, lfms1
        integer iz(0:nphx), lmaxsc(0:nphx)
        real rfms1
        double precision gamach, rgrd, ca1, ecv, totvol
        double precision  xnatph(0:nphx), folp(0:nphx), xion(0:nphx)
c       for OVERLAP option
        integer novr(0:nphx), iphovr(novrx,0:nphx), nnovr(novrx,0:nphx)
        double precision  rovr(novrx,0:nphx)

c     Local stuff
      character*512 slog
      character*32 s1, s2, s3

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)


c     Read  geom.dat file
      open (file='geom.dat', unit=3, status='old',iostat=ios)
c       read header from geom.dat 
        nhead = nheadx
        call rdhead (3, nhead, head, lhead)
        nat = 0
        nph = 0
        do 40 iph = 0, nphx
  40    iatph(iph) = 0
  50    continue
           if (nat .gt. natx)  then
              write(slog,55) ' nat, natx ', nat, natx
              call wlog(slog)
  55          format(a, 2i10)
              stop 'Bad input'
           endif
           nat = nat+1
           read(3,*,end=60)  idum, (rat(j,nat),j=1,3), iphat(nat), i1b
           if (iphat(nat).gt.nph) nph = iphat(nat)
           if ( iatph(iphat(nat)).eq.0) iatph(iphat(nat)) = nat
        goto 50
  60    continue
        nat = nat-1
      close(3)

c     read mod1.inp
      open (file='mod1.inp', unit=3, status='old',iostat=ios)
      call chopen (ios, 'mod1.inp', 'reapot')
        read (3,10) slog
        read (3,20) mpot, nph, ntitle, ihole, ipr1, iafolp, ixc, ispec
        read (3,10) slog
        read (3,20)  nmix, nohole, jumprm, inters, nscmt, icoul, lfms1,
     1     iunf
        do 110 ititle = 1, ntitle
  110   read (3,10) title(ititle)
        read (3,10) slog
        read (3,30)  gamach, rgrd, ca1, ecv, totvol, rfms1
        read (3,10) slog
  120   format ( 2i5, 4f13.5)
        do 130 ip = 0, nph
  130   read (3,120) iz(ip), lmaxsc(ip), xnatph(ip), xion(ip), folp(ip)
c       for OVERLAP option
        read (3,10) slog
        read (3,20) ( novr(iph), iph=0,nph)
        read (3,10) slog
  140   format ( 2i5, f13.5)
        do 150 iph = 0, nph
        do 150 iovr = 1, novr(iph)
  150   read (3,140) iphovr(iovr, iph), nnovr(iovr,iph), rovr(iovr,iph)
      close(3)

c     transform to code units (bohrs and hartrees - atomic unuts)
      rfms1 = rfms1 / bohr
      gamach = gamach / hart
      ecv   = ecv   / hart
      totvol = totvol / bohr**3
      do 210 iat = 1, nat
      do 210 i = 1,3
        rat(i,iat) = rat (i, iat) / bohr
  210 continue
      do 220 iph = 0, nph
      do 220 iovr = 1, novr(iph)
         rovr(iovr,iph) = rovr(iovr,iph) / bohr
  220 continue

c     add lines to the title
      if (mpot.eq.1) then
         ntitle = ntitle + 1
         if (nat.gt.1) then
           if (rfms1.lt.0) rfms1 = 0
           if (nscmt.gt.0) then
             write(s1, 230) nscmt, rfms1*bohr, lfms1
  230        format(' POT  SCF', i4, f8.4, i4)
           else
             write(s1, 235) 
  235        format(' POT  Non-SCF' )
           endif
         else
           write(s1, 240) 
  240      format(' POT  used OVERLAP geometry,')
         endif
         if (nohole.eq.0) then
           write(s2, 310) 
  310      format(', NO core-hole,')
         elseif (nohole.eq.2) then
           write(s2, 315) 
  315      format(', screened core-hole,')
         else
           write(s2, 320) 
  320      format(', core-hole,')
         endif
         if (iafolp.lt.0) then
           write(s3, 330) folp(0)
  330      format(' FOLP (folp(0)=', f6.3, ')' )
         else
           write(s3, 340) folp(0)
  340      format(' AFOLP (folp(0)=', f6.3, ')' )
         endif
c        concatenate 3 strings into 1
         title(ntitle) = ' '
         ilen = istrln(s1)
         istart = 1
         iend = ilen
         title(ntitle)(istart:iend) = s1(1:ilen)
         ilen = istrln(s2)
         istart = iend + 1
         iend = iend + ilen
         title(ntitle)(istart:iend) = s2(1:ilen)
         ilen = istrln(s3)
         istart = iend + 1
         iend = iend + ilen
         title(ntitle)(istart:iend) = s3(1:ilen)
      endif

      return
      end
      subroutine rholie ( ri05, nr05, dx, x0, ri, em,
     2                  ixc, rmt, rnrm,
     3                  vtot, vvalgs, xnval, dgcn, dpcn, eref,
     4                  adgc, adpc, xrhole, xrhoce, yrhole, yrhoce, ph,
     i                  iz, xion, iunf, ihole, lmaxsc)

      implicit double precision (a-h, o-z)

c     INPUT
c     dx, x0, ri(nr)
c                  Loucks r-grid, ri=exp((i-1)*dx-x0)
c     ne, em(ne)   number of energy points,  complex energy grid
c     ixc          0  Hedin-Lunqist + const real & imag part
c                  1  Dirac-Hara + const real & imag part
c                  2  ground state + const real & imag part
c                  3  Dirac-Hara + HL imag part + const real & imag part
c                  5  Dirac-Fock exchange with core electrons +
c                     ixc=0 for valence electron density
c     rmt          r muffin tin
c     rnrm         r norman
c     vtot(nr)     total potential, including gsxc, final state
c     dgcn(dpcn)   large (small) dirac components for central atom
c     adgc(adpc)   their development coefficients
c
c     OUTPUT
c     xrhole(0:lx)  integral over r of density function
c     xrhoce(0:lx)  the same integral for embedded atom only
c     yrhole(251,0:lx)   density function
c     yrhoce(251)        density function for embedded atom


c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     max number allowed in xsect r-grid
      parameter (nrx = nrptx)

c     output
      complex*16  xrhole(0:lx)
      complex*16  xrhoce(0:lx)
      complex*16  yrhole(251,0:lx), yrhoce(251)
      complex*16  ph(lx+1)

      dimension ri(nrptx), ri05(251)
      dimension  vtot(nrptx), vvalgs(nrptx)
      complex*16 vtotc(nrptx), vvalc(nrptx)
      dimension xnval(30), dgcn(nrptx,30), dpcn(nrptx,30)
      dimension adgc(10,30), adpc(10,30)

c     energy grid in complex e-plane
      complex*16 em, eref

c     work space for dfovrg: regular and irregular solutions
      complex*16 pr(nrx), qr(nrx), pn(nrx), qn(nrx)

      complex*16  p2, xkmt, ck, xck
      complex*16  pu, qu
      complex*16  xfnorm, xirf
      complex*16  temp,  phx, tempc

      complex*16 jl,jlp1,nl,nlp1
      complex*16  xpc(nrx)

c     initialize
      lmax=lmaxsc
      if (lmax.gt.lx) lmax = lx
      if (iz.le.4) lmax=2
      if (iz.le.2) lmax=1
      do 20 i = 1, nrptx
         vtotc(i)=vtot(i)
         vvalc(i)= vvalgs(i)
  20  continue
c     set imt and jri (use general Loucks grid)
c     rmt is between imt and jri (see function ii(r) in file xx.f)
      imt  = (log(rmt) + x0) / dx  +  1
      jri  = imt+1
      if (jri .gt. nrptx)  call par_stop('jri .gt. nrptx in phase')
      inrm = (log(rnrm) + x0) / dx  +  1
      jnrm = inrm+1

c     set limits for tabulations
      nr05= (log(rnrm) + x0) / 0.05d0 + 5
      if (nr05.gt.251) nr05 = 251
c     ilast is the last integration point
c     it is larger than jnrm for better interpolations
      ilast = nint( (nr05-1) *0.05d0 / dx ) + 1
      if (ilast.gt.nrptx) ilast=nrptx

      do 10 lll = 0, lx
      do 10 j = 1, 251
         yrhole(j,lll) = 0
  10  continue
      do 30 j = 1, 251
  30  yrhoce(j) = 0

c     p2 is 0.5*(complex momentum)**2 referenced to energy dep xc
c     need hartree units for dfovrg
      p2 = em - eref
      if (mod(ixc,10) .lt. 5) then
        ncycle = 0
      else
        ncycle = 3
      endif
      ck = sqrt(2*p2 + (p2*alphfs)**2)
      xkmt = rmt * ck

      do 200 lll=0,lx
        if (lll.gt.lmax) then
           ph(lll+1) = 0
           xrhoce(lll) = 0
           xrhole(lll) = 0
           do 110 i = 1,251
  110      yrhole(i,lll) = 0
           goto 200
        endif

c       may want to use ihole=0 for new screening. 
c       don't want ro use it now
c       ihole = 0
        ikap = -1-lll
        irr = -1
        ic3 = 1
        if (lll.eq.0) ic3 = 0
        call dfovrg ( ncycle, ikap, rmt, ilast, jri, p2, dx,
     $                ri, vtotc, vvalc, dgcn, dpcn, adgc, adpc,
     $                xnval, pu, qu, pn, qn,
     $                iz, ihole, xion, iunf, irr, ic3)
        call exjlnl (xkmt, lll, jl, nl)
        call exjlnl (xkmt, lll+1, jlp1, nlp1)
        call phamp (rmt, pu, qu, ck,  jl, nl, jlp1, nlp1, ikap,
     1                  phx, temp)
        ph(lll+1)=phx

c     Normalize final state  at rmt to
c     rmt*(jl*cos(delta) - nl*sin(delta))
        xfnorm = 1 / temp
c     normalize regular solution
        do 133  i = 1,ilast
          pr(i)=pn(i)*xfnorm
          qr(i)=qn(i)*xfnorm
  133   continue

c      find irregular solution
        irr = 1
        pu = ck*alphfs
        pu = - pu/(1+sqrt(1+pu**2))
c       set pu, qu - initial condition for irregular solution at ilast
c       qu=(nlp1*cos(phx)+jlp1*sin(phx))*pu *rmt
c       pu = (nl*cos(phx)+jl*sin(phx)) *rmt
        qu=(nlp1*cos(phx)+jlp1*sin(phx))*pu *rmt 
        pu = (nl*cos(phx)+jl*sin(phx)) *rmt 

        call dfovrg (ncycle, ikap, rmt, ilast, jri, p2, dx,
     1              ri, vtotc,vvalc, dgcn, dpcn, adgc, adpc,
     1              xnval, pu, qu, pn, qn,
     1              iz, ihole, xion, iunf, irr, ic3)
cc      set N- irregular solution , which is outside
cc      N=(nlp1*cos(ph0)+jlp1*sin(ph0))*factor *rmt * dum1
cc      N = i*R - H*exp(i*ph0)
        temp = exp(coni*phx)
c       calculate wronskian
        qu = 2 * alpinv * temp * ( pn(jri)*qr(jri) - pr(jri)*qn(jri) )
        qu = 1 /qu / ck
c       qu should be close to 1
        do i = 1, ilast
          pn(i) = coni * pr(i) - temp * pn(i)*qu
          qn(i) = coni * qr(i) - temp * qn(i)*qu
        enddo

c     ATOM,  dgc0 is large component, ground state hole orbital
c     .      dpc0 is small component, ground state hole orbital
c     FOVRG, p    is large component, final state photo electron
c     .      q    is small component, final state photo electron

            
c    combine all constant factors to temp
c    add relativistic correction to normalization and factor 2*lll+1
        pu = ck*alphfs
        pu = - pu/(1+sqrt(1+pu**2))
        temp = (2*lll+1.0d0)/(1+pu**2) /pi *ck * 2
c    also scale by appropriate step in complex energy
        do 190  i = 1, ilast
          xpc(i) = pr(i) * pr(i) + qr(i) * qr(i) 
 190    continue
          
        do 191 ir=1,nr05
           call terpc(ri, xpc, ilast, 3, ri05(ir), tempc)
           tempc = tempc * temp
           yrhole(ir,lll)= tempc
 191    continue

        xirf = lll*2 + 2
c       i0 should be less or equal to  ilast
        i0=jnrm+1
        call csomm2 (ri, xpc, dx, xirf, rnrm, i0)
c       print out xirf for Bruce
        xrhole(lll) = xirf*temp

c     only central atom contribution needs irregular solution
        do 195  i = 1, ilast
          xpc(i) = pn(i)*pr(i)-coni*pr(i)*pr(i)
     1           + qn(i)*qr(i)-coni*qr(i)*qr(i)
c         yrhoce(i)=yrhoce(i) - temp*xpc(i)
 195    continue
        do 196 ir=1,nr05
           call terpc(ri, xpc, ilast, 3, ri05(ir), tempc)
           yrhoce(ir)=yrhoce(ir) - temp*tempc
 196    continue

        xirf =  1
        call csomm2 (ri, xpc, dx, xirf, rnrm, i0)
        xrhoce(lll) =  - xirf* temp
 200  continue 

      return
      end
      subroutine scmt ( iscmt, ecv, nph, nat, vclap,
     2                edens, edenvl, vtot, vvalgs, rmt, rnrm,qnrm,
     2                ixc, rhoint, vint, xmu, jumprm,
     3                xnferm, xnvmu, xnval,
     4                x0, ri, dx, xnatph, xion, iunf, iz,
     5                adgc, adpc, dgc,dpc, ihole,
     7                rat,iatph,iphat, lmaxsc, rhoval, xnmues, ok,
     8                rgrd, nohole, nscmt, icoul, ca1, rfms1, lfms1)

c     Finds new Fermi level (xmu), electron counts (qnrm) 
c     and new valence densities (rhoval).

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}

c     input
      dimension dmagx(nrptx), dmag0(251)
      dimension vclap(251,0:nphx)
      dimension vtot (251,0:nphx), vvalgs (251,0:nphx)
      dimension xnvmu(0:lx,0:nphx+1), rmt(0:nphx),rnrm(0:nphx)
      dimension xnval (30,0:nphx)
      dimension qnrm(0:nphx), dq(0:nphx)
      dimension ri(nrptx), ri05(251), nr05(0:nphx)
      dimension xnatph(0:nphx), iz(0:nphx), xion(0:nphx)
      dimension rat(3,natx),iatph(0:nphx),iphat(natx), lmaxsc(0:nphx)
      real  rfms1
c     input and output
      dimension edens(251,0:nphx), edenvl(251,0:nphx)
      dimension rhoval(251,0:nphx+1)

c     work space
      dimension xnmues(0:lx, 0:nphx)
      complex gtr(0:lx, 0:nphx)
      dimension dum(nrptx), vtotph(nrptx),vvalph(nrptx)
      dimension dgc(251,30,0:nphx+1), dpc(251,30,0:nphx+1)
      dimension adgc(10,30,0:nphx+1), adpc(10,30,0:nphx+1)
      dimension dgcn(nrptx,30), dpcn(nrptx,30)
      complex*16 xrhoce(0:lx,0:nphx), xrhocp(0:lx,0:nphx)
      complex*16 xrhole(0:lx,0:nphx)
      complex*16 yrhoce(251,0:nphx), yrhocp(251,0:nphx)
      complex*16 yrhole(251,0:lx,0:nphx)
      complex*16 ph(lx+1, 0:nphx)
      integer iph
c     complex energy grid emg is decomposed into em and eref
      parameter (negx = 80)
      complex*16 emg(negx), em, eref, ee, ep, fl, fr, fxa
c     nflrx should be odd and defines the max of Im energy for
c     the countour 
      parameter (nflrx = 17)
      dimension step(nflrx)
c     stuff from feff.f for rdinp, pathfinder and genfmt
      logical wnstar, upok, ok
c     Following passed to pathfinder, which is single precision.
      character*512 slog
      integer ient
      data ient /0/

c     save staff from rdinp, so no need to call it again
      save   ri05, ient

      ient = ient + 1
      if (ient.eq.1) then
         do 15 i= 1,251
  15     ri05(i) = exp (-8.8+0.05*(i-1))
      endif

      write (slog,10) iscmt, nscmt
  10  format('              SCF ITERATION NUMBER',i3,'  OUT OF',i3)
      call wlog(slog)

      call wlog (' Calculating energy and space dependent l-DOS.')
      call wlog (' It takes time ...')

c     initialize new valence density
      do 16 iph=0,nphx
      do 16 ir=1,251
  16  rhoval(ir,iph) = 0

c     polarization average in scmt and ldos

      call grids (ecv, xmu, negx, neg, emg, step, nflrx)

c     ie - is number of energy points calculated
      ie = 0
      ee = emg(1)
      ep = dble(ee)
      do 22 iph=0,nphx
      do 22 il=0,lx
        xrhoce(il,iph) = 0
        xnmues(il,iph) = 0
  22  continue
      do 23 iph=0,nphx
      do 23  ir = 1,251
  23  yrhoce(ir,iph) = 0
      iflr = nflrx
      iflrp = nflrx

c     Start the cycle over energy points (ie)
  25  continue
      ie = ie + 1

      do 29 iph = 0,nph
        do 860 il = 0,lx
  860     xrhocp(il,iph) = xrhoce(il,iph)
        do 870 i = 1,251
  870     yrhocp(i,iph) = yrhoce(i,iph)
  29  continue

      if (ie.eq.1 .or. mod(ie,20).eq.0) then
         write(slog,30) ie, dble(ee)*hart
   30    format('     point # ', i3, '  energy = ', f7.3)
         call wlog(slog)
      endif

      do 100  iph = 0, nph

         do 35 i=1, 251
  35     dmag0(i) = 0.d0
cc       use spin-unpolarized case to get SCF. set dmagx to zero
cc       may want to replace dmag0 with dmag(1,iph) for spin-dependent
cc       extension of SCF procedure.
         call fixvar (rmt(iph),edens(1,iph),vtot(1,iph),dmag0,
     1                vint, rhoint, dx, rgrd, jumprm,
     2                vjump, ri, vtotph, dum, dmagx)
         if (mod(ixc,10) .ge.5) then
            if (jumprm .gt. 0) jumprm = 2
            call fixvar (rmt(iph), edenvl(1,iph), vvalgs(1,iph),
     1                dmag0, vint, rhoint, dx, rgrd , jumprm,
     2                vjump, ri, vvalph, dum, dmagx)
            if (jumprm .gt. 0) jumprm = 1
         endif

         call fixdsx (iph, dx, rgrd , dgc, dpc, dgcn, dpcn)
        jri = (log(rmt(iph)) + x0) / rgrd + 2
        jri1 = jri+1
        eref = vtotph(jri1)
        do 40 i = 1, jri1
  40    vtotph(i) = vtotph(i) - eref
        if (ixc.ge.5) then
           do 50 i = 1, jri1
  50       vvalph(i) = vvalph(i) - eref
        else
           do 60 i = 1, jri1
  60       vvalph(i) = vtotph(i)
        endif

         itmp = 0
         if (iph.eq.0 .and. nohole.lt.0) itmp = ihole
         call rholie( ri05, nr05(iph), rgrd, x0, ri, ee,
     2           ixc, rmt(iph), rnrm(iph),
     3           vtotph, vvalph, xnval(1,iph), dgcn, dpcn, eref,
     4           adgc(1,1,iph), adpc(1,1,iph), xrhole(0,iph),
     5          xrhoce(0,iph),yrhole(1,0,iph),yrhoce(1,iph),ph(1,iph),
     6           iz(iph), xion(iph), iunf, itmp,lmaxsc(iph))
  100 continue

c     Write out phases for fmsie
c     transform neg,emg to em,ne,eref first
       em= dble(ee)
       eref=dble(eref)-coni*dimag(ee)

cc    call fms for a cluster around central atom
       do 195 iph0 = 0,nph
       do 195 il = 0, lx
  195  gtr(il,iph0) = 0
      if (rfms1 .gt. 0) then
        if (lfms1 .ne. 0) then
          iph0 = 0
          call fmsie( iph0, nph, lmaxsc, ie,  em, eref, ph, iz,
     1                rfms1, lfms1, nat, iphat, rat, gtr)
        else
          do 190 iph0 = 0, nph 
  190     call fmsie( iph0, nph, lmaxsc, ie, em, eref, ph, iz,
     1                rfms1, lfms1, nat, iphat, rat, gtr)
        endif
      endif

      xntot = 0
      fl = 0
      fr = 0
      do 300 iph = 0,nph
c       calculate density and integrated number of electrons in each
c       channel for each type of atoms density, etc., find xntot. 
        call ff2g (gtr(0,iph), iph, ie, nr05(iph), xrhoce, 
     1     xrhole(0,iph), xrhocp, ee, ep, 
     2     yrhole(1,0,iph), yrhoce(1,iph), yrhocp(1,iph), rhoval(1,iph),
     3     xnmues(0,iph), xnatph(iph), xntot, iflr, iflrp, fl, fr, iunf)
  300 continue

      if (ie.ne.1) xndifp = xndif
      xndif = xntot - xnferm

c     decide on next energy point; there are nflrx floors, defined
c     by the magnitude of Im part. Each floor has it's height and
c     horizontal step to search for Fermi level associated with it.
c     The driver below will decide whether to go left or right on
c     the current floor, go one floor up or down.

      if ((ie.lt.neg .and. ient.gt.1) .or. 
     1    (ient.eq.1.and.ie.lt.nflrx)) then
         ep = ee
         ee = emg(ie+1)
         if (ie.eq.neg-1) then
c          reset iflr variables
           iflrp = 2
           iflr  = 1
         endif
         goto 25
      elseif (ient.eq.1 .and. ie.eq.nflrx) then
         upok = .false.
         idir = 1
         if (xntot.gt. xnferm) idir = -1
         ep = ee
         ee = ee + idir * step(iflr)
         goto 25
      elseif (ient.gt.1 .and. ie.eq.neg) then
         upok = .true.
         iflrp = 1
         iflr  = 1
         idir = -1
         if (xntot.lt. xnferm) idir = 1
         ep = ee
         ee = ee + idir * step(iflr)
         goto 25
      else
c       check if the fermi level is found
        if (iflrp.eq.1 .and. iflr.eq.1 .and.
     1                xndifp*xndif .le. 0.e0) then
c          Fermi level is found ; do not goto 25
           if (xndif.eq.0) then
              xmunew = dble(ee)
              a=0
           else
              a = xndif/(xndif-xndifp)
              do 220 i = 1,4
                fxa = a*fl + (1-a)*fr
                bb = dimag((ep-ee)*(fr+fxa)/2 + coni*dimag(ee)*(fr-fl))
                xndif1 = xndif + a * bb
                a = a - xndif1 / bb
  220         continue
              xmunew = dble((1-a)*ee+a*ep)
           endif

c          add end cap corrections to the configuration and density
c          factor 2 for spin degeneracy
           do 250 iph = 0,nph
              do 230 il = 0,lx
               if (il.le.2 .or. iunf.ne.0) then
                fl = xrhocp(il,iph) * 2
                fr = xrhoce(il,iph) * 2
                fxa = a*fl + (1-a)*fr
                bb = dimag((ep-ee)*(fr+fxa)/2 + coni*dimag(ee)*(fr-fl))
                xnmues(il,iph) = xnmues(il,iph) + a * bb
               endif
  230         continue
              do 240 ir = 1,nr05(iph)
                fl = yrhocp(ir,iph) * 2
                fr = yrhoce(ir,iph) * 2
                fxa = a*fl + (1-a)*fr
                bb = dimag((ep-ee)*(fr+fxa)/2 + coni*dimag(ee)*(fr-fl))
                rhoval(ir,iph) = rhoval(ir,iph) + a * bb
  240         continue
  250      continue
        else
c          continue search ; goto 25 eventually
           if (iflr.eq.iflrp) then
c            previous step was gorizontal
             if (xndifp*xndif.le.0) then
c               need to step down
                upok =.false.
                iflrp = iflr
                iflr = iflr - 1
                ep = ee
                ee = dble(ee) + coni*4*step(iflr)
             elseif (abs(xndif).gt.10.d0*abs(xndif-xndifp)
     1          .and. upok) then
c               need to go up one floor since too far from fermi level
                iflrp = iflr
                if (iflr.lt.nflrx) then
                  iflr = iflr+1
                  ep = ee
                  ee = dble(ee) +  coni*4*step(iflr)
                else
                  ep = ee
                  ee = ee + idir* step(iflr)
                endif
             else
c               keep the same floor and direction
                ep = ee
                ee = ee + idir* step(iflr)
             endif
           else
c            previous step was up or down (vertical)
c            check the direction of search
             idir = -1
             if (xndif.lt.0) idir = 1
             iflrp = iflr
             ep = ee
             ee = ee + idir* step(iflr)
           endif
           goto 25
        endif
      endif
c     END of the loop over energy in comlex plane.
c     new fermi level and densities are calculated.

c     report configuration; repeat iteration if found bad counts.
      ok = .true.
      call wlog('  Electronic configuration')
      call wlog('   iph    il      N_el')
 310  format (2i6, f9.3)
      do 320 ip= 0,nph
      do 320 il = 0,lx
         write (slog,310) ip,il,xnmues(il,ip)
         call wlog(slog)
c        check that occupation numbers are consistent with those
c        set in getorb.f
         diff = abs(xnmues(il,ip) - xnvmu(il,ip))
         if (diff.gt.13.1 .or. (il.eq.2 .and. diff.gt. 9.1) .or.
     1   (il.eq.1 .and. diff.gt.5.1) .or.
     2   (il.eq.0 .and. diff.gt.1.95)) then
            call wlog (' Found bad counts.')
            write (slog,311) xnvmu(il,ip)
  311       format('  Occupation number in getorb is ', f9.3)
            call wlog(slog)
            call wlog ('  Will repeat this iteration ')
c            if (ient.gt.1) ok = .false.
         endif
 320  continue

c     if (.not. ok) then will restart SCF loop 
      if (ok) then
         xmu = xmunew
c        find rhoval via Broyden algorithm
         call broydn( iscmt, ca1, nph, xnvmu,
     1         nr05 , xnatph, rnrm, qnrm, edenvl, rhoval, dq)

c        calculate new vclap - overlap coulomb potential
         call coulom (icoul, nph, nr05 , rhoval, edenvl, edens,
     2     nat, rat, iatph, iphat, rnrm, dq, iz, vclap)

c       update array edens
        do 350 ip=0,nph
           do 330 ir=1,nr05 (ip)
             edens(ir,ip)=edens(ir,ip)-edenvl(ir,ip)+rhoval(ir,ip)
  330      continue
           do 340 ir=nr05 (ip)+1,251
             edens(ir,ip)=0.0d0
             edenvl(ir,ip)=0.0d0
  340      continue
  350   continue
      endif

      return
      end
c SUBROUTINE SUMAX (RN, ANN, AA2, AASUM)
c This is a version of the subroutine sumax found on page 110 of
c Louck's book.  It performs eq 3.22, using simpson's rule and
c taking advantage of the logarithmic grid so that sum f(r)*dr becomes
c sum over f(r)*r*(0.05).  Linear interpolation is used at the end
c caps.  This version does not sum over 14 shells of identical
c atoms, instead it averages the contribution of one or more atoms
c of type 2 at the location of atom 1.  Louck's description (except
c for his integration algorithm) is very clear.
c
c input:  
c         rn        distance from atom 1 to atom 2 in au
c         ann       number of type 2 atoms to add to atom 1, can
c                   be fractional
c         aa2(i)    potential or density at atom 2
c output: aasum(i)  spherically summed contribution added into this
c                   array so that sumax can be called repeatedly
c                   and the overlapped values summed into aasum
c
c Note that this routine requires that all position data be on a
c grid  rr(j) = exp (-8.8d0 + (j-1)*0.05d0), which is the grid
c used by Louck, and also used by ATOM if nuclear options not used.
c
c Coded by Steven Zabinsky, December 1989
c Modified for FEFF cluster code, August 1990, siz
c Bug fixed, May 1991, SIZ
c Another bug fixed, Mar 1992, SIZ
c
c T.L.Louck, "Augmented Plane Wave Method", W.A.Benjamin, Inc., 1967

      subroutine sumax (rn, ann, aa2, aasum)
      implicit double precision (a-h, o-z)
      parameter (nptx=250)
      dimension aa2(nptx), aasum(nptx)
      dimension stor(nptx)
c#mn
       external ii, xx

c     jjchi     index beyond which aa2 is zero
c     jtop      index just below distance to neighbor
c               aasum is calculated only up to index jtop

c     Wigner-Seitz radius is set to 15 in ATOM.
      rws = 15
      jjchi = ii(rws)
      jtop  = ii(rn)

      topx = xx(jjchi)

      do 120  i = 1, jtop
         x = xx(i)
         xint = 0.0
         et = exp(x)
         blx = log(rn-et)
         if (blx .ge. topx)  goto 119
         jbl = 2.0+20.0*(blx+8.8)
         if (jbl .lt. 1)  jbl=1
         if (jbl .ge. 2)  then
c           use linear interp to make end cap near center of neighbor
            xjbl = jbl
            xbl = 0.05 * (xjbl-1.0) - 8.8
            g = xbl-blx
            xint = xint+0.5*g*(aa2(jbl)*(2.0-20.0*g)*exp(2.0*xbl)
     1             +20.0*g*aa2(jbl-1)*exp(2.0*(xbl-0.05)))
         endif
         tlx = log(rn+et)
         if (tlx .ge. topx)  then
            jtl = jjchi
            go to 90
         endif
         jtl = 1.0 + 20.0*(tlx+8.8)
         if (jtl .lt. jbl)  then
c           handle peculiar special case at center of atom 1
            fzn = aa2(jtl)*exp(2.0*(xbl-0.05))
            fz3 = aa2(jbl)*exp(2.0*xbl)
            fz2 = fzn+20.0*(fz3-fzn)*(tlx-xbl+0.05)
            fz1 = fzn+20.0*(fz3-fzn)*(blx-xbl+0.05)
            xint = 0.5*(fz1+fz2)*(tlx-blx)
            go to 119
         endif
         xjtl = jtl
         xtl = 0.05*(xjtl-1.0)-8.8
         c = tlx-xtl
         xint = xint+0.5*c*(aa2(jtl)*(2.0-20.0*c)
     1         *exp(2.0*xtl)+aa2(jtl+1)*20.0*c
     2         *exp(2.0*(xtl+0.05)))

   90    if (jtl .gt. jbl)  then
  100       xint = xint+0.5*(aa2(jbl)*exp(2.0*xbl)+aa2(jbl+1)
     1             *exp(2.0*(xbl+0.05)))*0.05
            jbl = jbl+1
            if (jbl .lt. jtl) then
               xbl = xbl+0.05
               go to 100
            endif
         endif
  119    stor(i) = 0.5*xint*ann/(rn*et)
  120 continue

      do 190  i = 1, jtop
         aasum(i) = aasum(i) + stor(i)
  190 continue

      return
      end
      subroutine wpot (nph, edens, imt, inrm,
     1                 rho, vclap, vcoul, vtot, ntitle, title)

c     Writes potentials to file name POTxx.DAT for each unique pot.

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension rho(251,0:nphx+1)
      dimension vcoul(251,0:nphx+1)
      dimension edens(251,0:nphx)
      dimension vclap(251,0:nphx)
      dimension vtot (251,0:nphx)
      dimension imt(0:nphx)
      dimension inrm(0:nphx)
      character*80 title(ntitle)

      character*30 fname
c#mn
       external rr

c     note units --
c     potentials in hartrees, so that v * 27.2 -> eV
c     density in #/(bohr)**3, so rho * e / (.529)**3 -> e/(Ang)**3

      do 180  iph = 0, nph
c        prepare file for unique potential data
         write(fname,172)  iph
  172    format('pot', i2.2, '.dat')
         open (unit=1, file=fname, status='unknown', iostat=ios)
         call chopen (ios, fname, 'wpot')
         call wthead(1, ntitle, title)
         write(1,173)  iph, imt(iph), inrm(iph)
  173    format (1x, 3i4, '  Unique potential, I_mt, I_norman.',
     1          '    Following data in atomic units.')
         write(1,*) ' iph ', iph
         write(1,174)
  174    format ('   i      r         vcoul        rho',
     1           '     ovrlp vcoul  ovrlp vtot  ovrlp rho')
c        need some limit here, 1250 points is silly.  Use
c        r <= 38, which gives 249 points with usual rgrid
         do 178  i = 1, 251
            if (rr(i) .gt. 38)  goto 179
            write(1,176) i, rr(i), vcoul(i,iph), rho(i,iph)/(4*pi),
     1                vclap(i,iph), vtot(i,iph), edens(i,iph)/(4*pi)
  176       format (1x, i4, 1p, 6e12.4)
  178    continue
  179    continue
         close(unit=1)
  180 continue

      return
      end
      subroutine wrpot ( nph, ntitle, title, rnrmav, xmu, vint, rhoint,
     1                  emu, s02, erelax, wp, ecv,rs,xf, qtotel, 
     2                  imt, rmt, inrm, rnrm, folp, folpx, xnatph,
     3                  dgc0, dpc0, dgc, dpc, adgc, adpc,
     3                  edens, vclap, vtot, edenvl, vvalgs, dmag, xnval,
     4                  eorb, kappa, iorb, qnrm, xnmues, nohole, ihole,
     5                  inters, totvol, iafolp, xion, iunf, iz, jumprm)
c  opens pot.bin file and writes following information
c  General:
c     ntitle - number of title lines
c     title  - title itself
c     emu    - edge position (x-ray energy for final state at Fermi level)
c  Muffin-tin geometry
c     rmt    - muffin-tin radii
c     imt    - index of radial grid just below muffin-tin radii
c     rnrm   - Norman radii
c     inrm   - index of radial grid just below Norman radii
c     rnrmav - average Norman radius
c     folp   - overlap parameter for rmt
c     folpx  - maximum value for folp
c  Atomic orbitals info (Dirac spinors)
c     dgc0   - upper component for initial orbital
c     dpc0   - lower component for initial orbital
c     dgc    - upper components for all atomic orbitals
c     dpc    - lower components for all atomic orbitals
c     adgc   - development coefficient for upper components
c     adpc   - development coefficient for lower components
c     xnval  - number of valence electrons for each atomic orbital
c     eorb   - atomic energy of occupied orbitals
c     kappa  - quantum number kappa of occupied orbitals
c     iorb   - index of last occupied orbital for each kappa
c              used for core-valence separation and non-local exchange
c  Electron density information 
c     rhoint - interstitial density
c     rs     - r_s estimate from rhoint (4/3 r_s**3 * rhoint = 1)
c     xf     - estimate of momentum at Fermi level from rhoint
c     edens  - total electron density
c     edenvl - density from valence electrons
c     dmag   - density for spin-up minus density for spin-down
c     qtotel - total charge of a cluster
c     qnrm   - charge accumulated inside Norman sphere as result of SCF
c     xnmues - occupation numbers of valence orbitals from SCF procedure
c  Potential information
c     xmu    - Fermi level position
c     ecv    - core-valence separation energy
c     vint   - muffin-tin zero energy (interstitial potential)
c     vclap  - Coulomb potential
c     vtot   - vclap + xc potential from edens
c     vvalgs - vclap + xc potential from edenvl (EXCHANGE 5 model)
c  Specific data for convolution with excitation spectrum (see mbconv)
c     s02    - many body reduction factor S_0^2 
c     erelax - estimate of relaxation energy = efrozen - emu, where
c              efrozen is edge position estimate from Koopmans theorem
c     wp     - estimate of plasmon frequency from rhoint

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      parameter (npadx=8)
      dimension imt(0:nphx), rmt(0:nphx), inrm(0:nphx),  rnrm(0:nphx)
      dimension folp(0:nphx), folpx(0:nphx), dgc0(251), dpc0(251)
      dimension dgc(251, 30, 0:nphx), dpc(251, 30, 0:nphx)
      dimension adgc(10, 30, 0:nphx), adpc(10, 30, 0:nphx)
      dimension edens(251, 0:nphx), vclap(251, 0:nphx)
      dimension vtot(251, 0:nphx), edenvl(251, 0:nphx)
      dimension vvalgs(251, 0:nphx), dmag(251, 0:nphx)
      dimension xnval(30,0:nphx), qnrm(0:nphx), xnmues(0:lx,0:nphx)
      dimension eorb(30), kappa(30)
      dimension iorb(-4:3,0:nphx), iz(0:nphx), xion(0:nphx)
      dimension xnatph(0:nphx)
      character*80 title(nheadx)

      dimension dum(13)
      character*75 wfmt

  10  format(a)
      write (wfmt, 35) nph + 1
  35  format( '(', i3, '(1x,i4))' )

      open (unit=3, file='pot.bin', status='unknown', iostat=ios)
      call chopen (ios, 'pot.bin', 'pot')
      write(3,20) ntitle, nph, npadx, nohole, ihole, inters, iafolp,
     1            jumprm, iunf
  20  format (9(1x,i4))
      do 133  i  = 1, ntitle
         ll = istrln(title(i))
         write(3,10) title(i)(1:ll)
  133 continue
c     Misc stuff from pot.bin
      dum(1)  = rnrmav
      dum(2)  = xmu
      dum(3)  = vint
      dum(4)  = rhoint
      dum(5)  = emu
      dum(6)  = s02
      dum(7)  = erelax
      dum(8)  = wp
      dum(9)  = ecv
      dum(10)  = rs
      dum(11)  = xf
      dum(12)  = qtotel
      dum(13)  = totvol
      call wrpadd(3, npadx, dum(1), 13)

      write (3, 40) (imt(i),i=0,nph)
  40  format(20(1x,i4))
      
      call wrpadd(3, npadx, rmt(0), nph+1)

      write (3, 40) (inrm(i),i=0,nph)
      write (3, 40) (iz(i),i=0,nph)
      write (3, 40) (kappa(i),i=1,30)
      
      call wrpadd(3, npadx, rnrm(0), nph+1)
      call wrpadd(3, npadx, folp(0), nph+1)
      call wrpadd(3, npadx, folpx(0), nph+1)
      call wrpadd(3, npadx, xnatph(0), nph+1)
      call wrpadd(3, npadx, xion(0), nph+1)
      call wrpadd(3, npadx, dgc0(1), 251)
      call wrpadd(3, npadx, dpc0(1), 251)
      call wrpadd(3, npadx, dgc(1,1,0), 251*30*(nph+1) )
      call wrpadd(3, npadx, dpc(1,1,0), 251*30*(nph+1) )
      call wrpadd(3, npadx, adgc(1,1,0), 10*30*(nph+1) )
      call wrpadd(3, npadx, adpc(1,1,0), 10*30*(nph+1) )
      call wrpadd(3, npadx, edens(1,0), 251*(nph+1) )
      call wrpadd(3, npadx, vclap(1,0), 251*(nph+1) )
      call wrpadd(3, npadx, vtot(1,0), 251*(nph+1) )
      call wrpadd(3, npadx, edenvl(1,0), 251*(nph+1) )
      call wrpadd(3, npadx, vvalgs(1,0), 251*(nph+1) )
      call wrpadd(3, npadx, dmag(1,0), 251*(nph+1) )
      call wrpadd(3, npadx, xnval(1,0), 30*(nph+1) )
      call wrpadd(3, npadx, eorb(1), 30)
      
      do 50 iph=0,nph
        write (3, 60) (iorb(i,iph),i=-4,3)
 50   continue
 60   format(8(1x,i2))
      call wrpadd(3, npadx, qnrm(0), nph+1 )
      call wrpadd(3, npadx, xnmues(0,0), (lx+1)*(nph+1) )
      close (unit=3)

      return
      end
      subroutine istprm ( nph, nat, iphat, rat, iatph, xnatph,
     1                novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1                edens, edenvl, idmag,
     2                dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm, 
     2                ixc, rhoint, vint, rs, xf, xmu, xmunew,
     3                rnrmav, qtotel, inters, totvol)

c     Finds interstitial parameters, rmt, vint, etc.
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension iphat(natx)
      dimension rat(3,natx)
      dimension iatph(0:nphx)
      dimension xnatph(0:nphx)
      dimension novr(0:nphx)
      dimension iphovr(novrx,0:nphx)
      dimension nnovr(novrx,0:nphx)
      dimension rovr(novrx,0:nphx)
      dimension folp(0:nphx), folpx(0:nphx)
      dimension edens(251,0:nphx), edenvl(251,0:nphx)
      dimension dmag(251,0:nphx+1)
      dimension vclap(251,0:nphx)
      dimension vtot (251,0:nphx), vvalgs (251,0:nphx)
      dimension imt(0:nphx)
      dimension inrm(0:nphx)
      dimension rmt(0:nphx)
      dimension rnrm(0:nphx)
      parameter (big = 5000)
      character*512 slog
      logical lnear
      dimension lnear(0:nphx), inn(0:nphx), rnnmin(0:nphx)
c#mn
       external dist

c     work space for linear algebra
      dimension ri(251)
      parameter (novp=40)
      complex cmovp(novp*(nphx+1)+1,novp*(nphx+1)+1)
      integer ipiv(novp*(nphx+1)+1)
      save lnear

c Find muffin tin radii.  We'll find rmt based on norman prescription,
c ie, rmt(i) = R * folp * rnrm(i) / (rnrm(i) + rnrm(j)),
c a simple average
c based on atoms i and j.  We average the rmt's from each pair of
c atoms, weighting by the volume of the lense shape formed by the
c overlap of the norman spheres.
c NB, if folp=1, muffin tins touch without overlap, folp>1 gives
c overlapping muffin tins.
c
c rnn is distance between sphere centers
c rnrm is the radius of the norman sphere
c xl_i is the distance to the plane containing the circle of the
c    intersection
c h_i  = rnrm_i - xl_i is the height of the ith atom's part of
c    the lense
c vol_i = (pi/3)*(h_i**2 * (3*rnrm_i - h_i))
c
c xl_i = (rnrm_i**2 - rnrm_j**2 + rnn**2) / (2*rnn)

c     find rmt from rnrm only on first call of istprm (rmt(0)=-1)
      if (rmt(0).le.0.0) then
      do 10 iph=0,nph
  10  lnear(iph)=.false.
      do 140  iph = 0, nph
         voltot = 0
         rmtavg = 0
         inrm(iph) = ii(rnrm(iph))
         if (novr(iph) .gt. 0)  then
c           Overlap explicitly defined by overlap card
            rnear = big
            inters = mod(inters,6)
c           use Norman prescription only in this case

            do 124  iovr = 1, novr(iph)
               rnn  = rovr(iovr,iph)
               inph = iphovr(iovr,iph)
               if (rnn .le. rnear) then
                  rnear = rnn
                  rnnmin(iph) = rnn
                  inn(iph) = inph
               endif
c              Don't avg if norman spheres don't overlap
               if (rnrm(iph)+rnrm(inph) .le. rnn)  goto 124
               voltmp = calcvl (rnrm(iph), rnrm(inph), rnn)
               voltmp = voltmp + calcvl (rnrm(inph), rnrm(iph), rnn)
               rmttmp = rnn * folp(iph) * rnrm(iph) /
     1                  (rnrm(iph) + rnrm(inph))
               ntmp = nnovr(iovr,iph)
               rmtavg = rmtavg + rmttmp*voltmp*ntmp
               voltot = voltot + voltmp*ntmp
  124       continue
         else
            iat = iatph(iph)
            rnear = big
            rmt(iph) = big
            do 130  inat = 1, nat
               if (inat .eq. iat)  goto 130
               rnn = dist (rat(1,inat), rat(1,iat))
               inph = iphat(inat)
               if (rnn .le. rnear) then
                  rnear = rnn
                  rnnmin(iph) = rnn
                  inn(iph) = inph
               endif
c              Don't avg if norman spheres don't overlap
               if (rnrm(iph)+rnrm(inph) .lt. rnn)  goto 130

               if (inters.lt.6) then
c                Norman prescription
                 voltmp = calcvl (rnrm(iph), rnrm(inph), rnn)
                 voltmp = voltmp + calcvl (rnrm(inph), rnrm(iph), rnn)
                 rmttmp = rnn * folp(iph) * rnrm(iph) /
     1                  (rnrm(iph) + rnrm(inph))
                 rmtavg = rmtavg + rmttmp*voltmp
                 voltot = voltot + voltmp
               else
c                Matching point prescription
                 do 125 i=inrm(iph),1,-1
                   j=ii(rnn-rnrm(iph))
                   if (vclap(i,iph).le.vclap(j,inph)) then
                     d1 = (vclap(i+1,iph)-vclap(i,iph))/(rr(i+1)-rr(i))
                     d2 =(vclap(j,inph)-vclap(j-1,inph))/(rr(j)-rr(j-1))
                     rmtavg = rr(i) + 
     1               (vclap(j,inph)+d2*(rnn-rr(i)-rr(j))-vclap(i,iph))
     2               /(d1+d2)
                     goto 127
c                    exit from the loop
                   endif
  125            continue
  127            continue
                 if (rmtavg.lt.rmt(iph)) rmt(iph) = rmtavg
               endif
  130       continue
         endif

c        special situation if rnrm is too close or larger than
c        the nearest neighbor distance
         if (rnrm(iph).ge.rnear) lnear(iph) = .true.

         if (rmtavg .le. 0)  then
            write(slog,132) iat, iph
            call wlog(slog)
  132       format (' WARNING: NO ATOMS CLOSE ENOUGH TO OVERLAP ATOM',
     1              i5, ',  UNIQUE POT', i5, '!!  ', 
     2              'Rmt set to Rnorman.  May be error in ',
     3              'input file.')
            rmt(iph) = rnrm(iph)
         elseif(inters.lt.6) then
c           Norman prescription
            rmt(iph) = rmtavg / voltot
            if (rmt(iph) .ge. rnear)  then
c              print*,iph, rmt(iph), rnear
               call wlog(' Rmt >= distance to nearest neighbor.  ' //
     1            'Not physically, meaningful.')
               call wlog(' FEFF may crash.  Look for error in ATOM '//
     1            'list or OVERLAP cards.')
            endif
            if (rnrm(iph) .ge. rnear) then
              imax = ii(rnear) - 1
c             begin until loop
 133            if (vclap(imax,iph).lt.vclap(imax+1,iph)) goto 134
                imax = imax-1
                goto 133
c             end of until loop
 134          continue
              rmt(iph) = exp(xx(imax)) - 0.0001
            endif
         endif

  140 continue

c     set maximum value for folp(iph) if AFOLP is in use
c     LMTO lore says no more than 15% overlap
c     do 144 iph = 0, nph
c 144 folpx(iph) = 1.15
c     already done in pot.f

      do 145 iph = 0, nph
         if (iafolp. gt. 0 ) then
            temp = 0.2 + 0.8 * rnrm(iph) / rmt(iph)
         else
            temp = 0.3 + 0.7 * rnrm(iph) / rmt(iph)
         endif
         if (temp.lt.folpx(iph)) folpx(iph) = temp
         temp = rnnmin(iph)/rmt(iph)/1.06d0
         if (temp.lt.folpx(iph)) folpx(iph) = temp
         temp = exp( -(novp-3)*0.05d0)
c      make sure that with given folpx(iph) the construction
c      of the overlapping matrix in movrlp will not fail
         if (lnear(iph)) then
c           lnear=.true. only when hydrogens are present in the system.
c           want to scale both rmt for iph and inn, so that overlapping
c           matrix calculations will not fail
            temp = rnnmin(iph) / (rmt(iph)*1.05d0 + temp*rmt(inn(iph)))
            if (temp.lt.folpx(iph)) folpx(iph) = temp
            if (temp.lt.folpx(inn(iph))) folpx(inn(iph)) = temp
         else
            temp = (rnnmin(iph) - rnrm(iph))/ (temp*rmt(inn(iph)))
            if (temp.lt.folpx(inn(iph))) folpx(inn(iph)) = temp
         endif
  145 continue

      endif
c     end of finding rmt from rnrm on first call of istprm.

c     Need potential with ground state xc, put it into vtot
      do 160  iph = 0, nph
         call sidx (edens(1,iph), 250, rmt(iph), rnrm(iph),
     1              imax, imt(iph), inrm(iph))
         do 150  i = 1, imax
            if (edens(i,iph).le.0) then
             if(mod(i,10).eq.0) then
               write(slog, 149) 'negative dens ', i,iph
  149          format (a, 2i3)
               call wlog(slog)
             endif
             rs = 100
             xmag=1.0
            else
              rs = (edens(i,iph)/3)**(-third)
c     spin dependent xc potential for ground state from Von Barth, Hedin
c     J.Phys.C:Solid State Phys., 5, 1629 (1972).
c     xmag/2 -fraction of spin up or down, depending on sign in renorm.f
c     put xmag = 1.0 to calculate cmd with external potential difference
              xmag = 1.0 + idmag*dmag(i,iph)
            endif
c           wrong for ferromagnets, need to overlap dmag(i)

c           vvbh from Von Barth Hedin paper, 1971
            call vbh(rs,xmag,vvbh)
            vtot(i,iph) = vclap(i,iph) + vvbh

            if (mod(ixc,10).eq.5) then
              rsval = 10.0
              if (edenvl(i,iph) .gt. 0.00001) 
     1           rsval = (edenvl(i,iph)/3)**(-third)
              if (rsval.gt.10.0) rsval = 10.0
              xmagvl = 1.0 + idmag * dmag(i,iph) 
     1                      * edens(i,iph) / edenvl(i,iph)
              call vbh(rsval,xmagvl,vvbhvl)
              vvalgs(i,iph) = vclap(i,iph) + vvbhvl
            elseif (mod(ixc,10) .ge. 6) then
              if (edens(i,iph).le.edenvl(i,iph)) then
                 rscore =101.0
              else
                 rscore = ((edens(i,iph)-edenvl(i,iph)) / 3)**(-third)
              endif
              rsmag = (edens(i,iph)*(1+idmag*dmag(i,iph)) / 3)**(-third)
              xfmag = fa/rsmag
              call edp(rscore,xfmag,vrdh)
              vvalgs(i,iph) = vclap(i,iph) + vvbh - vrdh
            else
              vvalgs(i,iph) = 0.d0
            endif
  150    continue
  160 continue

c     What to do about interstitial values?
c     Calculate'em for all atoms, print'em out for all unique pots along
c     with derivative quantities, like fermi energy, etc.
c     Interstitial values will be average over all atoms in problem.

c     rnrmav is averge norman radius,
c     (4pi/3)rnrmav**3 = (sum((4pi/3)rnrm(i)**3)/n, sum over all atoms
c     in problem
      rnrmav = 0
      xn = 0
c     volint is total interstitial volume
      volint = 0
      do 180  iph = 0, nph
         rnrmav = rnrmav + xnatph(iph) * rnrm(iph)**3
         volint=volint-xnatph(iph) * rmt(iph)**3
         xn = xn + xnatph(iph)
  180 continue
      if (totvol.le.0.0d0) then
         volint=4*pi/3 *(volint+rnrmav)
      else
         volint=4*pi/3 *volint + totvol
      endif
c     volume of lenses from overlapping mt spheres is added in movrlp.
      rnrmav = (rnrmav/xn) ** third

      rs = 0
      vint   = 0
      rhoint = 0
      rsval = 0

      call movrlp(nph, nat, iphat, rat, iatph, xnatph,
     1            novr, iphovr, nnovr, rovr,
     2            imt, rmt, rnrm, ri, lnear,
     3            cmovp,ipiv, volint,inters)

c     If no contribution to interstitial from any atom, die.
      if (volint .le. 0)  then
         call wlog(' No interstitial density.  Check input file.')
         call par_stop('ISTPRM')
      endif

c     find interstitial density

      call ovp2mt(nph, edens, 0, qtotel, ri, xnatph, lnear,
     1            inrm, imt, rnrm, rmt, cmovp,ipiv, rhoint,inters)
      rhoint = 4*pi * rhoint / volint

      if (ixc.ge.5) then
c        find valence potential inside mt sphere (vintvl -dummy)
         call ovp2mt(nph, vvalgs, 1, qtotel, ri, xnatph, lnear,
     1           inrm, imt, rnrm, rmt, cmovp, ipiv, vintvl,inters)
      endif

c     find potential inside mt sphere and vint
      call ovp2mt(nph, vtot, 1, qtotel, ri, xnatph, lnear,
     1            inrm, imt, rnrm, rmt, cmovp, ipiv, vint,inters)

      if (vint.ge.xmu) then
        write(slog,'(a)')
     1  ' WARNING:interstitial level found above Fermi level'
        call wlog(slog)
        write(slog,'(a)')
     1  '  Results may be unreliable. See manual for details'
        call wlog(slog)
        vint = xmu - 0.05d0
        call ovp2mt(nph, vtot, 2, qtotel, ri, xnatph, lnear,
     1            inrm, imt, rnrm, rmt, cmovp, ipiv, vint,inters)
      endif
      call fermi (rhoint, vint, xmunew, rs, xf)

      return
      end

      double precision function calcvl (r1, r2, r)
      implicit double precision (a-h, o-z)
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
      xl = (r1**2 - r2**2 + r**2) / (2*r)
      h = r1 - xl
      calcvl = (pi/3) * h**2 * (3*r1 - h)
      return
      end
      subroutine movrlp ( nph, nat, iphat, rat, iatph, xnatph,
     1                novr, iphovr, nnovr, rovr,
     2                imt, rmt, rnrm, ri, lnear,
     3                cmovp, ipiv, volint, inters)

c     Constructs overlap matrix based on geometry of overlapped
c     muffin-tin spheres. Uses LU decomposition for inversion of matrix
c     
      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension iphat(natx)
      dimension rat(3,natx)
      dimension iatph(0:nphx)
      dimension xnatph(0:nphx)
      dimension novr(0:nphx)
      dimension iphovr(novrx,0:nphx)
      dimension nnovr(novrx,0:nphx)
      dimension rovr(novrx,0:nphx)
      dimension imt(0:nphx)
      dimension rmt(0:nphx)
      dimension rnrm(0:nphx)
      logical lnear
      dimension lnear(0:nphx)
c     local
      character*512 slog
c     work space for linear algebra
      dimension ri(251)
      parameter (novp=40)
      complex cmovp(novp*(nphx+1)+1,novp*(nphx+1)+1)
      real bmat(nphx+1,novp*(nphx+1))
      integer ipiv(novp*(nphx+1)+1)
c#mn
       external dist, ii

c     get ipot and irav from inters
      ipot = mod(inters,2)
      irav = (inters-ipot) / 2
      do 20 i=1,251
  20  ri(i)=exp(-8.8d0+(i-1)*0.05d0)
      exphx=exp(0.025d0)

c     initiallly cmovp is a unit matrix up to ncp
      ncp = novp*(nph+1)+1
      do 30 i2=1,ncp
      do 30 i1=1,ncp
        cmovp(i1,i2) = 0.d0
        if ( i1.eq.i2 ) cmovp(i1,i2) = 1.d0
        if (i2.eq.ncp) cmovp(i1,i2) = 0.01d0
  30  continue
      do 40 i2=1,ncp-1
      do 40 i1=1,nph+1
        bmat (i1,i2) = 0.d0
  40  continue
      xn = 0.d0

      do 200 ip1=0,nph
        if (novr(ip1) .gt. 0 ) then
           nlast = novr(ip1)
        else
           iat0 = iatph(ip1)
           ntmp = 1
           nlast = nat
        endif
        if (irav.eq.1) then
          rav = (rmt(ip1) + rnrm(ip1)) / 2
        elseif (irav.eq.0) then
          rav =  rnrm(ip1)
        else
          rav=ri(imt(ip1)+1)
        endif
        if (lnear(ip1)) rav=ri(imt(ip1)+1)

        do 190 iat = 1,nlast
          if (novr(ip1) .gt. 0 ) then
             ntmp = nnovr(iat,ip1)
             ip2 = iphovr(iat,ip1)
             rnn = rovr(iat,ip1)
          else
            if (iat.eq.iat0) goto 190
            ip2 = iphat(iat)
            rnn = dist (rat(1,iat0), rat(1,iat))
          endif

c         correct for double counting volume and area
          if (rnn .lt. rmt(ip1)+rmt(ip2)) then
c            correct interstitial volume
             volint = volint + xnatph(ip1) * ntmp *
     1       (calcvl( rmt(ip1), rmt(ip2), rnn) +
     2       calcvl(rmt(ip1), rmt(ip2), rnn)) / 2.d0
          endif

c         using expression for vtot(jri) ,(jri=i1)
c         first fill  matrix bmat
          ix1 = ip1+1

          if (rav+rmt(ip2) .le. rnn) goto 100
          imin2 = ii( rnn-rav )
          if (imt(ip2)-imin2 .ge. novp-1) then
             write(slog,132) ip1
  132        format(' FOLP for POTENTIAL type ',i3,' is too big.')
             call wlog (slog)
             write(slog,'(a)') ' Reduce overlap using FOLP and rerun'
             call wlog (slog)
             call par_stop('MOVRLP-1')
          endif
          imin2=imt(ip2)-novp+1

          do 80 i2 = imin2,imt(ip2)
             r1=ri(i2)/exphx
             r2=ri(i2)*exphx
             if (i2.eq.imt(ip2)) r2=rmt(ip2)
             if (i2.eq.imt(ip2))   r1=(r1+2*ri(imt(ip2))-rmt(ip2))/2.d0
             if (i2.eq.imt(ip2)-1) r2=(r2+2*ri(imt(ip2))-rmt(ip2))/2.d0
             if (r2+rav .lt. rnn) goto 80
             if (r1+rav .lt. rnn) then
c               use linear interpolation between cases xr=0, xr=1
                xr = (rnn-rav-r1)/ (r2-r1)
                r1 = rnn-rav   
                temp =  (r2**2 - r1**2) / (4*rnn*rav) * ntmp
                ind2=i2+1
                if (i2.eq.imt(ip2))  ind2=i2-1
                xr = xr * (r2-ri(i2)) / (ri(ind2)-ri(i2))
                ix2 = ip2*novp + i2 - imin2 + 1
                bmat (ix1,ix2) = bmat (ix1,ix2) + real(temp*(1-xr))
                ix2 = ip2*novp + ind2 - imin2 + 1
                bmat (ix1,ix2)=bmat (ix1,ix2) + real(temp*xr)
             else
                temp = (r2**2 - r1**2) / (4*rnn*rav   ) * ntmp
                ix2 = ip2*novp + i2 - imin2 + 1
                bmat (ix1,ix2) = bmat (ix1,ix2) + real( temp)
             endif
  80      continue

c         using expression for vtot(i) ,(i<jri)
c         construct matrix  cmovp
 100      if (rmt(ip1)+rmt(ip2) .le. rnn) goto 190

          imin1=ii(rnn-rmt(ip2))
          imin2=ii(rnn-rmt(ip1))
          if (imt(ip1)-imin1.ge.novp-1 .or. imt(ip2)-imin2.ge.novp-1) 
     1               call par_stop('tell authors to INCREASE NOVP')
          imin1=imt(ip1)-novp+1
          imin2=imt(ip2)-novp+1

          do 180 i1 = imin1,imt(ip1)
            ri1=ri(i1)/exphx
            ri2=ri(i1)*exphx
            if (i1.eq.imt(ip1)) ri2=rmt(ip1)
            if (i1.eq.imt(ip1)) ri1=(ri1+2*ri(imt(ip1))-rmt(ip1))/2.d0
            if (i1.eq.imt(ip1)-1)
     1                         ri2=(ri2+2*ri(imt(ip1))-rmt(ip1))/2.d0
            ix1 = i1-imin1+1  + ip1*novp
            do 170 i2 = imin2,imt(ip2)
              r1=ri(i2)/exphx
              r2=ri(i2)*exphx
              if (i2.eq.imt(ip2)) r2=rmt(ip2)
              if (i2.eq.imt(ip2))   r1=(r1+2*ri(imt(ip2))-rmt(ip2))/2.d0
              if (i2.eq.imt(ip2)-1) r2=(r2+2*ri(imt(ip2))-rmt(ip2))/2.d0
              if (r2+ri2.lt.rnn) goto 170

c             calculate volume of intersection
              temp = calcvl(ri2,r2,rnn) + calcvl(r2,ri2,rnn)
              if (ri1+r2.gt.rnn)
     1          temp = temp - calcvl(ri1,r2,rnn) - calcvl(r2,ri1,rnn)
              if (ri2+r1.gt.rnn)
     1          temp = temp - calcvl(ri2,r1,rnn) - calcvl(r1,ri2,rnn)
              if (ri1+r1.gt.rnn)
     1          temp = temp + calcvl(ri1,r1,rnn) + calcvl(r1,ri1,rnn)
c             volume of intersection (temp) should be devided by volume
c             volume between spheres ri1 and ri2
              temp=temp / ( 4.d0/3.d0*pi * (ri2**3-ri1**3) ) * ntmp

              if (r1+ri2.lt.rnn) then
c               use linear interpolation between cases xr=0, xr=1
                xr = (rnn-ri(i1)-r1)/ (r2-r1)

                ind2=i2+1
                if (i2.eq.imt(ip2))  ind2=i2-1
                xr = xr * (r2-ri(i2)) / (ri(ind2)-ri(i2))
                ix2 = i2-imin2+1 + ip2*novp
                cmovp(ix1,ix2)=cmovp(ix1,ix2) 
     1                              +cmplx (temp*(1-xr))
                ix2 = ind2-imin2+1 + ip2*novp
                cmovp(ix1,ix2)=cmovp(ix1,ix2) 
     1                               +cmplx (temp*xr)
                r1=rnn-ri2
              else
                ix1 = i1-imin1+1 + ip1*novp
                ix2 = i2-imin2+1 + ip2*novp
                cmovp(ix1,ix2)=cmovp(ix1,ix2)  +cmplx (temp)
              endif
 170        continue
 180      continue

 190     continue
         xn = xn + xnatph(ip1)
  200 continue

c     using matrix bmat fill in the last row of matrix cmvovp
c     this is additional equation to find Vint.
c     switch to local equation from average over all atoms
      if (ipot .eq. 0) then
         do 260 iph=0, nph
c          xn may differ from nat, if atom list have more natx atoms
c          see rdinp.f
           aa = xnatph(iph)/xn
           do 250 ix1 = 1, ncp-1
  250      cmovp(ncp,ix1) = cmovp(ncp, ix1) + aa*bmat(iph+1,ix1)
  260    continue
      else  
         iph=0
         do 270 ix1 = 1, ncp-1
  270    cmovp(ncp,ix1) = cmovp(ncp, ix1) + bmat(iph+1,ix1)
      endif

c --- invert matrices by LU decomposition
c     call cgetrf from lapack.  this performs an LU decomposition on
c     the matrix 
      istatx=novp*(nphx+1) + 1
      call cgetrf( ncp, ncp, cmovp, istatx, ipiv, info )
      if (info.ne.0) then
          call wlog('    *** Error in cgetrf when computing cmovp')
      endif

c     have to check that the last was not permuted, otherwise
c     the density calculation will be wrong
c     this is also why we put 0.01 in last column and not 1.0
      if (ipiv(ncp).ne.ncp) 
     .  call par_stop('illegal permutation in ipiv ')

      return
      end
      subroutine ovp2mt( nph, vtot, lrewr, qtot,ri,xnatph,lnear,
     1             inrm, imt, rnrm, rmt, cmovp, ipiv, vint, inters)
c  INPUT: nph - number of diferent potentials
c   vtot(i,iph) - potential OR density at point i for potential iph
c   lrewr       - if lrewr .gt. 0 potential will be overwritten
c                   density is never overwritten (lcoul.lt.0)
c                  lrewr=0 density calculation
c                  lrewr=1 potential calculation, vint estimated
c                  lrewr=2 potential calculation, vint is fixed
c   lcoul       -  .gt.0  (potential only) calculate charge for each iph
c                  .eq.0  (potential only) flat interstitial potential 
c                  .lt.0  (density only) calc charge inside MT spheres
c   qtot       -  for density only, total electron charge of cluster
c   ri         -  loucks radial grid
c   xnatph     -  number of atoms of type iph in the cluster
c   cmovp      -  LU decomposed overlapped matrix from movrlp.f
c   ipiv       -  pivoting indices for matrix cmovp
c  OUTPUT
c    vtot    if lrewr.gt.0  decomposed overlapped potential
c            if lrewr.le.0  old prescription for potential inside MT
c              spheres or don't want to overwrite densities
c    vint    mt zero level for potentials; charge outside mt spheres for
c            densities

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      dimension vtot(251,0:nphx), xnatph(0:nphx)
      dimension inrm(0:nphx), imt(0:nphx), rmt(0:nphx), rnrm(0:nphx)
      dimension vtotav(0:nphx)
c     work space for linear algebra
      parameter (novp=40)
      complex cmovp(novp*(nphx+1)+1,novp*(nphx+1)+1)
      complex cvovp(novp*(nphx+1)+1)
      integer ipiv(novp*(nphx+1)+1)
      dimension  ri(251)
      character*13 trans
      dimension  crho(251)
      logical lnear
      dimension lnear(0:nphx)
cpot      character*30 fname

c      get ipot and irav from inters
      ipot = mod(inters,2)
      irav = (inters-ipot) / 2
c     prepare cvovp and bvec from vtot
      ncp=0
      do 25 ip1=0,nph
      do 25 i=1,novp
        ncp = ncp + 1
        ix1 = imt(ip1)-novp + i
        cvovp(ncp)= real( vtot(ix1,ip1) )
       if (lrewr.eq.2) cvovp(ncp) = cvovp(ncp) - vint
  25  continue
      do 27 ip1=0,nph
         if (irav .eq. 1) then
           rav = (rmt(ip1) + rnrm(ip1)) / 2
         elseif(irav.eq.0) then
           rav =  rnrm(ip1)
         else
           rav = ri(imt(ip1)+1)
         endif
         if (lnear(ip1)) rav = ri(imt(ip1)+1)
         call terp(ri,vtot(1,ip1),inrm(ip1)+2,3,rav,vtotav(ip1))
  27  continue
      istatx=novp*(nphx+1)+1
      trans = 'NotTransposed'
      nrhs = 1

c     find parameters for interstitial potential
      if (lrewr.gt.0) then
c        dealing with potentials
         if (lrewr.eq.1) then
c           additional equation to find vint
            ncp = ncp + 1
            cvovp(ncp) = 0
            bsum = 0
c           switch from average equation for vint to the local one
            nphlst = 0
            if (ipot .eq. 0) nphlst = nph
            do 430 iph=0,nphlst
               cvovp(ncp) = cvovp(ncp) + vtotav(iph)*xnatph(iph)
               bsum = bsum + xnatph(iph)
  430       continue
            cvovp(ncp) = cvovp(ncp) / bsum
         endif

         call cgetrs(trans, ncp, nrhs, cmovp, istatx,
     $               ipiv, cvovp, istatx, info)
         if (info.lt.0) then
             call par_stop('    *** Error in cgetrf')
c            stop
         endif

         if (lrewr.eq.1) vint = dble(real(cvovp(ncp))) /100.0

c        rewrite vtot
         do 550 iph=0,nph
 
cpot  to write out ovp tot pot and it's mt approxim, comment out cpot
cpot         write(fname,172)  iph
cpot  172    format('potp', i2.2, '.dat')
cpot         open (unit=1, file=fname, status='unknown', iostat=ios)
cpot         call chopen (ios, fname, 'wpot')

            do 500 i=1,novp
              index1=imt(iph)-novp + i
              index2=i+novp*iph

cpot            write(1,176) i, ri(index1), 
cpot     1             vtot(index1,iph),  dble(real(cvovp(index2)))+vint
cpot  176       format (1x, i4, 1p, 3e12.4)

              vtot(index1,iph) = dble(real(cvovp(index2)))+vint
  500       continue

cpot         close (unit=1)

c           use second order extrapolation
            j=imt(iph)+1
            call terp (ri,vtot(1,iph),imt(iph),2,ri(j),vtot(j,iph))
            do 505 j=imt(iph)+2, 251
  505       vtot(j,iph) = vint
  550    continue
      else
c        dealing with  density calculations. vint  is the total
c        charge inside mt spheres.
c        Divided by interstitial volume in istprm

         call cgetrs(trans, ncp, nrhs, cmovp, istatx,
     $            ipiv, cvovp, istatx, info)
         if (info.lt.0) then
             call par_stop('    *** Error in cgetrf')
c            stop
         endif

         vint = 0
         do 450 iph=0,nph
            do 440 i=1,imt(iph)+2
               if (i.lt.imt(iph)-novp+1) then
                 crho(i) =  vtot(i,iph)*ri(i)**2
               elseif (i.le. imt(iph)) then
                 ix1 = novp*iph +i-imt(iph)+novp
                 crho(i) = real(cvovp(ix1)) * ri(i)**2
c                crho(i) =  vtot(i,iph)*ri(i)**2
               else
                 call terp(ri,crho,imt(iph),2,ri(i), crho(i) )
               endif
  440       continue
            np = imt(iph) + 2
            cdum = 0
            dpas = 0.05d0
            call somm2 (ri,crho,dpas,cdum,rmt(iph),0,np)
            vint = vint + xnatph(iph) * cdum
  450    continue
         vint=qtot-vint
      endif

      return
      end
      subroutine fermi (rhoint, vint, xmu, rs, xf)

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}

c     calculate fermi level of the system (mu) according to formula
c     mu=vcoulomb(interstitial)+vxc(interstitial)+kf(interstitial)^2
c     formula  2.13 in lee and beni, phys. rev. b15,2862(1977)

c     note that vint includes both coulomb and ground state
c     exchange-correlation potentials

c     den is the interstitial density
c     rs is the density parameter
c     xf is the interstital fermi momentum
c     xmu is the fermi level in hartrees

      den = rhoint / (4*pi)
      rs = (3 / (4*pi*den)) ** third
      xf = fa / rs
      xmu = vint + xf**2 / 2

      return
      end
      subroutine sidx (rholap, npts, rmt, rnrm, imax, imt, inrm)

      implicit double precision (a-h, o-z)
      dimension rholap (npts)
      character*512 slog
c#mn
      external ii, rr

      imt = ii (rmt)
      inrm = ii (rnrm)

c     Set imax (last non-zero rholap data)
      do 220  i = imt, npts
         if (rholap(i) .le. 1.0e-5)  goto 230
         imax = i
  220 continue
  230 continue

c     We need data up to the norman radius, so move norman
c     radius if density is zero inside rnrm.
      if (inrm .gt. imax)  then
         inrm = imax
         rnrm = rr (inrm)
  232    format(a,1pe13.5)
         write(slog,232) ' Moved rnrm.  New rnrm (au) ', rnrm
         call wlog(slog)
      endif
      if (imt .gt. imax)  then
         imt = imax
         rmt = rr (imt)
         write(slog,232) ' Moved rmt.  New rmt (au) ', rmt
         call wlog(slog)
      endif
      return
      end
      subroutine pot (rgrd, nohole, inters, totvol, ecv0,
     $             nscmt, nmix, ntitle, title,
     $             nat, nph, ihole, gamach, iafolp,
     $             ixc, iphat, rat, iatph,
     $             xnatph, novr,
     $             iphovr, nnovr, rovr, folp0, xion, iunf, iz, ipr1,
     $             ispec, jumprm,
     $             lmaxsc, icoul, ca1, rfms1, lfms1)

c     Cluster code -- multiple shell single scattering version of FEFF
c     This program (or subroutine) calculates potentials and phase
c     shifts for unique potentials specifed by atoms and overlap cards.
c
c     Input files:  potph.inp    input data, atoms, overlaps, etc.
c     Output:       phases.bin   phase shifts for use by the rest of the
c                                program
c                   xxx.dat      various diagnostics

      implicit double precision (a-h, o-z)
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      Parameter (Maxprocs = 1)

c     Notes:
c        nat    number of atoms in problem
c        nph    number of unique potentials
c        ihole  hole code of absorbing atom
c        iph=0 for central atom

c     Specific atom input data
c     iphat - given specific atom, which unique pot?
      dimension iphat(natx)
c     rat(3,natx)  -  cartesian coords of specific atom
      dimension rat(3,natx)
      real rfms1

c     Unique potential input data
c     iatph(0:nphx) - given unique pot, which atom is model?
c                   (0 if none specified for this unique pot)
      dimension iatph(0:nphx)
c     xnatph(0:nphx) - given unique pot, how many atoms are there
c                      of this type? (used for interstitial calc)
      dimension xnatph(0:nphx)

c     folp(0:nphx)  - overlap factor for rmt calculation
      dimension folp(0:nphx), folp0(0:nphx), folpx(0:nphx)
c     novr(0:nphx)  - number of overlap shells for unique pot
      dimension novr(0:nphx)
c     iphovr(novrx,0:nphx)  - unique pot for this overlap shell
      dimension iphovr(novrx,0:nphx)
c     nnovr(novrx,0:nphx)  -  number of atoms in overlap shell
      dimension nnovr(novrx,0:nphx)
c     rovr(novrx,0:nphx)   -  r for overlap shell
      dimension rovr(novrx,0:nphx)

c     Free atom data
c     xion(0:nphx)  - ionicity, input
      dimension xion(0:nphx)
c     iz(0:nphx)  -   atomic number, input
      dimension iz(0:nphx)

c     ATOM output
c     Note that ATOM output is dimensioned 251, all other r grid
c     data is set to nrptx, currently 250
c     rho(251,0:nphx+1)     -   density*4*pi
      dimension rho(251,0:nphx+1)
c     vcoul(251,0:nphx+1)   -   coulomb potential
      dimension vcoul(251,0:nphx+1)
      dimension dr(251), drho(251), dvcoul(251)

c     Overlap calculation results
c     overlapped density*4*pi
      dimension edens(251,0:nphx)
c     overlapped coul pot
      dimension vclap(251,0:nphx), vclapp(251,0:nphx)
c     overlapped total potential
      dimension vtot (251,0:nphx)

c     Muffin tin calculation results
c     r mesh index just inside rmt
      dimension imt(0:nphx)
c     r mesh index just inside rnorman
      dimension inrm(0:nphx)
c     muffin tin radius
      dimension rmt(0:nphx)
c     norman radius
      dimension rnrm(0:nphx), qnrm(0:nphx), qold(0:nphx), lmaxsc(0:nphx)
      dimension xnmues(0:lx,0:nphx)
      character*80 title(nheadx)

      logical ok

      complex gtr((lx + 1) * (nphx + 1) * Maxprocs)
      complex*16 xrhoce((lx + 1) * (nphx + 1) * Maxprocs)
      complex*16 xrhole((lx + 1) * (nphx + 1) * Maxprocs)
      complex*16 yrhoce(251 * (nphx + 1) * Maxprocs )
      complex*16 yrhole(251 * (lx + 1) * (nphx + 1) * Maxprocs )
c     need irregular solution for complex potential. fix later
      dimension dgc0(251), dpc0(251)

c     additioal data needed for relativistic version
      dimension dgc(251,30,0:nphx+1), dpc(251,30,0:nphx+1)
      dimension adgc(10,30,0:nphx+1), adpc(10,30,0:nphx+1)
      dimension rhoval(251,0:nphx+1), edenvl(251,0:nphx)
      dimension vvalgs (251,0:nphx)

c     nrx = max number of r points for phase and xsect r grid
      parameter (nrx = nrptx)
      dimension ri(nrptx)
      dimension  dmag(251,0:nphx+1), xnvmu(0:lx,0:nphx+1)
      dimension  xnval(30,0:nphx+1), norb(0:nphx+1), eorb(30,0:nphx+1)
      dimension kappa(30,0:nphx+1), iorb(-4:3,0:nphx+1)
c       criteria for self-consistency
      parameter (tolq = 1.D-3)
      parameter (tolmu = 3.D-3)
      logical lpass
      character*512 slog
c     Josh use nhtmp to save nohole value
      integer nhtmp
   10 format (4x, a, i5)

c     Josh - for now if nohole=2 reset to 0 so that regular nohole
c     potential is used
      nhtmp = nohole
      if (nohole.eq.2) nohole = 0
c     Josh

c     variables ecv0 and folp0 serve as input only; do not change them
c     since it will change file feff.ior content
c     ecv and folp are passed through pot.bin to next modules.
      ecv = ecv0
      do 12 i = 0, nph
   12 folp(i) = folp0(i)

      call inipot (dgc, dpc, edenvl, vvalgs, xnmues)

c     increase the length of hydrogen bonds for potential only
      call moveh (nat, iphat, iz, rat)

      nfree = 1
      do 17 i=0,nph
        if (abs(xion(i)) .gt. 1.d-3) nfree = 2
  17  continue

c     Free atom potentials and densities
c     Final state is (usually) with a core hole, initial state is 
c     w/o a corehole.
c     NB wsatom is needed in SUMAX, if changed here, change it there
c     wsatom = 15
c     do not save spinors
c     Call twice if any of xion.neq.0 ( first time with xion=0 to set
c     rnrm)

      do 99 ifree = 1, nfree

      ispinr = 0
      do 20  iph = 0, nph
         write(slog,10) 
     1     'free atom potential and density for atom type', iph
         call wlog(slog)
c        Include corehole if absorber (unless user says nohole)
         if (iph .eq. 0)  then
            itmp = ihole
         else
            itmp = 0
         endif
         if (nohole.ge.0 .and. iph.eq.0) then
           xionp = xion(0)
           if (nfree.eq.2 .and. ifree.eq.1) xionp = 0
           call scfdat ( ipr1, nph+1, nph, iz(0), itmp, xionp, iunf,
     1     vcoul(1,nph+1), rho(1,nph+1), dmag(1,nph+1), rhoval(1,nph+1),
     2     ispinr, dgc0, dpc0, dgc, dpc, adgc, adpc, 
     3     s02, efrozn, et, xnvmu(0,nph+1),
     4     xnval(1,nph+1), iorb(-4,nph+1), norb(nph+1),
     5     eorb(1,nph+1), kappa(1,nph+1) )
         else
           xionp = xion(iph)
           if (nfree.eq.2 .and. ifree.eq.1) xionp = 0
           call scfdat ( ipr1, iph, nph, iz(iph), itmp, xionp, iunf,
     1         vcoul(1,iph), rho(1,iph), dmag(1,iph), rhoval(1,iph),
     2         ispinr, dgc0, dpc0, dgc, dpc, adgc, adpc, 
     3         s02, efrozn, et, xnvmu(0,iph),
     4         xnval(1,iph), iorb(-4,iph), norb(iph),
     5         eorb(1,iph), kappa(1,iph) )
         endif
c        etfin is absorbing atom final state total energy, see nohole
c           case below
         if (iph .eq. 0) etfin = et
   20 continue

      write(slog,10) 'initial state energy'
      call wlog(slog)
c     Save initial state energy and spinors for core hole orbital,
c     do not save potentials, except for nohole.
      ispinr = ihole
      itmp = 0
      if (nohole.ge.0) then
         iph = 0
         xionp = xion(iph)
         if (nfree.eq.2 .and. ifree.eq.1) xionp = 0
         call scfdat ( ipr1, iph, nph, iz(iph), itmp, xionp, iunf,
     1         vcoul(1,iph), rho(1,iph), dmag(1,iph), rhoval(1,iph),
     2         ispinr, dgc0, dpc0, dgc, dpc, adgc, adpc, 
     3         s02, efrozn, etinit, xnvmu(0,iph),
     4         xnval(1,iph), iorb(-4,iph), norb(iph),
     5         eorb(1,iph), kappa(1,iph) )
      else
         xionp = xion(0)
         if (nfree.eq.2 .and. ifree.eq.1) xionp = 0
         call scfdat ( ipr1, nph+1, nph, iz(0), itmp, xionp, iunf,
     1     vcoul(1,nph+1), rho(1,nph+1), dmag(1,nph+1), rhoval(1,nph+1),
     2     ispinr, dgc0, dpc0, dgc, dpc, adgc, adpc, 
     3     s02, efrozn, etinit, xnvmu(0,nph+1),
     4     xnval(1,nph+1), iorb(-4,nph+1), norb(nph+1),
     5     eorb(1,nph+1), kappa(1,nph+1) )
      endif

c     testing new potential for the final state. ala
      hx = 0.05
      x0 = -8.8
      if (nohole.gt.0) then
         idim = 251
         do 30 i = 1,idim
  30     dr(i) = exp(x0+hx*(i-1))
         if (nohole.eq.1) then
            do 40 i = 1,idim
  40        drho(i) = dgc0(i)**2 + dpc0(i)**2
         else
            do 50 i = 1,idim
               drho(i)=dr(i)**2 *
     1         (rho(i,0)-rhoval(i,0)-rho(i,nph+1)+rhoval(i,nph+1))
  50        continue
         endif
         call potslw ( dvcoul, drho, dr, hx,idim)
         do 60 i=1,idim
c           drho(i) = drho(i)/ dr(i)**2
c           use 1/2 of core-hole as in transition state
            drho(i) = drho(i)/2.0d0/ dr(i)**2
  60     continue
      else
         do 70 i=1,251
            drho(i) = 0
            dvcoul(i) = 0
  70     continue
      endif

c     etinit is absorbing atom initial state (no hole)
c     efrozn is ionization energy with frozen orbitals (koopman's
c      theorem)
c     etfin-etinit is ionization energy in adiabatic approximation
      erelax= -efrozn - ( etfin - etinit)
      emu = etfin - etinit

c     Overlap potentials and densitites
      do 90  iph = 0, nph
         write(slog,10)
     1    'overlapped potential and density for unique potential', iph
         call wlog(slog)
         call ovrlp (iph, iphat, rat, iatph, novr, iphovr,
     1               nnovr, rovr, iz, nat, rho, dmag,
     2               rhoval, vcoul, edens, edenvl, vclap, qnrm)
         if (iph.eq.0) emu = emu - vclap(1,0)+vcoul(1,0)
   90 continue
      if (ifree.eq.1) then
c       Set the Norman radii 
        do 92 iph =0, nph
   92   rnrm(iph) = qnrm(iph)
      endif

   99 continue
c  end of free atom calculations (might be done twice if ION used)

cc new patch
c     itest = 1
c     if (itest.eq.1) then
cc      use orbitals with core-hole for initial orbitals
cc      orthogonaliztion problem for NRIXS calculations
c       do i = 1, 251
c         dgc0(i) = dgc(i,0)
c         dpc0(i) = dpc(i,0)
c       enddo
c     endif
cc end new patch
     
c     Find total charges for istprm
c     qtotel - total number of e in a cluster
      qtotel = 0
      do 80 iph = 0,nph
         qtotel = qtotel + (iz(iph)-xion(iph)) * xnatph(iph)
  80  continue
c     photoelectron moves out of the system
c     do not remove now since we are putting screening electron back


c     Find muffin tin radii, add gsxc to potentials, and find
c     interstitial parameters
      write(slog,10) 'muffin tin radii and interstitial parameters'
      call wlog(slog)

      rmt(0) = -1
      xmu = 100.d0
      if (iafolp.ge.0) then
        do 101 iph=0,nph
          folpx(iph) = folp(iph)
          folp(iph) = 1
  101   continue
      endif
        
      idmag = 0
      call istprm (nph, nat, iphat, rat, iatph, xnatph,
     1            novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1            edens, edenvl, idmag,
     2            dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3            ixc, rhoint,vint, rs, xf, xmu, xmunew,
     4            rnrmav, qtotel, inters, totvol)
      xmu = xmunew

c     Automatic max reasonable overlap
      if (iafolp .ge. 0)  then
         call afolp (nph, nat, iphat, rat, iatph, xnatph,
     1               novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1               edens, edenvl,
     2               dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3               ixc, rhoint,vint, rs, xf, xmu, xmunew,
     4               rnrmav, qtotel, inters, totvol)
         xmu =xmunew
      endif

c     wp is plasmon frequency in hart
      wp = sqrt(12.*rs/fa**4) * xf**2 / 2.d0

c     Phase shift calculation
c     Atom r grid
      dx = 0.05d0
      x0 = 8.8d0

c     Find self-consistent muffin-tin potential.
      do 105 iph=0,nph
         qnrm(iph) = 0
         qold(iph) = 0
  105 continue

  100 continue
      if (nscmt.gt.0 .or. (ispec.ne.0 .and. ispec.lt.4)) call corval
     1                 ( ecv, xnvmu, eorb, norb, xnval,
     1                  kappa, rgrd, nohole,
     2                  nph, edens, edenvl, vtot, vvalgs,
     3                  rmt, rnrm, ixc, rhoint, vint, jumprm,
     4                  x0, ri, dx, xion, iunf, iz,
     5                  adgc, adpc, dgc, dpc, ihole, lmaxsc)


c     find a total number of valence electrons
c     xntot - required number of valence electrons below fermi level
c     xnvmu(iph) = xnvmu(iph)-xion(iph)
c     xnvmu - number of valence electron within norman sphere
      xntot=0.0d0
      do 120 iph=0,nph
         xnvmup = 0
         do 110  i = 0,lx
  110    xnvmup = xnvmup + xnvmu(i,iph)
c x35 and earlier   xntot = xntot + xnatph(iph)*(xnvmup+xion(iph))
         xntot = xntot + xnatph(iph) * xnvmup
  120 continue

c     need to update vxcval in case if the core-valence separation was
c     made in subroutine corval. Need vxcval only for nonlocal exchange.
      if (mod(ixc,10).ge.5) then
         call  istprm (nph, nat, iphat, rat, iatph, xnatph,
     1               novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1               edens, edenvl, idmag,
     2               dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3               ixc, rhoint,vint, rs, xf, xmu, xmunew,
     5               rnrmav, qtotel, inters, totvol)
         xmunew = xmu
      endif

      write(slog,130) xmu*hart
  130 format(' mu_old= ',f9.3)
      call wlog(slog)

c     do first nmix iterations with mixing scheme. Need for f-elements.
  140 nmix=nmix-1

c     number of processors for parallel execution
      npr = numprocs
      do 200 iscmt =1,nscmt
c        need to store coulomb potential
         do 145 ip=0,nph
         do 145 ir=1,251
  145    vclapp(ir,ip) = vclap(ir,ip)

         if (npr.le.1) then
           call scmt (  iscmt, ecv, nph, nat, vclap, edens,
     1                edenvl, vtot, vvalgs, rmt, rnrm, qnrm,
     2                ixc, rhoint, vint, xmunew, jumprm,
     3                xntot, xnvmu, xnval,
     4                x0, ri, dx, xnatph, xion, iunf, iz,
     5                adgc, adpc, dgc,dpc, ihole,
     7                rat, iatph, iphat, lmaxsc, rhoval, xnmues, ok,
     8                rgrd, nohole, nscmt, icoul, ca1, rfms1, lfms1)
         else
           call scmtmp (npr,  iscmt, ecv, nph, nat, vclap, edens,
     1                edenvl, vtot, vvalgs, rmt, rnrm, qnrm,
     2                ixc, rhoint, vint, xmunew, jumprm,
     3                xntot, xnvmu, xnval,
     4                x0, ri, dx, xnatph, xion, iunf, iz,
     5                adgc, adpc, dgc,dpc, ihole,
     7                rat, iatph, iphat, lmaxsc, rhoval, xnmues, ok,
     8                rgrd, nohole, nscmt, icoul, ca1, rfms1, lfms1,
     9                gtr, xrhole, xrhoce, yrhole, yrhoce )
         endif

         if (.not. ok) goto 100
c        if need to change core-valence separation then
c        start scmt loop all over again

c        write out Fermi level and charge transfers 
c        and do tests of self-consistency
         lpass = .true.
         if (iscmt.lt.nscmt .and. iscmt.le.3) lpass =.false.
         write (slog,150)   xmunew*hart
  150    format (' mu_new= ', f9.3)
         call wlog(slog)
         if (abs (xmunew - xmu) .gt. tolmu) lpass = .false.
         xmu = xmunew
c        print out charge 
         call wlog(' Charge transfer:  iph  charge(iph) ')
         do 170 iph=0,nph
            write (slog,180) iph, -qnrm(iph) + xion(iph)
            call wlog(slog)
            if (abs(qnrm(iph)-qold(iph)).gt.tolq) lpass = .false.
            qold(iph) = qnrm(iph)

c           check self-consistency of charges
            sum = -qnrm(iph)
            do 160 il=0,lx
  160       sum = sum + xnmues(il,iph) - xnvmu(il,iph)
            if (abs(sum).gt.0.05) lpass = .false.
  170    continue
  180    format('     ',i3, 2f9.3)

c        recalculate core density (edens) here. fix later. ala
c        call scfdat
c        for now use the old core density
         if (iscmt.eq.nscmt .or. lpass) then
c           restore  total density from previous iteration
            do 190 ip=0,nph
              do 185 ir=1,251
c                need total density for istprm
                 edens(ir,ip) = edens(ir,ip)-rhoval(ir,ip)+edenvl(ir,ip)
                 vclap(ir,ip) = vclapp(ir,ip)
  185         continue
c             remember the reported charge transfer
              qnrm(ip) = -qnrm(ip) + xion(ip)
  190       continue
c           exit self-consistency loop
            goto 210
         else
c           update valence density
            do 195 ip=0,nph
            do 195 ir=1,251
c              need total density for istprm
               edenvl(ir,ip) = rhoval(ir,ip)
  195       continue
         endif

         call  istprm (nph, nat, iphat, rat, iatph, xnatph,
     1               novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1               edens, edenvl, idmag,
     2               dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3               ixc, rhoint,vint, rs, xf, xmu, xmunew,
     5               rnrmav, qtotel, inters, totvol)
         xmunew = xmu
         if (nmix.gt.0) goto 140

  200 continue
c     suspicious exit: run out of iterations (iscmt=nscmt)

c     right exit from the loop: self-consistency is achieved
  210 continue

      if (worker) go to 400

      if (nohole.gt.0) then
c        testing new final state potential
         do 220 j = 1,251
  220    edens(j,0) = edens(j,0) - drho(j)
         
c        notice that vclap is actually for the next iteration
c        in SCMT loop, thus vclap may be wrong if self-consistency
c        has not been reached
         do 230 j = 1,251
  230    vclap(j,0) = vclap(j,0) - dvcoul(j)

         call  istprm (nph, nat, iphat, rat, iatph, xnatph,
     1      novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1      edens, edenvl, idmag,
     2      dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3      ixc, rhoint,vint, rs, xf, xmu, xmunew,
     5      rnrmav, qtotel, inters, totvol)
      endif

c    correct the excitation energy
c     emu = emu -vclap(1,0) + vcoul(1,0) done also above
c     emu = emu+xmu  should be done in principle but leads
c     to worse estimate of edge position. fix later. ala

      if (ipr1 .ge. 2)  then
         call wpot (nph, edens, imt, inrm,
     1              rho, vclap, vcoul, vtot, ntitle, title)
      endif

c     write stuff into pot.bin
      call wrpot (nph, ntitle, title, rnrmav, xmu, vint, rhoint,
     1            emu, s02, erelax, wp, ecv,rs,xf, qtotel,
     2            imt, rmt, inrm, rnrm, folp, folpx, xnatph,
     3            dgc0, dpc0, dgc, dpc, adgc, adpc,
     3            edens, vclap, vtot, edenvl, vvalgs, dmag, xnval,
     4            eorb(1,0), kappa(1,0), iorb, qnrm, xnmues, nhtmp,
     5            ihole, inters, totvol, iafolp, xion, iunf, iz, jumprm)

c     write misc.dat
      if (ipr1 .ge. 1)  then
         open (unit=1, file='misc.dat', status='unknown', iostat=ios)
         call chopen (ios, 'misc.dat', 'potph')
         call wthead(1, ntitle, title)
         close (unit=1)
      endif

      call wlog(' Done with module 1: potentials. ')

  400 call par_barrier

      return
      end
      subroutine scmtmp (npr, iscmt, ecv, nph, nat, vclap,
     2                edens, edenvl, vtot, vvalgs, rmt, rnrm,qnrm,
     2                ixc, rhoint, vint, xmu, jumprm,
     3                xnferm, xnvmu, xnval,
     4                x0, ri, dx, xnatph, xion, iunf, iz,
     5                adgc, adpc, dgc,dpc, ihole,
     7                rat,iatph,iphat, lmaxsc, rhoval, xnmues, ok,
     8                rgrd, nohole, nscmt, icoul, ca1, rfms1, lfms1,
     9                gtr, xrhole, xrhoce, yrhole, yrhoce )

c     Finds new Fermi level (xmu), electron counts (qnrm) 
c     and new valence densities (rhoval).

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
      real*8 wall_commend, wall_commst
      Parameter (Maxprocs = 1)

c     input
      dimension dmagx(nrptx), dmag0(251)
      dimension vclap(251,0:nphx)
      dimension vtot (251,0:nphx), vvalgs (251,0:nphx)
      dimension xnvmu(0:lx,0:nphx+1), rmt(0:nphx),rnrm(0:nphx)
      dimension xnval (30,0:nphx)
      dimension qnrm(0:nphx), dq(0:nphx)
      dimension ri(nrptx), ri05(251), nr05(0:nphx)
      dimension xnatph(0:nphx), iz(0:nphx), xion(0:nphx)
      dimension rat(3,natx),iatph(0:nphx),iphat(natx), lmaxsc(0:nphx)
      real  rfms1
c     input and output
      dimension edens(251,0:nphx), edenvl(251,0:nphx)
      dimension rhoval(251,0:nphx+1)

c     work space
      dimension xnmues(0:lx, 0:nphx)
      dimension dum(nrptx), vtotph(nrptx),vvalph(nrptx)
      dimension dgc(251,30,0:nphx+1), dpc(251,30,0:nphx+1)
      dimension adgc(10,30,0:nphx+1), adpc(10,30,0:nphx+1)
      dimension dgcn(nrptx,30), dpcn(nrptx,30)
      complex*16 ph(lx+1, 0:nphx)
      complex*16 xrhocp(0:lx,0:nphx), yrhocp(251,0:nphx)

c     special dimension for MPI
c     Maxprocs = max number of processors for parallel execution
c--   This is set in parallel.h
c     npr - actual number of processors is passed to this subroutine
      complex gtr(0:lx, 0:nph, Maxprocs)
      complex*16 xrhoce(0:lx,0:nph,Maxprocs)
      complex*16 xrhole(0:lx,0:nph,Maxprocs)
      complex*16 yrhoce(251,0:nph,Maxprocs)
      complex*16 yrhole(251,0:lx,0:nph,Maxprocs)

      integer iph
c     complex energy grid emg is decomposed into em and eref
      parameter (negx = 80)
      complex*16 emg(negx), em, eref, ee, ep, fl, fr, fxa
c     nflrx should be odd and defines the max of Im energy for
c     the countour 
      parameter (nflrx = 17)
      dimension step(nflrx)
c     stuff from feff.f for rdinp, pathfinder and genfmt
      logical wnstar, ok
c     Following passed to pathfinder, which is single precision.
      character*512 slog
      integer ient
      data ient /0/

c     save stuff from rdinp, so no need to call it again
      save   ri05, ient


      ient = ient + 1
      if (ient.eq.1) then
         xmu = -0.25d0
         do 15 i= 1,251
  15     ri05(i) = exp (-8.8+0.05*(i-1))
      endif

      write (slog,10) iscmt, nscmt
  10  format('              SCF ITERATION NUMBER',i3,'  OUT OF',i3)
      call wlog(slog)

      call wlog (' Calculating energy and space dependent l-DOS.')
      call wlog (' It takes time ...')

c     initialize new valence density
      do 16 iph=0,nphx
      do 16 ir=1,251
  16  rhoval(ir,iph) = 0

c     polarization average in scmt and ldos

      call grids (ecv, xmu, negx, neg, emg, step, nflrx)

c     ie - is number of energy points calculated
      ietot0 = 1
      ee = emg(1)
      ep = dble(ee)
      do 21 ipr=1,Maxprocs
      do 21 iph=0,nph
      do 21 il=0,lx
  21    xrhoce(il,iph, ipr) = 0
      do 22 iph=0,nphx
      do 22 il=0,lx
  22    xnmues(il,iph) = 0
      do 23 ipr=1,Maxprocs
      do 23 iph=0,nph
      do 23  ir = 1,251
  23  yrhoce(ir,iph,ipr) = 0
      iflr = nflrx
      iflrp = nflrx

      nproc = min(npr, Maxprocs)
      n1 = 1
      n2 = min(neg, nproc)

c     Start the cycle over energy points (ie)
  25  continue

c     slow loop for MPI execution
      ie = this_process + n1
      ietot = ietot0 + this_process
      if (ie .gt. n2) go to 200
        ipr = 1 + ie - n1
	if (worker) par_type = 3

c       print *,'process n1 n2 ietot',this_process,n1,n2,ietot

        if (ietot.eq.1 .or. mod(ietot,20).eq.0) then
           write(slog,30) ietot, dble(emg(ie))*hart
   30      format('     point # ', i3, '  energy = ', f7.3)
           call wlog(slog)
        endif

        do 100  iph = 0, nph
          do 35 i=1, 251
  35      dmag0(i) = 0.d0
cc        use spin-unpolarized case to get SCF. set dmagx to zero
cc        may want to replace dmag0 with dmag(1,iph) for spin-dependent
cc        extension of SCF procedure.
          call fixvar (rmt(iph),edens(1,iph),vtot(1,iph),dmag0,
     1                  vint, rhoint, dx, rgrd, jumprm,
     2                  vjump, ri, vtotph, dum, dmagx)
          if (mod(ixc,10) .ge.5) then
            if (jumprm .gt. 0) jumprm = 2
            call fixvar (rmt(iph), edenvl(1,iph), vvalgs(1,iph),
     1                dmag0, vint, rhoint, dx, rgrd , jumprm,
     2                vjump, ri, vvalph, dum, dmagx)
            if (jumprm .gt. 0) jumprm = 1
          endif

          call fixdsx (iph, dx, rgrd , dgc, dpc, dgcn, dpcn)
          jri = (log(rmt(iph)) + x0) / rgrd + 2
          jri1 = jri+1
          eref = vtotph(jri1)
          do 40 i = 1, jri1
  40      vtotph(i) = vtotph(i) - eref
          if (ixc.ge.5) then
            do 50 i = 1, jri1
  50        vvalph(i) = vvalph(i) - eref
          else
            do 60 i = 1, jri1
  60        vvalph(i) = vtotph(i)
          endif

           itmp = 0
           if (iph.eq.0 .and. nohole.lt.0) itmp = ihole
           call rholie( ri05, nr05(iph), rgrd, x0, ri, emg(ie), ixc,
     2           rmt(iph), rnrm(iph), vtotph, vvalph, xnval(1,iph),
     3           dgcn, dpcn, eref, adgc(1,1,iph), adpc(1,1,iph),
     4           xrhole(0,iph,ipr), xrhoce(0,iph,ipr),
     5           yrhole(1,0,iph,ipr), yrhoce(1,iph,ipr),
     6           ph(1,iph), iz(iph), xion(iph), iunf, itmp,lmaxsc(iph))
  100   continue

c       Write out phases for fmsie
c       transform neg,emg to em,ne,eref first
        em= dble(emg(ie))
        eref=dble(eref)-coni*dimag(emg(ie))

cc      call fms for a cluster around central atom
        do 115 iph0 = 0,nph
        do 115 il = 0, lx
  115   gtr(il,iph0,ipr) = 0
        if (rfms1 .gt. 0) then
          if (lfms1 .ne. 0) then
            iph0 = 0
c           set logic to call yprep on every processor
            lfms = lfms1
            if (ietot0.eq.1) lfms = 2
            call fmsie( iph0, nph, lmaxsc, ietot, em, eref, ph, iz,
     1           rfms1, lfms, nat, iphat, rat, gtr(0,0,ipr))
          else
            do 190 iph0 = 0, nph 
  190       call fmsie( iph0, nph, lmaxsc, ietot, em, eref, ph, iz,
     1           rfms1, lfms1, nat, iphat, rat, gtr(0,0,ipr))
          endif
        endif
  200 continue
c     end of slow loop for MPI execution

      ietot0 = ietot0 + n2 - n1 + 1
      if (worker) par_type = 2

      ixl = (lx + 1) * (nph + 1)
      ixly = ixl * 251
      ixlc = (nph + 1) * 251
      if (nproc .gt. 1) then
        call seconds(wall_commst)
        if (worker .and. (ie .le. n2)) then
c-- Send pointers for gtr buffer to master
          call par_send_int(ixl,1,0,this_process)
          call par_send_int(ixly,1,0,this_process)
          call par_send_int(ixlc,1,0,this_process)
c-- Send buffer
          if (ixl .ne. 0) then
            call par_send_cmplx(gtr(0,0,ipr),ixl,0,this_process)
            call par_send_dc(xrhoce(0,0,ipr),ixl, 0, this_process)
            call par_send_dc(xrhole(0,0,ipr),ixl, 0, this_process)
	  endif
	  if (ixly .ne. 0)  
     .      call par_send_dc(yrhole(1,0,0,ipr),ixly, 0, this_process)
	  if (ixlc .ne. 0)  
     .      call par_send_dc(yrhoce(1,0,ipr),ixlc, 0, this_process)
        else if (master) then
	  do i = 1,n2-n1
c-- Receive pointers for gtr buffer from i
	    call par_recv_int(ixl,1,i,i)
	    call par_recv_int(ixly,1,i,i)
	    call par_recv_int(ixlc,1,i,i)
c-- Receive buffer from i
	    if (ixl .ne. 0) then
	      call par_recv_cmplx(gtr(0,0,i+1),ixl,i,i)
	      call par_recv_dc(xrhoce(0,0,i+1),ixl,i,i)
              call par_recv_dc(xrhole(0,0,i+1),ixl,i,i)
	    endif
	    if (ixly .ne. 0)
     .        call par_recv_dc(yrhole(1,0,0,i+1),ixly,i,i)
	    if (ixlc .ne. 0)
     .        call par_recv_dc(yrhoce(1,0,i+1),ixlc,i,i)
	  enddo
	endif
c-- Broadcast gtr
c-- Needed here since we aren't done yet
	ilen = ixl * (n2 - n1 + 1)
	ileny = ilen * 251
	ilenc = (nph + 1) * (n2 - n1 + 1) * 251
        call par_bcast_cmplx(gtr(0,0,1),ilen,0)
        call par_bcast_dc(xrhoce(0,0,1),ilen,0)
        call par_bcast_dc(xrhole(0,0,1),ilen,0)
        call par_bcast_dc(yrhole(1,0,0,1),ileny,0)
        call par_bcast_dc(yrhoce(1,0,1),ilenc,0)
        call seconds(wall_commend)
        wall_comm = wall_comm + wall_commend - wall_commst
      endif
       
c     fast loop (does not need parallel execution)
c     uses results of the above loop to find Fermi level
c     and to decide on next set of energy points
      do 300 ie = n1, n2
        ipr = 1+ ie -n1
        ee = emg(ie)

        if (ie.eq.1 .and. iflrp.ne.1) then
c         the absolutely first point on energy grid
          do 206 iph = 0,nph
          do 206 il = 0,lx
  206     xrhocp(il,iph) = xrhoce(il,iph, ipr)
          do 207 iph = 0,nph
          do 207 i = 1,251
  207     yrhocp(i,iph) = yrhoce(i,iph, ipr)
        endif

        xntot = 0
        if (ie.eq.neg .and. iflrp.gt.1) iflr = 1
        fl = 0
        fr = 0
        do 210 iph = 0,nph
c         calculate density and integrated number of electrons in each
c         channel for each type of atoms density, etc., find xntot. 
          call ff2g (gtr(0,iph,ipr), iph,ie, nr05(iph), xrhoce(0,0,ipr), 
     1      xrhole(0,iph,ipr), xrhocp, ee, ep, yrhole(1,0,iph,ipr),
     2      yrhoce(1,iph,ipr),yrhocp(1,iph),rhoval(1,iph),
     3      xnmues(0,iph), xnatph(iph), xntot, iflr, iflrp, fl, fr,iunf)
  210   continue

c       check whether Fermi level is found between points n1 and n2
c       and decide on next set of energy points;
        if (ie.ne.1 .or. iflrp.eq.1) xndifp = xndif
        xndif = xntot - xnferm
c       if (master) print*,'xndif = ', xndif, 'xntot = ',xntot

c       check if the fermi level is found
        if ( iflr.eq.1) then
          if (xndifp*xndif .le. 0.e0) then
c         Fermi level is found ; exit from energy loop
             if (xndif.eq.0) then
               xmunew = dble(emg(ie))
               a=0
             else
               a = xndif/(xndif-xndifp)
               do 220 i = 1,4
                 fxa = a*fl + (1-a)*fr
                 bb = dimag((ep-ee)*(fr+fxa)/2 + coni*dimag(ee)*(fr-fl))
                 xndif1 = xndif + a * bb
                 a = a - xndif1 / bb
  220          continue
               xmunew = dble((1-a)*ee+a*ep)
             endif

c            add end cap corrections to the configuration and density
c            factor 2 for spin degeneracy
             do 250 iph = 0,nph
               do 230 il = 0,lx
                if (il.le.2 .or. iunf.ne.0) then
                 fl = xrhocp(il,iph) * 2
                 fr = xrhoce(il,iph,ipr) * 2
                 fxa = a*fl + (1-a)*fr
                 bb = dimag((ep-ee)*(fr+fxa)/2 + coni*dimag(ee)*(fr-fl))
                 xnmues(il,iph) = xnmues(il,iph) + a * bb
                endif
  230          continue
               do 240 ir = 1,nr05(iph)
                 fl = yrhocp(ir,iph) * 2
                 fr = yrhoce(ir,iph,ipr) * 2
                 fxa = a*fl + (1-a)*fr
                 bb = dimag((ep-ee)*(fr+fxa)/2 + coni*dimag(ee)*(fr-fl))
                 rhoval(ir,iph) = rhoval(ir,iph) + a * bb
  240          continue
  250        continue

c            exit from the energy loop
             goto 305
          endif
        endif
        ep = emg(ie)
        do 256 iph = 0,nph
        do 256 il = 0,lx
  256   xrhocp(il,iph) = xrhoce(il,iph, ipr)
        do 257 iph = 0,nph
        do 257 i = 1,251
  257   yrhocp(i,iph) = yrhoce(i,iph, ipr)

 300  continue

      if (n2.lt.neg .and. iflrp.gt.1) then
        n1 = n2+1
        n2 = min(neg, n2+nproc)
      else
c       set direction of search
        iflr = 1
        iflrp = 1
        idir = -1
        if (xndif.lt.0) idir = 1
        n1 = 1
        n2 = min(nproc, negx)
        do 303 ie = n1, n2
 303    emg(ie) = ep+ idir*step(iflr) * ie
      endif
      goto 25

c     END of the loop over energy in complex plane.
c     new fermi level and densities are calculated.
 305  continue

c     report configuration; repeat iteration if found bad counts.
      ok = .true.
      call wlog('  Electronic configuration')
      call wlog('   iph    il      N_el')
 310  format (2i6, f9.3)
      do 320 ip= 0,nph
      do 320 il = 0,lx
         write (slog,310) ip,il,xnmues(il,ip)
         call wlog(slog)
c        check that occupation numbers are consistent with those
c        set in getorb.f
         diff = abs(xnmues(il,ip) - xnvmu(il,ip))
         if (diff.gt.13.1 .or. (il.eq.2 .and. diff.gt. 9.1) .or.
     1   (il.eq.1 .and. diff.gt.5.1) .or.
     2   (il.eq.0 .and. diff.gt.1.95)) then
            call wlog (' Found bad counts.')
            write (slog,311) xnvmu(il,ip)
  311       format('  Occupation number in getorb is ', f9.3)
            call wlog(slog)
            call wlog ('  Will repeat this iteration ')
            if (ient.gt.1) ok = .false.
         endif
 320  continue

c     if (.not. ok) then will restart SCF loop 
      if (ok) then
         xmu = xmunew
c        find rhoval via Broyden algorithm
         call broydn( iscmt, ca1, nph, xnvmu,
     1         nr05 , xnatph, rnrm, qnrm, edenvl, rhoval, dq)

c        calculate new vclap - overlap coulomb potential
         call coulom (icoul, nph, nr05 , rhoval, edenvl, edens,
     2     nat, rat, iatph, iphat, rnrm, dq, iz, vclap)

c       update array edens
        do 350 ip=0,nph
           do 330 ir=1,nr05 (ip)
             edens(ir,ip)=edens(ir,ip)-edenvl(ir,ip)+rhoval(ir,ip)
  330      continue
           do 340 ir=nr05 (ip)+1,251
             edens(ir,ip)=0.0d0
             edenvl(ir,ip)=0.0d0
  340      continue
  350   continue
      endif

      return
      end
c///////////////////////////////////////////////////////////////////////
c Distribution:  COMMON 1.0
c Copyright (c) [2002] University of Washington
c 
c This software was prepared in part with US Government Funding under
c DOE contract DE-FG03-97ER45623.

c Redistribution and use of this Distribution in source and binary
c formats, with or without modification is permitted, provided the 
c following conditions are met:
c 
c Redistributions must retain the above notices and the following list
c of conditions and disclaimer;
c 
c Modified formats carry the marking
c     "Based on or developed using Distribution: COMMON 1.0
c      COMMON 1.0 Copyright (c) [2002] University of Washington"
c 
c Recipient acknowledges the right of the University of Washington to
c prepare uses of this Distribution and its modifications that may be
c substantially similar or functionally equivalent to
c Recipient-prepared modifications.
c
c Recipient and anyone obtaining access to the Distribution through
c recipient's actions accept all risk associated with possession and
c use of the Distribution.
c
c THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
c WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
c MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
c IN NO EVENT SHALL THE UNIVERSITY OF WASHINGTON OR CONTRIBUTORS TO THE
c DISTRIBUTION BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
c EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
c PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
c REVENUE; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
c LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
c NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
c SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c
c     sub-program ffmod9
!     program  ffmod9
      subroutine ffmod9

c     Calculation of S_0^2 
c     written by Luke Campbell 2002
c     modified by Luke Campbell 2005 for new I/O structure

c     INPUT: s02.inp mod6.inp and any set of spectroscopy output files
c            (xmu.dat, chi.dat, chipNNNN.dat, feffNNNN.dat)
c     OUTPUT: specfunct.dat and the input spectroscopy files (overwritten)

      implicit double precision (a-h, o-z)
      character*12 cfname

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}


      call par_begin
      if (worker) go to 400
c     open the log file, unit 11.  See subroutine wlog.
      open (unit=11, file='logso2.dat', status='unknown', iostat=ios)
      call chopen (ios, 'logso2.dat', 'feff')

c     read  s02.inp
      call res02( mso2conv, ispec, ipr6, ipse, ipsk, wsigk, cen, cfname)

      if (mso2conv.eq.1) then 
        call wlog(' Calculating s_0^2 ...')

c       calculate S_0^2
        call so2conv (ispec, ipr6, ipse, ipsk, wsigk, cen, cfname)

        call wlog(' Done with s_0^2.')
      endif

  400 call par_barrier
      call par_end

c     sub-program ffmod9
!     stop
      return

      end
      subroutine sfconv(ekp,mu,gammach,npts2,wpts2,xchi,npts1,wpts1,
     2                spectf,weights,cchi,phase,iasym,icut,intout,omp)
* Convolutes the array xchi (signal) with the array spectf (spectral
* function or asymmetric broadening), where spectf
* has a delta function contribution of magnitude |weights(1)+i weights(2)|
* + weights(3).  Complex phase of weights(1) + i weights(2) is given 
* to overall phase of the otherwise real valued array spectf.
* Input: ekp - Photoelectron energy neglecting collective excitations.
*        mu - Chemical potential, position of edge.
*        gammach - Core hole lifetime.
*        npts2 - Dimension of signal array xchi.
*        wpts2 - Energy grid of signal.
*        xchi - Signal array.
*        npts1 - Dimension of spectral function array spectf.
*        wpts1 - Energy grid of spectral function.
*        weights - Array of weights of components of the spectral
*            function.  Only the delta function weights, weights(1)
*            and weights(3), and the imaginary part of the extrinsic
*            delta function, weights(2) are needed.
*        cchi - The magnitude of the convoluted signal.
*        phase - The phase of the convoluted signal.
*        iasym - set to 1 to include quasiparticle phase as an 
*            asymmetric 1/omega term to the etrinsic satellite
*            rather than as a complex spectral weight.  This is
*            necessary when convoluting with a real valued
*            function or one whose imaginary part is not known.
*        icut - set to 0 to avoid truncating the spectral function
*            at energies where there is insufficient energy to create
*            excitations.
*        intout - Flag to write diagnostic file, the running integration
*            of the convolution.
*        omp - Plasma frequency.
      implicit none
      integer npts1,npts2,i,j,intout,iasym,icut
      double precision wpts2(npts2),xchi(npts2),wpts1(npts1),
     2                 spectf(npts1),weights(8),cchi,phase,ekp,mu,
     3                 gammach,spectf2(npts1),wtmp,qpr,omp
*       spectf2 - The spectral function with a cutoff to prevent 
*           excitation energies higher than the total available 
*           energy in the system (ekp-mu).
*       wtmp - The new quasiparticle weight in going 
*           from spectf to spectf2.
*       qpr - Quasiparticle reduction, from renormalizing 
*           spectral function.
      double precision xrcchi,xicchi,xnorm,dw,w,www,xfact,
     2                 xrchi,am,phasez,efrac,pi,eV,store,
     3                 amp,del,lam
*       xrcchi - Real part of convoluted signal.
*       xicchi - Imaginary part of convoluted signal.
*       xnorm - Total weight of spectral function with cutoff,
*           used to normalize the spectral function.
*       dw - Energy interval.
*       w - Exitation energy (omega)
*       www - Quasiparticle energy, available energy minus excitation energy.
*       xfact - Used to store intermediate calculations.
*       xrchi - Convoluted signal before quasiparticle phase shift.
*       am - Magnitude of quasiparticle weight.
*       phasez - Quasiparticle phase.
*       efrac - Fractional distance from one energy grid point to
*           the next, used in interpolation.
*       pi - Ratio of circumference to diameter of a circle in
*           euclidian geometry.
*       eV - Unit conversion to electron volts.
*       store - Dummy variable used to store a value that will be 
*           overwritten but needs to be used again.
*       amp - "Amplitude", signal value at first data point,
*           used for extrapolating signal to lower energies to avoid
*           artifacts.
*       lam - "Lambda", decay constant for extrapolating signal below the
*           first data point.
*       del - "Delta", energy difference used in extrapolation of signal
*           below the first data point.
      parameter (eV=1.d0/27.21160d0)

      pi=dacos(-1.d0)
      xrcchi=0.d0
      xicchi=0.d0
*      iasym=0
* Extrinsic delta function (quasiparticle) weight.
      if (iasym.eq.1) then
        am=weights(1)
      else
        am=dsqrt(weights(1)**2+weights(2)**2)
      endif
* Quasiparticle phase.
      if (weights(1).ne.0.d0.and.iasym.ne.1) then
        phasez=datan(weights(2)/weights(1))
      else
        phasez=0.d0
      endif
* Reduce quasiparticle weight in accord with the same energy cutoff
* constraints used for the rest of the spectral function.
      if (icut.eq.0) then
        qpr=1.d0
      elseif (ekp-mu.ne.0.d0) then
        qpr=datan2(gammach,mu-ekp)/pi
      else
        qpr=0.5d0
      endif
      wtmp=qpr*(am+weights(3))
      xnorm=wtmp
* Cut off that portion of spectral function with more energy than is
* available in the system.
      do i=1,npts1
        if (i.eq.1) then
          dw=wpts1(2)-wpts1(1)
        elseif (i.eq.npts1) then
          dw=wpts1(npts1)-wpts1(npts1-1)
        else
          dw=(wpts1(i+1)-wpts1(i-1))/2.d0
        endif
        w=wpts1(i)
        www=ekp-w
* Construct weight function, cutoff at chemical potential, width 
* equal to core hole lifetime.
        if (icut.eq.0) then
          xfact=1.d0
        elseif (www-mu.ne.0.d0) then
          xfact=datan2(gammach,mu-www)/pi
        else
          xfact=0.5d0
        endif
* Multiply spectral function by cutoff weight function.
        if (icut.eq.0) then
          spectf2(i)=spectf(i)
        elseif (w.ge.0.d0) then
          spectf2(i)=spectf(i)*xfact
        else
          spectf2(i)=max(0.d0,spectf(i)*xfact)
        endif
        if (iasym.eq.1) then
          spectf2(i)=spectf2(i)-qpr*(weights(2)/(pi*am*dw))
     2      *log(((w+dw/2.d0)**2+(3.d0*dw)**2)
     3         /((w-dw/2.d0)**2+(3.d0*dw)**2))
     4         *exp(-((w)/(2*omp))**2)/2.d0
        endif
* Integration to find total spectral weight.
        xnorm=xnorm+spectf2(i)*dw
      enddo
* Main convolution loop.
      do i=1,npts1
        if (i.eq.1) then
          dw=wpts1(2)-wpts1(1)
        elseif (i.eq.npts1) then
          dw=wpts1(npts1)-wpts1(npts1-1)
        else
          dw=(wpts1(i+1)-wpts1(i-1))/2.d0
        endif
        w=wpts1(i)
        www=ekp-w
        xrchi=0
        if (www.gt.wpts2(npts2)) then
* Extrapolate signal to avoid artifacts.
          xrchi=xchi(npts2)
        elseif (www.le.wpts2(1)) then
* Extrapolate signal to avoid artifacts.
          amp=xchi(1)
          del=mu-wpts2(1)
          lam=del**2/(pi*dabs(amp)*(del**2+gammach**2))
          xrchi=amp*exp(lam*(www-wpts2(1)))
        else
* Interpolate signal onto spectral function energy.
          do j=1,npts2-1
            if (www.gt.wpts2(j).and.www.le.wpts2(j+1)) then
              efrac=(www-wpts2(j))/(wpts2(j+1)-wpts2(j))
              xrchi=xchi(j)+(xchi(j+1)-xchi(j))*efrac
              goto 50
            endif
          enddo
        endif
50      continue
        if ((w+wpts1(i-1))/2.d0.lt.0.d0.and.
     2      (w+wpts1(i+1))/2.d0.ge.0.d0) then
* Add delta function contribution.
          xrcchi=xrcchi+wtmp*xrchi
        endif
* Convolution integration.
        xrcchi=xrcchi+spectf2(i)*dw*xrchi
* Print diagnostic files of running integration if requested.
        if (intout.ne.0) then
          if ((w+wpts1(i-1))/2.d0.lt.0.d0.and.
     2        (w+wpts1(i+1))/2.d0.ge.0.d0) then
            write(28,500) www,xrcchi/xnorm,xrchi,am+weights(3),
     2           spectf2(i)/xnorm
          else
            write(28,500) www,xrcchi/xnorm,xrchi,spectf(i),
     2            spectf2(i)/xnorm
          endif
        endif
      enddo
* Add overall phase equal to quasiparticle phase.
      store=xrcchi
      xrcchi=store*dcos(phasez)-xicchi*dsin(phasez)
      xicchi=xicchi*dcos(phasez)+store*dsin(phasez)
      xrcchi=xrcchi/xnorm
      xicchi=xicchi/xnorm
      cchi=dsqrt(xrcchi**2+xicchi**2)
      phase=datan2(xicchi,xrcchi)

 500  format(1x,5(e12.5,1x))
 501  format(1x,7(e10.3,1x))
      return
      end
      subroutine croots (a,b,c,d,x1,x2,x3,nrroots)
* Solves the cubic polynomial ax^3+bx^2+cx+d=0.
* Returns the number of real roots nrroots and the three roots
* of the cubic polynomial.
      implicit none
      integer nrroots
      double precision a,b,c,d,p,q,r,ar,br,disc,disc2
      complex*16 AA,BB,yr,yi,y1,y2,y3,x1,x2,x3
      x1=0.d0
      x2=0.d0
      x3=0.d0
      if (a.eq.0.d0) then
        if (b.eq.0.d0) then
          if (c.eq.0.d0) then
            nrroots=0
            return
          endif
          nrroots=1
          x1=-d/c
          return
        endif
        disc=c**2-4.d0*d*b
        if (disc.ge.0.d0) then
          nrroots=2
        else
          nrroots=0
        endif
        x1=(-c+sqrt(dcmplx(disc,0.d0)))/(2.d0*b)
        x2=(-c-sqrt(dcmplx(disc,0.d0)))/(2.d0*b)
        return
      endif
      p=b/a
      q=c/a
      r=d/a
      ar=q-p**2/3.d0
      br=(2.d0*p**3-9.d0*p*q)/27.d0+r
      disc=br**2/4.d0+ar**3/27.d0
      if (disc.gt.0.d0) then
        nrroots=1
        disc2=-br/2.d0+sqrt(disc)
        if (disc2.ge.0.d0) then
          AA=dcmplx(disc2**(1.d0/3.d0),0.d0)
        else
          AA=dcmplx(-((-disc2)**(1.d0/3.d0)),0.d0)
        endif
        disc2=-br/2.d0-sqrt(disc)
        if (disc2.ge.0.d0) then
          BB=dcmplx(disc2**(1.d0/3.d0),0.d0)
        else
          BB=dcmplx(-((-disc2)**(1.d0/3.d0)),0.d0)
        endif
      else
        nrroots=3
        if (br.lt.0.d0) then
          AA=dcmplx(-br/2.d0,sqrt(-disc))**(1.d0/3.d0)
          BB=dcmplx(dble(AA),-dimag(AA))
        else
          AA=-dcmplx(br/2.d0,-sqrt(-disc))**(1.d0/3.d0)
          BB=dcmplx(dble(AA),-dimag(AA))
        endif
      endif
      yr=-(AA+BB)/2.d0
      yi=(AA-BB)*sqrt((-3.d0,0.d0))/2.d0
      y1=yr+yi
      y2=yr-yi
      y3=AA+BB
      x1=y1-p/3.d0
      x2=y2-p/3.d0
      x3=y3-p/3.d0
      return
      end
c**********************************************************************
c   This is Steve White's rewrite of Mike Teter's integration routine.
c   Modified by J. Rehr for complex integration.
c   The following is a listing of the arguments in the initial function
c   statement:
c      fn    -- routine requires external function statement in MAIN
c      xmin  -- lower limit
c      xmax  -- upper limit
c      abr   -- absolute tolerable error
c      rlr   -- relative tolerable error
c      nsing -- number of singularities or regions requiring
c                   special attention
c      xsing -- array of locations of singularities or endpoints
c                   of special regions
c      error -- output for routine error messages
c      numcal-- the number of times fn was called
c      maxns -- the maximum number of regions being considered simultaneously
c       function grater(fn,xmin,xmax,abr,rlr,nsing,xsing,error,numcal,maxns)
c       fn declared double precision
c       double precision function grater(fn,xmin,xmax,abr,rlr,
c       fn declared complex*16
c      complex*16 fn,value,valu,fval(3,mx),xmax,xmin,del,del1

       double precision function grater(fn,xmin,xmax,abr,rlr,
     1 nsing,xsing,error,numcal,maxns)

       implicit double precision (a-h,o-z)
       parameter (mx=1500)
       dimension xleft(mx),fval(3,mx),dx(3),wt(3)
       dimension wt9(9), xsing(20)
       external fn
        logical atsing
        save dx,wt,wt9
        data dx/0.1127016653792583  ,0.5  ,0.8872983346207417  /
        data wt/0.277777777777777778  ,0.4444444444444444444  ,
     1                               0.2777777777777777778  /
        data wt9/0.0616938806304841571  ,0.108384229110206161  ,
     1           0.0398463603260281088  ,0.175209035316976464  ,
     2           0.229732989232610220  ,0.175209035316976464  ,
     3           0.0398463603260281088  ,0.108384229110206161  ,
     4           0.0616938806304841571  /
c nstack is the number of different intervals into which the
c integration region is currently divided. The number of regions can
c grow if more accuracy is needed by dividing the right-most region
c into three regions. The number of regions shrinks when the integral
c over the right-most region is accurate enough, in which case that
c integral is added to the total (stored in grater) and the region
c is removed from consideration (and a new region is the right-most).
        nstack=nsing+1
        maxns = nstack
        error=0.
        grater=0.
c The array xleft stores the boundary points of the regions.
c The singular points just govern the initial placement of the regions.
        xleft(1)=xmin
        xleft(nsing+2)=xmax
        if(nsing.gt.0) then
          do 9 j=1,nsing
9           xleft(j+1)=xsing(j)
        endif
c For each region, calculate the function and store at three selected points.
        do 1 jj=1,nstack
          del=xleft(jj+1)-xleft(jj)
c         print*, 'fn call j= ,'
          do 1 j=1,3
c         print*, 'fn call in grater j= ',j
1           fval(j,jj)=fn(xleft(jj)+del*dx(j))
c         print*, 'output of fn call, fval(j,jj)',fval(j,jj)
        numcal = nstack * 3
6       continue
          if(nstack+3.ge.mx) then
            write(*,*) 'TOO MANY REGIONS'
            stop 0006
          endif
c Divide the rightmost region into three subregions.
          del=xleft(nstack+1)-xleft(nstack)
          xleft(nstack+3)=xleft(nstack+1)
          xleft(nstack+1)=xleft(nstack)+del*dx(1)*2.
          xleft(nstack+2)=xleft(nstack+3)-del*dx(1)*2.
c The three data points already found for the region become the
c middle data points (number 2 in first index of fval) for each region.
          fval(2,nstack+2)=fval(3,nstack)
          fval(2,nstack+1)=fval(2,nstack)
          fval(2,nstack)=fval(1,nstack)
c Now do the integral over the right-most region in two different ways-
c a three point integral (valu) over each of the three subregions
c and a more accurate nine-point integral (value) over whole region.
c valu is used only for the error estimate.
          icount=0
          value=0.
          valu=0.
          do 3 j=nstack,nstack+2
            del1=xleft(j+1)-xleft(j)
c         print*, 'fn call 2'
            fval(1,j)=fn(xleft(j)+dx(1)*del1)
            fval(3,j)=fn(xleft(j)+dx(3)*del1)
c         print*, 'fn call 2'
            numcal = numcal + 2
            do 5 k=1,3
              icount=icount+1
              value=value+wt9(icount)*fval(k,j)*del
5             valu=valu+fval(k,j)*wt(k)*del1
3         continue
          dif=abs(value-valu)
c If the following condition is true, add in this integral to the total,
c and reduce the number of regions under consideration.
          frac = del / (xmax - xmin)
          atsing = .false.
          if(frac .le. 1.0e-8) atsing = .true.
          if(dif .le. abr*frac .or. dif.le.rlr*abs(value) .or.
     1       (atsing .and.
     2     (frac .le. 1.0e-15 .or. dif .le. abr*0.1  ))) then
c The following commented out line is Teeter's old error criterion.
c          if(dif.le.abr.or.dif.le.rlr*abs(value))then
            grater=grater+value
            error=error+abs(dif)
            nstack=nstack-1
c If no more regions, we are done.
            if(nstack.le.0) return
          else
c If the integration is insufficiently accurate, make each of the
c three subregions of the right-most region into regions.
c On next pass the right-most of these is the new current region.
            nstack=nstack+2
            maxns = max(maxns,nstack)
          endif
        go to 6
        end
      subroutine interpsf(npts,epts,wpts,spectf,cspec)
* Interpolates the spectral function calculated on a minimal grid
* to a uniform grid that can be handled by the convolution subroutine.
* input: npts - number of grid points the spectral function will
*               be interpolated on to.
*        epts - energy values of the minimal grid
*        wpts - energy values of the uniform grid
*        spectf - the spectral function on the minimal grid
*        cspec - the spectral function on the uniform grid
      implicit none
      integer npts,nsfpts,i,j
*      parameter (nsfpts=80)
      parameter (nsfpts=110)
      double precision spectf(8,nsfpts),cspec(npts),epts(nsfpts),
     2                 wpts(npts),wmin,wmax,dw,sfhi,sflo,delw
      double precision pi,ef,fmu,qf,omp,ompl,wt,ekp,ek,qpk,acc,brd,adisp
      common /convsf/ pi,ef,fmu,qf,omp,ompl,wt,ekp,ek,qpk,acc,brd,adisp
      double precision se,ce,width,z1,z1i,se2,xise
      common /energies/ se,ce,width,z1,z1i,se2,xise
      wmin=epts(1)
      wmax=epts(nsfpts)
      dw=(wmax-wmin)/(npts-1)
      wpts(1)=wmin
      do i=2,npts
        wpts(i)=wmin+dw*(i-1)
      enddo
      cspec(1)=spectf(2,1)+spectf(5,1)-2.d0*spectf(4,1)
      cspec(npts)=spectf(2,nsfpts)+spectf(5,nsfpts)
     2            -2.d0*spectf(4,nsfpts)
      do i=2,npts-1
        do j=2,nsfpts
          if (wpts(i).ge.epts(j-1).and.wpts(i).lt.epts(j)) then
            delw=wpts(i)-epts(j-1)
            sfhi=spectf(2,j)+spectf(5,j)-2.d0*spectf(4,j)
            sflo=spectf(2,j-1)+spectf(5,j-1)-2.d0*spectf(4,j-1)
            cspec(i)=sflo+(sfhi-sflo)*delw/(epts(j)-epts(j-1))
            goto 10
          endif
        enddo
 10     continue
      enddo
      return
      end
      subroutine mkrmu(xmu,xmu0,rmu,wpts,npts)
* This subroutine does a Cramers-Kronig transform on the array xmu
* and returns an array rmu which is the real part of the analytic
* function whose imaginary part is xmu.  This is needed to get the proper
* phase shift for a convolution with a real function.
      implicit none
      integer npts,i,j
      double precision xmu(npts),xmu0(npts),rmu(npts),wpts(npts)
      double precision dw,pi
      pi=dacos(-1.d0)
      do j=1,npts
        rmu(j)=0.d0
        do i=1,npts
          if (i.eq.1) then
            dw=wpts(2)-wpts(1)
          elseif (i.eq.npts) then
            dw=wpts(npts)-wpts(npts-1)
          else
            dw=(wpts(i+1)-wpts(i-1))/2.d0
          endif
          if (i.ne.j) then
            rmu(j)=rmu(j)+dw*(xmu(i)-xmu0(i))/(wpts(i)-wpts(j))
          endif
        enddo
        rmu(j)=rmu(j)/pi
      enddo
      rmu(20)=(rmu(20)+rmu(21))/2.d0
      rmu(21)=rmu(20)
 500  format(1x,5(e12.5,1x))
      return
      end
      double precision function xmkesat(w)
* Find the extrinsic satellite spectral function.  This is the extrinsic 
* spectral function with the quasiparticle pole subtracted off and the 
* quasiparticle broadening removed.
* input: w - energy (omega)
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       omp - plasma frequency omega_p
*       se - real part of the on shell self energy
*       width - absolute value of the imaginargy part of the 
*            on shell self energy plus the core hole broadening
*       se2 - real part of the self energy at energy w
*       xise - imaginary part of the self energy at energy w
*       z1 - real part of the renormalization constant
*       z1i - imaginary part of the renormalization constant
      implicit none
      integer it1,it2
      double precision w,etot,emain,etothi,etotlo,z1m
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision se,ce,width,z1,z1i,se2,xise
      common /energies/ se,ce,width,z1,z1i,se2,xise
      z1m=sqrt(z1**2+z1i**2)
*      etot=-z1*(width-xise)+z1i*(w+se-se2)
      etot=-(width-xise)
      etot=etot/((w+se-se2)**2+(width-xise)**2)
*      it1=int(xmkesat)
*      it2=int(2*xmkesat)
*      if(it1.eq.it2.and.it1.gt.5) then
*        etot=-sqrt(z1**2+z1i**2)*(width-xise)
*        etothi=etot/((w+omp*1.d-3+se-se2)**2+(width-xise)**2)
*        etotlo=etot/((w-omp*1.d-3+se-se2)**2+(width-xise)**2)
*        etot=(etothi+etotlo)/2.d0
*      endif
*      emain=0.d0
      emain=-z1i/(w*pi*z1m)
      emain=emain*exp(-(w/(2*omp))**2)
      xmkesat=etot/(pi*z1m)-emain
*      it1=int(xmkesat)
*      it2=int(2*xmkesat)
*      if(it1.eq.it2.and.it1.gt.5) then
*        write(6,*) 'nan error: xmkesat'
*        write(6,*) z1,z1i,width,xise,w,se,se2,etot,xmkesat
*      endif
      return
500   format(1x,5(e12.5,1x))
      end

      double precision function xmkgwext(w)
* Find the extrinsic satellite, with full broadening and all quasiparticle
* contributions.
* input: w - energy (omega)
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       se - real part of the on shell self energy
*       se2 - real part of the self energy at energy w
*       xise - imaginary part of the self energy at energy w
      implicit none
      integer it1,it2
      double precision w,etot,emain
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision se,ce,width,z1,z1i,se2,xise
      common /energies/ se,ce,width,z1,z1i,se2,xise
      etot=xise/(pi*((w+se-se2)**2+xise**2))
      emain=0.d0
      xmkgwext=etot-emain
      it1=int(xmkgwext)
      it2=int(2*xmkgwext)
      if(it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'nan error: xmkgwext'
        write(6,*) z1,z1i,width,xise,w,se,se2,etot,xmkgwext
      endif
      return
500   format(1x,5(e12.5,1x))
      end

      double precision function xintxsat(q)
* the integrand of the interference spectral function
* input: q - momentum to be integrated over
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       omp - plasma frequency omega_p
*       ek - bare photoelectron kinetic energy = pk**2/2
*       brd - global broadening parameter to stabilize logarithms
*       ac2 - additional accuracy parameter
*       wp2 - omega prime, an additional energy variable
      implicit none
      integer numcal,maxns,nsing
      double precision wwq,q,xk,vpp2,wdisp,xfact,xloren,
     2       eps,ac2,wp2,dw1,abr,rlr,xsing,error,tol
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision se,ce,width,z1,z1i,se2,xise
      common /energies/ se,ce,width,z1,z1i,se2,xise
      common /ff/ ac2,wp2
      external vpp2,wdisp
      wwq=wdisp(q)
      tol=2.d-1*omp
      if (ek-wp2.ge.0.d0) then
        xk=sqrt(2.d0*(ek-wp2))
        xfact=log(((wwq-q**2/2+xk*q)**2+tol**2)/
     2            ((wwq-q**2/2-xk*q)**2+tol**2))/2.d0
        xloren=ac2/(pi*((wp2-wwq)**2+ac2**2))
        xintxsat=q*vpp2(q)*xloren*xfact/(wwq*xk)
      else
        xk=sqrt(-2.d0*(ek-wp2))
        xfact=datan(xk*q/(wwq-q**2/2))
        xloren=ac2/(pi*((wp2-wwq)**2+ac2**2))
        xintxsat=q*vpp2(q)*xloren*xfact/(wwq*xk)
      endif
      return
      end

      double precision function xintisat(q)
* the integrand of the intrinsic spectral function
* input: q - momentum to be integrated over
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ac2 - additional accuracy parameter
*       wp2 - omega prime, an additional energy variable
      implicit none
      integer numcal,maxns,nsing
      double precision wwq,q,xk,vpp2,wdisp,xfact,xloren,
     3       ac2,wp2,dw1,abr,rlr,xsing,error
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /ff/ ac2,wp2
      external vpp2,wdisp
      wwq=wdisp(q)
      xloren=ac2/(((wp2-wwq)**2+ac2**2)*pi)
      xintisat=q**2*vpp2(q)*xloren/wwq**2
      return
      end

      double precision function xmkxsat(w,width)
* generates the interference spectral function
* input: w - energy (omega)
*        width - additional broadening
* input from common blocks
*       omp - plasma frequency omega_p
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp2 - omega prime, an additional energy variable
      implicit none
      integer nsing,numcal,maxns,i
      double precision xintxsat,grater,abr,rlr,xsing,error,
     2       qk,wp,acc,pi,ef,xmu,qf,omp,ompl,wt,w,pk,width,
     3       ekp,ek,ac2,wp2,q2,qwidth,qmin,qmax,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /ff/ ac2,wp2
      external xintxsat,grater
      wp2=w
      ac2=width
      rlr=acc
      abr=omp*acc
      nsing=0
      q2=sqrt(max(2*(w-ompl),ac2))
      qwidth=10.d0*ac2/q2
      qmin=max(0.d0,q2-qwidth)
      qmax=q2+qwidth
*      do i=1,1000
*      enddo
*      write(6,*) 'xmkxsat'
      xmkxsat=grater(xintxsat,qmin,q2,
     2             abr,rlr,nsing,xsing,error,numcal,maxns)
      xmkxsat=xmkxsat+grater(xintxsat,q2,qmax,
     2             abr,rlr,nsing,xsing,error,numcal,maxns)
      xmkxsat=xmkxsat/(2.d0*pi)**2
      return
      end

      double precision function xmkisat(w,width)
* generates the intrinsic spectral function
* input: w - energy (omega)
*        width - additional broadening
* input from common blocks
*       omp - plasma frequency omega_p
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp2 - omega prime, an additional energy variable
      implicit none
      integer nsing,numcal,maxns
      double precision xintisat,grater,abr,rlr,xsing,error,
     2       qk,wp,acc,pi,ef,xmu,qf,omp,ompl,wt,z,w,pk,width,
     3       ekp,ek,ac2,wp2,q2,qmin,qmax,qwidth,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /ff/ ac2,wp2
      external xintisat,grater
      wp2=w
      ac2=width
      rlr=acc
      abr=omp*acc
      nsing=0
      if ((w-ompl).gt.ac2) then
        q2=dsqrt(2.d0*(w-ompl))
      else
        q2=dsqrt(2.d0*ac2)
      endif
      qwidth=10.d0*min(q2,ac2/q2)
      qmin=max(0.d0,q2-qwidth)
      qmax=q2+qwidth
      xmkisat=grater(xintisat,0.d0,q2,
     2             abr,rlr,nsing,xsing,error,numcal,maxns)
      xmkisat=xmkisat+grater(xintisat,q2,qmax,
     2             abr,rlr,nsing,xsing,error,numcal,maxns)
      xmkisat=xmkisat/(2.d0*pi**2)
      return
      end

*      double precision function xmkisat(w,width)
**     generates the intrinsic spectral function
*      implicit none
*      double precision w,wdisp,qdisp,dwdq,q,vpp2,width
*      double precision pi,ef,xmu,qf,omp,ekp,ek,pk,acc,brd,adisp
*      common /convsf/ pi,ef,xmu,qf,omp,ekp,ek,pk,acc,brd,adisp
*      external wdisp,dwdq,qdisp,vpp2
*      xmkisat=0.d0
*      if (w.gt.omp) then
*        q=qdisp(w)
*        xmkisat=q**2*vpp2(q)/(2.d0*pi**2*w**2*dwdq(q))
*      endif
*      return
*      end
*
*      double precision function xmkxsat(w)
**     generates the interference spectral function
*      implicit none
*      double precision w,q,wdisp,qdisp,dwdq,vpp2,xk,xfact,
*     2                 eta
*      complex*16 cfac,coni
*      parameter (coni=(0,1))
*      double precision pi,ef,xmu,qf,omp,ekp,ek,pk,acc,brd,adisp
*      common /convsf/ pi,ef,xmu,qf,omp,ekp,ek,pk,acc,brd,adisp
*      external wdisp,dwdq,qdisp,vpp2
*      xmkxsat=0.d0
*      eta=1.d-2*omp
*      if (w.gt.omp.and.ek.gt.w) then
*        q=qdisp(w)
*        xk=dsqrt(2.d0*(ek-w))
*        xfact=log(((w-q**2/2+xk*q)**2+(omp*acc)**2)/
*     2            ((w-q**2/2-xk*q)**2+(omp*acc)**2))/2.d0
**        cfac=log((w-q**2/2+xk*q-coni*eta)/(w-q**2/2-xk*q-coni*eta))
**        xfact=dble(cfac)
*        xmkxsat=q*vpp2(q)*xfact/((2.d0*pi)**2*xk*w*dwdq(q))
*      endif
*      return
*      end

      double precision function xmkak(w)
* This function returns the interference contribution to the 
* quasiparticle.
* input: w - energy (omega)
* input from common blocks
*       omp - plasma frequency omega_p
*       ek - bare photoelectron kinetic energy = pk**2/2
*       acc - global accuracy parameter 
*       wmax - highest allowed energy
* common block control of subprograms
*       pkq - momentum variable used in the integrand but kept 
*             fixed throughout the integration
      implicit none
      integer i,j,jj,nsing,numcal,maxns,it1,it2
      double precision w,qmax,xintak,
     2                 abr,rlr,error,xsing,grater
      integer nnpts
      double precision pkq
      common /funct2/ pkq
      double precision wmin,wmax,wmin1,wmax1
      common /limits/ wmin,wmax,wmin1,wmax1
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      external xintak
      if (w.gt.0.d0) then
        rlr=acc
        abr=dsqrt(omp)*acc
        qmax=dsqrt(2*wmax)
        pkq=dsqrt(2*ek)
        nsing=0
*        write(6,*) 'xmkak'
        xmkak=grater(xintak,abr,qmax,abr,rlr,nsing,xsing,
     2                 error,numcal,maxns)
      else
        xmkak=0.d0
      endif
      return
      end

      double precision function xintak(q)
* Integrand for the function xmkak.
* input: q - momentum to be integrated over.
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       omp - plasma frequency omega_p
*       pkq - momentum variable used in the integrand but kept 
*             fixed throughout the integration
      implicit none
      double precision wq,q,pkq,xlog,wdisp,vpp2,eps
      common /funct2/ pkq
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      external vpp2,wdisp
      wq=wdisp(q)
      eps=1.d-1
      xlog=(wq+q**2/2.d0+pkq*q)**2+(ompl*eps)**2
      xlog=xlog/((wq+q**2/2.d0-pkq*q)**2+(ompl*eps)**2)
      xlog=log(xlog)/2.d0
      xintak=q*vpp2(q)*xlog/(wq*pkq*4.d0*pi**2)
      return
      end
c  Computes spectral function window centered on resonance.  
c  Spectral function "deconvoluted" to remove broadening of main peak
      subroutine mkspectf(rs,pk,gammach,xreduc,wpts,spectf,
     2                    weights,isattype,npl,nplmax,
     3                    plengy,plwt,plbrd,brpole) 
* input: rs - radius that contains one electron
*        pk - photoelectron momentum
*        gammach - core hole lifetime broadening
*        xreduc - add-hoc interference reduction
*        isattype - approximation to use when computing satellite.
*        npl - number of poles in epsilon^{-1}
*        nplmax - maximum number of poles for dimensioning arrays
*        plengy - energy of each pole in epsilon^{-1}
*        plwt - weight of each pole in epsilon^{-1}
*        plbrd - broadening of each pole in epsilon^{-1}
*        brpole - true if poles are to be calculated with broadening
* output: wpts - array of energy points on which the spectral
*                function is specified.  array is of length npts
*         spectf - array of values of the spectral function.
*                array is of length npts
*         weights - array containing the total spectral weight of 
*                various contributions to the spectral function
*         weights(1) - extrinsic quasiparticle weight
*         weights(2) - asymmetry of quasiparticle
*         weights(3) - interference quasiparticle weight
*         weights(4) - extrinsic satellite weight
*         weights(5) - interference satellite weight
*         weights(6) - intrinsic satellite weight
*         weights(7) - weight of the extrinsic satellite clipped 
*                      to include only that part in the satellite region
*         weights(8) - weight of the extrinsic satellite clipped
*                      to include that part in the vicinity of the
*                      quasiparticle
      implicit none
      logical brpole
      integer npts,i,ii,j,jj,k,iemax,iixmax,ishift,isetold,
     2        iset,iset2,iswitch,isattype,iqph,iqpl,
     3        isetd,isetd2,iswd,iswd2,jwidth,ipl
*             npts - number of grid points for spectral function
*             i,ii,j,jj,k - counters and dummy variables
*             iixmax - grid point of highest value of the
*                   interference spectral function
*             ishift - number of grid points to shift the 
*                   extrinsic spectral function
*             iset,iset2,isetd,isetd2,isetold - keeping track
*                   of trigger conditions to separate the 
*                   extrinsic satellite into "satellite" and
*                   "main peak" regions
*             iswd,iswd2,iswitch - keeping track of grid points
*                   at which the above triggering conditions are met
*             iqph,iqpl - array points that bound the quasiparticle
*             jwidth - extra region tacked onto integration for 
*                   lorentzian broadening of the self energy
*             ipl - counter for loops over poles
*      parameter(npts=80)
      parameter(npts=112)
      integer npl,nplmax
      double precision rs,pk,gammach,xreduc,
     2                 spectf(8,npts),wpts(npts)
      double precision plengy(nplmax),plwt(nplmax),plbrd(nplmax)
      double precision conc,xa,expa,ak,aangstrom,eV,dsat,d2sat,
     2                 specttmp(npts),wswitch,swidth,wd,wd2,
     3                 dsatold,d2satold,dsath,wsearch,esfhi,esflo
*             conc - electron concentration
*             xa - dimensionless coupling constant of the electron gas
*             expa - the base of the natural logarithm raised to the
*                  power xa (e**xa)
*             ak - interference contribution to the quasiparticle
*             aangstrom - convert from angstrom to Bohr units of length
*             eV - convert from electron volts to Hartree units of energy
*             dsat,d2sat,dsatold,d2satold,dsath - finite difference 
*                  derivatives of the extrinsic satellite, to find
*                  the triggers to separate the "main peak" from the
*                  "satellite" structure of the extrinsic satellite 
*                  spectral function
*             specttmp - interpolated spectral function for shifting
*                  the extrinsic spectral function without numerical
*                  jitter
*             wsearch - energy used for finding the shift in the
*                  extrinsic spectral function
*             wswitch,wd,wdold - keep track of energy at which the trigger
*                  for separating the extrinsic spectral function
*                  is met
*             esfhi,esflo - used to bracket the high point of the
*                  extrinsic spectral function for its shift
      parameter (aangstrom=1.d0/0.52917706d0,eV=1.d0/27.21160d0)
      double precision xfact1,xfact2,wemax,wshift,wshift2,
     3                 whi,wlo,whi2,wlo2,ehi,elo,emax,ehi1,ehi2,
     4                 elo1,elo2,delta
*             xfact1,xfact2 - dummy variables for keeping track of 
*                  lengthly computations
*             wemax - the energy at the maximum value of the 
*                  extrinsic spectral function
*             wshift,wshift2 - amounts to shift the extrinsic 
*                  spectral function
*             whi,wlo,whi2,wlo2 - used to bracket the search region for the
*                  maximum of the extrinsic spectral function
*             ehi,elo,ehi1,ehi2,elo1,elo2 - values of the extrinsic 
*                  spectral function at the above bracket points
*             emax - the maximum value of the extrinsic spectral function
*             delta - a small value
      double precision sefr(npts),sefi(npts),
     2                 sef2r(npts),sef2i(npts),sumr,sumi,brpl,
     3                 wh,wl,w2,wh2,wl2,dw2
*             sefr - array of the real part of the self energy 
*                  values on the energy grid wpts
*             sefi - array of the imaginary part of the self energy 
*                  values on the energy grid wpts
*             sef2r,sef2i - self energy after lorentzian broadening
*             sumr,sumi - running integration counters
*             brpl - the broadening of a given pole in epsilon^{-1}
*             wh,wl,wh2,wl2 - high and low values of energy intervals,
*                  used for integration bounds over that interval
*             w2 - an energy variable
*             dw2 - an energy interval
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,qpk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,qpk,acc,brd,adisp
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of ipl'th pole in epsilon^{-1}
*       wt - weight of ipl'th pole in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       qpk - photoelectron momentum
*       acc - global accuracy parameter
*       brd - width of pole in epsilon^(-1)
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
      double precision wmin,wmax,wmin1,wmax1,dw,dw1,w,wlim(0:npts)
      common /limits/ wmin,wmax,wmin1,wmax1
*       wmin,wmax,wmin1,wmax1 - a bunch of extreme values of the energy
*       dw,dw1 - energy intervals
*       w - energy
*       wlim - energy values separating the energy gridpoints
      double precision se,xibeta,ce,width,xnn,xaa,se2,xise,
     2                 z0,z0i,zm,z1,z1i,z1m,xrz,xiz,x2a,x2n,
     3                 sef0,se0,yr,yi,zzr,zzi,zzm,qpengy,qpwidth
*       se - real part of the on shell self energy
*       xibeta - imaginary part of the on shell self energy, primarily 
*             used only to find width
*       ce - core energy
*       width - quasiparticle broadening
*       xnn - on shell energy derivative of the real part of the self
*             energy
*       xaa - on shell energy derivative of the imaginary part of the self
*             energy
*       se2 - real part of the self energy calculated at energy w
*       xise - imaginary part of the self energy calculated at energy w
*       z0 - approximation for the real part of the renormalization constant
*       z0i - approximation for the imaginary part of the 
*             renormalization constant
*       zm - magnitude of the above approximation for the 
*             renormalization constant
*       z1,z1i,z1m - a better approximation for the renormalization constant 
*       xrz,xiz - variables for intermediate steps in the calculation of
*             the renormalization constant
*       x2n,x2a - the real and imaginary parts, respectively, of the
*             second energy derivative of the on shell self energy.
*             These variables are not currently used in this version
*             of the code, but if needed, here they are.
*       sef0 - self energy at the fermi level
*       se0 - approximation for the self energy
*       yr - real part of second derivative of self energy
*       yi - imaginary part of second derivative of self energy
*       zzr,zzi,zzm - refined approximation for renormalization constant
*       qpengy - refined approximation for quasiparticle energy
*       qpwidth - refined approximation for quasiparticle width
      double complex zzc,yyc,xxc,discr,epc
*       zzc - complex renormalization constant
*       yyc - second derivative of self energy
*       xxc - 1-derivative of self energy
*       discr - square root of complex discriminant
*       epc - complex energy of quasiparticle pole
      double precision sxnn,sxaa,sse,sxise
*       for sums over the poles in epsilon^{-1} when computing the 
*       self energy and its derivatives
      common /energies/ se,ce,width,z1,z1i,se2,xise
      double precision xsat,xmain,emain,esat,xisat,esat2
*       the values of the interference satellite, interference 
*       quasiparticle, extrinsic quasiparticle, extrinsic satellite,
*       intrinsic satellite, and quasiparticle asymmetry spectral 
*       functions, respectively
      double precision xwidth, xiwidth
*       xwidth - broadening of the interference satellite
*       xiwidth - broadening of the intrinsic satellite
      double precision wtemain,wtesat,wtxmain,wtxsat,wtisat,
     2                 wtmesat,wtmemain,wtesat2,weights(8)
*       the total spectral weights of the extrinsic quasiparticle,
*       extrinsic satellite, interference quasiparticle, 
*       interference satellite, intrinsic satellite, clipped 
*       "satellite" part of the extrinsic satellite, clipped
*       "quasiparticle" part of the extrinsic satellite, and quasipartcle
*       asymmetry terms in the spectral function, respectively, in 
*       addition to the array of spectral weights
      double precision swtcorr,satwt,swtfac
*       swtcorr - the weight of the negative regions of the satellite
*       satwt - the satellite weight (neglecting factors of expa, as above)
*       swtfac - renormalization factor to keep satellite weight the 
*          same after negative parts are chopped off
      double precision grater,abr,rlr,xsing,error
      integer nsing,numcal,maxns
*       Grater is an integration function.  See its description for
*       the meaning of these variables.
      double precision xmkesat,beta,xmkak,xmkxsat,xmkisat,
     2                 xmkgwext,xmkssat,xmkpsat,xmkxg,xmkig
*       These are functions called in the execution of this subroutine.
      integer iwrite,jcount
      common /flag/ iwrite,jcount
*       These are used to flag a particular run of this subroutine
*       to write intermediate results to a file.
      integer lowq
*       lowq - If not equal to zero, calculate contributions
*          to self energy from below Fermi level.
      common /belowqf/ lowq
      external beta,grater,xmkesat,xmkxsat,xmkisat,xmkak,xmkgwext,
     2         xmkssat,xmkxg,xmkig
      double precision w3,q3,q4
      common /fqso2/ q3
      common /fw/ w
c     Josh - comment out extraneous externals
c      double precision wintr1,winti1,wintr2,winti2,xdumr,xdumi
c      external wintr1,winti1,wintr2,winti2
c      double precision srrpaw1,sirpaw1,rpadsfr,rpadsfi
c      external srrpaw1,sirpaw1,rpadsfr,rpadsfi
c      double precision rpapolr,rpapoli
c     external rpapolr,rpapoli
c      double precision xtestr,xtesti,qq,wplas,dq
c      external xtestr,xtesti,wplas
c      double precision rpasigr,rpasigi
c      external rpasigr,rpasigi
c     End Josh
      double precision exchange
      external exchange
      integer iw
      integer ijkwrite
      common /morewrite/ ijkwrite
* test functions

* compute initial values
      ijkwrite=0
      acc=1.d-4
      pi=dacos(-1.d0)
      qf=((9.d0*pi/4.d0)**(1.d0/3.d0))/rs
      ef=qf*qf/2.d0
      conc=3.d0/(4.d0*pi*(rs**3))
      omp=dsqrt(4.d0*pi*conc)
      qpk=qf
      ek=ef
      ekp=ef
      adisp=2.d0*ef/3.d0
      sef0=0.d0
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        if (brpole) then
          call brsigma(0.d0,sse,sxise)
        else
          call renergies(0.d0,sse)
        endif
*        call ppset(rs,pi,qf,ef,omp)
        sef0=sef0+sse*wt
      enddo
      sef0=sef0+exchange(qf)
*      call ppset(rs,pi,qf,ef,omp)
      xmu=ef+sef0
      ekp=xmu

* first estimate for energies and self energies
      qpk=pk
      ek=pk*pk/2.d0
      ekp=ek
      se0=0.d0
      xnn=0.d0
      xaa=0.d0
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        if (brpole) then
          call brsigma(0.d0,sse,sxise)
          call dbrsigma(0.d0,sxnn,sxaa)
        else
          call renergies(0.d0,sse)
          call drenergies(0.d0,sxnn)
          call dienergies(0.d0,sxaa)
        endif
*        call ppset(rs,pi,qf,ef,omp)
        se0=se0+sse*wt
        xnn=xnn+sxnn*wt
        xaa=xaa+sxaa*wt
      enddo
      se0=se0+exchange(pk)
*      call ppset(rs,pi,qf,ef,omp)
      xrz=1.d0-xnn
      xiz=-xaa
      z0=xrz/(xrz**2+xiz**2)
      z0i=-xiz/(xrz**2+xiz**2)
      zm=dsqrt(z0**2+z0i**2)
      ekp=ek+sef0+z0*(se0-sef0)

* refined estimate for self energies, using the self energy at the 
* Fermi level to increase self consistency
      se=0.d0
      xibeta=0.d0
      xnn=0.d0
      xaa=0.d0
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        if (brpole) then
          call brsigma(-sef0,sse,sxise)
          call dbrsigma(-sef0,sxnn,sxaa)
        else
          call renergies(-sef0,sse)
          call xienergies(-sef0,sxise)
          call drenergies(-sef0,sxnn)
          call dienergies(-sef0,sxaa)
        endif
        se=se+sse*wt
        xibeta=xibeta+sxise*wt
        xnn=xnn+sxnn*wt
        xaa=xaa+sxaa*wt
      enddo
      se=se+exchange(pk)
      width=dabs(xibeta)+gammach

* calculate renormalization constant
      xa=0.d0
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        xa=xa+3*wt*(omp/ompl)**2/(8*dsqrt(2.d0*ompl))
      enddo
      expa=exp(-xa)
      xrz=1.d0-xnn
      xiz=-xaa
      z1=xrz/(xrz**2+xiz**2)
      z1i=-xiz/(xrz**2+xiz**2)
      z1m=sqrt(z1**2+z1i**2)

* Find energy gridpoints
      dw=omp/30.d0
      iqph=54
      iqpl=53
      wpts(iqph)=dw*1.d-2
      wpts(iqpl)=-dw*1.d-2
      wpts(iqph+1)=dw*2.d-2
      wpts(iqpl-1)=-dw*2.d-2
      do i=1,30
        wpts(i+1+iqph)=i*dw
        wpts(iqpl-1-i)=-i*dw
      enddo
      do i=1,3
        wpts(i+31+iqph)=wpts(31+iqph)+i*dw
        wpts(iqpl-31-i)=wpts(iqpl-31)-i*dw
      enddo
      do i=1,3
        wpts(i+34+iqph)=wpts(34+iqph)+(2*i)*dw
        wpts(iqpl-34-i)=wpts(iqpl-33)-(2*i)*dw
      enddo
      do i=1,3
        wpts(i+37+iqph)=wpts(37+iqph)+(4*i)*dw
        wpts(iqpl-37-i)=wpts(iqpl-36)-(4*i)*dw
      enddo
      do i=1,12
        wpts(i+40+iqph)=wpts(40+iqph)+(10*i)*dw
        wpts(iqpl-40-i)=wpts(iqpl-39)-(10*i)*dw
      enddo
      do i=1,6
        wpts(i+52+iqph)=wpts(52+iqph)+(30*i)*dw
      enddo
      do i=1,npts-1
        wlim(i)=(wpts(i)+wpts(i+1))/2.d0
      enddo
      wlim(0)=2.d0*wpts(1)-wpts(2)
      wlim(npts)=2.d0*wpts(npts)-wpts(npts-1)
      wmin=wpts(1)
      wmax=wpts(npts)
      wmax1=ekp+wmax
      wmin1=ekp+wmin

* compute self energies on energy gridpoints
      do i=1,npts
        sefr(i)=0.d0
        sefi(i)=0.d0
      enddo
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        do i=1,npts
          w=wpts(i)+ekp
          dw1=wlim(i)-wlim(i-1)
*          dw1=wpts(i)-wpts(i-1)
  
*          call renergies(w-ekp-sef0,sse)
*          call xienergies(w-ekp-sef0,sxise)
          if (brpole) then
            call brsigma(w-ekp-se,sse,sxise)
          else
            call renergies(w-ekp-se,sse)
            call xienergies(w-ekp-se,sxise)
          endif
          sefr(i)=sefr(i)+sse*wt
          sefi(i)=sefi(i)+sxise*wt
        enddo
*        call ppset(rs,pi,qf,ef,omp)
      enddo
      se2=0.d0
      xise=0.d0
      xnn=0.d0
      xaa=0.d0
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        if (brpole) then
          call brsigma(-se,sse,sxise)
          call dbrsigma(-se,sxnn,sxaa)
        else
          call renergies(-se,sse)
          call xienergies(-se,sxise)
          call drenergies(-se,sxnn)
          call dienergies(-se,sxaa)
        endif
        se2=se2+sse*wt
        xise=xise+sxise*wt
        xnn=xnn+sxnn*wt
        xaa=xaa+sxaa*wt
      enddo
      se=se2+exchange(pk)
      width=dabs(xise)+gammach


      do i=1,npts
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        sefr(i)=sefr(i)+exchange(pk)
        sefi(i)=dabs(sefi(i))+gammach
        if (iwrite.eq.jcount) write(24,500) wpts(i),sefr(i),sefi(i)
      enddo
*      se=(sefr(iqph)+sefr(iqpl))/2
*      width=(sefi(iqph)+sefi(iqpl))/2
*      xnn=(sefr(iqph)-sefr(iqpl))/(wpts(iqph)-wpts(iqpl))
*      xaa=(sefi(iqph)-sefi(iqpl))/(wpts(iqph)-wpts(iqpl))
      xrz=1.d0-xnn
      xiz=-xaa
      z1=xrz/(xrz**2+xiz**2)
      z1i=-xiz/(xrz**2+xiz**2)
      z1m=sqrt(z1**2+z1i**2)
      qpengy=ekp+width*z1i
      qpwidth=width*z1
      zzr=z1
      zzi=z1i
      zzm=z1m

*      write(68,*) pk/qf,se,width,z1,z1i

* correct for endpoint effects
      ak=0.d0
      do ipl=1,npl
        call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
        ak=ak+xmkak(ekp)*xreduc*wt
*        call ppset(rs,pi,qf,ef,omp)
      enddo
      wtemain=(datan(wlim(0)/width)+pi/2.d0)/pi
     2        +(pi/2.d0-datan(wlim(npts)/width))/pi
      wtxmain=2.d0*wtemain*zm*z1*ak
      wtemain=wtemain*z1*expa
      wtesat=0.d0
      wtesat2=0.d0
      wtxsat=0.d0
      wtisat=0.d0
      do i=1,npts
        do ii=1,8
          spectf(ii,i)=0.d0
        enddo
      enddo

* compute spectral function
      do i=1,npts
        w=wpts(i)+ekp
        dw1=wlim(i)-wlim(i-1)

        se2=sefr(i)
        xise=sefi(i)

* This form for the extrinsic quasiparticle is calculated at the
* correct quasiparticle pole, for much better cancelation of the
* quasiparticle structure from the xmkgwext function, below.
        emain=z1*(datan((wlim(i)-qpengy+ekp)/qpwidth)
     2        -datan((wlim(i-1)-qpengy+ekp)/qpwidth))/(pi*dw1)
     3        -z1i*dlog((qpwidth**2+(wlim(i)-qpengy+ekp)**2)/
     4         (qpwidth**2+(wlim(i-1)-qpengy+ekp)**2))/(2.d0*pi*dw1)
     5         *exp(-((w-qpengy)/(2*omp))**2)
        xmain=2.d0*zm*ak*emain
        wtemain=wtemain+emain*expa*dw1
        wtxmain=wtxmain+xmain*expa*dw1
* Depending on the value of isattype, different approximations
* can be used for the satellite.
        if (isattype.eq.1) then
          esat=xmkgwext(w-ekp)-emain
        elseif (isattype.eq.2) then
          esat=(xise-width-(w-ekp)*xaa)/(pi*(w-ekp)**2)
        elseif (isattype.eq.3) then
* generate full extrinsic spectral function - do not use for spectroscopy!
          esat=xmkgwext(w-ekp)
        else
          esat=xmkesat(w-ekp)
        endif
        xsat=0.d0
        xisat=0.d0
        do ipl=1,npl
          call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
          xwidth=max(5.d0*dw,brd)
          xiwidth=max(2.d0*dw,brd)
          if (isattype.eq.3) then
            xwidth=xwidth+width
            xiwidth=xiwidth+width
          endif
          xsat=xsat+xmkxsat(w-ekp,xwidth)*xreduc*wt
          xisat=xisat+xmkisat(w-ekp,xiwidth)*wt
*          call ppset(rs,pi,qf,ef,omp)
        enddo
        wtxsat=wtxsat+xsat*dw1*expa
        wtesat=wtesat+esat*dw1*expa
        wtisat=wtisat+xisat*dw1*expa
        spectf(1,i)=emain
        spectf(2,i)=esat
        spectf(3,i)=xmain
        spectf(4,i)=xsat
        spectf(5,i)=xisat
        spectf(6,i)=(esat+xisat-2.d0*xsat)
        if (isattype.eq.3) then
          spectf(6,i)=spectf(6,i)+xmain
        endif
      enddo
      spectf(2,iqpl)=(spectf(2,iqpl)+spectf(2,iqph))/2
      spectf(2,iqph)=spectf(2,iqpl)

*     separate quasiparticle-like structure from satellite in non-delta
*     function part of extrinsic spectral function.
      iset=0
      iset2=0
      dsatold=0.d0
      d2satold=0.d0
      isetd=0
      isetd2=0
      do ii=2,npts-1
        isetold=iset2
        i=npts+1-ii
        w=wpts(i)+ekp
        dsat=(spectf(2,i)-spectf(2,i-1))/(wpts(i)-wpts(i-1))
        dsath=(spectf(2,i+1)-spectf(2,i))/(wpts(i+1)-wpts(i))
        d2sat=(dsath-dsat)/(wlim(i)-wlim(i-1))
        if (dsat.gt.0.d0.and.spectf(2,i).gt.0.d0
     2      .and.iset.eq.0.d0) iemax=i
        if (spectf(5,i).lt.spectf(5,i+1)
     2      .and.spectf(5,i+1).gt.spectf(5,i+2)) iixmax=i
        if (dsat.gt.0.d0.and.spectf(2,i).gt.0.d0) iset=1
        if (beta(0.d0).gt.0.d0) then
          if (dsat.lt.0.d0.and.dsatold.ge.0.d0
     2        .and.iset.eq.1.and.isetd.eq.0) then
             isetd=1
             iswd=i
             wd=w
          endif
          if (d2sat.gt.0.d0.and.d2satold.le.0.d0
     2        .and.iset.eq.1.and.isetd2.eq.0) then
             isetd2=1
             iswd2=i
             wd2=w
          endif
        else
          if (dsat.lt.0.d0.and.dsatold.ge.0.d0
     2        .and.iset.eq.1.and.isetd.eq.0.and.w.gt.0.d0) then
             isetd=1
             iswd=i
             wd=w
          endif
          if (d2sat.gt.0.d0.and.d2satold.le.0.d0
     2        .and.iset.eq.1.and.isetd2.eq.0) then
             isetd2=1
             iswd2=i
             wd2=w
          endif
        endif
      enddo
      if (isetd.eq.1) then
        iswitch=iswd
        wswitch=wd
      else
        iswitch=iswd2
        wswitch=wd2
      endif
*      swidth=(omp/4.d0)*spectf(2,iswitch)/spectf(2,iemax)
      swidth=0.d0
      do i=1,npts
        w=wpts(i)+ekp
        if (swidth.gt.0.d0) then
          spectf(7,i)=spectf(2,i)/(1.d0+exp((w-wswitch)/swidth))
          spectf(8,i)=spectf(2,i)/(1.d0+exp((wswitch-w)/swidth))
        elseif (i.ge.iswitch) then
          spectf(8,i)=spectf(2,i)
        else
          spectf(7,i)=spectf(2,i)
        endif
      enddo

** find the energy at which the extrinsic satellite reaches its 
** maximum value.
*      wemax=wpts(iemax)+ekp
*      whi=wpts(iemax+1)+ekp
*      wlo=wpts(iemax-1)+ekp
*      emax=spectf(2,iemax)
*      do i=1,8
*        whi2=(whi+wemax)/2.d0
*        wlo2=(wlo+wemax)/2.d0
*        if (whi2-ekp.ne.0.d0) then
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          xise=dabs(xise)+gammach
*          ehi=xmkesat(whi2-ekp)
*        else
*          delta=(whi2-wemax)/1.d3
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          xise=dabs(xise)+gammach
*          ehi1=xmkesat(whi2-ekp+delta)
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          xise=dabs(xise)+gammach
*          ehi2=xmkesat(whi2-ekp-delta)
*          ehi=(ehi1+ehi2)/2.d0
*        endif
*        if (wlo2-ekp.ne.0.d0) then
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          xise=dabs(xise)+gammach
*          elo=xmkesat(wlo2-ekp)
*        else
*          delta=(wemax-wlo2)/1.d3
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          xise=dabs(xise)+gammach
*          elo1=xmkesat(wlo2-ekp+delta)
*          se2=0.d0
*          xise=0.d0
*          do ipl=1,npl
*            call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
*            call brsigma(whi2-ekp-sef0,sse,sxise)
**            call ppset(rs,pi,qf,ef,omp)
*            se2=se2+sse*wt
*            xise=xise+sxise*wt
*          enddo
*          se2=se2+exchange(pk)
*          xise=dabs(xise)+gammach
*          elo2=xmkesat(wlo2-ekp-delta)
*          elo=(elo1+elo2)/2.d0
*        endif
*        if (ehi.gt.emax.and.ehi.gt.elo) then
*          wlo=wemax
*          wemax=whi2
*          emax=ehi
*        elseif(elo.gt.emax.and.elo.ge.ehi) then
*          whi=wemax
*          wemax=wlo2
*          emax=elo
*        else
*          whi=whi2
*          wlo=wlo2
*        endif
*      enddo
*      wemax=wemax-ekp
*
** if the extrinsic spectral function peaks beyond the plasma frequency,
** shift the spectral function so it peaks at the plasma frequency.
**      if(wemax.lt.omp) then
*      if(.false.) then
*        wshift=omp-wemax
*        ishift=53-iemax
**       here, wpts(53)=omp
*        wshift2=wpts(iemax)-wemax
*        if (wshift.lt.0.d0) then
*          ishift=ishift-1
*          wshift2=wpts(iemax+1)-wemax
*        endif
**        ishift=int(wshift/dw)
**        wshift2=wshift-ishift*dw
*        do i=1,ishift
*          specttmp(i)=0.d0
*        enddo
*        do i=1,npts
*          wsearch=wpts(i)-wshift
*          if (wpts(1).gt.wsearch) then
*            specttmp(i)=0.d0
*          else
*            do j=1,npts
*              if (wpts(j).gt.wsearch) then
*                whi=wpts(j)
*                wlo=wpts(j-1)
*                esfhi=spectf(2,j)
*                esflo=spectf(2,j-1)
*                wshift2=wpts(j)-wsearch
*                specttmp(i)=esflo+(esfhi-esflo)*wshift2/(whi-wlo)
*                goto 100
*              endif
*            enddo
*          endif
*100       continue
*        enddo
*      endif


* Find the weights for the clipped parts of the extrinsic satellite
      wtmesat=0.d0
      wtmemain=0.d0
      do i=1,npts
        wtmesat=wtmesat+spectf(8,i)*expa*dw
        wtmemain=wtmemain+spectf(7,i)*expa*dw
      enddo
** Weight the satellite terms by the power of the renormalization
** constant reflecting how many powers of the extrinsic Green's function
** appear in the original expressions
*      wtxsat=wtxsat*(zm+wtmemain)**2
*      wtisat=wtisat*(zm+wtmemain)
      do i=1,npts
*        spectf(4,i)=spectf(4,i)*(zm+wtmemain)**2
*        spectf(5,i)=spectf(5,i)*(zm+wtmemain)
        spectf(6,i)=spectf(2,i)-2.d0*spectf(4,i)+spectf(5,i)
      enddo
      
* eliminate regions of negative spectral weight, keep track of 
* the total satellite weight before correction and weight of negative
* regions removed for later renormalization.
      swtcorr=0.d0
      satwt=0.d0
      do i=1,npts
        w=wpts(i)+ekp
        dw1=wlim(i)-wlim(i-1)
        satwt=satwt+spectf(6,i)*dw1
        if (spectf(6,i).lt.0.d0) then
          swtcorr=swtcorr+spectf(6,i)*dw1
          spectf(6,i)=0.d0
          spectf(4,i)=(spectf(2,i)+spectf(5,i))/2.d0
        endif
      enddo
* renormalize to keep satellite weight the same.
      swtfac=satwt/(satwt-swtcorr)
      if (swtfac.lt.0.d0) swtfac=0.d0
      wtxsat=0.d0
      wtisat=0.d0
      wtesat=0.d0
      wtmesat=0.d0
      wtmemain=0.d0
      do i=1,npts
        w=wpts(i)+ekp
        dw1=wlim(i)-wlim(i-1)
        spectf(4,i)=(spectf(2,i)+spectf(5,i)-spectf(6,i)*swtfac)/2.d0
        wtxsat=wtxsat+spectf(4,i)*dw1*expa
        wtesat=wtesat+spectf(2,i)*dw1*expa
        wtisat=wtisat+spectf(5,i)*dw1*expa
        wtmesat=wtmesat+spectf(8,i)*expa*dw
        wtmemain=wtmemain+spectf(7,i)*expa*dw
      enddo
        
* Write out array of weights
      weights(1)=z1*expa
      write(66,*) z1,expa
      weights(2)=z1i*expa
      weights(3)=2.d0*z1*zm*ak*xreduc*expa
      weights(4)=wtesat
      weights(5)=wtxsat
      weights(6)=wtisat
      weights(7)=wtmesat
      weights(8)=wtmemain

*      write(6,*) xxc,yyc,discr,abs(discr),
*     2           -2.d0*width*(0,1)*yyc,zzc,abs(zzc),z1,z1i
*      z1=zzr
*      z1i=zzi
*      z1m=zzm

      if (iwrite.eq.jcount) then
        do i=1,npts
          write(12,500) wpts(i),spectf(1,i),spectf(3,i),
     2                  spectf(7,i),spectf(8,i)
          write(13,500) wpts(i),spectf(2,i),spectf(4,i),
     2                  spectf(5,i),
     3                  spectf(2,i)+spectf(5,i)-2.d0*spectf(4,i)
*     2                  spectf(5,i),spectf(6,i)
        enddo
      endif

      return
 500  format(1x,5(e12.5,1x))
 700  format(1x,7(f10.5,1x))
      end
      double precision function wdisp(q)
* dispertion relation
* input: q - momentum or wavenumber
* input from common blocks
*       ompl - zero q energy of mode
*       adisp - dispersion parameter for dispersion relation,
      implicit none
      double precision q
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      wdisp=sqrt(ompl**2+adisp*q**2+q**4/4.d0)
      return
      end

      double precision function dwdq(q)
* the derivative of the dispertion relation 
* with respect to the plasmon momentum q
* input: q - momentum or wavenumber
* input from common blocks
*       ompl - zero q energy of mode
*       adisp - dispersion parameter for dispersion relation,
      implicit none
      double precision q,wdisp
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      external wdisp
      dwdq=(q**3+2.d0*adisp*q)/(2.d0*wdisp(q))
      return
      end

      double precision function d2wdq2(q)
* the second derivative of the dispertion relation 
* with respect to the plasmon momentum q
* input: q - momentum or wavenumber
* input from common blocks
*       omp - plasma frequency omega_p
*       adisp - dispersion parameter for dispersion relation,
      implicit none
      double precision q,wdisp,dwdq
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      external wdisp,dwdq
      d2wdq2=(3.d0*q**2+2.d0*adisp)*wdisp(q)
     2       -(q**3+2.d0*adisp*q)*dwdq(q)
      d2wdq2=d2wdq2/(2.d0*wdisp(q)**2)
      return
      end

      double precision function qdisp(w)
* The inverse dispertion relation
* input: w - energy (omega)
* input from common blocks
*       ompl - zero q energy of mode
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=ompl+adisp*q**2+q**4/4
      implicit none
      double precision w,x,y
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      x=adisp**2+w**2-ompl**2
      if (x.ge.0.d0) then
        y=-2.d0*adisp+2.d0*dsqrt(x)
        if (y.ge.0.d0) then
          qdisp=dsqrt(y)
          return
        endif
      endif
      qdisp=0.d0
      return
      end

      double precision function qthresh(ompl,AA,ef,qf)
* Find the photoelectron momentum corresponding to the onset of plasmon
* losses.
* input: ompl - zero q energy of mode
*        AA - dispersion parameter omega(q)**2=ompl**2+AA*q**2+q**4/4
*        ef - fermi energy
*        qf - fermi momentum
      implicit none
      integer i,nrts,nrts2,nflip,nqa,nqb
      double precision AA,ompl,ef,qf,a,b,c,d,qthresh1,qthresh2,q01,
     2                 q02,xfact,test1,test2,test3,qh,ek,q1a,q2a,
     3                 q3a,q0a,q1b,q2b,q3b,q0b,w,x,y
      complex*16 rt1,rt2,rt3,rtt1,rtt2,rtt3,rt(3),rtt(3),qst
      a=1.d0
      b=-3.d0*AA
      c=3.d0*AA**2-27.d0*ompl**2/4.d0
      d=-AA**3
      call croots(a,b,c,d,rt1,rt2,rt3,nrts)
      rt(1)=rt1
      rt(2)=rt2
      rt(3)=rt3
      if (nrts.eq.1) then
 10     continue
          nflip=0
          do i=1,2
            if (dimag(rt(i)).lt.dimag(rt(i+1))) then
              qst=rt(i)
              rt(i)=rt(i+1)
              rt(i+1)=qst
              nflip=nflip+1
            endif
          enddo
        if (nflip.ne.0) goto 10
        qthresh1=dble(rt(2))
      else
        qthresh1=max(dble(rt1),dble(rt2),dble(rt3))
      endif
*      write(6,*) rt1,rt2,rt3
*      write(6,*) qthresh1
      if (qthresh1.gt.0.d0) then
        qthresh1=dsqrt(qthresh1)
      else
        qthresh1=0.d0
      endif
*      write(6,*) qthresh1
      a=1.d0
      b=1.5d0*qf+AA/qf
      c=qf**2+2.d0*AA
      d=qf**3/4.d0+AA*qf+ompl**2/qf
      call croots(a,b,c,d,rt1,rt2,rt3,nrts)
      rt(1)=rt1
      rt(2)=rt2
      rt(3)=rt3
      b=-b
      d=-d
      call croots(a,b,c,d,rtt1,rtt2,rtt3,nrts2)
      rtt(1)=rtt1
      rtt(2)=rtt2
      rtt(3)=rtt3
      if (nrts.eq.1) then
 11     continue
          nflip=0
          do i=1,2
            if (dimag(rt(i)).lt.dimag(rt(i+1))) then
              qst=rt(i)
              rt(i)=rt(i+1)
              rt(i+1)=qst
              nflip=nflip+1
            endif
          enddo
        if (nflip.ne.0) goto 11
        q01=dble(rt(2))
      else
        xfact=sqrt(AA**2+(dble(rt(1))**2/2.d0)**2-ompl**2)-AA
        test1=dble(rt(1))-qf-sqrt(2.d0*xfact)
        xfact=sqrt(AA**2+(dble(rt(2))**2/2.d0)**2-ompl**2)-AA
        test2=dble(rt(2))-qf-sqrt(2.d0*xfact)
        xfact=sqrt(AA**2+(dble(rt(3))**2/2.d0)**2-ompl**2)-AA
        test3=dble(rt(3))-qf-sqrt(2.d0*xfact)
        if(test1.lt.test2.and.test1.lt.test3) then
          q01=dble(rt(1))
        elseif(test2.lt.test3) then
          q01=dble(rt(2))
        else
          q01=dble(rt(3))
        endif
      endif
      if (nrts2.eq.1) then
 12     continue
          nflip=0
          do i=1,2
            if (dimag(rtt(i)).lt.dimag(rtt(i+1))) then
              qst=rtt(i)
              rtt(i)=rtt(i+1)
              rtt(i+1)=qst
              nflip=nflip+1
            endif
          enddo
        if (nflip.ne.0) goto 12
        q02=dble(rtt(2))
      else
        xfact=sqrt(AA**2+(dble(rtt(1))**2/2.d0)**2-ompl**2)-AA
        test1=dble(rtt(1))+qf-sqrt(2.d0*xfact)
        xfact=sqrt(AA**2+(dble(rtt(2))**2/2.d0)**2-ompl**2)-AA
        test2=dble(rtt(2))+qf-sqrt(2.d0*xfact)
        xfact=sqrt(AA**2+(dble(rtt(3))**2/2.d0)**2-ompl**2)-AA
        test3=dble(rtt(3))+qf-sqrt(2.d0*xfact)
        if(test1.lt.test2.and.test1.lt.test3) then
          q02=dble(rt(1))
        elseif(test2.lt.test3) then
          q02=dble(rt(2))
        else
          q02=dble(rt(3))
        endif
      endif
*      write(6,*) q01,q02
      qthresh2=min(abs(q01),abs(q02))
*      write(6,*) qthresh1,qthresh2

      qh=1000.d0*qf
      ek=qthresh1**2/2.d0
      call qlimits(ek,qthresh1,ompl,AA,qh,nqa,q1a,q2a,q3a)
      q0a=0.d0
      w=ek-ef
      x=AA**2+w**2-ompl**2
      if (x.ge.0.d0) then
        y=-2.d0*AA+2.d0*dsqrt(x)
        if (y.ge.0.d0) then
          q0a=dsqrt(y)
        endif
      endif
      ek=qthresh2**2/2.d0
      call qlimits(ek,qthresh2,ompl,AA,qh,nqb,q1b,q2b,q3b)
      q0b=0.d0
      w=ek-ef
      x=AA**2+w**2-ompl**2
      if (x.ge.0.d0) then
        y=-2.d0*AA+2.d0*dsqrt(x)
        if (y.ge.0.d0) then
          q0b=dsqrt(y)
        endif
      endif

      if (nqa.eq.0) then
        qthresh=qthresh1
      elseif(abs(q1a-q2a).lt.abs(q1b-q0b)) then
        qthresh=qthresh1
      else
        qthresh=qthresh2
      endif
*      write(6,*) qthresh
      return
      end

      double precision function vpp2(q)
* the square of the coupling potential
* input: q - momentum or wavenumber
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ompl - zero q energy of mode
      implicit none
      double precision q,wdisp
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      external wdisp
      vpp2=2*pi*omp**2/(q**2*wdisp(q))
      return
      end

      subroutine qlimits(w,pk,omp,Ap,qh,nq,q1,q2,q3)
* finds the limiting q values of the inequalities
* omega(q)+(q-k)^2/2-omega < 0 
* omega(q)+(q+k)^2/2-omega > 0 and
* omega(q)-(q-k)^2/2+omega > 0
* for omega(q)^2 = omp^2+Ap q^2+q^4/4
* qh is the upper allowable value for q (usually set by omega(q)+E_f-omega < 0
* for the first two inequalities.
* input: energy w in atomic hartrees.
*        momentum pk in atomic units.
*        resonance frequency omp in hartrees.
*        dispersion parameter Ap.
*        upper limit qh.
* output: number of limiting q values (either 1 or 3).
*         limiting q values q1, q2,and q3
*         q1 and q2 bracket a region of allowed q values given by
*         the first two inequalities listed above,
*         q3 is the upper bound of the third inequality
      implicit none
      integer i,j,nar,nq
      double precision w,pk,omp,Ap,qh,q1,q2,q3,a,b,c,d
      double precision dev1,dev2,dev3,qa1,qa2,qa3,wdisp
      complex*16 aa1,aa2,aa3
      external wdisp
*      write(6,*) 'qlimits'
* find q for which omega(q)+(q-k)^2/2-omega = 0
      a=pk
      b=w+Ap-3.d0*pk**2/2.d0
      c=pk**3-2.d0*w*pk
      d=omp**2-w**2+w*pk**2-pk**4/4.d0
      call croots(a,b,c,d,aa1,aa2,aa3,nar)
* One of these roots is the solution of
* omega(q)-(q-k)^2/2+omega = 0.  This is q3.  The other two roots, if present,
* solve omega(q)+(q-k)^2/2-omega = 0
* It must hold that q>=0.  Fortunately, the symmetry of the inequalities
* means that solving omega(q)+(q+k)^2/2-omega = 0 gives roots which are the 
* negatives of the roots from the cubic we just solved.  It suffices to
* take the absolute value of the roots (if they are real) to give our
* limiting values of q.
      if (nar.eq.3) then
        qa1=dble(aa1)
        qa2=dble(aa2)
        qa3=dble(aa3)
        dev1=dabs(wdisp(qa1)+(qa1-pk)**2/2.d0-w)
        dev2=dabs(wdisp(qa2)+(qa2-pk)**2/2.d0-w)
        dev3=dabs(wdisp(qa3)+(qa3-pk)**2/2.d0-w)
        if (dev1.gt.dev2.and.dev1.gt.dev3) then
          q1=min(dabs(qa2),dabs(qa3))
          q2=max(dabs(qa2),dabs(qa3))
          q3=dabs(qa1)
        elseif(dev2.gt.dev3) then
          q1=min(dabs(qa1),dabs(qa3))
          q2=max(dabs(qa1),dabs(qa3))
          q3=dabs(qa2)
        else
          q1=min(dabs(qa1),dabs(qa2))
          q2=max(dabs(qa1),dabs(qa2))
          q3=dabs(qa3)
        endif
        q1=min(q1,qh)
        q2=min(q2,qh)
        nq=3
      else
* The equation omega(q)+(q-k)^2/2-omega = 0 has no real solutions.  The
* one real root of the cubic is q3. 
        q1=0.d0
        q2=0.d0
        qa1=dabs(dimag(aa1))
        qa2=dabs(dimag(aa2))
        qa3=dabs(dimag(aa3))
        if (qa1.lt.qa2.and.qa1.lt.qa3) then
          q3=dabs(dble(aa1))
        elseif (qa2.lt.qa3) then
          q3=dabs(dble(aa2))
        else
          q3=dabs(dble(aa3))
        endif
        nq=1
      endif
      return
      end
      subroutine renergies(w,rbeta)
* Calculates the real part of the photelectron self energy due to 
* pole ipl in the inverse dielectric function epsilon^{-1}.
* input: w - energy (omega)
* output: rbeta - the real part of the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - width of pole in epsilon^(-1)
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=ompl+adisp*q**2+q**4/4
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable
      implicit none
      integer i,npts,nnpts,nsing,numcal,maxns
      double precision w,rbeta,beta,rw1beta,grater,wmax,wmin,
     2                 abr,rlr,xsing,error,exchange,qmax
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision rseint1,rseint2,rseint3
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      integer lowq
      common /belowqf/ lowq
      external beta,rw1beta,grater,exchange,rseint1,rseint2,rseint3
      integer ijkwrite
      common /morewrite/ ijkwrite
      wp=w+ekp
      qmax=1.d2*dsqrt(ompl)+pk+qf
*     rlr for plasmon pole should be 10^-7 to eliminate numerical 
*     artifacts
      rlr=1.d-7
      abr=rlr/1.d3
      nsing=0
      if (pk.gt.qf) then
        rbeta=grater(rseint1,pk+qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        rbeta=rbeta+grater(rseint1,0.d0,pk-qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        rbeta=rbeta+grater(rseint2,pk-qf,pk+qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      elseif (pk.lt.qf) then
        rbeta=grater(rseint1,pk+qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        rbeta=rbeta+grater(rseint2,qf-pk,pk+qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        if (lowq.ne.0) rbeta=rbeta+grater(rseint3,0.d0,
     2             qf-pk,abr,rlr,nsing,xsing,error,numcal,maxns)
      else
        rbeta=grater(rseint1,2.d0*qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        rbeta=rbeta+grater(rseint2,0.d0,2.d0*qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      endif
      rbeta=-rbeta*omp**2/(2.d0*pi*pk)
*      rbeta=rbeta+exchange(pk)
      return
      end

      subroutine brsigma(w,rbeta,xibeta)
* Calculates the broadened photelectron self energy due to 
* pole ipl in the inverse dielectric function epsilon^{-1}.
* input: w - energy (omega)
* output: rbeta - the real part of the self energy
*         xibeta - the imaginary part of the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - linewidth of pole in epsilon^{-1}
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=ompl+adisp*q**2+q**4/4
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable
      implicit none
      integer i,npts,nnpts,nsing,numcal,maxns,nq,nqq
      parameter (nqq=5)
      double precision w,rbeta,xibeta,grater,qdisp,wmax,wmin,
     2                 abr,rlr,xsing(20),error
      double precision qmax,qlimh,qliml,qh,q0,q1,q2,q3,qsing(nqq)
      double precision sig1r,sig2r,sig3r,sig4r,sig5r,
     2                 sig6r,sig7r,sig8r,sig9r,sig10r,
     3                 sig1i,sig2i,sig3i,sig4i,sig5i,
     4                 sig6i,sig7i,sig8i,sig9i,sig10i
      double precision fqlogr1,fqlogr2,fqlogr3,fqlogr4,
     2                 fqlogi1,fqlogi2,fqlogi3,fqlogi4,
     3                 fqatnr1,fqatnr2,fqatnr3,fqatnr4,
     4                 fqatni1,fqatni2,fqatni3,fqatni4
      double complex cfact,csigma
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      integer iwrite,jj
      common /flag/ iwrite,jj
      integer lowq
      common /belowqf/ lowq
      external grater,qdisp,
     2         fqlogr1,fqlogr2,fqlogr3,fqlogr4,
     3         fqlogi1,fqlogi2,fqlogi3,fqlogi4,
     4         fqatnr1,fqatnr2,fqatnr3,fqatnr4,
     5         fqatni1,fqatni2,fqatni3,fqatni4
      wp=w+ekp
      qmax=1.d2*dsqrt(ompl)+pk+qf
*     rlr for plasmon pole should be 10^-7 to eliminate numerical 
*     artifacts
      rlr=1.d-7
      abr=rlr/1.d3
      qlimh=pk+qf
      qliml=abs(pk-qf)
      qh=qdisp(max(wp-ef,ompl))
      q0=qdisp(max(ef-wp,ompl))
      call qlimits(wp,pk,ompl,adisp,qmax,nq,q1,q2,q3)
      qsing(1)=q0
      qsing(2)=q1
      qsing(3)=q2
      qsing(4)=q3
      qsing(5)=qh
      sig1r=0.d0
      sig1i=0.d0
      sig2r=0.d0
      sig2i=0.d0
      sig3r=0.d0
      sig3i=0.d0
      sig4r=0.d0
      sig4i=0.d0
      sig5r=0.d0
      sig5i=0.d0
      sig6r=0.d0
      sig6i=0.d0
      sig7r=0.d0
      sig7i=0.d0
      sig8r=0.d0
      sig8i=0.d0
      sig9r=0.d0
      sig9i=0.d0
      sig10r=0.d0
      sig10i=0.d0
      call findsing(qlimh,qmax,nqq,qsing,nsing,xsing)
      sig1r=grater(fqlogr1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      sig1i=grater(fqlogi1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      sig2r=grater(fqatnr1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      sig2i=grater(fqatni1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      call findsing(qliml,qlimh,nqq,qsing,nsing,xsing)
      sig3r=grater(fqlogr2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      sig3i=grater(fqlogi2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      sig4r=grater(fqatnr2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      sig4i=grater(fqatni2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      if (lowq.ne.0) then
        sig7r=grater(fqlogr3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
        sig7i=grater(fqlogi3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
        sig8r=grater(fqatnr3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
        sig8i=grater(fqatni3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      endif
      call findsing(0.d0,qliml,nqq,qsing,nsing,xsing)
      if (pk.gt.qf) then
        sig5r=grater(fqlogr1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        sig5i=grater(fqlogi1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        sig6r=grater(fqatnr1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        sig6i=grater(fqatni1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      endif
      if (pk.lt.qf.and.lowq.ne.0) then
        sig9r=grater(fqlogr4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        sig9i=grater(fqlogi4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        sig10r=grater(fqatnr4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        sig10i=grater(fqatni4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      endif
      rbeta=(sig1r+sig3r+sig5r+sig7r+sig9r)*omp**2/(4.d0*pi*pk)
     2     +(sig2r+sig4r+sig6r+sig8r+sig10r)*omp**2/(2.d0*pi*pk)
      xibeta=(sig1i+sig3i+sig5i+sig7i+sig9i)*omp**2/(4.d0*pi*pk)
     2     -(sig2i+sig4i+sig6i+sig8i+sig10i)*omp**2/(2.d0*pi*pk)
      cfact=(1,0)-(brd/ompl)*(0,1)
      csigma=((1,0)*rbeta+(0,1)*xibeta)*cfact
      rbeta=dble(csigma)
      xibeta=dimag(csigma)
*      rbeta=rbeta+exchange(pk)
      return
      end

      double precision function fqlogr1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xlog=((pk-q)**2/2.d0-wp+wq)**2+(brd)**2
      xlog=xlog/(((pk+q)**2/2.d0-wp+wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogr1=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogi1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xlog=((pk-q)**2/2.d0-wp+wq)**2+(brd)**2
      xlog=xlog/(((pk+q)**2/2.d0-wp+wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogi1=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogr2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xlog=(ef-wp+wq)**2+(brd)**2
      xlog=xlog/(((pk+q)**2/2.d0-wp+wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogr2=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogi2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xlog=(ef-wp+wq)**2+(brd)**2
      xlog=xlog/(((pk+q)**2/2.d0-wp+wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogi2=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogr3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xlog=((pk-q)**2/2.d0-wp-wq)**2+(brd)**2
      xlog=xlog/((ef-wp-wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogr3=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogi3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xlog=((pk-q)**2/2.d0-wp-wq)**2+(brd)**2
      xlog=xlog/((ef-wp-wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogi3=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogr4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xlog=((pk-q)**2/2.d0-wp-wq)**2+(brd)**2
      xlog=xlog/(((pk+q)**2/2.d0-wp-wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogr4=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqlogi4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xlog=((pk-q)**2/2.d0-wp-wq)**2+(brd)**2
      xlog=xlog/(((pk+q)**2/2.d0-wp-wq)**2+(brd)**2)
      xlog=log(xlog)
      fqlogi4=xpole*xlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function fqatni1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xatan=atan((wp-wq-(pk-q)**2/2.d0)/brd)
      xatan=xatan-atan((wp-wq-(pk+q)**2/2.d0)/brd)
      fqatni1=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatnr1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xatan=atan((wp-wq-(pk-q)**2/2.d0)/brd)
      xatan=xatan-atan((wp-wq-(pk+q)**2/2.d0)/brd)
      fqatnr1=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatni2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xatan=atan((wp-wq-ef)/brd)
      xatan=xatan-atan((wp-wq-(pk+q)**2/2.d0)/brd)
      fqatni2=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatnr2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xatan=atan((wp-wq-ef)/brd)
      xatan=xatan-atan((wp-wq-(pk+q)**2/2.d0)/brd)
      fqatnr2=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatni3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xatan=atan((wp+wq-(pk-q)**2/2.d0)/brd)
      xatan=xatan-atan((wp+wq-ef)/brd)
      fqatni3=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatnr3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xatan=atan((wp+wq-(pk-q)**2/2.d0)/brd)
      xatan=xatan-atan((wp+wq-ef)/brd)
      fqatnr3=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatni4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xatan=atan((wp+wq-(pk-q)**2/2.d0)/brd)
      xatan=xatan-atan((wp+wq-(pk+q)**2/2.d0)/brd)
      fqatni4=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function fqatnr4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,xatan
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xatan=atan((wp+wq-(pk-q)**2/2.d0)/brd)
      xatan=xatan-atan((wp+wq-(pk+q)**2/2.d0)/brd)
      fqatnr4=xpole*xatan/dsqrt(q**2+omp*acc)
      return
      end

      subroutine dbrsigma(w,drbeta,dibeta)
* Calculates the derivative of the broadened photelectron self energy 
* with respect to frequency w due to 
* pole ipl in the inverse dielectric function epsilon^{-1}.
* input: w - energy (omega)
* output: drbeta - the real part of the self energy derivative
*         dibeta - the imaginary part of the self energy derivative
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - linewidth of pole in epsilon^{-1}
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=ompl+adisp*q**2+q**4/4
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable
      implicit none
      integer i,npts,nnpts,nsing,numcal,maxns,nq,nqq
      parameter (nqq=5)
      double precision w,drbeta,dibeta,grater,qdisp,wmax,wmin,
     2                 abr,rlr,xsing(20),error
      double precision qmax,qlimh,qliml,qh,q0,q1,q2,q3,qsing(nqq)
      double precision dsig1r,dsig2r,dsig3r,dsig4r,dsig5r,
     2                 dsig6r,dsig7r,dsig8r,dsig9r,dsig10r,
     3                 dsig1i,dsig2i,dsig3i,dsig4i,dsig5i,
     4                 dsig6i,dsig7i,dsig8i,dsig9i,dsig10i
      double precision fqlogr1,fqlogr2,fqlogr3,fqlogr4,
     2                 fqlogi1,fqlogi2,fqlogi3,fqlogi4,
     3                 fqatnr1,fqatnr2,fqatnr3,fqatnr4,
     4                 fqatni1,fqatni2,fqatni3,fqatni4
      double complex cfact,csigma
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      integer iwrite,jj
      common /flag/ iwrite,jj
      integer lowq
      common /belowqf/ lowq
      external grater,qdisp,
     2         dqlogr1,dqlogr2,dqlogr3,dqlogr4,
     3         dqlogi1,dqlogi2,dqlogi3,dqlogi4,
     4         dqatnr1,dqatnr2,dqatnr3,dqatnr4,
     5         dqatni1,dqatni2,dqatni3,dqatni4
      wp=w+ekp
      qmax=1.d2*dsqrt(ompl)+pk+qf
*     rlr for plasmon pole should be 10^-7 to eliminate numerical 
*     artifacts
      rlr=1.d-7
      abr=rlr/1.d3
      qlimh=pk+qf
      qliml=abs(pk-qf)
      qh=qdisp(max(wp-ef,ompl))
      q0=qdisp(max(ef-wp,ompl))
      call qlimits(wp,pk,ompl,adisp,qmax,nq,q1,q2,q3)
      qsing(1)=q0
      qsing(2)=q1
      qsing(3)=q2
      qsing(4)=q3
      qsing(5)=qh
      dsig1r=0.d0
      dsig1i=0.d0
      dsig2r=0.d0
      dsig2i=0.d0
      dsig3r=0.d0
      dsig3i=0.d0
      dsig4r=0.d0
      dsig4i=0.d0
      dsig5r=0.d0
      dsig5i=0.d0
      dsig6r=0.d0
      dsig6i=0.d0
      dsig7r=0.d0
      dsig7i=0.d0
      dsig8r=0.d0
      dsig8i=0.d0
      dsig9r=0.d0
      dsig9i=0.d0
      dsig10r=0.d0
      dsig10i=0.d0
      call findsing(qlimh,qmax,nqq,qsing,nsing,xsing)
      dsig1r=grater(dqlogr1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      dsig1i=grater(dqlogi1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      dsig2r=grater(dqatnr1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      dsig2i=grater(dqatni1,qlimh,qmax,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      call findsing(qliml,qlimh,nqq,qsing,nsing,xsing)
      dsig3r=grater(dqlogr2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      dsig3i=grater(dqlogi2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      dsig4r=grater(dqatnr2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      dsig4i=grater(dqatni2,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      if (lowq.ne.0) then
        dsig7r=grater(dqlogr3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
        dsig7i=grater(dqlogi3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
        dsig8r=grater(dqatnr3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
        dsig8i=grater(dqatni3,qliml,qlimh,abr,rlr,nsing,xsing,
     2           error,numcal,maxns)
      endif
      call findsing(0.d0,qliml,nqq,qsing,nsing,xsing)
      if (pk.gt.qf) then
        dsig5r=grater(dqlogr1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        dsig5i=grater(dqlogi1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        dsig6r=grater(dqatnr1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        dsig6i=grater(dqatni1,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      endif
      if (pk.lt.qf.and.lowq.ne.0) then
        dsig9r=grater(dqlogr4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        dsig9i=grater(dqlogi4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        dsig10r=grater(dqatnr4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        dsig10i=grater(dqatni4,0.d0,qliml,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      endif
      drbeta=(dsig1r+dsig3r+dsig5r+dsig7r+dsig9r)*omp**2/(2.d0*pi*pk)
     2     +(dsig2r+dsig4r+dsig6r+dsig8r+dsig10r)*omp**2/(2.d0*pi*pk)
      dibeta=(dsig1i+dsig3i+dsig5i+dsig7i+dsig9i)*omp**2/(2.d0*pi*pk)
     2     -(dsig2i+dsig4i+dsig6i+dsig8i+dsig10i)*omp**2/(2.d0*pi*pk)
      cfact=(1,0)-(brd/ompl)*(0,1)
      csigma=((1,0)*drbeta+(0,1)*dibeta)*cfact
      drbeta=dble(csigma)
      dibeta=dimag(csigma)
*      rbeta=rbeta+exchange(pk)
      return
      end

      double precision function dqlogr1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp-wq-(pk-q)**2/2.d0
      xw2=wp-wq-(pk+q)**2/2.d0
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogr1=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqlogi1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp-wq-(pk-q)**2/2.d0
      xw2=wp-wq-(pk+q)**2/2.d0
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogi1=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqlogr2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp-wq-ef
      xw2=wp-wq-(pk+q)**2/2.d0
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogr2=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqlogi2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp-wq-ef
      xw2=wp-wq-(pk+q)**2/2.d0
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogi2=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqlogr3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-ef
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogr3=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqlogi3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-ef
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogi3=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end


      double precision function dqlogr4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-(pk+q)**2/2.d0
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogr4=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqlogi4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxlog,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-(pk+q)**2/2.d0
      dxlog=xw1/((xw1)**2+(brd)**2)-xw2/((xw2)**2+(brd)**2)
      dqlogi4=xpole*dxlog/dsqrt(q**2+ompl*acc)
      return
      end

      double precision function dqatni1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp-wq-(pk-q)**2/2.d0
      xw2=wp-wq-(pk+q)**2/2.d0
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatni1=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatnr1(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp-wq-(pk-q)**2/2.d0
      xw2=wp-wq-(pk+q)**2/2.d0
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatnr1=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatni2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp-wq-ef
      xw2=wp-wq-(pk+q)**2/2.d0
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatni2=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatnr2(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp-wq-ef
      xw2=wp-wq-(pk+q)**2/2.d0
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatnr2=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatni3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-ef
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatni3=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatnr3(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-ef
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatnr3=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatni4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=wq/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-(pk+q)**2/2.d0
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatni4=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      double precision function dqatnr4(q)
* Integrand for one of the intergals in calculating the 
* self energy in subroutine brsigma.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
*      integer it1,it2,i
      double precision q,wq,xpole,dxatan,xw1,xw2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xpole=brd/(wq**2+brd**2)
      xw1=wp+wq-(pk-q)**2/2.d0
      xw2=wp+wq-(pk+q)**2/2.d0
      dxatan=brd/((xw1)**2+(brd)**2)-brd/((xw2)**2+(brd)**2)
      dqatnr4=xpole*dxatan/dsqrt(q**2+omp*acc)
      return
      end

      subroutine findsing(ql,qh,nqq,qsing,nsing,xsing)
* finds which values in the array qsing are between ql and qh, and puts
* them in the array xsing.  Returns number of elements in xsing as nsing
      implicit none
      integer i,j,k,nqq,nsing,it
      double precision ql,qh,qsing(nqq),xsing(20),store
      integer iwrite,jj
      common /flag/ iwrite,jj
      nsing=0
      do i=1,nqq
        if (qsing(i).gt.ql.and.qsing(i).lt.qh) then
          nsing=nsing+1
          xsing(nsing)=qsing(i)
        elseif (qsing(i).lt.ql.and.qsing(i).gt.qh) then
          nsing=nsing+1
          xsing(nsing)=qsing(i)
        endif
      enddo
      if (nsing.le.1) goto 40
      j=2
 20   k=j
 30   continue
      if (xsing(k-1).gt.xsing(k)) then
        store=xsing(k-1)
        xsing(k-1)=xsing(k)
        xsing(k)=store
        k=k-1
        if (k.gt.1) goto 30
      endif
      j=j+1
      if (j.le.nsing) goto 20
 40   return
      end

      double precision function exchange(qk)
* compute the HF exchange potential for the free electron gas
* input: qk - photoelectron momentum
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       qf - Fermi momentum
      implicit none
      integer i,ii,j,jj
      double precision qk
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      if (qk.eq.qf) then
        exchange=-qf/pi
      else
        exchange=-(1.d0/pi)*(qf+
     2  ((qf**2-qk**2)/(2.d0*qk))*log(dabs((qk+qf)/(qk-qf))))
      endif
      return
      end

      subroutine xienergies(w,xibeta)
* Calculates the imaginary part of the photelectron self energy.
* input: w - energy (omega)
* output: xibeta - the imaginary part of the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=ompl+adisp*q**2+q**4/4
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable
      implicit none
      integer i,npts,nnpts,nsing,numcal,maxns
      double precision w,xibeta,beta,xiw1beta,grater,wmax,wmin,
     2                 abr,rlr,xsing,error
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      integer lowq
      common /belowqf/ lowq
      external beta,xiw1beta,grater
      xibeta=-beta(w)*pi
      return
      end

      subroutine drenergies(w,drbeta)
* Calculates the real part of the derivative of the photelectron 
* self energy with respect to omega.
* input: w - energy (omega)
* output: drbeta - the imaginary part of the derivative of the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable
      implicit none
      integer i,npts,nnpts,nsing,numcal,maxns
      double precision w,drbeta,beta,grater,wmax,wmin,
     2                 abr,rlr,xsing,error,qmax
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision rseint1,rseint2,rseint3
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      integer lowq
      common /belowqf/ lowq
      external beta,grater,drseint1,drseint2,drseint3
      wp=w+ekp
      qmax=1.d2*dsqrt(ompl)
*     rlr for plasmon pole should be 10^-7 to eliminate numerical 
*     artifacts
      rlr=1.d-7
      abr=rlr/1.d3
      nsing=0
      if (pk.gt.qf) then
        drbeta=grater(drseint1,pk+qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        drbeta=drbeta+grater(drseint1,0.d0,pk-qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        drbeta=drbeta+grater(drseint2,pk-qf,pk+qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
      elseif (pk.lt.qf) then
        drbeta=grater(drseint1,pk+qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        drbeta=drbeta+grater(drseint2,qf-pk,pk+qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        if (lowq.ne.0) drbeta=drbeta+grater(drseint3,0.d0,
     2             qf-pk,abr,rlr,nsing,xsing,error,numcal,maxns)
      else
        drbeta=grater(drseint1,2.d0*qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        drbeta=drbeta+grater(drseint2,0.d0,2.d0*qf,abr,rlr,nsing,
     2             xsing,error,numcal,maxns)
      endif
      drbeta=drbeta*omp**2/(2.d0*pi*pk)
      return
      end

      subroutine dienergies(w,dibeta)
* Calculates the imaginary part of the derivative of the photelectron 
* self energy with respect to omega.
* input: w - energy (omega)
* output: dibeta - the imaginary part of the derivative of the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=ompl+adisp*q**2+q**4/4
      implicit none
      integer i,npts,nnpts
      double precision w,dibeta
      integer it1,it2,nq
      double precision qh,q1,q2,q3,q0,wh,wq1,wq2,wq3,wq0,qmax
* the q's are limiting values of momenta, the w's are energies
* corresponding to these limiting momenta
      double precision qdisp,A,wdisp,test1,test2
      double precision dq0dw,dq1dw,dq2dw,dq3dw,dqhdw,xfact
* the dqdw's are derivatives of the momentum limits with
* changing energy
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      integer lowq
      common /belowqf/ lowq
      external qdisp,wdisp
      A=adisp
      q1=0.d0
      q2=0.d0
      q3=0.d0
*      xfact=0.d0
      dibeta=0.d0
* Must find the momenta which limit the 
* final integration (done analytically).
* Find limit due to Fermi level
      qh=qdisp(max(w+ekp-ef,ompl))
      q0=qdisp(max(ef-w-ekp,ompl))
* Find roots of omega(q)-omega+(q-k)^2/2=0, omega(q)-omega+(q+k)^2/2=0,
* and omega(q)+omega-(k-q)^2/2=0 for q>0.
      qmax=1.d6*qf
      call qlimits(w+ekp,pk,ompl,A,qmax,nq,q1,q2,q3)
* find derivatives of q's
      wq1=wdisp(q1)
      if (w+ekp-ef.gt.ompl) then
        dqhdw=(w+ekp-ef)/(qh*dsqrt(A**2+(w+ekp-ef)**2-ompl**2))
        dq0dw=0.d0
      elseif(ef-w-ekp.gt.ompl) then
        dq0dw=-(ef-w-ekp)/(q0*dsqrt(A**2+(ef-w-ekp)**2-ompl**2))
        dqhdw=0.d0
      else
        dqhdw=0.d0
        dq0dw=0.d0
      endif
      test1=(pk+q1)**2/2.d0-(w+ekp)+wq1
      test2=(pk-q1)**2/2.d0-(w+ekp)+wq1
      if (q1.ge.qh) then
        q1=qh
        dq1dw=dqhdw
      elseif (dabs(test1).lt.dabs(test2)) then
        dq1dw=wq1/((q1+pk)*wq1+A*q1+q1**3/2.d0)
      else
        dq1dw=wq1/((q1-pk)*wq1+A*q1+q1**3/2.d0)
      endif
      wq2=wdisp(q2)
      test1=(pk+q2)**2/2.d0-(w+ekp)+wq2
      test2=(pk-q2)**2/2.d0-(w+ekp)+wq2
      if (q2.ge.qh) then
        q2=qh
        dq2dw=dqhdw
      elseif (dabs(test1).lt.dabs(test2)) then
        dq2dw=wq2/((q2+pk)*wq2+A*q2+q2**3/2.d0)
      else
        dq2dw=wq2/((q2-pk)*wq2+A*q2+q2**3/2.d0)
      endif
      wq3=wdisp(q3)
      test1=(pk+q3)**2/2.d0-(w+ekp)-wq3
      test2=(pk-q3)**2/2.d0-(w+ekp)-wq3
      if (q3.ge.q0) then
        q3=q0
        dq3dw=dq0dw
      elseif (dabs(test1).lt.dabs(test2)) then
        dq3dw=wq3/((q3+pk)*wq3-A*q3-q3**3/2.d0)
      else
        dq3dw=wq3/((q3-pk)*wq3-A*q3-q3**3/2.d0)
      endif
* find derivative of imaginary part of self energy
* find contributions from above Fermi momentum
      if (nq.eq.3) then
        q1=dsqrt(q1**2+acc*ompl)
        q2=dsqrt(q2**2+acc*ompl)
        wq1=wdisp(q1)
        wq2=wdisp(q2)
        xfact=A*q1*(1.d0/wq1+1.d0/ompl)+q1**3/(2.d0*wq1)
        xfact=2.d0/q1-xfact/(ompl+wq1+A*q1**2/(2.d0*ompl))
        dibeta=dibeta+omp**2/(4.d0*pk*ompl)*dq1dw*xfact
        xfact=A*q2*(1.d0/wq2+1.d0/ompl)+q2**3/(2.d0*wq2)
        xfact=2.d0/q2-xfact/(ompl+wq2+A*q2**2/(2.d0*ompl))
        dibeta=dibeta-omp**2/(4.d0*pk*ompl)*dq2dw*xfact
      endif
* find contributions from below Fermi momentum
      if (q3.lt.q0.and.lowq.ne.0) then
        q0=dsqrt(q0**2+acc*ompl)
        q3=dsqrt(q3**2+acc*ompl)
        wq0=wdisp(q0)
        wq3=wdisp(q3)
        xfact=A*q0*(1.d0/wq0+1.d0/ompl)+q0**3/(2.d0*wq0)
        xfact=2.d0/q0-xfact/(ompl+wq0+A*q0**2/(2.d0*ompl))
        dibeta=dibeta+omp**2/(4.d0*pk*ompl)*dq0dw*xfact
        xfact=A*q3*(1.d0/wq3+1.d0/ompl)+q3**3/(2.d0*wq3)
        xfact=2.d0/q3-xfact/(ompl+wq3+A*q3**2/(2.d0*ompl))
        dibeta=dibeta-omp**2/(4.d0*pk*ompl)*dq3dw*xfact
      endif
      dibeta=dibeta
* Test that dibeta is a number (stop for nan results).
      it1=int(dibeta)
      it2=int(2.d0*dibeta)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'dienergies ',dibeta
        stop
      endif
      dibeta=dibeta
      return
      end

      subroutine d2renergies(w,d2rbeta)
* Calculates the real part of the second derivative of the photelectron 
* self energy with respect to omega.
* input: w - energy (omega)
* output: d2rbeta - the real part of the second derivative of the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable
      implicit none
      integer i,npts,nnpts,nsing,numcal,maxns
      double precision w,d2rbeta,beta,grater,wmax,wmin,
     2                 abr,rlr,xsing,error,qmax
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision d2rseint1,d2rseint2,d2rseint3
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      integer lowq
      common /belowqf/ lowq
      external beta,grater,d2rseint1,d2rseint2,d2rseint3
      wp=w+ekp
      wmin=-100*(pi*beta(0.d0)+ompl)+w
      wmax=100*(pi*beta(0.d0)+ompl)+w
      qmax=1.d2*dsqrt(ompl)
*     rlr for plasmon pole should be 10^-7 to eliminate numerical 
*     artifacts
      rlr=1.d-7
      abr=rlr/1.d3
      nsing=0
      if (pk.gt.qf) then
        d2rbeta=grater(d2rseint1,pk+qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        d2rbeta=d2rbeta+grater(d2rseint1,0.d0,pk-qf,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        d2rbeta=d2rbeta+grater(d2rseint2,pk-qf,pk+qf,abr,rlr,nsing,
     2             xsing,error,numcal,maxns)
      elseif (pk.lt.qf) then
        d2rbeta=grater(d2rseint1,pk+qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        d2rbeta=d2rbeta+grater(d2rseint2,qf-pk,pk+qf,abr,rlr,nsing,
     2             xsing,error,numcal,maxns)
        if (lowq.ne.0) d2rbeta=d2rbeta+grater(d2rseint3,0.d0,
     2             qf-pk,abr,rlr,nsing,xsing,error,numcal,maxns)
      else
        d2rbeta=grater(d2rseint1,2.d0*qf,qmax,abr,rlr,nsing,xsing,
     2             error,numcal,maxns)
        d2rbeta=d2rbeta+grater(d2rseint2,0.d0,2.d0*qf,abr,rlr,nsing,
     2             xsing,error,numcal,maxns)
      endif
      d2rbeta=d2rbeta*omp**2/(2.d0*pi*pk)
      return
      end

      subroutine d2ienergies(w,d2ibeta)
* Calculates the imaginary part of the second derivative of the photelectron 
* self energy with respect to omega.
* input: w - energy (omega)
* output: d2ibeta - the imaginary part of the second derivative of 
*                   the self energy
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
      implicit none
      integer i,npts,nnpts
      double precision w,d2ibeta
      integer it1,it2,nq
      double precision qh,q1,q2,q3,q0,wh,wq1,wq2,wq3,wq0,qmax
* the q's are limiting values of momenta, the w's are energies
* corresponding to these limiting momenta
      double precision qdisp,A,wdisp,test1,test2,www,d2fact,xfact
      double precision dq0dw,dq1dw,dq2dw,dq3dw,dqhdw,dwqdw
* the dqdw's are derivatives of the momentum limits with
* changing energy
      double precision d2q0dw2,d2q1dw2,d2q2dw2,d2q3dw2,d2qhdw2
* the d2qdw2's are second derivatives of the momentum limits with
* changing energy (but you've already figured that out by now, right?)
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      integer lowq
      common /belowqf/ lowq
      external qdisp,wdisp,d2fact
      A=adisp
      q1=0.d0
      q2=0.d0
      q3=0.d0
      d2ibeta=0.d0
* Must find the momenta which limit the 
* final integration (done analytically).
* Find limit due to Fermi level
      qh=qdisp(max(w+ekp-ef,ompl))
      q0=qdisp(max(ef-w-ekp,ompl))
* Find roots of omega(q)-omega+(q-k)^2/2=0, omega(q)-omega+(q+k)^2/2=0,
* and omega(q)+omega-(k-q)^2/2=0 for q>0.
      qmax=1.d6*qf
      call qlimits(w+ekp,pk,ompl,A,qmax,nq,q1,q2,q3)
* find derivatives of q's
      wq1=wdisp(q1)
      if (w+ekp-ef.gt.ompl) then
        www=A**2+(w+ekp-ef)**2-ompl**2
        dqhdw=(w+ekp-ef)/(qh*dsqrt(www))
        dq0dw=0.d0
        d2qhdw2=1/(qh*dsqrt(www))-(w+ekp-ef)**2/(qh*dsqrt(www)**3)
     2          -(w+ekp-ef)*dqhdw/(qh**2*dsqrt(www))
        d2q0dw2=0.d0
      elseif(ef-w-ekp.gt.ompl) then
        www=A**2+(w+ekp-ef)**2-ompl**2
        dq0dw=(w+ekp-ef)/(q0*dsqrt(www))
        dqhdw=0.d0
        d2q0dw2=1/(q0*dsqrt(www))-(w+ekp-ef)**2/(q0*dsqrt(www)**3)
     2          -(w+ekp-ef)*dq0dw/(q0**2*dsqrt(www))
        d2qhdw2=0.d0
      else
        dqhdw=0.d0
        dq0dw=0.d0
        d2qhdw2=0.d0
        d2q0dw2=0.d0
      endif
      test1=(pk+q1)**2/2.d0-(w+ekp)+wq1
      test2=(pk-q1)**2/2.d0-(w+ekp)+wq1
      if (q1.ge.qh) then
        q1=qh
        dq1dw=dqhdw
        d2q1dw2=d2qhdw2
      elseif (dabs(test1).lt.dabs(test2)) then
        dq1dw=wq1/((q1+pk)*wq1+A*q1+q1**3/2.d0)
        dwqdw=(A*q1+q1**3/2.d0)/wq1*dq1dw
        d2q1dw2=dwqdw/((q1+pk)*wq1+A*q1+q1**3/2.d0)
     2  -wq1/((q1+pk)*wq1+A*q1+q1**3/2.d0)
     3  *((wq1+A+3*q1**2/2.d0)*dq1dw+(q1+pk)*dwqdw)
      else
        dq1dw=wq1/((q1-pk)*wq1+A*q1+q1**3/2.d0)
        dwqdw=(A*q1+q1**3/2.d0)/wq1*dq1dw
        d2q1dw2=dwqdw/((q1-pk)*wq1+A*q1+q1**3/2.d0)
     2  -wq1/((q1-pk)*wq1+A*q1+q1**3/2.d0)
     3  *((wq1+A+3*q1**2/2.d0)*dq1dw+(q1-pk)*dwqdw)
      endif
      wq2=wdisp(q2)
      test1=(pk+q2)**2/2.d0-(w+ekp)+wq2
      test2=(pk-q2)**2/2.d0-(w+ekp)+wq2
      if (q2.ge.qh) then
        q2=qh
        dq2dw=dqhdw
        d2q2dw2=d2qhdw2
      elseif (dabs(test1).lt.dabs(test2)) then
        dq2dw=wq2/((q2+pk)*wq2+A*q2+q2**3/2.d0)
        dwqdw=(A*q2+q2**3/2.d0)/wq2*dq2dw
        d2q2dw2=dwqdw/((q2+pk)*wq2+A*q2+q2**3/2.d0)
     2  -wq2/((q2+pk)*wq2+A*q2+q2**3/2.d0)
     3  *((wq2+A+3*q2**2/2.d0)*dq2dw+(q2+pk)*dwqdw)
      else
        dq2dw=wq2/((q2-pk)*wq2+A*q2+q2**3/2.d0)
        dwqdw=(A*q2+q2**3/2.d0)/wq2*dq2dw
        d2q2dw2=dwqdw/((q2-pk)*wq2+A*q2+q2**3/2.d0)
     2  -wq2/((q2-pk)*wq2+A*q2+q2**3/2.d0)
     3  *((wq2+A+3*q2**2/2.d0)*dq2dw+(q2-pk)*dwqdw)
      endif
      wq3=wdisp(q3)
      test1=(pk+q3)**2/2.d0-(w+ekp)-wq3
      test2=(pk-q3)**2/2.d0-(w+ekp)-wq3
      if (q3.ge.q0) then
        q3=q0
        dq3dw=dq0dw
        d2q3dw2=d2q0dw2
      elseif (dabs(test1).lt.dabs(test2)) then
        dq3dw=wq3/((q3+pk)*wq3-A*q3-q3**3/2.d0)
        dwqdw=(A*q3+q3**3/2.d0)/wq3*dq3dw
        d2q3dw2=dwqdw/((q3+pk)*wq3-A*q3-q3**3/2.d0)
     2  -wq3/((q3+pk)*wq3-A*q3-q3**3/2.d0)
     3  *((wq3-A-3*q3**2/2.d0)*dq3dw+(q3+pk)*dwqdw)
      else
        dq3dw=wq3/((q3-pk)*wq3-A*q3-q3**3/2.d0)
        dwqdw=(A*q3+q3**3/2.d0)/wq3*dq3dw
        d2q3dw2=dwqdw/((q3-pk)*wq3-A*q3-q3**3/2.d0)
     2  -wq3/((q3-pk)*wq3-A*q3-q3**3/2.d0)
     3  *((wq3-A-3*q3**2/2.d0)*dq3dw+(q3-pk)*dwqdw)
      endif
* find second derivative of imaginary part of self energy
* find contributions from above Fermi momentum
      if (nq.eq.3) then
        q1=dsqrt(q1**2+acc*ompl)
        q2=dsqrt(q2**2+acc*ompl)
        wq1=wdisp(q1)
        wq2=wdisp(q2)
        d2ibeta=d2ibeta+d2fact(q1,wq1,dq1dw,d2q1dw2)
        d2ibeta=d2ibeta-d2fact(q2,wq2,dq2dw,d2q2dw2)
      endif
* find contributions from below Fermi momentum
      if (q3.lt.q0.and.lowq.ne.0) then
        q0=dsqrt(q0**2+acc*ompl)
        q3=dsqrt(q3**2+acc*ompl)
        wq0=wdisp(q0)
        wq3=wdisp(q3)
        d2ibeta=d2ibeta+d2fact(q0,wq0,dq0dw,d2q0dw2)
        d2ibeta=d2ibeta-d2fact(q3,wq3,dq3dw,d2q3dw2)
      endif
* Test that d2ibeta is a number (stop for nan results).
      it1=int(d2ibeta)
      it2=int(2.d0*d2ibeta)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'd2ienergies ',d2ibeta
        stop
      endif
      d2ibeta=d2ibeta
      return
      end

      double precision function d2fact(q,wq,dqdw,d2qdw2)
* the terms in a sum used to calculate the imaginary part of
* the second derivative of the self energy in the subroutine
* d2ienergies.
* input: q - momentum limit
*        wq - energy corresponding to q
*        dqdw - derivative of momentum limit with respect to energy
*        d2qdw2 - second derviative of momentum limit
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
      implicit none
      double precision q,wq,dqdw,d2qdw2,xfact1,xfact2,dwqdw
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,A
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,A
      dwqdw=(A*q+q**3/2.d0)/wq*dqdw
      xfact1=((A*(1.d0/wq+1.d0/ompl)+3.d0*q**2/(2.d0*wq))*dqdw
     2  -dwqdw*(q**3+2.d0*A*q)/(2*wq**2))
     3  /(ompl+wq+A*q**2/(2.d0*ompl))
      xfact1=-xfact1+(dwqdw+A*q*dqdw/ompl)
     2  *(A*q*(1.d0/wq+1.d0/ompl)+q**3/(2.d0*wq))
     3  /(ompl+wq+A*q**2/(2.d0*ompl))**2
      xfact1=xfact1-2.d0*dqdw/q**2
      xfact2=A*q*(1.d0/wq+1.d0/ompl)+q**3/(2.d0*wq)
      xfact2=2.d0/q-xfact2/(ompl+wq+A*q**2/(2.d0*ompl))
      d2fact=omp**2/(4.d0*pk*ompl)*(dqdw*xfact1+d2qdw2*xfact2)
      return
      end

      double precision function rseint1(q)
* Integrand for one of the intergals in calculating the real part
* of the self energy in subroutine renergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      integer ijkwrite
      common /morewrite/ ijkwrite
      wq=wdisp(q)
      xlog=((pk+q)**2/2.d0-wp+wq)**2+(acc*ompl)**2
      xlog=xlog/(((pk-q)**2/2.d0-wp+wq)**2+(acc*ompl)**2)
      xlog=log(xlog)/2.d0
      rseint1=xlog/(wq*dsqrt(q**2+ompl*acc))
** NAN detector
*      it1=int(rseint1)
*      it2=int(2.d0*rseint1)
*      if (it1.eq.it2.and.it1.gt.5) then
*        write(6,*) 'rseint1 ',rseint1,q,wq,xlog,wp,pk,acc,ompl
*        stop
*      endif
      return
      end

      double precision function rseint2(q)
* Integrand for one of the intergals in calculating the real part
* of the self energy in subroutine renergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      integer lowq
      common /belowqf/ lowq
      external qdisp,wdisp
      wq=wdisp(q)
      xlog=1.d0
      if (lowq.ne.0) then
        xlog=(ef-wp-wq)**2+(acc*ompl)**2
        xlog=xlog/(((pk-q)**2/2.d0-wp-wq)**2+(acc*ompl)**2)
      endif
      xlog=xlog*(((pk+q)**2/2.d0-wp+wq)**2+(acc*ompl)**2)
      xlog=xlog/((ef-wp+wq)**2+(acc*ompl)**2)
      xlog=log(xlog)/2.d0
      rseint2=xlog/(wq*dsqrt(q**2+ompl*acc))
** NAN detector
*      it1=int(rseint2)
*      it2=int(2.d0*rseint2)
*      if (it1.eq.it2.and.it1.gt.5) then
*        write(6,*) 'rseint2 ',rseint2,q,wq,xlog,wp,pk,acc,ompl
*        stop
*      endif
      return
      end

      double precision function rseint3(q)
* Integrand for one of the intergals in calculating the real part
* of the self energy in subroutine renergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xlog
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xlog=((pk+q)**2/2.d0-wp-wq)**2+(acc*ompl)**2
      xlog=xlog/(((pk-q)**2/2.d0-wp-wq)**2+(acc*ompl)**2)
      xlog=log(xlog)/2.d0
      rseint3=xlog/(wq*dsqrt(q**2+ompl*acc))
** NAN detector
*      it1=int(rseint3)
*      it2=int(2.d0*rseint3)
*      if (it1.eq.it2.and.it1.gt.5) then
*        write(6,*) 'rseint3 ',rseint3,q,wq,xlog,wp,pk,acc,ompl
*        stop
*      endif
      return
      end

      double precision function drseint1(q)
* Integrand for one of the intergals in calculating the derivative 
* of the real part of the self energy in subroutine drenergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xfact,xnum1,xnum2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xnum1=(pk+q)**2/2.d0-wp+wq
      xfact=xnum1/(xnum1**2+brd**2)
      xnum2=(pk-q)**2/2.d0-wp+wq
      xfact=xfact-xnum2/(xnum2**2+brd**2)
      drseint1=xfact/(wq*dsqrt(q**2+ompl*acc))
      it1=int(drseint1)
      it2=int(2.d0*drseint1)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'drseint1 ',drseint1,q,wq,xfact,wp,pk,acc,ompl
        stop
      endif
      return
      end

      double precision function drseint2(q)
* Integrand for one of the intergals in calculating the derivative 
* of the real part of the self energy in subroutine drenergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xfact,xnum1,xnum2,xnum3,xnum4
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      integer lowq
      common /belowqf/ lowq
      external qdisp,wdisp
      wq=wdisp(q)
      xfact=0.d0
      if (lowq.ne.0) then
        xnum1=ef-wp-wq
        xfact=xnum1/(xnum1**2+brd**2)
        xnum2=(pk-q)**2/2.d0-wp-wq
        xfact=xfact-xnum2/(xnum2**2+brd**2)
      endif
      xnum3=(pk+q)**2/2.d0-wp+wq
      xfact=xfact+xnum3/(xnum3**2+brd**2)
      xnum4=ef-wp+wq
      xfact=xfact-xnum4/(xnum4**2+brd**2)
      drseint2=xfact/(wq*dsqrt(q**2+ompl*acc))
      it1=int(drseint2)
      it2=int(2.d0*drseint2)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'drseint2 ',drseint2,q,wq,xfact,wp,pk,acc,ompl
        stop
      endif
      return
      end

      double precision function drseint3(q)
* Integrand for one of the intergals in calculating the derivative 
* of the real part of the self energy in subroutine drenergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xfact,xnum1,xnum2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xnum1=(pk+q)**2/2.d0-wp-wq
      xfact=xnum1/(xnum1**2+brd**2)
      xnum2=(pk-q)**2/2.d0-wp-wq
      xfact=xfact-xnum2/sqrt(xnum2**2+brd**2)
      drseint3=xfact/(wq*dsqrt(q**2+ompl*acc))
      it1=int(drseint3)
      it2=int(2.d0*drseint3)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'drseint3 ',drseint3,q,wq,xfact,wp,pk,acc,ompl
        stop
      endif
      return
      end

      double precision function d2rseint1(q)
* Integrand for one of the intergals in calculating the second derivative 
* of the real part of the self energy in subroutine d2renergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xfact,xnum1,xnum2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xnum1=(pk+q)**2/2.d0-wp+wq
      xfact=(xnum1**2-brd**2)/(xnum1**2+brd**2)**2
      xnum2=(pk-q)**2/2.d0-wp+wq
      xfact=xfact-(xnum2**2-brd**2)/(xnum2**2+brd**2)**2
      d2rseint1=xfact/(wq*dsqrt(q**2+ompl*acc))
      it1=int(d2rseint1)
      it2=int(2.d0*d2rseint1)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'd2rseint1 ',d2rseint1,q,wq,xfact,wp,pk,acc,ompl
        stop
      endif
      return
      end

      double precision function d2rseint2(q)
* Integrand for one of the intergals in calculating the second derivative 
* of the real part of the self energy in subroutine d2renergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xfact,xnum1,xnum2,xnum3,xnum4
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      integer lowq
      common /belowqf/ lowq
      external qdisp,wdisp
      wq=wdisp(q)
      xfact=0.d0
      if (lowq.ne.0) then
        xnum1=ef-wp-wq
        xfact=(xnum1**2-brd**2)/(xnum1**2+brd**2)**2
        xnum2=(pk-q)**2/2.d0-wp-wq
        xfact=xfact-(xnum2**2-brd**2)/(xnum2**2+brd**2)**2
      endif
      xnum3=(pk+q)**2/2.d0-wp+wq
      xfact=xfact+(xnum3**2-brd**2)/(xnum3**2+brd**2)**2
      xnum4=ef-wp+wq
      xfact=xfact-(xnum4**2-brd**2)/(xnum4**2+brd**2)**2
      d2rseint2=xfact/(wq*dsqrt(q**2+ompl*acc))
      it1=int(d2rseint2)
      it2=int(2.d0*d2rseint2)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'd2rseint2 ',d2rseint2
        stop
      endif
      return
      end

      double precision function d2rseint3(q)
* Integrand for one of the intergals in calculating the second derivative 
* of the real part of the self energy in subroutine d2renergies.
* input: q - momentum (variable to be integrated over)
* input from common blocks
*       ompl - energy of pole ipl in epsilon^{-1}
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
* common block control of subprograms
*       ac2 - additional accuracy parameter
*       wp - omega prime, an additional energy variable to be held
*            constant durring the integration
      implicit none
      integer it1,it2,i
      double precision q,wq,xfact,xnum1,xnum2
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      double precision ac2,wp
      common /ff/ ac2,wp
      double precision qdisp,wdisp
      external qdisp,wdisp
      wq=wdisp(q)
      xnum1=(pk+q)**2/2.d0-wp-wq
      xfact=(xnum1**2-brd**2)/(xnum1**2+brd**2)**2
      xnum2=(pk-q)**2/2.d0-wp-wq
      xfact=xfact-(xnum2**2-brd**2)/sqrt(xnum2**2+brd**2)**2
      d2rseint3=xfact/(wq*dsqrt(q**2+ompl*acc))
      it1=int(d2rseint3)
      it2=int(2.d0*d2rseint3)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'd2rseint3 ',d2rseint3
        stop
      endif
      return
      end

      double precision function beta(w)
* the extrinsic beta function
* beta(k,w)=(1/pi)*|Im(self energy(k,w+(k^2)/2))|*theta((w+(k^2)/2)-xmu)
* input: w - energy (omega)
* input from common blocks
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       xmu - chemical potential = Fermi energy + self consistent 
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole ipl in epsilon^{-1}
*       wt - weight of pole ipl in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of 
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       pk - photoelectron momentum
*       acc - global accuracy parameter 
*       brd - global broadening parameter to stabilize logarithms
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
      implicit none
      integer it1,it2,nq,i
      double precision w,q1,q2,q3,wth,wq0,wq1,wq2,wq3
      double precision q0,qh,qdisp,A,wdisp
      double precision pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
      common /convsf/ pi,ef,xmu,qf,omp,ompl,wt,ekp,ek,pk,acc,brd,adisp
*      common /temp/ q1,q2
      integer lowq
      common /belowqf/ lowq
      external qdisp,wdisp
      A=adisp
      q1=0.d0
      q2=0.d0
* Must find the momenta which limit the
* final integration (done analytically).
      beta=0.d0
* Find limit due to Fermi level
      qh=qdisp(max(w+ekp-ef,ompl))
      q0=qdisp(max(ef-w-ekp,ompl))
* Find roots of omega(q)-omega+(q-k)^2/2=0, omega(q)-omega+(q+k)^2/2=0,
* and omega(q)+omega-(k-q)^2/2=0.
      call qlimits(w+ekp,pk,ompl,A,qh,nq,q1,q2,q3)
* Calculate beta
* Calculate contributions from above Fermi momentum
      if (nq.eq.3) then
        q1=dsqrt(q1**2+acc*ompl)
        q2=dsqrt(q2**2+acc*ompl)
        wq1=wdisp(q1)
        wq2=wdisp(q2)
        beta=beta+omp**2/(4*pi*pk*ompl)
     2       *dlog(q2**2/(ompl+wq2+A*q2**2/(2.d0*ompl))
     2       *(ompl+wq1+A*q1**2/(2.d0*ompl))/q1**2)
*        beta=beta+ompl/(4*pi*pk)
*     2       *dlog(q2**2/(ompl+wq2+A*q2**2/(2.d0*ompl)))
      endif
* Calculate contributions from below Fermi momentum
      if (q3.lt.q0.and.lowq.ne.0) then
        q0=dsqrt(q0**2+acc*ompl)
        q3=dsqrt(q3**2+acc*ompl)
        wq0=wdisp(q0)
        wq3=wdisp(q3)
        beta=beta-omp**2/(4*pi*pk*ompl)
     2       *dlog(q0**2/(ompl+wq0+A*q0**2/(2.d0*ompl))
     2       *(ompl+wq3+A*q3**2/(2.d0*ompl))/q3**2)
      endif
* Test that beta is a number (stop for nan results).
      it1=int(beta)
      it2=int(2.d0*beta)
      if (it1.eq.it2.and.it1.gt.5) then
        write(6,*) 'beta ',beta,q1,q2,q3,q0
        write(6,*) 'beta ',pk,w,ekp,acc,ompl
        write(6,*) nq
        write(6,*) q1,q2
        stop
      endif
      return
      end
      
* Program so2conv, by Luke Campbell (2002)

      subroutine so2conv (ispec, ipr6, ipse, ipsk, wsigk, cen, cfname)

* This program computes many body effects on an XAS spectrum given in
* one or more FEFF output files of the form chi.dat,chipnnnn.dat,
* xmu.dat, or feffnnnn.dat.  The files read are from the most recent FEFF 
* from the directory in which this (sub) program is run, as determined
* by the files feff.inp and list.dat.  The files are overwritten
* with the computed spectra corrected for many body effects.

      implicit none
      integer npts,npts2,j,nsfpts,nqpts,maxfiles,ifiles,ifeffct
*      parameter(npts=400,npts2=401,nsfpts=80,nqpts=66,maxfiles=200)
      parameter(npts=400,npts2=401,nsfpts=112,nqpts=66,maxfiles=200)
*       npts - The number of points of the uniform energy grid used for 
*              the spectral function.
*       npts2 - The maximum number of data points in the data files
*       j - Used to store the number of data points in a data file.
*       nsfpts - Number of points of the minimal energy grid used for 
*              the spectral function.
*       nqpts - Number of points in the minimal momentum grid used for
*              the spectral function.
*       maxfiles - The maximum expected number of FEFF files to be read.
*       ifiles - The actual number of FEFF files specified.
*       ifeffct - Number of data points in a feffnnnn.dat file.
      integer i,ii,jj,ik,ikk,ipl
*       i,ii,jj,ik,ikk,ipl - counters for loops.
      integer last,lfirst,isearch,ifirst(maxfiles),ilast(maxfiles)
*       last - Collum number of last non-blank character in text string.
*       lfirst - Collum number of first non-blank character in text string.
*       isearch - Another counter for loops, used in text string searches.
*       ifirst - Collum number of start of file name.
*       ilast - Collum number of end of file name.
      integer ispec,ipr6
*       ispec - Identifies type of spectroscopy.  0 for EXAFS, 1 for XANES.
*       ipr6 - Identifes which files need to be convoluted.
      integer iwrite,iwrite2,intout,iwrconv,iwrcfile,iout,ipw,
     2        ipwc,ipse,ipsk
      double precision cen,den,den2
      character*12 cfname
*       iwrite - Write the spectral function and self energy 
*              to a file at this point on the minimal grid.
*       iwrite2 - Write the spectral function to a file at this point 
*              on the uniform grid.
*       intout - Set to one to write out the running integration of 
*              the convolution with the spectral function.
*       iwrconv - The data point at which the running integration is
*              to be written.
*       iwrcfile - The file for which the running integration is to be 
*              written.
*       ipw - Set greater than zero to write a file of integrated spectral
*              weights.
*       ipwc - Set greater than zero to write a file of integrated spectra
*              weights with the extrinsic spectral function separated into
*              quasiparticle and satellite terms.
*       ipse - Set greater to zero to write a file of the on shell
*              self energy.
*       ipsk - Set greater than zero to write the spectral function 
*              and self energy at a specified momentum.
*       iout - Flags whether the file specfunct.dat needs to
*              be created.
*       cen -  closest energy point to write out running convolution
*       den -  difference in gridpoint energy and cen (above)
*       cfname - name of file shown in running convolution (NULL if none)
      double precision wsigk
*       wsigk - Momentum at which to write self energy file if 
*              ipsk specified.
      integer iedge,ios,itype(maxfiles),iasym,iasymt,isattype,isattypt,
     2        icut,nleg,npi
*       iedge - Pointer to the Fermi energy in xmu.dat.
*       ios - Greater than 1 upon failure to open a file.
*       itype - Identifies type of file read.
*       iasym - Set to 1 to include quasiparticle phase as an
*              asymmetric 1/omega term to the extrinsic satellite
*              rather than as a complex spectral weight.  This is
*              necessary when convoluting with a real valued
*              function or one whose imaginary part is not known as
*              is the case with the xmu.dat file.
*       iasymt - Check if spectral function read from file uses
*              the same method of calculating the quasiparticle phase.
*       isattype - Indicates what approximations to use for 
*              satellite.
*       isattypt - Check if spectral function read from file uses
*              the same approximation.
*       icut - Set to 0 to avoid cutting off the spectral function at
*              energies where excitations are energetically forbidden
*              in the convolution.
*       nleg - Number of legs in the scattering path, not used for 
*              any calculations.
*       npi - Number of 2 pi jumps in phase.
      integer ipath,nlegs
*       Data from file list.dat.  Only ipath is used.
*       ipath - Path index.
      double precision sig2,ampratio,reff
*       Data from file list.dat.  Not used in this program except 
*       as dummy variables.
      character*80 cfirst,cinp,cblankl
      character*12 cfile(maxfiles)
      character*4 cpath
*       cfirst - Lines from FEFF files.
*       cinp - Lines from so2conv.inp.
*       cblankl - A long line of blanks.
*       cfile - The names of the FEFF files to read.
*       cpath - text containing path index
      character*20 cblanks
*       cblanks - A short line of blanks.
      character*10 vintx,mutx
*       Text containing the interstitial potential and the chemical
*       potential, respectively.
      character*9 gchtx,kftx
*       Text containing the core hole lifetime and the Fermi level,
*       respectively.
      character*5 rstx
*       Text containing the interstitial electron density parameter R_s.
      double precision aangstrom,eV
*       Conversion constants.
      parameter (aangstrom=1.d0/0.52917706d0,eV=1.d0/27.21160d0)
      double precision dw,w,wp,dk,dk2,dp,delta
*       Various energy and momenta and their intervals.
      double precision rs,vint,deg,Rnn,gammach,conc,brpl1,brpl,cmu,
     2                 ckf,rst,gcht,brplt
*       rs - Electron density parameter R_s.
*       vint - Interstitial potential.
*       deg - Path degeneracy, number of identical scattering paths.
*       Rnn - Half length of scattering path.
*       gammach - Core hole lifetime.
*       conc - Electron concentration.
*       brpl1 - plasmon broadening in units of plasma frequency
*       brpl - plasmon broadening
*       cmu - Chemical potential from FEFF file.
*       ckf - Fermi level from FEFF file.
*       rst - Test to see if rs matches old value.
*       gcht - Test to see if gammach matches old value.
*       brplt - Test to see if brpl1 matches old value.
      double precision sef0,se0,se,ce,width,z1,z1i,se2,xise,
     2                 zkk,dsig,xpkg(npts2),seg(npts2),ekpg(npts2),
     3                 sse,sxise
*       sef0 - Self energy at the Fermi level Sigma(E_F,k_F)
*       se0 - Non-self consistent on shell self energy.
*       se - Real part of on shell self energy.
*       ce - Electron gas core hole self energy.
*       width - Quasiparticle lifetime.
*       z1 - Real part of renormalization constant.
*       z1i - Imaginary part of renormalization constant.
*       se2 - Real part of self energy (not neccessarily on shell).
*       xise - Imaginary part of self energy (not neccessarily on shell).
*       zkk - Momentum derivative renormalization constant.
*       dsig - Difference in self energies, to estimate zkk.
*       xpkg - Array of momenta, to estimate zkk.
*       seg - Array of self energies, to estimate zkk.
*       ekpg - Array of energies, to estimate zkk.
*       sse - self energy due to given pole in epsilon^{-1}
      common /energies/ se,ce,width,z1,z1i,se2,xise
      double precision xktest,xktold
*       Used for checking the location of the fermi level in xmu.dat.
      double precision xreduc,xfact1
*       xreduc - Ad hoc overall uniform amplitude reduction.  Obsolete.
*       xfact1 - Dummy variable for storing intermediate calculations.
      double precision pk(npts2),pgrid(nqpts),epts(nsfpts),wpts(npts),
     2                 pthresh
*       pk - Array of momentum values at data points from FEFF files.
*       pgrid - Array of momentum values on minimal momentum grid.
*       epts - Array of energy values on minimal energy grid.
*       wpts - Array of energy variables on uniform energy grid.
*       pthresh - Estimate of momentum threshold for plasmon creation.
      double precision spectf(8,nsfpts),cspec(npts),weights(8)
*       spectf - Spectral function computed on minimal grid.
*       cspec - Spectral function interpolated onto uniform grid.
*       Weights - Spectral weights of the components of the spectral function.
      double precision dphsum,s02sum,xnorm,ww
*       Used in finite element integration for averaging over
*            data points on uniform momentum grid to get output 
*            for momentum points in feffnnnn.dat file.
*       dphsum - Phase shift integration.
*       s02sum - Amplitude reduction integration.
*       xnorm - Normalization.
*       ww - Weighting or importance function.
      double precision chirr,chiii,so2mag,phaseshft,
     2                 phshftold,phrmu,phrmu0,
     3                 xchir,xchii,phchir,phchii,xmu2,xmu02,
     4                 phmu,phmu0,xchi2,phchi,rmu2,rmu02,ximu2
*       chirr - Real part of chi.
*       chiii - Imaginary part of chi.
*       so2mag - Amplitude reduction.
*       phaseshift - Phaseshift.
*       phaseshiftold - Used to check for jumps of 2 pi in phase.
*       xchir - Intermediate real part of chi.
*       xchii - Intermediate imaginary part of chi.
*       phchir - Phase of convolution of real part of chi.
*       phchii - Phase of convolution of imaginary part of chi.
*       xmu2 - Convolution of XANES spectrum with spectral function.
*       xmu02 - Convolution of background with spectral function.
*       xchi2 - Convolution of XAFS signal from xmu.dat.
*       phmu - 'Phase' of XANES spectrum, should be zero, but the 
*           subroutine needs a variable to put it in.
*       phmu0 - 'Phase' of background, should be zero, but the 
*           subroutine needs a variable to put it in.
*       phchi - 'Phase' of XAFS signal, should be zero, but the 
*           subroutine needs a variable to put it in.
      double precision emsf(nqpts,nsfpts),essf(nqpts,nsfpts),
     2                 xmsf(nqpts,nsfpts),xssf(nqpts,nsfpts),
     3                 xissf(nqpts,nsfpts),escsf(nqpts,nsfpts),
     4                 engrid(nqpts,nsfpts),wgts(nqpts,8),
     5                 sfinfo(nqpts,8)
*       emsf - Array of extrinsic quasiparticle spectral function
*            values for file specfunct.dat.
*       essf - Array of extrinsic satellite spectral function
*            values for file specfunct.dat.
*       xmsf - Array of interference quasiparticle spectral function
*            values for file specfunct.dat.
*       xssf - Array of interference satellite spectral function
*            values for file specfunct.dat.
*       xissf - Array of intrinsic satellite spectral function
*            values for file specfunct.dat.
*       essf - Array of clipped extrinsic satellite spectral function
*            values for file specfunct.dat.
*       engrid - Energy grid for spectral function in file specfunct.dat.
*       wgts - Array of spectral weights in file specfunct.dat.
*       sfinfo - Array of miscellaneous information in file specfunct.dat.
      double precision xk(npts2),chi(npts2),xmag(npts2),phase(npts2),
     2                 phm2kr(npts2),epts2(npts2),chir(npts2),
     3                 chii(npts2),e1(npts2),xmu(npts2),xmu0(npts2),
     5                 xk2(npts2),caph(npts2),xmfeff(npts2),
     6                 phfeff(npts2),redfac(npts2),xlam(npts2),
     7                 realck2(npts2),caph2(npts2),xmfeff2(npts2),
     8                 phfeff2(npts2),redfac2(npts2),xlam2(npts2)
      double precision rmu(npts2),rmu0(npts2),ximu(npts2)
*       xk - EXAFS wavenumber from chi.dat or chipnnnn.dat.
*       chi - EXAFS signal from chi.dat or chipnnnn.dat.
*       xmag - Magnitude of chi from chi.dat or chipnnnn.dat.
*       phase - Phase of chi from chi.dat or chipnnnn.dat.
*       phm2kr - PHase Minus 2 K R, phase of chi with dominant 
*           k dependant oscillation removed from chi.dat or chipnnnn.dat.
*       epts2 - Energy from files, measured from edge.
*       chir - Real part of EXAFS signal.
*       chii - Imaginary part of EXAFS signal.
*       e1 - Energy from xmu.dat.
*       xmu - XANES signal from xmu.dat.
*       xmu0 - Embedded atom background signal.
*       xk2 - EXAFS wavenumber from feffnnnn.dat
*       caph - Central atom phase shift interpolated onto uniform 
*           momentum grid.
*       xmfeff - Magnitude of f_(eff) interpolated onto uniform
*           momentum grid.
*       phfeff - Phase of f_(eff) interpolated onto uniform 
*           momentum grid.
*       redfac - Reduction factor on uniform momentum grid.
*       xlam - Mean free path of photoelectron, interpolated
*           onto uniform momentum grid.
*       realck2 - Real part of complex momentum from feffnnnn.dat.
*       caph2 - Central atom phase shift on feffnnnn.dat grid.
*       xmfeff2 - Magnitude of f_(eff) from feffnnnn.dat.
*       phfeff2 - Phase of f_(eff) from feffnnnn.dat.
*       redfac2 - Reduction factor feffnnnn.dat grid
*       xlam2 - Mean free path of photoelectron from feffnnnn.dat.
      double precision s02list(npts2),phlist(npts2)
*       s02list - Array of amplitude reduction values on uniform 
*           momentum grid.
*       phlist - Array of phase shifts on uniform momentum grid.
      double precision emain,esat,xmain,xsat,xisat,sat,eclip,esatr
*       emain - Extrinsic quasiparticle spectral function.
*       esat - Extrinsic satellite spectral function.
*       xmain - Interference quasiparticle spectral function.
*       xsat - Interference satellite spectral function.
*       xisat - Intrinsic spectral function.
*       sat - Total satellite spectral function.
*       eclip - Anomalous extrinsic satellite in region of quasiparticle.
*       esatr - Everything left in the extrinsic satellite after eclip is
*         subtracted off.
      integer npl,nplmax,nplt
      parameter (nplmax=5000)
*       npl - number of poles in epsilon^{-1}
*       nplmax - maximum number of poles in epsilon^{-1} for array dimensioning
      double precision plengy(nplmax),plwt(nplmax),oscstr(nplmax),
     2                 plbrd(nplmax),epswt,
     3                 plengyt(nplmax),plwtt(nplmax),plbrdt(nplmax)
*       plengy - energy of poles in epsilon^{-1}
*       plwt - weight of poles in epsilon^{-1}, such that sum(plwt)=1
*       oscstr - oscilator strength f of resonances epsilon^{-1}
*       plbrd - broadening of poles in epsilon^{-1}
*       epswt - sum of weight of poles, to enforce sum(plwt)=1 {a consequence of
*               int(0,oo) d_omega omega epsilon^{-1}(q,omega)=-(pi/2)*omp}
      logical brpole
*       brpole - true if pole broadening is to be calculated
      double precision pi,ef,fmu,qf,omp,ompl,wt,ekp,ek,qpk,acc,brd,adisp
*       pi - ratio of circumference to diameter of a circle in
*            euclidian geometry
*       ef - Fermi energy
*       fmu - chemical potential = Fermi energy + self consistent
*             on shell self energy at the Fermi level
*       qf - Fermi momentum
*       omp - plasma frequency omega_p
*       ompl - energy of pole in epsilon^{-1}
*       wt - weight of pole in epsilon^{-1}
*       ekp - photoelectron energy = bare kinetic energy + real part of
*             on shell self energy
*       ek - bare photoelectron kinetic energy = pk**2/2
*       qpk - photoelectron momentum
*       acc - global accuracy parameter
*       brd - width of pole in epsilon^(-1)
*       adisp - dispersion parameter for dispersion relation,
*               w(q)**2=omp+adisp*q**2+q**4/4
      common /convsf/ pi,ef,fmu,qf,omp,ompl,wt,ekp,ek,qpk,acc,brd,adisp
*       Common block one is used in most functions and subroutines.
      common /flag/ iwrite,jj
*       Common block flag tells subroutine  mkspectf when to print out
*       interesting information.
      double precision qthresh,beta,exchange
*       Functions which may be called.
      integer lowq,lowqt
*       lowq - Set equal to 0 to avoid calculating self energy from 
*              contributions below Fermi level.  When considering 
*              interference effects, lowq should be set equal to zero.
*              When finding quasiparticle properties, lowq should not
*              be zero.
*       lowqt - Value of lowq from previous run.
      common /belowqf/ lowq
      external qthresh,beta,exchange


      integer elnes,ipmin,ipmax,ipstep  !KJ added these variables 2-06
	character*12 f1,f2  !KJ dummy filenames  2-06
	integer kilast(10) !KJ stupid fix for stupid setup of this program 2-06
	integer ip !KJ local index 2-06
c     elnes : we're in EELS mode if elnes=1
c     ipmin,ipmax,ipstep : range of polarization components to calculate

c  !KJ Next section added to read ELNES variables 2-06     
c     read eels.inp
      elnes=0
      open(file='eels.inp',unit=3,status='old',err=900)
        read(3,*,err=900,end=900) 
        read(3,20,err=900,end=900) elnes
        read(3,*,err=900,end=900)
        read(3,*,err=900,end=900)
        read(3,*,err=900,end=900)
        read(3,20,err=900,end=900) ipmin,ipstep,ipmax
  20  format (20i4)
      close(3)
      goto 901
900   continue
      elnes=0
901   continue
      if(elnes.eq.0) then
        ipstep=1
        ipmax=1
        ipmin=1
      endif
      do i=1,10
      kilast(i)=9
      enddo
      kilast(1)=7
c  !KJ end my changes



c  !KJ big loop for all polarization types 2-06 :
      do ip=ipmin,ipmax,ipstep
      if(ip.eq.1) then
	  f1(1:12)='chi.dat     '
	  f2(1:12)='xmu.dat     '
	elseif(ip.eq.10) then
	  f1(1:12)='chi10.dat   '
	  f2(1:12)='xmu10.dat   '
	elseif(ip.gt.1.and.ip.lt.10) then
	  f1(1:4)='chi0'
	  f1(5:5)= char(48+ip)
	  f1(6:12)='.dat   '
	  f2(1:4)='xmu0'
	  f2(5:5)= char(48+ip)
	  f2(6:12)='.dat   '
	else
	  stop 'crazy ip in ff2xmu'
	endif
c  !KJ end my changes


      isattype=0
      iwrite=0
      iwrite2=0
      iwrconv=0
      iwrcfile=0
      ipw=0
      ipwc=0
*      ipse=0
*      ipsk=0
      lowq=0
      icut=0
      brpole=.true.
*      brpole=.false.
*      wsigk=1.d0
      if (abs(ispec).eq.1) then
        cfile(1)= f2  !KJ 2-06    'xmu.dat     '
        ilast(1)= kilast(ip)  !KJ 2-06     7
        itype(1)=2
        cfile(2)= f1  !KJ 2-06    'chi.dat     '
        ilast(2)=7
        itype(2)=1
        ifiles=2
      elseif (abs(ispec).eq.0) then
c       Josh - Added convolution of xmu.dat for path expansion
        cfile(1)= f2  !KJ 2-06    'xmu.dat     '
        ilast(1)= kilast(ip)  !KJ 2-06   7
        itype(1)=2
c       Josh END
        cfile(2)= f1  !KJ 2-06    'chi.dat     '
        ilast(2)= kilast(ip)  !KJ 2-06   7
        itype(2)=1
        ik=2
        if (ipr6.eq.2.or.ipr6.eq.3) then
          open(unit=1,file='list.dat',status='old',iostat=ios)
          if (ios.gt.0) goto 10
 2        read(1,'(A)') cinp
          if (cinp(6:14).ne.'---------') goto 2
          read(1,'(A)') cinp
 3          read(1,'(A)',end=10) cinp
            ik=ik+1
            lfirst=1
            last=1
 4          if (cinp(lfirst:lfirst).eq.' ') then
              lfirst=lfirst+1
              last=lfirst
              goto 4
            endif
 5          if (cinp(last:last).ne.' ') then
              last=last+1
              goto 5
            endif
            if (last-lfirst.eq.3) then
              cpath='0'//cinp(lfirst:last-1)
            elseif (last-lfirst.eq.2) then
              cpath='00'//cinp(lfirst:last-1)
            elseif (last-lfirst.eq.1) then
              cpath='000'//cinp(lfirst:last-1)
            else
              cpath=cinp(lfirst:last-1)
            endif
*            open(unit=23,file='temp',status='unknown')
*            close(unit=23)
*            open(unit=23,file='temp',status='old')
*            read(23,*) cpath
*            close(unit=23,status='delete')
*            last=4
* 4          if (cpath(last:last).eq.' ') then
*              last=last-1
*              goto 4
*            endif
*            if (last.eq.3) then
*              cpath='0'//cpath(:last)
*            elseif (last.eq.2) then
*              cpath='00'//cpath(:last)
*            elseif (last.eq.1) then
*              cpath='000'//cpath(:last)
*            endif
            if (ipr6.eq.2) then
              cfile(ik+1)='chip'//cpath//'.dat'
              itype(ik+1)=1
            elseif (ipr6.eq.3) then
              cfile(ik+1)='feff'//cpath//'.dat'
              itype(ik+1)=3
            endif
            ilast(ik+1)=12
          goto 3
 10       close(unit=1)
        endif
        ifiles=ik+1
      endif
      do i=1,ifiles
        if (cfile(i).eq.cfname) iwrcfile=i
      enddo

      if (ipsk.ne.0) then
        iwrite=0
        iwrite2=0
      elseif (iwrite.ne.0) then
        iwrite2=0
      endif
        
* Open diagnostic and auxilliary output files.
      if (iwrite.ne.0.or.iwrite2.ne.0.or.ipsk.ne.0) then
        open(unit=12,status='unknown',file='qpsf.dat')
        open(unit=13,status='unknown',file='satsf.dat')
      endif
      if (ipsk.ne.0.or.iwrite.ne.0) 
     2  open(unit=24,status='unknown',file='sigma.dat')
      if (ipwc.ne.0) open(unit=14,status='unknown',file='weightscl.dat')
      if (ipw.ne.0) open(unit=15,status='unknown',file='weights.dat')
      if (ipse.ne.0) 
     2 open(unit=18,status='unknown',file='selfenergy.dat')

      do ikk=1,ifiles
* Open input and output files.
        open(unit=21,status='old',
     2       file=cfile(ikk)(:ilast(ikk)),iostat=ios)
        open(unit=16,status='unknown',
     2       file='mbheader.temp')
*        if (itype(ikk).eq.1) then
*          open(unit=17,status='unknown',
*     2       file=cfile(ikk)(:ilast(ikk)-4)//'so2.dat')
*        endif
        if (ios.gt.0) goto 640

 12     read(21,'(A)') cfirst
        last=80
* Trim off excess white space.
 13     if (cfirst(last:last).eq.' ') then
          last=last-1
          goto 13
        endif
* Josh - Check that convolution has not been done on this file.
        if(cfirst(1:last).eq.'# Convoluted with A(omega).') then
          print '(A)', 'WARNING: '// cfile(ikk) 
          print '(A)', 'has already been convoluted ' //
     2          'in a previous calculation.'
          print '(A)', 'Rerun module 6 if you still '//
     2          'wish to proceed.'
          stop
        end if
* Find physical parameters of the material needed for computation.
        do isearch=1,last-7
          if(cfirst(isearch:isearch+6).eq.'Gam_ch=') then
            gchtx=cfirst(isearch+7:isearch+15)
          elseif(cfirst(isearch:isearch+6).eq.'Rs_int=') then
            rstx=cfirst(isearch+8:isearch+12)
          elseif(cfirst(isearch:isearch+4).eq.'Vint=') then
            vintx=cfirst(isearch+5:isearch+14)
          elseif(cfirst(isearch:isearch+2).eq.'Mu=') then
            mutx=cfirst(isearch+3:isearch+12)
          elseif(cfirst(isearch:isearch+2).eq.'kf=') then
            kftx=cfirst(isearch+3:isearch+11)
          endif
        enddo
* Write header lines.
        if ((iwrite.ne.0.or.iwrite2.ne.0.or.ipsk.ne.0).and.ikk.eq.1) 
     2  then
          write(12,'(A)') cfirst(1:last)
          write(13,'(A)') cfirst(1:last)
        endif
        if (ikk.eq.1.and.(ipsk.ne.0.or.iwrite.ne.0))
     2    write(24,'(A)') cfirst(1:last)
        if (ikk.eq.1.and.ipwc.ne.0) write(14,'(A)') cfirst(1:last)
        if (ikk.eq.1.and.ipw.ne.0) write(15,'(A)') cfirst(1:last)
        write(16,'(A)') cfirst(1:last)
        if (ikk.eq.1.and.ipse.ne.0) write(18,'(A)') cfirst(1:last)
        if (cfirst(6:14).ne.'---------') goto 12
* feffnnnn.dat files have more information lines after the line with
* dashes than the other file types.
        if (itype(ikk).eq.3) then
 14       read(21,'(A)') cfirst
          last=80
 15        if (cfirst(last:last).eq.' ') then
            last=last-1
            goto 15
          endif
* If first character is a number, keep it.  Otherwise it might be a
* comment character, so dump it.
          if (cfirst(1:1).eq.'1'.or.cfirst(1:1).eq.'2'
     2        .or.cfirst(1:1).eq.'3'.or.cfirst(1:1).eq.'4'
     3        .or.cfirst(1:1).eq.'5'.or.cfirst(1:1).eq.'6'
     4        .or.cfirst(1:1).eq.'7'.or.cfirst(1:1).eq.'8'
     5        .or.cfirst(1:1).eq.'9'.or.cfirst(1:1).eq.'0') then
            lfirst=1
          else
            lfirst=2
          endif
* Search for scattering half length, read into variable Rnn
          do isearch=1,last
            if(cfirst(isearch:isearch+3).eq.'reff') then
              open(unit=23,file='temp',status='unknown')
              write(23,*) cfirst(lfirst:last)
              close(unit=23)
              open(unit=23,file='temp',status='old')
              read(23,*) nleg,deg,Rnn
              close(unit=23,status='delete')
              Rnn=Rnn*aangstrom
* @# indicates end of comment lines.
            elseif(cfirst(isearch:isearch+1).eq.'@#') then
              goto 16
            endif
          enddo
          write(16,'(A)') cfirst(1:last)
          goto 14
        else 
          read(21,'(A)') cfirst
        endif
        last=80
 16     if (cfirst(last:last).eq.' ') then
          last=last-1
          goto 16
        endif
* Write column labels.
        if (ikk.eq.1) then
          if (iwrite.ne.0.or.iwrite2.ne.0.or.ipsk.ne.0) then
            write(12,'(A)') '#  omega       delta ext    interf.'   
     2       // '      main ext     sat ext'
            write(13,'(A)') '#  omega       extrinsic    interf.'    
     2       // '      intrinsic    total'
          endif
          if (iwrite.ne.0.or.ipsk.ne.0)
     2    write(24,'(A)') '#   omega      Re(Sigma)    -Im(Sigma)'
          if (ipwc.ne.0)
     2    write(14,'(A)') '#   energy     ext q.p.   inter q.p. ext sat'
     3     // '    inter sat  intrin sat'
          if (ipw.ne.0)
     2    write(15,'(A)') '#   energy     ext q.p.   inter q.p. ext sat'
     3     // '    inter sat  intrin sat'
          if (ipse.ne.0)
     2    write(18,'(A)') '#   energy      Re(Sigma)   -Im(Sigma)'
     3     //'        Re(Z)        Im(Z)'
        endif
        write(16,'(A)') cfirst(1:last)
*        if (itype(ikk).eq.1) then
*          write(17,'(A)') '#     k          So2        phase shift'
*        endif
* Find numerical values of core hole lifetime, Wigner-Seitz radius, 
* interstitial potential, chemical potential, and Fermi momentum.
        open(unit=23,file='temp',status='unknown')
        write(23,*) gchtx
        write(23,*) rstx
        write(23,*) vintx
        write(23,*) mutx
        write(23,*) kftx
        close(unit=23)
        open(unit=23,file='temp',status='old')
        read(23,*) gammach
        read(23,*) rs
        read(23,*) vint
        read(23,*) cmu
        read(23,*) ckf
        close(unit=23,status='delete')
        gammach=(gammach/2.d0)*eV
        cmu=(cmu-vint)*eV
        vint=vint*eV
        ckf=ckf/aangstrom
        xreduc=1.d0
* Compute important material properties and constants.
        pi=dacos(-1.d0)
        qf=((9.d0*pi/4.d0)**(1.d0/3.d0))/rs
        ef=qf*qf/2.d0
        conc=3.d0/(4.d0*pi*(rs**3))
        omp=dsqrt(4.d0*pi*conc)
        adisp=2.d0*ef/3.d0
        ekp=ef
        qpk=qf
        acc=1.d-4

* Read pole expansion for epsilon^{-1}
        call rdeps(omp,nplmax,npl,plengy,oscstr,plbrd)
        epswt=0.d0
        do ipl=1,npl
          plwt(ipl)=dabs(oscstr(ipl)*plengy(ipl)**2/(omp**2))
          epswt=epswt+plwt(ipl)
        enddo
        open (unit=88,file='apl.dat', status='unknown')
        do ipl=1,npl
          write(88,'(5f10.5)') plengy(ipl)/eV,oscstr(ipl)*plengy(ipl)
        enddo
        close (88)

        sef0=0.d0
        do ipl=1,npl
          call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
          if (brpole) then
            call brsigma(0.d0,sse,sxise)
          else 
            call renergies(0.d0,sse)
          endif
          sef0=sef0+sse*wt
        enddo
        sef0=sef0+exchange(qf)

* Estimate threshold for plasmon creation.
        pthresh=qthresh(omp,adisp,ef,qf)
* Find minimal momentum grid.
        do i=1,10
          dp=(pthresh-qf)/10.d0
          pgrid(i)=qf+i*dp
        enddo
        do i=1,30
          dp=0.25d0*pthresh/30.d0
          pgrid(i+10)=pgrid(10)+i*dp
        enddo
        do i=1,10
          dp=0.75d0*pthresh/10.d0
          pgrid(i+40)=pgrid(40)+i*dp
        enddo
        do i=1,10
          dp=2.d0*pthresh/10.d0
          pgrid(i+50)=pgrid(50)+i*dp
        enddo
        pgrid(61)=5.d0*pthresh
        pgrid(62)=7.d0*pthresh
        pgrid(63)=1.d1*pthresh
        pgrid(64)=3.d1*pthresh
        pgrid(65)=1.d2*pthresh
        pgrid(66)=3.d2*pthresh
  
* Read information from files.
        if (itype(ikk).eq.1) then
          iasym=0
          do i=1,npts2
            epts2(i)=0.d0
            xk(i)=0.d0
            pk(i)=0.d0
            chi(i)=0.d0
            xmag(i)=0.d0
            phase(i)=0.d0
            phm2kr(i)=0.d0
          enddo
          xktold=0.d0
          do i=1,npts2
            read(21,*,end=25) xk(i),chi(i),xmag(i),phase(i)
            xk(i)=xk(i)/aangstrom
            chir(i)=xmag(i)*cos(phase(i))
            chii(i)=xmag(i)*sin(phase(i))
            j=i
          enddo
        elseif (itype(ikk).eq.2) then
          iasym=1
          do i=1,npts2
            e1(i)=0.d0
            epts2(i)=0.d0
            xk(i)=0.d0
            pk(i)=0.d0
            xmu(i)=0.d0
            xmu0(i)=0.d0
            chi(i)=0.d0
          enddo
          xktold=0.d0
          do i=1,npts2
            read(21,*,end=25) e1(i),epts2(i),xk(i),xmu(i),xmu0(i),chi(i)
            e1(i)=e1(i)*eV
            epts2(i)=epts2(i)*eV
            xktest=dabs(xk(i))
            if (xktest.lt.xktold) iedge=i
            xktold=xktest
            xk(i)=xk(i)/aangstrom
            j=i
          enddo
          dw=epts2(j)-epts2(j-1)
        elseif (itype(ikk).eq.3) then
          iasym=0
          do i=1,npts2
            epts2(i)=0.d0
            xk(i)=0.05d0*(i-1)/aangstrom
            pk(i)=0.d0
            chi(i)=0.d0
            xmag(i)=0.d0
            phase(i)=0.d0
            phm2kr(i)=0.d0
          enddo
          xktold=0.d0
          do i=1,npts2
            read(21,*,end=17) xk2(i),caph2(i),xmfeff2(i),phfeff2(i),
     2          redfac2(i),xlam2(i),realck2(i)
            xk2(i)=xk2(i)/aangstrom
            xmfeff2(i)=xmfeff2(i)*aangstrom
            xlam2(i)=xlam2(i)*aangstrom
            realck2(i)=realck2(i)/aangstrom
            j=i
          enddo
 17       ifeffct=j
* Interpolate data from feffnnnn.dat grid to the uniform grid used
* in chi.dat.
          do i=1,npts2
            do jj=1,j-1
              if (xk(i).ge.xk2(jj).and.xk(i).lt.xk2(jj+1)) then
                caph(i)=caph2(jj)+(caph2(jj+1)-caph2(jj))
     2                  *(xk(i)-xk2(jj))/(xk2(jj+1)-xk2(jj))
                xmfeff(i)=xmfeff2(jj)+(xmfeff2(jj+1)-xmfeff2(jj))
     2                  *(xk(i)-xk2(jj))/(xk2(jj+1)-xk2(jj))
                phfeff(i)=phfeff2(jj)+(phfeff2(jj+1)-phfeff2(jj))
     2                  *(xk(i)-xk2(jj))/(xk2(jj+1)-xk2(jj))
                redfac(i)=redfac2(jj)+(redfac2(jj+1)-redfac2(jj))
     2                  *(xk(i)-xk2(jj))/(xk2(jj+1)-xk2(jj))
                xlam(i)=xlam2(jj)+(xlam2(jj+1)-xlam2(jj))
     2                  *(xk(i)-xk2(jj))/(xk2(jj+1)-xk2(jj))
                goto 18
              endif
            enddo
            if (xk(i).eq.xk2(jj)) then
              caph(i)=caph2(jj)
              xmfeff(i)=xmfeff2(jj)
              phfeff(i)=phfeff2(jj)
              redfac(i)=redfac2(jj)
              xlam(i)=xlam2(jj)
            endif
* Compute exafs signal Chi from feffnnnn.dat info.
 18         xmag(i)=(deg*xmfeff(i)*redfac(i)*exp(-2.d0*Rnn/xlam(i)))
     2              /(xk(i)*Rnn**2)
            phm2kr(i)=phfeff(i)+caph(i)
            phase(i)=phm2kr(i)+2.d0*xk(i)*Rnn
            chir(i)=xmag(i)*cos(phase(i))
            chii(i)=xmag(i)*sin(phase(i))
          enddo
          xmag(1)=xmag(2)+(xk(1)-xk(2))*(xmag(3)-xmag(2))/(xk(3)-xk(2))
          chir(1)=xmag(1)*cos(phase(1))
          chii(1)=xmag(1)*sin(phase(1))
          j=npts2
        endif
 25     continue

        close(unit=21)
        close(unit=16)
        open(unit=21,status='old',file='mbheader.temp',iostat=ios)
        if (ios.gt.0) goto 640
        open(unit=16,status='unknown',
     2       file=cfile(ikk)(:ilast(ikk)))
*	Josh - added to header so that we can check if a previous convolution
*	has been performed.
        write(16,'(A)') '# Convoluted with A(omega).'
 27       read(21,'(A)',end=35) cfirst
          last=80
 30       if (cfirst(last:last).eq.' ') then
            last=last-1
            goto 30
          endif
          write(16,'(A)') cfirst(1:last)
          goto 27
 35     close(unit=21,status='delete')
          
* Need to find photoelectron momentum.
* First, find kinetic energy.
        do i=1,j
          if (xk(i).ge.0.d0) then
            ekp=xk(i)**2/2.d0+cmu
          else
            ekp=-xk(i)**2/2.d0+cmu
          endif
          ekpg(i)=ekp
          if (itype(ikk).eq.1.or.itype(ikk).eq.3) epts2(i)=ekp
* Make arrays of 0 order self energies and 0 order estimates for momentum.
          if (ekp.ge.0.d0) then
            qpk=sqrt(qf**2+2.d0*(ekp-fmu))
            xpkg(i)=qpk
            se0=0.d0
            do ipl=1,npl
              call plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
              if (brpole) then
                call brsigma(0.d0,sse,sxise)
              else
                call renergies(0.d0,sse)
              endif
              se0=se0+sse*wt
            enddo
            seg(i)=se0+exchange(qpk)
          endif
        enddo
* Estimate momentum derivative renormalization constant.
        do i=1,j
          if (ekpg(i).ge.0) then
            if (i.ne.1.and.i.ne.j) then
              dsig=seg(i+1)-seg(i-1)
              dk2=xpkg(i+1)**2/2.d0-xpkg(i-1)**2/2.d0
            elseif (i.eq.1) then
              dsig=seg(i+1)-seg(i)
              dk2=xpkg(i+1)**2/2.d0-xpkg(i)**2/2.d0
            else
              dsig=seg(i)-seg(i-1)
              dk2=xpkg(i)**2/2.d0-xpkg(i-1)**2/2.d0
            endif
            zkk=1.d0/(1.d0+dsig/dk2)
* Find array of photoelectrom momenta.
            pk(i)=sqrt(xpkg(i)**2-2.d0*zkk*(seg(i)-sef0))
          endif
        enddo
* if running convolution is written, choose momentum point closest to desired energy
        if (iwrcfile.ne.0) then
          den=abs(ekpg(1)-cen)
          iwrconv=1
          do i=2,j
            den2=abs(ekpg(i)-cen)
            if (den2.lt.den) then
              den=den2
              iwrconv=i
            endif
          enddo
        endif
  
* Pad out the ends of the arrays so the convolution does not screw up the
* end data points.
        if (itype(ikk).eq.1.or.itype(ikk).eq.3) then
          dw=epts2(j)-epts2(j-1)
          do i=j+1,npts2
            epts2(i)=epts2(i-1)+dw
          enddo
        elseif (itype(ikk).eq.2) then
          dw=epts2(j)-epts2(j-1)
          do i=j,npts2
            e1(i)=e1(i-1)+dw
            epts2(i)=epts2(i-1)+dw
            xmu0(i)=xmu0(j)
            xmu(i)=xmu0(j)
            chi(i)=0.d0
          enddo
          call mkrmu(xmu,xmu0,rmu,epts2,npts2)
*          call mkrmu(xmu0,xmu0,rmu0,epts2,npts2)
          do i=1,npts2
            ximu(i)=xmu(i)-xmu0(i)
          enddo
        endif

* Find the spectral function and associated data.
        iout=0
* If specfunct.dat does not exist, or if it is for a material with 
* different electron gas properties, set flag 'iout' to recompute 
* spectral function.  Otherwise, read in spectral function.
        open(unit=23,file='specfunct.dat',status='old',
     2       access='sequential',form='unformatted',iostat=ios)
        if (ios.gt.0) then
          iout=1
        else
          read(23) rst,gcht,iasymt,isattypt,lowqt,nplt
          read(23) (plengyt(ii), ii=1,nplmax)
          read(23) (plbrdt(ii), ii=1,nplmax)
          read(23) (plwtt(ii), ii=1,nplmax)
          read(23) ((sfinfo(jj,ii), jj=1,nqpts), ii=1,8)
          read(23) ((wgts(jj,ii), jj=1,nqpts), ii=1,8)
          read(23) ((emsf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
          read(23) ((essf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
          read(23) ((xmsf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
          read(23) ((xssf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
          read(23) ((xissf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
          read(23) ((escsf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
          read(23) ((engrid(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        endif
        close(unit=23)
        if (rst.ne.rs) iout=1
        if (gcht.ne.gammach) iout=1
        if (iasymt.ne.iasym) iout=1
        if (lowqt.ne.lowq) iout=1
        if (isattypt.ne.isattype) iout=1
        if (nplt.ne.npl) iout=1
        do jj=1,npl
          if (plengy(jj).ne.plengyt(jj)) iout=1
          if (plbrd(jj).ne.plbrdt(jj)) iout=1
          if (plwt(jj).ne.plwtt(jj)) iout=1
        enddo
        do jj=1,nqpts
          if (real(sfinfo(jj,1)).ne.real(pgrid(jj))) iout=1
        enddo
        if (iwrite.ne.0.and.ikk.eq.1) iout=1

        npi=0
        if (iout.eq.1) then
          write(6,*) 'computing spectral function'
        endif
        if(ipsk.ne.0.and.ikk.eq.1) then
          jj=0
          call mkspectf(rs,wsigk*qf,gammach,xreduc,
     2                  epts,spectf,weights,isattype,
     3                  npl,nplmax,plengy,plwt,plbrd,brpole)

*          do ipl=1,npl
*            write(6,*) ipl,plengy(ipl),plbrd(ipl),plwt(ipl),
*     2        plengy(ipl)+sef0-se,sef0,se
*          enddo
  
        endif
        do jj=1,nqpts
          if (iout.eq.1) then
* Spectral function has not yet been computed, or was computed for the
* wrong material.  Compute spectral function.
            call mkspectf(rs,pgrid(jj),gammach,xreduc,
     2                    epts,spectf,weights,isattype,
     3                  npl,nplmax,plengy,plwt,plbrd,brpole)
            write(6,'(I3,A10)') int(real(jj)/real(nqpts)*100.0),
     &                '% computed'
            sfinfo(jj,1)=pgrid(jj)
            sfinfo(jj,2)=ekp
            sfinfo(jj,3)=ek
            sfinfo(jj,4)=se
            sfinfo(jj,5)=ce
            sfinfo(jj,6)=width
            sfinfo(jj,7)=z1
            sfinfo(jj,8)=z1i
            do ii=1,8
              wgts(jj,ii)=weights(ii)
            enddo
            do ii=1,nsfpts
              emsf(jj,ii)=spectf(1,ii)
              essf(jj,ii)=spectf(2,ii)
              xmsf(jj,ii)=spectf(3,ii)
              xssf(jj,ii)=spectf(4,ii)
              xissf(jj,ii)=spectf(5,ii)
              escsf(jj,ii)=spectf(8,ii)
              engrid(jj,ii)=epts(ii)
            enddo
          else
* Correct spectral function has already been computed.
            ekp=sfinfo(jj,2)
            ek=sfinfo(jj,3)
            se=sfinfo(jj,4)
            ce=sfinfo(jj,5)
            width=sfinfo(jj,6)
            z1=sfinfo(jj,7)
            z1i=sfinfo(jj,8)
            do ii=1,8
              weights(ii)=wgts(jj,ii)
            enddo
          endif
        enddo
        write(6,*) 'convoluting file '
     2           //cfile(ikk)(:ilast(ikk))
* Interpolate spectral function onto uniform momentum grid.
        do jj=1,j
          do i=1,nqpts-1
            if (pk(jj).ge.pgrid(i).and.pk(jj).lt.pgrid(i+1)) then
              delta=(pk(jj)-pgrid(i))/(pgrid(i+1)-pgrid(i))
              do ii=1,nsfpts
                epts(ii)=engrid(i,ii)
     2               +delta*(engrid(i+1,ii)-engrid(i,ii))
                spectf(1,ii)=emsf(i,ii)+delta*(emsf(i+1,ii)-emsf(i,ii))
                spectf(2,ii)=essf(i,ii)+delta*(essf(i+1,ii)-essf(i,ii))
                spectf(3,ii)=xmsf(i,ii)+delta*(xmsf(i+1,ii)-xmsf(i,ii))
                spectf(4,ii)=xssf(i,ii)+delta*(xssf(i+1,ii)-xssf(i,ii)) 
                spectf(5,ii)=xissf(i,ii)
     2               +delta*(xissf(i+1,ii)-xissf(i,ii))
                spectf(6,ii)=essf(i,ii)+xissf(i,ii)-2.d0*xssf(i,ii)
     2               +delta*(essf(i+1,ii)+xissf(i+1,ii)
     3                     -2.d0*xssf(i+1,ii)
     4                     -(essf(i,ii)+xissf(i,ii)-2.d0*xssf(i,ii)))
                spectf(7,ii)=essf(i,ii)-escsf(i,ii)
     2               +delta*(essf(i+1,ii)-escsf(i+1,ii)
     3                     -(essf(i,ii)-escsf(i,ii)))
                spectf(8,ii)=escsf(i,ii)
     2               +delta*(escsf(i+1,ii)-escsf(i,ii))
              enddo
              do ii=1,8
                weights(ii)=wgts(i,ii)+delta*(wgts(i+1,ii)-wgts(i,ii))
              enddo
              se=sfinfo(i,4)+delta*(sfinfo(i+1,4)-sfinfo(i,4))
              ce=sfinfo(i,5)+delta*(sfinfo(i+1,5)-sfinfo(i,5))
              width=sfinfo(i,6)+delta*(sfinfo(i+1,6)-sfinfo(i,6))
              z1=sfinfo(i,7)+delta*(sfinfo(i+1,7)-sfinfo(i,7))
              z1i=sfinfo(i,8)+delta*(sfinfo(i+1,8)-sfinfo(i,8))
            endif
          enddo
* Take special care with the endpoints.
          if (pk(jj).ge.pgrid(nqpts)) then
            do ii=1,nsfpts
              epts(ii)=engrid(nqpts,ii)
              spectf(1,ii)=emsf(nqpts,ii)
              spectf(2,ii)=essf(nqpts,ii)
              spectf(3,ii)=xmsf(nqpts,ii)
              spectf(4,ii)=xssf(nqpts,ii)
              spectf(5,ii)=xissf(nqpts,ii)
              spectf(6,ii)=essf(nqpts,ii)+xissf(nqpts,ii)
     2                     -2.d0*xssf(nqpts,ii)
              spectf(7,ii)=essf(nqpts,ii)-escsf(nqpts,ii)
              spectf(8,ii)=escsf(nqpts,ii)
            enddo
            do ii=1,8
              weights(ii)=wgts(nqpts,ii)
            enddo
            se=sfinfo(nqpts,4)
            ce=sfinfo(nqpts,5)
            width=sfinfo(nqpts,6)
            z1=sfinfo(nqpts,7)
            z1i=sfinfo(nqpts,8)
          elseif (pk(jj).lt.pgrid(1)) then
            do ii=1,nsfpts
              epts(ii)=engrid(nqpts,ii)
              spectf(1,ii)=emsf(1,ii)
              spectf(2,ii)=essf(1,ii)
              spectf(3,ii)=xmsf(1,ii)
              spectf(4,ii)=xssf(1,ii)
              spectf(5,ii)=xissf(1,ii)
              spectf(6,ii)=essf(1,ii)+xissf(1,ii)-2.d0*xssf(1,ii)
              spectf(7,ii)=essf(1,ii)-escsf(1,ii)
              spectf(8,ii)=escsf(1,ii)
            enddo
            do ii=1,8
              weights(ii)=wgts(1,ii)
            enddo
            se=sfinfo(1,4)
            ce=sfinfo(1,5)
            width=sfinfo(1,6)
            z1=sfinfo(1,7)
            z1i=sfinfo(1,8)
          endif
* Interpolate spectral function onto uniform energy grid.
          call interpsf(npts,epts,wpts,spectf,cspec)
* Write information to diagnostic and supplementary files.
          if (ikk.eq.1.and.ipwc.ne.0) then
            write(14,701) epts2(jj),weights(1)+weights(8),
     2                  weights(3),weights(7),weights(5),weights(6)
          endif
          if (ikk.eq.1.and.ipw.ne.0) then
            write(15,701) epts2(jj),weights(1),weights(3)/2.d0,
     2                  weights(4),weights(5),weights(6)
          endif
          if (ikk.eq.1.and.ipse.ne.0) then
            write(18,500) epts2(jj),se,width,z1,z1i
          endif
          do i=1,nsfpts
            w=epts(i)
            emain=spectf(1,i)
            esat =spectf(2,i)
            xmain=spectf(3,i)
            xsat =spectf(4,i)
            xisat =spectf(5,i)
            sat  =spectf(6,i)
            eclip=spectf(7,i)
            esatr=spectf(8,i)
            if (jj.eq.iwrite2.and.ikk.eq.1) then
              write(12,500) w,emain,xmain,eclip,esatr
              write(13,500) w,esat,-2.d0*xsat,xisat,
     2                      (esat+xisat-2.d0*xsat)
            endif
          enddo
          wp=epts2(jj)
* Begin convolution.
          if (itype(ikk).eq.1.or.itype(ikk).eq.3) then
            if (jj.eq.iwrconv.and.ikk.eq.iwrcfile) then
              intout=1
              open (unit=28,file='realint.dat',status='unknown')
            else
              intout=0
            endif
            call sfconv(wp,cmu,gammach,npts2,epts2,chir,npts,
     2                wpts,cspec,weights,xchir,phchir,iasym,
     3                1,intout,omp)
            if (jj.eq.iwrconv.and.ikk.eq.iwrcfile) then
              intout=1
              open (unit=28,file='imagint.dat',status='unknown')
            else
              intout=0
            endif
            call sfconv(wp,cmu,gammach,npts2,epts2,chii,npts,
     2                wpts,cspec,weights,xchii,phchii,iasym,
     3                1,intout,omp)
* Find real and imaginary many body EXAFS signal chi.
            chirr=xchir*cos(phchir)-xchii*sin(phchii)
            chiii=xchii*cos(phchii)+xchir*sin(phchir)
* Compute phase shift, remove jumps of 2 pi.
            phaseshft=datan2(chiii,chirr)
            if(phaseshft-phshftold.gt.5.d0) then
              npi=npi+2
            elseif(phaseshft-phshftold.lt.-5.d0) then
              npi=npi-2
            endif
            phshftold=phaseshft
            phaseshft=phaseshft-pi*npi
            if (itype(ikk).eq.1) then
* Write output file of many body EXAFS signal.
              write(16,630) xk(jj)*aangstrom,
     2                chiii,dsqrt(chirr**2+chiii**2),
     3                phaseshft,
     4                phaseshft+phm2kr(jj)-phase(jj)
            endif
 630        format (1x, f10.4, 3x, 4(1pe13.6,1x))
* Find amplitude reduction and phase shift.
            so2mag=dsqrt(chirr**2+chiii**2)/xmag(jj)
            phaseshft=datan2(chiii,chirr)
            if(phaseshft-phshftold.gt.5.d0) then
              npi=npi+2
            elseif(phaseshft-phshftold.lt.-5.d0) then
              npi=npi-2
            endif
            phshftold=phaseshft
            phaseshft=phaseshft-pi*npi-phase(jj)
            s02list(jj)=so2mag
            phlist(jj)=phaseshft
*            if (itype(ikk).eq.1) then
** Write output file of amplitude reduction and phase shift.
*              write(17,500) xk(jj)*aangstrom,
*     2                so2mag,phaseshft
*            endif
          elseif (itype(ikk).eq.2) then
* Find many body convolution on absorption signal, embedded atom background,
* and fine structure.
*            call sfconv(wp,cmu+vint,gammach,npts2,epts2,chi,npts,
*     2                wpts,cspec,weights,xchi2,phchi,iasym,1,0,omp)
            if (iasym.eq.0) then
              if (jj.eq.iwrconv) then
                intout=1
                open (unit=28,file='imagint.dat',status='unknown')
              else
                intout=0
              endif
              call sfconv(wp,cmu+vint,gammach,npts2,epts2,ximu,npts,
     2            wpts,cspec,weights,ximu2,phmu,iasym,icut,intout,omp)
              if (jj.eq.iwrconv) then
                intout=1
                open (unit=28,file='realint.dat',status='unknown')
              else
                intout=0
              endif
              call sfconv(wp,cmu+vint,gammach,npts2,epts2,rmu,npts,
     2            wpts,cspec,weights,rmu2,phrmu,iasym,icut,intout,omp)
            else
              if (jj.eq.iwrconv) then
                intout=1
                open (unit=28,file='realint.dat',status='unknown')
              else
                intout=0
              endif
              call sfconv(wp,cmu+vint,gammach,npts2,epts2,xmu,npts,
     2            wpts,cspec,weights,xmu2,phrmu,iasym,icut,intout,omp)
            endif
            if (jj.eq.iwrconv) then
              intout=1
              open (unit=28,file='xmu0int.dat',status='unknown')
            else
              intout=0
            endif
            call sfconv(wp,cmu+vint,gammach,npts2,epts2,xmu0,npts,
     2            wpts,cspec,weights,xmu02,phmu0,iasym,icut,intout,omp)
            if (iasym.eq.0) then
              xmu2=ximu2*cos(phmu)+rmu2*sin(phrmu)+xmu02
            endif
            write(16,800)
     2                e1(jj)/eV,epts2(jj)/eV,xk(jj)*aangstrom,
!     2                xmu2,xmu02,(xmu2-xmu02)/xmu02    !KJ this is the original instruction  3-06
     2                xmu2,xmu02,(xmu2-xmu02)   !KJ removed normalization of chi   3-06  
          endif
        enddo
        if (itype(ikk).eq.3) then
          dk=0.05d0
* Average over nearby points on uniform momentum grid to find
* values for coarser grid in feffnnnn.dat files.  Use a trianguar
* weighting function to ensure each point contributes its full weight
* to the average.
          do jj=1,ifeffct
            s02sum=0.d0
            dphsum=0.d0
            xnorm=0.d0
            do i=1,j
              if (xk2(jj).eq.xk(i)) then
                ww=1.d0
                s02sum=s02sum+s02list(i)*ww*dk
                dphsum=dphsum+phlist(i)*ww*dk
                xnorm=xnorm+ww*dk
              elseif (xk(i).gt.xk2(jj-1).and.xk(i).le.xk2(jj)
     2                .and.xk2(jj-1).ne.xk2(jj)) then
                ww=(xk(i)-xk2(jj-1))/(xk2(jj)-xk2(jj-1))
                s02sum=s02sum+s02list(i)*ww*dk
                dphsum=dphsum+phlist(i)*ww*dk
                xnorm=xnorm+ww*dk
              elseif(xk(i).gt.xk2(jj).and.xk(i).lt.xk2(jj+1)
     2                .and.xk2(jj+1).ne.xk2(jj)) then
                ww=(xk2(jj+1)-xk(i))/(xk2(jj+1)-xk2(jj))
                s02sum=s02sum+s02list(i)*ww*dk
                dphsum=dphsum+phlist(i)*ww*dk
                xnorm=xnorm+ww*dk
              else
                ww=0.d0
              endif
            enddo
* Find many body values of phase and reduction.
            redfac2(jj)=redfac2(jj)*s02sum/xnorm
            caph2(jj)=caph2(jj)+dphsum/xnorm
* Write convoluted feffnnnnc.dat.
            write(16,400) xk2(jj)*aangstrom,caph2(jj),
     2          xmfeff2(jj)/aangstrom,phfeff2(jj),redfac2(jj),
     2          xlam2(jj)/aangstrom,realck2(jj)*aangstrom
  400       format (1x, f6.3, 1x, 3(1pe11.4,1x),1pe10.3,1x,
     1                            2(1pe11.4,1x))
          enddo
        endif
* Write out the spectral function to a data file.
        open(unit=23,file='specfunct.dat',status='unknown',
     2       access='sequential',form='unformatted',iostat=ios)
        write(23) rs,gammach,iasym,isattype,lowq,npl
        write(23) (plengy(ii), ii=1,nplmax)
        write(23) (plbrd(ii), ii=1,nplmax)
        write(23) (plwt(ii), ii=1,nplmax)
        write(23) ((sfinfo(jj,ii), jj=1,nqpts), ii=1,8)
        write(23) ((wgts(jj,ii), jj=1,nqpts), ii=1,8)
        write(23) ((emsf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        write(23) ((essf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        write(23) ((xmsf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        write(23) ((xssf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        write(23) ((xissf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        write(23) ((escsf(jj,ii), jj=1,nqpts), ii=1,nsfpts)
        write(23) ((engrid(jj,ii), jj=1,nqpts), ii=1,nsfpts)
* Do a little housecleaning.
        close(unit=23)
        close(unit=21)
        close(unit=16)
        close(unit=17)
 640    continue
      enddo
 500  format(1x,5(e12.5,1x))
 700  format(1x,7(f10.5,1x))
 701  format(1x,e10.5,1x,6(f10.5,1x))
 800  format(1x,2f11.3,f8.3,1p,3e13.5)
* End of program.


      enddo  !KJ end of loop do ip=ipmin,ipmax,ipstep  2-06


c     sub-program so2conv
c!    stop
      return

      end
      subroutine res02 ( mso2conv, ispec, ipr6, ipse, ipsk, wsigk, cen,
     2                   cfname)

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

        integer  mso2conv, ipse, ipsk, ispec, ipr6
        double precision  wsigk, cen
        character*12 cfname

c     Local stuff
      character*512 slog
      character*80 head(nheadx)
      dimension lhead(nheadx)

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)


c     read s02.inp
      open (file='s02.inp', unit=3, status='old',iostat=ios)
        read (3,10)  slog
        read (3,20)  mso2conv, ipse, ipsk
        read (3,10)  slog
        read (3,30)  wsigk, cen
        read (3,10)  slog
        read (3,20)  ispec, ipr6
        read (3,10)  slog
        read (3,10)  cfname
      close(3)

      return
      end
      subroutine rdeps (omp,nplmax,npl,plengy,oscstr,plbrd)

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      integer  npl,nplmax,ipl
      double precision  plengy(nplmax),oscstr(nplmax),plbrd(nplmax)

c     Local stuff
      character*512 slog
      character*80 head(nheadx),line
      dimension lhead(nheadx)

*     initialize
      do ipl=1,nplmax
        plengy(ipl)=0.d0
        oscstr(ipl)=0.d0
        plbrd(ipl)=0.d0
      enddo

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)

c     read s02.inp
      open (file='exc.dat', unit=3, status='old',iostat=ios)
      if (ios.eq.0) then
        npl=0
 100      read (3,'(a)',end=200)  line
          istart=1
 110      if (line(istart:istart).eq.' ') then
            istart=istart+1
            goto 110
          endif
          if (line(istart:istart).ne.'#') then
            npl=npl+1
            read (line,*) plengy(npl),plbrd(npl),oscstr(npl)
          endif
          goto 100
 200    continue
        do ipl=1,npl
          plengy(ipl)=plengy(ipl)/hart
          plbrd(ipl)=plbrd(ipl)/hart
        enddo
      else
        npl=1
        plengy(1)=omp
        plbrd(1)=0.001d0*omp
        oscstr(1)=1.d0
        open (file='exc.dat', unit=3, status='unknown')
        write(3,30) plengy(1)*hart,plbrd(1)*hart,oscstr(1)
      endif
      close(3)
      


*      write(6,*) '***',npl,'*',plengy(1),'*',plbrd(1),'*',oscstr(1),'***'


      return
      end
      subroutine plset(ipl,nplmax,plengy,plwt,plbrd,ompl,wt,brd)
* Sets calculation parameters for a given pole in epsilon^{-1}
*        ipl - pole to set parameters for
*        nplmax - array dimensioning (maximum number of poles)
*        plengy - energy of poles (array)
*        plwt - weight of poles (array)
*        ompl - energy of selected pole
*        wt - weight of selected pole
*        adisp - dispersion parameter for selected pole
*        conc - electron density that would give plasma frequency
*               equal to pole energy
*        rs - Wigner Seitz radius that would give plasma frequency
*               equal to pole energy
*        ef - Fermi energy that would give plasma frequency
*               equal to pole energy
*        qf - Fermi momentum that would give plasma frequency
*               equal to pole energy
      implicit none
      integer ipl,nplmax
      double precision plengy(nplmax),plwt(nplmax),plbrd(nplmax)
      double precision ompl,wt,brd
*      double precision pi,adisp,conc,rs,ef,qf
      ompl=plengy(ipl)
      wt=plwt(ipl)
      brd=plbrd(ipl)
*      adisp=(0.75d0*pi/ompl**2)**(2.d0/3.d0)/3.d0
*      rs=(3.d0/ompl**2)**(1.d0/3.d0)
*      conc=3.d0/(4.d0*pi*(rs**3))
*      qf=((9.d0*pi/4.d0)**(1.d0/3.d0))/rs
*      ef=qf*qf/2.d0
      return
      end

      subroutine ppset(rs,pi,qf,ef,omp)
* Sets electron gas parameters for a given Wigner-Seitz radius rs.
*        rs - Wigner Seitz radius that would give plasma frequency
*               equal to pole energy
*        omp - plasma frequency
*        ef - Fermi energy that would give plasma frequency
*               equal to pole energy
*        qf - Fermi momentum that would give plasma frequency
*               equal to pole energy
      implicit none
      double precision rs,qf,ef,conc,omp,pi
      qf=((9.d0*pi/4.d0)**(1.d0/3.d0))/rs
      ef=qf*qf/2.d0
      conc=3.d0/(4.d0*pi*(rs**3))
      omp=dsqrt(4.d0*pi*conc)
      return
      end

c///////////////////////////////////////////////////////////////////////
c FEFF PROGRAMS (referred below as a System)
c Copyright (c) 1986-2002, University of Washington.
c 
c END-USER LICENSE 
c 
c A signed End-user License Agreement from the University of Washington
c Office of Technology Transfer is required to use these programs and
c subroutines.
c 
c See the URL: http://leonardo.phys.washington.edu/feff/
c 
c USE RESTRICTIONS:
c 
c 1. The End-user agrees that neither the System, nor any of its
c components shall be used as the basis of a commercial product, and
c that the System shall not be rewritten or otherwise adapted to
c circumvent the need for obtaining additional license rights.
c Components of the System subject to other license agreements are
c excluded from this restriction.
c
c 2. Modification of the System is permitted, e.g., to facilitate
c its performance by the End-user. Use of the System or any of its
c components for any purpose other than that specified in this Agreement
c requires prior approval in writing from the University of Washington.
c
c 3. The license granted hereunder and the licensed System may not be
c assigned, sublicensed, or otherwise transferred by the End-user.  
c
c 4. The End-user shall take reasonable precautions to ensure that
c neither the System nor its components are copied, or transferred out
c side of his/her current academic or government affiliated laboratory
c or disclosed to parties other than the End-user.
c 
c 5. In no event shall the End-user install or provide this System
c on any computer system on which the End-user purchases or sells
c computer-related services.
c 
c 6. Nothing in this agreement shall be construed as conferring rights
c to use in advertising, publicity, or otherwise any trademark or the
c names of the System or the UW.   In published accounts of the use or
c application of FEFF the System should be referred to  by this name,
c with an appropriate literature reference:
c 
c FEFF8: A.L. Ankudinov, B. Ravel, J.J. Rehr, and S.D. Conradson,
c        Phys. Rev. B 58, pp. 7565-7576 (1998).
c
c LIMITATION OF LIABILITY:
c
c 1.   THE UW MAKES NO WARRANTIES , EITHER EXPRESSED OR IMPLIED, AS TO
c THE CONDITION OF THE SYSTEM, ITS MERCHANTABILITY, OR ITS FITNESS FOR
c ANY PARTICULAR PURPOSE.  THE END-USER AGREES TO ACCEPT THE SYSTEM
c 'AS IS' AND IT IS UNDERSTOOD THAT THE UW IS NOT OBLIGATED TO PROVIDE
c MAINTENANCE, IMPROVEMENTS, DEBUGGING OR SUPPORT OF ANY KIND.
c
c 2. THE UW SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL,
c INCIDENTAL OR CONSEQUENTIAL DAMAGES SUFFERED BY THE END-USER OR ANY
c OTHER PARTIES FROM THE USE OF THE SYSTEM.
c
c 3.  The End-user agrees to indemnify the UW for liability resulting
c from the use of the System by End-user. The End-user and the UW each
c agree to hold the other harmless for their own negligence.
c
c TITLE:
c
c 1.  Title patent, copyright and trademark rights to the System are
c retained by the UW. The End-user shall take all reasonable precautions
c to preserve these rights.
c 
c 2.  The UW reserves the right to license or grant any other rights to
c the System to other persons or entities.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c
c     sub-program exchange
!     program  ffmod2
      subroutine ffmod2

c     cross-section and phase shifts calculations
c     coded by a.ankudinov 2000

c     INPUT: mod2.inp geom.dat global.inp and pot.bin
c     OUTPUT: xsect.bin and xsph.bin

      implicit double precision (a-h, o-z)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
      character*6 potlbl
      dimension potlbl(0:nphx)
      dimension lmaxph(0:nphx), iatph(0:nphx), spinph(0:nphx)
      dimension rat(3, natx), iphat(natx)
      complex*16 ptz(-1:1, -1:1)

c     necessary input information from feff.inp file
c     see CARDs description in feff8 manual for more details
c     CONTROL mphase: 1-run (0-don't run)  the program
c     PRINT ipr2: for auxialry output files (default=0)
c     ispec: spectroscopy type (EXAFS, XANES, XES, DANES, FPRIME) 
c     vixan, xkstep, xkmax: energy grid for chosen spectroscopy
c     RDRIG rgrid: radial grid (default=0.05)
c     POTENTIAL info
c       nph: number of unique potentials
c       lmaxph: max orbital momentum for xsph calculations
c       potlbl: labels for unique potentials
c      ATOMS
c       nat: number of atoms
c       rat: their coordinates
c       iphat: type of potential for each site
c       iatph: representative atoms indices in atoms list
c      EXCHANGE ixc  vr0  vi0  ixc0 - exchange correlation model
c      RSIGMA (RPHASES) lreal (default=0)
c      FMS  rfms2 lfms2
       real rfms2
       integer lfms2
c      Global data
c        ipol - polarization type (default:0 - polarization average)
c        ispin - spin type (default=0 - spin independent)
c        le2 - include/exclude quad. transitions (default=2 - include)
c        angks - angle between x-ray propagation and spin (default=0)
c        ptz - polarization tenzor (default=0 for ipol=0)
      integer iPl, iGrid

      call par_begin
      if (worker) go to 400

c     open the log file, unit 11.  See subroutine wlog.
      open (unit=11, file='log2.dat', status='unknown', iostat=ios)
      call chopen (ios, 'log2.dat', 'feff')

c     read  INPUT data files: geom.dat, global.dat and mod2.inp.
c     Josh - added flag iPl for PLASMON card
      call rexsph(mphase, ipr2, ispec, vixan, xkstep,xkmax,gamach,rgrd,
     1             nph, lmaxph, potlbl, spinph, iatph, nat, rat, iphat,
     2             ixc, vr0, vi0, ixc0, lreal, rfms2, lfms2, l2lp,
     3             ipol, ispin, le2, angks, ptz, iPl, iGrid,
     4             izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis)

      if (mphase .eq. 1)  then
         call wlog(' Calculating cross-section and phases...')
         call xsph (ipr2, ispec, vixan, xkstep, xkmax, gamach, rgrd,
     1             nph, lmaxph, potlbl, spinph, iatph, nat, rat, iphat,
     2             ixc, vr0, vi0, ixc0, lreal, rfms2, lfms2, l2lp,
     3             ipol, ispin, le2, angks, ptz, iPl, iGrid,
     4             izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis)

         call wlog(' Done with module 2: cross-section and phases...')
      endif

c     OUTPUT: data for the next modules is written in xsph.bin
c     auxilary output can be obtained using 'ipr2' (see feff8.2 manual)

      close (unit=11)
  400 call par_barrier
      call par_end

c     sub-program exchange
!     stop
      return
      end
      subroutine axafs(em, emu, xsec,ne1,ik0)
c     extract axafs from xsec
c     written by a.l.ankudinov Dec. 1998

c     the file axafs.dat (format as in xmu.dat) will be written if
c     you use PRINT 0 1 0 0 0 0 (ipr2 > 0), and ran the second module.

c     the code draws a parabola using least mean square method
c     through xsec(i) * ee (i)**xn 
c     the weight for each point i, is defined as (ee(i)-E_F)**mm*
c     (ee(i+1)- ee(i-1)), where the last multiplier is used since the 
c     grid is not regular in energy.
c     E_F - energy that corresponds to Fermi level.

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}

      complex*16 em(nex), xsec(nex)
      dimension ee(nex), xmu(nex), wt(nex)
      dimension xx(0:4), yy(0:2), xm(3,3)

c     empirically I found that the best curve is drawn if xn=0 and mm=1
c     alex ankudinov, january 1999.
      xn = 0
      mm = 1
      np = ne1 - ik0
      ef = emu

      do 10 ie = 1, np
        ee(ie) = dble(em(ik0+ie)-em(ik0)) +emu
        xmu(ie) = dimag(xsec(ik0+ie)) * ee(ie)**xn
  10  continue
      do 20 ie = 1, np
        if (ie.eq.1) then
          wt(ie) = (ee(ie+1)-ef) * (abs(ee(ie)-ef))**mm
        elseif (ie.eq.np) then
          wt(ie) = (ee(ie)-ee(ie-1)) * (ee(ie)-ef)**mm
        else
          wt(ie) = (ee(ie+1)-ee(ie-1)) * (ee(ie)-ef)**mm
        endif
  20  continue
      do 30 i = 0, 4
  30  xx(i) = 0
      do 40 i = 0, 2
  40  yy(i) = 0

      do 100 ie = 1, np
         do 80 i = 0,4
  80     xx(i) = xx(i) + wt(ie)*ee(ie)**i
         do 90 i = 0,2
  90     yy(i) = yy(i) + wt(ie)*xmu(ie)*ee(ie)**i
 100  continue

      do 105 i=1,3
      do 105 j=1,3
 105  xm(i,j) = xx(i+j-2)
      denom = determ (xm, 3, 3)

      do 110 i=1,3
      do 110 j=1,3
 110  xm(i,j) = xx(i+j-2)
      do 120 i=1,3
 120  xm(i,1) = yy (i-1)
      aa = determ (xm,3,3)
      aa = aa / denom

      do 210 i=1,3
      do 210 j=1,3
 210  xm(i,j) = xx(i+j-2)
      do 220 i=1,3
 220  xm(i,2) = yy (i-1)
      bb = determ (xm,3,3)
      bb = bb / denom

      do 310 i=1,3
      do 310 j=1,3
 310  xm(i,j) = xx(i+j-2)
      do 320 i=1,3
 320  xm(i,3) = yy (i-1)
      cc = determ (xm,3,3)
      cc = cc / denom

c     find normalization at edge+100 eV
      eee = ee(1) + 100/hart
      xnorm = (aa+bb*eee+cc*eee**2) / eee**xn

      open (unit=1,file='axafs.dat', status='unknown')
      write (1,*) '# File contains AXAFS. See manual for details.'
      write (1,*)
     1 '#--------------------------------------------------------------'
      write(1,*) '#  e, e(wrt edge), k,',
     1           ' mu_at=(1+chi_at)*mu0_at, mu0_at, chi_at @#'
      do 400 ie = 1, np
        xmu(ie) = dimag(xsec(ie+ik0))
        xmu0 = (aa+bb*ee(ie)+cc*ee(ie)**2) / ee(ie)**xn
        chiat = (xmu(ie) - xmu0) / xmu0
        eee = ee(ie) -ef
        if (eee.ge.0.d0) then
           xk = sqrt(2*eee) /bohr
        else
           xk = -sqrt(-2*eee) /bohr
        endif
        write (1, 410) ee(ie)*hart, (ee(ie)-emu)*hart, xk,
     1              xmu(ie)/xnorm, xmu0/xnorm, chiat
 410    format (1x, 2f11.3, f8.3, 1p, 3e13.5)
 400  continue
      close (unit=1)

      return
      end
         

c     Josh - argument iPl has been added to arguments of xsect
      subroutine phase (iph, dx, x0, ri, ne, ne1, ne3, em,
     1                  ixc, nsp, lreal, rmt,rnrm, xmu,
     2                  vi0, iPl, gamach,
     2                  vtot, vvalgs, edens, dmag, edenvl,
     3                  dgcn, dpcn, adgc, adpc, eref, ph, lmax,
     2                  iz, ihole, xion, iunf, xnval, ispin)

      implicit double precision (a-h, o-z)

c     INPUT
c     iph          unique pot index (used for messages only)
c     dx, x0, ri(nr)
c                  Loucks r-grid, ri=exp((i-1)*dx-x0)
c     ne, em(ne)   number of energy points, real energy grid
c     ixc        0  Hedin-Lunqist + const real & imag part
c                  1  Dirac-Hara + const real & imag part
c                  2  ground state + const real & imag part
c                  3  Dirac-Hara + HL imag part + const real & imag part
c                  4, 5, 6, see rdinp or xcpot
c     lreal        1 for real self energy and 2 for real phase shifts 
c     rmt          r muffin tin
c     xmu          fermi level
c     vi0          const imag part to add to complex potential
c     gamach       core hole lifetime
c     vtot(nr)     total potential, including gsxc
c     vvalgs(nr)   overlap Coulomb+gsxc potential for valence electrons
c     edens(nr)    density
c     dmag(nr)     density magnetization
c     edenvl(nr)  valence charge density
c     dgcn(dpcn)   large (small) dirac components for 'iph' atom
c     adgc(adpc)   their development coefficients
c
c     OUTPUT
c     eref(ne)     complex energy reference including energy dep xc
c     ph(nex,ltot+1) complex scattering phase shifts
c     lmax         max l (lmax = kmax*rmt)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}

      complex*16 em(nex)
      dimension  ri(nrptx), vtot(nrptx), edens(nrptx)
      dimension  dmag(nrptx), vvalgs(nrptx), edenvl(nrptx)
      dimension  adgc(10,30), adpc(10,30), xnval(30)
      dimension  dgcn(nrptx,30), dpcn(nrptx,30)
      complex*16  eref(nex)
      complex*16  ph(nex,-ltot:ltot)
      integer ispin

c     work space for xcpot
      dimension   vxcrmu(nrptx), vxcimu(nrptx), gsrel(nrptx)
      dimension   vvxcrm(nrptx), vvxcim(nrptx)
c     p and q were needed in xsect to calc. matrix elements.
      complex*16 p(nrptx), q(nrptx)

      complex*16  p2, ck, xkmtp, xkmt, temp, pu, qu
      complex*16 jl(ltot+2), nl(ltot+2), jlp(ltot+2), nlp(ltot+2)

      complex*16 v(nrptx), vval(nrptx)
      character*512 slog
c     Josh - Added iPl switch for PLASMON card
c          - and WpCorr = Wi/Wp, Gamma, AmpFac
c          - to describe Im[eps^-1]
      integer iPl, ipole
      double precision WpCorr(MxPole), Gamma(MxPole), AmpFac(MxPole),
     &     rnrm
c     Josh END

c{#mn: g77 (and other compilers) have an intrinsic function besjn, 
c      so besjn should be declared  external 
         external besjn
c#mn}
c     zero phase shifts (some may not be set below)
      xkmax = 0
      ne12 = ne - ne3
      do 100  ie = 1, ne
         do 90  il = -ltot, ltot
            ph(ie,il) = 0
   90    continue
         if (ie.le.ne12 .and. xkmax.lt.dble(em(ie))) xkmax= dble(em(ie))
  100 continue
      xkmax = sqrt(xkmax * 2)

c     Use kmax to find accurate l-points
c     limit l, lmax = prefac* kmax * rmt
c     prefac is set not to have warning message for Cu metal for kmax=20
      prefac = 0.7d0
      lmax = prefac * rmt * xkmax
      lmax = max(lmax, 5)
      if (lmax.gt.ltot) then
        ik = nint( ltot / rmt / bohr / prefac )
        write (slog, 110) ik
  110   format('      Phase shift calculation is accurate to k=', i2)
        call wlog(slog)
        write (slog, 120)
  120   format('      See FEFF document to increase the range.')
        call wlog(slog)
      endif
      lmax = min (lmax, ltot)
c     set imt and jri (use general Loucks grid)
c     rmt is between imt and jri (see function ii(r) in file xx.f)
      imt = (log(rmt) + x0) / dx  +  1
      jri = imt+1
      jri1 = jri+1
      if (jri1 .gt. nrptx)  call par_stop('jri .gt. nrptx in phase')

      ifirst = 0
      index = ixc
c     Josh - if PLASMON card is set, and using HL exc,
c          - read pole information from epsinv.dat
      IF( (iPl.gt.0).and.(ixc.eq.0) ) THEN
         open(file='exc.dat', unit=47, status='old',iostat=ios)
         call chopen(ios,'exc.dat','ffmod2(phase)')
         DO ipole = 1, MxPole
            call rdcmt(47,'#*cC')
            read(47,*,END=125) WpCorr(ipole), Gamma(ipole),
     &           AmpFac(ipole)
            Gamma(ipole)  = Gamma(ipole)/hart
            WpCorr(ipole) = (WpCorr(ipole)/hart) /
     &           SQRT(3.d0/((3 / (4*pi*edens(jri+1))) ** third)**3)
         END DO
 125     CONTINUE
         WpCorr(ipole) = -1.d30
         CLOSE(47)
      END IF
      IF(ixc.eq.0) THEN
c     Write wp as calculated from density to sigma.dat
         open(file='mpse.dat', unit=45, status='replace', iostat=ios)
         call chopen(ios, 'sigma.dat', 'ffmod2(phase)')
         write(45,*) '# ', 'rs      wp(eV)'
         write(45,*) '# ', (3 / (4*pi*edens(jri+1))) ** third, 
     &        SQRT(3.d0/((3 / (4*pi*edens(jri+1))) ** third)**3)*hart
         write(45,*) '# mu (eV)'
         write(45,*) '# ', xmu
         write(45,'(a)') 
     &         '# E-EFermi (eV)   Re[Sigma(E)] (eV)   Im[Sigma(E)] (eV)'
     &       // '   Re[Z]   Im[Z]   Mag[Z]   Phase[Z]   Lambda(E) (/A)'
      END IF
c     Josh END
      
c     calculate phase shifts
      do 220 ie = 1, ne12

c        Josh - xcpot now has new arguments:
c             - iPl, WpCorr, Gamma, AmpFac         
         call xcpot (iph, ie, index, lreal, ifirst, jri,
     1               em(ie), xmu,
     2               vtot, vvalgs, edens, dmag, edenvl,
     3               eref(ie), v, vval, iPl, WpCorr, Gamma, AmpFac,
     4               vxcrmu, vxcimu, gsrel, vvxcrm, vvxcim, rnrm)

         if (dble(em(ie)).lt.-10.d0 .or. dble(em(ie)) .gt.3.d2) goto 220
c        p2 is (complex momentum)**2 referenced to energy dep xc
c        notice that constant Im part (gamach/2+vi0) is cancelled,
c        since it is also present in v and vval.
         p2 = em(ie) - eref(ie) 
         if (lreal.gt.1 .and. ie.le.ne1) p2 = dble(p2)
         ck =  sqrt (2*p2+ (p2*alphfs)**2)
         xkmt = rmt * ck
         if (dble(p2).le.0.d0 .and. dimag(p2) .le.0.d0) goto 220

c{#mn  see note above about declaring besjn as external
c#mn}
         call besjn (xkmt, jl, nl)

         if (mod(ixc,10) .lt. 5) then
             ncycle = 0
         else
             ncycle = 3
         endif

         do 210  ll = -lmax, lmax
            il = abs(ll) +  1
c           nonlocal exchange is unstable for high il.
c           need to do integrals instead of diff. eq. fix later
c           use local xc for high il
            if (il*dx.gt.0.50) then
               ncycle=0
            endif

c  v should be V_N+V_COUL+V_XCtotal-V_mt, vval= V_N+V_COUL+V_XCVAL-V_mt
            ikap = ll - 1
            if ( ll.gt.0 ) ikap=ll
            ilp = il + 1
            if (ikap.gt.0) ilp = il - 1
            ic3 = 0

            if(nsp.eq.1 .and. ispin.eq.0) then
c              remove spin-orbit interaction
c              otherwise, get wrong results e.g. for Pt metal
               if (ll.ne.0) ic3 = 1
               ikap = -1 - abs(ll)
               ilp = il + 1
            endif

c_lz  add term (C L_z) (p.32 of Ankoudinov's thesis) 
c     currently just add constant potential only within mt radius
c     keep intersitial level the same
c OPC for U for jj coupling
c           if (ll.eq.3 .and. iph.eq.1) then
c              clz = -0.5d0 / hart
c              if (ispin.lt.0) clz = -clz
c              do 180 i = 1, jri
c                 v(i) = v(i) + clz
c                 vval(i) = vval(i) + clz
c180           continue
c           endif
c OPC for U for LS coupling
            if (abs(ll).eq.3 .and. iph.eq.1 .and. ispin.eq.1) then
               clz = -0.0d0 / hart
               if (ikap.lt.0) clz = -clz
               do 180 i = 1, jri
                  v(i) = v(i) + clz
                  vval(i) = vval(i) + clz
 180           continue
            endif

c           never use irr=0, only positive or negative
            irr = -1
            call dfovrg (ncycle, ikap, rmt, jri, jri, p2, dx,
     1               ri, v,vval, dgcn, dpcn, adgc, adpc,
     1               xnval, pu, qu, p, q,
     1               iz, ihole, xion, iunf, irr, ic3)

c        restore potential for clz=0
c OPC for U for jj coupling
c           if (ll.eq.3 .and. iph.eq.1) then
c OPC for U for LS coupling
            if (abs(ll).eq.3 .and. iph.eq.1 .and. ispin.eq.1) then
               do 190 i = 1, jri
                  v(i) = v(i) - clz
                  vval(i) = vval(i) - clz
 190           continue
            endif
            call phamp (rmt, pu, qu, ck, jl(il), nl(il),
     1                  jl(ilp), nl(ilp), ikap, ph(ie,ll), temp)

c           cut phaseshift calculation if they become too small
            if (abs(ph(ie,ll)) .lt. 1.0e-6 .and. ll.ge.4)  goto 220
c           new cut function introduced by Rivas
            if(abs(exp((0,2)*ph(ie,ll))-1.).lt.1.0e-5) ph(ie,ll)=0
            if (abs(ph(ie,ll)) .lt. 1.0e-5 .and. ll.ge.4)  goto 220

  210    continue
  220 continue
c     Josh - Close sigma.dat
      close(45)
c     Josh END

      do 230 ie = ne12+1, ne
  230 eref(ie) = eref(ne1)

      return
      end
      SUBROUTINE phmesh2 (iprint, ispec, edge, emu, vi0, gamach,
     &     xkmax, xkstep, vixan, ne, ne1, em, ik0, ne3, iGrid)
!     This subroutine makes the energy mesh used for phases and cross sections,
!     as well as for the fms routine, path, and genfmt. For EXAFS, the final output
!     chi is on a different (usually finer) grid with mu0 interpolated.
!     This will reproduce the old (FEFF84) grids, as well as any combination of user
!     defined energy, k, exponential, or arbitrary (read from file) grids. The input
!     for the user defined grids is read from grid.inp. Details of grid.inp are given
!     in rdgrid.f
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

!     Input:
!     iprint - if > 3, print emesh.dat
!     ispec  - controls which grid to use (0=EXAFS,1=XANES,2=XES,3=DANES,4=FPRIME)
!     edge   - This name is misleading and is not the x-ray edge energy.
!              edge = xmu - vr0, where vr0 is given as an the first option in the
!              EXCHANGE card.
!     vi0    - Contant imaginary part added to the potential, second option in the
!              EXCHANGE card.
!     gamach - Core-Hole broadening. Gives an additional constant imaginary part to
!              the potential.
!     xkmax  - maximum k value for EXAFS/XANES calculations. holds emin for f'
!              calculations.
!     xkstep - k-grid spacing for XANES calculations. holds emax for f' calculations
!     vixan  - energy step for FMS calculations (grid is even in energy near edge)
      INTEGER iprint, ispec
      DOUBLE PRECISION edge, emu, vi0, gamach, xkmax, xkstep, vixan
      
!     Output:
!     ne     - Total number of energy points.
!     ne1    - Number of energy points on the horizontal grid.
!     ik0    - point where k=0
!     em(ne) - energy array
      INTEGER ne, ne1, ik0
      COMPLEX*16 em(nex)

!     Local Variables:
!     xloss  - total constant imaginary part of em
!     xim    - energy step near the fermi level
!     deltak - k step
!     emin   - minimum e for exponential grid used by DANES
!     emax   - maximum e for exponential grid used by DANES
!     del    - step for exponential grid
!     ios    - i/o errors
!     nemax  - temp variable to hold max # of energy points
      DOUBLE PRECISION xloss, xim, deltak, emin, emax, del
      INTEGER ios
!     User defined grid variables
!     nGridMax  - max number of grids
!     nGrid     - number of grids.
!     iGridType - Type of grid (1 = energy, 2 = k, 3 = exp)
!     GridMin   - minimum k or E of grid. k for k-grids, e for others
!     GridMax   - Maximum k or E of grid
!     GridStep  - step size.
      INTEGER nGridMax
      PARAMETER(nGridMax=10)
      INTEGER nGrid, iGridType(nGridMax)
      DOUBLE PRECISION GridMin(nGridMax), GridMax(nGridMax),
     &     GridStep(nGridMax)
      
!     Loop Variables:
      INTEGER i1
      DOUBLE PRECISION getxk
      EXTERNAL getxk
!     Initialization
!     Set total imaginary part, must be >= 0.02 eV
      xloss = MAX(gamach/2.d0 + vi0, 0.02/hart)
!     Set energy step to half of imaginary part, or
!     vixan if vixan is set.
      IF(vixan.gt.0.0001) THEN
         xim = vixan
      ELSE
         xim = xloss/2.d0
      END IF

      ik0 = 0
      
      IF(iGrid.eq.0) THEN
!     Use FEFF84 grids
         IF(ispec.eq.0) THEN
            ne = 1
            CALL ExafsGrid84(em, xkmax, ne, nex)
            ne1 = ne
            ik0 = 1
         ELSEIF((ABS(ispec).gt.0).and.(ABS(ispec).lt.4)) THEN
!     Use same grid for XANES, XES, DANES
            CALL XanesGrid84(em, xkmax, xkstep, xim, ne, ik0, nex)            
            ne1 = ne
         ELSEIF(ispec.eq.4) THEN
!     FPRIME
            CALL FPrimeGrid84(em, xkmax, xkstep, vixan, emu, edge, ne,
     &           ne1, ne3, nex)
         END IF
         
!     If ispec is negative, we are not running FMS. Make EXAFS grid
!     for points above the fermi level.
         IF(ispec.lt.0) THEN
            ne = 11
            CALL ExafsGrid84(em, xkmax, ne, nex)
            ne1 = ne
         END IF
      ELSE
!     User defined grids.
         ! Make sure there are enough points left over to make vertical grid etc.
         nemax = nex - 50
         ne = 0
         CALL RdGrid(em,ne,nGrid,iGridType,GridMin,GridMax,GridStep,
     &        nGridMax,nemax)

         DO i1 = 1, nGrid
            IF(iGridType(i1).eq.1) THEN
               ! grid is regular in energy
               ne = ne + 1
               CALL MkEMesh(em, ne, GridMin(i1), GridMax(i1),
     &              GridStep(i1), NPts, nex)
               ne = MIN(ne + NPts, nemax)
            ELSEIF(iGridType(i1).eq.2) THEN
               ! grid is regular in k
               ne = ne + 1
               CALL MkKMesh(em, ne, GridMin(i1), GridMax(i1),
     &              GridStep(i1), NPts, nex)
               ne = MIN(ne + NPts, nemax)
            ELSEIF(iGridType(i1).eq.3) THEN
               ! grid is exponential
               ne = ne + 1
               CALL MkExpMesh(em, ne, GridMin(i1), GridMax(i1),
     &              GridStep(i1), NPts, nex)
               ne = MIN(ne + NPts, nemax)
            END IF
         END DO
         
!        Add a point at E = 0 in case there is not one.
         IF(ne+1.lt.nex) THEN
            em(ne+1) = 0.d0
            ne = ne + 1
         ELSE
            em(ne) = 0.d0
         END IF
!        Now, sort energy grid and remove degenerate points.
         CALL SortE(em,ne,ik0,nex)
         ne1 = ne
      END IF

!     If XES, flip grid about 0.0
      IF(ABS(ispec).eq.2) CALL ReverseGrid(em,ne,0.d0)
         
!     Shift horizontal grid by edge + coni*xloss.
      IF(ispec.ne.4) THEN
         DO i1 = 1, ne
            em(i1) = em(i1) + edge + coni*xloss
         END DO
      END IF

!     If not fprime calculation, make vertical grid
      IF(ispec.ne.4) THEN
         ne = ne + 1
         CALL MkVGrid84(em, ne, xloss, nex)
!     Shift vertical grid by edge.
         DO i1 = ne1+1, ne
            em(i1) = em(i1) + edge
         END DO
      END IF
         
      IF(ABS(ispec).eq.3) THEN
!     DANES: add more points to horizontal grid.
         ne3  = MIN(nex,150) - ne
         emin = DBLE(2*em(ne1)-em(ne1-1))
         emax = 7.d4
         del  = LOG(emax/emin)/(ne3-1)
         ne = ne + 1
         CALL MkExpMesh(em, ne, emin, emax, del, ne3, nex)
         DO i1 = 0, ne3 - 1
            em(ne+i1) = em(ne+i1) + coni*1.d-8
         END DO
         ne = ne + ne3
      END IF      

      IF (iprint .ge. 3)  THEN
         OPEN (unit=44, file='emesh.dat', status='unknown')
         WRITE(44,*) 'edge, bohr, edge*hart ', edge, bohr, edge*hart
         WRITE(44,*) 'ispec, ik0 ', ispec, ik0
         WRITE(44,*) 'ie, em(ie)*hart, xk(ie)'
         DO ie = 1, ne
           WRITE (44,'(i5, 3f20.5)') ie, dble(em(ie))*hart,
     &                   getxk(dble(em(ie))-edge)/bohr
        END DO
         CLOSE(unit=44)
      endif

      RETURN
      END

      SUBROUTINE MkVGrid84(em, ne, xloss, nex)
!     make the vertical grid in energy plane
!     first point is at 0.005 ev, second at 0.01 ev and
!     exponential grid with step 0.4 after that up to 50 eV
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
!     Input:
!     ne    - first energy point
!     nex   - length of em array
!     xloss - total imaginary part of horizontal grid
      INTEGER ne, nex
      DOUBLE PRECISION xloss

!     Output:
!     ne      - number of energy points
!     em(nex) - energy grid
      COMPLEX*16 em(nex)

!     Local Variables:
!     n1     - number of points in exponential grid
!     estep0 - first two points are at estep0/2 and estep0
!     del    - spacing: em(j) = emin*exp(j*del)
!     expdel - exp(del)
!     emin   - minimum energy in exponential grid.
!     emax   - max energy in exponential grid
      INTEGER n1
      DOUBLE PRECISION estep0, del, expdel, emin, emax

!     Loop Variables:
      INTEGER i1

      estep0 = 0.01/hart
      em(ne) = coni*estep0/2
      em(ne+1) = coni*estep0
      ne = ne + 2
!     Exponential grid em(ne+1*j) = emin*exp(j*del)
!     del = 0.6 is ok for Cu K edge, but needs more testing
      del = 0.4d0

!     n1 is the # of points in a grid defined by estep0*exp(j*del) that lie below xloss.
      n1 = NINT(LOG(xloss/estep0)/del - 0.5)
      if (n1.le.0) n1 = 1

!     Now redefine the grid so that xloss is halfway between em(n) and em(n+1) 
!     Solving
!     xloss = [em(n1) + em(n1+1)]/2 = emin*[exp(n1*del) + exp((n1+1)*del)]/2
!     gives
!     emin = 2*xloss/(1+exp(del))*exp(-n1*del)
      expdel = EXP(del)
      emin = 2*xloss /(1+expdel)/expdel**n1
      if (emin.le.estep0) emin = emin*expdel

c     Josh         if (emin.le.estep0 .or. emin.ge.xloss) 
c     Josh     .     call par_stop(' Bad mesh in phmesh')
c     delk = log (xloss/tempk) /(n1+0.5)

!     Now change grid so that endpoint is at emax.
      emax = MIN(50.d0/hart,20.d0*xloss)
      CALL MkExpMesh(em, ne, emin, emax, del, n1, nex)
      DO i1 = 0, n1
         em(ne+i1) = (0,1)*em(ne+i1)
      END DO
      ne = ne + n1

      RETURN
      END
      
      SUBROUTINE MkExpMesh(em, iStart, emin, emax, del, NPts, nex)
      
      INTEGER iStart, nex
      DOUBLE PRECISION emin, emax, del
      COMPLEX*16 em(nex)
      
      INTEGER NPts

      INTEGER i1

      NPts = NINT( log(emax/emin) / del )

!     Fill grid
      DO i1 = 0, NPts
         em(iStart+i1) = emin*exp(del*i1)
      END DO
         
      RETURN
      END


      SUBROUTINE ExafsGrid84(em, xkmax, ne, nex)
!     Make old (FEFF8.4) grid for EXAFS calculations.
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
!     Input: 
!     xkmax - maximum k for grid
!     nex   - length of array em
      INTEGER nex
      DOUBLE PRECISION xkmax

!     Output:
!     em(nex) - energy grid array
!     ne      - number of points in energy grid
      COMPLEX*16 em(nex)
      INTEGER ne

!     Local Variables:
!     NPts   - Number of points that have been added to grid after a call
!              to MkKMesh
!     nemax  - maximum number of energy points (100)
!     deltak - k step (used when calling MkKMesh)
!     xkmin  - minimum (k used when calling MkKMesh)
!     xkmax2 - maximum (k used when calling MkKMesh)
      INTEGER NPts, nemax
      DOUBLE PRECISION deltak, xkmin, xkmax2, eps
      PARAMETER (small = 1.d-20)
      nemax = 100

!     20 pts (0 le k le 1.9, delk=0.1 ang(-1) )
      deltak = bohr/10
      xkmin = 0.d0
      xkmax2  = bohr*1.9d0*1.01d0
      CALL MkKMesh(em, ne, xkmin, xkmax2, deltak, NPts, nex)

!     20 pts (2 le k le 5.8, delk=0.2 ang(-1) )
      ne = ne + NPts + 1
      deltak = bohr/5
      xkmin  = bohr*2.d0
      xkmax2 = bohr*5.8d0*1.01d0
      CALL MkKMesh(em, ne, xkmin, xkmax2, deltak, NPts, nex)

!     9 pts (6 le k le 10., delk=0.5 ang(-1) )
      ne = ne + NPts + 1
      xkmin = bohr*6.d0
      xkmax2 = bohr*10.d0*1.01d0
      deltak = bohr*0.5d0
      CALL MkKMesh(em, ne, xkmin, xkmax2, deltak, NPts, nex)

!     make the rest of the points pts with deltak = 1.0 ang(-1)
      ne = ne + NPts + 1
      deltak = bohr
      xkmin = SQRT(2*DBLE(em(ne-1))) + deltak
!     Fill to end of grid, or max # of points.
      NPts = MIN(nemax-ne,NINT((xkmax-xkmin)/deltak)+1)
      xkmax2 = xkmin + (NPts)*deltak*1.01d0
      CALL MkKMesh(em, ne, xkmin, xkmax2, deltak, NPts, nex)
      ne = ne + NPts

      RETURN
      END

      SUBROUTINE XanesGrid84(em, xkmax, xkstep, estep, ne, ik0, nex)
!     Make old (FEFF8.4) grid for XANES calculations.
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
!     Input: 
!     xkmax  - maximum k for grid
!     xkstep - kstep at high k
!     estep  - estep near the fermi level
!     nex    - length of array em
      INTEGER nex
      DOUBLE PRECISION xkmax, xkstep, estep

!     Output:
!     emin    - -xim*n1
!     em(nex) - energy grid array
!     ik0     - zero point for k grid
      INTEGER ne
      COMPLEX*16 em(nex)

!     Local Variables:
      INTEGER n1, n2, nk, nemax, NPts
      DOUBLE PRECISION emin, emax, xkmin, dk, xkmax2
!     Make 10 points below fermi level
      nemax = 10
!     double k step below fermi level 
      dk = 2*xkstep
!     Not sure why to pick this number of steps regular in e?
      n1 = INT(estep/2/dk**2)
!     n2 is starting point of k grid minus 1 (int(k(emax)/dk) + 1)
      n2 = INT(SQRT(n1*2*estep)/dk)
!     If we can fit one more point in the egrid, do it
      If( (dk*(n2+1))**2 .gt. (n1+1)*2*estep ) n1 = n1+1

!     Make sure we don't use more than nemax points
      n1 = MIN(n1,nemax)
!     nk is number of points in k grid
      nk = nemax - n1

!     Fill k grid
      xkmin = -dk*(n2+nk)
      xkmax2 = -dk*(n2+1)
      ne = 1
      CALL MkKMesh(em, ne, xkmin, xkmax2, dk, nk, nex)  
      
!     Fill e grid
      ne = ne + nk + 1
      emin = -estep*n1
      emax = 0.d0
      CALL MkEMesh(em, ne, emin, emax, estep, NPts, nex)
      ne = ne + NPts + 1
      ik0 = ne
!     Fill grid above the fermi level.
!     Same grid as before except that k spacing is xkstep, and 90 points
      nemax = 90
!     Not sure why to pick this number of steps regular in e?
      n1 = INT(estep/2/xkstep**2)
!     n2 is starting point of k grid minus 1
      n2 = INT(SQRT(n1*2*estep)/xkstep)
      n1 = n1 + 1
!     If we can fit one more point in the egrid, do it
      If( (xkstep*(n2+1))**2 .gt. (n1)*2*xim ) n1 = n1+1
!     Make sure we don't use more than nemax points
      n1 = MIN(n1,nemax)

!     nk is number of points in k grid
      nk = nemax - n1

!     This time fill e grid first
      emin = estep
      emax = (n1-1)*estep
!     If k(emax) > xkmax set emax = e(xkmax) and nk = 0
      IF(SQRT(2*emax).gt.xkmax) THEN
         emax = xkmax**2/2
         nk = 0
      END IF
      CALL MkEMesh(em, ne, emin, emax, estep, NPts, nex)
 
!     Now fill k grid
      ne = ne + NPts + 1
      xkmin = xkstep*(n2+1)
      xkmax2 = xkstep*(n2+nk)
!     if xkmax2 > xkmax, set xkmax2 = xkmax
      IF(xkmax2.gt.xkmax) xkmax2 = xkmax
      CALL MkKMesh(em, ne, xkmin, xkmax2, xkstep, NPts, nex)  
      ne = ne + NPts
      
      RETURN
      END
      
      SUBROUTINE FPrimeGrid84(em,emin,emax,estep,emu,edge,ne,
     &     ne1,ne3,nex)
!     Make old (FEFF84) grid for FPRIME calculation
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c      include '../HEADERS/dim.h'
!     Input:
!     emin  - minimum energy
!     emax  - maximum energy
!     estep - energy step
!     emu   - x-ray edge energy
!     edge  - fermi level (xmu-vr0)
!     nex   - size of em array
      DOUBLE PRECISION emin, emax, estep, emu, edge
      INTEGER nex

!     Output:
!     ne      - total number of points in energy grid
!     ne1     - number of energy points in regular grid
!     em(nex) - energy grid
      INTEGER ne, ne1, ne3
      COMPLEX*16 em(nex)
      
!     Local variables:
!     nemax - maximum number of points in constant energy grid
!     del   - step for exponential grid.
!     
      INTEGER nemax
      DOUBLE PRECISION del, del2, elimit
!     Loop Variables:
      INTEGER i1
!     Initialization
      nemax = 100

      emin  = emin/bohr/hart - emu 
      emax  = emax/bohr/hart - emu

!     Fill a grid from emin to emax taking steps estep.
      em(1) = emin
      ne = 1
      IF(emin.lt.emax) THEN
         IF(estep.le.0.d0) estep = (emax-emin)/(nemax-1)
         ne = MIN(nemax,NINT((emax-emin)/estep))       
         DO i1 = 1, ne
            em(i1) = emin + (i1)*estep
         END DO
      END IF
      ne1 = ne

!     Now fill another grid for the KK-Transform
      nemax = MIN(nex-ne,100)
      del = 3.d0/hart

!     Set elimit = 20*emu, but make sure that 1.d3 .le. elimit .le. 2.d5
      elimit = MAX(1.d3/hart,MIN(20*emu,2.d5/hart))
      elimit = elimit - emu
      
      ne3 = nemax
      em(ne1+1) = edge
      DO i1 = 1, ne3-1
         del2 = 0
         IF(DBLE(em(ne1+i1)).gt.0.d0) del2 = em(ne1+i1)*
     &        (EXP( LOG( elimit/em(ne1+i1) ) / (ne3-i1) ) -1)
         em(ne1+i1+1) = em(ne1+i1) + MAX(del,del2)
      END DO
      ne = ne1 + ne3

      RETURN
      END

      SUBROUTINE ReverseGrid(em,ne,ZeroPoint)
!     Flips a grid about ZeroPoint.
!     Input:
!     em(ne)    - array to flip
!     ne        - number of elements
!     ZeroPoint - point to flip about
      INTEGER ne
      COMPLEX*16 em(ne), eTmp
      DOUBLE PRECISION ZeroPoint

!     Loop Variables
      INTEGER i1, i2, np
      np = ne/2
      DO i1 = 1, ne
         em(i1) = ZeroPoint - em(i1)
      END DO

      DO i1 = 1, np
         eTmp = em(i1)
         em(i1) = em(ne+1-i1)
         em(ne+1-i1) = eTmp
      END DO            
      
      RETURN
      END

      SUBROUTINE MkEMesh(em, iStart, emin, emax, estep, NPts, nex)
!     Make a grid even in k-space from xkmin to xkmax with grid spacing
!     deltak. If xkmin > xkmax, do nothing
      IMPLICIT NONE
!     Input
!     em(nex) - energy grid
!     iStart  - index of em to start at.
!     emin    - starting k
!     emax    - ending k
!     estep   - k spacing
!     nex     - lenth of em array
      INTEGER iStart, nex
      COMPLEX*16 em(nex)
      DOUBLE PRECISION estep, emin, emax

!     Output:
!     NPts    - index of the last point added to the energy grid.
      INTEGER NPts

!     Loop variables
      INTEGER i1

      NPts = NINT((emax - emin)/estep) 
      IF(NPts.le.0) THEN
         NPts = 0
         RETURN
      END IF
      DO i1=0, NPts
         IF(i1.le.nex) THEN 
            em(iStart + i1) = emin + estep*i1
         ELSE
c            CALL wlog('Energy grid is too large: truncating.')
            EXIT
         END IF
      END DO

      RETURN
      END

      
      SUBROUTINE MkKMesh(em, iStart, xkmin, xkmax, deltak, NPts, nex)
!     Make a grid even in k-space from xkmin to xkmax with grid spacing
!     deltak.
      IMPLICIT NONE
!     Input
!     em(nex) - energy grid
!     iStart  - index of em to start at.
!     xkmin   - starting k
!     xkmax   - ending k
!     deltak  - k spacing
!     nex     - lenth of em array
      INTEGER iStart, nex
      COMPLEX*16 em(nex)
      DOUBLE PRECISION deltak, xkmin, xkmax

!     Output:
!     NPts    - index of the last point added to energy grid.
      INTEGER NPts

!     Loop variables
      INTEGER i1, isgn

      NPts = NINT((xkmax - xkmin)/deltak) 
      IF(NPts.le.0) THEN
         NPts = 0
         RETURN
      END IF
      isgn = 1
      IF(xkmin.lt.0.d0) isgn = -1
      DO i1=0, NPts
         IF(i1.le.nex) THEN 
            em(iStart + i1) = isgn*(xkmin + deltak*(i1))**2/2
         ELSE
c            CALL wlog('Energy grid is too large: truncating.')
            EXIT
         END IF
      END DO

      RETURN
      END
 

      SUBROUTINE WrtE(em, ne, fl)
!     WrtE made for debugging.
      INTEGER ne, iU
      COMPLEX*16 em(ne)
      CHARACTER*(*) fl
      CHARACTER(300) fl2
      INTEGER i1

      fl2 = 'DEBUG/' // fl
      iU = 23
      OPEN(unit=iU,file=fl2,status='replace')
      DO i1 = 1, ne
         WRITE(iU,*) i1, em(i1)
      END DO
      CLOSE(iU)

      RETURN
      END

      SUBROUTINE SortE(em,ne,ik0,nex)
!     Sorts energy array em, eliminating degenerate points.
!     Also, set ik0.
!     Input:
!     ne     - number of energy points
!     em(ne) - energy grid
      INTEGER ne
      COMPLEX*16 em(ne)

!     Output: sorted array of energies, and number of unique energy points.
!     Also ik0
      INTEGER ik0

!     Local Variables:
!     RealE(nex)  - Re[em]
!     iOrder(nex) - Holds ordering for em.
!     nUE         - number of unique energy points
!     tol         - tolerence for degeneracy of energy points (in eV)
      DOUBLE PRECISION RealE(nex), E0, tol
      INTEGER iOrder(nex), nUE
      
!     Loop Variables:
      INTEGER i1, i2
      
      PARAMETER(tol = 0.001d0)
      ik0 = -1
      
      DO i1 = 1, ne
         RealE(i1) = DBLE(em(i1))
      END DO

!     Do sorting of RealE.
      CALL qsorti(iOrder,ne,RealE)
      
!     Replace em with sorted values and remove degeneracy.
      nUE   = 1
      IF((ABS(RealE(iOrder(1))).lt.tol)) THEN
         em(1) = 0.d0
         ik0 = 1
      ELSE
         em(1) = RealE(iOrder(1))
      END IF

!     Remove degenerate points
      DO i1 = 2, ne
         
!        find next point that is not degenerate and set next em to the
!        value of the non-degenerate point.
         DO i2 = i1, ne
            PRINT*, ABS(RealE(iOrder(i2))-DBLE(em(i1-1)))
            IF(ABS(RealE(iOrder(i2))-DBLE(em(i1-1))).gt.tol) THEN
               nUE = nUE + 1
               em(nUE) = RealE(iOrder(i2))
               EXIT
            END IF
         END DO
      END DO
      PRINT*, nUE, ne      
      ne = nUE
      
!     Set ik0
      ik0 = 1
      E0 = ABS(DBLE(em(1)))
      DO i1 = 1, nUE
         IF(ABS(DBLE(em(i1))).lt.E0) THEN
            PRINT*, em(i1), E0
            E0 = ABS(DBLE(em(i1)))
            ik0 = i1
         END IF
      END DO
      PRINT*, ik0
      em(ik0) = 0.d0
      
      RETURN
      END
c     make e mesh for phase
c     input:  iprint, ispec, edge, vi0, gamach, xkmax, xkstep
c     output: ne, ne1, em(ne), ik0 [grid point with k=0]
c             ne -  total number of points in array em
c             ne1 - number of points on horizontal grid 

      subroutine phmesh (iprint, ispec, edge, emu, vi0, gamach, ecv,
     1                  xkmax, xkstep, vixan, ne, ne1, em, ik0, ne3)
      implicit double precision (a-h, o-z)
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      complex*16 em(nex), tempc

c     see arrays.h
c#mn
      external getxk

c     nemax - max number of points on horizontal axis
      xloss = gamach/2 + vi0
      if (xloss.lt.0) xloss = 0
      xvert = max(xloss, 0.02/hart)
      xloss = xvert
      aa = 0.5d0
      ne3 = 0
      xim = xloss*aa
      if (vixan.gt.0.0001) xim = vixan
      ik0 = 0

      if (ispec.le.3)  then
c        make energy mesh for XANES with FMS
c        around fermi level step is regular in energy (xloss/2)
c        and regular in k at high energies

c        10 points below Fermi level
         nemax = 10
c        dk = 0.14*bohr
         dk = 2*xkstep
         n1 = int (xim/2/dk**2)         
         n2 = int ( sqrt(n1*2*xim) / dk )
         if ( (dk*(n2+1))**2 .gt. (n1+1)*2*xim ) n1 = n1+1
         n1 = min (n1,nemax)
         do 10 i = 1, n1
  10     em(nemax+1-i) = -xim*i + edge + coni*xloss
         nb = nemax-n1
         do 20 i = 1, nb
  20     em(nb + 1 -i) = -(dk*(n2+i))**2/2 + edge + coni*xloss
         nmin = nemax
         ik0 = nemax+1
      endif

      if (ispec .gt. 0 .and. ispec.le.3)  then
c        make energy mesh for XANES with FMS
c        around fermi level step is regular in energy (xloss/2)
c        and regular in k at high energies
c        90 points above Fermi level
         nemax = 100 - nemax 
         n1 = int (xim/2/xkstep**2)
         n2 = int ( sqrt(n1*2*xim) / xkstep )
         n1 = n1 + 1
         if ( (xkstep*(n2+1))**2 .gt. n1*2*xim ) n1 = n1+1
         n1 = min (n1,nemax)
         if (ispec.ne.2) then
            nb = int (xkmax**2 /xim/2) + 1
         else
            nb = int (abs(edge - xkmax/bohr/hart) /xim) + 1
         endif
         if (nb .le. n1) n1 = nb
         do 30 i = 1, n1
  30     em(nmin+i) = xim*(i-1)
         if (ispec.ne.2) then
            nb = int( xkmax / xkstep)  - n2
         else
            nb = int( sqrt(abs(2*(edge-xkmax/bohr/hart))) / xkstep) - n2
         endif
         nb = min(nb, nemax-n1)
         nb = max(nb,0)
         do 40 i = 1, nb
  40     em(nmin+n1+i) = (xkstep*(n2+i))**2 /2
         ne1 = nmin+n1+nb
         do 50 i = ik0, ne1
  50     em(i) = em(i) + edge + coni*xloss

      elseif (ispec.eq.4) then
c        grid for atomic f' calculation regular in energy
         nemax = 100
         emin = xkmax / bohr /hart
         emax = xkstep / bohr / hart
         ne = 1
         emin = emin - emu + edge
         emax  = emax - emu + edge
         em(1) = emin
         if (emin .lt. emax) then
            if (vixan.le.0.d0) vixan = (emax-emin) / (nemax-1)

  85        ne = ne + 1
            em(ne) = em(ne-1) + vixan
            if ( ne.lt.nemax .and. dble(em(ne)).lt.emax) goto 85
         endif

         ne1 = ne
         nemax = nex-ne
         if (nemax.gt.100) nemax=100
         de = 3.d0 /hart
         elimit = min (2.0d5/hart, 20*emu)
         elimit = max (elimit, 1.0d3/hart)
         elimit = elimit - emu

         ne2 = 0
         ne3 = nemax
         ne = ne1+ne2+ne3
         em(ne1+1) = edge
         do 88 i = 1,ne3-1
            dep = 0
            if (dble(em(ne1+i)).gt.0) 
     1      dep=em(ne1+i)*(exp( log( elimit/em(ne1+i) ) / (ne3-i) ) -1)
            if (dep.lt.de) dep = de
            em(ne1+i+1) = em(ne1+i) + dep
  88     continue
      else
c        energy mesh for EXAFS or XANES without FMS
c        20 pts (0 le k le 1.9, delk=0.1 ang(-1) )
c        20 pts (2 le k le 5.8, delk=0.2 ang(-1) )
c         9 pts (6 le k le 10., delk=0.5 ang(-1) )
c        10 pts (11 le k le 20.0, delk=1.0 ang(-1) )
         ne = 0
         if (ispec.lt.0) ne = 10
         nemax = 100
         delk = bohr/10
         do 111 i=1,20
            tempk=(i-1)*delk
            ne = ne+1
            em(ne)=tempk**2/2 +edge + coni*xloss
            if (i.eq.1)  ik0 = ne
  111    continue
         delk = bohr/5
         n2 = 20
         do 112 i=1,n2
            tempk=2*bohr + (i-1)*delk
            ne = ne+1
            em(ne)=tempk**2/2 +edge + coni*xloss
  112    continue
         delk = bohr/2
         do 113 i=1,9
            tempk=6*bohr + (i-1)*delk
            ne = ne+1
            em(ne)=tempk**2/2 +edge + coni*xloss
  113    continue
         delk=bohr
         do 114 i=1,10
            tempk=11*bohr + (i-1)*delk
            ne = ne+1
            em(ne)=tempk**2/2 +edge + coni*xloss
  114    continue

c        while loop
  115    if (tempk. lt.xkmax) then
            tempk = tempk + delk
            ne = ne+1
            em(ne)=tempk**2/2 +edge + coni*xloss
            goto 115
         endif

         ne = min (ne, nemax)
         ne1 = ne
      endif

      if (ispec.le.3)  then
c        make the vertical grid in energy plane
c        first point is at 0.005 ev, second at 0.01 ev and
c        exponential grid with step 0.4 after that up to 50 eV
         tempk = 0.005d0/hart
         em(ne1+1) = edge + coni*tempk
         tempk = tempk*2
         em(ne1+2) = edge + coni*tempk
c        chose delk that point edge+coni*xloss is in the middle of step
c        delk = 0.6 is ok for Cu K edge, but needs more testing
         delk = 0.4d0
         n1 = nint ( log(xloss/tempk)/delk - 0.5d0)
         if (n1.le.0) n1 = 1
         bb = exp(delk)
         aa = 2*xloss /(1+bb)
         aa = aa/bb**n1
         if (aa.le. tempk) aa = aa*bb
cJosh         if (aa.le.tempk .or. aa.ge. xloss) 
cJosh     .     call par_stop(' Bad mesh in phmesh')
c        delk = log (xloss/tempk) /(n1+0.5)
c        n1 = nint( log(1000/hart/tempk) / delk )
c        n1 = nint( log(50/hart/aa) / delk )
         ee = min(50.d0/hart,20.d0*xloss)
         print*, ee, aa, xloss, n1
         n1 = nint( log(ee/aa) / delk )
         do 60 i = 0, n1
  60     em(ne1+3+i) = edge +coni*aa*exp(delk*i)
         ne = ne1 + n1 + 3

c        for DANES need additional points
         if (abs(ispec).eq.3) then
            ne3 = min(nex,150) - ne
            em(ne+1) = dble(2*em(ne1)-em(ne1-1))
            dk = log(7.d4/dble(em(ne+1))) / (ne3-1)
            dk = exp(dk)
            do 80 i = 1, ne3-1
  80        em(ne+i+1)= em(ne+i)*dk
            do 90 i = 1, ne3
  90        em(ne+i)= em(ne+i)+coni*1.d-8
            ne = ne + ne3
            
         endif
      endif

c     need to reverse order for horizontal grid for XES
      if (ispec.eq.2) then
         do 150 ie = 1, ne1
  150    em(ie) = 2*(edge + coni*xloss) - em(ie)
         np = ne1 / 2
         do 160 ie=1,np
            ip = ne1+1-ie
            tempc = em(ie)
            em(ie) = em(ip)
            em(ip) = tempc
  160    continue
         ik0 = ne1+1-ik0
      endif

      if (iprint .ge. 3)  then
         open (unit=44, file='emesh.dat', status='unknown')
         write(44,*) 'edge, bohr, edge*hart ', edge, bohr, edge*hart
         write(44,*) 'ispec, ik0 ', ispec, ik0
         write(44,*) 'ie, em(ie)*hart, xk(ie)'
         do 230  ie = 1, ne
           write(44,220) ie, dble(em(ie))*hart,
     1                   getxk(dble(em(ie))-edge)/bohr
  220      format (i5, 3f20.5)
  230    continue
         close (unit=44)
      endif

      return
      end
      subroutine radint (ifl, mult, bf, kinit, dgc0, dpc0, ikap, p, q,
     1   pn, qn, ri, dx, ilast, iold, xrc, xnc, xrcold, xncold, xirf)
c     performs radial integration for multipole matrix element
c     or central atom absorption depending on flag 'ifl'.
      implicit double precision (a-h, o-z)

c     INPUT
c     ifl - number corresponds to the calling order in xsect.f
c         - 1 - calculate matrix element (rkk)
c         - -1 - calculate matrix element (rkk) in nonrelativistic limit
c         - 2 - calculate cross section (xsec)
c             cross term needed for spin-dependent potential only
c         - 3 - cross term (xsec) with irregular part for current kappa
c         - 4 - cross term (xsec) with regular part for current kappa
c     mult - specifies multipole transition
c     bf - bessel functions for x-ray k-vector for l=0,1,2
c     kinit - initial kappa
c     dgc0,dpc0 - large (small) dirac components for initial orbital 
c     ikap  = final state kappa
c     p,q   Dirac components for regular (R) final state solution
c     pn,qn  Dirac components for irregular(N) final state solution
c     ri,dx - radial grid
c     ilast - last integration point
c     iold  - 0 - do nothing to xrcold, xncold (ic3=0 case)
c             1 - store intermediate results in xrcold, xncold (ic3=1)
c             2 - use intermediate results in xrcold, xncold (ic3=1)
c
c     OUTPUT
c     xrcold,xncold - coupling to regular (R) and irregular(N) solutions
c                     both output and input
c     xirf  - value of the radial integral

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      dimension ri(nrptx), dgc0(nrptx), dpc0(nrptx)
      dimension bf(0:2, nrptx)
      complex*16 p(nrptx), q(nrptx), pn(nrptx), qn(nrptx)
c     storage for calculation of cross term (SPIN 1 only)
      complex*16 xrcold(nrptx) , xncold(nrptx)
      complex*16  xirf, temp

c     local staff
      complex*16  xm(4)
      complex*16 xrc(nrptx), xnc(nrptx)
      complex*16 coni
      parameter (coni = (0.d0, 1.d0))

      linit = kinit
      if (kinit.lt.0) linit = - kinit - 1
      lfin = ikap
      if (ikap.lt.0) lfin = - ikap - 1
c     set multipliers  from Grant,Advan.Phys.,v.19,747(1970) eq. 6.30,
c     using Messiah's "Q.M." appendices to calculate 9j,3j symbols
      if (ifl.lt.0) then
        ji2 = 2*abs(kinit)-1
        jf2 = 2*abs(ikap)-1
        if (mult.eq.0 .or. mult.eq.2) then
           ll = 1
           if (mult.eq.2) ll = 2
           ll2 = 2*ll
           temp = sqrt(dble((ji2+1)*(jf2+1))) *cwig3j(jf2,ll2,ji2,1,0,2)
c          sign of temp is (-)**(j+1/2): compare eq. 6.2 and 6.30 
c          of Grant, Adv. Phys. 19, 747 (1970).
           temp = temp * (-1)**(abs(ikap))
           ls = ll-1
           xm(1) = temp * (ll2+1) *coni**ls *(2*ls+1) *
     1     cwig3j(ls,1,ll,0,0,1) * cwig3j(ls,1,ll,0,1,1)
           ls = ll+1
           xm(3) = 0
c          xm(3) = temp * (ll2+1) *coni**ls *(2*ls+1) *
c    1     cwig3j(ls,1,ll,0,0,1) * cwig3j(ls,1,ll,0,1,1)
        else
c          if (mult.eq.1) then
           stop 'not set up for M1 transition in nonrelativistic limit'
        endif
      elseif (mult.eq.0) then
        call xmult( ikap, kinit, 0, 1, xm(1), xm(2))
        call xmult( ikap, kinit, 2, 1, xm(3), xm(4))
      else
        xm(3) = 0
        xm(4) = 0
        if (mult.eq.2) then
          call xmult( ikap, kinit, 1, 2, xm(1), xm(2))
        else
c         mult=1 - M1 transition
          call xmult( ikap, kinit, 1, 1, xm(1), xm(2))
        endif
      endif

c     radial integrals depending on case
      ia = abs(ifl)
      is = ifl /ia
      if (ia.eq.1) then
c       single radial integral for rkk - reduced matrix elements
c       xirf = <f |p| i> relativistic version of dipole m.e.
        do 10  i = 1, ilast
          xnc(i) = 0.0d0
          if (is.gt.0) then
           call xrci(mult,xm,dgc0(i),dpc0(i),p(i),q(i),bf(0,i),xrc(i))
          else
c          nonrelativistic case 
           if (mult.eq.0) then
             temp = xm(1)*bf(0,i)+ xm(3)*bf(2,i)
           elseif (mult.eq.2) then
             temp = xm(1)*bf(1,i)
           endif
           temp = temp *coni
           xrc(i) = ri(i) * (dgc0(i)*p(i) + dpc0(i)*q(i)) *temp
c          xrc(i) = ri(i) * (dgc0(i)*p(i) ) *temp
          endif

c         store xrc if needed
          if (iold.eq.1) xrcold(i) = xrc(i)
  10    continue
        xirf=lfin+linit+2
        if (mult.gt.0) xirf = xirf + 1
        call csomm (ri, xrc, xnc, dx, xirf, 0, ilast)
      else
c       need to perform double radial integral in all cases below
        if (ia.eq.2) then
c         combine regular(kdif) and irregular(kdif) solution into
c         the central atom absorption coefficient xsec (mu = dimag(xsec))
c         thus for real energy dimag(xsec)=xsnorm
          do 20  i = 1, ilast
           if (is.gt.0) then
           call xrci(mult,xm,dgc0(i),dpc0(i),pn(i),qn(i),bf(0,i),xnc(i))
           call xrci(mult,xm,dgc0(i),dpc0(i),p(i),q(i),bf(0,i),xrc(i))
           else
c            nonrelativistic case 
             if (mult.eq.0) then
               temp = xm(1)*bf(0,i)+ xm(3)*bf(2,i)
             elseif (mult.eq.2) then
               temp = xm(1)*bf(1,i)
             endif
             temp = temp*coni
             xrc(i) = ri(i) * (dgc0(i)*p(i) + dpc0(i)*q(i)) *temp
             xnc(i) = ri(i) * (dgc0(i)*pn(i) + dpc0(i)*qn(i)) *temp
c            xrc(i) = ri(i) * (dgc0(i)*p(i) ) *temp
c            xnc(i) = ri(i) * (dgc0(i)*pn(i) ) *temp
           endif
c           store irregular contribution for later use
            if (iold.eq.1) xncold(i) = xnc(i)
  20      continue
        elseif (ifl.eq.3 .and. iold.eq.2) then
c         combine regular(k1) and irregular (kdif) solutions into the
c         central atom absorption coefficient xsec (mu = dimag(xsec))
c         nonzero only for |ispin=1| and same angular momenta in k1,kdif
          do 30  i = 1, ilast
            xrc(i)= xrcold(i)
           call xrci(mult,xm,dgc0(i),dpc0(i),pn(i),qn(i),bf(0,i),xnc(i))
  30      continue
        elseif(ifl.eq.4 .and. iold.eq.2) then
c         combine regular(kdif) and irregular (k1) solutions into the
c         central atom absorption coefficient xsec (mu = dimag(xsec))
c         nonzero only for |ispin=1| and same angular momenta in k1,kdif
          do 40  i = 1, ilast
            call xrci( mult,xm,dgc0(i),dpc0(i),p(i),q(i),bf(0,i),xrc(i))
            xnc(i) = xncold(i)
  40      continue
        endif

c       same staff for all double integrals
        if ((iold.eq.0.and.ia.eq.2) .or. (ifl.gt.2.and.iold.eq.2)) then
c          do radial integration for r'>r first
c          power of xrc near zero
           lpwr = lfin + linit +2
c          factor 2 since integral(r<r')=integral(r>r')
           xirf = 2 * xrc(1) * ri(1) /(lpwr+1)
           xnc(1) = xnc(1) * xirf
           do 70 i = 2, ilast
             xirf = xirf + (xrc(i-1)+xrc(i)) * (ri(i)-ri(i-1))
             xnc(i) = xnc(i) * xirf
  70       continue
           do 80 i = 1,ilast
  80       xrc(i) = 0
           xirf = lpwr+1+linit+1-lfin
c          ready for second integral over r from 0 to \infty
           call csomm (ri, xrc, xnc, dx, xirf, 0, ilast)
        endif
      endif

      return
      end

      subroutine xrci( mult, xm, dgc0, dpc0, p, q, bf, value)
c     r-dependent multipole matrix element (before r-integration)
      implicit double precision (a-h, o-z)
      complex*16 xm(4), p, q, value
      dimension bf(0:2)

      if (mult.eq.0) then
c       el. dipole transition with both j0 and j2 contributions
        value = dgc0*q* (xm(2)*bf(0) + xm(4)*bf(2)) +
     1         dpc0*p* (xm(1)*bf(0) + xm(3)*bf(2))
       else
         value = (xm(2)*dgc0*q+xm(1)*dpc0*p) * bf(1)
       endif

      return
      end
      subroutine wphase (nph, em, eref, lmax, ne, ph, ntitle, title)

c     Writes phase data to file PHASExx.DAT for each shell

      implicit double precision (a-h, o-z)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      complex*16 eref(nex, nspx)
      complex*16 ph( nex, -ltot:ltot, nspx, 0:nphx)
      complex*16  em(nex)
      dimension lmax(0:nphx)
      character*30  fname
      character*80  title(ntitle)
      character*2 coment
      parameter (coment='# ')

c     Dump phase data, eref and complex phase for each shell
      do 200  iph = 0, nph
         linit = 0
         if (linit .ge. lmax(iph)-1) linit = lmax(iph)-2
         if (linit .lt. 0) linit = 0

c        prepare files for shell's phase data

         write(fname,20)  iph
  20     format('phase', i2.2, '.dat')
         open (unit=1, file=fname, status='unknown', iostat=ios)
         call chopen (ios, fname, 'wphase')

         write(fname,30)  iph
  30     format('phmin', i2.2, '.dat')
         open (unit=2, file=fname, status='unknown', iostat=ios)
         call chopen (ios, fname, 'wphase')

         do 50 i = 1, ntitle
            ll = istrln(title(i))
            write(1,40)  coment, title(i)(1:ll)
            write(2,40)  coment, title(i)(1:ll)
  40        format (a,a)
  50     continue
c        write out unique pot and lmax
         write(1,60)   coment, iph, lmax(iph), ne
         write(2,60)   coment, iph, lmax(iph), ne
  60     format (a, 1x, 3i4, '   unique pot,  lmax, ne')
         write(2,70) coment, linit,linit+1,linit+2
  70     format (a,'      energy      re(eref)     re(p)    phase( ',i2,
     1         ')  phase(',i2,') phase(',i2,')' ) 

c        for each energy
c        ie, em, eref, p=sqrt(2*(em-eref))
c        ph array from 0 to ltot, 5 values per line
         do 150  ie = 1, ne
           write(1,110) coment, ie, dble(em(ie)), eref(ie,1),
     1                  sqrt(2*(em(ie)-eref(ie,1)))
  110      format (a, '   ie        energy      re(eref)',
     1             '      im(eref)',
     2             '         re(p)         im(p)', /,
     3             1x, i4, 1p, 5e14.6)

           write(1,120)  (ph(ie,ll,1,iph), ll=0,lmax(iph))
  120      format (1x, 1p, 4e14.6)

           write(2,130) dble(em(ie)), dble(eref(ie,1)),
     1     dble(sqrt(2*(em(ie)-eref(ie,1)))),
     2     (dble(ph(ie,ll,1,iph)), ll=linit,linit+2)
  130       format (1p, 6e13.5)
  150    continue
         close(unit=1)
         close(unit=2)
  200 continue

      return
      end
      subroutine wrxsph (nsp, ne, ne1, ne3, nph, ihole, rnrmav,xmu,edge,
     1                   ik0, em, eref, lmax, iz, potlbl, ph, rkk)
      implicit double precision (a-h, o-z)
c     writes down file 'phase.bin' to be read by rphbin
c  Energy grid information
c     em   - complex energy grid
c     eref - V_int + i*gamach/2 + self-energy correction
c     ne   - total number of points in complex energy grid
c     ne1  - number of points on main horizontal axis
c     ne2  - number of points on vertical vertical axis ne2=ne-ne1-ne3
c     ne3  - number of points on auxilary horizontal axis (need for f')
c     xmu  - Fermi energy
c     edge - x-ray frequency for final state at Fermi level
c     ik0  - grid point index at Fermi level
c  Potential type information
c     nph - number of potential types
c     iz  - charge of nuclei (atomic number)
c     potlbl - label for each potential type
c     lmax - max orb momentum for each potential type
c     ihole - index of core-hole orbital for absorber (iph=0)
c     rnrmav - average Norman radius (used in headers only)
c  Main output of xsect and phases module (except that in xsect.bin)
c     ph  - complex scattering phase shifts
c     rkk - complex multipole matrix elements

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

      character*6  potlbl
      dimension  potlbl(0:nphx)

      complex*16 ph(nex,-ltot:ltot,nspx,0:nphx), eref(nex,nspx), em(nex)
      complex*16 rkk(nex, 8, nspx)
      dimension lmax(0:nphx)
      dimension iz(0:nphx)

c     Local staff
c     npadx control padlib precision (see padlib package)
      parameter (npadx=8)
c     use temp to write ph, rkk, since ne < nex
      complex*16 temp(nex*(2*ltot+1))
      dimension dum(3)

      open (unit=1, file='phase.bin', status='unknown', iostat=ios)
      call chopen (ios, 'phase.bin', 'wrxsph')

      write(1,10) nsp, ne, ne1, ne3, nph, ihole, ik0, npadx
  10  format (8(1x,i4))

      dum(1) = rnrmav
      dum(2) = xmu 
      dum(3) = edge
      call wrpadd(1, npadx, dum(1), 3)

      call wrpadx(1, npadx, em(1), ne)
      ii = 0
      do 60 isp = 1, nsp
      do 60 ie=1, ne
        ii = ii + 1
        temp(ii) = eref (ie, isp)
  60  continue
      call wrpadx (1, npadx, temp(1), ii)

      do 80  iph = 0, nph
         write(1, 20) lmax(iph), iz(iph), potlbl(iph)
  20     format(2(1x,i3), 1x, a6)
         do 75  isp = 1, nsp
            ii = 0
            do 70  ie = 1, ne
            do 70  ll = -lmax(iph), lmax(iph)
               ii = ii+ 1
               temp(ii) = ph(ie, ll, isp, iph)
   70       continue
            call wrpadx (1, npadx, temp(1), ii )
   75    continue
   80 continue

      ii = 0
      do 90 isp = 1, nsp
      do 90 kdif = 1, 8
      do 90 ie=1, ne
        ii = ii + 1
        temp(ii) = rkk (ie, kdif, isp)
  90  continue
      call wrpadx (1, npadx, temp(1), ii)

      close (unit=1)

      return
      end
      subroutine xmult (k, kp, ls, lb, xm1, xm2)

      implicit double precision (a-h, o-z)
      complex*16 xm1, xm2, alslb
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c     xm1, xm2 both either real or pure imaginary
      integer a, ap

c     see Grant eq. 6.30. calculate the factors 
c     <k|alpha*A( l, L)|k'> = (-)**(j-m) * 3j( j L j'; -m p m')*R_k,k'
c     R_k,k'(l,L) = \int dr (xm1*P_k*Q_k'+ xm2*Q_k*P_k') * j_l(wr)

c     set the factor in front of bessel function (eq.6.26)
      if (ls+1.eq.lb) then
c        e.g. dipole and quadrupole transition
         aa = (2*lb-1) * (lb+1) / 2.d0
         alslb = coni**ls * sqrt(aa)
      elseif (ls-1.eq.lb) then
c        e.g. cross dipole-octupole
         aa = (2*lb+3) * lb / 2.d0
         alslb = coni**ls * sqrt(aa)
      elseif (ls.eq.lb) then
c        e.g. magnetic dipole
         alslb = coni**ls * (2*lb+1) /sqrt(2.d0)
      else
         alslb = 0
      endif

c     set all angular momenta
      j2 = 2*abs(k) -1
      a = 1
      if (k.gt.0) a=-1
      jp2 = 2*abs(kp) -1
      ap = 1
      if (kp.gt.0) ap=-1

c     calculate xm1 (beta=1 in eq.6.30)
c     check out 2 Kronecker symbols
      lam = (j2-a) / 2
      lamp = (jp2+ap) / 2
      if ( 2*lam.eq.j2-a .and. 2*lamp.eq.jp2+ap) then
         call ninej (lam, lamp, ls, j2,jp2, lb, aa)
         xm1 = alslb * aa * cwig3j(lam, ls, lamp, 0, 0, 1) * (-1)**lam
     1        * sqrt(6.d0*(j2+1)*(jp2+1)*(2*lb+1)*(2*lam+1)*(2*lamp+1) )
         xm1 = xm1 * coni
      else
         xm1 = 0
      endif

c     calculate xm2 (beta=-1 in eq.6.30)
c     check out 2 Kronecker symbols
      lam = (j2+a) / 2
      lamp = (jp2-ap) / 2
      if ( 2*lam.eq.j2+a .and. 2*lamp.eq.jp2-ap) then
         call ninej (lam, lamp, ls, j2,jp2, lb, aa)
         xm2 = alslb * aa * cwig3j(lam, ls, lamp, 0, 0, 1) * (-1)**lam
     1       * sqrt(6.d0*(j2+1)*(jp2+1)*(2*lb+1)*(2*lam+1)*(2*lamp+1) )
c        factor -1 due to complex conjugation of i*Q_k
         xm2 = - coni * xm2
      else
         xm2 = 0
      endif

      return
      end

      subroutine ninej (lam, lamp, ls, j2,jp2, lb, aa)
      implicit double precision (a-h, o-z)
c     calculate 9j-symbol in 6.30 of Grant using eq. C.41 in Messiah

      if (ls.gt.lb) then
        aa = - (ls+lb+1)* sixj(1,2,2*lb,ls+lb,2*ls) *
     1       sixj(2*lb, ls+lb, 2*lamp, jp2, j2) *
     1       sixj(ls+lb,2*ls, 2*lam, j2, 2*lamp)
      elseif (ls.lt.lb) then
        aa = - (ls+lb+1)* sixj(1,2,2*lb,ls+lb,2*ls) *
     1       sixj(ls+lb, 2*lb, jp2, 2*lamp, j2) *
     1       sixj(2*ls, ls+lb, j2, 2*lam, 2*lamp)
      else
c       ls=lb (magnetic dipole)
        aa = -(2*ls+2) * sixj(1,2,2*lb,2*lb+1,2*lb) *
     1       sixj(2*lb, 2*lb+1, 2*lamp, jp2, j2) *
     1       sixj(2*lb, 2*lb+1, j2, 2*lam, 2*lamp)
        aa = aa -(2*ls) * sixj(1,2,2*lb,2*lb-1,2*lb) *
     1       sixj(2*lb-1, 2*lb, jp2, 2*lamp, j2) *
     1       sixj(2*lb-1, 2*lb, 2*lam, j2, 2*lamp)
      endif

      return
      end

      double precision function sixj(j1,j2,j3,j4,j5)
      implicit double precision (a-h, o-z)
c     calculate 6j symbols in eq. c.38, c39 of Messiah
c     all input angular momenta are multiplied by 2 and
c     j2 should be equal to j1+1
      integer g2

      aa = 0
      if (j2.eq.j1+1) then
        if (j4.eq.j3+1) then
c         eq.c.38
          g2 = j5 - 1
          if (g2.ge.abs(j1-j3) .and. g2.le.j1+j3) then
            aa = (1.d0 + (g2+j1-j3)/2.d0) * (1.d0 +(g2-j1+j3)/2.d0) /
     1           (j1+1) /(j1+2)/(j3+1)/(j3+2)
            aa = sqrt(aa) * (-1)**(nint(1+(g2+j1+j3)/2.d0))
          endif
        elseif(j3.eq.j4+1) then
c         eq.c.39
          g2 = j5
          if (g2.ge.abs(j1-j4) .and. g2.le.j1+j4) then
            aa = (1.d0 - (g2-j1-j4)/2.d0) * (2.d0 +(g2+j1+j4)/2.d0) /
     1           (j1+1) /(j1+2)/(j4+1)/(j4+2)
            aa = sqrt(aa) * (-1)**(nint(1+(g2+j1+j4)/2.d0))
          endif
        endif
      endif
      sixj = aa

      return
      end

      subroutine rexsph ( mphase, ipr2, ispec, vixan, xkstep, xkmax,
     1             gamach, rgrd,
     1             nph, lmaxph, potlbl, spinph, iatph, nat, rat, iphat,
     2             ixc, vr0, vi0, ixc0, lreal, rfms2, lfms2, l2lp,
     3             ipol, ispin, le2, angks, ptz, iPl, iGrid,
     4             izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis)

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

cc    geom.dat
        integer  nat, iatph(0:nphx), iphat(natx)
        double precision  rat(3,natx)
cc    global.dat 
c       configuration average
        integer nabs, iphabs
c       global polarization data
        integer  ipol, ispin, le2
        double precision evec(3), xivec(3), spvec(3), elpty,angks,rclabs
        complex*16 ptz(-1:1, -1:1)
cc    mod2.inp
        integer mphase, ipr2, ixc, ixc0, ispec, lreal, lfms2, l2lp, iPl, 
     &       iGrid
        double precision rgrd, gamach, xkstep, xkmax, vixan
        double precision vr0, vi0, spinph(0:nphx)
        real rfms2
        integer lmaxph(0:nphx)
        character*6  potlbl(0:nphx)
        integer izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis

c     Local stuff
      character*512 slog
      character*80 head(nheadx)
      dimension lhead(nheadx)

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)


c     Read  geom.dat file
      open (file='geom.dat', unit=3, status='old',iostat=ios)
c       read header from geom.dat
        nhead = nheadx
        call rdhead (3, nhead, head, lhead)
        nat = 0
        nph = 0
        do 40 iph = 0, nphx
  40    iatph(iph) = 0
  50    continue
           nat = nat+1
           if (nat .gt. natx)  then
              write(slog,55) ' nat, natx ', nat, natx
              call wlog(slog)
  55          format(a, 2i10)
              stop 'Bad input'
           endif
           read(3,*,end=60)  idum, (rat(j,nat),j=1,3), iphat(nat), i1b
           if (iphat(nat).gt.nph) nph = iphat(nat)
           if ( iatph(iphat(nat)).eq.0) iatph(iphat(nat)) = nat
        goto 50
  60    continue
        nat = nat-1
      close(3)
cc    global.inp
      open (file='global.dat', unit=3, status='unknown',iostat=ios)
c       configuration average data
        read  (3, 10) slog
        read  (3, 65) nabs, iphabs, rclabs
  65    format ( 2i8, f13.5)
c       global polarization data
        read  (3,10)   slog
        read  (3, 70)  ipol, ispin, le2, elpty, angks
  70    format ( 3i5, 2f12.4)
        read  (3, 10) slog
        do 80 i = 1,3
          read  (3,30) evec(i), xivec(i), spvec(i)
  80    continue
        read  (3, 10) slog
        do 90 i = -1, 1
          read (3,30) a1, b1, a2, b2, a3, b3
          ptz(-1,i)= cmplx(a1,b1)
          ptz(0,i) = cmplx(a2,b2)
          ptz(1,i) = cmplx(a3,b3)
  90    continue
      close(3)
c     read mod2.inp
c     Josh - added flag iPl for PLASMON card
c     Josh - added flag iGrid for user controlled grids.
      open (file='mod2.inp', unit=3, status='old',iostat=ios)
        read (3,10)  slog
        read (3,20)  mphase,ipr2,ixc,ixc0,ispec,lreal,lfms2,nph,l2lp,
     &       iPl,iGrid
        read (3,10)  slog
        read (3,30)  vr0, vi0
        read (3,10)  slog
        read (3,20)  (lmaxph(iph),iph=0,nph)
        read (3,10)  slog
        read (3,170)  (potlbl(iph),iph=0,nph)
  170   format (13a6)
        read (3,10)  slog
        read (3,30)  rgrd, rfms2, gamach, xkstep, xkmax, vixan
        read (3,30)  (spinph(iph),iph=0,nph)
        read (3,20)  izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis
      close(3)

!KJ next section added for ELNES calculations 1-06
      open(3,file='eels.inp',status='old',err=100)
        read(3,*)
	read(3,20,end=100,err=100) melnes
      close(3)
      if(melnes.eq.1.and.mphase.eq.1) then
        call wlog(':INFO : rexsph reduces your polarization tensor to 
     1   the unit matrix, because eels.inp says you are doing ELNES.')
        do i=-1,1
	do j=-1,1
	ptz(i,j)=dcmplx(0,0)
	enddo
	  ptz(i,i)=dble(1)/dble(3)
	  write(*,*) (ptz(i,j),j=-1,1)
	enddo
      endif
100   continue
c !KJ end of my modifications      



c     transform to code units (bohrs and hartrees - atomic unuts)
      rfms2 = rfms2 / bohr
      vr0   = vr0 / hart
      vi0   = vi0 / hart
      gamach = gamach / hart
      vixan = vixan / hart
      xkstep = xkstep * bohr
      xkmax  = xkmax  * bohr
      do 210 i = 1,3
      do 210 iat = 1, nat
        rat(i,iat) = rat(i,iat) / bohr
 210  continue

      return
      end
c     Josh - argument iPl has been added to arguments of xsect
      subroutine xsect (ipr2, dx, x0, ri, ne, ne1, ik0, em, edge,
     1                  ihole, emu, corr, dgc0, dpc0, jnew,
     2                  ixc, lreal, rmt, rnrm, xmu,
     2                  vi0, iPl, gamach,
     3                  vtot, vvalgs, edens, dmag, edenvl,
     4                  dgcn, dpcn, adgc, adpc, xsec, xsnorm, rkk,
     5                  iz, xion, iunf, xnval,
     5                  izstd, ifxc, eorb, kappa, iorb, l2lp,
     6                  ipol, ispin, le2, angks, ptz)

c     right know the same self-energy is used for calculation
c     of the central atom part (xsec) and dipole m.e. for
c     scattering (rkk). You may want to run xsect separately
c     for xsec and for rkk, if you want to use different self-energy
c     for central and scattering parts.  ala. fix later

      implicit double precision (a-h, o-z)

c     INPUT
c     dx, x0, ri(nr)
c                  Loucks r-grid, ri=exp((i-1)*dx-x0)
c     ne, em(ne)   number of energy points, real energy grid
c     edge         chemical potential (energy for k=0)
c     ihole        hole code
c     emu          position of chemical potential in absorption specrum
c     dgc0(nr)     dirac upper component, ground state hole orbital
c     dpc0(nr)     dirac lower component, ground state hole orbital
c     ixc          0  Hedin-Lunqist + const real & imag part
c                  1  Dirac-Hara + const real & imag part
c                  2  ground state + const real & imag part
c                  3  Dirac-Hara + HL imag part + const real & imag part
c                  5  Dirac-Fock exchange with core electrons +
c                     ixc=0 for valence electron density
c     lreal        logical, true for real phase shifts only
c     rmt          r muffin tin
c     xmu          fermi level
c     vi0          const imag part to add to complex potential
c     gamach       core hole lifetime
c     vtot(nr)     total potential, including gsxc, final state
c     edens(nr)    density, hole orbital, final state
c     dmag(251)     density magnetization
c     edenvl      valence charge density
c     dgcn(dpcn)   large (small) dirac components for central atom
c     adgc(adpc)   their development coefficients
c
c     OUTPUT
c     xsec(ne)    atomic absorption cross section to multiply \chi
c                 (atomic background for XMCD)
c     xsnorm(ne)  atomic  absorption cross section (norm for XMCD)
c     rkk(ne, 8)  normalized reduced matrix elements for construction
c                 of termination matrix in genfmt.

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      complex*16 ptz
      dimension ptz(-1:1, -1:1)

      complex*16 em(nex)
      dimension ri(nrptx), vtot(nrptx), edens(nrptx),dmag(nrptx)
      dimension dgc0(nrptx), dpc0(nrptx), vvalgs(nrptx), edenvl(nrptx)
      dimension dgcn(nrptx,30), dpcn(nrptx,30), eorb(30), kappa(30)
      dimension adgc(10,30), adpc(10,30), xnval(30), iorb(-4:3)
      complex*16 rkk(nex, 8), xsec(nex)
      complex*16 bmat(-lx:lx,0:1,8, -lx:lx,0:1,8)
      dimension kind(8), lind(8)
      dimension xsnorm(nex)

      dimension xp(nrptx), xq(nrptx)

c     work space for xcpot
      dimension vxcrmu(nrptx), vxcimu(nrptx), gsrel(nrptx)
      dimension vvxcrm(nrptx), vvxcim(nrptx)

c     work space for fovrg
      complex*16 p(nrptx), q(nrptx), pn(nrptx), qn(nrptx), fscf(nrptx)
      complex*16 pp(nrptx), qp(nrptx), pnp(nrptx), qnp(nrptx)
c     storage for calculation of cross term (SPIN 1 only)
      complex*16 xrcold(nrptx) , xncold(nrptx), yvec(nrptx,1)

      complex*16  p2, ck, xkmt, xkmtp
      complex*16  pu, qu, dum1, factor
      complex*16  xfnorm, xirf, xirf1
      complex*16  temp, aa, bb, cc, rkk1, rkk0, phold
      complex*16  phx(8), ph0
      complex*16  eref, xm1, xm2, xm3, xm4

      complex*16 jl,jlp1,nl,nlp1
      complex*16  v(nrptx), vval(nrptx)
      complex*16  xrc(nrptx), xnc(nrptx)
      character*512 slog
      logical ltrace
c     nesvi:  
      complex*16 xrhoce(nex), xrhopr(nex), chia(nex), cchi(nex)
      dimension omega1(nex), bf(0:2, nrptx)

      dimension pat(nrptx),qat(nrptx)
      complex*16 intr(nrptx),var(nrptx) 
c     to pass energy levels and projected DOS
      dimension neg(30), eng(nex, 30), rhoj(nex,30)
c     Josh - Added iPl switch for PLASMON card
c          - and WpCorr = Wi/Wp, Gamma, AmpFac
c          - to describe Im[eps^-1]
      integer iPl, ipole
      double precision WpCorr(MxPole), Gamma(MxPole), AmpFac(MxPole)
c     Josh END
      
      call setkap(ihole, kinit, linit)
      PRINT*, 'dx=',dx
c     set imt and jri (use general Loucks grid)
c     rmt is between imt and jri (see function ii(r) in file xx.f)
      imt = (log(rmt) + x0) / dx  +  1
      jri = imt+1
      jri1 = jri+1
      if (jri1 .gt. nrptx)  call par_stop('jri .gt. nrptx in phase')

c     nesvi: define jnrm
      inrm = (log(rnrm) + x0) / dx + 1
      jnrm = inrm + 1

c     We'll need <i|i> later to normalize dipole matrix elements
c     <i|r|f>.  NB, dgc and dpc are r*wave_fn, so use '0' in somm to
c     get integral  psi**2 r**2 dr.
c     Square the dgc0 and dpc0 arrays before integrating.
c     <i|i> == xinorm.
c     dgc and dpc should be normalized <i|i>=1, check this here
      do 10  i = 1, nrptx
         xp(i) = dpc0(i)**2
         xq(i) = dgc0(i)**2
  10  continue
c     nb, xinorm is used for exponent on input to somm
      xinorm = 2*linit + 2
      call somm (ri, xp, xq, dx, xinorm, 0, jnrm)
      del = abs (abs(xinorm) - 1)
      if (del .gt. 1.e-2) then
         write(slog,'(a,i8,1p2e13.5)') ' ihole, xinorm ', ihole , xinorm
         call wlog(slog)
c        if using real phase shifts, don't expect great results
         if (lreal.lt.2)  then
           call wlog(' There may be convergence problems.')
           call wlog(' Xinorm should be 1. If you set the RGRID, '//
     1               'minor interpolation errors ')
           call wlog(' that will not affect final results may occur')
         endif
      endif

c     use ixc for testing
      index = ixc
c       Always use ground state self energy for xsection, quick fix
c       JJR, Jan 93
c       change for testing broadened plasmon pole 6/93
c       index = 2
c   ALA found that it is better to use index=ixc and real part of 
c   self-energy for atomic xsection. 12/96
      ltrace = .true.
      call bcoef(kinit, ipol, ptz, le2, ltrace, ispin, angks, 
     1           kind, lind, bmat)
c     set spin index to use bmat
      isp = 0
      if (ispin.eq.1) isp = nspx - 1

c     zero rkk and phx
      do 20 ie = 1,nex
      do 20 k1 = 1,8
 20   rkk(ie,k1) = 0
      do 30 k1 = 1,8
 30   phx(k1) = 0

      ifirst = 0
c     Josh - if PLASMON card is set, and using HL exc,
c          - read pole information from epsinv.dat
      IF( (iPl.gt.0).and.(ixc.eq.0) ) THEN
         open(file='exc.dat', unit=47, status='old',iostat=ios)
         call chopen (ios, 'exc.dat', 'ffmod2(xsect)')
         DO ipole = 1, MxPole
            call rdcmt(47,'#*cC')
            read(47,*,END=35) WpCorr(ipole), Gamma(ipole), AmpFac(ipole)
            Gamma(ipole)  = Gamma(ipole)/hart
            WpCorr(ipole) = (WpCorr(ipole)/hart) /
     &           SQRT(3.d0/((3 / (4*pi*edens(jri+1))) ** third)**3)
         END DO
 35      CONTINUE
         WpCorr(ipole) = -1.d30
         CLOSE(47)
      END IF
      IF(ixc.eq.0) THEN
c        Write wp as calculated from density to sigma.dat
         open(file='mpse.dat', unit=45, status='replace',iostat=ios)
         call chopen (ios, 'sigma.dat', 'ffmod2(xsect)')
         write(45,*) '# ', 'rs      wp(Hartrees)'
         write(45,*) '# ', (3 / (4*pi*edens(jri+1))) ** third,
     &        SQRT(3.d0/((3 / (4*pi*edens(jri+1))) ** third)**3)*hart
         write(45,'(a)')
     &        '# E-EFermi (eV)   Re[Sigma(E)] (eV)   Im[Sigma(E)] (eV)'
     &        // '   Re[Z]   Im[Z]   Mag[Z]   Phase[Z]   Lambda(E) (/A)'
      END IF
c     Josh END
      
      do 400 ie = 1, ne
         iph = 0
c        Josh - xcpot now has new arguments:
c             - iPl, WpCorr, Gamma, AmpFac         
         call xcpot (iph, ie, index, lreal, ifirst, jri,
     1               em(ie), xmu,
     2               vtot, vvalgs, edens, dmag, edenvl,
     3               eref, v, vval, iPl, WpCorr, Gamma, AmpFac,
     4               vxcrmu, vxcimu, gsrel, vvxcrm, vvxcim,rnrm)

c       set the method to calculate atomic cross section
c       p2 is (complex momentum)**2 referenced to energy dep xc
        p2 = em(ie) - eref
        p2f = edge - dble(eref)
        ck = sqrt (2*p2 + (p2*alphfs)**2)
        xkmt = rmt * ck

        if (mod(index,10) .lt. 5) then
           ncycle = 0
        else
c          fix later . may be ncycle can be less
           ncycle = 3
        endif
        omega = (dble(em(ie)) - edge) + emu
        omega = max (omega, 0.001d0 / hart)
c       nesvi: add omega1(ie)- need it later
        omega1(ie) = omega

c       remember the bessel functions for multipole matrix elements
        xk0 = omega * alphfs
        ilast = jnrm+6
        if (ilast.lt.jnew) ilast = jnew
        if (ilast.gt.nrptx) ilast = nrptx
        do 50 i = 1, ilast
          temp = xk0 * ri(i)
          if (abs(temp).lt.1.d0) then
c           use series expansion
            do 40 ll = 0,2
              call bjnser(temp,ll, xirf, dum1,1)
              bf(ll,i) = dble(xirf)
 40         continue
          else
c           use formula
            x = dble(temp)
            sinx = sin(x)
            cosx = cos(x)
            bf(0,i) = sinx/x
            bf(1,i) = sinx/x**2 - cosx/x
            bf(2,i) = sinx*(3/x**3-1/x) - 3*cosx/x**2
          endif
 50     continue

c       notice for spin-dep case xsnorm and xsec are spin-dep
c       and kept separately (see call to xsect in subroutine xsph)
        xsnorm(ie) = 0 
        xsec(ie) = 0
        if (dble(em(ie)).lt.-10.d0) goto 400
        if (dimag(p2).le.0.d0 .and. dble(p2).le.0.d0) goto 400

c       matrix elements for multipole (E1,E2,M1) transitions
c       The terms up to (k/c)^2 for absorption are kept.
c       L3 edge: kdif=1 (3d5/2)      kdif=2 (3d3/2), kdif=3(4s)
c       L2 edge: kdif=1 (no transition), 2 (4s),      3 (3d3/2)
        do 350 mult = 0, 2
          if (mult.eq.0) then
c           E1 transitions
            kx = 1
            ks = 2
          else
c           M1 transitions
            kx = 1
            ks = 6
c           E2 transitions
            if (mult.eq.2) kx = 2
          endif 
c         skip unnecessary calculations
          if (mult.gt.0 .and. (mult.ne.le2)) goto 350
 
c         set ilast larger than jri for better interpolation for pu
c         also need 5 points after jri for irregular solution
          ilast = jnrm + 6
          if (ilast.lt.jnew) ilast = jnew

cc        calculate screened dipole field
          ww = dble(emu+p2-edge)
          if (mult.eq.0 .and. izstd.gt.0) then
            if (ie.eq.1) call correorb(iz, ihole, rmt, jri, dx,ri,
     1                   p2f,edge, v, dgcn, dpcn, adgc, adpc,
     2                   eorb, neg, eng, rhoj, kappa, norbp)
            maxsize = 1
            matsize = 0
            sfun = 1.d0
            call phiscf (ifxc, rmt, ilast, jri, p2, p2f, emu, dx,
     1                  ri, v, edens, dgcn, dpcn, adgc, adpc,
     2                  iz, ihole, neg, eng, rhoj,kappa, norbp, fscf,
     3                  yvec, maxsize, matsize, sfun)
            wse = dble(p2-eng(1,ihole))
          else
            do 159 i = 1, nrptx 
  159       fscf(i) = 1.d0
            wse = ww
          endif
      
c         ww = 1
c         ww = wse / ww
          ww = sqrt(wse/ww)

          do 300 kdif = -kx, kx
            if (omega.le.0.0) goto 300
            ind = kdif + ks
            ikap = kind (ind)
            if (ikap .eq. 0) goto 300
c           use l2lp =0 to include both transitions l-->l+/-1
c           if (l2lp.ne.0) only dipole transitions are calculated.
c            l-->l+1 transitions
            if (l2lp.eq.1 .and. ((kinit.lt.0 .and. ind.ge.3) .or.
     1          (kinit.gt.0 .and. ind.ne.3)) ) goto 300
c            l-->l-1 transitions
            if (l2lp.eq.-1 .and. ((kinit.lt.0 .and. ind.ne.3) .or.
     1          (kinit.gt.0 .and. ind.ge.3)) ) goto 300

            iold = 0
            ic3=0
c           start cycle  do ic3=0,1
c           return for ic3=1 calculations only for |ispin|=1
c           where the central atom cross terms are needed
  100       continue

            irr = -1
c           ic3p=1 to test K2Cr2O7  L3 XES 
            ic3p = ic3
            call dfovrg ( ncycle, ikap, rmt, ilast, jri, p2, dx,
     1      ri, v, vval, dgcn, dpcn, adgc, adpc,
     2               xnval, pu, qu, p, q,
     3               iz, ihole, xion, iunf, irr, ic3p)
            lfin = lind (ind)
            ilp = lfin - 1
            if (ikap .lt. 0) ilp = lfin + 1
            call exjlnl (xkmt, lfin, jl, nl)
            call exjlnl (xkmt, ilp, jlp1, nlp1)
            call phamp(rmt,pu,qu, ck, jl,nl,jlp1,nlp1, ikap, ph0,temp)

            sign = -1.0
            if (ikap.gt.0) sign = 1.0
            factor = ck*alphfs 
            factor = sign * factor/(1+sqrt(1+factor**2))
            dum1 = 1/ sqrt(1+factor**2)
            xfnorm = 1 / temp *dum1
c           normalization factor
c           xfnorm = dum1*rmt*(jl*cos(delta) - nl*sin(delta))/ Rl(rmt)
c           dum1 is relativistic correction to normalization
c           normalize regular solution
            do 130  i = 1,ilast
              p(i)=p(i)*xfnorm
              q(i)=q(i)*xfnorm
  130       continue

cc          calculate xirf including fscf - TDLDA result
            do 140 id = 1, 2
              if (id.eq.1) then
                do 121 j = 1,ilast 
                  pp(j)  = p(j)*dble(fscf(j))
                  qp(j)  = q(j)*dble(fscf(j))
  121           continue
              else
                do 122 j = 1,ilast
                  pp(j)  = p(j)*dimag(fscf(j))
                  qp(j)  = q(j)*dimag(fscf(j))
  122           continue
              endif
              ifl = 1
              if (izstd.gt.0) ifl = -1
              xirf1 = 0
              call radint(ifl, mult, bf, kinit, dgc0,dpc0, ikap, pp,qp,
     1        pn,qn,ri,dx, ilast,iold, xrc,xnc, xrcold,xncold, xirf1)
c             if (ifl.lt.0) xirf1 = xirf1 * xk0 * ww
              if (ifl.lt.0) xirf1 = xirf1 * xk0 
              if (id.eq.1) then
                xirf = xirf1
              else
                if (abs(xirf) .eq. 0.d0) then
                  xirf = xirf1
                elseif (abs(xirf1) .eq. 0.d0) then
                  xirf = xirf
                elseif (abs(xirf1) .lt. abs(xirf)) then
                  dum = abs(xirf1) / abs(xirf)
                  xirf = xirf * sqrt(1.d0 + dum**2)
                else
                  dum = abs(xirf) / abs(xirf1)
                  xirf = xirf1 * sqrt(1.d0 + dum**2)
                endif
              endif
  140       continue

c           note that for real potential  xirf is real or reduced matrix
c           element for dipole transition is pure imaginary.
            if (ic3.eq.0) then
c              can remember only E2 or M1 matrix elements
               if (mult.eq.0 .or. le2.eq.mult) then
                 rkk(ie,ind)=xirf 
                 phx(ind) = ph0
               endif
c              for f' want to include both E2 and M1 for xsnorm and xsec
c              but now only one of them is included (fix later)
               xsnorm(ie)=xsnorm(ie) +
     1         ( dble(xirf)**2 + dimag(xirf)**2 )/ (2*kx+1)
               aa =  - coni*xirf**2
               xsec(ie) = xsec(ie) -  aa * bmat(0,isp,ind, 0,isp,ind)
            elseif (iold.eq.1) then
                rkk1=xirf
                phold = ph0
            elseif (iold.eq.2) then
                rkk0=xirf
            endif

c           get irregular solution and atomic cross-section xsec
c           find irregular solution

            if(dimag(em(ie)).gt.0.d0) then
              irr = 1
c             set pu, qu - initial condition for irregular solution 
              pu = (nl*cos(ph0)+jl*sin(ph0)) *rmt * dum1
              qu=(nlp1*cos(ph0)+jlp1*sin(ph0))*factor *rmt * dum1
             
c             test on bessel functions
c             if (ikap.gt.0) print*,'test1',xkmt**2*(jl*nlp1-nl*jlp1)

              call dfovrg (ncycle, ikap, rmt, ilast, jri, p2, dx,
     1              ri, v,vval, dgcn, dpcn, adgc, adpc,
     1              xnval, pu, qu, pn, qn,
     1              iz, ihole, xion, iunf, irr, ic3p)
cc            set N- irregular solution , which is outside
cc            N=(nlp1*cos(ph0)+jlp1*sin(ph0))*factor *rmt * dum1
cc            N = i*R - H*exp(i*ph0)
              temp = exp(coni*ph0)
              do i = 1, ilast
                pn(i) = coni * p(i) - temp * pn(i)
                qn(i) = coni * q(i) - temp * qn(i)
              enddo
            else
              do 150 i = 1, ilast
                pn(i) = 0
                qn(i) = 0
  150         continue
            endif

c           combine regular and irregular solution into the
c           central atom absorption coefficient xsec (mu = dimag(xsec))
c           thus for real energy dimag(xsec)=xsnorm

c           also include TDLDA effects
            do 170 id = 1, 2
              if (id.eq.1) then
                do 131 j = 1,ilast
                  pp(j)  = p(j)*dble(fscf(j))
                  qp(j)  = q(j)*dble(fscf(j))
                  pnp(j)  = pn(j)*dble(fscf(j))
                  qnp(j)  = qn(j)*dble(fscf(j))
  131           continue
              else
                do 132 j = 1,ilast
                  pp(j)  = p(j)*dimag(fscf(j))
                  qp(j)  = q(j)*dimag(fscf(j))
                  pnp(j)  = pn(j)*dimag(fscf(j))
                  qnp(j)  = qn(j)*dimag(fscf(j))
  132           continue
              endif

c           TDLDA theory is written for the r-form of matrix elements
c           so one might want to use ifl=-1,-2 for these calculations
c           on the other hand want ifl=1,2 for DANES calculations
c           since it is more reliable at high energies and gives
c           better results for Cu test.
              ifl = 2
              if (izstd.gt.0) ifl = -2

              call radint(ifl,mult, bf, kinit, dgc0, dpc0, ikap, pp, qp,
     1            pnp, qnp, ri,dx, ilast,iold, xrc, xnc, xrcold, xncold,
     2            xirf1)
              if (ifl.lt.0) xirf1 = xirf1 * xk0**2 * ww**2
              if (id.eq.1) then
                xirf = xirf1
              else
                if (abs(xirf) .eq. 0.d0) then
                  xirf = xirf1
                elseif (abs(xirf1) .eq. 0.d0) then
                  xirf = xirf
                elseif (abs(xirf1) .lt. abs(xirf)) then
                  dum = abs(xirf1) / abs(xirf)
                  xirf = xirf * sqrt(1.d0 + dum**2)
                else
                  dum = abs(xirf) / abs(xirf1)
                  xirf = xirf1 * sqrt(1.d0 + dum**2)
                endif
              endif
  170       continue

            if (ic3.eq.0) then
               xsec(ie) = xsec(ie) - xirf * bmat(0,isp,ind, 0,isp,ind)
            endif

c           ------start of density of states part------------- 
c           added by nesvi 07/12/00
c
c           Calculate rhoc00 and rho_projected on 
c           the same grid as xsect. Need this to calculate the smooth
c           atomic ratio rho_0/mu_0 or rho_proj/mu_0.              
c           The atomic functions are normalized to 1 inside Norman radius.
c           This procedure can be called 'Renormalized atomic sphere method".
c           It gives very reasonable numbers for hole counts. In order to
c           get Mulliken counts one can extend integration limits till very
c           large R, but it's currently not recommended because of the problems
c           with the wave function's tails above Rnm.
 

            jproj =  iorb(ikap)
            if (jproj.eq.0 .and. ikap.lt.0) jproj = iorb(-ikap-1)
            kdif1 = -1
            if(kinit.gt.0) kdif1 =  1
                
            if (kdif .eq. kdif1 .and. ic3.eq.0 .and. jproj.gt.0) then
c              calculate rhoc00 (rho_0)

               temp = (2*lfin+1.0d0) / (1+factor**2) /pi *4*ck /hart
               do 500 i = 1, ilast
                 xrc(i) = pn(i)*p(i) - coni*p(i)*p(i) 
     1                   + qn(i)*q(i) - coni*q(i)*q(i)
  500          continue    
               xirf = 1
c              integration is till Norman radius, not Rmt as in xsect
               i0 = jnrm + 1
               call csomm2 (ri, xrc, dx, xirf, rnrm, i0)
               xrhoce(ie) = - xirf * temp
            
c              calculate rho_projected:              

c              pat, qat - atomic functions that we make projection on.
               do 510 i=1,nrptx
                 pat(i) = dgcn(i,jproj)
                 qat(i) = dpcn(i,jproj)
  510          continue

c     normalize pat and qat in the Norman radius sphere: <n|n>=1,
c     (renormalized atomic sphere method)
     
               do 520  i = 1, ilast
                  xp(i) = pat(i)**2 + qat(i)**2
                  xq(i) = 0
  520          continue
c     nb, xinorm is used for exponent on input to somm 
               xinorm = 2*lfin + 2
               call somm2 (ri, xp, dx, xinorm, rnrm, 0, i0)
c              call somm (ri, xp, xq, dx, xinorm, 0, jnrm)
      
               xinorm = sqrt(xinorm)
               do 530 i=1,nrptx
                  pat(i) = pat(i) / xinorm
                  qat(i) = qat(i) / xinorm
  530          continue
  
c              calculate overlap integral between f and atomic function
c              (integral Rl(r)*Psi_at(r)dr from 0 till r') 
c              intr(i) is that overlap integral. Later it
c              will be multiplied by pr(i)*Psi_at(r') and integrated 
c              till Norman radius.

               do 540 i=1,ilast
                  var(i)=pat(i)*p(i)+qat(i)*q(i)
c                 factor of 2 -integration r< r>  -->2 r r'
  540          continue

c              integration by trapezoid method
               intr(1)=var(1)*ri(1)
               do 550 i=2,ilast
                  intr(i)=intr(i-1)+ (var(i)+var(i-1))*(ri(i)-ri(i-1))
  550          continue 


c         now calculate rho_projected - xrhopr
               temp = (2*lfin+1.0d0) / (1+factor**2) /pi *4*ck /hart
c              temp = abs(ikap) / (1+factor**2) /pi *4*ck /hart
               do 560  i = 1, ilast
                 xrc(i) = pn(i)*pat(i)*intr(i)+ 
     1                    qn(i)*qat(i)*intr(i)
                 xrc(i) = xrc(i) - coni*(p(i)*pat(i)*intr(i) + 
     1                    q(i)*qat(i)*intr(i))
  560          continue

               xirf =  1
               call csomm2 (ri, xrc, dx, xirf, rnrm, i0)
               xrhopr(ie) = - xirf * temp
    
            endif
c           ----------end of density of states part---


            if (iold.gt.0) then
c             calculate cross term contribution to XMCD
c             in both cases coupling between neighbors 
c             need to remove SO interaction (ic3=1) in order
c             to avoid unphysical peak in Gd XMCD. a.l. ankudinov
              k1 = ind - 1
              if (k1.ge.1 .and.k1.le.8) then
              if (lind(k1).eq.lind(ind) .and. lind(k1).gt.0) then
                aa = exp( coni*(ph0 - phold))
                bb = 1/aa
                cc = - ( bmat(0,isp,k1, 0,isp,ind) +
     1                 bmat(0,isp,ind, 0,isp,k1) ) / 2.d0
                xsec(ie) = xsec(ie) - coni * rkk1 * rkk0 * (bb+aa) * cc
cc              combine regular and irregular solution into the
cc              central atom absorption coefficient (mu=dimag(xsec))
cc              thus for real energy dimag(xsec)=xsnorm
                call radint (3, mult, bf, kinit, dgc0, dpc0, ikap, p, q,
     1            pn, qn, ri, dx, ilast, iold, xrc, xnc, xrcold, xncold,
     2            xirf)
                xsec(ie) = xsec(ie) + xirf * cc * bb
  
                call radint (4, mult, bf, kinit, dgc0, dpc0, ikap, p, q,
     1            pn, qn, ri, dx, ilast, iold, xrc, xnc, xrcold, xncold,
     2             xirf)
                xsec(ie) = xsec(ie) + xirf * cc * aa
              endif
              endif
            endif
cc          end of |ispin=1| cross term calculations

c           prepare for ic3=1 cross term calculations if needed
            if (ic3.eq.0 .and. abs(ispin).eq.1) then
              iold = 0
              if (ind.lt.8 .and. lind(ind).gt.0) then
                k1 = ind + 1
                if (lind(k1).eq.lind(ind)) iold = 1
              endif
              if (ind.gt.1 .and. lind(ind).gt.0) then
                k1 = ind - 1
                if (lind(k1).eq.lind(ind)) iold = 2
              endif
c             need to remove SO interaction to calculate cross term
c             big effect for Gd XMCD calculations
              if (iold.gt.0) then
c               repeat calculation for current kdif with SO turned off
                ic3 = 1
                goto 100
              endif
            endif

  300     continue
  350   continue

        if (omega.gt.0.0) then
c         prefac = (8 * pi / 3)  * alphfs * omega  -- nonrelativistic
c         relativistic is (for alpha form)
          prefac = 4 * pi * alpinv / omega * bohr**2
          xsnorm(ie) =  xsnorm(ie) * prefac * 2*abs(ck) 
          xnorm= sqrt( xsnorm(ie) )
          xsec(ie) = xsec(ie) * prefac* 2*ck

c         put complex sqrt(prefactor) into reduced matrix elements rkk
          ck = sqrt ( prefac * (2*ck))
c         guarantee that we have the right root
          if (dimag(ck) .lt. 0) ck = -ck
c         add central atom phase shift here. 
          do 360 kdif = 1 , 8
 360      rkk(ie,kdif)= rkk(ie,kdif) * ck/xnorm * exp(coni*phx(kdif))
        endif
 400  continue
c     end of energy cycle

c     Josh - Close sigma.dat
      close(45)
c     Josh END

      if (ipr2.ge.3) then
c       calculate mu_0/rho_0 for XMCD normalization.
        do 410 ie=1,ne
           chia(ie) = 0
  410   continue
        vrcorr = 0
        vicorr = 0
        call xscorr(1, em, ne1, ne, ik0, xrhoce,xsnorm,chia,
     1     vrcorr, vicorr, cchi)
        do 420 ie = 1, ne1
            xrhoce(ie)  = coni* dimag(xrhoce(ie)+cchi(ie))
  420   continue
        call xscorr(1, em, ne1, ne, ik0, xrhopr,xsnorm,chia,
     1     vrcorr, vicorr, cchi)
        do 425 ie = 1, ne1
            xrhopr(ie)  = coni* dimag(xrhopr(ie)+cchi(ie))
  425   continue    
        call xscorr(1, em, ne1, ne, ik0, xsec,xsnorm,chia,
     1     vrcorr, vicorr, cchi)
        do 430 ie = 1, ne1
            cchi(ie)  = coni* dimag(xsec(ie)+cchi(ie))
  430   continue

        open(unit=3,file='ratio.dat',status='unknown', iostat=ios)
        open(unit=4,file='ratiop.dat',status='unknown', iostat=ios)
c       normalize to xsec at 50 ev above edge
        edg50 = emu +50.0 / hart
        call terp (omega1, xsnorm, ne1, 1, edg50, xsedge)
        write(3,440) xsedge, emu * hart 
  440   format ('# Normalization factor:', e12.4,
     1     ' Angstrom**2. Fermi level at ', f7.1, ' eV.')
        write(3,450)
  450   format ('#   Energy      rho_0        mu_0       rho_0/mu_0 ')
     
        write(4,440) xsedge, emu * hart 
        write(4,455)
  455   format ('#   Energy      rho_proj      mu_0      rho_proj/mu_0',
     1   '    mu_deloc ')

        do 470 ie=1,ne1 
           if (dimag(cchi(ie)).eq.0.d0 .and. ie.lt.ik0) then
              cchi(ie)=cchi(ik0)
              xrhoce(ie)=xrhoce(ik0)
              xrhopr(ie)=xrhopr(ik0)
           endif
           ratio = dimag(xrhoce(ie)) / dimag(cchi(ie)) * xsedge
           ratiop = dimag(xrhopr(ie)) / dimag(cchi(ie)) * xsedge

           write(3,460)  dble(em(ie))*hart, dimag(xrhoce(ie)),
     1          dimag(cchi(ie))/xsedge, ratio*corr
c          corr is the ratio N_av/N_j, responsible for difference in
c          counts due to variation of wave function due to spin-orbit
  460      format(f12.6, 2x, e12.6,2x,e12.6,2x,e12.6,1x,e12.6)      
           write(4,465)  dble(em(ie))*hart, dimag(xrhopr(ie)),
     1          dimag(cchi(ie))/xsedge, ratiop,
     2          dimag(xrhoce(ie)-xrhopr(ie))/ratio 
c     also write contribution to mu_0 from delocalized states defined as
c     (rho-rho_proj)/ratio 
  465      format(f12.6, 2x, e12.6,2x,e12.6,2x,e12.6,1x,e12.6,2x,e12.6)    
      
  470   continue    
        close(unit=3)
        close(unit=4)
      endif 

      return
      end
c     Josh - added argument iPl to control many pole self energy.
      subroutine xsph (ipr2, ispec, vixan, xkstep, xkmax, gamach, rgrd,
     1             nph, lmaxph, potlbl, spinph, iatph, nat, rat, iphat,
     2             ixc, vr0, vi0, ixc0, lreal, rfms2, lfms2, l2lp,
     3             ipol, ispin, le2, angks, ptz, iPl, iGrid,
     4             izstd, ifxc, ipmbse, itdlda, nonlocal, ibasis)

c     Cluster code -- multiple shell single scattering version of FEFF
c     This program (or subroutine) calculates potentials and phase
c     shifts for unique potentials specifed by atoms and overlap cards.
c
c     Input files:  potph.inp    input data, atoms, overlaps, etc.
c     Output:       phases.bin   phase shifts for use by the rest of the
c                                program
c                   xxx.dat      various diagnostics

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     Notes:
c        nat    number of atoms in problem
c        nph    number of unique potentials
c        ihole  hole code of absorbing atom
c        iph=0 for central atom

c     Specific atom input data
c     iphat(natx)  -  given specific atom, which unique pot?
      dimension iphat(natx)
c     rat(3,natx)  -  cartesian coords of specific atom
      dimension rat(3,natx)

c     Unique potential input data
c     iatph(0:nphx)  - given unique pot, which atom is model?
c                      (0 if none specified for this unique pot)
      dimension iatph(0:nphx)
c     xnatph(0:nphx) - given unique pot, how many atoms are there
c                      of this type? (used for interstitial calc)
      dimension xnatph(0:nphx), spinph(0:nphx)
c     potlbl(0:nphx)    -   label for user convienence
      character*6 potlbl(0:nphx)

c     folp(0:nphx) -  overlap factor for rmt calculation
      dimension folp(0:nphx)
c     novr(0:nphx) -  number of overlap shells for unique pot
      dimension novr(0:nphx)
c     iphovr(novrx,0:nphx) -  unique pot for this overlap shell
      dimension iphovr(novrx,0:nphx)
c     nnovr(novrx,0:nphx) -   number of atoms in overlap shell
      dimension nnovr(novrx,0:nphx)
c     rovr(novrx,0:nphx)  -   r for overlap shell
      dimension rovr(novrx,0:nphx)

c     Free atom data
c     xion(0:nphx)  - ionicity, input
      dimension xion(0:nphx)
c     iz(0:nphx)    - atomic number, input
      dimension iz(0:nphx)

c     Overlap calculation results
c     edens(251,0:nphx)   -   overlapped density*4*pi
      dimension edens(251,0:nphx)
c     vtot (251,0:nphx)   -   overlapped total potential
      dimension vtot (251,0:nphx), vclap (251,0:nphx)

c     Muffin tin calculation results
c     imt(0:nphx)  -  r mesh index just inside rmt
      dimension imt(0:nphx), inrm(0:nphx), folpx(0:nphx)
c     rmt(0:nphx)  -  muffin tin radius
      dimension rmt(0:nphx)
c     rnrm(0:nphx)  -  Norman radius
      dimension rnrm(0:nphx), qnrm(0:nphx)
      dimension xnmues(0:lx,0:nphx)
      real rfms2
      integer ipol, ispin, lfms2
      complex*16 ptz
      dimension ptz(-1:1, -1:1)
      dimension lmaxph(0:nphx)

c     PHASE output
c     eref(nex, nspx)         -     interstitial energy ref
      complex*16 eref(nex, nspx)
c     ph(nex,-ltot:ltot,nspx,0:nphx) - phase shifts
      complex*16 ph( nex, -ltot:ltot, nspx, 0:nphx)
c     lmax(0:nphx)      -     number of ang mom levels
      dimension lmax(0:nphx)

      character*80 title(nheadx)

      complex*16  em(nex)
      complex*16  rkk(nex,8,nspx), xsec(nex,nspx)
      dimension xsnorm(nex, nspx)
      dimension dgc0(251), dpc0(251)

c     additioal data needed for relativistic version
      dimension dgc(251,30,0:nphx), dpc(251,30,0:nphx)
      dimension adgc(10,30,0:nphx), adpc(10,30,0:nphx)
      dimension dgcn(nrptx,30), dpcn(nrptx,30)
      dimension edenvl(251,0:nphx), eorb(30), kappa(30)
      dimension vvalgs (251,0:nphx), xnval(30,0:nphx), iorb(-4:3,0:nphx)

c     nrx = max number of r points for phase and xsect r grid
      parameter (nrx = nrptx)
      dimension ri(nrptx), vtotph(nrx), rhoph(nrx)
      dimension  dmagx(nrptx), dmag(251,0:nphx)
      dimension dgcx(nrptx), dpcx(nrptx), vvalph(nrx), rhphvl(nrx)
      dimension vch (251), vchp(nrx)

      logical lopt
      character*512 slog

c     Josh - Added iPl for PLASMON card, and iexist for mpse.dat
      integer iPl, iexist
      

   10 format (4x, a, i5)

c     Phase shift calculation
c     Atom r grid
      dx = 0.05d0
      x0 = 8.8d0
c     Phase r grid
      dxnew = rgrd

      call rdpot ( ntitle, title, rnrmav, xmu, vint, rhoint,
     1                  emu, s02, erelax, wp, ecv,rs,xf, qtotel,
     2                  imt, rmt, inrm, rnrm, folp, folpx, xnatph,
     3                  dgc0, dpc0, dgc, dpc, adgc, adpc,
     3                  edens, vclap, vtot, edenvl, vvalgs, dmag, xnval,
     4                  eorb, kappa, iorb, qnrm, xnmues, nohole, ihole,
     5                  inters, totvol, iafolp, xion, iunf, iz, jumprm)
c      lopt=true for the Rivas code of optical constants
       lopt = .false.
       if (lopt) call getedg(ihole,iz(0), emu)
       if (lopt) ik0 = 1
       if (lopt) then
         call wlog('   Fixing edge energy from Elam table...')
         write(slog,fmt="('   emu = ',f10.3,' eV')") emu*hart
         call wlog(slog)
       endif

       do 15 iph = 0, nph
 15    novr(iph) = 0

c  update header, since e.g. one may use diff ixc for the same potential
        call sthead (ntitle, title, nph, iz, rmt, rnrm,
     1          xion, ihole, ixc,
     2          vr0, vi0, gamach, xmu, xf, vint, rs,
     2          nohole, lreal, rgrd)
c     Make energy mesh
      edge = xmu - vr0
      if (.not.lopt) emu = emu - vr0

cc    manual input. Later make TDLDA and PMBSE cards
cc    TDLDA ifxc  (izstd=1 if TDLDA card is present)
c     izstd = 0
c     ifxc = 0
cc    PMBSE  ipmbse  nonlocal ifxc itdlda
c     ipmbse = 2
c     ibasis = 2
cc    ipmbse=0 (do not run); 1-LF only; 2-PM only; 3-combined; 
cc           4-combined with s-function kernel splitting
c     nonlocal = 0
cc    nonlocal = 0 (local fxc); 1-read W from pot.ch; 2-from yoshi.dat
c     itdlda = 2
cc    itdlda = 0, 1, 2 should be run in sequence
cc    end of manual input

c     check that logic is set up correctly
      if (ipmbse.le.0) itdlda = 0
      if (nohole.lt.0) then
c       core-hole potential is used already
        if (ifxc.ne.0) then
          call wlog(' Reset ifxc=0 since NOHOLE card is absent')
          ifxc = 0
          if (ipmbse.gt.0) nonlocal = 0
        endif
        if (ipmbse.eq.3 .and. izstd.eq.0) then
          call wlog(' Reset ipmbse=1 since NOHOLE card is absent')
          ipmbse = 1
        endif
      endif
      if (izstd.gt.0 .and. itdlda.gt.0) then
c       no need run PMBSE in this case
        call wlog(' Ignored PMBSE cards since TDLDA is present')
        itdlda = 0
      endif
      if (ipmbse.eq.2 .and. nonlocal.gt.0 .and. ifxc.gt.0) then
c       accounting for core-hole twice. reset ifxc=0
        call wlog(' Reset ifxc=0 since core-hole potential is used.')
        ifxc = 0
      endif
      if (ipmbse.eq.1 .and. nonlocal.gt.0) then
c       V_ch should be zero
        nonlocal = 0
      endif

c     Josh - if nohole = 2, read wscrn.dat and add ch pot to vtot.
c     Need to add file check and emesh check.
      if (nohole.eq.2)  then
         open (unit=13, file='wscrn.dat', status='old', iostat=ios)
         call chopen (ios, 'wscrn.dat', 'ffmod2(xsph)')
         open (unit=14, file='vtot.dat', status='replace',iostat=ios)
         call chopen (ios, 'vtot.dat', 'ffmod2(xsph)')
         do i = 1, 251
            read(13,'(2e20.10)',end=20) dum1, dum2
            dum3 = vtot(i,0)
            vtot(i,0) = vtot(i,0) - dum2
            write(14,'(3e20.10)') dum1, dum3, dum2
         end do
 20      continue
         nohole = 0
         close(13)
         close(14)
      end if
c     Josh END
      
      if (itdlda.eq.0)  then 
!     Josh - Replaced call to phmesh with phmesh2, which allows user
!     defined grids read from grid.inp. Details can be found in phmesh2.f
!         call phmesh2 (ipr2, ispec, edge, emu, vi0, gamach, xkmax,
!     &        xkstep, vixan, ne, ne1, em, ik0, ne3,iGrid)
        call phmesh (ipr2, ispec, edge, emu, vi0, gamach, ecv,
     1                 xkmax, xkstep, vixan, ne, ne1, em, ik0, ne3)
      else
c       nesvi TDLDA
        call meshlda (xkstep, ne, ne1, em, ik0)
        corr = 1.0
      endif

      if (itdlda.eq.1) then
c       to get the mesh only
        do 93  i = 1, ne1
          write(3,94) dble(em(i))*hart
 94       format (7f10.5)
 93     continue
        stop 'TDLDA energy mesh is written out'
c       end of itdlda=1 calculations
      endif

c     Make old grid to report distances in xsect.bin
      do 95 i = 1, 251
 95   ri(i) = exp(-x0+dx*(i-1))

c     open xsect.bin and write the header
      open (unit=1, file='xsect.bin', status='unknown', iostat=ios)
      call chopen (ios, 'xsect.bin', 'potph')
      call wthead (1, ntitle, title)
c skip old output in title ( title lines are above ------ )
c     write(1,*) 'vtot in eV, rho in code units, includes 4pi'
c     write(1,*) 'ipot, vtot(imt), rho(imt) '
c     write(1,122) 'interstitial', vint*hart, rhoint
c     do 386  iph = 0, nph
c        write(1,123)iph,vtot(imt(iph),iph)*hart,edens(imt(iph),iph)
c 386 continue
c 122 format (1x, a, 1p, 2e20.6)
c 123 format (i10, 1p, 2e20.6)
c     write(1,42)  emu*hart
c  42 format ('       edge ', 2f20.5)
c     write(1,*)  imt(0), ' imt(0)'
c     write(1,200)  vint*hart, rhoint, ri(imt(0)+1)
c 200 format ('  v, rho, r', /, 1p, 3e20.4, ' intersitial')
c     do 220  iii = imt(0), imt(0)-4, -1
c        write(1,210)  vtot(iii,0)* hart, edens(iii,0), ri(iii), iii
c 210 format (1p, 3e20.4, i6)
c 220 continue

      write(1,45)
   45 format (1x, 71('-'))
      write(1,55) s02, erelax, wp, edge, emu
   55 format ( 3e13.5, 2e15.7, ' method to calculate xsect')
      write(1,56) gamach*hart, ne1, ik0
   56 format (1p, e15.7, 2i4,
     1       ' gamach in eV, # of points on horizintal axis')
      write(1,57)
   57 format ('        em              xsnorm            xsec  ')
c     end of the xsect.bin header

c     nsp = 1 - spin average caclulations; 2 - spin up and down
      nsp = 1
      if (abs(ispin).eq.1) nsp = nspx
c     scale spin density on each atom appropriately
      do iph = 0, nph
       do i = 1, 251
         dmag(i,iph) = dmag(i, iph) * spinph(iph)
       enddo
      enddo

      do 300 isp = 1, nsp
        if (ispin.ne.0) then
c         make spin dependent potential if needed
c         isp = 1-spin-down; 2-spin-up potentials
          idmag = (-1)**isp
          if (nsp.eq.1) then
             idmag = 1
             if(ispin.lt.0) idmag=-1
          endif
          call  istprm (nph, nat, iphat, rat, iatph, xnatph,
     1               novr, iphovr, nnovr, rovr, folp, folpx, iafolp,
     1               edens, edenvl, idmag,
     2               dmag, vclap, vtot, vvalgs, imt, inrm, rmt, rnrm,
     3               ixc, rhoint,vint, rs, xf, xmu, xmunew,
     5               rnrmav, qtotel, inters, totvol)
          xmunew = xmu
          if (abs(ispin).eq.1 .and. nsp.eq.2) then
c           |ispinp| = |ispin|, but sign is determined by isp
             ispinp = abs(ispin)
             if (isp.eq.1) ispinp = -ispinp
          else
c            sign is determined by spin (always for ispin=-2,2)
             ispinp = ispin
          endif
        else
c         spin-independent case
          ispinp = 0
        endif

c       calculate operators of interest (s_z, l_z, t_z)
        xmuvr = xmu - vr0
        if (ipr2.ge.3) call szlz(ispinp,ecv,nph,nat,rgrd,nohole,rfms2,
     2     lfms2, lmaxph, edens, edenvl, dmag, vtot, vvalgs, rmt, rnrm,
     2     ixc, rhoint, vint, xmuvr, jumprm,
     3     xnval, iorb, x0, dx, xion, iunf, iz,
     5     adgc, adpc, dgc, dpc, ihole, rat, iphat, corr)
c    1                   em, ne1, ne, ik0 )

c       Cross section calculation, use phase mesh for now
c       Absorbing atom is iph=0
        write(slog,10) 'absorption cross section'
        call wlog(slog)
        iph = 0
        call fixvar (rmt(0), edens(1,0), vtot(1,0), dmag(1,0),
     1             vint, rhoint, dx, dxnew, jumprm,
     2             vjump, ri, vtotph, rhoph, dmagx)
        call fixdsx (iph, dx, dxnew, dgc, dpc, dgcn, dpcn)
        if (mod(ixc,10) .ge. 5) then
           if (jumprm .gt. 0) jumprm = 2
           call fixvar (rmt(0), edenvl(1,0), vvalgs(1,0), dmag(1,0),
     1             vint, rhoint, dx, dxnew, jumprm,
     2             vjump, ri, vvalph, rhphvl, dmagx)
           if (jumprm .gt. 0) jumprm = 1
        endif
        call fixdsp (dx, dxnew, dgc0, dpc0, dgcx, dpcx, jnew)
  
        if (itdlda.eq.0) then
c         Josh - added argument iPl to control many pole self energy
          call xsect (ipr2, dxnew, x0, ri, ne, ne1, ik0, em, edge,
     1       ihole, emu, corr, dgcx, dpcx, jnew,
     2       ixc0, lreal, rmt(0), rnrm(0), xmuvr, vi0, iPl,
     3       gamach, vtotph, vvalph, rhoph, dmagx, rhphvl, 
     4       dgcn, dpcn, adgc(1,1,iph), adpc(1,1,iph), xsec(1,isp),
     5       xsnorm(1,isp), rkk(1,1,isp), iz(0), xion(0), iunf,
     6       xnval(1,iph), izstd, ifxc, eorb, kappa, iorb(-4,iph), l2lp,
     7       ipol, ispinp, le2, angks,ptz)
        else
          if (nonlocal.gt.0) then
c           read potential with core-hole from a file
            if (nonlocal.eq.1) then
              call rdpotp(vch)
            elseif (nonlocal.eq.2) then
c             open (unit=3, file='MgO_Mgk.dat', status='old')
              open (unit=3, file='wscrn.dat', status='old')
c             open (unit=3, file='w_m5p.dat', status='old')
c             open (unit=3, file='ni_l2.dat', status='old')
c             open (unit=3, file='ni_l2_sp.dat', status='old')
              n=0
 338          n = n+1
                read(3,337, end=339) dum1, dum2
c               use frac.ne.1  to mix bare and screened ch pot
c                frac = 0.80
c                frac = 1.00
                vch(n) = -1.d0*dum2
 337            format(6e20.10)
                goto 338
 339          continue
              close (unit=3)
            endif
            call fixvar (rmt(0), edens(1,0), vch, dmag(1,0),
     1             vint, rhoint, dx, dxnew, jumprm,
     2             vjump, ri, vchp, rhoph, dmagx)
            do 333 i = 1, nrptx
               if (ri(i).lt.rmt(0)) then
                 if (nonlocal.eq.1) then
                   vchp(i) = vchp(i) - vtotph(i)
                 endif
               elseif (ri(i).lt.40.d0) then
c                 assume const/r behaviour
                  vchp(i) = vchp(i-1) * ri(i-1) / ri(i) 
               else
                  vchp(i) = 0
               endif
c           testing: write core-hole potential in fort.17
               if (ri(i).lt.40.d0) write(17,332) ri(i), vchp(i)
 332            format(2f30.5)
 333        continue
           
            close (unit=17)
c           itest = 2
c           if (itest.eq.2) stop
          else
            do 334 i =1, nrptx
 334        vchp(i) = 0
          endif
          
c         Josh - added argument iPl to control many pole self energy
          call xsectd (ipr2,dxnew, x0, ri, ne, ne1, ik0, em, edge,
     1       ihole, emu, corr, dgcx, dpcx, jnew,
     2       ixc0, lreal, rmt(0), rnrm(0), xmuvr, vi0, iPl,
     3       gamach, vtotph, vvalph,vchp, rhoph, dmagx, rhphvl,
     4       dgcn, dpcn, adgc(1,1,iph), adpc(1,1,iph), xsec(1,isp),
     5       xsnorm(1,isp), rkk(1,1,isp),iz(0), xion(0), iunf,
     6       xnval(1,iph), ipmbse, ifxc, ibasis, eorb, kappa,
     7       iorb(-4,iph), l2lp, ipol, ispinp, le2, angks,ptz, itdlda)
        endif


        do 60  iph = 0, nph
          write(slog,10) 'phase shifts for unique potential', iph
          call wlog(slog)
c         fix up variable for phase
          call fixvar (rmt(iph), edens(1,iph), vtot(1,iph), dmag(1,iph),
     1                vint, rhoint, dx, dxnew, jumprm,
     2                vjump, ri, vtotph, rhoph, dmagx)
          if (mod(ixc,10) .ge.5) then
            if (jumprm .gt. 0) jumprm = 2
            call fixvar (rmt(iph), edenvl(1,iph), vvalgs(1,iph),
     1                dmag(1,iph), vint, rhoint, dx, dxnew, jumprm,
     2                vjump, ri, vvalph, rhphvl, dmagx)
            if (jumprm .gt. 0) jumprm = 1
            call fixdsx (iph, dx, dxnew, dgc, dpc, dgcn, dpcn)
          endif
          if (iph .eq. 0)  then
            itmp = ihole
          else
            itmp = 0
          endif

          call phase (iph, dxnew, x0, ri, ne, ne1, ne3, em, ixc, nsp,
     1            lreal, rmt(iph),rnrm(iph), xmuvr, vi0, iPl,
     2            gamach, vtotph, vvalph, rhoph, dmagx, rhphvl,
     3            dgcn, dpcn, adgc(1,1,iph), adpc(1,1,iph), eref(1,isp),
     4            ph(1,-ltot,isp,iph), lmax(iph), iz(iph), itmp,
     5            xion(iph), iunf, xnval(1,iph), ispinp)
 60     continue

 300  continue

c     write main output to xsect.bin
  340 format (e17.9, 4e13.5)
      if (abs(ispin).ne.1 .or. nspx.eq.1) then
        do 350  ie = 1, ne
           write(1,340) dble(em(ie))*hart, dimag(em(ie))*hart,
     1                 xsnorm(ie,1), dble(xsec(ie,1)), dimag(xsec(ie,1))
  350   continue
      else
c       nspx = 2
        do 380  ie = 1, ne
           write(1,340) dble(em(ie))*hart, dimag(em(ie))*hart,
     1             (xsnorm(ie,1) + xsnorm(ie,nspx)) / 2.d0 ,
     2           dble( (xsec(ie,1) + xsec(ie,nspx)) ),
     3          dimag( (xsec(ie,1) + xsec(ie,nspx)) )
c          Normalize rkk to the average over up/down spin
c          nsp=2
           xnorm1 = sqrt( 2*xsnorm(ie,1) /
     1                         (xsnorm(ie,1) + xsnorm(ie,nspx)) )
           xnorm2 = sqrt( 2*xsnorm(ie,nspx) /
     1                         (xsnorm(ie,1) + xsnorm(ie,nspx)) )
           do 360 kdif = 1,8
             rkk (ie, kdif, 1) = rkk (ie, kdif, 1) * xnorm1
             rkk (ie, kdif, nspx) = rkk (ie, kdif, nspx) * xnorm2
  360      continue
  380   continue
      endif
      close (unit=1)

c     disable for now since dimensions are different
      if (ipr2 .ge. 2)  then
         call wphase (nph, em, eref, lmax, ne, ph, ntitle, title)
      endif

c     Write out phases for paths and genfmt
      call wrxsph (nsp, ne, ne1, ne3, nph, ihole, rnrmav, xmuvr,
     &     edge,ik0,em, eref, lmax, iz, potlbl, ph, rkk)

      if (ipr2 .ge. 1) then
c       calculate axafs
c       axafs does not make sense for |ispin| = 1
        call axafs (em, emu, xsec(1,1), ne1, ik0)
      endif

      return
      end
      subroutine szlz (ispin, ecv, nph, nat, rgrd, nohole, rfms2, lfms2,
     2           lmaxph, edens, edenvl, dmag, vtot, vvalgs, rmt, rnrm,
     2           ixc, rhoint, vint, xmu, jumprm,
     3           xnval, iorb, x0, dx, xion, iunf, iz,
     5           adgc, adpc, dgc, dpc, ihole, rat, iphat, corr)


c     Finds new Fermi level (xmu), electron counts 

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
      integer ispin

c     input
      dimension dmagx(nrptx), dmag(251,0:nphx+1)
      dimension vtot (251,0:nphx), vvalgs (251,0:nphx)
      dimension rmt(0:nphx),rnrm(0:nphx)
      dimension xnval (30,0:nphx), iorb (-4:3,0:nphx)
      dimension ri(nrptx)
      dimension iz(0:nphx), xion(0:nphx), lmaxph(0:nphx)
      dimension rat(3,natx),iphat(natx)
      real  rfms, rfms2
c     input and output
      dimension edens(251,0:nphx), edenvl(251,0:nphx)

c     work space
      dimension xnmues(3,0:lx,0:nphx)
      complex*16 fl(3,0:lx,0:nphx), fr(3,0:lx,0:nphx)
      complex gtr(2,2, 3,0:lx, 0:nphx)
      real amat(-lx:lx,2,2, 3,0:lx), gctr(2,2, 3,0:lx,0:nphx)
      dimension dum(nrptx), vtotph(nrptx),vvalph(nrptx)
      dimension dgc(251,30,0:nphx+1), dpc(251,30,0:nphx+1)
      dimension adgc(10,30,0:nphx+1), adpc(10,30,0:nphx+1)
      dimension dgcn(nrptx,30), dpcn(nrptx,30)
      complex*16 xrhoce(-4:3, -4:3, 0:nphx), xrhole(-4:3, -4:3, 0:nphx)
      complex*16 ph(lx+1, 0:nphx)
      integer iph
c     complex energy grid emg is decomposed into em and eref
      parameter (negx = 80)
      complex*16 emg(negx), em, eref, ee, ep, cchi, de
c     nflrx should be odd and defines the max of Im energy for
c     the countour 
      parameter (nflrx = 17)
      dimension step(nflrx)
      character*512 slog

      call setkap(ihole, kinit, linit)

      if (ispin.eq.0) then
        write (slog,8)
   8    format('              N_l, N_j- and N_j+ calculation')
        write (slog,9)
   9    format('              ONLY central atom contribution! ')
      elseif (abs(ispin).le.1) then
        write (slog,10)
  10    format('              S_z, L_z and t_z calculation')
      else 
        write (slog,11)
  11    format('              S_z, N_l and N_j calculation')
      endif
      call wlog(slog)

      call wlog (' Calculating energy and space dependent l-DOS.')
      call wlog (' It takes time ...')

c     calculate energy independent matrix of angular coefficients
      call acoef(ispin, amat)

      call grids (ecv, xmu, negx, neg, emg, step, nflrx)

c     ie - is number of energy points calculated
      ie = 0
      ee = emg(1)
      ep = dble(ee)
      do 22 iph=0,nphx
      do 22 il=0,lx
      do 22 i=1,3
        xnmues(i, il,iph) = 0
  22  continue

c     Start the cycle over energy points (ie)
  25  continue
      ie = ie + 1

      if (ie.eq.1 .or. mod(ie,20).eq.0) then
         write(slog,30) ie, dble(ee)*hart
   30    format('     point # ', i3, '  energy = ', f7.3)
         call wlog(slog)
      endif

      do 100  iph = 0, nph

         call fixvar (rmt(iph),edens(1,iph),vtot(1,iph),dmag(1,iph),
     1                vint, rhoint, dx, rgrd, jumprm,
     2                vjump, ri, vtotph, dum, dmagx)
         if (mod(ixc,10) .ge.5) then
            if (jumprm .gt. 0) jumprm = 2
            call fixvar (rmt(iph), edenvl(1,iph), vvalgs(1,iph),
     1                dmag(1,iph), vint, rhoint, dx, rgrd , jumprm,
     2                vjump, ri, vvalph, dum, dmagx)
            if (jumprm .gt. 0) jumprm = 1
         endif

         call fixdsx (iph, dx, rgrd , dgc, dpc, dgcn, dpcn)
        jri = (log(rmt(iph)) + x0) / rgrd + 2
        jri1 = jri+1
        eref = vtotph(jri1)
        do 40 i = 1, jri1
  40    vtotph(i) = vtotph(i) - eref
        if (ixc.ge.5) then
           do 50 i = 1, jri1
  50       vvalph(i) = vvalph(i) - eref
        else
           do 60 i = 1, jri1
  60       vvalph(i) = vtotph(i)
        endif

         itmp = 0
c        icount=1 for Renormalized atom counts
c        icount=2 for Mulliken counts
         icount = 0
         if (iph.eq.0 .and. nohole.lt.0) itmp = ihole
         if (icount.gt.0) then
            call rholat( icount, rgrd, x0, ri, ee,
     2           ixc, rmt(iph), rnrm(iph),
     3           vtotph, vvalph, xnval(1,iph), iorb(-4,iph),
     3           dgcn, dpcn, eref,
     4           adgc(1,1,iph), adpc(1,1,iph), xrhole(-4,-4,iph),
     5           xrhoce(-4,-4,iph), ph(1,iph),
     6           iz(iph), xion(iph), iunf, itmp,3)
         else
            call rholsz( rgrd, x0, ri, ee,
     2           ixc, rmt(iph), rnrm(iph),
     3           vtotph, vvalph, xnval(1,iph), dgcn, dpcn, eref,
     4           adgc(1,1,iph), adpc(1,1,iph), xrhole(-4,-4,iph),
     5           xrhoce(-4,-4,iph), ph(1,iph),
     6           iz(iph), xion(iph), iunf, itmp,3)
         endif
  100 continue

c     Write out phases for fmssz
c     transform neg,emg to em,ne,eref first
      em= dble(ee)
      eref=dble(eref)-coni*dimag(ee)

cc    call fms for a cluster around central atom
      do 195 iph0 = 0,nph
      do 195 il = 0, lx
      do 195 i = 1, 3
      do 195 i2= 1, 2
      do 195 i1= 1, 2
         gtr( i1,i2, i, il, iph0) = 0
         gctr(i1,i2, i, il, iph0) = 0
  195 continue

      rfms = 0
c     only central atom contribution for ispin = 0
ctemp if (ispin.ne.0)  rfms = rfms2
      rfms = rfms2

      if (lfms2 .ne. 0) then
        iph0 = 0
        call fmssz( iph0, ie,  em, eref, ph, iz, nph,
     1        rfms, lfms2, nat, iphat, rat, amat, lmaxph, gctr, gtr)
      else
        do 190 iph0 = 0, nph 
  190   call fmssz( iph0,  ie, em, eref, ph, iz, nph,
     1        rfms, lfms2, nat, iphat, rat, amat, lmaxph, gctr, gtr)
      endif

      de = ee-ep
      do 300 iph = 0,nph
      do 300 lpp = 0,lx
      do 300 iop = 1,3
c       calculate density and integrated number of electrons in each
c       channel for each type of atoms density, etc.
        if (ie.gt.1) fl(iop,lpp,iph) = fr( iop,lpp,iph)
        fr( iop,lpp,iph) = 0
        call kfromi (1, lpp, j1, kk1)
        call kfromi (2, lpp, j1, kk2)
        do 200 i1=1,2
        do 200 i2=1,2
          call kfromi (i1, lpp, j1, k1)
          call kfromi (i2, lpp, j1, k2)
          if (k1.eq.0 .or. k2.eq.0) goto 200

          cchi =  dble( real( gtr(i1,i2, iop,lpp,iph) )) + 
     1           coni* dble(aimag( gtr(i1,i2, iop,lpp,iph) ))
c         fr( iop,lpp,iph) = fr( iop,lpp,iph) + cchi * xrhole(k1,k2,iph)
c         use above kk1,kk1 for j- value, kk2,kk2 for j+ value
          if (ispin.ne.0 .or. iop.eq.1) then
            fr( iop,lpp,iph) = fr( iop,lpp,iph) + cchi*xrhole(k1,k2,iph)
          elseif(iop.eq.2) then
            fr( iop,lpp,iph) = fr( iop,lpp,iph)+cchi*xrhole(kk1,kk1,iph)
          elseif(iop.eq.3) then
            fr( iop,lpp,iph) = fr( iop,lpp,iph)+cchi*xrhole(kk2,kk2,iph)
          endif

c         add central atom part
          cchi =  dble(  gctr(i1,i2, iop,lpp,iph) ) 
          if (ispin.ne.0 .or. iop.eq.1) then
            fr( iop,lpp,iph) = fr( iop,lpp,iph) + cchi*xrhoce(k1,k2,iph)
c           use above k1,k1 for j- value, k2,k2 for j+ value
          elseif(iop.eq.2) then
            fr( iop,lpp,iph) = fr( iop,lpp,iph)+cchi*xrhoce(kk1,kk1,iph)
          elseif(iop.eq.3) then
            fr( iop,lpp,iph) = fr( iop,lpp,iph)+cchi*xrhoce(kk2,kk2,iph)
          endif
 200    continue

c       do integral over energy with trapezoidal rule
        if (ie.eq.1)  fl( iop,lpp,iph) = fr( iop,lpp,iph)
        xnmues(iop,lpp,iph) =  xnmues(iop,lpp,iph) +
     1  dimag((fl(iop,lpp,iph) + fr(iop,lpp,iph)) * de /2)
        if (ie.eq.neg) then
c          end point correction
           xnmues(iop,lpp,iph) =  xnmues(iop,lpp,iph) +
     1     dimag( fr(iop,lpp,iph) * (dble(ee)-ee) )
        endif

  300 continue

c     next energy point
      if (ie.lt.neg) then
         ep = ee
         ee = emg(ie+1)
         goto 25
      endif

c     report configuration; repeat iteration if found bad counts.
      call wlog('  Electronic configuration')
      call wlog('  Electronic configuration:Mulliken counts')
      if (ispin.eq.0) then
         call wlog('   iph    il      N_l   N_j-  N_j+')
      elseif (abs(ispin).eq.1) then
         call wlog('   iph    il      S_z   L_z   T_z')
      else
         call wlog('   iph    il      S_z   N_l   N_j')
      endif
 310  format (2i6, 3f9.4)
      do 320 ip= 0,nph
      do 320 il = 0,lx
         write (slog,310) ip,il,(xnmues(i,il,ip), i=1,3)
         call wlog(slog)
 320  continue
      corr = 1.d0
      if (ispin.eq.0 .and. kinit.ne.-1) then
c       calculation  changes in counts due to spin-orbit interaction
        ip = 2
        if (kinit.lt.0) ip = 3
        il = linit + 1
        if (linit.eq.3) il = linit - 1
        corr = xnmues(1,il,0) /xnmues (ip,il, 0)
      endif

      return
      end
      subroutine acoef(ispin, amat)
c     performs the sum of the product of 4 3j symbols
c       ispin - type of spin calculation
c       amat  - matrix to calculate density via
c             \mu=\mu_at*(1- Im \sum_kp,kpp rkk(kp)*rkk(kpp)*
c                         \sum_m1,m2 bmat(kp,kpp,m1,m2)*G_lp,m2;lpp,m1 )

      implicit double precision (a-h,o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      integer ispin

      real  amat(-lx:lx,2,2, 3,0:lx)
      real t3j(0:lx,0:lx,0:1), operls (0:1, 0:1, 3)
      real xms, xml, xmj

      external cwig3j

      do 10 i5 =  0,lx
      do 10 i4 =  1,3 
      do 10 i3 =  1,2
      do 10 i2 =  1,2
      do 10 i1 = -lx,lx
         amat(i1,i2,i3,i4,i5)=0
  10  continue
      ms = 1
      if (ispin.lt.0) ms=0
      print*, ' Spin = ', 2*ms-1

      do 100 ml = -lx, lx
        mj = 2*ml + (2*ms-1)
        xmj = 0.5e0*mj
        mj = -mj
c       mj is conserved for all operators of interst (s_z, l_z, t_z)
c       tabulate necessary Clebsh-Gordon coefficients
        do 20 lp = 0,lx
        do 20 jp = 0,lx
        do 20 mp = 0,1
           lp2 = 2*lp
           jp2 = 2*jp+1
           mp2 = 2*mp-1
           t3j(lp,jp,mp) = (-1)**lp *sqrt(jp2+1.e0) * 
     1                    real( cwig3j ( 1, jp2, lp2, mp2, mj, 2) )
 20     continue

        do 90 lpp = 0,lx
          do 30 m1=0,1
          do 30 m2=0,1
          do 30 iop=1,3
            operls(m1,m2,iop) = 0
            if (m1.eq.m2) then
              xms =  m1 - 0.5e0
              xml = xmj-xms
              if (abs(ml+ms-m1).le.lpp) then
                if (ispin.eq.0) then
c                 occupation numbers N_l, N_j- , N_j+
                  operls(m1,m2,iop) = 2
                elseif (iop.eq.1) then
c                 s_z operator in ls basis
                  operls(m1,m2,iop) = xms
                elseif (iop.eq.2 .and. abs(ispin).eq.1) then
c                 l_z operator
                  operls(m1,m2,iop) = xml
                elseif (iop.eq.2 .and. abs(ispin).eq.2) then
c                 unit operator for occupation numbers
                  operls(m1,m2,iop) = 1
                elseif (iop.eq.3 .and. abs(ispin).eq.1) then
c                 t_z operator
                  operls(m1,m2,iop) = xms*2*(3*xml**2-lpp*(lpp+1))
     1                                /(2*lpp+3) /(2*lpp-1)
                elseif (iop.eq.3 .and. abs(ispin).eq.2) then
c                 occupation number for j=l+1/2
                  operls(m1,m2,iop) = t3j(lpp,lpp,m1)**2
                endif
              endif
            else
c             t_z only has nonzero off diagonal matrix elements 
              if (iop.eq.3 .and. abs(ispin).le.1 .and.
     1        nint( 0.5e0+abs(xmj)).lt.lpp)  then
                 operls(m1,m2,iop)=3*xmj*
     1           sqrt(lpp*(lpp+1)-(xmj**2-0.25e0)) /(2*lpp+3) /(2*lpp-1)
              elseif (iop.eq.3 .and. abs(ispin).gt.1) then
                 operls(m1,m2,iop)= t3j(lpp,lpp,m1)* t3j(lpp,lpp,m2)
              endif
            endif
  30      continue

c         calculate energy and r independent matrix amat
c         which is equivalent to integration over angular coordinates
c         for assumed density matrix
          do 80 i1=1,2
             call kfromi(i1,lpp,jj,k1)
             if (k1.eq.0) goto 80
             do 70 i2=1,2
                call kfromi(i2,lpp,jp,k2)
                if (k2.eq.0) goto 70
                do 60 iop=1,3
                do 60 m2=0,1
                do 60 m1=0,1
                  amat(ml,i1,i2,iop,lpp) =  amat(ml,i1,i2,iop,lpp) +
     1            operls(m1,m2,iop) * t3j(lpp,jp,ms)* t3j(lpp,jp,m1)*
     2            t3j(lpp,jj,m2)*t3j(lpp,jj,ms)
  60            continue
  70         continue
  80      continue
  90    continue
 100  continue

      return
      end

      subroutine kfromi (i, lpp, jj, k)
c     input index i1 and orb. mom. lpp
c     output: final state kappa - k; jj=tot.mom(k)-1/2
      integer i, lpp, jj, k

      jj = lpp + i - 2
      k = - lpp - 1
      if (i.eq.1) k = lpp

      return
      end
      subroutine fmssz( iph0, ie, em, eref, ph, iz, nph,
     1           rfms, lfms, nat, iphat, rath, amat, lipotx, gctr, gtr)
c     uses Bruce Ravel subroutine to do FMS in self-consistency loop
c     written by alexei ankudinov 06.1997

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     input
      dimension iphat(natx), rath(3,natx)
      real rat(3,natx), rfms
      real rpart,aipart
      integer nph
      dimension iz(0:nphx)

c     work space
      complex*16 ph(lx+1, 0:nphx)
      integer iph
      complex*16 em, eref
      character*512 slog
c     fms staff
      integer lipotx(0:nphx)
      complex gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphx)
      complex gtr(2,2, 3,0:lx, 0:nphx)
      real amat(-lx:lx,2,2, 3,0:lx), gctr(2,2, 3,0:lx, 0:nphx)
      complex xphase(nspx, -lx:lx, 0:nphx), ck(nspx)
      complex*16 dck
      real  rdirec, toler1, toler2
      logical lcalc
      dimension lcalc(0:lx)
      save

      if (rfms .gt. 0) then
        do 25 iat=1,nat
        do 25 j=1,3
   25   rat(j,iat) = real (rath(j,iat))

c       transform to single precision
        minv = 0
        rdirec = 2*rfms
        toler1 = 0.e0
        toler2 = 0.e0


c       it will be nice to call yprep once for all energy points,
c       fix later, and now call it every time
        if (ie.eq.1 .or. lfms.eq.0) 
     1    call yprep(iph0, nat, inclus, nph, iphat, rfms, rat,
     2       iz, rdirec)

        if (inclus.gt.1) then
cc        call fms for a cluster around central atom
          if (ie.eq.1) then
             write (slog,35) inclus, iph0
  35         format ('        Doing FMS for a cluster of ',i3,
     1       ' atoms around iph = ',i2)
             call wlog (slog)
          endif

          dck=sqrt(2*(em-eref))
          rpart  = real(dble(dck))
          aipart = real(dimag(dck))
          ck(1) = cmplx(rpart, aipart)
          do 50 ipp = 0,nph
            do 40 ill = -lipotx(ipp), lipotx(ipp)
              rpart  = real(dble( ph(abs(ill)+1,ipp)))
              aipart = real(dimag(ph(abs(ill)+1,ipp)))
              xphase(1, ill, ipp) = cmplx(rpart, aipart)
  40        continue
  50      continue
          iverb=0
          if (ie.eq.1) iverb = 1
c         neglect spin-flip processes (fix later for ispin=1)
          nsp = 1
          ispin = 0
          do 55 ill = 0, lx
  55      lcalc(ill) = .true.
          call fms(lfms, nsp, ispin, inclus, nph, ck, lipotx, xphase,ie,
     1     iverb, minv, rdirec, toler1, toler2, lcalc,gg)
        endif
      endif

      do 200 ip=0,nph

        if (lfms.ne.0 .or. ip.eq.iph0) then
          do 190 lpp =0,lipotx(ip)
             ix1 = lpp**2 
             do 170 im=1,2*lpp+1
c              now cycle over gtr dimensions
               do 100 iop = 1,3
               do 100 i2 = 1,2
               do 100 i1 = 1,2
                 if (rfms.gt.0 .and. inclus.gt.0) gtr(i1,i2,iop,lpp,ip)= 
     1             gtr(i1,i2,iop,lpp,ip) + amat(im-lpp-1,i1,i2,iop,lpp)
     2             * gg(ix1+im,ix1+im,ip)
                 gctr(i1, i2, iop,lpp,ip)= gctr(i1, i2, iop,lpp,ip)
     1             + amat(im-lpp-1,i1,i2,iop,lpp)
 100           continue
 170         continue
 190      continue
        endif
 200  continue

      return
      end
      subroutine rholsz ( dx, x0, ri, em,
     2                  ixc, rmt, rnrm,
     3                  vtot, vvalgs, xnval, dgcn, dpcn, eref,
     4                  adgc, adpc, xrhole, xrhoce, ph,
     i                  iz, xion, iunf, ihole, lmaxsc)

      implicit double precision (a-h, o-z)

c     INPUT
c     dx, x0, ri(nr)
c                  Loucks r-grid, ri=exp((i-1)*dx-x0)
c     ne, em(ne)   number of energy points,  complex energy grid
c     ixc          0  Hedin-Lunqist + const real & imag part
c                  1  Dirac-Hara + const real & imag part
c                  2  ground state + const real & imag part
c                  3  Dirac-Hara + HL imag part + const real & imag part
c                  5  Dirac-Fock exchange with core electrons +
c                     ixc=0 for valence electron density
c     rmt          r muffin tin
c     rnrm         r norman
c     vtot(nr)     total potential, including gsxc, final state
c     dgcn(dpcn)   large (small) dirac components for central atom
c     adgc(adpc)   their development coefficients
c
c     OUTPUT
c     xrhole(0:lx)  integral over r of density function
c     xrhoce(0:lx)  the same integral for embedded atom only


c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     max number allowed in xsect r-grid
      parameter (nrx = nrptx)

c     output
      complex*16  xrhole(-4:3,-4:3)
      complex*16  xrhoce(-4:3, -4:3)
      complex*16  ph(lx+1)

      dimension ri(nrptx), ri05(251)
      dimension  vtot(nrptx), vvalgs(nrptx)
      complex*16 vtotc(nrptx), vvalc(nrptx)
      dimension xnval(30), dgcn(nrptx,30), dpcn(nrptx,30)
      dimension adgc(10,30), adpc(10,30)

c     energy grid in complex e-plane
      complex*16 em, eref

c     work space for dfovrg: regular and irregular solutions
      complex*16 pr(nrx,2,2), qr(nrx,2,2), pn(nrx,2,2), qn(nrx,2,2)

      complex*16  p2, xkmt, ck, xck
      complex*16  pu, qu
      complex*16  xfnorm, xirf, xmp, xpm
      complex*16  temp,  phx, phm(2,2), factor

      complex*16 jl,jlp1,nl,nlp1
      complex*16  xpc(nrx)

c     initialize
      lmax=lmaxsc
      if (lmax.gt.lx) lmax = lx
      if (iz.le.4) lmax=2
      if (iz.le.2) lmax=1
      do 20 i = 1, nrptx
         vtotc(i)=vtot(i)
         vvalc(i)= vvalgs(i)
  20  continue
c     set imt and jri (use general Loucks grid)
c     rmt is between imt and jri (see function ii(r) in file xx.f)
      imt  = (log(rmt) + x0) / dx  +  1
      jri  = imt+1
      if (jri .gt. nrptx)  call par_stop('jri .gt. nrptx in phase')
      inrm = (log(rnrm) + x0) / dx  +  1
      jnrm = inrm+1

c     set limits for tabulations
      nr05= (log(rnrm) + x0) / 0.05d0 + 5
      if (nr05.gt.251) nr05 = 251
c     ilast is the last integration point
c     it is larger than jnrm for better interpolations
      ilast = nint( (nr05-1) *0.05d0 / dx ) + 1
      if (ilast.gt.nrptx) ilast=nrptx

      do 10 i = -4,3
      do 10 j = -4,3
         xrhole(i,j) = 0
         xrhoce(i,j) = 0
  10  continue
      do 15 i=1,lx+1
  15  ph(i) = 0

c     p2 is 0.5*(complex momentum)**2 referenced to energy dep xc
c     need hartree units for dfovrg
      p2 = em - eref
      if (mod(ixc,10) .lt. 5) then
        ncycle = 0
      else
        ncycle = 3
      endif
      ck = sqrt(2*p2 + (p2*alphfs)**2)
      xkmt = rmt * ck

      do 200 lll=0,lmax
        do 199 jd = 0,1
          ikap = (lll+jd)* (-1)**jd
          if (ikap.eq.0) goto 199

          ilp = lll + 1
          if (ikap.gt.0) ilp = lll - 1
          im = 1+ jd

          do 150 j = 1, 2
            ic3 = j-1
            if (lll.eq.0 .and. ic3.eq.1) goto 150

            irr = -1
            call dfovrg ( ncycle, ikap, rmt, ilast, jri, p2, dx,
     $                ri, vtotc, vvalc, dgcn, dpcn, adgc, adpc,
     $                xnval, pu, qu, pn(1,im,j), qn(1,im,j),
     $                iz, ihole, xion, iunf, irr, ic3)
            
            call exjlnl (xkmt, lll, jl, nl)
            call exjlnl (xkmt, ilp, jlp1, nlp1)
            call phamp (rmt, pu, qu, ck,  jl, nl, jlp1, nlp1, ikap,
     1                  phx, temp)
            if (lll.eq.0)  ph(1)=phx
            phm(im,j) = phx

c           Normalize final state  at rmt to
c           rmt*(jl*cos(delta) - nl*sin(delta))
            xfnorm = 1 / temp
c           normalize regular solution
            do 133  i = 1,ilast
              pr(i,im,j)=pn(i,im,j)*xfnorm
              qr(i,im,j)=qn(i,im,j)*xfnorm
  133       continue

c          find irregular solution
            irr = 1
            pu = ck*alphfs
            factor = pu/(1+sqrt(1+pu**2))
            if (ikap.lt.0) factor = -factor
c           set pu, qu - initial condition for irregular solution at ilast
c           qu=(nlp1*cos(phx)+jlp1*sin(phx))*pu *rmt
c           pu = (nl*cos(phx)+jl*sin(phx)) *rmt
            qu=(nlp1*cos(phx)+jlp1*sin(phx))* factor *rmt 
            pu = (nl*cos(phx)+jl*sin(phx)) *rmt 

            call dfovrg (ncycle, ikap, rmt, ilast, jri, p2, dx,
     1              ri, vtotc,vvalc, dgcn, dpcn, adgc, adpc,
     1              xnval, pu, qu, pn(1,im,j), qn(1,im,j),
     1              iz, ihole, xion, iunf, irr, ic3)
cc            set N- irregular solution , which is outside
cc            N=(nlp1*cos(ph0)+jlp1*sin(ph0))*factor *rmt * dum1
cc            N = i*R - H*exp(i*ph0)
              temp = exp(coni*phx)
              do i = 1, ilast
                pn(i,im,j) = coni * pr(i,im,j) - temp * pn(i,im,j)
                qn(i,im,j) = coni * qr(i,im,j) - temp * qn(i,im,j)
              enddo

 150      continue

c         combine all constant factors to temp
c         add relativistic correction to normaliz. and factor 2*lll+1
          temp = 2*ck / (1+factor**2) / pi
  
c         ic3 = 0, j= ic3+1
          j = 1
c         calculate diagonal radial integrals R(k1,k1) - xrhoce and xrhole
            do 190  i = 1, ilast
              xpc(i) = pr(i,im,j) **2 + qr(i,im,j) **2
 190        continue
            xirf = lll*2 + 2
c           i0 should be less or equal to  ilast
            i0=jnrm+1
            call csomm2 (ri, xpc, dx, xirf, rnrm, i0)
            xrhole(ikap,ikap) =xirf*temp*exp(coni*(phm(im,j)+phm(im,j)))

c         only central atom contribution needs irregular solution
            do 195  i = 1, ilast
              xpc(i) = pn(i,im,j)*pr(i,im,j)+ qn(i,im,j) *qr(i,im,j)
              xpc(i) = xpc(i) - coni*(pr(i,im,j)**2 + qr(i,im,j)**2)
 195        continue
            xirf =  1
            call csomm2 (ri, xpc, dx, xirf, rnrm, i0)
            xrhoce(ikap,ikap) = - xirf * temp

c         calculate cross terms
          if (ikap.lt.-1) then
            k1 = ikap + 2*lll + 1
            do 290  i = 1, ilast
              xpc(i) = pr(i,1,j) * pr(i,2,j) + qr(i,1,j) * qr(i,2,j) 
 290        continue
            xirf = lll*2 + 2
c           i0 should be less or equal to  ilast
            i0=jnrm+1
            call csomm2 (ri, xpc, dx, xirf, rnrm, i0)
            xrhole (ikap, k1) = xirf*temp* exp(coni*(phm(1,j)+phm(2,j)))
            xrhole (k1, ikap) = xrhole (ikap, k1)

c           ic3 = 1, j= ic3+1
            j = 2
            xpm =  exp(coni*(phm(1,j)-phm(2,j))) / 2
            xmp =  exp(coni*(phm(2,j)-phm(1,j))) / 2
            do 295  i = 1, ilast
              xpc(i) = (pn(i,1,j)*pr(i,2,j)+ qn(i,1,j) *qr(i,2,j)) * xmp
     1               + (pn(i,2,j)*pr(i,1,j)+ qn(i,2,j) *qr(i,1,j)) * xpm
              xpc(i) = xpc(i) - coni*(xpm+xmp) *
     1                 (pr(i,1,j)*pr(i,2,j) + qr(i,1,j)*qr(i,2,j))
 295        continue
            xirf =  1
            call csomm2 (ri, xpc, dx, xirf, rnrm, i0)
            xrhoce(ikap,k1) = - xirf * temp
            xrhoce(k1,ikap) =  xrhoce(ikap,k1)
          endif
 199    continue 
 200  continue 

c     calculate phase shift in old way (ic3=1) test new one
c     which is commented out above later
      do 300 lll = 1,lmax
          im = 1
          ikap = -lll-1
          irr = -1
          ic3 = 1
          call dfovrg ( ncycle, ikap, rmt, ilast, jri, p2, dx,
     $                ri, vtotc, vvalc, dgcn, dpcn, adgc, adpc,
     $                xnval, pu, qu, pr(1,im,1), qr(1,im,1),
     $                iz, ihole, xion, iunf, irr, ic3)
            
          call exjlnl (xkmt, lll, jl, nl)
          call exjlnl (xkmt, lll+1, jlp1, nlp1)
          call phamp (rmt, pu, qu, ck,  jl, nl, jlp1, nlp1, ikap,
     1                  phx, temp)
          ph(1+lll)=phx
 300  continue

      return
      end
      subroutine rholat ( icount, dx, x0, ri, em,
     2                  ixc, rmt, rnrm,
     3                  vtot, vvalgs, xnval, iorb, dgcn, dpcn, eref,
     4                  adgc, adpc, xrhole, xrhoce, ph,
     i                  iz, xion, iunf, ihole, lmaxsc)

      implicit double precision (a-h, o-z)

c     INPUT
c     dx, x0, ri(nr)
c                  Loucks r-grid, ri=exp((i-1)*dx-x0)
c     ne, em(ne)   number of energy points,  complex energy grid
c     ixc          0  Hedin-Lunqist + const real & imag part
c                  1  Dirac-Hara + const real & imag part
c                  2  ground state + const real & imag part
c                  3  Dirac-Hara + HL imag part + const real & imag part
c                  5  Dirac-Fock exchange with core electrons +
c                     ixc=0 for valence electron density
c     rmt          r muffin tin
c     rnrm         r norman
c     vtot(nr)     total potential, including gsxc, final state
c     dgcn(dpcn)   large (small) dirac components for central atom
c     adgc(adpc)   their development coefficients
c
c     OUTPUT
c     xrhole(0:lx)  integral over r of density function
c     xrhoce(0:lx)  the same integral for embedded atom only


c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     max number allowed in xsect r-grid
      parameter (nrx = nrptx)

c     output
      complex*16  xrhole(-4:3,-4:3)
      complex*16  xrhoce(-4:3, -4:3)
      complex*16  ph(lx+1)

      dimension ri(nrptx), ri05(251)
      dimension  vtot(nrptx), vvalgs(nrptx)
      complex*16 vtotc(nrptx), vvalc(nrptx)
      dimension xnval(30), iorb(-4:3), dgcn(nrptx,30), dpcn(nrptx,30)
      dimension adgc(10,30), adpc(10,30)

c     energy grid in complex e-plane
      complex*16 em, eref

c     work space for dfovrg: regular and irregular solutions
      complex*16 pr(nrx,2,2), qr(nrx,2,2), pn(nrx,2,2), qn(nrx,2,2)

      complex*16  p2, xkmt, ck, xck
      complex*16  pu, qu
      complex*16  xfnorm, xirf, xmp, xpm
      complex*16  temp,  phx, phm(2,2), factor

      complex*16 jl,jlp1,nl,nlp1
      complex*16  xpc(nrx)

c     nesvi
      dimension pat(nrx,2,2),qat(nrx,2,2)
      complex*16 intr(nrx,2,2),var(nrx) 
      dimension xq(nrptx),xp(nrptx)
      complex*16 xkmi

c     initialize
      lmax=lmaxsc
      if (lmax.gt.lx) lmax = lx
      if (iz.le.4) lmax=2
      if (iz.le.2) lmax=1
      do 20 i = 1, nrptx
         vtotc(i)=vtot(i)
         vvalc(i)= vvalgs(i)
  20  continue
c     set imt and jri (use general Loucks grid)
c     rmt is between imt and jri (see function ii(r) in file xx.f)
      imt  = (log(rmt) + x0) / dx  +  1
      jri  = imt+1
      if (jri .gt. nrptx)  call par_stop('jri .gt. nrptx in phase')

      inrm = (log(rnrm) + x0) / dx  +  1
      jnrm = inrm+1

c     define ilast1,rlast
      rlast=rnrm
      if (icount.eq.2) rlast=10*rnrm
      jlast1=(log(rlast) + x0)/ dx + 2
      ilast1=jlast1 + 6

cc    nesvi
cc    dgcn and dpcn should be normalized <n|n>=1, check this here
     
      do 440 j = -4, 3
        jj = iorb(j)
        if (jj.le.0) goto 440

        do 420  i = 1, jlast1
         xp(i) = dpcn(i,jj)**2 + dgcn(i,jj)**2
         xq(i) = 0
  420   continue
cc      nb, xinorm is used for exponent on input to somm
        lfin = j
        if (j.lt.0) lfin = -j - 1
        xinorm = 2*lfin + 2
        i0 = jnrm + 1
        call somm2 (ri, xp, dx, xinorm, rnrm, 0, i0)
        if (xinorm.lt.0.99 .and. icount.eq.2) then
           call wlog
     1     ('  WARNING: small overlap integral for Mulliken count')
        endif
    
        xinorm = 1.d0 / sqrt(xinorm)
        do 430 i=1,nrptx
          dpcn(i,jj)=dpcn(i,jj) * xinorm
          dgcn(i,jj)=dgcn(i,jj) * xinorm
  430   continue
  440 continue

c     set limits for tabulations
      nr05= (log(rnrm) + x0) / 0.05d0 + 5
      if (nr05.gt.251) nr05 = 251
c     ilast is the last integration point
c     it is larger than jnrm for better interpolations
      ilast = nint( (nr05-1) *0.05d0 / dx ) + 1
      if (ilast.gt.nrptx) ilast=nrptx

      if (ilast1.gt.nrptx) ilast1=nrptx

      do 10 i = -4,3
      do 10 j = -4,3
         xrhole(i,j) = 0
         xrhoce(i,j) = 0
  10  continue
      do 15 i=1,lx+1
  15  ph(i) = 0

c     p2 is 0.5*(complex momentum)**2 referenced to energy dep xc
c     need hartree units for dfovrg
      p2 = em - eref
      if (mod(ixc,10) .lt. 5) then
        ncycle = 0
      else
        ncycle = 3
      endif
      ck = sqrt(2*p2 + (p2*alphfs)**2)
      xkmt = rmt * ck

      do 200 lll=0,lmax
        do 199 jd = 0,1
          ikap = (lll+jd)* (-1)**jd
          if (ikap.eq.0) goto 199

          ilp = lll + 1
          if (ikap.gt.0) ilp = lll - 1
          im = 1+ jd

          do 150 j = 1, 2
            ic3 = j-1
            if (lll.eq.0 .and. ic3.eq.1) goto 150

            irr = -1
            call dfovrg ( ncycle, ikap, rmt, ilast1, jri, p2, dx,
     $                ri, vtotc, vvalc, dgcn, dpcn, adgc, adpc,
     $                xnval, pu, qu, pn(1,im,j), qn(1,im,j),
     $                iz, ihole, xion, iunf, irr, ic3)
            
            call exjlnl (xkmt, lll, jl, nl)
            call exjlnl (xkmt, ilp, jlp1, nlp1)
            call phamp (rmt, pu, qu, ck,  jl, nl, jlp1, nlp1, ikap,
     1                  phx, temp)
            if (lll.eq.0)  ph(1)=phx
            phm(im,j) = phx

c           Normalize final state  at rmt to
c           rmt*(jl*cos(delta) - nl*sin(delta))
            xfnorm = 1 / temp
c           normalize regular solution
            do 133  i = 1,ilast1
              pr(i,im,j)=pn(i,im,j)*xfnorm
              qr(i,im,j)=qn(i,im,j)*xfnorm
  133       continue

c-----------------------
c           nesvi            

cc           add solution beyond Rmt:
c             do 1010 i=jri+1, ilast1
c                xkmi=ri(i)*ck
c                call exjlnl(xkmi,lll,jl,nl)
c                pr(i,im,j)=(jl*cos(phx)-nl*sin(phx))*ri(i)
c                qr(i,im,j)=0.0d0
c1010         continue

c             chose atomic function for making projection.
c             Project on corresponding atomic states. 
              jj = iorb(ikap)

c             make corresponding atomic functions
              if (jj.eq.0) then
                do 397 i=1,nrptx
                  pat(i,im,j)=0
                  qat(i,im,j)=0
  397           continue
              else
                do 398 i=1,nrptx
                  pat(i,im,j)=dgcn(i,jj)
                  qat(i,im,j)=dpcn(i,jj)    
  398           continue
              endif

            open(unit=3,file='wfat.dat',status='unknown')    

c         only central atom contribution needs irregular solution
            do 194  i = 1, ilast1           
                write(3,1019) ri(i)/rnrm, dgcn(i,6),dgcn(i,8),
     1          dgcn(i,10),dgcn(i,12)
 1019           format(f10.5,1x,e10.4,1x,e10.4,1x,e10.4,1x,e10.4)

 194         continue

            close(3)




c             calculate overlap integral between f and atomic function
c             (integral Rl(r)*Psi_at(r)dr from 0 till r') 
c             intr(i) is that overlap integral. Later it
c             will be multiplied by pr(i)*Psi_at(r') and integrated till
c             r=infinity (ideal case), but actually till rlast.

              do 400 i=1,ilast1
                var(i)=pat(i,im,j)*pr(i,im,j)+qat(i,im,j)*qr(i,im,j)
c             factor of 2 -integration r< r>  -->2 r r'
  400         continue

c             integration by trapezoid method
              
              intr(1,im,j)=var(1)*ri(1)
   
              do 410 i=2,ilast1
                intr(i,im,j)=intr(i-1,im,j)+
     1                       (var(i)+var(i-1))*(ri(i)-ri(i-1))
  410         continue 

cc              old way, no double integration 
c              do 415 i=1,ilast1
c                 intr(i,im,j)=intr(ilast1,im,j)/2.0                
c  415         continue    

              
c----------------


c          find irregular solution
            irr = 1
            pu = ck*alphfs
            factor = pu/(1+sqrt(1+pu**2))
            if (ikap.lt.0) factor = -factor
c           set pu, qu - initial condition for irregular solution at ilast
c           qu=(nlp1*cos(phx)+jlp1*sin(phx))*pu *rmt
c           pu = (nl*cos(phx)+jl*sin(phx)) *rmt
            qu=(nlp1*cos(phx)+jlp1*sin(phx))* factor *rmt 
            pu = (nl*cos(phx)+jl*sin(phx)) *rmt 

            call dfovrg (ncycle, ikap, rmt, ilast1, jri, p2, dx,
     1              ri, vtotc,vvalc, dgcn, dpcn, adgc, adpc,
     1              xnval, pu, qu, pn(1,im,j), qn(1,im,j),
     1              iz, ihole, xion, iunf, irr, ic3)
cc            set N- irregular solution , which is outside
cc            N=(nlp1*cos(ph0)+jlp1*sin(ph0))*factor *rmt * dum1
cc            N = i*R - H*exp(i*ph0)
              temp = exp(coni*phx)
              do i = 1, ilast
                pn(i,im,j) = coni * pr(i,im,j) - temp * pn(i,im,j)
                qn(i,im,j) = coni * qr(i,im,j) - temp * qn(i,im,j)
              enddo

 150      continue

c         combine all constant factors to temp
c         add relativistic correction to normaliz. and factor 2*lll+1
          temp = 2*ck / (1+factor**2) / pi

c         nesvi add irregular solution beyond Rmt          
c           do 1020 i=(jri+1), ilast1
c                xkmi=ri(i)*ck
c                call exjlnl(xkmi,lll,jl,nl)
c                pn(i,im,j)=(nl*cos(phx)+jl*sin(phx))*ri(i)
c                qn(i,im,j)=0.0d0
c1020        continue
     
c          open(unit=2,file='wfunc1.dat',status='unknown')    
c         ic3 = 0, j= ic3+1
          j = 1
c         calculate diagonal radial integrals R(k1,k1) - xrhoce and xrhole
            do 190  i = 1, ilast1
              xpc(i) = pr(i,im,j)*pat(i,im,j)*intr(i,im,j)+ 
     1              qr(i,im,j)*qat(i,im,j)*intr(i,im,j)

c            if (ikap .eq. -3 .and. (dble(em) +12.0/hart)
c     1          .le. 1.0/hart) then
c                write(2,1015) ri(i)/rnrm, dble(pr(i,im,j)),
c     1          pat(i,im,j), dble(intr(i,im,j)),dble(xpc(i))
c 1015           format(f10.6,1x,e10.4,1x,e10.4,1x,e10.4,1x,e10.4)
c             endif

 190        continue
            xirf = lll*2 + 2
            i0=jlast1+1
            call csomm2 (ri, xpc, dx, xirf, rlast, i0)
            xrhole(ikap,ikap) =xirf*temp*exp(coni*(phm(im,j)+phm(im,j)))

c            close(2)
            open(unit=2,file='wfunc.dat',status='unknown')    

c         only central atom contribution needs irregular solution
            do 195  i = 1, ilast1
              xpc(i) = pn(i,im,j)*pat(i,im,j)*intr(i,im,j)+ 
     1              qn(i,im,j)*qat(i,im,j)*intr(i,im,j)
              xpc(i) = xpc(i) - 
     1              coni*(pr(i,im,j)*pat(i,im,j)*intr(i,im,j) + 
     2              qr(i,im,j)*qat(i,im,j)*intr(i,im,j))

c         for test purposes
 
c           do 195  i = 1, ilast1
c              xpc(i) = pn(i,im,j)*pat(i,im,j)*intr(i,im,j)
c            xpc(i) = -1.0*coni*(pr(i,im,j)*pat(i,im,j)*intr(i,im,j))
           
             if (ikap .eq. 1 .and. (dble(em) +12.0/hart)
     1          .lt. 1.0/hart) then
                write(2,1016) ri(i)/rnrm, dble(pr(i,im,j)),
     1          pat(i,im,j), dble(intr(i,im,j)),-dimag(xpc(i))
 1016           format(f10.4,1x,e10.4,1x,e10.4,1x,e10.4,1x,e10.4)
             endif

 195        continue

            close(2)

            xirf =  1
            call csomm2 (ri, xpc, dx, xirf, rlast, i0)
            xrhoce(ikap,ikap) = - xirf * temp

c         calculate cross terms
          if (ikap.lt.-1) then
            k1 = ikap + 2*lll + 1
            do 290  i = 1, ilast1
              xpc(i) = pr(i,1,j)*pat(i,1,j)*intr(i,2,j) +
     1                 qr(i,1,j)*qat(i,1,j)*intr(i,2,j) 
 290        continue
            xirf = lll*2 + 2
c           i0 should be less or equal to  ilast
            i0=jlast1+1
            call csomm2 (ri, xpc, dx, xirf, rlast, i0)
c            xrhole (ikap, k1) = xirf*temp* exp(coni*(phm(1,j)+phm(2,j)))
c             xrhoce(ikap,k1)=0.0d0           
             xrhole (k1, ikap) = xrhole (ikap, k1)
c            nesvi: checked that cross-terms are not important for N_h 
            
c           ic3 = 1, j= ic3+1
            j = 2
            xpm =  exp(coni*(phm(1,j)-phm(2,j))) / 2
            xmp =  exp(coni*(phm(2,j)-phm(1,j))) / 2
            do 295  i = 1, ilast1
              xpc(i) = (pn(i,1,j)*pat(i,1,j)*intr(i,2,j)+ 
     1                  qn(i,1,j)*qat(i,1,j)*intr(i,2,j)) * xmp +
     2                 (pn(i,2,j)*pat(i,2,j)*intr(i,1,j)+ 
     3                  qn(i,2,j)*qat(i,2,j)*intr(i,1,j)) * xpm
              xpc(i) = xpc(i) - coni*(xpm+xmp) *
     1                 (pr(i,1,j)*pat(i,1,j)*intr(i,2,j) +
     2                  qr(i,1,j)*qat(i,1,j)*intr(i,2,j))
 295        continue
            xirf =  1
            call csomm2 (ri, xpc, dx, xirf, rlast, i0)
            xrhoce(ikap,k1) = - xirf * temp
c        cross term not important for N_h
c            xrhoce(ikap,k1)=0.0d0
            xrhoce(k1,ikap) =  xrhoce(ikap,k1)
          endif
 199    continue 
 200  continue 


           
          if ((dble(em) +12.0/hart) .lt. 1.0/hart) then
          open(unit=4,file='xrhocet.dat',status='unknown')  
          do 1195  i=-4,3
              do 1195 j=-4,3
                write(4,1018) i,j,dimag(xrhoce(i,j))
 1018           format(i3,1x,i3,1x,f10.4)
 1195        continue
          close(4)
          endif
         



c     calculate phase shift in old way (ic3=1) test new one
c     which is commented out above later
      do 300 lll = 1,lmax
          im = 1
          ikap = -lll-1
          irr = -1
          ic3 = 1
          call dfovrg ( ncycle, ikap, rmt, ilast1, jri, p2, dx,
     $                ri, vtotc, vvalc, dgcn, dpcn, adgc, adpc,
     $                xnval, pu, qu, pr(1,im,1), qr(1,im,1),
     $                iz, ihole, xion, iunf, irr, ic3)
            
          call exjlnl (xkmt, lll, jl, nl)
          call exjlnl (xkmt, lll+1, jlp1, nlp1)
          call phamp (rmt, pu, qu, ck,  jl, nl, jlp1, nlp1, ikap,
     1                  phx, temp)
          ph(1+lll)=phx
 300  continue

      return
      end
      subroutine getedg (ihole, iz, emu)
      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c Insert corrected edges from G.P. Williams' and W.T. Elam's tables.
c 17/10/2002 G. Rivas
      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
                                                                                
      dimension exmu(1:100,1:29)
                                                                                
c edge energies for each element for z = 1, 98
c some values taken from W.T.Elam's table:
c Li L1, Be to C L1-3, N & O L2-3, F L1-3, Mg to Cl M1-3,
c Ti to Cu M4-5, Zn N2-3, Ga to Br N1-3, Rh to Ag N4-5,
c Sb to I O1-3, Ce N5, Pm M1 N1 N6-7 O1-3, Eu N6-7, Gd N4,
c Er N6, Tm N6, Au O4-5, Pb to At P1-3, Rn P2-3, Ac P1-3
c Pa P1-3, and all values up to from z=92 to z=98
      data (exmu( 1,i),i=1,29)  /13.6,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 2,i),i=1,29)  /24.6,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 3,i),i=1,29)  /54.7,5.3,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 4,i),i=1,29)  /111.5,8.0,3.0,3.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 5,i),i=1,29)  /188.0,12.6,4.7,4.7,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 6,i),i=1,29)  /284.2,18.0,7.2,7.2,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 7,i),i=1,29)  /409.9,37.3,17.5,17.5,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 8,i),i=1,29)  /543.1,41.6,18.2,18.2,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
                                                                                
c     To test a problem with sum rules for F absorber in LiF, I
c     have put the Flourine edge energies back to Feff default.
c     MPP 8/7/03. Set back 10/16/03 MPP.
      data (exmu( 9,i),i=1,29)  /696.7,45.0,19.9,19.9,
c      data (exmu( 9,i),i=1,29)  /-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(10,i),i=1,29)  /870.2,48.5,21.7,21.6,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(11,i),i=1,29)  /1070.8,63.5,30.65,30.81,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(12,i),i=1,29)  /1303.0,88.7,49.78,49.5,
     1                           2.0,1.0,1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(13,i),i=1,29)  /1559.6,117.8,72.95,72.55,
     1                           4.0,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(14,i),i=1,29)  /1839.0,149.7,99.82,99.42,
     1                           8.0,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(15,i),i=1,29)  /2145.5,189.0,136.0,135.0,
     1                           12.0,7.0,6.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(16,i),i=1,29)  /2472.0,230.9,163.6,162.5,
     1                           14.0,8.0,7.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(17,i),i=1,29)  /2822.4,270.0,202.0,200.0,
     1                           18.0,10.0,10.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(18,i),i=1,29)  /3205.9,326.3,250.6,248.4,
     1                           29.3,15.9,15.7,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(19,i),i=1,29)  /3608.4,378.6,297.3,294.6,
     1                           34.8,18.3,18.3,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(20,i),i=1,29)  /4038.5,438.4,349.7,346.2,
     1                           44.3,25.4,25.4,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(21,i),i=1,29)  /4492.0,498.0,403.6,398.7,
     1                           51.1,28.3,28.3,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(22,i),i=1,29)  /4966.0,560.9,460.2,453.8,
     1                           58.7,32.6,32.6,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(23,i),i=1,29)  /5465.0,626.7,519.8,512.1,
     1                           66.3,37.2,37.2,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(24,i),i=1,29)  /5989.0,696.0,583.8,574.1,
     1                           74.1,42.2,42.2,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(25,i),i=1,29)  /6539.0,769.1,649.9,638.7,
     1                           82.3,47.2,47.2,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(26,i),i=1,29)  /7112.0,844.6,719.9,706.8,
     1                           91.3,52.7,52.7,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(27,i),i=1,29)  /7709.0,925.1,793.2,778.1,
     1                           101.0,58.9,59.9,3.0,3.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(28,i),i=1,29)  /8333.0,1008.6,870.0,852.7,
     1                           110.8,68.0,66.2,4.0,4.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(29,i),i=1,29)  /8979.0,1096.7,952.3,932.7,
     1                           122.5,77.3,75.1,5.0,5.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(30,i),i=1,29)  /9659.0,1196.2,1044.9,1021.8,
     1                          139.8,91.4,88.6,10.2,10.1,
     1                          -1.0,1.0,1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(31,i),i=1,29)  /10367.0,1299.0,1143.2,1116.4,
     1                           159.5,103.5,100.0,18.7,18.7,
     1                           1.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(32,i),i=1,29)  /11103.0,1414.6,1248.1,1217.0,
     1                           180.1,124.9,120.8,29.8,29.2,
     1                           5.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(33,i),i=1,29)  /11867.0,1527.0,1359.1,1323.6,
     1                           204.7,146.2,141.2,41.7,41.7,
     1                           8.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(34,i),i=1,29)  /12658.0,1652.0,1474.3,1433.9,
     1                           229.6,166.5,160.7,55.5,54.6,
     1                           12.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(35,i),i=1,29)  /13474.0,1782.0,1596.0,1550.0,
     1                           257.0,189.0,182.0,70.0,69.0,
     1                           27.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(36,i),i=1,29)  /14326.0,1921.0,1730.9,1678.4,
     1                           292.8,222.2,214.4,95.0,93.8,
     1                           27.5,14.1,14.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(37,i),i=1,29)  /15200.0,2065.0,1864.0,1804.0,
     1                           326.7,248.7,239.1,113.0,112.0,
     1                           30.5,16.3,15.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(38,i),i=1,29)  /16105.0,2216.0,2007.0,1940.0,
     1                           358.7,280.3,270.0,136.0,134.2,
     1                           38.9,21.3,20.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(39,i),i=1,29)  /17038.0,2373.0,2156.0,2080.0,
     1                           392.0,310.6,298.8,157.7,155.8,
     1                           43.8,24.4,23.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(40,i),i=1,29)  /17998.0,2532.0,2307.0,2223.0,
     1                           430.3,343.5,329.8,181.1,178.8,
     1                           50.6,28.5,27.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(41,i),i=1,29)  /18986.0,2698.0,2465.0,2371.0,
     1                           466.6,376.1,360.6,205.0,202.3,
     1                           56.4,32.6,30.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(42,i),i=1,29)  /20000.0,2866.0,2625.0,2520.0,
     1                           506.3,411.6,394.0,231.1,227.9,
     1                           63.2,37.6,35.5,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(43,i),i=1,29)  /21044.0,3043.0,2793.0,2677.0,
     1                           544.0,447.6,417.7,257.6,253.9,
     1                           69.5,42.3,39.9,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(44,i),i=1,29)  /22117.0,3224.0,2967.0,2838.0,
     1                           586.1,483.5,461.4,284.2,280.0,
     1                           75.0,46.3,43.2,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(45,i),i=1,29)  /23220.0,3412.0,3146.0,3004.0,
     1                           628.1,521.3,496.5,311.9,307.2,
     1                           81.4,50.5,47.3,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(46,i),i=1,29)  /24350.0,3604.0,3330.0,3173.0,
     1                           671.6,559.9,532.3,340.5,335.2,
     1                           87.1,55.7,50.9,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(47,i),i=1,29)  /25514.0,3806.0,3524.0,3351.0,
     1                           719.0,603.8,573.0,374.0,368.3,
     1                           97.0,63.7,58.3,4.0,4.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(48,i),i=1,29)  /26711.0,4018.0,3727.0,3538.0,
     1                           772.0,652.6,618.4,411.9,405.2,
     1                           109.8,63.9,63.9,11.7,10.7,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(49,i),i=1,29)  /27940.0,4238.0,3938.0,3730.0,
     1                           827.2,703.2,665.3,451.4,443.9,
     1                           122.9,73.5,73.5,17.7,16.9,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(50,i),i=1,29)  /29200.0,4465.0,4156.0,3929.0,
     1                           884.7,756.5,714.6,493.2,484.9,
     1                           137.1,83.6,83.6,24.9,23.9,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(51,i),i=1,29)  /30491.0,4698.0,4380.0,4132.0,
     1                           946.0,812.7,766.4,537.5,528.2,
     1                           153.2,95.6,95.6,33.3,32.1,-1.0,-1.0,
     1                           7.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(52,i),i=1,29)  /31814.0,4939.0,4612.0,4341.0,
     1                           1006.0,870.8,820.0,583.4,573.0,
     1                           169.4,103.3,103.3,41.9,40.4,-1.0,-1.0,
     1                           12.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(53,i),i=1,29)  /33169.0,5188.0,4852.0,4557.0,
     1                           1072.0,931.0,875.0,630.8,619.3,
     1                           186.0,123.0,123.0,50.6,48.9,-1.0,-1.0,
     1                           14.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(54,i),i=1,29)  /34561.0,5453.0,5107.0,4786.0,
     1                           1148.7,1002.1,940.6,689.0,676.4,
     1                           213.2,146.7,145.5,69.5,67.5,-1.0,-1.0,
     1                           23.3,13.4,12.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(55,i),i=1,29)  /35985.0,5714.0,5359.0,5012.0,
     1                           1211.0,1071.0,1003.0,740.5,726.6,
     1                           232.3,172.4,161.3,79.8,77.5,-1.0,-1.0,
     1                           22.7,14.2,12.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(56,i),i=1,29)  /37441.0,5989.0,5624.0,5247.0,
     1                           1293.0,1137.0,1063.0,795.7,780.5,
     1                           253.5,192.0,178.6,92.6,89.9,-1.0,-1.0,
     1                           30.3,17.0,14.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(57,i),i=1,29)  /38925.0,6266.0,5891.0,5483.0,
     1                           1362.0,1209.0,1128.0,853.0,836.0,
     1                          274.7,205.8,196.0,105.3,102.5,-1.0,-1.0,
     1                           34.3,19.3,16.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(58,i),i=1,29)  /40443.0,6549.0,6164.0,5723.0,
     1                           1436.0,1274.0,1187.0,902.4,883.8,
     1                           291.0,223.2,206.5,109.0,109.0,0.1,0.1,
     1                           37.8,19.8,17.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(59,i),i=1,29)  /41991.0,6835.0,6440.0,5964.0,
     1                           1511.0,1337.0,1242.0,948.3,928.8,
     1                           304.5,236.3,217.6,115.1,115.1,2.0,2.0,
     1                           37.4,22.3,22.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(60,i),i=1,29)  /43569.0,7126.0,6722.0,6208.0,
     1                           1575.0,1403.0,1297.0,1003.3,980.4,
     1                           319.2,243.3,224.6,120.5,120.5,1.5,1.5,
     1                           37.5,21.1,21.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(61,i),i=1,29)  /45184.0,7428.0,7013.0,6459.0,
     1                           1650.0,1471.0,1357.0,1052.0,1027.0,
     1                           331.0,242.0,242.0,120.0,120.0,4.0,4.0,
     1                           38.0,22.0,22.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(62,i),i=1,29)  /46834.0,7737.0,7312.0,6716.0,
     1                           1723.0,1541.0,1420.0,1110.9,1083.4,
     1                           347.2,265.6,247.4,129.0,129.0,5.2,5.2,
     1                           37.4,21.3,21.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(63,i),i=1,29)  /48519.0,8052.0,7617.0,6977.0,
     1                           1800.0,1614.0,1481.0,1158.6,1127.5,
     1                           360.0,284.0,257.0,133.0,127.7,6.0,6.0,
     1                           32.0,22.0,22.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(64,i),i=1,29)  /50239.0,8376.0,7930.0,7243.0,
     1                           1881.0,1688.0,1544.0,1221.9,1189.6,
     1                           378.6,286.0,271.0,142.6,142.6,8.6,8.6,
     1                           36.0,28.0,21.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(65,i),i=1,29)  /51996.0,8708.0,8252.0,7514.0,
     1                           1968.0,1768.0,1611.0,1276.9,1241.1,
     1                           396.0,322.4,284.1,150.5,150.5,7.7,2.4,
     1                           45.6,28.7,22.6,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(66,i),i=1,29)  /53789.0,9046.0,8581.0,7790.0,
     1                           2047.0,1842.0,1676.0,1333.0,1292.6,
     1                           414.2,333.5,293.2,153.6,153.6,8.0,4.3,
     1                           49.9,26.3,26.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(67,i),i=1,29)  /55618.0,9394.0,8918.0,8071.0,
     1                           2128.0,1923.0,1741.0,1392.0,1351.0,
     1                           432.4,343.5,308.2,160.0,160.0,8.6,5.2,
     1                           49.3,30.8,24.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(68,i),i=1,29)  /57486.0,9751.0,9264.0,8358.0,
     1                           2207.0,2006.0,1812.0,1453.0,1409.0,
     1                           449.8,366.2,320.2,167.6,167.6,4.7,4.7,
     1                           50.6,31.4,24.7,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(69,i),i=1,29)  /59390.0,10116.0,9617.0,8648.0,
     1                           2307.0,2090.0,1885.0,1515.0,1468.0,
     1                           470.9,385.9,332.6,175.5,175.5,4.6,4.6,
     1                           54.7,31.8,25.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(70,i),i=1,29)  /61332.0,10486.0,9978.0,8944.0,
     1                           2398.0,2173.0,1950.0,1576.0,1528.0,
     1                           480.5,388.7,339.7,191.2,182.4,2.5,1.3,
     1                           52.0,30.3,24.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(71,i),i=1,29)  /63314.0,10870.0,10349.0,9244.0,
     1                           2491.0,2264.0,2024.0,1639.0,1589.0,
     1                           506.8,412.4,359.2,206.1,196.3,8.9,7.5,
     1                           57.3,33.6,26.7,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(72,i),i=1,29)  /65351.0,11271.0,10739.0,9561.0,
     1                           2601.0,2365.0,2108.0,1716.0,1662.0,
     1                          538.0,438.2,380.7,220.0,211.5,15.9,14.2,
     1                           64.2,38,29.9,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(73,i),i=1,29)  /67416.0,11682.0,11136.0,9881.0,
     1                           2708.0,2469.0,2194.0,1793.0,1735.0,
     1                          563.4,463.4,400.9,237.9,226.4,23.5,21.6,
     1                           69.7,42.2,32.7,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(74,i),i=1,29)  /69525.0,12100.0,11544.0,10207.0,
     1                           2820.0,2575.0,2281.0,1872.0,1809.0,
     1                          594.1,490.4,423.6,255.9,243.5,33.6,31.4,
     1                           75.6,45.3,36.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(75,i),i=1,29)  /71676.0,12527.0,11959.0,10535.0,
     1                           2932.0,2682.0,2367.0,1949.0,1883.0,
     1                          625.4,518.7,446.8,273.9,260.5,42.9,40.5,
     1                           83.0,45.6,34.6,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(76,i),i=1,29) /73871.0,12968.0,12385.0,10871.0,
     1                          3049.0,2792.0,2457.0,2031.0,1960.0,
     1                          658.2,549.1,470.7,293.1,278.5,53.4,50.7,
     1                          84.0,58.0,44.5,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(77,i),i=1,29) /76111.0,13419.0,12824.0,11215.0,
     1                          3174.0,2909.0,2551.0,2116.0,2040.0,
     1                          691.1,577.8,495.8,311.9,296.3,63.8,60.8,
     1                          95.2,63.0,48.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(78,i),i=1,29) /78395.0,13880.0,13273.0,11564.0,
     1                          3296.0,3027.0,2645.0,2202.0,2122.0,
     1                          725.4,609.1,519.4,331.6,314.6,74.5,71.2,
     1                          101.7,65.3,51.7,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(79,i),i=1,29) /80725.0,14353.0,13734.0,11919.0,
     1                          3425.0,3148.0,2743.0,2291.0,2206.0,
     1                          762.1,642.7,546.3,353.2,335.1,87.6,84.0,
     1                          107.2,74.2,57.2,5.0,5.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(80,i),i=1,29)/83102.0,14839.0,14209.0,12284.0,
     1                         3562.0,3279.0,2847.0,2385.0,2295.0,
     1                         802.2,680.2,576.6,378.2,358.8,104.0,99.9,
     1                         127.0,83.1,64.5,9.6,7.8,-1.0,-1.0,
     1                        -1.0,-1.0,-1.0,-1.0,-1.0,
     1                        -1.0/
                                                                                
      data (exmu(81,i),i=1,29)/85530.0,15347.0,14698.0,12658.0,
     1                        3704.0,3416.0,2957.0,2485.0,2389.0,
     1                        846.2,720.5,609.5,405.7,385.0,122.2,117.8,
     1                        136.0,94.6,73.5,14.7,12.5,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(82,i),i=1,29)/88005.0,15861.0,15200.0,13035.0,
     1                        3851.0,3554.0,3066.0,2586.0,2484.0,
     1                        891.8,761.9,643.5,434.3,412.2,141.7,136.9,
     1                        147.0,106.4,83.3,20.7,18.1,-1.0,-1.0,
     1                        3.0,1.0,1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(83,i),i=1,29)/90526.0,16388.0,15711.0,13419.0,
     1                        3999.0,3696.0,3177.0,2688.0,2580.0,
     1                        939.0,805.2,678.8,464.0,440.1,162.3,157.0,
     1                        159.3,119.0,92.6,26.9,23.8,-1.0,-1.0,
     1                        8.0,3.0,3.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(84,i),i=1,29)/93105.0,16939.0,16244.0,13814.0,
     1                        4149.0,3854.0,3302.0,2798.0,2683.0,
     1                        995.0,851.0,705.0,500.0,473.0,184.0,184.0,
     1                        177.0,132.0,104.0,31.0,31.0,-1.0,-1.0,
     1                        9.0,4.0,1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(85,i),i=1,29)/95730.0,17493.0,16785.0,14214.0,
     1                       4317.0,4008.0,3426.0,2909.0,2787.0,
     1                       1042.0,886.0,740.0,533.0,507.0,210.0,210.0,
     1                       195.0,148.0,115.0,40.0,40.0,-1.0,-1.0,
     1                       13.0,6.0,1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(86,i),i=1,29)/98404.0,18049.0,17337.0,14619.0,
     1                       4482.0,4159.0,3538.0,3022.0,2892.0,
     1                       1097.0,929.0,768.0,567.0,541.0,238.0,238.0,
     1                       214.0,164.0,127.0,48.0,48.0,-1.0,-1.0,
     1                       26.0,8.0,2.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(87,i),i=1,29)/101137.0,18639.0,17907.0,15031.0,
     1                       4652.0,4327.0,3663.0,3136.0,3000.0,
     1                       1153.0,980.0,810.0,603.0,577.0,268.0,268.0,
     1                       234.0,182.0,140.0,58.0,58.0,-1.0,-1.0,
     1                       34.0,15.0,15.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(88,i),i=1,29)/103922.0,19237.0,18484.0,15444.0,
     1                       4822.0,4490.0,3792.0,3248.0,3105.0,
     1                      1208.0,1058.0,879.0,636.0,603.0,299.0,299.0,
     1                       254.0,200.0,153.0,68.0,68.0,-1.0,-1.0,
     1                       44.0,19.0,19.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(89,i),i=1,29)/106755.0,19840.0,19083.0,15871.0,
     1                       5002.0,4656.0,3909.0,3370.0,3219.0,
     1                      1269.0,1080.0,890.0,675.0,639.0,319.0,319.0,
     1                       272.0,215.0,167.0,80.0,80.0,-1.0,-1.0,
     1                       37.0,24.0,15.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(90,i),i=1,29)/109651.0,20472.0,19693.0,16300.0,
     1                       5182.0,4830.0,4046.0,3491.0,3332.0,
     1                      1330.0,1168.0,966.4,712.1,675.2,342.4,333.1,
     1                       290.0,229.0,182.0,92.5,85.4,-1.0,-1.0,
     1                       41.4,24.5,16.6,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(91,i),i=1,29)/112601.0,21105.0,20314.0,16733.0,
     1                       5367.0,5001.0,4174.0,3611.0,3442.0,
     1                     1387.0,1224.0,1007.0,743.0,708.0,371.0,360.0,
     1                       310.0,232.0,232.0,94.0,94.0,-1.0,-1.0,
     1                       43.0,27.0,17.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(92,i),i=1,29)/115606.0,21757.0,20948.0,17166.0,
     1                       5548.0,5182.0,4303.0,3728.0,3552.0,
     1                     1439.0,1271.0,1043.0,778.3,736.2,388.2,377.4,
     1                       321.0,257.0,192.0,102.8,94.2,-1.0,-1.0,
     1                       43.9,26.8,16.8,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(93,i),i=1,29)/118669.0,22427.0,21600.0,17610.0,
     1                       5739.0,5366.0,4435.0,3849.0,3664.0,
     1                     1501.0,1328.0,1085.0,816.0,771.0,414.0,403.0,
     1                       338.0,274.0,206.0,109.0,101.0,-1.0,-1.0,
     1                       47.0,29.0,18.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(94,i),i=1,29)/121791.0,23104.0,22266.0,18057.0,
     1                       5933.0,5547.0,4563.0,3970.0,3775.0,
     1                     1559.0,1380.0,1123.0,846.0,798.0,436.0,424.0,
     1                       350.0,283.0,213.0,113.0,102.0,-1.0,-1.0,
     1                       46.0,29.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(95,i),i=1,29)/124982.0,23808.0,22952.0,18510.0,
     1                       6133.0,5739.0,4698.0,4096.0,3890.0,
     1                     1620.0,1438.0,1165.0,880.0,829.0,461.0,446.0,
     1                       365.0,298.0,219.0,116.0,106.0,-1.0,-1.0,
     1                       48.0,29.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(96,i),i=1,29)/128241.0,24526.0,23651.0,18970.0,
     1                       6337.0,5937.0,4838.0,4224.0,4009.0,
     1                     1684.0,1498.0,1207.0,916.0,862.0,484.0,470.0,
     1                       383.0,313.0,229.0,124.0,110.0,-1.0,-1.0,
     1                        50.0,30.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(97,i),i=1,29)/131556.0,25256.0,24371.0,19435.0,
     1                       6545.0,6138.0,4976.0,4353.0,4127.0,
     1                     1748.0,1558.0,1249.0,955.0,898.0,511.0,495.0,
     1                       399.0,326.0,237.0,130.0,117.0,-1.0,-1.0,
     1                       52.0,32.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(98,i),i=1,29)/134939.0,26010.0,25108.0,19907.0,
     1                       6761.0,6345.0,5116.0,4484.0,4247.0,
     1                     1813.0,1620.0,1292.0,991.0,930.0,538.0,520.0,
     1                       416.0,341.0,245.0,137.0,122.0,-1.0,-1.0,
     1                       54.0,33.0,17.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(99,i),i=1,29)/-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(100,i),i=1,29) /-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                

      if(exmu(iz,ihole).gt.0.) emu = exmu(iz,ihole) / hart

      return
      end
      SUBROUTINE RdGrid(em,ne,nGrid,iGridType,GridMin,GridMax,GridStep,
     &     nGridMax,nex)
!     Read data from grid.inp.
!     file should have lines with the following format:
!     
!     Grid_Type    GridMin    GridMax    GridStep
!     
!     Grid_Type can be any of the following (case insensitive):
!     egrid    - (regular in energy)
!     kgrid    - (regular in k)
!     expgrid  - (exponential in energy)
!     usergrid - (read a grid from the file)
!
!     Energy, and k are given relative to the edge.
!     For egrid and expgrid, GridMin, GridMax, and GridStep are
!     given in (eV).
!     For kgrid, units are inverse angstroms.
!     usergrid is a special case and is followed by one energy
!     point per line, i.e.
!            usergrid
!            -1.01
!            -0.55
!            10.01
!              .!              .
!              .
!
!     More than one grid may be specified, and grids can
!     overlap, for example:
!
!     egrid -10 10 0.1
!     kgrid  0  15 0.5
!
!     will make overlapping grids going from E = -10 eV to
!     k = 15 Angstrom**(-1). Up to 10 different grids can be
!     defined.
!     If the 'last' keyword is used in the GridMin field, i.e.
!        expgrid  last  100
!     the specified grid will start where the last grid ended.
!     This is usefull when defining non-overlapping k/e grids.
!     Comments lines have #,!,c, or * at the beginning.
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
!     Input:
!     nGridMax - max number of grids that can be defined.
!     nex      - max number of energy points
      INTEGER nGridMax, nex

!     Output:
!     nGrid     - number of grids defined in file
!     iGridType - Type of grid. (0 = user, 1 = energy, 2 = k, 3 = exponential)
!     GridMin   - Minimum value of grid.
!     GridMax   - Maximum value of grid.
!     GridStep  - Step size.
!     ne        - number of energy points
!     em(nex)        - energy grid
      INTEGER nGrid, iGridType(nGridMax), ne
      DOUBLE PRECISION GridMin(nGridMax), GridMax(nGridMax),
     &     GridStep(nGridMax)
      COMPLEX*16 em(nex)

!     Local Variables:
!     ios      - i/o error flag
!     iUGrid   - unit number for grid.inp
!     RealE    - real part of energy
!     ImagE    - imaginary part of energy
!     nWords   - number of words in the line
!     Words(4) - array of words
!     line     - string to hold line
!     ieMin    - index of minimum of user defined grid
!     ieMax    - index of max of user defined frid
      INTEGER ios, iUGrid, nWords, ieMin, ieMax
      DOUBLE PRECISION RealE, ImagE
      CHARACTER(20) Words(10)
      CHARACTER(100) line

!     Loop Variables:
      INTEGER i1, i2

!     Externals
      LOGICAL isnum
      EXTERNAL isnum

      iUGrid = 22
      OPEN(unit=iUGrid,file='grid.inp',status='old',iostat=ios)
      CALL CHOPEN(ios, 'grid.inp', 'xsph')
      
      DO nGrid = 1, nGridMax
!        Read comment lines
         CALL rdcmt(iUGrid,'#!*C')
!        Read data line into string variable "line" and change to
!        lowercase.
         READ(iUGrid,'(A)',END=5) line
c         CALL lower(line)
!        bwords breaks line into words which are then passed
!        back in Words array
         nWords = 4
         CALL untab(line)
         CALL bwords(line,nWords,Words)

!        Set iGridType
         IF(Words(1).eq.'usergrid') THEN
            iGridType(nGrid) = 0
         ELSEIF(Words(1).eq.'egrid') THEN
            iGridType(nGrid) = 1
c            IF(nwords.ne.4) CALL GridError('Error in grid.inp', line)
         ELSEIF(Words(1).eq.'kgrid') THEN
            iGridType(nGrid) = 2
         ELSEIF(Words(1).eq.'expgrid') THEN
            iGridType(nGrid) = 3
         END IF
         
         IF(iGridType(nGrid).ne.0) THEN
            IF(Words(2).eq.'last') THEN
               ! Set the grid minimum to the max of the last grid.
               IF(nGrid.gt.1) THEN
                  CALL SetGridMin(GridMin,GridMax,GridStep,iGridType,
     &                 nGrid)
               ELSE
                  GridMin(1) = 0.d0
               END IF
            ELSE
               READ(Words(2),*) GridMin(nGrid)
            END IF
            READ(Words(3),*) GridMax(nGrid)
            READ(Words(4),*) GridStep(nGrid)
         END IF

         IF(iGridType(nGrid).eq.0) THEN
!        User defined points: read from file.
            DO i2 = 1, nex
               ! Read comments
               CALL rdcmt(iUGrid,'#!*C')
               ! Read line
               READ(iUGrid,'(A)',END=5) line
               nwords = 2
               ! break line into words
               CALL untab(line)
               CALL bwords(line,nWords,Words)
               ! if first word is number, Real(em) = num
               IF(isnum(Words(1))) THEN
                  READ(Words(1),*) RealE
                  ! if second word exists and is a num, Im(em) = num
                  IF((nWords.ge.2).and.isnum(Words(2)))
     &                 READ(Words(2),*) ImagE                  
                  em(i2) = (RealE + coni*ImagE)
                  ne = ne + 1
               ! If first word is not a number, exit loop and read line again.   
               ELSE
                  ! Set GridMax and GridMin for reference
                  GridMin(nGrid) = DBLE(em(ne - i2 + 1))
                  GridMax(nGrid) = DBLE(em(ne))

                  BACKSPACE(iUGrid)
                  EXIT
               END IF
            END DO
         END IF
      END DO
 5    CONTINUE
      nGrid = nGrid - 1

      DO i1 = 1, nGrid
         IF(iGridType(i1).eq.2) THEN
!     k-Grid. Set units to bohr**(-1)
            GridMin(i1) = GridMin(i1)*bohr
            GridMax(i1) = GridMax(i1)*bohr
            GridStep(i1) = GridStep(i1)*bohr
         ELSE
!     e-grid. Set units to hartrees
            GridMin(i1) = GridMin(i1)/hart
            GridMax(i1) = GridMax(i1)/hart
            GridStep(i1) = GridStep(i1)/hart
         END IF
      END DO
      DO i1 = 1, ne
         em(i1) = em(i1)/hart
      END DO

      CLOSE(iUGrid)
      RETURN
      END

      SUBROUTINE SetGridMin(GridMin, GridMax, GridStep, iGridType,
     &     nGrid)
!     This sets the minimum of the current grid to the maximum of the last grid + GridStep
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
!     Input:
!     GridMin   - array that holds grid minima
!     GridMax   - array that holds grid maxima
!     GridStep  - array of steps
!     iGridType - array of grid types
!     nGrid     - current grid
      INTEGER nGrid
      INTEGER iGridType(nGrid)
      DOUBLE PRECISION GridMin(nGrid), GridMax(nGrid), GridStep(nGrid)

!     Output: GridMin(nGrid) (minimum of current grid.

      IF((iGridType(nGrid).ne.2).and.(iGridType(nGrid-1).ne.2).or.
     &    (iGridType(nGrid).eq.iGridType(nGrid-1))) THEN
!     If neither grid is a k grid, or if both are k-grid, just set the minimum to the previous
!     maximum.
         GridMin(nGrid) = GridMax(nGrid-1) + GridStep(nGrid)
      ELSEIF(iGridType(nGrid).eq.2) THEN
!     If current grid is k, kmin = sqrt(2*emax)
         GridMin(nGrid) =
     &        SQRT(2*GridMax(nGrid-1)/hart)/bohr + GridStep(nGrid)
      ELSE
!     If current grid is e, emin = k**2/2
         GridMin(nGrid) =
     &        (GridMax(nGrid-1)*bohr)**2/2*hart + GridStep(nGrid)
      END IF

      RETURN
      END

      SUBROUTINE GridError(message, line)
      CHARACTER(300) message, line
      
      CALL wlog(message)
      CALL wlog(line)
      STOP

      RETURN
      END
c///////////////////////////////////////////////////////////////////////
c FEFF PROGRAMS (referred below as a System)
c Copyright (c) 1986-2002, University of Washington.
c 
c END-USER LICENSE 
c 
c A signed End-user License Agreement from the University of Washington
c Office of Technology Transfer is required to use these programs and
c subroutines.
c 
c See the URL: http://leonardo.phys.washington.edu/feff/
c 
c USE RESTRICTIONS:
c 
c 1. The End-user agrees that neither the System, nor any of its
c components shall be used as the basis of a commercial product, and
c that the System shall not be rewritten or otherwise adapted to
c circumvent the need for obtaining additional license rights.
c Components of the System subject to other license agreements are
c excluded from this restriction.
c
c 2. Modification of the System is permitted, e.g., to facilitate
c its performance by the End-user. Use of the System or any of its
c components for any purpose other than that specified in this Agreement
c requires prior approval in writing from the University of Washington.
c
c 3. The license granted hereunder and the licensed System may not be
c assigned, sublicensed, or otherwise transferred by the End-user.  
c
c 4. The End-user shall take reasonable precautions to ensure that
c neither the System nor its components are copied, or transferred out
c side of his/her current academic or government affiliated laboratory
c or disclosed to parties other than the End-user.
c 
c 5. In no event shall the End-user install or provide this System
c on any computer system on which the End-user purchases or sells
c computer-related services.
c 
c 6. Nothing in this agreement shall be construed as conferring rights
c to use in advertising, publicity, or otherwise any trademark or the
c names of the System or the UW.   In published accounts of the use or
c application of FEFF the System should be referred to  by this name,
c with an appropriate literature reference:
c 
c FEFF8: A.L. Ankudinov, B. Ravel, J.J. Rehr, and S.D. Conradson,
c        Phys. Rev. B 58, pp. 7565-7576 (1998).
c
c LIMITATION OF LIABILITY:
c
c 1.   THE UW MAKES NO WARRANTIES , EITHER EXPRESSED OR IMPLIED, AS TO
c THE CONDITION OF THE SYSTEM, ITS MERCHANTABILITY, OR ITS FITNESS FOR
c ANY PARTICULAR PURPOSE.  THE END-USER AGREES TO ACCEPT THE SYSTEM
c 'AS IS' AND IT IS UNDERSTOOD THAT THE UW IS NOT OBLIGATED TO PROVIDE
c MAINTENANCE, IMPROVEMENTS, DEBUGGING OR SUPPORT OF ANY KIND.
c
c 2. THE UW SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL,
c INCIDENTAL OR CONSEQUENTIAL DAMAGES SUFFERED BY THE END-USER OR ANY
c OTHER PARTIES FROM THE USE OF THE SYSTEM.
c
c 3.  The End-user agrees to indemnify the UW for liability resulting
c from the use of the System by End-user. The End-user and the UW each
c agree to hold the other harmless for their own negligence.
c
c TITLE:
c
c 1.  Title patent, copyright and trademark rights to the System are
c retained by the UW. The End-user shall take all reasonable precautions
c to preserve these rights.
c 
c 2.  The UW reserves the right to license or grant any other rights to
c the System to other persons or entities.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c
      subroutine fmsie( iph0, nph, lipotx, ie, em, eref, ph, iz,
     1                 rfms, lfms, nat, iphat, rath, gtr)

c     full multiple scattering code for single energy point
c     written by a.ankudinov 06.1997 using earlier written subroutines
c     coded by b.ravel
c     modified by a.ankudinov 2001 for new matrix inversion algorithms
c     Feb. 2002, a.ankudinov: fixed logic for MPI calculations
c       lfms=0  - extended system calculataions (e.g. crystal)
c       lfms=1  - small system calculations (e.g. molecule)
c       lfms=2  - same as 1 for MPI run (forces call yprep)

      implicit double precision (a-h, o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     input
      dimension iphat(natx), rath(3,natx)
      real rat(3,natx), rfms, rdirec, toler1, toler2
      real rpart,aipart
      integer nph
      dimension iz(0:nphx)
      complex*16 ph(lx+1, 0:nphx)

c     work space
      integer iph0
      complex*16 em, eref
      character*512 slog
      logical lcalc
      dimension lcalc(0:lx)
c     fms staff
      integer lipotx(0:nphx)
      complex gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphx)
      complex gtr(0:lx, 0:nphx)
      complex xphase(nspx, -lx:lx, 0:nphx), ck(nspx)
      complex*16 dck
      complex conis
      parameter (conis = (0,1))
      real  temper, thetax, sig2
      save

      if (rfms .le. 0.0) goto 900

c     set default (LU) inv method
      minv = 0
      rdirec = 2*rfms
      toler1 = 0.e0
      toler2 = 0.e0

      do 30 iat=1,nat
      do 30 j=1,3
   30 rat(j,iat) = real (rath(j,iat))

c     transform to single precision
      temper =0.0e0
      thetax =0.0e0
      sig2  = 0.0e0

c      it will be nice to call yprep once for all energy points,
c      fix later, and now call it every time
      if (ie.eq.1 .or. lfms.eq.0 .or. lfms.eq.2) 
     1  call yprep(iph0, nat, inclus, nph, iphat, rfms, rat,
     2     iz, rdirec )

      if (inclus.gt.1) then

cc     call fms for a cluster around central atom
       if (ie.eq.1) then
          write (slog,35) inclus, iph0
  35      format ('        Doing FMS for a cluster of ',i3,
     1    ' atoms around iph = ',i2)
          call wlog (slog)
       endif

       dck=sqrt(2*(em-eref))
       rpart  = dble(dck)
       aipart = real(dimag(dck))
       ck(1) = cmplx(rpart, aipart)
       do 1020 ipp = 0,nph
         do 1010 ill = -lipotx(ipp), lipotx(ipp)
           rpart  = dble( ph( 1+abs(ill), ipp))
           aipart = dimag(ph( 1+abs(ill), ipp)) 
           xphase(1, ill, ipp) = cmplx(rpart, aipart)
 1010    continue
 1020  continue
       iverb=0
       if (ie.eq.1) iverb = 1
       nsp = 1
       ispin = 0
       do 1011 ill = 0,lx
 1011  lcalc(ill) = .true.
       call fms(lfms, nsp, ispin, inclus, nph, ck, lipotx, xphase, ie,
     1  iverb, minv, rdirec, toler1, toler2, lcalc, gg)

c      make ck= i, since coni is c*16
       do 1030 ip=0,nph
         if (lfms.ne.0 .or. ip.eq.iph0) then
           do 1040 il=0,lipotx(ip)
             ix = il**2
             do 1050 im=1,2*il+1
               gtr(il, ip) = gtr(il, ip) + gg(ix+im,ix+im,ip)
 1050        continue
             gtr(il,ip)= gtr(il,ip)*
     1            exp(2*conis*xphase(1,il,ip))/(2*il+1)
 1040      continue
         endif
 1030  continue
      endif

 900  continue
      return
      end
      subroutine fms(lfms, nsp, ispin, inclus, npot, ck, lipotx, xphase,
     1   ik, iverb, minv, rdirec, toler1, toler2, lcalc, gg)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c--------------------------------------------------------------------
c  compute full multiple scattering within some cluster at some
c  energy 
c  This uses the LU decomposition package from LAPACK.  Driver
c  routines: cgetrf (decomposition), cgetrs (backsubstitution)
c  coded by b.ravel
c  modified by a.l.ankudinov to include spin and SO interactions
c  feb 2000
c
c  dim.h and xparam.h must be included in the calling routine
c
c  most of the information needed by this package is set into common
c  blocks the companion package xprep.  In that package, the lists of
c  atomic coordinates and potential indeces are organized so that the
c  first npot+1 entries are examples of each of the unique potentials.
c  Consequently, only the upper left hand corner of the FMS matrix
c  need be recomposed to get the set of submatrices necessary to
c  compute chi for each type of atom in the cluster.
c
c  See subroutine fmstot.f for an example of decoding the output of this
c  subroutine. The third index of gg refers to the unique potential with
c  element 0 being the absorbing atom.  
c  The first two indeces are related to the |lms> state by the
c  formula:
c       nsp=1, no spin indeces
c       lm  = ( l**2 + 1 ) + ( l + m )
c            thus {1..(lx+1)^2} ==>
c            {0,0 1,-1 1,0 1,1 2,-2 2,-1 2,0 2,1 2,2 ...
c                   lx,lx-1 lx,lx}
c       nsp=2, with spin indeces
c       lms  = 2*( l**2 + 1 ) + 2*( l + m ) + (s-1/2)
c            thus {1...2*(lx+1)^2} ==>
c            {0, 0,-1/2  0. 0,1/2
c             1,-1,-1/2  1,-1,1/2  1,0,-1/2  1,0,1/2  1,1,-1/2 1,1,1/2
c             2,-2,-1/2  2,-2,1/2  2,-1,-1/2 2,-1,1/2 ...    lx,lx,1/2}
c
c  The calling protocol for xpreppack and fmspack is;
c          include 'dim.h'
c          include 'xparam.h'
c          ...
c          call xprep(nat, inclus, npot, iphat, rmax, rat,
c     $            xnrm, izx, temper, thetad)
c          energy loop {
c             ...
c             call fms(nsp, inclus, npot, ck, lipotx, xphase,
c                      ik, iverb, gg)
c             ... }
c
c  fmspack contains the following routines:
c    fms.f:     main routine of fmspack
c    kets.f:    compute all state kets for current energy
c    xclmz.f:   compute hankle-like polynomials for current energy
c    xgllm.f:   compute z-axis propagators for current energy
c    cgetrf.f:  LU decomposition of matrix
c    cgetrs.f:  backsubstitution of LU decomposed matrix
c    lu_misc.f: various routines called by LU package
c
c---------------------------------------------------------------------
c  input
c    nsp:    1) no spin indeces 2) with spin indeces
c    inclus: number of atoms in cluster
c    npot:   number of unique potentials in cluster
c    ck:     complex momentum of current energy point
c    lipotx: (0:nphasx) max l for each unique potential
c    xphase: (0:lx, 0:nphasx) single complex array of partial wave
c            phase shifts for each unique potential
c    ik:     current energy grid index, used for run-time messages
c    iverb:  do nothing when iverb <= 0
c            1  => write a message about grid point and matrix size
c
c  passed in common from xprep package (xstruc.h)
c    xrat:   (3,nclusx) array of coordinates with first npot+1
c            elements each a unique potential
c    xphi:   (nclusx, nclusx) angles between z axis and vectors
c            connecting the atoms in the cluster
c    iphx:   (nclusx) potential index of each atom in the cluster
c    drix:   huge matrix containing all rotation matrix elements
c            needed for computation of free electron propagators
c    xnlm:   matrix of legendre polynomial normalization factors
c    xpsile: matrix containing wave functions for hybridization
c            calculation
c    sigsqr: (nclusx,nclusx) matrix of pair-wise mean square
c            displacements about interatomic distances.  Currently only
c            calculated by the correlated debye model.
c
c  output
c    gg:  (nsp*lx**2, nsp*lx**2, 0:nphasx) submatrix spanning the entire
c          angular momentum basis for each unique potential

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c====================================================================
c  This common block contains the structural information about the
c  cluster to be used for the full multiple scattering calculation
c  xphi:  matrix of angles between the z axis and pairs of atoms
c  xrat:  xyz coordinates of the atoms in the cluster, the first
c         npot+1 entries are examples of each unique potential
c  iphx:  potential indeces of each atom in the cluster, ordered like
c         xrat
      common /xstruc/ xphi(nclusx,nclusx), xrat(3,nclusx),
     $            iphx(nclusx)
      save /xstruc/
c********************************************************************
c**** rotation matrices for entire cluster
c
      complex drix
      common /rotx/ drix(-lx:lx, -lx:lx, 0:lx, 0:1, nclusx, nclusx)
      save /rotx/
c********************************************************************
c common blocks for saving rotation matrices between xanes and rotxan
       integer    jsavx, jsav, jbmagk
       parameter (jsavx = 150, roteps = 1.e-12,jbmagk=-9999)
       dimension drisav(-lx:lx,-lx:lx,0:lx,jsavx), betsav(jsavx)
       integer   ldsav(jsavx), mdsav(jsavx)
       common /rotsav/  drisav, betsav, ldsav, mdsav, jsav
       save  /rotsav/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /lnlm/ xnlm(0:lx,0:lx)
      save   /lnlm/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /xdwf/ sigsqr(nclusx,nclusx)
      save   /xdwf/
c********************************************************************
c**** save Clebsch-Gordon coefficients: <LS|J>
      dimension t3jp(0:lx, -lx:lx, 2), t3jm(0:lx, -lx:lx, 2)
      common /t3j/ t3jp, t3jm
      save   /t3j/

c********************************************************************
      parameter (pi = 3.14159 26535 89793 23846 26433e0)
      parameter (bohr = 0.529 177 249e0)
      parameter (one = 1, zero = 0)
      complex coni
      parameter (coni = (0,1))
      complex   term, prefac, gllmz, ck(nspx)
      complex   clm(lx+2, 2*lx+3), xclm(0:lx, 0:lx, nclusx, nclusx,nspx)
      complex   xrho( nclusx, nclusx, nspx)
      integer   lipotx(0:nphasx)

c********************************************************************
c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate
      save   /stkets/
      complex   xphase(nspx, -lx:lx, 0:nphasx)
      complex   tmatrx(nspx, istatx)
c     big work matrices
      complex   g0(istatx,istatx), g0t(istatx,istatx)
      logical lcalc
      dimension lcalc(0:lx)
c     return matrix containing info about each unique potential
      complex   gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphasx)

      integer i0(0:nphx)
      character*3  cerr, dec
      character*13 trans
      character*75 messg

 400  format(i4)

      do 10 i=0,nphx
        if (lipotx(i).le.0)  lipotx(i) = lx
        if (lipotx(i).gt.lx) lipotx(i) = lx
        i0(i) = -1
 10   continue
c     initialize gg to zero
      do 20 i = 0, nphasx
        do 18 j = 1, nspx*(lx+1)**2
          do 16 k = 1, nspx*(lx+1)**2
            gg( k, j, i) = cmplx( zero, zero)
 16       continue
 18     continue
 20   continue

      if (lfms.eq.0) then
        ipi = iphx(1)
        ipf = iphx(1)
      else
        ipi = 0
        ipf = npot
      endif
c --- get basis kets; output array 'lrstat' passed through common
      call getkts(nsp, inclus, npot, iphx, lipotx, i0)

c --- sanity check for i0(ip)
      do 30 ip = ipi, ipf
        if (i0(ip) .lt. 0) then
          call wlog (' Cannot find all representative atoms')
          call wlog (' Increase FMS radius and rerun.')
          call par_stop(' In subroutine FMS')
        endif
  30  continue

c --- runtime message if requested
      if (iverb.gt.0 .and. minv.eq.0) then
         dec = 'LUD'
         write(messg, 4010)this_process,dec, ik, istate
 4010    format('  ',i3,'   FMS matrix (', a, ') at point ', i3,
     $               ', number of state kets =', i4)
         call wlog(messg)
      endif

c --- get all c_lm(z) values for this energy, i,j sum over all atom
c     pairs xrho and xclm are symmetric in ij
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
c  nota bene, in the code for setting the clmz, the indexing starts
c  at 1 rather than 0.  To my mind, that is confusing, so here I
c  reindex when I copy from clm to xclm.  See the note about this in
c  subroutine xclmz
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      lplus1 = lx+1
      mplus1 = lx+1
      do 140  i=1,inclus
        do 130 j=1,i

c ------- get and store rho for this pair of atoms   bohr units on
c         r and ck
          r   = zero
          do 100 ix=1,3
            r = r + (xrat(ix,i) - xrat(ix,j))**2
 100      continue
          r   = sqrt(r)

          do 125 isp = 1,nsp
             xrho(i,j,isp) = ck(isp) * r
             xrho(j,i,isp) = xrho(i,j,isp)

c ------- store the c_lm(z) for all the rhos at this energy
c            xclm(i,j) = xclm(j,i) by symmetry
             if (i.ne.j) call xclmz(lplus1,mplus1,xrho(i,j,isp),clm)
             do 120 ll = 0,lx
               do 110 mm = 0,lx
                 if (i.eq.j) then
                     xclm(mm,ll,j,i,isp) = cmplx(zero,zero)
                 else
                     xclm(mm,ll,j,i,isp) = clm(ll+1,mm+1)
                     xclm(mm,ll,i,j,isp) = clm(ll+1,mm+1)
                 endif
 110           continue
 120         continue
 125      continue

 130    continue
 140  continue

c --- fill the G0 and T matrices for this energy
      rdir2 = rdirec**2
      do 220 ist1=1,istate
        iat1 = lrstat(1, ist1)
        l1   = lrstat(2, ist1)
        m1   = lrstat(3, ist1)
        isp1 = lrstat(4, ist1)

        do 210 ist2=1,istate
          iat2 = lrstat(1, ist2)
          l2   = lrstat(2, ist2)
          m2   = lrstat(3, ist2)
          isp2 = lrstat(4, ist2)

          rr = (xrat(1,iat1)-xrat(1,iat2))**2 +
     1    (xrat(2,iat1)-xrat(2,iat2))**2 +(xrat(3,iat1)-xrat(3,iat2))**2

c                               equation 9 in Rehr, Albers
c                               <LR| G |L'R'>

          if (iat1.eq.iat2) then
c             same atom: G=0, calculate T-matrix 
              g0(ist1,ist2)     = cmplx(zero,zero)
c             notice that T is tri-diagonal, due to conservation of
c             total momentum.(will be broken by nonspherical potential)
c             --- potential index for this atom
              iph = iphx(iat1)
            if (nsp.eq.1.and.ispin.eq.0) then
              if (ist1.eq.ist2) tmatrx(1, ist1) =
     $                    ( exp(2*coni*xphase(isp1,l1,iph)) - one )
     $                    / (2*coni) 
            else
              if (ist1.eq.ist2) then
c                set spin index for t3jm and t3jp
                 is = isp1
                 if (nsp.eq.1) then
c                  special case
                   is = 1
                   if (ispin.gt.0) is = 2
                 endif

c                diagonal matrix element
                 tmatrx(1, ist1) =
     $                    ( exp(2*coni*xphase(isp1,l1,iph)) - one )
     $                    / (2*coni) * t3jm (l1, m1, is)**2  + 
     $                    ( exp(2*coni*xphase(isp1,-l1,iph)) - one )
     $                    / (2*coni) * t3jp (l1, m1, is)**2 
              elseif (nsp.eq.2.and.l1.eq.l2.and.m1+isp1.eq.m2+isp2) then
c                same orb. mom. and total momentum projections conserved
c                calculate off-diagonal T-matrix element
c                tmatrx(2, ist1) = here only if nspx equal to 2
                 tmatrx(nsp, ist1) =
     $             ( exp(2*coni*xphase(isp1, l1,iph)) - one +
     $               exp(2*coni*xphase(isp2, l1,iph)) - one ) / (4*coni) 
     1             * t3jm (l1, m1, isp1) * t3jm (l1, m2, isp2)  + 
     $             ( exp(2*coni*xphase(isp1,-l1,iph)) - one +
     $               exp(2*coni*xphase(isp2,-l1,iph)) - one ) / (4*coni) 
     1             * t3jp (l1, m1, isp1) * t3jp (l1, m2, isp2)
              endif
            endif
          elseif (isp1.eq.isp2 .and. rr.le.rdir2) then
c           different atoms, same spin: T=0, calculate G
            g0(ist1,ist2) = cmplx(zero,zero)
            do 200 mu=-l1,l1
c             --- third arg in drix: 0==>beta, 1==>-beta
              muabs = abs(mu)
              call xgllm(muabs, ist1, ist2, lrstat,
     1                   xclm(0,0,1,1,isp1), gllmz )
              g0(ist1,ist2) = g0(ist1,ist2) +
     2             drix(mu,m1,l1,1,iat2,iat1) *  gllmz *
     3             drix(m2,mu,l2,0,iat2,iat1)
 200        continue
            prefac = exp(coni*xrho(iat1,iat2,isp1)) /
     $                  xrho(iat1,iat2,isp1)
c           use correlated debye model, sigsqr is in AA^2
            prefac = prefac * exp(-1 * sigsqr(iat1,iat2) *
     $                  ck(isp1)**2 / bohr**2)
            g0(ist1,ist2) = prefac * g0(ist1,ist2)
          else
c           different atoms, different spins:T=G=0
            g0(ist1,ist2) = cmplx(zero,zero)
          endif

c -----   end of loops over states
 210    continue
 220  continue

      if (minv.eq.0) then
         call gglu ( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg)
      elseif (minv.eq.1) then
         dec = 'VdV'
         call ggbi ( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1              toler1, toler2, lcalc, msord)
      elseif (minv.eq.2) then
         dec = 'LLU'
         call ggrm ( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1              toler1, toler2, lcalc, msord)
      elseif (minv.eq.3) then
         dec = 'GMS'
         call gggm ( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1              toler1, toler2, lcalc, msord)
      else
         dec = 'TF'
         call ggtf ( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1              toler1, toler2, lcalc, msord)
      endif
      if (minv.ne.0) then
         write(messg, 410)this_process,dec, ik, istate, msord
 410     format('  ',i3,'. Iterative FMS (', a, ') at point ', i3,
     $               '; matrix size =', i4,'; MS order =',i5)
         call wlog(messg)
      endif

      return
      end
c--------------------------------------------------------------------
      subroutine getkts(nsp, nat, npot, iphx, lipotx, i0)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c--------------------------------------------------------------------
c  construct state kets |iat,l,m> at this energy
c--------------------------------------------------------------------
c  input
c    nat:    number of atoms in cluster
c    npot:   number of unique potentials
c    iphx:   (nclusx) potential index of each atom in the cluster
c    lipotx: (nphasx) maximum angular momentum to consider for each
c            ipot
c  output
c   (istate: number of states  ---  passed in kets.h)
c    i0:     index shift for each potential representative
c   (lrstat: (4, istatx) state kets |iat,l,m> --- passed in kets.h)
c--------------------------------------------------------------------
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c********************************************************************
c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate
      save   /stkets/
      integer   lipotx(0:nphasx), iphx(nclusx), i0(0:nphx)

      istate = 0
      do 120 iat=1,nat
        ip = iphx(iat)
c       i0(ip) - index for the ip-representative atom
c       need for simple find of states for ip-representative.
        if (i0(ip).lt.0) i0(ip) = istate
        lim = min(lx, lipotx(ip))
        do 110 l=0,lim
          do 100 m = -l, l
          do 100 isp = 1, nsp
            istate = istate + 1
            if (istate.gt.istatx) then
                call wlog('Exceeded maximum number of LR states.'//
     $                      '  Stopping')
                call par_stop('GETKTS-1')
            endif
            lrstat(1,istate) = iat
            lrstat(2,istate) = l
            lrstat(3,istate) = m
            lrstat(4,istate) = isp
 100      continue
 110    continue
 120  continue

      return
c end subroutine kets
      end
c    ----------------------------------------------------------------
      subroutine xclmz(lmaxp1,mmaxp1,rho,clm)
      implicit real(a-h,o-z)

c     calculates energy dependent factors needed in subroutine gllm
c     c(il,im) = c_l^(m)z**m/m!=c_lm             by recursion
c     c_l+1,m  = c_l-1,m-(2l+1)z(c_l,m-c_l,m-1)  l ne m
c     c_m,m    = (-z)**m (2m)!/(2**m m!)         with z=1/i rho
c
c  input:
c    lmaxp1, mmaxp1:  largest angular momentum under consideration + 1
c    rho:  distance between atoms * complex momentum at this energy
c          point
c  output:
c    clm(lx+1,lx+1):  Hankle-like polynomials from RA

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      parameter (one = 1, zero = 0)
      complex coni
      parameter (coni = (0,1))
      parameter (ltotb=lx+1,mtotb=ltotb,ntotb=ltotb,mntot=mtotb+ntotb)
      complex z, cmm, clm(ltotb+1,mntot+1), rho

      cmm  = cmplx(one, zero)
      z    = (-coni)/rho

      clm(1,1) = cmplx(one,zero)
      clm(2,1) = clm(1,1) - z

      lmax = lmaxp1-1
      do 20 il=2,lmax
        clm(il+1,1) = clm(il-1,1) - (z * (2*il-1) * clm(il,1))
 20   continue
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
c  nota bene:  the 2l-1 factor above is correct, even though in Rehr,
c  Albers equation 4 appears with a 2l+1.  The reason has to do with
c  the indexing.  in RA the subscripts on the c's start at 0.  In this
c  piece of code, the subscripts start at 1.  If you sub l-1 for
c      l, 2l+1 --> 2l-1
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


      mmxp1 = min(lmaxp1, mmaxp1)
      do 40 im=2,mmxp1
        m    = im-1
        imp1 = im+1
        cmm  = (-cmm) * (2*m-1) * z
        clm(im,im)   = cmm
        clm(imp1,im) = cmm * (2*m+1) * (1-im*z)
        do 30 il=imp1,lmax
          clm(il+1,im) = clm(il-1,im) - (2*il-1) * z *
     $                               ( clm(il,im)+clm(il,m) )
c           l = il-1
c           clm(il+1,im) = clm(l,im) - (2*l+1) * z *
c      $                               ( clm(il,im)+clm(il,m) )
 30     continue
 40   continue

      return
c  end subroutine xclmz
      end
      subroutine xgllm(mu, ist1, ist2, lrstat, xclm, gllmz)
c--------------------------------------------------------------------
c  this calculates equations 11,12 from Rehr, Albers PRB v.41,#12,
c  p.8139,  the output is the G term in equation 9 from that paper
c
c  input:
c    mu:         abs val of magnetic state in sum in eqn 11 RA, mu>=0
c    ist1, ist2: state indices of mat. elem., first index of lrstat
c    lrstat:     (4,istatx,nkmin:nex) array of LR states
c    xclm:       (0:lx,0:lx,nclusx,nclusx) array of c_lm(z) for
c                present energy value
c  output:
c    gllmz:      g_ll'^|m|(z), for present state & energy, eqn 11 RA
c--------------------------------------------------------------------
c  this requires that N_lm normalization factors and c_lm(z)
c  polynomials have already been calculated.
c--------------------------------------------------------------------
      implicit real(a-h,o-z)
      implicit integer (i-n)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c====================================================================
c  This header file contains the structural information about the
c  cluster to be used for the full multiple scattering calculation

      common /xstruc/ xphi(nclusx,nclusx), xrat(3,nclusx),
     $            iphx(nclusx)
      save /xstruc/

c  xphi:  matrix of angles between the z axis and pairs of atoms
c  xrat:  xyz coordinates of the atoms in the cluster, the first
c         npot+1 entries are examples of each unique potential
c  iphx:  potential indeces of each atom in the cluster, ordered like
c         xrat
c********************************************************************
c**** rotation matrices for entire cluster
c
      complex drix
      common /rotx/ drix(-lx:lx, -lx:lx, 0:lx, 0:1, nclusx, nclusx)
      save /rotx/
c********************************************************************
c common blocks for saving rotation matrices between xanes and rotxan
       integer    jsavx, jsav, jbmagk
       parameter (jsavx = 150, roteps = 1.e-12,jbmagk=-9999)
       dimension drisav(-lx:lx,-lx:lx,0:lx,jsavx), betsav(jsavx)
       integer   ldsav(jsavx), mdsav(jsavx)
       common /rotsav/  drisav, betsav, ldsav, mdsav, jsav
       save  /rotsav/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /lnlm/ xnlm(0:lx,0:lx)
      save   /lnlm/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /xdwf/ sigsqr(nclusx,nclusx)
      save   /xdwf/

c  end of xstruc.h
c********************************************************************

      parameter (zero=0.e0)
      integer    lrstat(4, istatx)
      complex xclm(0:lx, 0:lx, nclusx, nclusx), sum, gllmz
      complex gam, gamtl

      iat1     = lrstat(1, ist1)
      l1       = lrstat(2, ist1)
      iat2     = lrstat(1, ist2)
      l2       = lrstat(2, ist2)
      numax    = min(l1, l2-mu)

      sum      = cmplx(zero, zero)
      do 100 nu=0,numax
        mn    = mu+nu

c       bug for xnlm with nspx=2
        gamtl = (2*l1+1) * xclm(nu, l1, iat2, iat1) / xnlm(mu, l1)
        gam   = (-1)**mu * xclm(mn, l2, iat2, iat1) * xnlm(mu, l2)

        sum   = sum + gamtl * gam
 100  continue

      gllmz = sum

      return
c  end subroutine gllm
      end

c====================================================================
      subroutine gglu( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c  output
c    gg:  (nsp*lx**2, nsp*lx**2, 0:nphasx) submatrix spanning the entire
c          angular momentum basis for each unique potential

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      integer  i0 (0:nphx),  lipotx(0:nphx)

      parameter (one = 1, zero = 0)
      integer   ipiv(istatx)

c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate

      complex   tmatrx(nspx, istatx)
c     big work matrices
      complex   g0( istatx, istatx), g0t( istatx, istatx)
      complex   g0s( istatx, nspx*(lx+1)**2)
c     return matrix containing info about each unique potential
      complex   gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphasx)

      character*3  cerr
      character*13 trans

 400  format(i4)


c -------------------- LU gg
c     multiply T and G0 matrices together, construct g0t = 1 - G0*T
c     notice that the signs below for g0t ARE correct since 1 is the
c     unit matrix
c     since t is tri-diagonal, this product can be computed in n^2 time
c     also fill up some work matrices for use in eigenvalue and
c     determinant calculations and elsewhere
      do 320 icol = 1,istate
        do 310 irow = 1,istate
c         T diagonal contribution
          g0t(irow, icol) = - g0(irow, icol) * tmatrx(1, icol)
c         T off-diagonal contribution
          l1   = lrstat(2,icol)
          m1   = lrstat(3,icol)
          isp1 = lrstat(4,icol)
          m2 = m1+isp1
          if (nsp.eq.2 .and. m2.gt.-l1+1 .and. m2.lt.l1+2) then
             ist2 = icol + (-1)**isp1
             g0t(irow, icol) = g0t(irow, icol)
     1                   - g0(irow, ist2) * tmatrx(nsp, icol)
          endif
 310    continue

        g0t(icol, icol) = g0t(icol, icol) + one

 320  continue

c --- invert matrix by LU decomposition
c     call cgetrf from lapack.  this performs an LU decomposition on
c     the matrix g0t = 1 - g0*T
      call cgetrf( istate, istate, g0t, istatx, ipiv, info )
      if (info.lt.0) then
          call wlog('    *** Error in cgetrf when computing G')
          write(cerr,400)abs(info)
          call wlog('        Argument #'//cerr//
     $                ' had an illegal value.')
      elseif (info.gt.0) then
          call wlog('    *** Error in cgetrf when computing G')
          write(cerr,400)info
          call wlog('        g0t('//cerr// ','//cerr//
     $                ') is exactly 0 -- '//
     $                'this matrix cannot be decomposed.')
      endif

c     now we want g_c = (g0t)^-1 * g0.  Rather than calculating
c     the inverse of g0t from the LU decomposition, we can compute
c     g0t^-1 * g0 directly by backsubstituting the columns of G0.
c     See sect. 2.3 in Numerical Recipes or LAPACK Users' Guide
c     sect. 2.3

c     third arg in number of output columns, istate for full
c     matrix, ipart(ik) for just the parts of the matrix needed
c     to contruct fine structure + DOS functions

      do 620 ip=ipi, ipf
        ipart = nsp*(lipotx(ip)+1)**2
        do 590 is1 = 1, istate
        do 590 is2 = 1, ipart
          g0s(is1,is2) = g0(is1, is2 + i0(ip))
  590   continue

        trans = 'NotTransposed'
        call cgetrs(trans, istate, ipart, g0t, istatx,
     $                ipiv, g0s, istatx, info)
        if (info.lt.0) then
            call wlog('    *** Error in cgetrf')
            write(cerr,400) abs(info)
            call wlog('        Argument #'//cerr//
     $              ' had an invalid value.')
        endif

c **** at this point g0s contains the full MS ****

c  pack FMS matrix into an nsp*(lx+1)^2 x nsp*(lx+1)^2 matrix for each
c  ipot

        do 600 is2=1,ipart
        do 600 is1=1,ipart
          gg( is1, is2, ip) = g0s( is1+i0(ip), is2)
 600    continue
 620  continue

      return
      end
      subroutine ggbi( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1                 toler1, toler2, lcalc, msord)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c  output
c    gg:  (nsp*lx**2, nsp*lx**2, 0:nphasx) submatrix spanning the entire
c          angular momentum basis for each unique potential
c     BiCGStab algorithm: Saad, Iterative methods for ..., p. 220 (1996)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      integer  i0 (0:nphx),  lipotx(0:nphx)

      parameter (one = 1, zero = 0)
      complex coni
      parameter (coni = (0,1))

c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate

      complex   tmatrx(nspx, istatx)
c     big work matrices
      complex   g0( istatx, istatx), g0t( istatx, istatx)
      logical lcalc
      dimension lcalc(0:lx)

c     Lanczos method variables
      complex xvec( istatx), yvec(istatx), avec(istatx), asve(istatx)
      complex rvec(istatx), pvec(istatx), svec( istatx)
      complex aa, dd, aw, wa, ww
      complex del, delp, omega, chi, psi
c     return matrix containing info about each unique potential
      complex   gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphasx)

c      notice that in gglu we invert (1-Gt), but here (1-tG).
c     multiply T and G0 matrices together, construct g0t = 1 - T*G0
c     notice that the signs below for g0t ARE correct since 1 is the
c     unit matrix
c     since t is tri-diagonal, this product can be computed in n^2 time
c     also fill up some work matrices for use in eigenvalue and
c     determinant calculations and elsewhere
c     cycle over dimensions of matrix g0t
      do 10 icol = 1,istatx
      do 10 irow = 1,istatx
 10   g0t(irow,icol) = 0

      do 30 icol = 1,istate
        do 20 irow = 1,istate
c         T diagonal contribution T(irow, irow)
          if ( abs( g0(irow, icol)) .gt. toler2 )
     1    g0t(irow,icol)=g0t(irow,icol) - tmatrx(1,irow) * g0(irow,icol) 

c         T off-diagonal contribution T(ist2, irow) in tmatr(2,irow)
c         T off-diagonal contribution T(irow, ist2) in tmatr(2,ist2)
          l1   = lrstat(2,irow)
          m1   = lrstat(3,irow)
          isp1 = lrstat(4,irow)
          m2 = m1+isp1
          if (nsp.eq.2 .and. m2.gt.-l1+1 .and. m2.lt.l1+2) then
c            spin-flip contribution
             ist2 = irow + (-1)**isp1
             if ( abs( g0(ist2, icol)) .gt. toler2)
     1       g0t(irow, icol) = g0t(irow, icol)
     2                   - tmatrx(nsp, ist2) * g0(ist2, icol) 
          endif
 20     continue

        g0t(icol, icol) = g0t(icol, icol) + one
 30   continue

      do 920 ip=ipi, ipf
        ipart = nsp*(lipotx(ip)+1)**2
        do 910 is1 = 1, ipart
          is2 = is1+i0(ip)
          l1   = lrstat(2,is2)
          if (.not.lcalc(l1)) goto 910

c         start first tier with xvec=0
          istart = -1
          msord = 0
          do 40 is = 1, istate
          avec(is) = 0
  40      xvec(is) = 0

c         RESTART here if necessary
  50      continue
          istart = istart+1

          if (istart.gt.0) call matvec( istatx,istate,g0t,xvec,avec,1)
          do 90 is = 1,istate
 90       rvec(is) = - avec(is)
c         rvec = bvec - g0t*xvec , in our case bvec(is) = delta_{is,is2}
          rvec(is2) = rvec(is2) + 1
cc          Check convergence criteria: |r_n+1| < tol
            ipass = 1
            do 92 is = 1, istate
              if ( abs(real(rvec(is))).gt.toler1) goto 93
              if ( abs(aimag(rvec(is))).gt.toler1) goto 93
 92         continue
            ipass = 0
 93         continue
            if (ipass.eq.0) goto 700

          do 95 is = 1, istate
 95       pvec(is) = rvec(is)
          call matvec( istatx,istate,g0t,pvec,avec,1)
          msord = msord + 1

c         choose yvec that del and delp close to one
          call cdot( istatx, istate, avec, avec, aa)
          call cdot( istatx, istate, rvec, avec, wa)
          aw = real(wa) - coni* aimag(wa)
          call cdot( istatx, istate, rvec, rvec, ww)
          dd = aa*ww - aw*wa
          if (abs(dd/aa/ww) .lt.1.e-8) then
            do 96 is = 1,istate
  96        yvec(is) = rvec(is) / ww
          else
            ww = ( ww - aw ) / dd
            aa = ( wa - aa) / dd
            do 97 is = 1,istate
  97        yvec(is) = rvec(is) * aa + avec(is) * ww
          endif
          call cdot( istatx, istate, yvec, rvec, del)

c         it seems ran out of precision for nit>150
          nitx = 30
          do 500 nit = 0, nitx
            call cdot( istatx, istate, yvec, avec, delp)
            omega = del / delp

            do 120 is = 1, istate
 120        svec(is) = rvec(is) - omega * avec(is)
cc          Check convergence criteria: |s_n+1| < tol
            ipass = 1
            do 122 is = 1, istate
              if ( abs(real(svec(is))).gt.toler1) goto 123
              if ( abs(aimag(svec(is))).gt.toler1) goto 123
 122        continue
            ipass = 0
 123        continue
            if (ipass.eq.0)  then
              do 124 is = 1, istate
 124          xvec(is) = xvec(is) + omega*pvec(is)
              goto 700
            endif

            call matvec( istatx,istate,g0t,svec,asve,1)
            msord = msord + 1
            call cdot( istatx, istate, asve, asve, aa)
            call cdot( istatx, istate, asve, svec, wa)
            chi = wa / aa
            do 125 is = 1, istate
 125        xvec(is) = xvec(is) + omega*pvec(is) + chi*svec(is)

            do 130 is = 1, istate
 130        rvec(is) = svec(is) - chi* asve(is)

cc          Check convergence criteria: |r_n+1| < tol
            ipass = 1
            do 370 is = 1, istate
              if ( abs(real(rvec(is))).gt.toler1) goto 380
              if ( abs(aimag(rvec(is))).gt.toler1) goto 380
 370        continue
            ipass = 0
 380        continue
            if (ipass.eq.0) goto 700

c           prepare for next iteration
            call cdot( istatx, istate, yvec, rvec, del)
            psi = del / (delp * chi)

            do 135 is = 1, istate
 135        pvec(is) = rvec(is) + psi * (pvec(is)-chi*avec(is))
            call matvec( istatx,istate,g0t,pvec,avec,1)
            msord = msord + 1

 500      continue
c         restart since ran out of iterations
          goto 50

c         exit if tolerance has been achieved
 700      continue
c         print*, ' BI iterations:', nit + istart*nitx
c         end of BI iterations

c         at this point xvec = (1-tG)**-1 * bvec  with chosen tolerance
c         pack FMS matrix into an nsp*(lx+1)^2 x nsp*(lx+1)^2 matrix 
c         for each ipot
          do 800 is2=1,ipart
            gg( is2, is1, ip) = zero
            do 790 is = 1,istate
              gg( is2, is1, ip) = gg( is2, is1, ip) +
     1        g0( is2+i0(ip), is) * xvec(is)
 790        continue
 800      continue

 910    continue
 920  continue

      return
      end
      subroutine ggrm( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1                 toler1, toler2, lcalc, msord)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c  output
c    gg:  (nsp*lx**2, nsp*lx**2, 0:nphasx) submatrix spanning the entire
c          angular momentum basis for each unique potential

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      integer  i0 (0:nphx),  lipotx(0:nphx)

      parameter (one = 1, zero = 0)
      complex coni
      parameter (coni = (0,1))

c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate

      complex   tmatrx(nspx, istatx)
c     big work matrices
      complex   g0( istatx, istatx), g0t( istatx, istatx)
      logical lcalc
      dimension lcalc(0:lx)

      complex xvec( istatx), xket( istatx), xbra( istatx)
      complex xketp(istatx), xbrap(istatx)
      complex zvec(istatx), rvec(istatx), svec(istatx)
      complex tket(istatx), tbra(istatx)
      double precision  dum1, dum2
      complex alphac, betac, aa, bb, yy, aac, bbc, gamma
      real alpha, beta
c     return matrix containing info about each unique potential
      complex   gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphasx)

c      notice that in gglu we invert (1-Gt), but here (1-tG).
c     multiply T and G0 matrices together, construct g0t = 1 - T*G0
c     notice that the signs below for g0t ARE correct since 1 is the
c     unit matrix
c     since t is tri-diagonal, this product can be computed in n^2 time
c     also fill up some work matrices for use in eigenvalue and
c     determinant calculations and elsewhere
c     cycle over dimensions of matrix g0t
      do 10 icol = 1,istatx
      do 10 irow = 1,istatx
 10   g0t(irow,icol) = 0

      do 30 icol = 1,istate
        do 20 irow = 1,istate
c         T diagonal contribution T(irow, irow)
          if ( abs( g0(irow, icol)) .gt. toler2 )
     1    g0t(irow,icol)=g0t(irow,icol) - tmatrx(1,irow) * g0(irow,icol) 

c         T off-diagonal contribution T(ist2, irow) in tmatr(2,irow)
c         T off-diagonal contribution T(irow, ist2) in tmatr(2,ist2)
          l1   = lrstat(2,irow)
          m1   = lrstat(3,irow)
          isp1 = lrstat(4,irow)
          m2 = m1+isp1
          if (nsp.eq.2 .and. m2.gt.-l1+1 .and. m2.lt.l1+2) then
c            spin-flip contribution
             ist2 = irow + (-1)**isp1
             if ( abs( g0(ist2, icol)) .gt. toler2)
     1       g0t(irow, icol) = g0t(irow, icol)
     2                   - tmatrx(nsp, ist2) * g0(ist2, icol) 
          endif
 20     continue

        g0t(icol, icol) = g0t(icol, icol) + one
 30   continue

      do 920 ip=ipi, ipf
        ipart = nsp*(lipotx(ip)+1)**2
        do 910 is1 = 1, ipart
          is2 = is1+i0(ip)
          l1   = lrstat(2,is2)
          if (.not.lcalc(l1)) goto 910

c         start first tier with xvec=0
          istart = -1
          msord=0
          do 40 is = 1, istate
          rvec(is) = 0
  40      xvec(is) = 0

c         RESTART here if necessary
  50      continue
          istart = istart+1

          if (istart.gt.0) call matvec( istatx,istate,g0t,xvec,rvec,1)
c         rvec = g0t*xvec - bvec, in our case bvec(is) = delta_{is,is2}
          rvec(is2) = rvec(is2) - 1
          do 90 is = 1,istate
 90       xket(is) = - rvec(is)
          call cdot( istatx, istate, xket, xket, bb)
          if (abs(bb).eq.0) goto 700

          xfnorm = 1.e0 / real(dble(bb))
          do 91 is = 1, istate
 91       xbra(is) = xket(is) * xfnorm
c         |t> = A |n> ; |n> - xket, |n-1> - xketp
          call matvec ( istatx, istate, g0t, xket, tket, 1)
          msord = msord + 1
          call cdot( istatx, istate, xbra, tket, aa)
          aac = real(aa) - coni*aimag(aa)
          bb = 0
          bbc= 0
          betac = aa
          yy = 1
c         initialize vectors
          do 110 is = 1,istate
            xketp(is) = 0
            xbrap(is) = 0
            zvec(is) = xket(is)
            xvec(is) = xvec(is) + zvec(is)/betac
 110      continue

          do 120 is = 1, istate
 120      svec(is) = tket(is)
          do 130 is = 1, istate
 130      rvec(is) = rvec(is) + svec(is) / betac

c         it seems ran out of precision for nit>150
          nitx = 100
          do 300 nit = 1, nitx
c           use recursion method to calculate a_n+1, b_n, |n+1>, <n+1|
            do 140 is = 1, istate
 140        tket(is) = tket(is) - aa*xket(is) - bb*xketp(is)
            call matvec ( istatx, istate, g0t, xbra, tbra, 2)
            do 150 is = 1, istate
 150        tbra(is) = tbra(is) - aac*xbra(is) - bbc*xbrap(is)
            call cdot( istatx, istate, tbra, tket, bb)
            if (abs(bb).eq.0) goto 700

            bb = sqrt (bb)
            bbc = real(bb) - coni*aimag(bb)
            do 160 is = 1, istate
              xketp(is) = xket(is)
              xbrap(is) = xbra(is)
 160        continue
            do 170 is = 1, istate
              xket(is) = tket(is) / bb
              xbra(is) = tbra(is) / bbc
 170        continue
            call matvec ( istatx, istate, g0t, xket, tket, 1)
            msord = msord + 1
            call cdot( istatx, istate, xbra, tket, aa)
            aac = real(aa) - coni*aimag(aa)
            
c           update iterative solution xvec, 
c           and residual rvec = g0t*xvec - |1>
            alphac = bb / betac
            do 210 is = 1, istate
 210        zvec(is) = xket(is) - alphac * zvec(is)
            do 220 is = 1, istate
 220        svec(is) = tket(is) - alphac * svec(is)

            betac = aa - alphac*bb
            yy = - alphac * yy
            gamma = yy / betac
            do 230 is = 1, istate
 230        xvec(is) = xvec(is) + gamma * zvec(is)
            do 240 is = 1, istate
 240        rvec(is) = rvec(is) + gamma * svec(is)

cc          Check convergence criteria: | rvec | < tol
c           call vecvec( istatx, istate, rvec, rvec, dum2)
c           if (dum2.le.tol) goto 700
cc          Check convergence criteria: | rvec | < tol
            ipass = 1
            do 250 is = 1, istate
              if ( abs(real(rvec(is))).gt.toler1) goto 260
              if ( abs(aimag(rvec(is))).gt.toler1) goto 260
 250        continue
            ipass = 0
 260        continue
            if (ipass.eq.0) goto 700

 300      continue
c         restart since ran out of iterations
          goto 50

c         exit if tolerance has been achieved
 700      continue
c         end of RM iterations

c         at this point xvec = (1-tG)**-1 * bvec  with chosen tolerance
c         pack FMS matrix into an nsp*(lx+1)^2 x nsp*(lx+1)^2 matrix 
c         for each ipot
          do 800 is2=1,ipart
            gg( is2, is1, ip) = zero
            do 790 is = 1,istate
              gg( is2, is1, ip) = gg( is2, is1, ip) +
     1        g0( is2+i0(ip), is) * xvec(is)
 790        continue
 800      continue

 910    continue
 920  continue

      return
      end

      subroutine cdot ( istatx, istate, abra, aket, cc)
c     dot product of two vectors
c     notice that we keep bra  vector as it's complex conjugate
c     thus need to conjugate abra here
      implicit real (a-h,o-z)
      implicit integer (i-n)
      complex coni
      parameter (coni = (0,1))
      complex abra, aket, cc, aa
      dimension abra(istatx), aket(istatx)

      cc = 0
      do 10 is = 1,istate
        aa = real(abra(is)) - coni*aimag(abra(is))
        cc = cc + aa * aket(is)
 10   continue
      return
      end

      subroutine vecvec ( istatx, istate, avec, bvec, cc)
c     dot product of two vectors
      implicit real (a-h,o-z)
      implicit integer (i-n)
      complex avec, bvec
      double precision cc, aa, bb
      dimension avec(istatx), bvec(istatx)

      cc = 0
      do 10 is = 1,istate
        aa = dble(real(avec(is))) * dble(real(bvec(is)))
        bb = dble(aimag(avec(is))) * dble(aimag(bvec(is)))
        cc = cc + aa + bb
 10   continue
      return
      end

      subroutine matvec (istatx, istate, amat, bvec, cvec, itrans)
c     itrans = 1  cvec = amat * bvec
c     itrans = 2  cvec = amat^+ * bvec
c     itrans = 3  cvec = amat^T * bvec
      implicit real (a-h,o-z)
      implicit integer (i-n)
      complex coni, aa
      parameter (coni = (0,1))
      complex amat, bvec, cvec
      dimension amat(istatx, istatx), bvec(istatx), cvec(istatx)

c     initialize cvec
      do 10 is = 1,istatx
 10   cvec(is) = 0

c     cycle over dimensions of amat
      do 20 icol = 1,istate
      do 20 irow = 1,istate
        if (itrans.eq.1) then
          cvec(irow) = cvec(irow) + amat(irow, icol) * bvec(icol)
        elseif(itrans.eq.2) then
          aa = real(amat(irow, icol)) - coni*aimag(amat(irow, icol))
          cvec(icol) = cvec(icol) + aa * bvec(irow)
        else
          cvec(icol) = cvec(icol) + amat(irow, icol) * bvec(irow)
        endif
 20   continue

      return
      end
      subroutine gggm( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1                 toler1, toler2, lcalc, msord)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c  output
c    gg:  (nsp*lx**2, nsp*lx**2, 0:nphasx) submatrix spanning the entire
c          angular momentum basis for each unique potential
c     Lanczos algorithm: Graves-Morris,Salam, Num.Algor.21,p.213(1999)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      integer  i0 (0:nphx),  lipotx(0:nphx)

      parameter (one = 1, zero = 0)
      complex coni
      parameter (coni = (0,1))

c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate

      complex   tmatrx(nspx, istatx)
c     big work matrices
      complex   g0( istatx, istatx), g0t( istatx, istatx)
      logical lcalc
      dimension lcalc(0:lx)

c     Lanczos method variables
      complex xvec( istatx), wvec(istatx), x0(istatx), x1(istatx)
      complex avec(istatx), bvec(istatx)
      complex r0(istatx), r1(istatx), t0(istatx), t1(istatx)
      complex aa, dd, aw, wa, ww, e0, e1, alpha, beta, theta, q0, q1
c     return matrix containing info about each unique potential
      complex   gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphasx)

c      notice that in gglu we invert (1-Gt), but here (1-tG).
c     multiply T and G0 matrices together, construct g0t = 1 - T*G0
c     notice that the signs below for g0t ARE correct since 1 is the
c     unit matrix
c     since t is tri-diagonal, this product can be computed in n^2 time
c     also fill up some work matrices for use in eigenvalue and
c     determinant calculations and elsewhere
c     cycle over dimensions of matrix g0t
      do 10 icol = 1,istatx
      do 10 irow = 1,istatx
 10   g0t(irow,icol) = 0

      do 30 icol = 1,istate
        do 20 irow = 1,istate
c         T diagonal contribution T(irow, irow)
          if ( abs( g0(irow, icol)) .gt. toler2 )
     1    g0t(irow,icol)=g0t(irow,icol) + tmatrx(1,irow) * g0(irow,icol) 

c         T off-diagonal contribution T(ist2, irow) in tmatr(2,irow)
c         T off-diagonal contribution T(irow, ist2) in tmatr(2,ist2)
          l1   = lrstat(2,irow)
          m1   = lrstat(3,irow)
          isp1 = lrstat(4,irow)
          m2 = m1+isp1
          if (nsp.eq.2 .and. m2.gt.-l1+1 .and. m2.lt.l1+2) then
c            spin-flip contribution
             ist2 = irow + (-1)**isp1
             if ( abs( g0(ist2, icol)) .gt. toler2)
     1       g0t(irow, icol) = g0t(irow, icol)
     2                   + tmatrx(nsp, ist2) * g0(ist2, icol) 
          endif
 20     continue

c       g0t(icol, icol) = g0t(icol, icol) + one
 30   continue

      do 920 ip=ipi, ipf
        ipart = nsp*(lipotx(ip)+1)**2
        do 910 is1 = 1, ipart
          is2 = is1+i0(ip)
          l1   = lrstat(2,is2)
          if (.not.lcalc(l1)) goto 910

c         start first tier with xvec=0
          istart = -1
          msord = 0
          do 40 is = 1, istate
          bvec(is) = 0
  40      xvec(is) = 0
c         rvec = bvec - A*xvec , in our case bvec(is) = delta_{is,is2}
          bvec(is2) = 1

c         RESTART here if necessary
  50      continue
          istart = istart+1

          if (istart.gt.0) then
            do 60 is = 1, istate
  60        xvec(is) = xvec(is) + x0(is) / q0
            call matvec( istatx,istate,g0t,xvec,avec,1)
            do 70 is = 1, istate
  70        bvec(is) = avec(is) - xvec(is)
            bvec(is2) = bvec(is2) + 1
          endif
          do 80 is = 1,istate
 80       r0(is) = bvec(is)
          do 90 is = 1,istate
 90       x0(is) = 0
          do 95 is = 1, istate
 95       x1(is) = bvec(is)
          call matvec( istatx,istate,g0t,bvec,r1,1)
          msord = msord + 1

c         choose wvec that del and delp close to one
          call cdot( istatx, istate, r0, r0, ww)
          call cdot( istatx, istate, r1, r1, aa)
          call cdot( istatx, istate, r0, r1, wa)
          aw = real(wa) - coni* aimag(wa)
          dd = aa*ww - aw*wa
          if (abs(dd/aa/ww) .lt.1.e-8) then
            do 96 is = 1,istate
  96        wvec(is) = r0(is) / ww
          else
            ww = ( ww - aw ) / dd
            aa = ( wa - aa) / dd
            do 97 is = 1,istate
  97        wvec(is) = r0(is) * aa + r1(is) * ww
          endif
c         update dot products to avoid round off errors
          call cdot( istatx, istate, wvec, r0, e0)
          call cdot( istatx, istate, wvec, r1, e1)
          q0 = 1
          q1 = 1

c         it seems ran out of precision for nit>150
          nitx = 10
          do 500 nit = 1, nitx
            tol = toler1 * abs(q1) /10
cc          Check convergence criteria: |r1| < tol / 10
cc          so mostly code will not exit here
            ipass = 1
            do 98 is = 1, istate
              if ( abs(real(r1(is))).gt.tol) goto 99
              if ( abs(aimag(r1(is))).gt.tol) goto 99
  98        continue
            ipass = 0
  99        continue
            if (ipass.eq.0) then
              do 100 is = 1, istate
 100          xvec(is) = xvec(is) + x1(is) / q1
              goto 700
            endif

            alpha = e1 / e0
            do 130 is = 1, istate
 130        t0(is) = r1(is) - alpha* r0(is)
            call matvec( istatx,istate,g0t,t0,t1,1)
            msord = msord + 1

            call cdot( istatx, istate, t0, t1, wa)
            call cdot( istatx, istate, t0, t0, ww)
            call cdot( istatx, istate, t1, t1, aa)
            aw = real(wa) - coni* aimag(wa)
            theta = (wa - aa) / (ww - aw)

            do 145 is = 1, istate
 145        r0(is) = t1(is) - theta * t0(is)
            dd = 1- theta
            do 150 is = 1, istate
 150        x0(is) = t0(is) + dd * (x1(is) - alpha*x0(is))
            q0 = dd * (q1 - alpha*q0)
            tol = toler1 * abs(q0)

cc          Check convergence criteria: |r0| < tol
            ipass = 1
            do 370 is = 1, istate
              if ( abs(real(r0(is))).gt.tol) goto 380
              if ( abs(aimag(r0(is))).gt.tol) goto 380
 370        continue
            ipass = 0
 380        continue
            if (ipass.eq.0) then 
              do 390 is = 1, istate
 390          xvec(is) = xvec(is) + x0(is) / q0
              goto 700
            endif

c           prepare for next iteration
            call cdot( istatx, istate, wvec, r0, e0)
            beta = e0 / e1
            do 255 is = 1, istate
 255        t0(is) = r0(is) - beta * r1(is)
            call matvec( istatx,istate,g0t,t0,avec,1)
            msord = msord + 1
            dd = beta * theta
            do 260 is = 1, istate
 260        r1(is) = avec(is) + dd * r1(is)
            call cdot( istatx, istate, wvec, r1, e1)

            dd = beta * (1-theta)
            do 270 is = 1, istate
 270        x1(is) = x0(is) - dd * x1(is) + t0(is)
            q1 = q0 - (1-theta) * beta * q1
 500      continue
c         restart since ran out of iterations
          goto 50

c         exit if tolerance has been achieved
 700      continue
c         end of GM iterations

c         at this point xvec = (1-tG)**-1 * bvec  with chosen tolerance
c         pack FMS matrix into an nsp*(lx+1)^2 x nsp*(lx+1)^2 matrix 
c         for each ipot
          do 800 is2=1,ipart
            gg( is2, is1, ip) = zero
            do 790 is = 1,istate
              gg( is2, is1, ip) = gg( is2, is1, ip) +
     1        g0( is2+i0(ip), is) * xvec(is)
 790        continue
 800      continue

 910    continue
 920  continue

      return
      end
      subroutine ggtf( nsp, i0, ipi, ipf, lipotx, g0, tmatrx, g0t, gg,
     1                 toler1, toler2, lcalc, msord)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c  output
c    gg:  (nsp*lx**2, nsp*lx**2, 0:nphasx) submatrix spanning the entire
c          angular momentum basis for each unique potential
c     TFQMR: Saad, Iterative Methods for Sparse Matrices, p.225 (1996).

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      integer  i0 (0:nphx),  lipotx(0:nphx)

      parameter (one = 1, zero = 0)
      complex coni
      parameter (coni = (0,1))

c**** array of state kets at current energy
      common /stkets/ lrstat(4, istatx), istate

      complex   tmatrx(nspx, istatx)
c     big work matrices
      complex   g0( istatx, istatx), g0t( istatx, istatx)
      logical lcalc
      dimension lcalc(0:lx)

      complex xvec(istatx), uvec(istatx), avec(istatx), wvec(istatx)
      complex dvec(istatx), rvec(istatx), vvec(istatx)
      complex alpha, beta, aa, rho, eta
      real tau, nu, cm, err
c     return matrix containing info about each unique potential
      complex   gg(nspx*(lx+1)**2, nspx*(lx+1)**2, 0:nphasx)

c      notice that in gglu we invert (1-Gt), but here (1-tG).
c     multiply T and G0 matrices together, construct g0t = 1 - T*G0
c     notice that the signs below for g0t ARE correct since 1 is the
c     unit matrix
c     since t is tri-diagonal, this product can be computed in n^2 time
c     also fill up some work matrices for use in eigenvalue and
c     determinant calculations and elsewhere
c     cycle over dimensions of matrix g0t
      do 10 icol = 1,istatx
      do 10 irow = 1,istatx
 10   g0t(irow,icol) = 0

      do 30 icol = 1,istate
        do 20 irow = 1,istate
c         T diagonal contribution T(irow, irow)
          if ( abs( g0(irow, icol)) .gt. toler2 )
     1    g0t(irow,icol)=g0t(irow,icol) - tmatrx(1,irow) * g0(irow,icol) 

c         T off-diagonal contribution T(ist2, irow) in tmatr(2,irow)
c         T off-diagonal contribution T(irow, ist2) in tmatr(2,ist2)
          l1   = lrstat(2,irow)
          m1   = lrstat(3,irow)
          isp1 = lrstat(4,irow)
          m2 = m1+isp1
          if (nsp.eq.2 .and. m2.gt.-l1+1 .and. m2.lt.l1+2) then
c            spin-flip contribution
             ist2 = irow + (-1)**isp1
             if ( abs( g0(ist2, icol)) .gt. toler2)
     1       g0t(irow, icol) = g0t(irow, icol)
     2                   - tmatrx(nsp, ist2) * g0(ist2, icol) 
          endif
 20     continue

        g0t(icol, icol) = g0t(icol, icol) + one
 30   continue

      do 920 ip=ipi, ipf
        ipart = nsp*(lipotx(ip)+1)**2
        do 910 is1 = 1, ipart
          is2 = is1+i0(ip)
          l1   = lrstat(2,is2)
          if (.not.lcalc(l1)) goto 910

c         start first tier with xvec=0
          istart = -1
          msord = 0
          do 40 is = 1, istate
          rvec(is) = 0
          avec(is) = 0
  40      xvec(is) = 0

c         RESTART here if necessary
  50      continue
          istart = istart+1

          if (istart.gt.0) call matvec( istatx,istate,g0t,xvec,avec,1)
          do 90 is = 1,istate
 90       uvec(is) = - avec(is)
c         uvec = bvec - g0t*xvec , in our case bvec(is) = delta_{is,is2}
          uvec(is2) = uvec(is2) + 1
          call matvec( istatx,istate,g0t,uvec,avec,1)
          msord = msord + 1
          do 95 is = 1, istate
 95       wvec(is) = uvec(is)
          do 96 is = 1, istate
 96       vvec(is) = avec(is)
          do 97 is = 1, istate
 97       dvec(is) = 0
          call cdot( istatx, istate, uvec, uvec, aa)
          tau = sqrt(real(aa))
          nu = 0
          eta = 0
c         choose rvec = uvec /aa so that dot products are about 1
          do 98 is = 1, istate
 98       rvec(is) = uvec(is) / aa
          rho = 1

c         it seems ran out of precision for nit>150
          nitx = 20
          do 300 nit = 0, nitx
            if (mod(nit,2).eq.0) then
              call cdot( istatx, istate, rvec, vvec, aa)
              alpha = rho / aa
            else
              call matvec( istatx,istate,g0t,uvec,avec,1)
              msord = msord + 1
            endif

            do 115 is = 1, istate
 115        wvec(is) = wvec(is) - alpha * avec(is)

            aa = nu**2 * eta / alpha
            do 120 is = 1, istate
 120        dvec(is) = uvec(is) + aa * dvec(is)

            call cdot( istatx, istate, wvec, wvec, aa)
            nu = sqrt(real(aa)) / tau
            cm = 1 / sqrt(1+nu**2)
            tau = tau * nu * cm
            eta = cm**2 * alpha
            do 140 is = 1, istate
 140        xvec(is) = xvec(is) + eta * dvec(is)

cc          Check convergence criteria: | rvec | < tol
            err = (1.e0 + nit) / istate
            err = tau * sqrt(err) * 10
            if ( abs(err).lt.toler1) goto 700

            if (mod(nit,2) .ne.0) then
              aa = rho
              call cdot( istatx, istate, rvec, wvec, rho)
              beta = rho / aa
              do 210 is = 1, istate
 210          uvec(is) = wvec(is) + beta * uvec(is)

              do 215 is = 1, istate
 215          vvec(is) = beta * ( avec(is) + beta * vvec(is))
              call matvec( istatx,istate,g0t,uvec,avec,1)
              msord = msord + 1
              do 220 is = 1, istate
 220          vvec(is) = avec(is) + vvec(is)
            else
              do 230 is = 1, istate
 230          uvec(is) = uvec(is) - alpha * vvec(is)
            endif
 300      continue
c         restart since ran out of iterations
          goto 50

c         exit if tolerance has been achieved
 700      continue
c         end of TFQMR iterations

c         at this point xvec = (1-tG)**-1 * bvec  with chosen tolerance
c         pack FMS matrix into an nsp*(lx+1)^2 x nsp*(lx+1)^2 matrix 
c         for each ipot
          do 800 is2=1,ipart
            gg( is2, is1, ip) = zero
            do 790 is = 1,istate
              gg( is2, is1, ip) = gg( is2, is1, ip) +
     1        g0( is2+i0(ip), is) * xvec(is)
 790        continue
 800      continue

 910    continue
 920  continue

      return
      end
      subroutine atheap(nat, rat, iphat, ra)

c--------------------------------------------------------------
c  copyright 1993 university of washington         bruce ravel
c  modified by alexei ankudinov in march 1999
c--------------------------------------------------------------
      implicit real (a-h,o-z)
      implicit integer (i-n)
c      implicit double precision (a-h,o-z)
c-------------------------------------------------------------------
c  heapsort adapted from numerical recipes.  sort atoms by distance.
c  all the pesky little do loops are for transferring rows
c  of temp into toss.
c-------------------------------------------------------------------
c  alexei ankudinov: needed to avoid unnecessary permutations when atoms
c  are at the same distance from the central atom, in order to comply 
c  feff document: the sample atom should be the nearest to absorber or
c  first in the list among equidistant
c  Add small contribution 10**-8 * number to the sorting variable ra
c  in order to achieve this.
c-------------------------------------------------------------------
c  natx:   dimension parameter from calling program
c-------------------------------------------------------------------
      dimension rat(3, nat), toss(3), iphat(nat)
      double precision ra(nat), dum 

      if (nat.lt.2) return

      l=0
      do 10 i=1,nat
         ra(i) = dble( rat(1,i)**2 + rat(2,i)**2 + rat(3,i)**2 ) +
     1           i*1.d-8
c        small addition at to prefer the old ordering
         if (l.eq.0 .and.i.gt.1) then
             if (ra(i).lt.ra(i-1)) l=1
         endif
  10  continue
c     check if array is already in order
      if (l.eq.0) return

      l  = nat/2+1
      ir = nat
 110  continue
         if (l.gt.1) then
            l = l-1
            do 120 index=1,3
               toss(index)=rat(index,l)
 120        continue
            itoss = iphat(l)
            dum = ra(l)
         else
            do 130 index=1,3
               toss(index) = rat(index,ir)
 130        continue
            itoss = iphat(ir)
            dum = ra(ir)
            do 140 index=1,3
               rat(index,ir) = rat(index,1)
 140        continue
            iphat(ir) = iphat(1)
            ra(ir) = ra(1)
            ir=ir-1
            if (ir.eq.1) then
               do 150 index=1,3
                  rat(index,1)=toss(index)
 150           continue
               iphat(1) = itoss
               ra(1) = dum
c              sort is finished
               goto 300
            endif
         endif
         i=l
         j=l+l

 160     if (j.le.ir) then
            if (j.lt.ir) then
               if ( ra(j) .lt. ra(j+1) ) then
                  j  = j + 1
               endif
            endif

            if ( dum .lt. ra(j) ) then
               do 170 index=1,3
                  rat(index,i) = rat(index,j)
 170           continue
               iphat(i) = iphat(j)
               ra(i) = ra(j)
               i=j
               j=j+j
            else
               j=ir+1
            endif
            goto 160
         endif

         do 180 index=1,3
            rat(index,i) = toss(index)
 180     continue
         iphat(i) = itoss
         ra(i) = dum

      goto 110
 300  continue

      return
c end subroutine atheap
      end
      subroutine getang(nclusx, rat, i, j, theta, phi)

c------------------------------------------------------------------
c  determine theta and phi polar angles of the vector between two
c  atom positions
c
c  inputs
c    rat:   (3,nclusx) x,y,z of all atoms in cluster
c    i, j:  indices of atoms at ends of vector Ri-Rj
c
c  outputs
c    theta: polar angle theta of vector Ri-Rj
c    phi:   polar angle phi of vector Ri-Rj
c------------------------------------------------------------------

      implicit real (a-h,o-z)
      implicit integer (i-n)

c       include 'dim.h'
c       include 'xparam.h'
      dimension rat(3,nclusx)
      parameter(tiny=1.e-7, zero=0.e0, pi=3.141592654)

      x = rat(1,i) - rat(1,j)
      y = rat(2,i) - rat(2,j)
      z = rat(3,i) - rat(3,j)
      r = sqrt(x**2 + y**2 + z**2)

c  this fails to calculate phi correctly for, as an example,
c  x=0.5e-7 and y=2e-7.  However, those numbers are below the
c  precision of the numbers stored in potph.bin.

      phi = zero
      theta  = zero
      if (i.ne.j) then
c           phi = atan2(y,x)
c        all of these conditionals will do the work for a machine that
c        cannot correctly handle a zero value for the second argument
c        of atan2
          if (abs(x).lt.tiny) then
              if (abs(y).lt.tiny) then
                  phi = zero
              elseif (y.gt.tiny) then
                  phi = pi/2
              else
                  phi = -pi/2
              endif
          else
              phi = atan2(y,x)
          endif
          if (r.gt.tiny) then
            if (z.le.-r) then
             theta = pi
            elseif ( z.lt.r) then
             theta = acos(z/r)
            endif
          endif
      endif

      return
c  end subroutine getang
      end


c====================================================================
      subroutine rotxan (lxp1, mxp1, betax, i, j, k)
      implicit real (a-h,o-z)

c     input:  lxp1, mxp1: lmax+1 & mmax+1, largest L states in matrix
c             betax is the rotation angle
c             i and j are the indeces of the atoms, thus denote
c                 which pair of atoms this is the rotation matrix for
c             k=0 for forward rotation, k=1 for backward rotation
c     output: drix(L,k,j,i) in common /rotx/
c+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
c     adapted by BR from rot3i, version for genfmt by SIZ
c        new data structure for rotation matrices to accomodate
c        xanes calculation
c+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
c     subroutine rot3 calculates rotation matrices for l = 0,lxp1-1

c     subroutine rot3 calculates the beta dependence of rotation
c     matrix elements using recursion of an iterated version of
c     formula (4.4.1) in edmonds.
c
c     first written:(september 17,1986) by j. mustre
c     version 2  (17 sep 86)
c     version 3  (22 feb 87) modified by j. rehr
c     version for genfmt, modified by s. zabinsky, Sept 1991
c     Initialized dri0.  Some elements may be used before being
c        initialized elsewhere -- rot3i needs to be carefully
c        checked.  S. Zabinsky, April 1993
c
c******************** warning****************************************
c     lxx must be at least lxp1 or overwriting will occur
c     nmax must be at least nm or overwriting will occur
c--------------------------------------------------------------------
c     notation dri0(l,m,n) =  drot_i(l'm'n')
c     l = l'+1, n' = n-l, m' = m-l, primes denoting subscripts
c     thus dri0(1,1,1) corresponds to the rotation matrix with
c     l' = 0, and n' and m' = 0; dri0(3,5,5) : l' = 2,n' = 2,m' = 2.
c--------------------------------------------------------------------

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c       include 'xstruc.h'
c====================================================================
c  This header file contains the structural information about the
c  cluster to be used for the full multiple scattering calculation

      common /xstruc/ xphi(nclusx,nclusx), xrat(3,nclusx),
     $            iphx(nclusx)
      save /xstruc/

c  xphi:  matrix of angles between the z axis and pairs of atoms
c  xrat:  xyz coordinates of the atoms in the cluster, the first
c         npot+1 entries are examples of each unique potential
c  iphx:  potential indeces of each atom in the cluster, ordered like
c         xrat
c********************************************************************
c**** rotation matrices for entire cluster
c
      complex drix
      common /rotx/ drix(-lx:lx, -lx:lx, 0:lx, 0:1, nclusx, nclusx)
      save /rotx/
c********************************************************************
c#mn{
c common blocks for saving rotation matrices between xanes and rotxan
       integer    jsavx, jsav, jbmagk
       parameter (jsavx = 150, roteps = 1.e-12,jbmagk=-9999)
       dimension drisav(-lx:lx,-lx:lx,0:lx,jsavx), betsav(jsavx)
       integer   ldsav(jsavx), mdsav(jsavx)
       common /rotsav/  drisav, betsav, ldsav, mdsav, jsav
       save  /rotsav/
c#mn}

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /lnlm/ xnlm(0:lx,0:lx)
      save   /lnlm/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /xdwf/ sigsqr(nclusx,nclusx)
      save   /xdwf/

c  end of xstruc.h
c********************************************************************
      parameter (one = 1, zero = 0)
c      needed for commented out diagnostic file
c      logical open
      parameter(lxx=24)
      parameter (pi = 3.14159 26535 89793 23846 26433e0)
      complex coni, dum 
      parameter (coni = (0,1))

c     dri0 is larger than needed for genfmt, but necessary for
c     this calculation algorithm.  Copy result into smaller
c     dri arrays (in common) at end of this routine.
      dimension  dri0 (lxx+1, 2*lxx+1, 2*lxx+1)

c#mn{
c  check whether a rotation matrix for this {beta(ileg),lxp1,mxp1} has
c  been calculated and saved.  If so, just use the saved value
       do 90 isav = 1, jsav
          if (betsav(isav).eq.jbmagk) go to 95
          if ((lxp1.eq.ldsav(isav)).and.(mxp1.eq.mdsav(isav)).and.
     $         (abs(betax-betsav(isav)).le.roteps) ) then
cc             print*, 'using drisav for ', isav, betax, lxp1, mxp1
             do 85 il = 0, lx
             do 85 m1 = -il, il
             do 85 m2 = -il, il
               drix(m2,m1,il,k,j,i)=cmplx(drisav(m2,m1,il,isav),zero)
 85          continue
             go to 770
          end if
 90    continue
 95    continue
c#mn}


c     initialize dri0
      do 150 in = 1, 2*lxx+1
        do 150 im = 1, 2*lxx+1
          do 150 il = 1, lxx+1
            dri0(il,im,in) = zero
 150  continue

      nm  = mxp1
      ndm = lxp1+nm-1
      xc  = cos(betax/2)
      xs  = sin(betax/2)
      s   = sin(betax)
      dri0(1,1,1) =  1
      dri0(2,1,1) =  xc**2
      dri0(2,1,2) =  s/sqrt(2*one)
      dri0(2,1,3) =  xs**2
      dri0(2,2,1) = -dri0(2,1,2)
      dri0(2,2,2) =  cos(betax)
      dri0(2,2,3) =  dri0(2,1,2)
      dri0(2,3,1) =  dri0(2,1,3)
      dri0(2,3,2) = -dri0(2,2,3)
      dri0(2,3,3) =  dri0(2,1,1)
      do 230  l = 3, lxp1
        ln = 2*l - 1
        lm = 2*l - 3
        if (ln .gt. ndm)  ln = ndm
        if (lm .gt. ndm)  lm = ndm
        do 220  n = 1, ln
          do 210  m = 1, lm
            t1   = (2*l-1-n) * (2*l-2-n)
            t    = (2*l-1-m) * (2*l-2-m)
            f1   = sqrt(t1/t)
            f2   = sqrt( (2*l-1-n) * (n-1) / t )
            t3   = (n-2) * (n-1)
            f3   = sqrt(t3/t)
            dlnm = f1 * xc**2 * dri0(l-1,n,m)
            if (n-1 .gt. 0) dlnm = dlnm - f2*s*dri0(l-1,n-1,m)
            if (n-2 .gt. 0) dlnm = dlnm + f3*xs**2*dri0(l-1,n-2,m)
            dri0(l,n,m) = dlnm
            if (n .gt. (2*l-3))
     $                  dri0(l,m,n) = (-1)**(n-m) * dri0(l,n,m)
 210      continue
          if (n .gt. (2*l-3)) then
              dri0(l,2*l-2,2*l-2) =  dri0(l,2,2)
              dri0(l,2*l-1,2*l-2) = -dri0(l,1,2)
              dri0(l,2*l-2,2*l-1) = -dri0(l,2,1)
              dri0(l,2*l-1,2*l-1) =  dri0(l,1,1)
          endif
 220    continue
 230  continue


c     initialize drix
      do 310 il = 0, lx
      do 310 m1 = -lx, lx
      do 310 m2 = -lx, lx
        drix(m2,m1,il,k,j,i) = cmplx(zero,zero)
        drix(m2,m1,il,k,i,i) = cmplx(zero,zero)
 310  continue

c     Copy result into drix(...,k,j,i) in /rotx/
      do 390  il = 1, lxp1
        mmx = min (il-1, mxp1-1)
        do 380  m1 = -mmx, mmx
        do 380  m2 = -mmx, mmx
          drix(m2, m1, il-1, k, j, i)=cmplx(dri0(il,m1+il,m2+il),zero)
 380    continue
 390  continue
c#mn{
c      save dri if there's room
       if (jsav.lt.jsavx) then
          jsav = jsav + 1
cc          print*, 'saving dri to ',  jsav, betax, lxp1, mxp1
          betsav(jsav) = betax
          ldsav(jsav)  = lxp1
          mdsav(jsav)  = mxp1
          do 720 il = 0, lx
          do 720 m1 = -il, il
          do 720 m2 = -il, il
            drisav(m2,m1,il,jsav) = real(drix(m2,m1,il,k,j,i))
 720      continue
       else
cc          print*, 'not saving dri to ',  betax, lxp1, mxp1
       end if
 770   continue
c#mn}

c-----test sum rule on d
c       if (idbg(1).eq.1) then
c           inquire(file='rotmat.dat', opened=open)
c           if (.not.open) then
c               iun = nxtunt(25)
c               open (iun,file='rotmat.dat',status='unknown')
c           endif
c           write(iun,*)'  '
c           write(iun,*)'atom #s : ',i,j
c           write(iun,*)  ' il, im, sum, beta'
c           write(iun,*) ' (drix(il,im,in,k,j,i),in = -il,il)'
c           do 880 il = 0,lxp1-1
c             do 870 im = -il,il
c               sum = 0
c               do 850 in = -il,il
c                 term = drix(in,im,il,k,j,i)
c                 sum = sum+term**2
c  850           continue
c               write(iun,860) il,im,sum,betax
c               write(iun,862) (drix(in,im,il,k,j,i),in = -il,il)
c  860          format(2i3,1x,f16.12,1x,f8.4)
c  862          format(5f14.6)
c  870         continue
c  880       continue
c c          close(iun)
c       endif
c-----end test------------------------

        do 920 il = 0, lx
        do 920 m1 = -il, il
          dum = coni * m1 * (xphi(i,j)-pi)
          if (k.eq.1) dum = -dum
          dum = exp( dum )
          do 910 m2 = -il, il
            if (k.eq.1) then
              drix(m2,m1,il,k,j,i) = drix(m2,m1,il,k,j,i) * dum
            else
              drix(m1,m2,il,k,j,i) = drix(m1,m2,il,k,j,i) * dum
            endif
 910       continue
 920     continue

      return
c  end subroutine rotxan
      end
c====================================================================
c#mn{
       subroutine rotint
       implicit real (a-h,o-z)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c        include 'xstruc.h'
c====================================================================
c  This header file contains the structural information about the
c  cluster to be used for the full multiple scattering calculation

      common /xstruc/ xphi(nclusx,nclusx), xrat(3,nclusx),
     $            iphx(nclusx)
      save /xstruc/

c  xphi:  matrix of angles between the z axis and pairs of atoms
c  xrat:  xyz coordinates of the atoms in the cluster, the first
c         npot+1 entries are examples of each unique potential
c  iphx:  potential indeces of each atom in the cluster, ordered like
c         xrat
c********************************************************************
c**** rotation matrices for entire cluster
c
      complex drix
      common /rotx/ drix(-lx:lx, -lx:lx, 0:lx, 0:1, nclusx, nclusx)
      save /rotx/
c********************************************************************
c#mn{
c common blocks for saving rotation matrices between xanes and rotxan
       integer    jsavx, jsav, jbmagk
       parameter (jsavx = 150, roteps = 1.e-12,jbmagk=-9999)
       dimension drisav(-lx:lx,-lx:lx,0:lx,jsavx), betsav(jsavx)
       integer   ldsav(jsavx), mdsav(jsavx)
       common /rotsav/  drisav, betsav, ldsav, mdsav, jsav
       save  /rotsav/
c#mn}

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /lnlm/ xnlm(0:lx,0:lx)
      save   /lnlm/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /xdwf/ sigsqr(nclusx,nclusx)
      save   /xdwf/

c  end of xstruc.h
c********************************************************************
c initialize /rotsav/
       jsav = 0
       do 100 js = 1, jsavx
          betsav(js) = jbmagk
          ldsav(js)  = 0
          mdsav(js)  = 0
          do 90 il  = 0, lx
             do 80 m1 = -lx, lx
                do 70 m2 = -lx, lx
                   drisav(m2,m1,il,js) = 0
 70             continue
 80          continue
 90       continue
 100   continue
       return
c#mn}
       end
      subroutine sortat(iph0, nat, npot, iphat, iphx, rat, xrat)

      implicit real (a-h,o-z)
      implicit integer (i-n)
c--------------------------------------------------------------------
c  this subroutine sorts the atoms in xrat such that the first npot
c  entries are each a representative atom of a unique potential.  This
c  will mean that the upper left corner of the full MS matrix will
c  contain all of the information needed to compute the fine structure
c  and all of the electron densities.
c  NOTA BENE:  the atoms *must* have already been sorted by radial
c    distance!
c--------------------------------------------------------------------
c  input:
c    iph0:    potential index for central atom in LDOS (added by ala)
c                (iph0=0 for absorbing atom as the central atom)
c     nat:    number of atoms in cluster
c    npot:    number of unique potentials in cluster
c    iphat:   (nclusx) potential index of each atom in cluster as read
c             from geometry file
c    rat:     (3, nclusx) coordinates of each atom in cluster as read
c             from geometry file
c  output:
c    iphx:    (nclusx) potential index of each atom in cluster sorted
c             so that the first npot+1 entries are examples of each
c             ipot
c    xrat:    (3, nclusx) coordinates of each atom in cluster sorted
c             so that the first npot+1 entries are examples of each
c             ipot
c--------------------------------------------------------------------

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
      dimension rat(3,natxx), xrat(3,nclusx)
      integer   iphat(natxx), iphx(nclusx), ipoint
      dimension ipoint(0:nphasx)
      integer iph0, ip, ilast

      do 10 i=0,nphasx
        ipoint(i) = 0
 10   continue
      do 30 ic=1,nat
        iphx(ic) = iphat(ic)
        do 20 ix=1,3
          xrat(ix,ic) = rat(ix,ic)
 20     continue
 30   continue

c     (iph0=0 for absorbing atom as the central atom)
      if (iphx(1).ne.iph0) then
          call wlog('* * * ERROR in sortat * * *')
          call wlog('            The first atom in xrat is not '//
     $                'the central atom.')
          call wlog('            Complain to Bruce immediately!')
          call par_stop('SORTAT-1')
      endif

c       if (idbg(4).eq.1) print*,'SORTAT: nat,npot: ',nat,npot
c       if (idbg(4).eq.1) print*,'SORTAT: xcen,ycen,zcen: ',
c      $            xcen,ycen,zcen

c --- find the example of each unique potential that is closest to the
c     central atom.  This will presumably be well within the cluster
c     that was used to compute the overlapped potentials
      ipoint(iph0) = 1
      do 150 ip=0,npot
        if (ip .ne. iph0) then
          do 130 iat=2,nat
            if (iphx(iat).eq.ip .and. ipoint(ip).eq.0) then
                ipoint(ip) = iat
c                print*,'>>>>> ip, ipoint(ip)', ip, ipoint(ip)
            endif
 130      continue
        endif
 150  continue

c --- now swap the first few atoms with the atoms found above
      do 200 ip=0,npot

c ----- some potentials might not be in the xanes cluster
        if (ipoint(ip).eq.0) goto 200
c ----- don't swap two potentials if examples live in the first npot
c       entries
        if (ipoint(ip).le.ip+1) goto 200

        xx  = xrat(1,1+ip)
        yy  = xrat(2,1+ip)
        zz  = xrat(3,1+ip)
        iph = iphx(1+ip)

        xrat(1,1+ip) = xrat(1,ipoint(ip))
        xrat(2,1+ip) = xrat(2,ipoint(ip))
        xrat(3,1+ip) = xrat(3,ipoint(ip))
        iphx(1+ip)  = iphx(ipoint(ip))

        xrat(1,ipoint(ip)) = xx
        xrat(2,ipoint(ip)) = yy
        xrat(3,ipoint(ip)) = zz
        iphx(ipoint(ip))  = iph

c       added by ala
c       check that substituted atom was not some ip example
c          ???BR Jan 16 1998???
        do 190 ipp = ip+1, npot
          if (ipoint(ipp).eq.ip+1) ipoint(ipp) = ipoint(ip)
  190   continue
c       set the correct pointer to ip example
        ipoint(ip) = ip+1

 200  continue

c     added by ala
c     Notice that fms will take the last atom of given type ip
c     from first npot atoms in the list as an example for ip.
c     Make more permutaions if necesary.
      ilast = -1
      nmin = min (npot+1, nat)
      do 210 ip = 0, npot
        if (ipoint(ip).ne.0) then
          do 205 iat = 1,nmin
  205     if (iphx(iat).eq.ip) ilast = iat

          if (ilast.ne.ipoint(ip)) then
            xx  = xrat(1,ilast)
            yy  = xrat(2,ilast)
            zz  = xrat(3,ilast)

            xrat(1,ilast)= xrat(1,ipoint(ip))
            xrat(2,ilast)= xrat(2,ipoint(ip))
            xrat(3,ilast)= xrat(3,ipoint(ip))

            xrat(1,ipoint(ip)) = xx
            xrat(2,ipoint(ip)) = yy
            xrat(3,ipoint(ip)) = zz
c           now ipoint(ip) = ilast, but don't need ipoint anymore
          endif
        endif
  210 continue

c       if (idbg(4).eq.1) then
c           do 220 i=1,npot+1
c             print *,i,xrat(1,i),xrat(2,i),xrat(3,i),iphx(i)
c  220      continue
c       endif
      return
c  end subroutine sortat
      end
      subroutine xanlm(lmaxp1,mmaxp1)

c------------------------------------------------------------------
c  calculate and store all of the legendre polynomial normalization
c  factors needed in the problem
c     xnlm= sqrt ((2l+1)(l-m)!/(l+m)!)
c  see, for instance, Arfken section 12.6.  Note that this lacks the
c  factor of sqrt(4*pi)
c
c  inputs:
c     lmaxp1, nmaxp1:  maximun l and m considered in the problem +1
c                      i.e. lmaxp1 = l_max+1
c
c  outputs:
c     all normalization factors passed in common /xnlm/
c------------------------------------------------------------------

      implicit real(a-h,o-z)
c       parameter(ltot=6,mtot=3)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c       include 'xstruc.h'
c====================================================================
c  This header file contains the structural information about the
c  cluster to be used for the full multiple scattering calculation

      common /xstruc/ xphi(nclusx,nclusx), xrat(3,nclusx),
     $            iphx(nclusx)
      save /xstruc/

c  xphi:  matrix of angles between the z axis and pairs of atoms
c  xrat:  xyz coordinates of the atoms in the cluster, the first
c         npot+1 entries are examples of each unique potential
c  iphx:  potential indeces of each atom in the cluster, ordered like
c         xrat
c********************************************************************
c**** rotation matrices for entire cluster
c
      complex drix
      common /rotx/ drix(-lx:lx, -lx:lx, 0:lx, 0:1, nclusx, nclusx)
      save /rotx/
c********************************************************************
c common blocks for saving rotation matrices between xanes and rotxan
       integer    jsavx, jsav, jbmagk
       parameter (jsavx = 150, roteps = 1.e-12,jbmagk=-9999)
       dimension drisav(-lx:lx,-lx:lx,0:lx,jsavx), betsav(jsavx)
       integer   ldsav(jsavx), mdsav(jsavx)
       common /rotsav/  drisav, betsav, ldsav, mdsav, jsav
       save  /rotsav/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /lnlm/ xnlm(0:lx,0:lx)
      save   /lnlm/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /xdwf/ sigsqr(nclusx,nclusx)
      save   /xdwf/

c  end of xstruc.h
c********************************************************************

      common/afctr/afac,flzero,flg(0:50)
c      common/afctr/afac,flzero,flg(0:210)
c      common/afctr/afac,flzero,flg(0:110) vax change

      call xfctst
      do 50 il=1,lmaxp1
        mmxp1 = min(mmaxp1,il)
        do 40 im=1,mmxp1
          l    = il-1
          m    = im-1
          cnlm = (2*l+1) * flg(l-m) / flg(l+m)
          cnlm = sqrt(cnlm) * afac**m
          xnlm(m,l) = cnlm

 40     continue
 50   continue
      return
c  end subroutine xlm
      end


      subroutine xfctst
c  same as feff's factst, but with a different name
      implicit real (a-h,o-z)
c     program for s3j and s6j symbols obtained from
c     steve younger of n.b.s.   modified by j.b.mann
c--------------------------------------------------------------------
c     a set to 1/64 to prevent overflow on vax
c     range on  flg set to 0:210, rather than flg(210)
c--------------------------------------------------------------------
cBR   This allows calculation of a large factorial (~100) without
cBR   overflow problems -- factor in a power of a small number then
cBR   factor it out
c--------------------------------------------------------------------
      common /afctr/ a, flzero, flg(0:50)
c      common /afctr/ a, flzero, flg(0:210)
      a=0.03125
c     a=0.015625
      flzero = 1.0
      flg(0) = 1.0
      flg(1) = a
      do 10 i=2,50
        flg(i) = flg(i-1) * i * a
 10   continue
      return
      end



c====================================================================
      subroutine yprep(iph0, nat, inclus, npot, iphat, rmax, rat,
     $            izx, rdirec)
c    yprep is the same as xprep for negative idwopt
c    simlifies calls in SCF and LDOS where DW factors should not enter

      implicit real (a-h,o-z)
      implicit integer (i-n)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={xparam.h
c nphasx MUST be the same as nphx, the maximum number of unique
c        potentials
c natxx MUST be the same as natx, the maximum number of atoms in the
c       extendeed cluster
c nexx MUST be the same as nex, the maximum number of energy points
      parameter (nphasx=nphx)
      parameter (natxx=natx)
      parameter (nexx=nex)
      parameter (istatx=(lx+1)**2*nclusx*nspx)
      parameter (nkmin=1)
c     parameter (nkmin=-9)
c= xparam.h}
c====================================================================
c  This header file contains the structural information about the
c  cluster to be used for the full multiple scattering calculation

      common /xstruc/ xphi(nclusx,nclusx), xrat(3,nclusx),
     $            iphx(nclusx)
      save /xstruc/

c  xphi:  matrix of angles between the z axis and pairs of atoms
c  xrat:  xyz coordinates of the atoms in the cluster, the first
c         npot+1 entries are examples of each unique potential
c  iphx:  potential indeces of each atom in the cluster, ordered like
c         xrat
c********************************************************************
c**** rotation matrices for entire cluster
c
      complex drix
      common /rotx/ drix(-lx:lx, -lx:lx, 0:lx, 0:1, nclusx, nclusx)
      save /rotx/
c********************************************************************
c common blocks for saving rotation matrices between xanes and rotxan
       integer    jsavx, jsav, jbmagk
       parameter (jsavx = 150, roteps = 1.e-12,jbmagk=-9999)
       dimension drisav(-lx:lx,-lx:lx,0:lx,jsavx), betsav(jsavx)
       integer   ldsav(jsavx), mdsav(jsavx)
       common /rotsav/  drisav, betsav, ldsav, mdsav, jsav
       save  /rotsav/
c********************************************************************
c**** legendre polynomial normalization constants
c
      common /lnlm/ xnlm(0:lx,0:lx)
      save   /lnlm/

c********************************************************************
c**** legendre polynomial normalization constants
c
      common /xdwf/ sigsqr(nclusx,nclusx)
      save   /xdwf/

c  end of xstruc.h
c********************************************************************
      parameter(zero=0.e0)
      parameter (bohr = 0.529 177 249e0)
      integer   iphat(natxx), iphat2(natxx), izx(0:nphasx), izpair(0:2)
      dimension rat(3,natxx), rat2(3,natxx)
      double precision ra(natxx)
      character*78 line
c     sigms is written in double precision.  these are the variables
c     that it uses
      double precision dtemp, dthet, drs, dsigsq, pair(3,0:2)
      double precision sig2mx, sig2x(0:nphx,0:nphx)
c     iwarn - needed to wrtite waqrning just one time
      integer iwarn
      save iwarn
      data  iwarn /0/

c  initialize geometrical arrays
      do 30 i=1,nclusx
        do 10 j=1,nclusx
          xphi(j,i) = zero
 10     continue
        do 20 j=1,3
          xrat(j,i) = zero
 20     continue
        iphx(i) = 0
 30   continue
      inclus = 0

c --- find the central atom, ipot=iph0 (iph0=0 for the absorbing atom)
      icen = 0
      do 40 i=1,nat
        iphat2(i) = iphat(i)
        if (iphat(i).eq.iph0) then
            if (icen.eq.0) then
                icen = i
            elseif (iph0.eq.0) then
                call wlog('* * * ERROR!  More than one atom '//
     $                      'in the extended cluster have ipot=0')
                call wlog('      You may only have one central atom.')
                call wlog('      Stopping in xprep.')
                call par_stop('YPREP-1')
            endif
        endif
 40   continue
c --- make sure central atom is at (0,0,0)
      do 45 i=1,nat
        rat2(1,i) = rat(1,i)-rat(1,icen)
        rat2(2,i) = rat(2,i)-rat(2,icen)
        rat2(3,i) = rat(3,i)-rat(3,icen)
 45   continue

c --- sort the atoms from extended cluster by distance from central
c     atom.
      call atheap(nat, rat2, iphat2, ra)

c --- define cluster from extended cluster by as those closer than
c     rmax to central atom
      inclus=0
      rmax2 = rmax**2
      do 50 i=1,nat
        rr = (rat2(1,i)**2 + rat2(2,i)**2 + rat2(3,i)**2)
        if (rr.gt.rmax2) then
            inclus = i-1
            goto 60
        endif
 50   continue
 60   continue
      if (inclus.eq.0) inclus=nat

c --- sanity check size of cluster
      if (inclus.gt.nclusx) then
        if (iwarn.eq.0) then
          call wlog('* * * WARNING preparing cluster for '//
     $                'FMS calculation.')
          write(line,400) inclus
 400      format('      You specified a cluster of ', i3,
     $                ' atoms for the FMS calculation.')
          call wlog(line)
          write(line,410)nclusx
          call wlog(line)
 410      format('      This exceeds the hard wired limit of ', i3,
     $                ' atoms.')
          write(line,420)nclusx
          call wlog(line)
 420      format('      The cluster size was reset to ', i3,
     $                ' and the calculation will continue.')
          iwarn = 1
        endif
        inclus = nclusx
      endif

c --- make the first few entries in xrat represent each of the
c     unique potentials, sorting around the chosen center
c     (iph0=0 for the absorbing atom)
c     call sortat(iph0, inclus, npot, iphat2, iphx, rat2, xrat)
      do 430 iat = 1, inclus
          iphx(iat) = iphat2(iat)
          xrat(1,iat) = real (rat2(1,iat))
          xrat(2,iat) = real (rat2(2,iat))
          xrat(3,iat) = real (rat2(3,iat))
 430  continue


c --- Calculate and store rotation matrix elements and phi angles
c     the k loop calculates the forward then the backward rotation
c     for an atom pair (ij). k = 0-->forward, 1-->backward
      call rotint
      lplus1 = lx+1
      mplus1 = lx+1
      do 150  i=1,inclus
        do 140 j=1,inclus
          rr = (xrat(1,i)-xrat(1,j))**2 + (xrat(2,i)-xrat(2,j))**2
     1       + (xrat(3,i)-xrat(3,j))**2
c         if (rr.gt.rdirec**2) goto 140

          call getang(nclusx, xrat, i, j, xbeta, xphi(i,j))
          if (i.eq.j) goto 140
          do 130 k=0,1
            if (k.eq.1) xbeta = (-1) * xbeta
            call rotxan(lplus1, mplus1, xbeta, i, j, k)
 130      continue
 140    continue
 150  continue

c --- calculate spherical harmonic normalization factors
      call xanlm(lplus1,mplus1)

      do 200 iat2=1,nclusx
      do 200 iat1=1,nclusx
        sigsqr(iat1,iat2) = zero
 200  continue

      return
      end
c///////////////////////////////////////////////////////////////////////
c FEFF PROGRAMS (referred below as a System)
c Copyright (c) 1986-2002, University of Washington.
c 
c END-USER LICENSE 
c 
c A signed End-user License Agreement from the University of Washington
c Office of Technology Transfer is required to use these programs and
c subroutines.
c 
c See the URL: http://leonardo.phys.washington.edu/feff/
c 
c USE RESTRICTIONS:
c 
c 1. The End-user agrees that neither the System, nor any of its
c components shall be used as the basis of a commercial product, and
c that the System shall not be rewritten or otherwise adapted to
c circumvent the need for obtaining additional license rights.
c Components of the System subject to other license agreements are
c excluded from this restriction.
c
c 2. Modification of the System is permitted, e.g., to facilitate
c its performance by the End-user. Use of the System or any of its
c components for any purpose other than that specified in this Agreement
c requires prior approval in writing from the University of Washington.
c
c 3. The license granted hereunder and the licensed System may not be
c assigned, sublicensed, or otherwise transferred by the End-user.  
c
c 4. The End-user shall take reasonable precautions to ensure that
c neither the System nor its components are copied, or transferred out
c side of his/her current academic or government affiliated laboratory
c or disclosed to parties other than the End-user.
c 
c 5. In no event shall the End-user install or provide this System
c on any computer system on which the End-user purchases or sells
c computer-related services.
c 
c 6. Nothing in this agreement shall be construed as conferring rights
c to use in advertising, publicity, or otherwise any trademark or the
c names of the System or the UW.   In published accounts of the use or
c application of FEFF the System should be referred to  by this name,
c with an appropriate literature reference:
c 
c FEFF8: A.L. Ankudinov, B. Ravel, J.J. Rehr, and S.D. Conradson,
c        Phys. Rev. B 58, pp. 7565-7576 (1998).
c
c LIMITATION OF LIABILITY:
c
c 1.   THE UW MAKES NO WARRANTIES , EITHER EXPRESSED OR IMPLIED, AS TO
c THE CONDITION OF THE SYSTEM, ITS MERCHANTABILITY, OR ITS FITNESS FOR
c ANY PARTICULAR PURPOSE.  THE END-USER AGREES TO ACCEPT THE SYSTEM
c 'AS IS' AND IT IS UNDERSTOOD THAT THE UW IS NOT OBLIGATED TO PROVIDE
c MAINTENANCE, IMPROVEMENTS, DEBUGGING OR SUPPORT OF ANY KIND.
c
c 2. THE UW SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL,
c INCIDENTAL OR CONSEQUENTIAL DAMAGES SUFFERED BY THE END-USER OR ANY
c OTHER PARTIES FROM THE USE OF THE SYSTEM.
c
c 3.  The End-user agrees to indemnify the UW for liability resulting
c from the use of the System by End-user. The End-user and the UW each
c agree to hold the other harmless for their own negligence.
c
c TITLE:
c
c 1.  Title patent, copyright and trademark rights to the System are
c retained by the UW. The End-user shall take all reasonable precautions
c to preserve these rights.
c 
c 2.  The UW reserves the right to license or grant any other rights to
c the System to other persons or entities.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c

c     sub-program exchange
!     program  ffmod4
      subroutine ffmod4

c     makes paths list using cluster geometry and phase shifts
c     written by a.ankudinov 2000 using earlier subroutines
c     written by s.zabinsky
c     modified by a.ankudinov 2001 for new I/O structure

c     INPUT FILES
c       global.dat, geom.dat - global infomation file is read here 
c       mod4.inp - specific information for present module
c       phase.bin - output of XSPH module is read using subroutine 
c                  'rdxsph' inside subroutine 'prcrit'.
c                   needed  data: (list of variables)
c                  (ne, ne1, npot, ik0, em, eref2, potlbl, ph4)
c     OUTPUT FILE
c       paths.dat - list of filtered paths

      implicit double precision (a-h, o-z)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}

      
      dimension lmaxph(0:nphx), rat(3,natx), iphat(natx), ibounc(natx)
      double precision evec(3), xivec(3)
      character*6  potlbl(0:nphx)
        integer  mpath, ms, nncrit, nlegxx, ipr4
        real critpw, pcritk, pcrith,  rmax, rfms2

      integer eels !KJ added 5/06
      character*30 fname

c     Following passed to pathfinder, which is single precision.
c     Be careful to always declare these!
      parameter (necrit=9, nbeta=40)
      real fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      real fbeta(-nbeta:nbeta,0:nphx,nex), cksp(nex)
      real xlamc(necrit), xlam(nex)

      call par_begin
      if (worker) go to 400
      
c     open the log file, unit 11.  See subroutine wlog.
      open (unit=11, file='log4.dat', status='unknown', iostat=ios)
      call chopen (ios, 'log4.dat', 'feff')

c     INPUT: read geom.dat, global.dat, mod4.inp
      call repath (ms, mpath, ipr4,  pcritk, pcrith, nncrit, rmax,
     1             nlegxx, rfms2, critpw,
c                  geom.dat
     2             nat, rat, iphat, ibounc,
c                  global.dat
     3             ipol, ispin, evec, xivec ,eels) !KJ added eels 5/06
       if (nspx.gt.1) ispin = abs(ispin)

      if (ms.eq.1  .and.  mpath.eq.1)  then
         call wlog(' Preparing plane wave scattering amplitudes...')
         call prcrit (ne, nncrit, ik0, cksp, fbeta, ckspc, 
     1                fbetac, potlbl, xlam, xlamc)

c        Dump out fbetac for central atom and first pot
         if (ipr4 .ge. 3 .and. ipr4.ne.5)  then
            do 260  iph = 0, 1
               do 250  ie = 1, nncrit
                  write(fname,200)  ie, iph
  200             format ('fbeta', i1, 'p', i1, '.dat')
                  open (unit=1, file=fname, status='unknown')
                  write(1,210)  iph, ie, ckspc(ie)
  210             format ('# iph, ie, ckspc(ie) ', 2i5, 1pe20.6, /
     1                    '#  angle(degrees), fbeta/|p|,  fbeta')
                  do 240  ibeta = -nbeta, nbeta
                     cosb = .025 * ibeta
                     if (cosb .gt.  1)  cosb =  1
                     if (cosb .lt. -1)  cosb = -1
                     angle = acos (cosb)
                     write(1,230)  angle*raddeg, 
     1                  fbetac(ibeta,iph,ie)/ckspc(ie),
     2                  fbetac(ibeta,iph,ie)
  230                format (f10.4, 1p, 2e15.6)
  240             continue
                  close (unit=1)
  250          continue
  260       continue
         endif

         call wlog(' Searching for paths...')
         call paths (ckspc, fbetac, xlamc, pcritk, pcrith, critpw,
     1               nncrit, rmax, nlegxx, rfms2,
     2               nat, rat, iphat, ibounc) 
         call wlog(' Eliminating path degeneracies...')
         call pathsd (ckspc, fbetac, xlamc, ne, ik0, cksp, 
     1                fbeta, xlam, critpw, ipr4, nncrit, potlbl,
     1            ipol, ispin, evec, xivec,eels) !KJ added eels 5/06
         call wlog(' Done with module 4: pathfinder.')
      endif
      close (unit=11)

  400 call par_barrier
      call par_end

c     sub-program exchange
!     stop
      return

      end
      subroutine ccrit (npat, ipat, ckspc,
     1    fbetac, xlamc, rmax, pcrith, pcritk, nncrit, ipot,
     2    rpath, lheap, lkeep, xcalcx, iclus)

c     lheap to add to heap, lkeep if keep path at output.
c     NB, if lheap is false, lkeep is not used (since path
c     won't be in the heap).

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      logical lheap, lkeep
      dimension ipat(npatx)
      dimension ipot(0:natx)
      parameter (necrit=9, nbeta=40)
      dimension fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      dimension xlamc(necrit), iclus(0:natx)

c     local variables
      dimension ri(npatx+1), beta(npatx+1), indbet(npatx+1)


c     mrb is efficient way to get only ri and beta
c     note that beta is cos(beta)
      call mrb (npat, ipat, ri, beta)

      rpath = 0
      do 300  i = 1, npat+1
         rpath = rpath + ri(i)
  300 continue

c     If we can decide only on rpath, do it here...
      if (rpath .gt. rmax)  then
         lheap = .false.
         lkeep = .false.
         return
      endif

c     If last atom central atom, do put in heap, don't use it
c     as an actual path at output
      if (ipat(npat).eq.0)  then
         lheap = .true.
         lkeep = .false.
         return
      endif

c     Make index into fbetac array (this is nearest cos(beta) grid 
c     point, code is a bit cute [sorry!], see prcrit for grid).
      do 290  i = 1, npat+1
         tmp = abs(beta(i))
         n = tmp / 0.025
         del = tmp - n*0.025
         if (del .gt. 0.0125)  n = n+1
         if (beta(i) .lt. 0)  n = -n
         indbet(i) = n
  290 continue

c     Decide if we want the path added to the heap if necessary.
c     (Not necessary if no pcrith in use.)
      if (pcrith .gt. 0)  then

         call mcrith (npat, ipat, ri, indbet,
     1                ipot, nncrit, fbetac, ckspc, xheap)

c        xheap = -1 if not defined for this path (too few legs, etc.)
         if (xheap .ge. 0  .and.  xheap .lt. pcrith)  then
c           Do not want path in heap
            lheap = .false.
            lkeep = .false.
            return
         endif
      endif
c     Keep this path in the heap
      lheap = .true.

c     We may want path in heap so that other paths built from this
c     path will be considered, but do not want this path to be
c     written out for itself.  Decide that now and save the flag
c     in the heap, so we won't have to re-calculate the mpprm
c     path parameters later.

c     Skip calc if pcritk < 0
      if (pcritk .le. 0)  then
         lkeep = .true.
         goto 999
      endif

c     Make xout, output inportance factor.
      call mcritk (npat, ipat, ri, beta, indbet,
     1             ipot, nncrit, fbetac, xlamc, ckspc, xout, xcalcx)

c     See if path wanted for output
c     Do not want it if last atom is central atom (xout = -1) or
c     if xout is too small
      lkeep = .false.
      if (xout .ge. pcritk)  lkeep = .true.

c     If path is entirely inside a cluster do not keep it
  999 nclus=0
      do 700 i=1,npat
  700 nclus=nclus+iclus(ipat(i))
      if (nclus.eq.0) lkeep = .false.

      return
      end
c     These heap routines maintain a heap (array h) and an index
c     array (array ih) used to keep other data associated with the heap
c     elements.

      subroutine hup (h, ih, n)
c     heap is in order except for last element, which is new and must
c     be bubbled through to its proper location
c     new element is at i, j = index of parent
      integer  n,i,j
      integer  ih(n)
      dimension h(n)

      i = n

   10 j = i/2
c     if no parent, we're at the top of the heap, and done
      if (j .eq. 0)  return
      if (h(i) .lt. h(j))  then
         call swap (h(i), h(j))
         call iswap (ih(i), ih(j))
         i = j
         goto 10
      endif
      return
      end

      subroutine hdown (h, ih, n)
c     h is in order, except that 1st element has been replaced.
c     Bubble it down to its proper location.  New element is i,
c     children are j and k.

      integer  n,i,j,k
      integer  ih(n)
      dimension h(n)

      i = 1

   10 continue
      j = 2*i
      k = j + 1

c     if j > n, new element is at bottom, we're done
      if (j .gt. n)  return
c     handle case where new element has only one child
      if (k .gt. n)  k = j

      if (h(j) .gt. h(k))  j = k
c     j is now index of smallest of children

      if (h(i) .gt. h(j))  then
         call swap (h(i), h(j))
         call iswap (ih(i), ih(j))
         i = j
         goto 10
      endif

      return
      end

      subroutine swap (a, b)
      t = a
      a = b
      b = t
      return
      end

      subroutine iswap (i, j)
      integer  i,j,k
      k = i
      i = j
      j = k
      return
      end
      subroutine ipack (iout, n, ipat)

c     Input:  n          number of things to pack, nmax=8
c             ipat(1:n)  integers to pack
c     Output: iout(3)    packed version of n and ipat(1:n)
c
c     Packs n and ipat(1:n) into 3 integers, iout(1:3).  Algorithm
c     packs three integers (each between 0 and 1289 inclusive) into a
c     single integer.  Single integer must be INT*4 or larger, we assume
c     that one bit is wasted as a sign bit so largest positive int
c     is 2,147,483,647 = (2**31 - 1).
c     This version is specifically for the path finder and
c     degeneracy checker.

      dimension iout(3), ipat(n)
      dimension itmp(8)
      parameter (ifac1 = 1290, ifac2 = 1290**2)

      if (n .gt. 8)  call par_stop('ipack n too big')

      do 10  i = 1, n
         itmp(i) = ipat(i)
   10 continue
      do 20  i = n+1, 8
         itmp(i) = 0
   20 continue

      iout(1) = n       + itmp(1)*ifac1 + itmp(2)*ifac2
      iout(2) = itmp(3) + itmp(4)*ifac1 + itmp(5)*ifac2
      iout(3) = itmp(6) + itmp(7)*ifac1 + itmp(8)*ifac2

      return
      end
      subroutine upack (iout, n, ipat)

c     retrieve n and ipat from iout
c     Input:  iout(3)  packed integers
c             n        max number to get, must be .le. 8
c     Output: n        number unpacked
c             ipat(1:n) unpacked integers

      dimension iout(3), ipat(n)
      dimension itmp(8)
      parameter (ifac1 = 1290, ifac2 = 1290**2)

      nmax = n
      if (nmax .gt. 8)  call par_stop('nmax .gt. 8 in upack')

      n = mod (iout(1), ifac1)
      if (n .gt. nmax)  call par_stop('nmax in upack too small')

      itmp(1) = mod (iout(1), ifac2) / ifac1
      itmp(2) = iout(1) / ifac2
      itmp(3) = mod (iout(2), ifac1)
      itmp(4) = mod (iout(2), ifac2) / ifac1
      itmp(5) = iout(2) / ifac2
      itmp(6) = mod (iout(3), ifac1)
      itmp(7) = mod (iout(3), ifac2) / ifac1
      itmp(8) = iout(3) / ifac2

      do 10  i = 1, n
         ipat(i) = itmp(i)
   10 continue

      return
      end
      subroutine mcrith (npat, ipat, ri, indbet,
     1                   ipot, nncrit, fbetac, ckspc, xheap)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      dimension ipat(npatx)
      dimension ri(npatx+1), indbet(npatx+1)
      dimension ipot(0:natx)
      parameter (necrit=9, nbeta=40)
      dimension fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)

c     Decide if we want the path added to the heap.

      if (ipat(npat) .eq. 0 .or. npat.le.2)  then
c        Partial path is used for xheap, not defined for ss and
c        triangles.  Special case: central atom added to end of path 
c        necessary for complete tree, but not a real path, again,
c        xheap not defined.  Return -1 as not-defined flag.
         xheap = -1
      else
c        Calculate xheap and see if we want to add path to heap.
c        Factor for comparison is sum over nncrit of
c        f(beta1)*f(beta2)*..*f(beta npat-2)/(rho1*rho2*..*rho npat-1).
c        Compare this to sum(1/p), multiply by 100 so we can think 
c        in percent.  Allow for degeneracy when setting crit.
         xheap = 0
         spinv = 0
         do 340  icrit = 1, nncrit
            x = ckspc(icrit) ** (-(npat-1)) * ri(npat-1)
            do 320  i = 1, npat-2
               ipot0 = ipot(ipat(i))
               x = x * fbetac(indbet(i),ipot0,icrit) / ri(i)
  320       continue
            spinv = spinv + 1/ckspc(icrit)
            xheap = xheap + x
  340    continue
         xheap = 100 * xheap / spinv

c        Factor for comparison is sum over nncrit of
c        New xheap:
c        Full chi is
c f(beta1)*f(beta2)*..*f(beta npat)cos(beta0)/(rho1*rho2*..*rho nleg).
c Some of this stuff may change when the path is modified --
c we can't use rho nleg or nleg-1, beta0, beta(npat) or beta(npat-1).
c We DO want to normalize wrt first ss path, f(pi)/(rho nn)**2.
c
c So save f(pi)/(rho nn)**2, 
c calculate 
c f(beta1)*f(beta2)*..*f(beta npat-2)/(rho1*rho2*..*rho npat-1).
c divide nn ss term by stuff we left out -- beta(npat), beta(npat-1),
c cos(beta0), rho nleg, rho nleg-1.
c
c Sum this over nncrit and try it out.
*
c        Sum over nncrit of
c        1/(rho1+rho2+..+rho npat-1).
*        reff = 0
*        do 350  i = 1, npat-1
*           reff = reff + ri(i)
* 350    continue
*        xss = 0
*        do 360  icrit = 1, nncrit
*           rho = ckspc(icrit) * reff
*           xss = xss + 1/rho
* 360    continue
*        xheap = 100 * xheap / xss
      endif

      return
      end
      subroutine mcritk (npat, ipat, ri, beta, indbet,
     1      ipot, nncrit, fbetac, xlamc, ckspc, xout, xcalcx)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      dimension ipat(npatx)
      dimension ri(npatx+1), beta(npatx+1), indbet(npatx+1)
      dimension ipot(0:natx)
      parameter (necrit=9, nbeta=40)
      dimension fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      dimension xlamc(necrit)

cc    xcalcx is max xcalc encountered so far.  Set to -1 to reset it --
cc    otherwise it gets passed in and out as mcritk gets called.
c     calculation of xcalcx changed by ala. It is calculated only
c     a first call, i.e. for the NN SS path, and is not recalculated

c     We may want path in heap so that other paths built from this
c     path will be considered, but do not want this path to be
c     written out for itself.  Decide that now and save the flag
c     in the heap, so we won't have to re-calculate the mpprm
c     path parameters later.

c     Do not want it for output if last atom is central atom,
c     use xout = -1 as flag for undefined, don't keep it.
      if (ipat(npat) .eq. 0)  then
         xout = -1
         return
      endif

c     Make xout, output inportance factor.  This is sum over p of
c     (product of f(beta)/rho for the scatterers) * 
c                                 (cos(beta0)/rho(npat+1).
c     Compare this to xoutx, max xout encountered so far.
c     Use mean free path factor, exp(-rtot/xlam)
c     Multiply by 100 so we can think in percent.

      xcalc = 0
      rtot = 0
      do 410  i = 1, npat+1
         rtot = rtot + ri(i)
  410 continue
      do 460  icrit = 1, nncrit
         rho = ri(npat+1) * ckspc(icrit)
c        when beta(0)=90 degrees, get zero, so fudge with cos=.2
         x = max (abs(beta(npat+1)), 0.3) / rho
         do 420  iat = 1, npat
            rho = ri(iat) * ckspc(icrit)
            ipot0 = ipot(ipat(iat))
            x = x * fbetac(indbet(iat),ipot0,icrit) / rho
  420    continue
         x = x * exp (-rtot/xlamc(icrit))
         xcalc = xcalc + x
  460 continue
      if (xcalcx.le.0)  xcalcx = xcalc
      xout = 100 * xcalc / xcalcx
      return
      end
      subroutine mpprmd (npat, ipat, ri, beta, eta)
c     double precision version so angles come out right
c     for output...

c     Used with pathsd, a single precision code, so BE CAREFUL!!
c     No implicit, all variables declared explicitly.

c     make path parameters, ie, ri, beta, eta for each leg for a given
c     path.

c     Input is list of atoms (npat, ipat(npat)), output is
c     ri(npat+1), beta, eta.

      dimension ipat(npat)
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

c     /atoms/ is single precision from pathsd
      common /atoms/ rat(3,0:natx), ipot(0:natx), i1b(0:natx)

      complex*16  coni
      parameter (coni = (0,1))

      complex*16  alph(npatx+1), gamm(npatx+2), eieta
      double precision beta(npatx+1)
      double precision ri(npatx+1), eta(npatx+1)

      double precision x, y, z
      double precision ct, st, cp, sp, ctp, stp, cpp, spp
      double precision cppp, sppp

      n = npat + 1
      do 100  j = 1, n

c        get the atoms in this path
c        we actually have them already via the ipat array
c        remember that we'll want rat(,npat+1)=rat(,0) and
c                                 rat(,npat+2)=rat(,1) later on
c        make alpha, beta, and gamma for point i from 1 to N
c        NB: N is npat+1, since npat is number of bounces and N is
c            number of legs, or think of N=npat+1 as the central atom
c            that is the end of the path.
c
c        for euler angles at point i, need th and ph (theta and phi)
c        from rat(i+1)-rat(i)  and  thp and php
c        (theta prime and phi prime) from rat(i)-rat(i-1)
c
c        Actually, we need cos(th), sin(th), cos(phi), sin(phi) and
c        also for angles prime.  Call these  ct,  st,  cp,  sp   and
c                                            ctp, stp, cpp, spp.
c
c        We'll need angles from n-1 to n to 1,
c        so use rat(n+1) = rat(1), so we don't have to write code
c        later to handle these cases.

c        i = ipat(j)
c        ip1 = ipat(j+1)
c        im1 = ipat(j-1)
c        except for special cases...
         if (j .eq. n)  then
c           j central atom, j+1 first atom, j-1 last path atom
            i = 0
            ip1 = ipat(1)
            im1 = ipat(npat)
         elseif (j .eq. npat)  then
c           j last path atom, j+1 central, j-1 next-to last atom
c              unless only one atom, then j-1 central
            i = ipat(j)
            ip1 = 0
            if (npat .eq. 1)  then
               im1 = 0
            else
               im1 = ipat(npat-1)
            endif
         elseif (j .eq. 1)  then
c           j first atom, j+1 second unless only one,
c           then j+1 central, j-1 central
            i = ipat(j)
            if (npat .eq. 1)  then
               ip1 = 0
            else
               ip1 = ipat (j+1)
            endif
            im1 = 0
         else
            i = ipat(j)
            ip1 = ipat(j+1)
            im1 = ipat(j-1)
         endif

         x = rat(1,ip1) - rat(1,i)
         y = rat(2,ip1) - rat(2,i)
         z = rat(3,ip1) - rat(3,i)
         call strigd (x, y, z, ct, st, cp, sp)
         x = rat(1,i) - rat(1,im1)
         y = rat(2,i) - rat(2,im1)
         z = rat(3,i) - rat(3,im1)
         call strigd (x, y, z, ctp, stp, cpp, spp)

c        cppp = cos (phi prime - phi)
c        sppp = sin (phi prime - phi)
         cppp = cp*cpp + sp*spp
         sppp = spp*cp - cpp*sp

c        alph = exp**(i alpha)  in ref eqs 18
c        beta = cos(beta)
c        gamm = exp**(i gamma)
         alph(j) = st*ctp - ct*stp*cppp - coni*stp*sppp
         beta(j) = ct*ctp + st*stp*cppp
c        Watch out for roundoff errors
         if (beta(j) .lt. -1)  beta(j) = -1
         if (beta(j) .gt.  1)  beta(j) =  1
         gamm(j) = st*ctp*cppp - ct*stp + coni*st*sppp
         ri(j) = sdist (rat(1,i), rat(1,im1))
  100 continue

c     Make eta(i) = alpha(i) + gamma(i+1).  We only really need
c     exp(i*eta)=eieta, so that's what we'll calculate.
c     We'll need gamm(N+1)=gamm(npat+2)=gamm(1)
      gamm(npat+2) = gamm(1)
      do 150  j = 1, npat+1
         eieta = alph(j) * gamm(j+1)
         call sargd (eieta, eta(j))
  150 continue

c     Return beta as an angle, ie, acos(beta).  Check for beta >1 or
c     beta <1 (roundoff nasties)
      do 160  j = 1, npat+1
         if (beta(j) .gt.  1)  beta(j) =  1
         if (beta(j) .lt. -1)  beta(j) = -1
         beta(j) = acos(beta(j))
  160 continue

      return
      end
      subroutine strigd (x, y, z, ct, st, cp, sp)
      double precision x, y, z, ct, st, cp, sp, r, rxy
c     returns cos(theta), sin(theta), cos(phi), sin(ph) for (x,y,z)
c     convention - if x=y=0, phi=0, cp=1, sp=0
c                - if x=y=z=0, theta=0, ct=1, st=0
      parameter (eps = 1.0e-6)
      r = sqrt (x**2 + y**2 + z**2)
      rxy = sqrt (x**2 + y**2)
      if (r .lt. eps)  then
         ct = 1
         st = 0
      else
         ct = z/r
         st = rxy/r
      endif
      if (rxy .lt. eps)  then
         cp = 1
         sp = 0
      else
         cp = x / rxy
         sp = y / rxy
      endif

      return
      end
      subroutine sargd (c, th)

      double precision x, y, th
      complex*16  c
      parameter (eps = 1.0e-6)
      x = dble(c)
      y = dimag(c)
      if (abs(x) .lt. eps)  x = 0
      if (abs(y) .lt. eps)  y = 0
      if (abs(x) .lt. eps  .and.  abs(y) .lt. eps)  then
         th = 0
      else
         th = atan2 (y, x)
      endif
      return
      end
      subroutine mpprmp (npat, ipat, xp, yp, zp,
     1                   ipol, ispin, evec, xivec,ica)   !KJ added ica 5/06

c     make path parameters,  xp, yp,zp for each atom for a given
c     path. The allowed symmetry operations are restricted by
c     polarization type ipol (evec, xivec) and spin type (ispin)
c     of calculations
c      ipol=0 - polarization average 
c      ipol=1 - linear (admixture of 2 linear for elpty.ne.0)
c      ipol=2 - circular dichroism
c      ispin=0 - spin-independent system V_up=V_dn=V_av
c      |ispin|=1 - V_up .ne. V_dn, sum over up and down calculations
c      ispin= 2 - V_up portion of |ispin|=1 
c      ispin=-2 - V_dn portion of |ispin|=1 
c    all possible cases fall into 7 categories of allowed symmetries
c    Spin-independent calculations 
c     1) IF ipol=0 
c        any path rotation, reflection and reversal are allowed
c     2) ELSEIF ispin=0 ipol=1  xivec.eq.0 (dipole transitions only)
c        any rotation around evec, reflections in planes normal
c        and parallel to evec, path reversal
c     3) ELSEIF ispin=0 ipol=1   xivec.ne.0
c        reflections in 2 planes (xivec, evec) and (xivec, B field)
c        reflection in (evec, B field) probably does not conserve
c        E1-E2 cross term (currently used; check and fix later)
c     4) ELSEIF ispin=0 ipol=2  
c        rotations around xivec, path reversal (? -check for XNCD)
c    Spin systems (only ispin.ne.0, ipol.ne.0 below)
c     5) ELSEIF  xivec(1)=xivec(2)=0 .and. ( ipol.eq.2 .or. 
c                 ( ipol.eq.1 .and.xivec(3)=evec(1)=evec(2)=0 ) )
c        rotations around spin axis
c     6) ELSEIF ipol=1 xivec(1)=xivec(2)=evec(3)=0 (XMLD)
c        only 180 degrees rotation around spin axis
c     7) ELSE   ipol=1,2 .and. (xivec(1).ne.0 or xivec(2).ne.0 )
c        NO symmetry operations
c    Disclaimer: the symmetry rules for might be
c    too restrictive and were checked for ipol=2 calculations (case=5)
c    One can always check the symmetry rules by comparing with case=7.

c    To exploit above symmetry, every path is recorded in a new frame of
c    reference, constructed for the calculations specified.

c     Input is list of atoms (npat, ipat(npat)), output are
c     x,y,z coord. of path in standard frame of reference
c     (see comments in timrep.f or here below)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      double precision evec(3), xivec(3)
      double precision  ro2, norm, zvec, xvec, yvec, ri, xp1, yp1, zp1
      dimension ipat(npatx+1), zvec(3), xvec(3), yvec(3)

      common /atoms/ rat(3,0:natx), ipot(0:natx), i1b(0:natx)

      dimension xp(npatx), yp(npatx), zp(npatx)
      dimension xp1(npatx), yp1(npatx), zp1(npatx)
      dimension ri(3,npatx)
      logical lkvec, lkz, lez
      integer ica !KJ new input parameter. overrides icase if positive.

      parameter (eps4 = 1.0E-4)

c     the atoms in this path are passed via the ipat and rat arrays


      if (ica.gt.0.and.ica.lt.8) then !KJ added this and next 2 lines
!KJ Purpose : for eels calculations, we want a result for many k and q.
!KJ This means we cannot use the symmetry operations.
         icase=ica
      else
      
c        determine which case we are dealing with (see above comments)
c        default is icase =7 - no symmetry at all (safe for untested cases)
c        logical lkvec answers whether xivec is a vector
         lkvec = .false.
         if (xivec(1)**2+xivec(2)**2+xivec(3)**2.gt.eps4) lkvec = .true.
c        logical lkz answers whether xivec is a vector along z at most
         lkz = .true.
         if (xivec(1)**2+xivec(2)**2.gt.eps4) lkz = .false.
c        logical lez answers whether evec is a vector along z at most
         lez = .true.
         if (evec(1)**2+evec(2)**2.gt.eps4) lez = .false.

         icase = 7
         if (ipol.eq.0) then
           icase = 1
         elseif (ispin.eq.0) then
           if (ipol.eq.1 .and. (.not.lkvec)) icase = 2
           if (ipol.eq.1 .and. lkvec) icase = 3
           if (ipol.eq.2) icase=4
         else
           if (ipol.eq.2 .and. lkz) icase = 5
           if (ipol.eq.1 .and. .not.lkvec  .and. lez) icase = 5
           if (ipol.eq.1 .and. lkz .and. evec(3)**2.lt.eps4) icase = 6
         endif

 
       endif  !KJ my block. 5/06


c     initialize staff
      do 10 j = 1, npatx
         xp(j) = 0
         yp(j) = 0
         zp(j) = 0
         xp1(j) = 0
         yp1(j) = 0
         zp1(j) = 0
   10 continue
      nleg = npat + 1
      do 20  j = 1, npat
      do 20  i = 1, 3
         ri(i,j) = rat(i,ipat(j)) - rat(i,0)
   20 continue
      do 30  j = nleg, npatx
      do 30  i = 1, 3
         ri(i,j) = 0
   30 continue
      do 40 i =1, 3
         xvec(i) = 0
         yvec(i) = 0
         zvec(i) = 0
   40 continue

      if (icase.eq.1) then
c        z-axis along first leg
         norm = ri(1,1)*ri(1,1)+ri(2,1)*ri(2,1)+ri(3,1)*ri(3,1)
         norm = sqrt(norm)
         do 140 i = 1, 3
           zvec(i) = ri(i,1)/norm
  140    continue
      elseif (icase.eq.2 .or. icase.eq.3) then
c        z-axis in direction of polarization
         do 120 i = 1, 3
           zvec(i) = evec(i)
  120    continue
      else 
c        keep z-axis
         zvec(3) = 1.d0
      endif

      do 160 j = 1,npat
      do 160 i = 1, 3
        zp1(j) = zp1(j) + zvec(i)*ri(i,j)
  160 continue
c     if no symmetries, don't waste time
      if (icase.eq.7) then
         xvec(1) = 1.d0
         yvec(2) = 1.d0
         goto 390
      endif

      if (icase.eq.1 .or. icase.ge.4) goto 240
c     use z-->-z symmetry 
      num = 1
  200 continue
      if (abs(zp1(num)) .gt. eps4) then
         if (zp1(num) .lt. 0) then
c           inverse all z-coordinates and zvec, if 
c           first nonzero z-coordinate is negative 
            do 210 j = 1, 3
               zvec(j) = - zvec(j)
  210       continue
            do 220 j = 1, npat
               zp1(j) = - zp1(j)
  220       continue
         endif
         goto 240
      endif
      num = num +1
      if (num .lt. nleg) then
         goto 200
      endif
c     z--> -z symmetry has been used
  240 continue

c     use rotations around z and reflections containing z
      num = 1
  300 continue
      ro2 = 0
      do 310 i =1, 3
         ro2 = ro2 + ri(i,num)*ri(i,num)
  310 continue
c     looking for first atom which is not on z-axis
      ro2 = ro2 - zp1(num)*zp1(num)
      ro2 = sqrt(abs(ro2))
      if (ro2 .ge. eps4) then
c     if atom not on the z-axis then
         if (icase.eq.1.or.icase.eq.2.or.icase.eq.4.or.icase.eq.5) then
c           any rotation around z is allowed
c           choose x-axis so that x-coord. positive and y=0.
            do 320 i = 1, 3
               xvec(i) = ri(i,num) - zvec(i)*zp1(num)
  320       continue
            do 330 i = 1, 3
               xvec(i) = xvec(i)/ro2
  330       continue
         elseif (icase.eq.3) then
c           if elliptical polarization then
c           choose x-axis along incident beam
            do 350 i =1, 3
               xvec(i) = xivec(i)
  350       continue
         else
c           icase.eq.6 choose x-axis so that x-coord is positive
            xvec(1) = 1.d0
            if (ri(1,num).lt.0) xvec(1) = -1.d0
         endif
         yvec(1) = zvec(2)*xvec(3) - zvec(3)*xvec(2)
         yvec(2) = zvec(3)*xvec(1) - zvec(1)*xvec(3)
         yvec(3) = zvec(1)*xvec(2) - zvec(2)*xvec(1)
         goto 390
      endif
      num = num + 1
      if (num .lt. nleg) then
         goto 300
      endif

  390 continue

c     calculate x,y coord for each atom in chosen frame of reference
      do 400 j = 1, npat
      do 400 i =1,3
         xp1(j) = xp1(j) + xvec(i)*ri(i,j)
         yp1(j) = yp1(j) + yvec(i)*ri(i,j)
  400 continue

      if (icase.eq.3) then
c        check that first nonzero  x-coordinate is positive,
c        no need to check it in other cases.
         num = 1
  500    continue
         if (abs(xp1(num)) .ge. eps4) then
            if (xp1(num) .lt. 0) then
               do 510 j = 1, npat
                  xp1(j) = - xp1(j)
  510          continue
            endif
            goto 520
         endif
         num = num + 1
         if (num .lt. nleg) then
            goto 500
         endif
  520    continue
      endif

      if (icase.ge.4) goto 590
      num = 1
  570 continue
c     inverse all y-coordinates if first nonzero y-coord is negative
      if (abs(yp1(num)) .ge. eps4) then
         if (yp1(num) .lt. 0) then
            do 580 j = 1, npat
               yp1(j) = - yp1(j)
  580       continue
         endif
         goto 590
      endif
      num = num + 1
      if (num .lt. nleg) then
         goto 570
      endif
  590 continue

      do 595 j = 1, npat
        xp(j) = xp1(j)
        yp(j) = yp1(j)
        zp(j) = zp1(j)
  595 continue
c     now xp,yp,zp represent the path in standard order
      return
      end
      subroutine mrb (npat, ipat, ri, beta)

c     Make ri, beta and rpath path parameters for crit calculations.

c     Input is list of atoms (npat, ipat(npat)), output is
c     ri(npat+1), beta, eta.

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      dimension ipat(npatx)

      common /atoms/ rat(3,0:natx), ipot(0:natx), i1b(0:natx)

      dimension beta(npatx+1), ri(npatx+1), ipat0(npatx+1)
c#mn
       external sdist

      nleg = npat+1
c     central atom is atom 0 in rat array
c     need local ipat0 array since we use ipat0(npat+1), final atom
c     in path (final atom is, of course, the central atom)
      do 10  i = 1, npat
         ipat0(i) = ipat(i)
   10 continue
      ipat0(nleg) = 0

      do 30  ileg = 1, nleg
c        make beta and ri for point i from 1 to N
c        NB: N is npat+1, since npat is number of bounces and N is
c            number of legs, or think of N=npat+1 as the central atom
c            that is the end of the path.
c
c        We'll need angles from n-1 to n to 1,
c        so use rat(n+1) = rat(1), so we don't have to write code
c        later to handle these cases.

c        Work with atom j
c        jp1 = (j+1)
c        jm1 = (j-1)
         j = ileg
         jm1 = j-1
         jp1 = j+1
c        Fix special cases (wrap around when j is near central atom,
c        also handle ss and triangular cases).
         if (jm1 .le.    0)  jm1 = nleg
         if (jp1 .gt. nleg)  jp1 = 1

         jat = ipat0(j)
         jm1at = ipat0(jm1)
         jp1at = ipat0(jp1)

         ri(ileg) = sdist (rat(1,jat), rat(1,jm1at))

c        Make cos(beta) from dot product
         call dotcos (rat(1,jm1at), rat(1,jat), rat(1,jp1at),
     1               beta(ileg))
   30 continue

      rpath = 0
      do 60  ileg = 1, nleg
         rpath = rpath + ri(ileg)
   60 continue

      return
      end
      subroutine dotcos (rm1, r, rp1, cosb)
      dimension rm1(3), r(3), rp1(3)

      parameter (eps = 1.0e-8)

      cosb = 0
      do 100  i = 1, 3
         cosb = cosb + (r(i)-rm1(i)) * (rp1(i)-r(i))
  100 continue

c     if denom is zero (and it may be if 2 atoms are in the same place,
c     which will happen when last path atom is central atom), set
c     cosb = 0, so it won't be undefined.

      denom = (sdist(r,rm1) * sdist(rp1,r))
      if (denom .gt. eps)  then
         cosb = cosb / denom
      else
         cosb = 0
      endif
      return
      end
      subroutine outcrt (npat, ipat, ckspc,
     1    nncrit, fbetac, xlamc, ne, ik0, cksp, 
     1    fbeta, xlam, ipot,
     1    xport, xheap, xheapr,
     1    xout, xcalcx)

c     This make pw importance factor for pathsd, also recalculates
c     pathfinder criteria for output.  Pathfinder recalculation
c     is hacked from ccrit, so be sure to update this if ccrit
c     is changed.

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      dimension ipat(npatx)
      dimension ipot(0:natx)
      parameter (necrit=9, nbeta=40)
      dimension fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      dimension fbeta(-nbeta:nbeta,0:nphx,nex), cksp(nex)
      dimension xlamc(necrit), xlam(nex)

c     local variables
      dimension ri(npatx+1), beta(npatx+1), indbet(npatx+1)
      dimension xporti(nex)
      parameter (eps = 1.0e-6)

c     Space for variables for time reversed path (used in xheapr
c     calculation below)
      dimension ipat0(npatx)
      dimension ri0(npatx+1), indbe0(npatx+1)

c     mrb is 'efficient' way to get only ri and beta
c     note that beta is cos(beta)
      call mrb (npat, ipat, ri, beta)

c     Make index into fbeta array (this is nearest cos(beta) grid point,
c     code is a bit cute [sorry!], see prcrit for grid).
      do 290  i = 1, npat+1
         tmp = abs(beta(i))
         n = tmp / 0.025
         del = tmp - n*0.025
         if (del .gt. 0.0125)  n = n+1
         if (beta(i) .lt. 0)  n = -n
         indbet(i) = n
  290 continue

c     Make pw importance factor by integrating over all points
c     above the edge
c     Path importance factor is integral d|p| of
c        (product of f(beta)/rho for the scatterers) * cos(beta0)/rho0
c     Include mean free path factor, exp(-rtot/xlam)
      rtot = 0
      do 510  i = 1, npat+1
         rtot = rtot + ri(i)
  510 continue
      do 560  ie = ik0, ne
         rho = ri(npat+1) * cksp(ie)
         crit = max (abs(beta(npat+1)), 0.3) / rho
         do 520  iat = 1, npat
            rho = ri(iat) * cksp(ie)
            ipot0 = ipot(ipat(iat))
            crit = crit * fbeta(indbet(iat),ipot0,ie) / rho
  520    continue
         crit = crit * exp (-rtot/xlam(ie))
         xporti(ie) =  abs(crit)
  560 continue


c     integrate from ik0 to ne
      nmax = ne - ik0 + 1
      call strap (cksp(ik0), xporti(ik0), nmax, xport)

c     Stuff for  output.
c     Heap crit thing (see ccrit and mcrith for comments)
c     If a path got time reversed, its xheap may be smaller than
c     it was before it got time-reversed.  So calculate it both
c     ways.
c     xheap for path, xheapr for time-reversed path

      xheap  = -1
      xheapr = -1
      call mcrith (npat, ipat, ri, indbet,
     1             ipot, nncrit, fbetac, ckspc, xheap)

c     Prepare arrays for time reversed path and make xheapr
c     See timrev.f for details on indexing here.

      nleg = npat+1
c     ri
      do 200  i = 1, nleg
         ri0(i) = ri(nleg+1-i)
  200 continue
c     indbet  and ipat
      indbe0(nleg) = indbet(nleg)
      do 210  i = 1, nleg-1
         indbe0(i) = indbet(nleg-i)
         ipat0(i) = ipat(nleg-i)
  210 continue

      call mcrith (npat, ipat0, ri0, indbe0,
     1             ipot, nncrit, fbetac, ckspc, xheapr)

c     Keep crit thing (see mcritk for comments)
      call mcritk (npat, ipat, ri, beta, indbet,
     1             ipot, nncrit, fbetac, xlamc, ckspc, xout, xcalcx)

      return
      end
      subroutine repath ( ms, mpath, ipr4, pcritk, pcrith, nncrit, rmax,
     1             nlegxx, rfms2, critpw,
     2             nat, rat, iphat, ibounc,
     3             ipol, ispin, evec, xivec ,eels)  !KJ added eels 5/06

      implicit double precision (a-h, o-z)

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}

cc    geom.dat
        integer  nat, iatph(0:nphx), iphat(natx), ibounc(natx)
        double precision  rat(3,natx)
cc    global.dat 
c       configuration average
        integer nabs, iphabs
c       global polarization data
        integer  ipol, ispin, le2
        double precision evec(3), xivec(3), spvec(3), elpty,angks,rclabs
        complex*16 ptz(-1:1, -1:1)
cc    mod4.inp
        integer  mpath, ms, nncrit, nlegxx, ipr4
        real critpw, pcritk, pcrith,  rmax, rfms2
	
	integer eels !KJ added 5/06


c     Local stuff
      character*512 slog
      character*80 head(nheadx)
      dimension lhead(nheadx)

c     standard formats for string, integers and real numbers
  10  format(a)
  20  format (20i4)
  30  format (6f13.5)


c     Read  geom.dat file
      open (file='geom.dat', unit=3, status='old',iostat=ios)
c       read header from geom.dat
        nhead = nheadx
        call rdhead (3, nhead, head, lhead)
        nat = 0
        nph = 0
        do 40 iph = 0, nphx
  40    iatph(iph) = 0
  50    continue
         nat = nat+1
         if (nat .gt. natx)  then
           write(slog,55) ' nat, natx ', nat, natx
           call wlog(slog)
  55       format(a, 2i10)
           stop 'Bad input'
         endif
         read(3,*,end=60) idum,(rat(j,nat),j=1,3),iphat(nat),ibounc(nat)
         if (iphat(nat).gt.nph) nph = iphat(nat)
         if ( iatph(iphat(nat)).eq.0) iatph(iphat(nat)) = nat
        goto 50
  60    continue
        nat = nat-1
      close(3)

cc    global.inp
      open (file='global.dat', unit=3, status='unknown',iostat=ios)
c       configuration average data
        read  (3, 10) slog
        read  (3, 65) nabs, iphabs, rclabs
  65    format ( 2i8, f13.5)
c       global polarization data
        read  (3,10)   slog
        read  (3, 70)  ipol, ispin, le2, elpty, angks
  70    format ( 3i5, 2f12.4)
        read  (3, 10) slog
        do 80 i = 1,3
          read  (3,30) evec(i), xivec(i), spvec(i)
  80    continue
        read  (3, 10) slog
        do 90 i = -1, 1
          read (3,30) a1, b1, a2, b2, a3, b3
          ptz(-1,i)= cmplx(a1,b1)
          ptz(0,i) = cmplx(a2,b2)
          ptz(1,i) = cmplx(a3,b3)
  90    continue
      close(3)
c     read mod4.inp
      open (file='mod4.inp', unit=3, status='old',iostat=ios)
        read (3,10)  slog
        read (3,20)  mpath, ms, nncrit, nlegxx, ipr4
        read (3,10)  slog
        read (3,30)  critpw, pcritk, pcrith,  rmax, rfms2
      close(3)
      
c  !KJ Next section added to read EELS variables       5-06
c     read eels.inp
      eels=0
      open(file='eels.inp',unit=3,status='old',err=900)
        read(3,*,err=900,end=900) 
	read(3,20,err=900,end=900) eels
      close(3)
      goto 901
900   continue
      eels=0
901   continue
c  !KJ end my changes 
      

      return
      end
      subroutine paths (ckspc, fbetac, xlamc, pcritk, pcrith, critpw,
     1                  nncrit, rmax, nlegxx, rfms,
     2                  nat, ratdp, iphat, ibounc)

c     finds multiple scattering paths
c     This is single precision, units are Angstroms.  BE CAREFUL!

c     pcrith is cut-off fraction used when building paths
c            (path criterion for heap)
c     pcritk is cut-off fraction used on output
c            (path criterion for keeping)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      parameter (necrit=9, nbeta=40)
      dimension fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      dimension xlamc(necrit)

c     This common in pathsd, mpprm
      common /atoms/ rat(3,0:natx), ipot(0:natx), i1b(0:natx)
      double precision ratdp(3,natx)
      integer  iphat(natx), ibounc(natx)

      dimension m(-1:natx,0:natx)
      dimension mindex(natx+1)
c     Used for packed integers
      dimension iout(3)

c     ok true if all paths to rmax found.  If heap full, npx exceeded,
c     etc., last general shell may be incomplete, set ok=.false.
      logical ok
c     is label nfound, etc, written yet?
      logical wlabel

c     Heap data structure:
c     index is the pointer to the element of the data structure.
c     Each element contains
c        r        total path length
c                 Note that r is sorted along with index -- this keeps
c                 the heap maintenance routines fast.
c        mi, mj   m matrix elements used to place last atom in this path
c        npat     number of atoms in this path
c        ipat(npatx) indices of atoms in this path
c     next is the index of the next data structure element available.
c     If an element is freed, npat is the index of the free element
c     to use after using current "next" element.
c     nx is max number in heap
      integer    nx
c     parameter (nx = 10 000)
      parameter (nx = 6000 000)
c     r also used in making m matrix, must have nx >= natx+1
      integer   index(nx), npx, np, n, ip, i, iat0, idum
c     parameter (npx = 100 000)
      parameter (npx = 100000000)
      dimension r(nx), mi(nx), mj(nx)
      dimension npat(nx)
      dimension ipat (npatx,nx)
c     Keep this path on output
      logical keep1(nx), kp1tmp
c     to remmember atoms outside rfms
      dimension iclus(0:natx) 

c     Used with ipack, so need ipat(8)
      dimension ipat0(8)

c     paths are typically about 10 or 20 Ang
      parameter (big = 1.0e3)

      character*80  title

c     Returned from criterion checker, false if path fails criterion
      logical keep
      character*512 slog

      external sdist

c     transform to single precision for pathfinder
c     also count in pathfinder starts with 0, not with 1
      do 15 iat = 1, nat
        j = iat-1
        do 10 i = 1, 3
          rat(i, j) = real (ratdp(i,iat))
 10     continue
        ipot(j) = iphat(iat)
        i1b(j) = ibounc(iat)
 15   continue
      nat = nat - 1

c     nlegxx is max number of legs user wants to consider.
c     nlegs = npat+1, so set npatxx = min (npatx, nlegxx-1)
      npatxx = min (npatx, nlegxx-1)
c     Input rmax is one-way distances
      rmax = rmax*2
c     ratx is distance to most distant atom, used to check rmax
      ratx = 0
      iat0 = -1
      i1b(0) = 0

c     find index for the central atom
      do 20 iat = 0, nat
         if (ipot(iat).eq.0 .and. iat0.lt.0) iat0=iat
   20 continue

c     iclus = 0 for atoms inside rfms cluster, 1 for atoms outside
      do 21 iat = 0,nat
        rtmp = sdist(rat(1,iat),rat(1,iat0))
        if (rtmp.gt.rfms) iclus(iat)=1
        iclus(iat)=0
        if (rtmp.gt.rfms) iclus(iat)=1
   21 continue

      if (iat0.ne. 0) then
c       permute atoms 0 and iat0
c       do not need to permute i1b, since all of them are 1 in
c       this case, except i1b(0) = 0, which we want to keep.
        do 25 j=1,3
          temp = rat(j,0)
          rat(j,0) = rat(j,iat0)
          rat(j,iat0) = temp
   25   continue
        idum = ipot(0)
        ipot(0) = ipot(iat0)
        ipot(iat0) = idum
        idum = iclus(0)
        iclus(0) = iclus(iat0)
        iclus(iat0) = idum
      endif

c     Warn user if rmax > dist to most distant atom
c     1.01 to avoid roundoff error, matches rdinp where rmax default set
      if (rmax/2 .gt. 1.01 * ratx)  then
         call wlog('   WARNING:  rmax > distance to most distant atom.')
         call wlog('             Some paths may be missing.')
         write(slog,22) rmax/2, ratx
         call wlog(slog)
   22    format('             rmax, ratx ', 1p, 2e13.5)
      endif

c     Count number of 1st bounce atoms (at least 1 required).
      n1b = 0
      do 30  i = 1, nat
         if (i1b(i) .gt. 0)  n1b = n1b + 1
   30 continue
      if (n1b .lt. 1) 
     .  call par_stop('At least one 1st bounce atoms required.')

      if (rmax .ge. big)  call par_stop('Hey, get real with rmax!')

c     Make title for this run, include carriage control because head
c     (read above) includes carriage control.
      write(title,32)  rmax/2, pcritk, pcrith, critpw
   32 format('PATH  Rmax=', f6.3, ',  Keep_limit=', f5.2,
     1       ', Heap_limit', f5.2,'  Pwcrit=', f5.2, '%')

      write(slog,34) rmax/2, pcritk, pcrith
      call wlog(slog)
   34 format ('    Rmax', f8.4,
     1        '  keep and heap limits', 2f12.7)

      call wlog('    Preparing neighbor table')
      
   36 format (1x, a)
c     prepare table telling distance from atom i to atom j and then
c     back to central atom
c     First bounce is m(-1,...), m(0,...) is bounces from central
c     atom that are not first bounces.
      do 60  i = -1, nat
         ir = i
         if (i .eq. -1)  ir = 0
         do 40  j = 0, nat
c           r begins with element 1 so sort routine later will work
            r(j+1) = sdist (rat(1,ir), rat(1,j))
            r(j+1) = r(j+1) + sdist (rat(1,j), rat(1,0))
c           we don't need m(i,i), since this will be = shortest
c           of the r(j), so just set it to something very big,
c           it will sort to the end of this row and it won't
c           bother us
            if (j .eq. ir)  r(j+1) = big
c           If we're doing first bounce, use only the allowed first
c           bounce paths.
            if (i .eq. -1)  then
               if (i1b(j) .le. 0)  r(j+1) = big
            endif
   40    continue

c        prepare row i of m table
c        m is a distance table ordered such that distance from
c               i to m(i,0) to 0 <
c               i to m(i,1) to 0 <
c               i    m(i,2)    0 <
c               :    :    :
c               i    m(i,nat)  0
c
c        That is, m(i,0) is index of atom that gives shortest path,
c                 m(i,1)                        next shortest path, etc.
c        Note that m(0,0) is shortest single bounce path.

c        Again, r and mindex go from 1 to nat+1, m goes from 0 to nat
         call sortir (nat+1, mindex, r)
         do 50  j = 0, nat
            m(i,j) = mindex(j+1)-1
   50    continue
   60 continue

c     label for nfound, heap size, etc written?
      wlabel = .false.
c     initialize heap data space "next" pointers
      do 70  i = 1, nx-1
         npat(i) = i+1
   70 continue
      npat(nx) = -1
c     initial condition:  make the first path
c     n    number in heap
c     nna  number skipped counter
c     nhx  number used in heap max, a counter
      n = 1
      nna = 0
      nhx = n
      nwrote = 0
      index(n) = 1
      ip = index(n)
      next = 2
      mi(ip) = -1
      mj(ip) = 0
      npat(ip) = 1
      ipat(npat(ip),1) = m(mi(ip),mj(ip))

c     Someday change keep and keep1 to lkeep and lheap to match
c     ccrit variable names.
c     Initialize keep criterion
      xcalcx = -1
      call ccrit (npat(ip), ipat(1,ip), ckspc,
     1    fbetac, xlamc, rmax, pcrith, pcritk, nncrit, ipot,
     2    r(n), keep, keep1(ip), xcalcx, iclus)

      open (file='paths.bin', unit=3, access='sequential',
     1      form='unformatted', status='unknown', iostat=ios)
      call chopen (ios, 'paths.bin', 'paths')
c     These strings are all char*80 and include carriage control
c     temporary fix for zero title lines: fix later
      nhead = 1
      write(3) nhead
      write(3) title
      write(3)  nat
      do 90  i = 0, nat
         write(3) (rat(j,i),j=1,3), ipot(i), i1b(i)
   90 continue

c     r is the heap, index is the pointer to the rest of the data
c     np is the number of paths found and saved
      np = 0
c     nbx  mpat max (Number of Bounces maX)
      nbx = 0

c     done if path at top of heap is longer than longest path we're
c        interested in
c     done if max number of paths we want have been found
c     begin 'while not done' loop
      ok = .false.
  800 continue
         if (r(1) .gt. rmax  .or.  np .ge. npx .or. n.le.0)  then
c           n=0 means heap is empty
            if (n.le.0)  ok=.true.
            goto 2000
         endif

c        save element at top of heap in arrays labeled 0
c        dump to unit 3 (unformatted)
         ip = index(1)
         npat0 = npat(ip)
         do 100  i = 1, npat0
            ipat0(i) = ipat(i,ip)
  100    continue
         r0 = r(1)

c        Don't write out path if last atom is central atom, or
c        if it doesn't meet pcritk
         if (ipat0(npat0).ne.0 .and. keep1(ip))  then
            np = np+1
c           pack integers
            call ipack (iout, npat0, ipat0)
            write(3)  r0, iout
            nwrote = nwrote+1
c           write status report to screen
            if (mod(np,1000) .eq. 0)  then
               if (.not. wlabel)  then
                  call wlog('    nfound  heapsize  maxheap' //
     1               '  maxscatt   reff')
                  wlabel = .true.
               endif
               write(slog,132) np, n, nhx, nbx, r0/2
               call wlog(slog)
  132          format (4x, i6, i9, i9, i7, f12.4)
            endif
         endif

         if (np .ge. npx)  then
            write(slog,134) np
            call wlog(slog)
  134       format(i15, ' paths found.  (np .ge. npx)')
            goto 2000
         endif

c        Make new path by replacing last atom in path from top of heap,
c        put this path on top of heap and buble it down.  If row is
c        finished, or new path is too long, don't add it, instead
c        move last path in heap to the top.
c        If working on row mi=-1 (first bounce atoms), don't
c        use them if not allowed 1st bounce atoms.
         mj(ip) = mj(ip) + 1
         if (mi(ip).eq.-1  .and.  i1b(m(mi(ip),mj(ip))).le.0)  then
c           not allowed first bounce atom
            r(1) = big
            keep = .false.
c           type*, '1st bounce limit!'
         elseif (mj(ip) .ge. nat)  then
c           we've finished a row of m matrix
            r(1) = big
            keep = .false.
         else
c           new path has same indices, etc.  Only need to replace
c           last atom.
            ipat(npat(ip),ip) = m(mi(ip),mj(ip))
            call ccrit (npat(ip), ipat(1,ip), ckspc,
     1                  fbetac, xlamc, rmax, pcrith, pcritk, nncrit,
     2                  ipot, r(1), keep, keep1(ip), xcalcx, iclus)
         endif

c        If r is bigger than rmax or keep=false, remove element from
c        heap by taking the last element in the heap and moving it to
c        the top.  Then bubble it down.  When removing an element
c        from the heap, be sure to save the newly freed up index.
c        r(1) and index(1) are new path, set above
         if (r(1).gt.rmax .and. keep)  then
            call wlog(' odd case rmax...')
         endif
         if (r(1).gt.rmax .or. .not.keep)  then
            index(1) = index(n)
            r(1) = r(n)
c           use npat as pointer to next free location
            npat(ip) = next
            next = ip
            n = n-1
c           nna is Number Not Added to heap
            nna = nna + 1
c           Maybe heap may be empty here, but that's alright
         endif
         if (npat(index(1)).gt.nbx .and. n.gt.0)  nbx = npat(index(1))

c        If heap is empty, don't call hdown.
         if (n.gt.0)  call hdown (r, index, n)

c        and make a new path by adding an atom onto the end of the path
c        we saved, put this at the end of the heap and bubble it up.
c        Do this only if it won't be too many bounces.
         if (npat0+1 .le. npatxx)  then
            ip = next
            if (ip .lt. 0)  then
c              call wlog('   Heap full')
               goto 2000
            endif
            next0 = npat(ip)
            do 200  i = 1, npat0
               ipat(i,ip) = ipat0(i)
  200       continue
            mi(ip) = ipat0(npat0)
            mj(ip) = 0
            npat(ip) = npat0+1
            ipat(npat(ip),ip) = m(mi(ip),mj(ip))
            call ccrit (npat(ip), ipat(1,ip), ckspc,
     1                  fbetac, xlamc, rmax, pcrith, pcritk, nncrit,
     2                  ipot, rtmp, keep, kp1tmp, xcalcx, iclus)
            if (rtmp .gt. rmax  .and.  keep)  then
               call wlog(' odd case rmax and tmp...')
            endif
            if (rtmp .gt. rmax  .or.  .not.keep)  then
               npat(ip) = next0
               nna = nna+1
            else
c              add it to the heap
               next = next0
               n = n+1
               if (n .gt. nhx)  nhx = n
               index(n) = ip
               r(n) = rtmp
               keep1(ip) = kp1tmp
               if (npat(index(n)) .gt. nbx)  nbx = npat(index(n))
               call hup (r, index, n)
            endif
         endif

      goto 800
 2000 continue
c     end of 'while not done' loop
      if (.not. ok)  then
         call wlog('   Internal path finder limit exceeded -- ' //
     1             'path list may be incomplete.')
      endif
      close (unit=3)
      write(slog,2010) np, nhx, nbx
      call wlog(slog)
 2010 format ('    Paths found', i9, 3x,
     1        '(maxheap, maxscatt', i8, i4, ')')

c     restore the value of rmax
      rmax = rmax/2

      end
      subroutine pathsd (ckspc, fbetac, xlamc, ne, ik0, cksp, 
     1                fbeta, xlam, critpw, ipr2,  nncrit, potlbl,
     1            ipol, ispin, evec, xivec,eels)  !KJ added eels 5/06

c     New degeneracy checker, cute and hopefully fast for large
c     problems

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      common /atoms/ rat(3,0:natx), ipot(0:natx), i1b(0:natx)

c     np1x  number of paths to consider at 1 time
c     parameter (np1x = 12 000)
      parameter (np1x = 600 000)
      dimension iout(3,np1x), iout0(3)

      dimension index(np1x)
      double precision dhash(np1x), dcurr, ddum
      dimension rx(npatx), ry(npatx), rz(npatx), ipat(npatx+1)
      dimension rx0(npatx), ry0(npatx), rz0(npatx), ipat0(npatx+1)
      double precision rid(npatx+1), betad(npatx+1), etad(npatx+1)

      integer eels !KJ 5/06 - just passed on to timrep
      character*80 head(nheadx)
      character*6  potlbl(0:nphx)
      double precision xivec(3), evec(3)

c     eps5 for rtotal range, eps3 for individual leg parameters.
c     eps3 large since code single precision and don't want round-off
c     error to reduce degeneracy.
      parameter (eps5 = 2.0e-5)
      parameter (eps3 = 1.0e-3)

      logical ldiff, last
      parameter (necrit=9, nbeta=40)
      real fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      real fbeta(-nbeta:nbeta,0:nphx,nex), cksp(nex)
      real xlamc(necrit), xlam(nex)

      character*512 slog

      write(slog,30) critpw
      call wlog(slog)
   30 format ('    Plane wave chi amplitude filter', f7.2, '%')

c     Read atoms info
      open (file='paths.bin', unit=3, access='sequential',
     1      form='unformatted', status='old', iostat=ios)
      call chopen (ios, 'paths.bin', 'pathsd')
      read(3) nhead
      do 40  ihead = 1, nhead
         read(3)  head(ihead)
   40 continue
c     Header lines above include carriage control
      read(3)  nat
c     rat and ipot could be permuted by paths.f
      do 50  i = 0, nat
         read(3) (rat(j,i),j=1,3), ipot(i), i1b(i)
   50 continue

c     Initialize stuff...
c     nptot  number of total paths, incl all degeneracies
c     nuptot number of unique paths for which must calc xafs
c     ngs    number of generalized shells (unique distances)
      nptot = 0
      nuptot = 0
      ngs = 0
      xportx = eps5
      ndegx = -1
c     Initialize keep criterion
      xcalcx = -1

c     write output to paths.dat
      if (ipr2 .ne. 5)  then
         open (unit=1, file='paths.dat', status='unknown', iostat=ios)
         call chopen (ios, 'paths.dat', 'pathsd')
         do 60  ihead = 1, nhead
            ii = istrln(head(ihead))
            write(1,58)  head(ihead)(1:ii)
   58       format(a)
   60    continue
c        write(1,61)  critpw
   61    format (' Plane wave chi amplitude filter', f7.2, '%')
         write(1,62)
   62    format (1x, 71('-'))
      endif

c     Write crit.dat (criteria information)
      if (ipr2 .ge. 1)  then
         open (unit=4, file='crit.dat', status='unknown', iostat=ios)
         call chopen (ios, 'crit.dat', 'pathsd')
         do 65  ihead = 1, nhead
              ii = istrln(head(ihead))
            write(4,58)  head(ihead)(1:ii)
   65    continue
         write(4,61)  critpw
         write(4,62)
         write(4,80)
   80    format (' ipath nleg ndeg     r       pwcrit    ',
     1           'xkeep   accuracy   xheap    accuracy')
      endif

c     Read path data for each total path length range

c     Prepare for first path.
      read(3,end=999)  r0, iout0

c     Begin next total path length range
      last = .false.
  100 continue
      ngs = ngs+1
      rcurr = r0
      np = 1
      do 110  i = 1,3
         iout(i,np) = iout0(i)
  110 continue
  120 read(3,end=140)  r0, iout0
         if (abs(r0-rcurr) .lt. eps3)  then
            np = np+1
            if (np .gt. np1x) then
               write(slog,122) ' np, np1x ', np, np1x
               call wlog(slog)
  122          format (a, 2i15)
               call par_stop('np > np1x')
            endif
            do 130  i = 1, 3
               iout(i,np) = iout0(i)
  130       continue
         else
c           r0 is the rtot for the next set
c           iout0 is the packed atom list for the first path of the
c           next set
            goto 200
         endif
      goto 120
  140 continue
c     Get here only if end-of-file during read
      last = .true.

  200 continue

      nupr = 0
c     variable nuprtt was nuprtot, changed to be six chars, SIZ 12/93
      nuprtt = 0

c     Hash each path into an integer
      iscale = 1000
      do 230  ip = 1, np

         npat = npatx
         call upack (iout(1,ip), npat, ipat)

c        Get hash key for this path.
c        If two paths are the same, except time-reversed, the xafs
c        will be the same, so check for this type of degeneracy.
c        We do this by choosing a 'standard order' for a path --
c        if it's the other-way-around, we time-reverse here.
         call timrep (npat, ipat, rx, ry, rz, dhash(ip),
     1            ipol, ispin, evec, xivec,eels)  !KJ added eels 5/06

  230 continue

c     Do a heap sort on these things
      call sortid (np, index, dhash)

c     Find beginning and end of range with same hash key
c     i0 is beginning of hash range, i1 is end of the range

      i0 = 1
  300 continue
         i1 = np + 1
         dcurr = dhash(index(i0))
         do 310  ip = i0+1, np
            if (dhash(index(ip)) .ne. dcurr)  then
c              end of a hash range
               i1 = ip
               goto 311
            endif
  310    continue
  311    continue
         i1 = i1-1

c        At this point, i0 is the first path and i1 the last
c        of a hash range.  Do whatever you want with them!

c        Sum degeneracy, including degeneracy from 1st bounce atom.
c        Check this range to see if all of the paths are actually 
c        degenerate.  Make sure time-ordering is standard.
         npat0 = npatx
         call upack (iout(1,index(i0)), npat0, ipat0)
         call timrep (npat0, ipat0, rx0, ry0, rz0, ddum,
     1            ipol, ispin, evec, xivec,eels) !KJ added eels 5/06

         ndeg = 0
         do 430  ii = i0, i1
            npat = npatx
            call upack (iout(1,index(ii)), npat, ipat)
c           Note that if path gets time-reversed, we lose 1st bounce 
c           flag (since first atom is now last...), so save path deg
            ndpath = i1b(ipat(1))
            call timrep (npat, ipat, rx, ry, rz, ddum,
     1            ipol, ispin, evec, xivec,eels) !KJ added eels 5/06
c           Sum degeneracy here.
            ndeg = ndeg + ndpath
c           Check for hash collisons begins here.
            ldiff = .false.
            if (npat .ne. npat0)  then
               ldiff = .true.
               goto 430
            endif
            do 320  iat = 1, npat
               if (ipot(ipat(iat)) .ne. ipot(ipat0(iat)))  then
                  ldiff = .true.
                  goto 400
               endif
  320       continue
            do 330  ileg = 1, npat
               if (abs(rx(ileg)-rx0(ileg)) .gt. eps3  .or.
     1             abs(ry(ileg)-ry0(ileg)) .gt. eps3  .or.
     2             abs(rz(ileg)-rz0(ileg)) .gt. eps3)  then
                  ldiff = .true.
                  goto 400
               endif
  330       continue
  400       continue
            if (ldiff)  then
               call wlog(' WARNING!!  Two non-degenerate paths,' //
     1                   ' hashed to the same hash key!!')
  402          format (1x, 2e28.20)
               write(slog,402) dhash(index(i0)), dhash(index(ii))
               call wlog(slog)
  404          format (1x, 2i10, a)
               write(slog,404) npat0, npat, '  npat0, npat'
               call wlog(slog)
               call wlog(' iat, ipot0, ipot, ipat0, ipat')
               do 410  iat = 1, npat
  406             format (5i10)
                  write(slog,406) iat, ipot(ipat0(iat)), 
     1               ipot(ipat(iat)), ipat0(iat), ipat(iat)
                  call wlog(slog)
  410          continue
               call wlog(' ileg, rx0,ry0,rz0,  rx1,ry1,rz1')
               do 420  ileg = 1, npat
  412             format(i6, 1p, 3e18.10)
                  write(slog,412) ileg, rx0(ileg), rx(ileg)
                  call wlog(slog)
                  write(slog,412) ileg, ry0(ileg), ry(ileg)
                  call wlog(slog)
                  write(slog,412) ileg, rz0(ileg), rz(ileg)
                  call wlog(slog)
  420          continue
               call par_stop('hash error')
            endif
  430    continue

c        Find path pw importance factors, and recalculate 
c        pathfinder crits for output
         call outcrt (npat0, ipat0, ckspc,
     1                nncrit, fbetac, xlamc, ne, ik0, cksp, 
     1                fbeta, xlam, 
     1                ipot,
     1                xport, xheap, xheapr, xkeep, xcalcx)

         if (xportx*ndegx .le. 0)  then
            xportx = xport
c           ndegx is degeneracy of path that makes xportx, used for
c           testing new path keep crit
            ndegx = ndeg
         endif
c        frac is fraction of max importance to use for test
         frac = 100*ndeg*xport/(ndegx*xportx)

c        Write output if path is important enough (ie, path is
c        at least critpw % important as most important path found
c        so far.)
         if (frac .ge. critpw)  then
            nupr = nupr+1
            nuprtt = nuprtt+ndeg
            nptot = nptot + ndeg
            nuptot = nuptot + 1

c           Write path info to paths.dat
c           mpprmd is double precision, used to get angles
c           180.000 instead of 179.983, etc.
            call mpprmd (npat0, ipat0, rid, betad, etad)
c           skip paths.dat if not necessary
            if (ipr2 .eq. 5)  goto 576
            write(1,500) nuptot, npat0+1, real(ndeg),
     1              rcurr/2
  500       format (1x, 2i5, f8.3,
     1             '  index, nleg, degeneracy, r=', f8.4)
            write(1,502)
  502       format ('      x           y           z     ipot  ',
     1              'label      rleg      beta        eta')
            do 510  i = 1, npat0
               iat = ipat0(i)
               write(1,506)  rat(1,iat), rat(2,iat),
     1                  rat(3,iat), ipot(iat), potlbl(ipot(iat)),
     1                  rid(i), betad(i)*raddeg, etad(i)*raddeg
  506          format (3f12.6, i4, 1x, '''', a6, '''', 1x, 3f10.4)
  510       continue
            write(1,506)  rat(1,0), rat(2,0), rat(3,0), ipot(0), 
     1         potlbl(ipot(0)),
     1         rid(npat0+1), betad(npat0+1)*raddeg, etad(npat0+1)*raddeg
c           End of paths.dat writing for this path

c           Write to crit.dat here (unit 4, opened above)
  576       continue

c           cmpk is degeneracy corrected xkeep, should equal frac
            cmpk = xkeep*ndeg/ndegx
c           cmpk is accuracy of xkeep, 100 is perfect
            cmpk = 100 - 100*(abs(frac-cmpk)/frac)

c           cmph is same thing for xheap
            if (xheap .lt. 0)  then
               cmph = 100
            else
               cmph = xheap*ndeg/ndegx
               cmph = 100 - 100*(abs(frac-cmph)/frac)
            endif

            if (ipr2 .ge. 1)  then
               write(4,560)  nuptot, npat0+1, ndeg, rcurr/2, frac,
     1             xkeep, cmpk, xheap, cmph
  560          format (i6, i4, i6, 3f10.4, f8.2, f10.4, 1pe14.3)
            endif

c           write out fraction error between xkeep and critpw
         endif

c        And do next ihash range
         i0 = i1+1
      if (i0 .le. np)  goto 300

c     type600,  ngs, rcurr, nupr
c 600 format (1x, i5, f12.6, i7, ' igs, rcurr, nupr')
c     write(80,601)  ngs, rcurr/2, nupr, nuprtt
c 601 format (1x, i8, f12.6, 2i9)

      if (.not. last) goto 100

  999 if (ipr2 .ne. 5)  close (unit=1)
c     delete paths.bin when done...
      close (unit=3, status='delete')
      close (unit=4)

      write(slog,620) nuptot, nptot
      call wlog(slog)
  620 format ('    Unique paths', i7, ',  total paths', i8)

c     Do not let user accidently fill up their disk
      if (nuptot .gt. 1200)  then
      call wlog(' You have found more than 1200 paths.  Genfmt')
      call wlog(' could require a lot of time and more than 6 meg of')
      call wlog(' storage.  Suggest a larger critpw to reduce number')
      call wlog(' of paths.  To continue this calculation, restart')
      call wlog(' with current paths.dat and module genfmt (3rd module')
      call wlog(' on CONTROL card).')
      call par_stop('User must verify very large run.')
      endif
      return
c 999 stop 'no input'
      end
      subroutine phash (npat, ipat, rx, ry, rz, dhash)
c     hashes a path into double precision real dhash

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      double precision dhash
      dimension rx(npatx), ry(npatx), rz(npatx), ipat(npatx+1)

      common /atoms/ rat(3,0:natx), ipot(0:natx), i1b(0:natx)

      double precision xx

      parameter (iscale = 1000)
      parameter (factor = 16.12345678)
      parameter (facto2 = 8.57654321)

c     Hashing scheme: Assume about 15 significant digits in a double 
c     precision number.  This is 53 bit mantissa and 11 bits for sign 
c     and exponent, vax g_floating and probably most other machines.
c     With max of 9 legs, 47**9 = 1.12e15, so with a number less than 
c     47, we can use all these digits, scaling each leg's data by 
c     47**(j-1).  Actually, since our numbers can go up to about 10,000,
c     we should keep total number < 1.0e11, 17**9 = 1.18e11, which means
c     a factor a bit less than 17.  Choose 16.12345678, a non-integer,
c     to help avoid hash collisions.

c     iscale and 'int' below are to strip off trailing digits, which
c     may contain roundoff errors

      dhash = 0
      do 210  j = 1, npat
         xx = factor**(j-1)
         dhash = dhash + xx * (nint(rx(j)*iscale) +
     1               nint(ry(j)*iscale)*0.894375 +
     2               nint(rz(j)*iscale)*0.573498)
  210 continue
      do 220  j = 1, npat
         xx = facto2**(j-1)
         dhash = dhash + xx * iscale * ipot(ipat(j))
c        dhash = dhash + xx * ipot(ipat(j))
  220 continue
      dhash = dhash + npat * 40 000 000

      return
      end
      subroutine prcrit (neout, nncrit, ik0out, cksp, fbeta, ckspc, 
     1                   fbetac, potlb0, xlam, xlamc)
      implicit double precision (a-h, o-z)

c     Prepare fbeta arrays, etc., for pathfinder criteria
c
c     Note that path finder is single precision, so be sure that
c     things are correct precision in calls and declarations!
c     See declarations below for details.
c     
c     Inputs:  Reads phase.bin
c     Output:  neout   'ne', number of energy grid points
c              ik0out  index of energy grid with k=0
c              cksp    |p| at each energy grid point in single precision
c              fbeta   |f(beta)| for each angle, npot, energy point, sp
c              ckspc   |p| at each necrit point in single precision
c              fbetac  |f(beta)| for each angle, npot, nncrit point, sp
c              potlb0  unique potential labels
c              xlam    mean free path for each energy point in Ang, sp
c              xlamc   mean free path for each nncrit point in Ang, sp

c={../HEADERS/const.h
      parameter (pi = 3.14159 26535 89793 23846 26433d0)
      parameter (one = 1, zero = 0)
      parameter (third = one/3)
      parameter (raddeg = 180 / pi)
      complex*16 coni
      parameter (coni = (0,1))
c     kf = fa/rs with fa = (9*pi/4)**third, see Ash&Merm, pg 37
      parameter (fa = 1.919 158 292 677 512 811d0)

      parameter (bohr = 0.529 177 249d0, ryd  = 13.605 698d0)
      parameter (hart = 2 * ryd)
      parameter (alpinv = 137.035 989 56d0)
c     fine structure alpha
      parameter (alphfs = 1 / alpinv)
c= ../HEADERS/const.h}
c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      character*6  potlbl
      dimension  potlbl(0:nphx)

c     staff originally kept in common blocks of pdata.h
      complex*16 ph, eref, em
      double precision rnrmav, xmu, edge
      dimension ph( nex, ltot+1, 0:nphx), eref(nex), em(nex),
     1 lmax(nex,0:nphx), iz(0:nphx)

c     Output variables SINGLE PRECISION for use with path finder.
c     BE CAREFUL!!
      parameter (necrit=9, nbeta=40)
      real fbetac(-nbeta:nbeta,0:nphx,necrit), ckspc(necrit)
      real fbeta(-nbeta:nbeta,0:nphx,nex), cksp(nex)
      real xlamc(necrit)
      real xlam(nex)
      character*6  potlb0(0:nphx)

c     Local variables
      complex*16 cfbeta, tl, cktmp
      dimension dcosb(-nbeta:nbeta)
      dimension pl(ltot+1)
      dimension iecrit(necrit)
      parameter (eps = 1.0e-16)
      complex*16 rkk(nex,8,nspx), eref2(nex,nspx)
      complex*16 ph4(nex, -ltot:ltot, nspx, 0:nphx)

c     Need stuff from phase.bin
c     Read phase calculation input, data returned via commons
      call rdxsph (ne, ne1, ne3, npot, ihole,
     1    rnrmav, xmu, edge, ik0, em, eref2, iz, potlbl, ph4, rkk,
     2    lmax, lmaxp1  )
 
      do 10 ie = 1, ne
  10  eref(ie) = eref2(ie,1)
      do 20 iph = 0, npot
      do 20 ie = 1, ne
      do 20 il = 0, lmax(ie, iph)
  20  ph(ie,il+1, iph) = ph4(ie, -il, 1, iph)

      neout = ne1
      ik0out = ik0
      do 40  i = 0, nphx
         potlb0(i) = potlbl(i)
   40 continue

c     |p| at each energy point (path finder uses invA, convert here)
c     Also make mfp (xlam) in Ang
      do 100  ie = 1, ne
         cktmp = sqrt (2*(em(ie) - eref(ie)))
         cksp(ie) = dble (cktmp) / bohr
c        xlam code lifted from genfmt
         xlam(ie) = 1.0e10
         if (abs(dimag(cktmp)) .gt. eps) xlam(ie) = 1/dimag(cktmp)
         xlam(ie) = xlam(ie) * bohr
  100 continue

c     Make the cos(beta)'s
c     Grid is from -40 to 40, 81 points from -1 to 1, spaced .025
      do 200  ibeta = -nbeta, nbeta
         dcosb(ibeta) = 0.025 * ibeta
  200 continue
c     watch out for round-off error
      dcosb(-nbeta) = -1
      dcosb(nbeta)  =  1

c     make fbeta (f(beta) for all energy points
      do 280  ibeta = -nbeta, nbeta
         call cpl0 (dcosb(ibeta), pl, lmaxp1)
         do 260  iii = 0, npot
            do 250  ie = 1, ne
               cfbeta = 0
               do 245  il = 1, lmax(ie,iii)+1
                  tl = (exp (2*coni*ph(ie,il,iii)) - 1) / (2*coni)
                  cfbeta = cfbeta + tl*pl(il)*(2*il-1)
  245          continue
               fbeta(ibeta,iii,ie) = abs(cfbeta)
  250       continue
  260    continue
  280 continue

c     Make similar arrays for only the icrit points

c     Use 9 points at k=0,1,2,3,4,6,8,10,12 invA
c     See phmesh for energy gid definition.  These seem to work fine, 
c     and results aren't too sensitive to choices of k.  As few as 4
c     points work well (used 0,3,6,9), but time penalty for 9 points
c     is small and increased safety seems to be worth it.
      iecrit(1) = ik0
      iecrit(2) = ik0 + 5
      iecrit(3) = ik0 + 10
      iecrit(4) = ik0 + 15
      iecrit(5) = ik0 + 20
      iecrit(6) = ik0 + 30
      iecrit(7) = ik0 + 34
      iecrit(8) = ik0 + 38
      iecrit(9) = ik0 + 40

c     make sure that we have enough energy grid points to use all
c     9 iecrits
      nncrit = 0
      do 290  ie = 1, necrit
         if (iecrit(ie) .gt. ne)  goto 295
         nncrit = ie
  290 continue
  295 continue
      if (nncrit .eq. 0) call par_stop('bad nncrit in prcrit')
            

      do 320  icrit = 1, nncrit
         ie = iecrit(icrit)
         ckspc(icrit) = cksp(ie)
         xlamc(icrit) = xlam(ie)
         do 310  ibeta = -nbeta, nbeta
            do 300  iii = 0, npot
               fbetac(ibeta,iii,icrit) = fbeta(ibeta,iii,ie)
  300       continue
  310    continue
  320 continue

      return
      end
      subroutine sortir (n, index, r)

c     SORT by rearranges Indices, keys are Real numbers
c     Heap sort, following algorithm in Knuth using r as key
c     Knuth, The Art of Computer Programming,
c     Vol 3 / Sorting and Searching, pp 146-7
c     Array r is not modified, instead array index is returned
c     ordered so that r(index(1)) is smallest, etc.
c     rr is temporary r storage (Knuth's R), irr is index of stored r

      dimension r(n), index(n)

c     Initialize index array
      do 10  i = 1, n
         index(i) = i
   10 continue
c     only 1 element is already sorted
      if (n .eq. 1)  return

c     H1: initialize
      l = n/2 + 1
      ir = n

c     H2: Decrease l or ir
   20 continue
      if (l .gt. 1)  then
         l = l-1
         irr = index(l)
         rr = r(irr)
      else
         irr = index(ir)
         rr = r(irr)
         index(ir) = index(1)
         ir = ir-1
         if (ir .eq. 1) then
            index(1) = irr
            return
         endif
      endif

c     H3: Prepare for sift-up
      j = l

c     H4: Advance downward
   40 continue
      i = j
      j = 2 * j
      if (j .eq. ir)  goto 60
      if (j .gt. ir)  goto 80

c     H5: Find larger son of i
      if (r(index(j)) .lt. r(index(j+1)))  j = j+1

c     H6: Son larger than rr?
   60 continue
      if (rr .ge. r(index(j)))  goto 80

c     H7: Move son up
      index(i) = index(j)
      goto 40

c     H8: Store rr in it's proper place
   80 continue
      index(i) = irr
      goto 20

      end
      subroutine sortii (n, index, k)

c     SORT by rearranges Indices, keys are Integers
c     Heap sort, following algorithm in Knuth using r as key
c     Knuth, The Art of Computer Programming,
c     Vol 3 / Sorting and Searching, pp 146-7
c     Array r is not modified, instead array index is returned
c     ordered so that r(index(1)) is smallest, etc.
c     rr is temporary r storage (Knuth's R), irr is index of stored r

      dimension k(n)
      dimension index(n)

c     Initialize index array
      do 10  i = 1, n
         index(i) = i
   10 continue
c     only 1 element is already sorted
      if (n .eq. 1)  return

c     H1: initialize
      l = n/2 + 1
      ir = n

c     H2: Decrease l or ir
   20 continue
      if (l .gt. 1)  then
         l = l-1
         irr = index(l)
         kk = k(irr)
      else
         irr = index(ir)
         kk = k(irr)
         index(ir) = index(1)
         ir = ir-1
         if (ir .eq. 1) then
            index(1) = irr
            return
         endif
      endif

c     H3: Prepare for sift-up
      j = l

c     H4: Advance downward
   40 continue
      i = j
      j = 2 * j
      if (j .eq. ir)  goto 60
      if (j .gt. ir)  goto 80

c     H5: Find larger son of i
      if (k(index(j)) .lt. k(index(j+1)))  j = j+1

c     H6: Son larger than kk?
   60 continue
      if (kk .ge. k(index(j)))  goto 80

c     H7: Move son up
      index(i) = index(j)
      goto 40

c     H8: Store kk in it's proper place
   80 continue
      index(i) = irr
      goto 20

      end
      subroutine sortid (n, index, r)

c     SORT by rearranges Indices, keys are Double precision numbers
c     Heap sort, following algorithm in Knuth using r as key
c     Knuth, The Art of Computer Programming,
c     Vol 3 / Sorting and Searching, pp 146-7
c     Array r is not modified, instead array index is returned
c     ordered so that r(index(1)) is smallest, etc.
c     rr is temporary r storage (Knuth's R), irr is index of stored r

      implicit double precision (a-h, o-z)
      dimension r(n), index(n)

c     Initialize index array
      do 10  i = 1, n
         index(i) = i
   10 continue
c     only 1 element is already sorted
      if (n .eq. 1)  return

c     H1: initialize
      l = n/2 + 1
      ir = n

c     H2: Decrease l or ir
   20 continue
      if (l .gt. 1)  then
         l = l-1
         irr = index(l)
         rr = r(irr)
      else
         irr = index(ir)
         rr = r(irr)
         index(ir) = index(1)
         ir = ir-1
         if (ir .eq. 1) then
            index(1) = irr
            return
         endif
      endif

c     H3: Prepare for sift-up
      j = l

c     H4: Advance downward
   40 continue
      i = j
      j = 2 * j
      if (j .eq. ir)  goto 60
      if (j .gt. ir)  goto 80

c     H5: Find larger son of i
      if (r(index(j)) .lt. r(index(j+1)))  j = j+1

c     H6: Son larger than rr?
   60 continue
      if (rr .ge. r(index(j)))  goto 80

c     H7: Move son up
      index(i) = index(j)
      goto 40

c     H8: Store rr in it's proper place
   80 continue
      index(i) = irr
      goto 20

      end
      subroutine timrep (npat, ipat, rx, ry, rz, dhash,
     1            ipol, ispin, evec, xivec,eels)   !KJ added eels 5/06

c     subroutine timrev(...) is modified for polarization case 
c     Time-orders path and returns path in standard order,
c     standard order defined below.
c     Input:  npat, ipat
c     Output: ipat in standard order (time reversed if necessary)
c             rx, ry, rz   contain x,y,z coordinates of the path atoms,
c             where z-axis is along polarization vector or first leg, if
c               running usual feff,
c             x-axis is chosen so that first atom, which does not lie on
c               z-axis, lies in xz-plane,
c               for elliptically polarized light, x-axis is along the
c               incidence direction
c             y-axis is cross product of two previos unit vectors
c             Standarrd order is defined so that first nonzero x,y and z
c             coords are positive.(Otherwise we use the inversion of
c             the corresponding unit vector)
c             dhash double precision hash key for path in standard
c                order

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
      double precision evec(3), xivec(3)
      common /atoms/ rat(3,0:natx), ipot(0:natx), ilb(0:natx)
      dimension ipat(npatx+1), rx(npatx), ry(npatx), rz(npatx)
      dimension ipat0(npatx+1), rx0(npatx), ry0(npatx), rz0(npatx)
      integer eels,icase  !KJ added 5/06

      double precision dhash, dhash0

c     Time reverses path if time reversing it will put it
c     in standard order.  Standard order is defined by min hash
c     number, using path hash algorithm developed for the path
c     degeneracy checker.  See subroutine phash for details.
c     Symmetrical paths are, of course, always standard ordered.
c     Also returns hash number for standard ordered path.

c     Use suffix 0 for (') in variable names

!KJ next block : prepare new calling argument for mpprmp
      if(eels.eq.1) then
         icase=7
      else
         icase=-1
      endif
!KJ end new block. 5/06


c     If no time-reversal standard ordering needed, make hash number
c     and return.  No timrev needed if 2 leg path (symmetrical).
      nleg = npat + 1
      ipat(nleg) = 0
      do 10 i = 1, npatx
         rx(i)   = 0
         ry(i)   = 0
         rz(i)   = 0
         rx0(i)   = 0
         ry0(i)   = 0
         rz0(i)   = 0
   10 continue
      call mpprmp(npat, ipat, rx, ry, rz,
     1            ipol, ispin, evec, xivec,icase)   !KJ added icase 5/06
      call phash (npat, ipat, rx, ry, rz, dhash)

      if (npat .le. 1)  then
         return
      endif

c     Make time reversed path

      ipat0(nleg) = ipat(nleg)
      do 210  i = 1, npat
         ipat0(i) = ipat(nleg-i)
  210 continue
      call mpprmp(npat, ipat0, rx0, ry0, rz0,
     1            ipol, ispin, evec, xivec,icase)  !KJ added icase 5/06
      call phash (npat, ipat0, rx0, ry0, rz0, dhash0)

c     turn off path reversal in special cases (make dhash0>dhash)
      if (ispin.ne.0 .and. ipol.ne.0) dhash0 = dhash+1

c     Do the comparison using hash numbers
c     Want representation with smallest hash number
      if (dhash0 .lt. dhash)  then
c        time reversed representation is smaller, so return
c        that version of the path
         dhash = dhash0
         do 300  i = 1, npat
            ipat(i) = ipat0(i)
            rx(i)   = rx0(i)
            ry(i)   = ry0(i)
            rz(i)   = rz0(i)
  300    continue
      endif

      return
      end
c///////////////////////////////////////////////////////////////////////
c Distribution:  GENFMT 2.0
c Copyright (c) [2002] University of Washington
c 
c This software was prepared in part with US Government Funding under
c DOE contract DE-FG03-97ER45623.

c Redistribution and use of this Distribution in source and binary
c formats, with or without modification is permitted, provided the 
c following conditions are met:
c 
c Redistributions must retain the above notices and the following list
c of conditions and disclaimer;
c 
c Modified formats carry the marking
c     "Based on or developed using Distribution: GENFMT 2.0
c      GENFMT 2.0 Copyright (c) [2002] University of Washington"
c 
c Recipient acknowledges the right of the University of Washington to
c prepare uses of this Distribution and its modifications that may be
c substantially similar or functionally equivalent to
c Recipient-prepared modifications.
c
c Recipient and anyone obtaining access to the Distribution through
c recipient's actions accept all risk associated with possession and
c use of the Distribution.
c
c THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
c WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
c MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
c IN NO EVENT SHALL THE UNIVERSITY OF WASHINGTON OR CONTRIBUTORS TO THE
c DISTRIBUTION BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
c EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
c PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
c REVENUE; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
c LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
c NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
c SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
c///////////////////////////////////////////////////////////////////////
c License is applicable for routines below, until otherwise specified.
c
c     sub-program exchange
!     program ffmod5
      subroutine ffmod5

c     scattering F-matrix multiplication for each MS path
c     written by a.ankudinov 2000, using subroutines
c     which were written earlier by j.rehr and others
c     modified by a.ankudinov 2001 for new I/O structure

c     INPUT: phase.bin, paths.dat, mod5.inp and global.dat
c     OUTPUT: feff.bin and list.dat files
      implicit double precision (a-h, o-z)

c={../HEADERS/dim.h
c      maximum number of atoms for FMS. Reduce nclusx if you need
c      smaller executable.
      parameter (nclusx=100)
c      maximum number of atoms for tdlda module.
      parameter (nclxtd=100)
c      max number of spins: 1 for spin average; 2 for spin-dep
      parameter (nspx=1)
c      max number of atoms in problem for the pathfinder
      parameter (natx =1000)
c      max number of atoms in problem for the rdinp and ffsort
      parameter (nattx =1000)
c      max orbital momentum for FMS module.
      parameter (lx=4)
c      max number of unique potentials (potph) (nphx must be ODD to
c      avoid compilation warnings about alignment in COMMON blocks)
      parameter (nphx = 11)
c      max number of ang mom (arrays 1:ltot+1)
      parameter (ltot = 24)
c      Loucks r grid used through overlap and in phase work arrays
      parameter (nrptx = 1251)
c      Number of energy points genfmt, etc.
      parameter (nex = 150)
c      Max number of distinct lambda's for genfmt
c      15 handles iord 2 and exact ss
      parameter (lamtot=15)
c      vary mmax and nmax independently
      parameter (mtot=4, ntot=2)
c      max number of path atoms, used in path finder, NOT in genfmt
      parameter (npatx = 8)
c      matches path finder, used in GENFMT
      parameter (legtot=npatx+1)
c      max number of overlap shells (OVERLAP card)
      parameter (novrx=8)
c      max number of header lines
      parameter (nheadx=30)
c      max number of poles that can be used to
c      model epsilon^-1 for HL multipole self energy
      parameter (MxPole=1000)
c= ../HEADERS/dim.h}
c={../HEADERS/parallel.h
      integer par_type, this_process, numprocs, my_rank
      logical master, worker, parallel_run
      real*8 wall_comm, time_comm
      common /timing/ wall_comm, time_comm
      common /parallel/ numprocs, my_rank, this_process, 
     .          master, worker, parallel_run, par_type
c= ../HEADERS/parallel.h}
      double precision evec(3), xivec(3)
      complex*16 ptz(-1:1, -1:1)
      integer  mfeff, ipr5, iorder
      logical  wnstar
      double precision critcw, angks, elpty
      integer elnes,ipstep,ipmin,ipmax  !KJ added these variables 1-06


      call par_begin
      if (worker) go to 400

c     open the log file, unit 11.  See subroutine wlog.
      open (unit=11, file='log5.dat', status='unknown', iostat=ios)
      call chopen (ios, 'log5.dat', 'feff')

c                 read  mod5.inp 
      call regenf(mfeff, ipr5, critcw, iorder, wnstar,
c                 and global.dat
     1            ipol, ispin, le2, angks, elpty, evec, xivec, ptz,
     2            elnes,ipmin,ip