/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class RestrictionEnzyme
extends JPanel
implements TableModelListener,
ListSelectionListener {
    private DNADraw dna;
    private JButton deleteRE;
    private final JTable reTable = new JTable();

    public RestrictionEnzyme(DNADraw dna, final Vector restrictionEnzyme) {
        this.dna = dna;
        Box bdown = Box.createVerticalBox();
        Dimension d = new Dimension(100, 25);
        bdown.add(Box.createVerticalStrut(4));
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Label");
        columnNames.add("Position");
        columnNames.add("Colour");
        final RETableModel reModel = new RETableModel(restrictionEnzyme, columnNames);
        this.reTable.setModel(reModel);
        this.reTable.getModel().addTableModelListener(this);
        this.reTable.getSelectionModel().addListSelectionListener(this);
        this.setUpColorRenderer(this.reTable);
        this.setUpColorEditor(this.reTable);
        JScrollPane scrollRE = new JScrollPane(this.reTable);
        scrollRE.setPreferredSize(new Dimension(300, 150));
        scrollRE.getViewport().setBackground(Color.white);
        bdown.add(scrollRE);
        bdown.add(Box.createVerticalStrut(4));
        bdown.add(new JSeparator());
        bdown.add(Box.createVerticalStrut(4));
        Box bacross = Box.createHorizontalBox();
        final JTextField reLabel = new JTextField("");
        reLabel.setMaximumSize(d);
        reLabel.setPreferredSize(d);
        bacross.add(new JLabel("Label:"));
        bacross.add(reLabel);
        bacross.add(Box.createHorizontalStrut(4));
        final TextFieldInt pos = new TextFieldInt();
        pos.setMaximumSize(d);
        pos.setPreferredSize(d);
        bacross.add(new JLabel("Position:"));
        bacross.add(pos);
        bacross.add(Box.createHorizontalStrut(4));
        final JButton reColour = this.setUpColorButton(Color.blue);
        bacross.add(new JLabel("Colour:"));
        bacross.add(reColour);
        bacross.add(Box.createHorizontalStrut(4));
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        JButton addRE = new JButton("Add RE");
        addRE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector<Object> re = new Vector<Object>();
                re.add(reLabel.getText());
                re.add(new Integer(pos.getValue()));
                re.add(reColour.getBackground());
                restrictionEnzyme.add(re);
                reModel.addRow();
            }
        });
        bacross.add(addRE);
        bacross.add(Box.createHorizontalGlue());
        this.deleteRE = new JButton("Delete RE");
        this.deleteRE.setToolTipText("Deletes the restriction enzyme selected");
        this.deleteRE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RestrictionEnzyme.this.reTable.isEditing()) {
                    RestrictionEnzyme.this.reTable.getCellEditor().stopCellEditing();
                }
                int i = RestrictionEnzyme.this.reTable.getSelectedRow();
                reModel.deleteRow(i);
            }
        });
        this.deleteRE.setEnabled(false);
        Dimension minSize = new Dimension(5, 40);
        Dimension prefSize = new Dimension(5, 40);
        Dimension maxSize = new Dimension(Short.MAX_VALUE, 50);
        bacross.add(new Box.Filler(minSize, prefSize, maxSize));
        bacross.add(this.deleteRE);
        bdown.add(bacross);
        this.add(bdown);
    }

    public void tableChanged(TableModelEvent e) {
        if (this.dna != null) {
            this.dna.repaint();
        }
    }

    protected JMenuBar createMenuBar(final JFrame f) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem closeMenu = new JMenuItem("Close");
        closeMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        fileMenu.add(closeMenu);
        return menuBar;
    }

    private void setUpColorRenderer(JTable table) {
        table.setDefaultRenderer(Color.class, new ColorRenderer(true));
    }

    private void setUpColorEditor(JTable table) {
        final JButton button = new JButton(""){

            public void setText(String s) {
            }
        };
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final ColorEditor colorEditor = new ColorEditor(button);
        table.setDefaultEditor(Color.class, colorEditor);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                colorEditor.currentColor = colorChooser.getColor();
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Color", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorEditor.currentColor);
                colorChooser.setColor(colorEditor.currentColor);
                dialog.show();
            }
        });
    }

    private JButton setUpColorButton(Color col) {
        final JButton button = new JButton(""){

            public void setText(String s) {
            }
        };
        button.setBackground(col);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        Dimension d = new Dimension(25, 25);
        button.setPreferredSize(d);
        button.setMinimumSize(d);
        button.setMaximumSize(d);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorChooser.getColor());
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Color", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.show();
            }
        });
        return button;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int i = this.reTable.getSelectedRow();
            this.deleteRE.setEnabled(i != -1);
        }
    }

    class RETableModel
    extends AbstractTableModel {
        private Vector rowData;
        private Vector columnNames;

        public RETableModel(Vector rowData, Vector columnNames) {
            this.columnNames = columnNames;
            this.rowData = rowData;
        }

        public int getColumnCount() {
            return this.columnNames.size();
        }

        public int getRowCount() {
            return this.rowData.size();
        }

        public String getColumnName(int col) {
            return (String)this.columnNames.elementAt(col);
        }

        public Object getValueAt(int row, int col) {
            return ((Vector)this.rowData.elementAt(row)).elementAt(col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            Vector vrow = (Vector)this.rowData.elementAt(row);
            vrow.setElementAt(value, col);
            this.rowData.setElementAt(vrow, row);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow() {
            this.fireTableRowsInserted(this.rowData.size(), this.rowData.size());
        }

        public boolean deleteRow(int row) {
            if (row < 0 || row >= this.rowData.size()) {
                return false;
            }
            this.rowData.remove(row);
            this.fireTableRowsDeleted(row, row);
            return true;
        }
    }

    class ColorEditor
    extends DefaultCellEditor {
        Color currentColor;

        public ColorEditor(JButton b) {
            super(new JCheckBox());
            this.currentColor = null;
            this.editorComponent = b;
            this.setClickCountToStart(1);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorEditor.this.fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JButton)this.editorComponent).setText(value.toString());
            this.currentColor = (Color)value;
            return this.editorComponent;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

