/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_X1P42100_GPIO_H_
#define _SOC_QUALCOMM_X1P42100_GPIO_H_

#include <types.h>
#include <soc/addressmap.h>
#include <soc/gpio_common.h>

#define PIN(index, func1, func2, func3, func4, func5, func6) \
GPIO##index##_ADDR = TLMM_TILE_BASE + (index * TLMM_GPIO_OFF_DELTA), \
GPIO##index##_FUNC_##func1 = 1, \
GPIO##index##_FUNC_##func2 = 2, \
GPIO##index##_FUNC_##func3 = 3, \
GPIO##index##_FUNC_##func4 = 4, \
GPIO##index##_FUNC_##func5 = 5, \
GPIO##index##_FUNC_##func6 = 6

enum {
	PIN(0, QUP0_SE0_L0, IBI_I3C_QUP0_SE0_SDA, RES_3, RES_4, RES_5, RES_6),
	PIN(1, QUP0_SE0_L1, IBI_I3C_QUP0_SE0_SCL, RES_3, RES_4, RES_5, RES_6),
	PIN(2, QUP0_SE0_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(3, QUP0_SE0_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(4, QUP0_SE1_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(5, QUP0_SE1_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(6, QUP0_SE1_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(7, QUP0_SE1_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(8, QUP0_SE2_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(9, QUP0_SE2_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(10, QUP0_SE2_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(11, QUP0_SE2_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(12, QUP0_SE3_L0, QUP0_SE7_L2, RES_3, RES_4, RES_5, RES_6),
	PIN(13, QUP0_SE3_L1, QUP0_SE7_L3, RES_3, RES_4, RES_5, RES_6),
	PIN(14, QUP0_SE3_L2, QUP0_SE7_L0, RES_3, RES_4, RES_5, RES_6),
	PIN(15, QUP0_SE3_L3, QUP0_SE7_L1, RES_3, RES_4, RES_5, RES_6),
	PIN(16, QUP0_SE4_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(17, QUP0_SE4_L1, QUP0_SE2_L4, RES_3, RES_4, RES_5, RES_6),
	PIN(18, QUP0_SE4_L2, QUP0_SE2_L5, RES_3, RES_4, QDSS_CTI_TRIG0_OUT_MIRB, RES_6),
	PIN(19, QUP0_SE4_L3, QUP0_SE2_L6, RES_3, RES_4, QDSS_CTI_TRIG1_OUT_MIRB, RES_6),
	PIN(20, QUP0_SE5_L0, GP_PDM_MIRB_2, RES_3, RES_4, RES_5, RES_6),
	PIN(21, QUP0_SE5_L1, QUP0_SE3_L6, GP_PDM_MIRB_1, RES_4, RES_5, RES_6),
	PIN(22, QUP0_SE5_L2, QUP0_SE3_L5, GP_PDM_MIRB_0, RES_4, RES_5, RES_6),
	PIN(23, QUP0_SE5_L3, QUP0_SE3_L4, RES_3, RES_4, QDSS_CTI_TRIG0_IN_MIRA, RES_6),
	PIN(24, QUP0_SE6_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(25, QUP0_SE6_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(26, QUP0_SE6_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(27, QUP0_SE6_L3, RES_2, RES_3, QDSS_CTI_TRIG1_IN_MIRA, RES_5, RES_6),
	PIN(28, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(29, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(30, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(31, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(32, QUP1_SE0_L0, IBI_I3C_QUP1_SE0_SDA, RES_3, RES_4, RES_5, RES_6),
	PIN(33, QUP1_SE0_L1, IBI_I3C_QUP1_SE0_SCL, QUP1_SE3_L6, RES_4, RES_5, RES_6),
	PIN(34, QUP1_SE0_L2, QUP1_SE3_L5, TSENSE_PWM1_OUT_MIRNAT, TSENSE_PWM2_OUT_MIRNAT,
		 TSENSE_PWM3_OUT_MIRNAT, TSENSE_PWM4_OUT_MIRNAT),
	PIN(35, QUP1_SE0_L3, QUP1_SE3_L4, PLL_CLK_AUX, RES_4, RES_5, RES_6),
	PIN(36, QUP1_SE1_L0, IBI_I3C_QUP1_SE1_SDA, RES_3, RES_4, RES_5, RES_6),
	PIN(37, QUP1_SE1_L1, IBI_I3C_QUP1_SE1_SCL, RES_3, RES_4, RES_5, RES_6),
	PIN(38, QUP1_SE1_L2, VSENSE_TRIGGER_MIRNAT, RES_3, RES_4, RES_5, RES_6),
	PIN(39, QUP1_SE1_L3, SYS_THROTTLE_MIRA, RES_3, RES_4, RES_5, RES_6),
	PIN(40, QUP1_SE2_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(41, QUP1_SE2_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(42, QUP1_SE2_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(43, QUP1_SE2_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(44, QUP1_SE3_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(45, QUP1_SE3_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(46, QUP1_SE3_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(47, QUP1_SE3_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(48, QUP1_SE4_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(49, QUP1_SE4_L1, QUP1_SE2_L4, RES_3, RES_4, RES_5, RES_6),
	PIN(50, QUP1_SE4_L2, QUP1_SE2_L5, RES_3, RES_4, RES_5, RES_6),
	PIN(51, QUP1_SE4_L3, QUP1_SE2_L6, RES_3, RES_4, RES_5, RES_6),
	PIN(52, QUP1_SE5_L0, QUP1_SE7_L2, RES_3, RES_4, RES_5, RES_6),
	PIN(53, QUP1_SE5_L1, QUP1_SE7_L3, GP_MN, RES_4, RES_5, RES_6),
	PIN(54, QUP1_SE5_L2, QUP1_SE7_L0, RES_3, RES_4, RES_5, RES_6),
	PIN(55, QUP1_SE5_L3, QUP1_SE7_L1, RES_3, RES_4, RES_5, RES_6),
	PIN(56, QUP1_SE6_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(57, QUP1_SE6_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(58, QUP1_SE6_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(59, QUP1_SE6_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(60, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(61, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(62, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(63, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(64, QUP2_SE0_L0, GCC_GP2_CLK_MIRB, RES_3, RES_4, RES_5, RES_6),
	PIN(65, QUP2_SE0_L1, QUP2_SE3_L6, TGU_CH1_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(66, QUP2_SE0_L2, QUP2_SE3_L5, TGU_CH2_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(67, QUP2_SE0_L3, QUP2_SE3_L4, TGU_CH3_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(68, QUP2_SE1_L0, IBI_I3C_QUP2_SE1_SDA, TGU_CH4_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(69, QUP2_SE1_L1, IBI_I3C_QUP2_SE1_SCL, TGU_CH5_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(70, QUP2_SE1_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(71, QUP2_SE1_L3, GCC_GP1_CLK_MIRB, RES_3, RES_4, RES_5, RES_6),
	PIN(72, QUP2_SE2_L0, GCC_GP1_CLK_MIRA, RES_3, RES_4, RES_5, RES_6),
	PIN(73, QUP2_SE2_L1, GCC_GP2_CLK_MIRA, RES_3, RES_4, RES_5, RES_6),
	PIN(74, QUP2_SE2_L2, GCC_GP3_CLK_MIRA, RES_3, RES_4, RES_5, RES_6),
	PIN(75, QUP2_SE2_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(76, QUP2_SE3_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(77, QUP2_SE3_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(78, QUP2_SE3_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(79, QUP2_SE3_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(80, QUP2_SE4_L0, TGU_CH7_TRIGOUT, RES_3, RES_4, RES_5, RES_6),
	PIN(81, QUP2_SE4_L1, QUP2_SE2_L4, TGU_CH0_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(82, QUP2_SE4_L2, QUP2_SE2_L5, GCC_GP3_CLK_MIRB, RES_4, RES_5, RES_6),
	PIN(83, QUP2_SE4_L3, QUP2_SE2_L6, TGU_CH6_TRIGOUT, RES_4, RES_5, RES_6),
	PIN(84, QUP2_SE5_L0, QUP2_SE7_L2, RES_3, RES_4, RES_5, RES_6),
	PIN(85, QUP2_SE5_L1, QUP2_SE7_L3, RES_3, RES_4, RES_5, RES_6),
	PIN(86, QUP2_SE5_L2, QUP2_SE7_L0, RES_3, RES_4, RES_5, RES_6),
	PIN(87, QUP2_SE5_L3, QUP2_SE7_L1, RES_3, RES_4, RES_5, RES_6),
	PIN(88, QUP2_SE6_L0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(89, QUP2_SE6_L1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(90, QUP2_SE6_L2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(91, QUP2_SE6_L3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(92, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(93, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(94, SYS_THROTTLE_MIRB, RES_2, MDP_VSYNC_P, RES_4, RES_5, RES_6),
	PIN(95, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(96, CAM_MCLK0, QDSS_GPIO_TRACEDATA_LOCA_0, RES_3, RES_4, RES_5, RES_6),
	PIN(97, CAM_MCLK1, QDSS_GPIO_TRACEDATA_LOCA_1, RES_3, RES_4, RES_5, RES_6),
	PIN(98, CAM_MCLK2, QDSS_GPIO_TRACEDATA_LOCA_2, RES_3, RES_4, RES_5, RES_6),
	PIN(99, RES_1, QDSS_GPIO_TRACEDATA_LOCA_3, RES_3, RES_4, RES_5, RES_6),
	PIN(100, CAM_AON_MCLK4, QDSS_GPIO_TRACEDATA_LOCA_4, RES_3, RES_4, RES_5, RES_6),
	PIN(101, CCI_I2C_SDA0, QDSS_GPIO_TRACEDATA_LOCA_5, RES_3, RES_4, RES_5, RES_6),
	PIN(102, CCI_I2C_SCL0, QDSS_GPIO_TRACEDATA_LOCA_6, RES_3, RES_4, RES_5, RES_6),
	PIN(103, CCI_I2C_SDA1, QDSS_GPIO_TRACEDATA_LOCA_7, RES_3, RES_4, RES_5, RES_6),
	PIN(104, CCI_I2C_SCL1, QDSS_GPIO_TRACECTL_LOCA, RES_3, RES_4, RES_5, RES_6),
	PIN(105, CCI_I2C_SDA2, QDSS_GPIO_TRACECLK_LOCA, RES_3, RES_4, RES_5, RES_6),
	PIN(106, CCI_I2C_SCL2, QDSS_GPIO_TRACEDATA_LOCA_8, RES_3, RES_4, RES_5, RES_6),
	PIN(107, QDSS_GPIO_TRACEDATA_LOCA_9, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(108, QDSS_GPIO_TRACEDATA_LOCA_10, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(109, CCI_TIMER0, MDP_VSYNC4_OUT, QDSS_GPIO_TRACEDATA_LOCA_11, RES_4, RES_5, RES_6),
	PIN(110, CCI_TIMER1, MDP_VSYNC5_OUT, QDSS_GPIO_TRACEDATA_LOCA_12, RES_4, RES_5, RES_6),
	PIN(111, CCI_TIMER2, CCI_ASYNC_IN2, MDP_VSYNC6_OUT, QDSS_GPIO_TRACEDATA_LOCA_13, RES_5, RES_6),
	PIN(112, CCI_TIMER3, CCI_ASYNC_IN1, MDP_VSYNC7_OUT, QDSS_GPIO_TRACEDATA_LOCA_14, RES_5, RES_6),
	PIN(113, CCI_TIMER4, CCI_ASYNC_IN0, MDP_VSYNC8_OUT, QDSS_GPIO_TRACEDATA_LOCA_15, RES_5, RES_6),
	PIN(114, RES_2, MDP_VSYNC0_OUT, MDP_VSYNC1_OUT, RES_4, RES_5, RES_6),
	PIN(115, RES_2, MDP_VSYNC3_OUT, MDP_VSYNC2_OUT, RES_4, RES_5, RES_6),
	PIN(116, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(117, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(118, HOST2WLAN_SOL, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(119, EDP0_HOT_PLUG_DETECT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(120, EDP1_HOT_PLUG_DETECT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(121, USB0_PHY_PS, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(122, USB0_DP_HOT_PLUG_DETECT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(123, USB1_PHY_PS, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(124, USB1_DP_HOT_PLUG_DETECT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(125, USB2_PHY_PS, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(126, USB2_DP_HOT_PLUG_DETECT, GP_PDM_MIRA_0, RES_3, RES_4, RES_5, RES_6),
	PIN(127, QSPI0_CLK, RES_2, GP_PDM_MIRA_1, RES_4, RES_5, RES_6),
	PIN(128, QSPI0_DATA_0, RES_2, GP_PDM_MIRA_2, RES_4, RES_5, RES_6),
	PIN(129, QSPI0_DATA_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(130, QSPI0_DATA_2, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(131, QSPI0_DATA_3, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(132, QSPI0_CS0_N, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(133, QSPI0_CS1_N, RES_2, TB_TRIG_SDC1, RES_4, RES_5, RES_6),
	PIN(134, AUDIO_EXT_MCLK0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(135, I2S0_SCK, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(136, I2S0_DATA0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(137, I2S0_DATA1, TB_TRIG_SDC2, RES_3, RES_4, RES_5, RES_6),
	PIN(138, I2S0_WS, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(139, I2S1_SCK, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(140, I2S1_DATA0, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(141, I2S1_WS, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(142, I2S1_DATA1, AUDIO_EXT_MCLK1, AUDIO_REF_CLK, RES_4, RES_5, RES_6),
	PIN(143, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(144, PCIE3_CLK_REQ_N, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(145, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(146, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(147, PCIE4_CLK_REQ_N, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(148, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(149, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(150, PCIE5_CLK_REQ_N, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(151, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(152, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(153, PCIE6_CLK_REQ_N, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(154, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(155, MDP_VSYNC_S, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(156, RES_2, MDP_VSYNC_E, RES_3, RES_4, RES_5, RES_6),
	PIN(157, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(158, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(159, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(160, RESOUT_GPIO_N, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(161, QDSS_CTI_TRIG0_OUT_MIRA, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(162, SD_WRITE_PROTECT, QDSS_CTI_TRIG1_OUT_MIRA, RES_3, RES_4, RES_5, RES_6),
	PIN(163, USB0_SBRX, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(164, USB0_SBTX, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(165, USB0_SBTX_DIR_OUT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(166, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(167, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(168, EUSB0_AC_EN, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(169, EUSB3_AC_EN, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(170, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(171, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(172, USB1_SBRX, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(173, USB1_SBTX, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(174, USB1_SBTX_DIR_OUT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(175, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(176, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(177, EUSB1_AC_EN, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(178, EUSB6_AC_EN, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(179, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(180, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(181, USB2_SBRX, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(182, USB2_SBTX, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(183, USB2_SBTX_DIR_OUT, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(184, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(185, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(186, EUSB2_AC_EN, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(187, EUSB5_AC_EN, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(188, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(189, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(190, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(191, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(192, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(193, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(194, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(195, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(196, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(197, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(198, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(199, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(200, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(201, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(202, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(203, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(204, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(205, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(206, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(207, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(208, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(209, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(210, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(211, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(212, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(213, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(214, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(215, RES_2, QDSS_CTI_TRIG1_IN_MIRB, RES_3, RES_4, RES_5, RES_6),
	PIN(216, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(217, RES_2, QDSS_CTI_TRIG0_IN_MIRB, RES_3, RES_4, RES_5, RES_6),
	PIN(218, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(219, RES_1, QDSS_GPIO_TRACEDATA_LOCB_0, RES_3, RES_4, RES_5, RES_6),
	PIN(220, RES_1, QDSS_GPIO_TRACEDATA_LOCB_1, RES_3, RES_4, RES_5, RES_6),
	PIN(221, RES_1, QDSS_GPIO_TRACEDATA_LOCB_2, RES_3, RES_4, RES_5, RES_6),
	PIN(222, RES_1, QDSS_GPIO_TRACEDATA_LOCB_3, RES_3, RES_4, RES_5, RES_6),
	PIN(223, RES_1, QDSS_GPIO_TRACEDATA_LOCB_4, RES_3, RES_4, RES_5, RES_6),
	PIN(224, RES_1, QDSS_GPIO_TRACEDATA_LOCB_5, RES_3, RES_4, RES_5, RES_6),
	PIN(225, RES_1, QDSS_GPIO_TRACEDATA_LOCB_6, RES_3, RES_4, RES_5, RES_6),
	PIN(226, RES_1, QDSS_GPIO_TRACEDATA_LOCB_7, RES_3, RES_4, RES_5, RES_6),
	PIN(227, RES_1, QDSS_GPIO_TRACECLK_LOCB, RES_3, RES_4, RES_5, RES_6),
	PIN(228, RES_1, QDSS_GPIO_TRACECTL_LOCB, RES_3, RES_4, RES_5, RES_6),
	PIN(229, QDSS_GPIO_TRACEDATA_LOCB_8, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(230, QDSS_GPIO_TRACEDATA_LOCB_9, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(231, QDSS_GPIO_TRACEDATA_LOCB_10, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(232, QDSS_GPIO_TRACEDATA_LOCB_11, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(233, QDSS_GPIO_TRACEDATA_LOCB_12, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(234, QDSS_GPIO_TRACEDATA_LOCB_13, RES_2, RES_3, RES_4, RES_5, RES_6),
	PIN(235, AON_CCI_I2C_SDA3, QDSS_GPIO_TRACEDATA_LOCB_14, RES_3, RES_4, RES_5, RES_6),
	PIN(236, AON_CCI_I2C_SCL3, QDSS_GPIO_TRACEDATA_LOCB_15, RES_3, RES_4, RES_5, RES_6),
	PIN(237, RES_1, RES_2, RES_3, RES_4, RES_5, RES_6),
};

#endif /* _SOC_QUALCOMM_X1P42100_GPIO_H_ */
