/*
    belcard-folder.cpp
    Copyright (C) 2015  Belledonne Communications SARL

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "belcard/belcard_utils.hpp"

#include <fstream>
#include <iostream>
#include <sstream>

using namespace std;

int main(int argc, char *argv[]) {
	const char *file = NULL;

	if (argc < 2) {
		cerr << argv[0] << " <file to fold> - fold the content of a file" << endl;
		return -1;
	}
	file = argv[1];

	ifstream istr(file);
	if (!istr.is_open()) {
		return -1;
	}

	stringstream vcardStream;
	vcardStream << istr.rdbuf();
	string vcard = vcardStream.str();

	vcard = belcard_fold(vcard);
	cout << vcard << endl;

	return 0;
}
