/*
 * Copyright (c) 2024, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * This file contains the CSS specific definitions for the third generation of
 * platforms.
 */

#ifndef NRD_CSS_DEF3_H
#define NRD_CSS_DEF3_H

/*******************************************************************************
 * CSS memory map related defines
 ******************************************************************************/

/* Shared RAM */
#define NRD_CSS_SHARED_SRAM_BASE		UL(0x00000000)

/* General Peripherals */
#define NRD_CSS_PERIPH_BASE			UL(0x20000000)
#define NRD_CSS_PERIPH_SIZE			UL(0x20000000)

/* System NCI */
#define NRD_CSS_SYSTEM_NCI_BASE			UL(0x20000000)
#define NRD_CSS_SYSTEM_NCI_SIZE			UL(0x04000000)

/* Debug NIC */
#define NRD_CSS_DEBUG_NIC_BASE			UL(0x28000000)
#define NRD_CSS_DEBUG_NIC_SIZE			UL(0x01000000)

/* NS UART */
#define NRD_CSS_NS_UART_BASE			UL(0x2A400000)
#define NRD_CSS_NS_UART_SIZE			UL(0x00010000)

/* Secure UART */
#define NRD_CSS_SECURE_UART_BASE		UL(0x2A410000)
#define NRD_CSS_SECURE_UART_SIZE		UL(0x00010000)

/* Realm UART */
#define NRD_CSS_REALM_UART_BASE			UL(0x2A420000)
#define NRD_CSS_REALM_UART_SIZE			UL(0x00010000)

/* Generic Refclk */
#define NRD_CSS_GENERIC_REFCLK_BASE		UL(0x2A430000)
#define NRD_CSS_GENERIC_REFCLK_SIZE		UL(0x00010000)

/* NS Watchdog */
#define NRD_CSS_AP_NS_WDOG_BASE			UL(0x2A440000)
#define NRD_CSS_AP_NS_WDOG_SIZE			UL(0x00020000)

/* Root Watchdog */
#define NRD_CSS_AP_ROOT_WDOG_BASE		UL(0x2A460000)
#define NRD_CSS_AP_ROOT_WDOG_SIZE		UL(0x00020000)

/* Secure Watchdog */
#define NRD_CSS_AP_SECURE_WDOG_BASE		UL(0x2A480000)
#define NRD_CSS_AP_SECURE_WDOG_SIZE		UL(0x00020000)

/* SID */
#define NRD_CSS_SID_BASE			UL(0x2A4A0000)
#define NRD_CSS_SID_SIZE			UL(0x00010000)

/* SRAM Secure Error Record Block - AP */
#define NRD_CSS_SECURE_SRAM_ERB_AP_BASE		UL(0x2A4B0000)
#define NRD_CSS_SECURE_SRAM_ERB_AP_SIZE		UL(0x00010000)

/* SRAM NS Error Record Block - AP */
#define NRD_CSS_NS_SRAM_ERB_AP_BASE		UL(0x2A4C0000)
#define NRD_CSS_NS_SRAM_ERB_AP_SIZE		UL(0x00010000)

/* SRAM Root Error Record Block - AP */
#define NRD_CSS_ROOT_SRAM_ERB_AP_BASE		UL(0x2A4D0000)
#define NRD_CSS_ROOT_SRAM_ERB_AP_SIZE		UL(0x00010000)

/* SRAM Realm Error Record Block - AP */
#define NRD_CSS_REALM_SRAM_ERB_AP_BASE		UL(0x2A4E0000)
#define NRD_CSS_REALM_SRAM_ERB_AP_SIZE		UL(0x00010000)

/* SRAM Secure Error Record Block - SCP */
#define NRD_CSS_SECURE_SRAM_ERB_SCP_BASE	UL(0x2A4F0000)
#define NRD_CSS_SECURE_SRAM_ERB_SCP_SIZE	UL(0x00010000)

/* SRAM NS Error Record Block - SCP */
#define NRD_CSS_NS_SRAM_ERB_SCP_BASE		UL(0x2A500000)
#define NRD_CSS_NS_SRAM_ERB_SCP_SIZE		UL(0x00010000)

/* SRAM Root Error Record Block - SCP */
#define NRD_CSS_ROOT_SRAM_ERB_SCP_BASE		UL(0x2A510000)
#define NRD_CSS_ROOT_SRAM_ERB_SCP_SIZE		UL(0x00010000)

/* SRAM Realm Error Record Block - SCP */
#define NRD_CSS_REALM_SRAM_ERB_SCP_BASE		UL(0x2A520000)
#define NRD_CSS_REALM_SRAM_ERB_SCP_SIZE		UL(0x00010000)

/* SRAM Secure Error Record Block - MCP */
#define NRD_CSS_SECURE_SRAM_ERB_MCP_BASE	UL(0x2A530000)
#define NRD_CSS_SECURE_SRAM_ERB_MCP_SIZE	UL(0x00010000)

/* SRAM NS Error Record Block - MCP */
#define NRD_CSS_NS_SRAM_ERB_MCP_BASE		UL(0x2A540000)
#define NRD_CSS_NS_SRAM_ERB_MCP_SIZE		UL(0x00010000)

/* SRAM Root Error Record Block - MCP */
#define NRD_CSS_ROOT_SRAM_ERB_MCP_BASE		UL(0x2A550000)
#define NRD_CSS_ROOT_SRAM_ERB_MCP_SIZE		UL(0x00010000)

/* SRAM Realm Error Record Block - MCP */
#define NRD_CSS_REALM_SRAM_ERB_MCP_BASE		UL(0x2A560000)
#define NRD_CSS_REALM_SRAM_ERB_MCP_SIZE		UL(0x00010000)

/* SRAM Secure Error Record Block - RSE */
#define NRD_CSS_SECURE_SRAM_ERB_RSE_BASE	UL(0x2A570000)
#define NRD_CSS_SECURE_SRAM_ERB_RSE_SIZE	UL(0x00010000)

/* SRAM NS Error Record Block - RSE */
#define NRD_CSS_NS_SRAM_ERB_RSE_BASE		UL(0x2A580000)
#define NRD_CSS_NS_SRAM_ERB_RSE_SIZE		UL(0x00010000)

/* SRAM Root Error Record Block - RSE */
#define NRD_CSS_ROOT_SRAM_ERB_RSE_BASE		UL(0x2A590000)
#define NRD_CSS_ROOT_SRAM_ERB_RSE_SIZE		UL(0x00010000)

/* SRAM Realm Error Record Block - RSE */
#define NRD_CSS_REALM_SRAM_ERB_RSE_BASE		UL(0x2A5A0000)
#define NRD_CSS_REALM_SRAM_ERB_RSE_SIZE		UL(0x00010000)

/* RSE SRAM Secure Error Record Block - RSM */
#define NRD_CSS_RSE_SECURE_SRAM_ERB_RSM_BASE	UL(0x2A5B0000)
#define NRD_CSS_RSE_SECURE_SRAM_ERB_RSM_SIZE	UL(0x00010000)

/* RSE SRAM Secure Error Record Block - RSM */
#define NRD_CSS_RSE_NS_SRAM_ERB_RSM_BASE	UL(0x2A5C0000)
#define NRD_CSS_RSE_NS_SRAM_ERB_RSM_SIZE	UL(0x00010000)

/* SCP SRAM Secure Error Record Block - RSM */
#define NRD_CSS_SCP_SECURE_SRAM_ERB_RSM_BASE	UL(0x2A5D0000)
#define NRD_CSS_SCP_SECURE_SRAM_ERB_RSM_SIZE	UL(0x00010000)

/* SCP SRAM NS Error Record Block - RSM */
#define NRD_CSS_SCP_NS_SRAM_ERB_RSM_BASE	UL(0x2A5E0000)
#define NRD_CSS_SCP_NS_SRAM_ERB_RSM_SIZE	UL(0x00010000)

/* MCP SRAM Secure Error Record Block - RSM */
#define NRD_CSS_MCP_SECURE_SRAM_ERB_RSM_BASE	UL(0x2A5F0000)
#define NRD_CSS_MCP_SECURE_SRAM_ERB_RSM_SIZE	UL(0x00010000)

/* MCP SRAM NS Error Record Block - RSM */
#define NRD_CSS_MCP_NS_SRAM_ERB_RSM_BASE	UL(0x2A600000)
#define NRD_CSS_MCP_NS_SRAM_ERB_RSM_SIZE	UL(0x00010000)

/* CNTCTL Refclk Readframe */
#define NRD_CSS_CNTCTL_REFCLK_READFRAME_BASE	UL(0x2A800000)
#define NRD_CSS_CNTCTL_REFCLK_READFRAME_SIZE	UL(0x00020000)

/* CNTCTL base */
#define NRD_CSS_SYS_TIMCTL_BASE			UL(0x2A810000)

/* Secure Timer */
#define NRD_CSS_SECURE_TIMER_CTL_BASE		UL(0x2A820000)
#define NRD_CSS_SECURE_TIMER_CTL_SIZE		UL(0x00010000)

/* NS Timer */
#define NRD_CSS_NS_TIMER_CTL_BASE		UL(0x2A830000)
#define NRD_CSS_NS_TIMER_CTL_SIZE		UL(0x00010000)

/* AP - SCP NS MHU */
#define NRD_CSS_AP_SCP_NS_MHU_BASE		UL(0x2A900000)
#define NRD_CSS_AP_SCP_NS_MHU_SIZE		UL(0x00020000)

/* AP - SCP Secure MHU */
#define NRD_CSS_AP_SCP_SECURE_MHU_BASE		UL(0x2A920000)
#define NRD_CSS_AP_SCP_SECURE_MHU_SIZE		UL(0x00020000)

/* AP - SCP Root MHU */
#define NRD_CSS_AP_SCP_ROOT_MHU_BASE		UL(0x2A940000)
#define NRD_CSS_AP_SCP_ROOT_MHU_SIZE		UL(0x00020000)

/* AP - MCP NS MHU */
#define NRD_CSS_AP_MCP_NS_MHU_BASE		UL(0x2AA00000)
#define NRD_CSS_AP_MCP_NS_MHU_SIZE		UL(0x00020000)

/* AP - MCP Secure MHU */
#define NRD_CSS_AP_MCP_SECURE_MHU_BASE		UL(0x2AA20000)
#define NRD_CSS_AP_MCP_SECURE_MHU_SIZE		UL(0x00020000)

/* AP - MCP Root MHU */
#define NRD_CSS_AP_MCP_ROOT_MHU_BASE		UL(0x2AA40000)
#define NRD_CSS_AP_MCP_ROOT_MHU_SIZE		UL(0x00020000)

/* AP - RSE NS MHU */
#define NRD_CSS_AP_RSE_NS_MHU_BASE		UL(0x2AB00000)
#define NRD_CSS_AP_RSE_NS_MHU_SIZE		UL(0x00020000)

/* AP - RSE Secure MHU */
#define NRD_CSS_AP_RSE_SECURE_MHU_BASE		UL(0x2AB20000)
#define NRD_CSS_AP_RSE_SECURE_MHU_SIZE		UL(0x00020000)

/* AP - RSE Root MHU */
#define NRD_CSS_AP_RSE_ROOT_MHU_BASE		UL(0x2AB40000)
#define NRD_CSS_AP_RSE_ROOT_MHU_SIZE		UL(0x00020000)

/* AP - RSE Realm MHU */
#define NRD_CSS_AP_RSE_REALM_MHU_BASE		UL(0x2AB60000)
#define NRD_CSS_AP_RSE_REALM_MHU_SIZE		UL(0x00020000)

/* SCP - MCP - RSE Cross chip MHU */
#define NRD_CSS_SCP_MCP_RSE_CROSS_CHIP_MHU_BASE	UL(0x2AC00000)
#define NRD_CSS_SCP_MCP_RSE_CROSS_CHIP_MHU_SIZE	UL(0x00120000)

/* Synchronization Master Tupdate */
#define NRD_CSS_SYNCNT_MSTUPDTVAL_ADDR_BASE	UL(0x2B100000)
#define NRD_CSS_SYNCNT_MSTUPDTVAL_ADDR_SIZE	UL(0x00030000)

/* AP - RSE NS MHU */
#define NRD_CSS_STM_SYSTEM_ITS_BASE		UL(0x2CF00000)
#define NRD_CSS_STM_SYSTEM_ITS_SIZE		UL(0x02100000)

/* SCP - MCP - RSE Shared SRAM */
#define NRD_CSS_SCP_MCP_RSE_SHARED_SRAM_BASE	UL(0x2F000000)
#define NRD_CSS_SCP_MCP_RSE_SHARED_SRAM_SIZE	UL(0x00400000)

/* GIC base */
#define NRD_CSS_GIC_BASE			UL(0x30000000)
#define NRD_CSS_GIC_SIZE			UL(0x08000000)

/* CMN */
#define NRD_CSS_CMN_BASE			ULL(0x100000000)
#define NRD_CSS_CMN_SIZE			UL(0x40000000)

/* LCP Peripherals */
#define NRD_CSS_LCP_PERIPHERAL_BASE		ULL(0x200000000)
#define NRD_CSS_LCP_PERIPHERAL_SIZE		UL(0x40000000)

/* DDR IO */
#define NRD_CSS_DDR_IO_BASE			ULL(0x240000000)
#define NRD_CSS_DDR_IO_SIZE			UL(0x40000000)

/* SMMU & NCI IO */
#define NRD_CSS_SMMU_NCI_IO_BASE		ULL(0x280000000)
#define NRD_CSS_SMMU_NCI_IO_SIZE		UL(0x60000000)

/* GPC SMMU */
#define NRD_CSS_GPC_SMMUV3_BASE			UL(0x300000000)
#define NRD_CSS_GPC_SMMUV3_SIZE			UL(0x8000000)

/* DRAM1 */
#define NRD_CSS_DRAM1_BASE			UL(0x80000000)

/* DRAM2 */
#define NRD_CSS_DRAM2_BASE			ULL(0x8080000000)

/*******************************************************************************
 * MHUv3 related definitions
 ******************************************************************************/

#define MHU_V3_MBX_FRAME_OFFSET			UL(0x10000)

/* MHUv3 Postbox and Mailbox register frame base */
#define AP_RSE_ROOT_MHU_V3_PBX		NRD_CSS_AP_RSE_ROOT_MHU_BASE
#define AP_RSE_ROOT_MHU_V3_MBX		NRD_CSS_AP_RSE_ROOT_MHU_BASE + \
						MHU_V3_MBX_FRAME_OFFSET

#define AP_RSE_SECURE_MHU_V3_PBX	NRD_CSS_AP_RSE_SECURE_MHU_BASE
#define AP_RSE_SECURE_MHU_V3_MBX	NRD_CSS_AP_RSE_SECURE_MHU_BASE + \
						MHU_V3_MBX_FRAME_OFFSET

#endif /* NRD_CSS_DEF3_H */
