#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Suicide of Rachel Foster
# send your bug reports to contact@dotslashplay.it
###

script_version=20241219.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='the-suicide-of-rachel-foster'
GAME_NAME='The Suicide of Rachel Foster'

ARCHIVE_BASE_1_NAME='setup_the_suicide_of_rachel_foster_1.0.9v_(57374).exe'
ARCHIVE_BASE_1_MD5='7e4cc8210ab1deb630c4ab489aa8ebfb'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_the_suicide_of_rachel_foster_1.0.9v_(57374)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='96d1fdafd4826dda89693d559a78bf08'
ARCHIVE_BASE_1_PART2_NAME='setup_the_suicide_of_rachel_foster_1.0.9v_(57374)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='ee7554f1f0696841099997efe15dc8e2'
ARCHIVE_BASE_1_PART3_NAME='setup_the_suicide_of_rachel_foster_1.0.9v_(57374)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='295557d6e0d74b12e429441e23d3d995'
ARCHIVE_BASE_1_SIZE='8860163'
ARCHIVE_BASE_1_VERSION='1.0.9v-gog57374'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_suicide_of_rachel_foster'

ARCHIVE_BASE_0_NAME='setup_the_suicide_of_rachel_foster_1.0.3d_(36448).exe'
ARCHIVE_BASE_0_MD5='b351509e1845cdd6d99e7e252dc27815'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_suicide_of_rachel_foster_1.0.3d_(36448)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='f5cca9cdf87ec5bc32800b30cf7223e3'
ARCHIVE_BASE_0_PART2_NAME='setup_the_suicide_of_rachel_foster_1.0.3d_(36448)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='5ff56895c2de3bf2d973e89982d7a7c8'
ARCHIVE_BASE_0_PART3_NAME='setup_the_suicide_of_rachel_foster_1.0.3d_(36448)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='1f71e3117575dfe51758986882bc0e28'
ARCHIVE_BASE_0_SIZE='11000000'
ARCHIVE_BASE_0_VERSION='1.0.3d-gog36448'

UNREALENGINE4_NAME='tsorf'

CONTENT_PATH_DEFAULT='tsorf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Local Settings/Application Data/Daedalic Entertainment GmbH/The Suicide of Rachel Foster'

APP_MAIN_EXE='tsorf/binaries/win64/overlook-win64-shipping.exe'
## Override the default wrestool options string for Unreal Engine 4 games
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=123'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
